/* WindowStateSaver.c generated by valac 0.56.16, the Vala compiler
 * generated from WindowStateSaver.vala, do not modify */

/*
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <meta/window.h>
#include <sqlite3.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "gala.h"
#include <mtk/mtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_STATE_SAVER (gala_window_state_saver_get_type ())
#define GALA_WINDOW_STATE_SAVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_STATE_SAVER, GalaWindowStateSaver))
#define GALA_WINDOW_STATE_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_STATE_SAVER, GalaWindowStateSaverClass))
#define GALA_IS_WINDOW_STATE_SAVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_STATE_SAVER))
#define GALA_IS_WINDOW_STATE_SAVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_STATE_SAVER))
#define GALA_WINDOW_STATE_SAVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_STATE_SAVER, GalaWindowStateSaverClass))

typedef struct _GalaWindowStateSaver GalaWindowStateSaver;
typedef struct _GalaWindowStateSaverClass GalaWindowStateSaverClass;
typedef struct _GalaWindowStateSaverPrivate GalaWindowStateSaverPrivate;
enum  {
	GALA_WINDOW_STATE_SAVER_0_PROPERTY,
	GALA_WINDOW_STATE_SAVER_NUM_PROPERTIES
};
static GParamSpec* gala_window_state_saver_properties[GALA_WINDOW_STATE_SAVER_NUM_PROPERTIES];

#define GALA_TYPE_WINDOW_TRACKER (gala_window_tracker_get_type ())
#define GALA_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTracker))
#define GALA_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))
#define GALA_IS_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_TRACKER))
#define GALA_IS_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_TRACKER))
#define GALA_WINDOW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))

typedef struct _GalaWindowTracker GalaWindowTracker;
typedef struct _GalaWindowTrackerClass GalaWindowTrackerClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block35Data Block35Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaWindowStateSaver {
	GObject parent_instance;
	GalaWindowStateSaverPrivate * priv;
};

struct _GalaWindowStateSaverClass {
	GObjectClass parent_class;
};

struct _Block35Data {
	int _ref_count_;
	gchar* app_id;
	gboolean tracking_window;
	MetaWindow* window;
};

static gpointer gala_window_state_saver_parent_class = NULL;
static GalaWindowTracker* gala_window_state_saver_window_tracker;
static GalaWindowTracker* gala_window_state_saver_window_tracker = NULL;
static GHashTable* gala_window_state_saver_app_windows;
static GHashTable* gala_window_state_saver_app_windows = NULL;
static sqlite3* gala_window_state_saver_db;
static sqlite3* gala_window_state_saver_db = NULL;

VALA_EXTERN GType gala_window_state_saver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowStateSaver, g_object_unref)
VALA_EXTERN GType gala_window_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowTracker, g_object_unref)
VALA_EXTERN void gala_window_state_saver_init (GalaWindowTracker* window_tracker);
static void _g_free0_ (gpointer var);
static void _g_array_unref0_ (gpointer var);
VALA_EXTERN void gala_window_state_saver_on_map (MetaWindow* window);
static Block35Data* block35_data_ref (Block35Data* _data35_);
static void block35_data_unref (void * _userdata_);
VALA_EXTERN GalaApp* gala_window_tracker_get_app_for_window (GalaWindowTracker* self,
                                                 MetaWindow* window);
static void _g_object_unref0_ (gpointer var);
static void _vala_MetaWindow_free_function_content_of (gpointer data);
static gint gala_window_state_saver_find_window_index (MetaWindow* window,
                                                const gchar* app_id);
static gint __lambda129_ (Block35Data* _data35_,
                   gint n_columns,
                   gchar** values,
                   gchar** column_names);
static void gala_window_state_saver_track_window (MetaWindow* window,
                                           const gchar* app_id);
static gint ___lambda129__sqlite3_callback (gpointer self,
                                     gint n_columns,
                                     gchar** values,
                                     gchar** column_names);
static void gala_window_state_saver_on_window_unmanaging (MetaWindow* window);
static void _gala_window_state_saver_on_window_unmanaging_meta_window_unmanaging (MetaWindow* _sender,
                                                                           gpointer self);
VALA_EXTERN GalaWindowStateSaver* gala_window_state_saver_new (void);
VALA_EXTERN GalaWindowStateSaver* gala_window_state_saver_construct (GType object_type);
static void gala_window_state_saver_finalize (GObject * obj);
static GType gala_window_state_saver_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_array_unref (var), NULL));
}

static gint
_sqlite3_exec (sqlite3* self,
               const gchar* sql,
               sqlite3_callback callback,
               gpointer callback_target,
               gchar** errmsg)
{
	gchar* _vala_errmsg = NULL;
	const gchar* sqlite_errmsg = NULL;
	gint ec = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (sql != NULL, 0);
	_tmp1_ = sqlite3_exec (self, sql, callback, callback_target, (char**) (&_tmp0_));
	sqlite_errmsg = _tmp0_;
	ec = _tmp1_;
	if ((&_vala_errmsg) != NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = sqlite_errmsg;
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_errmsg);
		_vala_errmsg = _tmp3_;
	} else {
		_g_free0 (_vala_errmsg);
		_vala_errmsg = NULL;
	}
	_tmp4_ = sqlite_errmsg;
	sqlite3_free ((void*) _tmp4_);
	result = ec;
	if (errmsg) {
		*errmsg = _vala_errmsg;
	} else {
		_g_free0 (_vala_errmsg);
	}
	return result;
}

void
gala_window_state_saver_init (GalaWindowTracker* window_tracker)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* dir = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* path = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gint rc = 0;
	const gchar* _tmp8_;
	sqlite3* _tmp9_ = NULL;
	gint _tmp10_;
	sqlite3_stmt* stmt = NULL;
	sqlite3* _tmp13_;
	sqlite3_stmt* _tmp14_ = NULL;
	gint _tmp15_;
	sqlite3* _tmp20_;
	const gchar* _tmp21_;
	g_return_if_fail (window_tracker != NULL);
	gala_window_state_saver_window_tracker = window_tracker;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_array_unref0_);
	_g_hash_table_unref0 (gala_window_state_saver_app_windows);
	gala_window_state_saver_app_windows = _tmp2_;
	_tmp3_ = g_get_user_data_dir ();
	_tmp4_ = g_build_filename (_tmp3_, "io.elementary.gala", NULL);
	dir = _tmp4_;
	_tmp5_ = dir;
	mkdir (_tmp5_, (mode_t) 0775);
	_tmp6_ = dir;
	_tmp7_ = g_build_filename (_tmp6_, "windowstate.db", NULL);
	path = _tmp7_;
	_tmp8_ = path;
	_tmp10_ = sqlite3_open_v2 (_tmp8_, &_tmp9_, SQLITE_OPEN_READWRITE | SQLITE_OPEN_CREATE, NULL);
	_sqlite3_close0 (gala_window_state_saver_db);
	gala_window_state_saver_db = _tmp9_;
	rc = _tmp10_;
	if (rc != SQLITE_OK) {
		sqlite3* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = gala_window_state_saver_db;
		_tmp12_ = sqlite3_errmsg (_tmp11_);
		g_critical ("WindowStateSaver.vala:21: Cannot open database: %d, %s", rc, _tmp12_);
		_g_free0 (path);
		_g_free0 (dir);
		return;
	}
	_tmp13_ = gala_window_state_saver_db;
	_tmp15_ = sqlite3_prepare_v2 (_tmp13_, "\n" \
"            CREATE TABLE IF NOT EXISTS apps (\n" \
"                app_id       TEXT,\n" \
"                window_index INTEGER,\n" \
"                last_x       INTEGER,\n" \
"                last_y       INTEGER,\n" \
"                last_width   INTEGER,\n" \
"                last_height  INTEGER,\n" \
"                PRIMARY KEY (app_id, window_index)\n" \
"            );\n" \
"            ", -1, &_tmp14_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp14_;
	rc = _tmp15_;
	if (rc == SQLITE_OK) {
		sqlite3_stmt* _tmp16_;
		_tmp16_ = stmt;
		rc = sqlite3_step (_tmp16_);
		if (rc == SQLITE_DONE) {
			sqlite3* _tmp17_;
			_tmp17_ = gala_window_state_saver_db;
			rc = _sqlite3_exec (_tmp17_, "PRAGMA synchronous=OFF", NULL, NULL, NULL);
			if (rc != SQLITE_OK) {
				sqlite3* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = gala_window_state_saver_db;
				_tmp19_ = sqlite3_errmsg (_tmp18_);
				g_warning ("WindowStateSaver.vala:47: Unable to disable synchronous mode %d, %s", rc, _tmp19_);
			}
			_sqlite3_finalize0 (stmt);
			_g_free0 (path);
			_g_free0 (dir);
			return;
		}
	}
	_tmp20_ = gala_window_state_saver_db;
	_tmp21_ = sqlite3_errmsg (_tmp20_);
	g_critical ("WindowStateSaver.vala:54: Cannot create table 'apps': %d, %s", rc, _tmp21_);
	_sqlite3_finalize0 (stmt);
	_g_free0 (path);
	_g_free0 (dir);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block35Data*
block35_data_ref (Block35Data* _data35_)
{
	g_atomic_int_inc (&_data35_->_ref_count_);
	return _data35_;
}

static void
block35_data_unref (void * _userdata_)
{
	Block35Data* _data35_;
	_data35_ = (Block35Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data35_->_ref_count_)) {
		_g_free0 (_data35_->app_id);
		_g_object_unref0 (_data35_->window);
		g_slice_free (Block35Data, _data35_);
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_MetaWindow_free_function_content_of (gpointer data)
{
	MetaWindow* self;
	self = *((MetaWindow**) data);
	_g_object_unref0_ (self);
}

static gint
__lambda129_ (Block35Data* _data35_,
              gint n_columns,
              gchar** values,
              gchar** column_names)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint result;
	_tmp0_ = values[0];
	_tmp1_ = values[1];
	_tmp2_ = values[2];
	_tmp3_ = values[3];
	meta_window_move_resize_frame (_data35_->window, FALSE, atoi (_tmp0_), atoi (_tmp1_), atoi (_tmp2_), atoi (_tmp3_));
	_tmp4_ = _data35_->app_id;
	gala_window_state_saver_track_window (_data35_->window, _tmp4_);
	_data35_->tracking_window = TRUE;
	result = 0;
	return result;
}

static gint
___lambda129__sqlite3_callback (gpointer self,
                                gint n_columns,
                                gchar** values,
                                gchar** column_names)
{
	gint result;
	result = __lambda129_ (self, n_columns, values, column_names);
	return result;
}

void
gala_window_state_saver_on_map (MetaWindow* window)
{
	Block35Data* _data35_;
	MetaWindow* _tmp0_;
	GalaWindowTracker* _tmp1_;
	GalaApp* _tmp2_;
	GalaApp* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	MetaWindowType _tmp9_;
	MetaWindowType _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gint window_index = 0;
	const gchar* _tmp17_;
	GHashTable* _tmp18_;
	const gchar* _tmp19_;
	gconstpointer _tmp20_;
	MetaWindow* _tmp21_;
	sqlite3* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	MtkRectangle frame_rect = {0};
	MtkRectangle _tmp26_ = {0};
	sqlite3_stmt* stmt = NULL;
	gint rc = 0;
	sqlite3* _tmp27_;
	const gchar* _tmp28_;
	MtkRectangle _tmp29_;
	MtkRectangle _tmp30_;
	MtkRectangle _tmp31_;
	MtkRectangle _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	sqlite3_stmt* _tmp35_ = NULL;
	gint _tmp36_;
	gint _tmp37_;
	sqlite3* _tmp40_;
	const gchar* _tmp41_;
	g_return_if_fail (window != NULL);
	_data35_ = g_slice_new0 (Block35Data);
	_data35_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data35_->window);
	_data35_->window = _tmp0_;
	_tmp1_ = gala_window_state_saver_window_tracker;
	_tmp2_ = gala_window_tracker_get_app_for_window (_tmp1_, _data35_->window);
	_tmp3_ = _tmp2_;
	_tmp4_ = gala_app_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_markup_escape_text (_tmp5_, (gssize) -1);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp3_);
	_data35_->app_id = _tmp7_;
	_tmp8_ = _data35_->app_id;
	if (g_str_has_prefix (_tmp8_, "window:")) {
		block35_data_unref (_data35_);
		_data35_ = NULL;
		return;
	}
	_tmp9_ = meta_window_get_window_type (_data35_->window);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != META_WINDOW_NORMAL) {
		block35_data_unref (_data35_);
		_data35_ = NULL;
		return;
	}
	_tmp11_ = gala_window_state_saver_app_windows;
	_tmp12_ = _data35_->app_id;
	if (!g_hash_table_contains (_tmp11_, _tmp12_)) {
		GHashTable* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		GArray* _tmp16_;
		_tmp13_ = gala_window_state_saver_app_windows;
		_tmp14_ = _data35_->app_id;
		_tmp15_ = g_strdup (_tmp14_);
		_tmp16_ = g_array_new (TRUE, TRUE, sizeof (MetaWindow*));
		g_array_set_clear_func (_tmp16_, (GDestroyNotify) _vala_MetaWindow_free_function_content_of);
		g_hash_table_insert (_tmp13_, _tmp15_, _tmp16_);
	}
	_tmp17_ = _data35_->app_id;
	window_index = gala_window_state_saver_find_window_index (_data35_->window, _tmp17_);
	_tmp18_ = gala_window_state_saver_app_windows;
	_tmp19_ = _data35_->app_id;
	_tmp20_ = g_hash_table_lookup (_tmp18_, _tmp19_);
	_tmp21_ = _g_object_ref0 (_data35_->window);
	g_array_insert_val ((GArray*) _tmp20_, (guint) window_index, _tmp21_);
	_data35_->tracking_window = FALSE;
	_tmp22_ = gala_window_state_saver_db;
	_tmp23_ = _data35_->app_id;
	_tmp24_ = g_strdup_printf ("SELECT last_x, last_y, last_width, last_height FROM apps WHERE app_id " \
"= '%s' AND window_index = '%d';", _tmp23_, window_index);
	_tmp25_ = _tmp24_;
	_sqlite3_exec (_tmp22_, _tmp25_, ___lambda129__sqlite3_callback, _data35_, NULL);
	_g_free0 (_tmp25_);
	if (_data35_->tracking_window) {
		block35_data_unref (_data35_);
		_data35_ = NULL;
		return;
	}
	meta_window_get_frame_rect (_data35_->window, &_tmp26_);
	frame_rect = _tmp26_;
	_tmp27_ = gala_window_state_saver_db;
	_tmp28_ = _data35_->app_id;
	_tmp29_ = frame_rect;
	_tmp30_ = frame_rect;
	_tmp31_ = frame_rect;
	_tmp32_ = frame_rect;
	_tmp33_ = g_strdup_printf ("INSERT INTO apps (app_id, window_index, last_x, last_y, last_width, la" \
"st_height) VALUES ('%s', '%d', '%d', '%d', '%d', '%d');", _tmp28_, window_index, _tmp29_.x, _tmp30_.y, _tmp31_.width, _tmp32_.height);
	_tmp34_ = _tmp33_;
	_tmp36_ = sqlite3_prepare_v2 (_tmp27_, _tmp34_, -1, &_tmp35_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp35_;
	_tmp37_ = _tmp36_;
	_g_free0 (_tmp34_);
	rc = _tmp37_;
	if (rc == SQLITE_OK) {
		sqlite3_stmt* _tmp38_;
		_tmp38_ = stmt;
		rc = sqlite3_step (_tmp38_);
		if (rc == SQLITE_DONE) {
			const gchar* _tmp39_;
			_tmp39_ = _data35_->app_id;
			gala_window_state_saver_track_window (_data35_->window, _tmp39_);
			_sqlite3_finalize0 (stmt);
			block35_data_unref (_data35_);
			_data35_ = NULL;
			return;
		}
	}
	_tmp40_ = gala_window_state_saver_db;
	_tmp41_ = sqlite3_errmsg (_tmp40_);
	g_critical ("WindowStateSaver.vala:110: Cannot insert app information into database" \
": %d, %s", rc, _tmp41_);
	_sqlite3_finalize0 (stmt);
	block35_data_unref (_data35_);
	_data35_ = NULL;
}

static void
_gala_window_state_saver_on_window_unmanaging_meta_window_unmanaging (MetaWindow* _sender,
                                                                      gpointer self)
{
	gala_window_state_saver_on_window_unmanaging (_sender);
}

static void
gala_window_state_saver_track_window (MetaWindow* window,
                                      const gchar* app_id)
{
	g_return_if_fail (window != NULL);
	g_return_if_fail (app_id != NULL);
	g_signal_connect (window, "unmanaging", (GCallback) _gala_window_state_saver_on_window_unmanaging_meta_window_unmanaging, NULL);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

static void
gala_window_state_saver_on_window_unmanaging (MetaWindow* window)
{
	gchar* app_id = NULL;
	GalaWindowTracker* _tmp0_;
	GalaApp* _tmp1_;
	GalaApp* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gint window_index = 0;
	const gchar* _tmp7_;
	GHashTable* _tmp8_;
	const gchar* _tmp9_;
	gconstpointer _tmp10_;
	MetaWindow* _tmp11_;
	MetaWindow* _tmp12_;
	gpointer value = NULL;
	GHashTable* _tmp13_;
	const gchar* _tmp14_;
	gconstpointer _tmp15_;
	gpointer _tmp16_;
	MtkRectangle frame_rect = {0};
	MtkRectangle _tmp17_ = {0};
	sqlite3_stmt* stmt = NULL;
	gint rc = 0;
	sqlite3* _tmp18_;
	MtkRectangle _tmp19_;
	MtkRectangle _tmp20_;
	MtkRectangle _tmp21_;
	MtkRectangle _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	sqlite3_stmt* _tmp26_ = NULL;
	gint _tmp27_;
	gint _tmp28_;
	sqlite3* _tmp30_;
	const gchar* _tmp31_;
	g_return_if_fail (window != NULL);
	_tmp0_ = gala_window_state_saver_window_tracker;
	_tmp1_ = gala_window_tracker_get_app_for_window (_tmp0_, window);
	_tmp2_ = _tmp1_;
	_tmp3_ = gala_app_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_markup_escape_text (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	app_id = _tmp6_;
	_tmp7_ = app_id;
	window_index = gala_window_state_saver_find_window_index (window, _tmp7_);
	_tmp8_ = gala_window_state_saver_app_windows;
	_tmp9_ = app_id;
	_tmp10_ = g_hash_table_lookup (_tmp8_, _tmp9_);
	_tmp11_ = vala_g_array_remove_index ((GArray*) _tmp10_, (guint) window_index);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp12_);
	value = NULL;
	_tmp13_ = gala_window_state_saver_app_windows;
	_tmp14_ = app_id;
	_tmp15_ = g_hash_table_lookup (_tmp13_, _tmp14_);
	_tmp16_ = value;
	g_array_insert_val ((GArray*) _tmp15_, (guint) window_index, _tmp16_);
	meta_window_get_frame_rect (window, &_tmp17_);
	frame_rect = _tmp17_;
	_tmp18_ = gala_window_state_saver_db;
	_tmp19_ = frame_rect;
	_tmp20_ = frame_rect;
	_tmp21_ = frame_rect;
	_tmp22_ = frame_rect;
	_tmp23_ = app_id;
	_tmp24_ = g_strdup_printf ("UPDATE apps SET last_x = '%d', last_y = '%d', last_width = '%d', last_" \
"height = '%d' WHERE app_id = '%s' AND window_index = '%d';", _tmp19_.x, _tmp20_.y, _tmp21_.width, _tmp22_.height, _tmp23_, window_index);
	_tmp25_ = _tmp24_;
	_tmp27_ = sqlite3_prepare_v2 (_tmp18_, _tmp25_, -1, &_tmp26_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp26_;
	_tmp28_ = _tmp27_;
	_g_free0 (_tmp25_);
	rc = _tmp28_;
	if (rc == SQLITE_OK) {
		sqlite3_stmt* _tmp29_;
		_tmp29_ = stmt;
		rc = sqlite3_step (_tmp29_);
		if (rc == SQLITE_DONE) {
			_sqlite3_finalize0 (stmt);
			_g_free0 (app_id);
			return;
		}
	}
	_tmp30_ = gala_window_state_saver_db;
	_tmp31_ = sqlite3_errmsg (_tmp30_);
	g_critical ("WindowStateSaver.vala:141: Cannot update app position in database: %d," \
" %s", rc, _tmp31_);
	_sqlite3_finalize0 (stmt);
	_g_free0 (app_id);
}

static gint
gala_window_state_saver_find_window_index (MetaWindow* window,
                                           const gchar* app_id)
{
	GHashTable* _tmp0_;
	GArray* windows_list = NULL;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	gint first_null = 0;
	GArray* _tmp13_;
	gint result;
	g_return_val_if_fail (window != NULL, 0);
	g_return_val_if_fail (app_id != NULL, 0);
	_tmp0_ = gala_window_state_saver_app_windows;
	_vala_return_val_if_fail (g_hash_table_contains (_tmp0_, app_id), "app_id in app_windows", 0);
	_tmp1_ = gala_window_state_saver_app_windows;
	_tmp2_ = g_hash_table_lookup (_tmp1_, app_id);
	windows_list = (GArray*) _tmp2_;
	first_null = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GArray* _tmp5_;
				MetaWindow* w = NULL;
				GArray* _tmp6_;
				gpointer* _tmp7_;
				gint _tmp7__length1;
				MetaWindow* _tmp8_;
				MetaWindow* _tmp9_;
				MetaWindow* _tmp10_;
				gboolean _tmp11_ = FALSE;
				MetaWindow* _tmp12_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = windows_list;
				if (!(((guint) i) < _tmp5_->len)) {
					break;
				}
				_tmp6_ = windows_list;
				_tmp7_ = _tmp6_->data;
				_tmp7__length1 = _tmp6_->len;
				_tmp8_ = _tmp7_[i];
				_tmp9_ = _g_object_ref0 (_tmp8_);
				w = _tmp9_;
				_tmp10_ = w;
				if (_tmp10_ == window) {
					result = i;
					_g_object_unref0 (w);
					return result;
				}
				_tmp12_ = w;
				if (_tmp12_ == NULL) {
					_tmp11_ = first_null == -1;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					first_null = i;
				}
				_g_object_unref0 (w);
			}
		}
	}
	if (first_null != -1) {
		result = first_null;
		return result;
	}
	_tmp13_ = windows_list;
	result = (gint) _tmp13_->len;
	return result;
}

GalaWindowStateSaver*
gala_window_state_saver_construct (GType object_type)
{
	GalaWindowStateSaver * self = NULL;
	self = (GalaWindowStateSaver*) g_object_new (object_type, NULL);
	return self;
}

GalaWindowStateSaver*
gala_window_state_saver_new (void)
{
	return gala_window_state_saver_construct (GALA_TYPE_WINDOW_STATE_SAVER);
}

static void
gala_window_state_saver_class_init (GalaWindowStateSaverClass * klass,
                                    gpointer klass_data)
{
	gala_window_state_saver_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = gala_window_state_saver_finalize;
}

static void
gala_window_state_saver_instance_init (GalaWindowStateSaver * self,
                                       gpointer klass)
{
}

static void
gala_window_state_saver_finalize (GObject * obj)
{
	GalaWindowStateSaver * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_STATE_SAVER, GalaWindowStateSaver);
	G_OBJECT_CLASS (gala_window_state_saver_parent_class)->finalize (obj);
}

static GType
gala_window_state_saver_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowStateSaverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_state_saver_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowStateSaver), 0, (GInstanceInitFunc) gala_window_state_saver_instance_init, NULL };
	GType gala_window_state_saver_type_id;
	gala_window_state_saver_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaWindowStateSaver", &g_define_type_info, 0);
	return gala_window_state_saver_type_id;
}

GType
gala_window_state_saver_get_type (void)
{
	static volatile gsize gala_window_state_saver_type_id__once = 0;
	if (g_once_init_enter (&gala_window_state_saver_type_id__once)) {
		GType gala_window_state_saver_type_id;
		gala_window_state_saver_type_id = gala_window_state_saver_get_type_once ();
		g_once_init_leave (&gala_window_state_saver_type_id__once, gala_window_state_saver_type_id);
	}
	return gala_window_state_saver_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

