/* WorkspaceClone.c generated by valac 0.56.16, the Vala compiler
 * generated from WorkspaceClone.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <meta/meta-background-group.h>
#include "gala.h"
#include <glib-object.h>
#include <cogl/cogl.h>
#include <cairo-gobject.h>
#include <glib.h>
#include <clutter/clutter.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <mtk/mtk.h>
#include <meta/workspace.h>
#include <meta/window.h>
#include <meta/meta-workspace-manager.h>

#define GALA_WORKSPACE_CLONE_BOTTOM_OFFSET 100
#define GALA_WORKSPACE_CLONE_TOP_OFFSET 20
#define GALA_WORKSPACE_CLONE_HOVER_ACTIVATE_DELAY 400
#define GALA_WORKSPACE_CLONE_X_OFFSET 150
#define GALA_WINDOW_MANAGER_GALA_WORKSPACE_GAP 24
#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
typedef struct _GalaBackgroundManagerPrivate GalaBackgroundManagerPrivate;

#define GALA_TYPE_FRAMED_BACKGROUND (gala_framed_background_get_type ())
#define GALA_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground))
#define GALA_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))
#define GALA_IS_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_IS_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_FRAMED_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))

typedef struct _GalaFramedBackground GalaFramedBackground;
typedef struct _GalaFramedBackgroundClass GalaFramedBackgroundClass;
typedef struct _GalaFramedBackgroundPrivate GalaFramedBackgroundPrivate;
enum  {
	GALA_FRAMED_BACKGROUND_0_PROPERTY,
	GALA_FRAMED_BACKGROUND_NUM_PROPERTIES
};
static GParamSpec* gala_framed_background_properties[GALA_FRAMED_BACKGROUND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;
typedef struct _GalaWorkspaceClonePrivate GalaWorkspaceClonePrivate;

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
enum  {
	GALA_WORKSPACE_CLONE_0_PROPERTY,
	GALA_WORKSPACE_CLONE_WM_PROPERTY,
	GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY,
	GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY,
	GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY,
	GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY,
	GALA_WORKSPACE_CLONE_SCALE_FACTOR_PROPERTY,
	GALA_WORKSPACE_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_NUM_PROPERTIES];

#define GALA_TYPE_WINDOW_LISTENER (gala_window_listener_get_type ())
#define GALA_WINDOW_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_LISTENER, GalaWindowListener))
#define GALA_WINDOW_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_LISTENER, GalaWindowListenerClass))
#define GALA_IS_WINDOW_LISTENER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_LISTENER))
#define GALA_IS_WINDOW_LISTENER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_LISTENER))
#define GALA_WINDOW_LISTENER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_LISTENER, GalaWindowListenerClass))

typedef struct _GalaWindowListener GalaWindowListener;
typedef struct _GalaWindowListenerClass GalaWindowListenerClass;

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
typedef struct _Block73Data Block73Data;
typedef void (*GalaGestureTrackerOnBegin) (gdouble percentage, gpointer user_data);
typedef void (*GalaGestureTrackerOnUpdate) (gdouble percentage, gpointer user_data);
typedef void (*GalaGestureTrackerOnEnd) (gdouble percentage, gboolean cancel_action, gint calculated_duration, gpointer user_data);
typedef struct _Block74Data Block74Data;
enum  {
	GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL,
	GALA_WORKSPACE_CLONE_SELECTED_SIGNAL,
	GALA_WORKSPACE_CLONE_NUM_SIGNALS
};
static guint gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_NUM_SIGNALS] = {0};

struct _GalaBackgroundManager {
	MetaBackgroundGroup parent_instance;
	GalaBackgroundManagerPrivate * priv;
};

struct _GalaBackgroundManagerClass {
	MetaBackgroundGroupClass parent_class;
};

struct _GalaFramedBackground {
	GalaBackgroundManager parent_instance;
	GalaFramedBackgroundPrivate * priv;
};

struct _GalaFramedBackgroundClass {
	GalaBackgroundManagerClass parent_class;
};

struct _GalaFramedBackgroundPrivate {
	CoglPipeline* pipeline;
	cairo_surface_t* cached_surface;
	cairo_t* cached_context;
	CoglTexture2D* cached_texture;
	gint last_width;
	gint last_height;
};

struct _GalaWorkspaceClone {
	ClutterActor parent_instance;
	GalaWorkspaceClonePrivate * priv;
};

struct _GalaWorkspaceCloneClass {
	ClutterActorClass parent_class;
};

struct _GalaWorkspaceClonePrivate {
	GalaWindowManager* _wm;
	MetaWorkspace* _workspace;
	GalaGestureTracker* _gesture_tracker;
	GalaIconGroup* _icon_group;
	GalaWindowCloneContainer* _window_container;
	gfloat _scale_factor;
	GalaBackgroundManager* background;
	gboolean opened;
	guint hover_activate_timeout;
};

struct _Block73Data {
	int _ref_count_;
	GalaWorkspaceClone* self;
	gfloat initial_x;
	gfloat target_x;
	gfloat scale;
	gfloat pivot_y;
};

struct _Block74Data {
	int _ref_count_;
	GalaWorkspaceClone* self;
	gfloat initial_x;
	gfloat target_x;
	gdouble initial_scale_x;
	gdouble initial_scale_y;
};

static gint GalaFramedBackground_private_offset;
static gpointer gala_framed_background_parent_class = NULL;
static gint GalaWorkspaceClone_private_offset;
static gpointer gala_workspace_clone_parent_class = NULL;

VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
 G_GNUC_INTERNAL GType gala_framed_background_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFramedBackground, g_object_unref)
 G_GNUC_INTERNAL GalaFramedBackground* gala_framed_background_new (GalaWindowManager* wm);
 G_GNUC_INTERNAL GalaFramedBackground* gala_framed_background_construct (GType object_type,
                                                        GalaWindowManager* wm);
static void gala_framed_background_real_paint (ClutterActor* base,
                                        ClutterPaintContext* context);
static GObject * gala_framed_background_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN GalaWindowManager* gala_background_manager_get_wm (GalaBackgroundManager* self);
static void gala_framed_background_finalize (GObject * obj);
static GType gala_framed_background_get_type_once (void);
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
static void gala_workspace_clone_window_entered_monitor (GalaWorkspaceClone* self,
                                                  MetaDisplay* display,
                                                  gint monitor,
                                                  MetaWindow* window);
static void _gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                       gint object,
                                                                                       MetaWindow* p0,
                                                                                       gpointer self);
static void gala_workspace_clone_window_left_monitor (GalaWorkspaceClone* self,
                                               MetaDisplay* display,
                                               gint monitor,
                                               MetaWindow* window);
static void _gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                                 gint object,
                                                                                 MetaWindow* p0,
                                                                                 gpointer self);
static void gala_workspace_clone_add_window (GalaWorkspaceClone* self,
                                      MetaWindow* window);
static void _gala_workspace_clone_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self);
static void gala_workspace_clone_remove_window (GalaWorkspaceClone* self,
                                         MetaWindow* window);
static void _gala_workspace_clone_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                        MetaWindow* object,
                                                                        gpointer self);
VALA_EXTERN GType gala_window_listener_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowListener, g_object_unref)
VALA_EXTERN GalaWindowListener* gala_window_listener_get_default (void);
static void _gala_workspace_clone_add_window_gala_window_listener_window_no_longer_on_all_workspaces (GalaWindowListener* _sender,
                                                                                               MetaWindow* window,
                                                                                               gpointer self);
VALA_EXTERN GalaWindowCloneContainer* gala_workspace_clone_get_window_container (GalaWorkspaceClone* self);
VALA_EXTERN GalaIconGroup* gala_workspace_clone_get_icon_group (GalaWorkspaceClone* self);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_new (GalaWindowManager* wm,
                                              MetaWorkspace* workspace,
                                              GalaGestureTracker* gesture_tracker,
                                              gfloat scale);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_construct (GType object_type,
                                                    GalaWindowManager* wm,
                                                    MetaWorkspace* workspace,
                                                    GalaGestureTracker* gesture_tracker,
                                                    gfloat scale);
static void gala_workspace_clone_reallocate (GalaWorkspaceClone* self);
VALA_EXTERN gfloat gala_workspace_clone_get_scale_factor (GalaWorkspaceClone* self);
VALA_EXTERN void gala_icon_group_set_scale_factor (GalaIconGroup* self,
                                       gfloat value);
VALA_EXTERN void gala_window_clone_container_set_monitor_scale (GalaWindowCloneContainer* self,
                                                    gfloat value);
VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
VALA_EXTERN void gala_icon_group_add_window (GalaIconGroup* self,
                                 MetaWindow* window,
                                 gboolean no_redraw,
                                 gboolean temporary);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
VALA_EXTERN void gala_icon_group_remove_window (GalaIconGroup* self,
                                    MetaWindow* window,
                                    gboolean animate);
VALA_EXTERN void gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                       MtkRectangle* monitor_geometry);
VALA_EXTERN void gala_background_manager_set_size (GalaBackgroundManager* self,
                                       gfloat width,
                                       gfloat height);
VALA_EXTERN gfloat gala_workspace_clone_multitasking_view_x (GalaWorkspaceClone* self);
VALA_EXTERN gint gala_internal_utils_scale_to_int (gint value,
                                       gfloat scale_factor);
static gfloat gala_workspace_clone_current_x_overlap (GalaWorkspaceClone* self);
static inline void gala_workspace_clone_shrink_rectangle (MtkRectangle* rect,
                                            gint amount);
VALA_EXTERN void gala_workspace_clone_open (GalaWorkspaceClone* self,
                                gboolean with_gesture,
                                gboolean is_cancel_animation);
static Block73Data* block73_data_ref (Block73Data* _data73_);
static void block73_data_unref (void * _userdata_);
VALA_EXTERN void gala_window_clone_container_restack_windows (GalaWindowCloneContainer* self);
static void __lambda53_ (Block73Data* _data73_);
static void ___lambda53__gala_gesture_tracker_on_begin (gdouble percentage,
                                                 gpointer self);
static void __lambda54_ (Block73Data* _data73_,
                  gdouble percentage);
VALA_EXTERN gfloat gala_gesture_tracker_animation_value (gfloat initial_value,
                                             gfloat target_value,
                                             gdouble percentage,
                                             gboolean rounded);
static void ___lambda54__gala_gesture_tracker_on_update (gdouble percentage,
                                                  gpointer self);
static void __lambda55_ (Block73Data* _data73_,
                  gdouble percentage,
                  gboolean cancel_action);
VALA_EXTERN GalaWindowManager* gala_workspace_clone_get_wm (GalaWorkspaceClone* self);
static void ___lambda55__gala_gesture_tracker_on_end (gdouble percentage,
                                               gboolean cancel_action,
                                               gint calculated_duration,
                                               gpointer self);
VALA_EXTERN GalaGestureTracker* gala_workspace_clone_get_gesture_tracker (GalaWorkspaceClone* self);
VALA_EXTERN void gala_gesture_tracker_connect_handlers (GalaGestureTracker* self,
                                            GalaGestureTrackerOnBegin on_begin_handler,
                                            gpointer on_begin_handler_target,
                                            GDestroyNotify on_begin_handler_target_destroy_notify,
                                            GalaGestureTrackerOnUpdate on_update_handler,
                                            gpointer on_update_handler_target,
                                            GDestroyNotify on_update_handler_target_destroy_notify,
                                            GalaGestureTrackerOnEnd on_end_handler,
                                            gpointer on_end_handler_target,
                                            GDestroyNotify on_end_handler_target_destroy_notify);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
VALA_EXTERN void gala_icon_group_redraw (GalaIconGroup* self);
VALA_EXTERN void gala_window_clone_container_open (GalaWindowCloneContainer* self,
                                       MetaWindow* selected_window,
                                       gboolean with_gesture,
                                       gboolean is_cancel_animation);
VALA_EXTERN void gala_workspace_clone_close (GalaWorkspaceClone* self,
                                 gboolean with_gesture,
                                 gboolean is_cancel_animation);
static Block74Data* block74_data_ref (Block74Data* _data74_);
static void block74_data_unref (void * _userdata_);
static void __lambda56_ (Block74Data* _data74_,
                  gdouble percentage);
static void ___lambda56__gala_gesture_tracker_on_update (gdouble percentage,
                                                  gpointer self);
static void __lambda57_ (Block74Data* _data74_,
                  gdouble percentage,
                  gboolean cancel_action);
static void ___lambda57__gala_gesture_tracker_on_end (gdouble percentage,
                                               gboolean cancel_action,
                                               gint calculated_duration,
                                               gpointer self);
VALA_EXTERN void gala_window_clone_container_close (GalaWindowCloneContainer* self,
                                        gboolean with_gesture,
                                        gboolean is_cancel_animation);
static void gala_workspace_clone_set_wm (GalaWorkspaceClone* self,
                                  GalaWindowManager* value);
static void gala_workspace_clone_set_workspace (GalaWorkspaceClone* self,
                                         MetaWorkspace* value);
static void gala_workspace_clone_set_gesture_tracker (GalaWorkspaceClone* self,
                                               GalaGestureTracker* value);
static void gala_workspace_clone_set_icon_group (GalaWorkspaceClone* self,
                                          GalaIconGroup* value);
static void gala_workspace_clone_set_window_container (GalaWorkspaceClone* self,
                                                GalaWindowCloneContainer* value);
VALA_EXTERN void gala_workspace_clone_set_scale_factor (GalaWorkspaceClone* self,
                                            gfloat value);
static GObject * gala_workspace_clone_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _gala_workspace_clone___lambda58_ (GalaWorkspaceClone* self);
static void __gala_workspace_clone___lambda58__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                      ClutterActor* actor,
                                                                      gpointer self);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           GalaGestureTracker* gesture_tracker,
                                                           gfloat scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 GalaGestureTracker* gesture_tracker,
                                                                 gfloat scale,
                                                                 gboolean overview_mode);
static void _gala_workspace_clone___lambda59_ (GalaWorkspaceClone* self,
                                        MetaWindow* w);
static void __gala_workspace_clone___lambda59__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                     MetaWindow* window,
                                                                                     gpointer self);
static void _gala_workspace_clone___lambda60_ (GalaWorkspaceClone* self);
static void __gala_workspace_clone___lambda60__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                                                     gpointer self);
VALA_EXTERN GalaIconGroup* gala_icon_group_new (GalaWindowManager* wm,
                                    MetaWorkspace* workspace,
                                    gfloat scale);
VALA_EXTERN GalaIconGroup* gala_icon_group_construct (GType object_type,
                                          GalaWindowManager* wm,
                                          MetaWorkspace* workspace,
                                          gfloat scale);
static void _gala_workspace_clone___lambda61_ (GalaWorkspaceClone* self);
static void __gala_workspace_clone___lambda61__gala_icon_group_selected (GalaIconGroup* _sender,
                                                                  gpointer self);
static void _gala_workspace_clone___lambda62_ (GalaWorkspaceClone* self,
                                        ClutterActor* target,
                                        gboolean hovered);
static gboolean ___lambda63_ (GalaWorkspaceClone* self);
static gboolean ____lambda63__gsource_func (gpointer self);
static void __gala_workspace_clone___lambda62__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                                                       ClutterActor* target,
                                                                       gboolean hovered,
                                                                       gpointer self);
static void gala_workspace_clone_finalize (GObject * obj);
static GType gala_workspace_clone_get_type_once (void);
static void _vala_gala_workspace_clone_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_workspace_clone_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_framed_background_get_instance_private (GalaFramedBackground* self)
{
	return G_STRUCT_MEMBER_P (self, GalaFramedBackground_private_offset);
}

 G_GNUC_INTERNAL GalaFramedBackground*
gala_framed_background_construct (GType object_type,
                                  GalaWindowManager* wm)
{
	GalaFramedBackground * self = NULL;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (wm != NULL, NULL);
	_tmp0_ = meta_plugin_get_display ((MetaPlugin*) wm);
	self = (GalaFramedBackground*) g_object_new (object_type, "wm", wm, "monitor-index", meta_display_get_primary_monitor (_tmp0_), "control-position", FALSE, NULL);
	return self;
}

 G_GNUC_INTERNAL GalaFramedBackground*
gala_framed_background_new (GalaWindowManager* wm)
{
	return gala_framed_background_construct (GALA_TYPE_FRAMED_BACKGROUND, wm);
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_framed_background_real_paint (ClutterActor* base,
                                   ClutterPaintContext* context)
{
	GalaFramedBackground * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	cairo_t* ctx = NULL;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	gfloat _tmp24_;
	gfloat _tmp25_;
	gfloat _tmp26_;
	gfloat _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	cairo_t* _tmp30_;
	cairo_t* _tmp31_;
	CoglColor color = {0};
	CoglPipeline* _tmp49_;
	CoglColor _tmp50_;
	CoglFramebuffer* fb = NULL;
	CoglFramebuffer* _tmp51_;
	CoglPipeline* _tmp52_;
	gfloat _tmp53_;
	gfloat _tmp54_;
	gfloat _tmp55_;
	gfloat _tmp56_;
	GError* _inner_error0_ = NULL;
	self = (GalaFramedBackground*) base;
	g_return_if_fail (context != NULL);
	CLUTTER_ACTOR_CLASS (gala_framed_background_parent_class)->paint ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager), context);
	_tmp2_ = self->priv->cached_surface;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		gfloat _tmp3_;
		gfloat _tmp4_;
		_tmp3_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp4_ = _tmp3_;
		_tmp1_ = self->priv->last_width != ((gint) _tmp4_);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gfloat _tmp5_;
		gfloat _tmp6_;
		_tmp5_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp6_ = _tmp5_;
		_tmp0_ = self->priv->last_height != ((gint) _tmp6_);
	}
	if (_tmp0_) {
		gfloat _tmp7_;
		gfloat _tmp8_;
		gfloat _tmp9_;
		gfloat _tmp10_;
		cairo_surface_t* _tmp11_;
		cairo_surface_t* _tmp12_;
		cairo_t* _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		gfloat _tmp16_;
		gfloat _tmp17_;
		_g_object_unref0 (self->priv->cached_texture);
		self->priv->cached_texture = NULL;
		_tmp7_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) _tmp8_, (gint) _tmp10_);
		_cairo_surface_destroy0 (self->priv->cached_surface);
		self->priv->cached_surface = _tmp11_;
		_tmp12_ = self->priv->cached_surface;
		_tmp13_ = cairo_create (_tmp12_);
		_cairo_destroy0 (self->priv->cached_context);
		self->priv->cached_context = _tmp13_;
		_tmp14_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp15_ = _tmp14_;
		self->priv->last_width = (gint) _tmp15_;
		_tmp16_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp17_ = _tmp16_;
		self->priv->last_height = (gint) _tmp17_;
	}
	_tmp18_ = self->priv->cached_surface;
	_tmp19_ = _cairo_surface_reference0 (_tmp18_);
	surface = _tmp19_;
	_tmp20_ = self->priv->cached_context;
	_tmp21_ = _cairo_reference0 (_tmp20_);
	ctx = _tmp21_;
	_tmp22_ = ctx;
	cairo_set_source_rgba (_tmp22_, (gdouble) 255, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp23_ = ctx;
	_tmp24_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp27_ = _tmp26_;
	gala_drawing_utilities_cairo_rounded_rectangle (_tmp23_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp25_, (gdouble) _tmp27_, (gdouble) 9);
	_tmp28_ = ctx;
	cairo_set_operator (_tmp28_, CAIRO_OPERATOR_SOURCE);
	_tmp29_ = ctx;
	cairo_stroke (_tmp29_);
	_tmp30_ = ctx;
	cairo_restore (_tmp30_);
	_tmp31_ = ctx;
	cairo_paint (_tmp31_);
	{
		CoglTexture2D* _tmp32_;
		_tmp32_ = self->priv->cached_texture;
		if (_tmp32_ == NULL) {
			CoglTexture2D* texture = NULL;
			CoglFramebuffer* _tmp33_;
			CoglContext* _tmp34_;
			gfloat _tmp35_;
			gfloat _tmp36_;
			gfloat _tmp37_;
			gfloat _tmp38_;
			cairo_surface_t* _tmp39_;
			cairo_surface_t* _tmp40_;
			guchar* _tmp41_;
			CoglTexture2D* _tmp42_;
			CoglPipeline* _tmp43_;
			CoglTexture2D* _tmp44_;
			CoglTexture2D* _tmp45_;
			CoglTexture2D* _tmp46_;
			_tmp33_ = clutter_paint_context_get_framebuffer (context);
			_tmp34_ = cogl_framebuffer_get_context (_tmp33_);
			_tmp35_ = clutter_actor_get_width ((ClutterActor*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = clutter_actor_get_height ((ClutterActor*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = surface;
			_tmp40_ = surface;
			_tmp41_ = cairo_image_surface_get_data (_tmp40_);
			_tmp42_ = (CoglTexture2D*) cogl_texture_2d_new_from_data (_tmp34_, (gint) _tmp36_, (gint) _tmp38_, COGL_PIXEL_FORMAT_BGRA_8888_PRE, cairo_image_surface_get_stride (_tmp39_), _tmp41_, &_inner_error0_);
			texture = _tmp42_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp43_ = self->priv->pipeline;
			_tmp44_ = texture;
			cogl_pipeline_set_layer_texture (_tmp43_, 0, (CoglTexture*) _tmp44_);
			_tmp45_ = texture;
			_tmp46_ = _g_object_ref0 (_tmp45_);
			_g_object_unref0 (self->priv->cached_texture);
			self->priv->cached_texture = _tmp46_;
			_g_object_unref0 (texture);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp47_;
		const gchar* _tmp48_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		g_debug ("WorkspaceClone.vala:86: %s", _tmp48_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_destroy0 (ctx);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	cogl_color_init_from_4f (&color, 1.0f, 1.0f, 1.0f, 25.0f / 255.0f);
	cogl_color_premultiply (&color);
	_tmp49_ = self->priv->pipeline;
	_tmp50_ = color;
	cogl_pipeline_set_color (_tmp49_, &_tmp50_);
	_tmp51_ = clutter_paint_context_get_framebuffer (context);
	fb = _tmp51_;
	_tmp52_ = self->priv->pipeline;
	_tmp53_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp56_ = _tmp55_;
	cogl_framebuffer_draw_rectangle (fb, _tmp52_, (gfloat) 0, (gfloat) 0, _tmp54_, _tmp56_);
	_cairo_destroy0 (ctx);
	_cairo_surface_destroy0 (surface);
}

static GObject *
gala_framed_background_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaFramedBackground * self;
	ClutterBackend* _tmp0_;
	CoglContext* _tmp1_;
	CoglPipeline* _tmp2_;
	gint primary = 0;
	GalaWindowManager* _tmp3_;
	GalaWindowManager* _tmp4_;
	MetaDisplay* _tmp5_;
	MtkRectangle monitor_geom = {0};
	GalaWindowManager* _tmp6_;
	GalaWindowManager* _tmp7_;
	MetaDisplay* _tmp8_;
	MtkRectangle _tmp9_ = {0};
	GalaShadowEffect* effect = NULL;
	gchar* _tmp10_;
	GalaShadowEffect* _tmp11_ = NULL;
	GalaShadowEffect* _tmp12_;
	parent_class = G_OBJECT_CLASS (gala_framed_background_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_cogl_context (_tmp0_);
	_tmp2_ = cogl_pipeline_new (_tmp1_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp2_;
	_tmp3_ = gala_background_manager_get_wm ((GalaBackgroundManager*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
	primary = meta_display_get_primary_monitor (_tmp5_);
	_tmp6_ = gala_background_manager_get_wm ((GalaBackgroundManager*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = meta_plugin_get_display ((MetaPlugin*) _tmp7_);
	meta_display_get_monitor_geometry (_tmp8_, primary, &_tmp9_);
	monitor_geom = _tmp9_;
	_tmp10_ = g_strdup ("workspace");
	_tmp11_ = gala_shadow_effect_new (40);
	gala_shadow_effect_set_css_class (_tmp11_, _tmp10_);
	_g_free0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	effect = _tmp11_;
	_tmp12_ = effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp12_);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_g_object_unref0 (effect);
	return obj;
}

static void
gala_framed_background_class_init (GalaFramedBackgroundClass * klass,
                                   gpointer klass_data)
{
	gala_framed_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaFramedBackground_private_offset);
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_framed_background_real_paint;
	G_OBJECT_CLASS (klass)->constructor = gala_framed_background_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_framed_background_finalize;
}

static void
gala_framed_background_instance_init (GalaFramedBackground * self,
                                      gpointer klass)
{
	self->priv = gala_framed_background_get_instance_private (self);
}

static void
gala_framed_background_finalize (GObject * obj)
{
	GalaFramedBackground * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground);
	_g_object_unref0 (self->priv->pipeline);
	_cairo_surface_destroy0 (self->priv->cached_surface);
	_cairo_destroy0 (self->priv->cached_context);
	_g_object_unref0 (self->priv->cached_texture);
	G_OBJECT_CLASS (gala_framed_background_parent_class)->finalize (obj);
}

/**
     * Utility class which adds a border and a shadow to a Background
     */
static GType
gala_framed_background_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaFramedBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_framed_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaFramedBackground), 0, (GInstanceInitFunc) gala_framed_background_instance_init, NULL };
	GType gala_framed_background_type_id;
	gala_framed_background_type_id = g_type_register_static (GALA_TYPE_BACKGROUND_MANAGER, "GalaFramedBackground", &g_define_type_info, 0);
	GalaFramedBackground_private_offset = g_type_add_instance_private (gala_framed_background_type_id, sizeof (GalaFramedBackgroundPrivate));
	return gala_framed_background_type_id;
}

 G_GNUC_INTERNAL GType
gala_framed_background_get_type (void)
{
	static volatile gsize gala_framed_background_type_id__once = 0;
	if (g_once_init_enter (&gala_framed_background_type_id__once)) {
		GType gala_framed_background_type_id;
		gala_framed_background_type_id = gala_framed_background_get_type_once ();
		g_once_init_leave (&gala_framed_background_type_id__once, gala_framed_background_type_id);
	}
	return gala_framed_background_type_id__once;
}

static inline gpointer
gala_workspace_clone_get_instance_private (GalaWorkspaceClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWorkspaceClone_private_offset);
}

static void
_gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                  gint object,
                                                                                  MetaWindow* p0,
                                                                                  gpointer self)
{
	gala_workspace_clone_window_entered_monitor ((GalaWorkspaceClone*) self, _sender, object, p0);
}

static void
_gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                            gint object,
                                                                            MetaWindow* p0,
                                                                            gpointer self)
{
	gala_workspace_clone_window_left_monitor ((GalaWorkspaceClone*) self, _sender, object, p0);
}

static void
_gala_workspace_clone_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                              MetaWindow* object,
                                                              gpointer self)
{
	gala_workspace_clone_add_window ((GalaWorkspaceClone*) self, object);
}

static void
_gala_workspace_clone_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self)
{
	gala_workspace_clone_remove_window ((GalaWorkspaceClone*) self, object);
}

static void
_gala_workspace_clone_add_window_gala_window_listener_window_no_longer_on_all_workspaces (GalaWindowListener* _sender,
                                                                                          MetaWindow* window,
                                                                                          gpointer self)
{
	gala_workspace_clone_add_window ((GalaWorkspaceClone*) self, window);
}

GalaWorkspaceClone*
gala_workspace_clone_construct (GType object_type,
                                GalaWindowManager* wm,
                                MetaWorkspace* workspace,
                                GalaGestureTracker* gesture_tracker,
                                gfloat scale)
{
	GalaWorkspaceClone * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (workspace != NULL, NULL);
	g_return_val_if_fail (gesture_tracker != NULL, NULL);
	self = (GalaWorkspaceClone*) g_object_new (object_type, "wm", wm, "workspace", workspace, "gesture-tracker", gesture_tracker, "scale-factor", scale, NULL);
	return self;
}

GalaWorkspaceClone*
gala_workspace_clone_new (GalaWindowManager* wm,
                          MetaWorkspace* workspace,
                          GalaGestureTracker* gesture_tracker,
                          gfloat scale)
{
	return gala_workspace_clone_construct (GALA_TYPE_WORKSPACE_CLONE, wm, workspace, gesture_tracker, scale);
}

static void
gala_workspace_clone_reallocate (GalaWorkspaceClone* self)
{
	GalaIconGroup* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	GalaWindowCloneContainer* _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_icon_group;
	_tmp1_ = gala_workspace_clone_get_scale_factor (self);
	_tmp2_ = _tmp1_;
	gala_icon_group_set_scale_factor (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->_window_container;
	_tmp4_ = gala_workspace_clone_get_scale_factor (self);
	_tmp5_ = _tmp4_;
	gala_window_clone_container_set_monitor_scale (_tmp3_, _tmp5_);
}

/**
         * Add a window to the WindowCloneContainer and the IconGroup if it really
         * belongs to this workspace and this monitor.
         */
static void
gala_workspace_clone_add_window (GalaWorkspaceClone* self,
                                 MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	MetaWindowType _tmp3_;
	MetaWindowType _tmp4_;
	GalaWindowCloneContainer* _tmp9_;
	GList* _tmp10_;
	GalaWindowCloneContainer* _tmp14_;
	GalaIconGroup* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp3_ = meta_window_get_window_type (window);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != META_WINDOW_NORMAL) {
		_tmp2_ = TRUE;
	} else {
		MetaWorkspace* _tmp5_;
		MetaWorkspace* _tmp6_;
		_tmp5_ = meta_window_get_workspace (window);
		_tmp6_ = self->priv->_workspace;
		_tmp2_ = _tmp5_ != _tmp6_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp7_;
		gboolean _tmp8_;
		g_object_get (window, "on-all-workspaces", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !meta_window_is_on_primary_monitor (window);
	}
	if (_tmp0_) {
		return;
	}
	_tmp9_ = self->priv->_window_container;
	_tmp10_ = clutter_actor_get_children ((ClutterActor*) _tmp9_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp10_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp11_;
				MetaWindow* _tmp12_;
				MetaWindow* _tmp13_;
				_tmp11_ = child;
				_tmp12_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
				_tmp13_ = _tmp12_;
				if (_tmp13_ == window) {
					(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
					return;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp14_ = self->priv->_window_container;
	gala_window_clone_container_add_window (_tmp14_, window);
	_tmp15_ = self->priv->_icon_group;
	gala_icon_group_add_window (_tmp15_, window, FALSE, FALSE);
}

/**
         * Remove a window from the WindowCloneContainer and the IconGroup
         */
static void
gala_workspace_clone_remove_window (GalaWorkspaceClone* self,
                                    MetaWindow* window)
{
	GalaWindowCloneContainer* _tmp0_;
	GalaIconGroup* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_window_container;
	gala_window_clone_container_remove_window (_tmp0_, window);
	_tmp1_ = self->priv->_icon_group;
	gala_icon_group_remove_window (_tmp1_, window, self->priv->opened);
}

static void
gala_workspace_clone_window_entered_monitor (GalaWorkspaceClone* self,
                                             MetaDisplay* display,
                                             gint monitor,
                                             MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	gala_workspace_clone_add_window (self, window);
}

static void
gala_workspace_clone_window_left_monitor (GalaWorkspaceClone* self,
                                          MetaDisplay* display,
                                          gint monitor,
                                          MetaWindow* window)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (window != NULL);
	if (monitor == meta_display_get_primary_monitor (display)) {
		gala_workspace_clone_remove_window (self, window);
	}
}

void
gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                  MtkRectangle* monitor_geometry)
{
	gboolean _tmp0_ = FALSE;
	GalaWindowCloneContainer* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	MtkRectangle _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (monitor_geometry != NULL);
	_tmp1_ = self->priv->_window_container;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *monitor_geometry;
	if (_tmp3_ != ((gfloat) _tmp4_.width)) {
		_tmp0_ = TRUE;
	} else {
		GalaWindowCloneContainer* _tmp5_;
		gfloat _tmp6_;
		gfloat _tmp7_;
		MtkRectangle _tmp8_;
		_tmp5_ = self->priv->_window_container;
		_tmp6_ = clutter_actor_get_height ((ClutterActor*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = *monitor_geometry;
		_tmp0_ = _tmp7_ != ((gfloat) _tmp8_.height);
	}
	if (_tmp0_) {
		GalaWindowCloneContainer* _tmp9_;
		MtkRectangle _tmp10_;
		MtkRectangle _tmp11_;
		GalaBackgroundManager* _tmp12_;
		GalaWindowCloneContainer* _tmp13_;
		gfloat _tmp14_;
		gfloat _tmp15_;
		GalaWindowCloneContainer* _tmp16_;
		gfloat _tmp17_;
		gfloat _tmp18_;
		_tmp9_ = self->priv->_window_container;
		_tmp10_ = *monitor_geometry;
		_tmp11_ = *monitor_geometry;
		clutter_actor_set_size ((ClutterActor*) _tmp9_, (gfloat) _tmp10_.width, (gfloat) _tmp11_.height);
		_tmp12_ = self->priv->background;
		_tmp13_ = self->priv->_window_container;
		_tmp14_ = clutter_actor_get_width ((ClutterActor*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->_window_container;
		_tmp17_ = clutter_actor_get_height ((ClutterActor*) _tmp16_);
		_tmp18_ = _tmp17_;
		gala_background_manager_set_size (_tmp12_, _tmp15_, _tmp18_);
	}
}

/**
         * @return The position on the X axis of this workspace.
         */
gfloat
gala_workspace_clone_multitasking_view_x (GalaWorkspaceClone* self)
{
	MetaWorkspace* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gala_workspace_clone_get_scale_factor (self);
	_tmp4_ = _tmp3_;
	result = meta_workspace_index (_tmp0_) * (_tmp2_ - gala_internal_utils_scale_to_int (GALA_WORKSPACE_CLONE_X_OFFSET, _tmp4_));
	return result;
}

/**
         * @return The amount of pixels the workspace is overlapped in the X axis.
         */
static gfloat
gala_workspace_clone_current_x_overlap (GalaWorkspaceClone* self)
{
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	gint active_index = 0;
	MetaWorkspaceManager* _tmp5_;
	MetaWorkspace* _tmp6_;
	MetaWorkspace* _tmp7_;
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	manager = _tmp4_;
	_tmp5_ = manager;
	_tmp6_ = meta_workspace_manager_get_active_workspace (_tmp5_);
	active_index = meta_workspace_index (_tmp6_);
	_tmp7_ = self->priv->_workspace;
	if (meta_workspace_index (_tmp7_) == active_index) {
		result = (gfloat) 0;
		_g_object_unref0 (display);
		return result;
	} else {
		gint x_offset = 0;
		gfloat _tmp8_;
		gfloat _tmp9_;
		gint _tmp10_ = 0;
		MetaWorkspace* _tmp11_;
		_tmp8_ = gala_workspace_clone_get_scale_factor (self);
		_tmp9_ = _tmp8_;
		x_offset = gala_internal_utils_scale_to_int (GALA_WORKSPACE_CLONE_X_OFFSET, _tmp9_) + GALA_WINDOW_MANAGER_GALA_WORKSPACE_GAP;
		_tmp11_ = self->priv->_workspace;
		if (meta_workspace_index (_tmp11_) < active_index) {
			_tmp10_ = -x_offset;
		} else {
			_tmp10_ = x_offset;
		}
		result = (gfloat) _tmp10_;
		_g_object_unref0 (display);
		return result;
	}
}

/**
         * Utility function to shrink a MetaRectangle on all sides for the given amount.
         * Negative amounts will scale it instead.
         *
         * @param amount The amount in px to shrink.
         */
static inline void
gala_workspace_clone_shrink_rectangle (MtkRectangle* rect,
                                       gint amount)
{
	g_return_if_fail (rect != NULL);
	(*rect).x = (*rect).x + amount;
	(*rect).y = (*rect).y + amount;
	(*rect).width = (*rect).width - (amount * 2);
	(*rect).height = (*rect).height - (amount * 2);
}

/**
         * Animates the background to its scale, causes a redraw on the IconGroup and
         * makes sure the WindowCloneContainer animates its windows to their tiled layout.
         * Also sets the current_window of the WindowCloneContainer to the active window
         * if it belongs to this workspace.
         */
static Block73Data*
block73_data_ref (Block73Data* _data73_)
{
	g_atomic_int_inc (&_data73_->_ref_count_);
	return _data73_;
}

static void
block73_data_unref (void * _userdata_)
{
	Block73Data* _data73_;
	_data73_ = (Block73Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data73_->_ref_count_)) {
		GalaWorkspaceClone* self;
		self = _data73_->self;
		_g_object_unref0 (self);
		g_slice_free (Block73Data, _data73_);
	}
}

static void
__lambda53_ (Block73Data* _data73_)
{
	GalaWorkspaceClone* self;
	GalaBackgroundManager* _tmp0_;
	self = _data73_->self;
	clutter_actor_set_x ((ClutterActor*) self, _data73_->initial_x);
	_tmp0_ = self->priv->background;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp0_, 0.5f, _data73_->pivot_y);
}

static void
___lambda53__gala_gesture_tracker_on_begin (gdouble percentage,
                                            gpointer self)
{
	__lambda53_ (self);
}

static void
__lambda54_ (Block73Data* _data73_,
             gdouble percentage)
{
	GalaWorkspaceClone* self;
	gfloat x = 0.0F;
	gdouble update_scale = 0.0;
	GalaBackgroundManager* _tmp0_;
	self = _data73_->self;
	x = gala_gesture_tracker_animation_value (_data73_->initial_x, _data73_->target_x, percentage, FALSE);
	clutter_actor_set_x ((ClutterActor*) self, x);
	update_scale = (gdouble) gala_gesture_tracker_animation_value (1.0f, (gfloat) _data73_->scale, percentage, FALSE);
	_tmp0_ = self->priv->background;
	clutter_actor_set_scale ((ClutterActor*) _tmp0_, update_scale, update_scale);
}

static void
___lambda54__gala_gesture_tracker_on_update (gdouble percentage,
                                             gpointer self)
{
	__lambda54_ (self, percentage);
}

static void
__lambda55_ (Block73Data* _data73_,
             gdouble percentage,
             gboolean cancel_action)
{
	GalaWorkspaceClone* self;
	gint _tmp0_ = 0;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GalaBackgroundManager* _tmp4_;
	GalaBackgroundManager* _tmp5_;
	gint _tmp6_ = 0;
	GalaWindowManager* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GalaBackgroundManager* _tmp10_;
	GalaBackgroundManager* _tmp11_;
	GalaBackgroundManager* _tmp12_;
	self = _data73_->self;
	if (cancel_action) {
		return;
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp0_ = 0;
	}
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) _tmp0_);
	clutter_actor_set_x ((ClutterActor*) self, _data73_->target_x);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_tmp4_ = self->priv->background;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp4_);
	_tmp5_ = self->priv->background;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp5_, CLUTTER_EASE_OUT_QUAD);
	_tmp7_ = self->priv->_wm;
	_tmp8_ = gala_window_manager_get_enable_animations (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		_tmp6_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp6_ = 0;
	}
	_tmp10_ = self->priv->background;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp10_, (guint) _tmp6_);
	_tmp11_ = self->priv->background;
	clutter_actor_set_scale ((ClutterActor*) _tmp11_, (gdouble) _data73_->scale, (gdouble) _data73_->scale);
	_tmp12_ = self->priv->background;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp12_);
}

static void
___lambda55__gala_gesture_tracker_on_end (gdouble percentage,
                                          gboolean cancel_action,
                                          gint calculated_duration,
                                          gpointer self)
{
	__lambda55_ (self, percentage, cancel_action);
}

void
gala_workspace_clone_open (GalaWorkspaceClone* self,
                           gboolean with_gesture,
                           gboolean is_cancel_animation)
{
	Block73Data* _data73_;
	GalaWindowCloneContainer* _tmp0_;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp1_;
	MetaDisplay* _tmp2_;
	MtkRectangle monitor = {0};
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	MtkRectangle _tmp5_ = {0};
	gfloat _tmp6_ = 0.0F;
	MtkRectangle _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	MtkRectangle _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	MtkRectangle _tmp17_;
	MtkRectangle _tmp18_;
	MtkRectangle _tmp19_;
	GalaGestureTrackerOnBegin on_animation_begin = NULL;
	gpointer on_animation_begin_target;
	GDestroyNotify on_animation_begin_target_destroy_notify;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	gboolean _tmp20_ = FALSE;
	MtkRectangle area = {0};
	MtkRectangle _tmp30_;
	MtkRectangle _tmp31_;
	MtkRectangle _tmp32_;
	MtkRectangle _tmp33_;
	gfloat _tmp34_;
	gfloat _tmp35_;
	MtkRectangle _tmp36_;
	MtkRectangle _tmp37_;
	MtkRectangle _tmp38_ = {0};
	GalaWindowCloneContainer* _tmp39_;
	gfloat _tmp40_;
	gfloat _tmp41_;
	GalaWindowCloneContainer* _tmp42_;
	GalaWindowCloneContainer* _tmp43_;
	MtkRectangle _tmp44_;
	MtkRectangle _tmp45_;
	GalaWindowCloneContainer* _tmp46_;
	gfloat _tmp47_;
	gfloat _tmp48_;
	GalaIconGroup* _tmp49_;
	MetaWindow* _tmp50_ = NULL;
	MetaDisplay* _tmp51_;
	MetaWorkspaceManager* _tmp52_;
	MetaWorkspace* _tmp53_;
	MetaWorkspace* _tmp54_;
	MetaWindow* selected_window = NULL;
	MetaWindow* _tmp57_;
	GalaWindowCloneContainer* _tmp58_;
	MetaWindow* _tmp59_;
	g_return_if_fail (self != NULL);
	_data73_ = g_slice_new0 (Block73Data);
	_data73_->_ref_count_ = 1;
	_data73_->self = g_object_ref (self);
	if (self->priv->opened) {
		block73_data_unref (_data73_);
		_data73_ = NULL;
		return;
	}
	self->priv->opened = TRUE;
	_tmp0_ = self->priv->_window_container;
	gala_window_clone_container_restack_windows (_tmp0_);
	_tmp1_ = self->priv->_workspace;
	_tmp2_ = meta_workspace_get_display (_tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	_tmp4_ = display;
	meta_display_get_monitor_geometry (_tmp3_, meta_display_get_primary_monitor (_tmp4_), &_tmp5_);
	monitor = _tmp5_;
	if (is_cancel_animation) {
		gfloat _tmp7_;
		gfloat _tmp8_;
		_tmp7_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp8_ = _tmp7_;
		_tmp6_ = _tmp8_;
	} else {
		gfloat _tmp9_;
		gfloat _tmp10_;
		_tmp9_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ + gala_workspace_clone_current_x_overlap (self);
	}
	_data73_->initial_x = _tmp6_;
	_data73_->target_x = gala_workspace_clone_multitasking_view_x (self);
	_tmp11_ = monitor;
	_tmp12_ = gala_workspace_clone_get_scale_factor (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = monitor;
	_data73_->scale = ((gfloat) (_tmp11_.height - gala_internal_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET + GALA_WORKSPACE_CLONE_BOTTOM_OFFSET, _tmp13_))) / _tmp14_.height;
	_tmp15_ = gala_workspace_clone_get_scale_factor (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = monitor;
	_tmp18_ = monitor;
	_data73_->pivot_y = gala_internal_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET, _tmp16_) / (_tmp17_.height - (_tmp18_.height * _data73_->scale));
	_tmp19_ = monitor;
	gala_workspace_clone_update_size (self, &_tmp19_);
	on_animation_begin = ___lambda53__gala_gesture_tracker_on_begin;
	on_animation_begin_target = block73_data_ref (_data73_);
	on_animation_begin_target_destroy_notify = block73_data_unref;
	on_animation_update = ___lambda54__gala_gesture_tracker_on_update;
	on_animation_update_target = block73_data_ref (_data73_);
	on_animation_update_target_destroy_notify = block73_data_unref;
	on_animation_end = ___lambda55__gala_gesture_tracker_on_end;
	on_animation_end_target = block73_data_ref (_data73_);
	on_animation_end_target_destroy_notify = block73_data_unref;
	if (!with_gesture) {
		_tmp20_ = TRUE;
	} else {
		GalaWindowManager* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp21_ = self->priv->_wm;
		_tmp22_ = gala_window_manager_get_enable_animations (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp20_ = !_tmp23_;
	}
	if (_tmp20_) {
		GalaGestureTrackerOnBegin _tmp24_;
		gpointer _tmp24__target;
		GalaGestureTrackerOnEnd _tmp25_;
		gpointer _tmp25__target;
		_tmp24_ = on_animation_begin;
		_tmp24__target = on_animation_begin_target;
		_tmp24_ ((gdouble) 0, _tmp24__target);
		_tmp25_ = on_animation_end;
		_tmp25__target = on_animation_end_target;
		_tmp25_ ((gdouble) 1, FALSE, 0, _tmp25__target);
	} else {
		GalaGestureTracker* _tmp26_;
		GalaGestureTrackerOnBegin _tmp27_;
		gpointer _tmp27__target;
		GDestroyNotify _tmp27__target_destroy_notify;
		GalaGestureTrackerOnUpdate _tmp28_;
		gpointer _tmp28__target;
		GDestroyNotify _tmp28__target_destroy_notify;
		GalaGestureTrackerOnEnd _tmp29_;
		gpointer _tmp29__target;
		GDestroyNotify _tmp29__target_destroy_notify;
		_tmp26_ = self->priv->_gesture_tracker;
		_tmp27_ = on_animation_begin;
		_tmp27__target = on_animation_begin_target;
		_tmp27__target_destroy_notify = on_animation_begin_target_destroy_notify;
		on_animation_begin = NULL;
		on_animation_begin_target = NULL;
		on_animation_begin_target_destroy_notify = NULL;
		_tmp28_ = on_animation_update;
		_tmp28__target = on_animation_update_target;
		_tmp28__target_destroy_notify = on_animation_update_target_destroy_notify;
		on_animation_update = NULL;
		on_animation_update_target = NULL;
		on_animation_update_target_destroy_notify = NULL;
		_tmp29_ = on_animation_end;
		_tmp29__target = on_animation_end_target;
		_tmp29__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp26_, _tmp27_, _tmp27__target, _tmp27__target_destroy_notify, _tmp28_, _tmp28__target, _tmp28__target_destroy_notify, _tmp29_, _tmp29__target, _tmp29__target_destroy_notify);
	}
	_tmp30_ = monitor;
	_tmp31_ = monitor;
	_tmp32_ = monitor;
	_tmp33_ = monitor;
	_tmp34_ = gala_workspace_clone_get_scale_factor (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = monitor;
	_tmp37_ = monitor;
	_tmp38_.x = ((gint) floorf ((_tmp30_.x + _tmp31_.width) - (_tmp32_.width * _data73_->scale))) / 2;
	_tmp38_.y = (gint) floorf ((gfloat) (_tmp33_.y + gala_internal_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET, _tmp35_)));
	_tmp38_.width = (gint) floorf (_tmp36_.width * _data73_->scale);
	_tmp38_.height = (gint) floorf (_tmp37_.height * _data73_->scale);
	area = _tmp38_;
	gala_workspace_clone_shrink_rectangle (&area, 32);
	_tmp39_ = self->priv->_window_container;
	_tmp40_ = gala_workspace_clone_get_scale_factor (self);
	_tmp41_ = _tmp40_;
	gala_window_clone_container_set_padding_top (_tmp39_, gala_internal_utils_scale_to_int (GALA_WORKSPACE_CLONE_TOP_OFFSET, _tmp41_));
	_tmp42_ = self->priv->_window_container;
	_tmp43_ = self->priv->_window_container;
	_tmp44_ = monitor;
	_tmp45_ = monitor;
	gala_window_clone_container_set_padding_right (_tmp43_, ((gint) (_tmp44_.width - (_tmp45_.width * _data73_->scale))) / 2);
	gala_window_clone_container_set_padding_left (_tmp42_, ((gint) (_tmp44_.width - (_tmp45_.width * _data73_->scale))) / 2);
	_tmp46_ = self->priv->_window_container;
	_tmp47_ = gala_workspace_clone_get_scale_factor (self);
	_tmp48_ = _tmp47_;
	gala_window_clone_container_set_padding_bottom (_tmp46_, gala_internal_utils_scale_to_int (GALA_WORKSPACE_CLONE_BOTTOM_OFFSET, _tmp48_));
	_tmp49_ = self->priv->_icon_group;
	gala_icon_group_redraw (_tmp49_);
	_tmp51_ = display;
	_tmp52_ = meta_display_get_workspace_manager (_tmp51_);
	_tmp53_ = meta_workspace_manager_get_active_workspace (_tmp52_);
	_tmp54_ = self->priv->_workspace;
	if (_tmp53_ == _tmp54_) {
		MetaDisplay* _tmp55_;
		MetaWindow* _tmp56_;
		_tmp55_ = display;
		_tmp56_ = meta_display_get_focus_window (_tmp55_);
		_tmp50_ = _tmp56_;
	} else {
		_tmp50_ = NULL;
	}
	_tmp57_ = _g_object_ref0 (_tmp50_);
	selected_window = _tmp57_;
	_tmp58_ = self->priv->_window_container;
	_tmp59_ = selected_window;
	gala_window_clone_container_open (_tmp58_, _tmp59_, with_gesture, is_cancel_animation);
	_g_object_unref0 (selected_window);
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	(on_animation_begin_target_destroy_notify == NULL) ? NULL : (on_animation_begin_target_destroy_notify (on_animation_begin_target), NULL);
	on_animation_begin = NULL;
	on_animation_begin_target = NULL;
	on_animation_begin_target_destroy_notify = NULL;
	block73_data_unref (_data73_);
	_data73_ = NULL;
}

/**
         * Close the view again by animating the background back to its scale and
         * the windows back to their old locations.
         */
static Block74Data*
block74_data_ref (Block74Data* _data74_)
{
	g_atomic_int_inc (&_data74_->_ref_count_);
	return _data74_;
}

static void
block74_data_unref (void * _userdata_)
{
	Block74Data* _data74_;
	_data74_ = (Block74Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data74_->_ref_count_)) {
		GalaWorkspaceClone* self;
		self = _data74_->self;
		_g_object_unref0 (self);
		g_slice_free (Block74Data, _data74_);
	}
}

static void
__lambda56_ (Block74Data* _data74_,
             gdouble percentage)
{
	GalaWorkspaceClone* self;
	gfloat x = 0.0F;
	gdouble scale_x = 0.0;
	gdouble scale_y = 0.0;
	GalaBackgroundManager* _tmp0_;
	self = _data74_->self;
	x = gala_gesture_tracker_animation_value (_data74_->initial_x, _data74_->target_x, percentage, FALSE);
	clutter_actor_set_x ((ClutterActor*) self, x);
	scale_x = (gdouble) gala_gesture_tracker_animation_value ((gfloat) _data74_->initial_scale_x, 1.0f, percentage, FALSE);
	scale_y = (gdouble) gala_gesture_tracker_animation_value ((gfloat) _data74_->initial_scale_y, 1.0f, percentage, FALSE);
	_tmp0_ = self->priv->background;
	clutter_actor_set_scale ((ClutterActor*) _tmp0_, scale_x, scale_y);
}

static void
___lambda56__gala_gesture_tracker_on_update (gdouble percentage,
                                             gpointer self)
{
	__lambda56_ (self, percentage);
}

static void
__lambda57_ (Block74Data* _data74_,
             gdouble percentage,
             gboolean cancel_action)
{
	GalaWorkspaceClone* self;
	gint _tmp0_ = 0;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GalaBackgroundManager* _tmp4_;
	GalaBackgroundManager* _tmp5_;
	gint _tmp6_ = 0;
	GalaWindowManager* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GalaBackgroundManager* _tmp10_;
	GalaBackgroundManager* _tmp11_;
	GalaBackgroundManager* _tmp12_;
	self = _data74_->self;
	if (cancel_action) {
		return;
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp0_ = 0;
	}
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) _tmp0_);
	clutter_actor_set_x ((ClutterActor*) self, _data74_->target_x);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_tmp4_ = self->priv->background;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp4_);
	_tmp5_ = self->priv->background;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp5_, CLUTTER_EASE_OUT_QUAD);
	_tmp7_ = self->priv->_wm;
	_tmp8_ = gala_window_manager_get_enable_animations (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		_tmp6_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp6_ = 0;
	}
	_tmp10_ = self->priv->background;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp10_, (guint) _tmp6_);
	_tmp11_ = self->priv->background;
	clutter_actor_set_scale ((ClutterActor*) _tmp11_, (gdouble) 1, (gdouble) 1);
	_tmp12_ = self->priv->background;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp12_);
}

static void
___lambda57__gala_gesture_tracker_on_end (gdouble percentage,
                                          gboolean cancel_action,
                                          gint calculated_duration,
                                          gpointer self)
{
	__lambda57_ (self, percentage, cancel_action);
}

void
gala_workspace_clone_close (GalaWorkspaceClone* self,
                            gboolean with_gesture,
                            gboolean is_cancel_animation)
{
	Block74Data* _data74_;
	GalaWindowCloneContainer* _tmp0_;
	gfloat _tmp1_ = 0.0F;
	GalaBackgroundManager* _tmp4_;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	gboolean _tmp7_ = FALSE;
	GalaWindowCloneContainer* _tmp15_;
	g_return_if_fail (self != NULL);
	_data74_ = g_slice_new0 (Block74Data);
	_data74_->_ref_count_ = 1;
	_data74_->self = g_object_ref (self);
	if (!self->priv->opened) {
		block74_data_unref (_data74_);
		_data74_ = NULL;
		return;
	}
	self->priv->opened = FALSE;
	_tmp0_ = self->priv->_window_container;
	gala_window_clone_container_restack_windows (_tmp0_);
	if (is_cancel_animation) {
		gfloat _tmp2_;
		gfloat _tmp3_;
		_tmp2_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp3_ = _tmp2_;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = gala_workspace_clone_multitasking_view_x (self);
	}
	_data74_->initial_x = _tmp1_;
	_data74_->target_x = gala_workspace_clone_multitasking_view_x (self) + gala_workspace_clone_current_x_overlap (self);
	_tmp4_ = self->priv->background;
	clutter_actor_get_scale ((ClutterActor*) _tmp4_, &_tmp5_, &_tmp6_);
	_data74_->initial_scale_x = _tmp5_;
	_data74_->initial_scale_y = _tmp6_;
	on_animation_update = ___lambda56__gala_gesture_tracker_on_update;
	on_animation_update_target = block74_data_ref (_data74_);
	on_animation_update_target_destroy_notify = block74_data_unref;
	on_animation_end = ___lambda57__gala_gesture_tracker_on_end;
	on_animation_end_target = block74_data_ref (_data74_);
	on_animation_end_target_destroy_notify = block74_data_unref;
	if (!with_gesture) {
		_tmp7_ = TRUE;
	} else {
		GalaWindowManager* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->_wm;
		_tmp9_ = gala_window_manager_get_enable_animations (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp7_ = !_tmp10_;
	}
	if (_tmp7_) {
		GalaGestureTrackerOnEnd _tmp11_;
		gpointer _tmp11__target;
		_tmp11_ = on_animation_end;
		_tmp11__target = on_animation_end_target;
		_tmp11_ ((gdouble) 1, FALSE, 0, _tmp11__target);
	} else {
		GalaGestureTracker* _tmp12_;
		GalaGestureTrackerOnUpdate _tmp13_;
		gpointer _tmp13__target;
		GDestroyNotify _tmp13__target_destroy_notify;
		GalaGestureTrackerOnEnd _tmp14_;
		gpointer _tmp14__target;
		GDestroyNotify _tmp14__target_destroy_notify;
		_tmp12_ = self->priv->_gesture_tracker;
		_tmp13_ = on_animation_update;
		_tmp13__target = on_animation_update_target;
		_tmp13__target_destroy_notify = on_animation_update_target_destroy_notify;
		on_animation_update = NULL;
		on_animation_update_target = NULL;
		on_animation_update_target_destroy_notify = NULL;
		_tmp14_ = on_animation_end;
		_tmp14__target = on_animation_end_target;
		_tmp14__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp12_, NULL, NULL, NULL, _tmp13_, _tmp13__target, _tmp13__target_destroy_notify, _tmp14_, _tmp14__target, _tmp14__target_destroy_notify);
	}
	_tmp15_ = self->priv->_window_container;
	gala_window_clone_container_close (_tmp15_, with_gesture, is_cancel_animation);
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	block74_data_unref (_data74_);
	_data74_ = NULL;
}

GalaWindowManager*
gala_workspace_clone_get_wm (GalaWorkspaceClone* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_wm (GalaWorkspaceClone* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WM_PROPERTY]);
	}
}

MetaWorkspace*
gala_workspace_clone_get_workspace (GalaWorkspaceClone* self)
{
	MetaWorkspace* result;
	MetaWorkspace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_workspace (GalaWorkspaceClone* self,
                                    MetaWorkspace* value)
{
	MetaWorkspace* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_workspace (self);
	if (old_value != value) {
		MetaWorkspace* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_workspace);
		self->priv->_workspace = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY]);
	}
}

GalaGestureTracker*
gala_workspace_clone_get_gesture_tracker (GalaWorkspaceClone* self)
{
	GalaGestureTracker* result;
	GalaGestureTracker* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gesture_tracker;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_gesture_tracker (GalaWorkspaceClone* self,
                                          GalaGestureTracker* value)
{
	GalaGestureTracker* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_gesture_tracker (self);
	if (old_value != value) {
		GalaGestureTracker* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gesture_tracker);
		self->priv->_gesture_tracker = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY]);
	}
}

GalaIconGroup*
gala_workspace_clone_get_icon_group (GalaWorkspaceClone* self)
{
	GalaIconGroup* result;
	GalaIconGroup* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_group;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_icon_group (GalaWorkspaceClone* self,
                                     GalaIconGroup* value)
{
	GalaIconGroup* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_icon_group (self);
	if (old_value != value) {
		GalaIconGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon_group);
		self->priv->_icon_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY]);
	}
}

GalaWindowCloneContainer*
gala_workspace_clone_get_window_container (GalaWorkspaceClone* self)
{
	GalaWindowCloneContainer* result;
	GalaWindowCloneContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_container;
	result = _tmp0_;
	return result;
}

static void
gala_workspace_clone_set_window_container (GalaWorkspaceClone* self,
                                           GalaWindowCloneContainer* value)
{
	GalaWindowCloneContainer* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_clone_get_window_container (self);
	if (old_value != value) {
		GalaWindowCloneContainer* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window_container);
		self->priv->_window_container = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY]);
	}
}

gfloat
gala_workspace_clone_get_scale_factor (GalaWorkspaceClone* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_scale_factor;
	return result;
}

void
gala_workspace_clone_set_scale_factor (GalaWorkspaceClone* self,
                                       gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_scale_factor) {
		self->priv->_scale_factor = value;
		gala_workspace_clone_reallocate (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_SCALE_FACTOR_PROPERTY]);
}

static void
_gala_workspace_clone___lambda58_ (GalaWorkspaceClone* self)
{
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_SELECTED_SIGNAL], 0, TRUE);
}

static void
__gala_workspace_clone___lambda58__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                 ClutterActor* actor,
                                                                 gpointer self)
{
	_gala_workspace_clone___lambda58_ ((GalaWorkspaceClone*) self);
}

static void
_gala_workspace_clone___lambda59_ (GalaWorkspaceClone* self,
                                   MetaWindow* w)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL], 0, w);
}

static void
__gala_workspace_clone___lambda59__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                MetaWindow* window,
                                                                                gpointer self)
{
	_gala_workspace_clone___lambda59_ ((GalaWorkspaceClone*) self, window);
}

static void
_gala_workspace_clone___lambda60_ (GalaWorkspaceClone* self)
{
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_SELECTED_SIGNAL], 0, TRUE);
}

static void
__gala_workspace_clone___lambda60__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                                                gpointer self)
{
	_gala_workspace_clone___lambda60_ ((GalaWorkspaceClone*) self);
}

static void
_gala_workspace_clone___lambda61_ (GalaWorkspaceClone* self)
{
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_SELECTED_SIGNAL], 0, TRUE);
}

static void
__gala_workspace_clone___lambda61__gala_icon_group_selected (GalaIconGroup* _sender,
                                                             gpointer self)
{
	_gala_workspace_clone___lambda61_ ((GalaWorkspaceClone*) self);
}

static gboolean
___lambda63_ (GalaWorkspaceClone* self)
{
	gboolean result;
	g_signal_emit (self, gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_SELECTED_SIGNAL], 0, FALSE);
	self->priv->hover_activate_timeout = (guint) 0;
	result = FALSE;
	return result;
}

static gboolean
____lambda63__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda63_ ((GalaWorkspaceClone*) self);
	return result;
}

static void
_gala_workspace_clone___lambda62_ (GalaWorkspaceClone* self,
                                   ClutterActor* target,
                                   gboolean hovered)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	if (!hovered) {
		_tmp0_ = self->priv->hover_activate_timeout != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_source_remove (self->priv->hover_activate_timeout);
		self->priv->hover_activate_timeout = (guint) 0;
		return;
	}
	if (hovered) {
		_tmp1_ = self->priv->hover_activate_timeout == ((guint) 0);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->hover_activate_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_WORKSPACE_CLONE_HOVER_ACTIVATE_DELAY, ____lambda63__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
__gala_workspace_clone___lambda62__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                                                  ClutterActor* target,
                                                                  gboolean hovered,
                                                                  gpointer self)
{
	_gala_workspace_clone___lambda62_ ((GalaWorkspaceClone*) self, target, hovered);
}

static GObject *
gala_workspace_clone_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWorkspaceClone * self;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	gint primary_monitor = 0;
	MetaDisplay* _tmp2_;
	MtkRectangle monitor_geometry = {0};
	MetaDisplay* _tmp3_;
	MtkRectangle _tmp4_ = {0};
	ClutterClickAction* background_click_action = NULL;
	ClutterClickAction* _tmp5_;
	ClutterClickAction* _tmp6_;
	GalaWindowManager* _tmp7_;
	GalaFramedBackground* _tmp8_;
	GalaBackgroundManager* _tmp9_;
	ClutterClickAction* _tmp10_;
	GalaWindowManager* _tmp11_;
	GalaGestureTracker* _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	MtkRectangle _tmp15_;
	MtkRectangle _tmp16_;
	GalaWindowCloneContainer* _tmp17_ = NULL;
	GalaWindowCloneContainer* _tmp18_;
	GalaWindowCloneContainer* _tmp19_;
	GalaWindowCloneContainer* _tmp20_;
	GalaWindowManager* _tmp21_;
	MetaWorkspace* _tmp22_;
	gfloat _tmp23_;
	gfloat _tmp24_;
	GalaIconGroup* _tmp25_;
	GalaIconGroup* _tmp26_;
	GalaIconGroup* _tmp27_;
	GalaDragDropAction* icons_drop_action = NULL;
	GalaDragDropAction* _tmp28_;
	GalaIconGroup* _tmp29_;
	GalaDragDropAction* _tmp30_;
	GalaDragDropAction* background_drop_action = NULL;
	GalaDragDropAction* _tmp31_;
	GalaBackgroundManager* _tmp32_;
	GalaDragDropAction* _tmp33_;
	GalaDragDropAction* _tmp34_;
	MetaDisplay* _tmp35_;
	MetaDisplay* _tmp36_;
	MetaWorkspace* _tmp37_;
	MetaWorkspace* _tmp38_;
	GalaBackgroundManager* _tmp39_;
	GalaWindowCloneContainer* _tmp40_;
	GList* windows = NULL;
	MetaWorkspace* _tmp41_;
	GList* _tmp42_;
	GList* _tmp43_;
	GalaWindowListener* listener = NULL;
	GalaWindowListener* _tmp57_;
	GalaWindowListener* _tmp58_;
	GalaWindowListener* _tmp59_;
	parent_class = G_OBJECT_CLASS (gala_workspace_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	self->priv->opened = FALSE;
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	primary_monitor = meta_display_get_primary_monitor (_tmp2_);
	_tmp3_ = display;
	meta_display_get_monitor_geometry (_tmp3_, primary_monitor, &_tmp4_);
	monitor_geometry = _tmp4_;
	_tmp5_ = (ClutterClickAction*) clutter_click_action_new ();
	g_object_ref_sink (_tmp5_);
	background_click_action = _tmp5_;
	_tmp6_ = background_click_action;
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) __gala_workspace_clone___lambda58__clutter_click_action_clicked, self, 0);
	_tmp7_ = self->priv->_wm;
	_tmp8_ = gala_framed_background_new (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = (GalaBackgroundManager*) _tmp8_;
	_tmp9_ = self->priv->background;
	_tmp10_ = background_click_action;
	clutter_actor_add_action ((ClutterActor*) _tmp9_, (ClutterAction*) _tmp10_);
	_tmp11_ = self->priv->_wm;
	_tmp12_ = self->priv->_gesture_tracker;
	_tmp13_ = gala_workspace_clone_get_scale_factor (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = monitor_geometry;
	_tmp16_ = monitor_geometry;
	_tmp17_ = gala_window_clone_container_new (_tmp11_, _tmp12_, _tmp14_, FALSE);
	clutter_actor_set_width ((ClutterActor*) _tmp17_, (gfloat) _tmp15_.width);
	clutter_actor_set_height ((ClutterActor*) _tmp17_, (gfloat) _tmp16_.height);
	g_object_ref_sink (_tmp17_);
	_tmp18_ = _tmp17_;
	gala_workspace_clone_set_window_container (self, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = self->priv->_window_container;
	g_signal_connect_object (_tmp19_, "window-selected", (GCallback) __gala_workspace_clone___lambda59__gala_window_clone_container_window_selected, self, 0);
	_tmp20_ = self->priv->_window_container;
	g_signal_connect_object (_tmp20_, "requested-close", (GCallback) __gala_workspace_clone___lambda60__gala_window_clone_container_requested_close, self, 0);
	_tmp21_ = self->priv->_wm;
	_tmp22_ = self->priv->_workspace;
	_tmp23_ = gala_workspace_clone_get_scale_factor (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = gala_icon_group_new (_tmp21_, _tmp22_, _tmp24_);
	g_object_ref_sink (_tmp25_);
	_tmp26_ = _tmp25_;
	gala_workspace_clone_set_icon_group (self, _tmp26_);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = self->priv->_icon_group;
	g_signal_connect_object (_tmp27_, "selected", (GCallback) __gala_workspace_clone___lambda61__gala_icon_group_selected, self, 0);
	_tmp28_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp28_);
	icons_drop_action = _tmp28_;
	_tmp29_ = self->priv->_icon_group;
	_tmp30_ = icons_drop_action;
	clutter_actor_add_action ((ClutterActor*) _tmp29_, (ClutterAction*) _tmp30_);
	_tmp31_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp31_);
	background_drop_action = _tmp31_;
	_tmp32_ = self->priv->background;
	_tmp33_ = background_drop_action;
	clutter_actor_add_action ((ClutterActor*) _tmp32_, (ClutterAction*) _tmp33_);
	_tmp34_ = background_drop_action;
	g_signal_connect_object (_tmp34_, "crossed", (GCallback) __gala_workspace_clone___lambda62__gala_drag_drop_action_crossed, self, 0);
	_tmp35_ = display;
	g_signal_connect_object (_tmp35_, "window-entered-monitor", (GCallback) _gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor, self, 0);
	_tmp36_ = display;
	g_signal_connect_object (_tmp36_, "window-left-monitor", (GCallback) _gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor, self, 0);
	_tmp37_ = self->priv->_workspace;
	g_signal_connect_object (_tmp37_, "window-added", (GCallback) _gala_workspace_clone_add_window_meta_workspace_window_added, self, 0);
	_tmp38_ = self->priv->_workspace;
	g_signal_connect_object (_tmp38_, "window-removed", (GCallback) _gala_workspace_clone_remove_window_meta_workspace_window_removed, self, 0);
	_tmp39_ = self->priv->background;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp39_);
	_tmp40_ = self->priv->_window_container;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp40_);
	_tmp41_ = self->priv->_workspace;
	_tmp42_ = meta_workspace_list_windows (_tmp41_);
	windows = _tmp42_;
	_tmp43_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp43_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
				MetaWindow* _tmp46_;
				MetaWindowType _tmp47_;
				MetaWindowType _tmp48_;
				_tmp46_ = window;
				_tmp47_ = meta_window_get_window_type (_tmp46_);
				_tmp48_ = _tmp47_;
				if (_tmp48_ == META_WINDOW_NORMAL) {
					MetaWindow* _tmp49_;
					gboolean _tmp50_;
					gboolean _tmp51_;
					_tmp49_ = window;
					g_object_get (_tmp49_, "on-all-workspaces", &_tmp50_, NULL);
					_tmp51_ = _tmp50_;
					_tmp45_ = !_tmp51_;
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					MetaWindow* _tmp52_;
					_tmp52_ = window;
					_tmp44_ = meta_window_is_on_primary_monitor (_tmp52_);
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					GalaWindowCloneContainer* _tmp53_;
					MetaWindow* _tmp54_;
					GalaIconGroup* _tmp55_;
					MetaWindow* _tmp56_;
					_tmp53_ = self->priv->_window_container;
					_tmp54_ = window;
					gala_window_clone_container_add_window (_tmp53_, _tmp54_);
					_tmp55_ = self->priv->_icon_group;
					_tmp56_ = window;
					gala_icon_group_add_window (_tmp55_, _tmp56_, TRUE, FALSE);
				}
			}
		}
	}
	_tmp57_ = gala_window_listener_get_default ();
	_tmp58_ = _g_object_ref0 (_tmp57_);
	listener = _tmp58_;
	_tmp59_ = listener;
	g_signal_connect_object (_tmp59_, "window-no-longer-on-all-workspaces", (GCallback) _gala_workspace_clone_add_window_gala_window_listener_window_no_longer_on_all_workspaces, self, 0);
	_g_object_unref0 (listener);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	_g_object_unref0 (background_drop_action);
	_g_object_unref0 (icons_drop_action);
	_g_object_unref0 (background_click_action);
	return obj;
}

static void
gala_workspace_clone_class_init (GalaWorkspaceCloneClass * klass,
                                 gpointer klass_data)
{
	gala_workspace_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWorkspaceClone_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_workspace_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_workspace_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_workspace_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_workspace_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WM_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY] = g_param_spec_object ("workspace", "workspace", "workspace", meta_workspace_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY] = g_param_spec_object ("gesture-tracker", "gesture-tracker", "gesture-tracker", GALA_TYPE_GESTURE_TRACKER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY] = g_param_spec_object ("icon-group", "icon-group", "icon-group", GALA_TYPE_ICON_GROUP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY] = g_param_spec_object ("window-container", "window-container", "window-container", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_CLONE_SCALE_FACTOR_PROPERTY, gala_workspace_clone_properties[GALA_WORKSPACE_CLONE_SCALE_FACTOR_PROPERTY] = g_param_spec_float ("scale-factor", "scale-factor", "scale-factor", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * A window has been selected, the MultitaskingView should consider activating
	         * and closing the view.
	         */
	gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_WORKSPACE_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
	/**
	         * The background has been selected. Switch to that workspace.
	         *
	         * @param close_view If the MultitaskingView should also consider closing itself
	         *                   after switching.
	         */
	gala_workspace_clone_signals[GALA_WORKSPACE_CLONE_SELECTED_SIGNAL] = g_signal_new ("selected", GALA_TYPE_WORKSPACE_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
gala_workspace_clone_instance_init (GalaWorkspaceClone * self,
                                    gpointer klass)
{
	self->priv = gala_workspace_clone_get_instance_private (self);
	self->priv->_scale_factor = 1.0f;
	self->priv->hover_activate_timeout = (guint) 0;
}

static void
gala_workspace_clone_finalize (GObject * obj)
{
	GalaWorkspaceClone * self;
	MetaDisplay* display = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	guint _tmp3_;
	MetaDisplay* _tmp4_;
	guint _tmp5_;
	MetaWorkspace* _tmp6_;
	guint _tmp7_;
	MetaWorkspace* _tmp8_;
	guint _tmp9_;
	GalaWindowListener* listener = NULL;
	GalaWindowListener* _tmp10_;
	GalaWindowListener* _tmp11_;
	GalaWindowListener* _tmp12_;
	guint _tmp13_;
	GalaBackgroundManager* _tmp14_;
	GalaWindowCloneContainer* _tmp15_;
	GalaIconGroup* _tmp16_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	g_signal_parse_name ("window-entered-monitor", meta_display_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gala_workspace_clone_window_entered_monitor_meta_display_window_entered_monitor, self);
	_tmp4_ = display;
	g_signal_parse_name ("window-left-monitor", meta_display_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _gala_workspace_clone_window_left_monitor_meta_display_window_left_monitor, self);
	_tmp6_ = self->priv->_workspace;
	g_signal_parse_name ("window-added", meta_workspace_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gala_workspace_clone_add_window_meta_workspace_window_added, self);
	_tmp8_ = self->priv->_workspace;
	g_signal_parse_name ("window-removed", meta_workspace_get_type (), &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _gala_workspace_clone_remove_window_meta_workspace_window_removed, self);
	_tmp10_ = gala_window_listener_get_default ();
	_tmp11_ = _g_object_ref0 (_tmp10_);
	listener = _tmp11_;
	_tmp12_ = listener;
	g_signal_parse_name ("window-no-longer-on-all-workspaces", GALA_TYPE_WINDOW_LISTENER, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _gala_workspace_clone_add_window_gala_window_listener_window_no_longer_on_all_workspaces, self);
	_tmp14_ = self->priv->background;
	clutter_actor_destroy ((ClutterActor*) _tmp14_);
	_tmp15_ = self->priv->_window_container;
	clutter_actor_destroy ((ClutterActor*) _tmp15_);
	_tmp16_ = self->priv->_icon_group;
	clutter_actor_destroy ((ClutterActor*) _tmp16_);
	_g_object_unref0 (listener);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_workspace);
	_g_object_unref0 (self->priv->_gesture_tracker);
	_g_object_unref0 (self->priv->_icon_group);
	_g_object_unref0 (self->priv->_window_container);
	_g_object_unref0 (self->priv->background);
	G_OBJECT_CLASS (gala_workspace_clone_parent_class)->finalize (obj);
}

/**
     * This is the container which manages a clone of the background which will
     * be scaled and animated inwards, a WindowCloneContainer for the windows on
     * this workspace and also holds the instance for this workspace's IconGroup.
     * The latter is not added to the WorkspaceClone itself though but to a container
     * of the MultitaskingView.
     */
static GType
gala_workspace_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWorkspaceCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_workspace_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWorkspaceClone), 0, (GInstanceInitFunc) gala_workspace_clone_instance_init, NULL };
	GType gala_workspace_clone_type_id;
	gala_workspace_clone_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWorkspaceClone", &g_define_type_info, 0);
	GalaWorkspaceClone_private_offset = g_type_add_instance_private (gala_workspace_clone_type_id, sizeof (GalaWorkspaceClonePrivate));
	return gala_workspace_clone_type_id;
}

GType
gala_workspace_clone_get_type (void)
{
	static volatile gsize gala_workspace_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_workspace_clone_type_id__once)) {
		GType gala_workspace_clone_type_id;
		gala_workspace_clone_type_id = gala_workspace_clone_get_type_once ();
		g_once_init_leave (&gala_workspace_clone_type_id__once, gala_workspace_clone_type_id);
	}
	return gala_workspace_clone_type_id__once;
}

static void
_vala_gala_workspace_clone_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWorkspaceClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	switch (property_id) {
		case GALA_WORKSPACE_CLONE_WM_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_wm (self));
		break;
		case GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_workspace (self));
		break;
		case GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_gesture_tracker (self));
		break;
		case GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_icon_group (self));
		break;
		case GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY:
		g_value_set_object (value, gala_workspace_clone_get_window_container (self));
		break;
		case GALA_WORKSPACE_CLONE_SCALE_FACTOR_PROPERTY:
		g_value_set_float (value, gala_workspace_clone_get_scale_factor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_workspace_clone_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWorkspaceClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
	switch (property_id) {
		case GALA_WORKSPACE_CLONE_WM_PROPERTY:
		gala_workspace_clone_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_WORKSPACE_PROPERTY:
		gala_workspace_clone_set_workspace (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_GESTURE_TRACKER_PROPERTY:
		gala_workspace_clone_set_gesture_tracker (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_ICON_GROUP_PROPERTY:
		gala_workspace_clone_set_icon_group (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_WINDOW_CONTAINER_PROPERTY:
		gala_workspace_clone_set_window_container (self, g_value_get_object (value));
		break;
		case GALA_WORKSPACE_CLONE_SCALE_FACTOR_PROPERTY:
		gala_workspace_clone_set_scale_factor (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

