/* WindowSwitcherIcon.c generated by valac 0.56.16, the Vala compiler
 * generated from WindowSwitcherIcon.vala, do not modify */

/*
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib-object.h>
#include <meta/window.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <clutter/clutter.h>
#include <gdk/gdk.h>
#include <string.h>

#define GALA_WINDOW_SWITCHER_ICON_WRAPPER_BORDER_RADIUS 3
#define GALA_WINDOW_SWITCHER_ICON_SIZE 64
#define GALA_WINDOW_SWITCHER_WRAPPER_PADDING 12
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_SWITCHER_ICON (gala_window_switcher_icon_get_type ())
#define GALA_WINDOW_SWITCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon))
#define GALA_WINDOW_SWITCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIconClass))
#define GALA_IS_WINDOW_SWITCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON))
#define GALA_IS_WINDOW_SWITCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_SWITCHER_ICON))
#define GALA_WINDOW_SWITCHER_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIconClass))

typedef struct _GalaWindowSwitcherIcon GalaWindowSwitcherIcon;
typedef struct _GalaWindowSwitcherIconClass GalaWindowSwitcherIconClass;
typedef struct _GalaWindowSwitcherIconPrivate GalaWindowSwitcherIconPrivate;
enum  {
	GALA_WINDOW_SWITCHER_ICON_0_PROPERTY,
	GALA_WINDOW_SWITCHER_ICON_WINDOW_PROPERTY,
	GALA_WINDOW_SWITCHER_ICON_SELECTED_PROPERTY,
	GALA_WINDOW_SWITCHER_ICON_SCALE_FACTOR_PROPERTY,
	GALA_WINDOW_SWITCHER_ICON_NUM_PROPERTIES
};
static GParamSpec* gala_window_switcher_icon_properties[GALA_WINDOW_SWITCHER_ICON_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaWindowSwitcherIcon {
	GalaCanvasActor parent_instance;
	GalaWindowSwitcherIconPrivate * priv;
};

struct _GalaWindowSwitcherIconClass {
	GalaCanvasActorClass parent_class;
};

struct _GalaWindowSwitcherIconPrivate {
	MetaWindow* _window;
	GalaWindowIcon* icon;
	gboolean _selected;
	gfloat _scale_factor;
};

static gint GalaWindowSwitcherIcon_private_offset;
static gpointer gala_window_switcher_icon_parent_class = NULL;

VALA_EXTERN GType gala_window_switcher_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowSwitcherIcon, g_object_unref)
VALA_EXTERN GalaWindowSwitcherIcon* gala_window_switcher_icon_new (MetaWindow* window,
                                                       gint icon_size,
                                                       gfloat scale_factor);
VALA_EXTERN GalaWindowSwitcherIcon* gala_window_switcher_icon_construct (GType object_type,
                                                             MetaWindow* window,
                                                             gint icon_size,
                                                             gfloat scale_factor);
VALA_EXTERN gint gala_internal_utils_scale_to_int (gint value,
                                       gfloat scale_factor);
VALA_EXTERN void gala_window_switcher_icon_set_scale_factor (GalaWindowSwitcherIcon* self,
                                                 gfloat value);
static void gala_window_switcher_icon_update_size (GalaWindowSwitcherIcon* self);
VALA_EXTERN gfloat gala_window_switcher_icon_get_scale_factor (GalaWindowSwitcherIcon* self);
static void gala_window_switcher_icon_real_draw (GalaCanvasActor* base,
                                          cairo_t* ctx,
                                          gint width,
                                          gint height);
VALA_EXTERN gboolean gala_window_switcher_icon_get_selected (GalaWindowSwitcherIcon* self);
VALA_EXTERN void gala_internal_utils_get_theme_accent_color (GdkRGBA* result);
VALA_EXTERN MetaWindow* gala_window_switcher_icon_get_window (GalaWindowSwitcherIcon* self);
static void gala_window_switcher_icon_set_window (GalaWindowSwitcherIcon* self,
                                           MetaWindow* value);
VALA_EXTERN void gala_window_switcher_icon_set_selected (GalaWindowSwitcherIcon* self,
                                             gboolean value);
static void gala_window_switcher_icon_finalize (GObject * obj);
static GType gala_window_switcher_icon_get_type_once (void);
static void _vala_gala_window_switcher_icon_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_gala_window_switcher_icon_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_window_switcher_icon_get_instance_private (GalaWindowSwitcherIcon* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowSwitcherIcon_private_offset);
}

GalaWindowSwitcherIcon*
gala_window_switcher_icon_construct (GType object_type,
                                     MetaWindow* window,
                                     gint icon_size,
                                     gfloat scale_factor)
{
	GalaWindowSwitcherIcon * self = NULL;
	GalaWindowIcon* _tmp0_;
	GalaWindowIcon* _tmp1_;
	ClutterAlignConstraint* _tmp2_;
	ClutterAlignConstraint* _tmp3_;
	GalaWindowIcon* _tmp4_;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaWindowSwitcherIcon*) g_object_new (object_type, "window", window, NULL);
	_tmp0_ = gala_window_icon_new (window, gala_internal_utils_scale_to_int (icon_size, scale_factor), 1);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp0_;
	_tmp1_ = self->priv->icon;
	_tmp2_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_BOTH, 0.5f);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp1_, (ClutterConstraint*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->icon;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp4_);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	gala_window_switcher_icon_set_scale_factor (self, scale_factor);
	return self;
}

GalaWindowSwitcherIcon*
gala_window_switcher_icon_new (MetaWindow* window,
                               gint icon_size,
                               gfloat scale_factor)
{
	return gala_window_switcher_icon_construct (GALA_TYPE_WINDOW_SWITCHER_ICON, window, icon_size, scale_factor);
}

static void
gala_window_switcher_icon_update_size (GalaWindowSwitcherIcon* self)
{
	gint indicator_size = 0;
	gfloat _tmp0_;
	gfloat _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_window_switcher_icon_get_scale_factor (self);
	_tmp1_ = _tmp0_;
	indicator_size = gala_internal_utils_scale_to_int (GALA_WINDOW_SWITCHER_ICON_SIZE + (GALA_WINDOW_SWITCHER_WRAPPER_PADDING * 2), _tmp1_);
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) indicator_size, (gfloat) indicator_size);
}

static void
gala_window_switcher_icon_real_draw (GalaCanvasActor* base,
                                     cairo_t* ctx,
                                     gint width,
                                     gint height)
{
	GalaWindowSwitcherIcon * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (GalaWindowSwitcherIcon*) base;
	g_return_if_fail (ctx != NULL);
	cairo_save (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_clip (ctx);
	cairo_reset_clip (ctx);
	_tmp0_ = gala_window_switcher_icon_get_selected (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GdkRGBA rgba = {0};
		GdkRGBA _tmp2_ = {0};
		GdkRGBA _tmp3_;
		GdkRGBA _tmp4_;
		GdkRGBA _tmp5_;
		GdkRGBA _tmp6_;
		gint rect_radius = 0;
		gfloat _tmp7_;
		gfloat _tmp8_;
		gala_internal_utils_get_theme_accent_color (&_tmp2_);
		rgba = _tmp2_;
		_tmp3_ = rgba;
		_tmp4_ = rgba;
		_tmp5_ = rgba;
		_tmp6_ = rgba;
		cairo_set_source_rgba (ctx, _tmp3_.red, _tmp4_.green, _tmp5_.blue, _tmp6_.alpha);
		_tmp7_ = gala_window_switcher_icon_get_scale_factor (self);
		_tmp8_ = _tmp7_;
		rect_radius = gala_internal_utils_scale_to_int (GALA_WINDOW_SWITCHER_ICON_WRAPPER_BORDER_RADIUS, _tmp8_);
		gala_drawing_utilities_cairo_rounded_rectangle (ctx, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height, (gdouble) rect_radius);
		cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
		cairo_fill (ctx);
		cairo_restore (ctx);
	}
}

MetaWindow*
gala_window_switcher_icon_get_window (GalaWindowSwitcherIcon* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_window_switcher_icon_set_window (GalaWindowSwitcherIcon* self,
                                      MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_icon_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_icon_properties[GALA_WINDOW_SWITCHER_ICON_WINDOW_PROPERTY]);
	}
}

gboolean
gala_window_switcher_icon_get_selected (GalaWindowSwitcherIcon* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selected;
	return result;
}

void
gala_window_switcher_icon_set_selected (GalaWindowSwitcherIcon* self,
                                        gboolean value)
{
	ClutterContent* _tmp0_;
	ClutterContent* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_selected = value;
	_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	clutter_content_invalidate (_tmp1_);
	g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_icon_properties[GALA_WINDOW_SWITCHER_ICON_SELECTED_PROPERTY]);
}

gfloat
gala_window_switcher_icon_get_scale_factor (GalaWindowSwitcherIcon* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_scale_factor;
	return result;
}

void
gala_window_switcher_icon_set_scale_factor (GalaWindowSwitcherIcon* self,
                                            gfloat value)
{
	g_return_if_fail (self != NULL);
	self->priv->_scale_factor = value;
	gala_window_switcher_icon_update_size (self);
	g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_icon_properties[GALA_WINDOW_SWITCHER_ICON_SCALE_FACTOR_PROPERTY]);
}

static void
gala_window_switcher_icon_class_init (GalaWindowSwitcherIconClass * klass,
                                      gpointer klass_data)
{
	gala_window_switcher_icon_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowSwitcherIcon_private_offset);
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_window_switcher_icon_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_switcher_icon_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_switcher_icon_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_window_switcher_icon_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_ICON_WINDOW_PROPERTY, gala_window_switcher_icon_properties[GALA_WINDOW_SWITCHER_ICON_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_ICON_SELECTED_PROPERTY, gala_window_switcher_icon_properties[GALA_WINDOW_SWITCHER_ICON_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_ICON_SCALE_FACTOR_PROPERTY, gala_window_switcher_icon_properties[GALA_WINDOW_SWITCHER_ICON_SCALE_FACTOR_PROPERTY] = g_param_spec_float ("scale-factor", "scale-factor", "scale-factor", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gala_window_switcher_icon_instance_init (GalaWindowSwitcherIcon * self,
                                         gpointer klass)
{
	self->priv = gala_window_switcher_icon_get_instance_private (self);
	self->priv->_selected = FALSE;
	self->priv->_scale_factor = 1.0f;
}

static void
gala_window_switcher_icon_finalize (GObject * obj)
{
	GalaWindowSwitcherIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon);
	_g_object_unref0 (self->priv->_window);
	_g_object_unref0 (self->priv->icon);
	G_OBJECT_CLASS (gala_window_switcher_icon_parent_class)->finalize (obj);
}

static GType
gala_window_switcher_icon_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowSwitcherIconClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_switcher_icon_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowSwitcherIcon), 0, (GInstanceInitFunc) gala_window_switcher_icon_instance_init, NULL };
	GType gala_window_switcher_icon_type_id;
	gala_window_switcher_icon_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaWindowSwitcherIcon", &g_define_type_info, 0);
	GalaWindowSwitcherIcon_private_offset = g_type_add_instance_private (gala_window_switcher_icon_type_id, sizeof (GalaWindowSwitcherIconPrivate));
	return gala_window_switcher_icon_type_id;
}

GType
gala_window_switcher_icon_get_type (void)
{
	static volatile gsize gala_window_switcher_icon_type_id__once = 0;
	if (g_once_init_enter (&gala_window_switcher_icon_type_id__once)) {
		GType gala_window_switcher_icon_type_id;
		gala_window_switcher_icon_type_id = gala_window_switcher_icon_get_type_once ();
		g_once_init_leave (&gala_window_switcher_icon_type_id__once, gala_window_switcher_icon_type_id);
	}
	return gala_window_switcher_icon_type_id__once;
}

static void
_vala_gala_window_switcher_icon_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	GalaWindowSwitcherIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_ICON_WINDOW_PROPERTY:
		g_value_set_object (value, gala_window_switcher_icon_get_window (self));
		break;
		case GALA_WINDOW_SWITCHER_ICON_SELECTED_PROPERTY:
		g_value_set_boolean (value, gala_window_switcher_icon_get_selected (self));
		break;
		case GALA_WINDOW_SWITCHER_ICON_SCALE_FACTOR_PROPERTY:
		g_value_set_float (value, gala_window_switcher_icon_get_scale_factor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_switcher_icon_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	GalaWindowSwitcherIcon * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_ICON_WINDOW_PROPERTY:
		gala_window_switcher_icon_set_window (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_SWITCHER_ICON_SELECTED_PROPERTY:
		gala_window_switcher_icon_set_selected (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_SWITCHER_ICON_SCALE_FACTOR_PROPERTY:
		gala_window_switcher_icon_set_scale_factor (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

