/* WindowSwitcher.c generated by valac 0.56.16, the Vala compiler
 * generated from WindowSwitcher.vala, do not modify */

/*
 * Copyright 2021 Aral Balkan <mail@ar.al>
 * Copyright 2020 Mark Story <mark@mark-story.com>
 * Copyright 2017 Popye <sailor3101@gmail.com>
 * Copyright 2014 Tom Beckmann
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <granite.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <mtk/mtk.h>
#include <gdk/gdk.h>
#include <meta/window.h>
#include <meta/keybindings.h>
#include <meta/workspace.h>
#include <meta/meta-workspace-manager.h>
#include <meta/prefs.h>
#include <meta/meta-cursor-tracker.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#define GALA_WINDOW_SWITCHER_ICON_SIZE 64
#define GALA_WINDOW_SWITCHER_WRAPPER_PADDING 12
#define GALA_WINDOW_SWITCHER_CAPTION_FONT_NAME "Inter"
#define GALA_WINDOW_SWITCHER_MIN_OFFSET 64
#define GALA_WINDOW_SWITCHER_ANIMATION_DURATION 200
#define GALA_WINDOW_SWITCHER_GESTURE_RANGE_LIMIT 10
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_SWITCHER (gala_window_switcher_get_type ())
#define GALA_WINDOW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher))
#define GALA_WINDOW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcherClass))
#define GALA_IS_WINDOW_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_SWITCHER))
#define GALA_IS_WINDOW_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_SWITCHER))
#define GALA_WINDOW_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcherClass))

typedef struct _GalaWindowSwitcher GalaWindowSwitcher;
typedef struct _GalaWindowSwitcherClass GalaWindowSwitcherClass;
typedef struct _GalaWindowSwitcherPrivate GalaWindowSwitcherPrivate;

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;

#define GALA_TYPE_WINDOW_SWITCHER_ICON (gala_window_switcher_icon_get_type ())
#define GALA_WINDOW_SWITCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon))
#define GALA_WINDOW_SWITCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIconClass))
#define GALA_IS_WINDOW_SWITCHER_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON))
#define GALA_IS_WINDOW_SWITCHER_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_SWITCHER_ICON))
#define GALA_WINDOW_SWITCHER_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIconClass))

typedef struct _GalaWindowSwitcherIcon GalaWindowSwitcherIcon;
typedef struct _GalaWindowSwitcherIconClass GalaWindowSwitcherIconClass;
enum  {
	GALA_WINDOW_SWITCHER_0_PROPERTY,
	GALA_WINDOW_SWITCHER_WM_PROPERTY,
	GALA_WINDOW_SWITCHER_GESTURE_TRACKER_PROPERTY,
	GALA_WINDOW_SWITCHER_OPENED_PROPERTY,
	GALA_WINDOW_SWITCHER_NUM_PROPERTIES
};
static GParamSpec* gala_window_switcher_properties[GALA_WINDOW_SWITCHER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_ClutterColor_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterColor_free (var), NULL)))
typedef enum  {
	GALA_GESTURE_DIRECTION_UNKNOWN = 0,
	GALA_GESTURE_DIRECTION_UP = 1,
	GALA_GESTURE_DIRECTION_DOWN = 2,
	GALA_GESTURE_DIRECTION_LEFT = 3,
	GALA_GESTURE_DIRECTION_RIGHT = 4,
	GALA_GESTURE_DIRECTION_IN = 5,
	GALA_GESTURE_DIRECTION_OUT = 6
} GalaGestureDirection;

#define GALA_TYPE_GESTURE_DIRECTION (gala_gesture_direction_get_type ())
typedef struct _Block71Data Block71Data;
typedef void (*GalaGestureTrackerOnUpdate) (gdouble percentage, gpointer user_data);
typedef void (*GalaGestureTrackerOnEnd) (gdouble percentage, gboolean cancel_action, gint calculated_duration, gpointer user_data);
typedef void (*GalaGestureTrackerOnBegin) (gdouble percentage, gpointer user_data);

#define GALA_TYPE_WINDOW_TRACKER (gala_window_tracker_get_type ())
#define GALA_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTracker))
#define GALA_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))
#define GALA_IS_WINDOW_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_TRACKER))
#define GALA_IS_WINDOW_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_TRACKER))
#define GALA_WINDOW_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_TRACKER, GalaWindowTrackerClass))

typedef struct _GalaWindowTracker GalaWindowTracker;
typedef struct _GalaWindowTrackerClass GalaWindowTrackerClass;

#define GALA_TYPE_WINDOW_MANAGER_GALA (gala_window_manager_gala_get_type ())
#define GALA_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala))
#define GALA_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))
#define GALA_IS_WINDOW_MANAGER_GALA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_IS_WINDOW_MANAGER_GALA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_MANAGER_GALA))
#define GALA_WINDOW_MANAGER_GALA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGalaClass))

typedef struct _GalaWindowManagerGala GalaWindowManagerGala;
typedef struct _GalaWindowManagerGalaClass GalaWindowManagerGalaClass;
typedef struct _Block72Data Block72Data;

struct _GalaWindowSwitcher {
	GalaCanvasActor parent_instance;
	GalaWindowSwitcherPrivate * priv;
};

struct _GalaWindowSwitcherClass {
	GalaCanvasActorClass parent_class;
};

struct _GalaWindowSwitcherPrivate {
	GalaWindowManager* _wm;
	GalaGestureTracker* _gesture_tracker;
	gboolean _opened;
	gboolean handling_gesture;
	gint modifier_mask;
	GalaModalProxy* modal_proxy;
	GraniteSettings* granite_settings;
	ClutterActor* container;
	ClutterText* caption;
	GalaShadowEffect* shadow_effect;
	GalaWindowSwitcherIcon* _current_icon;
	gfloat scaling_factor;
};

struct _Block71Data {
	int _ref_count_;
	GalaWindowSwitcher* self;
	gint last_window_index;
	GalaGestureDirection direction;
};

struct _Block72Data {
	int _ref_count_;
	GalaWindowSwitcher* self;
	GalaWindowSwitcherIcon* icon;
};

static gint GalaWindowSwitcher_private_offset;
static gpointer gala_window_switcher_parent_class = NULL;

VALA_EXTERN GType gala_window_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowSwitcher, g_object_unref)
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
VALA_EXTERN GType gala_window_switcher_icon_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowSwitcherIcon, g_object_unref)
VALA_EXTERN GalaWindowSwitcher* gala_window_switcher_new (GalaWindowManager* wm,
                                              GalaGestureTracker* gesture_tracker);
VALA_EXTERN GalaWindowSwitcher* gala_window_switcher_construct (GType object_type,
                                                    GalaWindowManager* wm,
                                                    GalaGestureTracker* gesture_tracker);
static void gala_window_switcher_scale (GalaWindowSwitcher* self);
VALA_EXTERN GalaWindowManager* gala_window_switcher_get_wm (GalaWindowSwitcher* self);
VALA_EXTERN gint gala_internal_utils_scale_to_int (gint value,
                                       gfloat scale_factor);
static void gala_window_switcher_real_get_preferred_width (ClutterActor* base,
                                                    gfloat for_height,
                                                    gfloat* min_width,
                                                    gfloat* natural_width);
static void gala_window_switcher_real_draw (GalaCanvasActor* base,
                                     cairo_t* ctx,
                                     gint width,
                                     gint height);
static void _vala_ClutterColor_free (ClutterColor* self);
VALA_EXTERN void gala_window_switcher_handle_switch_windows (MetaDisplay* display,
                                                 MetaWindow* window,
                                                 ClutterKeyEvent* event,
                                                 MetaKeyBinding* binding,
                                                 GalaWindowSwitcher* self);
VALA_EXTERN gboolean gala_window_switcher_get_opened (GalaWindowSwitcher* self);
static gboolean gala_window_switcher_collect_current_windows (GalaWindowSwitcher* self,
                                                       MetaDisplay* display,
                                                       MetaWorkspace* workspace);
static gboolean gala_window_switcher_collect_all_windows (GalaWindowSwitcher* self,
                                                   MetaDisplay* display,
                                                   MetaWorkspace* workspace);
static void gala_window_switcher_open_switcher (GalaWindowSwitcher* self);
static void gala_window_switcher_next_window (GalaWindowSwitcher* self,
                                       gboolean backward);
VALA_EXTERN GType gala_gesture_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void gala_window_switcher_handle_gesture (GalaWindowSwitcher* self,
                                          GalaGestureDirection direction);
static Block71Data* block71_data_ref (Block71Data* _data71_);
static void block71_data_unref (void * _userdata_);
static void __lambda84_ (Block71Data* _data71_,
                  gdouble percentage);
VALA_EXTERN gfloat gala_gesture_tracker_animation_value (gfloat initial_value,
                                             gfloat target_value,
                                             gdouble percentage,
                                             gboolean rounded);
static void ___lambda84__gala_gesture_tracker_on_update (gdouble percentage,
                                                  gpointer self);
static void __lambda85_ (GalaWindowSwitcher* self,
                  gdouble percentage,
                  gboolean cancel_action,
                  gint calculated_duration);
static void gala_window_switcher_close_switcher (GalaWindowSwitcher* self,
                                          guint32 time,
                                          gboolean cancel);
static void ___lambda85__gala_gesture_tracker_on_end (gdouble percentage,
                                               gboolean cancel_action,
                                               gint calculated_duration,
                                               gpointer self);
VALA_EXTERN GalaGestureTracker* gala_window_switcher_get_gesture_tracker (GalaWindowSwitcher* self);
VALA_EXTERN void gala_gesture_tracker_connect_handlers (GalaGestureTracker* self,
                                            GalaGestureTrackerOnBegin on_begin_handler,
                                            gpointer on_begin_handler_target,
                                            GDestroyNotify on_begin_handler_target_destroy_notify,
                                            GalaGestureTrackerOnUpdate on_update_handler,
                                            gpointer on_update_handler_target,
                                            GDestroyNotify on_update_handler_target_destroy_notify,
                                            GalaGestureTrackerOnEnd on_end_handler,
                                            gpointer on_end_handler_target,
                                            GDestroyNotify on_end_handler_target_destroy_notify);
static void gala_window_switcher_set_current_icon (GalaWindowSwitcher* self,
                                            GalaWindowSwitcherIcon* value);
VALA_EXTERN GalaWindowSwitcherIcon* gala_window_switcher_icon_new (MetaWindow* window,
                                                       gint icon_size,
                                                       gfloat scale_factor);
VALA_EXTERN GalaWindowSwitcherIcon* gala_window_switcher_icon_construct (GType object_type,
                                                             MetaWindow* window,
                                                             gint icon_size,
                                                             gfloat scale_factor);
static void gala_window_switcher_add_icon (GalaWindowSwitcher* self,
                                    GalaWindowSwitcherIcon* icon);
VALA_EXTERN GType gala_window_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowTracker, g_object_unref)
VALA_EXTERN GType gala_window_manager_gala_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowManagerGala, g_object_unref)
VALA_EXTERN GalaWindowTracker* gala_window_manager_gala_get_window_tracker (GalaWindowManagerGala* self);
VALA_EXTERN GalaApp* gala_window_tracker_get_app_for_window (GalaWindowTracker* self,
                                                 MetaWindow* window);
static Block72Data* block72_data_ref (Block72Data* _data72_);
static void block72_data_unref (void * _userdata_);
static gboolean __lambda82_ (Block72Data* _data72_);
static GalaWindowSwitcherIcon* gala_window_switcher_get_current_icon (GalaWindowSwitcher* self);
static gboolean ___lambda82__clutter_actor_motion_event (ClutterActor* _sender,
                                                  ClutterEvent* event,
                                                  gpointer self);
static void gala_window_switcher_toggle_display (GalaWindowSwitcher* self,
                                          gboolean show);
static void gala_window_switcher_set_opened (GalaWindowSwitcher* self,
                                      gboolean value);
static void gala_window_switcher_push_modal (GalaWindowSwitcher* self);
static gboolean __lambda83_ (GalaWindowSwitcher* self,
                      MetaKeyBinding* binding);
static gboolean ___lambda83__gala_keybinding_filter (MetaKeyBinding* binding,
                                              gpointer self);
VALA_EXTERN MetaWindow* gala_window_switcher_icon_get_window (GalaWindowSwitcherIcon* self);
static void gala_window_switcher_update_caption_text (GalaWindowSwitcher* self);
static void gala_window_switcher_real_key_focus_out (ClutterActor* base);
static gboolean gala_window_switcher_container_mouse_release (GalaWindowSwitcher* self,
                                                       ClutterEvent* event);
static gboolean gala_window_switcher_real_key_release_event (ClutterActor* base,
                                                      ClutterEvent* event);
static inline ClutterModifierType gala_window_switcher_get_current_modifiers (GalaWindowSwitcher* self);
static gboolean gala_window_switcher_real_key_press_event (ClutterActor* base,
                                                    ClutterEvent* event);
static void gala_window_switcher_set_wm (GalaWindowSwitcher* self,
                                  GalaWindowManager* value);
static void gala_window_switcher_set_gesture_tracker (GalaWindowSwitcher* self,
                                               GalaGestureTracker* value);
VALA_EXTERN void gala_window_switcher_icon_set_selected (GalaWindowSwitcherIcon* self,
                                             gboolean value);
static GObject * gala_window_switcher_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static gboolean _gala_window_switcher_container_mouse_release_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                                           ClutterEvent* event,
                                                                                           gpointer self);
static void _clutter_content_invalidate_g_object_notify (GObject* _sender,
                                                  GParamSpec* pspec,
                                                  gpointer self);
static void _gala_window_switcher_scale_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                        gpointer self);
static void gala_window_switcher_finalize (GObject * obj);
static GType gala_window_switcher_get_type_once (void);
static void _vala_gala_window_switcher_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_window_switcher_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_window_switcher_get_instance_private (GalaWindowSwitcher* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowSwitcher_private_offset);
}

GalaWindowSwitcher*
gala_window_switcher_construct (GType object_type,
                                GalaWindowManager* wm,
                                GalaGestureTracker* gesture_tracker)
{
	GalaWindowSwitcher * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (gesture_tracker != NULL, NULL);
	self = (GalaWindowSwitcher*) g_object_new (object_type, "wm", wm, "gesture-tracker", gesture_tracker, NULL);
	return self;
}

GalaWindowSwitcher*
gala_window_switcher_new (GalaWindowManager* wm,
                          GalaGestureTracker* gesture_tracker)
{
	return gala_window_switcher_construct (GALA_TYPE_WINDOW_SWITCHER, wm, gesture_tracker);
}

static void
gala_window_switcher_scale (GalaWindowSwitcher* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	GalaShadowEffect* _tmp4_;
	gint margin = 0;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterText* _tmp9_;
	ClutterText* _tmp10_;
	ClutterText* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	self->priv->scaling_factor = meta_display_get_monitor_scale (_tmp1_, meta_display_get_current_monitor (_tmp3_));
	_tmp4_ = self->priv->shadow_effect;
	gala_shadow_effect_set_scale_factor (_tmp4_, self->priv->scaling_factor);
	margin = gala_internal_utils_scale_to_int (GALA_WINDOW_SWITCHER_WRAPPER_PADDING, self->priv->scaling_factor);
	_tmp5_ = self->priv->container;
	clutter_actor_set_margin_left (_tmp5_, (gfloat) margin);
	_tmp6_ = self->priv->container;
	clutter_actor_set_margin_right (_tmp6_, (gfloat) margin);
	_tmp7_ = self->priv->container;
	clutter_actor_set_margin_bottom (_tmp7_, (gfloat) margin);
	_tmp8_ = self->priv->container;
	clutter_actor_set_margin_top (_tmp8_, (gfloat) margin);
	_tmp9_ = self->priv->caption;
	clutter_actor_set_margin_left ((ClutterActor*) _tmp9_, (gfloat) margin);
	_tmp10_ = self->priv->caption;
	clutter_actor_set_margin_right ((ClutterActor*) _tmp10_, (gfloat) margin);
	_tmp11_ = self->priv->caption;
	clutter_actor_set_margin_bottom ((ClutterActor*) _tmp11_, (gfloat) margin);
}

static void
gala_window_switcher_real_get_preferred_width (ClutterActor* base,
                                               gfloat for_height,
                                               gfloat* min_width,
                                               gfloat* natural_width)
{
	GalaWindowSwitcher * self;
	gfloat _vala_min_width = 0.0F;
	gfloat _vala_natural_width = 0.0F;
	gfloat preferred_nat_width = 0.0F;
	gfloat _tmp0_ = 0.0F;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	gint monitor = 0;
	MtkRectangle geom = {0};
	MtkRectangle _tmp3_ = {0};
	gfloat container_nat_width = 0.0F;
	ClutterActor* _tmp4_;
	gfloat _tmp5_ = 0.0F;
	gfloat max_width = 0.0F;
	MtkRectangle _tmp6_;
	self = (GalaWindowSwitcher*) base;
	_vala_min_width = (gfloat) 0;
	CLUTTER_ACTOR_CLASS (gala_window_switcher_parent_class)->get_preferred_width ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_CANVAS_ACTOR, GalaCanvasActor), for_height, NULL, &_tmp0_);
	preferred_nat_width = _tmp0_;
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	display = _tmp2_;
	monitor = meta_display_get_current_monitor (display);
	meta_display_get_monitor_geometry (display, monitor, &_tmp3_);
	geom = _tmp3_;
	_tmp4_ = self->priv->container;
	clutter_actor_get_preferred_size (_tmp4_, NULL, NULL, &_tmp5_, NULL);
	container_nat_width = _tmp5_;
	_tmp6_ = geom;
	max_width = MIN ((gfloat) (_tmp6_.width - (gala_internal_utils_scale_to_int (GALA_WINDOW_SWITCHER_MIN_OFFSET, self->priv->scaling_factor) * 2)), container_nat_width);
	_vala_natural_width = MIN (max_width, preferred_nat_width);
	if (min_width) {
		*min_width = _vala_min_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}

static ClutterColor*
_vala_clutter_color_from_string (const gchar* str)
{
	ClutterColor* color = NULL;
	ClutterColor* _tmp0_;
	ClutterColor* result;
	g_return_val_if_fail (str != NULL, NULL);
	_tmp0_ = clutter_color_alloc ();
	color = _tmp0_;
	clutter_color_from_string (color, str);
	result = color;
	return result;
}

static void
_vala_ClutterColor_free (ClutterColor* self)
{
	g_boxed_free (clutter_color_get_type (), self);
}

static void
gala_window_switcher_real_draw (GalaCanvasActor* base,
                                cairo_t* ctx,
                                gint width,
                                gint height)
{
	GalaWindowSwitcher * self;
	gchar* caption_color = NULL;
	gchar* _tmp0_;
	GraniteSettings* _tmp1_;
	GraniteSettingsColorScheme _tmp2_;
	GraniteSettingsColorScheme _tmp3_;
	ClutterText* _tmp5_;
	const gchar* _tmp6_;
	ClutterColor* _tmp7_;
	ClutterColor* _tmp8_;
	ClutterColor _tmp9_;
	GdkRGBA background_color = {0};
	GraniteSettings* _tmp10_;
	GraniteSettingsColorScheme _tmp11_;
	GraniteSettingsColorScheme _tmp12_;
	GdkRGBA _tmp13_;
	GdkRGBA _tmp14_;
	GdkRGBA _tmp15_;
	GdkRGBA _tmp16_;
	self = (GalaWindowSwitcher*) base;
	g_return_if_fail (ctx != NULL);
	_tmp0_ = g_strdup ("#2e2e31");
	caption_color = _tmp0_;
	_tmp1_ = self->priv->granite_settings;
	_tmp2_ = granite_settings_get_prefers_color_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("#fafafa");
		_g_free0 (caption_color);
		caption_color = _tmp4_;
	}
	_tmp5_ = self->priv->caption;
	_tmp6_ = caption_color;
	_tmp7_ = _vala_clutter_color_from_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = *_tmp8_;
	clutter_text_set_color (_tmp5_, &_tmp9_);
	__vala_ClutterColor_free0 (_tmp8_);
	cairo_save (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_clip (ctx);
	cairo_reset_clip (ctx);
	background_color = GALA_DRAWING_COLOR_LIGHT_BACKGROUND;
	_tmp10_ = self->priv->granite_settings;
	_tmp11_ = granite_settings_get_prefers_color_scheme (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK) {
		background_color = GALA_DRAWING_COLOR_DARK_BACKGROUND;
	}
	cairo_set_operator (ctx, CAIRO_OPERATOR_SOURCE);
	_tmp13_ = background_color;
	_tmp14_ = background_color;
	_tmp15_ = background_color;
	_tmp16_ = background_color;
	cairo_set_source_rgba (ctx, _tmp13_.red, _tmp14_.green, _tmp15_.blue, _tmp16_.alpha);
	gala_drawing_utilities_cairo_rounded_rectangle (ctx, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height, (gdouble) gala_internal_utils_scale_to_int (6, self->priv->scaling_factor));
	cairo_fill (ctx);
	cairo_restore (ctx);
	_g_free0 (caption_color);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gala_window_switcher_handle_switch_windows (MetaDisplay* display,
                                            MetaWindow* window,
                                            ClutterKeyEvent* event,
                                            MetaKeyBinding* binding,
                                            GalaWindowSwitcher* self)
{
	MetaWorkspace* workspace = NULL;
	MetaWorkspaceManager* _tmp0_;
	MetaWorkspace* _tmp1_;
	MetaWorkspace* _tmp2_;
	guint mask = 0U;
	gboolean _tmp3_;
	gchar* binding_name = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean backward = FALSE;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (event != NULL);
	g_return_if_fail (binding != NULL);
	if (self->priv->handling_gesture) {
		return;
	}
	_tmp0_ = meta_display_get_workspace_manager (display);
	_tmp1_ = meta_workspace_manager_get_active_workspace (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	workspace = _tmp2_;
	mask = meta_key_binding_get_mask (binding);
	if (mask == ((guint) 0)) {
		self->priv->modifier_mask = 0;
	} else {
		self->priv->modifier_mask = 1;
		while (TRUE) {
			if (!(mask > ((guint) 1))) {
				break;
			}
			mask >>= (guint) 1;
			self->priv->modifier_mask = self->priv->modifier_mask << 1;
		}
	}
	_tmp3_ = self->priv->_opened;
	if (!_tmp3_) {
		gboolean windows_exist = FALSE;
		const gchar* _tmp4_;
		_tmp4_ = meta_key_binding_get_name (binding);
		if (g_str_has_prefix (_tmp4_, "switch-group")) {
			MetaWorkspace* _tmp5_;
			_tmp5_ = workspace;
			windows_exist = gala_window_switcher_collect_current_windows (self, display, _tmp5_);
		} else {
			MetaWorkspace* _tmp6_;
			_tmp6_ = workspace;
			windows_exist = gala_window_switcher_collect_all_windows (self, display, _tmp6_);
		}
		if (!windows_exist) {
			_g_object_unref0 (workspace);
			return;
		}
		gala_window_switcher_open_switcher (self);
	}
	_tmp7_ = meta_key_binding_get_name (binding);
	_tmp8_ = g_strdup (_tmp7_);
	binding_name = _tmp8_;
	_tmp9_ = binding_name;
	backward = g_str_has_suffix (_tmp9_, "-backward");
	gala_window_switcher_next_window (self, backward);
	_g_free0 (binding_name);
	_g_object_unref0 (workspace);
}

static Block71Data*
block71_data_ref (Block71Data* _data71_)
{
	g_atomic_int_inc (&_data71_->_ref_count_);
	return _data71_;
}

static void
block71_data_unref (void * _userdata_)
{
	Block71Data* _data71_;
	_data71_ = (Block71Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data71_->_ref_count_)) {
		GalaWindowSwitcher* self;
		self = _data71_->self;
		_g_object_unref0 (self);
		g_slice_free (Block71Data, _data71_);
	}
}

static void
__lambda84_ (Block71Data* _data71_,
             gdouble percentage)
{
	GalaWindowSwitcher* self;
	gfloat window_index = 0.0F;
	ClutterActor* _tmp0_;
	self = _data71_->self;
	window_index = gala_gesture_tracker_animation_value ((gfloat) 0, (gfloat) GALA_WINDOW_SWITCHER_GESTURE_RANGE_LIMIT, percentage, TRUE);
	_tmp0_ = self->priv->container;
	if (window_index >= ((gfloat) clutter_actor_get_n_children (_tmp0_))) {
		return;
	}
	if (window_index > ((gfloat) _data71_->last_window_index)) {
		while (TRUE) {
			gint _tmp1_;
			if (!(((gfloat) _data71_->last_window_index) < window_index)) {
				break;
			}
			gala_window_switcher_next_window (self, _data71_->direction == GALA_GESTURE_DIRECTION_LEFT);
			_tmp1_ = _data71_->last_window_index;
			_data71_->last_window_index = _tmp1_ + 1;
		}
	} else {
		if (window_index < ((gfloat) _data71_->last_window_index)) {
			while (TRUE) {
				gint _tmp2_;
				if (!(((gfloat) _data71_->last_window_index) > window_index)) {
					break;
				}
				gala_window_switcher_next_window (self, _data71_->direction == GALA_GESTURE_DIRECTION_RIGHT);
				_tmp2_ = _data71_->last_window_index;
				_data71_->last_window_index = _tmp2_ - 1;
			}
		}
	}
}

static void
___lambda84__gala_gesture_tracker_on_update (gdouble percentage,
                                             gpointer self)
{
	__lambda84_ (self, percentage);
}

static void
__lambda85_ (GalaWindowSwitcher* self,
             gdouble percentage,
             gboolean cancel_action,
             gint calculated_duration)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	self->priv->handling_gesture = FALSE;
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	gala_window_switcher_close_switcher (self, meta_display_get_current_time (_tmp1_), FALSE);
}

static void
___lambda85__gala_gesture_tracker_on_end (gdouble percentage,
                                          gboolean cancel_action,
                                          gint calculated_duration,
                                          gpointer self)
{
	__lambda85_ ((GalaWindowSwitcher*) self, percentage, cancel_action, calculated_duration);
}

void
gala_window_switcher_handle_gesture (GalaWindowSwitcher* self,
                                     GalaGestureDirection direction)
{
	Block71Data* _data71_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* workspace_manager = NULL;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	MetaWorkspace* active_workspace = NULL;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspace* _tmp5_;
	gboolean windows_exist = FALSE;
	MetaDisplay* _tmp6_;
	MetaWorkspace* _tmp7_;
	gint _tmp8_ = 0;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	GalaGestureTracker* _tmp9_;
	GalaGestureTrackerOnUpdate _tmp10_;
	gpointer _tmp10__target;
	GDestroyNotify _tmp10__target_destroy_notify;
	GalaGestureTrackerOnEnd _tmp11_;
	gpointer _tmp11__target;
	GDestroyNotify _tmp11__target_destroy_notify;
	g_return_if_fail (self != NULL);
	_data71_ = g_slice_new0 (Block71Data);
	_data71_->_ref_count_ = 1;
	_data71_->self = g_object_ref (self);
	_data71_->direction = direction;
	self->priv->handling_gesture = TRUE;
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
	workspace_manager = _tmp3_;
	_tmp4_ = workspace_manager;
	_tmp5_ = meta_workspace_manager_get_active_workspace (_tmp4_);
	active_workspace = _tmp5_;
	_tmp6_ = display;
	_tmp7_ = active_workspace;
	windows_exist = gala_window_switcher_collect_all_windows (self, _tmp6_, _tmp7_);
	if (!windows_exist) {
		block71_data_unref (_data71_);
		_data71_ = NULL;
		return;
	}
	gala_window_switcher_open_switcher (self);
	if (_data71_->direction == GALA_GESTURE_DIRECTION_RIGHT) {
		_tmp8_ = 0;
	} else {
		_tmp8_ = -1;
	}
	_data71_->last_window_index = _tmp8_;
	on_animation_update = ___lambda84__gala_gesture_tracker_on_update;
	on_animation_update_target = block71_data_ref (_data71_);
	on_animation_update_target_destroy_notify = block71_data_unref;
	on_animation_end = ___lambda85__gala_gesture_tracker_on_end;
	on_animation_end_target = g_object_ref (self);
	on_animation_end_target_destroy_notify = g_object_unref;
	_tmp9_ = self->priv->_gesture_tracker;
	_tmp10_ = on_animation_update;
	_tmp10__target = on_animation_update_target;
	_tmp10__target_destroy_notify = on_animation_update_target_destroy_notify;
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	_tmp11_ = on_animation_end;
	_tmp11__target = on_animation_end_target;
	_tmp11__target_destroy_notify = on_animation_end_target_destroy_notify;
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	gala_gesture_tracker_connect_handlers (_tmp9_, NULL, NULL, NULL, _tmp10_, _tmp10__target, _tmp10__target_destroy_notify, _tmp11_, _tmp11__target, _tmp11__target_destroy_notify);
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	block71_data_unref (_data71_);
	_data71_ = NULL;
}

static gboolean
gala_window_switcher_collect_all_windows (GalaWindowSwitcher* self,
                                          MetaDisplay* display,
                                          MetaWorkspace* workspace)
{
	GList* windows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	ClutterActor* _tmp4_;
	GList* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = meta_display_get_tab_list (display, META_TAB_LIST_NORMAL, workspace);
	windows = _tmp0_;
	_tmp1_ = windows;
	if (_tmp1_ == NULL) {
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp2_ = meta_display_get_tab_current (display, META_TAB_LIST_NORMAL, workspace);
	current_window = _tmp2_;
	_tmp3_ = current_window;
	if (_tmp3_ == NULL) {
		gala_window_switcher_set_current_icon (self, NULL);
	}
	_tmp4_ = self->priv->container;
	clutter_actor_remove_all_children (_tmp4_);
	_tmp5_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp5_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				GalaWindowSwitcherIcon* icon = NULL;
				MetaWindow* _tmp6_;
				GalaWindowSwitcherIcon* _tmp7_;
				MetaWindow* _tmp8_;
				MetaWindow* _tmp9_;
				GalaWindowSwitcherIcon* _tmp11_;
				_tmp6_ = window;
				_tmp7_ = gala_window_switcher_icon_new (_tmp6_, GALA_WINDOW_SWITCHER_ICON_SIZE, self->priv->scaling_factor);
				g_object_ref_sink (_tmp7_);
				icon = _tmp7_;
				_tmp8_ = window;
				_tmp9_ = current_window;
				if (_tmp8_ == _tmp9_) {
					GalaWindowSwitcherIcon* _tmp10_;
					_tmp10_ = icon;
					gala_window_switcher_set_current_icon (self, _tmp10_);
				}
				_tmp11_ = icon;
				gala_window_switcher_add_icon (self, _tmp11_);
				_g_object_unref0 (icon);
			}
		}
	}
	result = TRUE;
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

static gboolean
gala_window_switcher_collect_current_windows (GalaWindowSwitcher* self,
                                              MetaDisplay* display,
                                              MetaWorkspace* workspace)
{
	GList* windows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	ClutterActor* _tmp4_;
	GalaWindowTracker* window_tracker = NULL;
	GalaWindowManager* _tmp5_;
	GalaWindowTracker* _tmp6_;
	GalaWindowTracker* _tmp7_;
	GalaApp* app = NULL;
	GalaWindowTracker* _tmp8_;
	MetaWindow* _tmp9_;
	GalaApp* _tmp10_;
	GList* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = meta_display_get_tab_list (display, META_TAB_LIST_NORMAL, workspace);
	windows = _tmp0_;
	_tmp1_ = windows;
	if (_tmp1_ == NULL) {
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp2_ = meta_display_get_tab_current (display, META_TAB_LIST_NORMAL, workspace);
	current_window = _tmp2_;
	_tmp3_ = current_window;
	if (_tmp3_ == NULL) {
		gala_window_switcher_set_current_icon (self, NULL);
		result = FALSE;
		(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
		return result;
	}
	_tmp4_ = self->priv->container;
	clutter_actor_remove_all_children (_tmp4_);
	_tmp5_ = self->priv->_wm;
	_tmp6_ = gala_window_manager_gala_get_window_tracker (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GALA_TYPE_WINDOW_MANAGER_GALA, GalaWindowManagerGala));
	_tmp7_ = _tmp6_;
	window_tracker = _tmp7_;
	_tmp8_ = window_tracker;
	_tmp9_ = current_window;
	_tmp10_ = gala_window_tracker_get_app_for_window (_tmp8_, _tmp9_);
	app = _tmp10_;
	_tmp11_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp11_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				GalaWindowTracker* _tmp12_;
				MetaWindow* _tmp13_;
				GalaApp* _tmp14_;
				GalaApp* _tmp15_;
				GalaApp* _tmp16_;
				gboolean _tmp17_;
				_tmp12_ = window_tracker;
				_tmp13_ = window;
				_tmp14_ = gala_window_tracker_get_app_for_window (_tmp12_, _tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = app;
				_tmp17_ = _tmp15_ == _tmp16_;
				_g_object_unref0 (_tmp15_);
				if (_tmp17_) {
					GalaWindowSwitcherIcon* icon = NULL;
					MetaWindow* _tmp18_;
					GalaWindowSwitcherIcon* _tmp19_;
					MetaWindow* _tmp20_;
					MetaWindow* _tmp21_;
					GalaWindowSwitcherIcon* _tmp23_;
					_tmp18_ = window;
					_tmp19_ = gala_window_switcher_icon_new (_tmp18_, GALA_WINDOW_SWITCHER_ICON_SIZE, self->priv->scaling_factor);
					g_object_ref_sink (_tmp19_);
					icon = _tmp19_;
					_tmp20_ = window;
					_tmp21_ = current_window;
					if (_tmp20_ == _tmp21_) {
						GalaWindowSwitcherIcon* _tmp22_;
						_tmp22_ = icon;
						gala_window_switcher_set_current_icon (self, _tmp22_);
					}
					_tmp23_ = icon;
					gala_window_switcher_add_icon (self, _tmp23_);
					_g_object_unref0 (icon);
				}
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (app);
	(windows == NULL) ? NULL : (windows = (g_list_free (windows), NULL));
	return result;
}

static Block72Data*
block72_data_ref (Block72Data* _data72_)
{
	g_atomic_int_inc (&_data72_->_ref_count_);
	return _data72_;
}

static void
block72_data_unref (void * _userdata_)
{
	Block72Data* _data72_;
	_data72_ = (Block72Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data72_->_ref_count_)) {
		GalaWindowSwitcher* self;
		self = _data72_->self;
		_g_object_unref0 (_data72_->icon);
		_g_object_unref0 (self);
		g_slice_free (Block72Data, _data72_);
	}
}

static gboolean
__lambda82_ (Block72Data* _data72_)
{
	GalaWindowSwitcher* self;
	gboolean _tmp0_ = FALSE;
	GalaWindowSwitcherIcon* _tmp1_;
	GalaWindowSwitcherIcon* _tmp2_;
	gboolean result;
	self = _data72_->self;
	_tmp1_ = gala_window_switcher_get_current_icon (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != _data72_->icon) {
		_tmp0_ = !self->priv->handling_gesture;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_set_current_icon (self, _data72_->icon);
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
___lambda82__clutter_actor_motion_event (ClutterActor* _sender,
                                         ClutterEvent* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda82_ (self);
	return result;
}

static void
gala_window_switcher_add_icon (GalaWindowSwitcher* self,
                               GalaWindowSwitcherIcon* icon)
{
	Block72Data* _data72_;
	GalaWindowSwitcherIcon* _tmp0_;
	ClutterActor* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon != NULL);
	_data72_ = g_slice_new0 (Block72Data);
	_data72_->_ref_count_ = 1;
	_data72_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (icon);
	_g_object_unref0 (_data72_->icon);
	_data72_->icon = _tmp0_;
	_tmp1_ = self->priv->container;
	clutter_actor_add_child (_tmp1_, (ClutterActor*) _data72_->icon);
	g_signal_connect_data ((ClutterActor*) _data72_->icon, "motion-event", (GCallback) ___lambda82__clutter_actor_motion_event, block72_data_ref (_data72_), (GClosureNotify) block72_data_unref, 0);
	block72_data_unref (_data72_);
	_data72_ = NULL;
}

static void
gala_window_switcher_open_switcher (GalaWindowSwitcher* self)
{
	ClutterActor* _tmp0_;
	gboolean _tmp3_;
	gfloat width = 0.0F;
	gfloat height = 0.0F;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp6_;
	MetaDisplay* _tmp7_;
	gint monitor = 0;
	MetaDisplay* _tmp8_;
	MtkRectangle geom = {0};
	MetaDisplay* _tmp9_;
	MtkRectangle _tmp10_ = {0};
	MtkRectangle _tmp11_;
	MtkRectangle _tmp12_;
	MtkRectangle _tmp13_;
	MtkRectangle _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp0_) == 0) {
		ClutterBackend* _tmp1_;
		ClutterSeat* _tmp2_;
		_tmp1_ = clutter_get_default_backend ();
		_tmp2_ = clutter_backend_get_default_seat (_tmp1_);
		clutter_seat_bell_notify (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->_opened;
	if (_tmp3_) {
		return;
	}
	clutter_actor_get_preferred_size ((ClutterActor*) self, NULL, NULL, &_tmp4_, &_tmp5_);
	width = _tmp4_;
	height = _tmp5_;
	_tmp6_ = self->priv->_wm;
	_tmp7_ = meta_plugin_get_display ((MetaPlugin*) _tmp6_);
	display = _tmp7_;
	_tmp8_ = display;
	monitor = meta_display_get_current_monitor (_tmp8_);
	_tmp9_ = display;
	meta_display_get_monitor_geometry (_tmp9_, monitor, &_tmp10_);
	geom = _tmp10_;
	_tmp11_ = geom;
	_tmp12_ = geom;
	_tmp13_ = geom;
	_tmp14_ = geom;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) ((gint) (_tmp11_.x + ((_tmp12_.width - width) / 2))), (gfloat) ((gint) (_tmp13_.y + ((_tmp14_.height - height) / 2))));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	gala_window_switcher_toggle_display (self, TRUE);
}

static void
gala_window_switcher_toggle_display (GalaWindowSwitcher* self,
                                     gboolean show)
{
	gboolean _tmp0_;
	gint _tmp3_ = 0;
	GalaWindowManager* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gint _tmp7_ = 0;
	ClutterActor* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_opened;
	if (_tmp0_ == show) {
		return;
	}
	gala_window_switcher_set_opened (self, show);
	if (show) {
		gala_window_switcher_push_modal (self);
	} else {
		GalaWindowManager* _tmp1_;
		GalaModalProxy* _tmp2_;
		_tmp1_ = self->priv->_wm;
		_tmp2_ = self->priv->modal_proxy;
		gala_window_manager_pop_modal (_tmp1_, _tmp2_);
	}
	clutter_actor_save_easing_state ((ClutterActor*) self);
	_tmp4_ = self->priv->_wm;
	_tmp5_ = gala_window_manager_get_enable_animations (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		_tmp3_ = GALA_WINDOW_SWITCHER_ANIMATION_DURATION;
	} else {
		_tmp3_ = 0;
	}
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) _tmp3_);
	if (show) {
		_tmp7_ = 255;
	} else {
		_tmp7_ = 0;
	}
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) _tmp7_);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_tmp8_ = self->priv->container;
	clutter_actor_set_reactive (_tmp8_, show);
}

static gboolean
__lambda83_ (GalaWindowSwitcher* self,
             MetaKeyBinding* binding)
{
	MetaKeyBindingAction action = 0;
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (binding != NULL, FALSE);
	_tmp0_ = meta_key_binding_get_name (binding);
	action = meta_prefs_get_keybinding_action (_tmp0_);
	switch (action) {
		case META_KEYBINDING_ACTION_NONE:
		case META_KEYBINDING_ACTION_LOCATE_POINTER_KEY:
		case META_KEYBINDING_ACTION_SWITCH_APPLICATIONS:
		case META_KEYBINDING_ACTION_SWITCH_APPLICATIONS_BACKWARD:
		case META_KEYBINDING_ACTION_SWITCH_WINDOWS:
		case META_KEYBINDING_ACTION_SWITCH_WINDOWS_BACKWARD:
		case META_KEYBINDING_ACTION_SWITCH_GROUP:
		case META_KEYBINDING_ACTION_SWITCH_GROUP_BACKWARD:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda83__gala_keybinding_filter (MetaKeyBinding* binding,
                                     gpointer self)
{
	gboolean result;
	result = __lambda83_ ((GalaWindowSwitcher*) self, binding);
	return result;
}

static void
gala_window_switcher_push_modal (GalaWindowSwitcher* self)
{
	GalaWindowManager* _tmp0_;
	GalaModalProxy* _tmp1_;
	GalaModalProxy* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_window_manager_push_modal (_tmp0_, (ClutterActor*) self);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp1_;
	_tmp2_ = self->priv->modal_proxy;
	gala_modal_proxy_set_keybinding_filter (_tmp2_, ___lambda83__gala_keybinding_filter, self);
}

static void
gala_window_switcher_close_switcher (GalaWindowSwitcher* self,
                                     guint32 time,
                                     gboolean cancel)
{
	gboolean _tmp0_;
	MetaWindow* window = NULL;
	GalaWindowSwitcherIcon* _tmp1_;
	GalaWindowSwitcherIcon* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	MetaWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_opened;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gala_window_switcher_get_current_icon (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = gala_window_switcher_icon_get_window (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	window = _tmp5_;
	_tmp6_ = window;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (window);
		return;
	}
	if (!cancel) {
		MetaWorkspace* workspace = NULL;
		MetaWindow* _tmp7_;
		MetaWorkspace* _tmp8_;
		MetaWorkspace* _tmp9_;
		GalaWindowManager* _tmp10_;
		MetaDisplay* _tmp11_;
		MetaWorkspaceManager* _tmp12_;
		MetaWorkspace* _tmp13_;
		_tmp7_ = window;
		_tmp8_ = meta_window_get_workspace (_tmp7_);
		workspace = _tmp8_;
		_tmp9_ = workspace;
		_tmp10_ = self->priv->_wm;
		_tmp11_ = meta_plugin_get_display ((MetaPlugin*) _tmp10_);
		_tmp12_ = meta_display_get_workspace_manager (_tmp11_);
		_tmp13_ = meta_workspace_manager_get_active_workspace (_tmp12_);
		if (_tmp9_ != _tmp13_) {
			MetaWorkspace* _tmp14_;
			MetaWindow* _tmp15_;
			_tmp14_ = workspace;
			_tmp15_ = window;
			meta_workspace_activate_with_focus (_tmp14_, _tmp15_, time);
		} else {
			MetaWindow* _tmp16_;
			_tmp16_ = window;
			meta_window_activate (_tmp16_, time);
		}
	}
	gala_window_switcher_toggle_display (self, FALSE);
	_g_object_unref0 (window);
}

static void
gala_window_switcher_next_window (GalaWindowSwitcher* self,
                                  gboolean backward)
{
	ClutterActor* actor = NULL;
	gboolean _tmp0_ = FALSE;
	ClutterActor* _tmp1_;
	GalaWindowSwitcherIcon* _tmp6_;
	GalaWindowSwitcherIcon* _tmp7_;
	ClutterActor* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->container;
	if (clutter_actor_get_n_children (_tmp1_) == 1) {
		GalaWindowSwitcherIcon* _tmp2_;
		GalaWindowSwitcherIcon* _tmp3_;
		_tmp2_ = gala_window_switcher_get_current_icon (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ClutterBackend* _tmp4_;
		ClutterSeat* _tmp5_;
		_tmp4_ = clutter_get_default_backend ();
		_tmp5_ = clutter_backend_get_default_seat (_tmp4_);
		clutter_seat_bell_notify (_tmp5_);
		_g_object_unref0 (actor);
		return;
	}
	_tmp6_ = gala_window_switcher_get_current_icon (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		ClutterActor* _tmp8_;
		ClutterActor* _tmp9_;
		ClutterActor* _tmp10_;
		_tmp8_ = self->priv->container;
		_tmp9_ = clutter_actor_get_first_child (_tmp8_);
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (actor);
		actor = _tmp10_;
	} else {
		if (!backward) {
			GalaWindowSwitcherIcon* _tmp11_;
			GalaWindowSwitcherIcon* _tmp12_;
			ClutterActor* _tmp13_;
			ClutterActor* _tmp14_;
			ClutterActor* _tmp15_;
			_tmp11_ = gala_window_switcher_get_current_icon (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = clutter_actor_get_next_sibling ((ClutterActor*) _tmp12_);
			_tmp14_ = _g_object_ref0 (_tmp13_);
			_g_object_unref0 (actor);
			actor = _tmp14_;
			_tmp15_ = actor;
			if (_tmp15_ == NULL) {
				ClutterActor* _tmp16_;
				ClutterActor* _tmp17_;
				ClutterActor* _tmp18_;
				_tmp16_ = self->priv->container;
				_tmp17_ = clutter_actor_get_first_child (_tmp16_);
				_tmp18_ = _g_object_ref0 (_tmp17_);
				_g_object_unref0 (actor);
				actor = _tmp18_;
			}
		} else {
			GalaWindowSwitcherIcon* _tmp19_;
			GalaWindowSwitcherIcon* _tmp20_;
			ClutterActor* _tmp21_;
			ClutterActor* _tmp22_;
			ClutterActor* _tmp23_;
			_tmp19_ = gala_window_switcher_get_current_icon (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = clutter_actor_get_previous_sibling ((ClutterActor*) _tmp20_);
			_tmp22_ = _g_object_ref0 (_tmp21_);
			_g_object_unref0 (actor);
			actor = _tmp22_;
			_tmp23_ = actor;
			if (_tmp23_ == NULL) {
				ClutterActor* _tmp24_;
				ClutterActor* _tmp25_;
				ClutterActor* _tmp26_;
				_tmp24_ = self->priv->container;
				_tmp25_ = clutter_actor_get_last_child (_tmp24_);
				_tmp26_ = _g_object_ref0 (_tmp25_);
				_g_object_unref0 (actor);
				actor = _tmp26_;
			}
		}
	}
	_tmp27_ = actor;
	gala_window_switcher_set_current_icon (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GALA_TYPE_WINDOW_SWITCHER_ICON, GalaWindowSwitcherIcon));
	_g_object_unref0 (actor);
}

static void
gala_window_switcher_update_caption_text (GalaWindowSwitcher* self)
{
	MetaWindow* _tmp0_ = NULL;
	GalaWindowSwitcherIcon* _tmp1_;
	GalaWindowSwitcherIcon* _tmp2_;
	MetaWindow* current_window = NULL;
	MetaWindow* _tmp7_;
	const gchar* _tmp8_ = NULL;
	MetaWindow* _tmp9_;
	gchar* current_caption = NULL;
	gchar* _tmp13_;
	ClutterText* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp1_ = gala_window_switcher_get_current_icon (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GalaWindowSwitcherIcon* _tmp3_;
		GalaWindowSwitcherIcon* _tmp4_;
		MetaWindow* _tmp5_;
		MetaWindow* _tmp6_;
		_tmp3_ = gala_window_switcher_get_current_icon (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = gala_window_switcher_icon_get_window (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp7_ = _g_object_ref0 (_tmp0_);
	current_window = _tmp7_;
	_tmp9_ = current_window;
	if (_tmp9_ != NULL) {
		MetaWindow* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = current_window;
		_tmp11_ = meta_window_get_title (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_;
	} else {
		_tmp8_ = "n/a";
	}
	_tmp13_ = g_strdup (_tmp8_);
	current_caption = _tmp13_;
	_tmp14_ = self->priv->caption;
	clutter_text_set_text (_tmp14_, current_caption);
	_g_free0 (current_caption);
	_g_object_unref0 (current_window);
}

static void
gala_window_switcher_real_key_focus_out (ClutterActor* base)
{
	GalaWindowSwitcher * self;
	self = (GalaWindowSwitcher*) base;
	if (!self->priv->handling_gesture) {
		GalaWindowManager* _tmp0_;
		MetaDisplay* _tmp1_;
		_tmp0_ = self->priv->_wm;
		_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
		gala_window_switcher_close_switcher (self, meta_display_get_current_time (_tmp1_), FALSE);
	}
}

static gboolean
gala_window_switcher_container_mouse_release (GalaWindowSwitcher* self,
                                              ClutterEvent* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = self->priv->_opened;
	if (_tmp2_) {
		_tmp1_ = clutter_event_get_button (event) == CLUTTER_BUTTON_PRIMARY;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !self->priv->handling_gesture;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_close_switcher (self, clutter_event_get_time (event), FALSE);
	}
	result = TRUE;
	return result;
}

static gboolean
gala_window_switcher_real_key_release_event (ClutterActor* base,
                                             ClutterEvent* event)
{
	GalaWindowSwitcher * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = (GalaWindowSwitcher*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if ((gala_window_switcher_get_current_modifiers (self) & self->priv->modifier_mask) == 0) {
		_tmp0_ = !self->priv->handling_gesture;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gala_window_switcher_close_switcher (self, clutter_event_get_time (event), FALSE);
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
gala_window_switcher_real_key_press_event (ClutterActor* base,
                                           ClutterEvent* event)
{
	GalaWindowSwitcher * self;
	gboolean result;
	self = (GalaWindowSwitcher*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (clutter_event_get_key_symbol (event)) {
		case CLUTTER_KEY_Right:
		{
			if (!self->priv->handling_gesture) {
				gala_window_switcher_next_window (self, FALSE);
			}
			result = CLUTTER_EVENT_STOP;
			return result;
		}
		case CLUTTER_KEY_Left:
		{
			if (!self->priv->handling_gesture) {
				gala_window_switcher_next_window (self, TRUE);
			}
			result = CLUTTER_EVENT_STOP;
			return result;
		}
		case CLUTTER_KEY_Escape:
		{
			gala_window_switcher_close_switcher (self, clutter_event_get_time (event), TRUE);
			result = CLUTTER_EVENT_PROPAGATE;
			return result;
		}
		case CLUTTER_KEY_Return:
		{
			gala_window_switcher_close_switcher (self, clutter_event_get_time (event), FALSE);
			result = CLUTTER_EVENT_PROPAGATE;
			return result;
		}
		default:
		break;
	}
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static inline ClutterModifierType
gala_window_switcher_get_current_modifiers (GalaWindowSwitcher* self)
{
	ClutterModifierType modifiers = 0U;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaCursorTracker* _tmp2_;
	ClutterModifierType _tmp3_ = 0U;
	ClutterModifierType result;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_cursor_tracker_get_for_display (_tmp1_);
	meta_cursor_tracker_get_pointer (_tmp2_, NULL, &_tmp3_);
	modifiers = _tmp3_;
	result = modifiers & CLUTTER_MODIFIER_MASK;
	return result;
}

GalaWindowManager*
gala_window_switcher_get_wm (GalaWindowSwitcher* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_switcher_set_wm (GalaWindowSwitcher* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_WM_PROPERTY]);
	}
}

GalaGestureTracker*
gala_window_switcher_get_gesture_tracker (GalaWindowSwitcher* self)
{
	GalaGestureTracker* result;
	GalaGestureTracker* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gesture_tracker;
	result = _tmp0_;
	return result;
}

static void
gala_window_switcher_set_gesture_tracker (GalaWindowSwitcher* self,
                                          GalaGestureTracker* value)
{
	GalaGestureTracker* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_gesture_tracker (self);
	if (old_value != value) {
		GalaGestureTracker* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gesture_tracker);
		self->priv->_gesture_tracker = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_GESTURE_TRACKER_PROPERTY]);
	}
}

gboolean
gala_window_switcher_get_opened (GalaWindowSwitcher* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_opened;
	return result;
}

static void
gala_window_switcher_set_opened (GalaWindowSwitcher* self,
                                 gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_switcher_get_opened (self);
	if (old_value != value) {
		self->priv->_opened = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_OPENED_PROPERTY]);
	}
}

static GalaWindowSwitcherIcon*
gala_window_switcher_get_current_icon (GalaWindowSwitcher* self)
{
	GalaWindowSwitcherIcon* result;
	GalaWindowSwitcherIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_icon;
	result = _tmp0_;
	return result;
}

static void
gala_window_switcher_set_current_icon (GalaWindowSwitcher* self,
                                       GalaWindowSwitcherIcon* value)
{
	GalaWindowSwitcherIcon* _tmp0_;
	GalaWindowSwitcherIcon* _tmp2_;
	GalaWindowSwitcherIcon* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_icon;
	if (_tmp0_ != NULL) {
		GalaWindowSwitcherIcon* _tmp1_;
		_tmp1_ = self->priv->_current_icon;
		gala_window_switcher_icon_set_selected (_tmp1_, FALSE);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_current_icon);
	self->priv->_current_icon = _tmp2_;
	_tmp3_ = self->priv->_current_icon;
	if (_tmp3_ != NULL) {
		GalaWindowSwitcherIcon* _tmp4_;
		_tmp4_ = self->priv->_current_icon;
		gala_window_switcher_icon_set_selected (_tmp4_, TRUE);
	}
	gala_window_switcher_update_caption_text (self);
}

static gboolean
_gala_window_switcher_container_mouse_release_clutter_actor_button_release_event (ClutterActor* _sender,
                                                                                  ClutterEvent* event,
                                                                                  gpointer self)
{
	gboolean result;
	result = gala_window_switcher_container_mouse_release ((GalaWindowSwitcher*) self, event);
	return result;
}

static void
_clutter_content_invalidate_g_object_notify (GObject* _sender,
                                             GParamSpec* pspec,
                                             gpointer self)
{
	clutter_content_invalidate ((ClutterContent*) self);
}

static void
_gala_window_switcher_scale_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                   gpointer self)
{
	gala_window_switcher_scale ((GalaWindowSwitcher*) self);
}

static GObject *
gala_window_switcher_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowSwitcher * self;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	GraniteSettings* _tmp2_;
	ClutterFlowLayout* _tmp3_;
	ClutterActor* _tmp4_ = NULL;
	gchar* _tmp5_;
	ClutterText* _tmp6_ = NULL;
	ClutterActor* _tmp7_;
	ClutterText* _tmp8_;
	ClutterBoxLayout* _tmp9_ = NULL;
	ClutterBoxLayout* _tmp10_;
	gchar* _tmp11_;
	GalaShadowEffect* _tmp12_ = NULL;
	GalaShadowEffect* _tmp13_;
	ClutterActor* _tmp14_;
	GraniteSettings* _tmp15_;
	ClutterContent* _tmp16_;
	ClutterContent* _tmp17_;
	GtkSettings* _tmp18_;
	ClutterContent* _tmp19_;
	ClutterContent* _tmp20_;
	MetaMonitorManager* monitor_manager = NULL;
	GalaWindowManager* _tmp21_;
	MetaDisplay* _tmp22_;
	MetaContext* _tmp23_;
	MetaBackend* _tmp24_;
	MetaMonitorManager* _tmp25_;
	MetaMonitorManager* _tmp26_;
	parent_class = G_OBJECT_CLASS (gala_window_switcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	_tmp0_ = gtk_settings_get_default ();
	gtk_settings = _tmp0_;
	_tmp1_ = granite_settings_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->granite_settings);
	self->priv->granite_settings = _tmp2_;
	_tmp3_ = (ClutterFlowLayout*) clutter_flow_layout_new (CLUTTER_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp3_);
	_tmp4_ = clutter_actor_new ();
	clutter_actor_set_reactive (_tmp4_, TRUE);
	clutter_actor_set_layout_manager (_tmp4_, (ClutterLayoutManager*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp4_;
	_tmp5_ = g_strdup (GALA_WINDOW_SWITCHER_CAPTION_FONT_NAME);
	_tmp6_ = (ClutterText*) clutter_text_new ();
	clutter_text_set_font_name (_tmp6_, _tmp5_);
	_g_free0 (_tmp5_);
	clutter_text_set_ellipsize (_tmp6_, PANGO_ELLIPSIZE_END);
	clutter_text_set_line_alignment (_tmp6_, PANGO_ALIGN_CENTER);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->caption);
	self->priv->caption = _tmp6_;
	_tmp7_ = self->priv->container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp7_);
	_tmp8_ = self->priv->caption;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp8_);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	_tmp9_ = (ClutterBoxLayout*) clutter_box_layout_new ();
	clutter_box_layout_set_orientation (_tmp9_, CLUTTER_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	clutter_actor_set_layout_manager ((ClutterActor*) self, (ClutterLayoutManager*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = g_strdup ("window-switcher");
	_tmp12_ = gala_shadow_effect_new (40);
	gala_shadow_effect_set_shadow_opacity (_tmp12_, (guint8) 200);
	gala_shadow_effect_set_css_class (_tmp12_, _tmp11_);
	_g_free0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->shadow_effect);
	self->priv->shadow_effect = _tmp12_;
	_tmp13_ = self->priv->shadow_effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp13_);
	gala_window_switcher_scale (self);
	_tmp14_ = self->priv->container;
	g_signal_connect_object (_tmp14_, "button-release-event", (GCallback) _gala_window_switcher_container_mouse_release_clutter_actor_button_release_event, self, 0);
	_tmp15_ = self->priv->granite_settings;
	_tmp16_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp17_ = _tmp16_;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::prefers-color-scheme", (GCallback) _clutter_content_invalidate_g_object_notify, _tmp17_, 0);
	_tmp18_ = gtk_settings;
	_tmp19_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp20_ = _tmp19_;
	g_signal_connect_object ((GObject*) _tmp18_, "notify::gtk-theme-name", (GCallback) _clutter_content_invalidate_g_object_notify, _tmp20_, 0);
	_tmp21_ = self->priv->_wm;
	_tmp22_ = meta_plugin_get_display ((MetaPlugin*) _tmp21_);
	_tmp23_ = meta_display_get_context (_tmp22_);
	_tmp24_ = meta_context_get_backend (_tmp23_);
	_tmp25_ = meta_backend_get_monitor_manager (_tmp24_);
	monitor_manager = _tmp25_;
	_tmp26_ = monitor_manager;
	g_signal_connect_object (_tmp26_, "monitors-changed", (GCallback) _gala_window_switcher_scale_meta_monitor_manager_monitors_changed, self, 0);
	return obj;
}

static void
gala_window_switcher_class_init (GalaWindowSwitcherClass * klass,
                                 gpointer klass_data)
{
	gala_window_switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowSwitcher_private_offset);
	((ClutterActorClass *) klass)->get_preferred_width = (void (*) (ClutterActor*, gfloat, gfloat*, gfloat*)) gala_window_switcher_real_get_preferred_width;
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_window_switcher_real_draw;
	((ClutterActorClass *) klass)->key_focus_out = (void (*) (ClutterActor*)) gala_window_switcher_real_key_focus_out;
	((ClutterActorClass *) klass)->key_release_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_switcher_real_key_release_event;
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_switcher_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_switcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_switcher_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_switcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_switcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_WM_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_GESTURE_TRACKER_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_GESTURE_TRACKER_PROPERTY] = g_param_spec_object ("gesture-tracker", "gesture-tracker", "gesture-tracker", GALA_TYPE_GESTURE_TRACKER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_SWITCHER_OPENED_PROPERTY, gala_window_switcher_properties[GALA_WINDOW_SWITCHER_OPENED_PROPERTY] = g_param_spec_boolean ("opened", "opened", "opened", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_window_switcher_instance_init (GalaWindowSwitcher * self,
                                    gpointer klass)
{
	self->priv = gala_window_switcher_get_instance_private (self);
	self->priv->_opened = FALSE;
	self->priv->handling_gesture = FALSE;
	self->priv->modal_proxy = NULL;
	self->priv->_current_icon = NULL;
	self->priv->scaling_factor = 1.0f;
}

static void
gala_window_switcher_finalize (GObject * obj)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_gesture_tracker);
	_g_object_unref0 (self->priv->modal_proxy);
	_g_object_unref0 (self->priv->granite_settings);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->caption);
	_g_object_unref0 (self->priv->shadow_effect);
	_g_object_unref0 (self->priv->_current_icon);
	G_OBJECT_CLASS (gala_window_switcher_parent_class)->finalize (obj);
}

static GType
gala_window_switcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowSwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowSwitcher), 0, (GInstanceInitFunc) gala_window_switcher_instance_init, NULL };
	GType gala_window_switcher_type_id;
	gala_window_switcher_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaWindowSwitcher", &g_define_type_info, 0);
	GalaWindowSwitcher_private_offset = g_type_add_instance_private (gala_window_switcher_type_id, sizeof (GalaWindowSwitcherPrivate));
	return gala_window_switcher_type_id;
}

GType
gala_window_switcher_get_type (void)
{
	static volatile gsize gala_window_switcher_type_id__once = 0;
	if (g_once_init_enter (&gala_window_switcher_type_id__once)) {
		GType gala_window_switcher_type_id;
		gala_window_switcher_type_id = gala_window_switcher_get_type_once ();
		g_once_init_leave (&gala_window_switcher_type_id__once, gala_window_switcher_type_id);
	}
	return gala_window_switcher_type_id__once;
}

static void
_vala_gala_window_switcher_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_WM_PROPERTY:
		g_value_set_object (value, gala_window_switcher_get_wm (self));
		break;
		case GALA_WINDOW_SWITCHER_GESTURE_TRACKER_PROPERTY:
		g_value_set_object (value, gala_window_switcher_get_gesture_tracker (self));
		break;
		case GALA_WINDOW_SWITCHER_OPENED_PROPERTY:
		g_value_set_boolean (value, gala_window_switcher_get_opened (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_switcher_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowSwitcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_SWITCHER, GalaWindowSwitcher);
	switch (property_id) {
		case GALA_WINDOW_SWITCHER_WM_PROPERTY:
		gala_window_switcher_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_SWITCHER_GESTURE_TRACKER_PROPERTY:
		gala_window_switcher_set_gesture_tracker (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_SWITCHER_OPENED_PROPERTY:
		gala_window_switcher_set_opened (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

