/* WindowOverview.c generated by valac 0.56.16, the Vala compiler
 * generated from WindowOverview.vala, do not modify */

/*
 * Copyright 2012 Tom Beckmann
 * Copyright 2012 Rico Tzschichholz
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <clutter/clutter.h>
#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <meta/workspace.h>
#include <stdlib.h>
#include <string.h>
#include <meta/meta-workspace-manager.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/window.h>
#include <meta/meta-window-actor.h>
#include <meta/keybindings.h>
#include <mtk/mtk.h>
#include <float.h>
#include <math.h>
#include <meta/prefs.h>

#define GALA_WINDOW_OVERVIEW_BORDER 10
#define GALA_WINDOW_OVERVIEW_TOP_GAP 30
#define GALA_WINDOW_OVERVIEW_BOTTOM_GAP 100
#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_OVERVIEW (gala_window_overview_get_type ())
#define GALA_WINDOW_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview))
#define GALA_WINDOW_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverviewClass))
#define GALA_IS_WINDOW_OVERVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_OVERVIEW))
#define GALA_IS_WINDOW_OVERVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_OVERVIEW))
#define GALA_WINDOW_OVERVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverviewClass))

typedef struct _GalaWindowOverview GalaWindowOverview;
typedef struct _GalaWindowOverviewClass GalaWindowOverviewClass;
typedef struct _GalaWindowOverviewPrivate GalaWindowOverviewPrivate;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
enum  {
	GALA_WINDOW_OVERVIEW_0_PROPERTY,
	GALA_WINDOW_OVERVIEW_WM_PROPERTY,
	GALA_WINDOW_OVERVIEW_NUM_PROPERTIES
};
static GParamSpec* gala_window_overview_properties[GALA_WINDOW_OVERVIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;
typedef struct _Block70Data Block70Data;

struct _GalaWindowOverview {
	ClutterActor parent_instance;
	GalaWindowOverviewPrivate * priv;
};

struct _GalaWindowOverviewClass {
	ClutterActorClass parent_class;
};

struct _GalaWindowOverviewPrivate {
	GalaWindowManager* _wm;
	GalaModalProxy* modal_proxy;
	GList* workspaces;
	GalaWindowCloneContainer* window_clone_container;
};

struct _Block70Data {
	int _ref_count_;
	GalaWindowOverview* self;
	MetaWindow* window;
};

static gint GalaWindowOverview_private_offset;
static gpointer gala_window_overview_parent_class = NULL;
static GalaActivatableComponentIface * gala_window_overview_gala_activatable_component_parent_iface = NULL;

VALA_EXTERN GType gala_window_overview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowOverview, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GalaWindowOverview* gala_window_overview_new (GalaWindowManager* wm);
VALA_EXTERN GalaWindowOverview* gala_window_overview_construct (GType object_type,
                                                    GalaWindowManager* wm);
static gboolean gala_window_overview_real_key_press_event (ClutterActor* base,
                                                    ClutterEvent* event);
static gboolean gala_window_overview_real_button_release_event (ClutterActor* base,
                                                         ClutterEvent* event);
static gboolean gala_window_overview_real_is_opened (GalaActivatableComponent* base);
static void gala_window_overview_real_open (GalaActivatableComponent* base,
                                     GHashTable* hints);
VALA_EXTERN GalaWindowManager* gala_window_overview_get_wm (GalaWindowOverview* self);
static guint64* _variant_get1 (GVariant* value,
                        gint* result_length1);
static gboolean _vala_uint64_array_contains (guint64 * stack,
                                      gssize stack_length,
                                      const guint64 needle);
static void gala_window_overview_add_window (GalaWindowOverview* self,
                                      MetaWindow* window);
static void _gala_window_overview_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self);
static void gala_window_overview_remove_window (GalaWindowOverview* self,
                                         MetaWindow* window);
static void _gala_window_overview_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                        MetaWindow* object,
                                                                        gpointer self);
static void gala_window_overview_window_left_monitor (GalaWindowOverview* self,
                                               gint num,
                                               MetaWindow* window);
static void _gala_window_overview_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                                 gint object,
                                                                                 MetaWindow* p0,
                                                                                 gpointer self);
static gboolean gala_window_overview_keybinding_filter (GalaWindowOverview* self,
                                                 MetaKeyBinding* binding);
static gboolean _gala_window_overview_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                         gpointer self);
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           GalaGestureTracker* gesture_tracker,
                                                           gfloat scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 GalaGestureTracker* gesture_tracker,
                                                                 gfloat scale,
                                                                 gboolean overview_mode);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
static void gala_window_overview_thumb_selected (GalaWindowOverview* self,
                                          MetaWindow* window);
static void _gala_window_overview_thumb_selected_gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                       MetaWindow* window,
                                                                                       gpointer self);
static void _____lambda152_ (GalaWindowOverview* self);
static void ______lambda152__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                                   gpointer self);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
VALA_EXTERN void gala_window_clone_container_open (GalaWindowCloneContainer* self,
                                       MetaWindow* selected_window,
                                       gboolean with_gesture,
                                       gboolean is_cancel_animation);
static void gala_window_overview_restack_windows (GalaWindowOverview* self);
VALA_EXTERN void gala_window_clone_container_restack_windows (GalaWindowCloneContainer* self);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
static Block70Data* block70_data_ref (Block70Data* _data70_);
static void block70_data_unref (void * _userdata_);
static gboolean ___lambda151_ (Block70Data* _data70_);
static gboolean ____lambda151__gsource_func (gpointer self);
static void gala_window_overview_real_close (GalaActivatableComponent* base,
                                      GHashTable* hints);
VALA_EXTERN void gala_window_clone_container_close (GalaWindowCloneContainer* self,
                                        gboolean with_gesture,
                                        gboolean is_cancel_animation);
static gboolean __lambda150_ (GalaWindowOverview* self);
static void gala_window_overview_cleanup (GalaWindowOverview* self);
static gboolean ___lambda150__gsource_func (gpointer self);
static void gala_window_overview_set_wm (GalaWindowOverview* self,
                                  GalaWindowManager* value);
static GObject * gala_window_overview_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void gala_window_overview_finalize (GObject * obj);
static GType gala_window_overview_get_type_once (void);
static void _vala_gala_window_overview_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_gala_window_overview_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_window_overview_get_instance_private (GalaWindowOverview* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowOverview_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GalaWindowOverview*
gala_window_overview_construct (GType object_type,
                                GalaWindowManager* wm)
{
	GalaWindowOverview * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWindowOverview*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaWindowOverview*
gala_window_overview_new (GalaWindowManager* wm)
{
	return gala_window_overview_construct (GALA_TYPE_WINDOW_OVERVIEW, wm);
}

static gboolean
gala_window_overview_real_key_press_event (ClutterActor* base,
                                           ClutterEvent* event)
{
	GalaWindowOverview * self;
	GalaWindowCloneContainer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!gala_activatable_component_is_opened ((GalaActivatableComponent*) self)) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = self->priv->window_clone_container;
	g_signal_emit_by_name ((ClutterActor*) _tmp0_, "key-press-event", event, &_tmp1_);
	result = _tmp1_;
	return result;
}

static gboolean
gala_window_overview_real_button_release_event (ClutterActor* base,
                                                ClutterEvent* event)
{
	GalaWindowOverview * self;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (clutter_event_get_button (event) == CLUTTER_BUTTON_PRIMARY) {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

/**
     * {@inheritDoc}
     */
static gboolean
gala_window_overview_real_is_opened (GalaActivatableComponent* base)
{
	GalaWindowOverview * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	self = (GalaWindowOverview*) base;
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}

/**
     * {@inheritDoc}
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static guint64*
_variant_get1 (GVariant* value,
               gint* result_length1)
{
	guint64* _tmp0_;
	gint _tmp0__length;
	gint _tmp0__size;
	gint _tmp0__length1;
	GVariantIter _tmp1_;
	GVariant* _tmp2_;
	_tmp0_ = g_new (guint64, 5);
	_tmp0__length = 0;
	_tmp0__size = 4;
	_tmp0__length1 = 0;
	g_variant_iter_init (&_tmp1_, value);
	for (; (_tmp2_ = g_variant_iter_next_value (&_tmp1_)) != NULL; _tmp0__length1++) {
		if (_tmp0__size == _tmp0__length) {
			_tmp0__size = 2 * _tmp0__size;
			_tmp0_ = g_renew (guint64, _tmp0_, _tmp0__size + 1);
		}
		_tmp0_[_tmp0__length++] = g_variant_get_uint64 (_tmp2_);
		g_variant_unref (_tmp2_);
	}
	*result_length1 = _tmp0__length1;
	return _tmp0_;
}

static gboolean
_vala_uint64_array_contains (guint64 * stack,
                             gssize stack_length,
                             const guint64 needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static void
_gala_window_overview_add_window_meta_workspace_window_added (MetaWorkspace* _sender,
                                                              MetaWindow* object,
                                                              gpointer self)
{
	gala_window_overview_add_window ((GalaWindowOverview*) self, object);
}

static void
_gala_window_overview_remove_window_meta_workspace_window_removed (MetaWorkspace* _sender,
                                                                   MetaWindow* object,
                                                                   gpointer self)
{
	gala_window_overview_remove_window ((GalaWindowOverview*) self, object);
}

static void
_gala_window_overview_window_left_monitor_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                            gint object,
                                                                            MetaWindow* p0,
                                                                            gpointer self)
{
	gala_window_overview_window_left_monitor ((GalaWindowOverview*) self, object, p0);
}

static gboolean
_gala_window_overview_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                gpointer self)
{
	gboolean result;
	result = gala_window_overview_keybinding_filter ((GalaWindowOverview*) self, binding);
	return result;
}

static void
_gala_window_overview_thumb_selected_gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                  MetaWindow* window,
                                                                                  gpointer self)
{
	gala_window_overview_thumb_selected ((GalaWindowOverview*) self, window);
}

static void
_____lambda152_ (GalaWindowOverview* self)
{
	gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
}

static void
______lambda152__gala_window_clone_container_requested_close (GalaWindowCloneContainer* _sender,
                                                              gpointer self)
{
	_____lambda152_ ((GalaWindowOverview*) self);
}

static void
gala_window_overview_real_open (GalaActivatableComponent* base,
                                GHashTable* hints)
{
	GalaWindowOverview * self;
	MetaWorkspaceManager* manager = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	GList* _tmp4_;
	guint64* window_ids = NULL;
	gint window_ids_length1;
	gint _window_ids_size_;
	gboolean _tmp7_ = FALSE;
	GList* windows = NULL;
	GList* _tmp10_;
	GList* _tmp47_;
	GList* _tmp48_;
	GalaWindowManager* _tmp52_;
	MetaDisplay* _tmp53_;
	GalaWindowManager* _tmp54_;
	GalaModalProxy* _tmp55_;
	GalaModalProxy* _tmp56_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp57_;
	MetaDisplay* _tmp58_;
	GList* _tmp74_;
	self = (GalaWindowOverview*) base;
	(self->priv->workspaces == NULL) ? NULL : (self->priv->workspaces = (_g_list_free__g_object_unref0_ (self->priv->workspaces), NULL));
	self->priv->workspaces = NULL;
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = manager;
	_tmp4_ = meta_workspace_manager_get_workspaces (_tmp3_);
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp4_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* workspace = NULL;
			workspace = (MetaWorkspace*) workspace_it->data;
			{
				MetaWorkspace* _tmp5_;
				MetaWorkspace* _tmp6_;
				_tmp5_ = workspace;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				self->priv->workspaces = g_list_append (self->priv->workspaces, _tmp6_);
			}
		}
	}
	window_ids = NULL;
	window_ids_length1 = 0;
	_window_ids_size_ = window_ids_length1;
	if (hints != NULL) {
		_tmp7_ = g_hash_table_contains (hints, "windows");
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gconstpointer _tmp8_;
		guint64* _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		_tmp8_ = g_hash_table_lookup (hints, "windows");
		_tmp9_ = _variant_get1 ((GVariant*) _tmp8_, &_tmp9__length1);
		window_ids = (g_free (window_ids), NULL);
		window_ids = _tmp9_;
		window_ids_length1 = _tmp9__length1;
		_window_ids_size_ = window_ids_length1;
	}
	windows = NULL;
	_tmp10_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp10_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp11_;
			MetaWorkspace* workspace = NULL;
			_tmp11_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp11_;
			{
				MetaWorkspace* _tmp12_;
				GList* _tmp13_;
				_tmp12_ = workspace;
				_tmp13_ = meta_workspace_list_windows (_tmp12_);
				{
					GList* window_collection = NULL;
					GList* window_it = NULL;
					window_collection = _tmp13_;
					for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
						MetaWindow* window = NULL;
						window = (MetaWindow*) window_it->data;
						{
							gboolean _tmp14_ = FALSE;
							MetaWindow* _tmp15_;
							MetaWindowType _tmp16_;
							MetaWindowType _tmp17_;
							gboolean _tmp21_ = FALSE;
							gboolean _tmp22_ = FALSE;
							gboolean _tmp23_ = FALSE;
							MetaWindow* _tmp24_;
							MetaWindowType _tmp25_;
							MetaWindowType _tmp26_;
							gboolean _tmp38_ = FALSE;
							MetaWindow* _tmp39_;
							gboolean _tmp40_;
							gboolean _tmp41_;
							MetaWindow* _tmp45_;
							MetaWindow* _tmp46_;
							_tmp15_ = window;
							_tmp16_ = meta_window_get_window_type (_tmp15_);
							_tmp17_ = _tmp16_;
							if (_tmp17_ == META_WINDOW_DOCK) {
								_tmp14_ = TRUE;
							} else {
								MetaWindow* _tmp18_;
								MetaWindowType _tmp19_;
								MetaWindowType _tmp20_;
								_tmp18_ = window;
								_tmp19_ = meta_window_get_window_type (_tmp18_);
								_tmp20_ = _tmp19_;
								_tmp14_ = _tmp20_ == META_WINDOW_NOTIFICATION;
							}
							if (_tmp14_) {
								continue;
							}
							_tmp24_ = window;
							_tmp25_ = meta_window_get_window_type (_tmp24_);
							_tmp26_ = _tmp25_;
							if (_tmp26_ != META_WINDOW_NORMAL) {
								MetaWindow* _tmp27_;
								MetaWindowType _tmp28_;
								MetaWindowType _tmp29_;
								_tmp27_ = window;
								_tmp28_ = meta_window_get_window_type (_tmp27_);
								_tmp29_ = _tmp28_;
								_tmp23_ = _tmp29_ != META_WINDOW_DIALOG;
							} else {
								_tmp23_ = FALSE;
							}
							if (_tmp23_) {
								_tmp22_ = TRUE;
							} else {
								MetaWindow* _tmp30_;
								_tmp30_ = window;
								_tmp22_ = meta_window_is_attached_dialog (_tmp30_);
							}
							if (_tmp22_) {
								_tmp21_ = TRUE;
							} else {
								gboolean _tmp31_ = FALSE;
								guint64* _tmp32_;
								gint _tmp32__length1;
								_tmp32_ = window_ids;
								_tmp32__length1 = window_ids_length1;
								if (_tmp32_ != NULL) {
									MetaWindow* _tmp33_;
									guint64* _tmp34_;
									gint _tmp34__length1;
									_tmp33_ = window;
									_tmp34_ = window_ids;
									_tmp34__length1 = window_ids_length1;
									_tmp31_ = !_vala_uint64_array_contains (_tmp34_, _tmp34__length1, meta_window_get_id (_tmp33_));
								} else {
									_tmp31_ = FALSE;
								}
								_tmp21_ = _tmp31_;
							}
							if (_tmp21_) {
								MetaWindowActor* actor = NULL;
								MetaWindow* _tmp35_;
								GObject* _tmp36_;
								MetaWindowActor* _tmp37_;
								_tmp35_ = window;
								_tmp36_ = meta_window_get_compositor_private (_tmp35_);
								actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, meta_window_actor_get_type (), MetaWindowActor);
								_tmp37_ = actor;
								clutter_actor_hide ((ClutterActor*) _tmp37_);
								continue;
							}
							_tmp39_ = window;
							g_object_get (_tmp39_, "on-all-workspaces", &_tmp40_, NULL);
							_tmp41_ = _tmp40_;
							if (_tmp41_) {
								MetaWindow* _tmp42_;
								MetaWorkspace* _tmp43_;
								MetaWorkspace* _tmp44_;
								_tmp42_ = window;
								_tmp43_ = meta_window_get_workspace (_tmp42_);
								_tmp44_ = workspace;
								_tmp38_ = _tmp43_ != _tmp44_;
							} else {
								_tmp38_ = FALSE;
							}
							if (_tmp38_) {
								continue;
							}
							_tmp45_ = window;
							_tmp46_ = _g_object_ref0 (_tmp45_);
							windows = g_list_append (windows, _tmp46_);
						}
					}
					(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
				}
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp47_ = windows;
	if (vala_g_list_is_empty (_tmp47_)) {
		(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
		window_ids = (g_free (window_ids), NULL);
		return;
	}
	_tmp48_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp48_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp49_;
			MetaWorkspace* workspace = NULL;
			_tmp49_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp49_;
			{
				MetaWorkspace* _tmp50_;
				MetaWorkspace* _tmp51_;
				_tmp50_ = workspace;
				g_signal_connect_object (_tmp50_, "window-added", (GCallback) _gala_window_overview_add_window_meta_workspace_window_added, self, 0);
				_tmp51_ = workspace;
				g_signal_connect_object (_tmp51_, "window-removed", (GCallback) _gala_window_overview_remove_window_meta_workspace_window_removed, self, 0);
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp52_ = self->priv->_wm;
	_tmp53_ = meta_plugin_get_display ((MetaPlugin*) _tmp52_);
	g_signal_connect_object (_tmp53_, "window-left-monitor", (GCallback) _gala_window_overview_window_left_monitor_meta_display_window_left_monitor, self, 0);
	clutter_actor_grab_key_focus ((ClutterActor*) self);
	_tmp54_ = self->priv->_wm;
	_tmp55_ = gala_window_manager_push_modal (_tmp54_, (ClutterActor*) self);
	_g_object_unref0 (self->priv->modal_proxy);
	self->priv->modal_proxy = _tmp55_;
	_tmp56_ = self->priv->modal_proxy;
	gala_modal_proxy_set_keybinding_filter (_tmp56_, _gala_window_overview_keybinding_filter_gala_keybinding_filter, self);
	_tmp57_ = self->priv->_wm;
	_tmp58_ = meta_plugin_get_display ((MetaPlugin*) _tmp57_);
	display = _tmp58_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp59_ = FALSE;
			_tmp59_ = TRUE;
			while (TRUE) {
				MetaDisplay* _tmp61_;
				MtkRectangle geometry = {0};
				MetaDisplay* _tmp62_;
				MtkRectangle _tmp63_ = {0};
				gfloat scale = 0.0F;
				MetaDisplay* _tmp64_;
				GalaWindowManager* _tmp65_;
				MtkRectangle _tmp66_;
				MtkRectangle _tmp67_;
				MtkRectangle _tmp68_;
				MtkRectangle _tmp69_;
				GalaWindowCloneContainer* _tmp70_ = NULL;
				GalaWindowCloneContainer* _tmp71_;
				GalaWindowCloneContainer* _tmp72_;
				GalaWindowCloneContainer* _tmp73_;
				if (!_tmp59_) {
					gint _tmp60_;
					_tmp60_ = i;
					i = _tmp60_ + 1;
				}
				_tmp59_ = FALSE;
				_tmp61_ = display;
				if (!(i < meta_display_get_n_monitors (_tmp61_))) {
					break;
				}
				_tmp62_ = display;
				meta_display_get_monitor_geometry (_tmp62_, i, &_tmp63_);
				geometry = _tmp63_;
				_tmp64_ = display;
				scale = meta_display_get_monitor_scale (_tmp64_, i);
				_tmp65_ = self->priv->_wm;
				_tmp66_ = geometry;
				_tmp67_ = geometry;
				_tmp68_ = geometry;
				_tmp69_ = geometry;
				_tmp70_ = gala_window_clone_container_new (_tmp65_, NULL, scale, TRUE);
				gala_window_clone_container_set_padding_top (_tmp70_, GALA_WINDOW_OVERVIEW_TOP_GAP);
				gala_window_clone_container_set_padding_left (_tmp70_, GALA_WINDOW_OVERVIEW_BORDER);
				gala_window_clone_container_set_padding_right (_tmp70_, GALA_WINDOW_OVERVIEW_BORDER);
				gala_window_clone_container_set_padding_bottom (_tmp70_, GALA_WINDOW_OVERVIEW_BOTTOM_GAP);
				clutter_actor_set_width ((ClutterActor*) _tmp70_, (gfloat) _tmp66_.width);
				clutter_actor_set_height ((ClutterActor*) _tmp70_, (gfloat) _tmp67_.height);
				clutter_actor_set_x ((ClutterActor*) _tmp70_, (gfloat) _tmp68_.x);
				clutter_actor_set_y ((ClutterActor*) _tmp70_, (gfloat) _tmp69_.y);
				g_object_ref_sink (_tmp70_);
				_g_object_unref0 (self->priv->window_clone_container);
				self->priv->window_clone_container = _tmp70_;
				_tmp71_ = self->priv->window_clone_container;
				g_signal_connect_object (_tmp71_, "window-selected", (GCallback) _gala_window_overview_thumb_selected_gala_window_clone_container_window_selected, self, 0);
				_tmp72_ = self->priv->window_clone_container;
				g_signal_connect_object (_tmp72_, "requested-close", (GCallback) ______lambda152__gala_window_clone_container_requested_close, self, 0);
				_tmp73_ = self->priv->window_clone_container;
				clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp73_);
			}
		}
	}
	g_object_set ((ClutterActor*) self, "visible", TRUE, NULL);
	_tmp74_ = windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp74_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindowActor* actor = NULL;
				MetaWindow* _tmp75_;
				GObject* _tmp76_;
				MetaWindowActor* _tmp77_;
				GalaWindowCloneContainer* container = NULL;
				MetaWindow* _tmp78_;
				ClutterActor* _tmp79_;
				GalaWindowCloneContainer* _tmp80_;
				GalaWindowCloneContainer* _tmp81_;
				MetaWindow* _tmp82_;
				GalaWindowCloneContainer* _tmp83_;
				MetaDisplay* _tmp84_;
				MetaWindow* _tmp85_;
				_tmp75_ = window;
				_tmp76_ = meta_window_get_compositor_private (_tmp75_);
				actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, meta_window_actor_get_type (), MetaWindowActor);
				_tmp77_ = actor;
				clutter_actor_hide ((ClutterActor*) _tmp77_);
				_tmp78_ = window;
				_tmp79_ = clutter_actor_get_child_at_index ((ClutterActor*) self, meta_window_get_monitor (_tmp78_));
				container = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
				_tmp80_ = container;
				if (_tmp80_ == NULL) {
					continue;
				}
				_tmp81_ = container;
				_tmp82_ = window;
				gala_window_clone_container_add_window (_tmp81_, _tmp82_);
				_tmp83_ = container;
				_tmp84_ = display;
				_tmp85_ = meta_display_get_focus_window (_tmp84_);
				gala_window_clone_container_open (_tmp83_, _tmp85_, FALSE, FALSE);
			}
		}
	}
	(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
	window_ids = (g_free (window_ids), NULL);
}

static gboolean
gala_window_overview_keybinding_filter (GalaWindowOverview* self,
                                        MetaKeyBinding* binding)
{
	MetaKeyBindingAction action = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	static GQuark _tmp3_label2 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (binding != NULL, FALSE);
	_tmp0_ = meta_key_binding_get_name (binding);
	action = meta_prefs_get_keybinding_action (_tmp0_);
	switch (action) {
		case META_KEYBINDING_ACTION_NONE:
		case META_KEYBINDING_ACTION_LOCATE_POINTER_KEY:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp1_ = meta_key_binding_get_name (binding);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (((_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("expose-all-windows")))) || (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("zoom-in"))))) || (_tmp4_ == ((0 != _tmp3_label2) ? _tmp3_label2 : (_tmp3_label2 = g_quark_from_static_string ("zoom-out"))))) {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	result = TRUE;
	return result;
}

static void
gala_window_overview_restack_windows (GalaWindowOverview* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp1_;
				_tmp1_ = child;
				gala_window_clone_container_restack_windows (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer));
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
gala_window_overview_window_left_monitor (GalaWindowOverview* self,
                                          gint num,
                                          MetaWindow* window)
{
	GalaWindowCloneContainer* container = NULL;
	ClutterActor* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = clutter_actor_get_child_at_index ((ClutterActor*) self, num);
	container = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_tmp1_ = container;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp2_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp3_;
			MetaWorkspace* workspace = NULL;
			_tmp3_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp3_;
			{
				MetaWorkspace* _tmp4_;
				_tmp4_ = workspace;
				if (meta_window_located_on_workspace (window, _tmp4_)) {
					GalaWindowCloneContainer* _tmp5_;
					_tmp5_ = container;
					gala_window_clone_container_remove_window (_tmp5_, window);
					_g_object_unref0 (workspace);
					break;
				}
				_g_object_unref0 (workspace);
			}
		}
	}
}

static void
gala_window_overview_add_window (GalaWindowOverview* self,
                                 MetaWindow* window)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	MetaWindowType _tmp3_;
	MetaWindowType _tmp4_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	MetaWindowType _tmp9_;
	MetaWindowType _tmp10_;
	GalaWindowCloneContainer* container = NULL;
	ClutterActor* _tmp15_;
	GalaWindowCloneContainer* _tmp16_;
	GList* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp3_ = meta_window_get_window_type (window);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == META_WINDOW_DOCK) {
		_tmp2_ = TRUE;
	} else {
		MetaWindowType _tmp5_;
		MetaWindowType _tmp6_;
		_tmp5_ = meta_window_get_window_type (window);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == META_WINDOW_NOTIFICATION;
	}
	if (_tmp2_) {
		return;
	}
	_tmp9_ = meta_window_get_window_type (window);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != META_WINDOW_NORMAL) {
		MetaWindowType _tmp11_;
		MetaWindowType _tmp12_;
		_tmp11_ = meta_window_get_window_type (window);
		_tmp12_ = _tmp11_;
		_tmp8_ = _tmp12_ != META_WINDOW_DIALOG;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = meta_window_is_attached_dialog (window);
	}
	if (_tmp7_) {
		MetaWindowActor* actor = NULL;
		GObject* _tmp13_;
		MetaWindowActor* _tmp14_;
		_tmp13_ = meta_window_get_compositor_private (window);
		actor = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, meta_window_actor_get_type (), MetaWindowActor);
		_tmp14_ = actor;
		clutter_actor_hide ((ClutterActor*) _tmp14_);
		return;
	}
	_tmp15_ = clutter_actor_get_child_at_index ((ClutterActor*) self, meta_window_get_monitor (window));
	container = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_tmp16_ = container;
	if (_tmp16_ == NULL) {
		return;
	}
	_tmp17_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp17_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp18_;
			MetaWorkspace* workspace = NULL;
			_tmp18_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp18_;
			{
				MetaWorkspace* _tmp19_;
				_tmp19_ = workspace;
				if (meta_window_located_on_workspace (window, _tmp19_)) {
					GalaWindowCloneContainer* _tmp20_;
					_tmp20_ = container;
					gala_window_clone_container_add_window (_tmp20_, window);
					_g_object_unref0 (workspace);
					break;
				}
				_g_object_unref0 (workspace);
			}
		}
	}
}

static void
gala_window_overview_remove_window (GalaWindowOverview* self,
                                    MetaWindow* window)
{
	GalaWindowCloneContainer* container = NULL;
	ClutterActor* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	GalaWindowCloneContainer* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = clutter_actor_get_child_at_index ((ClutterActor*) self, meta_window_get_monitor (window));
	container = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_tmp1_ = container;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = container;
	gala_window_clone_container_remove_window (_tmp2_, window);
}

static Block70Data*
block70_data_ref (Block70Data* _data70_)
{
	g_atomic_int_inc (&_data70_->_ref_count_);
	return _data70_;
}

static void
block70_data_unref (void * _userdata_)
{
	Block70Data* _data70_;
	_data70_ = (Block70Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data70_->_ref_count_)) {
		GalaWindowOverview* self;
		self = _data70_->self;
		_g_object_unref0 (_data70_->window);
		_g_object_unref0 (self);
		g_slice_free (Block70Data, _data70_);
	}
}

static gboolean
___lambda151_ (Block70Data* _data70_)
{
	GalaWindowOverview* self;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	gboolean result;
	self = _data70_->self;
	_tmp0_ = meta_window_get_workspace (_data70_->window);
	_tmp1_ = meta_window_get_display (_data70_->window);
	meta_workspace_activate_with_focus (_tmp0_, _data70_->window, meta_display_get_current_time (_tmp1_));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda151__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda151_ (self);
	return result;
}

static void
gala_window_overview_thumb_selected (GalaWindowOverview* self,
                                     MetaWindow* window)
{
	Block70Data* _data70_;
	MetaWindow* _tmp0_;
	MetaWorkspace* _tmp1_;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspace* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_data70_ = g_slice_new0 (Block70Data);
	_data70_->_ref_count_ = 1;
	_data70_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (window);
	_g_object_unref0 (_data70_->window);
	_data70_->window = _tmp0_;
	_tmp1_ = meta_window_get_workspace (_data70_->window);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	_tmp5_ = meta_workspace_manager_get_active_workspace (_tmp4_);
	if (_tmp1_ == _tmp5_) {
		MetaDisplay* _tmp6_;
		_tmp6_ = meta_window_get_display (_data70_->window);
		meta_window_activate (_data70_->window, meta_display_get_current_time (_tmp6_));
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
	} else {
		gala_activatable_component_close ((GalaActivatableComponent*) self, NULL);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION, ____lambda151__gsource_func, block70_data_ref (_data70_), block70_data_unref);
	}
	block70_data_unref (_data70_);
	_data70_ = NULL;
}

/**
     * {@inheritDoc}
     */
static gboolean
__lambda150_ (GalaWindowOverview* self)
{
	gboolean result;
	gala_window_overview_cleanup (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda150__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda150_ ((GalaWindowOverview*) self);
	return result;
}

static void
gala_window_overview_real_close (GalaActivatableComponent* base,
                                 GHashTable* hints)
{
	GalaWindowOverview * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GList* _tmp2_;
	GalaWindowManager* _tmp8_;
	MetaDisplay* _tmp9_;
	guint _tmp10_;
	GList* _tmp11_;
	self = (GalaWindowOverview*) base;
	g_object_get ((ClutterActor*) self, "visible", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	gala_window_overview_restack_windows (self);
	_tmp2_ = self->priv->workspaces;
	{
		GList* workspace_collection = NULL;
		GList* workspace_it = NULL;
		workspace_collection = _tmp2_;
		for (workspace_it = workspace_collection; workspace_it != NULL; workspace_it = workspace_it->next) {
			MetaWorkspace* _tmp3_;
			MetaWorkspace* workspace = NULL;
			_tmp3_ = _g_object_ref0 ((MetaWorkspace*) workspace_it->data);
			workspace = _tmp3_;
			{
				MetaWorkspace* _tmp4_;
				guint _tmp5_;
				MetaWorkspace* _tmp6_;
				guint _tmp7_;
				_tmp4_ = workspace;
				g_signal_parse_name ("window-added", meta_workspace_get_type (), &_tmp5_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _gala_window_overview_add_window_meta_workspace_window_added, self);
				_tmp6_ = workspace;
				g_signal_parse_name ("window-removed", meta_workspace_get_type (), &_tmp7_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _gala_window_overview_remove_window_meta_workspace_window_removed, self);
				_g_object_unref0 (workspace);
			}
		}
	}
	_tmp8_ = self->priv->_wm;
	_tmp9_ = meta_plugin_get_display ((MetaPlugin*) _tmp8_);
	g_signal_parse_name ("window-left-monitor", meta_display_get_type (), &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _gala_window_overview_window_left_monitor_meta_display_window_left_monitor, self);
	_tmp11_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp11_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp12_;
				_tmp12_ = child;
				gala_window_clone_container_close (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer), FALSE, FALSE);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	clutter_threads_add_timeout ((guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION, ___lambda150__gsource_func, self);
}

static void
gala_window_overview_cleanup (GalaWindowOverview* self)
{
	GalaWindowManager* _tmp0_;
	GalaModalProxy* _tmp1_;
	GalaWindowManager* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspace* _tmp5_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = self->priv->modal_proxy;
	gala_window_manager_pop_modal (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	_tmp5_ = meta_workspace_manager_get_active_workspace (_tmp4_);
	_tmp6_ = meta_workspace_list_windows (_tmp5_);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp6_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp7_;
				_tmp7_ = window;
				if (meta_window_showing_on_its_workspace (_tmp7_)) {
					MetaWindow* _tmp8_;
					GObject* _tmp9_;
					_tmp8_ = window;
					_tmp9_ = meta_window_get_compositor_private (_tmp8_);
					clutter_actor_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, clutter_actor_get_type (), ClutterActor));
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	clutter_actor_destroy_all_children ((ClutterActor*) self);
}

GalaWindowManager*
gala_window_overview_get_wm (GalaWindowOverview* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_overview_set_wm (GalaWindowOverview* self,
                             GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_overview_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_overview_properties[GALA_WINDOW_OVERVIEW_WM_PROPERTY]);
	}
}

static GObject *
gala_window_overview_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowOverview * self;
	parent_class = G_OBJECT_CLASS (gala_window_overview_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	return obj;
}

static void
gala_window_overview_class_init (GalaWindowOverviewClass * klass,
                                 gpointer klass_data)
{
	gala_window_overview_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowOverview_private_offset);
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_overview_real_key_press_event;
	((ClutterActorClass *) klass)->button_release_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_overview_real_button_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_overview_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_overview_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_overview_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_overview_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_OVERVIEW_WM_PROPERTY, gala_window_overview_properties[GALA_WINDOW_OVERVIEW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_window_overview_gala_activatable_component_interface_init (GalaActivatableComponentIface * iface,
                                                                gpointer iface_data)
{
	gala_window_overview_gala_activatable_component_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_opened = (gboolean (*) (GalaActivatableComponent*)) gala_window_overview_real_is_opened;
	iface->open = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_window_overview_real_open;
	iface->close = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_window_overview_real_close;
}

static void
gala_window_overview_instance_init (GalaWindowOverview * self,
                                    gpointer klass)
{
	self->priv = gala_window_overview_get_instance_private (self);
}

static void
gala_window_overview_finalize (GObject * obj)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->modal_proxy);
	(self->priv->workspaces == NULL) ? NULL : (self->priv->workspaces = (_g_list_free__g_object_unref0_ (self->priv->workspaces), NULL));
	_g_object_unref0 (self->priv->window_clone_container);
	G_OBJECT_CLASS (gala_window_overview_parent_class)->finalize (obj);
}

static GType
gala_window_overview_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowOverviewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_overview_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowOverview), 0, (GInstanceInitFunc) gala_window_overview_instance_init, NULL };
	static const GInterfaceInfo gala_activatable_component_info = { (GInterfaceInitFunc) gala_window_overview_gala_activatable_component_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_window_overview_type_id;
	gala_window_overview_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowOverview", &g_define_type_info, 0);
	g_type_add_interface_static (gala_window_overview_type_id, GALA_TYPE_ACTIVATABLE_COMPONENT, &gala_activatable_component_info);
	GalaWindowOverview_private_offset = g_type_add_instance_private (gala_window_overview_type_id, sizeof (GalaWindowOverviewPrivate));
	return gala_window_overview_type_id;
}

GType
gala_window_overview_get_type (void)
{
	static volatile gsize gala_window_overview_type_id__once = 0;
	if (g_once_init_enter (&gala_window_overview_type_id__once)) {
		GType gala_window_overview_type_id;
		gala_window_overview_type_id = gala_window_overview_get_type_once ();
		g_once_init_leave (&gala_window_overview_type_id__once, gala_window_overview_type_id);
	}
	return gala_window_overview_type_id__once;
}

static void
_vala_gala_window_overview_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	switch (property_id) {
		case GALA_WINDOW_OVERVIEW_WM_PROPERTY:
		g_value_set_object (value, gala_window_overview_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_overview_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GalaWindowOverview * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_OVERVIEW, GalaWindowOverview);
	switch (property_id) {
		case GALA_WINDOW_OVERVIEW_WM_PROPERTY:
		gala_window_overview_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

