/* WindowCloneContainer.c generated by valac 0.56.16, the Vala compiler
 * generated from WindowCloneContainer.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include "gala.h"
#include <float.h>
#include <math.h>
#include <meta/window.h>
#include <meta/display.h>
#include <meta/meta-plugin.h>
#include <mtk/mtk.h>
#include <meta/common.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
typedef struct _GalaWindowCloneContainerPrivate GalaWindowCloneContainerPrivate;

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
enum  {
	GALA_WINDOW_CLONE_CONTAINER_0_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_GESTURE_TRACKER_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_INTERNAL_UTILS_TYPE_TILABLE_WINDOW (gala_internal_utils_tilable_window_get_type ())
typedef struct _GalaInternalUtilsTilableWindow GalaInternalUtilsTilableWindow;
#define _gala_internal_utils_tilable_window_free0(var) ((var == NULL) ? NULL : (var = (gala_internal_utils_tilable_window_free (var), NULL)))
#define __vala_MtkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_MtkRectangle_free (var), NULL)))
enum  {
	GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL,
	GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL,
	GALA_WINDOW_CLONE_CONTAINER_NUM_SIGNALS
};
static guint gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_NUM_SIGNALS] = {0};

struct _GalaWindowCloneContainer {
	ClutterActor parent_instance;
	GalaWindowCloneContainerPrivate * priv;
};

struct _GalaWindowCloneContainerClass {
	ClutterActorClass parent_class;
};

struct _GalaWindowCloneContainerPrivate {
	gint _padding_top;
	gint _padding_left;
	gint _padding_right;
	gint _padding_bottom;
	GalaWindowManager* _wm;
	GalaGestureTracker* _gesture_tracker;
	gboolean _overview_mode;
	gfloat _monitor_scale;
	gboolean opened;
	GalaWindowClone* current_window;
};

struct _GalaInternalUtilsTilableWindow {
	MtkRectangle rect;
	GalaWindowClone* id;
};

static gint GalaWindowCloneContainer_private_offset;
static gpointer gala_window_clone_container_parent_class = NULL;

VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           GalaGestureTracker* gesture_tracker,
                                                           gfloat scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 GalaGestureTracker* gesture_tracker,
                                                                 gfloat scale,
                                                                 gboolean overview_mode);
static void gala_window_clone_container_reallocate (GalaWindowCloneContainer* self);
VALA_EXTERN gfloat gala_window_clone_container_get_monitor_scale (GalaWindowCloneContainer* self);
VALA_EXTERN void gala_window_clone_set_monitor_scale_factor (GalaWindowClone* self,
                                                 gfloat value);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
VALA_EXTERN GSList* gala_internal_utils_sort_windows (MetaDisplay* display,
                                          GList* windows);
VALA_EXTERN GalaWindowManager* gala_window_clone_container_get_wm (GalaWindowCloneContainer* self);
VALA_EXTERN GalaGestureTracker* gala_window_clone_container_get_gesture_tracker (GalaWindowCloneContainer* self);
VALA_EXTERN gboolean gala_window_clone_container_get_overview_mode (GalaWindowCloneContainer* self);
VALA_EXTERN GalaWindowClone* gala_window_clone_new (GalaWindowManager* wm,
                                        MetaWindow* window,
                                        GalaGestureTracker* gesture_tracker,
                                        gfloat scale,
                                        gboolean overview_mode);
VALA_EXTERN GalaWindowClone* gala_window_clone_construct (GType object_type,
                                              GalaWindowManager* wm,
                                              MetaWindow* window,
                                              GalaGestureTracker* gesture_tracker,
                                              gfloat scale,
                                              gboolean overview_mode);
static void __lambda23_ (GalaWindowCloneContainer* self,
                  GalaWindowClone* clone);
static void ___lambda23__gala_window_clone_selected (GalaWindowClone* _sender,
                                              gpointer self);
static void __lambda24_ (GalaWindowCloneContainer* self);
VALA_EXTERN void gala_window_clone_container_reflow (GalaWindowCloneContainer* self,
                                         gboolean with_gesture,
                                         gboolean is_cancel_animation);
static void ___lambda24__clutter_actor_destroy (ClutterActor* _sender,
                                         gpointer self);
static void __lambda29_ (GalaWindowCloneContainer* self);
static void ___lambda29__gala_window_clone_request_reposition (GalaWindowClone* _sender,
                                                        gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
VALA_EXTERN void gala_window_clone_container_restack_windows (GalaWindowCloneContainer* self);
VALA_EXTERN GType gala_internal_utils_tilable_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaInternalUtilsTilableWindow* gala_internal_utils_tilable_window_dup (const GalaInternalUtilsTilableWindow* self);
VALA_EXTERN void gala_internal_utils_tilable_window_free (GalaInternalUtilsTilableWindow* self);
static void _gala_internal_utils_tilable_window_free0_ (gpointer var);
static inline void _g_list_free__gala_internal_utils_tilable_window_free0_ (GList* self);
static gint __lambda25_ (GalaInternalUtilsTilableWindow* a,
                  GalaInternalUtilsTilableWindow* b);
static gint ___lambda25__gcompare_func (gconstpointer a,
                                 gconstpointer b);
VALA_EXTERN gint gala_window_clone_container_get_padding_left (GalaWindowCloneContainer* self);
VALA_EXTERN gint gala_window_clone_container_get_padding_top (GalaWindowCloneContainer* self);
VALA_EXTERN gint gala_window_clone_container_get_padding_right (GalaWindowCloneContainer* self);
VALA_EXTERN gint gala_window_clone_container_get_padding_bottom (GalaWindowCloneContainer* self);
VALA_EXTERN GList* gala_internal_utils_calculate_grid_placement (MtkRectangle* area,
                                                     GList* windows);
VALA_EXTERN void gala_window_clone_take_slot (GalaWindowClone* self,
                                  MtkRectangle* rect,
                                  gboolean with_gesture,
                                  gboolean is_cancel_animation);
static gboolean gala_window_clone_container_real_key_press_event (ClutterActor* base,
                                                           ClutterEvent* event);
VALA_EXTERN void gala_window_clone_container_select_next_window (GalaWindowCloneContainer* self,
                                                     MetaMotionDirection direction);
VALA_EXTERN gboolean gala_window_clone_container_activate_selected_window (GalaWindowCloneContainer* self);
VALA_EXTERN MtkRectangle* gala_window_clone_get_slot (GalaWindowClone* self);
static MtkRectangle* _vala_MtkRectangle_copy (MtkRectangle* self);
static void _vala_MtkRectangle_free (MtkRectangle* self);
VALA_EXTERN void gala_window_clone_set_active (GalaWindowClone* self,
                                   gboolean value);
VALA_EXTERN void gala_window_clone_container_open (GalaWindowCloneContainer* self,
                                       MetaWindow* selected_window,
                                       gboolean with_gesture,
                                       gboolean is_cancel_animation);
VALA_EXTERN void gala_window_clone_transition_to_original_state (GalaWindowClone* self,
                                                     gboolean animate,
                                                     gboolean with_gesture,
                                                     gboolean is_cancel_animation);
VALA_EXTERN void gala_window_clone_container_close (GalaWindowCloneContainer* self,
                                        gboolean with_gesture,
                                        gboolean is_cancel_animation);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
static void gala_window_clone_container_set_wm (GalaWindowCloneContainer* self,
                                         GalaWindowManager* value);
static void gala_window_clone_container_set_gesture_tracker (GalaWindowCloneContainer* self,
                                                      GalaGestureTracker* value);
static void gala_window_clone_container_set_overview_mode (GalaWindowCloneContainer* self,
                                                    gboolean value);
VALA_EXTERN void gala_window_clone_container_set_monitor_scale (GalaWindowCloneContainer* self,
                                                    gfloat value);
static void gala_window_clone_container_finalize (GObject * obj);
static GType gala_window_clone_container_get_type_once (void);
static void _vala_gala_window_clone_container_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_gala_window_clone_container_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_window_clone_container_get_instance_private (GalaWindowCloneContainer* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowCloneContainer_private_offset);
}

GalaWindowCloneContainer*
gala_window_clone_container_construct (GType object_type,
                                       GalaWindowManager* wm,
                                       GalaGestureTracker* gesture_tracker,
                                       gfloat scale,
                                       gboolean overview_mode)
{
	GalaWindowCloneContainer * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaWindowCloneContainer*) g_object_new (object_type, "wm", wm, "gesture-tracker", gesture_tracker, "monitor-scale", scale, "overview-mode", overview_mode, NULL);
	return self;
}

GalaWindowCloneContainer*
gala_window_clone_container_new (GalaWindowManager* wm,
                                 GalaGestureTracker* gesture_tracker,
                                 gfloat scale,
                                 gboolean overview_mode)
{
	return gala_window_clone_container_construct (GALA_TYPE_WINDOW_CLONE_CONTAINER, wm, gesture_tracker, scale, overview_mode);
}

static void
gala_window_clone_container_reallocate (GalaWindowCloneContainer* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWindowClone* clone = NULL;
				ClutterActor* _tmp1_;
				GalaWindowClone* _tmp2_;
				gfloat _tmp3_;
				gfloat _tmp4_;
				_tmp1_ = child;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
				_tmp2_ = clone;
				_tmp3_ = gala_window_clone_container_get_monitor_scale (self);
				_tmp4_ = _tmp3_;
				gala_window_clone_set_monitor_scale_factor (_tmp2_, _tmp4_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

/**
         * Create a WindowClone for a MetaWindow and add it to the group
         *
         * @param window The window for which to create the WindowClone for
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda23_ (GalaWindowCloneContainer* self,
             GalaWindowClone* clone)
{
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	g_return_if_fail (clone != NULL);
	_tmp0_ = gala_window_clone_get_window (clone);
	_tmp1_ = _tmp0_;
	g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL], 0, _tmp1_);
}

static void
___lambda23__gala_window_clone_selected (GalaWindowClone* _sender,
                                         gpointer self)
{
	__lambda23_ ((GalaWindowCloneContainer*) self, _sender);
}

static void
__lambda24_ (GalaWindowCloneContainer* self)
{
	gala_window_clone_container_reflow (self, FALSE, FALSE);
}

static void
___lambda24__clutter_actor_destroy (ClutterActor* _sender,
                                    gpointer self)
{
	__lambda24_ ((GalaWindowCloneContainer*) self);
}

static void
__lambda29_ (GalaWindowCloneContainer* self)
{
	gala_window_clone_container_reflow (self, FALSE, FALSE);
}

static void
___lambda29__gala_window_clone_request_reposition (GalaWindowClone* _sender,
                                                   gpointer self)
{
	__lambda29_ ((GalaWindowCloneContainer*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                        MetaWindow* window)
{
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp0_;
	GList* windows = NULL;
	GList* _tmp1_;
	MetaWindow* _tmp7_;
	GSList* windows_ordered = NULL;
	MetaDisplay* _tmp8_;
	GList* _tmp9_;
	GSList* _tmp10_;
	GalaWindowClone* new_window = NULL;
	GalaWindowManager* _tmp11_;
	GalaGestureTracker* _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	gboolean _tmp15_;
	GalaWindowClone* _tmp16_;
	GalaWindowClone* _tmp17_;
	GalaWindowClone* _tmp18_;
	GalaWindowClone* _tmp19_;
	MetaWindow* target = NULL;
	GSList* _tmp20_;
	MetaWindow* _tmp23_;
	GList* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = meta_window_get_display (window);
	display = _tmp0_;
	windows = NULL;
	_tmp1_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWindowClone* clone = NULL;
				ClutterActor* _tmp2_;
				GalaWindowClone* _tmp3_;
				MetaWindow* _tmp4_;
				MetaWindow* _tmp5_;
				MetaWindow* _tmp6_;
				_tmp2_ = child;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
				_tmp3_ = clone;
				_tmp4_ = gala_window_clone_get_window (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				windows = g_list_append (windows, _tmp6_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp7_ = _g_object_ref0 (window);
	windows = g_list_append (windows, _tmp7_);
	_tmp8_ = display;
	_tmp9_ = windows;
	_tmp10_ = gala_internal_utils_sort_windows (_tmp8_, _tmp9_);
	windows_ordered = _tmp10_;
	_tmp11_ = self->priv->_wm;
	_tmp12_ = self->priv->_gesture_tracker;
	_tmp13_ = gala_window_clone_container_get_monitor_scale (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->_overview_mode;
	_tmp16_ = gala_window_clone_new (_tmp11_, window, _tmp12_, _tmp14_, _tmp15_);
	g_object_ref_sink (_tmp16_);
	new_window = _tmp16_;
	_tmp17_ = new_window;
	g_signal_connect_object (_tmp17_, "selected", (GCallback) ___lambda23__gala_window_clone_selected, self, 0);
	_tmp18_ = new_window;
	g_signal_connect_object ((ClutterActor*) _tmp18_, "destroy", (GCallback) ___lambda24__clutter_actor_destroy, self, 0);
	_tmp19_ = new_window;
	g_signal_connect_object (_tmp19_, "request-reposition", (GCallback) ___lambda29__gala_window_clone_request_reposition, self, 0);
	target = NULL;
	_tmp20_ = windows_ordered;
	{
		GSList* w_collection = NULL;
		GSList* w_it = NULL;
		w_collection = _tmp20_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			MetaWindow* w = NULL;
			w = (MetaWindow*) w_it->data;
			{
				MetaWindow* _tmp21_;
				_tmp21_ = w;
				if (_tmp21_ != window) {
					MetaWindow* _tmp22_;
					_tmp22_ = w;
					target = _tmp22_;
					continue;
				}
				break;
			}
		}
	}
	_tmp23_ = target;
	if (_tmp23_ == NULL) {
		GalaWindowClone* _tmp24_;
		_tmp24_ = new_window;
		clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp24_);
	}
	_tmp25_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp25_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWindowClone* clone = NULL;
				ClutterActor* _tmp26_;
				MetaWindow* _tmp27_;
				GalaWindowClone* _tmp28_;
				MetaWindow* _tmp29_;
				MetaWindow* _tmp30_;
				_tmp26_ = child;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
				_tmp27_ = target;
				_tmp28_ = clone;
				_tmp29_ = gala_window_clone_get_window (_tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp27_ == _tmp30_) {
					GalaWindowClone* _tmp31_;
					GalaWindowClone* _tmp32_;
					_tmp31_ = new_window;
					_tmp32_ = clone;
					clutter_actor_insert_child_below ((ClutterActor*) self, (ClutterActor*) _tmp31_, (ClutterActor*) _tmp32_);
					break;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	gala_window_clone_container_reflow (self, FALSE, FALSE);
	_g_object_unref0 (new_window);
	(windows_ordered == NULL) ? NULL : (windows_ordered = (g_slist_free (windows_ordered), NULL));
	(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
}

/**
         * Find and remove the WindowClone for a MetaWindow
         */
void
gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                           MetaWindow* window)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp1_;
				MetaWindow* _tmp2_;
				MetaWindow* _tmp3_;
				_tmp1_ = child;
				_tmp2_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
				_tmp3_ = _tmp2_;
				if (_tmp3_ == window) {
					ClutterActor* _tmp4_;
					_tmp4_ = child;
					clutter_actor_remove_child ((ClutterActor*) self, _tmp4_);
					gala_window_clone_container_reflow (self, FALSE, FALSE);
					break;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

/**
         * Sort the windows z-order by their actual stacking to make intersections
         * during animations correct.
         */
void
gala_window_clone_container_restack_windows (GalaWindowCloneContainer* self)
{
	GList* children = NULL;
	GList* _tmp0_;
	GList* windows = NULL;
	GList* _tmp1_;
	GSList* windows_ordered = NULL;
	GalaWindowManager* _tmp6_;
	MetaDisplay* _tmp7_;
	GList* _tmp8_;
	GSList* _tmp9_;
	gint i = 0;
	GSList* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	children = _tmp0_;
	windows = NULL;
	_tmp1_ = children;
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp2_;
				MetaWindow* _tmp3_;
				MetaWindow* _tmp4_;
				MetaWindow* _tmp5_;
				_tmp2_ = child;
				_tmp3_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
				_tmp4_ = _tmp3_;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				windows = g_list_prepend (windows, _tmp5_);
			}
		}
	}
	_tmp6_ = self->priv->_wm;
	_tmp7_ = meta_plugin_get_display ((MetaPlugin*) _tmp6_);
	_tmp8_ = windows;
	_tmp9_ = gala_internal_utils_sort_windows (_tmp7_, _tmp8_);
	windows_ordered = _tmp9_;
	windows_ordered = g_slist_reverse (windows_ordered);
	i = 0;
	_tmp10_ = windows_ordered;
	{
		GSList* window_collection = NULL;
		GSList* window_it = NULL;
		window_collection = _tmp10_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				GList* _tmp11_;
				_tmp11_ = children;
				{
					GList* child_collection = NULL;
					GList* child_it = NULL;
					child_collection = _tmp11_;
					for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
						ClutterActor* child = NULL;
						child = (ClutterActor*) child_it->data;
						{
							ClutterActor* _tmp12_;
							MetaWindow* _tmp13_;
							MetaWindow* _tmp14_;
							MetaWindow* _tmp15_;
							_tmp12_ = child;
							_tmp13_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
							_tmp14_ = _tmp13_;
							_tmp15_ = window;
							if (_tmp14_ == _tmp15_) {
								ClutterActor* _tmp16_;
								ClutterActor* _tmp17_;
								gint _tmp18_;
								_tmp16_ = child;
								clutter_actor_set_child_at_index ((ClutterActor*) self, _tmp16_, i);
								_tmp17_ = child;
								children = g_list_remove (children, _tmp17_);
								_tmp18_ = i;
								i = _tmp18_ + 1;
								break;
							}
						}
					}
				}
			}
		}
	}
	(windows_ordered == NULL) ? NULL : (windows_ordered = (g_slist_free (windows_ordered), NULL));
	(windows == NULL) ? NULL : (windows = (_g_list_free__g_object_unref0_ (windows), NULL));
	(children == NULL) ? NULL : (children = (g_list_free (children), NULL));
}

/**
         * Recalculate the tiling positions of the windows and animate them to
         * the resulting spots.
         */
static gpointer
_gala_internal_utils_tilable_window_dup0 (gpointer self)
{
	return self ? gala_internal_utils_tilable_window_dup (self) : NULL;
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

static void
_gala_internal_utils_tilable_window_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gala_internal_utils_tilable_window_free (var), NULL));
}

static inline void
_g_list_free__gala_internal_utils_tilable_window_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gala_internal_utils_tilable_window_free0_);
}

static gint
__lambda25_ (GalaInternalUtilsTilableWindow* a,
             GalaInternalUtilsTilableWindow* b)
{
	guint seq_a = 0U;
	GalaWindowClone* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	guint seq_b = 0U;
	GalaWindowClone* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	gint result;
	_tmp0_ = (*a).id;
	_tmp1_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
	_tmp2_ = _tmp1_;
	seq_a = meta_window_get_stable_sequence (_tmp2_);
	_tmp3_ = (*b).id;
	_tmp4_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
	_tmp5_ = _tmp4_;
	seq_b = meta_window_get_stable_sequence (_tmp5_);
	result = (gint) (seq_b - seq_a);
	return result;
}

static gint
___lambda25__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda25_ ((GalaInternalUtilsTilableWindow*) a, (GalaInternalUtilsTilableWindow*) b);
	return result;
}

void
gala_window_clone_container_reflow (GalaWindowCloneContainer* self,
                                    gboolean with_gesture,
                                    gboolean is_cancel_animation)
{
	GList* windows = NULL;
	GList* _tmp0_;
	GList* _tmp9_;
	MtkRectangle area = {0};
	gint _tmp10_;
	gint _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	MtkRectangle _tmp20_ = {0};
	GList* window_positions = NULL;
	MtkRectangle _tmp21_;
	GList* _tmp22_;
	GList* _tmp23_;
	GList* _tmp24_;
	g_return_if_fail (self != NULL);
	if (!self->priv->opened) {
		return;
	}
	windows = NULL;
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp0_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWindowClone* clone = NULL;
				ClutterActor* _tmp1_;
				GalaWindowClone* _tmp2_;
				MetaWindow* _tmp3_;
				MetaWindow* _tmp4_;
				MtkRectangle _tmp5_ = {0};
				GalaWindowClone* _tmp6_;
				GalaInternalUtilsTilableWindow _tmp7_ = {0};
				GalaInternalUtilsTilableWindow* _tmp8_;
				_tmp1_ = child;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
				_tmp2_ = clone;
				_tmp3_ = gala_window_clone_get_window (_tmp2_);
				_tmp4_ = _tmp3_;
				meta_window_get_frame_rect (_tmp4_, &_tmp5_);
				_tmp6_ = clone;
				_tmp7_.rect = _tmp5_;
				_tmp7_.id = _tmp6_;
				_tmp8_ = _gala_internal_utils_tilable_window_dup0 (&_tmp7_);
				windows = g_list_prepend (windows, _tmp8_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp9_ = windows;
	if (vala_g_list_is_empty (_tmp9_)) {
		(windows == NULL) ? NULL : (windows = (_g_list_free__gala_internal_utils_tilable_window_free0_ (windows), NULL));
		return;
	}
	windows = g_list_sort (windows, ___lambda25__gcompare_func);
	_tmp10_ = self->priv->_padding_left;
	_tmp11_ = self->priv->_padding_top;
	_tmp12_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->_padding_left;
	_tmp15_ = self->priv->_padding_right;
	_tmp16_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->_padding_top;
	_tmp19_ = self->priv->_padding_bottom;
	_tmp20_.x = _tmp10_;
	_tmp20_.y = _tmp11_;
	_tmp20_.width = (((gint) _tmp13_) - _tmp14_) - _tmp15_;
	_tmp20_.height = (((gint) _tmp17_) - _tmp18_) - _tmp19_;
	area = _tmp20_;
	_tmp21_ = area;
	_tmp22_ = windows;
	_tmp23_ = gala_internal_utils_calculate_grid_placement (&_tmp21_, _tmp22_);
	window_positions = _tmp23_;
	_tmp24_ = window_positions;
	{
		GList* tilable_collection = NULL;
		GList* tilable_it = NULL;
		tilable_collection = _tmp24_;
		for (tilable_it = tilable_collection; tilable_it != NULL; tilable_it = tilable_it->next) {
			GalaInternalUtilsTilableWindow* _tmp25_;
			GalaInternalUtilsTilableWindow* tilable = NULL;
			_tmp25_ = _gala_internal_utils_tilable_window_dup0 ((GalaInternalUtilsTilableWindow*) tilable_it->data);
			tilable = _tmp25_;
			{
				GalaWindowClone* clone = NULL;
				GalaInternalUtilsTilableWindow* _tmp26_;
				GalaWindowClone* _tmp27_;
				GalaWindowClone* _tmp28_;
				GalaInternalUtilsTilableWindow* _tmp29_;
				MtkRectangle _tmp30_;
				_tmp26_ = tilable;
				_tmp27_ = (*_tmp26_).id;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
				_tmp28_ = clone;
				_tmp29_ = tilable;
				_tmp30_ = (*_tmp29_).rect;
				gala_window_clone_take_slot (_tmp28_, &_tmp30_, with_gesture, is_cancel_animation);
				_gala_internal_utils_tilable_window_free0 (tilable);
			}
		}
	}
	(window_positions == NULL) ? NULL : (window_positions = (_g_list_free__gala_internal_utils_tilable_window_free0_ (window_positions), NULL));
	(windows == NULL) ? NULL : (windows = (_g_list_free__gala_internal_utils_tilable_window_free0_ (windows), NULL));
}

/**
         * Collect key events, mainly for redirecting them to the WindowCloneContainers to
         * select the active window.
         */
static gboolean
gala_window_clone_container_real_key_press_event (ClutterActor* base,
                                                  ClutterEvent* event)
{
	GalaWindowCloneContainer * self;
	gboolean result;
	self = (GalaWindowCloneContainer*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->opened) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	switch (clutter_event_get_key_symbol (event)) {
		case CLUTTER_KEY_Escape:
		{
			g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL], 0);
			break;
		}
		case CLUTTER_KEY_Down:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_DOWN);
			break;
		}
		case CLUTTER_KEY_Up:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_UP);
			break;
		}
		case CLUTTER_KEY_Left:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_LEFT);
			break;
		}
		case CLUTTER_KEY_Right:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_RIGHT);
			break;
		}
		case CLUTTER_KEY_Return:
		case CLUTTER_KEY_KP_Enter:
		{
			if (!gala_window_clone_container_activate_selected_window (self)) {
				g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL], 0);
			}
			break;
		}
		default:
		break;
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

/**
         * Look for the next window in a direction and make this window the
         * new current_window. Used for keyboard navigation.
         *
         * @param direction The MetaMotionDirection in which to search for windows for.
         */
static MtkRectangle*
_vala_MtkRectangle_copy (MtkRectangle* self)
{
	return g_boxed_copy (mtk_rectangle_get_type (), self);
}

static gpointer
__vala_MtkRectangle_copy0 (gpointer self)
{
	return self ? _vala_MtkRectangle_copy (self) : NULL;
}

static void
_vala_MtkRectangle_free (MtkRectangle* self)
{
	g_boxed_free (mtk_rectangle_get_type (), self);
}

void
gala_window_clone_container_select_next_window (GalaWindowCloneContainer* self,
                                                MetaMotionDirection direction)
{
	GalaWindowClone* closest = NULL;
	GalaWindowClone* _tmp0_;
	GalaWindowClone* _tmp82_;
	GalaWindowClone* _tmp87_;
	GalaWindowClone* _tmp89_;
	GalaWindowClone* _tmp90_;
	GalaWindowClone* _tmp91_;
	g_return_if_fail (self != NULL);
	if (clutter_actor_get_n_children ((ClutterActor*) self) < 1) {
		return;
	}
	closest = NULL;
	_tmp0_ = self->priv->current_window;
	if (_tmp0_ == NULL) {
		ClutterActor* _tmp1_;
		GalaWindowClone* _tmp2_;
		_tmp1_ = clutter_actor_get_child_at_index ((ClutterActor*) self, 0);
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
		_g_object_unref0 (closest);
		closest = _tmp2_;
	} else {
		MtkRectangle* current_rect = NULL;
		GalaWindowClone* _tmp3_;
		MtkRectangle* _tmp4_;
		MtkRectangle* _tmp5_;
		MtkRectangle* _tmp6_;
		GList* _tmp7_;
		_tmp3_ = self->priv->current_window;
		_tmp4_ = gala_window_clone_get_slot (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = __vala_MtkRectangle_copy0 (_tmp5_);
		current_rect = _tmp6_;
		_tmp7_ = clutter_actor_get_children ((ClutterActor*) self);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp7_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				ClutterActor* child = NULL;
				child = (ClutterActor*) child_it->data;
				{
					ClutterActor* _tmp8_;
					GalaWindowClone* _tmp9_;
					MtkRectangle* window_rect = NULL;
					ClutterActor* _tmp10_;
					MtkRectangle* _tmp11_;
					MtkRectangle* _tmp12_;
					MtkRectangle* _tmp13_;
					_tmp8_ = child;
					_tmp9_ = self->priv->current_window;
					if (_tmp8_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, clutter_actor_get_type (), ClutterActor)) {
						continue;
					}
					_tmp10_ = child;
					_tmp11_ = gala_window_clone_get_slot (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
					_tmp12_ = _tmp11_;
					_tmp13_ = __vala_MtkRectangle_copy0 (_tmp12_);
					window_rect = _tmp13_;
					if (direction == META_MOTION_LEFT) {
						MtkRectangle* _tmp14_;
						MtkRectangle* _tmp15_;
						gboolean _tmp16_ = FALSE;
						MtkRectangle* _tmp17_;
						MtkRectangle* _tmp18_;
						MtkRectangle* _tmp19_;
						_tmp14_ = window_rect;
						_tmp15_ = current_rect;
						if ((*_tmp14_).x > (*_tmp15_).x) {
							__vala_MtkRectangle_free0 (window_rect);
							continue;
						}
						_tmp17_ = window_rect;
						_tmp18_ = window_rect;
						_tmp19_ = current_rect;
						if (((*_tmp17_).y + (*_tmp18_).height) > (*_tmp19_).y) {
							MtkRectangle* _tmp20_;
							MtkRectangle* _tmp21_;
							MtkRectangle* _tmp22_;
							_tmp20_ = window_rect;
							_tmp21_ = current_rect;
							_tmp22_ = current_rect;
							_tmp16_ = (*_tmp20_).y < ((*_tmp21_).y + (*_tmp22_).height);
						} else {
							_tmp16_ = FALSE;
						}
						if (_tmp16_) {
							gboolean _tmp23_ = FALSE;
							GalaWindowClone* _tmp24_;
							_tmp24_ = closest;
							if (_tmp24_ == NULL) {
								_tmp23_ = TRUE;
							} else {
								GalaWindowClone* _tmp25_;
								MtkRectangle* _tmp26_;
								MtkRectangle* _tmp27_;
								MtkRectangle* _tmp28_;
								_tmp25_ = closest;
								_tmp26_ = gala_window_clone_get_slot (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = window_rect;
								_tmp23_ = (*_tmp27_).x < (*_tmp28_).x;
							}
							if (_tmp23_) {
								ClutterActor* _tmp29_;
								GalaWindowClone* _tmp30_;
								_tmp29_ = child;
								_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
								_g_object_unref0 (closest);
								closest = _tmp30_;
							}
						}
					} else {
						if (direction == META_MOTION_RIGHT) {
							MtkRectangle* _tmp31_;
							MtkRectangle* _tmp32_;
							gboolean _tmp33_ = FALSE;
							MtkRectangle* _tmp34_;
							MtkRectangle* _tmp35_;
							MtkRectangle* _tmp36_;
							_tmp31_ = window_rect;
							_tmp32_ = current_rect;
							if ((*_tmp31_).x < (*_tmp32_).x) {
								__vala_MtkRectangle_free0 (window_rect);
								continue;
							}
							_tmp34_ = window_rect;
							_tmp35_ = window_rect;
							_tmp36_ = current_rect;
							if (((*_tmp34_).y + (*_tmp35_).height) > (*_tmp36_).y) {
								MtkRectangle* _tmp37_;
								MtkRectangle* _tmp38_;
								MtkRectangle* _tmp39_;
								_tmp37_ = window_rect;
								_tmp38_ = current_rect;
								_tmp39_ = current_rect;
								_tmp33_ = (*_tmp37_).y < ((*_tmp38_).y + (*_tmp39_).height);
							} else {
								_tmp33_ = FALSE;
							}
							if (_tmp33_) {
								gboolean _tmp40_ = FALSE;
								GalaWindowClone* _tmp41_;
								_tmp41_ = closest;
								if (_tmp41_ == NULL) {
									_tmp40_ = TRUE;
								} else {
									GalaWindowClone* _tmp42_;
									MtkRectangle* _tmp43_;
									MtkRectangle* _tmp44_;
									MtkRectangle* _tmp45_;
									_tmp42_ = closest;
									_tmp43_ = gala_window_clone_get_slot (_tmp42_);
									_tmp44_ = _tmp43_;
									_tmp45_ = window_rect;
									_tmp40_ = (*_tmp44_).x > (*_tmp45_).x;
								}
								if (_tmp40_) {
									ClutterActor* _tmp46_;
									GalaWindowClone* _tmp47_;
									_tmp46_ = child;
									_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
									_g_object_unref0 (closest);
									closest = _tmp47_;
								}
							}
						} else {
							if (direction == META_MOTION_UP) {
								MtkRectangle* _tmp48_;
								MtkRectangle* _tmp49_;
								gboolean _tmp50_ = FALSE;
								MtkRectangle* _tmp51_;
								MtkRectangle* _tmp52_;
								MtkRectangle* _tmp53_;
								_tmp48_ = window_rect;
								_tmp49_ = current_rect;
								if ((*_tmp48_).y > (*_tmp49_).y) {
									__vala_MtkRectangle_free0 (window_rect);
									continue;
								}
								_tmp51_ = window_rect;
								_tmp52_ = window_rect;
								_tmp53_ = current_rect;
								if (((*_tmp51_).x + (*_tmp52_).width) > (*_tmp53_).x) {
									MtkRectangle* _tmp54_;
									MtkRectangle* _tmp55_;
									MtkRectangle* _tmp56_;
									_tmp54_ = window_rect;
									_tmp55_ = current_rect;
									_tmp56_ = current_rect;
									_tmp50_ = (*_tmp54_).x < ((*_tmp55_).x + (*_tmp56_).width);
								} else {
									_tmp50_ = FALSE;
								}
								if (_tmp50_) {
									gboolean _tmp57_ = FALSE;
									GalaWindowClone* _tmp58_;
									_tmp58_ = closest;
									if (_tmp58_ == NULL) {
										_tmp57_ = TRUE;
									} else {
										GalaWindowClone* _tmp59_;
										MtkRectangle* _tmp60_;
										MtkRectangle* _tmp61_;
										MtkRectangle* _tmp62_;
										_tmp59_ = closest;
										_tmp60_ = gala_window_clone_get_slot (_tmp59_);
										_tmp61_ = _tmp60_;
										_tmp62_ = window_rect;
										_tmp57_ = (*_tmp61_).y < (*_tmp62_).y;
									}
									if (_tmp57_) {
										ClutterActor* _tmp63_;
										GalaWindowClone* _tmp64_;
										_tmp63_ = child;
										_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
										_g_object_unref0 (closest);
										closest = _tmp64_;
									}
								}
							} else {
								if (direction == META_MOTION_DOWN) {
									MtkRectangle* _tmp65_;
									MtkRectangle* _tmp66_;
									gboolean _tmp67_ = FALSE;
									MtkRectangle* _tmp68_;
									MtkRectangle* _tmp69_;
									MtkRectangle* _tmp70_;
									_tmp65_ = window_rect;
									_tmp66_ = current_rect;
									if ((*_tmp65_).y < (*_tmp66_).y) {
										__vala_MtkRectangle_free0 (window_rect);
										continue;
									}
									_tmp68_ = window_rect;
									_tmp69_ = window_rect;
									_tmp70_ = current_rect;
									if (((*_tmp68_).x + (*_tmp69_).width) > (*_tmp70_).x) {
										MtkRectangle* _tmp71_;
										MtkRectangle* _tmp72_;
										MtkRectangle* _tmp73_;
										_tmp71_ = window_rect;
										_tmp72_ = current_rect;
										_tmp73_ = current_rect;
										_tmp67_ = (*_tmp71_).x < ((*_tmp72_).x + (*_tmp73_).width);
									} else {
										_tmp67_ = FALSE;
									}
									if (_tmp67_) {
										gboolean _tmp74_ = FALSE;
										GalaWindowClone* _tmp75_;
										_tmp75_ = closest;
										if (_tmp75_ == NULL) {
											_tmp74_ = TRUE;
										} else {
											GalaWindowClone* _tmp76_;
											MtkRectangle* _tmp77_;
											MtkRectangle* _tmp78_;
											MtkRectangle* _tmp79_;
											_tmp76_ = closest;
											_tmp77_ = gala_window_clone_get_slot (_tmp76_);
											_tmp78_ = _tmp77_;
											_tmp79_ = window_rect;
											_tmp74_ = (*_tmp78_).y > (*_tmp79_).y;
										}
										if (_tmp74_) {
											ClutterActor* _tmp80_;
											GalaWindowClone* _tmp81_;
											_tmp80_ = child;
											_tmp81_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp80_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
											_g_object_unref0 (closest);
											closest = _tmp81_;
										}
									}
								} else {
									g_warning ("WindowCloneContainer.vala:321: Invalid direction");
									__vala_MtkRectangle_free0 (window_rect);
									break;
								}
							}
						}
					}
					__vala_MtkRectangle_free0 (window_rect);
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
		__vala_MtkRectangle_free0 (current_rect);
	}
	_tmp82_ = closest;
	if (_tmp82_ == NULL) {
		GalaWindowClone* _tmp83_;
		_tmp83_ = self->priv->current_window;
		if (_tmp83_ != NULL) {
			ClutterBackend* _tmp84_;
			ClutterSeat* _tmp85_;
			GalaWindowClone* _tmp86_;
			_tmp84_ = clutter_get_default_backend ();
			_tmp85_ = clutter_backend_get_default_seat (_tmp84_);
			clutter_seat_bell_notify (_tmp85_);
			_tmp86_ = self->priv->current_window;
			gala_window_clone_set_active (_tmp86_, TRUE);
		}
		_g_object_unref0 (closest);
		return;
	}
	_tmp87_ = self->priv->current_window;
	if (_tmp87_ != NULL) {
		GalaWindowClone* _tmp88_;
		_tmp88_ = self->priv->current_window;
		gala_window_clone_set_active (_tmp88_, FALSE);
	}
	_tmp89_ = closest;
	gala_window_clone_set_active (_tmp89_, TRUE);
	_tmp90_ = closest;
	_tmp91_ = _g_object_ref0 (_tmp90_);
	_g_object_unref0 (self->priv->current_window);
	self->priv->current_window = _tmp91_;
	_g_object_unref0 (closest);
}

/**
         * Emit the selected signal for the current_window.
         */
gboolean
gala_window_clone_container_activate_selected_window (GalaWindowCloneContainer* self)
{
	GalaWindowClone* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current_window;
	if (_tmp0_ != NULL) {
		GalaWindowClone* _tmp1_;
		MetaWindow* _tmp2_;
		MetaWindow* _tmp3_;
		_tmp1_ = self->priv->current_window;
		_tmp2_ = gala_window_clone_get_window (_tmp1_);
		_tmp3_ = _tmp2_;
		g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL], 0, _tmp3_);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

/**
         * When opened the WindowClones are animated to a tiled layout
         */
void
gala_window_clone_container_open (GalaWindowCloneContainer* self,
                                  MetaWindow* selected_window,
                                  gboolean with_gesture,
                                  gboolean is_cancel_animation)
{
	gboolean _tmp9_ = FALSE;
	GalaGestureTracker* _tmp10_;
	g_return_if_fail (self != NULL);
	if (self->priv->opened) {
		return;
	}
	self->priv->opened = TRUE;
	if (selected_window != NULL) {
		GList* _tmp0_;
		GalaWindowClone* _tmp7_;
		_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp0_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				ClutterActor* child = NULL;
				child = (ClutterActor*) child_it->data;
				{
					GalaWindowClone* clone = NULL;
					ClutterActor* _tmp1_;
					GalaWindowClone* _tmp2_;
					MetaWindow* _tmp3_;
					MetaWindow* _tmp4_;
					_tmp1_ = child;
					clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
					_tmp2_ = clone;
					_tmp3_ = gala_window_clone_get_window (_tmp2_);
					_tmp4_ = _tmp3_;
					if (_tmp4_ == selected_window) {
						GalaWindowClone* _tmp5_;
						GalaWindowClone* _tmp6_;
						_tmp5_ = clone;
						_tmp6_ = _g_object_ref0 (_tmp5_);
						_g_object_unref0 (self->priv->current_window);
						self->priv->current_window = _tmp6_;
						break;
					}
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
		_tmp7_ = self->priv->current_window;
		if (_tmp7_ != NULL) {
			GalaWindowClone* _tmp8_;
			_tmp8_ = self->priv->current_window;
			gala_window_clone_set_active (_tmp8_, FALSE);
		}
	} else {
		_g_object_unref0 (self->priv->current_window);
		self->priv->current_window = NULL;
	}
	_tmp10_ = self->priv->_gesture_tracker;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = !is_cancel_animation;
	}
	if (_tmp9_) {
		GList* _tmp11_;
		_tmp11_ = clutter_actor_get_children ((ClutterActor*) self);
		{
			GList* window_collection = NULL;
			GList* window_it = NULL;
			window_collection = _tmp11_;
			for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
				ClutterActor* window = NULL;
				window = (ClutterActor*) window_it->data;
				{
					ClutterActor* _tmp12_;
					_tmp12_ = window;
					gala_window_clone_transition_to_original_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone), FALSE, with_gesture, is_cancel_animation);
				}
			}
			(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
		}
	}
	gala_window_clone_container_reflow (self, with_gesture, is_cancel_animation);
}

/**
         * Calls the transition_to_original_state() function on each child
         * to make them take their original locations again.
         */
void
gala_window_clone_container_close (GalaWindowCloneContainer* self,
                                   gboolean with_gesture,
                                   gboolean is_cancel_animation)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	if (!self->priv->opened) {
		return;
	}
	self->priv->opened = FALSE;
	_tmp0_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			ClutterActor* window = NULL;
			window = (ClutterActor*) window_it->data;
			{
				ClutterActor* _tmp1_;
				_tmp1_ = window;
				gala_window_clone_transition_to_original_state (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone), TRUE, with_gesture, is_cancel_animation);
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
}

gint
gala_window_clone_container_get_padding_top (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_top;
	return result;
}

void
gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_top (self);
	if (old_value != value) {
		self->priv->_padding_top = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY]);
	}
}

gint
gala_window_clone_container_get_padding_left (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_left;
	return result;
}

void
gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_left (self);
	if (old_value != value) {
		self->priv->_padding_left = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY]);
	}
}

gint
gala_window_clone_container_get_padding_right (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_right;
	return result;
}

void
gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_right (self);
	if (old_value != value) {
		self->priv->_padding_right = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY]);
	}
}

gint
gala_window_clone_container_get_padding_bottom (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_bottom;
	return result;
}

void
gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_bottom (self);
	if (old_value != value) {
		self->priv->_padding_bottom = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY]);
	}
}

GalaWindowManager*
gala_window_clone_container_get_wm (GalaWindowCloneContainer* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_container_set_wm (GalaWindowCloneContainer* self,
                                    GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY]);
	}
}

GalaGestureTracker*
gala_window_clone_container_get_gesture_tracker (GalaWindowCloneContainer* self)
{
	GalaGestureTracker* result;
	GalaGestureTracker* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gesture_tracker;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_container_set_gesture_tracker (GalaWindowCloneContainer* self,
                                                 GalaGestureTracker* value)
{
	GalaGestureTracker* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_gesture_tracker (self);
	if (old_value != value) {
		GalaGestureTracker* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gesture_tracker);
		self->priv->_gesture_tracker = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_GESTURE_TRACKER_PROPERTY]);
	}
}

gboolean
gala_window_clone_container_get_overview_mode (GalaWindowCloneContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overview_mode;
	return result;
}

static void
gala_window_clone_container_set_overview_mode (GalaWindowCloneContainer* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_overview_mode (self);
	if (old_value != value) {
		self->priv->_overview_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY]);
	}
}

gfloat
gala_window_clone_container_get_monitor_scale (GalaWindowCloneContainer* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_window_clone_container_set_monitor_scale (GalaWindowCloneContainer* self,
                                               gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_monitor_scale) {
		self->priv->_monitor_scale = value;
		gala_window_clone_container_reallocate (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY]);
}

static void
gala_window_clone_container_class_init (GalaWindowCloneContainerClass * klass,
                                        gpointer klass_data)
{
	gala_window_clone_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowCloneContainer_private_offset);
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_clone_container_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_clone_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_clone_container_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY] = g_param_spec_int ("padding-top", "padding-top", "padding-top", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY] = g_param_spec_int ("padding-left", "padding-left", "padding-left", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY] = g_param_spec_int ("padding-right", "padding-right", "padding-right", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY] = g_param_spec_int ("padding-bottom", "padding-bottom", "padding-bottom", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_GESTURE_TRACKER_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_GESTURE_TRACKER_PROPERTY] = g_param_spec_object ("gesture-tracker", "gesture-tracker", "gesture-tracker", GALA_TYPE_GESTURE_TRACKER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY] = g_param_spec_boolean ("overview-mode", "overview-mode", "overview-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
	gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL] = g_signal_new ("requested-close", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_window_clone_container_instance_init (GalaWindowCloneContainer * self,
                                           gpointer klass)
{
	self->priv = gala_window_clone_container_get_instance_private (self);
	self->priv->_padding_top = 12;
	self->priv->_padding_left = 12;
	self->priv->_padding_right = 12;
	self->priv->_padding_bottom = 12;
	self->priv->_monitor_scale = 1.0f;
	self->priv->opened = FALSE;
	self->priv->current_window = NULL;
}

static void
gala_window_clone_container_finalize (GObject * obj)
{
	GalaWindowCloneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_gesture_tracker);
	_g_object_unref0 (self->priv->current_window);
	G_OBJECT_CLASS (gala_window_clone_container_parent_class)->finalize (obj);
}

/**
     * Container which controls the layout of a set of WindowClones.
     */
static GType
gala_window_clone_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowCloneContainer), 0, (GInstanceInitFunc) gala_window_clone_container_instance_init, NULL };
	GType gala_window_clone_container_type_id;
	gala_window_clone_container_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowCloneContainer", &g_define_type_info, 0);
	GalaWindowCloneContainer_private_offset = g_type_add_instance_private (gala_window_clone_container_type_id, sizeof (GalaWindowCloneContainerPrivate));
	return gala_window_clone_container_type_id;
}

GType
gala_window_clone_container_get_type (void)
{
	static volatile gsize gala_window_clone_container_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_container_type_id__once)) {
		GType gala_window_clone_container_type_id;
		gala_window_clone_container_type_id = gala_window_clone_container_get_type_once ();
		g_once_init_leave (&gala_window_clone_container_type_id__once, gala_window_clone_container_type_id);
	}
	return gala_window_clone_container_type_id__once;
}

static void
_vala_gala_window_clone_container_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GalaWindowCloneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	switch (property_id) {
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_top (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_left (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_right (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_bottom (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY:
		g_value_set_object (value, gala_window_clone_container_get_wm (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_GESTURE_TRACKER_PROPERTY:
		g_value_set_object (value, gala_window_clone_container_get_gesture_tracker (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY:
		g_value_set_boolean (value, gala_window_clone_container_get_overview_mode (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_window_clone_container_get_monitor_scale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_clone_container_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GalaWindowCloneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	switch (property_id) {
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY:
		gala_window_clone_container_set_padding_top (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY:
		gala_window_clone_container_set_padding_left (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY:
		gala_window_clone_container_set_padding_right (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY:
		gala_window_clone_container_set_padding_bottom (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY:
		gala_window_clone_container_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_GESTURE_TRACKER_PROPERTY:
		gala_window_clone_container_set_gesture_tracker (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY:
		gala_window_clone_container_set_overview_mode (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY:
		gala_window_clone_container_set_monitor_scale (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

