/* WindowClone.c generated by valac 0.56.16, the Vala compiler
 * generated from WindowClone.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2022-2023 elementary, Inc. (https://elementary.io)
 *                         2014 Tom Beckmann
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <meta/window.h>
#include <mtk/mtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/meta-window-actor.h>
#include <stdlib.h>
#include <string.h>
#include <meta/workspace.h>
#include <meta/display.h>
#include <meta/meta-workspace-manager.h>
#include <meta/meta-plugin.h>
#include <meta/common.h>
#include <meta/prefs.h>
#include <meta/meta-background-group.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>

#define GALA_WINDOW_CLONE_CLOSE_WINDOW_ICON_SIZE 36
#define GALA_WINDOW_CLONE_WINDOW_ICON_SIZE 64
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE 12
#define GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION 200
#define GALA_WINDOW_CLONE_TITLE_MAX_WIDTH_MARGIN 60
#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_BORDER_RADIUS 16
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_COLOR_OPACITY 0.8
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
typedef struct _GalaWindowClonePrivate GalaWindowClonePrivate;

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;

#define GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE (gala_window_clone_active_shape_get_type ())
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape))
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShapeClass))
#define GALA_WINDOW_CLONE_IS_ACTIVE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE))
#define GALA_WINDOW_CLONE_IS_ACTIVE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE))
#define GALA_WINDOW_CLONE_ACTIVE_SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShapeClass))

typedef struct _GalaWindowCloneActiveShape GalaWindowCloneActiveShape;
typedef struct _GalaWindowCloneActiveShapeClass GalaWindowCloneActiveShapeClass;

#define GALA_TYPE_TOOLTIP (gala_tooltip_get_type ())
#define GALA_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOOLTIP, GalaTooltip))
#define GALA_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOOLTIP, GalaTooltipClass))
#define GALA_IS_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOOLTIP))
#define GALA_IS_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOOLTIP))
#define GALA_TOOLTIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOOLTIP, GalaTooltipClass))

typedef struct _GalaTooltip GalaTooltip;
typedef struct _GalaTooltipClass GalaTooltipClass;
enum  {
	GALA_WINDOW_CLONE_0_PROPERTY,
	GALA_WINDOW_CLONE_WM_PROPERTY,
	GALA_WINDOW_CLONE_WINDOW_PROPERTY,
	GALA_WINDOW_CLONE_SLOT_PROPERTY,
	GALA_WINDOW_CLONE_ACTIVE_PROPERTY,
	GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY,
	GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY,
	GALA_WINDOW_CLONE_MONITOR_SCALE_FACTOR_PROPERTY,
	GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY,
	GALA_WINDOW_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_properties[GALA_WINDOW_CLONE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_MtkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_MtkRectangle_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block67Data Block67Data;
typedef void (*GalaGestureTrackerOnUpdate) (gdouble percentage, gpointer user_data);
typedef void (*GalaGestureTrackerOnEnd) (gdouble percentage, gboolean cancel_action, gint calculated_duration, gpointer user_data);
typedef void (*GalaGestureTrackerOnBegin) (gdouble percentage, gpointer user_data);
typedef struct _Block68Data Block68Data;

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;

#define GALA_TYPE_WORKSPACE_INSERT_THUMB (gala_workspace_insert_thumb_get_type ())
#define GALA_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb))
#define GALA_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))
#define GALA_IS_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_IS_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_WORKSPACE_INSERT_THUMB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))

typedef struct _GalaWorkspaceInsertThumb GalaWorkspaceInsertThumb;
typedef struct _GalaWorkspaceInsertThumbClass GalaWorkspaceInsertThumbClass;

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;

#define GALA_TYPE_FRAMED_BACKGROUND (gala_framed_background_get_type ())
#define GALA_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackground))
#define GALA_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))
#define GALA_IS_FRAMED_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_IS_FRAMED_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_FRAMED_BACKGROUND))
#define GALA_FRAMED_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_FRAMED_BACKGROUND, GalaFramedBackgroundClass))

typedef struct _GalaFramedBackground GalaFramedBackground;
typedef struct _GalaFramedBackgroundClass GalaFramedBackgroundClass;

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;

#define GALA_TYPE_MONITOR_CLONE (gala_monitor_clone_get_type ())
#define GALA_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorClone))
#define GALA_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))
#define GALA_IS_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONITOR_CLONE))
#define GALA_IS_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONITOR_CLONE))
#define GALA_MONITOR_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))

typedef struct _GalaMonitorClone GalaMonitorClone;
typedef struct _GalaMonitorCloneClass GalaMonitorCloneClass;
typedef struct _GalaWindowCloneActiveShapePrivate GalaWindowCloneActiveShapePrivate;
enum  {
	GALA_WINDOW_CLONE_ACTIVE_SHAPE_0_PROPERTY,
	GALA_WINDOW_CLONE_ACTIVE_SHAPE_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_active_shape_properties[GALA_WINDOW_CLONE_ACTIVE_SHAPE_NUM_PROPERTIES];
typedef struct _Block69Data Block69Data;
enum  {
	GALA_WINDOW_CLONE_SELECTED_SIGNAL,
	GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL,
	GALA_WINDOW_CLONE_NUM_SIGNALS
};
static guint gala_window_clone_signals[GALA_WINDOW_CLONE_NUM_SIGNALS] = {0};

struct _GalaWindowClone {
	ClutterActor parent_instance;
	GalaWindowClonePrivate * priv;
};

struct _GalaWindowCloneClass {
	ClutterActorClass parent_class;
};

struct _GalaWindowClonePrivate {
	GalaWindowManager* _wm;
	MetaWindow* _window;
	MtkRectangle* _slot;
	gboolean _overview_mode;
	GalaGestureTracker* _gesture_tracker;
	gfloat _monitor_scale_factor;
	GalaDragDropAction* drag_action;
	ClutterClone* clone;
	GalaShadowEffect* shadow_effect;
	ClutterActor* prev_parent;
	gint prev_index;
	gulong check_confirm_dialog_cb;
	gboolean in_slot_animation;
	GalaCloseButton* close_button;
	GalaWindowCloneActiveShape* active_shape;
	ClutterActor* window_icon;
	GalaTooltip* window_title;
};

struct _Block67Data {
	int _ref_count_;
	GalaWindowClone* self;
	MtkRectangle outer_rect;
	gfloat initial_scale;
	gfloat target_scale;
	gfloat initial_x;
	gfloat initial_y;
	gfloat initial_width;
	gfloat initial_height;
	gint target_x;
	gint target_y;
	gboolean animate;
};

struct _Block68Data {
	int _ref_count_;
	GalaWindowClone* self;
	gfloat initial_x;
	gfloat initial_y;
	gfloat initial_width;
	gfloat initial_height;
	gfloat scale;
	MtkRectangle rect;
};

struct _GalaWindowCloneActiveShape {
	GalaCanvasActor parent_instance;
	GalaWindowCloneActiveShapePrivate * priv;
};

struct _GalaWindowCloneActiveShapeClass {
	GalaCanvasActorClass parent_class;
};

struct _Block69Data {
	int _ref_count_;
	GalaWindowClone* self;
	ClutterClickAction* click_action;
};

static gint GalaWindowClone_private_offset;
static gpointer gala_window_clone_parent_class = NULL;
static gpointer gala_window_clone_active_shape_parent_class = NULL;

VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
static GType gala_window_clone_active_shape_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneActiveShape, g_object_unref)
VALA_EXTERN GType gala_tooltip_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaTooltip, g_object_unref)
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
static void gala_window_clone_unmanaged (GalaWindowClone* self);
static void _gala_window_clone_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                         gpointer self);
static void gala_window_clone_on_all_workspaces_changed (GalaWindowClone* self);
static void _gala_window_clone_on_all_workspaces_changed_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void gala_window_clone_check_shadow_requirements (GalaWindowClone* self);
static void _gala_window_clone_check_shadow_requirements_g_object_notify (GObject* _sender,
                                                                   GParamSpec* pspec,
                                                                   gpointer self);
static void _vala_MtkRectangle_free (MtkRectangle* self);
VALA_EXTERN GalaWindowClone* gala_window_clone_new (GalaWindowManager* wm,
                                        MetaWindow* window,
                                        GalaGestureTracker* gesture_tracker,
                                        gfloat scale,
                                        gboolean overview_mode);
VALA_EXTERN GalaWindowClone* gala_window_clone_construct (GType object_type,
                                              GalaWindowManager* wm,
                                              MetaWindow* window,
                                              GalaGestureTracker* gesture_tracker,
                                              gfloat scale,
                                              gboolean overview_mode);
static void gala_window_clone_reallocate (GalaWindowClone* self);
VALA_EXTERN gfloat gala_window_clone_get_monitor_scale_factor (GalaWindowClone* self);
static void gala_window_clone_close_window (GalaWindowClone* self,
                                     guint32 timestamp);
static void _gala_window_clone_close_window_gala_close_button_triggered (GalaCloseButton* _sender,
                                                                  guint32 timestamp,
                                                                  gpointer self);
static void gala_window_clone_set_window_icon_position (GalaWindowClone* self,
                                                 gfloat window_width,
                                                 gfloat window_height,
                                                 gfloat scale_factor,
                                                 gboolean aligned);
static void gala_window_clone_load_clone (GalaWindowClone* self,
                                   gboolean was_waiting);
static gboolean ___lambda20_ (GalaWindowClone* self);
static gboolean ____lambda20__gsource_func (gpointer self);
VALA_EXTERN gboolean gala_window_clone_get_overview_mode (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_transition_to_original_state (GalaWindowClone* self,
                                                     gboolean animate,
                                                     gboolean with_gesture,
                                                     gboolean is_cancel_animation);
static gboolean gala_window_clone_should_fade (GalaWindowClone* self);
VALA_EXTERN MtkRectangle* gala_window_clone_get_slot (GalaWindowClone* self);
VALA_EXTERN void gala_window_clone_take_slot (GalaWindowClone* self,
                                  MtkRectangle* rect,
                                  gboolean with_gesture,
                                  gboolean is_cancel_animation);
VALA_EXTERN void gala_window_clone_set_shadow_opacity (GalaWindowClone* self,
                                           guint8 value);
static Block67Data* block67_data_ref (Block67Data* _data67_);
static void block67_data_unref (void * _userdata_);
VALA_EXTERN void gala_window_clone_set_active (GalaWindowClone* self,
                                   gboolean value);
VALA_EXTERN void gala_window_clone_place_widgets (GalaWindowClone* self,
                                      gint dest_width,
                                      gint dest_height,
                                      gfloat scale_factor);
static void __lambda21_ (Block67Data* _data67_,
                  gdouble percentage);
VALA_EXTERN gfloat gala_gesture_tracker_animation_value (gfloat initial_value,
                                             gfloat target_value,
                                             gdouble percentage,
                                             gboolean rounded);
static void ___lambda21__gala_gesture_tracker_on_update (gdouble percentage,
                                                  gpointer self);
static void __lambda22_ (Block67Data* _data67_,
                  gdouble percentage,
                  gboolean cancel_action);
VALA_EXTERN GalaWindowManager* gala_window_clone_get_wm (GalaWindowClone* self);
static void gala_window_clone_toggle_shadow (GalaWindowClone* self,
                                      gboolean show);
static void ___lambda78_ (Block67Data* _data67_);
static void ____lambda78__clutter_timeline_completed (ClutterTimeline* _sender,
                                               gpointer self);
static void ___lambda22__gala_gesture_tracker_on_end (gdouble percentage,
                                               gboolean cancel_action,
                                               gint calculated_duration,
                                               gpointer self);
VALA_EXTERN GalaGestureTracker* gala_window_clone_get_gesture_tracker (GalaWindowClone* self);
VALA_EXTERN void gala_gesture_tracker_connect_handlers (GalaGestureTracker* self,
                                            GalaGestureTrackerOnBegin on_begin_handler,
                                            gpointer on_begin_handler_target,
                                            GDestroyNotify on_begin_handler_target_destroy_notify,
                                            GalaGestureTrackerOnUpdate on_update_handler,
                                            gpointer on_update_handler_target,
                                            GDestroyNotify on_update_handler_target_destroy_notify,
                                            GalaGestureTrackerOnEnd on_end_handler,
                                            gpointer on_end_handler_target,
                                            GDestroyNotify on_end_handler_target_destroy_notify);
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
static void gala_window_clone_set_slot (GalaWindowClone* self,
                                 MtkRectangle* value);
static void __lambda26_ (Block68Data* _data68_,
                  gdouble percentage);
static void ___lambda26__gala_gesture_tracker_on_update (gdouble percentage,
                                                  gpointer self);
static void __lambda27_ (Block68Data* _data68_,
                  gdouble percentage,
                  gboolean cancel_action);
static void ___lambda28_ (Block68Data* _data68_);
static void ____lambda28__clutter_timeline_completed (ClutterTimeline* _sender,
                                               gpointer self);
static void ___lambda27__gala_gesture_tracker_on_end (gdouble percentage,
                                               gboolean cancel_action,
                                               gint calculated_duration,
                                               gpointer self);
static void gala_window_clone_real_allocate (ClutterActor* base,
                                      ClutterActorBox* box);
static gboolean gala_window_clone_real_button_press_event (ClutterActor* base,
                                                    ClutterEvent* event);
static gboolean gala_window_clone_real_enter_event (ClutterActor* base,
                                             ClutterEvent* event);
static gboolean gala_window_clone_real_leave_event (ClutterActor* base,
                                             ClutterEvent* event);
VALA_EXTERN gint gala_internal_utils_scale_to_int (gint value,
                                       gfloat scale_factor);
static gboolean gala_window_clone_is_close_button_on_left (void);
VALA_EXTERN void gala_tooltip_set_text (GalaTooltip* self,
                            const gchar* new_text);
VALA_EXTERN void gala_tooltip_set_max_width (GalaTooltip* self,
                                 gfloat new_max_width);
static void gala_window_clone_set_window_title_position (GalaWindowClone* self,
                                                  gfloat window_width,
                                                  gfloat window_height,
                                                  gfloat scale_factor);
VALA_EXTERN guint8 gala_window_clone_get_shadow_opacity (GalaWindowClone* self);
static void gala_window_clone_check_confirm_dialog (GalaWindowClone* self,
                                             gint monitor,
                                             MetaWindow* new_window);
static void _gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                                  gint object,
                                                                                  MetaWindow* p0,
                                                                                  gpointer self);
static gboolean ___lambda19_ (GalaWindowClone* self);
static gboolean ____lambda19__gsource_func (gpointer self);
static void gala_window_clone_actor_clicked (GalaWindowClone* self,
                                      guint32 button);
static ClutterActor* gala_window_clone_drag_begin (GalaWindowClone* self,
                                            gfloat click_x,
                                            gfloat click_y);
static void gala_window_clone_drag_destination_crossed (GalaWindowClone* self,
                                                 ClutterActor* destination,
                                                 gboolean hovered);
VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN GType gala_workspace_insert_thumb_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceInsertThumb, g_object_unref)
VALA_EXTERN MetaWorkspace* gala_icon_group_get_workspace (GalaIconGroup* self);
VALA_EXTERN gint gala_workspace_insert_thumb_get_delay (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_workspace_insert_thumb_set_window_thumb (GalaWorkspaceInsertThumb* self,
                                                   MetaWindow* window);
VALA_EXTERN void gala_icon_group_add_window (GalaIconGroup* self,
                                 MetaWindow* window,
                                 gboolean no_redraw,
                                 gboolean temporary);
VALA_EXTERN void gala_icon_group_remove_window (GalaIconGroup* self,
                                    MetaWindow* window,
                                    gboolean animate);
static void gala_window_clone_drag_end (GalaWindowClone* self,
                                 ClutterActor* destination);
VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
 G_GNUC_INTERNAL GType gala_framed_background_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaFramedBackground, g_object_unref)
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
static void gala_window_clone_drag_canceled (GalaWindowClone* self);
VALA_EXTERN gint gala_workspace_insert_thumb_get_workspace_index (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_internal_utils_insert_workspace_with_window (gint index,
                                                       MetaWindow* new_window);
VALA_EXTERN GType gala_monitor_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonitorClone, g_object_unref)
VALA_EXTERN gint gala_monitor_clone_get_monitor (GalaMonitorClone* self);
static void gala_window_clone_set_wm (GalaWindowClone* self,
                               GalaWindowManager* value);
static void gala_window_clone_set_window (GalaWindowClone* self,
                                   MetaWindow* value);
static gboolean _mtk_rectangle_equal (const MtkRectangle * s1,
                               const MtkRectangle * s2);
static MtkRectangle* _vala_MtkRectangle_copy (MtkRectangle* self);
static void gala_window_clone_set_overview_mode (GalaWindowClone* self,
                                          gboolean value);
static void gala_window_clone_set_gesture_tracker (GalaWindowClone* self,
                                            GalaGestureTracker* value);
VALA_EXTERN void gala_window_clone_set_monitor_scale_factor (GalaWindowClone* self,
                                                 gfloat value);
static void gala_window_clone_active_shape_invalidate (GalaWindowCloneActiveShape* self);
static void gala_window_clone_active_shape_real_draw (GalaCanvasActor* base,
                                               cairo_t* cr,
                                               gint width,
                                               gint height);
VALA_EXTERN void gala_internal_utils_get_theme_accent_color (GdkRGBA* result);
static GalaWindowCloneActiveShape* gala_window_clone_active_shape_new (void);
static GalaWindowCloneActiveShape* gala_window_clone_active_shape_construct (GType object_type);
static GObject * gala_window_clone_active_shape_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void _gala_window_clone_active_shape_invalidate_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self);
static GType gala_window_clone_active_shape_get_type_once (void);
static GObject * gala_window_clone_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block69Data* block69_data_ref (Block69Data* _data69_);
static void block69_data_unref (void * _userdata_);
static void _gala_window_clone____lambda79_ (Block69Data* _data69_);
static void __gala_window_clone____lambda79__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                                    ClutterActor* actor,
                                                                    gpointer self);
static ClutterActor* _gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                              gfloat x,
                                                                              gfloat y,
                                                                              gpointer self);
static void _gala_window_clone_drag_destination_crossed_gala_drag_drop_action_destination_crossed (GalaDragDropAction* _sender,
                                                                                            ClutterActor* destination,
                                                                                            gboolean hovered,
                                                                                            gpointer self);
static void _gala_window_clone_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                                 ClutterActor* actor,
                                                                 gpointer self);
static void _gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                           gpointer self);
static void _gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                           guint32 button,
                                                                           gpointer self);
VALA_EXTERN GalaTooltip* gala_tooltip_new (void);
VALA_EXTERN GalaTooltip* gala_tooltip_construct (GType object_type);
static void gala_window_clone_finalize (GObject * obj);
static GType gala_window_clone_get_type_once (void);
static void _vala_gala_window_clone_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_gala_window_clone_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_window_clone_get_instance_private (GalaWindowClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowClone_private_offset);
}

static void
_gala_window_clone_unmanaged_meta_window_unmanaged (MetaWindow* _sender,
                                                    gpointer self)
{
	gala_window_clone_unmanaged ((GalaWindowClone*) self);
}

static void
_gala_window_clone_on_all_workspaces_changed_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	gala_window_clone_on_all_workspaces_changed ((GalaWindowClone*) self);
}

static void
_gala_window_clone_check_shadow_requirements_g_object_notify (GObject* _sender,
                                                              GParamSpec* pspec,
                                                              gpointer self)
{
	gala_window_clone_check_shadow_requirements ((GalaWindowClone*) self);
}

static void
_vala_MtkRectangle_free (MtkRectangle* self)
{
	g_boxed_free (mtk_rectangle_get_type (), self);
}

GalaWindowClone*
gala_window_clone_construct (GType object_type,
                             GalaWindowManager* wm,
                             MetaWindow* window,
                             GalaGestureTracker* gesture_tracker,
                             gfloat scale,
                             gboolean overview_mode)
{
	GalaWindowClone * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	self = (GalaWindowClone*) g_object_new (object_type, "wm", wm, "window", window, "gesture-tracker", gesture_tracker, "monitor-scale-factor", scale, "overview-mode", overview_mode, NULL);
	return self;
}

GalaWindowClone*
gala_window_clone_new (GalaWindowManager* wm,
                       MetaWindow* window,
                       GalaGestureTracker* gesture_tracker,
                       gfloat scale,
                       gboolean overview_mode)
{
	return gala_window_clone_construct (GALA_TYPE_WINDOW_CLONE, wm, window, gesture_tracker, scale, overview_mode);
}

static void
_gala_window_clone_close_window_gala_close_button_triggered (GalaCloseButton* _sender,
                                                             guint32 timestamp,
                                                             gpointer self)
{
	gala_window_clone_close_window ((GalaWindowClone*) self, timestamp);
}

static void
gala_window_clone_reallocate (GalaWindowClone* self)
{
	MtkRectangle window_frame_rect = {0};
	MetaWindow* _tmp0_;
	MtkRectangle _tmp1_ = {0};
	gfloat _tmp2_;
	gfloat _tmp3_;
	GalaCloseButton* _tmp4_ = NULL;
	GalaCloseButton* _tmp5_;
	MetaWindow* _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	GalaWindowIcon* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	MtkRectangle _tmp12_;
	MtkRectangle _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	GalaCloseButton* _tmp16_;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	GalaTooltip* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp0_, &_tmp1_);
	window_frame_rect = _tmp1_;
	_tmp2_ = gala_window_clone_get_monitor_scale_factor (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gala_close_button_new (_tmp3_);
	clutter_actor_set_opacity ((ClutterActor*) _tmp4_, (guint) 0);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp4_;
	_tmp5_ = self->priv->close_button;
	g_signal_connect_object (_tmp5_, "triggered", (GCallback) _gala_window_clone_close_window_gala_close_button_triggered, self, 0);
	_tmp6_ = self->priv->_window;
	_tmp7_ = gala_window_clone_get_monitor_scale_factor (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = gala_window_icon_new (_tmp6_, GALA_WINDOW_CLONE_WINDOW_ICON_SIZE, (gint) round ((gdouble) _tmp8_));
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->window_icon);
	self->priv->window_icon = (ClutterActor*) _tmp9_;
	_tmp10_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp10_, (guint) 0);
	_tmp11_ = self->priv->window_icon;
	clutter_actor_set_pivot_point (_tmp11_, 0.5f, 0.5f);
	_tmp12_ = window_frame_rect;
	_tmp13_ = window_frame_rect;
	_tmp14_ = gala_window_clone_get_monitor_scale_factor (self);
	_tmp15_ = _tmp14_;
	gala_window_clone_set_window_icon_position (self, (gfloat) _tmp12_.width, (gfloat) _tmp13_.height, _tmp15_, TRUE);
	_tmp16_ = self->priv->close_button;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp16_);
	_tmp17_ = self->priv->window_icon;
	clutter_actor_add_child ((ClutterActor*) self, _tmp17_);
	_tmp18_ = self->priv->window_icon;
	_tmp19_ = self->priv->window_title;
	clutter_actor_set_child_below_sibling ((ClutterActor*) self, _tmp18_, (ClutterActor*) _tmp19_);
}

/**
     * Waits for the texture of a new Meta.WindowActor to be available
     * and makes a close of it. If it was already was assigned a slot
     * at this point it will animate to it. Otherwise it will just place
     * itself at the location of the original window. Also adds the shadow
     * effect and makes sure the shadow is updated on size changes.
     *
     * @param was_waiting Internal argument used to indicate that we had to
     *                    wait before the window's texture became available.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
___lambda20_ (GalaWindowClone* self)
{
	MetaWindow* _tmp0_;
	GObject* _tmp1_;
	gboolean result;
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_compositor_private (_tmp0_);
	if (_tmp1_ != NULL) {
		gala_window_clone_load_clone (self, TRUE);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda20__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda20_ ((GalaWindowClone*) self);
	return result;
}

static void
gala_window_clone_load_clone (GalaWindowClone* self,
                              gboolean was_waiting)
{
	MetaWindowActor* actor = NULL;
	MetaWindow* _tmp0_;
	GObject* _tmp1_;
	MetaWindowActor* _tmp2_;
	MetaWindowActor* _tmp3_;
	gboolean _tmp4_;
	MetaWindowActor* _tmp6_;
	ClutterClone* _tmp7_;
	ClutterClone* _tmp8_;
	GalaWindowCloneActiveShape* _tmp9_;
	ClutterClone* _tmp10_;
	GalaCloseButton* _tmp11_;
	ClutterClone* _tmp12_;
	ClutterActor* _tmp13_;
	ClutterClone* _tmp14_;
	GalaTooltip* _tmp15_;
	ClutterClone* _tmp16_;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_compositor_private (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, meta_window_actor_get_type (), MetaWindowActor));
	actor = _tmp2_;
	_tmp3_ = actor;
	if (_tmp3_ == NULL) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda20__gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (actor);
		return;
	}
	_tmp4_ = self->priv->_overview_mode;
	if (_tmp4_) {
		MetaWindowActor* _tmp5_;
		_tmp5_ = actor;
		clutter_actor_hide ((ClutterActor*) _tmp5_);
	}
	_tmp6_ = actor;
	_tmp7_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp6_);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->clone);
	self->priv->clone = _tmp7_;
	_tmp8_ = self->priv->clone;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp8_);
	_tmp9_ = self->priv->active_shape;
	_tmp10_ = self->priv->clone;
	clutter_actor_set_child_below_sibling ((ClutterActor*) self, (ClutterActor*) _tmp9_, (ClutterActor*) _tmp10_);
	_tmp11_ = self->priv->close_button;
	_tmp12_ = self->priv->clone;
	clutter_actor_set_child_above_sibling ((ClutterActor*) self, (ClutterActor*) _tmp11_, (ClutterActor*) _tmp12_);
	_tmp13_ = self->priv->window_icon;
	_tmp14_ = self->priv->clone;
	clutter_actor_set_child_above_sibling ((ClutterActor*) self, _tmp13_, (ClutterActor*) _tmp14_);
	_tmp15_ = self->priv->window_title;
	_tmp16_ = self->priv->clone;
	clutter_actor_set_child_above_sibling ((ClutterActor*) self, (ClutterActor*) _tmp15_, (ClutterActor*) _tmp16_);
	gala_window_clone_transition_to_original_state (self, FALSE, FALSE, FALSE);
	gala_window_clone_check_shadow_requirements (self);
	if (gala_window_clone_should_fade (self)) {
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	}
	if (was_waiting) {
		MtkRectangle* _tmp18_;
		_tmp18_ = self->priv->_slot;
		_tmp17_ = _tmp18_ != NULL;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		MtkRectangle* _tmp19_;
		MtkRectangle _tmp20_;
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
		_tmp19_ = self->priv->_slot;
		_tmp20_ = *_tmp19_;
		gala_window_clone_take_slot (self, &_tmp20_, FALSE, FALSE);
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
		g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
	}
	_g_object_unref0 (actor);
}

static void
gala_window_clone_check_shadow_requirements (GalaWindowClone* self)
{
	ClutterClone* _tmp0_;
	gboolean _tmp1_ = FALSE;
	MetaWindow* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->_window;
	g_object_get (_tmp2_, "fullscreen", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		MetaWindow* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->_window;
		g_object_get (_tmp6_, "maximized-horizontally", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			MetaWindow* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp9_ = self->priv->_window;
			g_object_get (_tmp9_, "maximized-vertically", &_tmp10_, NULL);
			_tmp11_ = _tmp10_;
			_tmp5_ = _tmp11_;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		GalaShadowEffect* _tmp12_;
		_tmp12_ = self->priv->shadow_effect;
		if (_tmp12_ == NULL) {
			gchar* _tmp13_;
			GalaShadowEffect* _tmp14_ = NULL;
			ClutterClone* _tmp15_;
			GalaShadowEffect* _tmp16_;
			_tmp13_ = g_strdup ("window-clone");
			_tmp14_ = gala_shadow_effect_new (55);
			gala_shadow_effect_set_css_class (_tmp14_, _tmp13_);
			_g_free0 (_tmp13_);
			g_object_ref_sink (_tmp14_);
			_g_object_unref0 (self->priv->shadow_effect);
			self->priv->shadow_effect = _tmp14_;
			gala_window_clone_set_shadow_opacity (self, (guint8) 0);
			_tmp15_ = self->priv->clone;
			_tmp16_ = self->priv->shadow_effect;
			clutter_actor_add_effect_with_name ((ClutterActor*) _tmp15_, "shadow", (ClutterEffect*) _tmp16_);
		}
	} else {
		GalaShadowEffect* _tmp17_;
		_tmp17_ = self->priv->shadow_effect;
		if (_tmp17_ != NULL) {
			ClutterClone* _tmp18_;
			GalaShadowEffect* _tmp19_;
			_tmp18_ = self->priv->clone;
			_tmp19_ = self->priv->shadow_effect;
			clutter_actor_remove_effect ((ClutterActor*) _tmp18_, (ClutterEffect*) _tmp19_);
			_g_object_unref0 (self->priv->shadow_effect);
			self->priv->shadow_effect = NULL;
		}
	}
}

/**
     * If we are in overview mode, we may display windows from workspaces other than
     * the current one. To ease their appearance we have to fade them in.
     */
static gboolean
gala_window_clone_should_fade (GalaWindowClone* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->priv->_overview_mode;
	if (_tmp2_) {
		MetaWindow* _tmp3_;
		MetaWorkspace* _tmp4_;
		MetaWindow* _tmp5_;
		MetaDisplay* _tmp6_;
		MetaWorkspaceManager* _tmp7_;
		MetaWorkspace* _tmp8_;
		_tmp3_ = self->priv->_window;
		_tmp4_ = meta_window_get_workspace (_tmp3_);
		_tmp5_ = self->priv->_window;
		_tmp6_ = meta_window_get_display (_tmp5_);
		_tmp7_ = meta_display_get_workspace_manager (_tmp6_);
		_tmp8_ = meta_workspace_manager_get_active_workspace (_tmp7_);
		_tmp1_ = _tmp4_ != _tmp8_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		MetaWindow* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->_window;
		g_object_get (_tmp9_, "minimized", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		_tmp0_ = _tmp11_;
	}
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_on_all_workspaces_changed (GalaWindowClone* self)
{
	MetaWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	g_object_get (_tmp0_, "on-all-workspaces", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gala_window_clone_unmanaged (self);
	}
}

/**
     * Place the window at the location of the original MetaWindow
     *
     * @param animate Animate the transformation of the placement
     */
static Block67Data*
block67_data_ref (Block67Data* _data67_)
{
	g_atomic_int_inc (&_data67_->_ref_count_);
	return _data67_;
}

static void
block67_data_unref (void * _userdata_)
{
	Block67Data* _data67_;
	_data67_ = (Block67Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data67_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data67_->self;
		_g_object_unref0 (self);
		g_slice_free (Block67Data, _data67_);
	}
}

static void
__lambda21_ (Block67Data* _data67_,
             gdouble percentage)
{
	GalaWindowClone* self;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	gfloat width = 0.0F;
	MtkRectangle _tmp0_;
	gfloat height = 0.0F;
	MtkRectangle _tmp1_;
	gfloat scale = 0.0F;
	gfloat opacity = 0.0F;
	ClutterActor* _tmp2_;
	self = _data67_->self;
	x = gala_gesture_tracker_animation_value (_data67_->initial_x, (gfloat) _data67_->target_x, percentage, FALSE);
	y = gala_gesture_tracker_animation_value (_data67_->initial_y, (gfloat) _data67_->target_y, percentage, FALSE);
	_tmp0_ = _data67_->outer_rect;
	width = gala_gesture_tracker_animation_value (_data67_->initial_width, (gfloat) _tmp0_.width, percentage, FALSE);
	_tmp1_ = _data67_->outer_rect;
	height = gala_gesture_tracker_animation_value (_data67_->initial_height, (gfloat) _tmp1_.height, percentage, FALSE);
	scale = gala_gesture_tracker_animation_value (_data67_->initial_scale, _data67_->target_scale, percentage, FALSE);
	opacity = gala_gesture_tracker_animation_value (255.f, 0.f, percentage, FALSE);
	clutter_actor_set_size ((ClutterActor*) self, width, height);
	clutter_actor_set_position ((ClutterActor*) self, x, y);
	_tmp2_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp2_, (guint) opacity);
	gala_window_clone_set_window_icon_position (self, width, height, scale, FALSE);
	gala_window_clone_place_widgets (self, (gint) width, (gint) height, scale);
	gala_window_clone_set_shadow_opacity (self, (guint8) opacity);
}

static void
___lambda21__gala_gesture_tracker_on_update (gdouble percentage,
                                             gpointer self)
{
	__lambda21_ (self, percentage);
}

static void
___lambda78_ (Block67Data* _data67_)
{
	GalaWindowClone* self;
	MtkRectangle _tmp0_;
	MtkRectangle _tmp1_;
	self = _data67_->self;
	self->priv->in_slot_animation = FALSE;
	_tmp0_ = _data67_->outer_rect;
	_tmp1_ = _data67_->outer_rect;
	gala_window_clone_place_widgets (self, _tmp0_.width, _tmp1_.height, _data67_->target_scale);
}

static void
____lambda78__clutter_timeline_completed (ClutterTimeline* _sender,
                                          gpointer self)
{
	___lambda78_ (self);
}

static void
__lambda22_ (Block67Data* _data67_,
             gdouble percentage,
             gboolean cancel_action)
{
	GalaWindowClone* self;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint duration = 0;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	MtkRectangle _tmp11_;
	MtkRectangle _tmp12_;
	ClutterActor* _tmp13_;
	ClutterTransition* transition = NULL;
	ClutterActor* _tmp14_;
	ClutterTransition* _tmp15_;
	ClutterTransition* _tmp16_;
	ClutterTransition* _tmp17_;
	self = _data67_->self;
	if (cancel_action) {
		return;
	}
	if (_data67_->animate) {
		GalaWindowManager* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->_wm;
		_tmp3_ = gala_window_manager_get_enable_animations (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp0_ = 0;
	}
	duration = _tmp0_;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) duration);
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _data67_->target_x, (gfloat) _data67_->target_y);
	_tmp5_ = _data67_->outer_rect;
	_tmp6_ = _data67_->outer_rect;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp5_.width, (gfloat) _tmp6_.height);
	if (gala_window_clone_should_fade (self)) {
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	}
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	if (_data67_->animate) {
		gala_window_clone_toggle_shadow (self, FALSE);
	}
	_tmp7_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp7_);
	_tmp8_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp8_, CLUTTER_EASE_OUT_QUAD);
	_tmp9_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp9_, (guint) duration);
	_tmp10_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp10_, (guint) 0);
	_tmp11_ = _data67_->outer_rect;
	_tmp12_ = _data67_->outer_rect;
	gala_window_clone_set_window_icon_position (self, (gfloat) _tmp11_.width, (gfloat) _tmp12_.height, _data67_->target_scale, TRUE);
	_tmp13_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp13_);
	_tmp14_ = self->priv->window_icon;
	_tmp15_ = clutter_actor_get_transition (_tmp14_, "opacity");
	_tmp16_ = _g_object_ref0 (_tmp15_);
	transition = _tmp16_;
	_tmp17_ = transition;
	if (_tmp17_ != NULL) {
		ClutterTransition* _tmp18_;
		_tmp18_ = transition;
		g_signal_connect_data ((ClutterTimeline*) _tmp18_, "completed", (GCallback) ____lambda78__clutter_timeline_completed, block67_data_ref (_data67_), (GClosureNotify) block67_data_unref, 0);
	} else {
		MtkRectangle _tmp19_;
		MtkRectangle _tmp20_;
		self->priv->in_slot_animation = FALSE;
		_tmp19_ = _data67_->outer_rect;
		_tmp20_ = _data67_->outer_rect;
		gala_window_clone_place_widgets (self, _tmp19_.width, _tmp20_.height, _data67_->target_scale);
	}
	_g_object_unref0 (transition);
}

static void
___lambda22__gala_gesture_tracker_on_end (gdouble percentage,
                                          gboolean cancel_action,
                                          gint calculated_duration,
                                          gpointer self)
{
	__lambda22_ (self, percentage, cancel_action);
}

void
gala_window_clone_transition_to_original_state (GalaWindowClone* self,
                                                gboolean animate,
                                                gboolean with_gesture,
                                                gboolean is_cancel_animation)
{
	Block67Data* _data67_;
	MetaWindow* _tmp0_;
	MtkRectangle _tmp1_ = {0};
	MetaDisplay* display = NULL;
	MetaWindow* _tmp2_;
	MetaDisplay* _tmp3_;
	MtkRectangle monitor_geom = {0};
	MetaDisplay* _tmp4_;
	MetaWindow* _tmp5_;
	MtkRectangle _tmp6_ = {0};
	gfloat _tmp7_;
	gfloat _tmp8_;
	MetaDisplay* _tmp9_;
	MetaWindow* _tmp10_;
	gint offset_x = 0;
	MtkRectangle _tmp11_;
	gint offset_y = 0;
	MtkRectangle _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	gfloat _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	MtkRectangle _tmp21_;
	MtkRectangle _tmp22_;
	MtkRectangle _tmp23_;
	MtkRectangle _tmp24_;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	g_return_if_fail (self != NULL);
	_data67_ = g_slice_new0 (Block67Data);
	_data67_->_ref_count_ = 1;
	_data67_->self = g_object_ref (self);
	_data67_->animate = animate;
	_tmp0_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp0_, &_tmp1_);
	_data67_->outer_rect = _tmp1_;
	_tmp2_ = self->priv->_window;
	_tmp3_ = meta_window_get_display (_tmp2_);
	display = _tmp3_;
	_tmp4_ = display;
	_tmp5_ = self->priv->_window;
	meta_display_get_monitor_geometry (_tmp4_, meta_window_get_monitor (_tmp5_), &_tmp6_);
	monitor_geom = _tmp6_;
	_tmp7_ = gala_window_clone_get_monitor_scale_factor (self);
	_tmp8_ = _tmp7_;
	_data67_->initial_scale = _tmp8_;
	_tmp9_ = display;
	_tmp10_ = self->priv->_window;
	_data67_->target_scale = meta_display_get_monitor_scale (_tmp9_, meta_window_get_monitor (_tmp10_));
	_tmp11_ = monitor_geom;
	offset_x = _tmp11_.x;
	_tmp12_ = monitor_geom;
	offset_y = _tmp12_.y;
	_tmp13_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp14_ = _tmp13_;
	_data67_->initial_x = _tmp14_;
	_tmp15_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp16_ = _tmp15_;
	_data67_->initial_y = _tmp16_;
	_tmp17_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp18_ = _tmp17_;
	_data67_->initial_width = _tmp18_;
	_tmp19_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp20_ = _tmp19_;
	_data67_->initial_height = _tmp20_;
	_tmp21_ = _data67_->outer_rect;
	_data67_->target_x = _tmp21_.x - offset_x;
	_tmp22_ = _data67_->outer_rect;
	_data67_->target_y = _tmp22_.y - offset_y;
	gala_window_clone_set_active (self, FALSE);
	self->priv->in_slot_animation = TRUE;
	_tmp23_ = _data67_->outer_rect;
	_tmp24_ = _data67_->outer_rect;
	gala_window_clone_place_widgets (self, _tmp23_.width, _tmp24_.height, _data67_->initial_scale);
	on_animation_update = ___lambda21__gala_gesture_tracker_on_update;
	on_animation_update_target = block67_data_ref (_data67_);
	on_animation_update_target_destroy_notify = block67_data_unref;
	on_animation_end = ___lambda22__gala_gesture_tracker_on_end;
	on_animation_end_target = block67_data_ref (_data67_);
	on_animation_end_target_destroy_notify = block67_data_unref;
	if (!_data67_->animate) {
		_tmp27_ = TRUE;
	} else {
		GalaGestureTracker* _tmp28_;
		_tmp28_ = self->priv->_gesture_tracker;
		_tmp27_ = _tmp28_ == NULL;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = !with_gesture;
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		GalaWindowManager* _tmp29_;
		gboolean _tmp30_;
		gboolean _tmp31_;
		_tmp29_ = self->priv->_wm;
		_tmp30_ = gala_window_manager_get_enable_animations (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp25_ = !_tmp31_;
	}
	if (_tmp25_) {
		GalaGestureTrackerOnEnd _tmp32_;
		gpointer _tmp32__target;
		_tmp32_ = on_animation_end;
		_tmp32__target = on_animation_end_target;
		_tmp32_ ((gdouble) 1, FALSE, 0, _tmp32__target);
	} else {
		GalaGestureTracker* _tmp33_;
		GalaGestureTrackerOnUpdate _tmp34_;
		gpointer _tmp34__target;
		GDestroyNotify _tmp34__target_destroy_notify;
		GalaGestureTrackerOnEnd _tmp35_;
		gpointer _tmp35__target;
		GDestroyNotify _tmp35__target_destroy_notify;
		_tmp33_ = self->priv->_gesture_tracker;
		_tmp34_ = on_animation_update;
		_tmp34__target = on_animation_update_target;
		_tmp34__target_destroy_notify = on_animation_update_target_destroy_notify;
		on_animation_update = NULL;
		on_animation_update_target = NULL;
		on_animation_update_target_destroy_notify = NULL;
		_tmp35_ = on_animation_end;
		_tmp35__target = on_animation_end_target;
		_tmp35__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp33_, NULL, NULL, NULL, _tmp34_, _tmp34__target, _tmp34__target_destroy_notify, _tmp35_, _tmp35__target, _tmp35__target_destroy_notify);
	}
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	block67_data_unref (_data67_);
	_data67_ = NULL;
}

/**
     * Animate the window to the given slot
     */
static Block68Data*
block68_data_ref (Block68Data* _data68_)
{
	g_atomic_int_inc (&_data68_->_ref_count_);
	return _data68_;
}

static void
block68_data_unref (void * _userdata_)
{
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data68_->self;
		_g_object_unref0 (self);
		g_slice_free (Block68Data, _data68_);
	}
}

static void
__lambda26_ (Block68Data* _data68_,
             gdouble percentage)
{
	GalaWindowClone* self;
	gfloat x = 0.0F;
	MtkRectangle _tmp0_;
	gfloat y = 0.0F;
	MtkRectangle _tmp1_;
	gfloat width = 0.0F;
	MtkRectangle _tmp2_;
	gfloat height = 0.0F;
	MtkRectangle _tmp3_;
	gfloat opacity = 0.0F;
	ClutterActor* _tmp4_;
	self = _data68_->self;
	_tmp0_ = _data68_->rect;
	x = gala_gesture_tracker_animation_value (_data68_->initial_x, (gfloat) _tmp0_.x, percentage, FALSE);
	_tmp1_ = _data68_->rect;
	y = gala_gesture_tracker_animation_value (_data68_->initial_y, (gfloat) _tmp1_.y, percentage, FALSE);
	_tmp2_ = _data68_->rect;
	width = gala_gesture_tracker_animation_value (_data68_->initial_width, (gfloat) _tmp2_.width, percentage, FALSE);
	_tmp3_ = _data68_->rect;
	height = gala_gesture_tracker_animation_value (_data68_->initial_height, (gfloat) _tmp3_.height, percentage, FALSE);
	opacity = gala_gesture_tracker_animation_value (0.f, 255.f, percentage, FALSE);
	clutter_actor_set_size ((ClutterActor*) self, width, height);
	clutter_actor_set_position ((ClutterActor*) self, x, y);
	_tmp4_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp4_, (guint) opacity);
	gala_window_clone_set_window_icon_position (self, width, height, _data68_->scale, FALSE);
	gala_window_clone_set_shadow_opacity (self, (guint8) opacity);
}

static void
___lambda26__gala_gesture_tracker_on_update (gdouble percentage,
                                             gpointer self)
{
	__lambda26_ (self, percentage);
}

static void
___lambda28_ (Block68Data* _data68_)
{
	GalaWindowClone* self;
	MtkRectangle _tmp0_;
	MtkRectangle _tmp1_;
	self = _data68_->self;
	self->priv->in_slot_animation = FALSE;
	_tmp0_ = _data68_->rect;
	_tmp1_ = _data68_->rect;
	gala_window_clone_place_widgets (self, _tmp0_.width, _tmp1_.height, _data68_->scale);
}

static void
____lambda28__clutter_timeline_completed (ClutterTimeline* _sender,
                                          gpointer self)
{
	___lambda28_ (self);
}

static void
__lambda27_ (Block68Data* _data68_,
             gdouble percentage,
             gboolean cancel_action)
{
	GalaWindowClone* self;
	gint _tmp0_ = 0;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint duration = 0;
	MtkRectangle _tmp4_;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	MtkRectangle _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	MtkRectangle _tmp12_;
	MtkRectangle _tmp13_;
	ClutterActor* _tmp14_;
	ClutterTransition* transition = NULL;
	ClutterActor* _tmp15_;
	ClutterTransition* _tmp16_;
	ClutterTransition* _tmp17_;
	ClutterTransition* _tmp18_;
	self = _data68_->self;
	if (cancel_action) {
		return;
	}
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp0_ = 0;
	}
	duration = _tmp0_;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) duration);
	_tmp4_ = _data68_->rect;
	_tmp5_ = _data68_->rect;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp4_.width, (gfloat) _tmp5_.height);
	_tmp6_ = _data68_->rect;
	_tmp7_ = _data68_->rect;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp6_.x, (gfloat) _tmp7_.y);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	_tmp8_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp8_);
	_tmp9_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp9_, CLUTTER_EASE_OUT_QUAD);
	_tmp10_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp10_, (guint) duration);
	_tmp11_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp11_, (guint) 255);
	_tmp12_ = _data68_->rect;
	_tmp13_ = _data68_->rect;
	gala_window_clone_set_window_icon_position (self, (gfloat) _tmp12_.width, (gfloat) _tmp13_.height, _data68_->scale, TRUE);
	_tmp14_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp14_);
	gala_window_clone_toggle_shadow (self, TRUE);
	_tmp15_ = self->priv->window_icon;
	_tmp16_ = clutter_actor_get_transition (_tmp15_, "opacity");
	_tmp17_ = _g_object_ref0 (_tmp16_);
	transition = _tmp17_;
	_tmp18_ = transition;
	if (_tmp18_ != NULL) {
		ClutterTransition* _tmp19_;
		_tmp19_ = transition;
		g_signal_connect_data ((ClutterTimeline*) _tmp19_, "completed", (GCallback) ____lambda28__clutter_timeline_completed, block68_data_ref (_data68_), (GClosureNotify) block68_data_unref, 0);
	} else {
		MtkRectangle _tmp20_;
		MtkRectangle _tmp21_;
		self->priv->in_slot_animation = FALSE;
		_tmp20_ = _data68_->rect;
		_tmp21_ = _data68_->rect;
		gala_window_clone_place_widgets (self, _tmp20_.width, _tmp21_.height, _data68_->scale);
	}
	_g_object_unref0 (transition);
}

static void
___lambda27__gala_gesture_tracker_on_end (gdouble percentage,
                                          gboolean cancel_action,
                                          gint calculated_duration,
                                          gpointer self)
{
	__lambda27_ (self, percentage, cancel_action);
}

void
gala_window_clone_take_slot (GalaWindowClone* self,
                             MtkRectangle* rect,
                             gboolean with_gesture,
                             gboolean is_cancel_animation)
{
	Block68Data* _data68_;
	MtkRectangle _tmp0_;
	MtkRectangle _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp10_;
	MetaDisplay* _tmp11_;
	MetaDisplay* _tmp12_;
	MetaDisplay* _tmp13_;
	MtkRectangle _tmp14_;
	MtkRectangle _tmp15_;
	MtkRectangle _tmp16_;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	GalaGestureTracker* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (rect != NULL);
	_data68_ = g_slice_new0 (Block68Data);
	_data68_->_ref_count_ = 1;
	_data68_->self = g_object_ref (self);
	_tmp0_ = *rect;
	_data68_->rect = _tmp0_;
	_tmp1_ = _data68_->rect;
	gala_window_clone_set_slot (self, &_tmp1_);
	_tmp2_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp3_ = _tmp2_;
	_data68_->initial_x = _tmp3_;
	_tmp4_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp5_ = _tmp4_;
	_data68_->initial_y = _tmp5_;
	_tmp6_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp7_ = _tmp6_;
	_data68_->initial_width = _tmp7_;
	_tmp8_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp9_ = _tmp8_;
	_data68_->initial_height = _tmp9_;
	gala_window_clone_set_active (self, FALSE);
	_tmp10_ = self->priv->_wm;
	_tmp11_ = meta_plugin_get_display ((MetaPlugin*) _tmp10_);
	display = _tmp11_;
	_tmp12_ = display;
	_tmp13_ = display;
	_tmp14_ = _data68_->rect;
	_data68_->scale = meta_display_get_monitor_scale (_tmp12_, meta_display_get_monitor_index_for_rect (_tmp13_, &_tmp14_));
	self->priv->in_slot_animation = TRUE;
	_tmp15_ = _data68_->rect;
	_tmp16_ = _data68_->rect;
	gala_window_clone_place_widgets (self, _tmp15_.width, _tmp16_.height, _data68_->scale);
	on_animation_update = ___lambda26__gala_gesture_tracker_on_update;
	on_animation_update_target = block68_data_ref (_data68_);
	on_animation_update_target_destroy_notify = block68_data_unref;
	on_animation_end = ___lambda27__gala_gesture_tracker_on_end;
	on_animation_end_target = block68_data_ref (_data68_);
	on_animation_end_target_destroy_notify = block68_data_unref;
	_tmp19_ = self->priv->_gesture_tracker;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = !with_gesture;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		GalaWindowManager* _tmp20_;
		gboolean _tmp21_;
		gboolean _tmp22_;
		_tmp20_ = self->priv->_wm;
		_tmp21_ = gala_window_manager_get_enable_animations (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp17_ = !_tmp22_;
	}
	if (_tmp17_) {
		GalaGestureTrackerOnEnd _tmp23_;
		gpointer _tmp23__target;
		_tmp23_ = on_animation_end;
		_tmp23__target = on_animation_end_target;
		_tmp23_ ((gdouble) 1, FALSE, 0, _tmp23__target);
	} else {
		GalaGestureTracker* _tmp24_;
		GalaGestureTrackerOnUpdate _tmp25_;
		gpointer _tmp25__target;
		GDestroyNotify _tmp25__target_destroy_notify;
		GalaGestureTrackerOnEnd _tmp26_;
		gpointer _tmp26__target;
		GDestroyNotify _tmp26__target_destroy_notify;
		_tmp24_ = self->priv->_gesture_tracker;
		_tmp25_ = on_animation_update;
		_tmp25__target = on_animation_update_target;
		_tmp25__target_destroy_notify = on_animation_update_target_destroy_notify;
		on_animation_update = NULL;
		on_animation_update_target = NULL;
		on_animation_update_target_destroy_notify = NULL;
		_tmp26_ = on_animation_end;
		_tmp26__target = on_animation_end_target;
		_tmp26__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp24_, NULL, NULL, NULL, _tmp25_, _tmp25__target, _tmp25__target_destroy_notify, _tmp26_, _tmp26__target, _tmp26__target_destroy_notify);
	}
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	block68_data_unref (_data68_);
	_data68_ = NULL;
}

/**
     * Except for the texture clone and the highlight all children are placed
     * according to their given allocations. The first two are placed in a way
     * that compensates for invisible borders of the texture.
     */
static void
gala_window_clone_real_allocate (ClutterActor* base,
                                 ClutterActorBox* box)
{
	GalaWindowClone * self;
	ClutterActorBox _tmp0_;
	MtkRectangle input_rect = {0};
	MetaWindow* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	MtkRectangle outer_rect = {0};
	MetaWindow* _tmp3_;
	MtkRectangle _tmp4_ = {0};
	gfloat scale_factor = 0.0F;
	gfloat _tmp5_;
	gfloat _tmp6_;
	MtkRectangle _tmp7_;
	ClutterActorBox shape_alloc = {0};
	MtkRectangle _tmp8_;
	MtkRectangle _tmp9_;
	ClutterActorBox _tmp10_ = {0};
	GalaWindowCloneActiveShape* _tmp11_;
	ClutterActorBox _tmp12_;
	gboolean _tmp13_ = FALSE;
	ClutterClone* _tmp14_;
	ClutterClone* _tmp20_;
	ClutterClone* _tmp21_;
	MtkRectangle _tmp22_;
	MtkRectangle _tmp23_;
	MtkRectangle _tmp24_;
	MtkRectangle _tmp25_;
	self = (GalaWindowClone*) base;
	g_return_if_fail (box != NULL);
	_tmp0_ = *box;
	CLUTTER_ACTOR_CLASS (gala_window_clone_parent_class)->allocate (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor), &_tmp0_);
	_tmp1_ = self->priv->_window;
	meta_window_get_buffer_rect (_tmp1_, &_tmp2_);
	input_rect = _tmp2_;
	_tmp3_ = self->priv->_window;
	meta_window_get_frame_rect (_tmp3_, &_tmp4_);
	outer_rect = _tmp4_;
	_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = outer_rect;
	scale_factor = _tmp6_ / _tmp7_.width;
	_tmp8_ = outer_rect;
	_tmp9_ = outer_rect;
	_tmp10_.x1 = (gfloat) (-GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE);
	_tmp10_.y1 = (gfloat) (-GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE);
	_tmp10_.x2 = (_tmp8_.width * scale_factor) + GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE;
	_tmp10_.y2 = (_tmp9_.height * scale_factor) + GALA_WINDOW_CLONE_ACTIVE_SHAPE_SIZE;
	shape_alloc = _tmp10_;
	_tmp11_ = self->priv->active_shape;
	_tmp12_ = shape_alloc;
	clutter_actor_allocate ((ClutterActor*) _tmp11_, &_tmp12_);
	_tmp14_ = self->priv->clone;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp15_ = FALSE;
		GalaDragDropAction* _tmp16_;
		_tmp16_ = self->priv->drag_action;
		if (_tmp16_ != NULL) {
			GalaDragDropAction* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = self->priv->drag_action;
			_tmp18_ = gala_drag_drop_action_get_dragging (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp15_ = _tmp19_;
		} else {
			_tmp15_ = FALSE;
		}
		_tmp13_ = _tmp15_;
	}
	if (_tmp13_) {
		return;
	}
	_tmp20_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp20_, (gdouble) scale_factor, (gdouble) scale_factor);
	_tmp21_ = self->priv->clone;
	_tmp22_ = input_rect;
	_tmp23_ = outer_rect;
	_tmp24_ = input_rect;
	_tmp25_ = outer_rect;
	clutter_actor_set_position ((ClutterActor*) _tmp21_, (_tmp22_.x - _tmp23_.x) * scale_factor, (_tmp24_.y - _tmp25_.y) * scale_factor);
}

static gboolean
gala_window_clone_real_button_press_event (ClutterActor* base,
                                           ClutterEvent* event)
{
	GalaWindowClone * self;
	gboolean result;
	self = (GalaWindowClone*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	result = CLUTTER_EVENT_STOP;
	return result;
}

static gboolean
gala_window_clone_real_enter_event (ClutterActor* base,
                                    ClutterEvent* event)
{
	GalaWindowClone * self;
	gboolean _tmp0_ = FALSE;
	GalaDragDropAction* _tmp1_;
	gint _tmp5_ = 0;
	GalaWindowManager* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gint duration = 0;
	GalaCloseButton* _tmp9_;
	GalaCloseButton* _tmp10_;
	GalaCloseButton* _tmp11_;
	gint _tmp12_ = 0;
	GalaCloseButton* _tmp13_;
	GalaCloseButton* _tmp14_;
	GalaTooltip* _tmp15_;
	GalaTooltip* _tmp16_;
	GalaTooltip* _tmp17_;
	gint _tmp18_ = 0;
	GalaTooltip* _tmp19_;
	GalaTooltip* _tmp20_;
	gboolean result;
	self = (GalaWindowClone*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->drag_action;
	if (_tmp1_ != NULL) {
		GalaDragDropAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->drag_action;
		_tmp3_ = gala_drag_drop_action_get_dragging (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	_tmp6_ = self->priv->_wm;
	_tmp7_ = gala_window_manager_get_enable_animations (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		_tmp5_ = GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION;
	} else {
		_tmp5_ = 0;
	}
	duration = _tmp5_;
	_tmp9_ = self->priv->close_button;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp9_);
	_tmp10_ = self->priv->close_button;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp10_, CLUTTER_LINEAR);
	_tmp11_ = self->priv->close_button;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp11_, (guint) duration);
	if (self->priv->in_slot_animation) {
		_tmp12_ = 0;
	} else {
		_tmp12_ = 255;
	}
	_tmp13_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp13_, (guint) _tmp12_);
	_tmp14_ = self->priv->close_button;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp14_);
	_tmp15_ = self->priv->window_title;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp15_);
	_tmp16_ = self->priv->window_title;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp16_, CLUTTER_LINEAR);
	_tmp17_ = self->priv->window_title;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp17_, (guint) duration);
	if (self->priv->in_slot_animation) {
		_tmp18_ = 0;
	} else {
		_tmp18_ = 255;
	}
	_tmp19_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp19_, (guint) _tmp18_);
	_tmp20_ = self->priv->window_title;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp20_);
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
gala_window_clone_real_leave_event (ClutterActor* base,
                                    ClutterEvent* event)
{
	GalaWindowClone * self;
	gint _tmp0_ = 0;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint duration = 0;
	GalaCloseButton* _tmp4_;
	GalaCloseButton* _tmp5_;
	GalaCloseButton* _tmp6_;
	GalaCloseButton* _tmp7_;
	GalaCloseButton* _tmp8_;
	GalaTooltip* _tmp9_;
	GalaTooltip* _tmp10_;
	GalaTooltip* _tmp11_;
	GalaTooltip* _tmp12_;
	GalaTooltip* _tmp13_;
	gboolean result;
	self = (GalaWindowClone*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION;
	} else {
		_tmp0_ = 0;
	}
	duration = _tmp0_;
	_tmp4_ = self->priv->close_button;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp4_);
	_tmp5_ = self->priv->close_button;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp5_, CLUTTER_LINEAR);
	_tmp6_ = self->priv->close_button;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp6_, (guint) duration);
	_tmp7_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp7_, (guint) 0);
	_tmp8_ = self->priv->close_button;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp8_);
	_tmp9_ = self->priv->window_title;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp9_);
	_tmp10_ = self->priv->window_title;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp10_, CLUTTER_LINEAR);
	_tmp11_ = self->priv->window_title;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp11_, (guint) duration);
	_tmp12_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp12_, (guint) 0);
	_tmp13_ = self->priv->window_title;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp13_);
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

/**
     * Place the widgets, that is the close button and the WindowIcon of the window,
     * at their positions inside the actor for a given width and height.
     */
void
gala_window_clone_place_widgets (GalaWindowClone* self,
                                 gint dest_width,
                                 gint dest_height,
                                 gfloat scale_factor)
{
	gint close_button_size = 0;
	GalaCloseButton* _tmp0_;
	GalaCloseButton* _tmp1_;
	GalaCloseButton* _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_ = 0.0F;
	GalaCloseButton* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean show = FALSE;
	gint _tmp16_ = 0;
	GalaCloseButton* _tmp17_;
	GalaTooltip* _tmp18_;
	GalaCloseButton* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	const gchar* _tmp22_ = NULL;
	MetaWindow* _tmp23_;
	const gchar* _tmp24_;
	GalaTooltip* _tmp25_;
	GalaTooltip* _tmp26_;
	g_return_if_fail (self != NULL);
	close_button_size = gala_internal_utils_scale_to_int (GALA_WINDOW_CLONE_CLOSE_WINDOW_ICON_SIZE, scale_factor);
	_tmp0_ = self->priv->close_button;
	clutter_actor_set_size ((ClutterActor*) _tmp0_, (gfloat) close_button_size, (gfloat) close_button_size);
	_tmp1_ = self->priv->close_button;
	_tmp2_ = self->priv->close_button;
	_tmp3_ = clutter_actor_get_height ((ClutterActor*) _tmp2_);
	_tmp4_ = _tmp3_;
	clutter_actor_set_y ((ClutterActor*) _tmp1_, (-_tmp4_) * 0.33f);
	if (gala_window_clone_is_close_button_on_left ()) {
		GalaCloseButton* _tmp6_;
		gfloat _tmp7_;
		gfloat _tmp8_;
		_tmp6_ = self->priv->close_button;
		_tmp7_ = clutter_actor_get_width ((ClutterActor*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp5_ = (-_tmp8_) * 0.5f;
	} else {
		GalaCloseButton* _tmp9_;
		gfloat _tmp10_;
		gfloat _tmp11_;
		_tmp9_ = self->priv->close_button;
		_tmp10_ = clutter_actor_get_width ((ClutterActor*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = dest_width - (_tmp11_ * 0.5f);
	}
	_tmp12_ = self->priv->close_button;
	clutter_actor_set_x ((ClutterActor*) _tmp12_, _tmp5_);
	g_object_get ((ClutterActor*) self, "has-pointer", &_tmp14_, NULL);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		_tmp13_ = !self->priv->in_slot_animation;
	} else {
		_tmp13_ = FALSE;
	}
	show = _tmp13_;
	if (show) {
		_tmp16_ = 255;
	} else {
		_tmp16_ = 0;
	}
	_tmp17_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp17_, (guint) _tmp16_);
	_tmp18_ = self->priv->window_title;
	_tmp19_ = self->priv->close_button;
	_tmp20_ = clutter_actor_get_opacity ((ClutterActor*) _tmp19_);
	_tmp21_ = _tmp20_;
	clutter_actor_set_opacity ((ClutterActor*) _tmp18_, _tmp21_);
	_tmp23_ = self->priv->_window;
	_tmp24_ = meta_window_get_title (_tmp23_);
	_tmp22_ = _tmp24_;
	if (_tmp22_ == NULL) {
		_tmp22_ = "";
	}
	_tmp25_ = self->priv->window_title;
	gala_tooltip_set_text (_tmp25_, _tmp22_);
	_tmp26_ = self->priv->window_title;
	gala_tooltip_set_max_width (_tmp26_, (gfloat) (dest_width - gala_internal_utils_scale_to_int (GALA_WINDOW_CLONE_TITLE_MAX_WIDTH_MARGIN, scale_factor)));
	gala_window_clone_set_window_title_position (self, (gfloat) dest_width, (gfloat) dest_height, scale_factor);
}

static void
gala_window_clone_toggle_shadow (GalaWindowClone* self,
                                 gboolean show)
{
	ClutterTransition* _tmp0_;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_transition ((ClutterActor*) self, "shadow-opacity");
	if (_tmp0_ != NULL) {
		clutter_actor_remove_transition ((ClutterActor*) self, "shadow-opacity");
	}
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gint _tmp4_ = 0;
		ClutterPropertyTransition* shadow_transition = NULL;
		guint8 _tmp5_;
		guint8 _tmp6_;
		ClutterInterval* _tmp7_;
		ClutterPropertyTransition* _tmp8_ = NULL;
		ClutterPropertyTransition* _tmp9_;
		if (show) {
			_tmp4_ = 255;
		} else {
			_tmp4_ = 0;
		}
		_tmp5_ = gala_window_clone_get_shadow_opacity (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = clutter_interval_new (G_TYPE_UCHAR, _tmp6_, _tmp4_, NULL);
		g_object_ref_sink (_tmp7_);
		_tmp8_ = (ClutterPropertyTransition*) clutter_property_transition_new ("shadow-opacity");
		clutter_timeline_set_duration ((ClutterTimeline*) _tmp8_, (guint) GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
		clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp8_, TRUE);
		clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp8_, CLUTTER_EASE_OUT_QUAD);
		clutter_transition_set_interval ((ClutterTransition*) _tmp8_, _tmp7_);
		_g_object_unref0 (_tmp7_);
		shadow_transition = _tmp8_;
		_tmp9_ = shadow_transition;
		clutter_actor_add_transition ((ClutterActor*) self, "shadow-opacity", (ClutterTransition*) _tmp9_);
		_g_object_unref0 (shadow_transition);
	} else {
		gint _tmp10_ = 0;
		if (show) {
			_tmp10_ = 255;
		} else {
			_tmp10_ = 0;
		}
		gala_window_clone_set_shadow_opacity (self, (guint8) _tmp10_);
	}
}

/**
     * Send the window the delete signal and listen for new windows to be added
     * to the window's workspace, in which case we check if the new window is a
     * dialog of the window we were going to delete. If that's the case, we request
     * to select our window.
     */
static void
_gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                             gint object,
                                                                             MetaWindow* p0,
                                                                             gpointer self)
{
	gala_window_clone_check_confirm_dialog ((GalaWindowClone*) self, object, p0);
}

static void
gala_window_clone_close_window (GalaWindowClone* self,
                                guint32 timestamp)
{
	MetaDisplay* display = NULL;
	MetaWindow* _tmp0_;
	MetaDisplay* _tmp1_;
	gulong _tmp2_;
	MetaWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_display (_tmp0_);
	display = _tmp1_;
	_tmp2_ = g_signal_connect_object (display, "window-entered-monitor", (GCallback) _gala_window_clone_check_confirm_dialog_meta_display_window_entered_monitor, self, 0);
	self->priv->check_confirm_dialog_cb = _tmp2_;
	_tmp3_ = self->priv->_window;
	meta_window_delete (_tmp3_, timestamp);
}

static gboolean
___lambda19_ (GalaWindowClone* self)
{
	gboolean result;
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL], 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda19__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda19_ ((GalaWindowClone*) self);
	return result;
}

static void
gala_window_clone_check_confirm_dialog (GalaWindowClone* self,
                                        gint monitor,
                                        MetaWindow* new_window)
{
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_window != NULL);
	_tmp0_ = meta_window_get_transient_for (new_window);
	_tmp1_ = self->priv->_window;
	if (_tmp0_ == _tmp1_) {
		MetaWindow* _tmp2_;
		MetaDisplay* _tmp3_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda19__gsource_func, g_object_ref (self), g_object_unref);
		_tmp2_ = self->priv->_window;
		_tmp3_ = meta_window_get_display (_tmp2_);
		g_signal_handler_disconnect (_tmp3_, self->priv->check_confirm_dialog_cb);
		self->priv->check_confirm_dialog_cb = (gulong) 0;
	}
}

/**
     * The window unmanaged by the compositor, so we need to destroy ourselves too.
     */
static void
gala_window_clone_unmanaged (GalaWindowClone* self)
{
	gboolean _tmp0_ = FALSE;
	GalaDragDropAction* _tmp1_;
	ClutterClone* _tmp6_;
	g_return_if_fail (self != NULL);
	clutter_actor_remove_all_transitions ((ClutterActor*) self);
	_tmp1_ = self->priv->drag_action;
	if (_tmp1_ != NULL) {
		GalaDragDropAction* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->drag_action;
		_tmp3_ = gala_drag_drop_action_get_dragging (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GalaDragDropAction* _tmp5_;
		_tmp5_ = self->priv->drag_action;
		gala_drag_drop_action_cancel (_tmp5_);
	}
	_tmp6_ = self->priv->clone;
	if (_tmp6_ != NULL) {
		ClutterClone* _tmp7_;
		_tmp7_ = self->priv->clone;
		clutter_actor_destroy ((ClutterActor*) _tmp7_);
	}
	if (self->priv->check_confirm_dialog_cb != ((gulong) 0)) {
		MetaWindow* _tmp8_;
		MetaDisplay* _tmp9_;
		_tmp8_ = self->priv->_window;
		_tmp9_ = meta_window_get_display (_tmp8_);
		g_signal_handler_disconnect (_tmp9_, self->priv->check_confirm_dialog_cb);
		self->priv->check_confirm_dialog_cb = (gulong) 0;
	}
	clutter_actor_destroy ((ClutterActor*) self);
}

static void
gala_window_clone_actor_clicked (GalaWindowClone* self,
                                 guint32 button)
{
	g_return_if_fail (self != NULL);
	switch (button) {
		case CLUTTER_BUTTON_PRIMARY:
		{
			g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL], 0);
			break;
		}
		case CLUTTER_BUTTON_MIDDLE:
		{
			GalaWindowManager* _tmp0_;
			MetaDisplay* _tmp1_;
			_tmp0_ = self->priv->_wm;
			_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
			gala_window_clone_close_window (self, meta_display_get_current_time (_tmp1_));
			break;
		}
		default:
		break;
	}
}

/**
     * A drag action has been initiated on us, we reparent ourselves to the stage so
     * we can move freely, scale ourselves to a smaller scale and request that the
     * position we just freed is immediately filled by the WindowCloneContainer.
     */
static ClutterActor*
gala_window_clone_drag_begin (GalaWindowClone* self,
                              gfloat click_x,
                              gfloat click_y)
{
	gfloat abs_x = 0.0F;
	gfloat abs_y = 0.0F;
	gfloat prev_parent_x = 0.0F;
	gfloat prev_parent_y = 0.0F;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	ClutterActor* _tmp5_;
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	ClutterStage* stage = NULL;
	ClutterStage* _tmp8_;
	ClutterStage* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterStage* _tmp11_;
	GalaWindowCloneActiveShape* _tmp12_;
	gfloat scale = 0.0F;
	ClutterActor* _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	ClutterClone* _tmp16_;
	gfloat _tmp17_;
	gfloat _tmp18_;
	gint _tmp19_ = 0;
	GalaWindowManager* _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gint duration = 0;
	ClutterClone* _tmp23_;
	gfloat _tmp24_ = 0.0F;
	gfloat _tmp25_ = 0.0F;
	ClutterClone* _tmp26_;
	ClutterClone* _tmp27_;
	ClutterClone* _tmp28_;
	ClutterClone* _tmp29_;
	ClutterClone* _tmp30_;
	gfloat _tmp31_;
	gfloat _tmp32_;
	ClutterClone* _tmp33_;
	gfloat _tmp34_;
	gfloat _tmp35_;
	ClutterClone* _tmp36_;
	ClutterClone* _tmp37_;
	ClutterClone* _tmp38_;
	gfloat _tmp39_ = 0.0F;
	gfloat _tmp40_ = 0.0F;
	ClutterActor* _tmp41_;
	ClutterActor* _tmp42_;
	ClutterActor* _tmp43_;
	ClutterActor* _tmp44_;
	ClutterActor* _tmp45_;
	gfloat _tmp46_;
	gfloat _tmp47_;
	ClutterActor* _tmp48_;
	gfloat _tmp49_;
	gfloat _tmp50_;
	ClutterActor* _tmp51_;
	GalaCloseButton* _tmp52_;
	GalaTooltip* _tmp53_;
	GalaWindowManager* _tmp54_;
	MetaDisplay* _tmp55_;
	ClutterActor* _tmp56_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->prev_parent);
	self->priv->prev_parent = _tmp1_;
	_tmp2_ = self->priv->prev_parent;
	_tmp3_ = clutter_actor_get_children (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->prev_index = g_list_index (_tmp4_, (ClutterActor*) self);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (g_list_free (_tmp4_), NULL));
	_tmp5_ = self->priv->prev_parent;
	clutter_actor_get_transformed_position (_tmp5_, &_tmp6_, &_tmp7_);
	prev_parent_x = _tmp6_;
	prev_parent_y = _tmp7_;
	_tmp8_ = clutter_actor_get_stage ((ClutterActor*) self);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	stage = _tmp9_;
	_tmp10_ = self->priv->prev_parent;
	clutter_actor_remove_child (_tmp10_, (ClutterActor*) self);
	_tmp11_ = stage;
	clutter_actor_add_child ((ClutterActor*) _tmp11_, (ClutterActor*) self);
	_tmp12_ = self->priv->active_shape;
	clutter_actor_hide ((ClutterActor*) _tmp12_);
	_tmp13_ = self->priv->window_icon;
	_tmp14_ = clutter_actor_get_width (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->clone;
	_tmp17_ = clutter_actor_get_width ((ClutterActor*) _tmp16_);
	_tmp18_ = _tmp17_;
	scale = _tmp15_ / _tmp18_;
	_tmp20_ = self->priv->_wm;
	_tmp21_ = gala_window_manager_get_enable_animations (_tmp20_);
	_tmp22_ = _tmp21_;
	if (_tmp22_) {
		_tmp19_ = GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION;
	} else {
		_tmp19_ = 0;
	}
	duration = _tmp19_;
	_tmp23_ = self->priv->clone;
	clutter_actor_get_transformed_position ((ClutterActor*) _tmp23_, &_tmp24_, &_tmp25_);
	abs_x = _tmp24_;
	abs_y = _tmp25_;
	_tmp26_ = self->priv->clone;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp26_);
	_tmp27_ = self->priv->clone;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp27_, (guint) duration);
	_tmp28_ = self->priv->clone;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp28_, CLUTTER_EASE_IN_CUBIC);
	_tmp29_ = self->priv->clone;
	_tmp30_ = self->priv->clone;
	_tmp31_ = clutter_actor_get_width ((ClutterActor*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->clone;
	_tmp34_ = clutter_actor_get_height ((ClutterActor*) _tmp33_);
	_tmp35_ = _tmp34_;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp29_, (click_x - abs_x) / _tmp32_, (click_y - abs_y) / _tmp35_);
	_tmp36_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp36_, (gdouble) scale, (gdouble) scale);
	_tmp37_ = self->priv->clone;
	clutter_actor_set_opacity ((ClutterActor*) _tmp37_, (guint) 0);
	_tmp38_ = self->priv->clone;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp38_);
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
	clutter_actor_get_transformed_position ((ClutterActor*) self, &_tmp39_, &_tmp40_);
	abs_x = _tmp39_;
	abs_y = _tmp40_;
	clutter_actor_set_position ((ClutterActor*) self, abs_x + prev_parent_x, abs_y + prev_parent_y);
	_tmp41_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp41_);
	_tmp42_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp42_, (guint) duration);
	_tmp43_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp43_, CLUTTER_EASE_IN_OUT_CUBIC);
	_tmp44_ = self->priv->window_icon;
	_tmp45_ = self->priv->window_icon;
	_tmp46_ = clutter_actor_get_width (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = self->priv->window_icon;
	_tmp49_ = clutter_actor_get_height (_tmp48_);
	_tmp50_ = _tmp49_;
	clutter_actor_set_position (_tmp44_, (click_x - (abs_x + prev_parent_x)) - (_tmp47_ / 2), (click_y - (abs_y + prev_parent_y)) - (_tmp50_ / 2));
	_tmp51_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp51_);
	_tmp52_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp52_, (guint) 0);
	_tmp53_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp53_, (guint) 0);
	_tmp54_ = self->priv->_wm;
	_tmp55_ = meta_plugin_get_display ((MetaPlugin*) _tmp54_);
	meta_display_set_cursor (_tmp55_, META_CURSOR_DND_IN_DRAG);
	_tmp56_ = _g_object_ref0 ((ClutterActor*) self);
	result = _tmp56_;
	_g_object_unref0 (stage);
	return result;
}

/**
     * When we cross an IconGroup, we animate to an even smaller size and slightly
     * less opacity and add ourselves as temporary window to the group. When left,
     * we reverse those steps.
     */
static void
gala_window_clone_drag_destination_crossed (GalaWindowClone* self,
                                            ClutterActor* destination,
                                            gboolean hovered)
{
	GalaIconGroup* icon_group = NULL;
	GalaIconGroup* _tmp0_;
	GalaWorkspaceInsertThumb* insert_thumb = NULL;
	GalaWorkspaceInsertThumb* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GalaIconGroup* _tmp4_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GalaIconGroup* _tmp10_;
	gdouble _tmp17_ = 0.0;
	gdouble scale = 0.0;
	gint _tmp18_ = 0;
	gint opacity = 0;
	gint _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	gint duration = 0;
	gint _tmp25_ = 0;
	GalaWindowManager* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	ClutterActor* _tmp29_;
	ClutterActor* _tmp30_;
	ClutterActor* _tmp31_;
	ClutterActor* _tmp32_;
	ClutterActor* _tmp33_;
	ClutterActor* _tmp34_;
	GalaWorkspaceInsertThumb* _tmp35_;
	GalaIconGroup* _tmp38_;
	MetaCursor _tmp43_ = 0;
	GalaWindowManager* _tmp44_;
	MetaDisplay* _tmp45_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	_tmp0_ = _g_object_ref0 (GALA_IS_ICON_GROUP (destination) ? ((GalaIconGroup*) destination) : NULL);
	icon_group = _tmp0_;
	_tmp1_ = _g_object_ref0 (GALA_IS_WORKSPACE_INSERT_THUMB (destination) ? ((GalaWorkspaceInsertThumb*) destination) : NULL);
	insert_thumb = _tmp1_;
	_tmp4_ = icon_group;
	if (_tmp4_ == NULL) {
		GalaWorkspaceInsertThumb* _tmp5_;
		_tmp5_ = insert_thumb;
		_tmp3_ = _tmp5_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		GalaWorkspaceInsertThumb* _tmp7_;
		_tmp7_ = insert_thumb;
		if (_tmp7_ != NULL) {
			_tmp6_ = !meta_prefs_get_dynamic_workspaces ();
		} else {
			_tmp6_ = FALSE;
		}
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		_g_object_unref0 (insert_thumb);
		_g_object_unref0 (icon_group);
		return;
	}
	_tmp10_ = icon_group;
	if (_tmp10_ != NULL) {
		GalaIconGroup* _tmp11_;
		MetaWorkspace* _tmp12_;
		MetaWorkspace* _tmp13_;
		MetaWindow* _tmp14_;
		MetaWorkspace* _tmp15_;
		_tmp11_ = icon_group;
		_tmp12_ = gala_icon_group_get_workspace (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->_window;
		_tmp15_ = meta_window_get_workspace (_tmp14_);
		_tmp9_ = _tmp13_ == _tmp15_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		MetaWindow* _tmp16_;
		_tmp16_ = self->priv->_window;
		_tmp8_ = meta_window_is_on_primary_monitor (_tmp16_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_g_object_unref0 (insert_thumb);
		_g_object_unref0 (icon_group);
		return;
	}
	if (hovered) {
		_tmp17_ = 0.4;
	} else {
		_tmp17_ = 1.0;
	}
	scale = _tmp17_;
	if (hovered) {
		_tmp18_ = 0;
	} else {
		_tmp18_ = 255;
	}
	opacity = _tmp18_;
	if (hovered) {
		GalaWorkspaceInsertThumb* _tmp21_;
		_tmp21_ = insert_thumb;
		_tmp20_ = _tmp21_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		GalaWorkspaceInsertThumb* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp22_ = insert_thumb;
		_tmp23_ = gala_workspace_insert_thumb_get_delay (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp19_ = _tmp24_;
	} else {
		_tmp19_ = 100;
	}
	duration = _tmp19_;
	_tmp26_ = self->priv->_wm;
	_tmp27_ = gala_window_manager_get_enable_animations (_tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_) {
		_tmp25_ = duration;
	} else {
		_tmp25_ = 0;
	}
	duration = _tmp25_;
	_tmp29_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp29_);
	_tmp30_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp30_, CLUTTER_LINEAR);
	_tmp31_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp31_, (guint) duration);
	_tmp32_ = self->priv->window_icon;
	clutter_actor_set_scale (_tmp32_, scale, scale);
	_tmp33_ = self->priv->window_icon;
	clutter_actor_set_opacity (_tmp33_, (guint8) opacity);
	_tmp34_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp34_);
	_tmp35_ = insert_thumb;
	if (_tmp35_ != NULL) {
		GalaWorkspaceInsertThumb* _tmp36_;
		MetaWindow* _tmp37_;
		_tmp36_ = insert_thumb;
		_tmp37_ = self->priv->_window;
		gala_workspace_insert_thumb_set_window_thumb (_tmp36_, _tmp37_);
	}
	_tmp38_ = icon_group;
	if (_tmp38_ != NULL) {
		if (hovered) {
			GalaIconGroup* _tmp39_;
			MetaWindow* _tmp40_;
			_tmp39_ = icon_group;
			_tmp40_ = self->priv->_window;
			gala_icon_group_add_window (_tmp39_, _tmp40_, FALSE, TRUE);
		} else {
			GalaIconGroup* _tmp41_;
			MetaWindow* _tmp42_;
			_tmp41_ = icon_group;
			_tmp42_ = self->priv->_window;
			gala_icon_group_remove_window (_tmp41_, _tmp42_, FALSE);
		}
	}
	if (hovered) {
		_tmp43_ = META_CURSOR_DND_MOVE;
	} else {
		_tmp43_ = META_CURSOR_DND_IN_DRAG;
	}
	_tmp44_ = self->priv->_wm;
	_tmp45_ = meta_plugin_get_display ((MetaPlugin*) _tmp44_);
	meta_display_set_cursor (_tmp45_, _tmp43_);
	_g_object_unref0 (insert_thumb);
	_g_object_unref0 (icon_group);
}

/**
     * Depending on the destination we have different ways to find the correct destination.
     * After we found one we destroy ourselves so the dragged clone immediately disappears,
     * otherwise we cancel the drag and animate back to our old place.
     */
static void
gala_window_clone_drag_end (GalaWindowClone* self,
                            ClutterActor* destination)
{
	MetaWorkspace* workspace = NULL;
	gint primary = 0;
	MetaWindow* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaWindowCloneActiveShape* _tmp2_;
	GalaWindowManager* _tmp3_;
	MetaDisplay* _tmp4_;
	gboolean did_move = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp31_ = FALSE;
	MetaWorkspace* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	workspace = NULL;
	_tmp0_ = self->priv->_window;
	_tmp1_ = meta_window_get_display (_tmp0_);
	primary = meta_display_get_primary_monitor (_tmp1_);
	_tmp2_ = self->priv->active_shape;
	clutter_actor_show ((ClutterActor*) _tmp2_);
	_tmp3_ = self->priv->_wm;
	_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
	meta_display_set_cursor (_tmp4_, META_CURSOR_DEFAULT);
	if (GALA_IS_ICON_GROUP (destination)) {
		MetaWorkspace* _tmp5_;
		MetaWorkspace* _tmp6_;
		MetaWorkspace* _tmp7_;
		_tmp5_ = gala_icon_group_get_workspace (G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_ICON_GROUP, GalaIconGroup));
		_tmp6_ = _tmp5_;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (workspace);
		workspace = _tmp7_;
	} else {
		if (GALA_IS_FRAMED_BACKGROUND (destination)) {
			ClutterActor* _tmp8_;
			MetaWorkspace* _tmp9_;
			MetaWorkspace* _tmp10_;
			MetaWorkspace* _tmp11_;
			_tmp8_ = clutter_actor_get_parent (destination);
			_tmp9_ = gala_workspace_clone_get_workspace (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone));
			_tmp10_ = _tmp9_;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (workspace);
			workspace = _tmp11_;
		} else {
			if (GALA_IS_WORKSPACE_INSERT_THUMB (destination)) {
				GalaWorkspaceInsertThumb* inserter = NULL;
				gboolean will_move = FALSE;
				MetaWindow* _tmp12_;
				MetaWorkspace* _tmp13_;
				GalaWorkspaceInsertThumb* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gboolean _tmp17_ = FALSE;
				GalaWorkspaceInsertThumb* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				MetaWindow* _tmp23_;
				if (!meta_prefs_get_dynamic_workspaces ()) {
					gala_window_clone_drag_canceled (self);
					_g_object_unref0 (workspace);
					return;
				}
				inserter = G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb);
				_tmp12_ = self->priv->_window;
				_tmp13_ = meta_window_get_workspace (_tmp12_);
				_tmp14_ = inserter;
				_tmp15_ = gala_workspace_insert_thumb_get_workspace_index (_tmp14_);
				_tmp16_ = _tmp15_;
				will_move = meta_workspace_index (_tmp13_) != _tmp16_;
				if (meta_prefs_get_workspaces_only_on_primary ()) {
					MetaWindow* _tmp18_;
					_tmp18_ = self->priv->_window;
					_tmp17_ = !meta_window_is_on_primary_monitor (_tmp18_);
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					MetaWindow* _tmp19_;
					_tmp19_ = self->priv->_window;
					meta_window_move_to_monitor (_tmp19_, primary);
					will_move = TRUE;
				}
				_tmp20_ = inserter;
				_tmp21_ = gala_workspace_insert_thumb_get_workspace_index (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = self->priv->_window;
				gala_internal_utils_insert_workspace_with_window (_tmp22_, _tmp23_);
				if (will_move) {
					gala_window_clone_unmanaged (self);
				} else {
					gala_window_clone_drag_canceled (self);
				}
				_g_object_unref0 (workspace);
				return;
			} else {
				if (GALA_IS_MONITOR_CLONE (destination)) {
					gint monitor = 0;
					gint _tmp24_;
					gint _tmp25_;
					MetaWindow* _tmp26_;
					_tmp24_ = gala_monitor_clone_get_monitor (G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone));
					_tmp25_ = _tmp24_;
					monitor = _tmp25_;
					_tmp26_ = self->priv->_window;
					if (meta_window_get_monitor (_tmp26_) != monitor) {
						MetaWindow* _tmp27_;
						_tmp27_ = self->priv->_window;
						meta_window_move_to_monitor (_tmp27_, monitor);
						gala_window_clone_unmanaged (self);
					} else {
						gala_window_clone_drag_canceled (self);
					}
					_g_object_unref0 (workspace);
					return;
				}
			}
		}
	}
	did_move = FALSE;
	if (meta_prefs_get_workspaces_only_on_primary ()) {
		MetaWindow* _tmp29_;
		_tmp29_ = self->priv->_window;
		_tmp28_ = !meta_window_is_on_primary_monitor (_tmp29_);
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		MetaWindow* _tmp30_;
		_tmp30_ = self->priv->_window;
		meta_window_move_to_monitor (_tmp30_, primary);
		did_move = TRUE;
	}
	_tmp32_ = workspace;
	if (_tmp32_ != NULL) {
		MetaWorkspace* _tmp33_;
		MetaWindow* _tmp34_;
		MetaWorkspace* _tmp35_;
		_tmp33_ = workspace;
		_tmp34_ = self->priv->_window;
		_tmp35_ = meta_window_get_workspace (_tmp34_);
		_tmp31_ = _tmp33_ != _tmp35_;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		MetaWindow* _tmp36_;
		MetaWorkspace* _tmp37_;
		_tmp36_ = self->priv->_window;
		_tmp37_ = workspace;
		meta_window_change_workspace (_tmp36_, _tmp37_);
		did_move = TRUE;
	}
	if (did_move) {
		gala_window_clone_unmanaged (self);
	} else {
		gala_window_clone_drag_canceled (self);
	}
	_g_object_unref0 (workspace);
}

/**
     * Animate back to our previous position with a bouncing animation.
     */
static void
gala_window_clone_drag_canceled (GalaWindowClone* self)
{
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	gint _tmp2_ = 0;
	GalaWindowManager* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint duration = 0;
	ClutterClone* _tmp6_;
	ClutterClone* _tmp7_;
	ClutterClone* _tmp8_;
	ClutterClone* _tmp9_;
	ClutterClone* _tmp10_;
	ClutterClone* _tmp11_;
	ClutterClone* _tmp12_;
	ClutterActor* _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	MtkRectangle* _tmp16_;
	MtkRectangle* _tmp17_;
	gfloat _tmp18_;
	gfloat _tmp19_;
	ClutterActor* _tmp20_;
	GalaWindowManager* _tmp21_;
	MetaDisplay* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
	clutter_actor_remove_child (_tmp0_, (ClutterActor*) self);
	_tmp1_ = self->priv->prev_parent;
	clutter_actor_insert_child_at_index (_tmp1_, (ClutterActor*) self, self->priv->prev_index);
	_tmp3_ = self->priv->_wm;
	_tmp4_ = gala_window_manager_get_enable_animations (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp2_ = 0;
	}
	duration = _tmp2_;
	_tmp6_ = self->priv->clone;
	clutter_actor_set_pivot_point ((ClutterActor*) _tmp6_, 0.0f, 0.0f);
	_tmp7_ = self->priv->clone;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp7_);
	_tmp8_ = self->priv->clone;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp8_, (guint) duration);
	_tmp9_ = self->priv->clone;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp9_, CLUTTER_EASE_OUT_QUAD);
	_tmp10_ = self->priv->clone;
	clutter_actor_set_scale ((ClutterActor*) _tmp10_, (gdouble) 1, (gdouble) 1);
	_tmp11_ = self->priv->clone;
	clutter_actor_set_opacity ((ClutterActor*) _tmp11_, (guint) 255);
	_tmp12_ = self->priv->clone;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp12_);
	g_signal_emit (self, gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL], 0);
	_tmp13_ = self->priv->window_icon;
	clutter_actor_save_easing_state (_tmp13_);
	_tmp14_ = self->priv->window_icon;
	clutter_actor_set_easing_duration (_tmp14_, (guint) duration);
	_tmp15_ = self->priv->window_icon;
	clutter_actor_set_easing_mode (_tmp15_, CLUTTER_EASE_OUT_QUAD);
	_tmp16_ = self->priv->_slot;
	_tmp17_ = self->priv->_slot;
	_tmp18_ = gala_window_clone_get_monitor_scale_factor (self);
	_tmp19_ = _tmp18_;
	gala_window_clone_set_window_icon_position (self, (gfloat) (*_tmp16_).width, (gfloat) (*_tmp17_).height, _tmp19_, TRUE);
	_tmp20_ = self->priv->window_icon;
	clutter_actor_restore_easing_state (_tmp20_);
	_tmp21_ = self->priv->_wm;
	_tmp22_ = meta_plugin_get_display ((MetaPlugin*) _tmp21_);
	meta_display_set_cursor (_tmp22_, META_CURSOR_DEFAULT);
}

static void
gala_window_clone_set_window_icon_position (GalaWindowClone* self,
                                            gfloat window_width,
                                            gfloat window_height,
                                            gfloat scale_factor,
                                            gboolean aligned)
{
	gint size = 0;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	ClutterActor* _tmp0_;
	ClutterActor* _tmp1_;
	g_return_if_fail (self != NULL);
	size = gala_internal_utils_scale_to_int (GALA_WINDOW_CLONE_WINDOW_ICON_SIZE, scale_factor);
	x = (window_width - size) / 2;
	y = window_height - (size * 0.75f);
	if (aligned) {
		x = (gfloat) ((gint) round ((gdouble) x));
		y = (gfloat) ((gint) round ((gdouble) y));
	}
	_tmp0_ = self->priv->window_icon;
	clutter_actor_set_size (_tmp0_, (gfloat) size, (gfloat) size);
	_tmp1_ = self->priv->window_icon;
	clutter_actor_set_position (_tmp1_, x, y);
}

static void
gala_window_clone_set_window_title_position (GalaWindowClone* self,
                                             gfloat window_width,
                                             gfloat window_height,
                                             gfloat scale_factor)
{
	gint x = 0;
	GalaTooltip* _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gint y = 0;
	GalaTooltip* _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	GalaTooltip* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_title;
	_tmp1_ = clutter_actor_get_width ((ClutterActor*) _tmp0_);
	_tmp2_ = _tmp1_;
	x = (gint) round ((gdouble) ((window_width - _tmp2_) / 2));
	_tmp3_ = self->priv->window_title;
	_tmp4_ = clutter_actor_get_height ((ClutterActor*) _tmp3_);
	_tmp5_ = _tmp4_;
	y = (gint) round ((gdouble) (((window_height - (gala_internal_utils_scale_to_int (GALA_WINDOW_CLONE_WINDOW_ICON_SIZE, scale_factor) * 0.75f)) - (_tmp5_ / 2)) - gala_internal_utils_scale_to_int (18, scale_factor)));
	_tmp6_ = self->priv->window_title;
	clutter_actor_set_position ((ClutterActor*) _tmp6_, (gfloat) x, (gfloat) y);
}

static gboolean
gala_window_clone_is_close_button_on_left (void)
{
	MetaButtonLayout layout = {0};
	MetaButtonLayout _tmp0_ = {0};
	MetaButtonLayout _tmp1_;
	gboolean result;
	meta_prefs_get_button_layout (&_tmp0_);
	layout = _tmp0_;
	_tmp1_ = layout;
	{
		MetaButtonFunction* button_function_collection = NULL;
		gint button_function_collection_length1 = 0;
		gint _button_function_collection_size_ = 0;
		gint button_function_it = 0;
		button_function_collection = _tmp1_.left_buttons;
		button_function_collection_length1 = 4;
		for (button_function_it = 0; button_function_it < button_function_collection_length1; button_function_it = button_function_it + 1) {
			MetaButtonFunction button_function = 0;
			button_function = button_function_collection[button_function_it];
			{
				if (button_function == META_BUTTON_FUNCTION_CLOSE) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

GalaWindowManager*
gala_window_clone_get_wm (GalaWindowClone* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_set_wm (GalaWindowClone* self,
                          GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_WM_PROPERTY]);
	}
}

MetaWindow*
gala_window_clone_get_window (GalaWindowClone* self)
{
	MetaWindow* result;
	MetaWindow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_set_window (GalaWindowClone* self,
                              MetaWindow* value)
{
	MetaWindow* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_window (self);
	if (old_value != value) {
		MetaWindow* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window);
		self->priv->_window = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_WINDOW_PROPERTY]);
	}
}

MtkRectangle*
gala_window_clone_get_slot (GalaWindowClone* self)
{
	MtkRectangle* result;
	MtkRectangle* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_slot;
	result = _tmp0_;
	return result;
}

static gboolean
_mtk_rectangle_equal (const MtkRectangle * s1,
                      const MtkRectangle * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static MtkRectangle*
_vala_MtkRectangle_copy (MtkRectangle* self)
{
	return g_boxed_copy (mtk_rectangle_get_type (), self);
}

static gpointer
__vala_MtkRectangle_copy0 (gpointer self)
{
	return self ? _vala_MtkRectangle_copy (self) : NULL;
}

static void
gala_window_clone_set_slot (GalaWindowClone* self,
                            MtkRectangle* value)
{
	MtkRectangle* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_slot (self);
	if (_mtk_rectangle_equal (value, old_value) != TRUE) {
		MtkRectangle* _tmp0_;
		_tmp0_ = __vala_MtkRectangle_copy0 (value);
		__vala_MtkRectangle_free0 (self->priv->_slot);
		self->priv->_slot = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_SLOT_PROPERTY]);
	}
}

void
gala_window_clone_set_active (GalaWindowClone* self,
                              gboolean value)
{
	GalaWindowCloneActiveShape* _tmp0_;
	gint _tmp1_ = 0;
	GalaWindowManager* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GalaWindowCloneActiveShape* _tmp5_;
	gint _tmp6_ = 0;
	GalaWindowCloneActiveShape* _tmp7_;
	GalaWindowCloneActiveShape* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->active_shape;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp2_ = self->priv->_wm;
	_tmp3_ = gala_window_manager_get_enable_animations (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = GALA_WINDOW_CLONE_FADE_ANIMATION_DURATION;
	} else {
		_tmp1_ = 0;
	}
	_tmp5_ = self->priv->active_shape;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp5_, (guint) _tmp1_);
	if (value) {
		_tmp6_ = 255;
	} else {
		_tmp6_ = 0;
	}
	_tmp7_ = self->priv->active_shape;
	clutter_actor_set_opacity ((ClutterActor*) _tmp7_, (guint) _tmp6_);
	_tmp8_ = self->priv->active_shape;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp8_);
	g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_ACTIVE_PROPERTY]);
}

gboolean
gala_window_clone_get_overview_mode (GalaWindowClone* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overview_mode;
	return result;
}

static void
gala_window_clone_set_overview_mode (GalaWindowClone* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_overview_mode (self);
	if (old_value != value) {
		self->priv->_overview_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY]);
	}
}

GalaGestureTracker*
gala_window_clone_get_gesture_tracker (GalaWindowClone* self)
{
	GalaGestureTracker* result;
	GalaGestureTracker* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gesture_tracker;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_set_gesture_tracker (GalaWindowClone* self,
                                       GalaGestureTracker* value)
{
	GalaGestureTracker* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_get_gesture_tracker (self);
	if (old_value != value) {
		GalaGestureTracker* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gesture_tracker);
		self->priv->_gesture_tracker = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY]);
	}
}

gfloat
gala_window_clone_get_monitor_scale_factor (GalaWindowClone* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale_factor;
	return result;
}

void
gala_window_clone_set_monitor_scale_factor (GalaWindowClone* self,
                                            gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_monitor_scale_factor) {
		self->priv->_monitor_scale_factor = value;
		gala_window_clone_reallocate (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_window_clone_properties[GALA_WINDOW_CLONE_MONITOR_SCALE_FACTOR_PROPERTY]);
}

guint8
gala_window_clone_get_shadow_opacity (GalaWindowClone* self)
{
	guint8 result;
	guint8 _tmp0_ = 0U;
	GalaShadowEffect* _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = self->priv->shadow_effect;
	if (_tmp1_ != NULL) {
		GalaShadowEffect* _tmp2_;
		guint8 _tmp3_;
		guint8 _tmp4_;
		_tmp2_ = self->priv->shadow_effect;
		_tmp3_ = gala_shadow_effect_get_shadow_opacity (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = (guint8) 255;
	}
	result = _tmp0_;
	return result;
}

void
gala_window_clone_set_shadow_opacity (GalaWindowClone* self,
                                      guint8 value)
{
	GalaShadowEffect* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->shadow_effect;
	if (_tmp0_ != NULL) {
		GalaShadowEffect* _tmp1_;
		_tmp1_ = self->priv->shadow_effect;
		gala_shadow_effect_set_shadow_opacity (_tmp1_, value);
		clutter_actor_queue_redraw ((ClutterActor*) self);
	}
}

static void
gala_window_clone_active_shape_invalidate (GalaWindowCloneActiveShape* self)
{
	ClutterContent* _tmp0_;
	ClutterContent* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	clutter_content_invalidate (_tmp1_);
}

static void
gala_window_clone_active_shape_real_draw (GalaCanvasActor* base,
                                          cairo_t* cr,
                                          gint width,
                                          gint height)
{
	GalaWindowCloneActiveShape * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GdkRGBA color = {0};
	GdkRGBA _tmp5_ = {0};
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	self = (GalaWindowCloneActiveShape*) base;
	g_return_if_fail (cr != NULL);
	g_object_get ((ClutterActor*) self, "visible", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp3_;
		guint _tmp4_;
		_tmp3_ = clutter_actor_get_opacity ((ClutterActor*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == ((guint) 0);
	}
	if (_tmp0_) {
		return;
	}
	gala_internal_utils_get_theme_accent_color (&_tmp5_);
	color = _tmp5_;
	cairo_save (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_restore (cr);
	gala_drawing_utilities_cairo_rounded_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height, (gdouble) GALA_WINDOW_CLONE_ACTIVE_SHAPE_BORDER_RADIUS);
	_tmp6_ = color;
	_tmp7_ = color;
	_tmp8_ = color;
	cairo_set_source_rgba (cr, _tmp6_.red, _tmp7_.green, _tmp8_.blue, GALA_WINDOW_CLONE_ACTIVE_SHAPE_COLOR_OPACITY);
	cairo_fill (cr);
}

static GalaWindowCloneActiveShape*
gala_window_clone_active_shape_construct (GType object_type)
{
	GalaWindowCloneActiveShape * self = NULL;
	self = (GalaWindowCloneActiveShape*) gala_canvas_actor_construct (object_type);
	return self;
}

static GalaWindowCloneActiveShape*
gala_window_clone_active_shape_new (void)
{
	return gala_window_clone_active_shape_construct (GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE);
}

static void
_gala_window_clone_active_shape_invalidate_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self)
{
	gala_window_clone_active_shape_invalidate ((GalaWindowCloneActiveShape*) self);
}

static GObject *
gala_window_clone_active_shape_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowCloneActiveShape * self;
	parent_class = G_OBJECT_CLASS (gala_window_clone_active_shape_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_WINDOW_CLONE_TYPE_ACTIVE_SHAPE, GalaWindowCloneActiveShape);
	g_signal_connect_object ((GObject*) self, "notify::opacity", (GCallback) _gala_window_clone_active_shape_invalidate_g_object_notify, self, 0);
	return obj;
}

static void
gala_window_clone_active_shape_class_init (GalaWindowCloneActiveShapeClass * klass,
                                           gpointer klass_data)
{
	gala_window_clone_active_shape_parent_class = g_type_class_peek_parent (klass);
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_window_clone_active_shape_real_draw;
	G_OBJECT_CLASS (klass)->constructor = gala_window_clone_active_shape_constructor;
}

static void
gala_window_clone_active_shape_instance_init (GalaWindowCloneActiveShape * self,
                                              gpointer klass)
{
}

/**
     * Border to show around the selected window when using keyboard navigation.
     */
static GType
gala_window_clone_active_shape_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneActiveShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_active_shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowCloneActiveShape), 0, (GInstanceInitFunc) gala_window_clone_active_shape_instance_init, NULL };
	GType gala_window_clone_active_shape_type_id;
	gala_window_clone_active_shape_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaWindowCloneActiveShape", &g_define_type_info, 0);
	return gala_window_clone_active_shape_type_id;
}

static GType
gala_window_clone_active_shape_get_type (void)
{
	static volatile gsize gala_window_clone_active_shape_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_active_shape_type_id__once)) {
		GType gala_window_clone_active_shape_type_id;
		gala_window_clone_active_shape_type_id = gala_window_clone_active_shape_get_type_once ();
		g_once_init_leave (&gala_window_clone_active_shape_type_id__once, gala_window_clone_active_shape_type_id);
	}
	return gala_window_clone_active_shape_type_id__once;
}

static Block69Data*
block69_data_ref (Block69Data* _data69_)
{
	g_atomic_int_inc (&_data69_->_ref_count_);
	return _data69_;
}

static void
block69_data_unref (void * _userdata_)
{
	Block69Data* _data69_;
	_data69_ = (Block69Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data69_->_ref_count_)) {
		GalaWindowClone* self;
		self = _data69_->self;
		_g_object_unref0 (_data69_->click_action);
		_g_object_unref0 (self);
		g_slice_free (Block69Data, _data69_);
	}
}

static void
_gala_window_clone____lambda79_ (Block69Data* _data69_)
{
	GalaWindowClone* self;
	ClutterClickAction* _tmp0_;
	self = _data69_->self;
	_tmp0_ = _data69_->click_action;
	gala_window_clone_actor_clicked (self, (guint32) clutter_click_action_get_button (_tmp0_));
}

static void
__gala_window_clone____lambda79__clutter_click_action_clicked (ClutterClickAction* _sender,
                                                               ClutterActor* actor,
                                                               gpointer self)
{
	_gala_window_clone____lambda79_ (self);
}

static ClutterActor*
_gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                gfloat x,
                                                                gfloat y,
                                                                gpointer self)
{
	ClutterActor* result;
	result = gala_window_clone_drag_begin ((GalaWindowClone*) self, x, y);
	return result;
}

static void
_gala_window_clone_drag_destination_crossed_gala_drag_drop_action_destination_crossed (GalaDragDropAction* _sender,
                                                                                       ClutterActor* destination,
                                                                                       gboolean hovered,
                                                                                       gpointer self)
{
	gala_window_clone_drag_destination_crossed ((GalaWindowClone*) self, destination, hovered);
}

static void
_gala_window_clone_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                            ClutterActor* actor,
                                                            gpointer self)
{
	gala_window_clone_drag_end ((GalaWindowClone*) self, actor);
}

static void
_gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                      gpointer self)
{
	gala_window_clone_drag_canceled ((GalaWindowClone*) self);
}

static void
_gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                      guint32 button,
                                                                      gpointer self)
{
	gala_window_clone_actor_clicked ((GalaWindowClone*) self, button);
}

static GObject *
gala_window_clone_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowClone * self;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	MetaWindow* _tmp3_;
	MetaWindow* _tmp4_;
	gboolean _tmp5_;
	GalaTooltip* _tmp16_;
	GalaTooltip* _tmp17_;
	GalaWindowCloneActiveShape* _tmp18_;
	GalaWindowCloneActiveShape* _tmp19_;
	GalaWindowCloneActiveShape* _tmp20_;
	GalaTooltip* _tmp21_;
	parent_class = G_OBJECT_CLASS (gala_window_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = self->priv->_window;
	g_signal_connect_object (_tmp0_, "unmanaged", (GCallback) _gala_window_clone_unmanaged_meta_window_unmanaged, self, 0);
	_tmp1_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::on-all-workspaces", (GCallback) _gala_window_clone_on_all_workspaces_changed_g_object_notify, self, 0);
	_tmp2_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::fullscreen", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp3_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::maximized-horizontally", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp4_ = self->priv->_window;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::maximized-vertically", (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self, 0);
	_tmp5_ = self->priv->_overview_mode;
	if (_tmp5_) {
		Block69Data* _data69_;
		ClutterClickAction* _tmp6_;
		ClutterClickAction* _tmp7_;
		ClutterClickAction* _tmp8_;
		_data69_ = g_slice_new0 (Block69Data);
		_data69_->_ref_count_ = 1;
		_data69_->self = g_object_ref (self);
		_tmp6_ = (ClutterClickAction*) clutter_click_action_new ();
		g_object_ref_sink (_tmp6_);
		_data69_->click_action = _tmp6_;
		_tmp7_ = _data69_->click_action;
		g_signal_connect_data (_tmp7_, "clicked", (GCallback) __gala_window_clone____lambda79__clutter_click_action_clicked, block69_data_ref (_data69_), (GClosureNotify) block69_data_unref, 0);
		_tmp8_ = _data69_->click_action;
		clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp8_);
		block69_data_unref (_data69_);
		_data69_ = NULL;
	} else {
		GalaDragDropAction* _tmp9_;
		GalaDragDropAction* _tmp10_;
		GalaDragDropAction* _tmp11_;
		GalaDragDropAction* _tmp12_;
		GalaDragDropAction* _tmp13_;
		GalaDragDropAction* _tmp14_;
		GalaDragDropAction* _tmp15_;
		_tmp9_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE, "multitaskingview-window");
		g_object_ref_sink (_tmp9_);
		_g_object_unref0 (self->priv->drag_action);
		self->priv->drag_action = _tmp9_;
		_tmp10_ = self->priv->drag_action;
		g_signal_connect_object (_tmp10_, "drag-begin", (GCallback) _gala_window_clone_drag_begin_gala_drag_drop_action_drag_begin, self, 0);
		_tmp11_ = self->priv->drag_action;
		g_signal_connect_object (_tmp11_, "destination-crossed", (GCallback) _gala_window_clone_drag_destination_crossed_gala_drag_drop_action_destination_crossed, self, 0);
		_tmp12_ = self->priv->drag_action;
		g_signal_connect_object (_tmp12_, "drag-end", (GCallback) _gala_window_clone_drag_end_gala_drag_drop_action_drag_end, self, 0);
		_tmp13_ = self->priv->drag_action;
		g_signal_connect_object (_tmp13_, "drag-canceled", (GCallback) _gala_window_clone_drag_canceled_gala_drag_drop_action_drag_canceled, self, 0);
		_tmp14_ = self->priv->drag_action;
		g_signal_connect_object (_tmp14_, "actor-clicked", (GCallback) _gala_window_clone_actor_clicked_gala_drag_drop_action_actor_clicked, self, 0);
		_tmp15_ = self->priv->drag_action;
		clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp15_);
	}
	_tmp16_ = gala_tooltip_new ();
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->window_title);
	self->priv->window_title = _tmp16_;
	_tmp17_ = self->priv->window_title;
	clutter_actor_set_opacity ((ClutterActor*) _tmp17_, (guint) 0);
	_tmp18_ = gala_window_clone_active_shape_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->active_shape);
	self->priv->active_shape = _tmp18_;
	_tmp19_ = self->priv->active_shape;
	clutter_actor_set_opacity ((ClutterActor*) _tmp19_, (guint) 0);
	_tmp20_ = self->priv->active_shape;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp20_);
	_tmp21_ = self->priv->window_title;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp21_);
	gala_window_clone_reallocate (self);
	gala_window_clone_load_clone (self, FALSE);
	return obj;
}

static void
gala_window_clone_class_init (GalaWindowCloneClass * klass,
                              gpointer klass_data)
{
	gala_window_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowClone_private_offset);
	((ClutterActorClass *) klass)->allocate = (void (*) (ClutterActor*, ClutterActorBox*)) gala_window_clone_real_allocate;
	((ClutterActorClass *) klass)->button_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_clone_real_button_press_event;
	((ClutterActorClass *) klass)->enter_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_clone_real_enter_event;
	((ClutterActorClass *) klass)->leave_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_clone_real_leave_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_WM_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_WINDOW_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_WINDOW_PROPERTY] = g_param_spec_object ("window", "window", "window", meta_window_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * The currently assigned slot of the window in the tiling layout. May be null.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_SLOT_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_SLOT_PROPERTY] = g_param_spec_boxed ("slot", "slot", "slot", mtk_rectangle_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	     * When active fades a white border around the window in. Used for the visually
	     * indicating the WindowCloneContainer's current_window.
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_ACTIVE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_ACTIVE_PROPERTY] = g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY] = g_param_spec_boolean ("overview-mode", "overview-mode", "overview-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY] = g_param_spec_object ("gesture-tracker", "gesture-tracker", "gesture-tracker", GALA_TYPE_GESTURE_TRACKER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_MONITOR_SCALE_FACTOR_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_MONITOR_SCALE_FACTOR_PROPERTY] = g_param_spec_float ("monitor-scale-factor", "monitor-scale-factor", "monitor-scale-factor", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY, gala_window_clone_properties[GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY] = g_param_spec_uchar ("shadow-opacity", "shadow-opacity", "shadow-opacity", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	/**
	     * The window was selected. The MultitaskingView should consider activating
	     * the window and closing the view.
	     */
	gala_window_clone_signals[GALA_WINDOW_CLONE_SELECTED_SIGNAL] = g_signal_new ("selected", GALA_TYPE_WINDOW_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	     * The window was moved or resized and a relayout of the tiling layout may
	     * be sensible right now.
	     */
	gala_window_clone_signals[GALA_WINDOW_CLONE_REQUEST_REPOSITION_SIGNAL] = g_signal_new ("request-reposition", GALA_TYPE_WINDOW_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_window_clone_instance_init (GalaWindowClone * self,
                                 gpointer klass)
{
	self->priv = gala_window_clone_get_instance_private (self);
	self->priv->_slot = NULL;
	self->priv->_monitor_scale_factor = 1.0f;
	self->priv->drag_action = NULL;
	self->priv->clone = NULL;
	self->priv->shadow_effect = NULL;
	self->priv->prev_parent = NULL;
	self->priv->prev_index = -1;
	self->priv->check_confirm_dialog_cb = (gulong) 0;
	self->priv->in_slot_animation = FALSE;
}

static void
gala_window_clone_finalize (GObject * obj)
{
	GalaWindowClone * self;
	MetaWindow* _tmp0_;
	guint _tmp1_;
	MetaWindow* _tmp2_;
	guint _tmp3_;
	GQuark _tmp4_;
	MetaWindow* _tmp5_;
	guint _tmp6_;
	GQuark _tmp7_;
	MetaWindow* _tmp8_;
	guint _tmp9_;
	GQuark _tmp10_;
	MetaWindow* _tmp11_;
	guint _tmp12_;
	GQuark _tmp13_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	_tmp0_ = self->priv->_window;
	g_signal_parse_name ("unmanaged", meta_window_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_window_clone_unmanaged_meta_window_unmanaged, self);
	_tmp2_ = self->priv->_window;
	g_signal_parse_name ("notify::on-all-workspaces", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _gala_window_clone_on_all_workspaces_changed_g_object_notify, self);
	_tmp5_ = self->priv->_window;
	g_signal_parse_name ("notify::fullscreen", G_TYPE_OBJECT, &_tmp6_, &_tmp7_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, _tmp7_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_tmp8_ = self->priv->_window;
	g_signal_parse_name ("notify::maximized-horizontally", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_tmp11_ = self->priv->_window;
	g_signal_parse_name ("notify::maximized-vertically", G_TYPE_OBJECT, &_tmp12_, &_tmp13_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, _tmp13_, NULL, (GCallback) _gala_window_clone_check_shadow_requirements_g_object_notify, self);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_window);
	__vala_MtkRectangle_free0 (self->priv->_slot);
	_g_object_unref0 (self->priv->_gesture_tracker);
	_g_object_unref0 (self->priv->drag_action);
	_g_object_unref0 (self->priv->clone);
	_g_object_unref0 (self->priv->shadow_effect);
	_g_object_unref0 (self->priv->prev_parent);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->active_shape);
	_g_object_unref0 (self->priv->window_icon);
	_g_object_unref0 (self->priv->window_title);
	G_OBJECT_CLASS (gala_window_clone_parent_class)->finalize (obj);
}

/**
 * A container for a clone of the texture of a MetaWindow, a WindowIcon, a Tooltip with the title,
 * a close button and a shadow. Used together with the WindowCloneContainer.
 */
static GType
gala_window_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowClone), 0, (GInstanceInitFunc) gala_window_clone_instance_init, NULL };
	GType gala_window_clone_type_id;
	gala_window_clone_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWindowClone", &g_define_type_info, 0);
	GalaWindowClone_private_offset = g_type_add_instance_private (gala_window_clone_type_id, sizeof (GalaWindowClonePrivate));
	return gala_window_clone_type_id;
}

GType
gala_window_clone_get_type (void)
{
	static volatile gsize gala_window_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_type_id__once)) {
		GType gala_window_clone_type_id;
		gala_window_clone_type_id = gala_window_clone_get_type_once ();
		g_once_init_leave (&gala_window_clone_type_id__once, gala_window_clone_type_id);
	}
	return gala_window_clone_type_id__once;
}

static void
_vala_gala_window_clone_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	GalaWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	switch (property_id) {
		case GALA_WINDOW_CLONE_WM_PROPERTY:
		g_value_set_object (value, gala_window_clone_get_wm (self));
		break;
		case GALA_WINDOW_CLONE_WINDOW_PROPERTY:
		g_value_set_object (value, gala_window_clone_get_window (self));
		break;
		case GALA_WINDOW_CLONE_SLOT_PROPERTY:
		{
			MtkRectangle* boxed;
			boxed = gala_window_clone_get_slot (self);
			g_value_set_boxed (value, boxed);
		}
		break;
		case GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY:
		g_value_set_boolean (value, gala_window_clone_get_overview_mode (self));
		break;
		case GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY:
		g_value_set_object (value, gala_window_clone_get_gesture_tracker (self));
		break;
		case GALA_WINDOW_CLONE_MONITOR_SCALE_FACTOR_PROPERTY:
		g_value_set_float (value, gala_window_clone_get_monitor_scale_factor (self));
		break;
		case GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY:
		g_value_set_uchar (value, gala_window_clone_get_shadow_opacity (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_clone_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	GalaWindowClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE, GalaWindowClone);
	switch (property_id) {
		case GALA_WINDOW_CLONE_WM_PROPERTY:
		gala_window_clone_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_WINDOW_PROPERTY:
		gala_window_clone_set_window (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_SLOT_PROPERTY:
		gala_window_clone_set_slot (self, g_value_get_boxed (value));
		break;
		case GALA_WINDOW_CLONE_ACTIVE_PROPERTY:
		gala_window_clone_set_active (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_OVERVIEW_MODE_PROPERTY:
		gala_window_clone_set_overview_mode (self, g_value_get_boolean (value));
		break;
		case GALA_WINDOW_CLONE_GESTURE_TRACKER_PROPERTY:
		gala_window_clone_set_gesture_tracker (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_MONITOR_SCALE_FACTOR_PROPERTY:
		gala_window_clone_set_monitor_scale_factor (self, g_value_get_float (value));
		break;
		case GALA_WINDOW_CLONE_SHADOW_OPACITY_PROPERTY:
		gala_window_clone_set_shadow_opacity (self, g_value_get_uchar (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

