/* Tooltip.c generated by valac 0.56.16, the Vala compiler
 * generated from Tooltip.vala, do not modify */

/*
 * Copyright 2021 José Expósito <jose.exposito89@gmail.com>
 * Copyright 2021-2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_TOOLTIP (gala_tooltip_get_type ())
#define GALA_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOOLTIP, GalaTooltip))
#define GALA_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOOLTIP, GalaTooltipClass))
#define GALA_IS_TOOLTIP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOOLTIP))
#define GALA_IS_TOOLTIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOOLTIP))
#define GALA_TOOLTIP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOOLTIP, GalaTooltipClass))

typedef struct _GalaTooltip GalaTooltip;
typedef struct _GalaTooltipClass GalaTooltipClass;
typedef struct _GalaTooltipPrivate GalaTooltipPrivate;
enum  {
	GALA_TOOLTIP_0_PROPERTY,
	GALA_TOOLTIP_NUM_PROPERTIES
};
static GParamSpec* gala_tooltip_properties[GALA_TOOLTIP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaTooltip {
	GalaCanvasActor parent_instance;
	GalaTooltipPrivate * priv;
	gfloat max_width;
};

struct _GalaTooltipClass {
	GalaCanvasActorClass parent_class;
};

struct _GalaTooltipPrivate {
	ClutterText* text_actor;
};

static gint GalaTooltip_private_offset;
static gpointer gala_tooltip_parent_class = NULL;

VALA_EXTERN GType gala_tooltip_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaTooltip, g_object_unref)
VALA_EXTERN void gala_tooltip_set_text (GalaTooltip* self,
                            const gchar* new_text);
VALA_EXTERN void gala_tooltip_set_max_width (GalaTooltip* self,
                                 gfloat new_max_width);
static void gala_tooltip_real_allocate (ClutterActor* base,
                                 ClutterActorBox* box);
static void gala_tooltip_real_draw (GalaCanvasActor* base,
                             cairo_t* ctx,
                             gint width,
                             gint height);
VALA_EXTERN GalaTooltip* gala_tooltip_new (void);
VALA_EXTERN GalaTooltip* gala_tooltip_construct (GType object_type);
static GObject * gala_tooltip_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void gala_tooltip_finalize (GObject * obj);
static GType gala_tooltip_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_tooltip_get_instance_private (GalaTooltip* self)
{
	return G_STRUCT_MEMBER_P (self, GalaTooltip_private_offset);
}

void
gala_tooltip_set_text (GalaTooltip* self,
                       const gchar* new_text)
{
	ClutterText* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_text != NULL);
	_tmp0_ = self->priv->text_actor;
	clutter_text_set_text (_tmp0_, new_text);
}

void
gala_tooltip_set_max_width (GalaTooltip* self,
                            gfloat new_max_width)
{
	g_return_if_fail (self != NULL);
	self->max_width = new_max_width;
	clutter_actor_queue_relayout ((ClutterActor*) self);
}

static void
gala_tooltip_real_allocate (ClutterActor* base,
                            ClutterActorBox* box)
{
	GalaTooltip * self;
	ClutterActorBox _tmp0_;
	self = (GalaTooltip*) base;
	g_return_if_fail (box != NULL);
	if (clutter_actor_box_get_width (box) > self->max_width) {
		clutter_actor_box_set_origin (box, clutter_actor_box_get_x (box) + ((clutter_actor_box_get_width (box) - self->max_width) / 2), clutter_actor_box_get_y (box));
		clutter_actor_box_set_size (box, self->max_width, clutter_actor_box_get_height (box));
	}
	_tmp0_ = *box;
	CLUTTER_ACTOR_CLASS (gala_tooltip_parent_class)->allocate ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_CANVAS_ACTOR, GalaCanvasActor), &_tmp0_);
}

static void
gala_tooltip_real_draw (GalaCanvasActor* base,
                        cairo_t* ctx,
                        gint width,
                        gint height)
{
	GalaTooltip * self;
	GdkRGBA background_color = {0};
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	self = (GalaTooltip*) base;
	g_return_if_fail (ctx != NULL);
	cairo_save (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	cairo_clip (ctx);
	cairo_reset_clip (ctx);
	cairo_set_operator (ctx, CAIRO_OPERATOR_OVER);
	background_color = GALA_DRAWING_COLOR_TOOLTIP_BACKGROUND;
	_tmp0_ = background_color;
	_tmp1_ = background_color;
	_tmp2_ = background_color;
	_tmp3_ = background_color;
	cairo_set_source_rgba (ctx, _tmp0_.red, _tmp1_.green, _tmp2_.blue, _tmp3_.alpha);
	gala_drawing_utilities_cairo_rounded_rectangle (ctx, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height, (gdouble) 4);
	cairo_fill (ctx);
	cairo_restore (ctx);
}

GalaTooltip*
gala_tooltip_construct (GType object_type)
{
	GalaTooltip * self = NULL;
	self = (GalaTooltip*) gala_canvas_actor_construct (object_type);
	return self;
}

GalaTooltip*
gala_tooltip_new (void)
{
	return gala_tooltip_construct (GALA_TYPE_TOOLTIP);
}

static GObject *
gala_tooltip_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaTooltip * self;
	ClutterColor text_color = {0};
	ClutterColor _tmp0_ = {0};
	ClutterColor _tmp1_;
	ClutterText* _tmp2_ = NULL;
	ClutterText* _tmp3_;
	ClutterBinLayout* _tmp4_;
	ClutterBinLayout* _tmp5_;
	parent_class = G_OBJECT_CLASS (gala_tooltip_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_TOOLTIP, GalaTooltip);
	self->max_width = (gfloat) 200;
	_tmp0_.red = ((guint8) GALA_DRAWING_COLOR_TOOLTIP_TEXT_COLOR.red) * G_MAXUINT8;
	_tmp0_.green = ((guint8) GALA_DRAWING_COLOR_TOOLTIP_TEXT_COLOR.green) * G_MAXUINT8;
	_tmp0_.blue = ((guint8) GALA_DRAWING_COLOR_TOOLTIP_TEXT_COLOR.blue) * G_MAXUINT8;
	_tmp0_.alpha = ((guint8) GALA_DRAWING_COLOR_TOOLTIP_TEXT_COLOR.alpha) * G_MAXUINT8;
	text_color = _tmp0_;
	_tmp1_ = text_color;
	_tmp2_ = (ClutterText*) clutter_text_new ();
	clutter_actor_set_margin_left ((ClutterActor*) _tmp2_, (gfloat) 6);
	clutter_actor_set_margin_top ((ClutterActor*) _tmp2_, (gfloat) 6);
	clutter_actor_set_margin_bottom ((ClutterActor*) _tmp2_, (gfloat) 6);
	clutter_actor_set_margin_right ((ClutterActor*) _tmp2_, (gfloat) 6);
	clutter_text_set_ellipsize (_tmp2_, PANGO_ELLIPSIZE_MIDDLE);
	clutter_text_set_color (_tmp2_, &_tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->text_actor);
	self->priv->text_actor = _tmp2_;
	_tmp3_ = self->priv->text_actor;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp3_);
	_tmp4_ = (ClutterBinLayout*) clutter_bin_layout_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	clutter_actor_set_layout_manager ((ClutterActor*) self, (ClutterLayoutManager*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	return obj;
}

static void
gala_tooltip_class_init (GalaTooltipClass * klass,
                         gpointer klass_data)
{
	gala_tooltip_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaTooltip_private_offset);
	((ClutterActorClass *) klass)->allocate = (void (*) (ClutterActor*, ClutterActorBox*)) gala_tooltip_real_allocate;
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_tooltip_real_draw;
	G_OBJECT_CLASS (klass)->constructor = gala_tooltip_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_tooltip_finalize;
}

static void
gala_tooltip_instance_init (GalaTooltip * self,
                            gpointer klass)
{
	self->priv = gala_tooltip_get_instance_private (self);
}

static void
gala_tooltip_finalize (GObject * obj)
{
	GalaTooltip * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_TOOLTIP, GalaTooltip);
	_g_object_unref0 (self->priv->text_actor);
	G_OBJECT_CLASS (gala_tooltip_parent_class)->finalize (obj);
}

/**
 * Clutter actor to display text in a tooltip-like component.
 */
static GType
gala_tooltip_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaTooltipClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_tooltip_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaTooltip), 0, (GInstanceInitFunc) gala_tooltip_instance_init, NULL };
	GType gala_tooltip_type_id;
	gala_tooltip_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaTooltip", &g_define_type_info, 0);
	GalaTooltip_private_offset = g_type_add_instance_private (gala_tooltip_type_id, sizeof (GalaTooltipPrivate));
	return gala_tooltip_type_id;
}

GType
gala_tooltip_get_type (void)
{
	static volatile gsize gala_tooltip_type_id__once = 0;
	if (g_once_init_enter (&gala_tooltip_type_id__once)) {
		GType gala_tooltip_type_id;
		gala_tooltip_type_id = gala_tooltip_get_type_once ();
		g_once_init_leave (&gala_tooltip_type_id__once, gala_tooltip_type_id);
	}
	return gala_tooltip_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

