/* MultitaskingView.c generated by valac 0.56.16, the Vala compiler
 * generated from MultitaskingView.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <clutter/clutter.h>
#include "gala.h"
#include <glib-object.h>
#include <meta/display.h>
#include <glib.h>
#include <gio/gio.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <float.h>
#include <math.h>
#include <meta/meta-workspace-manager.h>
#include <meta/common.h>
#include <meta/workspace.h>
#include <meta/meta-plugin.h>
#include <meta/keybindings.h>
#include <meta/meta-background-group.h>
#include <meta/meta-window-actor.h>
#include <meta/compositor-mutter.h>
#include <meta/prefs.h>
#include <meta/meta-monitor-manager.h>
#include <meta/meta-context.h>
#include <meta/meta-backend.h>

#define GALA_MULTITASKING_VIEW_ANIMATION_DURATION 250
#define GALA_MULTITASKING_VIEW_OPEN_MULTITASKING_VIEW "dbus-send --session --dest=org.pantheon.gala --print-reply /org/panthe" \
"on/gala org.pantheon.gala.PerformAction int32:1"
#define GALA_WINDOW_MANAGER_GALA_NUDGE_GAP 32
#define GALA_ICON_GROUP_CONTAINER_SPACING 48
#define GALA_ICON_GROUP_SIZE 64
#define GALA_WORKSPACE_CLONE_BOTTOM_OFFSET 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_MULTITASKING_VIEW (gala_multitasking_view_get_type ())
#define GALA_MULTITASKING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView))
#define GALA_MULTITASKING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingViewClass))
#define GALA_IS_MULTITASKING_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MULTITASKING_VIEW))
#define GALA_IS_MULTITASKING_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MULTITASKING_VIEW))
#define GALA_MULTITASKING_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingViewClass))

typedef struct _GalaMultitaskingView GalaMultitaskingView;
typedef struct _GalaMultitaskingViewClass GalaMultitaskingViewClass;
typedef struct _GalaMultitaskingViewPrivate GalaMultitaskingViewPrivate;

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;

#define GALA_TYPE_MONITOR_CLONE (gala_monitor_clone_get_type ())
#define GALA_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorClone))
#define GALA_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))
#define GALA_IS_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONITOR_CLONE))
#define GALA_IS_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONITOR_CLONE))
#define GALA_MONITOR_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))

typedef struct _GalaMonitorClone GalaMonitorClone;
typedef struct _GalaMonitorCloneClass GalaMonitorCloneClass;

#define GALA_TYPE_ICON_GROUP_CONTAINER (gala_icon_group_container_get_type ())
#define GALA_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainer))
#define GALA_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))
#define GALA_IS_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_IS_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_ICON_GROUP_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))

typedef struct _GalaIconGroupContainer GalaIconGroupContainer;
typedef struct _GalaIconGroupContainerClass GalaIconGroupContainerClass;
enum  {
	GALA_MULTITASKING_VIEW_0_PROPERTY,
	GALA_MULTITASKING_VIEW_WM_PROPERTY,
	GALA_MULTITASKING_VIEW_NUM_PROPERTIES
};
static GParamSpec* gala_multitasking_view_properties[GALA_MULTITASKING_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_WORKSPACE_CLONE (gala_workspace_clone_get_type ())
#define GALA_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone))
#define GALA_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))
#define GALA_IS_WORKSPACE_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_IS_WORKSPACE_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_CLONE))
#define GALA_WORKSPACE_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceCloneClass))

typedef struct _GalaWorkspaceClone GalaWorkspaceClone;
typedef struct _GalaWorkspaceCloneClass GalaWorkspaceCloneClass;

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;

#define GALA_TYPE_GESTURE (gala_gesture_get_type ())
#define GALA_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE, GalaGesture))
#define GALA_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE, GalaGestureClass))
#define GALA_IS_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE))
#define GALA_IS_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE))
#define GALA_GESTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE, GalaGestureClass))

typedef struct _GalaGesture GalaGesture;
typedef struct _GalaGestureClass GalaGestureClass;
typedef struct _GalaGesturePrivate GalaGesturePrivate;
typedef enum  {
	GALA_GESTURE_DIRECTION_UNKNOWN = 0,
	GALA_GESTURE_DIRECTION_UP = 1,
	GALA_GESTURE_DIRECTION_DOWN = 2,
	GALA_GESTURE_DIRECTION_LEFT = 3,
	GALA_GESTURE_DIRECTION_RIGHT = 4,
	GALA_GESTURE_DIRECTION_IN = 5,
	GALA_GESTURE_DIRECTION_OUT = 6
} GalaGestureDirection;

#define GALA_TYPE_GESTURE_DIRECTION (gala_gesture_direction_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define GALA_TYPE_GESTURE_SETTINGS (gala_gesture_settings_get_type ())
#define GALA_GESTURE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettings))
#define GALA_GESTURE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettingsClass))
#define GALA_IS_GESTURE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_SETTINGS))
#define GALA_IS_GESTURE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_SETTINGS))
#define GALA_GESTURE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettingsClass))

typedef struct _GalaGestureSettings GalaGestureSettings;
typedef struct _GalaGestureSettingsClass GalaGestureSettingsClass;
typedef struct _Block60Data Block60Data;
typedef void (*GalaGestureTrackerOnUpdate) (gdouble percentage, gpointer user_data);
typedef void (*GalaGestureTrackerOnEnd) (gdouble percentage, gboolean cancel_action, gint calculated_duration, gpointer user_data);
typedef void (*GalaGestureTrackerOnBegin) (gdouble percentage, gpointer user_data);

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
typedef struct _Block61Data Block61Data;
typedef struct _Block62Data Block62Data;
typedef struct _Block63Data Block63Data;

#define GALA_TYPE_SAFE_WINDOW_CLONE (gala_safe_window_clone_get_type ())
#define GALA_SAFE_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowClone))
#define GALA_SAFE_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowCloneClass))
#define GALA_IS_SAFE_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SAFE_WINDOW_CLONE))
#define GALA_IS_SAFE_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SAFE_WINDOW_CLONE))
#define GALA_SAFE_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SAFE_WINDOW_CLONE, GalaSafeWindowCloneClass))

typedef struct _GalaSafeWindowClone GalaSafeWindowClone;
typedef struct _GalaSafeWindowCloneClass GalaSafeWindowCloneClass;
typedef struct _Block64Data Block64Data;
typedef struct _Block65Data Block65Data;
typedef struct _Block66Data Block66Data;

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;

#define GALA_TYPE_BLUR_EFFECT (gala_blur_effect_get_type ())
#define GALA_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BLUR_EFFECT, GalaBlurEffect))
#define GALA_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BLUR_EFFECT, GalaBlurEffectClass))
#define GALA_IS_BLUR_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BLUR_EFFECT))
#define GALA_IS_BLUR_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BLUR_EFFECT))
#define GALA_BLUR_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BLUR_EFFECT, GalaBlurEffectClass))

typedef struct _GalaBlurEffect GalaBlurEffect;
typedef struct _GalaBlurEffectClass GalaBlurEffectClass;

struct _GalaMultitaskingView {
	ClutterActor parent_instance;
	GalaMultitaskingViewPrivate * priv;
};

struct _GalaMultitaskingViewClass {
	ClutterActorClass parent_class;
};

struct _GalaMultitaskingViewPrivate {
	GalaGestureTracker* multitasking_gesture_tracker;
	GalaGestureTracker* workspace_gesture_tracker;
	GalaWindowManager* _wm;
	MetaDisplay* display;
	GalaModalProxy* modal_proxy;
	gboolean opened;
	gboolean animating;
	GList* window_containers_monitors;
	GalaIconGroupContainer* icon_groups;
	ClutterActor* workspaces;
	ClutterActor* dock_clones;
	ClutterActor* primary_monitor_container;
	ClutterBrightnessContrastEffect* brightness_effect;
	GSettings* gala_behavior_settings;
	GraniteSettings* granite_settings;
	gboolean switching_workspace_with_gesture;
};

struct _GalaGesture {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaGesturePrivate * priv;
	ClutterEventType type;
	GalaGestureDirection direction;
	gint fingers;
	ClutterInputDeviceType performed_on_device_type;
};

struct _GalaGestureClass {
	GTypeClass parent_class;
	void (*finalize) (GalaGesture *self);
};

struct _Block60Data {
	int _ref_count_;
	GalaMultitaskingView* self;
	MetaWorkspace* active_workspace;
	gfloat initial_x;
	gfloat target_x;
	gboolean is_nudge_animation;
	gint nudge_gap;
	GalaIconGroup* active_icon_group;
	GalaIconGroup* target_icon_group;
};

struct _Block61Data {
	int _ref_count_;
	GalaMultitaskingView* self;
	gboolean opening;
};

struct _Block62Data {
	int _ref_count_;
	Block61Data * _data61_;
	gboolean cancel_action;
};

struct _Block63Data {
	int _ref_count_;
	GalaMultitaskingView* self;
	gboolean is_cancel_animation;
};

struct _Block64Data {
	int _ref_count_;
	Block63Data * _data63_;
	gfloat initial_y;
	gfloat target_y;
	GalaSafeWindowClone* clone;
};

struct _Block65Data {
	int _ref_count_;
	GalaMultitaskingView* self;
	ClutterClone* dock;
	gfloat initial_y;
	gfloat target_y;
};

struct _Block66Data {
	int _ref_count_;
	GalaMultitaskingView* self;
	MetaWorkspaceManager* manager;
};

static gint GalaMultitaskingView_private_offset;
static gpointer gala_multitasking_view_parent_class = NULL;
static GalaActivatableComponentIface * gala_multitasking_view_gala_activatable_component_parent_iface = NULL;

VALA_EXTERN GType gala_multitasking_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMultitaskingView, g_object_unref)
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
VALA_EXTERN GType gala_monitor_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonitorClone, g_object_unref)
VALA_EXTERN GType gala_icon_group_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroupContainer, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN GalaMultitaskingView* gala_multitasking_view_new (GalaWindowManager* wm);
VALA_EXTERN GalaMultitaskingView* gala_multitasking_view_construct (GType object_type,
                                                        GalaWindowManager* wm);
static void gala_multitasking_view_update_brightness_effect (GalaMultitaskingView* self);
static void gala_multitasking_view_update_monitors (GalaMultitaskingView* self);
static void gala_multitasking_view_update_workspaces (GalaMultitaskingView* self);
VALA_EXTERN gboolean gala_internal_utils_workspaces_only_on_primary (void);
VALA_EXTERN GalaWindowManager* gala_multitasking_view_get_wm (GalaMultitaskingView* self);
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_new (GalaWindowManager* wm,
                                          MetaDisplay* display,
                                          gint monitor,
                                          GalaGestureTracker* gesture_tracker);
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_construct (GType object_type,
                                                GalaWindowManager* wm,
                                                MetaDisplay* display,
                                                gint monitor,
                                                GalaGestureTracker* gesture_tracker);
static void gala_multitasking_view_window_selected (GalaMultitaskingView* self,
                                             MetaWindow* window);
static void _gala_multitasking_view_window_selected_gala_monitor_clone_window_selected (GalaMonitorClone* _sender,
                                                                                 MetaWindow* window,
                                                                                 gpointer self);
VALA_EXTERN void gala_icon_group_container_set_scale_factor (GalaIconGroupContainer* self,
                                                 gfloat value);
VALA_EXTERN GType gala_workspace_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceClone, g_object_unref)
VALA_EXTERN void gala_workspace_clone_set_scale_factor (GalaWorkspaceClone* self,
                                            gfloat value);
VALA_EXTERN void gala_workspace_clone_update_size (GalaWorkspaceClone* self,
                                       MtkRectangle* monitor_geometry);
VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN void gala_icon_group_container_remove_group (GalaIconGroupContainer* self,
                                             GalaIconGroup* group);
VALA_EXTERN GalaIconGroup* gala_workspace_clone_get_icon_group (GalaWorkspaceClone* self);
static void gala_multitasking_view_add_workspace (GalaMultitaskingView* self,
                                           gint num);
static gboolean gala_multitasking_view_real_scroll_event (ClutterActor* base,
                                                   ClutterEvent* scroll_event);
VALA_EXTERN void gala_multitasking_view_play_nudge_animation (GalaMultitaskingView* self,
                                                  MetaMotionDirection direction);
VALA_EXTERN gint gala_internal_utils_scale_to_int (gint value,
                                       gfloat scale_factor);
static void _vala_GValue_array_free (GValue * array,
                              gssize array_length);
VALA_EXTERN gpointer gala_gesture_ref (gpointer instance);
VALA_EXTERN void gala_gesture_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_gesture (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void gala_value_set_gesture (GValue* value,
                             gpointer v_object);
VALA_EXTERN void gala_value_take_gesture (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer gala_value_get_gesture (const GValue* value);
VALA_EXTERN GType gala_gesture_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGesture, gala_gesture_unref)
static void gala_multitasking_view_on_multitasking_gesture_detected (GalaMultitaskingView* self,
                                                              GalaGesture* gesture);
VALA_EXTERN GType gala_gesture_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* gala_gesture_settings_get_string (const gchar* setting_id);
static void gala_multitasking_view_toggle (GalaMultitaskingView* self,
                                    gboolean with_gesture,
                                    gboolean is_cancel_animation);
static void gala_multitasking_view_on_workspace_gesture_detected (GalaMultitaskingView* self,
                                                           GalaGesture* gesture);
VALA_EXTERN GType gala_gesture_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureSettings, g_object_unref)
VALA_EXTERN GalaGestureSettings* gala_gesture_tracker_get_settings (GalaGestureTracker* self);
VALA_EXTERN MetaMotionDirection* gala_gesture_settings_get_natural_scroll_direction (GalaGestureSettings* self,
                                                                         GalaGesture* gesture);
static void gala_multitasking_view_switch_workspace_with_gesture (GalaMultitaskingView* self,
                                                           MetaMotionDirection direction);
static Block60Data* block60_data_ref (Block60Data* _data60_);
static void block60_data_unref (void * _userdata_);
static gboolean gala_multitasking_view_get_switching_workspace_in_progress (GalaMultitaskingView* self);
VALA_EXTERN void gala_internal_utils_get_workspaces_geometry (MetaDisplay* display,
                                                  MtkRectangle* result);
VALA_EXTERN MetaWorkspace* gala_workspace_clone_get_workspace (GalaWorkspaceClone* self);
VALA_EXTERN gfloat gala_workspace_clone_multitasking_view_x (GalaWorkspaceClone* self);
static void __lambda72_ (Block60Data* _data60_,
                  gdouble percentage);
VALA_EXTERN gfloat gala_gesture_tracker_animation_value (gfloat initial_value,
                                             gfloat target_value,
                                             gdouble percentage,
                                             gboolean rounded);
VALA_EXTERN void gala_icon_group_set_backdrop_opacity (GalaIconGroup* self,
                                           gfloat value);
static void ___lambda72__gala_gesture_tracker_on_update (gdouble percentage,
                                                  gpointer self);
static void __lambda73_ (Block60Data* _data60_,
                  gdouble percentage,
                  gboolean cancel_action,
                  gint calculated_duration);
VALA_EXTERN gfloat gala_icon_group_get_backdrop_opacity (GalaIconGroup* self);
static void ___lambda73__gala_gesture_tracker_on_end (gdouble percentage,
                                               gboolean cancel_action,
                                               gint calculated_duration,
                                               gpointer self);
VALA_EXTERN void gala_gesture_tracker_connect_handlers (GalaGestureTracker* self,
                                            GalaGestureTrackerOnBegin on_begin_handler,
                                            gpointer on_begin_handler_target,
                                            GDestroyNotify on_begin_handler_target_destroy_notify,
                                            GalaGestureTrackerOnUpdate on_update_handler,
                                            gpointer on_update_handler_target,
                                            GDestroyNotify on_update_handler_target_destroy_notify,
                                            GalaGestureTrackerOnEnd on_end_handler,
                                            gpointer on_end_handler_target,
                                            GDestroyNotify on_end_handler_target_destroy_notify);
static void gala_multitasking_view_update_positions (GalaMultitaskingView* self,
                                              gboolean animate);
static void gala_multitasking_view_reposition_icon_groups (GalaMultitaskingView* self,
                                                    gboolean animate);
VALA_EXTERN gfloat gala_icon_group_container_calculate_total_width (GalaIconGroupContainer* self);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_new (GalaWindowManager* wm,
                                              MetaWorkspace* workspace,
                                              GalaGestureTracker* gesture_tracker,
                                              gfloat scale);
VALA_EXTERN GalaWorkspaceClone* gala_workspace_clone_construct (GType object_type,
                                                    GalaWindowManager* wm,
                                                    MetaWorkspace* workspace,
                                                    GalaGestureTracker* gesture_tracker,
                                                    gfloat scale);
VALA_EXTERN void gala_icon_group_container_add_group (GalaIconGroupContainer* self,
                                          GalaIconGroup* group);
static void _gala_multitasking_view_window_selected_gala_workspace_clone_window_selected (GalaWorkspaceClone* _sender,
                                                                                   MetaWindow* window,
                                                                                   gpointer self);
static void gala_multitasking_view_activate_workspace (GalaMultitaskingView* self,
                                                GalaWorkspaceClone* clone,
                                                gboolean close_view);
static void _gala_multitasking_view_activate_workspace_gala_workspace_clone_selected (GalaWorkspaceClone* _sender,
                                                                               gboolean close_view,
                                                                               gpointer self);
VALA_EXTERN void gala_workspace_clone_open (GalaWorkspaceClone* self,
                                gboolean with_gesture,
                                gboolean is_cancel_animation);
static void gala_multitasking_view_remove_workspace (GalaMultitaskingView* self,
                                              gint num);
static gboolean gala_multitasking_view_real_key_press_event (ClutterActor* base,
                                                      ClutterEvent* event);
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
static GalaWindowCloneContainer* gala_multitasking_view_get_active_window_clone_container (GalaMultitaskingView* self);
VALA_EXTERN GalaWindowCloneContainer* gala_workspace_clone_get_window_container (GalaWorkspaceClone* self);
static gboolean gala_multitasking_view_real_is_opened (GalaActivatableComponent* base);
static void gala_multitasking_view_real_open (GalaActivatableComponent* base,
                                       GHashTable* hints);
static void gala_multitasking_view_real_close (GalaActivatableComponent* base,
                                        GHashTable* hints);
static Block61Data* block61_data_ref (Block61Data* _data61_);
static void block61_data_unref (void * _userdata_);
VALA_EXTERN void gala_monitor_clone_open (GalaMonitorClone* self,
                              gboolean with_gesture,
                              gboolean is_cancel_animation);
VALA_EXTERN void gala_monitor_clone_close (GalaMonitorClone* self,
                               gboolean with_gesture,
                               gboolean is_cancel_animation);
static gboolean gala_multitasking_view_keybinding_filter (GalaMultitaskingView* self,
                                                   MetaKeyBinding* binding);
static gboolean _gala_multitasking_view_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                           gpointer self);
VALA_EXTERN void gala_icon_group_container_force_reposition (GalaIconGroupContainer* self);
VALA_EXTERN void gala_workspace_clone_close (GalaWorkspaceClone* self,
                                 gboolean with_gesture,
                                 gboolean is_cancel_animation);
static void gala_multitasking_view_show_docks (GalaMultitaskingView* self,
                                        gboolean with_gesture,
                                        gboolean is_cancel_animation);
static void gala_multitasking_view_hide_docks (GalaMultitaskingView* self,
                                        gboolean with_gesture,
                                        gboolean is_cancel_animation);
static void __lambda70_ (Block61Data* _data61_,
                  gdouble percentage,
                  gboolean cancel_action);
static Block62Data* block62_data_ref (Block62Data* _data62_);
static void block62_data_unref (void * _userdata_);
static gboolean __lambda71_ (Block62Data* _data62_);
static gboolean ___lambda71__gsource_func (gpointer self);
static void ___lambda70__gala_gesture_tracker_on_end (gdouble percentage,
                                               gboolean cancel_action,
                                               gint calculated_duration,
                                               gpointer self);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
VALA_EXTERN GType gala_safe_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaSafeWindowClone, g_object_unref)
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
VALA_EXTERN GalaSafeWindowClone* gala_safe_window_clone_new (MetaWindow* window,
                                                 gboolean destroy_on_unmanaged);
VALA_EXTERN GalaSafeWindowClone* gala_safe_window_clone_construct (GType object_type,
                                                       MetaWindow* window,
                                                       gboolean destroy_on_unmanaged);
static void ____lambda66_ (Block64Data* _data64_,
                    gdouble percentage);
static void _____lambda66__gala_gesture_tracker_on_update (gdouble percentage,
                                                    gpointer self);
static void ____lambda67_ (Block64Data* _data64_,
                    gdouble percentage,
                    gboolean cancel_action);
static void _____lambda67__gala_gesture_tracker_on_end (gdouble percentage,
                                                 gboolean cancel_action,
                                                 gint calculated_duration,
                                                 gpointer self);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
static void ____lambda68_ (Block65Data* _data65_,
                    gdouble percentage);
static void _____lambda68__gala_gesture_tracker_on_update (gdouble percentage,
                                                    gpointer self);
static void ____lambda69_ (Block65Data* _data65_,
                    gdouble percentage,
                    gboolean cancel_action);
static void _____lambda69__gala_gesture_tracker_on_end (gdouble percentage,
                                                 gboolean cancel_action,
                                                 gint calculated_duration,
                                                 gpointer self);
static void gala_multitasking_view_set_wm (GalaMultitaskingView* self,
                                    GalaWindowManager* value);
static GObject * gala_multitasking_view_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
VALA_EXTERN GalaGestureTracker* gala_gesture_tracker_new (gint min_animation_duration,
                                              gint max_animation_duration);
VALA_EXTERN GalaGestureTracker* gala_gesture_tracker_construct (GType object_type,
                                                    gint min_animation_duration,
                                                    gint max_animation_duration);
VALA_EXTERN void gala_gesture_tracker_enable_touchpad (GalaGestureTracker* self);
static void _gala_multitasking_view_on_multitasking_gesture_detected_gala_gesture_tracker_on_gesture_detected (GalaGestureTracker* _sender,
                                                                                                        GalaGesture* gesture,
                                                                                                        gpointer self);
VALA_EXTERN void gala_gesture_tracker_enable_scroll (GalaGestureTracker* self,
                                         ClutterActor* actor,
                                         ClutterOrientation orientation);
static void _gala_multitasking_view_on_workspace_gesture_detected_gala_gesture_tracker_on_gesture_detected (GalaGestureTracker* _sender,
                                                                                                     GalaGesture* gesture,
                                                                                                     gpointer self);
VALA_EXTERN GalaIconGroupContainer* gala_icon_group_container_new (GalaWindowManager* wm,
                                                       gfloat scale);
VALA_EXTERN GalaIconGroupContainer* gala_icon_group_container_construct (GType object_type,
                                                             GalaWindowManager* wm,
                                                             gfloat scale);
VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
VALA_EXTERN GalaBackgroundManager* gala_background_manager_new (GalaWindowManager* wm,
                                                    gint monitor_index,
                                                    gboolean control_position);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_construct (GType object_type,
                                                          GalaWindowManager* wm,
                                                          gint monitor_index,
                                                          gboolean control_position);
VALA_EXTERN GalaBlurEffect* gala_blur_effect_new (ClutterActor* actor,
                                      gfloat radius);
VALA_EXTERN GalaBlurEffect* gala_blur_effect_construct (GType object_type,
                                            ClutterActor* actor,
                                            gfloat radius);
VALA_EXTERN GType gala_blur_effect_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBlurEffect, g_object_unref)
static void _gala_multitasking_view_add_workspace_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                                   gint object,
                                                                                   gpointer self);
static void _gala_multitasking_view_remove_workspace_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                        gint object,
                                                                                        gpointer self);
static void _gala_multitasking_view___lambda74_ (GalaMultitaskingView* self);
static void __gala_multitasking_view___lambda74__meta_workspace_manager_workspaces_reordered (MetaWorkspaceManager* _sender,
                                                                                       gpointer self);
static void _gala_multitasking_view___lambda75_ (GalaMultitaskingView* self,
                                          gint from,
                                          gint to,
                                          MetaMotionDirection direction);
static void __gala_multitasking_view___lambda75__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                                     gint object,
                                                                                     gint p0,
                                                                                     MetaMotionDirection p1,
                                                                                     gpointer self);
static void _gala_multitasking_view_update_monitors_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                                    gpointer self);
static void _gala_multitasking_view___lambda76_ (Block66Data* _data66_,
                                          MetaPreference pref);
static gboolean __lambda77_ (Block66Data* _data66_);
static gboolean ___lambda77__gsource_func (gpointer self);
static void __gala_multitasking_view___lambda76__meta_prefs_changed_func (MetaPreference pref,
                                                                   gpointer self);
static void _gala_multitasking_view_update_brightness_effect_g_object_notify (GObject* _sender,
                                                                       GParamSpec* pspec,
                                                                       gpointer self);
static void gala_multitasking_view_finalize (GObject * obj);
static GType gala_multitasking_view_get_type_once (void);
static void _vala_gala_multitasking_view_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_gala_multitasking_view_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_multitasking_view_get_instance_private (GalaMultitaskingView* self)
{
	return G_STRUCT_MEMBER_P (self, GalaMultitaskingView_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

GalaMultitaskingView*
gala_multitasking_view_construct (GType object_type,
                                  GalaWindowManager* wm)
{
	GalaMultitaskingView * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaMultitaskingView*) g_object_new (object_type, "wm", wm, NULL);
	return self;
}

GalaMultitaskingView*
gala_multitasking_view_new (GalaWindowManager* wm)
{
	return gala_multitasking_view_construct (GALA_TYPE_MULTITASKING_VIEW, wm);
}

static void
gala_multitasking_view_update_brightness_effect (GalaMultitaskingView* self)
{
	GraniteSettings* _tmp0_;
	GraniteSettingsColorScheme _tmp1_;
	GraniteSettingsColorScheme _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->granite_settings;
	_tmp1_ = granite_settings_get_prefers_color_scheme (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK) {
		ClutterBrightnessContrastEffect* _tmp3_;
		_tmp3_ = self->priv->brightness_effect;
		clutter_brightness_contrast_effect_set_brightness (_tmp3_, -0.4f);
	} else {
		ClutterBrightnessContrastEffect* _tmp4_;
		_tmp4_ = self->priv->brightness_effect;
		clutter_brightness_contrast_effect_set_brightness (_tmp4_, 0.4f);
	}
}

/**
         * Places the primary container for the WorkspaceClones and the
         * MonitorClones at the right positions
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gala_multitasking_view_window_selected_gala_monitor_clone_window_selected (GalaMonitorClone* _sender,
                                                                            MetaWindow* window,
                                                                            gpointer self)
{
	gala_multitasking_view_window_selected ((GalaMultitaskingView*) self, window);
}

static void
gala_multitasking_view_update_monitors (GalaMultitaskingView* self)
{
	GList* _tmp0_;
	gint primary = 0;
	MetaDisplay* _tmp3_;
	MtkRectangle primary_geometry = {0};
	MetaDisplay* _tmp16_;
	MtkRectangle _tmp17_ = {0};
	gfloat scale = 0.0F;
	MetaDisplay* _tmp18_;
	GalaIconGroupContainer* _tmp19_;
	ClutterActor* _tmp20_;
	MtkRectangle _tmp21_;
	MtkRectangle _tmp22_;
	ClutterActor* _tmp23_;
	MtkRectangle _tmp24_;
	MtkRectangle _tmp25_;
	ClutterActor* _tmp26_;
	GList* _tmp27_;
	g_return_if_fail (self != NULL);
	gala_multitasking_view_update_workspaces (self);
	_tmp0_ = self->priv->window_containers_monitors;
	{
		GList* monitor_clone_collection = NULL;
		GList* monitor_clone_it = NULL;
		monitor_clone_collection = _tmp0_;
		for (monitor_clone_it = monitor_clone_collection; monitor_clone_it != NULL; monitor_clone_it = monitor_clone_it->next) {
			GalaMonitorClone* _tmp1_;
			GalaMonitorClone* monitor_clone = NULL;
			_tmp1_ = _g_object_ref0 ((GalaMonitorClone*) monitor_clone_it->data);
			monitor_clone = _tmp1_;
			{
				GalaMonitorClone* _tmp2_;
				_tmp2_ = monitor_clone;
				clutter_actor_destroy ((ClutterActor*) _tmp2_);
				_g_object_unref0 (monitor_clone);
			}
		}
	}
	_tmp3_ = self->priv->display;
	primary = meta_display_get_primary_monitor (_tmp3_);
	if (gala_internal_utils_workspaces_only_on_primary ()) {
		{
			gint monitor = 0;
			monitor = 0;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					MetaDisplay* _tmp6_;
					GalaMonitorClone* monitor_clone = NULL;
					GalaWindowManager* _tmp7_;
					MetaDisplay* _tmp8_;
					GalaGestureTracker* _tmp9_;
					GalaMonitorClone* _tmp10_;
					GalaMonitorClone* _tmp11_;
					GalaMonitorClone* _tmp12_;
					GalaMonitorClone* _tmp13_;
					GalaMonitorClone* _tmp14_;
					GalaMonitorClone* _tmp15_;
					if (!_tmp4_) {
						gint _tmp5_;
						_tmp5_ = monitor;
						monitor = _tmp5_ + 1;
					}
					_tmp4_ = FALSE;
					_tmp6_ = self->priv->display;
					if (!(monitor < meta_display_get_n_monitors (_tmp6_))) {
						break;
					}
					if (monitor == primary) {
						continue;
					}
					_tmp7_ = self->priv->_wm;
					_tmp8_ = self->priv->display;
					_tmp9_ = self->priv->multitasking_gesture_tracker;
					_tmp10_ = gala_monitor_clone_new (_tmp7_, _tmp8_, monitor, _tmp9_);
					g_object_ref_sink (_tmp10_);
					monitor_clone = _tmp10_;
					_tmp11_ = monitor_clone;
					g_signal_connect_object (_tmp11_, "window-selected", (GCallback) _gala_multitasking_view_window_selected_gala_monitor_clone_window_selected, self, 0);
					_tmp12_ = monitor_clone;
					g_object_set ((ClutterActor*) _tmp12_, "visible", self->priv->opened, NULL);
					_tmp13_ = monitor_clone;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					self->priv->window_containers_monitors = g_list_append (self->priv->window_containers_monitors, _tmp14_);
					_tmp15_ = monitor_clone;
					clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp15_);
					_g_object_unref0 (monitor_clone);
				}
			}
		}
	}
	_tmp16_ = self->priv->display;
	meta_display_get_monitor_geometry (_tmp16_, primary, &_tmp17_);
	primary_geometry = _tmp17_;
	_tmp18_ = self->priv->display;
	scale = meta_display_get_monitor_scale (_tmp18_, primary);
	_tmp19_ = self->priv->icon_groups;
	gala_icon_group_container_set_scale_factor (_tmp19_, scale);
	_tmp20_ = self->priv->primary_monitor_container;
	_tmp21_ = primary_geometry;
	_tmp22_ = primary_geometry;
	clutter_actor_set_position (_tmp20_, (gfloat) _tmp21_.x, (gfloat) _tmp22_.y);
	_tmp23_ = self->priv->primary_monitor_container;
	_tmp24_ = primary_geometry;
	_tmp25_ = primary_geometry;
	clutter_actor_set_size (_tmp23_, (gfloat) _tmp24_.width, (gfloat) _tmp25_.height);
	_tmp26_ = self->priv->workspaces;
	_tmp27_ = clutter_actor_get_children (_tmp26_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp27_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace_clone = NULL;
				ClutterActor* _tmp28_;
				GalaWorkspaceClone* _tmp29_;
				GalaWorkspaceClone* _tmp30_;
				MtkRectangle _tmp31_;
				_tmp28_ = child;
				workspace_clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp29_ = workspace_clone;
				gala_workspace_clone_set_scale_factor (_tmp29_, scale);
				_tmp30_ = workspace_clone;
				_tmp31_ = primary_geometry;
				gala_workspace_clone_update_size (_tmp30_, &_tmp31_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
gala_multitasking_view_update_workspaces (GalaMultitaskingView* self)
{
	ClutterActor* _tmp0_;
	GList* _tmp1_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp8_;
	MetaWorkspaceManager* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->workspaces;
	_tmp1_ = clutter_actor_get_children (_tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace_clone = NULL;
				ClutterActor* _tmp2_;
				GalaIconGroupContainer* _tmp3_;
				GalaWorkspaceClone* _tmp4_;
				GalaIconGroup* _tmp5_;
				GalaIconGroup* _tmp6_;
				GalaWorkspaceClone* _tmp7_;
				_tmp2_ = child;
				workspace_clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp3_ = self->priv->icon_groups;
				_tmp4_ = workspace_clone;
				_tmp5_ = gala_workspace_clone_get_icon_group (_tmp4_);
				_tmp6_ = _tmp5_;
				gala_icon_group_container_remove_group (_tmp3_, _tmp6_);
				_tmp7_ = workspace_clone;
				clutter_actor_destroy ((ClutterActor*) _tmp7_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp8_ = self->priv->display;
	_tmp9_ = meta_display_get_workspace_manager (_tmp8_);
	manager = _tmp9_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp12_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp12_))) {
					break;
				}
				gala_multitasking_view_add_workspace (self, i);
			}
		}
	}
}

/**
         * Scroll through workspaces with the mouse wheel. Smooth scrolling is handled by
         * GestureTracker.
         */
static gboolean
gala_multitasking_view_real_scroll_event (ClutterActor* base,
                                          ClutterEvent* scroll_event)
{
	GalaMultitaskingView * self;
	ClutterScrollDirection scroll_direction = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	MetaMotionDirection direction = 0;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp3_;
	MetaWorkspaceManager* _tmp4_;
	MetaWorkspace* active_workspace = NULL;
	MetaWorkspaceManager* _tmp5_;
	MetaWorkspace* _tmp6_;
	MetaWorkspace* _tmp7_;
	MetaWorkspace* new_workspace = NULL;
	MetaWorkspace* _tmp8_;
	MetaWorkspace* _tmp9_;
	MetaWorkspace* _tmp10_;
	MetaWorkspace* _tmp11_;
	MetaWorkspace* _tmp12_;
	gboolean result;
	self = (GalaMultitaskingView*) base;
	g_return_val_if_fail (scroll_event != NULL, FALSE);
	if (!self->priv->opened) {
		result = TRUE;
		return result;
	}
	scroll_direction = clutter_event_get_scroll_direction (scroll_event);
	if (scroll_direction == CLUTTER_SCROLL_SMOOTH) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = clutter_event_get_scroll_source (scroll_event) == CLUTTER_SCROLL_SOURCE_FINGER;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ClutterInputDevice* _tmp2_;
		_tmp2_ = clutter_event_get_source_device (scroll_event);
		_tmp0_ = clutter_input_device_get_device_type (_tmp2_) == CLUTTER_TOUCHPAD_DEVICE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	switch (scroll_direction) {
		case CLUTTER_SCROLL_UP:
		case CLUTTER_SCROLL_LEFT:
		{
			direction = META_MOTION_LEFT;
			break;
		}
		default:
		case CLUTTER_SCROLL_DOWN:
		case CLUTTER_SCROLL_RIGHT:
		{
			direction = META_MOTION_RIGHT;
			break;
		}
	}
	_tmp3_ = self->priv->display;
	_tmp4_ = meta_display_get_workspace_manager (_tmp3_);
	manager = _tmp4_;
	_tmp5_ = manager;
	_tmp6_ = meta_workspace_manager_get_active_workspace (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	active_workspace = _tmp7_;
	_tmp8_ = active_workspace;
	_tmp9_ = meta_workspace_get_neighbor (_tmp8_, direction);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	new_workspace = _tmp10_;
	_tmp11_ = active_workspace;
	_tmp12_ = new_workspace;
	if (_tmp11_ != _tmp12_) {
		MetaWorkspace* _tmp13_;
		_tmp13_ = new_workspace;
		meta_workspace_activate (_tmp13_, clutter_event_get_time (scroll_event));
	} else {
		gala_multitasking_view_play_nudge_animation (self, direction);
	}
	result = TRUE;
	_g_object_unref0 (new_workspace);
	_g_object_unref0 (active_workspace);
	return result;
}

static void
_vala_GValue_array_free (GValue * array,
                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}

void
gala_multitasking_view_play_nudge_animation (GalaMultitaskingView* self,
                                             MetaMotionDirection direction)
{
	GalaWindowManager* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp3_;
	MetaDisplay* _tmp4_;
	gint nudge_gap = 0;
	gfloat dest = 0.0F;
	gdouble* keyframes = NULL;
	gdouble* _tmp5_;
	gint keyframes_length1;
	gint _keyframes_size_;
	GValue* x = NULL;
	GValue _tmp6_ = {0};
	GValue* _tmp7_;
	gint x_length1;
	gint _x_size_;
	ClutterKeyframeTransition* nudge = NULL;
	ClutterKeyframeTransition* _tmp8_ = NULL;
	ClutterKeyframeTransition* _tmp9_;
	GValue _tmp10_ = {0};
	ClutterKeyframeTransition* _tmp11_;
	GValue _tmp12_ = {0};
	ClutterKeyframeTransition* _tmp13_;
	gdouble* _tmp14_;
	gint _tmp14__length1;
	ClutterKeyframeTransition* _tmp15_;
	GValue* _tmp16_;
	gint _tmp16__length1;
	ClutterActor* _tmp17_;
	ClutterKeyframeTransition* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_window_manager_get_enable_animations (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->display;
	_tmp4_ = self->priv->display;
	scale = meta_display_get_monitor_scale (_tmp3_, meta_display_get_primary_monitor (_tmp4_));
	nudge_gap = gala_internal_utils_scale_to_int (GALA_WINDOW_MANAGER_GALA_NUDGE_GAP, scale);
	dest = (gfloat) nudge_gap;
	if (direction == META_MOTION_RIGHT) {
		dest *= (gfloat) -1;
	}
	_tmp5_ = g_new0 (gdouble, 1);
	_tmp5_[0] = 0.5;
	keyframes = _tmp5_;
	keyframes_length1 = 1;
	_keyframes_size_ = keyframes_length1;
	g_value_init (&_tmp6_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp6_, dest);
	_tmp7_ = g_new0 (GValue, 1);
	_tmp7_[0] = _tmp6_;
	x = _tmp7_;
	x_length1 = 1;
	_x_size_ = x_length1;
	_tmp8_ = (ClutterKeyframeTransition*) clutter_keyframe_transition_new ("translation-x");
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp8_, (guint) GALA_ANIMATION_DURATION_NUDGE);
	clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp8_, TRUE);
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp8_, CLUTTER_EASE_IN_QUAD);
	nudge = _tmp8_;
	_tmp9_ = nudge;
	g_value_init (&_tmp10_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp10_, 0.0f);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp9_, &_tmp10_);
	G_IS_VALUE (&_tmp10_) ? (g_value_unset (&_tmp10_), NULL) : NULL;
	_tmp11_ = nudge;
	g_value_init (&_tmp12_, G_TYPE_FLOAT);
	g_value_set_float (&_tmp12_, 0.0f);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp11_, &_tmp12_);
	G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
	_tmp13_ = nudge;
	_tmp14_ = keyframes;
	_tmp14__length1 = keyframes_length1;
	clutter_keyframe_transition_set_key_frames (_tmp13_, (guint) _tmp14__length1, _tmp14_);
	_tmp15_ = nudge;
	_tmp16_ = x;
	_tmp16__length1 = x_length1;
	clutter_keyframe_transition_set_values (_tmp15_, (guint) _tmp16__length1, _tmp16_);
	_tmp17_ = self->priv->workspaces;
	_tmp18_ = nudge;
	clutter_actor_add_transition (_tmp17_, "nudge", (ClutterTransition*) _tmp18_);
	_g_object_unref0 (nudge);
	x = (_vala_GValue_array_free (x, x_length1), NULL);
	keyframes = (g_free (keyframes), NULL);
}

static void
gala_multitasking_view_on_multitasking_gesture_detected (GalaMultitaskingView* self,
                                                         GalaGesture* gesture)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	if (gesture->type != CLUTTER_TOUCHPAD_SWIPE) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (gesture->fingers == 3) {
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp3_ = gala_gesture_settings_get_string ("three-finger-swipe-up");
			_tmp4_ = _tmp3_;
			_tmp2_ = g_strcmp0 (_tmp4_, "multitasking-view") != 0;
			_g_free0 (_tmp4_);
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		if (gesture->fingers == 4) {
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = gala_gesture_settings_get_string ("four-finger-swipe-up");
			_tmp7_ = _tmp6_;
			_tmp5_ = g_strcmp0 (_tmp7_, "multitasking-view") != 0;
			_g_free0 (_tmp7_);
		} else {
			_tmp5_ = FALSE;
		}
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		return;
	}
	if (gesture->direction == GALA_GESTURE_DIRECTION_UP) {
		_tmp8_ = !self->priv->opened;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gala_multitasking_view_toggle (self, TRUE, FALSE);
	} else {
		gboolean _tmp9_ = FALSE;
		if (gesture->direction == GALA_GESTURE_DIRECTION_DOWN) {
			_tmp9_ = self->priv->opened;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			gala_multitasking_view_toggle (self, TRUE, FALSE);
		}
	}
}

static void
gala_multitasking_view_on_workspace_gesture_detected (GalaMultitaskingView* self,
                                                      GalaGesture* gesture)
{
	gboolean _tmp0_ = FALSE;
	gboolean can_handle_swipe = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean fingers = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	if (!self->priv->opened) {
		return;
	}
	if (gesture->type == CLUTTER_TOUCHPAD_SWIPE) {
		gboolean _tmp1_ = FALSE;
		if (gesture->direction == GALA_GESTURE_DIRECTION_LEFT) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = gesture->direction == GALA_GESTURE_DIRECTION_RIGHT;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	can_handle_swipe = _tmp0_;
	if (gesture->fingers == 3) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = gala_gesture_settings_get_string ("three-finger-swipe-horizontal");
		_tmp5_ = _tmp4_;
		_tmp3_ = g_strcmp0 (_tmp5_, "switch-to-workspace") == 0;
		_g_free0 (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		if (gesture->fingers == 4) {
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = gala_gesture_settings_get_string ("four-finger-swipe-horizontal");
			_tmp8_ = _tmp7_;
			_tmp6_ = g_strcmp0 (_tmp8_, "switch-to-workspace") == 0;
			_g_free0 (_tmp8_);
		} else {
			_tmp6_ = FALSE;
		}
		_tmp2_ = _tmp6_;
	}
	fingers = _tmp2_;
	if (gesture->type == CLUTTER_SCROLL) {
		_tmp9_ = TRUE;
	} else {
		gboolean _tmp10_ = FALSE;
		if (can_handle_swipe) {
			_tmp10_ = fingers;
		} else {
			_tmp10_ = FALSE;
		}
		_tmp9_ = _tmp10_;
	}
	if (_tmp9_) {
		MetaMotionDirection* direction = NULL;
		GalaGestureTracker* _tmp11_;
		GalaGestureSettings* _tmp12_;
		GalaGestureSettings* _tmp13_;
		MetaMotionDirection* _tmp14_;
		MetaMotionDirection* _tmp15_;
		_tmp11_ = self->priv->workspace_gesture_tracker;
		_tmp12_ = gala_gesture_tracker_get_settings (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gala_gesture_settings_get_natural_scroll_direction (_tmp13_, gesture);
		direction = _tmp14_;
		_tmp15_ = direction;
		gala_multitasking_view_switch_workspace_with_gesture (self, *_tmp15_);
		_g_free0 (direction);
	}
}

static Block60Data*
block60_data_ref (Block60Data* _data60_)
{
	g_atomic_int_inc (&_data60_->_ref_count_);
	return _data60_;
}

static void
block60_data_unref (void * _userdata_)
{
	Block60Data* _data60_;
	_data60_ = (Block60Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data60_->_ref_count_)) {
		GalaMultitaskingView* self;
		self = _data60_->self;
		_g_object_unref0 (self);
		g_slice_free (Block60Data, _data60_);
	}
}

static void
__lambda72_ (Block60Data* _data60_,
             gdouble percentage)
{
	GalaMultitaskingView* self;
	gfloat x = 0.0F;
	gfloat icon_group_opacity = 0.0F;
	ClutterActor* _tmp0_;
	self = _data60_->self;
	x = gala_gesture_tracker_animation_value (_data60_->initial_x, _data60_->target_x, percentage, TRUE);
	icon_group_opacity = gala_gesture_tracker_animation_value (0.0f, 1.0f, percentage, FALSE);
	if (_data60_->is_nudge_animation) {
		x = CLAMP (x, _data60_->initial_x - _data60_->nudge_gap, _data60_->initial_x + _data60_->nudge_gap);
	}
	_tmp0_ = self->priv->workspaces;
	clutter_actor_set_x (_tmp0_, x);
	if (!_data60_->is_nudge_animation) {
		GalaIconGroup* _tmp1_;
		GalaIconGroup* _tmp2_;
		_tmp1_ = _data60_->active_icon_group;
		gala_icon_group_set_backdrop_opacity (_tmp1_, 1.0f - icon_group_opacity);
		_tmp2_ = _data60_->target_icon_group;
		gala_icon_group_set_backdrop_opacity (_tmp2_, icon_group_opacity);
	}
}

static void
___lambda72__gala_gesture_tracker_on_update (gdouble percentage,
                                             gpointer self)
{
	__lambda72_ (self, percentage);
}

static void
__lambda73_ (Block60Data* _data60_,
             gdouble percentage,
             gboolean cancel_action,
             gint calculated_duration)
{
	GalaMultitaskingView* self;
	guint _tmp0_ = 0U;
	guint duration = 0U;
	ClutterActor* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	gfloat _tmp4_ = 0.0F;
	gboolean _tmp5_ = FALSE;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	gboolean _tmp37_ = FALSE;
	self = _data60_->self;
	self->priv->switching_workspace_with_gesture = FALSE;
	if (_data60_->is_nudge_animation) {
		_tmp0_ = (guint) (GALA_ANIMATION_DURATION_NUDGE / 2);
	} else {
		_tmp0_ = (guint) calculated_duration;
	}
	duration = _tmp0_;
	_tmp1_ = self->priv->workspaces;
	clutter_actor_save_easing_state (_tmp1_);
	_tmp2_ = self->priv->workspaces;
	clutter_actor_set_easing_mode (_tmp2_, CLUTTER_EASE_OUT_QUAD);
	_tmp3_ = self->priv->workspaces;
	clutter_actor_set_easing_duration (_tmp3_, duration);
	if (_data60_->is_nudge_animation) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = cancel_action;
	}
	if (_tmp5_) {
		_tmp4_ = _data60_->initial_x;
	} else {
		_tmp4_ = _data60_->target_x;
	}
	_tmp6_ = self->priv->workspaces;
	clutter_actor_set_x (_tmp6_, _tmp4_);
	_tmp7_ = self->priv->workspaces;
	clutter_actor_restore_easing_state (_tmp7_);
	if (!_data60_->is_nudge_animation) {
		GalaWindowManager* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = self->priv->_wm;
		_tmp9_ = gala_window_manager_get_enable_animations (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_) {
			ClutterPropertyTransition* active_transition = NULL;
			ClutterPropertyTransition* _tmp11_ = NULL;
			ClutterPropertyTransition* _tmp12_;
			GalaIconGroup* _tmp13_;
			gfloat _tmp14_;
			gfloat _tmp15_;
			GValue _tmp16_ = {0};
			gfloat _tmp17_ = 0.0F;
			ClutterPropertyTransition* _tmp18_;
			GValue _tmp19_ = {0};
			GalaIconGroup* _tmp20_;
			ClutterPropertyTransition* _tmp21_;
			ClutterPropertyTransition* target_transition = NULL;
			ClutterPropertyTransition* _tmp22_ = NULL;
			ClutterPropertyTransition* _tmp23_;
			GalaIconGroup* _tmp24_;
			gfloat _tmp25_;
			gfloat _tmp26_;
			GValue _tmp27_ = {0};
			gfloat _tmp28_ = 0.0F;
			ClutterPropertyTransition* _tmp29_;
			GValue _tmp30_ = {0};
			GalaIconGroup* _tmp31_;
			ClutterPropertyTransition* _tmp32_;
			_tmp11_ = (ClutterPropertyTransition*) clutter_property_transition_new ("backdrop-opacity");
			clutter_timeline_set_duration ((ClutterTimeline*) _tmp11_, duration);
			clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp11_, TRUE);
			active_transition = _tmp11_;
			_tmp12_ = active_transition;
			_tmp13_ = _data60_->active_icon_group;
			_tmp14_ = gala_icon_group_get_backdrop_opacity (_tmp13_);
			_tmp15_ = _tmp14_;
			g_value_init (&_tmp16_, G_TYPE_FLOAT);
			g_value_set_float (&_tmp16_, _tmp15_);
			clutter_transition_set_from_value ((ClutterTransition*) _tmp12_, &_tmp16_);
			G_IS_VALUE (&_tmp16_) ? (g_value_unset (&_tmp16_), NULL) : NULL;
			if (cancel_action) {
				_tmp17_ = 1.0f;
			} else {
				_tmp17_ = 0.0f;
			}
			_tmp18_ = active_transition;
			g_value_init (&_tmp19_, G_TYPE_FLOAT);
			g_value_set_float (&_tmp19_, _tmp17_);
			clutter_transition_set_to_value ((ClutterTransition*) _tmp18_, &_tmp19_);
			G_IS_VALUE (&_tmp19_) ? (g_value_unset (&_tmp19_), NULL) : NULL;
			_tmp20_ = _data60_->active_icon_group;
			_tmp21_ = active_transition;
			clutter_actor_add_transition ((ClutterActor*) _tmp20_, "backdrop-opacity", (ClutterTransition*) _tmp21_);
			_tmp22_ = (ClutterPropertyTransition*) clutter_property_transition_new ("backdrop-opacity");
			clutter_timeline_set_duration ((ClutterTimeline*) _tmp22_, duration);
			clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp22_, TRUE);
			target_transition = _tmp22_;
			_tmp23_ = target_transition;
			_tmp24_ = _data60_->target_icon_group;
			_tmp25_ = gala_icon_group_get_backdrop_opacity (_tmp24_);
			_tmp26_ = _tmp25_;
			g_value_init (&_tmp27_, G_TYPE_FLOAT);
			g_value_set_float (&_tmp27_, _tmp26_);
			clutter_transition_set_from_value ((ClutterTransition*) _tmp23_, &_tmp27_);
			G_IS_VALUE (&_tmp27_) ? (g_value_unset (&_tmp27_), NULL) : NULL;
			if (cancel_action) {
				_tmp28_ = 0.0f;
			} else {
				_tmp28_ = 1.0f;
			}
			_tmp29_ = target_transition;
			g_value_init (&_tmp30_, G_TYPE_FLOAT);
			g_value_set_float (&_tmp30_, _tmp28_);
			clutter_transition_set_to_value ((ClutterTransition*) _tmp29_, &_tmp30_);
			G_IS_VALUE (&_tmp30_) ? (g_value_unset (&_tmp30_), NULL) : NULL;
			_tmp31_ = _data60_->target_icon_group;
			_tmp32_ = target_transition;
			clutter_actor_add_transition ((ClutterActor*) _tmp31_, "backdrop-opacity", (ClutterTransition*) _tmp32_);
			_g_object_unref0 (target_transition);
			_g_object_unref0 (active_transition);
		} else {
			gfloat _tmp33_ = 0.0F;
			GalaIconGroup* _tmp34_;
			gfloat _tmp35_ = 0.0F;
			GalaIconGroup* _tmp36_;
			if (cancel_action) {
				_tmp33_ = 1.0f;
			} else {
				_tmp33_ = 0.0f;
			}
			_tmp34_ = _data60_->active_icon_group;
			gala_icon_group_set_backdrop_opacity (_tmp34_, _tmp33_);
			if (cancel_action) {
				_tmp35_ = 0.0f;
			} else {
				_tmp35_ = 1.0f;
			}
			_tmp36_ = _data60_->target_icon_group;
			gala_icon_group_set_backdrop_opacity (_tmp36_, _tmp35_);
		}
	}
	if (_data60_->is_nudge_animation) {
		_tmp37_ = TRUE;
	} else {
		_tmp37_ = cancel_action;
	}
	if (_tmp37_) {
		MetaWorkspace* _tmp38_;
		MetaDisplay* _tmp39_;
		_tmp38_ = _data60_->active_workspace;
		_tmp39_ = self->priv->display;
		meta_workspace_activate (_tmp38_, meta_display_get_current_time (_tmp39_));
	}
}

static void
___lambda73__gala_gesture_tracker_on_end (gdouble percentage,
                                          gboolean cancel_action,
                                          gint calculated_duration,
                                          gpointer self)
{
	__lambda73_ (self, percentage, cancel_action, calculated_duration);
}

static void
gala_multitasking_view_switch_workspace_with_gesture (GalaMultitaskingView* self,
                                                      MetaMotionDirection direction)
{
	Block60Data* _data60_;
	gboolean _tmp0_;
	gboolean _tmp1_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp2_;
	MetaWorkspaceManager* _tmp3_;
	gint num_workspaces = 0;
	MetaWorkspaceManager* _tmp4_;
	gint _tmp5_ = 0;
	gint relative_dir = 0;
	MetaWorkspaceManager* _tmp6_;
	MetaWorkspace* _tmp7_;
	gint target_workspace_index = 0;
	MetaWorkspace* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean target_workspace_exists = FALSE;
	MetaWorkspace* target_workspace = NULL;
	MetaWorkspaceManager* _tmp10_;
	MetaWorkspace* _tmp11_;
	ClutterActor* _tmp12_;
	gfloat _tmp13_;
	gfloat _tmp14_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp15_;
	MetaDisplay* _tmp16_;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp42_ = FALSE;
	MetaWorkspace* _tmp46_;
	const gchar* _tmp47_ = NULL;
	MetaWorkspace* _tmp48_;
	GalaGestureTrackerOnUpdate on_animation_update = NULL;
	gpointer on_animation_update_target;
	GDestroyNotify on_animation_update_target_destroy_notify;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	GalaWindowManager* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	g_return_if_fail (self != NULL);
	_data60_ = g_slice_new0 (Block60Data);
	_data60_->_ref_count_ = 1;
	_data60_->self = g_object_ref (self);
	_tmp0_ = gala_multitasking_view_get_switching_workspace_in_progress (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		block60_data_unref (_data60_);
		_data60_ = NULL;
		return;
	}
	_tmp2_ = self->priv->display;
	_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
	manager = _tmp3_;
	_tmp4_ = manager;
	num_workspaces = meta_workspace_manager_get_n_workspaces (_tmp4_);
	if (direction == META_MOTION_LEFT) {
		_tmp5_ = -1;
	} else {
		_tmp5_ = 1;
	}
	relative_dir = _tmp5_;
	_tmp6_ = manager;
	_tmp7_ = meta_workspace_manager_get_active_workspace (_tmp6_);
	_data60_->active_workspace = _tmp7_;
	_tmp8_ = _data60_->active_workspace;
	target_workspace_index = meta_workspace_index (_tmp8_) + relative_dir;
	if (target_workspace_index >= 0) {
		_tmp9_ = target_workspace_index < num_workspaces;
	} else {
		_tmp9_ = FALSE;
	}
	target_workspace_exists = _tmp9_;
	_tmp10_ = manager;
	_tmp11_ = meta_workspace_manager_get_workspace_by_index (_tmp10_, target_workspace_index);
	target_workspace = _tmp11_;
	_tmp12_ = self->priv->workspaces;
	_tmp13_ = clutter_actor_get_x (_tmp12_);
	_tmp14_ = _tmp13_;
	_data60_->initial_x = _tmp14_;
	_data60_->target_x = (gfloat) 0;
	_data60_->is_nudge_animation = !target_workspace_exists;
	_tmp15_ = self->priv->display;
	_tmp16_ = self->priv->display;
	scale = meta_display_get_monitor_scale (_tmp15_, meta_display_get_primary_monitor (_tmp16_));
	_data60_->nudge_gap = gala_internal_utils_scale_to_int (GALA_WINDOW_MANAGER_GALA_NUDGE_GAP, scale);
	_data60_->active_icon_group = NULL;
	_data60_->target_icon_group = NULL;
	if (_data60_->is_nudge_animation) {
		MtkRectangle workspaces_geometry = {0};
		MetaDisplay* _tmp17_;
		MtkRectangle _tmp18_ = {0};
		MtkRectangle _tmp19_;
		_tmp17_ = self->priv->display;
		gala_internal_utils_get_workspaces_geometry (_tmp17_, &_tmp18_);
		workspaces_geometry = _tmp18_;
		_tmp19_ = workspaces_geometry;
		_data60_->target_x = _data60_->initial_x + (_tmp19_.width * (-relative_dir));
	} else {
		ClutterActor* _tmp20_;
		GList* _tmp21_;
		_tmp20_ = self->priv->workspaces;
		_tmp21_ = clutter_actor_get_children (_tmp20_);
		{
			GList* child_collection = NULL;
			GList* child_it = NULL;
			child_collection = _tmp21_;
			for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
				ClutterActor* child = NULL;
				child = (ClutterActor*) child_it->data;
				{
					GalaWorkspaceClone* workspace_clone = NULL;
					ClutterActor* _tmp22_;
					MetaWorkspace* workspace = NULL;
					GalaWorkspaceClone* _tmp23_;
					MetaWorkspace* _tmp24_;
					MetaWorkspace* _tmp25_;
					MetaWorkspace* _tmp26_;
					MetaWorkspace* _tmp27_;
					MetaWorkspace* _tmp28_;
					_tmp22_ = child;
					workspace_clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
					_tmp23_ = workspace_clone;
					_tmp24_ = gala_workspace_clone_get_workspace (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = _g_object_ref0 (_tmp25_);
					workspace = _tmp26_;
					_tmp27_ = workspace;
					_tmp28_ = target_workspace;
					if (_tmp27_ == _tmp28_) {
						GalaWorkspaceClone* _tmp29_;
						GalaIconGroup* _tmp30_;
						GalaIconGroup* _tmp31_;
						GalaWorkspaceClone* _tmp32_;
						_tmp29_ = workspace_clone;
						_tmp30_ = gala_workspace_clone_get_icon_group (_tmp29_);
						_tmp31_ = _tmp30_;
						_data60_->target_icon_group = _tmp31_;
						_tmp32_ = workspace_clone;
						_data60_->target_x = -gala_workspace_clone_multitasking_view_x (_tmp32_);
					} else {
						MetaWorkspace* _tmp33_;
						MetaWorkspace* _tmp34_;
						_tmp33_ = workspace;
						_tmp34_ = _data60_->active_workspace;
						if (_tmp33_ == _tmp34_) {
							GalaWorkspaceClone* _tmp35_;
							GalaIconGroup* _tmp36_;
							GalaIconGroup* _tmp37_;
							_tmp35_ = workspace_clone;
							_tmp36_ = gala_workspace_clone_get_icon_group (_tmp35_);
							_tmp37_ = _tmp36_;
							_data60_->active_icon_group = _tmp37_;
						}
					}
					_g_object_unref0 (workspace);
				}
			}
			(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
		}
	}
	if (!_data60_->is_nudge_animation) {
		GalaIconGroup* _tmp39_;
		ClutterTransition* _tmp40_;
		_tmp39_ = _data60_->active_icon_group;
		_tmp40_ = clutter_actor_get_transition ((ClutterActor*) _tmp39_, "backdrop-opacity");
		_tmp38_ = _tmp40_ != NULL;
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		GalaIconGroup* _tmp41_;
		_tmp41_ = _data60_->active_icon_group;
		clutter_actor_remove_transition ((ClutterActor*) _tmp41_, "backdrop-opacity");
	}
	if (!_data60_->is_nudge_animation) {
		GalaIconGroup* _tmp43_;
		ClutterTransition* _tmp44_;
		_tmp43_ = _data60_->target_icon_group;
		_tmp44_ = clutter_actor_get_transition ((ClutterActor*) _tmp43_, "backdrop-opacity");
		_tmp42_ = _tmp44_ != NULL;
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		GalaIconGroup* _tmp45_;
		_tmp45_ = _data60_->target_icon_group;
		clutter_actor_remove_transition ((ClutterActor*) _tmp45_, "backdrop-opacity");
	}
	g_debug ("MultitaskingView.vala:373: Starting MultitaskingView switch workspace " \
"animation:");
	_tmp46_ = _data60_->active_workspace;
	g_debug ("MultitaskingView.vala:374: Active workspace index: %d", meta_workspace_index (_tmp46_));
	g_debug ("MultitaskingView.vala:375: Target workspace index: %d", target_workspace_index);
	g_debug ("MultitaskingView.vala:376: Total number of workspaces: %d", num_workspaces);
	if (_data60_->is_nudge_animation) {
		_tmp47_ = "Yes";
	} else {
		_tmp47_ = "No";
	}
	g_debug ("MultitaskingView.vala:377: Is nudge animation: %s", _tmp47_);
	g_debug ("MultitaskingView.vala:378: Initial X: %f", (gdouble) _data60_->initial_x);
	g_debug ("MultitaskingView.vala:379: Target X: %f", (gdouble) _data60_->target_x);
	self->priv->switching_workspace_with_gesture = TRUE;
	_tmp48_ = target_workspace;
	if (_tmp48_ != NULL) {
		MetaWorkspace* _tmp49_;
		MetaDisplay* _tmp50_;
		_tmp49_ = target_workspace;
		_tmp50_ = self->priv->display;
		meta_workspace_activate (_tmp49_, meta_display_get_current_time (_tmp50_));
	}
	on_animation_update = ___lambda72__gala_gesture_tracker_on_update;
	on_animation_update_target = block60_data_ref (_data60_);
	on_animation_update_target_destroy_notify = block60_data_unref;
	on_animation_end = ___lambda73__gala_gesture_tracker_on_end;
	on_animation_end_target = block60_data_ref (_data60_);
	on_animation_end_target_destroy_notify = block60_data_unref;
	_tmp51_ = self->priv->_wm;
	_tmp52_ = gala_window_manager_get_enable_animations (_tmp51_);
	_tmp53_ = _tmp52_;
	if (!_tmp53_) {
		GalaGestureTrackerOnEnd _tmp54_;
		gpointer _tmp54__target;
		_tmp54_ = on_animation_end;
		_tmp54__target = on_animation_end_target;
		_tmp54_ ((gdouble) 1, FALSE, 0, _tmp54__target);
	} else {
		GalaGestureTracker* _tmp55_;
		GalaGestureTrackerOnUpdate _tmp56_;
		gpointer _tmp56__target;
		GDestroyNotify _tmp56__target_destroy_notify;
		GalaGestureTrackerOnEnd _tmp57_;
		gpointer _tmp57__target;
		GDestroyNotify _tmp57__target_destroy_notify;
		_tmp55_ = self->priv->workspace_gesture_tracker;
		_tmp56_ = on_animation_update;
		_tmp56__target = on_animation_update_target;
		_tmp56__target_destroy_notify = on_animation_update_target_destroy_notify;
		on_animation_update = NULL;
		on_animation_update_target = NULL;
		on_animation_update_target_destroy_notify = NULL;
		_tmp57_ = on_animation_end;
		_tmp57__target = on_animation_end_target;
		_tmp57__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp55_, NULL, NULL, NULL, _tmp56_, _tmp56__target, _tmp56__target_destroy_notify, _tmp57_, _tmp57__target, _tmp57__target_destroy_notify);
	}
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
	on_animation_update = NULL;
	on_animation_update_target = NULL;
	on_animation_update_target_destroy_notify = NULL;
	block60_data_unref (_data60_);
	_data60_ = NULL;
}

/**
         * Places the WorkspaceClones, moves the view so that the active one is shown
         * and does the same for the IconGroups.
         *
         * @param animate Whether to animate the movement or have all elements take their
         *                positions immediately.
         */
static void
gala_multitasking_view_update_positions (GalaMultitaskingView* self,
                                         gboolean animate)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspace* active_workspace = NULL;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* _tmp3_;
	MetaWorkspace* _tmp4_;
	gfloat active_x = 0.0F;
	ClutterActor* _tmp5_;
	GList* _tmp6_;
	ClutterActor* _tmp30_;
	ClutterActor* _tmp31_;
	GalaAnimationDuration _tmp32_ = 0;
	gboolean _tmp33_ = FALSE;
	ClutterActor* _tmp37_;
	ClutterActor* _tmp38_;
	ClutterActor* _tmp39_;
	g_return_if_fail (self != NULL);
	if (self->priv->switching_workspace_with_gesture) {
		return;
	}
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = manager;
	_tmp3_ = meta_workspace_manager_get_active_workspace (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	active_workspace = _tmp4_;
	active_x = 0.0f;
	_tmp5_ = self->priv->workspaces;
	_tmp6_ = clutter_actor_get_children (_tmp5_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp6_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace_clone = NULL;
				ClutterActor* _tmp7_;
				MetaWorkspace* workspace = NULL;
				GalaWorkspaceClone* _tmp8_;
				MetaWorkspace* _tmp9_;
				MetaWorkspace* _tmp10_;
				MetaWorkspace* _tmp11_;
				gfloat dest_x = 0.0F;
				GalaWorkspaceClone* _tmp12_;
				MetaWorkspace* _tmp13_;
				MetaWorkspace* _tmp14_;
				GalaWorkspaceClone* _tmp21_;
				gint _tmp22_ = 0;
				gboolean _tmp23_ = FALSE;
				GalaWorkspaceClone* _tmp27_;
				GalaWorkspaceClone* _tmp28_;
				GalaWorkspaceClone* _tmp29_;
				_tmp7_ = child;
				workspace_clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp8_ = workspace_clone;
				_tmp9_ = gala_workspace_clone_get_workspace (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				workspace = _tmp11_;
				_tmp12_ = workspace_clone;
				dest_x = gala_workspace_clone_multitasking_view_x (_tmp12_);
				_tmp13_ = workspace;
				_tmp14_ = active_workspace;
				if (_tmp13_ == _tmp14_) {
					GalaWorkspaceClone* _tmp15_;
					GalaIconGroup* _tmp16_;
					GalaIconGroup* _tmp17_;
					active_x = dest_x;
					_tmp15_ = workspace_clone;
					_tmp16_ = gala_workspace_clone_get_icon_group (_tmp15_);
					_tmp17_ = _tmp16_;
					gala_icon_group_set_backdrop_opacity (_tmp17_, 1.0f);
				} else {
					GalaWorkspaceClone* _tmp18_;
					GalaIconGroup* _tmp19_;
					GalaIconGroup* _tmp20_;
					_tmp18_ = workspace_clone;
					_tmp19_ = gala_workspace_clone_get_icon_group (_tmp18_);
					_tmp20_ = _tmp19_;
					gala_icon_group_set_backdrop_opacity (_tmp20_, 0.0f);
				}
				_tmp21_ = workspace_clone;
				clutter_actor_save_easing_state ((ClutterActor*) _tmp21_);
				if (animate) {
					GalaWindowManager* _tmp24_;
					gboolean _tmp25_;
					gboolean _tmp26_;
					_tmp24_ = self->priv->_wm;
					_tmp25_ = gala_window_manager_get_enable_animations (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp23_ = _tmp26_;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					_tmp22_ = 200;
				} else {
					_tmp22_ = 0;
				}
				_tmp27_ = workspace_clone;
				clutter_actor_set_easing_duration ((ClutterActor*) _tmp27_, (guint) _tmp22_);
				_tmp28_ = workspace_clone;
				clutter_actor_set_x ((ClutterActor*) _tmp28_, dest_x);
				_tmp29_ = workspace_clone;
				clutter_actor_restore_easing_state ((ClutterActor*) _tmp29_);
				_g_object_unref0 (workspace);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp30_ = self->priv->workspaces;
	clutter_actor_save_easing_state (_tmp30_);
	_tmp31_ = self->priv->workspaces;
	clutter_actor_set_easing_mode (_tmp31_, CLUTTER_EASE_OUT_QUAD);
	if (animate) {
		GalaWindowManager* _tmp34_;
		gboolean _tmp35_;
		gboolean _tmp36_;
		_tmp34_ = self->priv->_wm;
		_tmp35_ = gala_window_manager_get_enable_animations (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp33_ = _tmp36_;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		_tmp32_ = GALA_ANIMATION_DURATION_WORKSPACE_SWITCH_MIN;
	} else {
		_tmp32_ = 0;
	}
	_tmp37_ = self->priv->workspaces;
	clutter_actor_set_easing_duration (_tmp37_, (guint) _tmp32_);
	_tmp38_ = self->priv->workspaces;
	clutter_actor_set_x (_tmp38_, -active_x);
	_tmp39_ = self->priv->workspaces;
	clutter_actor_restore_easing_state (_tmp39_);
	gala_multitasking_view_reposition_icon_groups (self, animate);
	_g_object_unref0 (active_workspace);
}

static void
gala_multitasking_view_reposition_icon_groups (GalaMultitaskingView* self,
                                               gboolean animate)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	gint active_index = 0;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* _tmp3_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp7_;
	MetaDisplay* _tmp8_;
	gfloat icon_groups_width = 0.0F;
	GalaIconGroupContainer* _tmp9_;
	ClutterActor* _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = manager;
	_tmp3_ = meta_workspace_manager_get_active_workspace (_tmp2_);
	active_index = meta_workspace_index (_tmp3_);
	if (animate) {
		GalaIconGroupContainer* _tmp4_;
		GalaIconGroupContainer* _tmp5_;
		GalaIconGroupContainer* _tmp6_;
		_tmp4_ = self->priv->icon_groups;
		clutter_actor_save_easing_state ((ClutterActor*) _tmp4_);
		_tmp5_ = self->priv->icon_groups;
		clutter_actor_set_easing_mode ((ClutterActor*) _tmp5_, CLUTTER_EASE_OUT_QUAD);
		_tmp6_ = self->priv->icon_groups;
		clutter_actor_set_easing_duration ((ClutterActor*) _tmp6_, (guint) 200);
	}
	_tmp7_ = self->priv->display;
	_tmp8_ = self->priv->display;
	scale = meta_display_get_monitor_scale (_tmp7_, meta_display_get_primary_monitor (_tmp8_));
	_tmp9_ = self->priv->icon_groups;
	icon_groups_width = gala_icon_group_container_calculate_total_width (_tmp9_);
	_tmp10_ = self->priv->primary_monitor_container;
	_tmp11_ = clutter_actor_get_width (_tmp10_);
	_tmp12_ = _tmp11_;
	if (icon_groups_width > _tmp12_) {
		GalaIconGroupContainer* _tmp13_;
		ClutterActor* _tmp14_;
		gfloat _tmp15_;
		gfloat _tmp16_;
		ClutterActor* _tmp17_;
		gfloat _tmp18_;
		gfloat _tmp19_;
		_tmp13_ = self->priv->icon_groups;
		_tmp14_ = self->priv->primary_monitor_container;
		_tmp15_ = clutter_actor_get_width (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->primary_monitor_container;
		_tmp18_ = clutter_actor_get_width (_tmp17_);
		_tmp19_ = _tmp18_;
		clutter_actor_set_x ((ClutterActor*) _tmp13_, CLAMP (((-active_index) * gala_internal_utils_scale_to_int (GALA_ICON_GROUP_CONTAINER_SPACING + GALA_ICON_GROUP_SIZE, scale)) + (_tmp16_ / 2), (_tmp19_ - icon_groups_width) - gala_internal_utils_scale_to_int (64, scale), (gfloat) gala_internal_utils_scale_to_int (64, scale)));
	} else {
		GalaIconGroupContainer* _tmp20_;
		ClutterActor* _tmp21_;
		gfloat _tmp22_;
		gfloat _tmp23_;
		_tmp20_ = self->priv->icon_groups;
		_tmp21_ = self->priv->primary_monitor_container;
		_tmp22_ = clutter_actor_get_width (_tmp21_);
		_tmp23_ = _tmp22_;
		clutter_actor_set_x ((ClutterActor*) _tmp20_, (_tmp23_ / 2) - (icon_groups_width / 2));
	}
	if (animate) {
		GalaIconGroupContainer* _tmp24_;
		_tmp24_ = self->priv->icon_groups;
		clutter_actor_restore_easing_state ((ClutterActor*) _tmp24_);
	}
}

static void
_gala_multitasking_view_window_selected_gala_workspace_clone_window_selected (GalaWorkspaceClone* _sender,
                                                                              MetaWindow* window,
                                                                              gpointer self)
{
	gala_multitasking_view_window_selected ((GalaMultitaskingView*) self, window);
}

static void
_gala_multitasking_view_activate_workspace_gala_workspace_clone_selected (GalaWorkspaceClone* _sender,
                                                                          gboolean close_view,
                                                                          gpointer self)
{
	gala_multitasking_view_activate_workspace ((GalaMultitaskingView*) self, _sender, close_view);
}

static void
gala_multitasking_view_add_workspace (GalaMultitaskingView* self,
                                      gint num)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	GalaWorkspaceClone* workspace = NULL;
	GalaWindowManager* _tmp4_;
	MetaWorkspaceManager* _tmp5_;
	MetaWorkspace* _tmp6_;
	GalaGestureTracker* _tmp7_;
	GalaWorkspaceClone* _tmp8_;
	ClutterActor* _tmp9_;
	GalaWorkspaceClone* _tmp10_;
	GalaIconGroupContainer* _tmp11_;
	GalaWorkspaceClone* _tmp12_;
	GalaIconGroup* _tmp13_;
	GalaIconGroup* _tmp14_;
	GalaWorkspaceClone* _tmp15_;
	GalaWorkspaceClone* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = self->priv->display;
	_tmp3_ = self->priv->display;
	scale = meta_display_get_monitor_scale (_tmp2_, meta_display_get_primary_monitor (_tmp3_));
	_tmp4_ = self->priv->_wm;
	_tmp5_ = manager;
	_tmp6_ = meta_workspace_manager_get_workspace_by_index (_tmp5_, num);
	_tmp7_ = self->priv->multitasking_gesture_tracker;
	_tmp8_ = gala_workspace_clone_new (_tmp4_, _tmp6_, _tmp7_, scale);
	g_object_ref_sink (_tmp8_);
	workspace = _tmp8_;
	_tmp9_ = self->priv->workspaces;
	_tmp10_ = workspace;
	clutter_actor_insert_child_at_index (_tmp9_, (ClutterActor*) _tmp10_, num);
	_tmp11_ = self->priv->icon_groups;
	_tmp12_ = workspace;
	_tmp13_ = gala_workspace_clone_get_icon_group (_tmp12_);
	_tmp14_ = _tmp13_;
	gala_icon_group_container_add_group (_tmp11_, _tmp14_);
	_tmp15_ = workspace;
	g_signal_connect_object (_tmp15_, "window-selected", (GCallback) _gala_multitasking_view_window_selected_gala_workspace_clone_window_selected, self, 0);
	_tmp16_ = workspace;
	g_signal_connect_object (_tmp16_, "selected", (GCallback) _gala_multitasking_view_activate_workspace_gala_workspace_clone_selected, self, 0);
	gala_multitasking_view_update_positions (self, FALSE);
	if (self->priv->opened) {
		GalaWorkspaceClone* _tmp17_;
		_tmp17_ = workspace;
		gala_workspace_clone_open (_tmp17_, FALSE, FALSE);
	}
	_g_object_unref0 (workspace);
}

static void
gala_multitasking_view_remove_workspace (GalaMultitaskingView* self,
                                         gint num)
{
	GalaWorkspaceClone* workspace = NULL;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	GList* existing_workspaces = NULL;
	ClutterActor* _tmp8_;
	GList* _tmp9_;
	GalaWorkspaceClone* _tmp17_;
	GalaWorkspaceClone* _tmp18_;
	guint _tmp19_;
	GalaWorkspaceClone* _tmp20_;
	guint _tmp21_;
	GalaIconGroupContainer* _tmp22_;
	GalaWorkspaceClone* _tmp23_;
	GalaIconGroup* _tmp24_;
	GalaIconGroup* _tmp25_;
	GalaWorkspaceClone* _tmp30_;
	g_return_if_fail (self != NULL);
	workspace = NULL;
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	existing_workspaces = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp4_;
				MetaWorkspaceManager* _tmp5_;
				MetaWorkspace* _tmp6_;
				MetaWorkspace* _tmp7_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp4_))) {
					break;
				}
				_tmp5_ = manager;
				_tmp6_ = meta_workspace_manager_get_workspace_by_index (_tmp5_, i);
				_tmp7_ = _g_object_ref0 (_tmp6_);
				existing_workspaces = g_list_append (existing_workspaces, _tmp7_);
			}
		}
	}
	_tmp8_ = self->priv->workspaces;
	_tmp9_ = clutter_actor_get_children (_tmp8_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp9_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* clone = NULL;
				ClutterActor* _tmp10_;
				GList* _tmp11_;
				GalaWorkspaceClone* _tmp12_;
				MetaWorkspace* _tmp13_;
				MetaWorkspace* _tmp14_;
				_tmp10_ = child;
				clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp11_ = existing_workspaces;
				_tmp12_ = clone;
				_tmp13_ = gala_workspace_clone_get_workspace (_tmp12_);
				_tmp14_ = _tmp13_;
				if (g_list_index (_tmp11_, _tmp14_) < 0) {
					GalaWorkspaceClone* _tmp15_;
					GalaWorkspaceClone* _tmp16_;
					_tmp15_ = clone;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					_g_object_unref0 (workspace);
					workspace = _tmp16_;
					break;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp17_ = workspace;
	if (_tmp17_ == NULL) {
		(existing_workspaces == NULL) ? NULL : (existing_workspaces = (_g_list_free__g_object_unref0_ (existing_workspaces), NULL));
		_g_object_unref0 (workspace);
		return;
	}
	_tmp18_ = workspace;
	g_signal_parse_name ("window-selected", GALA_TYPE_WORKSPACE_CLONE, &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _gala_multitasking_view_window_selected_gala_workspace_clone_window_selected, self);
	_tmp20_ = workspace;
	g_signal_parse_name ("selected", GALA_TYPE_WORKSPACE_CLONE, &_tmp21_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp20_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp21_, 0, NULL, (GCallback) _gala_multitasking_view_activate_workspace_gala_workspace_clone_selected, self);
	_tmp22_ = self->priv->icon_groups;
	_tmp23_ = workspace;
	_tmp24_ = gala_workspace_clone_get_icon_group (_tmp23_);
	_tmp25_ = _tmp24_;
	if (clutter_actor_contains ((ClutterActor*) _tmp22_, (ClutterActor*) _tmp25_)) {
		GalaIconGroupContainer* _tmp26_;
		GalaWorkspaceClone* _tmp27_;
		GalaIconGroup* _tmp28_;
		GalaIconGroup* _tmp29_;
		_tmp26_ = self->priv->icon_groups;
		_tmp27_ = workspace;
		_tmp28_ = gala_workspace_clone_get_icon_group (_tmp27_);
		_tmp29_ = _tmp28_;
		gala_icon_group_container_remove_group (_tmp26_, _tmp29_);
	}
	_tmp30_ = workspace;
	clutter_actor_destroy ((ClutterActor*) _tmp30_);
	gala_multitasking_view_update_positions (self, self->priv->opened);
	(existing_workspaces == NULL) ? NULL : (existing_workspaces = (_g_list_free__g_object_unref0_ (existing_workspaces), NULL));
	_g_object_unref0 (workspace);
}

/**
         * Activates the workspace of a WorkspaceClone
         *
         * @param close_view Whether to close the view as well. Will only be considered
         *                   if the workspace is also the currently active workspace.
         *                   Otherwise it will only be made active, but the view won't be
         *                   closed.
         */
static void
gala_multitasking_view_activate_workspace (GalaMultitaskingView* self,
                                           GalaWorkspaceClone* clone,
                                           gboolean close_view)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	gboolean _tmp2_ = FALSE;
	MetaWorkspace* _tmp7_;
	MetaWorkspace* _tmp8_;
	MetaDisplay* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clone != NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	if (close_view) {
		MetaWorkspaceManager* _tmp3_;
		MetaWorkspace* _tmp4_;
		MetaWorkspace* _tmp5_;
		MetaWorkspace* _tmp6_;
		_tmp3_ = manager;
		_tmp4_ = meta_workspace_manager_get_active_workspace (_tmp3_);
		_tmp5_ = gala_workspace_clone_get_workspace (clone);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp4_ == _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	close_view = _tmp2_;
	_tmp7_ = gala_workspace_clone_get_workspace (clone);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->display;
	meta_workspace_activate (_tmp8_, meta_display_get_current_time (_tmp9_));
	if (close_view) {
		gala_multitasking_view_toggle (self, FALSE, FALSE);
	}
}

/**
         * Collect key events, mainly for redirecting them to the WindowCloneContainers to
         * select the active window.
         */
static gboolean
gala_multitasking_view_real_key_press_event (ClutterActor* base,
                                             ClutterEvent* event)
{
	GalaMultitaskingView * self;
	GalaWindowCloneContainer* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean result;
	self = (GalaMultitaskingView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->opened) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	_tmp0_ = gala_multitasking_view_get_active_window_clone_container (self);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name ((ClutterActor*) _tmp1_, "key-press-event", event, &_tmp2_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

/**
         * Finds the active WorkspaceClone
         *
         * @return The active WorkspaceClone
         */
static GalaWindowCloneContainer*
gala_multitasking_view_get_active_window_clone_container (GalaMultitaskingView* self)
{
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspace* active_workspace = NULL;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* _tmp3_;
	ClutterActor* _tmp4_;
	GList* _tmp5_;
	GalaWindowCloneContainer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = manager;
	_tmp3_ = meta_workspace_manager_get_active_workspace (_tmp2_);
	active_workspace = _tmp3_;
	_tmp4_ = self->priv->workspaces;
	_tmp5_ = clutter_actor_get_children (_tmp4_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp5_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace_clone = NULL;
				ClutterActor* _tmp6_;
				GalaWorkspaceClone* _tmp7_;
				MetaWorkspace* _tmp8_;
				MetaWorkspace* _tmp9_;
				MetaWorkspace* _tmp10_;
				_tmp6_ = child;
				workspace_clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp7_ = workspace_clone;
				_tmp8_ = gala_workspace_clone_get_workspace (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = active_workspace;
				if (_tmp9_ == _tmp10_) {
					GalaWorkspaceClone* _tmp11_;
					GalaWindowCloneContainer* _tmp12_;
					GalaWindowCloneContainer* _tmp13_;
					GalaWindowCloneContainer* _tmp14_;
					_tmp11_ = workspace_clone;
					_tmp12_ = gala_workspace_clone_get_window_container (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					result = _tmp14_;
					(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
					return result;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	g_assert_not_reached ();
}

static void
gala_multitasking_view_window_selected (GalaMultitaskingView* self,
                                        MetaWindow* window)
{
	guint32 time = 0U;
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	MetaWorkspace* workspace = NULL;
	MetaWorkspace* _tmp3_;
	MetaWorkspace* _tmp4_;
	MetaWorkspaceManager* _tmp5_;
	MetaWorkspace* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->display;
	time = meta_display_get_current_time (_tmp0_);
	_tmp1_ = self->priv->display;
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp3_ = meta_window_get_workspace (window);
	workspace = _tmp3_;
	_tmp4_ = workspace;
	_tmp5_ = manager;
	_tmp6_ = meta_workspace_manager_get_active_workspace (_tmp5_);
	if (_tmp4_ != _tmp6_) {
		MetaWorkspace* _tmp7_;
		_tmp7_ = workspace;
		meta_workspace_activate (_tmp7_, time);
	} else {
		meta_window_activate (window, time);
		gala_multitasking_view_toggle (self, FALSE, FALSE);
	}
}

/**
         * {@inheritDoc}
         */
static gboolean
gala_multitasking_view_real_is_opened (GalaActivatableComponent* base)
{
	GalaMultitaskingView * self;
	gboolean result;
	self = (GalaMultitaskingView*) base;
	result = self->priv->opened;
	return result;
}

/**
         * {@inheritDoc}
         */
static void
gala_multitasking_view_real_open (GalaActivatableComponent* base,
                                  GHashTable* hints)
{
	GalaMultitaskingView * self;
	self = (GalaMultitaskingView*) base;
	if (!self->priv->opened) {
		gala_multitasking_view_toggle (self, FALSE, FALSE);
	}
}

/**
         * {@inheritDoc}
         */
static void
gala_multitasking_view_real_close (GalaActivatableComponent* base,
                                   GHashTable* hints)
{
	GalaMultitaskingView * self;
	self = (GalaMultitaskingView*) base;
	if (self->priv->opened) {
		gala_multitasking_view_toggle (self, FALSE, FALSE);
	}
}

/**
         * Toggles the view open or closed. Takes care of all the wm related tasks, like
         * starting the modal mode and hiding the WindowGroup. Finally tells all components
         * to animate to their positions.
         */
static Block61Data*
block61_data_ref (Block61Data* _data61_)
{
	g_atomic_int_inc (&_data61_->_ref_count_);
	return _data61_;
}

static void
block61_data_unref (void * _userdata_)
{
	Block61Data* _data61_;
	_data61_ = (Block61Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data61_->_ref_count_)) {
		GalaMultitaskingView* self;
		self = _data61_->self;
		_g_object_unref0 (self);
		g_slice_free (Block61Data, _data61_);
	}
}

static gboolean
_gala_multitasking_view_keybinding_filter_gala_keybinding_filter (MetaKeyBinding* binding,
                                                                  gpointer self)
{
	gboolean result;
	result = gala_multitasking_view_keybinding_filter ((GalaMultitaskingView*) self, binding);
	return result;
}

static Block62Data*
block62_data_ref (Block62Data* _data62_)
{
	g_atomic_int_inc (&_data62_->_ref_count_);
	return _data62_;
}

static void
block62_data_unref (void * _userdata_)
{
	Block62Data* _data62_;
	_data62_ = (Block62Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data62_->_ref_count_)) {
		GalaMultitaskingView* self;
		self = _data62_->_data61_->self;
		block61_data_unref (_data62_->_data61_);
		_data62_->_data61_ = NULL;
		g_slice_free (Block62Data, _data62_);
	}
}

static gboolean
__lambda71_ (Block62Data* _data62_)
{
	Block61Data* _data61_;
	GalaMultitaskingView* self;
	gboolean result;
	_data61_ = _data62_->_data61_;
	self = _data61_->self;
	if (!_data61_->opening) {
		GList* _tmp0_;
		GalaWindowManager* _tmp3_;
		MetaBackgroundGroup* _tmp4_;
		MetaBackgroundGroup* _tmp5_;
		GalaWindowManager* _tmp6_;
		ClutterActor* _tmp7_;
		ClutterActor* _tmp8_;
		GalaWindowManager* _tmp9_;
		ClutterActor* _tmp10_;
		ClutterActor* _tmp11_;
		ClutterActor* _tmp12_;
		GalaWindowManager* _tmp13_;
		GalaModalProxy* _tmp14_;
		_tmp0_ = self->priv->window_containers_monitors;
		{
			GList* container_collection = NULL;
			GList* container_it = NULL;
			container_collection = _tmp0_;
			for (container_it = container_collection; container_it != NULL; container_it = container_it->next) {
				GalaMonitorClone* _tmp1_;
				GalaMonitorClone* container = NULL;
				_tmp1_ = _g_object_ref0 ((GalaMonitorClone*) container_it->data);
				container = _tmp1_;
				{
					GalaMonitorClone* _tmp2_;
					_tmp2_ = container;
					g_object_set ((ClutterActor*) _tmp2_, "visible", FALSE, NULL);
					_g_object_unref0 (container);
				}
			}
		}
		clutter_actor_hide ((ClutterActor*) self);
		_tmp3_ = self->priv->_wm;
		_tmp4_ = gala_window_manager_get_background_group (_tmp3_);
		_tmp5_ = _tmp4_;
		clutter_actor_show ((ClutterActor*) _tmp5_);
		_tmp6_ = self->priv->_wm;
		_tmp7_ = gala_window_manager_get_window_group (_tmp6_);
		_tmp8_ = _tmp7_;
		clutter_actor_show (_tmp8_);
		_tmp9_ = self->priv->_wm;
		_tmp10_ = gala_window_manager_get_top_window_group (_tmp9_);
		_tmp11_ = _tmp10_;
		clutter_actor_show (_tmp11_);
		_tmp12_ = self->priv->dock_clones;
		clutter_actor_destroy_all_children (_tmp12_);
		_tmp13_ = self->priv->_wm;
		_tmp14_ = self->priv->modal_proxy;
		gala_window_manager_pop_modal (_tmp13_, _tmp14_);
	}
	self->priv->animating = FALSE;
	if (_data62_->cancel_action) {
		gala_multitasking_view_toggle (self, FALSE, TRUE);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda71__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda71_ (self);
	return result;
}

static void
__lambda70_ (Block61Data* _data61_,
             gdouble percentage,
             gboolean cancel_action)
{
	GalaMultitaskingView* self;
	Block62Data* _data62_;
	gint _tmp0_ = 0;
	gint animation_duration = 0;
	self = _data61_->self;
	_data62_ = g_slice_new0 (Block62Data);
	_data62_->_ref_count_ = 1;
	_data62_->_data61_ = block61_data_ref (_data61_);
	_data62_->cancel_action = cancel_action;
	if (_data62_->cancel_action) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	}
	animation_duration = _tmp0_;
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) animation_duration, ___lambda71__gsource_func, block62_data_ref (_data62_), block62_data_unref);
	block62_data_unref (_data62_);
	_data62_ = NULL;
}

static void
___lambda70__gala_gesture_tracker_on_end (gdouble percentage,
                                          gboolean cancel_action,
                                          gint calculated_duration,
                                          gpointer self)
{
	__lambda70_ (self, percentage, cancel_action);
}

static void
gala_multitasking_view_toggle (GalaMultitaskingView* self,
                               gboolean with_gesture,
                               gboolean is_cancel_animation)
{
	Block61Data* _data61_;
	gboolean _tmp0_ = FALSE;
	GList* _tmp5_;
	GalaWorkspaceClone* active_workspace = NULL;
	MetaWorkspaceManager* manager = NULL;
	MetaDisplay* _tmp29_;
	MetaWorkspaceManager* _tmp30_;
	MetaWorkspace* active = NULL;
	MetaWorkspaceManager* _tmp31_;
	MetaWorkspace* _tmp32_;
	MetaWorkspace* _tmp33_;
	ClutterActor* _tmp34_;
	GList* _tmp35_;
	GalaWorkspaceClone* _tmp43_;
	ClutterActor* _tmp46_;
	ClutterActor* _tmp47_;
	GList* _tmp48_;
	ClutterActor* _tmp50_;
	GList* _tmp51_;
	GalaGestureTrackerOnEnd on_animation_end = NULL;
	gpointer on_animation_end_target;
	GDestroyNotify on_animation_end_target_destroy_notify;
	g_return_if_fail (self != NULL);
	_data61_ = g_slice_new0 (Block61Data);
	_data61_->_ref_count_ = 1;
	_data61_->self = g_object_ref (self);
	if (self->priv->animating) {
		block61_data_unref (_data61_);
		_data61_ = NULL;
		return;
	}
	if (is_cancel_animation) {
		GalaWindowManager* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->_wm;
		_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		block61_data_unref (_data61_);
		_data61_ = NULL;
		return;
	}
	self->priv->animating = TRUE;
	self->priv->opened = !self->priv->opened;
	_data61_->opening = self->priv->opened;
	if (_data61_->opening) {
		GalaWindowManager* _tmp4_;
		_tmp4_ = self->priv->_wm;
		G_TYPE_INSTANCE_GET_CLASS ((MetaPlugin*) _tmp4_, meta_plugin_get_type (), MetaPluginClass)->kill_switch_workspace ((MetaPlugin*) _tmp4_);
	}
	_tmp5_ = self->priv->window_containers_monitors;
	{
		GList* container_collection = NULL;
		GList* container_it = NULL;
		container_collection = _tmp5_;
		for (container_it = container_collection; container_it != NULL; container_it = container_it->next) {
			GalaMonitorClone* _tmp6_;
			GalaMonitorClone* container = NULL;
			_tmp6_ = _g_object_ref0 ((GalaMonitorClone*) container_it->data);
			container = _tmp6_;
			{
				if (_data61_->opening) {
					GalaMonitorClone* _tmp7_;
					GalaMonitorClone* _tmp8_;
					_tmp7_ = container;
					g_object_set ((ClutterActor*) _tmp7_, "visible", TRUE, NULL);
					_tmp8_ = container;
					gala_monitor_clone_open (_tmp8_, with_gesture, is_cancel_animation);
				} else {
					GalaMonitorClone* _tmp9_;
					_tmp9_ = container;
					gala_monitor_clone_close (_tmp9_, with_gesture, is_cancel_animation);
				}
				_g_object_unref0 (container);
			}
		}
	}
	if (_data61_->opening) {
		GalaWindowManager* _tmp10_;
		GalaModalProxy* _tmp11_;
		GalaModalProxy* _tmp12_;
		GalaWindowManager* _tmp13_;
		MetaBackgroundGroup* _tmp14_;
		MetaBackgroundGroup* _tmp15_;
		GalaWindowManager* _tmp16_;
		ClutterActor* _tmp17_;
		ClutterActor* _tmp18_;
		GalaWindowManager* _tmp19_;
		ClutterActor* _tmp20_;
		ClutterActor* _tmp21_;
		gfloat scale = 0.0F;
		MetaDisplay* _tmp22_;
		MetaDisplay* _tmp23_;
		GalaIconGroupContainer* _tmp24_;
		GalaIconGroupContainer* _tmp25_;
		ClutterActor* _tmp26_;
		gfloat _tmp27_;
		gfloat _tmp28_;
		_tmp10_ = self->priv->_wm;
		_tmp11_ = gala_window_manager_push_modal (_tmp10_, (ClutterActor*) self);
		_g_object_unref0 (self->priv->modal_proxy);
		self->priv->modal_proxy = _tmp11_;
		_tmp12_ = self->priv->modal_proxy;
		gala_modal_proxy_set_keybinding_filter (_tmp12_, _gala_multitasking_view_keybinding_filter_gala_keybinding_filter, self);
		_tmp13_ = self->priv->_wm;
		_tmp14_ = gala_window_manager_get_background_group (_tmp13_);
		_tmp15_ = _tmp14_;
		clutter_actor_hide ((ClutterActor*) _tmp15_);
		_tmp16_ = self->priv->_wm;
		_tmp17_ = gala_window_manager_get_window_group (_tmp16_);
		_tmp18_ = _tmp17_;
		clutter_actor_hide (_tmp18_);
		_tmp19_ = self->priv->_wm;
		_tmp20_ = gala_window_manager_get_top_window_group (_tmp19_);
		_tmp21_ = _tmp20_;
		clutter_actor_hide (_tmp21_);
		clutter_actor_show ((ClutterActor*) self);
		clutter_actor_grab_key_focus ((ClutterActor*) self);
		_tmp22_ = self->priv->display;
		_tmp23_ = self->priv->display;
		scale = meta_display_get_monitor_scale (_tmp22_, meta_display_get_primary_monitor (_tmp23_));
		_tmp24_ = self->priv->icon_groups;
		gala_icon_group_container_force_reposition (_tmp24_);
		_tmp25_ = self->priv->icon_groups;
		_tmp26_ = self->priv->primary_monitor_container;
		_tmp27_ = clutter_actor_get_height (_tmp26_);
		_tmp28_ = _tmp27_;
		clutter_actor_set_y ((ClutterActor*) _tmp25_, _tmp28_ - gala_internal_utils_scale_to_int (GALA_WORKSPACE_CLONE_BOTTOM_OFFSET - 20, scale));
	} else {
		gala_drag_drop_action_cancel_all_by_id ("multitaskingview-window");
	}
	active_workspace = NULL;
	_tmp29_ = self->priv->display;
	_tmp30_ = meta_display_get_workspace_manager (_tmp29_);
	manager = _tmp30_;
	_tmp31_ = manager;
	_tmp32_ = meta_workspace_manager_get_active_workspace (_tmp31_);
	_tmp33_ = _g_object_ref0 (_tmp32_);
	active = _tmp33_;
	_tmp34_ = self->priv->workspaces;
	_tmp35_ = clutter_actor_get_children (_tmp34_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp35_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace = NULL;
				ClutterActor* _tmp36_;
				GalaWorkspaceClone* _tmp37_;
				MetaWorkspace* _tmp38_;
				MetaWorkspace* _tmp39_;
				MetaWorkspace* _tmp40_;
				_tmp36_ = child;
				workspace = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp37_ = workspace;
				_tmp38_ = gala_workspace_clone_get_workspace (_tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = active;
				if (_tmp39_ == _tmp40_) {
					GalaWorkspaceClone* _tmp41_;
					GalaWorkspaceClone* _tmp42_;
					_tmp41_ = workspace;
					_tmp42_ = _g_object_ref0 (_tmp41_);
					_g_object_unref0 (active_workspace);
					active_workspace = _tmp42_;
					break;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	_tmp43_ = active_workspace;
	if (_tmp43_ != NULL) {
		ClutterActor* _tmp44_;
		GalaWorkspaceClone* _tmp45_;
		_tmp44_ = self->priv->workspaces;
		_tmp45_ = active_workspace;
		clutter_actor_set_child_above_sibling (_tmp44_, (ClutterActor*) _tmp45_, NULL);
	}
	_tmp46_ = self->priv->workspaces;
	clutter_actor_remove_all_transitions (_tmp46_);
	_tmp47_ = self->priv->workspaces;
	_tmp48_ = clutter_actor_get_children (_tmp47_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp48_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				ClutterActor* _tmp49_;
				_tmp49_ = child;
				clutter_actor_remove_all_transitions (_tmp49_);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	if (!is_cancel_animation) {
		gala_multitasking_view_update_positions (self, FALSE);
	}
	_tmp50_ = self->priv->workspaces;
	_tmp51_ = clutter_actor_get_children (_tmp50_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp51_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace = NULL;
				ClutterActor* _tmp52_;
				_tmp52_ = child;
				workspace = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				if (_data61_->opening) {
					GalaWorkspaceClone* _tmp53_;
					_tmp53_ = workspace;
					gala_workspace_clone_open (_tmp53_, with_gesture, is_cancel_animation);
				} else {
					GalaWorkspaceClone* _tmp54_;
					_tmp54_ = workspace;
					gala_workspace_clone_close (_tmp54_, with_gesture, is_cancel_animation);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	if (_data61_->opening) {
		gala_multitasking_view_show_docks (self, with_gesture, is_cancel_animation);
	} else {
		gala_multitasking_view_hide_docks (self, with_gesture, is_cancel_animation);
	}
	on_animation_end = ___lambda70__gala_gesture_tracker_on_end;
	on_animation_end_target = block61_data_ref (_data61_);
	on_animation_end_target_destroy_notify = block61_data_unref;
	if (!with_gesture) {
		GalaGestureTrackerOnEnd _tmp55_;
		gpointer _tmp55__target;
		_tmp55_ = on_animation_end;
		_tmp55__target = on_animation_end_target;
		_tmp55_ ((gdouble) 1, FALSE, 0, _tmp55__target);
	} else {
		GalaGestureTracker* _tmp56_;
		GalaGestureTrackerOnEnd _tmp57_;
		gpointer _tmp57__target;
		GDestroyNotify _tmp57__target_destroy_notify;
		_tmp56_ = self->priv->multitasking_gesture_tracker;
		_tmp57_ = on_animation_end;
		_tmp57__target = on_animation_end_target;
		_tmp57__target_destroy_notify = on_animation_end_target_destroy_notify;
		on_animation_end = NULL;
		on_animation_end_target = NULL;
		on_animation_end_target_destroy_notify = NULL;
		gala_gesture_tracker_connect_handlers (_tmp56_, NULL, NULL, NULL, NULL, NULL, NULL, _tmp57_, _tmp57__target, _tmp57__target_destroy_notify);
	}
	(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
	on_animation_end = NULL;
	on_animation_end_target = NULL;
	on_animation_end_target_destroy_notify = NULL;
	_g_object_unref0 (active);
	_g_object_unref0 (active_workspace);
	block61_data_unref (_data61_);
	_data61_ = NULL;
}

static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		GalaMultitaskingView* self;
		self = _data63_->self;
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static Block64Data*
block64_data_ref (Block64Data* _data64_)
{
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}

static void
block64_data_unref (void * _userdata_)
{
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		GalaMultitaskingView* self;
		self = _data64_->_data63_->self;
		_g_object_unref0 (_data64_->clone);
		block63_data_unref (_data64_->_data63_);
		_data64_->_data63_ = NULL;
		g_slice_free (Block64Data, _data64_);
	}
}

static void
____lambda66_ (Block64Data* _data64_,
               gdouble percentage)
{
	Block63Data* _data63_;
	GalaMultitaskingView* self;
	gfloat y = 0.0F;
	GalaSafeWindowClone* _tmp0_;
	_data63_ = _data64_->_data63_;
	self = _data63_->self;
	y = gala_gesture_tracker_animation_value (_data64_->initial_y, _data64_->target_y, percentage, FALSE);
	_tmp0_ = _data64_->clone;
	clutter_actor_set_y ((ClutterActor*) _tmp0_, y);
}

static void
_____lambda66__gala_gesture_tracker_on_update (gdouble percentage,
                                               gpointer self)
{
	____lambda66_ (self, percentage);
}

static void
____lambda67_ (Block64Data* _data64_,
               gdouble percentage,
               gboolean cancel_action)
{
	Block63Data* _data63_;
	GalaMultitaskingView* self;
	GalaSafeWindowClone* _tmp0_;
	GalaSafeWindowClone* _tmp1_;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	GalaSafeWindowClone* _tmp7_;
	GalaSafeWindowClone* _tmp8_;
	GalaSafeWindowClone* _tmp9_;
	_data63_ = _data64_->_data63_;
	self = _data63_->self;
	if (cancel_action) {
		return;
	}
	_tmp0_ = _data64_->clone;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp1_ = _data64_->clone;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp1_, CLUTTER_EASE_OUT_QUAD);
	if (!_data63_->is_cancel_animation) {
		GalaWindowManager* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->_wm;
		_tmp5_ = gala_window_manager_get_enable_animations (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp2_ = 0;
	}
	_tmp7_ = _data64_->clone;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp7_, (guint) _tmp2_);
	_tmp8_ = _data64_->clone;
	clutter_actor_set_y ((ClutterActor*) _tmp8_, _data64_->target_y);
	_tmp9_ = _data64_->clone;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp9_);
}

static void
_____lambda67__gala_gesture_tracker_on_end (gdouble percentage,
                                            gboolean cancel_action,
                                            gint calculated_duration,
                                            gpointer self)
{
	____lambda67_ (self, percentage, cancel_action);
}

static void
gala_multitasking_view_show_docks (GalaMultitaskingView* self,
                                   gboolean with_gesture,
                                   gboolean is_cancel_animation)
{
	Block63Data* _data63_;
	GList* window_actors = NULL;
	MetaDisplay* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_data63_->self = g_object_ref (self);
	_data63_->is_cancel_animation = is_cancel_animation;
	_tmp0_ = self->priv->display;
	_tmp1_ = meta_get_window_actors (_tmp0_);
	window_actors = _tmp1_;
	_tmp2_ = window_actors;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp2_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			MetaWindowActor* actor = NULL;
			actor = (MetaWindowActor*) actor_it->data;
			{
				Block64Data* _data64_;
				static const gint MAX_OFFSET = 85;
				MetaWindowActor* _tmp3_;
				MetaWindow* window = NULL;
				MetaWindowActor* _tmp4_;
				MetaWindow* _tmp5_;
				gint monitor = 0;
				MetaWindow* _tmp6_;
				MetaWindow* _tmp7_;
				MetaWindowType _tmp8_;
				MetaWindowType _tmp9_;
				MetaDisplay* _tmp10_;
				MtkRectangle monitor_geom = {0};
				MetaDisplay* _tmp11_;
				MtkRectangle _tmp12_ = {0};
				MtkRectangle window_geom = {0};
				MetaWindow* _tmp13_;
				MtkRectangle _tmp14_ = {0};
				gboolean top = FALSE;
				MtkRectangle _tmp15_;
				MtkRectangle _tmp16_;
				gboolean bottom = FALSE;
				MtkRectangle _tmp17_;
				MtkRectangle _tmp18_;
				MtkRectangle _tmp19_;
				gboolean _tmp20_ = FALSE;
				gfloat initial_x = 0.0F;
				MetaWindowActor* _tmp21_;
				gfloat _tmp22_;
				gfloat _tmp23_;
				MetaWindowActor* _tmp24_;
				gfloat _tmp25_;
				gfloat _tmp26_;
				gfloat _tmp27_ = 0.0F;
				MetaWindow* _tmp40_;
				GalaSafeWindowClone* _tmp41_;
				ClutterActor* _tmp42_;
				GalaSafeWindowClone* _tmp43_;
				GalaSafeWindowClone* _tmp44_;
				GalaGestureTrackerOnUpdate on_animation_update = NULL;
				gpointer on_animation_update_target;
				GDestroyNotify on_animation_update_target_destroy_notify;
				GalaGestureTrackerOnEnd on_animation_end = NULL;
				gpointer on_animation_end_target;
				GDestroyNotify on_animation_end_target_destroy_notify;
				gboolean _tmp45_ = FALSE;
				_data64_ = g_slice_new0 (Block64Data);
				_data64_->_ref_count_ = 1;
				_data64_->_data63_ = block63_data_ref (_data63_);
				_tmp3_ = actor;
				if (meta_window_actor_is_destroyed (_tmp3_)) {
					block64_data_unref (_data64_);
					_data64_ = NULL;
					continue;
				}
				_tmp4_ = actor;
				_tmp5_ = meta_window_actor_get_meta_window (_tmp4_);
				window = _tmp5_;
				_tmp6_ = window;
				monitor = meta_window_get_monitor (_tmp6_);
				_tmp7_ = window;
				_tmp8_ = meta_window_get_window_type (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_ != META_WINDOW_DOCK) {
					block64_data_unref (_data64_);
					_data64_ = NULL;
					continue;
				}
				_tmp10_ = self->priv->display;
				if (meta_display_get_monitor_in_fullscreen (_tmp10_, monitor)) {
					block64_data_unref (_data64_);
					_data64_ = NULL;
					continue;
				}
				_tmp11_ = self->priv->display;
				meta_display_get_monitor_geometry (_tmp11_, monitor, &_tmp12_);
				monitor_geom = _tmp12_;
				_tmp13_ = window;
				meta_window_get_frame_rect (_tmp13_, &_tmp14_);
				window_geom = _tmp14_;
				_tmp15_ = monitor_geom;
				_tmp16_ = window_geom;
				top = (_tmp15_.y + MAX_OFFSET) > _tmp16_.y;
				_tmp17_ = monitor_geom;
				_tmp18_ = monitor_geom;
				_tmp19_ = window_geom;
				bottom = ((_tmp17_.y + _tmp18_.height) - MAX_OFFSET) > _tmp19_.y;
				if (!top) {
					_tmp20_ = !bottom;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					block64_data_unref (_data64_);
					_data64_ = NULL;
					continue;
				}
				_tmp21_ = actor;
				_tmp22_ = clutter_actor_get_x ((ClutterActor*) _tmp21_);
				_tmp23_ = _tmp22_;
				initial_x = _tmp23_;
				_tmp24_ = actor;
				_tmp25_ = clutter_actor_get_y ((ClutterActor*) _tmp24_);
				_tmp26_ = _tmp25_;
				_data64_->initial_y = _tmp26_;
				if (top) {
					MetaWindowActor* _tmp28_;
					gfloat _tmp29_;
					gfloat _tmp30_;
					MetaWindowActor* _tmp31_;
					gfloat _tmp32_;
					gfloat _tmp33_;
					_tmp28_ = actor;
					_tmp29_ = clutter_actor_get_y ((ClutterActor*) _tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = actor;
					_tmp32_ = clutter_actor_get_height ((ClutterActor*) _tmp31_);
					_tmp33_ = _tmp32_;
					_tmp27_ = _tmp30_ - _tmp33_;
				} else {
					MetaWindowActor* _tmp34_;
					gfloat _tmp35_;
					gfloat _tmp36_;
					MetaWindowActor* _tmp37_;
					gfloat _tmp38_;
					gfloat _tmp39_;
					_tmp34_ = actor;
					_tmp35_ = clutter_actor_get_y ((ClutterActor*) _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = actor;
					_tmp38_ = clutter_actor_get_height ((ClutterActor*) _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp27_ = _tmp36_ + _tmp39_;
				}
				_data64_->target_y = _tmp27_;
				_tmp40_ = window;
				_tmp41_ = gala_safe_window_clone_new (_tmp40_, TRUE);
				g_object_ref_sink (_tmp41_);
				_data64_->clone = _tmp41_;
				_tmp42_ = self->priv->dock_clones;
				_tmp43_ = _data64_->clone;
				clutter_actor_add_child (_tmp42_, (ClutterActor*) _tmp43_);
				_tmp44_ = _data64_->clone;
				clutter_actor_set_position ((ClutterActor*) _tmp44_, initial_x, _data64_->initial_y);
				on_animation_update = _____lambda66__gala_gesture_tracker_on_update;
				on_animation_update_target = block64_data_ref (_data64_);
				on_animation_update_target_destroy_notify = block64_data_unref;
				on_animation_end = _____lambda67__gala_gesture_tracker_on_end;
				on_animation_end_target = block64_data_ref (_data64_);
				on_animation_end_target_destroy_notify = block64_data_unref;
				if (!with_gesture) {
					_tmp45_ = TRUE;
				} else {
					GalaWindowManager* _tmp46_;
					gboolean _tmp47_;
					gboolean _tmp48_;
					_tmp46_ = self->priv->_wm;
					_tmp47_ = gala_window_manager_get_enable_animations (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp45_ = !_tmp48_;
				}
				if (_tmp45_) {
					GalaGestureTrackerOnEnd _tmp49_;
					gpointer _tmp49__target;
					_tmp49_ = on_animation_end;
					_tmp49__target = on_animation_end_target;
					_tmp49_ ((gdouble) 1, FALSE, 0, _tmp49__target);
				} else {
					GalaGestureTracker* _tmp50_;
					GalaGestureTrackerOnUpdate _tmp51_;
					gpointer _tmp51__target;
					GDestroyNotify _tmp51__target_destroy_notify;
					GalaGestureTrackerOnEnd _tmp52_;
					gpointer _tmp52__target;
					GDestroyNotify _tmp52__target_destroy_notify;
					_tmp50_ = self->priv->multitasking_gesture_tracker;
					_tmp51_ = on_animation_update;
					_tmp51__target = on_animation_update_target;
					_tmp51__target_destroy_notify = on_animation_update_target_destroy_notify;
					on_animation_update = NULL;
					on_animation_update_target = NULL;
					on_animation_update_target_destroy_notify = NULL;
					_tmp52_ = on_animation_end;
					_tmp52__target = on_animation_end_target;
					_tmp52__target_destroy_notify = on_animation_end_target_destroy_notify;
					on_animation_end = NULL;
					on_animation_end_target = NULL;
					on_animation_end_target_destroy_notify = NULL;
					gala_gesture_tracker_connect_handlers (_tmp50_, NULL, NULL, NULL, _tmp51_, _tmp51__target, _tmp51__target_destroy_notify, _tmp52_, _tmp52__target, _tmp52__target_destroy_notify);
				}
				(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
				on_animation_end = NULL;
				on_animation_end_target = NULL;
				on_animation_end_target_destroy_notify = NULL;
				(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
				on_animation_update = NULL;
				on_animation_update_target = NULL;
				on_animation_update_target_destroy_notify = NULL;
				block64_data_unref (_data64_);
				_data64_ = NULL;
			}
		}
	}
	block63_data_unref (_data63_);
	_data63_ = NULL;
}

static Block65Data*
block65_data_ref (Block65Data* _data65_)
{
	g_atomic_int_inc (&_data65_->_ref_count_);
	return _data65_;
}

static void
block65_data_unref (void * _userdata_)
{
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
		GalaMultitaskingView* self;
		self = _data65_->self;
		_g_object_unref0 (_data65_->dock);
		_g_object_unref0 (self);
		g_slice_free (Block65Data, _data65_);
	}
}

static void
____lambda68_ (Block65Data* _data65_,
               gdouble percentage)
{
	GalaMultitaskingView* self;
	gfloat y = 0.0F;
	ClutterClone* _tmp0_;
	self = _data65_->self;
	y = gala_gesture_tracker_animation_value (_data65_->initial_y, _data65_->target_y, percentage, FALSE);
	_tmp0_ = _data65_->dock;
	clutter_actor_set_y ((ClutterActor*) _tmp0_, y);
}

static void
_____lambda68__gala_gesture_tracker_on_update (gdouble percentage,
                                               gpointer self)
{
	____lambda68_ (self, percentage);
}

static void
____lambda69_ (Block65Data* _data65_,
               gdouble percentage,
               gboolean cancel_action)
{
	GalaMultitaskingView* self;
	ClutterClone* _tmp0_;
	ClutterClone* _tmp1_;
	gint _tmp2_ = 0;
	GalaWindowManager* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ClutterClone* _tmp6_;
	ClutterClone* _tmp7_;
	ClutterClone* _tmp8_;
	self = _data65_->self;
	if (cancel_action) {
		return;
	}
	_tmp0_ = _data65_->dock;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp1_ = _data65_->dock;
	clutter_actor_set_easing_mode ((ClutterActor*) _tmp1_, CLUTTER_EASE_OUT_QUAD);
	_tmp3_ = self->priv->_wm;
	_tmp4_ = gala_window_manager_get_enable_animations (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = GALA_MULTITASKING_VIEW_ANIMATION_DURATION;
	} else {
		_tmp2_ = 0;
	}
	_tmp6_ = _data65_->dock;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp6_, (guint) _tmp2_);
	_tmp7_ = _data65_->dock;
	clutter_actor_set_y ((ClutterActor*) _tmp7_, _data65_->target_y);
	_tmp8_ = _data65_->dock;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp8_);
}

static void
_____lambda69__gala_gesture_tracker_on_end (gdouble percentage,
                                            gboolean cancel_action,
                                            gint calculated_duration,
                                            gpointer self)
{
	____lambda69_ (self, percentage, cancel_action);
}

static void
gala_multitasking_view_hide_docks (GalaMultitaskingView* self,
                                   gboolean with_gesture,
                                   gboolean is_cancel_animation)
{
	ClutterActor* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dock_clones;
	_tmp1_ = clutter_actor_get_children (_tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				Block65Data* _data65_;
				ClutterActor* _tmp2_;
				ClutterClone* _tmp3_;
				ClutterClone* _tmp4_;
				gfloat _tmp5_;
				gfloat _tmp6_;
				ClutterClone* _tmp7_;
				ClutterActor* _tmp8_;
				ClutterActor* _tmp9_;
				gfloat _tmp10_;
				gfloat _tmp11_;
				GalaGestureTrackerOnUpdate on_animation_update = NULL;
				gpointer on_animation_update_target;
				GDestroyNotify on_animation_update_target_destroy_notify;
				GalaGestureTrackerOnEnd on_animation_end = NULL;
				gpointer on_animation_end_target;
				GDestroyNotify on_animation_end_target_destroy_notify;
				gboolean _tmp12_ = FALSE;
				_data65_ = g_slice_new0 (Block65Data);
				_data65_->_ref_count_ = 1;
				_data65_->self = g_object_ref (self);
				_tmp2_ = child;
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, clutter_clone_get_type (), ClutterClone));
				_data65_->dock = _tmp3_;
				_tmp4_ = _data65_->dock;
				_tmp5_ = clutter_actor_get_y ((ClutterActor*) _tmp4_);
				_tmp6_ = _tmp5_;
				_data65_->initial_y = _tmp6_;
				_tmp7_ = _data65_->dock;
				_tmp8_ = clutter_clone_get_source (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = clutter_actor_get_y (_tmp9_);
				_tmp11_ = _tmp10_;
				_data65_->target_y = _tmp11_;
				on_animation_update = _____lambda68__gala_gesture_tracker_on_update;
				on_animation_update_target = block65_data_ref (_data65_);
				on_animation_update_target_destroy_notify = block65_data_unref;
				on_animation_end = _____lambda69__gala_gesture_tracker_on_end;
				on_animation_end_target = block65_data_ref (_data65_);
				on_animation_end_target_destroy_notify = block65_data_unref;
				if (!with_gesture) {
					_tmp12_ = TRUE;
				} else {
					GalaWindowManager* _tmp13_;
					gboolean _tmp14_;
					gboolean _tmp15_;
					_tmp13_ = self->priv->_wm;
					_tmp14_ = gala_window_manager_get_enable_animations (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp12_ = !_tmp15_;
				}
				if (_tmp12_) {
					GalaGestureTrackerOnEnd _tmp16_;
					gpointer _tmp16__target;
					_tmp16_ = on_animation_end;
					_tmp16__target = on_animation_end_target;
					_tmp16_ ((gdouble) 1, FALSE, 0, _tmp16__target);
				} else {
					GalaGestureTracker* _tmp17_;
					GalaGestureTrackerOnUpdate _tmp18_;
					gpointer _tmp18__target;
					GDestroyNotify _tmp18__target_destroy_notify;
					GalaGestureTrackerOnEnd _tmp19_;
					gpointer _tmp19__target;
					GDestroyNotify _tmp19__target_destroy_notify;
					_tmp17_ = self->priv->multitasking_gesture_tracker;
					_tmp18_ = on_animation_update;
					_tmp18__target = on_animation_update_target;
					_tmp18__target_destroy_notify = on_animation_update_target_destroy_notify;
					on_animation_update = NULL;
					on_animation_update_target = NULL;
					on_animation_update_target_destroy_notify = NULL;
					_tmp19_ = on_animation_end;
					_tmp19__target = on_animation_end_target;
					_tmp19__target_destroy_notify = on_animation_end_target_destroy_notify;
					on_animation_end = NULL;
					on_animation_end_target = NULL;
					on_animation_end_target_destroy_notify = NULL;
					gala_gesture_tracker_connect_handlers (_tmp17_, NULL, NULL, NULL, _tmp18_, _tmp18__target, _tmp18__target_destroy_notify, _tmp19_, _tmp19__target, _tmp19__target_destroy_notify);
				}
				(on_animation_end_target_destroy_notify == NULL) ? NULL : (on_animation_end_target_destroy_notify (on_animation_end_target), NULL);
				on_animation_end = NULL;
				on_animation_end_target = NULL;
				on_animation_end_target_destroy_notify = NULL;
				(on_animation_update_target_destroy_notify == NULL) ? NULL : (on_animation_update_target_destroy_notify (on_animation_update_target), NULL);
				on_animation_update = NULL;
				on_animation_update_target = NULL;
				on_animation_update_target_destroy_notify = NULL;
				block65_data_unref (_data65_);
				_data65_ = NULL;
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static gboolean
gala_multitasking_view_keybinding_filter (GalaMultitaskingView* self,
                                          MetaKeyBinding* binding)
{
	MetaKeyBindingAction action = 0;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GQuark _tmp8_ = 0U;
	static GQuark _tmp7_label0 = 0;
	static GQuark _tmp7_label1 = 0;
	static GQuark _tmp7_label2 = 0;
	static GQuark _tmp7_label3 = 0;
	static GQuark _tmp7_label4 = 0;
	static GQuark _tmp7_label5 = 0;
	static GQuark _tmp7_label6 = 0;
	static GQuark _tmp7_label7 = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (binding != NULL, FALSE);
	_tmp0_ = meta_key_binding_get_name (binding);
	action = meta_prefs_get_keybinding_action (_tmp0_);
	if (action == META_KEYBINDING_ACTION_OVERLAY_KEY) {
		GSettings* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->priv->gala_behavior_settings;
		_tmp3_ = g_settings_get_string (_tmp2_, "overlay-action");
		_tmp4_ = _tmp3_;
		_tmp1_ = g_strcmp0 (_tmp4_, GALA_MULTITASKING_VIEW_OPEN_MULTITASKING_VIEW) == 0;
		_g_free0 (_tmp4_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	switch (action) {
		case META_KEYBINDING_ACTION_WORKSPACE_1:
		case META_KEYBINDING_ACTION_WORKSPACE_2:
		case META_KEYBINDING_ACTION_WORKSPACE_3:
		case META_KEYBINDING_ACTION_WORKSPACE_4:
		case META_KEYBINDING_ACTION_WORKSPACE_5:
		case META_KEYBINDING_ACTION_WORKSPACE_6:
		case META_KEYBINDING_ACTION_WORKSPACE_7:
		case META_KEYBINDING_ACTION_WORKSPACE_8:
		case META_KEYBINDING_ACTION_WORKSPACE_9:
		case META_KEYBINDING_ACTION_WORKSPACE_10:
		case META_KEYBINDING_ACTION_WORKSPACE_11:
		case META_KEYBINDING_ACTION_WORKSPACE_12:
		case META_KEYBINDING_ACTION_WORKSPACE_LEFT:
		case META_KEYBINDING_ACTION_WORKSPACE_RIGHT:
		case META_KEYBINDING_ACTION_SHOW_DESKTOP:
		case META_KEYBINDING_ACTION_NONE:
		case META_KEYBINDING_ACTION_LOCATE_POINTER_KEY:
		{
			result = FALSE;
			return result;
		}
		default:
		{
			break;
		}
	}
	_tmp5_ = meta_key_binding_get_name (binding);
	_tmp6_ = _tmp5_;
	_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if ((((((((_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("cycle-workspaces-next")))) || (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("cycle-workspaces-previous"))))) || (_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("switch-to-workspace-first"))))) || (_tmp8_ == ((0 != _tmp7_label3) ? _tmp7_label3 : (_tmp7_label3 = g_quark_from_static_string ("switch-to-workspace-last"))))) || (_tmp8_ == ((0 != _tmp7_label4) ? _tmp7_label4 : (_tmp7_label4 = g_quark_from_static_string ("zoom-in"))))) || (_tmp8_ == ((0 != _tmp7_label5) ? _tmp7_label5 : (_tmp7_label5 = g_quark_from_static_string ("zoom-out"))))) || (_tmp8_ == ((0 != _tmp7_label6) ? _tmp7_label6 : (_tmp7_label6 = g_quark_from_static_string ("screenshot"))))) || (_tmp8_ == ((0 != _tmp7_label7) ? _tmp7_label7 : (_tmp7_label7 = g_quark_from_static_string ("screenshot-clip"))))) {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	result = TRUE;
	return result;
}

GalaWindowManager*
gala_multitasking_view_get_wm (GalaMultitaskingView* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_multitasking_view_set_wm (GalaMultitaskingView* self,
                               GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_multitasking_view_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_multitasking_view_properties[GALA_MULTITASKING_VIEW_WM_PROPERTY]);
	}
}

static gboolean
gala_multitasking_view_get_switching_workspace_in_progress (GalaMultitaskingView* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->switching_workspace_with_gesture) {
		_tmp0_ = TRUE;
	} else {
		ClutterActor* _tmp1_;
		ClutterTransition* _tmp2_;
		_tmp1_ = self->priv->workspaces;
		_tmp2_ = clutter_actor_get_transition (_tmp1_, "x");
		_tmp0_ = _tmp2_ != NULL;
	}
	result = _tmp0_;
	return result;
}

static Block66Data*
block66_data_ref (Block66Data* _data66_)
{
	g_atomic_int_inc (&_data66_->_ref_count_);
	return _data66_;
}

static void
block66_data_unref (void * _userdata_)
{
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
		GalaMultitaskingView* self;
		self = _data66_->self;
		_g_object_unref0 (self);
		g_slice_free (Block66Data, _data66_);
	}
}

static void
_gala_multitasking_view_on_multitasking_gesture_detected_gala_gesture_tracker_on_gesture_detected (GalaGestureTracker* _sender,
                                                                                                   GalaGesture* gesture,
                                                                                                   gpointer self)
{
	gala_multitasking_view_on_multitasking_gesture_detected ((GalaMultitaskingView*) self, gesture);
}

static void
_gala_multitasking_view_on_workspace_gesture_detected_gala_gesture_tracker_on_gesture_detected (GalaGestureTracker* _sender,
                                                                                                GalaGesture* gesture,
                                                                                                gpointer self)
{
	gala_multitasking_view_on_workspace_gesture_detected ((GalaMultitaskingView*) self, gesture);
}

static void
_gala_multitasking_view_add_workspace_meta_workspace_manager_workspace_added (MetaWorkspaceManager* _sender,
                                                                              gint object,
                                                                              gpointer self)
{
	gala_multitasking_view_add_workspace ((GalaMultitaskingView*) self, object);
}

static void
_gala_multitasking_view_remove_workspace_meta_workspace_manager_workspace_removed (MetaWorkspaceManager* _sender,
                                                                                   gint object,
                                                                                   gpointer self)
{
	gala_multitasking_view_remove_workspace ((GalaMultitaskingView*) self, object);
}

static void
_gala_multitasking_view___lambda74_ (GalaMultitaskingView* self)
{
	gala_multitasking_view_update_positions (self, FALSE);
}

static void
__gala_multitasking_view___lambda74__meta_workspace_manager_workspaces_reordered (MetaWorkspaceManager* _sender,
                                                                                  gpointer self)
{
	_gala_multitasking_view___lambda74_ ((GalaMultitaskingView*) self);
}

static void
_gala_multitasking_view___lambda75_ (GalaMultitaskingView* self,
                                     gint from,
                                     gint to,
                                     MetaMotionDirection direction)
{
	gala_multitasking_view_update_positions (self, self->priv->opened);
}

static void
__gala_multitasking_view___lambda75__meta_workspace_manager_workspace_switched (MetaWorkspaceManager* _sender,
                                                                                gint object,
                                                                                gint p0,
                                                                                MetaMotionDirection p1,
                                                                                gpointer self)
{
	_gala_multitasking_view___lambda75_ ((GalaMultitaskingView*) self, object, p0, p1);
}

static void
_gala_multitasking_view_update_monitors_meta_monitor_manager_monitors_changed (MetaMonitorManager* _sender,
                                                                               gpointer self)
{
	gala_multitasking_view_update_monitors ((GalaMultitaskingView*) self);
}

static gboolean
__lambda77_ (Block66Data* _data66_)
{
	GalaMultitaskingView* self;
	GList* existing_workspaces = NULL;
	ClutterActor* _tmp6_;
	GList* _tmp7_;
	gboolean result;
	self = _data66_->self;
	existing_workspaces = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp2_;
				MetaWorkspaceManager* _tmp3_;
				MetaWorkspace* _tmp4_;
				MetaWorkspace* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = _data66_->manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp2_))) {
					break;
				}
				_tmp3_ = _data66_->manager;
				_tmp4_ = meta_workspace_manager_get_workspace_by_index (_tmp3_, i);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				existing_workspaces = g_list_append (existing_workspaces, _tmp5_);
			}
		}
	}
	_tmp6_ = self->priv->workspaces;
	_tmp7_ = clutter_actor_get_children (_tmp6_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp7_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				GalaWorkspaceClone* workspace_clone = NULL;
				ClutterActor* _tmp8_;
				GList* _tmp9_;
				GalaWorkspaceClone* _tmp10_;
				MetaWorkspace* _tmp11_;
				MetaWorkspace* _tmp12_;
				_tmp8_ = child;
				workspace_clone = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GALA_TYPE_WORKSPACE_CLONE, GalaWorkspaceClone);
				_tmp9_ = existing_workspaces;
				_tmp10_ = workspace_clone;
				_tmp11_ = gala_workspace_clone_get_workspace (_tmp10_);
				_tmp12_ = _tmp11_;
				if (g_list_index (_tmp9_, _tmp12_) < 0) {
					GalaWorkspaceClone* _tmp13_;
					guint _tmp14_;
					GalaWorkspaceClone* _tmp15_;
					guint _tmp16_;
					GalaIconGroupContainer* _tmp17_;
					GalaWorkspaceClone* _tmp18_;
					GalaIconGroup* _tmp19_;
					GalaIconGroup* _tmp20_;
					GalaWorkspaceClone* _tmp21_;
					_tmp13_ = workspace_clone;
					g_signal_parse_name ("window-selected", GALA_TYPE_WORKSPACE_CLONE, &_tmp14_, NULL, FALSE);
					g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) _gala_multitasking_view_window_selected_gala_workspace_clone_window_selected, self);
					_tmp15_ = workspace_clone;
					g_signal_parse_name ("selected", GALA_TYPE_WORKSPACE_CLONE, &_tmp16_, NULL, FALSE);
					g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) _gala_multitasking_view_activate_workspace_gala_workspace_clone_selected, self);
					_tmp17_ = self->priv->icon_groups;
					_tmp18_ = workspace_clone;
					_tmp19_ = gala_workspace_clone_get_icon_group (_tmp18_);
					_tmp20_ = _tmp19_;
					gala_icon_group_container_remove_group (_tmp17_, _tmp20_);
					_tmp21_ = workspace_clone;
					clutter_actor_destroy ((ClutterActor*) _tmp21_);
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	gala_multitasking_view_update_monitors (self);
	gala_multitasking_view_update_positions (self, FALSE);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda77__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda77_ (self);
	return result;
}

static void
_gala_multitasking_view___lambda76_ (Block66Data* _data66_,
                                     MetaPreference pref)
{
	GalaMultitaskingView* self;
	gboolean _tmp0_ = FALSE;
	self = _data66_->self;
	if (pref == META_PREF_WORKSPACES_ONLY_ON_PRIMARY) {
		gala_multitasking_view_update_monitors (self);
		return;
	}
	if (meta_prefs_get_dynamic_workspaces ()) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		if (pref != META_PREF_DYNAMIC_WORKSPACES) {
			_tmp1_ = pref != META_PREF_NUM_WORKSPACES;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda77__gsource_func, block66_data_ref (_data66_), block66_data_unref);
}

static void
__gala_multitasking_view___lambda76__meta_prefs_changed_func (MetaPreference pref,
                                                              gpointer self)
{
	_gala_multitasking_view___lambda76_ (self, pref);
}

static void
_gala_multitasking_view_update_brightness_effect_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self)
{
	gala_multitasking_view_update_brightness_effect ((GalaMultitaskingView*) self);
}

static GObject *
gala_multitasking_view_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaMultitaskingView * self;
	Block66Data* _data66_;
	GSettings* _tmp0_;
	GraniteSettings* _tmp1_;
	GraniteSettings* _tmp2_;
	GalaWindowManager* _tmp3_;
	MetaDisplay* _tmp4_;
	MetaDisplay* _tmp5_;
	GalaGestureTracker* _tmp6_;
	GalaGestureTracker* _tmp7_;
	GalaGestureTracker* _tmp8_;
	GalaGestureTracker* _tmp9_;
	GalaGestureTracker* _tmp10_;
	GalaGestureTracker* _tmp11_;
	GalaGestureTracker* _tmp12_;
	ClutterActor* _tmp13_;
	GalaWindowManager* _tmp14_;
	MetaDisplay* _tmp15_;
	MetaDisplay* _tmp16_;
	GalaIconGroupContainer* _tmp17_;
	ClutterActor* _tmp18_;
	ClutterBrightnessContrastEffect* _tmp19_;
	GalaBackgroundManager* blurred_bg = NULL;
	GalaWindowManager* _tmp20_;
	MetaDisplay* _tmp21_;
	GalaBackgroundManager* _tmp22_;
	GalaBackgroundManager* _tmp23_;
	GalaBackgroundManager* _tmp24_;
	GalaBlurEffect* _tmp25_;
	GalaBlurEffect* _tmp26_;
	GalaBackgroundManager* _tmp27_;
	ClutterBrightnessContrastEffect* _tmp28_;
	GalaBackgroundManager* _tmp29_;
	ClutterActor* _tmp30_;
	ClutterActor* _tmp31_;
	GalaIconGroupContainer* _tmp32_;
	ClutterActor* _tmp33_;
	ClutterActor* _tmp34_;
	ClutterActor* _tmp35_;
	ClutterActor* _tmp36_;
	MetaDisplay* _tmp37_;
	MetaWorkspaceManager* _tmp38_;
	MetaWorkspaceManager* _tmp39_;
	MetaWorkspaceManager* _tmp40_;
	MetaWorkspaceManager* _tmp41_;
	MetaWorkspaceManager* _tmp42_;
	MetaMonitorManager* monitor_manager = NULL;
	MetaDisplay* _tmp43_;
	MetaContext* _tmp44_;
	MetaBackend* _tmp45_;
	MetaMonitorManager* _tmp46_;
	MetaMonitorManager* _tmp47_;
	GraniteSettings* _tmp48_;
	parent_class = G_OBJECT_CLASS (gala_multitasking_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView);
	_data66_ = g_slice_new0 (Block66Data);
	_data66_->_ref_count_ = 1;
	_data66_->self = g_object_ref (self);
	_tmp0_ = g_settings_new ("org.pantheon.desktop.gala.behavior");
	_g_object_unref0 (self->priv->gala_behavior_settings);
	self->priv->gala_behavior_settings = _tmp0_;
	_tmp1_ = granite_settings_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->granite_settings);
	self->priv->granite_settings = _tmp2_;
	g_object_set ((ClutterActor*) self, "visible", FALSE, NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	clutter_actor_set_clip_to_allocation ((ClutterActor*) self, TRUE);
	self->priv->opened = FALSE;
	_tmp3_ = self->priv->_wm;
	_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->display);
	self->priv->display = _tmp5_;
	_tmp6_ = gala_gesture_tracker_new (GALA_MULTITASKING_VIEW_ANIMATION_DURATION, GALA_MULTITASKING_VIEW_ANIMATION_DURATION);
	_g_object_unref0 (self->priv->multitasking_gesture_tracker);
	self->priv->multitasking_gesture_tracker = _tmp6_;
	_tmp7_ = self->priv->multitasking_gesture_tracker;
	gala_gesture_tracker_enable_touchpad (_tmp7_);
	_tmp8_ = self->priv->multitasking_gesture_tracker;
	g_signal_connect_object (_tmp8_, "on-gesture-detected", (GCallback) _gala_multitasking_view_on_multitasking_gesture_detected_gala_gesture_tracker_on_gesture_detected, self, 0);
	_tmp9_ = gala_gesture_tracker_new ((gint) GALA_ANIMATION_DURATION_WORKSPACE_SWITCH_MIN, (gint) GALA_ANIMATION_DURATION_WORKSPACE_SWITCH);
	_g_object_unref0 (self->priv->workspace_gesture_tracker);
	self->priv->workspace_gesture_tracker = _tmp9_;
	_tmp10_ = self->priv->workspace_gesture_tracker;
	gala_gesture_tracker_enable_touchpad (_tmp10_);
	_tmp11_ = self->priv->workspace_gesture_tracker;
	gala_gesture_tracker_enable_scroll (_tmp11_, (ClutterActor*) self, CLUTTER_ORIENTATION_HORIZONTAL);
	_tmp12_ = self->priv->workspace_gesture_tracker;
	g_signal_connect_object (_tmp12_, "on-gesture-detected", (GCallback) _gala_multitasking_view_on_workspace_gesture_detected_gala_gesture_tracker_on_gesture_detected, self, 0);
	_tmp13_ = clutter_actor_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->workspaces);
	self->priv->workspaces = _tmp13_;
	_tmp14_ = self->priv->_wm;
	_tmp15_ = self->priv->display;
	_tmp16_ = self->priv->display;
	_tmp17_ = gala_icon_group_container_new (_tmp14_, meta_display_get_monitor_scale (_tmp15_, meta_display_get_primary_monitor (_tmp16_)));
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->icon_groups);
	self->priv->icon_groups = _tmp17_;
	_tmp18_ = clutter_actor_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->dock_clones);
	self->priv->dock_clones = _tmp18_;
	_tmp19_ = (ClutterBrightnessContrastEffect*) clutter_brightness_contrast_effect_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->brightness_effect);
	self->priv->brightness_effect = _tmp19_;
	gala_multitasking_view_update_brightness_effect (self);
	_tmp20_ = self->priv->_wm;
	_tmp21_ = self->priv->display;
	_tmp22_ = gala_background_manager_new (_tmp20_, meta_display_get_primary_monitor (_tmp21_), TRUE);
	g_object_ref_sink (_tmp22_);
	blurred_bg = _tmp22_;
	_tmp23_ = blurred_bg;
	_tmp24_ = blurred_bg;
	_tmp25_ = gala_blur_effect_new ((ClutterActor*) _tmp24_, (gfloat) 18);
	g_object_ref_sink (_tmp25_);
	_tmp26_ = _tmp25_;
	clutter_actor_add_effect ((ClutterActor*) _tmp23_, (ClutterEffect*) _tmp26_);
	_g_object_unref0 (_tmp26_);
	_tmp27_ = blurred_bg;
	_tmp28_ = self->priv->brightness_effect;
	clutter_actor_add_effect ((ClutterActor*) _tmp27_, (ClutterEffect*) _tmp28_);
	_tmp29_ = blurred_bg;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp29_);
	_tmp30_ = clutter_actor_new ();
	g_object_ref_sink (_tmp30_);
	_g_object_unref0 (self->priv->primary_monitor_container);
	self->priv->primary_monitor_container = _tmp30_;
	_tmp31_ = self->priv->primary_monitor_container;
	_tmp32_ = self->priv->icon_groups;
	clutter_actor_add_child (_tmp31_, (ClutterActor*) _tmp32_);
	_tmp33_ = self->priv->primary_monitor_container;
	_tmp34_ = self->priv->workspaces;
	clutter_actor_add_child (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->primary_monitor_container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp35_);
	_tmp36_ = self->priv->dock_clones;
	clutter_actor_add_child ((ClutterActor*) self, _tmp36_);
	_tmp37_ = self->priv->display;
	_tmp38_ = meta_display_get_workspace_manager (_tmp37_);
	_data66_->manager = _tmp38_;
	_tmp39_ = _data66_->manager;
	g_signal_connect_object (_tmp39_, "workspace-added", (GCallback) _gala_multitasking_view_add_workspace_meta_workspace_manager_workspace_added, self, 0);
	_tmp40_ = _data66_->manager;
	g_signal_connect_object (_tmp40_, "workspace-removed", (GCallback) _gala_multitasking_view_remove_workspace_meta_workspace_manager_workspace_removed, self, 0);
	_tmp41_ = _data66_->manager;
	g_signal_connect_object (_tmp41_, "workspaces-reordered", (GCallback) __gala_multitasking_view___lambda74__meta_workspace_manager_workspaces_reordered, self, 0);
	_tmp42_ = _data66_->manager;
	g_signal_connect_object (_tmp42_, "workspace-switched", (GCallback) __gala_multitasking_view___lambda75__meta_workspace_manager_workspace_switched, self, G_CONNECT_AFTER);
	(self->priv->window_containers_monitors == NULL) ? NULL : (self->priv->window_containers_monitors = (_g_list_free__g_object_unref0_ (self->priv->window_containers_monitors), NULL));
	self->priv->window_containers_monitors = NULL;
	gala_multitasking_view_update_monitors (self);
	_tmp43_ = self->priv->display;
	_tmp44_ = meta_display_get_context (_tmp43_);
	_tmp45_ = meta_context_get_backend (_tmp44_);
	_tmp46_ = meta_backend_get_monitor_manager (_tmp45_);
	monitor_manager = _tmp46_;
	_tmp47_ = monitor_manager;
	g_signal_connect_object (_tmp47_, "monitors-changed", (GCallback) _gala_multitasking_view_update_monitors_meta_monitor_manager_monitors_changed, self, 0);
	meta_prefs_add_listener (__gala_multitasking_view___lambda76__meta_prefs_changed_func, _data66_);
	_tmp48_ = self->priv->granite_settings;
	g_signal_connect_object ((GObject*) _tmp48_, "notify::prefers-color-scheme", (GCallback) _gala_multitasking_view_update_brightness_effect_g_object_notify, self, 0);
	_g_object_unref0 (blurred_bg);
	block66_data_unref (_data66_);
	_data66_ = NULL;
	return obj;
}

static void
gala_multitasking_view_class_init (GalaMultitaskingViewClass * klass,
                                   gpointer klass_data)
{
	gala_multitasking_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaMultitaskingView_private_offset);
	((ClutterActorClass *) klass)->scroll_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_multitasking_view_real_scroll_event;
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_multitasking_view_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_multitasking_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_multitasking_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_multitasking_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_multitasking_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MULTITASKING_VIEW_WM_PROPERTY, gala_multitasking_view_properties[GALA_MULTITASKING_VIEW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
gala_multitasking_view_gala_activatable_component_interface_init (GalaActivatableComponentIface * iface,
                                                                  gpointer iface_data)
{
	gala_multitasking_view_gala_activatable_component_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_opened = (gboolean (*) (GalaActivatableComponent*)) gala_multitasking_view_real_is_opened;
	iface->open = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_multitasking_view_real_open;
	iface->close = (void (*) (GalaActivatableComponent*, GHashTable*)) gala_multitasking_view_real_close;
}

static void
gala_multitasking_view_instance_init (GalaMultitaskingView * self,
                                      gpointer klass)
{
	self->priv = gala_multitasking_view_get_instance_private (self);
	self->priv->opened = FALSE;
	self->priv->animating = FALSE;
	self->priv->switching_workspace_with_gesture = FALSE;
}

static void
gala_multitasking_view_finalize (GObject * obj)
{
	GalaMultitaskingView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView);
	_g_object_unref0 (self->priv->multitasking_gesture_tracker);
	_g_object_unref0 (self->priv->workspace_gesture_tracker);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->display);
	_g_object_unref0 (self->priv->modal_proxy);
	(self->priv->window_containers_monitors == NULL) ? NULL : (self->priv->window_containers_monitors = (_g_list_free__g_object_unref0_ (self->priv->window_containers_monitors), NULL));
	_g_object_unref0 (self->priv->icon_groups);
	_g_object_unref0 (self->priv->workspaces);
	_g_object_unref0 (self->priv->dock_clones);
	_g_object_unref0 (self->priv->primary_monitor_container);
	_g_object_unref0 (self->priv->brightness_effect);
	_g_object_unref0 (self->priv->gala_behavior_settings);
	_g_object_unref0 (self->priv->granite_settings);
	G_OBJECT_CLASS (gala_multitasking_view_parent_class)->finalize (obj);
}

/**
     * The central class for the MultitaskingView which takes care of
     * preparing the wm, opening the components and holds containers for
     * the icon groups, the WorkspaceClones and the MonitorClones.
     */
static GType
gala_multitasking_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaMultitaskingViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_multitasking_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaMultitaskingView), 0, (GInstanceInitFunc) gala_multitasking_view_instance_init, NULL };
	static const GInterfaceInfo gala_activatable_component_info = { (GInterfaceInitFunc) gala_multitasking_view_gala_activatable_component_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_multitasking_view_type_id;
	gala_multitasking_view_type_id = g_type_register_static (clutter_actor_get_type (), "GalaMultitaskingView", &g_define_type_info, 0);
	g_type_add_interface_static (gala_multitasking_view_type_id, GALA_TYPE_ACTIVATABLE_COMPONENT, &gala_activatable_component_info);
	GalaMultitaskingView_private_offset = g_type_add_instance_private (gala_multitasking_view_type_id, sizeof (GalaMultitaskingViewPrivate));
	return gala_multitasking_view_type_id;
}

GType
gala_multitasking_view_get_type (void)
{
	static volatile gsize gala_multitasking_view_type_id__once = 0;
	if (g_once_init_enter (&gala_multitasking_view_type_id__once)) {
		GType gala_multitasking_view_type_id;
		gala_multitasking_view_type_id = gala_multitasking_view_get_type_once ();
		g_once_init_leave (&gala_multitasking_view_type_id__once, gala_multitasking_view_type_id);
	}
	return gala_multitasking_view_type_id__once;
}

static void
_vala_gala_multitasking_view_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	GalaMultitaskingView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView);
	switch (property_id) {
		case GALA_MULTITASKING_VIEW_WM_PROPERTY:
		g_value_set_object (value, gala_multitasking_view_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_multitasking_view_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	GalaMultitaskingView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MULTITASKING_VIEW, GalaMultitaskingView);
	switch (property_id) {
		case GALA_MULTITASKING_VIEW_WM_PROPERTY:
		gala_multitasking_view_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

