/* MonitorClone.c generated by valac 0.56.16, the Vala compiler
 * generated from MonitorClone.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include <clutter/clutter.h>
#include <glib-object.h>
#include "gala.h"
#include <meta/display.h>
#include <glib.h>
#include <meta/meta-background-group.h>
#include <meta/window.h>
#include <mtk/mtk.h>
#include <float.h>
#include <math.h>
#include <meta/meta-window-actor.h>
#include <meta/compositor-mutter.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_MONITOR_CLONE (gala_monitor_clone_get_type ())
#define GALA_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorClone))
#define GALA_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))
#define GALA_IS_MONITOR_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_MONITOR_CLONE))
#define GALA_IS_MONITOR_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_MONITOR_CLONE))
#define GALA_MONITOR_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_MONITOR_CLONE, GalaMonitorCloneClass))

typedef struct _GalaMonitorClone GalaMonitorClone;
typedef struct _GalaMonitorCloneClass GalaMonitorCloneClass;
typedef struct _GalaMonitorClonePrivate GalaMonitorClonePrivate;

#define GALA_TYPE_GESTURE_TRACKER (gala_gesture_tracker_get_type ())
#define GALA_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTracker))
#define GALA_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))
#define GALA_IS_GESTURE_TRACKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_TRACKER))
#define GALA_IS_GESTURE_TRACKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_TRACKER))
#define GALA_GESTURE_TRACKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_TRACKER, GalaGestureTrackerClass))

typedef struct _GalaGestureTracker GalaGestureTracker;
typedef struct _GalaGestureTrackerClass GalaGestureTrackerClass;

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
enum  {
	GALA_MONITOR_CLONE_0_PROPERTY,
	GALA_MONITOR_CLONE_WM_PROPERTY,
	GALA_MONITOR_CLONE_DISPLAY_PROPERTY,
	GALA_MONITOR_CLONE_MONITOR_PROPERTY,
	GALA_MONITOR_CLONE_GESTURE_TRACKER_PROPERTY,
	GALA_MONITOR_CLONE_NUM_PROPERTIES
};
static GParamSpec* gala_monitor_clone_properties[GALA_MONITOR_CLONE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_MONITOR_CLONE_WINDOW_SELECTED_SIGNAL,
	GALA_MONITOR_CLONE_NUM_SIGNALS
};
static guint gala_monitor_clone_signals[GALA_MONITOR_CLONE_NUM_SIGNALS] = {0};

struct _GalaMonitorClone {
	ClutterActor parent_instance;
	GalaMonitorClonePrivate * priv;
};

struct _GalaMonitorCloneClass {
	ClutterActorClass parent_class;
};

struct _GalaMonitorClonePrivate {
	GalaWindowManager* _wm;
	MetaDisplay* _display;
	gint _monitor;
	GalaGestureTracker* _gesture_tracker;
	GalaWindowCloneContainer* window_container;
	GalaBackgroundManager* background;
};

static gint GalaMonitorClone_private_offset;
static gpointer gala_monitor_clone_parent_class = NULL;

VALA_EXTERN GType gala_monitor_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaMonitorClone, g_object_unref)
VALA_EXTERN GType gala_gesture_tracker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureTracker, g_object_unref)
VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
VALA_EXTERN MetaDisplay* gala_monitor_clone_get_display (GalaMonitorClone* self);
static void gala_monitor_clone_window_entered (GalaMonitorClone* self,
                                        gint window_monitor,
                                        MetaWindow* window);
static void _gala_monitor_clone_window_entered_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                             gint object,
                                                                             MetaWindow* p0,
                                                                             gpointer self);
static void gala_monitor_clone_window_left (GalaMonitorClone* self,
                                     gint window_monitor,
                                     MetaWindow* window);
static void _gala_monitor_clone_window_left_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                       gint object,
                                                                       MetaWindow* p0,
                                                                       gpointer self);
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_new (GalaWindowManager* wm,
                                          MetaDisplay* display,
                                          gint monitor,
                                          GalaGestureTracker* gesture_tracker);
VALA_EXTERN GalaMonitorClone* gala_monitor_clone_construct (GType object_type,
                                                GalaWindowManager* wm,
                                                MetaDisplay* display,
                                                gint monitor,
                                                GalaGestureTracker* gesture_tracker);
VALA_EXTERN void gala_monitor_clone_update_allocation (GalaMonitorClone* self);
VALA_EXTERN gint gala_monitor_clone_get_monitor (GalaMonitorClone* self);
VALA_EXTERN void gala_window_clone_container_set_monitor_scale (GalaWindowCloneContainer* self,
                                                    gfloat value);
VALA_EXTERN void gala_monitor_clone_open (GalaMonitorClone* self,
                              gboolean with_gesture,
                              gboolean is_cancel_animation);
VALA_EXTERN void gala_window_clone_container_restack_windows (GalaWindowCloneContainer* self);
VALA_EXTERN void gala_window_clone_container_open (GalaWindowCloneContainer* self,
                                       MetaWindow* selected_window,
                                       gboolean with_gesture,
                                       gboolean is_cancel_animation);
VALA_EXTERN void gala_monitor_clone_close (GalaMonitorClone* self,
                               gboolean with_gesture,
                               gboolean is_cancel_animation);
VALA_EXTERN void gala_window_clone_container_close (GalaWindowCloneContainer* self,
                                        gboolean with_gesture,
                                        gboolean is_cancel_animation);
VALA_EXTERN void gala_window_clone_container_remove_window (GalaWindowCloneContainer* self,
                                                MetaWindow* window);
VALA_EXTERN void gala_window_clone_container_add_window (GalaWindowCloneContainer* self,
                                             MetaWindow* window);
VALA_EXTERN GalaWindowManager* gala_monitor_clone_get_wm (GalaMonitorClone* self);
static void gala_monitor_clone_set_wm (GalaMonitorClone* self,
                                GalaWindowManager* value);
static void gala_monitor_clone_set_display (GalaMonitorClone* self,
                                     MetaDisplay* value);
static void gala_monitor_clone_set_monitor (GalaMonitorClone* self,
                                     gint value);
VALA_EXTERN GalaGestureTracker* gala_monitor_clone_get_gesture_tracker (GalaMonitorClone* self);
static void gala_monitor_clone_set_gesture_tracker (GalaMonitorClone* self,
                                             GalaGestureTracker* value);
static GObject * gala_monitor_clone_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_new (GalaWindowManager* wm,
                                                    gint monitor_index,
                                                    gboolean control_position);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_construct (GType object_type,
                                                          GalaWindowManager* wm,
                                                          gint monitor_index,
                                                          gboolean control_position);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           GalaGestureTracker* gesture_tracker,
                                                           gfloat scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 GalaGestureTracker* gesture_tracker,
                                                                 gfloat scale,
                                                                 gboolean overview_mode);
static void _gala_monitor_clone___lambda49_ (GalaMonitorClone* self,
                                      MetaWindow* w);
static void __gala_monitor_clone___lambda49__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                                   MetaWindow* window,
                                                                                   gpointer self);
static void gala_monitor_clone_finalize (GObject * obj);
static GType gala_monitor_clone_get_type_once (void);
static void _vala_gala_monitor_clone_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gala_monitor_clone_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_monitor_clone_get_instance_private (GalaMonitorClone* self)
{
	return G_STRUCT_MEMBER_P (self, GalaMonitorClone_private_offset);
}

static void
_gala_monitor_clone_window_entered_meta_display_window_entered_monitor (MetaDisplay* _sender,
                                                                        gint object,
                                                                        MetaWindow* p0,
                                                                        gpointer self)
{
	gala_monitor_clone_window_entered ((GalaMonitorClone*) self, object, p0);
}

static void
_gala_monitor_clone_window_left_meta_display_window_left_monitor (MetaDisplay* _sender,
                                                                  gint object,
                                                                  MetaWindow* p0,
                                                                  gpointer self)
{
	gala_monitor_clone_window_left ((GalaMonitorClone*) self, object, p0);
}

GalaMonitorClone*
gala_monitor_clone_construct (GType object_type,
                              GalaWindowManager* wm,
                              MetaDisplay* display,
                              gint monitor,
                              GalaGestureTracker* gesture_tracker)
{
	GalaMonitorClone * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (gesture_tracker != NULL, NULL);
	self = (GalaMonitorClone*) g_object_new (object_type, "wm", wm, "display", display, "monitor", monitor, "gesture-tracker", gesture_tracker, NULL);
	return self;
}

GalaMonitorClone*
gala_monitor_clone_new (GalaWindowManager* wm,
                        MetaDisplay* display,
                        gint monitor,
                        GalaGestureTracker* gesture_tracker)
{
	return gala_monitor_clone_construct (GALA_TYPE_MONITOR_CLONE, wm, display, monitor, gesture_tracker);
}

/**
         * Make sure the MonitorClone is at the location of the monitor on the stage
         */
void
gala_monitor_clone_update_allocation (GalaMonitorClone* self)
{
	MtkRectangle monitor_geometry = {0};
	MetaDisplay* _tmp0_;
	gint _tmp1_;
	MtkRectangle _tmp2_ = {0};
	MtkRectangle _tmp3_;
	MtkRectangle _tmp4_;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	GalaWindowCloneContainer* _tmp7_;
	MtkRectangle _tmp8_;
	MtkRectangle _tmp9_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp10_;
	gint _tmp11_;
	GalaWindowCloneContainer* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = self->priv->_monitor;
	meta_display_get_monitor_geometry (_tmp0_, _tmp1_, &_tmp2_);
	monitor_geometry = _tmp2_;
	_tmp3_ = monitor_geometry;
	_tmp4_ = monitor_geometry;
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp3_.x, (gfloat) _tmp4_.y);
	_tmp5_ = monitor_geometry;
	_tmp6_ = monitor_geometry;
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp5_.width, (gfloat) _tmp6_.height);
	_tmp7_ = self->priv->window_container;
	_tmp8_ = monitor_geometry;
	_tmp9_ = monitor_geometry;
	clutter_actor_set_size ((ClutterActor*) _tmp7_, (gfloat) _tmp8_.width, (gfloat) _tmp9_.height);
	_tmp10_ = self->priv->_display;
	_tmp11_ = self->priv->_monitor;
	scale = meta_display_get_monitor_scale (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->window_container;
	gala_window_clone_container_set_monitor_scale (_tmp12_, scale);
}

/**
         * Animate the windows from their old location to a tiled layout
         */
void
gala_monitor_clone_open (GalaMonitorClone* self,
                         gboolean with_gesture,
                         gboolean is_cancel_animation)
{
	GalaWindowCloneContainer* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_container;
	gala_window_clone_container_restack_windows (_tmp0_);
	_tmp1_ = self->priv->window_container;
	gala_window_clone_container_open (_tmp1_, NULL, with_gesture, is_cancel_animation);
}

/**
         * Animate the windows back to their old location
         */
void
gala_monitor_clone_close (GalaMonitorClone* self,
                          gboolean with_gesture,
                          gboolean is_cancel_animation)
{
	GalaWindowCloneContainer* _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window_container;
	gala_window_clone_container_restack_windows (_tmp0_);
	_tmp1_ = self->priv->window_container;
	gala_window_clone_container_close (_tmp1_, with_gesture, is_cancel_animation);
}

static void
gala_monitor_clone_window_left (GalaMonitorClone* self,
                                gint window_monitor,
                                MetaWindow* window)
{
	gint _tmp0_;
	GalaWindowCloneContainer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_monitor;
	if (window_monitor != _tmp0_) {
		return;
	}
	_tmp1_ = self->priv->window_container;
	gala_window_clone_container_remove_window (_tmp1_, window);
}

static void
gala_monitor_clone_window_entered (GalaMonitorClone* self,
                                   gint window_monitor,
                                   MetaWindow* window)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	GalaWindowCloneContainer* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp1_ = self->priv->_monitor;
	if (window_monitor != _tmp1_) {
		_tmp0_ = TRUE;
	} else {
		MetaWindowType _tmp2_;
		MetaWindowType _tmp3_;
		_tmp2_ = meta_window_get_window_type (window);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ != META_WINDOW_NORMAL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->window_container;
	gala_window_clone_container_add_window (_tmp4_, window);
}

GalaWindowManager*
gala_monitor_clone_get_wm (GalaMonitorClone* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_monitor_clone_set_wm (GalaMonitorClone* self,
                           GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_WM_PROPERTY]);
	}
}

MetaDisplay*
gala_monitor_clone_get_display (GalaMonitorClone* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_monitor_clone_set_display (GalaMonitorClone* self,
                                MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_DISPLAY_PROPERTY]);
	}
}

gint
gala_monitor_clone_get_monitor (GalaMonitorClone* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor;
	return result;
}

static void
gala_monitor_clone_set_monitor (GalaMonitorClone* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_monitor (self);
	if (old_value != value) {
		self->priv->_monitor = value;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_PROPERTY]);
	}
}

GalaGestureTracker*
gala_monitor_clone_get_gesture_tracker (GalaMonitorClone* self)
{
	GalaGestureTracker* result;
	GalaGestureTracker* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_gesture_tracker;
	result = _tmp0_;
	return result;
}

static void
gala_monitor_clone_set_gesture_tracker (GalaMonitorClone* self,
                                        GalaGestureTracker* value)
{
	GalaGestureTracker* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_monitor_clone_get_gesture_tracker (self);
	if (old_value != value) {
		GalaGestureTracker* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gesture_tracker);
		self->priv->_gesture_tracker = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_monitor_clone_properties[GALA_MONITOR_CLONE_GESTURE_TRACKER_PROPERTY]);
	}
}

static void
_gala_monitor_clone___lambda49_ (GalaMonitorClone* self,
                                 MetaWindow* w)
{
	g_return_if_fail (w != NULL);
	g_signal_emit (self, gala_monitor_clone_signals[GALA_MONITOR_CLONE_WINDOW_SELECTED_SIGNAL], 0, w);
}

static void
__gala_monitor_clone___lambda49__gala_window_clone_container_window_selected (GalaWindowCloneContainer* _sender,
                                                                              MetaWindow* window,
                                                                              gpointer self)
{
	_gala_monitor_clone___lambda49_ ((GalaMonitorClone*) self, window);
}

static GObject *
gala_monitor_clone_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaMonitorClone * self;
	GalaWindowManager* _tmp0_;
	gint _tmp1_;
	GalaBackgroundManager* _tmp2_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp3_;
	gint _tmp4_;
	GalaWindowManager* _tmp5_;
	GalaGestureTracker* _tmp6_;
	GalaWindowCloneContainer* _tmp7_;
	GalaWindowCloneContainer* _tmp8_;
	MetaDisplay* _tmp9_;
	MetaDisplay* _tmp10_;
	GList* window_actors = NULL;
	MetaDisplay* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	GalaBackgroundManager* _tmp21_;
	GalaWindowCloneContainer* _tmp22_;
	GalaDragDropAction* drop = NULL;
	GalaDragDropAction* _tmp23_;
	GalaDragDropAction* _tmp24_;
	parent_class = G_OBJECT_CLASS (gala_monitor_clone_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = self->priv->_monitor;
	_tmp2_ = gala_background_manager_new (_tmp0_, _tmp1_, FALSE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->background);
	self->priv->background = _tmp2_;
	_tmp3_ = self->priv->_display;
	_tmp4_ = self->priv->_monitor;
	scale = meta_display_get_monitor_scale (_tmp3_, _tmp4_);
	_tmp5_ = self->priv->_wm;
	_tmp6_ = self->priv->_gesture_tracker;
	_tmp7_ = gala_window_clone_container_new (_tmp5_, _tmp6_, scale, FALSE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->window_container);
	self->priv->window_container = _tmp7_;
	_tmp8_ = self->priv->window_container;
	g_signal_connect_object (_tmp8_, "window-selected", (GCallback) __gala_monitor_clone___lambda49__gala_window_clone_container_window_selected, self, 0);
	_tmp9_ = self->priv->_display;
	g_signal_connect_object (_tmp9_, "window-entered-monitor", (GCallback) _gala_monitor_clone_window_entered_meta_display_window_entered_monitor, self, 0);
	_tmp10_ = self->priv->_display;
	g_signal_connect_object (_tmp10_, "window-left-monitor", (GCallback) _gala_monitor_clone_window_left_meta_display_window_left_monitor, self, 0);
	_tmp11_ = self->priv->_display;
	_tmp12_ = meta_get_window_actors (_tmp11_);
	window_actors = _tmp12_;
	_tmp13_ = window_actors;
	{
		GList* window_actor_collection = NULL;
		GList* window_actor_it = NULL;
		window_actor_collection = _tmp13_;
		for (window_actor_it = window_actor_collection; window_actor_it != NULL; window_actor_it = window_actor_it->next) {
			MetaWindowActor* window_actor = NULL;
			window_actor = (MetaWindowActor*) window_actor_it->data;
			{
				MetaWindowActor* _tmp14_;
				MetaWindow* window = NULL;
				MetaWindowActor* _tmp15_;
				MetaWindow* _tmp16_;
				MetaWindow* _tmp17_;
				gint _tmp18_;
				_tmp14_ = window_actor;
				if (meta_window_actor_is_destroyed (_tmp14_)) {
					continue;
				}
				_tmp15_ = window_actor;
				_tmp16_ = meta_window_actor_get_meta_window (_tmp15_);
				window = _tmp16_;
				_tmp17_ = window;
				_tmp18_ = self->priv->_monitor;
				if (meta_window_get_monitor (_tmp17_) == _tmp18_) {
					gint _tmp19_;
					MetaWindow* _tmp20_;
					_tmp19_ = self->priv->_monitor;
					_tmp20_ = window;
					gala_monitor_clone_window_entered (self, _tmp19_, _tmp20_);
				}
			}
		}
	}
	_tmp21_ = self->priv->background;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp21_);
	_tmp22_ = self->priv->window_container;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp22_);
	_tmp23_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp23_);
	drop = _tmp23_;
	_tmp24_ = drop;
	clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp24_);
	gala_monitor_clone_update_allocation (self);
	_g_object_unref0 (drop);
	return obj;
}

static void
gala_monitor_clone_class_init (GalaMonitorCloneClass * klass,
                               gpointer klass_data)
{
	gala_monitor_clone_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaMonitorClone_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_monitor_clone_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_monitor_clone_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_monitor_clone_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_monitor_clone_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_WM_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_DISPLAY_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_MONITOR_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_MONITOR_PROPERTY] = g_param_spec_int ("monitor", "monitor", "monitor", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_MONITOR_CLONE_GESTURE_TRACKER_PROPERTY, gala_monitor_clone_properties[GALA_MONITOR_CLONE_GESTURE_TRACKER_PROPERTY] = g_param_spec_object ("gesture-tracker", "gesture-tracker", "gesture-tracker", GALA_TYPE_GESTURE_TRACKER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_monitor_clone_signals[GALA_MONITOR_CLONE_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_MONITOR_CLONE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
}

static void
gala_monitor_clone_instance_init (GalaMonitorClone * self,
                                  gpointer klass)
{
	self->priv = gala_monitor_clone_get_instance_private (self);
}

static void
gala_monitor_clone_finalize (GObject * obj)
{
	GalaMonitorClone * self;
	MetaDisplay* _tmp0_;
	guint _tmp1_;
	MetaDisplay* _tmp2_;
	guint _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	_tmp0_ = self->priv->_display;
	g_signal_parse_name ("window-entered-monitor", meta_display_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_monitor_clone_window_entered_meta_display_window_entered_monitor, self);
	_tmp2_ = self->priv->_display;
	g_signal_parse_name ("window-left-monitor", meta_display_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gala_monitor_clone_window_left_meta_display_window_left_monitor, self);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_gesture_tracker);
	_g_object_unref0 (self->priv->window_container);
	_g_object_unref0 (self->priv->background);
	G_OBJECT_CLASS (gala_monitor_clone_parent_class)->finalize (obj);
}

/**
     * More or less utility class to contain a WindowCloneContainer for each
     * non-primary monitor. It's the pendant to the WorkspaceClone which is
     * only placed on the primary monitor. It also draws a wallpaper behind itself
     * as the WindowGroup is hidden while the view is active. Only used when
     * workspaces-only-on-primary is set to true.
     */
static GType
gala_monitor_clone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaMonitorCloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_monitor_clone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaMonitorClone), 0, (GInstanceInitFunc) gala_monitor_clone_instance_init, NULL };
	GType gala_monitor_clone_type_id;
	gala_monitor_clone_type_id = g_type_register_static (clutter_actor_get_type (), "GalaMonitorClone", &g_define_type_info, 0);
	GalaMonitorClone_private_offset = g_type_add_instance_private (gala_monitor_clone_type_id, sizeof (GalaMonitorClonePrivate));
	return gala_monitor_clone_type_id;
}

GType
gala_monitor_clone_get_type (void)
{
	static volatile gsize gala_monitor_clone_type_id__once = 0;
	if (g_once_init_enter (&gala_monitor_clone_type_id__once)) {
		GType gala_monitor_clone_type_id;
		gala_monitor_clone_type_id = gala_monitor_clone_get_type_once ();
		g_once_init_leave (&gala_monitor_clone_type_id__once, gala_monitor_clone_type_id);
	}
	return gala_monitor_clone_type_id__once;
}

static void
_vala_gala_monitor_clone_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GalaMonitorClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	switch (property_id) {
		case GALA_MONITOR_CLONE_WM_PROPERTY:
		g_value_set_object (value, gala_monitor_clone_get_wm (self));
		break;
		case GALA_MONITOR_CLONE_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_monitor_clone_get_display (self));
		break;
		case GALA_MONITOR_CLONE_MONITOR_PROPERTY:
		g_value_set_int (value, gala_monitor_clone_get_monitor (self));
		break;
		case GALA_MONITOR_CLONE_GESTURE_TRACKER_PROPERTY:
		g_value_set_object (value, gala_monitor_clone_get_gesture_tracker (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_monitor_clone_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GalaMonitorClone * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_MONITOR_CLONE, GalaMonitorClone);
	switch (property_id) {
		case GALA_MONITOR_CLONE_WM_PROPERTY:
		gala_monitor_clone_set_wm (self, g_value_get_object (value));
		break;
		case GALA_MONITOR_CLONE_DISPLAY_PROPERTY:
		gala_monitor_clone_set_display (self, g_value_get_object (value));
		break;
		case GALA_MONITOR_CLONE_MONITOR_PROPERTY:
		gala_monitor_clone_set_monitor (self, g_value_get_int (value));
		break;
		case GALA_MONITOR_CLONE_GESTURE_TRACKER_PROPERTY:
		gala_monitor_clone_set_gesture_tracker (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

