/* IconGroup.c generated by valac 0.56.16, the Vala compiler
 * generated from IconGroup.vala, do not modify */

/*
 * Copyright 2014 Tom Beckmann
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <meta/workspace.h>
#include <clutter/clutter.h>
#include <cairo-gobject.h>
#include <cogl/cogl.h>
#include <meta/window.h>
#include <granite.h>
#include <meta/meta-workspace-manager.h>
#include <meta/display.h>
#include <meta/prefs.h>
#include <meta/meta-plugin.h>
#include <meta/common.h>
#include <string.h>

#define GALA_ICON_GROUP_SIZE 64
#define GALA_ICON_GROUP_PLUS_SIZE 6
#define GALA_ICON_GROUP_PLUS_WIDTH 26
#define GALA_ICON_GROUP_BACKDROP_ABSOLUTE_OPACITY 40
#define GALA_WORKSPACE_CLONE_BOTTOM_OFFSET 100
#define GALA_WORKSPACE_INSERT_THUMB_EXPAND_DELAY 300
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_ICON_GROUP (gala_icon_group_get_type ())
#define GALA_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroup))
#define GALA_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))
#define GALA_IS_ICON_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP))
#define GALA_IS_ICON_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP))
#define GALA_ICON_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP, GalaIconGroupClass))

typedef struct _GalaIconGroup GalaIconGroup;
typedef struct _GalaIconGroupClass GalaIconGroupClass;
typedef struct _GalaIconGroupPrivate GalaIconGroupPrivate;
enum  {
	GALA_ICON_GROUP_0_PROPERTY,
	GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY,
	GALA_ICON_GROUP_WM_PROPERTY,
	GALA_ICON_GROUP_WORKSPACE_PROPERTY,
	GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY,
	GALA_ICON_GROUP_NUM_PROPERTIES
};
static GParamSpec* gala_icon_group_properties[GALA_ICON_GROUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_WINDOW_ICON_ACTOR (gala_window_icon_actor_get_type ())
#define GALA_WINDOW_ICON_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor))
#define GALA_WINDOW_ICON_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActorClass))
#define GALA_IS_WINDOW_ICON_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_ICON_ACTOR))
#define GALA_IS_WINDOW_ICON_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_ICON_ACTOR))
#define GALA_WINDOW_ICON_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActorClass))

typedef struct _GalaWindowIconActor GalaWindowIconActor;
typedef struct _GalaWindowIconActorClass GalaWindowIconActorClass;
typedef struct _Block59Data Block59Data;

#define GALA_TYPE_ICON_GROUP_CONTAINER (gala_icon_group_container_get_type ())
#define GALA_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainer))
#define GALA_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))
#define GALA_IS_ICON_GROUP_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_IS_ICON_GROUP_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_ICON_GROUP_CONTAINER))
#define GALA_ICON_GROUP_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_ICON_GROUP_CONTAINER, GalaIconGroupContainerClass))

typedef struct _GalaIconGroupContainer GalaIconGroupContainer;
typedef struct _GalaIconGroupContainerClass GalaIconGroupContainerClass;

#define GALA_TYPE_WORKSPACE_INSERT_THUMB (gala_workspace_insert_thumb_get_type ())
#define GALA_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb))
#define GALA_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))
#define GALA_IS_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_IS_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_WORKSPACE_INSERT_THUMB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))

typedef struct _GalaWorkspaceInsertThumb GalaWorkspaceInsertThumb;
typedef struct _GalaWorkspaceInsertThumbClass GalaWorkspaceInsertThumbClass;
enum  {
	GALA_ICON_GROUP_SELECTED_SIGNAL,
	GALA_ICON_GROUP_NUM_SIGNALS
};
static guint gala_icon_group_signals[GALA_ICON_GROUP_NUM_SIGNALS] = {0};

struct _GalaIconGroup {
	GalaCanvasActor parent_instance;
	GalaIconGroupPrivate * priv;
};

struct _GalaIconGroupClass {
	GalaCanvasActorClass parent_class;
};

struct _GalaIconGroupPrivate {
	gfloat _backdrop_opacity;
	GalaDragDropAction* drag_action;
	GalaWindowManager* _wm;
	MetaWorkspace* _workspace;
	gfloat _scale_factor;
	ClutterActor* prev_parent;
	ClutterActor* icon_container;
};

struct _Block59Data {
	int _ref_count_;
	GalaIconGroup* self;
	GalaWindowIconActor* icon;
};

static gint GalaIconGroup_private_offset;
static gpointer gala_icon_group_parent_class = NULL;

VALA_EXTERN GType gala_icon_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroup, g_object_unref)
VALA_EXTERN void gala_icon_group_redraw (GalaIconGroup* self);
static void _gala_icon_group_redraw_clutter_actor_child_removed (ClutterActor* _sender,
                                                          ClutterActor* child,
                                                          gpointer self);
VALA_EXTERN GalaIconGroup* gala_icon_group_new (GalaWindowManager* wm,
                                    MetaWorkspace* workspace,
                                    gfloat scale);
VALA_EXTERN GalaIconGroup* gala_icon_group_construct (GType object_type,
                                          GalaWindowManager* wm,
                                          MetaWorkspace* workspace,
                                          gfloat scale);
static void gala_icon_group_resize (GalaIconGroup* self);
VALA_EXTERN gint gala_internal_utils_scale_to_int (gint value,
                                       gfloat scale_factor);
VALA_EXTERN gfloat gala_icon_group_get_scale_factor (GalaIconGroup* self);
static void gala_icon_group_real_paint (ClutterActor* base,
                                 ClutterPaintContext* context);
VALA_EXTERN gfloat gala_icon_group_get_backdrop_opacity (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_clear (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_add_window (GalaIconGroup* self,
                                 MetaWindow* window,
                                 gboolean no_redraw,
                                 gboolean temporary);
VALA_EXTERN GType gala_window_icon_actor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowIconActor, g_object_unref)
VALA_EXTERN GalaWindowManager* gala_icon_group_get_wm (GalaIconGroup* self);
VALA_EXTERN GalaWindowIconActor* gala_window_icon_actor_new (GalaWindowManager* wm,
                                                 MetaWindow* window);
VALA_EXTERN GalaWindowIconActor* gala_window_icon_actor_construct (GType object_type,
                                                       GalaWindowManager* wm,
                                                       MetaWindow* window);
VALA_EXTERN void gala_window_icon_actor_set_temporary (GalaWindowIconActor* self,
                                           gboolean value);
VALA_EXTERN void gala_icon_group_remove_window (GalaIconGroup* self,
                                    MetaWindow* window,
                                    gboolean animate);
static Block59Data* block59_data_ref (Block59Data* _data59_);
static void block59_data_unref (void * _userdata_);
VALA_EXTERN MetaWindow* gala_window_icon_actor_get_window (GalaWindowIconActor* self);
static void _______lambda52_ (Block59Data* _data59_);
static void ________lambda52__clutter_timeline_completed (ClutterTimeline* _sender,
                                                   gpointer self);
VALA_EXTERN void gala_icon_group_set_hovered_actor (GalaIconGroup* self,
                                        ClutterActor* actor);
static void gala_icon_group_real_draw (GalaCanvasActor* base,
                                cairo_t* cr,
                                gint cr_width,
                                gint cr_height);
VALA_EXTERN void gala_window_icon_actor_place (GalaWindowIconActor* self,
                                   gfloat x,
                                   gfloat y,
                                   gint size,
                                   gfloat scale);
VALA_EXTERN MetaWorkspace* gala_icon_group_get_workspace (GalaIconGroup* self);
static ClutterActor* gala_icon_group_drag_begin (GalaIconGroup* self,
                                          gfloat click_x,
                                          gfloat click_y);
VALA_EXTERN GType gala_icon_group_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaIconGroupContainer, g_object_unref)
VALA_EXTERN void gala_icon_group_container_remove_group_in_place (GalaIconGroupContainer* self,
                                                      GalaIconGroup* group);
VALA_EXTERN void gala_icon_group_container_reset_thumbs (GalaIconGroupContainer* self,
                                             gint delay);
static void gala_icon_group_drag_end (GalaIconGroup* self,
                               ClutterActor* destination);
VALA_EXTERN GType gala_workspace_insert_thumb_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceInsertThumb, g_object_unref)
VALA_EXTERN gint gala_workspace_insert_thumb_get_workspace_index (GalaWorkspaceInsertThumb* self);
static void gala_icon_group_restore_group (GalaIconGroup* self);
static void gala_icon_group_drag_canceled (GalaIconGroup* self);
VALA_EXTERN void gala_icon_group_container_add_group (GalaIconGroupContainer* self,
                                          GalaIconGroup* group);
VALA_EXTERN void gala_icon_group_set_backdrop_opacity (GalaIconGroup* self,
                                           gfloat value);
static void gala_icon_group_set_wm (GalaIconGroup* self,
                             GalaWindowManager* value);
static void gala_icon_group_set_workspace (GalaIconGroup* self,
                                    MetaWorkspace* value);
VALA_EXTERN void gala_icon_group_set_scale_factor (GalaIconGroup* self,
                                       gfloat value);
static GObject * gala_icon_group_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void _gala_icon_group___lambda65_ (GalaIconGroup* self);
static void __gala_icon_group___lambda65__gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                        guint32 button,
                                                                        gpointer self);
static ClutterActor* _gala_icon_group_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                            gfloat x,
                                                                            gfloat y,
                                                                            gpointer self);
static void _gala_icon_group_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                               ClutterActor* actor,
                                                               gpointer self);
static void _gala_icon_group_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                         gpointer self);
static void _gala_icon_group_redraw_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self);
static void gala_icon_group_finalize (GObject * obj);
static GType gala_icon_group_get_type_once (void);
static void _vala_gala_icon_group_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_gala_icon_group_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_icon_group_get_instance_private (GalaIconGroup* self)
{
	return G_STRUCT_MEMBER_P (self, GalaIconGroup_private_offset);
}

static void
_gala_icon_group_redraw_clutter_actor_child_removed (ClutterActor* _sender,
                                                     ClutterActor* child,
                                                     gpointer self)
{
	gala_icon_group_redraw ((GalaIconGroup*) self);
}

GalaIconGroup*
gala_icon_group_construct (GType object_type,
                           GalaWindowManager* wm,
                           MetaWorkspace* workspace,
                           gfloat scale)
{
	GalaIconGroup * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (workspace != NULL, NULL);
	self = (GalaIconGroup*) g_object_new (object_type, "wm", wm, "workspace", workspace, "scale-factor", scale, NULL);
	return self;
}

GalaIconGroup*
gala_icon_group_new (GalaWindowManager* wm,
                     MetaWorkspace* workspace,
                     gfloat scale)
{
	return gala_icon_group_construct (GALA_TYPE_ICON_GROUP, wm, workspace, scale);
}

static void
gala_icon_group_resize (GalaIconGroup* self)
{
	gint size = 0;
	gfloat _tmp0_;
	gfloat _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_icon_group_get_scale_factor (self);
	_tmp1_ = _tmp0_;
	size = gala_internal_utils_scale_to_int (GALA_ICON_GROUP_SIZE, _tmp1_);
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) size);
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) size);
}

/**
         * Override the paint handler to draw our backdrop if necessary
         */
static void
gala_icon_group_real_paint (ClutterActor* base,
                            ClutterPaintContext* context)
{
	GalaIconGroup * self;
	gboolean _tmp0_ = FALSE;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gint width = 0;
	gfloat _tmp6_;
	gfloat _tmp7_;
	gint x = 0;
	gfloat _tmp8_;
	gfloat _tmp9_;
	gint y = 0;
	gint height = 0;
	gfloat _tmp10_;
	gfloat _tmp11_;
	guint8 backdrop_opacity_int = 0U;
	gfloat _tmp12_;
	gfloat _tmp13_;
	CoglVertexP2T2C4 vertices[4] = {0};
	CoglVertexP2T2C4 _tmp14_ = {0};
	CoglVertexP2T2C4 _tmp15_ = {0};
	CoglVertexP2T2C4 _tmp16_ = {0};
	CoglVertexP2T2C4 _tmp17_ = {0};
	CoglPrimitive* primitive = NULL;
	CoglFramebuffer* _tmp18_;
	CoglContext* _tmp19_;
	CoglPrimitive* _tmp20_;
	CoglPipeline* pipeline = NULL;
	CoglFramebuffer* _tmp21_;
	CoglContext* _tmp22_;
	CoglPipeline* _tmp23_;
	CoglPrimitive* _tmp24_;
	CoglFramebuffer* _tmp25_;
	CoglPipeline* _tmp26_;
	self = (GalaIconGroup*) base;
	g_return_if_fail (context != NULL);
	_tmp1_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp2_ = _tmp1_;
	if (((gdouble) _tmp2_) == 0.0) {
		_tmp0_ = TRUE;
	} else {
		GalaDragDropAction* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->drag_action;
		_tmp4_ = gala_drag_drop_action_get_dragging (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		CLUTTER_ACTOR_CLASS (gala_icon_group_parent_class)->paint ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_CANVAS_ACTOR, GalaCanvasActor), context);
		return;
	}
	_tmp6_ = gala_icon_group_get_scale_factor (self);
	_tmp7_ = _tmp6_;
	width = gala_internal_utils_scale_to_int (100, _tmp7_);
	_tmp8_ = gala_icon_group_get_scale_factor (self);
	_tmp9_ = _tmp8_;
	x = (gala_internal_utils_scale_to_int (GALA_ICON_GROUP_SIZE, _tmp9_) - width) / 2;
	y = -10;
	_tmp10_ = gala_icon_group_get_scale_factor (self);
	_tmp11_ = _tmp10_;
	height = gala_internal_utils_scale_to_int (GALA_WORKSPACE_CLONE_BOTTOM_OFFSET, _tmp11_);
	_tmp12_ = gala_icon_group_get_backdrop_opacity (self);
	_tmp13_ = _tmp12_;
	backdrop_opacity_int = (guint8) (GALA_ICON_GROUP_BACKDROP_ABSOLUTE_OPACITY * _tmp13_);
	_tmp14_.x = (gfloat) x;
	_tmp14_.y = (gfloat) (y + height);
	_tmp14_.s = (gfloat) 0;
	_tmp14_.t = (gfloat) 1;
	_tmp14_.r = backdrop_opacity_int;
	_tmp14_.g = backdrop_opacity_int;
	_tmp14_.b = backdrop_opacity_int;
	_tmp14_.a = backdrop_opacity_int;
	vertices[0] = _tmp14_;
	_tmp15_.x = (gfloat) x;
	_tmp15_.y = (gfloat) y;
	_tmp15_.s = (gfloat) 0;
	_tmp15_.t = (gfloat) 0;
	_tmp15_.r = (guint8) 0;
	_tmp15_.g = (guint8) 0;
	_tmp15_.b = (guint8) 0;
	_tmp15_.a = (guint8) 0;
	vertices[1] = _tmp15_;
	_tmp16_.x = (gfloat) (x + width);
	_tmp16_.y = (gfloat) (y + height);
	_tmp16_.s = (gfloat) 1;
	_tmp16_.t = (gfloat) 1;
	_tmp16_.r = backdrop_opacity_int;
	_tmp16_.g = backdrop_opacity_int;
	_tmp16_.b = backdrop_opacity_int;
	_tmp16_.a = backdrop_opacity_int;
	vertices[2] = _tmp16_;
	_tmp17_.x = (gfloat) (x + width);
	_tmp17_.y = (gfloat) y;
	_tmp17_.s = (gfloat) 1;
	_tmp17_.t = (gfloat) 0;
	_tmp17_.r = (guint8) 0;
	_tmp17_.g = (guint8) 0;
	_tmp17_.b = (guint8) 0;
	_tmp17_.a = (guint8) 0;
	vertices[3] = _tmp17_;
	_tmp18_ = clutter_paint_context_get_framebuffer (context);
	_tmp19_ = cogl_framebuffer_get_context (_tmp18_);
	_tmp20_ = cogl_primitive_new_p2t2c4 (_tmp19_, COGL_VERTICES_MODE_TRIANGLE_STRIP, 4, vertices);
	primitive = _tmp20_;
	_tmp21_ = clutter_paint_context_get_framebuffer (context);
	_tmp22_ = cogl_framebuffer_get_context (_tmp21_);
	_tmp23_ = cogl_pipeline_new (_tmp22_);
	pipeline = _tmp23_;
	_tmp24_ = primitive;
	_tmp25_ = clutter_paint_context_get_framebuffer (context);
	_tmp26_ = pipeline;
	cogl_primitive_draw (_tmp24_, _tmp25_, _tmp26_);
	CLUTTER_ACTOR_CLASS (gala_icon_group_parent_class)->paint ((ClutterActor*) G_TYPE_CHECK_INSTANCE_CAST (self, GALA_TYPE_CANVAS_ACTOR, GalaCanvasActor), context);
	_g_object_unref0 (pipeline);
	_g_object_unref0 (primitive);
}

/**
         * Remove all currently added WindowIconActors
         */
void
gala_icon_group_clear (GalaIconGroup* self)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->icon_container;
	clutter_actor_destroy_all_children (_tmp0_);
}

/**
         * Creates a WindowIconActor for the given window and adds it to the group
         *
         * @param window    The MetaWindow for which to create the WindowIconActor
         * @param no_redraw If you add multiple windows at once you may want to consider
         *                  settings this to true and when done calling redraw() manually
         * @param temporary Mark the WindowIconActor as temporary. Used for windows dragged over
         *                  the group.
         */
void
gala_icon_group_add_window (GalaIconGroup* self,
                            MetaWindow* window,
                            gboolean no_redraw,
                            gboolean temporary)
{
	GalaWindowIconActor* new_window = NULL;
	GalaWindowManager* _tmp0_;
	GalaWindowIconActor* _tmp1_;
	GalaWindowIconActor* _tmp2_;
	GalaWindowIconActor* _tmp3_;
	ClutterActor* _tmp4_;
	GalaWindowIconActor* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = gala_window_icon_actor_new (_tmp0_, window);
	g_object_ref_sink (_tmp1_);
	new_window = _tmp1_;
	_tmp2_ = new_window;
	clutter_actor_set_position ((ClutterActor*) _tmp2_, (gfloat) 32, (gfloat) 32);
	_tmp3_ = new_window;
	gala_window_icon_actor_set_temporary (_tmp3_, temporary);
	_tmp4_ = self->priv->icon_container;
	_tmp5_ = new_window;
	clutter_actor_add_child (_tmp4_, (ClutterActor*) _tmp5_);
	if (!no_redraw) {
		gala_icon_group_redraw (self);
	}
	_g_object_unref0 (new_window);
}

/**
         * Remove the WindowIconActor for a MetaWindow from the group
         *
         * @param animate Whether to fade the icon out before removing it
         */
static Block59Data*
block59_data_ref (Block59Data* _data59_)
{
	g_atomic_int_inc (&_data59_->_ref_count_);
	return _data59_;
}

static void
block59_data_unref (void * _userdata_)
{
	Block59Data* _data59_;
	_data59_ = (Block59Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data59_->_ref_count_)) {
		GalaIconGroup* self;
		self = _data59_->self;
		_g_object_unref0 (self);
		g_slice_free (Block59Data, _data59_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_______lambda52_ (Block59Data* _data59_)
{
	GalaIconGroup* self;
	GalaWindowIconActor* _tmp0_;
	self = _data59_->self;
	_tmp0_ = _data59_->icon;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
}

static void
________lambda52__clutter_timeline_completed (ClutterTimeline* _sender,
                                              gpointer self)
{
	_______lambda52_ (self);
}

void
gala_icon_group_remove_window (GalaIconGroup* self,
                               MetaWindow* window,
                               gboolean animate)
{
	ClutterActor* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->icon_container;
	_tmp1_ = clutter_actor_get_children (_tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			ClutterActor* child = NULL;
			child = (ClutterActor*) child_it->data;
			{
				Block59Data* _data59_;
				ClutterActor* _tmp2_;
				GalaWindowIconActor* _tmp3_;
				MetaWindow* _tmp4_;
				MetaWindow* _tmp5_;
				_data59_ = g_slice_new0 (Block59Data);
				_data59_->_ref_count_ = 1;
				_data59_->self = g_object_ref (self);
				_tmp2_ = child;
				_data59_->icon = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor);
				_tmp3_ = _data59_->icon;
				_tmp4_ = gala_window_icon_actor_get_window (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ == window) {
					if (animate) {
						GalaWindowIconActor* _tmp6_;
						GalaWindowIconActor* _tmp7_;
						gint _tmp8_ = 0;
						GalaWindowManager* _tmp9_;
						gboolean _tmp10_;
						gboolean _tmp11_;
						GalaWindowIconActor* _tmp12_;
						GalaWindowIconActor* _tmp13_;
						GalaWindowIconActor* _tmp14_;
						ClutterTransition* transition = NULL;
						GalaWindowIconActor* _tmp15_;
						ClutterTransition* _tmp16_;
						ClutterTransition* _tmp17_;
						ClutterTransition* _tmp18_;
						_tmp6_ = _data59_->icon;
						clutter_actor_save_easing_state ((ClutterActor*) _tmp6_);
						_tmp7_ = _data59_->icon;
						clutter_actor_set_easing_mode ((ClutterActor*) _tmp7_, CLUTTER_LINEAR);
						_tmp9_ = self->priv->_wm;
						_tmp10_ = gala_window_manager_get_enable_animations (_tmp9_);
						_tmp11_ = _tmp10_;
						if (_tmp11_) {
							_tmp8_ = 200;
						} else {
							_tmp8_ = 0;
						}
						_tmp12_ = _data59_->icon;
						clutter_actor_set_easing_duration ((ClutterActor*) _tmp12_, (guint) _tmp8_);
						_tmp13_ = _data59_->icon;
						clutter_actor_set_opacity ((ClutterActor*) _tmp13_, (guint) 0);
						_tmp14_ = _data59_->icon;
						clutter_actor_restore_easing_state ((ClutterActor*) _tmp14_);
						_tmp15_ = _data59_->icon;
						_tmp16_ = clutter_actor_get_transition ((ClutterActor*) _tmp15_, "opacity");
						_tmp17_ = _g_object_ref0 (_tmp16_);
						transition = _tmp17_;
						_tmp18_ = transition;
						if (_tmp18_ != NULL) {
							ClutterTransition* _tmp19_;
							_tmp19_ = transition;
							g_signal_connect_data ((ClutterTimeline*) _tmp19_, "completed", (GCallback) ________lambda52__clutter_timeline_completed, block59_data_ref (_data59_), (GClosureNotify) block59_data_unref, 0);
						} else {
							GalaWindowIconActor* _tmp20_;
							_tmp20_ = _data59_->icon;
							clutter_actor_destroy ((ClutterActor*) _tmp20_);
						}
						_g_object_unref0 (transition);
					} else {
						GalaWindowIconActor* _tmp21_;
						_tmp21_ = _data59_->icon;
						clutter_actor_destroy ((ClutterActor*) _tmp21_);
					}
				}
				block59_data_unref (_data59_);
				_data59_ = NULL;
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

/**
         * Sets a hovered actor for the drag action.
         */
void
gala_icon_group_set_hovered_actor (GalaIconGroup* self,
                                   ClutterActor* actor)
{
	GalaDragDropAction* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = self->priv->drag_action;
	gala_drag_drop_action_set_hovered (_tmp0_, actor);
}

/**
         * Trigger a redraw
         */
void
gala_icon_group_redraw (GalaIconGroup* self)
{
	ClutterContent* _tmp0_;
	ClutterContent* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_content ((ClutterActor*) self);
	_tmp1_ = _tmp0_;
	clutter_content_invalidate (_tmp1_);
}

/**
         * Draw the background or plus sign and do layouting. We won't lose performance here
         * by relayouting in the same function, as it's only ever called when we invalidate it.
         */
static void
gala_icon_group_real_draw (GalaCanvasActor* base,
                           cairo_t* cr,
                           gint cr_width,
                           gint cr_height)
{
	GalaIconGroup * self;
	gint n_windows = 0;
	ClutterActor* _tmp0_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	GalaShadowEffect* shadow_effect = NULL;
	gfloat _tmp13_;
	gfloat _tmp14_;
	GalaShadowEffect* _tmp15_ = NULL;
	GraniteSettings* granite_settings = NULL;
	GraniteSettings* _tmp16_;
	GraniteSettings* _tmp17_;
	GraniteSettings* _tmp18_;
	GraniteSettingsColorScheme _tmp19_;
	GraniteSettingsColorScheme _tmp20_;
	GalaDragDropAction* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	GalaShadowEffect* _tmp34_;
	MetaWorkspaceManager* manager = NULL;
	MetaWorkspace* _tmp35_;
	MetaDisplay* _tmp36_;
	MetaWorkspaceManager* _tmp37_;
	gint workspace_index = 0;
	gint scaled_size = 0;
	gfloat _tmp44_;
	gfloat _tmp45_;
	gint size = 0;
	guint n_tiled_windows = 0U;
	gint columns = 0;
	gint rows = 0;
	gint spacing = 0;
	gfloat _tmp118_;
	gfloat _tmp119_;
	gint width = 0;
	gfloat _tmp120_;
	gfloat _tmp121_;
	gint height = 0;
	gfloat _tmp122_;
	gfloat _tmp123_;
	gint x_offset = 0;
	gint y_offset = 0;
	gboolean show_ellipsis = FALSE;
	gint n_shown_windows = 0;
	gint x = 0;
	gint y = 0;
	self = (GalaIconGroup*) base;
	g_return_if_fail (cr != NULL);
	clutter_actor_clear_effects ((ClutterActor*) self);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	_tmp0_ = self->priv->icon_container;
	n_windows = clutter_actor_get_n_children (_tmp0_);
	if (n_windows == 1) {
		GalaWindowIconActor* icon = NULL;
		ClutterActor* _tmp1_;
		ClutterActor* _tmp2_;
		GalaWindowIconActor* _tmp3_;
		GalaWindowIconActor* _tmp4_;
		gfloat _tmp5_;
		gfloat _tmp6_;
		_tmp1_ = self->priv->icon_container;
		_tmp2_ = clutter_actor_get_child_at_index (_tmp1_, 0);
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor));
		icon = _tmp3_;
		_tmp4_ = icon;
		_tmp5_ = gala_icon_group_get_scale_factor (self);
		_tmp6_ = _tmp5_;
		gala_window_icon_actor_place (_tmp4_, (gfloat) 0, (gfloat) 0, 64, _tmp6_);
		_g_object_unref0 (icon);
		return;
	}
	_tmp7_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = gala_icon_group_get_scale_factor (self);
	_tmp12_ = _tmp11_;
	gala_drawing_utilities_cairo_rounded_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) _tmp8_, (gdouble) _tmp10_, (gdouble) gala_internal_utils_scale_to_int (5, _tmp12_));
	_tmp13_ = gala_icon_group_get_scale_factor (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = gala_shadow_effect_new (40);
	gala_shadow_effect_set_scale_factor (_tmp15_, _tmp14_);
	g_object_ref_sink (_tmp15_);
	shadow_effect = _tmp15_;
	_tmp16_ = granite_settings_get_default ();
	_tmp17_ = _g_object_ref0 (_tmp16_);
	granite_settings = _tmp17_;
	_tmp18_ = granite_settings;
	_tmp19_ = granite_settings_get_prefers_color_scheme (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK) {
		static const gdouble BG_COLOR = 35.0 / 255.0;
		GalaDragDropAction* _tmp21_;
		gboolean _tmp22_;
		gboolean _tmp23_;
		_tmp21_ = self->priv->drag_action;
		_tmp22_ = gala_drag_drop_action_get_dragging (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_) {
			cairo_set_source_rgba (cr, BG_COLOR, BG_COLOR, BG_COLOR, 0.8);
		} else {
			GalaShadowEffect* _tmp24_;
			cairo_set_source_rgba (cr, BG_COLOR, BG_COLOR, BG_COLOR, 0.5);
			_tmp24_ = shadow_effect;
			gala_shadow_effect_set_shadow_opacity (_tmp24_, (guint8) 200);
		}
	} else {
		GalaDragDropAction* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		_tmp25_ = self->priv->drag_action;
		_tmp26_ = gala_drag_drop_action_get_dragging (_tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_) {
			cairo_set_source_rgba (cr, (gdouble) 255, (gdouble) 255, (gdouble) 255, 0.8);
		} else {
			GalaShadowEffect* _tmp28_;
			cairo_set_source_rgba (cr, (gdouble) 255, (gdouble) 255, (gdouble) 255, 0.3);
			_tmp28_ = shadow_effect;
			gala_shadow_effect_set_shadow_opacity (_tmp28_, (guint8) 100);
		}
	}
	_tmp29_ = self->priv->drag_action;
	_tmp30_ = gala_drag_drop_action_get_dragging (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_) {
		GalaShadowEffect* _tmp32_;
		_tmp32_ = shadow_effect;
		gala_shadow_effect_set_css_class (_tmp32_, "workspace-switcher-dnd");
	} else {
		GalaShadowEffect* _tmp33_;
		_tmp33_ = shadow_effect;
		gala_shadow_effect_set_css_class (_tmp33_, "workspace-switcher");
	}
	_tmp34_ = shadow_effect;
	clutter_actor_add_effect ((ClutterActor*) self, (ClutterEffect*) _tmp34_);
	cairo_fill_preserve (cr);
	_tmp35_ = self->priv->_workspace;
	_tmp36_ = meta_workspace_get_display (_tmp35_);
	_tmp37_ = meta_display_get_workspace_manager (_tmp36_);
	manager = _tmp37_;
	workspace_index = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp38_ = FALSE;
			_tmp38_ = TRUE;
			while (TRUE) {
				MetaWorkspaceManager* _tmp40_;
				MetaWorkspaceManager* _tmp41_;
				MetaWorkspace* _tmp42_;
				MetaWorkspace* _tmp43_;
				if (!_tmp38_) {
					gint _tmp39_;
					_tmp39_ = i;
					i = _tmp39_ + 1;
				}
				_tmp38_ = FALSE;
				_tmp40_ = manager;
				if (!(i < meta_workspace_manager_get_n_workspaces (_tmp40_))) {
					break;
				}
				_tmp41_ = manager;
				_tmp42_ = meta_workspace_manager_get_workspace_by_index (_tmp41_, i);
				_tmp43_ = self->priv->_workspace;
				if (_tmp42_ == _tmp43_) {
					workspace_index = i;
					break;
				}
			}
		}
	}
	_tmp44_ = gala_icon_group_get_scale_factor (self);
	_tmp45_ = _tmp44_;
	scaled_size = gala_internal_utils_scale_to_int (GALA_ICON_GROUP_SIZE, _tmp45_);
	if (n_windows < 1) {
		gboolean _tmp46_ = FALSE;
		GalaDrawingBufferSurface* buffer = NULL;
		GalaDrawingBufferSurface* _tmp48_;
		gint offset = 0;
		gfloat _tmp49_;
		gfloat _tmp50_;
		GalaDrawingBufferSurface* _tmp51_;
		cairo_t* _tmp52_;
		cairo_t* _tmp53_;
		gfloat _tmp54_;
		gfloat _tmp55_;
		gfloat _tmp56_;
		gfloat _tmp57_;
		gfloat _tmp58_;
		gfloat _tmp59_;
		gfloat _tmp60_;
		gfloat _tmp61_;
		GalaDrawingBufferSurface* _tmp62_;
		cairo_t* _tmp63_;
		cairo_t* _tmp64_;
		gfloat _tmp65_;
		gfloat _tmp66_;
		gfloat _tmp67_;
		gfloat _tmp68_;
		gfloat _tmp69_;
		gfloat _tmp70_;
		gfloat _tmp71_;
		gfloat _tmp72_;
		GraniteSettings* _tmp73_;
		GraniteSettingsColorScheme _tmp74_;
		GraniteSettingsColorScheme _tmp75_;
		GalaDrawingBufferSurface* _tmp112_;
		cairo_t* _tmp113_;
		cairo_t* _tmp114_;
		GalaDrawingBufferSurface* _tmp115_;
		cairo_surface_t* _tmp116_;
		cairo_surface_t* _tmp117_;
		if (!meta_prefs_get_dynamic_workspaces ()) {
			_tmp46_ = TRUE;
		} else {
			MetaWorkspaceManager* _tmp47_;
			_tmp47_ = manager;
			_tmp46_ = workspace_index != (meta_workspace_manager_get_n_workspaces (_tmp47_) - 1);
		}
		if (_tmp46_) {
			_g_object_unref0 (granite_settings);
			_g_object_unref0 (shadow_effect);
			return;
		}
		_tmp48_ = gala_drawing_buffer_surface_new (scaled_size, scaled_size);
		buffer = _tmp48_;
		_tmp49_ = gala_icon_group_get_scale_factor (self);
		_tmp50_ = _tmp49_;
		offset = (scaled_size / 2) - (gala_internal_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH, _tmp50_) / 2);
		_tmp51_ = buffer;
		_tmp52_ = gala_drawing_buffer_surface_get_context (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = gala_icon_group_get_scale_factor (self);
		_tmp55_ = _tmp54_;
		_tmp56_ = gala_icon_group_get_scale_factor (self);
		_tmp57_ = _tmp56_;
		_tmp58_ = gala_icon_group_get_scale_factor (self);
		_tmp59_ = _tmp58_;
		_tmp60_ = gala_icon_group_get_scale_factor (self);
		_tmp61_ = _tmp60_;
		cairo_rectangle (_tmp53_, (gdouble) ((gala_internal_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH / 2, _tmp55_) - gala_internal_utils_scale_to_int (GALA_ICON_GROUP_PLUS_SIZE / 2, _tmp57_)) + offset), (gdouble) offset, (gdouble) gala_internal_utils_scale_to_int (GALA_ICON_GROUP_PLUS_SIZE, _tmp59_), (gdouble) gala_internal_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH, _tmp61_));
		_tmp62_ = buffer;
		_tmp63_ = gala_drawing_buffer_surface_get_context (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = gala_icon_group_get_scale_factor (self);
		_tmp66_ = _tmp65_;
		_tmp67_ = gala_icon_group_get_scale_factor (self);
		_tmp68_ = _tmp67_;
		_tmp69_ = gala_icon_group_get_scale_factor (self);
		_tmp70_ = _tmp69_;
		_tmp71_ = gala_icon_group_get_scale_factor (self);
		_tmp72_ = _tmp71_;
		cairo_rectangle (_tmp64_, (gdouble) offset, (gdouble) ((gala_internal_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH / 2, _tmp66_) - gala_internal_utils_scale_to_int (GALA_ICON_GROUP_PLUS_SIZE / 2, _tmp68_)) + offset), (gdouble) gala_internal_utils_scale_to_int (GALA_ICON_GROUP_PLUS_WIDTH, _tmp70_), (gdouble) gala_internal_utils_scale_to_int (GALA_ICON_GROUP_PLUS_SIZE, _tmp72_));
		_tmp73_ = granite_settings;
		_tmp74_ = granite_settings_get_prefers_color_scheme (_tmp73_);
		_tmp75_ = _tmp74_;
		if (_tmp75_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK) {
			GalaDrawingBufferSurface* _tmp76_;
			cairo_t* _tmp77_;
			cairo_t* _tmp78_;
			gfloat _tmp79_;
			gfloat _tmp80_;
			GalaDrawingBufferSurface* _tmp81_;
			cairo_t* _tmp82_;
			cairo_t* _tmp83_;
			GalaDrawingBufferSurface* _tmp84_;
			cairo_t* _tmp85_;
			cairo_t* _tmp86_;
			GalaDrawingBufferSurface* _tmp87_;
			GalaDrawingBufferSurface* _tmp88_;
			cairo_t* _tmp89_;
			cairo_t* _tmp90_;
			GalaDrawingBufferSurface* _tmp91_;
			cairo_t* _tmp92_;
			cairo_t* _tmp93_;
			_tmp76_ = buffer;
			_tmp77_ = gala_drawing_buffer_surface_get_context (_tmp76_);
			_tmp78_ = _tmp77_;
			_tmp79_ = gala_icon_group_get_scale_factor (self);
			_tmp80_ = _tmp79_;
			cairo_move_to (_tmp78_, (gdouble) 0, (gdouble) (1 * _tmp80_));
			_tmp81_ = buffer;
			_tmp82_ = gala_drawing_buffer_surface_get_context (_tmp81_);
			_tmp83_ = _tmp82_;
			cairo_set_source_rgb (_tmp83_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
			_tmp84_ = buffer;
			_tmp85_ = gala_drawing_buffer_surface_get_context (_tmp84_);
			_tmp86_ = _tmp85_;
			cairo_fill_preserve (_tmp86_);
			_tmp87_ = buffer;
			gala_drawing_buffer_surface_exponential_blur (_tmp87_, 2);
			_tmp88_ = buffer;
			_tmp89_ = gala_drawing_buffer_surface_get_context (_tmp88_);
			_tmp90_ = _tmp89_;
			cairo_move_to (_tmp90_, (gdouble) 0, (gdouble) 0);
			_tmp91_ = buffer;
			_tmp92_ = gala_drawing_buffer_surface_get_context (_tmp91_);
			_tmp93_ = _tmp92_;
			cairo_set_source_rgba (_tmp93_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.95);
		} else {
			GalaDrawingBufferSurface* _tmp94_;
			cairo_t* _tmp95_;
			cairo_t* _tmp96_;
			gfloat _tmp97_;
			gfloat _tmp98_;
			GalaDrawingBufferSurface* _tmp99_;
			cairo_t* _tmp100_;
			cairo_t* _tmp101_;
			GalaDrawingBufferSurface* _tmp102_;
			cairo_t* _tmp103_;
			cairo_t* _tmp104_;
			GalaDrawingBufferSurface* _tmp105_;
			GalaDrawingBufferSurface* _tmp106_;
			cairo_t* _tmp107_;
			cairo_t* _tmp108_;
			GalaDrawingBufferSurface* _tmp109_;
			cairo_t* _tmp110_;
			cairo_t* _tmp111_;
			_tmp94_ = buffer;
			_tmp95_ = gala_drawing_buffer_surface_get_context (_tmp94_);
			_tmp96_ = _tmp95_;
			_tmp97_ = gala_icon_group_get_scale_factor (self);
			_tmp98_ = _tmp97_;
			cairo_move_to (_tmp96_, (gdouble) 0, (gdouble) (1 * _tmp98_));
			_tmp99_ = buffer;
			_tmp100_ = gala_drawing_buffer_surface_get_context (_tmp99_);
			_tmp101_ = _tmp100_;
			cairo_set_source_rgba (_tmp101_, (gdouble) 1, (gdouble) 1, (gdouble) 1, 0.4);
			_tmp102_ = buffer;
			_tmp103_ = gala_drawing_buffer_surface_get_context (_tmp102_);
			_tmp104_ = _tmp103_;
			cairo_fill_preserve (_tmp104_);
			_tmp105_ = buffer;
			gala_drawing_buffer_surface_exponential_blur (_tmp105_, 1);
			_tmp106_ = buffer;
			_tmp107_ = gala_drawing_buffer_surface_get_context (_tmp106_);
			_tmp108_ = _tmp107_;
			cairo_move_to (_tmp108_, (gdouble) 0, (gdouble) 0);
			_tmp109_ = buffer;
			_tmp110_ = gala_drawing_buffer_surface_get_context (_tmp109_);
			_tmp111_ = _tmp110_;
			cairo_set_source_rgba (_tmp111_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.7);
		}
		_tmp112_ = buffer;
		_tmp113_ = gala_drawing_buffer_surface_get_context (_tmp112_);
		_tmp114_ = _tmp113_;
		cairo_fill (_tmp114_);
		_tmp115_ = buffer;
		_tmp116_ = gala_drawing_buffer_surface_get_surface (_tmp115_);
		_tmp117_ = _tmp116_;
		cairo_set_source_surface (cr, _tmp117_, (gdouble) 0, (gdouble) 0);
		cairo_paint (cr);
		_g_object_unref0 (buffer);
		_g_object_unref0 (granite_settings);
		_g_object_unref0 (shadow_effect);
		return;
	}
	if (n_windows < 5) {
		size = 24;
	} else {
		size = 16;
	}
	n_tiled_windows = MIN ((guint) n_windows, (guint) 9);
	columns = (gint) ceil (sqrt ((gdouble) n_tiled_windows));
	rows = (gint) ceil (n_tiled_windows / ((gdouble) columns));
	_tmp118_ = gala_icon_group_get_scale_factor (self);
	_tmp119_ = _tmp118_;
	spacing = gala_internal_utils_scale_to_int (6, _tmp119_);
	_tmp120_ = gala_icon_group_get_scale_factor (self);
	_tmp121_ = _tmp120_;
	width = (columns * gala_internal_utils_scale_to_int (size, _tmp121_)) + ((columns - 1) * spacing);
	_tmp122_ = gala_icon_group_get_scale_factor (self);
	_tmp123_ = _tmp122_;
	height = (rows * gala_internal_utils_scale_to_int (size, _tmp123_)) + ((rows - 1) * spacing);
	x_offset = (scaled_size / 2) - (width / 2);
	y_offset = (scaled_size / 2) - (height / 2);
	show_ellipsis = FALSE;
	n_shown_windows = n_windows;
	if (n_shown_windows > 9) {
		n_shown_windows = 8;
		show_ellipsis = TRUE;
	}
	x = x_offset;
	y = y_offset;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp124_ = FALSE;
			_tmp124_ = TRUE;
			while (TRUE) {
				GalaWindowIconActor* window = NULL;
				ClutterActor* _tmp126_;
				ClutterActor* _tmp127_;
				GalaWindowIconActor* _tmp128_;
				gboolean _tmp129_ = FALSE;
				GalaWindowIconActor* _tmp139_;
				gfloat _tmp140_;
				gfloat _tmp141_;
				gfloat _tmp142_;
				gfloat _tmp143_;
				gfloat _tmp144_;
				gfloat _tmp145_;
				if (!_tmp124_) {
					gint _tmp125_;
					_tmp125_ = i;
					i = _tmp125_ + 1;
				}
				_tmp124_ = FALSE;
				if (!(i < n_windows)) {
					break;
				}
				_tmp126_ = self->priv->icon_container;
				_tmp127_ = clutter_actor_get_child_at_index (_tmp126_, i);
				_tmp128_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp127_, GALA_TYPE_WINDOW_ICON_ACTOR, GalaWindowIconActor));
				window = _tmp128_;
				if (show_ellipsis) {
					_tmp129_ = i == 8;
				} else {
					_tmp129_ = FALSE;
				}
				if (_tmp129_) {
					gint top_offset = 0;
					gfloat _tmp130_;
					gfloat _tmp131_;
					gint left_offset = 0;
					gfloat _tmp132_;
					gfloat _tmp133_;
					gint radius = 0;
					gfloat _tmp134_;
					gfloat _tmp135_;
					gint dot_spacing = 0;
					gfloat _tmp136_;
					gfloat _tmp137_;
					_tmp130_ = gala_icon_group_get_scale_factor (self);
					_tmp131_ = _tmp130_;
					top_offset = gala_internal_utils_scale_to_int (10, _tmp131_);
					_tmp132_ = gala_icon_group_get_scale_factor (self);
					_tmp133_ = _tmp132_;
					left_offset = gala_internal_utils_scale_to_int (2, _tmp133_);
					_tmp134_ = gala_icon_group_get_scale_factor (self);
					_tmp135_ = _tmp134_;
					radius = gala_internal_utils_scale_to_int (2, _tmp135_);
					_tmp136_ = gala_icon_group_get_scale_factor (self);
					_tmp137_ = _tmp136_;
					dot_spacing = gala_internal_utils_scale_to_int (3, _tmp137_);
					cairo_arc (cr, (gdouble) (left_offset + x), (gdouble) (y + top_offset), (gdouble) radius, (gdouble) 0, 2 * G_PI);
					cairo_arc (cr, (gdouble) (((left_offset + x) + radius) + dot_spacing), (gdouble) (y + top_offset), (gdouble) radius, (gdouble) 0, 2 * G_PI);
					cairo_arc (cr, (gdouble) (((left_offset + x) + (radius * 2)) + (dot_spacing * 2)), (gdouble) (y + top_offset), (gdouble) radius, (gdouble) 0, 2 * G_PI);
					cairo_set_source_rgb (cr, 0.3, 0.3, 0.3);
					cairo_fill (cr);
				}
				if (i >= n_shown_windows) {
					GalaWindowIconActor* _tmp138_;
					_tmp138_ = window;
					g_object_set ((ClutterActor*) _tmp138_, "visible", FALSE, NULL);
					_g_object_unref0 (window);
					continue;
				}
				_tmp139_ = window;
				_tmp140_ = gala_icon_group_get_scale_factor (self);
				_tmp141_ = _tmp140_;
				gala_window_icon_actor_place (_tmp139_, (gfloat) x, (gfloat) y, size, _tmp141_);
				_tmp142_ = gala_icon_group_get_scale_factor (self);
				_tmp143_ = _tmp142_;
				x += gala_internal_utils_scale_to_int (size, _tmp143_) + spacing;
				_tmp144_ = gala_icon_group_get_scale_factor (self);
				_tmp145_ = _tmp144_;
				if ((x + gala_internal_utils_scale_to_int (size, _tmp145_)) >= scaled_size) {
					gfloat _tmp146_;
					gfloat _tmp147_;
					x = x_offset;
					_tmp146_ = gala_icon_group_get_scale_factor (self);
					_tmp147_ = _tmp146_;
					y += gala_internal_utils_scale_to_int (size, _tmp147_) + spacing;
				}
				_g_object_unref0 (window);
			}
		}
	}
	_g_object_unref0 (granite_settings);
	_g_object_unref0 (shadow_effect);
}

static ClutterActor*
gala_icon_group_drag_begin (GalaIconGroup* self,
                            gfloat click_x,
                            gfloat click_y)
{
	MetaWorkspaceManager* manager = NULL;
	MetaWorkspace* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWorkspaceManager* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ClutterActor* _tmp5_;
	gfloat abs_x = 0.0F;
	gfloat abs_y = 0.0F;
	gfloat prev_parent_x = 0.0F;
	gfloat prev_parent_y = 0.0F;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	gfloat _tmp11_ = 0.0F;
	gfloat _tmp12_ = 0.0F;
	ClutterStage* stage = NULL;
	ClutterStage* _tmp13_;
	ClutterStage* _tmp14_;
	GalaIconGroupContainer* container = NULL;
	ClutterActor* _tmp15_;
	GalaIconGroupContainer* _tmp16_;
	GalaIconGroupContainer* _tmp17_;
	ClutterStage* _tmp21_;
	gfloat _tmp22_ = 0.0F;
	gfloat _tmp23_ = 0.0F;
	GalaWindowManager* _tmp24_;
	MetaDisplay* _tmp25_;
	ClutterActor* _tmp26_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	_tmp1_ = meta_workspace_get_display (_tmp0_);
	_tmp2_ = meta_display_get_workspace_manager (_tmp1_);
	manager = _tmp2_;
	_tmp5_ = self->priv->icon_container;
	if (clutter_actor_get_n_children (_tmp5_) < 1) {
		_tmp4_ = meta_prefs_get_dynamic_workspaces ();
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		MetaWorkspace* _tmp6_;
		MetaWorkspaceManager* _tmp7_;
		_tmp6_ = self->priv->_workspace;
		_tmp7_ = manager;
		_tmp3_ = meta_workspace_index (_tmp6_) == (meta_workspace_manager_get_n_workspaces (_tmp7_) - 1);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = NULL;
		return result;
	}
	_tmp8_ = clutter_actor_get_parent ((ClutterActor*) self);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->prev_parent);
	self->priv->prev_parent = _tmp9_;
	_tmp10_ = self->priv->prev_parent;
	clutter_actor_get_transformed_position (_tmp10_, &_tmp11_, &_tmp12_);
	prev_parent_x = _tmp11_;
	prev_parent_y = _tmp12_;
	_tmp13_ = clutter_actor_get_stage ((ClutterActor*) self);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	stage = _tmp14_;
	_tmp15_ = self->priv->prev_parent;
	_tmp16_ = _g_object_ref0 (GALA_IS_ICON_GROUP_CONTAINER (_tmp15_) ? ((GalaIconGroupContainer*) _tmp15_) : NULL);
	container = _tmp16_;
	_tmp17_ = container;
	if (_tmp17_ != NULL) {
		GalaIconGroupContainer* _tmp18_;
		GalaIconGroupContainer* _tmp19_;
		_tmp18_ = container;
		gala_icon_group_container_remove_group_in_place (_tmp18_, self);
		_tmp19_ = container;
		gala_icon_group_container_reset_thumbs (_tmp19_, 0);
	} else {
		ClutterActor* _tmp20_;
		_tmp20_ = self->priv->prev_parent;
		clutter_actor_remove_child (_tmp20_, (ClutterActor*) self);
	}
	_tmp21_ = stage;
	clutter_actor_add_child ((ClutterActor*) _tmp21_, (ClutterActor*) self);
	clutter_actor_get_transformed_position ((ClutterActor*) self, &_tmp22_, &_tmp23_);
	abs_x = _tmp22_;
	abs_y = _tmp23_;
	clutter_actor_set_position ((ClutterActor*) self, abs_x + prev_parent_x, abs_y + prev_parent_y);
	clutter_actor_set_reactive ((ClutterActor*) self, FALSE);
	_tmp24_ = self->priv->_wm;
	_tmp25_ = meta_plugin_get_display ((MetaPlugin*) _tmp24_);
	meta_display_set_cursor (_tmp25_, META_CURSOR_DND_IN_DRAG);
	_tmp26_ = _g_object_ref0 ((ClutterActor*) self);
	result = _tmp26_;
	_g_object_unref0 (container);
	_g_object_unref0 (stage);
	return result;
}

static void
gala_icon_group_drag_end (GalaIconGroup* self,
                          ClutterActor* destination)
{
	GalaWindowManager* _tmp9_;
	MetaDisplay* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (destination != NULL);
	if (GALA_IS_WORKSPACE_INSERT_THUMB (destination)) {
		ClutterActor* _tmp0_;
		GalaWorkspaceInsertThumb* inserter = NULL;
		MetaWorkspaceManager* manager = NULL;
		MetaWorkspace* _tmp1_;
		MetaDisplay* _tmp2_;
		MetaWorkspaceManager* _tmp3_;
		MetaWorkspaceManager* _tmp4_;
		MetaWorkspace* _tmp5_;
		GalaWorkspaceInsertThumb* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
		clutter_actor_remove_child (_tmp0_, (ClutterActor*) self);
		inserter = G_TYPE_CHECK_INSTANCE_CAST (destination, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb);
		_tmp1_ = self->priv->_workspace;
		_tmp2_ = meta_workspace_get_display (_tmp1_);
		_tmp3_ = meta_display_get_workspace_manager (_tmp2_);
		manager = _tmp3_;
		_tmp4_ = manager;
		_tmp5_ = self->priv->_workspace;
		_tmp6_ = inserter;
		_tmp7_ = gala_workspace_insert_thumb_get_workspace_index (_tmp6_);
		_tmp8_ = _tmp7_;
		meta_workspace_manager_reorder_workspace (_tmp4_, _tmp5_, _tmp8_);
		gala_icon_group_restore_group (self);
	} else {
		gala_icon_group_drag_canceled (self);
	}
	_tmp9_ = self->priv->_wm;
	_tmp10_ = meta_plugin_get_display ((MetaPlugin*) _tmp9_);
	meta_display_set_cursor (_tmp10_, META_CURSOR_DEFAULT);
}

static void
gala_icon_group_drag_canceled (GalaIconGroup* self)
{
	ClutterActor* _tmp0_;
	GalaWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = clutter_actor_get_parent ((ClutterActor*) self);
	clutter_actor_remove_child (_tmp0_, (ClutterActor*) self);
	gala_icon_group_restore_group (self);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	meta_display_set_cursor (_tmp2_, META_CURSOR_DEFAULT);
}

static void
gala_icon_group_restore_group (GalaIconGroup* self)
{
	GalaIconGroupContainer* container = NULL;
	ClutterActor* _tmp0_;
	GalaIconGroupContainer* _tmp1_;
	GalaIconGroupContainer* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prev_parent;
	_tmp1_ = _g_object_ref0 (GALA_IS_ICON_GROUP_CONTAINER (_tmp0_) ? ((GalaIconGroupContainer*) _tmp0_) : NULL);
	container = _tmp1_;
	_tmp2_ = container;
	if (_tmp2_ != NULL) {
		GalaIconGroupContainer* _tmp3_;
		GalaIconGroupContainer* _tmp4_;
		GalaIconGroupContainer* _tmp5_;
		_tmp3_ = container;
		gala_icon_group_container_add_group (_tmp3_, self);
		_tmp4_ = container;
		g_signal_emit_by_name (_tmp4_, "request-reposition", FALSE);
		_tmp5_ = container;
		gala_icon_group_container_reset_thumbs (_tmp5_, GALA_WORKSPACE_INSERT_THUMB_EXPAND_DELAY);
	}
	_g_object_unref0 (container);
}

gfloat
gala_icon_group_get_backdrop_opacity (GalaIconGroup* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_backdrop_opacity;
	return result;
}

void
gala_icon_group_set_backdrop_opacity (GalaIconGroup* self,
                                      gfloat value)
{
	g_return_if_fail (self != NULL);
	self->priv->_backdrop_opacity = value;
	clutter_actor_queue_redraw ((ClutterActor*) self);
	g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY]);
}

GalaWindowManager*
gala_icon_group_get_wm (GalaIconGroup* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_icon_group_set_wm (GalaIconGroup* self,
                        GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_icon_group_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_WM_PROPERTY]);
	}
}

MetaWorkspace*
gala_icon_group_get_workspace (GalaIconGroup* self)
{
	MetaWorkspace* result;
	MetaWorkspace* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_workspace;
	result = _tmp0_;
	return result;
}

static void
gala_icon_group_set_workspace (GalaIconGroup* self,
                               MetaWorkspace* value)
{
	MetaWorkspace* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_icon_group_get_workspace (self);
	if (old_value != value) {
		MetaWorkspace* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_workspace);
		self->priv->_workspace = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_WORKSPACE_PROPERTY]);
	}
}

gfloat
gala_icon_group_get_scale_factor (GalaIconGroup* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_scale_factor;
	return result;
}

void
gala_icon_group_set_scale_factor (GalaIconGroup* self,
                                  gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_scale_factor) {
		self->priv->_scale_factor = value;
		gala_icon_group_resize (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_icon_group_properties[GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY]);
}

static void
_gala_icon_group___lambda65_ (GalaIconGroup* self)
{
	g_signal_emit (self, gala_icon_group_signals[GALA_ICON_GROUP_SELECTED_SIGNAL], 0);
}

static void
__gala_icon_group___lambda65__gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                   guint32 button,
                                                                   gpointer self)
{
	_gala_icon_group___lambda65_ ((GalaIconGroup*) self);
}

static ClutterActor*
_gala_icon_group_drag_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                              gfloat x,
                                                              gfloat y,
                                                              gpointer self)
{
	ClutterActor* result;
	result = gala_icon_group_drag_begin ((GalaIconGroup*) self, x, y);
	return result;
}

static void
_gala_icon_group_drag_end_gala_drag_drop_action_drag_end (GalaDragDropAction* _sender,
                                                          ClutterActor* actor,
                                                          gpointer self)
{
	gala_icon_group_drag_end ((GalaIconGroup*) self, actor);
}

static void
_gala_icon_group_drag_canceled_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                    gpointer self)
{
	gala_icon_group_drag_canceled ((GalaIconGroup*) self);
}

static void
_gala_icon_group_redraw_g_object_notify (GObject* _sender,
                                         GParamSpec* pspec,
                                         gpointer self)
{
	gala_icon_group_redraw ((GalaIconGroup*) self);
}

static GObject *
gala_icon_group_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaIconGroup * self;
	GalaDragDropAction* _tmp0_;
	GalaDragDropAction* _tmp1_;
	GalaDragDropAction* _tmp2_;
	GalaDragDropAction* _tmp3_;
	GalaDragDropAction* _tmp4_;
	GalaDragDropAction* _tmp5_;
	GalaDragDropAction* _tmp6_;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterActor* _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	parent_class = G_OBJECT_CLASS (gala_icon_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	_tmp0_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE | GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->drag_action);
	self->priv->drag_action = _tmp0_;
	_tmp1_ = self->priv->drag_action;
	g_signal_connect_object (_tmp1_, "actor-clicked", (GCallback) __gala_icon_group___lambda65__gala_drag_drop_action_actor_clicked, self, 0);
	_tmp2_ = self->priv->drag_action;
	g_signal_connect_object (_tmp2_, "drag-begin", (GCallback) _gala_icon_group_drag_begin_gala_drag_drop_action_drag_begin, self, 0);
	_tmp3_ = self->priv->drag_action;
	g_signal_connect_object (_tmp3_, "drag-end", (GCallback) _gala_icon_group_drag_end_gala_drag_drop_action_drag_end, self, 0);
	_tmp4_ = self->priv->drag_action;
	g_signal_connect_object (_tmp4_, "drag-canceled", (GCallback) _gala_icon_group_drag_canceled_gala_drag_drop_action_drag_canceled, self, 0);
	_tmp5_ = self->priv->drag_action;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::dragging", (GCallback) _gala_icon_group_redraw_g_object_notify, self, 0);
	_tmp6_ = self->priv->drag_action;
	clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp6_);
	_tmp7_ = clutter_actor_new ();
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->icon_container);
	self->priv->icon_container = _tmp7_;
	_tmp8_ = self->priv->icon_container;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	clutter_actor_set_width (_tmp8_, _tmp10_);
	_tmp11_ = self->priv->icon_container;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp13_ = _tmp12_;
	clutter_actor_set_height (_tmp11_, _tmp13_);
	_tmp14_ = self->priv->icon_container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp14_);
	gala_icon_group_resize (self);
	_tmp15_ = self->priv->icon_container;
	g_signal_connect_object (_tmp15_, "child-removed", (GCallback) _gala_icon_group_redraw_clutter_actor_child_removed, self, G_CONNECT_AFTER);
	return obj;
}

static void
gala_icon_group_class_init (GalaIconGroupClass * klass,
                            gpointer klass_data)
{
	gala_icon_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaIconGroup_private_offset);
	((ClutterActorClass *) klass)->paint = (void (*) (ClutterActor*, ClutterPaintContext*)) gala_icon_group_real_paint;
	((GalaCanvasActorClass *) klass)->draw = (void (*) (GalaCanvasActor*, cairo_t*, gint, gint)) gala_icon_group_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_icon_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_icon_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_icon_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_icon_group_finalize;
	/**
	         * The opacity of the backdrop/highlight.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY] = g_param_spec_float ("backdrop-opacity", "backdrop-opacity", "backdrop-opacity", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_WM_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_WORKSPACE_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_WORKSPACE_PROPERTY] = g_param_spec_object ("workspace", "workspace", "workspace", meta_workspace_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY, gala_icon_group_properties[GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY] = g_param_spec_float ("scale-factor", "scale-factor", "scale-factor", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * The group has been clicked. The MultitaskingView should consider activating
	         * its workspace.
	         */
	gala_icon_group_signals[GALA_ICON_GROUP_SELECTED_SIGNAL] = g_signal_new ("selected", GALA_TYPE_ICON_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_icon_group_instance_init (GalaIconGroup * self,
                               gpointer klass)
{
	self->priv = gala_icon_group_get_instance_private (self);
	self->priv->_backdrop_opacity = 0.0f;
	self->priv->_scale_factor = 1.0f;
	self->priv->prev_parent = NULL;
}

static void
gala_icon_group_finalize (GObject * obj)
{
	GalaIconGroup * self;
	ClutterActor* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	_tmp0_ = self->priv->icon_container;
	g_signal_parse_name ("child-removed", clutter_actor_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _gala_icon_group_redraw_clutter_actor_child_removed, self);
	_g_object_unref0 (self->priv->drag_action);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_workspace);
	_g_object_unref0 (self->priv->prev_parent);
	_g_object_unref0 (self->priv->icon_container);
	G_OBJECT_CLASS (gala_icon_group_parent_class)->finalize (obj);
}

/**
     * Container for WindowIconActors which takes care of the scaling and positioning.
     * It also decides whether to draw the container shape, a plus sign or an ellipsis.
     * Lastly it also includes the drawing code for the active highlight.
     */
static GType
gala_icon_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaIconGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_icon_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaIconGroup), 0, (GInstanceInitFunc) gala_icon_group_instance_init, NULL };
	GType gala_icon_group_type_id;
	gala_icon_group_type_id = g_type_register_static (GALA_TYPE_CANVAS_ACTOR, "GalaIconGroup", &g_define_type_info, 0);
	GalaIconGroup_private_offset = g_type_add_instance_private (gala_icon_group_type_id, sizeof (GalaIconGroupPrivate));
	return gala_icon_group_type_id;
}

GType
gala_icon_group_get_type (void)
{
	static volatile gsize gala_icon_group_type_id__once = 0;
	if (g_once_init_enter (&gala_icon_group_type_id__once)) {
		GType gala_icon_group_type_id;
		gala_icon_group_type_id = gala_icon_group_get_type_once ();
		g_once_init_leave (&gala_icon_group_type_id__once, gala_icon_group_type_id);
	}
	return gala_icon_group_type_id__once;
}

static void
_vala_gala_icon_group_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GalaIconGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	switch (property_id) {
		case GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY:
		g_value_set_float (value, gala_icon_group_get_backdrop_opacity (self));
		break;
		case GALA_ICON_GROUP_WM_PROPERTY:
		g_value_set_object (value, gala_icon_group_get_wm (self));
		break;
		case GALA_ICON_GROUP_WORKSPACE_PROPERTY:
		g_value_set_object (value, gala_icon_group_get_workspace (self));
		break;
		case GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY:
		g_value_set_float (value, gala_icon_group_get_scale_factor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_icon_group_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GalaIconGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_ICON_GROUP, GalaIconGroup);
	switch (property_id) {
		case GALA_ICON_GROUP_BACKDROP_OPACITY_PROPERTY:
		gala_icon_group_set_backdrop_opacity (self, g_value_get_float (value));
		break;
		case GALA_ICON_GROUP_WM_PROPERTY:
		gala_icon_group_set_wm (self, g_value_get_object (value));
		break;
		case GALA_ICON_GROUP_WORKSPACE_PROPERTY:
		gala_icon_group_set_workspace (self, g_value_get_object (value));
		break;
		case GALA_ICON_GROUP_SCALE_FACTOR_PROPERTY:
		gala_icon_group_set_scale_factor (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

