/* ScrollBackend.c generated by valac 0.56.16, the Vala compiler
 * generated from ScrollBackend.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc (https://elementary.io)
 *           2021 José Expósito <jose.exposito89@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <clutter/clutter.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>

#define GALA_SCROLL_BACKEND_FINISH_DELTA_HORIZONTAL ((gdouble) 40)
#define GALA_SCROLL_BACKEND_FINISH_DELTA_VERTICAL ((gdouble) 30)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_SCROLL_BACKEND (gala_scroll_backend_get_type ())
#define GALA_SCROLL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_SCROLL_BACKEND, GalaScrollBackend))
#define GALA_SCROLL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_SCROLL_BACKEND, GalaScrollBackendClass))
#define GALA_IS_SCROLL_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_SCROLL_BACKEND))
#define GALA_IS_SCROLL_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_SCROLL_BACKEND))
#define GALA_SCROLL_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_SCROLL_BACKEND, GalaScrollBackendClass))

typedef struct _GalaScrollBackend GalaScrollBackend;
typedef struct _GalaScrollBackendClass GalaScrollBackendClass;
typedef struct _GalaScrollBackendPrivate GalaScrollBackendPrivate;

#define GALA_TYPE_GESTURE_SETTINGS (gala_gesture_settings_get_type ())
#define GALA_GESTURE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettings))
#define GALA_GESTURE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettingsClass))
#define GALA_IS_GESTURE_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_SETTINGS))
#define GALA_IS_GESTURE_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE_SETTINGS))
#define GALA_GESTURE_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE_SETTINGS, GalaGestureSettingsClass))

typedef struct _GalaGestureSettings GalaGestureSettings;
typedef struct _GalaGestureSettingsClass GalaGestureSettingsClass;
typedef enum  {
	GALA_GESTURE_DIRECTION_UNKNOWN = 0,
	GALA_GESTURE_DIRECTION_UP = 1,
	GALA_GESTURE_DIRECTION_DOWN = 2,
	GALA_GESTURE_DIRECTION_LEFT = 3,
	GALA_GESTURE_DIRECTION_RIGHT = 4,
	GALA_GESTURE_DIRECTION_IN = 5,
	GALA_GESTURE_DIRECTION_OUT = 6
} GalaGestureDirection;

#define GALA_TYPE_GESTURE_DIRECTION (gala_gesture_direction_get_type ())
enum  {
	GALA_SCROLL_BACKEND_0_PROPERTY,
	GALA_SCROLL_BACKEND_ACTOR_PROPERTY,
	GALA_SCROLL_BACKEND_ORIENTATION_PROPERTY,
	GALA_SCROLL_BACKEND_SETTINGS_PROPERTY,
	GALA_SCROLL_BACKEND_NUM_PROPERTIES
};
static GParamSpec* gala_scroll_backend_properties[GALA_SCROLL_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_GESTURE (gala_gesture_get_type ())
#define GALA_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE, GalaGesture))
#define GALA_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE, GalaGestureClass))
#define GALA_IS_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE))
#define GALA_IS_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE))
#define GALA_GESTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE, GalaGestureClass))

typedef struct _GalaGesture GalaGesture;
typedef struct _GalaGestureClass GalaGestureClass;
typedef struct _GalaGesturePrivate GalaGesturePrivate;
#define _gala_gesture_unref0(var) ((var == NULL) ? NULL : (var = (gala_gesture_unref (var), NULL)))
enum  {
	GALA_SCROLL_BACKEND_ON_GESTURE_DETECTED_SIGNAL,
	GALA_SCROLL_BACKEND_ON_BEGIN_SIGNAL,
	GALA_SCROLL_BACKEND_ON_UPDATE_SIGNAL,
	GALA_SCROLL_BACKEND_ON_END_SIGNAL,
	GALA_SCROLL_BACKEND_NUM_SIGNALS
};
static guint gala_scroll_backend_signals[GALA_SCROLL_BACKEND_NUM_SIGNALS] = {0};

struct _GalaScrollBackend {
	GObject parent_instance;
	GalaScrollBackendPrivate * priv;
};

struct _GalaScrollBackendClass {
	GObjectClass parent_class;
};

struct _GalaScrollBackendPrivate {
	ClutterActor* _actor;
	ClutterOrientation _orientation;
	GalaGestureSettings* _settings;
	gboolean started;
	gdouble delta_x;
	gdouble delta_y;
	GalaGestureDirection direction;
};

struct _GalaGesture {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaGesturePrivate * priv;
	ClutterEventType type;
	GalaGestureDirection direction;
	gint fingers;
	ClutterInputDeviceType performed_on_device_type;
};

struct _GalaGestureClass {
	GTypeClass parent_class;
	void (*finalize) (GalaGesture *self);
};

static gint GalaScrollBackend_private_offset;
static gpointer gala_scroll_backend_parent_class = NULL;

VALA_EXTERN GType gala_scroll_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaScrollBackend, g_object_unref)
VALA_EXTERN GType gala_gesture_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureSettings, g_object_unref)
VALA_EXTERN GType gala_gesture_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GalaScrollBackend* gala_scroll_backend_new (ClutterActor* actor,
                                            ClutterOrientation orientation,
                                            GalaGestureSettings* settings);
VALA_EXTERN GalaScrollBackend* gala_scroll_backend_construct (GType object_type,
                                                  ClutterActor* actor,
                                                  ClutterOrientation orientation,
                                                  GalaGestureSettings* settings);
static gboolean gala_scroll_backend_on_scroll_event (GalaScrollBackend* self,
                                              ClutterEvent* event);
static gboolean _gala_scroll_backend_on_scroll_event_clutter_actor_scroll_event (ClutterActor* _sender,
                                                                          ClutterEvent* event,
                                                                          gpointer self);
static gboolean gala_scroll_backend_can_handle_event (ClutterEvent* event);
VALA_EXTERN GalaGestureSettings* gala_scroll_backend_get_settings (GalaScrollBackend* self);
VALA_EXTERN gboolean gala_gesture_settings_is_natural_scroll_enabled (GalaGestureSettings* self,
                                                          ClutterInputDeviceType device_type);
VALA_EXTERN gpointer gala_gesture_ref (gpointer instance);
VALA_EXTERN void gala_gesture_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_gesture (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void gala_value_set_gesture (GValue* value,
                             gpointer v_object);
VALA_EXTERN void gala_value_take_gesture (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer gala_value_get_gesture (const GValue* value);
VALA_EXTERN GType gala_gesture_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGesture, gala_gesture_unref)
static GalaGesture* gala_scroll_backend_build_gesture (gdouble delta_x,
                                                gdouble delta_y,
                                                ClutterOrientation orientation);
VALA_EXTERN ClutterOrientation gala_scroll_backend_get_orientation (GalaScrollBackend* self);
static gdouble gala_scroll_backend_calculate_delta (gdouble delta_x,
                                             gdouble delta_y,
                                             GalaGestureDirection direction);
VALA_EXTERN GalaGesture* gala_gesture_new (void);
VALA_EXTERN GalaGesture* gala_gesture_construct (GType object_type);
VALA_EXTERN ClutterActor* gala_scroll_backend_get_actor (GalaScrollBackend* self);
static void gala_scroll_backend_set_actor (GalaScrollBackend* self,
                                    ClutterActor* value);
static void gala_scroll_backend_set_orientation (GalaScrollBackend* self,
                                          ClutterOrientation value);
static void gala_scroll_backend_set_settings (GalaScrollBackend* self,
                                       GalaGestureSettings* value);
static void g_cclosure_user_marshal_VOID__GALA_GESTURE (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__DOUBLE_UINT64 (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static GObject * gala_scroll_backend_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void gala_scroll_backend_finalize (GObject * obj);
static GType gala_scroll_backend_get_type_once (void);
static void _vala_gala_scroll_backend_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gala_scroll_backend_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_scroll_backend_get_instance_private (GalaScrollBackend* self)
{
	return G_STRUCT_MEMBER_P (self, GalaScrollBackend_private_offset);
}

static gboolean
_gala_scroll_backend_on_scroll_event_clutter_actor_scroll_event (ClutterActor* _sender,
                                                                 ClutterEvent* event,
                                                                 gpointer self)
{
	gboolean result;
	result = gala_scroll_backend_on_scroll_event ((GalaScrollBackend*) self, event);
	return result;
}

GalaScrollBackend*
gala_scroll_backend_construct (GType object_type,
                               ClutterActor* actor,
                               ClutterOrientation orientation,
                               GalaGestureSettings* settings)
{
	GalaScrollBackend * self = NULL;
	g_return_val_if_fail (actor != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (GalaScrollBackend*) g_object_new (object_type, "actor", actor, "orientation", orientation, "settings", settings, NULL);
	g_signal_connect_object (actor, "scroll-event", (GCallback) _gala_scroll_backend_on_scroll_event_clutter_actor_scroll_event, self, 0);
	return self;
}

GalaScrollBackend*
gala_scroll_backend_new (ClutterActor* actor,
                         ClutterOrientation orientation,
                         GalaGestureSettings* settings)
{
	return gala_scroll_backend_construct (GALA_TYPE_SCROLL_BACKEND, actor, orientation, settings);
}

static gboolean
gala_scroll_backend_on_scroll_event (GalaScrollBackend* self,
                                     ClutterEvent* event)
{
	guint64 time = 0ULL;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gboolean natural_scroll = FALSE;
	GalaGestureSettings* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (!gala_scroll_backend_can_handle_event (event)) {
		result = FALSE;
		return result;
	}
	time = (guint64) clutter_event_get_time (event);
	clutter_event_get_scroll_delta (event, &_tmp0_, &_tmp1_);
	x = _tmp0_;
	y = _tmp1_;
	_tmp2_ = self->priv->_settings;
	natural_scroll = gala_gesture_settings_is_natural_scroll_enabled (_tmp2_, CLUTTER_TOUCHPAD_DEVICE);
	if (natural_scroll) {
		x *= (gdouble) -1;
		y *= (gdouble) -1;
	}
	self->priv->delta_x = self->priv->delta_x + x;
	self->priv->delta_y = self->priv->delta_y + y;
	if (!self->priv->started) {
		gboolean _tmp3_ = FALSE;
		if (self->priv->delta_x != ((gdouble) 0)) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = self->priv->delta_y != ((gdouble) 0);
		}
		if (_tmp3_) {
			GalaGesture* gesture = NULL;
			ClutterOrientation _tmp4_;
			GalaGesture* _tmp5_;
			GalaGesture* _tmp6_;
			GalaGesture* _tmp7_;
			gdouble delta = 0.0;
			_tmp4_ = self->priv->_orientation;
			_tmp5_ = gala_scroll_backend_build_gesture (self->priv->delta_x, self->priv->delta_y, _tmp4_);
			gesture = _tmp5_;
			self->priv->started = TRUE;
			_tmp6_ = gesture;
			self->priv->direction = _tmp6_->direction;
			_tmp7_ = gesture;
			g_signal_emit (self, gala_scroll_backend_signals[GALA_SCROLL_BACKEND_ON_GESTURE_DETECTED_SIGNAL], 0, _tmp7_);
			delta = gala_scroll_backend_calculate_delta (self->priv->delta_x, self->priv->delta_y, self->priv->direction);
			g_signal_emit (self, gala_scroll_backend_signals[GALA_SCROLL_BACKEND_ON_BEGIN_SIGNAL], 0, delta, time);
			_gala_gesture_unref0 (gesture);
		}
	} else {
		gdouble delta = 0.0;
		gboolean _tmp8_ = FALSE;
		delta = gala_scroll_backend_calculate_delta (self->priv->delta_x, self->priv->delta_y, self->priv->direction);
		if (x == ((gdouble) 0)) {
			_tmp8_ = y == ((gdouble) 0);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			self->priv->started = FALSE;
			self->priv->delta_x = (gdouble) 0;
			self->priv->delta_y = (gdouble) 0;
			self->priv->direction = GALA_GESTURE_DIRECTION_UNKNOWN;
			g_signal_emit (self, gala_scroll_backend_signals[GALA_SCROLL_BACKEND_ON_END_SIGNAL], 0, delta, time);
		} else {
			g_signal_emit (self, gala_scroll_backend_signals[GALA_SCROLL_BACKEND_ON_UPDATE_SIGNAL], 0, delta, time);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
gala_scroll_backend_can_handle_event (ClutterEvent* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (clutter_event_type (event) == CLUTTER_SCROLL) {
		ClutterInputDevice* _tmp2_;
		_tmp2_ = clutter_event_get_source_device (event);
		_tmp1_ = clutter_input_device_get_device_type (_tmp2_) == CLUTTER_TOUCHPAD_DEVICE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = clutter_event_get_scroll_direction (event) == CLUTTER_SCROLL_SMOOTH;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static GalaGesture*
gala_scroll_backend_build_gesture (gdouble delta_x,
                                   gdouble delta_y,
                                   ClutterOrientation orientation)
{
	GalaGestureDirection direction = 0;
	GalaGesture* _tmp2_ = NULL;
	GalaGesture* result;
	if (orientation == CLUTTER_ORIENTATION_HORIZONTAL) {
		GalaGestureDirection _tmp0_ = 0;
		if (delta_x > ((gdouble) 0)) {
			_tmp0_ = GALA_GESTURE_DIRECTION_RIGHT;
		} else {
			_tmp0_ = GALA_GESTURE_DIRECTION_LEFT;
		}
		direction = _tmp0_;
	} else {
		GalaGestureDirection _tmp1_ = 0;
		if (delta_y > ((gdouble) 0)) {
			_tmp1_ = GALA_GESTURE_DIRECTION_DOWN;
		} else {
			_tmp1_ = GALA_GESTURE_DIRECTION_UP;
		}
		direction = _tmp1_;
	}
	_tmp2_ = gala_gesture_new ();
	_tmp2_->type = CLUTTER_SCROLL;
	_tmp2_->direction = direction;
	_tmp2_->fingers = 2;
	_tmp2_->performed_on_device_type = CLUTTER_TOUCHPAD_DEVICE;
	result = _tmp2_;
	return result;
}

static gdouble
gala_scroll_backend_calculate_delta (gdouble delta_x,
                                     gdouble delta_y,
                                     GalaGestureDirection direction)
{
	gboolean _tmp0_ = FALSE;
	gboolean is_horizontal = FALSE;
	gdouble _tmp1_ = 0.0;
	gdouble used_delta = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble finish_delta = 0.0;
	gboolean _tmp3_ = FALSE;
	gboolean is_positive = FALSE;
	gint _tmp4_ = 0;
	gdouble clamp_low = 0.0;
	gint _tmp5_ = 0;
	gdouble clamp_high = 0.0;
	gdouble normalized_delta = 0.0;
	gdouble result;
	if (direction == GALA_GESTURE_DIRECTION_LEFT) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = direction == GALA_GESTURE_DIRECTION_RIGHT;
	}
	is_horizontal = _tmp0_;
	if (is_horizontal) {
		_tmp1_ = delta_x;
	} else {
		_tmp1_ = delta_y;
	}
	used_delta = _tmp1_;
	if (is_horizontal) {
		_tmp2_ = GALA_SCROLL_BACKEND_FINISH_DELTA_HORIZONTAL;
	} else {
		_tmp2_ = GALA_SCROLL_BACKEND_FINISH_DELTA_VERTICAL;
	}
	finish_delta = _tmp2_;
	if (direction == GALA_GESTURE_DIRECTION_RIGHT) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = direction == GALA_GESTURE_DIRECTION_DOWN;
	}
	is_positive = _tmp3_;
	if (is_positive) {
		_tmp4_ = 0;
	} else {
		_tmp4_ = -1;
	}
	clamp_low = (gdouble) _tmp4_;
	if (is_positive) {
		_tmp5_ = 1;
	} else {
		_tmp5_ = 0;
	}
	clamp_high = (gdouble) _tmp5_;
	normalized_delta = fabs (CLAMP (used_delta / finish_delta, clamp_low, clamp_high));
	result = normalized_delta;
	return result;
}

ClutterActor*
gala_scroll_backend_get_actor (GalaScrollBackend* self)
{
	ClutterActor* result;
	ClutterActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_actor;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
gala_scroll_backend_set_actor (GalaScrollBackend* self,
                               ClutterActor* value)
{
	ClutterActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_scroll_backend_get_actor (self);
	if (old_value != value) {
		ClutterActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_actor);
		self->priv->_actor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_scroll_backend_properties[GALA_SCROLL_BACKEND_ACTOR_PROPERTY]);
	}
}

ClutterOrientation
gala_scroll_backend_get_orientation (GalaScrollBackend* self)
{
	ClutterOrientation result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_orientation;
	return result;
}

static void
gala_scroll_backend_set_orientation (GalaScrollBackend* self,
                                     ClutterOrientation value)
{
	ClutterOrientation old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_scroll_backend_get_orientation (self);
	if (old_value != value) {
		self->priv->_orientation = value;
		g_object_notify_by_pspec ((GObject *) self, gala_scroll_backend_properties[GALA_SCROLL_BACKEND_ORIENTATION_PROPERTY]);
	}
}

GalaGestureSettings*
gala_scroll_backend_get_settings (GalaScrollBackend* self)
{
	GalaGestureSettings* result;
	GalaGestureSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
gala_scroll_backend_set_settings (GalaScrollBackend* self,
                                  GalaGestureSettings* value)
{
	GalaGestureSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_scroll_backend_get_settings (self);
	if (old_value != value) {
		GalaGestureSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_scroll_backend_properties[GALA_SCROLL_BACKEND_SETTINGS_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__GALA_GESTURE (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__GALA_GESTURE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__GALA_GESTURE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__GALA_GESTURE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, gala_value_get_gesture (param_values + 1), data2);
}

static void
g_cclosure_user_marshal_VOID__DOUBLE_UINT64 (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__DOUBLE_UINT64) (gpointer data1, gdouble arg_1, guint64 arg_2, gpointer data2);
	register GMarshalFunc_VOID__DOUBLE_UINT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__DOUBLE_UINT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_double (param_values + 1), g_value_get_uint64 (param_values + 2), data2);
}

static GObject *
gala_scroll_backend_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaScrollBackend * self;
	parent_class = G_OBJECT_CLASS (gala_scroll_backend_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SCROLL_BACKEND, GalaScrollBackend);
	self->priv->started = FALSE;
	self->priv->delta_x = (gdouble) 0;
	self->priv->delta_y = (gdouble) 0;
	self->priv->direction = GALA_GESTURE_DIRECTION_UNKNOWN;
	return obj;
}

static void
gala_scroll_backend_class_init (GalaScrollBackendClass * klass,
                                gpointer klass_data)
{
	gala_scroll_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaScrollBackend_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_scroll_backend_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_scroll_backend_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_scroll_backend_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_scroll_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SCROLL_BACKEND_ACTOR_PROPERTY, gala_scroll_backend_properties[GALA_SCROLL_BACKEND_ACTOR_PROPERTY] = g_param_spec_object ("actor", "actor", "actor", clutter_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SCROLL_BACKEND_ORIENTATION_PROPERTY, gala_scroll_backend_properties[GALA_SCROLL_BACKEND_ORIENTATION_PROPERTY] = g_param_spec_enum ("orientation", "orientation", "orientation", clutter_orientation_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SCROLL_BACKEND_SETTINGS_PROPERTY, gala_scroll_backend_properties[GALA_SCROLL_BACKEND_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", GALA_TYPE_GESTURE_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_scroll_backend_signals[GALA_SCROLL_BACKEND_ON_GESTURE_DETECTED_SIGNAL] = g_signal_new ("on-gesture-detected", GALA_TYPE_SCROLL_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__GALA_GESTURE, G_TYPE_NONE, 1, GALA_TYPE_GESTURE);
	gala_scroll_backend_signals[GALA_SCROLL_BACKEND_ON_BEGIN_SIGNAL] = g_signal_new ("on-begin", GALA_TYPE_SCROLL_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_UINT64, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_UINT64);
	gala_scroll_backend_signals[GALA_SCROLL_BACKEND_ON_UPDATE_SIGNAL] = g_signal_new ("on-update", GALA_TYPE_SCROLL_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_UINT64, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_UINT64);
	gala_scroll_backend_signals[GALA_SCROLL_BACKEND_ON_END_SIGNAL] = g_signal_new ("on-end", GALA_TYPE_SCROLL_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__DOUBLE_UINT64, G_TYPE_NONE, 2, G_TYPE_DOUBLE, G_TYPE_UINT64);
}

static void
gala_scroll_backend_instance_init (GalaScrollBackend * self,
                                   gpointer klass)
{
	self->priv = gala_scroll_backend_get_instance_private (self);
}

static void
gala_scroll_backend_finalize (GObject * obj)
{
	GalaScrollBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SCROLL_BACKEND, GalaScrollBackend);
	_g_object_unref0 (self->priv->_actor);
	_g_object_unref0 (self->priv->_settings);
	G_OBJECT_CLASS (gala_scroll_backend_parent_class)->finalize (obj);
}

/**
 * This gesture backend transforms the touchpad scroll events received by an actor into gestures.
 */
static GType
gala_scroll_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaScrollBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_scroll_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaScrollBackend), 0, (GInstanceInitFunc) gala_scroll_backend_instance_init, NULL };
	GType gala_scroll_backend_type_id;
	gala_scroll_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaScrollBackend", &g_define_type_info, 0);
	GalaScrollBackend_private_offset = g_type_add_instance_private (gala_scroll_backend_type_id, sizeof (GalaScrollBackendPrivate));
	return gala_scroll_backend_type_id;
}

GType
gala_scroll_backend_get_type (void)
{
	static volatile gsize gala_scroll_backend_type_id__once = 0;
	if (g_once_init_enter (&gala_scroll_backend_type_id__once)) {
		GType gala_scroll_backend_type_id;
		gala_scroll_backend_type_id = gala_scroll_backend_get_type_once ();
		g_once_init_leave (&gala_scroll_backend_type_id__once, gala_scroll_backend_type_id);
	}
	return gala_scroll_backend_type_id__once;
}

static void
_vala_gala_scroll_backend_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GalaScrollBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SCROLL_BACKEND, GalaScrollBackend);
	switch (property_id) {
		case GALA_SCROLL_BACKEND_ACTOR_PROPERTY:
		g_value_set_object (value, gala_scroll_backend_get_actor (self));
		break;
		case GALA_SCROLL_BACKEND_ORIENTATION_PROPERTY:
		g_value_set_enum (value, gala_scroll_backend_get_orientation (self));
		break;
		case GALA_SCROLL_BACKEND_SETTINGS_PROPERTY:
		g_value_set_object (value, gala_scroll_backend_get_settings (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_scroll_backend_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GalaScrollBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SCROLL_BACKEND, GalaScrollBackend);
	switch (property_id) {
		case GALA_SCROLL_BACKEND_ACTOR_PROPERTY:
		gala_scroll_backend_set_actor (self, g_value_get_object (value));
		break;
		case GALA_SCROLL_BACKEND_ORIENTATION_PROPERTY:
		gala_scroll_backend_set_orientation (self, g_value_get_enum (value));
		break;
		case GALA_SCROLL_BACKEND_SETTINGS_PROPERTY:
		gala_scroll_backend_set_settings (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

