/* BackgroundManager.c generated by valac 0.56.16, the Vala compiler
 * generated from BackgroundManager.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 *                         2014 Tom Beckmann
 */

#include <meta/meta-background-group.h>
#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <meta/meta-background-actor.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <meta/meta-background-content.h>
#include <meta/meta-background.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <mtk/mtk.h>
#include <string.h>

#define GALA_BACKGROUND_MANAGER_DIM_OPACITY 0.55
#define GALA_BACKGROUND_MANAGER_FADE_ANIMATION_TIME 1000
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_BACKGROUND_MANAGER (gala_background_manager_get_type ())
#define GALA_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager))
#define GALA_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))
#define GALA_IS_BACKGROUND_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_IS_BACKGROUND_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_MANAGER))
#define GALA_BACKGROUND_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManagerClass))

typedef struct _GalaBackgroundManager GalaBackgroundManager;
typedef struct _GalaBackgroundManagerClass GalaBackgroundManagerClass;
typedef struct _GalaBackgroundManagerPrivate GalaBackgroundManagerPrivate;

#define GALA_TYPE_BACKGROUND_SOURCE (gala_background_source_get_type ())
#define GALA_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSource))
#define GALA_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))
#define GALA_IS_BACKGROUND_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_IS_BACKGROUND_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_SOURCE))
#define GALA_BACKGROUND_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_SOURCE, GalaBackgroundSourceClass))

typedef struct _GalaBackgroundSource GalaBackgroundSource;
typedef struct _GalaBackgroundSourceClass GalaBackgroundSourceClass;
enum  {
	GALA_BACKGROUND_MANAGER_0_PROPERTY,
	GALA_BACKGROUND_MANAGER_WM_PROPERTY,
	GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY,
	GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY,
	GALA_BACKGROUND_MANAGER_NEWEST_BACKGROUND_ACTOR_PROPERTY,
	GALA_BACKGROUND_MANAGER_NUM_PROPERTIES
};
static GParamSpec* gala_background_manager_properties[GALA_BACKGROUND_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GALA_TYPE_BACKGROUND_CACHE (gala_background_cache_get_type ())
#define GALA_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCache))
#define GALA_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))
#define GALA_IS_BACKGROUND_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_IS_BACKGROUND_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND_CACHE))
#define GALA_BACKGROUND_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND_CACHE, GalaBackgroundCacheClass))

typedef struct _GalaBackgroundCache GalaBackgroundCache;
typedef struct _GalaBackgroundCacheClass GalaBackgroundCacheClass;
typedef struct _Block47Data Block47Data;

#define GALA_TYPE_BACKGROUND (gala_background_get_type ())
#define GALA_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_BACKGROUND, GalaBackground))
#define GALA_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_BACKGROUND, GalaBackgroundClass))
#define GALA_IS_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_BACKGROUND))
#define GALA_IS_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_BACKGROUND))
#define GALA_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_BACKGROUND, GalaBackgroundClass))

typedef struct _GalaBackground GalaBackground;
typedef struct _GalaBackgroundClass GalaBackgroundClass;
typedef struct _Block48Data Block48Data;
typedef struct _Block49Data Block49Data;
enum  {
	GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL,
	GALA_BACKGROUND_MANAGER_NUM_SIGNALS
};
static guint gala_background_manager_signals[GALA_BACKGROUND_MANAGER_NUM_SIGNALS] = {0};

struct _GalaBackgroundManager {
	MetaBackgroundGroup parent_instance;
	GalaBackgroundManagerPrivate * priv;
};

struct _GalaBackgroundManagerClass {
	MetaBackgroundGroupClass parent_class;
};

struct _GalaBackgroundManagerPrivate {
	GalaWindowManager* _wm;
	gint _monitor_index;
	gboolean _control_position;
	GalaBackgroundSource* background_source;
	MetaBackgroundActor* background_actor;
	MetaBackgroundActor* new_background_actor;
};

struct _Block47Data {
	int _ref_count_;
	GalaBackgroundManager* self;
	MetaBackgroundActor* old_background_actor;
};

struct _Block48Data {
	int _ref_count_;
	GalaBackgroundManager* self;
	MetaBackgroundContent* new_content;
	GalaBackground* background;
	gulong handler;
	gboolean animate;
};

struct _Block49Data {
	int _ref_count_;
	GalaBackgroundManager* self;
	GalaBackground* background;
	gulong changed_handler;
};

static gint GalaBackgroundManager_private_offset;
static gpointer gala_background_manager_parent_class = NULL;
static GalaBackgroundManagerInterfaceIface * gala_background_manager_gala_background_manager_interface_parent_iface = NULL;

VALA_EXTERN GType gala_background_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundManager, g_object_unref)
VALA_EXTERN GType gala_background_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundSource, g_object_unref)
VALA_EXTERN GalaBackgroundManager* gala_background_manager_new (GalaWindowManager* wm,
                                                    gint monitor_index,
                                                    gboolean control_position);
VALA_EXTERN GalaBackgroundManager* gala_background_manager_construct (GType object_type,
                                                          GalaWindowManager* wm,
                                                          gint monitor_index,
                                                          gboolean control_position);
static void gala_background_manager_on_destroy (GalaBackgroundManager* self);
VALA_EXTERN GType gala_background_cache_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackgroundCache, g_object_unref)
VALA_EXTERN GalaBackgroundCache* gala_background_cache_get_default (void);
VALA_EXTERN void gala_background_cache_release_background_source (GalaBackgroundCache* self);
static void gala_background_manager_swap_background_actor (GalaBackgroundManager* self,
                                                    gboolean animate);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
VALA_EXTERN GalaWindowManager* gala_background_manager_get_wm (GalaBackgroundManager* self);
static void ___lambda45_ (Block47Data* _data47_);
static void ____lambda45__clutter_timeline_completed (ClutterTimeline* _sender,
                                               gpointer self);
static void gala_background_manager_update_background_actor (GalaBackgroundManager* self,
                                                      gboolean animate);
VALA_EXTERN GType gala_background_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaBackground, g_object_unref)
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static MetaBackgroundActor* gala_background_manager_create_background_actor (GalaBackgroundManager* self);
VALA_EXTERN gboolean gala_background_get_is_loaded (GalaBackground* self);
VALA_EXTERN gint gala_background_manager_get_monitor_index (GalaBackgroundManager* self);
static void __lambda48_ (Block48Data* _data48_);
static void ___lambda48__gala_background_loaded (GalaBackground* _sender,
                                          gpointer self);
VALA_EXTERN void gala_background_manager_set_size (GalaBackgroundManager* self,
                                       gfloat width,
                                       gfloat height);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
VALA_EXTERN GalaBackground* gala_background_source_get_background (GalaBackgroundSource* self,
                                                       gint monitor_index);
VALA_EXTERN MetaBackground* gala_background_get_background (GalaBackground* self);
VALA_EXTERN gboolean gala_background_source_get_should_dim (GalaBackgroundSource* self);
VALA_EXTERN gboolean gala_background_manager_get_control_position (GalaBackgroundManager* self);
static void __lambda46_ (Block49Data* _data49_);
static void ___lambda46__gala_background_changed (GalaBackground* _sender,
                                           gpointer self);
static void __lambda47_ (Block49Data* _data49_);
static void ___lambda47__clutter_actor_destroy (ClutterActor* _sender,
                                         gpointer self);
static void gala_background_manager_set_wm (GalaBackgroundManager* self,
                                     GalaWindowManager* value);
static void gala_background_manager_set_monitor_index (GalaBackgroundManager* self,
                                                gint value);
static void gala_background_manager_set_control_position (GalaBackgroundManager* self,
                                                   gboolean value);
static GObject * gala_background_manager_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
VALA_EXTERN GalaBackgroundSource* gala_background_cache_get_background_source (GalaBackgroundCache* self,
                                                                   MetaDisplay* display);
static void _gala_background_manager_on_destroy_clutter_actor_destroy (ClutterActor* _sender,
                                                                gpointer self);
static void gala_background_manager_finalize (GObject * obj);
static GType gala_background_manager_get_type_once (void);
static void _vala_gala_background_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gala_background_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_background_manager_get_instance_private (GalaBackgroundManager* self)
{
	return G_STRUCT_MEMBER_P (self, GalaBackgroundManager_private_offset);
}

GalaBackgroundManager*
gala_background_manager_construct (GType object_type,
                                   GalaWindowManager* wm,
                                   gint monitor_index,
                                   gboolean control_position)
{
	GalaBackgroundManager * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	self = (GalaBackgroundManager*) g_object_new (object_type, "wm", wm, "monitor-index", monitor_index, "control-position", control_position, NULL);
	return self;
}

GalaBackgroundManager*
gala_background_manager_new (GalaWindowManager* wm,
                             gint monitor_index,
                             gboolean control_position)
{
	return gala_background_manager_construct (GALA_TYPE_BACKGROUND_MANAGER, wm, monitor_index, control_position);
}

static void
gala_background_manager_on_destroy (GalaBackgroundManager* self)
{
	GalaBackgroundCache* _tmp0_;
	MetaBackgroundActor* _tmp1_;
	MetaBackgroundActor* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_background_cache_get_default ();
	gala_background_cache_release_background_source (_tmp0_);
	_g_object_unref0 (self->priv->background_source);
	self->priv->background_source = NULL;
	_tmp1_ = self->priv->new_background_actor;
	if (_tmp1_ != NULL) {
		MetaBackgroundActor* _tmp2_;
		_tmp2_ = self->priv->new_background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp2_);
		_g_object_unref0 (self->priv->new_background_actor);
		self->priv->new_background_actor = NULL;
	}
	_tmp3_ = self->priv->background_actor;
	if (_tmp3_ != NULL) {
		MetaBackgroundActor* _tmp4_;
		_tmp4_ = self->priv->background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp4_);
		_g_object_unref0 (self->priv->background_actor);
		self->priv->background_actor = NULL;
	}
}

static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		GalaBackgroundManager* self;
		self = _data47_->self;
		_g_object_unref0 (_data47_->old_background_actor);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
___lambda45_ (Block47Data* _data47_)
{
	GalaBackgroundManager* self;
	MetaBackgroundActor* _tmp0_;
	self = _data47_->self;
	_tmp0_ = _data47_->old_background_actor;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
}

static void
____lambda45__clutter_timeline_completed (ClutterTimeline* _sender,
                                          gpointer self)
{
	___lambda45_ (self);
}

static void
gala_background_manager_swap_background_actor (GalaBackgroundManager* self,
                                               gboolean animate)
{
	Block47Data* _data47_;
	MetaBackgroundActor* _tmp0_;
	MetaBackgroundActor* _tmp1_;
	MetaBackgroundActor* _tmp2_;
	MetaBackgroundActor* _tmp3_;
	MetaBackgroundActor* _tmp4_;
	MetaBackgroundActor* _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_data47_ = g_slice_new0 (Block47Data);
	_data47_->_ref_count_ = 1;
	_data47_->self = g_object_ref (self);
	_tmp0_ = self->priv->new_background_actor;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->background_actor;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data47_->old_background_actor = _tmp2_;
	_tmp3_ = self->priv->new_background_actor;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->background_actor);
	self->priv->background_actor = _tmp4_;
	_g_object_unref0 (self->priv->new_background_actor);
	self->priv->new_background_actor = NULL;
	_tmp5_ = _data47_->old_background_actor;
	if (_tmp5_ == NULL) {
		block47_data_unref (_data47_);
		_data47_ = NULL;
		return;
	}
	if (animate) {
		GalaWindowManager* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->_wm;
		_tmp8_ = gala_window_manager_get_enable_animations (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp6_ = _tmp9_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ClutterPropertyTransition* transition = NULL;
		ClutterPropertyTransition* _tmp10_;
		ClutterPropertyTransition* _tmp11_;
		GValue _tmp12_ = {0};
		ClutterPropertyTransition* _tmp13_;
		GValue _tmp14_ = {0};
		ClutterPropertyTransition* _tmp15_;
		ClutterPropertyTransition* _tmp16_;
		ClutterPropertyTransition* _tmp17_;
		ClutterPropertyTransition* _tmp18_;
		MetaBackgroundActor* _tmp19_;
		ClutterPropertyTransition* _tmp20_;
		_tmp10_ = (ClutterPropertyTransition*) clutter_property_transition_new ("opacity");
		transition = _tmp10_;
		_tmp11_ = transition;
		g_value_init (&_tmp12_, G_TYPE_INT);
		g_value_set_int (&_tmp12_, 255);
		clutter_transition_set_from_value ((ClutterTransition*) _tmp11_, &_tmp12_);
		G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
		_tmp13_ = transition;
		g_value_init (&_tmp14_, G_TYPE_INT);
		g_value_set_int (&_tmp14_, 0);
		clutter_transition_set_to_value ((ClutterTransition*) _tmp13_, &_tmp14_);
		G_IS_VALUE (&_tmp14_) ? (g_value_unset (&_tmp14_), NULL) : NULL;
		_tmp15_ = transition;
		clutter_timeline_set_duration ((ClutterTimeline*) _tmp15_, (guint) GALA_BACKGROUND_MANAGER_FADE_ANIMATION_TIME);
		_tmp16_ = transition;
		clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp16_, CLUTTER_EASE_OUT_QUAD);
		_tmp17_ = transition;
		clutter_transition_set_remove_on_complete ((ClutterTransition*) _tmp17_, TRUE);
		_tmp18_ = transition;
		g_signal_connect_data ((ClutterTimeline*) _tmp18_, "completed", (GCallback) ____lambda45__clutter_timeline_completed, block47_data_ref (_data47_), (GClosureNotify) block47_data_unref, 0);
		_tmp19_ = _data47_->old_background_actor;
		_tmp20_ = transition;
		clutter_actor_add_transition ((ClutterActor*) _tmp19_, "fade-out", (ClutterTransition*) _tmp20_);
		_g_object_unref0 (transition);
	} else {
		MetaBackgroundActor* _tmp21_;
		_tmp21_ = _data47_->old_background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp21_);
	}
	g_signal_emit (self, gala_background_manager_signals[GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL], 0);
	block47_data_unref (_data47_);
	_data47_ = NULL;
}

static Block48Data*
block48_data_ref (Block48Data* _data48_)
{
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}

static void
block48_data_unref (void * _userdata_)
{
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		GalaBackgroundManager* self;
		self = _data48_->self;
		_g_object_unref0 (_data48_->background);
		_g_object_unref0 (_data48_->new_content);
		_g_object_unref0 (self);
		g_slice_free (Block48Data, _data48_);
	}
}

static void
__lambda48_ (Block48Data* _data48_)
{
	GalaBackgroundManager* self;
	GalaBackground* _tmp0_;
	GalaBackground* _tmp1_;
	MetaBackgroundContent* _tmp2_;
	GalaWindowManager* _tmp3_;
	MetaDisplay* _tmp4_;
	gint _tmp5_;
	self = _data48_->self;
	_tmp0_ = _data48_->background;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data48_->handler);
	_tmp1_ = _data48_->background;
	g_object_set_data_full ((GObject*) _tmp1_, "background-loaded-handler", (gpointer) ((guintptr) 0), NULL);
	gala_background_manager_swap_background_actor (self, _data48_->animate);
	_tmp2_ = _data48_->new_content;
	_tmp3_ = self->priv->_wm;
	_tmp4_ = meta_plugin_get_display ((MetaPlugin*) _tmp3_);
	_tmp5_ = self->priv->_monitor_index;
	g_object_set (_tmp2_, "rounded-clip-radius", (gfloat) gala_utils_scale_to_int (6, meta_display_get_monitor_scale (_tmp4_, _tmp5_)), NULL);
}

static void
___lambda48__gala_background_loaded (GalaBackground* _sender,
                                     gpointer self)
{
	__lambda48_ (self);
}

static void
gala_background_manager_update_background_actor (GalaBackgroundManager* self,
                                                 gboolean animate)
{
	Block48Data* _data48_;
	MetaBackgroundActor* _tmp0_;
	MetaBackgroundActor* _tmp2_;
	MetaBackgroundActor* _tmp3_;
	ClutterContent* _tmp4_;
	ClutterContent* _tmp5_;
	MetaBackgroundContent* _tmp6_;
	MetaBackgroundActor* _tmp7_;
	MetaBackgroundActor* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	MetaBackgroundContent* _tmp11_;
	MetaBackground* _tmp12_;
	MetaBackground* _tmp13_;
	MetaBackground* _tmp14_;
	gconstpointer _tmp15_;
	GalaBackground* _tmp16_;
	GalaBackground* _tmp17_;
	GalaBackground* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GalaBackground* _tmp25_;
	gulong _tmp26_;
	GalaBackground* _tmp27_;
	g_return_if_fail (self != NULL);
	_data48_ = g_slice_new0 (Block48Data);
	_data48_->_ref_count_ = 1;
	_data48_->self = g_object_ref (self);
	_data48_->animate = animate;
	_tmp0_ = self->priv->new_background_actor;
	if (_tmp0_ != NULL) {
		MetaBackgroundActor* _tmp1_;
		_tmp1_ = self->priv->new_background_actor;
		clutter_actor_destroy ((ClutterActor*) _tmp1_);
		_g_object_unref0 (self->priv->new_background_actor);
		self->priv->new_background_actor = NULL;
	}
	_tmp2_ = gala_background_manager_create_background_actor (self);
	_g_object_unref0 (self->priv->new_background_actor);
	self->priv->new_background_actor = _tmp2_;
	_tmp3_ = self->priv->new_background_actor;
	_tmp4_ = clutter_actor_get_content ((ClutterActor*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, meta_background_content_get_type (), MetaBackgroundContent));
	_data48_->new_content = _tmp6_;
	_tmp7_ = self->priv->new_background_actor;
	_tmp8_ = self->priv->background_actor;
	g_object_get ((ClutterActor*) _tmp8_, "visible", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	g_object_set ((ClutterActor*) _tmp7_, "visible", _tmp10_, NULL);
	_tmp11_ = _data48_->new_content;
	g_object_get (_tmp11_, "background", &_tmp12_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp15_ = g_object_get_data ((GObject*) _tmp14_, "delegate");
	_tmp16_ = _g_object_ref0 ((GalaBackground*) _tmp15_);
	_tmp17_ = _tmp16_;
	_g_object_unref0 (_tmp14_);
	_data48_->background = _tmp17_;
	_tmp18_ = _data48_->background;
	_tmp19_ = gala_background_get_is_loaded (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		MetaBackgroundContent* _tmp21_;
		GalaWindowManager* _tmp22_;
		MetaDisplay* _tmp23_;
		gint _tmp24_;
		_tmp21_ = _data48_->new_content;
		_tmp22_ = self->priv->_wm;
		_tmp23_ = meta_plugin_get_display ((MetaPlugin*) _tmp22_);
		_tmp24_ = self->priv->_monitor_index;
		g_object_set (_tmp21_, "rounded-clip-radius", (gfloat) gala_utils_scale_to_int (6, meta_display_get_monitor_scale (_tmp23_, _tmp24_)), NULL);
		gala_background_manager_swap_background_actor (self, _data48_->animate);
		block48_data_unref (_data48_);
		_data48_ = NULL;
		return;
	}
	_data48_->handler = (gulong) 0;
	_tmp25_ = _data48_->background;
	_tmp26_ = g_signal_connect_data (_tmp25_, "loaded", (GCallback) ___lambda48__gala_background_loaded, block48_data_ref (_data48_), (GClosureNotify) block48_data_unref, 0);
	_data48_->handler = _tmp26_;
	_tmp27_ = _data48_->background;
	g_object_set_data_full ((GObject*) _tmp27_, "background-loaded-handler", (gpointer) ((guintptr) _data48_->handler), NULL);
	block48_data_unref (_data48_);
	_data48_ = NULL;
}

void
gala_background_manager_set_size (GalaBackgroundManager* self,
                                  gfloat width,
                                  gfloat height)
{
	gboolean _tmp0_ = FALSE;
	MetaBackgroundActor* _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->background_actor;
	_tmp2_ = clutter_actor_get_width ((ClutterActor*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (width != _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		MetaBackgroundActor* _tmp4_;
		gfloat _tmp5_;
		gfloat _tmp6_;
		_tmp4_ = self->priv->background_actor;
		_tmp5_ = clutter_actor_get_height ((ClutterActor*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = height != _tmp6_;
	}
	if (_tmp0_) {
		gala_background_manager_update_background_actor (self, FALSE);
	}
}

static Block49Data*
block49_data_ref (Block49Data* _data49_)
{
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}

static void
block49_data_unref (void * _userdata_)
{
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		GalaBackgroundManager* self;
		self = _data49_->self;
		_g_object_unref0 (_data49_->background);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}

static void
__lambda46_ (Block49Data* _data49_)
{
	GalaBackgroundManager* self;
	GalaBackground* _tmp0_;
	self = _data49_->self;
	_tmp0_ = _data49_->background;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data49_->changed_handler);
	_data49_->changed_handler = (gulong) 0;
	gala_background_manager_update_background_actor (self, TRUE);
}

static void
___lambda46__gala_background_changed (GalaBackground* _sender,
                                      gpointer self)
{
	__lambda46_ (self);
}

static void
__lambda47_ (Block49Data* _data49_)
{
	GalaBackgroundManager* self;
	gulong loaded_handler = 0UL;
	GalaBackground* _tmp1_;
	gconstpointer _tmp2_;
	self = _data49_->self;
	if (_data49_->changed_handler != ((gulong) 0)) {
		GalaBackground* _tmp0_;
		_tmp0_ = _data49_->background;
		g_signal_handler_disconnect ((GObject*) _tmp0_, _data49_->changed_handler);
		_data49_->changed_handler = (gulong) 0;
	}
	_tmp1_ = _data49_->background;
	_tmp2_ = g_object_get_data ((GObject*) _tmp1_, "background-loaded-handler");
	loaded_handler = (gulong) ((guintptr) _tmp2_);
	if (loaded_handler != ((gulong) 0)) {
		GalaBackground* _tmp3_;
		GalaBackground* _tmp4_;
		_tmp3_ = _data49_->background;
		g_signal_handler_disconnect ((GObject*) _tmp3_, loaded_handler);
		_tmp4_ = _data49_->background;
		g_object_set_data_full ((GObject*) _tmp4_, "background-loaded-handler", (gpointer) ((guintptr) 0), NULL);
	}
}

static void
___lambda47__clutter_actor_destroy (ClutterActor* _sender,
                                    gpointer self)
{
	__lambda47_ (self);
}

static MetaBackgroundActor*
gala_background_manager_create_background_actor (GalaBackgroundManager* self)
{
	Block49Data* _data49_;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	GalaBackgroundSource* _tmp2_;
	gint _tmp3_;
	GalaBackground* _tmp4_;
	MetaBackgroundActor* background_actor = NULL;
	MetaDisplay* _tmp5_;
	gint _tmp6_;
	MetaBackgroundActor* _tmp7_;
	MetaBackgroundContent* content = NULL;
	MetaBackgroundActor* _tmp8_;
	ClutterContent* _tmp9_;
	ClutterContent* _tmp10_;
	MetaBackgroundContent* _tmp11_;
	GalaBackground* _tmp12_;
	MetaBackground* _tmp13_;
	MetaBackground* _tmp14_;
	MtkRectangle monitor = {0};
	MetaDisplay* _tmp15_;
	gint _tmp16_;
	MtkRectangle _tmp17_ = {0};
	GalaBackgroundSource* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	MetaBackgroundActor* _tmp23_;
	MetaBackgroundActor* _tmp24_;
	MtkRectangle _tmp25_;
	MtkRectangle _tmp26_;
	gboolean _tmp27_;
	GalaBackground* _tmp31_;
	gulong _tmp32_;
	MetaBackgroundActor* _tmp33_;
	MetaBackgroundActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_data49_->self = g_object_ref (self);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = self->priv->background_source;
	_tmp3_ = self->priv->_monitor_index;
	_tmp4_ = gala_background_source_get_background (_tmp2_, _tmp3_);
	_data49_->background = _tmp4_;
	_tmp5_ = display;
	_tmp6_ = self->priv->_monitor_index;
	_tmp7_ = (MetaBackgroundActor*) meta_background_actor_new (_tmp5_, _tmp6_);
	g_object_ref_sink (_tmp7_);
	background_actor = _tmp7_;
	_tmp8_ = background_actor;
	_tmp9_ = clutter_actor_get_content ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	content = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, meta_background_content_get_type (), MetaBackgroundContent);
	_tmp11_ = content;
	_tmp12_ = _data49_->background;
	_tmp13_ = gala_background_get_background (_tmp12_);
	_tmp14_ = _tmp13_;
	g_object_set (_tmp11_, "background", _tmp14_, NULL);
	_tmp15_ = display;
	_tmp16_ = self->priv->_monitor_index;
	meta_display_get_monitor_geometry (_tmp15_, _tmp16_, &_tmp17_);
	monitor = _tmp17_;
	_tmp18_ = self->priv->background_source;
	_tmp19_ = gala_background_source_get_should_dim (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_) {
		MetaBackgroundContent* _tmp21_;
		MetaBackgroundContent* _tmp22_;
		_tmp21_ = content;
		g_object_set (_tmp21_, "vignette", TRUE, NULL);
		_tmp22_ = content;
		g_object_set (_tmp22_, "brightness", GALA_BACKGROUND_MANAGER_DIM_OPACITY, NULL);
	}
	_tmp23_ = background_actor;
	clutter_actor_insert_child_below ((ClutterActor*) self, (ClutterActor*) _tmp23_, NULL);
	_tmp24_ = background_actor;
	_tmp25_ = monitor;
	_tmp26_ = monitor;
	clutter_actor_set_size ((ClutterActor*) _tmp24_, (gfloat) _tmp25_.width, (gfloat) _tmp26_.height);
	_tmp27_ = self->priv->_control_position;
	if (_tmp27_) {
		MetaBackgroundActor* _tmp28_;
		MtkRectangle _tmp29_;
		MtkRectangle _tmp30_;
		_tmp28_ = background_actor;
		_tmp29_ = monitor;
		_tmp30_ = monitor;
		clutter_actor_set_position ((ClutterActor*) _tmp28_, (gfloat) _tmp29_.x, (gfloat) _tmp30_.y);
	}
	_data49_->changed_handler = (gulong) 0;
	_tmp31_ = _data49_->background;
	_tmp32_ = g_signal_connect_data (_tmp31_, "changed", (GCallback) ___lambda46__gala_background_changed, block49_data_ref (_data49_), (GClosureNotify) block49_data_unref, 0);
	_data49_->changed_handler = _tmp32_;
	_tmp33_ = background_actor;
	g_signal_connect_data ((ClutterActor*) _tmp33_, "destroy", (GCallback) ___lambda47__clutter_actor_destroy, block49_data_ref (_data49_), (GClosureNotify) block49_data_unref, 0);
	result = background_actor;
	block49_data_unref (_data49_);
	_data49_ = NULL;
	return result;
}

GalaWindowManager*
gala_background_manager_get_wm (GalaBackgroundManager* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_background_manager_set_wm (GalaBackgroundManager* self,
                                GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_WM_PROPERTY]);
	}
}

gint
gala_background_manager_get_monitor_index (GalaBackgroundManager* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_monitor_index;
	return result;
}

static void
gala_background_manager_set_monitor_index (GalaBackgroundManager* self,
                                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_monitor_index (self);
	if (old_value != value) {
		self->priv->_monitor_index = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY]);
	}
}

gboolean
gala_background_manager_get_control_position (GalaBackgroundManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_control_position;
	return result;
}

static void
gala_background_manager_set_control_position (GalaBackgroundManager* self,
                                              gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_background_manager_get_control_position (self);
	if (old_value != value) {
		self->priv->_control_position = value;
		g_object_notify_by_pspec ((GObject *) self, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY]);
	}
}

static MetaBackgroundActor*
gala_background_manager_real_get_newest_background_actor (GalaBackgroundManagerInterface* base)
{
	MetaBackgroundActor* result;
	GalaBackgroundManager* self;
	MetaBackgroundActor* _tmp0_ = NULL;
	MetaBackgroundActor* _tmp1_;
	self = (GalaBackgroundManager*) base;
	_tmp1_ = self->priv->new_background_actor;
	if (_tmp1_ != NULL) {
		MetaBackgroundActor* _tmp2_;
		_tmp2_ = self->priv->new_background_actor;
		_tmp0_ = _tmp2_;
	} else {
		MetaBackgroundActor* _tmp3_;
		_tmp3_ = self->priv->background_actor;
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

static void
_gala_background_manager_on_destroy_clutter_actor_destroy (ClutterActor* _sender,
                                                           gpointer self)
{
	gala_background_manager_on_destroy ((GalaBackgroundManager*) self);
}

static GObject *
gala_background_manager_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaBackgroundManager * self;
	GalaBackgroundCache* _tmp0_;
	GalaWindowManager* _tmp1_;
	MetaDisplay* _tmp2_;
	GalaBackgroundSource* _tmp3_;
	parent_class = G_OBJECT_CLASS (gala_background_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	_tmp0_ = gala_background_cache_get_default ();
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_display ((MetaPlugin*) _tmp1_);
	_tmp3_ = gala_background_cache_get_background_source (_tmp0_, _tmp2_);
	_g_object_unref0 (self->priv->background_source);
	self->priv->background_source = _tmp3_;
	gala_background_manager_update_background_actor (self, FALSE);
	g_signal_connect_object ((ClutterActor*) self, "destroy", (GCallback) _gala_background_manager_on_destroy_clutter_actor_destroy, self, 0);
	return obj;
}

static void
gala_background_manager_class_init (GalaBackgroundManagerClass * klass,
                                    gpointer klass_data)
{
	gala_background_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaBackgroundManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_background_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_background_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_background_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_background_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_WM_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY] = g_param_spec_int ("monitor-index", "monitor-index", "monitor-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY] = g_param_spec_boolean ("control-position", "control-position", "control-position", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_BACKGROUND_MANAGER_NEWEST_BACKGROUND_ACTOR_PROPERTY, gala_background_manager_properties[GALA_BACKGROUND_MANAGER_NEWEST_BACKGROUND_ACTOR_PROPERTY] = g_param_spec_object ("newest-background-actor", "newest-background-actor", "newest-background-actor", meta_background_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gala_background_manager_signals[GALA_BACKGROUND_MANAGER_CHANGED_SIGNAL] = g_signal_new ("changed", GALA_TYPE_BACKGROUND_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_background_manager_gala_background_manager_interface_interface_init (GalaBackgroundManagerInterfaceIface * iface,
                                                                          gpointer iface_data)
{
	gala_background_manager_gala_background_manager_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_newest_background_actor = gala_background_manager_real_get_newest_background_actor;
}

static void
gala_background_manager_instance_init (GalaBackgroundManager * self,
                                       gpointer klass)
{
	self->priv = gala_background_manager_get_instance_private (self);
	self->priv->new_background_actor = NULL;
}

static void
gala_background_manager_finalize (GObject * obj)
{
	GalaBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->background_source);
	_g_object_unref0 (self->priv->background_actor);
	_g_object_unref0 (self->priv->new_background_actor);
	G_OBJECT_CLASS (gala_background_manager_parent_class)->finalize (obj);
}

static GType
gala_background_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaBackgroundManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_background_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaBackgroundManager), 0, (GInstanceInitFunc) gala_background_manager_instance_init, NULL };
	static const GInterfaceInfo gala_background_manager_interface_info = { (GInterfaceInitFunc) gala_background_manager_gala_background_manager_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_background_manager_type_id;
	gala_background_manager_type_id = g_type_register_static (meta_background_group_get_type (), "GalaBackgroundManager", &g_define_type_info, 0);
	g_type_add_interface_static (gala_background_manager_type_id, GALA_TYPE_BACKGROUND_MANAGER_INTERFACE, &gala_background_manager_interface_info);
	GalaBackgroundManager_private_offset = g_type_add_instance_private (gala_background_manager_type_id, sizeof (GalaBackgroundManagerPrivate));
	return gala_background_manager_type_id;
}

GType
gala_background_manager_get_type (void)
{
	static volatile gsize gala_background_manager_type_id__once = 0;
	if (g_once_init_enter (&gala_background_manager_type_id__once)) {
		GType gala_background_manager_type_id;
		gala_background_manager_type_id = gala_background_manager_get_type_once ();
		g_once_init_leave (&gala_background_manager_type_id__once, gala_background_manager_type_id);
	}
	return gala_background_manager_type_id__once;
}

static void
_vala_gala_background_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GalaBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	switch (property_id) {
		case GALA_BACKGROUND_MANAGER_WM_PROPERTY:
		g_value_set_object (value, gala_background_manager_get_wm (self));
		break;
		case GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY:
		g_value_set_int (value, gala_background_manager_get_monitor_index (self));
		break;
		case GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY:
		g_value_set_boolean (value, gala_background_manager_get_control_position (self));
		break;
		case GALA_BACKGROUND_MANAGER_NEWEST_BACKGROUND_ACTOR_PROPERTY:
		g_value_set_object (value, gala_background_manager_interface_get_newest_background_actor ((GalaBackgroundManagerInterface*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_background_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GalaBackgroundManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_BACKGROUND_MANAGER, GalaBackgroundManager);
	switch (property_id) {
		case GALA_BACKGROUND_MANAGER_WM_PROPERTY:
		gala_background_manager_set_wm (self, g_value_get_object (value));
		break;
		case GALA_BACKGROUND_MANAGER_MONITOR_INDEX_PROPERTY:
		gala_background_manager_set_monitor_index (self, g_value_get_int (value));
		break;
		case GALA_BACKGROUND_MANAGER_CONTROL_POSITION_PROPERTY:
		gala_background_manager_set_control_position (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

