/* PopupWindow.c generated by valac 0.56.16, the Vala compiler
 * generated from PopupWindow.vala, do not modify */

/*
 * Copyright 2017 Adam Bieńkowski
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala-pip.h"
#include <glib.h>
#include "gala.h"
#include <meta/meta-window-actor.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <meta/window.h>
#include <glib-object.h>
#include <graphene-gobject.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <meta/common.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>
#include <mtk/mtk.h>
#include <stdlib.h>
#include <string.h>

#define GALA_PLUGINS_PIP_POPUP_WINDOW_FADE_OUT_TIMEOUT ((guint) 200)
#define GALA_PLUGINS_PIP_POPUP_WINDOW_MINIMUM_SCALE 0.1f
#define GALA_PLUGINS_PIP_POPUP_WINDOW_MAXIMUM_SCALE 1.0f
#define GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN 0
#define GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_PERCENT 0.5f
#define GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS 80
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_PLUGINS_PIP_POPUP_WINDOW_0_PROPERTY,
	GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY,
	GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY,
	GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GALA_PLUGINS_PIP_POPUP_WINDOW_CLOSED_SIGNAL,
	GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_SIGNALS
};
static guint gala_plugins_pip_popup_window_signals[GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_SIGNALS] = {0};

struct _GalaPluginsPIPPopupWindowPrivate {
	gint button_size;
	gint container_margin;
	GalaWindowManager* _wm;
	MetaWindowActor* _window_actor;
	gboolean dynamic_container;
	ClutterActor* clone;
	ClutterActor* container;
	GalaCloseButton* close_button;
	ClutterActor* resize_button;
	GalaDragDropAction* move_action;
	gfloat begin_resize_width;
	gfloat begin_resize_height;
	gfloat resize_start_x;
	gfloat resize_start_y;
	gboolean resizing;
	gboolean off_screen;
	ClutterGrab* grab;
};

struct _Block4Data {
	int _ref_count_;
	GalaPluginsPIPPopupWindow* self;
	gulong completed_id;
};

static gint GalaPluginsPIPPopupWindow_private_offset;
static gpointer gala_plugins_pip_popup_window_parent_class = NULL;
static MetaWindow* gala_plugins_pip_popup_window_previous_focus;
static MetaWindow* gala_plugins_pip_popup_window_previous_focus = NULL;

static void gala_plugins_pip_popup_window_calculate_aspect_ratio_size_fit (gfloat src_width,
                                                                    gfloat src_height,
                                                                    gfloat max_width,
                                                                    gfloat max_height,
                                                                    gfloat* width,
                                                                    gfloat* height);
static gboolean gala_plugins_pip_popup_window_get_window_is_normal (MetaWindow* window);
static void gala_plugins_pip_popup_window_real_show (ClutterActor* base);
static void gala_plugins_pip_popup_window_real_hide (ClutterActor* base);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda4_ (Block4Data* _data4_);
static void ____lambda4__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                       gpointer self);
static gboolean gala_plugins_pip_popup_window_real_enter_event (ClutterActor* base,
                                                         ClutterEvent* event);
static gboolean gala_plugins_pip_popup_window_real_leave_event (ClutterActor* base,
                                                         ClutterEvent* event);
static void gala_plugins_pip_popup_window_update_container_scale (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_on_allocation_changed (GalaPluginsPIPPopupWindow* self);
static ClutterActor* gala_plugins_pip_popup_window_on_move_begin (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_on_move_end (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_update_screen_position (GalaPluginsPIPPopupWindow* self);
static gboolean gala_plugins_pip_popup_window_on_resize_button_press (GalaPluginsPIPPopupWindow* self,
                                                               ClutterEvent* event);
static gboolean gala_plugins_pip_popup_window_on_resize_event (GalaPluginsPIPPopupWindow* self,
                                                        ClutterEvent* event);
static gboolean _gala_plugins_pip_popup_window_on_resize_event_clutter_actor_event (ClutterActor* _sender,
                                                                             ClutterEvent* event,
                                                                             gpointer self);
static void gala_plugins_pip_popup_window_stop_resizing (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_update_size (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_update_clone_clip (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_on_close_click_clicked (GalaPluginsPIPPopupWindow* self);
static gboolean __lambda5_ (GalaPluginsPIPPopupWindow* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void gala_plugins_pip_popup_window_update_window_focus (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_get_target_window_size (GalaPluginsPIPPopupWindow* self,
                                                           gfloat* width,
                                                           gfloat* height);
static void gala_plugins_pip_popup_window_update_container_position (GalaPluginsPIPPopupWindow* self);
static gboolean gala_plugins_pip_popup_window_place_window_off_screen (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_place_window_in_screen (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_get_current_monitor_rect (GalaPluginsPIPPopupWindow* self,
                                                             MtkRectangle* rect);
static gboolean gala_plugins_pip_popup_window_coord_is_in_other_monitor (GalaPluginsPIPPopupWindow* self,
                                                                  gfloat coord,
                                                                  ClutterOrientation axis);
static void gala_plugins_pip_popup_window_activate (GalaPluginsPIPPopupWindow* self);
static GObject * gala_plugins_pip_popup_window_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _gala_plugins_pip_popup_window_on_close_click_clicked_meta_window_unmanaged (MetaWindow* _sender,
                                                                                  gpointer self);
static void _gala_plugins_pip_popup_window_update_window_focus_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self);
static void _gala_plugins_pip_popup_window_update_window_focus_meta_workspace_manager_active_workspace_changed (MetaWorkspaceManager* _sender,
                                                                                                         gpointer self);
static ClutterActor* _gala_plugins_pip_popup_window_on_move_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                                             gfloat x,
                                                                                             gfloat y,
                                                                                             gpointer self);
static void _gala_plugins_pip_popup_window_on_move_end_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                                     gpointer self);
static void _gala_plugins_pip_popup_window_activate_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                                  guint32 button,
                                                                                  gpointer self);
static void _gala_plugins_pip_popup_window_on_close_click_clicked_gala_close_button_triggered (GalaCloseButton* _sender,
                                                                                        guint32 timestamp,
                                                                                        gpointer self);
static gboolean _gala_plugins_pip_popup_window_on_resize_button_press_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                                                 ClutterEvent* event,
                                                                                                 gpointer self);
static void _gala_plugins_pip_popup_window_on_allocation_changed_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self);
static void gala_plugins_pip_popup_window_finalize (GObject * obj);
static GType gala_plugins_pip_popup_window_get_type_once (void);
static void _vala_gala_plugins_pip_popup_window_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_gala_plugins_pip_popup_window_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
gala_plugins_pip_popup_window_get_instance_private (GalaPluginsPIPPopupWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPluginsPIPPopupWindow_private_offset);
}

static void
gala_plugins_pip_popup_window_calculate_aspect_ratio_size_fit (gfloat src_width,
                                                               gfloat src_height,
                                                               gfloat max_width,
                                                               gfloat max_height,
                                                               gfloat* width,
                                                               gfloat* height)
{
	gfloat _vala_width = 0.0F;
	gfloat _vala_height = 0.0F;
	gfloat ratio = 0.0F;
	ratio = MIN (max_width / src_width, max_height / src_height);
	_vala_width = src_width * ratio;
	_vala_height = src_height * ratio;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static gboolean
gala_plugins_pip_popup_window_get_window_is_normal (MetaWindow* window)
{
	MetaWindowType window_type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (window != NULL, FALSE);
	window_type = meta_window_get_window_type (window);
	if (window_type == META_WINDOW_NORMAL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = window_type == META_WINDOW_DIALOG;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = window_type == META_WINDOW_MODAL_DIALOG;
	}
	result = _tmp0_;
	return result;
}

GalaPluginsPIPPopupWindow*
gala_plugins_pip_popup_window_construct (GType object_type,
                                         GalaWindowManager* wm,
                                         MetaWindowActor* window_actor)
{
	GalaPluginsPIPPopupWindow * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (window_actor != NULL, NULL);
	self = (GalaPluginsPIPPopupWindow*) g_object_new (object_type, "wm", wm, "window-actor", window_actor, NULL);
	return self;
}

GalaPluginsPIPPopupWindow*
gala_plugins_pip_popup_window_new (GalaWindowManager* wm,
                                   MetaWindowActor* window_actor)
{
	return gala_plugins_pip_popup_window_construct (GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, wm, window_actor);
}

static void
gala_plugins_pip_popup_window_real_show (ClutterActor* base)
{
	GalaPluginsPIPPopupWindow * self;
	gint _tmp0_ = 0;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (GalaPluginsPIPPopupWindow*) base;
	CLUTTER_ACTOR_CLASS (gala_plugins_pip_popup_window_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 200;
	} else {
		_tmp0_ = 0;
	}
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) _tmp0_);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GalaPluginsPIPPopupWindow* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda4_ (Block4Data* _data4_)
{
	GalaPluginsPIPPopupWindow* self;
	self = _data4_->self;
	g_signal_handler_disconnect ((GObject*) self, _data4_->completed_id);
	CLUTTER_ACTOR_CLASS (gala_plugins_pip_popup_window_parent_class)->hide (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
}

static void
____lambda4__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                  gpointer self)
{
	___lambda4_ (self);
}

static void
gala_plugins_pip_popup_window_real_hide (ClutterActor* base)
{
	GalaPluginsPIPPopupWindow * self;
	gint _tmp0_ = 0;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint duration = 0;
	self = (GalaPluginsPIPPopupWindow*) base;
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 200;
	} else {
		_tmp0_ = 0;
	}
	duration = _tmp0_;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) duration);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	if (duration == 0) {
		CLUTTER_ACTOR_CLASS (gala_plugins_pip_popup_window_parent_class)->hide (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
	} else {
		Block4Data* _data4_;
		gulong _tmp4_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_data4_->completed_id = (gulong) 0;
		_tmp4_ = g_signal_connect_data ((ClutterActor*) self, "transitions-completed", (GCallback) ____lambda4__clutter_actor_transitions_completed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_data4_->completed_id = _tmp4_;
		block4_data_unref (_data4_);
		_data4_ = NULL;
	}
}

static gboolean
gala_plugins_pip_popup_window_real_enter_event (ClutterActor* base,
                                                ClutterEvent* event)
{
	GalaPluginsPIPPopupWindow * self;
	gint _tmp0_ = 0;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint duration = 0;
	GalaCloseButton* _tmp4_;
	GalaCloseButton* _tmp5_;
	GalaCloseButton* _tmp6_;
	GalaCloseButton* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	gboolean result;
	self = (GalaPluginsPIPPopupWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 300;
	} else {
		_tmp0_ = 0;
	}
	duration = _tmp0_;
	_tmp4_ = self->priv->close_button;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp4_);
	_tmp5_ = self->priv->close_button;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp5_, (guint) duration);
	_tmp6_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp6_, (guint) 255);
	_tmp7_ = self->priv->close_button;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp7_);
	_tmp8_ = self->priv->resize_button;
	clutter_actor_save_easing_state (_tmp8_);
	_tmp9_ = self->priv->resize_button;
	clutter_actor_set_easing_duration (_tmp9_, (guint) duration);
	_tmp10_ = self->priv->resize_button;
	clutter_actor_set_opacity (_tmp10_, (guint) 255);
	_tmp11_ = self->priv->resize_button;
	clutter_actor_restore_easing_state (_tmp11_);
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_real_leave_event (ClutterActor* base,
                                                ClutterEvent* event)
{
	GalaPluginsPIPPopupWindow * self;
	gint _tmp0_ = 0;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint duration = 0;
	GalaCloseButton* _tmp4_;
	GalaCloseButton* _tmp5_;
	GalaCloseButton* _tmp6_;
	GalaCloseButton* _tmp7_;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	ClutterActor* _tmp11_;
	gboolean result;
	self = (GalaPluginsPIPPopupWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 300;
	} else {
		_tmp0_ = 0;
	}
	duration = _tmp0_;
	_tmp4_ = self->priv->close_button;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp4_);
	_tmp5_ = self->priv->close_button;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp5_, (guint) duration);
	_tmp6_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp6_, (guint) 0);
	_tmp7_ = self->priv->close_button;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp7_);
	_tmp8_ = self->priv->resize_button;
	clutter_actor_save_easing_state (_tmp8_);
	_tmp9_ = self->priv->resize_button;
	clutter_actor_set_easing_duration (_tmp9_, (guint) duration);
	_tmp10_ = self->priv->resize_button;
	clutter_actor_set_opacity (_tmp10_, (guint) 0);
	_tmp11_ = self->priv->resize_button;
	clutter_actor_restore_easing_state (_tmp11_);
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

void
gala_plugins_pip_popup_window_set_container_clip (GalaPluginsPIPPopupWindow* self,
                                                  graphene_rect_t* container_clip)
{
	ClutterActor* _tmp0_;
	graphene_rect_t _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->container;
	_tmp1_ = *container_clip;
	g_object_set (_tmp0_, "clip-rect", &_tmp1_, NULL);
	self->priv->dynamic_container = TRUE;
	gala_plugins_pip_popup_window_update_container_scale (self);
	gala_plugins_pip_popup_window_on_allocation_changed (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static ClutterActor*
gala_plugins_pip_popup_window_on_move_begin (GalaPluginsPIPPopupWindow* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	ClutterActor* _tmp2_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_set_cursor (_tmp1_, META_CURSOR_DND_IN_DRAG);
	_tmp2_ = _g_object_ref0 ((ClutterActor*) self);
	result = _tmp2_;
	return result;
}

static void
gala_plugins_pip_popup_window_on_move_end (GalaPluginsPIPPopupWindow* self)
{
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	g_return_if_fail (self != NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	gala_plugins_pip_popup_window_update_screen_position (self);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	meta_display_set_cursor (_tmp1_, META_CURSOR_DEFAULT);
}

static gboolean
_gala_plugins_pip_popup_window_on_resize_event_clutter_actor_event (ClutterActor* _sender,
                                                                    ClutterEvent* event,
                                                                    gpointer self)
{
	gboolean result;
	result = gala_plugins_pip_popup_window_on_resize_event ((GalaPluginsPIPPopupWindow*) self, event);
	return result;
}

static gboolean
gala_plugins_pip_popup_window_on_resize_button_press (GalaPluginsPIPPopupWindow* self,
                                                      ClutterEvent* event)
{
	gboolean _tmp0_ = FALSE;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	ClutterActor* _tmp7_;
	ClutterStage* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterGrab* _tmp10_;
	ClutterActor* _tmp11_;
	GalaWindowManager* _tmp12_;
	MetaDisplay* _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->resizing) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = clutter_event_get_button (event) != CLUTTER_BUTTON_PRIMARY;
	}
	if (_tmp0_) {
		result = CLUTTER_EVENT_STOP;
		return result;
	}
	self->priv->resizing = TRUE;
	clutter_event_get_coords (event, &_tmp1_, &_tmp2_);
	self->priv->resize_start_x = _tmp1_;
	self->priv->resize_start_y = _tmp2_;
	_tmp3_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp4_ = _tmp3_;
	self->priv->begin_resize_width = _tmp4_;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	self->priv->begin_resize_height = _tmp6_;
	_tmp7_ = self->priv->resize_button;
	_tmp8_ = clutter_actor_get_stage (_tmp7_);
	_tmp9_ = self->priv->resize_button;
	_tmp10_ = clutter_stage_grab (_tmp8_, _tmp9_);
	_g_object_unref0 (self->priv->grab);
	self->priv->grab = _tmp10_;
	_tmp11_ = self->priv->resize_button;
	g_signal_connect_object (_tmp11_, "event", (GCallback) _gala_plugins_pip_popup_window_on_resize_event_clutter_actor_event, self, 0);
	_tmp12_ = self->priv->_wm;
	_tmp13_ = meta_plugin_get_display ((MetaPlugin*) _tmp12_);
	meta_display_set_cursor (_tmp13_, META_CURSOR_SE_RESIZE);
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_on_resize_event (GalaPluginsPIPPopupWindow* self,
                                               ClutterEvent* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->resizing) {
		result = CLUTTER_EVENT_STOP;
		return result;
	}
	switch (clutter_event_type (event)) {
		case CLUTTER_MOTION:
		{
			ClutterModifierType mods = 0U;
			gfloat event_x = 0.0F;
			gfloat event_y = 0.0F;
			gfloat _tmp0_ = 0.0F;
			gfloat _tmp1_ = 0.0F;
			gfloat diff_x = 0.0F;
			gfloat diff_y = 0.0F;
			mods = clutter_event_get_state (event);
			if (!((mods & CLUTTER_BUTTON1_MASK) == CLUTTER_BUTTON1_MASK)) {
				gala_plugins_pip_popup_window_stop_resizing (self);
				break;
			}
			clutter_event_get_coords (event, &_tmp0_, &_tmp1_);
			event_x = _tmp0_;
			event_y = _tmp1_;
			diff_x = event_x - self->priv->resize_start_x;
			diff_y = event_y - self->priv->resize_start_y;
			clutter_actor_set_width ((ClutterActor*) self, self->priv->begin_resize_width + diff_x);
			clutter_actor_set_height ((ClutterActor*) self, self->priv->begin_resize_height + diff_y);
			gala_plugins_pip_popup_window_update_container_scale (self);
			gala_plugins_pip_popup_window_update_size (self);
			break;
		}
		case CLUTTER_BUTTON_RELEASE:
		{
			if (clutter_event_get_button (event) == CLUTTER_BUTTON_PRIMARY) {
				gala_plugins_pip_popup_window_stop_resizing (self);
			}
			break;
		}
		case CLUTTER_LEAVE:
		case CLUTTER_ENTER:
		{
			result = CLUTTER_EVENT_PROPAGATE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

static void
gala_plugins_pip_popup_window_stop_resizing (GalaPluginsPIPPopupWindow* self)
{
	ClutterGrab* _tmp0_;
	GalaWindowManager* _tmp4_;
	MetaDisplay* _tmp5_;
	g_return_if_fail (self != NULL);
	if (!self->priv->resizing) {
		return;
	}
	_tmp0_ = self->priv->grab;
	if (_tmp0_ != NULL) {
		ClutterGrab* _tmp1_;
		ClutterActor* _tmp2_;
		guint _tmp3_;
		_tmp1_ = self->priv->grab;
		clutter_grab_dismiss (_tmp1_);
		_tmp2_ = self->priv->resize_button;
		g_signal_parse_name ("event", clutter_actor_get_type (), &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gala_plugins_pip_popup_window_on_resize_event_clutter_actor_event, self);
		_g_object_unref0 (self->priv->grab);
		self->priv->grab = NULL;
	}
	self->priv->resizing = FALSE;
	gala_plugins_pip_popup_window_update_screen_position (self);
	_tmp4_ = self->priv->_wm;
	_tmp5_ = meta_plugin_get_display ((MetaPlugin*) _tmp4_);
	meta_display_set_cursor (_tmp5_, META_CURSOR_DEFAULT);
}

static void
gala_plugins_pip_popup_window_on_allocation_changed (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	gala_plugins_pip_popup_window_update_clone_clip (self);
	gala_plugins_pip_popup_window_update_size (self);
}

static gboolean
__lambda5_ (GalaPluginsPIPPopupWindow* self)
{
	gboolean result;
	g_signal_emit (self, gala_plugins_pip_popup_window_signals[GALA_PLUGINS_PIP_POPUP_WINDOW_CLOSED_SIGNAL], 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((GalaPluginsPIPPopupWindow*) self);
	return result;
}

static void
gala_plugins_pip_popup_window_on_close_click_clicked (GalaPluginsPIPPopupWindow* self)
{
	guint _tmp0_ = 0U;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	guint duration = 0U;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = GALA_PLUGINS_PIP_POPUP_WINDOW_FADE_OUT_TIMEOUT;
	} else {
		_tmp0_ = (guint) 0;
	}
	duration = _tmp0_;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, duration);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	clutter_threads_add_timeout (duration, ___lambda5__gsource_func, self);
}

static void
gala_plugins_pip_popup_window_update_window_focus (GalaPluginsPIPPopupWindow* self)
{
	MetaWindow* focus_window = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWindow* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	MetaWindow* _tmp5_;
	MetaWorkspaceManager* workspace_manager = NULL;
	GalaWindowManager* _tmp11_;
	MetaDisplay* _tmp12_;
	MetaWorkspaceManager* _tmp13_;
	MetaWorkspace* active_workspace = NULL;
	MetaWorkspaceManager* _tmp14_;
	MetaWorkspace* _tmp15_;
	MetaWindow* window = NULL;
	MetaWindowActor* _tmp16_;
	MetaWindow* _tmp17_;
	gboolean _tmp18_ = FALSE;
	MetaWindow* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	MetaWindow* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = meta_display_get_focus_window (_tmp1_);
	focus_window = _tmp2_;
	_tmp5_ = focus_window;
	if (_tmp5_ != NULL) {
		MetaWindow* _tmp6_;
		_tmp6_ = focus_window;
		_tmp4_ = !gala_plugins_pip_popup_window_get_window_is_normal (_tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		MetaWindow* _tmp8_;
		_tmp8_ = gala_plugins_pip_popup_window_previous_focus;
		if (_tmp8_ != NULL) {
			MetaWindow* _tmp9_;
			_tmp9_ = gala_plugins_pip_popup_window_previous_focus;
			_tmp7_ = !gala_plugins_pip_popup_window_get_window_is_normal (_tmp9_);
		} else {
			_tmp7_ = FALSE;
		}
		_tmp3_ = _tmp7_;
	}
	if (_tmp3_) {
		MetaWindow* _tmp10_;
		_tmp10_ = focus_window;
		gala_plugins_pip_popup_window_previous_focus = _tmp10_;
		return;
	}
	_tmp11_ = self->priv->_wm;
	_tmp12_ = meta_plugin_get_display ((MetaPlugin*) _tmp11_);
	_tmp13_ = meta_display_get_workspace_manager (_tmp12_);
	workspace_manager = _tmp13_;
	_tmp14_ = workspace_manager;
	_tmp15_ = meta_workspace_manager_get_active_workspace (_tmp14_);
	active_workspace = _tmp15_;
	_tmp16_ = self->priv->_window_actor;
	_tmp17_ = meta_window_actor_get_meta_window (_tmp16_);
	window = _tmp17_;
	_tmp19_ = window;
	g_object_get (_tmp19_, "appears-focused", &_tmp20_, NULL);
	_tmp21_ = _tmp20_;
	if (_tmp21_) {
		MetaWindow* _tmp22_;
		MetaWorkspace* _tmp23_;
		_tmp22_ = window;
		_tmp23_ = active_workspace;
		_tmp18_ = meta_window_located_on_workspace (_tmp22_, _tmp23_);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		clutter_actor_hide ((ClutterActor*) self);
	} else {
		MetaWindowActor* _tmp24_;
		_tmp24_ = self->priv->_window_actor;
		if (!meta_window_actor_is_destroyed (_tmp24_)) {
			clutter_actor_show ((ClutterActor*) self);
		}
	}
	_tmp25_ = focus_window;
	gala_plugins_pip_popup_window_previous_focus = _tmp25_;
}

static void
gala_plugins_pip_popup_window_update_size (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->dynamic_container) {
		gfloat src_width = 0.0F;
		gfloat src_height = 0.0F;
		ClutterActor* _tmp0_;
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
		ClutterActor* _tmp3_;
		gdouble _tmp4_;
		gdouble _tmp5_;
		ClutterActor* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		src_width = 0.0f;
		src_height = 0.0f;
		_tmp0_ = self->priv->container;
		clutter_actor_get_clip (_tmp0_, NULL, NULL, &_tmp1_, &_tmp2_);
		src_width = _tmp1_;
		src_height = _tmp2_;
		_tmp3_ = self->priv->container;
		g_object_get (_tmp3_, "scale-x", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		clutter_actor_set_width ((ClutterActor*) self, (gfloat) ((gint) ((src_width * _tmp5_) + self->priv->button_size)));
		_tmp6_ = self->priv->container;
		g_object_get (_tmp6_, "scale-y", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		clutter_actor_set_height ((ClutterActor*) self, (gfloat) ((gint) ((src_height * _tmp8_) + self->priv->button_size)));
	} else {
		ClutterActor* _tmp9_;
		gfloat _tmp10_;
		gfloat _tmp11_;
		ClutterActor* _tmp12_;
		gdouble _tmp13_;
		gdouble _tmp14_;
		ClutterActor* _tmp15_;
		gfloat _tmp16_;
		gfloat _tmp17_;
		ClutterActor* _tmp18_;
		gdouble _tmp19_;
		gdouble _tmp20_;
		_tmp9_ = self->priv->container;
		_tmp10_ = clutter_actor_get_width (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->priv->container;
		g_object_get (_tmp12_, "scale-x", &_tmp13_, NULL);
		_tmp14_ = _tmp13_;
		clutter_actor_set_width ((ClutterActor*) self, (gfloat) ((gint) ((_tmp11_ * _tmp14_) + self->priv->button_size)));
		_tmp15_ = self->priv->container;
		_tmp16_ = clutter_actor_get_height (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = self->priv->container;
		g_object_get (_tmp18_, "scale-y", &_tmp19_, NULL);
		_tmp20_ = _tmp19_;
		clutter_actor_set_height ((ClutterActor*) self, (gfloat) ((gint) ((_tmp17_ * _tmp20_) + self->priv->button_size)));
	}
}

static void
gala_plugins_pip_popup_window_update_clone_clip (GalaPluginsPIPPopupWindow* self)
{
	MtkRectangle rect = {0};
	MetaWindowActor* _tmp0_;
	MetaWindow* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	gfloat x_offset = 0.0F;
	MtkRectangle _tmp3_;
	MetaWindowActor* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gfloat y_offset = 0.0F;
	MtkRectangle _tmp7_;
	MetaWindowActor* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterActor* _tmp11_;
	MtkRectangle _tmp12_;
	MtkRectangle _tmp13_;
	ClutterActor* _tmp14_;
	ClutterActor* _tmp15_;
	MtkRectangle _tmp16_;
	MtkRectangle _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window_actor;
	_tmp1_ = meta_window_actor_get_meta_window (_tmp0_);
	meta_window_get_frame_rect (_tmp1_, &_tmp2_);
	rect = _tmp2_;
	_tmp3_ = rect;
	_tmp4_ = self->priv->_window_actor;
	_tmp5_ = clutter_actor_get_x ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	x_offset = _tmp3_.x - _tmp6_;
	_tmp7_ = rect;
	_tmp8_ = self->priv->_window_actor;
	_tmp9_ = clutter_actor_get_y ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	y_offset = _tmp7_.y - _tmp10_;
	_tmp11_ = self->priv->clone;
	_tmp12_ = rect;
	_tmp13_ = rect;
	clutter_actor_set_clip (_tmp11_, x_offset, y_offset, (gfloat) _tmp12_.width, (gfloat) _tmp13_.height);
	_tmp14_ = self->priv->clone;
	clutter_actor_set_position (_tmp14_, -x_offset, -y_offset);
	_tmp15_ = self->priv->container;
	_tmp16_ = rect;
	_tmp17_ = rect;
	clutter_actor_set_size (_tmp15_, (gfloat) _tmp16_.width, (gfloat) _tmp17_.height);
}

static void
gala_plugins_pip_popup_window_update_container_scale (GalaPluginsPIPPopupWindow* self)
{
	gfloat src_width = 0.0F;
	gfloat src_height = 0.0F;
	gfloat max_width = 0.0F;
	gfloat _tmp9_;
	gfloat _tmp10_;
	gfloat max_height = 0.0F;
	gfloat _tmp11_;
	gfloat _tmp12_;
	gfloat new_width = 0.0F;
	gfloat new_height = 0.0F;
	gfloat _tmp13_ = 0.0F;
	gfloat _tmp14_ = 0.0F;
	gfloat window_width = 0.0F;
	gfloat window_height = 0.0F;
	gfloat _tmp15_ = 0.0F;
	gfloat _tmp16_ = 0.0F;
	gfloat new_scale_x = 0.0F;
	gfloat new_scale_y = 0.0F;
	ClutterActor* _tmp17_;
	ClutterActor* _tmp18_;
	g_return_if_fail (self != NULL);
	src_width = 1.0f;
	src_height = 1.0f;
	if (self->priv->dynamic_container) {
		ClutterActor* _tmp0_;
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
		_tmp0_ = self->priv->container;
		clutter_actor_get_clip (_tmp0_, NULL, NULL, &_tmp1_, &_tmp2_);
		src_width = _tmp1_;
		src_height = _tmp2_;
	} else {
		ClutterActor* _tmp3_;
		gfloat _tmp4_;
		gfloat _tmp5_;
		ClutterActor* _tmp6_;
		gfloat _tmp7_;
		gfloat _tmp8_;
		_tmp3_ = self->priv->container;
		_tmp4_ = clutter_actor_get_width (_tmp3_);
		_tmp5_ = _tmp4_;
		src_width = _tmp5_;
		_tmp6_ = self->priv->container;
		_tmp7_ = clutter_actor_get_height (_tmp6_);
		_tmp8_ = _tmp7_;
		src_height = _tmp8_;
	}
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	max_width = _tmp10_ - self->priv->button_size;
	_tmp11_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp12_ = _tmp11_;
	max_height = _tmp12_ - self->priv->button_size;
	gala_plugins_pip_popup_window_calculate_aspect_ratio_size_fit (src_width, src_height, max_width, max_height, &_tmp13_, &_tmp14_);
	new_width = _tmp13_;
	new_height = _tmp14_;
	window_width = 1.0f;
	window_height = 1.0f;
	gala_plugins_pip_popup_window_get_target_window_size (self, &_tmp15_, &_tmp16_);
	window_width = _tmp15_;
	window_height = _tmp16_;
	new_scale_x = new_width / window_width;
	new_scale_y = new_height / window_height;
	_tmp17_ = self->priv->container;
	g_object_set (_tmp17_, "scale-x", (gdouble) CLAMP (new_scale_x, GALA_PLUGINS_PIP_POPUP_WINDOW_MINIMUM_SCALE, GALA_PLUGINS_PIP_POPUP_WINDOW_MAXIMUM_SCALE), NULL);
	_tmp18_ = self->priv->container;
	g_object_set (_tmp18_, "scale-y", (gdouble) CLAMP (new_scale_y, GALA_PLUGINS_PIP_POPUP_WINDOW_MINIMUM_SCALE, GALA_PLUGINS_PIP_POPUP_WINDOW_MAXIMUM_SCALE), NULL);
	gala_plugins_pip_popup_window_update_container_position (self);
}

static void
gala_plugins_pip_popup_window_update_container_position (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->dynamic_container) {
		gfloat clip_x = 0.0F;
		gfloat clip_y = 0.0F;
		ClutterActor* _tmp0_;
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
		ClutterActor* _tmp3_;
		ClutterActor* _tmp4_;
		gdouble _tmp5_;
		gdouble _tmp6_;
		ClutterActor* _tmp7_;
		ClutterActor* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		clip_x = 0.0f;
		clip_y = 0.0f;
		_tmp0_ = self->priv->container;
		clutter_actor_get_clip (_tmp0_, &_tmp1_, &_tmp2_, NULL, NULL);
		clip_x = _tmp1_;
		clip_y = _tmp2_;
		_tmp3_ = self->priv->container;
		_tmp4_ = self->priv->container;
		g_object_get (_tmp4_, "scale-x", &_tmp5_, NULL);
		_tmp6_ = _tmp5_;
		clutter_actor_set_x (_tmp3_, (gfloat) (((-clip_x) * _tmp6_) + self->priv->container_margin));
		_tmp7_ = self->priv->container;
		_tmp8_ = self->priv->container;
		g_object_get (_tmp8_, "scale-y", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		clutter_actor_set_y (_tmp7_, (gfloat) (((-clip_y) * _tmp10_) + self->priv->container_margin));
	}
}

static void
gala_plugins_pip_popup_window_update_screen_position (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (!gala_plugins_pip_popup_window_place_window_off_screen (self)) {
		gala_plugins_pip_popup_window_place_window_in_screen (self);
	}
}

static void
gala_plugins_pip_popup_window_place_window_in_screen (GalaPluginsPIPPopupWindow* self)
{
	MtkRectangle monitor_rect = {0};
	MtkRectangle _tmp0_ = {0};
	gint monitor_x = 0;
	MtkRectangle _tmp1_;
	gint monitor_y = 0;
	MtkRectangle _tmp2_;
	gint monitor_width = 0;
	MtkRectangle _tmp3_;
	gint monitor_height = 0;
	MtkRectangle _tmp4_;
	gint screen_limit_start_x = 0;
	gfloat screen_limit_end_x = 0.0F;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gint screen_limit_start_y = 0;
	gfloat screen_limit_end_y = 0.0F;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gint _tmp9_ = 0;
	GalaWindowManager* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gint duration = 0;
	gfloat _tmp13_;
	gfloat _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	g_return_if_fail (self != NULL);
	self->priv->off_screen = FALSE;
	gala_plugins_pip_popup_window_get_current_monitor_rect (self, &_tmp0_);
	monitor_rect = _tmp0_;
	_tmp1_ = monitor_rect;
	monitor_x = _tmp1_.x;
	_tmp2_ = monitor_rect;
	monitor_y = _tmp2_.y;
	_tmp3_ = monitor_rect;
	monitor_width = _tmp3_.width;
	_tmp4_ = monitor_rect;
	monitor_height = _tmp4_.height;
	screen_limit_start_x = GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN + monitor_x;
	_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	screen_limit_end_x = ((monitor_width + monitor_x) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp6_;
	screen_limit_start_y = GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN + monitor_y;
	_tmp7_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	screen_limit_end_y = ((monitor_height + monitor_y) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp8_;
	_tmp10_ = self->priv->_wm;
	_tmp11_ = gala_window_manager_get_enable_animations (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_) {
		_tmp9_ = 300;
	} else {
		_tmp9_ = 0;
	}
	duration = _tmp9_;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BACK);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) duration);
	_tmp13_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp14_ = _tmp13_;
	clutter_actor_set_x ((ClutterActor*) self, CLAMP (_tmp14_, (gfloat) screen_limit_start_x, screen_limit_end_x));
	_tmp15_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp16_ = _tmp15_;
	clutter_actor_set_y ((ClutterActor*) self, CLAMP (_tmp16_, (gfloat) screen_limit_start_y, screen_limit_end_y));
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}

static gboolean
gala_plugins_pip_popup_window_place_window_off_screen (GalaPluginsPIPPopupWindow* self)
{
	gint _tmp0_ = 0;
	GalaWindowManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gint duration = 0;
	MtkRectangle monitor_rect = {0};
	MtkRectangle _tmp4_ = {0};
	gint monitor_x = 0;
	MtkRectangle _tmp5_;
	gint monitor_y = 0;
	MtkRectangle _tmp6_;
	gint monitor_width = 0;
	MtkRectangle _tmp7_;
	gint monitor_height = 0;
	MtkRectangle _tmp8_;
	gfloat off_screen_x_threshold = 0.0F;
	gfloat _tmp9_;
	gfloat _tmp10_;
	gboolean off_screen_x = FALSE;
	gfloat _tmp11_;
	gfloat _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean off_screen_w = FALSE;
	gfloat _tmp18_;
	gfloat _tmp19_;
	gfloat _tmp20_;
	gfloat _tmp21_;
	gboolean _tmp22_ = FALSE;
	gfloat off_screen_y_threshold = 0.0F;
	gfloat _tmp27_;
	gfloat _tmp28_;
	gboolean off_screen_y = FALSE;
	gfloat _tmp29_;
	gfloat _tmp30_;
	gboolean _tmp31_ = FALSE;
	gboolean off_screen_h = FALSE;
	gfloat _tmp36_;
	gfloat _tmp37_;
	gfloat _tmp38_;
	gfloat _tmp39_;
	gboolean _tmp40_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->off_screen = FALSE;
	_tmp1_ = self->priv->_wm;
	_tmp2_ = gala_window_manager_get_enable_animations (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp0_ = 300;
	} else {
		_tmp0_ = 0;
	}
	duration = _tmp0_;
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BACK);
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) duration);
	gala_plugins_pip_popup_window_get_current_monitor_rect (self, &_tmp4_);
	monitor_rect = _tmp4_;
	_tmp5_ = monitor_rect;
	monitor_x = _tmp5_.x;
	_tmp6_ = monitor_rect;
	monitor_y = _tmp6_.y;
	_tmp7_ = monitor_rect;
	monitor_width = _tmp7_.width;
	_tmp8_ = monitor_rect;
	monitor_height = _tmp8_.height;
	_tmp9_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	off_screen_x_threshold = _tmp10_ * GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_PERCENT;
	_tmp11_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp12_ = _tmp11_;
	off_screen_x = (_tmp12_ - monitor_x) < (-off_screen_x_threshold);
	if (off_screen_x) {
		gfloat _tmp14_;
		gfloat _tmp15_;
		_tmp14_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp15_ = _tmp14_;
		_tmp13_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp15_, CLUTTER_ORIENTATION_HORIZONTAL);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gfloat _tmp16_;
		gfloat _tmp17_;
		self->priv->off_screen = TRUE;
		_tmp16_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp17_ = _tmp16_;
		clutter_actor_set_x ((ClutterActor*) self, (monitor_x - _tmp17_) + GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS);
	}
	_tmp18_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp21_ = _tmp20_;
	off_screen_w = (_tmp19_ + _tmp21_) > ((monitor_x + monitor_width) + off_screen_x_threshold);
	if (off_screen_w) {
		gfloat _tmp23_;
		gfloat _tmp24_;
		gfloat _tmp25_;
		gfloat _tmp26_;
		_tmp23_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp24_ = _tmp23_;
		_tmp25_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp26_ = _tmp25_;
		_tmp22_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp24_ + _tmp26_, CLUTTER_ORIENTATION_HORIZONTAL);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		self->priv->off_screen = TRUE;
		clutter_actor_set_x ((ClutterActor*) self, (gfloat) ((monitor_x + monitor_width) - GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS));
	}
	_tmp27_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp28_ = _tmp27_;
	off_screen_y_threshold = _tmp28_ * GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_PERCENT;
	_tmp29_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp30_ = _tmp29_;
	off_screen_y = (_tmp30_ - monitor_y) < (-off_screen_y_threshold);
	if (off_screen_y) {
		gfloat _tmp32_;
		gfloat _tmp33_;
		_tmp32_ = clutter_actor_get_y ((ClutterActor*) self);
		_tmp33_ = _tmp32_;
		_tmp31_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp33_, CLUTTER_ORIENTATION_VERTICAL);
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		gfloat _tmp34_;
		gfloat _tmp35_;
		self->priv->off_screen = TRUE;
		_tmp34_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp35_ = _tmp34_;
		clutter_actor_set_y ((ClutterActor*) self, (monitor_y - _tmp35_) + GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS);
	}
	_tmp36_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp37_ = _tmp36_;
	_tmp38_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp39_ = _tmp38_;
	off_screen_h = (_tmp37_ + _tmp39_) > ((monitor_y + monitor_height) + off_screen_y_threshold);
	if (off_screen_h) {
		gfloat _tmp41_;
		gfloat _tmp42_;
		gfloat _tmp43_;
		gfloat _tmp44_;
		_tmp41_ = clutter_actor_get_y ((ClutterActor*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp44_ = _tmp43_;
		_tmp40_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp42_ + _tmp44_, CLUTTER_ORIENTATION_VERTICAL);
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		self->priv->off_screen = TRUE;
		clutter_actor_set_y ((ClutterActor*) self, (gfloat) ((monitor_y + monitor_height) - GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS));
	}
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	result = self->priv->off_screen;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_coord_is_in_other_monitor (GalaPluginsPIPPopupWindow* self,
                                                         gfloat coord,
                                                         ClutterOrientation axis)
{
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	gint n_monitors = 0;
	MetaDisplay* _tmp3_;
	gint current = 0;
	MetaDisplay* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = display;
	n_monitors = meta_display_get_n_monitors (_tmp3_);
	if (n_monitors == 1) {
		result = FALSE;
		_g_object_unref0 (display);
		return result;
	}
	_tmp4_ = display;
	current = meta_display_get_current_monitor (_tmp4_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(i < n_monitors)) {
					break;
				}
				if (i != current) {
					MtkRectangle monitor_rect = {0};
					MetaDisplay* _tmp7_;
					MtkRectangle _tmp8_ = {0};
					gboolean in_monitor = FALSE;
					_tmp7_ = display;
					meta_display_get_monitor_geometry (_tmp7_, i, &_tmp8_);
					monitor_rect = _tmp8_;
					in_monitor = FALSE;
					if (axis == CLUTTER_ORIENTATION_HORIZONTAL) {
						gboolean _tmp9_ = FALSE;
						MtkRectangle _tmp10_;
						_tmp10_ = monitor_rect;
						if (coord >= ((gfloat) _tmp10_.x)) {
							MtkRectangle _tmp11_;
							MtkRectangle _tmp12_;
							_tmp11_ = monitor_rect;
							_tmp12_ = monitor_rect;
							_tmp9_ = coord <= ((gfloat) (_tmp11_.x + _tmp12_.width));
						} else {
							_tmp9_ = FALSE;
						}
						in_monitor = _tmp9_;
					} else {
						gboolean _tmp13_ = FALSE;
						MtkRectangle _tmp14_;
						_tmp14_ = monitor_rect;
						if (coord >= ((gfloat) _tmp14_.y)) {
							MtkRectangle _tmp15_;
							MtkRectangle _tmp16_;
							_tmp15_ = monitor_rect;
							_tmp16_ = monitor_rect;
							_tmp13_ = coord <= ((gfloat) (_tmp15_.y + _tmp16_.height));
						} else {
							_tmp13_ = FALSE;
						}
						in_monitor = _tmp13_;
					}
					if (in_monitor) {
						result = TRUE;
						_g_object_unref0 (display);
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (display);
	return result;
}

static void
gala_plugins_pip_popup_window_get_current_monitor_rect (GalaPluginsPIPPopupWindow* self,
                                                        MtkRectangle* rect)
{
	MtkRectangle _vala_rect = {0};
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaDisplay* _tmp2_;
	MtkRectangle _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	meta_display_get_monitor_geometry (display, meta_display_get_current_monitor (display), &_tmp3_);
	_vala_rect = _tmp3_;
	_g_object_unref0 (display);
	if (rect) {
		*rect = _vala_rect;
	}
}

static void
gala_plugins_pip_popup_window_get_target_window_size (GalaPluginsPIPPopupWindow* self,
                                                      gfloat* width,
                                                      gfloat* height)
{
	gfloat _vala_width = 0.0F;
	gfloat _vala_height = 0.0F;
	g_return_if_fail (self != NULL);
	if (self->priv->dynamic_container) {
		ClutterActor* _tmp0_;
		gfloat _tmp1_ = 0.0F;
		gfloat _tmp2_ = 0.0F;
		_tmp0_ = self->priv->container;
		clutter_actor_get_clip (_tmp0_, NULL, NULL, &_tmp1_, &_tmp2_);
		_vala_width = _tmp1_;
		_vala_height = _tmp2_;
	} else {
		ClutterActor* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = self->priv->clone;
		g_object_get (_tmp3_, "has-clip", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			ClutterActor* _tmp6_;
			gfloat _tmp7_ = 0.0F;
			gfloat _tmp8_ = 0.0F;
			_tmp6_ = self->priv->clone;
			clutter_actor_get_clip (_tmp6_, NULL, NULL, &_tmp7_, &_tmp8_);
			_vala_width = _tmp7_;
			_vala_height = _tmp8_;
		} else {
			ClutterActor* _tmp9_;
			gfloat _tmp10_;
			gfloat _tmp11_;
			ClutterActor* _tmp12_;
			gfloat _tmp13_;
			gfloat _tmp14_;
			_tmp9_ = self->priv->clone;
			_tmp10_ = clutter_actor_get_width (_tmp9_);
			_tmp11_ = _tmp10_;
			_vala_width = _tmp11_;
			_tmp12_ = self->priv->clone;
			_tmp13_ = clutter_actor_get_height (_tmp12_);
			_tmp14_ = _tmp13_;
			_vala_height = _tmp14_;
		}
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static void
gala_plugins_pip_popup_window_activate (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->off_screen) {
		gala_plugins_pip_popup_window_place_window_in_screen (self);
	} else {
		MetaWindow* window = NULL;
		MetaWindowActor* _tmp0_;
		MetaWindow* _tmp1_;
		MetaWindow* _tmp2_;
		MetaWindow* _tmp3_;
		_tmp0_ = self->priv->_window_actor;
		_tmp1_ = meta_window_actor_get_meta_window (_tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		window = _tmp2_;
		_tmp3_ = window;
		meta_window_activate (_tmp3_, clutter_get_current_event_time ());
		_g_object_unref0 (window);
	}
}

GalaWindowManager*
gala_plugins_pip_popup_window_get_wm (GalaPluginsPIPPopupWindow* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_plugins_pip_popup_window_set_wm (GalaPluginsPIPPopupWindow* self,
                                      GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_popup_window_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY]);
	}
}

MetaWindowActor*
gala_plugins_pip_popup_window_get_window_actor (GalaPluginsPIPPopupWindow* self)
{
	MetaWindowActor* result;
	MetaWindowActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_actor;
	result = _tmp0_;
	return result;
}

static void
gala_plugins_pip_popup_window_set_window_actor (GalaPluginsPIPPopupWindow* self,
                                                MetaWindowActor* value)
{
	MetaWindowActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_popup_window_get_window_actor (self);
	if (old_value != value) {
		MetaWindowActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window_actor);
		self->priv->_window_actor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY]);
	}
}

static void
_gala_plugins_pip_popup_window_on_close_click_clicked_meta_window_unmanaged (MetaWindow* _sender,
                                                                             gpointer self)
{
	gala_plugins_pip_popup_window_on_close_click_clicked ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_update_window_focus_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self)
{
	gala_plugins_pip_popup_window_update_window_focus ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_update_window_focus_meta_workspace_manager_active_workspace_changed (MetaWorkspaceManager* _sender,
                                                                                                    gpointer self)
{
	gala_plugins_pip_popup_window_update_window_focus ((GalaPluginsPIPPopupWindow*) self);
}

static ClutterActor*
_gala_plugins_pip_popup_window_on_move_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                               gfloat x,
                                                                               gfloat y,
                                                                               gpointer self)
{
	ClutterActor* result;
	result = gala_plugins_pip_popup_window_on_move_begin ((GalaPluginsPIPPopupWindow*) self);
	return result;
}

static void
_gala_plugins_pip_popup_window_on_move_end_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                                gpointer self)
{
	gala_plugins_pip_popup_window_on_move_end ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_activate_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                             guint32 button,
                                                                             gpointer self)
{
	gala_plugins_pip_popup_window_activate ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_on_close_click_clicked_gala_close_button_triggered (GalaCloseButton* _sender,
                                                                                   guint32 timestamp,
                                                                                   gpointer self)
{
	gala_plugins_pip_popup_window_on_close_click_clicked ((GalaPluginsPIPPopupWindow*) self);
}

static gboolean
_gala_plugins_pip_popup_window_on_resize_button_press_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                                        ClutterEvent* event,
                                                                                        gpointer self)
{
	gboolean result;
	result = gala_plugins_pip_popup_window_on_resize_button_press ((GalaPluginsPIPPopupWindow*) self, event);
	return result;
}

static void
_gala_plugins_pip_popup_window_on_allocation_changed_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self)
{
	gala_plugins_pip_popup_window_on_allocation_changed ((GalaPluginsPIPPopupWindow*) self);
}

static GObject *
gala_plugins_pip_popup_window_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaPluginsPIPPopupWindow * self;
	MetaDisplay* display = NULL;
	GalaWindowManager* _tmp0_;
	MetaDisplay* _tmp1_;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp2_;
	MetaDisplay* _tmp3_;
	MetaWindow* window = NULL;
	MetaWindowActor* _tmp4_;
	MetaWindow* _tmp5_;
	MetaWindow* _tmp6_;
	MetaWindow* _tmp7_;
	MetaWorkspaceManager* workspace_manager = NULL;
	GalaWindowManager* _tmp8_;
	MetaDisplay* _tmp9_;
	MetaWorkspaceManager* _tmp10_;
	MetaWorkspaceManager* _tmp11_;
	MetaWindowActor* _tmp12_;
	ClutterClone* _tmp13_;
	GalaDragDropAction* _tmp14_;
	GalaDragDropAction* _tmp15_;
	GalaDragDropAction* _tmp16_;
	GalaDragDropAction* _tmp17_;
	ClutterActor* _tmp18_;
	ClutterActor* _tmp19_;
	ClutterActor* _tmp20_;
	ClutterActor* _tmp21_;
	gchar* _tmp22_;
	GalaShadowEffect* _tmp23_ = NULL;
	GalaShadowEffect* _tmp24_;
	ClutterActor* _tmp25_;
	ClutterActor* _tmp26_;
	ClutterActor* _tmp27_;
	GalaDragDropAction* _tmp28_;
	MtkRectangle monitor_rect = {0};
	MtkRectangle _tmp29_ = {0};
	gfloat x_position = 0.0F;
	gfloat y_position = 0.0F;
	MtkRectangle _tmp35_;
	MtkRectangle _tmp36_;
	gfloat _tmp37_;
	gfloat _tmp38_;
	GalaCloseButton* _tmp39_ = NULL;
	GalaCloseButton* _tmp40_;
	ClutterAlignConstraint* _tmp41_;
	ClutterAlignConstraint* _tmp42_;
	GalaCloseButton* _tmp43_;
	ClutterAlignConstraint* _tmp44_;
	ClutterAlignConstraint* _tmp45_;
	GalaCloseButton* _tmp46_;
	ClutterActor* _tmp47_;
	ClutterActor* _tmp48_;
	ClutterActor* _tmp49_;
	ClutterActor* _tmp50_;
	ClutterAlignConstraint* _tmp51_;
	ClutterAlignConstraint* _tmp52_;
	ClutterActor* _tmp53_;
	ClutterAlignConstraint* _tmp54_;
	ClutterAlignConstraint* _tmp55_;
	ClutterActor* _tmp56_;
	ClutterActor* _tmp57_;
	GalaCloseButton* _tmp58_;
	ClutterActor* _tmp59_;
	MetaWindowActor* _tmp60_;
	ClutterActor* _tmp61_;
	parent_class = G_OBJECT_CLASS (gala_plugins_pip_popup_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_display ((MetaPlugin*) _tmp0_);
	display = _tmp1_;
	_tmp2_ = display;
	_tmp3_ = display;
	scale = meta_display_get_monitor_scale (_tmp2_, meta_display_get_current_monitor (_tmp3_));
	self->priv->button_size = gala_utils_scale_to_int (36, scale);
	self->priv->container_margin = self->priv->button_size / 2;
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
	_tmp4_ = self->priv->_window_actor;
	_tmp5_ = meta_window_actor_get_meta_window (_tmp4_);
	window = _tmp5_;
	_tmp6_ = window;
	g_signal_connect_object (_tmp6_, "unmanaged", (GCallback) _gala_plugins_pip_popup_window_on_close_click_clicked_meta_window_unmanaged, self, 0);
	_tmp7_ = window;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::appears-focused", (GCallback) _gala_plugins_pip_popup_window_update_window_focus_g_object_notify, self, 0);
	_tmp8_ = self->priv->_wm;
	_tmp9_ = meta_plugin_get_display ((MetaPlugin*) _tmp8_);
	_tmp10_ = meta_display_get_workspace_manager (_tmp9_);
	workspace_manager = _tmp10_;
	_tmp11_ = workspace_manager;
	g_signal_connect_object (_tmp11_, "active-workspace-changed", (GCallback) _gala_plugins_pip_popup_window_update_window_focus_meta_workspace_manager_active_workspace_changed, self, 0);
	_tmp12_ = self->priv->_window_actor;
	_tmp13_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp12_);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->clone);
	self->priv->clone = (ClutterActor*) _tmp13_;
	_tmp14_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE, "pip");
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->priv->move_action);
	self->priv->move_action = _tmp14_;
	_tmp15_ = self->priv->move_action;
	g_signal_connect_object (_tmp15_, "drag-begin", (GCallback) _gala_plugins_pip_popup_window_on_move_begin_gala_drag_drop_action_drag_begin, self, 0);
	_tmp16_ = self->priv->move_action;
	g_signal_connect_object (_tmp16_, "drag-canceled", (GCallback) _gala_plugins_pip_popup_window_on_move_end_gala_drag_drop_action_drag_canceled, self, 0);
	_tmp17_ = self->priv->move_action;
	g_signal_connect_object (_tmp17_, "actor-clicked", (GCallback) _gala_plugins_pip_popup_window_activate_gala_drag_drop_action_actor_clicked, self, 0);
	_tmp18_ = clutter_actor_new ();
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp18_;
	_tmp19_ = self->priv->container;
	clutter_actor_set_reactive (_tmp19_, TRUE);
	_tmp20_ = self->priv->container;
	clutter_actor_set_scale (_tmp20_, (gdouble) 0.35f, (gdouble) 0.35f);
	_tmp21_ = self->priv->container;
	_tmp22_ = g_strdup ("window-clone");
	_tmp23_ = gala_shadow_effect_new (55);
	gala_shadow_effect_set_css_class (_tmp23_, _tmp22_);
	_g_free0 (_tmp22_);
	g_object_ref_sink (_tmp23_);
	_tmp24_ = _tmp23_;
	clutter_actor_add_effect (_tmp21_, (ClutterEffect*) _tmp24_);
	_g_object_unref0 (_tmp24_);
	_tmp25_ = self->priv->container;
	_tmp26_ = self->priv->clone;
	clutter_actor_add_child (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->container;
	_tmp28_ = self->priv->move_action;
	clutter_actor_add_action (_tmp27_, (ClutterAction*) _tmp28_);
	gala_plugins_pip_popup_window_update_size (self);
	gala_plugins_pip_popup_window_update_container_position (self);
	gala_plugins_pip_popup_window_get_current_monitor_rect (self, &_tmp29_);
	monitor_rect = _tmp29_;
	if (clutter_get_default_text_direction () == CLUTTER_TEXT_DIRECTION_RTL) {
		MtkRectangle _tmp30_;
		_tmp30_ = monitor_rect;
		x_position = (gfloat) (GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN + _tmp30_.x);
	} else {
		MtkRectangle _tmp31_;
		MtkRectangle _tmp32_;
		gfloat _tmp33_;
		gfloat _tmp34_;
		_tmp31_ = monitor_rect;
		_tmp32_ = monitor_rect;
		_tmp33_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp34_ = _tmp33_;
		x_position = ((_tmp31_.width + _tmp32_.x) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp34_;
	}
	_tmp35_ = monitor_rect;
	_tmp36_ = monitor_rect;
	_tmp37_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp38_ = _tmp37_;
	y_position = ((_tmp35_.height + _tmp36_.y) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp38_;
	clutter_actor_set_position ((ClutterActor*) self, x_position, y_position);
	_tmp39_ = gala_close_button_new (scale);
	clutter_actor_set_opacity ((ClutterActor*) _tmp39_, (guint) 0);
	g_object_ref_sink (_tmp39_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp39_;
	_tmp40_ = self->priv->close_button;
	_tmp41_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_X_AXIS, 0.0f);
	g_object_ref_sink (_tmp41_);
	_tmp42_ = _tmp41_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp40_, (ClutterConstraint*) _tmp42_);
	_g_object_unref0 (_tmp42_);
	_tmp43_ = self->priv->close_button;
	_tmp44_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_Y_AXIS, 0.0f);
	g_object_ref_sink (_tmp44_);
	_tmp45_ = _tmp44_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp43_, (ClutterConstraint*) _tmp45_);
	_g_object_unref0 (_tmp45_);
	_tmp46_ = self->priv->close_button;
	g_signal_connect_object (_tmp46_, "triggered", (GCallback) _gala_plugins_pip_popup_window_on_close_click_clicked_gala_close_button_triggered, self, 0);
	_tmp47_ = gala_utils_create_resize_button (scale);
	_g_object_unref0 (self->priv->resize_button);
	self->priv->resize_button = _tmp47_;
	_tmp48_ = self->priv->resize_button;
	clutter_actor_set_opacity (_tmp48_, (guint) 0);
	_tmp49_ = self->priv->resize_button;
	clutter_actor_set_reactive (_tmp49_, TRUE);
	_tmp50_ = self->priv->resize_button;
	_tmp51_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_X_AXIS, 1.0f);
	g_object_ref_sink (_tmp51_);
	_tmp52_ = _tmp51_;
	clutter_actor_add_constraint (_tmp50_, (ClutterConstraint*) _tmp52_);
	_g_object_unref0 (_tmp52_);
	_tmp53_ = self->priv->resize_button;
	_tmp54_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_Y_AXIS, 1.0f);
	g_object_ref_sink (_tmp54_);
	_tmp55_ = _tmp54_;
	clutter_actor_add_constraint (_tmp53_, (ClutterConstraint*) _tmp55_);
	_g_object_unref0 (_tmp55_);
	_tmp56_ = self->priv->resize_button;
	g_signal_connect_object (_tmp56_, "button-press-event", (GCallback) _gala_plugins_pip_popup_window_on_resize_button_press_clutter_actor_button_press_event, self, 0);
	_tmp57_ = self->priv->container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp57_);
	_tmp58_ = self->priv->close_button;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp58_);
	_tmp59_ = self->priv->resize_button;
	clutter_actor_add_child ((ClutterActor*) self, _tmp59_);
	_tmp60_ = self->priv->_window_actor;
	g_signal_connect_object ((GObject*) _tmp60_, "notify::allocation", (GCallback) _gala_plugins_pip_popup_window_on_allocation_changed_g_object_notify, self, 0);
	_tmp61_ = self->priv->container;
	clutter_actor_set_position (_tmp61_, (gfloat) self->priv->container_margin, (gfloat) self->priv->container_margin);
	gala_plugins_pip_popup_window_update_clone_clip (self);
	return obj;
}

static void
gala_plugins_pip_popup_window_class_init (GalaPluginsPIPPopupWindowClass * klass,
                                          gpointer klass_data)
{
	gala_plugins_pip_popup_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPluginsPIPPopupWindow_private_offset);
	((ClutterActorClass *) klass)->show = (void (*) (ClutterActor*)) gala_plugins_pip_popup_window_real_show;
	((ClutterActorClass *) klass)->hide = (void (*) (ClutterActor*)) gala_plugins_pip_popup_window_real_hide;
	((ClutterActorClass *) klass)->enter_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_plugins_pip_popup_window_real_enter_event;
	((ClutterActorClass *) klass)->leave_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_plugins_pip_popup_window_real_leave_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_plugins_pip_popup_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_plugins_pip_popup_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_plugins_pip_popup_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_plugins_pip_popup_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY] = g_param_spec_object ("window-actor", "window-actor", "window-actor", meta_window_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_plugins_pip_popup_window_signals[GALA_PLUGINS_PIP_POPUP_WINDOW_CLOSED_SIGNAL] = g_signal_new ("closed", GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_plugins_pip_popup_window_instance_init (GalaPluginsPIPPopupWindow * self,
                                             gpointer klass)
{
	self->priv = gala_plugins_pip_popup_window_get_instance_private (self);
	self->priv->dynamic_container = FALSE;
	self->priv->begin_resize_width = 0.0f;
	self->priv->begin_resize_height = 0.0f;
	self->priv->resize_start_x = 0.0f;
	self->priv->resize_start_y = 0.0f;
	self->priv->resizing = FALSE;
	self->priv->off_screen = FALSE;
	self->priv->grab = NULL;
}

static void
gala_plugins_pip_popup_window_finalize (GObject * obj)
{
	GalaPluginsPIPPopupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_window_actor);
	_g_object_unref0 (self->priv->clone);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->resize_button);
	_g_object_unref0 (self->priv->move_action);
	_g_object_unref0 (self->priv->grab);
	G_OBJECT_CLASS (gala_plugins_pip_popup_window_parent_class)->finalize (obj);
}

static GType
gala_plugins_pip_popup_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPluginsPIPPopupWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_plugins_pip_popup_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPluginsPIPPopupWindow), 0, (GInstanceInitFunc) gala_plugins_pip_popup_window_instance_init, NULL };
	GType gala_plugins_pip_popup_window_type_id;
	gala_plugins_pip_popup_window_type_id = g_type_register_static (clutter_actor_get_type (), "GalaPluginsPIPPopupWindow", &g_define_type_info, 0);
	GalaPluginsPIPPopupWindow_private_offset = g_type_add_instance_private (gala_plugins_pip_popup_window_type_id, sizeof (GalaPluginsPIPPopupWindowPrivate));
	return gala_plugins_pip_popup_window_type_id;
}

GType
gala_plugins_pip_popup_window_get_type (void)
{
	static volatile gsize gala_plugins_pip_popup_window_type_id__once = 0;
	if (g_once_init_enter (&gala_plugins_pip_popup_window_type_id__once)) {
		GType gala_plugins_pip_popup_window_type_id;
		gala_plugins_pip_popup_window_type_id = gala_plugins_pip_popup_window_get_type_once ();
		g_once_init_leave (&gala_plugins_pip_popup_window_type_id__once, gala_plugins_pip_popup_window_type_id);
	}
	return gala_plugins_pip_popup_window_type_id__once;
}

static void
_vala_gala_plugins_pip_popup_window_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GalaPluginsPIPPopupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	switch (property_id) {
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY:
		g_value_set_object (value, gala_plugins_pip_popup_window_get_wm (self));
		break;
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY:
		g_value_set_object (value, gala_plugins_pip_popup_window_get_window_actor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_plugins_pip_popup_window_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GalaPluginsPIPPopupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	switch (property_id) {
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WM_PROPERTY:
		gala_plugins_pip_popup_window_set_wm (self, g_value_get_object (value));
		break;
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY:
		gala_plugins_pip_popup_window_set_window_actor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

