/* Utils.c generated by valac 0.56.16, the Vala compiler
 * generated from Utils.vala, do not modify */

/**/
/*  Copyright (C) 2012 Tom Beckmann, Rico Tzschichholz*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "gala.h"
#include <gee.h>
#include <glib-object.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gdesktopappinfo.h>
#include <meta/window.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <meta/group.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <meta/workspace.h>
#include <meta/meta-window-actor.h>
#include <mtk/mtk.h>
#include <clutter/clutter.h>
#include "config.h"
#include <cogl/cogl.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GALA_UTILS_TYPE_CACHED_ICON (gala_utils_cached_icon_get_type ())
typedef struct _GalaUtilsCachedIcon GalaUtilsCachedIcon;
typedef struct _Block4Data Block4Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gala_utils_cached_icon_free0(var) ((var == NULL) ? NULL : (var = (gala_utils_cached_icon_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GalaParamSpecUtils GalaParamSpecUtils;

struct _GalaUtilsCachedIcon {
	GdkPixbuf* icon;
	gint icon_size;
	gint scale;
};

struct _Block4Data {
	int _ref_count_;
	GDesktopAppInfo* desktop_app;
};

struct _GalaParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer gala_utils_parent_class = NULL;
static GeeHashMap* gala_utils_resize_pixbufs;
static GeeHashMap* gala_utils_resize_pixbufs = NULL;
static GeeHashMultiMap* gala_utils_icon_cache;
static GeeHashMultiMap* gala_utils_icon_cache = NULL;
static GeeHashMap* gala_utils_window_to_desktop_cache;
static GeeHashMap* gala_utils_window_to_desktop_cache = NULL;
static GeeArrayList* gala_utils_unknown_icon_cache;
static GeeArrayList* gala_utils_unknown_icon_cache = NULL;
static GalaAppCache* gala_utils_app_cache;
static GalaAppCache* gala_utils_app_cache = NULL;
static GtkCssProvider* gala_utils_gala_css;
static GtkCssProvider* gala_utils_gala_css = NULL;

static GType gala_utils_cached_icon_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GalaUtilsCachedIcon* gala_utils_cached_icon_dup (const GalaUtilsCachedIcon* self);
static void gala_utils_cached_icon_free (GalaUtilsCachedIcon* self);
static void gala_utils_cached_icon_copy (const GalaUtilsCachedIcon* self,
                                  GalaUtilsCachedIcon* dest);
static void gala_utils_cached_icon_destroy (GalaUtilsCachedIcon* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static GdkPixbuf* gala_utils_get_icon_for_desktop_app_info (GDesktopAppInfo* desktop,
                                                     gint icon_size,
                                                     gint scale);
static gboolean gala_utils_check_app_prefix (GDesktopAppInfo* app,
                                      const gchar* sandbox_id);
static GDesktopAppInfo* gala_utils_lookup_desktop_wmclass (const gchar* wm_class);
static GDesktopAppInfo* gala_utils_get_app_from_id (const gchar* id);
static void ____lambda9_ (Block4Data* _data4_,
                   MetaWindow* window);
static void _____lambda9__gfunc (gconstpointer data,
                          gpointer self);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void _gala_utils___lambda10_ (void);
static void __gala_utils___lambda10__gala_app_cache_changed (GalaAppCache* _sender,
                                                      gpointer self);
static void gala_utils_finalize (GalaUtils * obj);
static GType gala_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->desktop_app);
		g_slice_free (Block4Data, _data4_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
____lambda9_ (Block4Data* _data4_,
              MetaWindow* window)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GDesktopAppInfo* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (window != NULL);
	if (meta_window_get_window_type (window) != META_WINDOW_NORMAL) {
		return;
	}
	_tmp0_ = gala_utils_window_to_desktop_cache;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, window);
	_tmp2_ = (GDesktopAppInfo*) _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		GeeHashMap* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = gala_utils_window_to_desktop_cache;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, window);
		_g_object_unref0 (_data4_->desktop_app);
		_data4_->desktop_app = (GDesktopAppInfo*) _tmp5_;
	}
}

static void
_____lambda9__gfunc (gconstpointer data,
                     gpointer self)
{
	____lambda9_ (self, (MetaWindow*) data);
}

GdkPixbuf*
gala_utils_get_icon_for_window (MetaWindow* window,
                                gint icon_size,
                                gint scale)
{
	Block4Data* _data4_;
	MetaWindow* transient_for = NULL;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	GeeHashMap* _tmp5_;
	gpointer _tmp6_;
	GDesktopAppInfo* _tmp7_;
	gchar* sandbox_id = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* wm_instance = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GalaAppCache* _tmp15_;
	const gchar* _tmp16_;
	GDesktopAppInfo* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GDesktopAppInfo* _tmp19_;
	gchar* wm_class = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	GalaAppCache* _tmp29_;
	const gchar* _tmp30_;
	GDesktopAppInfo* _tmp31_;
	gboolean _tmp32_ = FALSE;
	GDesktopAppInfo* _tmp33_;
	const gchar* _tmp41_;
	GDesktopAppInfo* _tmp42_;
	gboolean _tmp43_ = FALSE;
	GDesktopAppInfo* _tmp44_;
	const gchar* _tmp52_;
	GDesktopAppInfo* _tmp53_;
	gboolean _tmp54_ = FALSE;
	GDesktopAppInfo* _tmp55_;
	const gchar* _tmp63_;
	GDesktopAppInfo* _tmp64_;
	GDesktopAppInfo* _tmp65_;
	gchar* gapplication_id = NULL;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	const gchar* _tmp73_;
	GDesktopAppInfo* _tmp74_;
	GDesktopAppInfo* _tmp75_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (window != NULL, NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_tmp0_ = meta_window_get_transient_for (window);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	transient_for = _tmp1_;
	_tmp2_ = transient_for;
	if (_tmp2_ != NULL) {
		MetaWindow* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp3_ = transient_for;
		_tmp4_ = gala_utils_get_icon_for_window (_tmp3_, icon_size, scale);
		result = _tmp4_;
		_g_object_unref0 (transient_for);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	_data4_->desktop_app = NULL;
	_tmp5_ = gala_utils_window_to_desktop_cache;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, window);
	_g_object_unref0 (_data4_->desktop_app);
	_data4_->desktop_app = (GDesktopAppInfo*) _tmp6_;
	_tmp7_ = _data4_->desktop_app;
	if (_tmp7_ != NULL) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp8_ = _data4_->desktop_app;
		_tmp9_ = gala_utils_get_icon_for_desktop_app_info (_tmp8_, icon_size, scale);
		icon = _tmp9_;
		_tmp10_ = icon;
		if (_tmp10_ != NULL) {
			result = icon;
			_g_object_unref0 (transient_for);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp11_ = meta_window_get_sandboxed_app_id (window);
	_tmp12_ = g_strdup (_tmp11_);
	sandbox_id = _tmp12_;
	_tmp13_ = meta_window_get_wm_class_instance (window);
	_tmp14_ = g_strdup (_tmp13_);
	wm_instance = _tmp14_;
	_tmp15_ = gala_utils_app_cache;
	_tmp16_ = wm_instance;
	_tmp17_ = gala_app_cache_lookup_startup_wmclass (_tmp15_, _tmp16_);
	_g_object_unref0 (_data4_->desktop_app);
	_data4_->desktop_app = _tmp17_;
	_tmp19_ = _data4_->desktop_app;
	if (_tmp19_ != NULL) {
		GDesktopAppInfo* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = _data4_->desktop_app;
		_tmp21_ = sandbox_id;
		_tmp18_ = gala_utils_check_app_prefix (_tmp20_, _tmp21_);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp22_;
		GdkPixbuf* _tmp23_;
		GdkPixbuf* _tmp24_;
		_tmp22_ = _data4_->desktop_app;
		_tmp23_ = gala_utils_get_icon_for_desktop_app_info (_tmp22_, icon_size, scale);
		icon = _tmp23_;
		_tmp24_ = icon;
		if (_tmp24_ != NULL) {
			GeeHashMap* _tmp25_;
			GDesktopAppInfo* _tmp26_;
			_tmp25_ = gala_utils_window_to_desktop_cache;
			_tmp26_ = _data4_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, window, _tmp26_);
			result = icon;
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp27_ = meta_window_get_wm_class (window);
	_tmp28_ = g_strdup (_tmp27_);
	wm_class = _tmp28_;
	_tmp29_ = gala_utils_app_cache;
	_tmp30_ = wm_class;
	_tmp31_ = gala_app_cache_lookup_startup_wmclass (_tmp29_, _tmp30_);
	_g_object_unref0 (_data4_->desktop_app);
	_data4_->desktop_app = _tmp31_;
	_tmp33_ = _data4_->desktop_app;
	if (_tmp33_ != NULL) {
		GDesktopAppInfo* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = _data4_->desktop_app;
		_tmp35_ = sandbox_id;
		_tmp32_ = gala_utils_check_app_prefix (_tmp34_, _tmp35_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp36_;
		GdkPixbuf* _tmp37_;
		GdkPixbuf* _tmp38_;
		_tmp36_ = _data4_->desktop_app;
		_tmp37_ = gala_utils_get_icon_for_desktop_app_info (_tmp36_, icon_size, scale);
		icon = _tmp37_;
		_tmp38_ = icon;
		if (_tmp38_ != NULL) {
			GeeHashMap* _tmp39_;
			GDesktopAppInfo* _tmp40_;
			_tmp39_ = gala_utils_window_to_desktop_cache;
			_tmp40_ = _data4_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp39_, window, _tmp40_);
			result = icon;
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp41_ = wm_instance;
	_tmp42_ = gala_utils_lookup_desktop_wmclass (_tmp41_);
	_g_object_unref0 (_data4_->desktop_app);
	_data4_->desktop_app = _tmp42_;
	_tmp44_ = _data4_->desktop_app;
	if (_tmp44_ != NULL) {
		GDesktopAppInfo* _tmp45_;
		const gchar* _tmp46_;
		_tmp45_ = _data4_->desktop_app;
		_tmp46_ = sandbox_id;
		_tmp43_ = gala_utils_check_app_prefix (_tmp45_, _tmp46_);
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp47_;
		GdkPixbuf* _tmp48_;
		GdkPixbuf* _tmp49_;
		_tmp47_ = _data4_->desktop_app;
		_tmp48_ = gala_utils_get_icon_for_desktop_app_info (_tmp47_, icon_size, scale);
		icon = _tmp48_;
		_tmp49_ = icon;
		if (_tmp49_ != NULL) {
			GeeHashMap* _tmp50_;
			GDesktopAppInfo* _tmp51_;
			_tmp50_ = gala_utils_window_to_desktop_cache;
			_tmp51_ = _data4_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp50_, window, _tmp51_);
			result = icon;
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp52_ = wm_class;
	_tmp53_ = gala_utils_lookup_desktop_wmclass (_tmp52_);
	_g_object_unref0 (_data4_->desktop_app);
	_data4_->desktop_app = _tmp53_;
	_tmp55_ = _data4_->desktop_app;
	if (_tmp55_ != NULL) {
		GDesktopAppInfo* _tmp56_;
		const gchar* _tmp57_;
		_tmp56_ = _data4_->desktop_app;
		_tmp57_ = sandbox_id;
		_tmp54_ = gala_utils_check_app_prefix (_tmp56_, _tmp57_);
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp58_;
		GdkPixbuf* _tmp59_;
		GdkPixbuf* _tmp60_;
		_tmp58_ = _data4_->desktop_app;
		_tmp59_ = gala_utils_get_icon_for_desktop_app_info (_tmp58_, icon_size, scale);
		icon = _tmp59_;
		_tmp60_ = icon;
		if (_tmp60_ != NULL) {
			GeeHashMap* _tmp61_;
			GDesktopAppInfo* _tmp62_;
			_tmp61_ = gala_utils_window_to_desktop_cache;
			_tmp62_ = _data4_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp61_, window, _tmp62_);
			result = icon;
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp63_ = sandbox_id;
	_tmp64_ = gala_utils_get_app_from_id (_tmp63_);
	_g_object_unref0 (_data4_->desktop_app);
	_data4_->desktop_app = _tmp64_;
	_tmp65_ = _data4_->desktop_app;
	if (_tmp65_ != NULL) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp66_;
		GdkPixbuf* _tmp67_;
		GdkPixbuf* _tmp68_;
		_tmp66_ = _data4_->desktop_app;
		_tmp67_ = gala_utils_get_icon_for_desktop_app_info (_tmp66_, icon_size, scale);
		icon = _tmp67_;
		_tmp68_ = icon;
		if (_tmp68_ != NULL) {
			GeeHashMap* _tmp69_;
			GDesktopAppInfo* _tmp70_;
			_tmp69_ = gala_utils_window_to_desktop_cache;
			_tmp70_ = _data4_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp69_, window, _tmp70_);
			result = icon;
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp71_ = meta_window_get_gtk_application_id (window);
	_tmp72_ = g_strdup (_tmp71_);
	gapplication_id = _tmp72_;
	_tmp73_ = gapplication_id;
	_tmp74_ = gala_utils_get_app_from_id (_tmp73_);
	_g_object_unref0 (_data4_->desktop_app);
	_data4_->desktop_app = _tmp74_;
	_tmp75_ = _data4_->desktop_app;
	if (_tmp75_ != NULL) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp76_;
		GdkPixbuf* _tmp77_;
		GdkPixbuf* _tmp78_;
		_tmp76_ = _data4_->desktop_app;
		_tmp77_ = gala_utils_get_icon_for_desktop_app_info (_tmp76_, icon_size, scale);
		icon = _tmp77_;
		_tmp78_ = icon;
		if (_tmp78_ != NULL) {
			GeeHashMap* _tmp79_;
			GDesktopAppInfo* _tmp80_;
			_tmp79_ = gala_utils_window_to_desktop_cache;
			_tmp80_ = _data4_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp79_, window, _tmp80_);
			result = icon;
			_g_free0 (gapplication_id);
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	if (meta_window_get_client_type (window) == META_WINDOW_CLIENT_TYPE_X11) {
		MetaGroup* group = NULL;
		MetaGroup* _tmp81_;
		MetaGroup* _tmp82_;
		_tmp81_ = meta_window_x11_get_group (window);
		group = _tmp81_;
		_tmp82_ = group;
		if (_tmp82_ != NULL) {
			GSList* group_windows = NULL;
			MetaGroup* _tmp83_;
			GSList* _tmp84_;
			GSList* _tmp85_;
			GDesktopAppInfo* _tmp86_;
			_tmp83_ = group;
			_tmp84_ = meta_group_list_windows (_tmp83_);
			group_windows = _tmp84_;
			_tmp85_ = group_windows;
			g_slist_foreach (_tmp85_, _____lambda9__gfunc, _data4_);
			_tmp86_ = _data4_->desktop_app;
			if (_tmp86_ != NULL) {
				GdkPixbuf* icon = NULL;
				GDesktopAppInfo* _tmp87_;
				GdkPixbuf* _tmp88_;
				GdkPixbuf* _tmp89_;
				_tmp87_ = _data4_->desktop_app;
				_tmp88_ = gala_utils_get_icon_for_desktop_app_info (_tmp87_, icon_size, scale);
				icon = _tmp88_;
				_tmp89_ = icon;
				if (_tmp89_ != NULL) {
					GeeHashMap* _tmp90_;
					GDesktopAppInfo* _tmp91_;
					_tmp90_ = gala_utils_window_to_desktop_cache;
					_tmp91_ = _data4_->desktop_app;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp90_, window, _tmp91_);
					result = icon;
					(group_windows == NULL) ? NULL : (group_windows = (g_slist_free (group_windows), NULL));
					_g_free0 (gapplication_id);
					_g_free0 (wm_class);
					_g_free0 (wm_instance);
					_g_free0 (sandbox_id);
					_g_object_unref0 (transient_for);
					block4_data_unref (_data4_);
					_data4_ = NULL;
					return result;
				}
				_g_object_unref0 (icon);
			}
			(group_windows == NULL) ? NULL : (group_windows = (g_slist_free (group_windows), NULL));
		}
	}
	{
		GeeArrayList* _icon_list = NULL;
		GeeArrayList* _tmp92_;
		gint _icon_size = 0;
		GeeArrayList* _tmp93_;
		gint _tmp94_;
		gint _tmp95_;
		gint _icon_index = 0;
		_tmp92_ = gala_utils_unknown_icon_cache;
		_icon_list = _tmp92_;
		_tmp93_ = _icon_list;
		_tmp94_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp93_);
		_tmp95_ = _tmp94_;
		_icon_size = _tmp95_;
		_icon_index = -1;
		while (TRUE) {
			gint _tmp96_;
			gint _tmp97_;
			GalaUtilsCachedIcon* icon = NULL;
			GeeArrayList* _tmp98_;
			gpointer _tmp99_;
			gboolean _tmp100_ = FALSE;
			GalaUtilsCachedIcon* _tmp101_;
			_icon_index = _icon_index + 1;
			_tmp96_ = _icon_index;
			_tmp97_ = _icon_size;
			if (!(_tmp96_ < _tmp97_)) {
				break;
			}
			_tmp98_ = _icon_list;
			_tmp99_ = gee_abstract_list_get ((GeeAbstractList*) _tmp98_, _icon_index);
			icon = (GalaUtilsCachedIcon*) _tmp99_;
			_tmp101_ = icon;
			if ((*_tmp101_).icon_size == icon_size) {
				GalaUtilsCachedIcon* _tmp102_;
				_tmp102_ = icon;
				_tmp100_ = (*_tmp102_).scale == scale;
			} else {
				_tmp100_ = FALSE;
			}
			if (_tmp100_) {
				GalaUtilsCachedIcon* _tmp103_;
				GdkPixbuf* _tmp104_;
				GdkPixbuf* _tmp105_;
				_tmp103_ = icon;
				_tmp104_ = (*_tmp103_).icon;
				_tmp105_ = _g_object_ref0 (_tmp104_);
				result = _tmp105_;
				_gala_utils_cached_icon_free0 (icon);
				_g_free0 (gapplication_id);
				_g_free0 (wm_class);
				_g_free0 (wm_instance);
				_g_free0 (sandbox_id);
				_g_object_unref0 (transient_for);
				block4_data_unref (_data4_);
				_data4_ = NULL;
				return result;
			}
			_gala_utils_cached_icon_free0 (icon);
		}
	}
	{
		GdkPixbuf* icon = NULL;
		GtkIconTheme* _tmp106_;
		GdkPixbuf* _tmp107_;
		GeeArrayList* _tmp108_;
		GdkPixbuf* _tmp109_;
		GdkPixbuf* _tmp110_;
		GalaUtilsCachedIcon _tmp111_ = {0};
		GalaUtilsCachedIcon _tmp112_;
		GalaUtilsCachedIcon _tmp113_;
		_tmp106_ = gtk_icon_theme_get_default ();
		_tmp107_ = gtk_icon_theme_load_icon_for_scale (_tmp106_, "application-default-icon", icon_size, scale, 0, &_inner_error0_);
		icon = _tmp107_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp108_ = gala_utils_unknown_icon_cache;
		_tmp109_ = icon;
		_tmp110_ = _g_object_ref0 (_tmp109_);
		memset (&_tmp111_, 0, sizeof (GalaUtilsCachedIcon));
		_g_object_unref0 (_tmp111_.icon);
		_tmp111_.icon = _tmp110_;
		_tmp111_.icon_size = icon_size;
		_tmp111_.scale = scale;
		_tmp112_ = _tmp111_;
		_tmp113_ = _tmp112_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp108_, &_tmp113_);
		gala_utils_cached_icon_destroy (&_tmp112_);
		result = icon;
		_g_free0 (gapplication_id);
		_g_free0 (wm_class);
		_g_free0 (wm_instance);
		_g_free0 (sandbox_id);
		_g_object_unref0 (transient_for);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GdkPixbuf* icon = NULL;
		GdkPixbuf* _tmp114_;
		GdkPixbuf* _tmp115_;
		g_clear_error (&_inner_error0_);
		_tmp114_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, icon_size * scale, icon_size * scale);
		icon = _tmp114_;
		_tmp115_ = icon;
		gdk_pixbuf_fill (_tmp115_, (guint32) 0x00000000);
		result = icon;
		_g_free0 (gapplication_id);
		_g_free0 (wm_class);
		_g_free0 (wm_instance);
		_g_free0 (sandbox_id);
		_g_object_unref0 (transient_for);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return result;
	}
	__finally0:
	_g_free0 (gapplication_id);
	_g_free0 (wm_class);
	_g_free0 (wm_instance);
	_g_free0 (sandbox_id);
	_g_object_unref0 (transient_for);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
gala_utils_check_app_prefix (GDesktopAppInfo* app,
                             const gchar* sandbox_id)
{
	gchar* prefix = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (app != NULL, FALSE);
	if (sandbox_id == NULL) {
		result = TRUE;
		return result;
	}
	_tmp0_ = g_strdup_printf ("%s.", sandbox_id);
	prefix = _tmp0_;
	_tmp1_ = g_app_info_get_id ((GAppInfo*) app);
	_tmp2_ = prefix;
	if (g_str_has_prefix (_tmp1_, _tmp2_)) {
		result = TRUE;
		_g_free0 (prefix);
		return result;
	}
	result = FALSE;
	_g_free0 (prefix);
	return result;
}

void
gala_utils_clear_window_cache (MetaWindow* window)
{
	GDesktopAppInfo* desktop = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GDesktopAppInfo* _tmp2_;
	g_return_if_fail (window != NULL);
	_tmp0_ = gala_utils_window_to_desktop_cache;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, window);
	desktop = (GDesktopAppInfo*) _tmp1_;
	_tmp2_ = desktop;
	if (_tmp2_ != NULL) {
		GeeHashMultiMap* _tmp3_;
		GDesktopAppInfo* _tmp4_;
		GeeHashMap* _tmp5_;
		_tmp3_ = gala_utils_icon_cache;
		_tmp4_ = desktop;
		gee_multi_map_remove_all ((GeeMultiMap*) _tmp3_, _tmp4_);
		_tmp5_ = gala_utils_window_to_desktop_cache;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, window, NULL);
	}
	_g_object_unref0 (desktop);
}

static GDesktopAppInfo*
gala_utils_get_app_from_id (const gchar* id)
{
	gchar* desktop_file = NULL;
	gchar* _tmp0_;
	GalaAppCache* _tmp1_;
	const gchar* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	GDesktopAppInfo* result;
	if (id == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_strdup_printf ("%s.desktop", id);
	desktop_file = _tmp0_;
	_tmp1_ = gala_utils_app_cache;
	_tmp2_ = desktop_file;
	_tmp3_ = gala_app_cache_lookup_id (_tmp1_, _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	_g_free0 (desktop_file);
	return result;
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

static GDesktopAppInfo*
gala_utils_lookup_desktop_wmclass (const gchar* wm_class)
{
	GDesktopAppInfo* desktop_info = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	gchar* canonicalized = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GDesktopAppInfo* _tmp7_;
	GDesktopAppInfo* result;
	if (wm_class == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = gala_utils_get_app_from_id (wm_class);
	desktop_info = _tmp0_;
	_tmp1_ = desktop_info;
	if (_tmp1_ != NULL) {
		result = desktop_info;
		return result;
	}
	_tmp2_ = g_ascii_strdown (wm_class, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_delimit (_tmp3_, " ", '-');
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	canonicalized = _tmp5_;
	_tmp6_ = canonicalized;
	_tmp7_ = gala_utils_get_app_from_id (_tmp6_);
	result = _tmp7_;
	_g_free0 (canonicalized);
	_g_object_unref0 (desktop_info);
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GdkPixbuf*
gala_utils_get_icon_for_desktop_app_info (GDesktopAppInfo* desktop,
                                          gint icon_size,
                                          gint scale)
{
	GeeHashMultiMap* _tmp0_;
	GIcon* icon = NULL;
	GIcon* _tmp15_;
	GIcon* _tmp16_;
	GIcon* _tmp17_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (desktop != NULL, NULL);
	_tmp0_ = gala_utils_icon_cache;
	if (gee_multi_map_contains ((GeeMultiMap*) _tmp0_, desktop)) {
		{
			GeeIterator* _icon_it = NULL;
			GeeHashMultiMap* _tmp1_;
			GeeCollection* _tmp2_;
			GeeCollection* _tmp3_;
			GeeIterator* _tmp4_;
			GeeIterator* _tmp5_;
			_tmp1_ = gala_utils_icon_cache;
			_tmp2_ = gee_multi_map_get ((GeeMultiMap*) _tmp1_, desktop);
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_icon_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				GalaUtilsCachedIcon* icon = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				gboolean _tmp9_ = FALSE;
				GalaUtilsCachedIcon* _tmp10_;
				_tmp6_ = _icon_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _icon_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				icon = (GalaUtilsCachedIcon*) _tmp8_;
				_tmp10_ = icon;
				if ((*_tmp10_).icon_size == icon_size) {
					GalaUtilsCachedIcon* _tmp11_;
					_tmp11_ = icon;
					_tmp9_ = (*_tmp11_).scale == scale;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					GalaUtilsCachedIcon* _tmp12_;
					GdkPixbuf* _tmp13_;
					GdkPixbuf* _tmp14_;
					_tmp12_ = icon;
					_tmp13_ = (*_tmp12_).icon;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					result = _tmp14_;
					_gala_utils_cached_icon_free0 (icon);
					_g_object_unref0 (_icon_it);
					return result;
				}
				_gala_utils_cached_icon_free0 (icon);
			}
			_g_object_unref0 (_icon_it);
		}
	}
	_tmp15_ = g_app_info_get_icon ((GAppInfo*) desktop);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	icon = _tmp16_;
	_tmp17_ = icon;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_themed_icon_get_type ())) {
		gchar** icon_names = NULL;
		GIcon* _tmp18_;
		gchar** _tmp19_;
		gchar** _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		gint icon_names_length1;
		gint _icon_names_size_;
		GtkIconInfo* icon_info = NULL;
		GtkIconTheme* _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		GtkIconInfo* _tmp24_;
		GtkIconInfo* _tmp25_;
		_tmp18_ = icon;
		_tmp20_ = _tmp19_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_themed_icon_get_type (), GThemedIcon));
		_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup3 (_tmp20_, _vala_array_length (_tmp19_)) : _tmp20_;
		_tmp21__length1 = _vala_array_length (_tmp19_);
		icon_names = _tmp21_;
		icon_names_length1 = _tmp21__length1;
		_icon_names_size_ = icon_names_length1;
		_tmp22_ = gtk_icon_theme_get_default ();
		_tmp23_ = icon_names;
		_tmp23__length1 = icon_names_length1;
		_tmp24_ = gtk_icon_theme_choose_icon_for_scale (_tmp22_, _tmp23_, icon_size, scale, 0);
		icon_info = _tmp24_;
		_tmp25_ = icon_info;
		if (_tmp25_ == NULL) {
			result = NULL;
			_g_object_unref0 (icon_info);
			icon_names = (_vala_array_free (icon_names, icon_names_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (icon);
			return result;
		}
		{
			GdkPixbuf* pixbuf = NULL;
			GtkIconInfo* _tmp26_;
			GdkPixbuf* _tmp27_;
			GeeHashMultiMap* _tmp28_;
			GdkPixbuf* _tmp29_;
			GdkPixbuf* _tmp30_;
			GalaUtilsCachedIcon _tmp31_ = {0};
			GalaUtilsCachedIcon _tmp32_;
			GalaUtilsCachedIcon _tmp33_;
			_tmp26_ = icon_info;
			_tmp27_ = gtk_icon_info_load_icon (_tmp26_, &_inner_error0_);
			pixbuf = _tmp27_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp28_ = gala_utils_icon_cache;
			_tmp29_ = pixbuf;
			_tmp30_ = _g_object_ref0 (_tmp29_);
			memset (&_tmp31_, 0, sizeof (GalaUtilsCachedIcon));
			_g_object_unref0 (_tmp31_.icon);
			_tmp31_.icon = _tmp30_;
			_tmp31_.icon_size = icon_size;
			_tmp31_.scale = scale;
			_tmp32_ = _tmp31_;
			_tmp33_ = _tmp32_;
			gee_multi_map_set ((GeeMultiMap*) _tmp28_, desktop, &_tmp33_);
			gala_utils_cached_icon_destroy (&_tmp32_);
			result = pixbuf;
			_g_object_unref0 (icon_info);
			icon_names = (_vala_array_free (icon_names, icon_names_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (icon);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			result = NULL;
			_g_object_unref0 (icon_info);
			icon_names = (_vala_array_free (icon_names, icon_names_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (icon);
			return result;
		}
		__finally0:
		_g_object_unref0 (icon_info);
		icon_names = (_vala_array_free (icon_names, icon_names_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (icon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	} else {
		GIcon* _tmp34_;
		_tmp34_ = icon;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, g_file_icon_get_type ())) {
			GFile* file = NULL;
			GIcon* _tmp35_;
			GFile* _tmp36_;
			GFile* _tmp37_;
			GFile* _tmp38_;
			gint size_with_scale = 0;
			_tmp35_ = icon;
			_tmp36_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, g_file_icon_get_type (), GFileIcon));
			_tmp37_ = _tmp36_;
			_tmp38_ = _g_object_ref0 (_tmp37_);
			file = _tmp38_;
			size_with_scale = icon_size * scale;
			{
				GFileInputStream* _tmp39_ = NULL;
				GFile* _tmp40_;
				GFileInputStream* _tmp41_;
				GdkPixbuf* pixbuf = NULL;
				GdkPixbuf* _tmp42_;
				GeeHashMultiMap* _tmp43_;
				GdkPixbuf* _tmp44_;
				GdkPixbuf* _tmp45_;
				GalaUtilsCachedIcon _tmp46_ = {0};
				GalaUtilsCachedIcon _tmp47_;
				GalaUtilsCachedIcon _tmp48_;
				_tmp40_ = file;
				_tmp41_ = g_file_read (_tmp40_, NULL, &_inner_error0_);
				_tmp39_ = _tmp41_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp42_ = gdk_pixbuf_new_from_stream_at_scale ((GInputStream*) _tmp39_, size_with_scale, size_with_scale, TRUE, NULL, &_inner_error0_);
				pixbuf = _tmp42_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp39_);
					goto __catch1_g_error;
				}
				_tmp43_ = gala_utils_icon_cache;
				_tmp44_ = pixbuf;
				_tmp45_ = _g_object_ref0 (_tmp44_);
				memset (&_tmp46_, 0, sizeof (GalaUtilsCachedIcon));
				_g_object_unref0 (_tmp46_.icon);
				_tmp46_.icon = _tmp45_;
				_tmp46_.icon_size = icon_size;
				_tmp46_.scale = scale;
				_tmp47_ = _tmp46_;
				_tmp48_ = _tmp47_;
				gee_multi_map_set ((GeeMultiMap*) _tmp43_, desktop, &_tmp48_);
				gala_utils_cached_icon_destroy (&_tmp47_);
				result = pixbuf;
				_g_object_unref0 (_tmp39_);
				_g_object_unref0 (file);
				_g_object_unref0 (icon);
				return result;
			}
			goto __finally1;
			__catch1_g_error:
			{
				g_clear_error (&_inner_error0_);
				result = NULL;
				_g_object_unref0 (file);
				_g_object_unref0 (icon);
				return result;
			}
			__finally1:
			_g_object_unref0 (file);
			_g_object_unref0 (icon);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = NULL;
	_g_object_unref0 (icon);
	return result;
}

/**
         * Multiplies an integer by a floating scaling factor, and then
         * returns the result rounded to the nearest integer
         */
gint
gala_utils_scale_to_int (gint value,
                         gfloat scale_factor)
{
	gint result;
	result = (gint) round ((gdouble) (((gfloat) value) * scale_factor));
	return result;
}

/**
         * Get the number of toplevel windows on a workspace excluding those that are
         * on all workspaces
         *
         * @param workspace The workspace on which to count the windows
         */
guint
gala_utils_get_n_windows (MetaWorkspace* workspace,
                          gboolean on_primary)
{
	gint n = 0;
	GList* _tmp0_;
	guint result;
	g_return_val_if_fail (workspace != NULL, 0U);
	n = 0;
	_tmp0_ = meta_workspace_list_windows (workspace);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				MetaWindow* _tmp1_;
				gboolean _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				gboolean _tmp6_ = FALSE;
				MetaWindow* _tmp7_;
				MetaWindowType _tmp8_;
				MetaWindowType _tmp9_;
				_tmp1_ = window;
				g_object_get (_tmp1_, "on-all-workspaces", &_tmp2_, NULL);
				_tmp3_ = _tmp2_;
				if (_tmp3_) {
					continue;
				}
				_tmp7_ = window;
				_tmp8_ = meta_window_get_window_type (_tmp7_);
				_tmp9_ = _tmp8_;
				if (_tmp9_ == META_WINDOW_NORMAL) {
					_tmp6_ = TRUE;
				} else {
					MetaWindow* _tmp10_;
					MetaWindowType _tmp11_;
					MetaWindowType _tmp12_;
					_tmp10_ = window;
					_tmp11_ = meta_window_get_window_type (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp6_ = _tmp12_ == META_WINDOW_DIALOG;
				}
				if (_tmp6_) {
					_tmp5_ = TRUE;
				} else {
					MetaWindow* _tmp13_;
					MetaWindowType _tmp14_;
					MetaWindowType _tmp15_;
					_tmp13_ = window;
					_tmp14_ = meta_window_get_window_type (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp5_ = _tmp15_ == META_WINDOW_MODAL_DIALOG;
				}
				if (_tmp5_) {
					gboolean _tmp16_ = FALSE;
					if (!on_primary) {
						_tmp16_ = TRUE;
					} else {
						gboolean _tmp17_ = FALSE;
						if (on_primary) {
							MetaWindow* _tmp18_;
							_tmp18_ = window;
							_tmp17_ = meta_window_is_on_primary_monitor (_tmp18_);
						} else {
							_tmp17_ = FALSE;
						}
						_tmp16_ = _tmp17_;
					}
					_tmp4_ = _tmp16_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					gint _tmp19_;
					_tmp19_ = n;
					n = _tmp19_ + 1;
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	result = (guint) n;
	return result;
}

/**
         * Creates an actor showing the current contents of the given WindowActor.
         *
         * @param actor      The actor from which to create a snapshot
         * @param inner_rect The inner (actually visible) rectangle of the window
         * @param outer_rect The outer (input region) rectangle of the window
         *
         * @return           A copy of the actor at that time or %NULL
         */
ClutterActor*
gala_utils_get_window_actor_snapshot (MetaWindowActor* actor,
                                      MtkRectangle* inner_rect)
{
	ClutterContent* content = NULL;
	ClutterContent* _tmp6_;
	ClutterActor* container = NULL;
	ClutterActor* _tmp7_;
	ClutterActor* _tmp8_;
	MtkRectangle _tmp9_;
	MtkRectangle _tmp10_;
	ClutterActor* _tmp11_;
	ClutterContent* _tmp12_;
	GError* _inner_error0_ = NULL;
	ClutterActor* result;
	g_return_val_if_fail (actor != NULL, NULL);
	g_return_val_if_fail (inner_rect != NULL, NULL);
	{
		ClutterContent* _tmp0_ = NULL;
		MtkRectangle _tmp1_;
		ClutterContent* _tmp2_;
		ClutterContent* _tmp3_;
		_tmp1_ = *inner_rect;
		_tmp2_ = meta_window_actor_paint_to_content (actor, &_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (content);
		content = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("Utils.vala:310: Could not create window snapshot: %s", _tmp5_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (content);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (content);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = content;
	if (_tmp6_ == NULL) {
		g_warning ("Utils.vala:315: Could not create window snapshot");
		result = NULL;
		_g_object_unref0 (content);
		return result;
	}
	_tmp7_ = clutter_actor_new ();
	g_object_ref_sink (_tmp7_);
	container = _tmp7_;
	_tmp8_ = container;
	_tmp9_ = *inner_rect;
	_tmp10_ = *inner_rect;
	clutter_actor_set_size (_tmp8_, (gfloat) _tmp9_.width, (gfloat) _tmp10_.height);
	_tmp11_ = container;
	_tmp12_ = content;
	clutter_actor_set_content (_tmp11_, _tmp12_);
	result = container;
	_g_object_unref0 (content);
	return result;
}

/**
         * DEPRECATED: When used with Mutter 44, this will always return 1.
         * Get the scaling factor for the monitor you are drawing to with
         * `Meta.Display.get_monitor_scale` instead
         */
gint
gala_utils_get_ui_scaling_factor (void)
{
	gint result;
	result = 1;
	return result;
}

/**
         * Returns the pixbuf that is used for resize buttons throughout gala at a
         * size of 36px
         *
         * @return the resize button pixbuf or null if it failed to load
         */
GdkPixbuf*
gala_utils_get_resize_button_pixbuf (gfloat scale)
{
	gint height = 0;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	GdkPixbuf* _tmp4_;
	gboolean _tmp5_;
	GeeHashMap* _tmp11_;
	gpointer _tmp12_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	height = gala_utils_scale_to_int (36, scale);
	_tmp0_ = gala_utils_resize_pixbufs;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (gala_utils_resize_pixbufs);
		gala_utils_resize_pixbufs = _tmp1_;
	}
	_tmp2_ = gala_utils_resize_pixbufs;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) height));
	_tmp4_ = (GdkPixbuf*) _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		{
			GdkPixbuf* _tmp6_ = NULL;
			GdkPixbuf* _tmp7_;
			GeeHashMap* _tmp8_;
			_tmp7_ = gdk_pixbuf_new_from_resource_at_scale (RESOURCEPATH "/buttons/resize.svg", -1, height, TRUE, &_inner_error0_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = gala_utils_resize_pixbufs;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, (gpointer) ((gintptr) height), _tmp6_);
			_g_object_unref0 (_tmp6_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("Utils.vala:362: %s", _tmp10_);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = gala_utils_resize_pixbufs;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((gintptr) height));
	result = (GdkPixbuf*) _tmp12_;
	return result;
}

/**
         * Creates a new reactive ClutterActor at 36px with the resize pixbuf
         *
         * @return The resize button actor
         */
ClutterActor*
gala_utils_create_resize_button (gfloat scale)
{
	ClutterActor* texture = NULL;
	ClutterActor* _tmp0_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp1_;
	ClutterActor* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	ClutterActor* result;
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	texture = _tmp0_;
	_tmp1_ = gala_utils_get_resize_button_pixbuf (scale);
	pixbuf = _tmp1_;
	_tmp2_ = texture;
	clutter_actor_set_reactive (_tmp2_, TRUE);
	_tmp3_ = pixbuf;
	if (_tmp3_ != NULL) {
		{
			ClutterImage* image = NULL;
			ClutterImage* _tmp4_;
			CoglPixelFormat _tmp5_ = 0;
			GdkPixbuf* _tmp6_;
			CoglPixelFormat pixel_format = 0;
			ClutterImage* _tmp7_;
			GdkPixbuf* _tmp8_;
			guint8* _tmp9_;
			GdkPixbuf* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			GdkPixbuf* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			GdkPixbuf* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ClutterActor* _tmp19_;
			ClutterImage* _tmp20_;
			ClutterActor* _tmp21_;
			GdkPixbuf* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			GdkPixbuf* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp4_ = (ClutterImage*) clutter_image_new ();
			image = _tmp4_;
			_tmp6_ = pixbuf;
			if (gdk_pixbuf_get_has_alpha (_tmp6_)) {
				_tmp5_ = COGL_PIXEL_FORMAT_RGBA_8888;
			} else {
				_tmp5_ = COGL_PIXEL_FORMAT_RGB_888;
			}
			pixel_format = _tmp5_;
			_tmp7_ = image;
			_tmp8_ = pixbuf;
			_tmp9_ = gdk_pixbuf_get_pixels (_tmp8_);
			_tmp10_ = pixbuf;
			_tmp11_ = gdk_pixbuf_get_width (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = pixbuf;
			_tmp14_ = gdk_pixbuf_get_height (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = pixbuf;
			_tmp17_ = gdk_pixbuf_get_rowstride (_tmp16_);
			_tmp18_ = _tmp17_;
			clutter_image_set_data (_tmp7_, _tmp9_, pixel_format, (guint) _tmp12_, (guint) _tmp15_, (guint) _tmp18_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (image);
				goto __catch0_g_error;
			}
			_tmp19_ = texture;
			_tmp20_ = image;
			clutter_actor_set_content (_tmp19_, (ClutterContent*) _tmp20_);
			_tmp21_ = texture;
			_tmp22_ = pixbuf;
			_tmp23_ = gdk_pixbuf_get_width (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = pixbuf;
			_tmp26_ = gdk_pixbuf_get_height (_tmp25_);
			_tmp27_ = _tmp26_;
			clutter_actor_set_size (_tmp21_, (gfloat) _tmp24_, (gfloat) _tmp27_);
			_g_object_unref0 (image);
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			_g_object_unref0 (texture);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	} else {
		gint size = 0;
		ClutterActor* _tmp28_;
		ClutterActor* _tmp29_;
		ClutterColor _tmp30_ = {0};
		size = gala_utils_scale_to_int (36, scale);
		_tmp28_ = texture;
		clutter_actor_set_size (_tmp28_, (gfloat) size, (gfloat) size);
		_tmp29_ = texture;
		_tmp30_.red = (guint8) 255;
		_tmp30_.green = (guint8) 0;
		_tmp30_.blue = (guint8) 0;
		_tmp30_.alpha = (guint8) 255;
		clutter_actor_set_background_color (_tmp29_, &_tmp30_);
	}
	result = texture;
	_g_object_unref0 (pixbuf);
	return result;
}

GtkCssProvider*
gala_utils_get_gala_css (void)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp3_;
	GtkCssProvider* result;
	_tmp0_ = gala_utils_gala_css;
	if (_tmp0_ == NULL) {
		GtkCssProvider* _tmp1_;
		GtkCssProvider* _tmp2_;
		_tmp1_ = gtk_css_provider_new ();
		_g_object_unref0 (gala_utils_gala_css);
		gala_utils_gala_css = _tmp1_;
		_tmp2_ = gala_utils_gala_css;
		gtk_css_provider_load_from_resource (_tmp2_, "/io/elementary/desktop/gala/gala.css");
	}
	_tmp3_ = gala_utils_gala_css;
	result = _tmp3_;
	return result;
}

GalaUtils*
gala_utils_construct (GType object_type)
{
	GalaUtils* self = NULL;
	self = (GalaUtils*) g_type_create_instance (object_type);
	return self;
}

GalaUtils*
gala_utils_new (void)
{
	return gala_utils_construct (GALA_TYPE_UTILS);
}

static void
gala_utils_cached_icon_copy (const GalaUtilsCachedIcon* self,
                             GalaUtilsCachedIcon* dest)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	_tmp0_ = (*self).icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).icon);
	(*dest).icon = _tmp1_;
	(*dest).icon_size = (*self).icon_size;
	(*dest).scale = (*self).scale;
}

static void
gala_utils_cached_icon_destroy (GalaUtilsCachedIcon* self)
{
	_g_object_unref0 ((*self).icon);
}

static GalaUtilsCachedIcon*
gala_utils_cached_icon_dup (const GalaUtilsCachedIcon* self)
{
	GalaUtilsCachedIcon* dup;
	dup = g_new0 (GalaUtilsCachedIcon, 1);
	gala_utils_cached_icon_copy (self, dup);
	return dup;
}

static void
gala_utils_cached_icon_free (GalaUtilsCachedIcon* self)
{
	gala_utils_cached_icon_destroy (self);
	g_free (self);
}

static GType
gala_utils_cached_icon_get_type_once (void)
{
	GType gala_utils_cached_icon_type_id;
	gala_utils_cached_icon_type_id = g_boxed_type_register_static ("GalaUtilsCachedIcon", (GBoxedCopyFunc) gala_utils_cached_icon_dup, (GBoxedFreeFunc) gala_utils_cached_icon_free);
	return gala_utils_cached_icon_type_id;
}

static GType
gala_utils_cached_icon_get_type (void)
{
	static volatile gsize gala_utils_cached_icon_type_id__once = 0;
	if (g_once_init_enter (&gala_utils_cached_icon_type_id__once)) {
		GType gala_utils_cached_icon_type_id;
		gala_utils_cached_icon_type_id = gala_utils_cached_icon_get_type_once ();
		g_once_init_leave (&gala_utils_cached_icon_type_id__once, gala_utils_cached_icon_type_id);
	}
	return gala_utils_cached_icon_type_id__once;
}

static void
_gala_utils___lambda10_ (void)
{
	GeeHashMultiMap* _tmp0_;
	GeeHashMap* _tmp1_;
	_tmp0_ = gala_utils_icon_cache;
	gee_multi_map_clear ((GeeMultiMap*) _tmp0_);
	_tmp1_ = gala_utils_window_to_desktop_cache;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
}

static void
__gala_utils___lambda10__gala_app_cache_changed (GalaAppCache* _sender,
                                                 gpointer self)
{
	_gala_utils___lambda10_ ();
}

static void
gala_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_utils_unref (value->data[0].v_pointer);
	}
}

static void
gala_value_utils_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_value_utils_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_value_utils_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	GalaUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gala_param_spec_utils (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	GalaParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gala_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
gala_value_set_utils (GValue* value,
                      gpointer v_object)
{
	GalaUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_utils_unref (old);
	}
}

void
gala_value_take_utils (GValue* value,
                       gpointer v_object)
{
	GalaUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_utils_unref (old);
	}
}

static void
gala_utils_class_init (GalaUtilsClass * klass,
                       gpointer klass_data)
{
	GeeHashMultiMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeArrayList* _tmp2_;
	GalaAppCache* _tmp3_;
	GalaAppCache* _tmp4_;
	gala_utils_parent_class = g_type_class_peek_parent (klass);
	((GalaUtilsClass *) klass)->finalize = gala_utils_finalize;
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_DESKTOP_APP_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GALA_UTILS_TYPE_CACHED_ICON, (GBoxedCopyFunc) gala_utils_cached_icon_dup, (GDestroyNotify) gala_utils_cached_icon_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gala_utils_icon_cache);
	gala_utils_icon_cache = _tmp0_;
	_tmp1_ = gee_hash_map_new (meta_window_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_DESKTOP_APP_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gala_utils_window_to_desktop_cache);
	gala_utils_window_to_desktop_cache = _tmp1_;
	_tmp2_ = gee_array_list_new (GALA_UTILS_TYPE_CACHED_ICON, (GBoxedCopyFunc) gala_utils_cached_icon_dup, (GDestroyNotify) gala_utils_cached_icon_free, NULL, NULL, NULL);
	_g_object_unref0 (gala_utils_unknown_icon_cache);
	gala_utils_unknown_icon_cache = _tmp2_;
	_tmp3_ = gala_app_cache_new ();
	_g_object_unref0 (gala_utils_app_cache);
	gala_utils_app_cache = _tmp3_;
	_tmp4_ = gala_utils_app_cache;
	g_signal_connect (_tmp4_, "changed", (GCallback) __gala_utils___lambda10__gala_app_cache_changed, NULL);
}

static void
gala_utils_instance_init (GalaUtils * self,
                          gpointer klass)
{
	self->ref_count = 1;
}

static void
gala_utils_finalize (GalaUtils * obj)
{
	GalaUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_UTILS, GalaUtils);
	g_signal_handlers_destroy (self);
}

static GType
gala_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_value_utils_init, gala_value_utils_free_value, gala_value_utils_copy_value, gala_value_utils_peek_pointer, "p", gala_value_utils_collect_value, "p", gala_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaUtils), 0, (GInstanceInitFunc) gala_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_utils_type_id;
	gala_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gala_utils_type_id;
}

GType
gala_utils_get_type (void)
{
	static volatile gsize gala_utils_type_id__once = 0;
	if (g_once_init_enter (&gala_utils_type_id__once)) {
		GType gala_utils_type_id;
		gala_utils_type_id = gala_utils_get_type_once ();
		g_once_init_leave (&gala_utils_type_id__once, gala_utils_type_id);
	}
	return gala_utils_type_id__once;
}

gpointer
gala_utils_ref (gpointer instance)
{
	GalaUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gala_utils_unref (gpointer instance)
{
	GalaUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

