/* ShadowEffect.c generated by valac 0.56.16, the Vala compiler
 * generated from ShadowEffect.vala, do not modify */

/*
 * Copyright 2014 Tom Beckmann
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <cogl/cogl.h>
#include <clutter/clutter.h>
#include <gee.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <graphene-gobject.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_SHADOW_EFFECT_0_PROPERTY,
	GALA_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY,
	GALA_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY,
	GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY,
	GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY,
	GALA_SHADOW_EFFECT_NUM_PROPERTIES
};
static GParamSpec* gala_shadow_effect_properties[GALA_SHADOW_EFFECT_NUM_PROPERTIES];

#define GALA_SHADOW_EFFECT_TYPE_SHADOW (gala_shadow_effect_shadow_get_type ())
#define GALA_SHADOW_EFFECT_SHADOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_SHADOW_EFFECT_TYPE_SHADOW, GalaShadowEffectShadow))
#define GALA_SHADOW_EFFECT_SHADOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_SHADOW_EFFECT_TYPE_SHADOW, GalaShadowEffectShadowClass))
#define GALA_SHADOW_EFFECT_IS_SHADOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_SHADOW_EFFECT_TYPE_SHADOW))
#define GALA_SHADOW_EFFECT_IS_SHADOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_SHADOW_EFFECT_TYPE_SHADOW))
#define GALA_SHADOW_EFFECT_SHADOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_SHADOW_EFFECT_TYPE_SHADOW, GalaShadowEffectShadowClass))

typedef struct _GalaShadowEffectShadow GalaShadowEffectShadow;
typedef struct _GalaShadowEffectShadowClass GalaShadowEffectShadowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
#define _gala_shadow_effect_shadow_unref0(var) ((var == NULL) ? NULL : (var = (gala_shadow_effect_shadow_unref (var), NULL)))
typedef struct _GalaShadowEffectShadowPrivate GalaShadowEffectShadowPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GalaShadowEffectParamSpecShadow GalaShadowEffectParamSpecShadow;

struct _GalaShadowEffectPrivate {
	gint _shadow_size;
	gfloat _scale_factor;
	guint8 _shadow_opacity;
	gchar* _css_class;
	CoglPipeline* pipeline;
	gchar* current_key;
};

struct _GalaShadowEffectShadow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaShadowEffectShadowPrivate * priv;
	gint users;
	CoglTexture* texture;
};

struct _GalaShadowEffectShadowClass {
	GTypeClass parent_class;
	void (*finalize) (GalaShadowEffectShadow *self);
};

struct _GalaShadowEffectParamSpecShadow {
	GParamSpec parent_instance;
};

static gint GalaShadowEffect_private_offset;
static gpointer gala_shadow_effect_parent_class = NULL;
static GeeHashMap* gala_shadow_effect_shadow_cache;
static GeeHashMap* gala_shadow_effect_shadow_cache = NULL;
static GOnce gala_shadow_effect__style_context;
static GOnce gala_shadow_effect__style_context = G_ONCE_INIT;
static gpointer gala_shadow_effect_shadow_parent_class = NULL;

static void gala_shadow_effect_decrement_shadow_users (GalaShadowEffect* self,
                                                const gchar* key);
static gpointer gala_shadow_effect_shadow_ref (gpointer instance);
static void gala_shadow_effect_shadow_unref (gpointer instance);
static GParamSpec* gala_shadow_effect_param_spec_shadow (const gchar* name,
                                                  const gchar* nick,
                                                  const gchar* blurb,
                                                  GType object_type,
                                                  GParamFlags flags) G_GNUC_UNUSED ;
static void gala_shadow_effect_value_set_shadow (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED ;
static void gala_shadow_effect_value_take_shadow (GValue* value,
                                           gpointer v_object) G_GNUC_UNUSED ;
static gpointer gala_shadow_effect_value_get_shadow (const GValue* value) G_GNUC_UNUSED ;
static GType gala_shadow_effect_shadow_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GtkStyleContext* gala_shadow_effect_create_style_context (void);
static CoglTexture* gala_shadow_effect_get_shadow (GalaShadowEffect* self,
                                            CoglContext* context,
                                            gint width,
                                            gint height,
                                            gint shadow_size);
static gpointer _gala_shadow_effect_create_style_context_gthread_func (gpointer self);
static GalaShadowEffectShadow* gala_shadow_effect_shadow_new (CoglTexture* _texture);
static GalaShadowEffectShadow* gala_shadow_effect_shadow_construct (GType object_type,
                                                             CoglTexture* _texture);
static void gala_shadow_effect_real_paint (ClutterEffect* base,
                                    ClutterPaintNode* node,
                                    ClutterPaintContext* context,
                                    ClutterEffectPaintFlags flags);
static void gala_shadow_effect_real_get_bounding_box (GalaShadowEffect* self,
                                               ClutterActorBox* result);
static gboolean gala_shadow_effect_real_modify_paint_volume (ClutterEffect* base,
                                                      ClutterPaintVolume* volume);
static void gala_shadow_effect_shadow_finalize (GalaShadowEffectShadow * obj);
static GType gala_shadow_effect_shadow_get_type_once (void);
static GObject * gala_shadow_effect_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void gala_shadow_effect_finalize (GObject * obj);
static GType gala_shadow_effect_get_type_once (void);
static void _vala_gala_shadow_effect_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_gala_shadow_effect_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
gala_shadow_effect_get_instance_private (GalaShadowEffect* self)
{
	return G_STRUCT_MEMBER_P (self, GalaShadowEffect_private_offset);
}

static GtkStyleContext*
gala_shadow_effect_create_style_context (void)
{
	GtkWidgetPath* style_path = NULL;
	GtkWidgetPath* _tmp0_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp1_;
	GtkCssProvider* _tmp2_;
	GtkStyleContext* result;
	_tmp0_ = gtk_widget_path_new ();
	style_path = _tmp0_;
	gtk_widget_path_append_type (style_path, gtk_window_get_type ());
	_tmp1_ = gtk_style_context_new ();
	style_context = _tmp1_;
	_tmp2_ = gala_utils_get_gala_css ();
	gtk_style_context_add_provider (style_context, (GtkStyleProvider*) _tmp2_, (guint) GTK_STYLE_PROVIDER_PRIORITY_FALLBACK);
	gtk_style_context_add_class (style_context, "decoration");
	gtk_style_context_set_path (style_context, style_path);
	result = style_context;
	_gtk_widget_path_unref0 (style_path);
	return result;
}

GalaShadowEffect*
gala_shadow_effect_construct (GType object_type,
                              gint shadow_size)
{
	GalaShadowEffect * self = NULL;
	self = (GalaShadowEffect*) g_object_new (object_type, "shadow-size", shadow_size, NULL);
	return self;
}

GalaShadowEffect*
gala_shadow_effect_new (gint shadow_size)
{
	return gala_shadow_effect_construct (GALA_TYPE_SHADOW_EFFECT, shadow_size);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_gala_shadow_effect_create_style_context_gthread_func (gpointer self)
{
	gpointer result;
	result = gala_shadow_effect_create_style_context ();
	return result;
}

static CoglTexture*
gala_shadow_effect_get_shadow (GalaShadowEffect* self,
                               CoglContext* context,
                               gint width,
                               gint height,
                               gint shadow_size)
{
	gchar* old_key = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GalaShadowEffectShadow* shadow = NULL;
	GeeHashMap* _tmp7_;
	const gchar* _tmp8_;
	gpointer _tmp9_;
	GalaShadowEffectShadow* _tmp10_;
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp16_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp17_;
	cairo_t* _tmp18_;
	cairo_t* _tmp19_;
	cairo_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	gfloat _tmp24_;
	gfloat _tmp25_;
	GtkStyleContext* style_context = NULL;
	gconstpointer _tmp26_;
	GtkStyleContext* _tmp27_;
	const gchar* _tmp28_;
	GtkStyleContext* _tmp31_;
	gfloat _tmp32_;
	gfloat size = 0.0F;
	gfloat _tmp33_;
	GtkStyleContext* _tmp34_;
	cairo_t* _tmp35_;
	gfloat _tmp36_;
	gfloat _tmp37_;
	GtkStyleContext* _tmp38_;
	cairo_t* _tmp39_;
	cairo_t* _tmp40_;
	GError* _inner_error0_ = NULL;
	CoglTexture* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	_tmp0_ = self->priv->current_key;
	_tmp1_ = g_strdup (_tmp0_);
	old_key = _tmp1_;
	_tmp2_ = g_strdup_printf ("%ix%i:%i", width, height, shadow_size);
	_g_free0 (self->priv->current_key);
	self->priv->current_key = _tmp2_;
	_tmp3_ = old_key;
	_tmp4_ = self->priv->current_key;
	if (g_strcmp0 (_tmp3_, _tmp4_) == 0) {
		result = NULL;
		_g_free0 (old_key);
		return result;
	}
	_tmp5_ = old_key;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = old_key;
		gala_shadow_effect_decrement_shadow_users (self, _tmp6_);
	}
	shadow = NULL;
	_tmp7_ = gala_shadow_effect_shadow_cache;
	_tmp8_ = self->priv->current_key;
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, _tmp8_);
	_gala_shadow_effect_shadow_unref0 (shadow);
	shadow = (GalaShadowEffectShadow*) _tmp9_;
	_tmp10_ = shadow;
	if (_tmp10_ != NULL) {
		GalaShadowEffectShadow* _tmp11_;
		gint _tmp12_;
		GalaShadowEffectShadow* _tmp13_;
		CoglTexture* _tmp14_;
		CoglTexture* _tmp15_;
		_tmp11_ = shadow;
		_tmp12_ = _tmp11_->users;
		_tmp11_->users = _tmp12_ + 1;
		_tmp13_ = shadow;
		_tmp14_ = _tmp13_->texture;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		result = _tmp15_;
		_gala_shadow_effect_shadow_unref0 (shadow);
		_g_free0 (old_key);
		return result;
	}
	_tmp16_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
	surface = _tmp16_;
	_tmp17_ = surface;
	_tmp18_ = cairo_create (_tmp17_);
	cr = _tmp18_;
	_tmp19_ = cr;
	cairo_set_source_rgba (_tmp19_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp20_ = cr;
	cairo_fill (_tmp20_);
	_tmp21_ = cr;
	cairo_set_operator (_tmp21_, CAIRO_OPERATOR_OVER);
	_tmp22_ = cr;
	cairo_save (_tmp22_);
	_tmp23_ = cr;
	_tmp24_ = self->priv->_scale_factor;
	_tmp25_ = self->priv->_scale_factor;
	cairo_scale (_tmp23_, (gdouble) _tmp24_, (gdouble) _tmp25_);
	_tmp26_ = g_once (&gala_shadow_effect__style_context, _gala_shadow_effect_create_style_context_gthread_func, NULL);
	style_context = (GtkStyleContext*) _tmp26_;
	_tmp27_ = style_context;
	gtk_style_context_save (_tmp27_);
	_tmp28_ = self->priv->_css_class;
	if (_tmp28_ != NULL) {
		GtkStyleContext* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = style_context;
		_tmp30_ = self->priv->_css_class;
		gtk_style_context_add_class (_tmp29_, _tmp30_);
	}
	_tmp31_ = style_context;
	_tmp32_ = self->priv->_scale_factor;
	gtk_style_context_set_scale (_tmp31_, (gint) round ((gdouble) _tmp32_));
	_tmp33_ = self->priv->_scale_factor;
	size = shadow_size * _tmp33_;
	_tmp34_ = style_context;
	_tmp35_ = cr;
	_tmp36_ = self->priv->_scale_factor;
	_tmp37_ = self->priv->_scale_factor;
	gtk_render_background (_tmp34_, _tmp35_, (gdouble) shadow_size, (gdouble) shadow_size, (gdouble) ((width - (size * 2)) / _tmp36_), (gdouble) ((height - (size * 2)) / _tmp37_));
	_tmp38_ = style_context;
	gtk_style_context_restore (_tmp38_);
	_tmp39_ = cr;
	cairo_restore (_tmp39_);
	_tmp40_ = cr;
	cairo_paint (_tmp40_);
	{
		CoglTexture2D* texture = NULL;
		cairo_surface_t* _tmp41_;
		cairo_surface_t* _tmp42_;
		guchar* _tmp43_;
		CoglTexture2D* _tmp44_;
		GeeHashMap* _tmp45_;
		const gchar* _tmp46_;
		CoglTexture2D* _tmp47_;
		GalaShadowEffectShadow* _tmp48_;
		GalaShadowEffectShadow* _tmp49_;
		_tmp41_ = surface;
		_tmp42_ = surface;
		_tmp43_ = cairo_image_surface_get_data (_tmp42_);
		_tmp44_ = (CoglTexture2D*) cogl_texture_2d_new_from_data (context, width, height, COGL_PIXEL_FORMAT_BGRA_8888_PRE, cairo_image_surface_get_stride (_tmp41_), _tmp43_, &_inner_error0_);
		texture = _tmp44_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp45_ = gala_shadow_effect_shadow_cache;
		_tmp46_ = self->priv->current_key;
		_tmp47_ = texture;
		_tmp48_ = gala_shadow_effect_shadow_new ((CoglTexture*) _tmp47_);
		_tmp49_ = _tmp48_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp45_, _tmp46_, _tmp49_);
		_gala_shadow_effect_shadow_unref0 (_tmp49_);
		result = (CoglTexture*) texture;
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (surface);
		_gala_shadow_effect_shadow_unref0 (shadow);
		_g_free0 (old_key);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp50_;
		const gchar* _tmp51_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp50_ = e;
		_tmp51_ = _tmp50_->message;
		g_debug ("ShadowEffect.vala:109: %s", _tmp51_);
		result = NULL;
		_g_error_free0 (e);
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (surface);
		_gala_shadow_effect_shadow_unref0 (shadow);
		_g_free0 (old_key);
		return result;
	}
	__finally0:
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	_gala_shadow_effect_shadow_unref0 (shadow);
	_g_free0 (old_key);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
gala_shadow_effect_decrement_shadow_users (GalaShadowEffect* self,
                                           const gchar* key)
{
	GalaShadowEffectShadow* shadow = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GalaShadowEffectShadow* _tmp2_;
	GalaShadowEffectShadow* _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = gala_shadow_effect_shadow_cache;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, key);
	shadow = (GalaShadowEffectShadow*) _tmp1_;
	_tmp2_ = shadow;
	if (_tmp2_ == NULL) {
		_gala_shadow_effect_shadow_unref0 (shadow);
		return;
	}
	_tmp3_ = shadow;
	_tmp3_->users = _tmp3_->users - 1;
	_tmp4_ = _tmp3_->users;
	if (_tmp4_ == 0) {
		GeeHashMap* _tmp5_;
		_tmp5_ = gala_shadow_effect_shadow_cache;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, key, NULL);
	}
	_gala_shadow_effect_shadow_unref0 (shadow);
}

static void
gala_shadow_effect_real_paint (ClutterEffect* base,
                               ClutterPaintNode* node,
                               ClutterPaintContext* context,
                               ClutterEffectPaintFlags flags)
{
	GalaShadowEffect * self;
	ClutterActorBox bounding_box = {0};
	ClutterActorBox _tmp0_ = {0};
	gint width = 0;
	ClutterActorBox _tmp1_;
	ClutterActorBox _tmp2_;
	gint height = 0;
	ClutterActorBox _tmp3_;
	ClutterActorBox _tmp4_;
	CoglTexture* shadow = NULL;
	CoglFramebuffer* _tmp5_;
	CoglContext* _tmp6_;
	gint _tmp7_;
	CoglTexture* _tmp8_;
	CoglTexture* _tmp9_;
	gfloat opacity = 0.0F;
	ClutterActor* _tmp12_;
	ClutterActor* _tmp13_;
	guint8 _tmp14_;
	CoglColor alpha = {0};
	CoglPipeline* _tmp15_;
	CoglColor _tmp16_;
	CoglFramebuffer* _tmp17_;
	CoglPipeline* _tmp18_;
	ClutterActorBox _tmp19_;
	ClutterActorBox _tmp20_;
	ClutterActorBox _tmp21_;
	ClutterActorBox _tmp22_;
	ClutterActor* _tmp23_;
	ClutterActor* _tmp24_;
	self = (GalaShadowEffect*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (context != NULL);
	gala_shadow_effect_get_bounding_box (self, &_tmp0_);
	bounding_box = _tmp0_;
	_tmp1_ = bounding_box;
	_tmp2_ = bounding_box;
	width = (gint) (_tmp1_.x2 - _tmp2_.x1);
	_tmp3_ = bounding_box;
	_tmp4_ = bounding_box;
	height = (gint) (_tmp3_.y2 - _tmp4_.y1);
	_tmp5_ = clutter_paint_context_get_framebuffer (context);
	_tmp6_ = cogl_framebuffer_get_context (_tmp5_);
	_tmp7_ = self->priv->_shadow_size;
	_tmp8_ = gala_shadow_effect_get_shadow (self, _tmp6_, width, height, _tmp7_);
	shadow = _tmp8_;
	_tmp9_ = shadow;
	if (_tmp9_ != NULL) {
		CoglPipeline* _tmp10_;
		CoglTexture* _tmp11_;
		_tmp10_ = self->priv->pipeline;
		_tmp11_ = shadow;
		cogl_pipeline_set_layer_texture (_tmp10_, 0, _tmp11_);
	}
	_tmp12_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->_shadow_opacity;
	opacity = (clutter_actor_get_paint_opacity (_tmp13_) * _tmp14_) / 255.0f;
	cogl_color_init_from_4f (&alpha, 1.0f, 1.0f, 1.0f, opacity / 255.0f);
	cogl_color_premultiply (&alpha);
	_tmp15_ = self->priv->pipeline;
	_tmp16_ = alpha;
	cogl_pipeline_set_color (_tmp15_, &_tmp16_);
	_tmp17_ = clutter_paint_context_get_framebuffer (context);
	_tmp18_ = self->priv->pipeline;
	_tmp19_ = bounding_box;
	_tmp20_ = bounding_box;
	_tmp21_ = bounding_box;
	_tmp22_ = bounding_box;
	cogl_framebuffer_draw_rectangle (_tmp17_, _tmp18_, _tmp19_.x1, _tmp20_.y1, _tmp21_.x2, _tmp22_.y2);
	_tmp23_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp24_ = _tmp23_;
	clutter_actor_continue_paint (_tmp24_, context);
	_g_object_unref0 (shadow);
}

static void
gala_shadow_effect_real_get_bounding_box (GalaShadowEffect* self,
                                          ClutterActorBox* result)
{
	gfloat size = 0.0F;
	gint _tmp0_;
	gfloat _tmp1_;
	ClutterActorBox bounding_box = {0};
	ClutterActor* _tmp2_;
	ClutterActor* _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	gfloat _tmp8_;
	gfloat _tmp9_;
	_tmp0_ = self->priv->_shadow_size;
	_tmp1_ = self->priv->_scale_factor;
	size = _tmp0_ * _tmp1_;
	memset (&bounding_box, 0, sizeof (ClutterActorBox));
	clutter_actor_box_set_origin (&bounding_box, -size, -size);
	_tmp2_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = clutter_actor_get_width (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = clutter_actor_meta_get_actor ((ClutterActorMeta*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = clutter_actor_get_height (_tmp7_);
	_tmp9_ = _tmp8_;
	clutter_actor_box_set_size (&bounding_box, _tmp5_ + (size * 2), _tmp9_ + (size * 2));
	*result = bounding_box;
	return;
}

void
gala_shadow_effect_get_bounding_box (GalaShadowEffect* self,
                                     ClutterActorBox* result)
{
	GalaShadowEffectClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_SHADOW_EFFECT_GET_CLASS (self);
	if (_klass_->get_bounding_box) {
		_klass_->get_bounding_box (self, result);
	}
}

static gboolean
gala_shadow_effect_real_modify_paint_volume (ClutterEffect* base,
                                             ClutterPaintVolume* volume)
{
	GalaShadowEffect * self;
	ClutterActorBox bounding_box = {0};
	ClutterActorBox _tmp0_ = {0};
	gfloat origin_x = 0.0F;
	gfloat origin_y = 0.0F;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	graphene_point3d_t origin = {0};
	graphene_point3d_t _tmp3_ = {0};
	graphene_point3d_t _tmp4_;
	gboolean result;
	self = (GalaShadowEffect*) base;
	g_return_val_if_fail (volume != NULL, FALSE);
	gala_shadow_effect_get_bounding_box (self, &_tmp0_);
	bounding_box = _tmp0_;
	clutter_paint_volume_set_width (volume, clutter_actor_box_get_width (&bounding_box));
	clutter_paint_volume_set_height (volume, clutter_actor_box_get_height (&bounding_box));
	clutter_actor_box_get_origin (&bounding_box, &_tmp1_, &_tmp2_);
	origin_x = _tmp1_;
	origin_y = _tmp2_;
	clutter_paint_volume_get_origin (volume, &_tmp3_);
	origin = _tmp3_;
	origin.x = origin.x + origin_x;
	origin.y = origin.y + origin_y;
	_tmp4_ = origin;
	clutter_paint_volume_set_origin (volume, &_tmp4_);
	result = TRUE;
	return result;
}

gint
gala_shadow_effect_get_shadow_size (GalaShadowEffect* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_shadow_size;
	return result;
}

static void
gala_shadow_effect_set_shadow_size (GalaShadowEffect* self,
                                    gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shadow_effect_get_shadow_size (self);
	if (old_value != value) {
		self->priv->_shadow_size = value;
		g_object_notify_by_pspec ((GObject *) self, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY]);
	}
}

gfloat
gala_shadow_effect_get_scale_factor (GalaShadowEffect* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_scale_factor;
	return result;
}

void
gala_shadow_effect_set_scale_factor (GalaShadowEffect* self,
                                     gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shadow_effect_get_scale_factor (self);
	if (old_value != value) {
		self->priv->_scale_factor = value;
		g_object_notify_by_pspec ((GObject *) self, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY]);
	}
}

guint8
gala_shadow_effect_get_shadow_opacity (GalaShadowEffect* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_shadow_opacity;
	return result;
}

void
gala_shadow_effect_set_shadow_opacity (GalaShadowEffect* self,
                                       guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shadow_effect_get_shadow_opacity (self);
	if (old_value != value) {
		self->priv->_shadow_opacity = value;
		g_object_notify_by_pspec ((GObject *) self, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY]);
	}
}

const gchar*
gala_shadow_effect_get_css_class (GalaShadowEffect* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_css_class;
	result = _tmp0_;
	return result;
}

void
gala_shadow_effect_set_css_class (GalaShadowEffect* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_shadow_effect_get_css_class (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_css_class);
		self->priv->_css_class = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY]);
	}
}

static GalaShadowEffectShadow*
gala_shadow_effect_shadow_construct (GType object_type,
                                     CoglTexture* _texture)
{
	GalaShadowEffectShadow* self = NULL;
	CoglTexture* _tmp0_;
	g_return_val_if_fail (_texture != NULL, NULL);
	self = (GalaShadowEffectShadow*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (_texture);
	_g_object_unref0 (self->texture);
	self->texture = _tmp0_;
	self->users = 1;
	return self;
}

static GalaShadowEffectShadow*
gala_shadow_effect_shadow_new (CoglTexture* _texture)
{
	return gala_shadow_effect_shadow_construct (GALA_SHADOW_EFFECT_TYPE_SHADOW, _texture);
}

static void
gala_shadow_effect_value_shadow_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_shadow_effect_value_shadow_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_shadow_effect_shadow_unref (value->data[0].v_pointer);
	}
}

static void
gala_shadow_effect_value_shadow_copy_value (const GValue* src_value,
                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_shadow_effect_shadow_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_shadow_effect_value_shadow_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_shadow_effect_value_shadow_collect_value (GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaShadowEffectShadow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_shadow_effect_shadow_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_shadow_effect_value_shadow_lcopy_value (const GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	GalaShadowEffectShadow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_shadow_effect_shadow_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
gala_shadow_effect_param_spec_shadow (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags)
{
	GalaShadowEffectParamSpecShadow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_SHADOW_EFFECT_TYPE_SHADOW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
gala_shadow_effect_value_get_shadow (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_SHADOW_EFFECT_TYPE_SHADOW), NULL);
	return value->data[0].v_pointer;
}

static void
gala_shadow_effect_value_set_shadow (GValue* value,
                                     gpointer v_object)
{
	GalaShadowEffectShadow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_SHADOW_EFFECT_TYPE_SHADOW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_SHADOW_EFFECT_TYPE_SHADOW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_shadow_effect_shadow_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_shadow_effect_shadow_unref (old);
	}
}

static void
gala_shadow_effect_value_take_shadow (GValue* value,
                                      gpointer v_object)
{
	GalaShadowEffectShadow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_SHADOW_EFFECT_TYPE_SHADOW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_SHADOW_EFFECT_TYPE_SHADOW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_shadow_effect_shadow_unref (old);
	}
}

static void
gala_shadow_effect_shadow_class_init (GalaShadowEffectShadowClass * klass,
                                      gpointer klass_data)
{
	gala_shadow_effect_shadow_parent_class = g_type_class_peek_parent (klass);
	((GalaShadowEffectShadowClass *) klass)->finalize = gala_shadow_effect_shadow_finalize;
}

static void
gala_shadow_effect_shadow_instance_init (GalaShadowEffectShadow * self,
                                         gpointer klass)
{
	self->ref_count = 1;
}

static void
gala_shadow_effect_shadow_finalize (GalaShadowEffectShadow * obj)
{
	GalaShadowEffectShadow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_SHADOW_EFFECT_TYPE_SHADOW, GalaShadowEffectShadow);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->texture);
}

static GType
gala_shadow_effect_shadow_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_shadow_effect_value_shadow_init, gala_shadow_effect_value_shadow_free_value, gala_shadow_effect_value_shadow_copy_value, gala_shadow_effect_value_shadow_peek_pointer, "p", gala_shadow_effect_value_shadow_collect_value, "p", gala_shadow_effect_value_shadow_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaShadowEffectShadowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_shadow_effect_shadow_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaShadowEffectShadow), 0, (GInstanceInitFunc) gala_shadow_effect_shadow_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_shadow_effect_shadow_type_id;
	gala_shadow_effect_shadow_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaShadowEffectShadow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gala_shadow_effect_shadow_type_id;
}

static GType
gala_shadow_effect_shadow_get_type (void)
{
	static volatile gsize gala_shadow_effect_shadow_type_id__once = 0;
	if (g_once_init_enter (&gala_shadow_effect_shadow_type_id__once)) {
		GType gala_shadow_effect_shadow_type_id;
		gala_shadow_effect_shadow_type_id = gala_shadow_effect_shadow_get_type_once ();
		g_once_init_leave (&gala_shadow_effect_shadow_type_id__once, gala_shadow_effect_shadow_type_id);
	}
	return gala_shadow_effect_shadow_type_id__once;
}

static gpointer
gala_shadow_effect_shadow_ref (gpointer instance)
{
	GalaShadowEffectShadow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
gala_shadow_effect_shadow_unref (gpointer instance)
{
	GalaShadowEffectShadow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_SHADOW_EFFECT_SHADOW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GObject *
gala_shadow_effect_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaShadowEffect * self;
	ClutterBackend* _tmp0_;
	CoglContext* _tmp1_;
	CoglPipeline* _tmp2_;
	parent_class = G_OBJECT_CLASS (gala_shadow_effect_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect);
	_tmp0_ = clutter_get_default_backend ();
	_tmp1_ = clutter_backend_get_cogl_context (_tmp0_);
	_tmp2_ = cogl_pipeline_new (_tmp1_);
	_g_object_unref0 (self->priv->pipeline);
	self->priv->pipeline = _tmp2_;
	return obj;
}

static void
gala_shadow_effect_class_init (GalaShadowEffectClass * klass,
                               gpointer klass_data)
{
	GeeHashMap* _tmp0_;
	gala_shadow_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaShadowEffect_private_offset);
	((ClutterEffectClass *) klass)->paint = (void (*) (ClutterEffect*, ClutterPaintNode*, ClutterPaintContext*, ClutterEffectPaintFlags)) gala_shadow_effect_real_paint;
	((GalaShadowEffectClass *) klass)->get_bounding_box = (void (*) (GalaShadowEffect*, ClutterActorBox*)) gala_shadow_effect_real_get_bounding_box;
	((ClutterEffectClass *) klass)->modify_paint_volume = (gboolean (*) (ClutterEffect*, ClutterPaintVolume*)) gala_shadow_effect_real_modify_paint_volume;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_shadow_effect_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_shadow_effect_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_shadow_effect_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_shadow_effect_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY] = g_param_spec_int ("shadow-size", "shadow-size", "shadow-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY] = g_param_spec_float ("scale-factor", "scale-factor", "scale-factor", -G_MAXFLOAT, G_MAXFLOAT, (gfloat) 1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY] = g_param_spec_uchar ("shadow-opacity", "shadow-opacity", "shadow-opacity", 0, G_MAXUINT8, (guint8) 255, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY, gala_shadow_effect_properties[GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY] = g_param_spec_string ("css-class", "css-class", "css-class", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GALA_SHADOW_EFFECT_TYPE_SHADOW, (GBoxedCopyFunc) gala_shadow_effect_shadow_ref, (GDestroyNotify) gala_shadow_effect_shadow_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gala_shadow_effect_shadow_cache);
	gala_shadow_effect_shadow_cache = _tmp0_;
}

static void
gala_shadow_effect_instance_init (GalaShadowEffect * self,
                                  gpointer klass)
{
	self->priv = gala_shadow_effect_get_instance_private (self);
	self->priv->_scale_factor = (gfloat) 1;
	self->priv->_shadow_opacity = (guint8) 255;
	self->priv->_css_class = NULL;
	self->priv->current_key = NULL;
}

static void
gala_shadow_effect_finalize (GObject * obj)
{
	GalaShadowEffect * self;
	const gchar* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect);
	_tmp0_ = self->priv->current_key;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->current_key;
		gala_shadow_effect_decrement_shadow_users (self, _tmp1_);
	}
	_g_free0 (self->priv->_css_class);
	_g_object_unref0 (self->priv->pipeline);
	_g_free0 (self->priv->current_key);
	G_OBJECT_CLASS (gala_shadow_effect_parent_class)->finalize (obj);
}

static GType
gala_shadow_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaShadowEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_shadow_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaShadowEffect), 0, (GInstanceInitFunc) gala_shadow_effect_instance_init, NULL };
	GType gala_shadow_effect_type_id;
	gala_shadow_effect_type_id = g_type_register_static (clutter_effect_get_type (), "GalaShadowEffect", &g_define_type_info, 0);
	GalaShadowEffect_private_offset = g_type_add_instance_private (gala_shadow_effect_type_id, sizeof (GalaShadowEffectPrivate));
	return gala_shadow_effect_type_id;
}

GType
gala_shadow_effect_get_type (void)
{
	static volatile gsize gala_shadow_effect_type_id__once = 0;
	if (g_once_init_enter (&gala_shadow_effect_type_id__once)) {
		GType gala_shadow_effect_type_id;
		gala_shadow_effect_type_id = gala_shadow_effect_get_type_once ();
		g_once_init_leave (&gala_shadow_effect_type_id__once, gala_shadow_effect_type_id);
	}
	return gala_shadow_effect_type_id__once;
}

static void
_vala_gala_shadow_effect_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GalaShadowEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect);
	switch (property_id) {
		case GALA_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY:
		g_value_set_int (value, gala_shadow_effect_get_shadow_size (self));
		break;
		case GALA_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY:
		g_value_set_float (value, gala_shadow_effect_get_scale_factor (self));
		break;
		case GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY:
		g_value_set_uchar (value, gala_shadow_effect_get_shadow_opacity (self));
		break;
		case GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY:
		g_value_set_string (value, gala_shadow_effect_get_css_class (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_shadow_effect_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GalaShadowEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_SHADOW_EFFECT, GalaShadowEffect);
	switch (property_id) {
		case GALA_SHADOW_EFFECT_SHADOW_SIZE_PROPERTY:
		gala_shadow_effect_set_shadow_size (self, g_value_get_int (value));
		break;
		case GALA_SHADOW_EFFECT_SCALE_FACTOR_PROPERTY:
		gala_shadow_effect_set_scale_factor (self, g_value_get_float (value));
		break;
		case GALA_SHADOW_EFFECT_SHADOW_OPACITY_PROPERTY:
		gala_shadow_effect_set_shadow_opacity (self, g_value_get_uchar (value));
		break;
		case GALA_SHADOW_EFFECT_CSS_CLASS_PROPERTY:
		gala_shadow_effect_set_css_class (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

