/* Plugin.c generated by valac 0.56.16, the Vala compiler
 * generated from Plugin.vala, do not modify */

/**/
/*  Copyright (C) 2014 Tom Beckmann*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "gala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <mtk/mtk.h>
#include <clutter/clutter.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GALA_PLUGIN_0_PROPERTY,
	GALA_PLUGIN_FREEZE_TRACK_PROPERTY,
	GALA_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* gala_plugin_properties[GALA_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GALA_PLUGIN_REGION_CHANGED_SIGNAL,
	GALA_PLUGIN_NUM_SIGNALS
};
static guint gala_plugin_signals[GALA_PLUGIN_NUM_SIGNALS] = {0};

struct _GalaPluginPrivate {
	MtkRectangle* region;
	gint region_length1;
	gint _region_size_;
	MtkRectangle* _custom_region;
	gint _custom_region_length1;
	gint __custom_region_size_;
	gboolean _freeze_track;
	GList* tracked_actors;
};

static gint GalaPlugin_private_offset;
static gpointer gala_plugin_parent_class = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static MtkRectangle* _vala_array_dup1 (MtkRectangle* self,
                                gssize length);
static void gala_plugin_real_initialize (GalaPlugin* self,
                                  GalaWindowManager* wm);
static void gala_plugin_real_destroy (GalaPlugin* self);
static void gala_plugin_on_actor_allocation_changed (GalaPlugin* self,
                                              GObject* actor_object,
                                              GParamSpec* pspec);
static void _gala_plugin_on_actor_allocation_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static MtkRectangle* _vala_array_dup2 (MtkRectangle* self,
                                gssize length);
static void gala_plugin_finalize (GObject * obj);
static GType gala_plugin_get_type_once (void);
static void _vala_gala_plugin_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_gala_plugin_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GType
gala_plugin_function_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_PLUGIN_FUNCTION_ADDITION, "GALA_PLUGIN_FUNCTION_ADDITION", "addition"}, {GALA_PLUGIN_FUNCTION_WINDOW_SWITCHER, "GALA_PLUGIN_FUNCTION_WINDOW_SWITCHER", "window-switcher"}, {GALA_PLUGIN_FUNCTION_WORKSPACE_VIEW, "GALA_PLUGIN_FUNCTION_WORKSPACE_VIEW", "workspace-view"}, {GALA_PLUGIN_FUNCTION_WINDOW_OVERVIEW, "GALA_PLUGIN_FUNCTION_WINDOW_OVERVIEW", "window-overview"}, {0, NULL, NULL}};
	GType gala_plugin_function_type_id;
	gala_plugin_function_type_id = g_enum_register_static ("GalaPluginFunction", values);
	return gala_plugin_function_type_id;
}

GType
gala_plugin_function_get_type (void)
{
	static volatile gsize gala_plugin_function_type_id__once = 0;
	if (g_once_init_enter (&gala_plugin_function_type_id__once)) {
		GType gala_plugin_function_type_id;
		gala_plugin_function_type_id = gala_plugin_function_get_type_once ();
		g_once_init_leave (&gala_plugin_function_type_id__once, gala_plugin_function_type_id);
	}
	return gala_plugin_function_type_id__once;
}

static GType
gala_load_priority_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_LOAD_PRIORITY_IMMEDIATE, "GALA_LOAD_PRIORITY_IMMEDIATE", "immediate"}, {GALA_LOAD_PRIORITY_DEFERRED, "GALA_LOAD_PRIORITY_DEFERRED", "deferred"}, {0, NULL, NULL}};
	GType gala_load_priority_type_id;
	gala_load_priority_type_id = g_enum_register_static ("GalaLoadPriority", values);
	return gala_load_priority_type_id;
}

GType
gala_load_priority_get_type (void)
{
	static volatile gsize gala_load_priority_type_id__once = 0;
	if (g_once_init_enter (&gala_load_priority_type_id__once)) {
		GType gala_load_priority_type_id;
		gala_load_priority_type_id = gala_load_priority_get_type_once ();
		g_once_init_leave (&gala_load_priority_type_id__once, gala_load_priority_type_id);
	}
	return gala_load_priority_type_id__once;
}

void
gala_plugin_info_copy (const GalaPluginInfo* self,
                       GalaPluginInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).author;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).author);
	(*dest).author = _tmp3_;
	(*dest).plugin_type = (*self).plugin_type;
	(*dest).provides = (*self).provides;
	(*dest).load_priority = (*self).load_priority;
	_tmp4_ = (*self).module_name;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).module_name);
	(*dest).module_name = _tmp5_;
}

void
gala_plugin_info_destroy (GalaPluginInfo* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).author);
	_g_free0 ((*self).module_name);
}

GalaPluginInfo*
gala_plugin_info_dup (const GalaPluginInfo* self)
{
	GalaPluginInfo* dup;
	dup = g_new0 (GalaPluginInfo, 1);
	gala_plugin_info_copy (self, dup);
	return dup;
}

void
gala_plugin_info_free (GalaPluginInfo* self)
{
	gala_plugin_info_destroy (self);
	g_free (self);
}

static GType
gala_plugin_info_get_type_once (void)
{
	GType gala_plugin_info_type_id;
	gala_plugin_info_type_id = g_boxed_type_register_static ("GalaPluginInfo", (GBoxedCopyFunc) gala_plugin_info_dup, (GBoxedFreeFunc) gala_plugin_info_free);
	return gala_plugin_info_type_id;
}

GType
gala_plugin_info_get_type (void)
{
	static volatile gsize gala_plugin_info_type_id__once = 0;
	if (g_once_init_enter (&gala_plugin_info_type_id__once)) {
		GType gala_plugin_info_type_id;
		gala_plugin_info_type_id = gala_plugin_info_get_type_once ();
		g_once_init_leave (&gala_plugin_info_type_id__once, gala_plugin_info_type_id);
	}
	return gala_plugin_info_type_id__once;
}

static inline gpointer
gala_plugin_get_instance_private (GalaPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPlugin_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

MtkRectangle*
gala_plugin_get_region (GalaPlugin* self,
                        gint* result_length1)
{
	MtkRectangle* _tmp0_;
	gint _tmp0__length1;
	MtkRectangle* _tmp1_;
	gint _tmp1__length1;
	MtkRectangle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->region;
	_tmp0__length1 = self->priv->region_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

MtkRectangle*
gala_plugin_get_custom_region (GalaPlugin* self,
                               gint* result_length1)
{
	MtkRectangle* _tmp0_;
	gint _tmp0__length1;
	MtkRectangle* _tmp1_;
	gint _tmp1__length1;
	MtkRectangle* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_custom_region;
	_tmp0__length1 = self->priv->_custom_region_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static MtkRectangle*
_vala_array_dup1 (MtkRectangle* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (MtkRectangle));
	}
	return NULL;
}

void
gala_plugin_set_custom_region (GalaPlugin* self,
                               MtkRectangle* custom_region,
                               gint custom_region_length1)
{
	MtkRectangle* _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (custom_region != NULL) ? _vala_array_dup1 (custom_region, custom_region_length1) : custom_region;
	_tmp0__length1 = custom_region_length1;
	self->priv->_custom_region = (g_free (self->priv->_custom_region), NULL);
	self->priv->_custom_region = _tmp0_;
	self->priv->_custom_region_length1 = _tmp0__length1;
	self->priv->__custom_region_size_ = self->priv->_custom_region_length1;
	gala_plugin_update_region (self);
}

/**
         * Once this method is called you can start adding actors to the stage
         * via the windowmanager instance that is given to you.
         *
         * @param wm The window manager.
         */
static void
gala_plugin_real_initialize (GalaPlugin* self,
                             GalaWindowManager* wm)
{
	g_critical ("Type `%s' does not implement abstract method `gala_plugin_initialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
gala_plugin_initialize (GalaPlugin* self,
                        GalaWindowManager* wm)
{
	GalaPluginClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_PLUGIN_GET_CLASS (self);
	if (_klass_->initialize) {
		_klass_->initialize (self, wm);
	}
}

/**
         * This method is currently not called in the code, however you should
         * still implement it to be compatible whenever we decide to use it.
         * It should make sure that everything your plugin added to the stage
         * is cleaned up.
         */
static void
gala_plugin_real_destroy (GalaPlugin* self)
{
	g_critical ("Type `%s' does not implement abstract method `gala_plugin_destroy'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
gala_plugin_destroy (GalaPlugin* self)
{
	GalaPluginClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GALA_PLUGIN_GET_CLASS (self);
	if (_klass_->destroy) {
		_klass_->destroy (self);
	}
}

/**
         * Listen to changes to the allocation of actor and update the region
         * accordingly. You may add multiple actors, their shapes will be
         * combined when one of them changes.
         *
         * @param actor The actor to be tracked
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gala_plugin_on_actor_allocation_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	gala_plugin_on_actor_allocation_changed ((GalaPlugin*) self, _sender, pspec);
}

void
gala_plugin_track_actor (GalaPlugin* self,
                         ClutterActor* actor)
{
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	_tmp0_ = _g_object_ref0 (actor);
	self->priv->tracked_actors = g_list_prepend (self->priv->tracked_actors, _tmp0_);
	g_signal_connect_object ((GObject*) actor, "notify::allocation", (GCallback) _gala_plugin_on_actor_allocation_changed_g_object_notify, self, 0);
	gala_plugin_update_region (self);
}

/**
         * Stop listening to allocation changes and remove the actor's
         * allocation from the region array.
         *
         * @param actor The actor to stop listening the changes on
         */
static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

void
gala_plugin_untrack_actor (GalaPlugin* self,
                           ClutterActor* actor)
{
	guint _tmp0_;
	GQuark _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	self->priv->tracked_actors = vala_g_list_remove_full (self->priv->tracked_actors, actor, _g_object_unref0_);
	g_signal_parse_name ("notify::allocation", G_TYPE_OBJECT, &_tmp0_, &_tmp1_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) actor, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, _tmp1_, NULL, (GCallback) _gala_plugin_on_actor_allocation_changed_g_object_notify, self);
}

/**
         * You can call this method to force the system to update the region that
         * is used by the window manager. It will automatically upon changes to
         * the custom_region property and when a tracked actor's allocation changes
         * unless freeze_track is set to true. You may need to call this function
         * after setting freeze_track back to false after an animation to make the
         * wm aware of the new position of the actor in question.
         */
static MtkRectangle*
_vala_array_dup2 (MtkRectangle* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (MtkRectangle));
	}
	return NULL;
}

void
gala_plugin_update_region (GalaPlugin* self)
{
	MtkRectangle* custom_region = NULL;
	gint _tmp0_ = 0;
	MtkRectangle* _tmp1_;
	gint custom_region_length1;
	gint _custom_region_size_;
	gboolean has_custom = FALSE;
	MtkRectangle* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	guint len = 0U;
	GList* _tmp5_;
	MtkRectangle* regions = NULL;
	MtkRectangle* _tmp6_;
	gint regions_length1;
	gint _regions_size_;
	gint i = 0;
	GList* _tmp14_;
	MtkRectangle* _tmp30_;
	gint _tmp30__length1;
	MtkRectangle* _tmp31_;
	gint _tmp31__length1;
	g_return_if_fail (self != NULL);
	_tmp1_ = gala_plugin_get_custom_region (self, &_tmp0_);
	custom_region = _tmp1_;
	custom_region_length1 = _tmp0_;
	_custom_region_size_ = custom_region_length1;
	_tmp2_ = custom_region;
	_tmp2__length1 = custom_region_length1;
	has_custom = _tmp2_ != NULL;
	if (has_custom) {
		MtkRectangle* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = custom_region;
		_tmp4__length1 = custom_region_length1;
		_tmp3_ = _tmp4__length1;
	} else {
		_tmp3_ = 0;
	}
	_tmp5_ = self->priv->tracked_actors;
	len = g_list_length (_tmp5_) + _tmp3_;
	_tmp6_ = g_new0 (MtkRectangle, len);
	regions = _tmp6_;
	regions_length1 = len;
	_regions_size_ = regions_length1;
	i = 0;
	if (has_custom) {
		{
			gint j = 0;
			j = 0;
			{
				gboolean _tmp7_ = FALSE;
				_tmp7_ = TRUE;
				while (TRUE) {
					MtkRectangle* _tmp9_;
					gint _tmp9__length1;
					MtkRectangle* _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					MtkRectangle* _tmp12_;
					gint _tmp12__length1;
					MtkRectangle _tmp13_;
					if (!_tmp7_) {
						gint _tmp8_;
						_tmp8_ = j;
						j = _tmp8_ + 1;
					}
					_tmp7_ = FALSE;
					_tmp9_ = custom_region;
					_tmp9__length1 = custom_region_length1;
					if (!(j < _tmp9__length1)) {
						break;
					}
					_tmp10_ = regions;
					_tmp10__length1 = regions_length1;
					_tmp11_ = i;
					i = _tmp11_ + 1;
					_tmp12_ = custom_region;
					_tmp12__length1 = custom_region_length1;
					_tmp13_ = _tmp12_[j];
					_tmp10_[_tmp11_] = _tmp13_;
				}
			}
		}
	}
	_tmp14_ = self->priv->tracked_actors;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp14_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* _tmp15_;
			ClutterActor* actor = NULL;
			_tmp15_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
			actor = _tmp15_;
			{
				gfloat x = 0.0F;
				gfloat y = 0.0F;
				gfloat w = 0.0F;
				gfloat h = 0.0F;
				ClutterActor* _tmp16_;
				gfloat _tmp17_ = 0.0F;
				gfloat _tmp18_ = 0.0F;
				ClutterActor* _tmp19_;
				gfloat _tmp20_ = 0.0F;
				gfloat _tmp21_ = 0.0F;
				gboolean _tmp22_ = FALSE;
				MtkRectangle* _tmp23_;
				gint _tmp23__length1;
				gint _tmp24_;
				gfloat _tmp25_;
				gfloat _tmp26_;
				gfloat _tmp27_;
				gfloat _tmp28_;
				MtkRectangle _tmp29_ = {0};
				_tmp16_ = actor;
				clutter_actor_get_transformed_position (_tmp16_, &_tmp17_, &_tmp18_);
				x = _tmp17_;
				y = _tmp18_;
				_tmp19_ = actor;
				clutter_actor_get_transformed_size (_tmp19_, &_tmp20_, &_tmp21_);
				w = _tmp20_;
				h = _tmp21_;
				if (w == ((gfloat) 0)) {
					_tmp22_ = TRUE;
				} else {
					_tmp22_ = h == ((gfloat) 0);
				}
				if (_tmp22_) {
					_g_object_unref0 (actor);
					continue;
				}
				_tmp23_ = regions;
				_tmp23__length1 = regions_length1;
				_tmp24_ = i;
				i = _tmp24_ + 1;
				_tmp25_ = x;
				_tmp26_ = y;
				_tmp27_ = w;
				_tmp28_ = h;
				_tmp29_.x = (gint) _tmp25_;
				_tmp29_.y = (gint) _tmp26_;
				_tmp29_.width = (gint) _tmp27_;
				_tmp29_.height = (gint) _tmp28_;
				_tmp23_[_tmp24_] = _tmp29_;
				_g_object_unref0 (actor);
			}
		}
	}
	_tmp30_ = regions;
	_tmp30__length1 = regions_length1;
	_tmp31_ = (_tmp30_ != NULL) ? _vala_array_dup2 (_tmp30_, _tmp30__length1) : _tmp30_;
	_tmp31__length1 = _tmp30__length1;
	self->priv->region = (g_free (self->priv->region), NULL);
	self->priv->region = _tmp31_;
	self->priv->region_length1 = _tmp31__length1;
	self->priv->_region_size_ = self->priv->region_length1;
	g_signal_emit (self, gala_plugin_signals[GALA_PLUGIN_REGION_CHANGED_SIGNAL], 0);
	regions = (g_free (regions), NULL);
}

static void
gala_plugin_on_actor_allocation_changed (GalaPlugin* self,
                                         GObject* actor_object,
                                         GParamSpec* pspec)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor_object != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = gala_plugin_get_freeze_track (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gala_plugin_update_region (self);
	}
}

GalaPlugin*
gala_plugin_construct (GType object_type)
{
	GalaPlugin * self = NULL;
	self = (GalaPlugin*) g_object_new (object_type, NULL);
	return self;
}

gboolean
gala_plugin_get_freeze_track (GalaPlugin* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_freeze_track;
	return result;
}

void
gala_plugin_set_freeze_track (GalaPlugin* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_freeze_track = value;
	if (!self->priv->_freeze_track) {
		gala_plugin_update_region (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_plugin_properties[GALA_PLUGIN_FREEZE_TRACK_PROPERTY]);
}

static void
gala_plugin_class_init (GalaPluginClass * klass,
                        gpointer klass_data)
{
	gala_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPlugin_private_offset);
	((GalaPluginClass *) klass)->initialize = (void (*) (GalaPlugin*, GalaWindowManager*)) gala_plugin_real_initialize;
	((GalaPluginClass *) klass)->destroy = (void (*) (GalaPlugin*)) gala_plugin_real_destroy;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_plugin_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_plugin_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_plugin_finalize;
	/**
	         * Set this property to true while animating an actor if you have tracked
	         * actors to prevent constant recalculations of the regions during an
	         * animation.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGIN_FREEZE_TRACK_PROPERTY, gala_plugin_properties[GALA_PLUGIN_FREEZE_TRACK_PROPERTY] = g_param_spec_boolean ("freeze-track", "freeze-track", "freeze-track", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	         * Emitted when update_region is called. Mainly for internal purposes.
	         */
	gala_plugin_signals[GALA_PLUGIN_REGION_CHANGED_SIGNAL] = g_signal_new ("region-changed", GALA_TYPE_PLUGIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_plugin_instance_init (GalaPlugin * self,
                           gpointer klass)
{
	self->priv = gala_plugin_get_instance_private (self);
	self->priv->_custom_region = NULL;
	self->priv->_custom_region_length1 = 0;
	self->priv->__custom_region_size_ = self->priv->_custom_region_length1;
	self->priv->_freeze_track = FALSE;
	self->priv->tracked_actors = NULL;
}

static void
gala_plugin_finalize (GObject * obj)
{
	GalaPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_PLUGIN, GalaPlugin);
	self->priv->region = (g_free (self->priv->region), NULL);
	self->priv->_custom_region = (g_free (self->priv->_custom_region), NULL);
	(self->priv->tracked_actors == NULL) ? NULL : (self->priv->tracked_actors = (_g_list_free__g_object_unref0_ (self->priv->tracked_actors), NULL));
	G_OBJECT_CLASS (gala_plugin_parent_class)->finalize (obj);
}

/**
     * This class has to be implemented by every plugin.
     * Additionally, the plugin module is required to have a register_plugin
     * function which returns a PluginInfo struct.
     * The plugin_type field has to be the type of your plugin class derived
     * from this class.
     */
static GType
gala_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPlugin), 0, (GInstanceInitFunc) gala_plugin_instance_init, NULL };
	GType gala_plugin_type_id;
	gala_plugin_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaPlugin", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	GalaPlugin_private_offset = g_type_add_instance_private (gala_plugin_type_id, sizeof (GalaPluginPrivate));
	return gala_plugin_type_id;
}

GType
gala_plugin_get_type (void)
{
	static volatile gsize gala_plugin_type_id__once = 0;
	if (g_once_init_enter (&gala_plugin_type_id__once)) {
		GType gala_plugin_type_id;
		gala_plugin_type_id = gala_plugin_get_type_once ();
		g_once_init_leave (&gala_plugin_type_id__once, gala_plugin_type_id);
	}
	return gala_plugin_type_id__once;
}

static void
_vala_gala_plugin_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	GalaPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PLUGIN, GalaPlugin);
	switch (property_id) {
		case GALA_PLUGIN_FREEZE_TRACK_PROPERTY:
		g_value_set_boolean (value, gala_plugin_get_freeze_track (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_plugin_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	GalaPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_PLUGIN, GalaPlugin);
	switch (property_id) {
		case GALA_PLUGIN_FREEZE_TRACK_PROPERTY:
		gala_plugin_set_freeze_track (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

