/* Utilities.c generated by valac 0.56.16, the Vala compiler
 * generated from Utilities.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2011-2013 Maxwell Barvian <maxwell@elementaryos.org>
 * Copyright Robert Dyer
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "gala.h"
#include <cairo-gobject.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_DRAWING_UTILITIES_0_PROPERTY,
	GALA_DRAWING_UTILITIES_NUM_PROPERTIES
};
static GParamSpec* gala_drawing_utilities_properties[GALA_DRAWING_UTILITIES_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

static gpointer gala_drawing_utilities_parent_class = NULL;

static GType gala_drawing_utilities_get_type_once (void);

/**
     * Adds a closed sub-path rounded rectangle of the given size and border radius to the current path
     * at position (x, y) in user-space coordinates.
     *
     * @param cr a {@link Cairo.Context}
     * @param x the X coordinate of the top left corner of the rounded rectangle
     * @param y the Y coordinate to the top left corner of the rounded rectangle
     * @param width the width of the rounded rectangle
     * @param height the height of the rounded rectangle
     * @param radius the border radius of the rounded rectangle
     */
void
gala_drawing_utilities_cairo_rounded_rectangle (cairo_t* cr,
                                                gdouble x,
                                                gdouble y,
                                                gdouble width,
                                                gdouble height,
                                                gdouble radius)
{
	g_return_if_fail (cr != NULL);
	cairo_move_to (cr, x + radius, y);
	cairo_arc (cr, (x + width) - radius, y + radius, radius, G_PI * 1.5, G_PI * 2);
	cairo_arc (cr, (x + width) - radius, (y + height) - radius, radius, (gdouble) 0, G_PI * 0.5);
	cairo_arc (cr, x + radius, (y + height) - radius, radius, G_PI * 0.5, G_PI);
	cairo_arc (cr, x + radius, y + radius, radius, G_PI, G_PI * 1.5);
	cairo_close_path (cr);
}

/**
     * Averages the colors in the {@link Gdk.Pixbuf} and returns it.
     *
     * @param source the {@link Gdk.Pixbuf}
     *
     * @return the {@link Gala.Drawing.Color} containing the averaged color
     */
GalaDrawingColor*
gala_drawing_utilities_average_color (GdkPixbuf* source)
{
	gdouble r_total = 0.0;
	gdouble g_total = 0.0;
	gdouble b_total = 0.0;
	guint8* data_ptr = NULL;
	guint8* _tmp0_;
	gdouble pixels = 0.0;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GalaDrawingColor* _tmp19_;
	GalaDrawingColor* _tmp20_;
	GalaDrawingColor* _tmp21_;
	GalaDrawingColor* _tmp22_;
	GalaDrawingColor* _tmp23_;
	GalaDrawingColor* _tmp24_;
	GalaDrawingColor* result;
	g_return_val_if_fail (source != NULL, NULL);
	r_total = 0.0;
	g_total = 0.0;
	b_total = 0.0;
	_tmp0_ = gdk_pixbuf_get_pixels (source);
	data_ptr = _tmp0_;
	_tmp1_ = gdk_pixbuf_get_height (source);
	_tmp2_ = _tmp1_;
	_tmp3_ = gdk_pixbuf_get_rowstride (source);
	_tmp4_ = _tmp3_;
	_tmp5_ = gdk_pixbuf_get_n_channels (source);
	_tmp6_ = _tmp5_;
	pixels = (gdouble) ((_tmp2_ * _tmp4_) / _tmp6_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				guint8 r = 0U;
				guint8* _tmp9_;
				guint8 _tmp10_;
				guint8 g = 0U;
				guint8* _tmp11_;
				guint8 _tmp12_;
				guint8 b = 0U;
				guint8* _tmp13_;
				guint8 _tmp14_;
				guint8 max = 0U;
				guint8 min = 0U;
				gdouble delta = 0.0;
				gdouble _tmp15_ = 0.0;
				gdouble sat = 0.0;
				gdouble score = 0.0;
				guint8* _tmp16_;
				gint _tmp17_;
				gint _tmp18_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				if (!(((gdouble) i) < pixels)) {
					break;
				}
				_tmp9_ = data_ptr;
				_tmp10_ = _tmp9_[0];
				r = _tmp10_;
				_tmp11_ = data_ptr;
				_tmp12_ = _tmp11_[1];
				g = _tmp12_;
				_tmp13_ = data_ptr;
				_tmp14_ = _tmp13_[2];
				b = _tmp14_;
				max = (guint8) MAX ((gdouble) r, MAX ((gdouble) g, (gdouble) b));
				min = (guint8) MIN ((gdouble) r, MIN ((gdouble) g, (gdouble) b));
				delta = (gdouble) (max - min);
				if (delta == ((gdouble) 0)) {
					_tmp15_ = 0.0;
				} else {
					_tmp15_ = delta / max;
				}
				sat = _tmp15_;
				score = 0.2 + (0.8 * sat);
				r_total += r * score;
				g_total += g * score;
				b_total += b * score;
				_tmp16_ = data_ptr;
				_tmp17_ = gdk_pixbuf_get_n_channels (source);
				_tmp18_ = _tmp17_;
				data_ptr = _tmp16_ + _tmp18_;
			}
		}
	}
	_tmp19_ = gala_drawing_color_new ((r_total / G_MAXUINT8) / pixels, (g_total / G_MAXUINT8) / pixels, (b_total / G_MAXUINT8) / pixels, (gdouble) 1);
	_tmp20_ = _tmp19_;
	_tmp21_ = gala_drawing_color_set_val (_tmp20_, 0.8);
	_tmp22_ = _tmp21_;
	_tmp23_ = gala_drawing_color_multiply_sat (_tmp22_, 1.15);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp22_);
	_g_object_unref0 (_tmp20_);
	result = _tmp24_;
	return result;
}

GalaDrawingUtilities*
gala_drawing_utilities_construct (GType object_type)
{
	GalaDrawingUtilities * self = NULL;
	self = (GalaDrawingUtilities*) g_object_new (object_type, NULL);
	return self;
}

GalaDrawingUtilities*
gala_drawing_utilities_new (void)
{
	return gala_drawing_utilities_construct (GALA_DRAWING_TYPE_UTILITIES);
}

static void
gala_drawing_utilities_class_init (GalaDrawingUtilitiesClass * klass,
                                   gpointer klass_data)
{
	gala_drawing_utilities_parent_class = g_type_class_peek_parent (klass);
}

static void
gala_drawing_utilities_instance_init (GalaDrawingUtilities * self,
                                      gpointer klass)
{
}

/**
 * A utility class for frequently-performed drawing operations.
 */
static GType
gala_drawing_utilities_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDrawingUtilitiesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_drawing_utilities_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDrawingUtilities), 0, (GInstanceInitFunc) gala_drawing_utilities_instance_init, NULL };
	GType gala_drawing_utilities_type_id;
	gala_drawing_utilities_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaDrawingUtilities", &g_define_type_info, 0);
	return gala_drawing_utilities_type_id;
}

GType
gala_drawing_utilities_get_type (void)
{
	static volatile gsize gala_drawing_utilities_type_id__once = 0;
	if (g_once_init_enter (&gala_drawing_utilities_type_id__once)) {
		GType gala_drawing_utilities_type_id;
		gala_drawing_utilities_type_id = gala_drawing_utilities_get_type_once ();
		g_once_init_leave (&gala_drawing_utilities_type_id__once, gala_drawing_utilities_type_id);
	}
	return gala_drawing_utilities_type_id__once;
}

