/* BufferSurface.c generated by valac 0.56.16, the Vala compiler
 * generated from BufferSurface.vala, do not modify */

/*
 * Copyright 2019 elementary, Inc. (https://elementary.io)
 * Copyright 2011-2013 Robert Dyer
 * Copyright 2011-2013 Rico Tzschichholz <ricotz@ubuntu.com>
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#include "gala.h"
#include <cairo-gobject.h>
#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>

#define GALA_DRAWING_BUFFER_SURFACE_ALPHA_PRECISION 16
#define GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION 7
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_DRAWING_BUFFER_SURFACE_0_PROPERTY,
	GALA_DRAWING_BUFFER_SURFACE_SURFACE_PROPERTY,
	GALA_DRAWING_BUFFER_SURFACE_WIDTH_PROPERTY,
	GALA_DRAWING_BUFFER_SURFACE_HEIGHT_PROPERTY,
	GALA_DRAWING_BUFFER_SURFACE_CONTEXT_PROPERTY,
	GALA_DRAWING_BUFFER_SURFACE_NUM_PROPERTIES
};
static GParamSpec* gala_drawing_buffer_surface_properties[GALA_DRAWING_BUFFER_SURFACE_NUM_PROPERTIES];
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GalaDrawingBufferSurfacePrivate {
	cairo_surface_t* _surface;
	gint _width;
	gint _height;
	cairo_t* _context;
};

struct _Block2Data {
	int _ref_count_;
	GalaDrawingBufferSurface* self;
	gint alpha;
	gint height;
	gint width;
	guint8* pixels;
};

struct _Block3Data {
	int _ref_count_;
	GalaDrawingBufferSurface* self;
	gint gauss_width;
	gdouble* kernel;
	gint kernel_length1;
	gint _kernel_size_;
	gint width;
	gint height;
	gdouble* buffer_a;
	gint buffer_a_length1;
	gint _buffer_a_size_;
	gdouble* buffer_b;
	gint buffer_b_length1;
	gint _buffer_b_size_;
	gint* shiftar;
	gint shiftar_length1;
	gint shiftar_length2;
	gint _shiftar_size_;
};

static gint GalaDrawingBufferSurface_private_offset;
static gpointer gala_drawing_buffer_surface_parent_class = NULL;

static void gala_drawing_buffer_surface_set_width (GalaDrawingBufferSurface* self,
                                            gint value);
static void gala_drawing_buffer_surface_set_height (GalaDrawingBufferSurface* self,
                                             gint value);
static void gala_drawing_buffer_surface_set_surface (GalaDrawingBufferSurface* self,
                                              cairo_surface_t* value);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void* ___lambda11_ (Block2Data* _data2_);
static void gala_drawing_buffer_surface_exponential_blur_rows (GalaDrawingBufferSurface* self,
                                                        guint8* pixels,
                                                        gint width,
                                                        gint height,
                                                        gint start_row,
                                                        gint end_row,
                                                        gint start_x,
                                                        gint end_x,
                                                        gint alpha);
static gpointer ____lambda11__gthread_func (gpointer self);
static void* ___lambda12_ (Block2Data* _data2_);
static void gala_drawing_buffer_surface_exponential_blur_columns (GalaDrawingBufferSurface* self,
                                                           guint8* pixels,
                                                           gint width,
                                                           gint height,
                                                           gint start_col,
                                                           gint end_col,
                                                           gint start_y,
                                                           gint end_y,
                                                           gint alpha);
static gpointer ____lambda12__gthread_func (gpointer self);
static inline void gala_drawing_buffer_surface_exponential_blur_inner (guint8* pixel,
                                                         gint* z_alpha,
                                                         gint* z_red,
                                                         gint* z_green,
                                                         gint* z_blue,
                                                         gint alpha);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gdouble* gala_drawing_buffer_surface_build_gaussian_kernel (gint gauss_width,
                                                            gint* result_length1);
static void* ___lambda13_ (Block3Data* _data3_);
static void gala_drawing_buffer_surface_gaussian_blur_horizontal (GalaDrawingBufferSurface* self,
                                                           gdouble* src,
                                                           gdouble* dest,
                                                           gdouble* kernel,
                                                           gint gauss_width,
                                                           gint width,
                                                           gint height,
                                                           gint start_row,
                                                           gint end_row,
                                                           gint* shift,
                                                           gint shift_length1,
                                                           gint shift_length2);
static gpointer ____lambda13__gthread_func (gpointer self);
static void* ___lambda14_ (Block3Data* _data3_);
static void gala_drawing_buffer_surface_gaussian_blur_vertical (GalaDrawingBufferSurface* self,
                                                         gdouble* src,
                                                         gdouble* dest,
                                                         gdouble* kernel,
                                                         gint gauss_width,
                                                         gint width,
                                                         gint height,
                                                         gint start_col,
                                                         gint end_col,
                                                         gint* shift,
                                                         gint shift_length1,
                                                         gint shift_length2);
static gpointer ____lambda14__gthread_func (gpointer self);
static void gala_drawing_buffer_surface_finalize (GObject * obj);
static GType gala_drawing_buffer_surface_get_type_once (void);
static void _vala_gala_drawing_buffer_surface_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_gala_drawing_buffer_surface_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
gala_drawing_buffer_surface_get_instance_private (GalaDrawingBufferSurface* self)
{
	return G_STRUCT_MEMBER_P (self, GalaDrawingBufferSurface_private_offset);
}

/**
        * Constructs a new, empty {@link Gala.Drawing.BufferSurface} with the supplied dimensions.
        *
        * @param width the width of {@link Gala.Drawing.BufferSurface}, in pixels
        * @param height the height of the {@link Gala.Drawing.BufferSurface}, in pixels
        */
GalaDrawingBufferSurface*
gala_drawing_buffer_surface_construct (GType object_type,
                                       gint width,
                                       gint height)
{
	GalaDrawingBufferSurface * self = NULL;
	_vala_return_val_if_fail ((width >= 0) && (height >= 0), "width >= 0 && height >= 0", NULL);
	self = (GalaDrawingBufferSurface*) g_object_new (object_type, NULL);
	gala_drawing_buffer_surface_set_width (self, width);
	gala_drawing_buffer_surface_set_height (self, height);
	return self;
}

GalaDrawingBufferSurface*
gala_drawing_buffer_surface_new (gint width,
                                 gint height)
{
	return gala_drawing_buffer_surface_construct (GALA_DRAWING_TYPE_BUFFER_SURFACE, width, height);
}

/**
        * Constructs a new, empty {@link Gala.Drawing.BufferSurface} with the supplied dimensions, using
        * the supplied {@link Cairo.Surface} as a model.
        *
        * @param width the width of the new {@link Gala.Drawing.BufferSurface}, in pixels
        * @param height the height of the new {@link Gala.Drawing.BufferSurface}, in pixels
        * @param model the {@link Cairo.Surface} to use as a model for the internal {@link Cairo.Surface}
        */
GalaDrawingBufferSurface*
gala_drawing_buffer_surface_construct_with_surface (GType object_type,
                                                    gint width,
                                                    gint height,
                                                    cairo_surface_t* model)
{
	GalaDrawingBufferSurface * self = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	g_return_val_if_fail (model != NULL, NULL);
	_vala_return_val_if_fail (model != NULL, "model != null", NULL);
	self = (GalaDrawingBufferSurface*) gala_drawing_buffer_surface_construct (object_type, width, height);
	_tmp0_ = cairo_surface_create_similar (model, CAIRO_CONTENT_COLOR_ALPHA, width, height);
	_tmp1_ = _tmp0_;
	gala_drawing_buffer_surface_set_surface (self, _tmp1_);
	_cairo_surface_destroy0 (_tmp1_);
	return self;
}

GalaDrawingBufferSurface*
gala_drawing_buffer_surface_new_with_surface (gint width,
                                              gint height,
                                              cairo_surface_t* model)
{
	return gala_drawing_buffer_surface_construct_with_surface (GALA_DRAWING_TYPE_BUFFER_SURFACE, width, height, model);
}

/**
        * Constructs a new, empty {@link Gala.Drawing.BufferSurface} with the supplied dimensions, using
        * the supplied {@link Gala.Drawing.BufferSurface} as a model.
        *
        * @param width the width of the new {@link Gala.Drawing.BufferSurface}, in pixels
        * @param height the height of the new {@link Gala.Drawing.BufferSurface}, in pixels
        * @param model the {@link Gala.Drawing.BufferSurface} to use as a model for the internal {@link Cairo.Surface}
        */
GalaDrawingBufferSurface*
gala_drawing_buffer_surface_construct_with_buffer_surface (GType object_type,
                                                           gint width,
                                                           gint height,
                                                           GalaDrawingBufferSurface* model)
{
	GalaDrawingBufferSurface * self = NULL;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_surface_t* _tmp3_;
	g_return_val_if_fail (model != NULL, NULL);
	_vala_return_val_if_fail (model != NULL, "model != null", NULL);
	self = (GalaDrawingBufferSurface*) gala_drawing_buffer_surface_construct (object_type, width, height);
	_tmp0_ = gala_drawing_buffer_surface_get_surface (model);
	_tmp1_ = _tmp0_;
	_tmp2_ = cairo_surface_create_similar (_tmp1_, CAIRO_CONTENT_COLOR_ALPHA, width, height);
	_tmp3_ = _tmp2_;
	gala_drawing_buffer_surface_set_surface (self, _tmp3_);
	_cairo_surface_destroy0 (_tmp3_);
	return self;
}

GalaDrawingBufferSurface*
gala_drawing_buffer_surface_new_with_buffer_surface (gint width,
                                                     gint height,
                                                     GalaDrawingBufferSurface* model)
{
	return gala_drawing_buffer_surface_construct_with_buffer_surface (GALA_DRAWING_TYPE_BUFFER_SURFACE, width, height, model);
}

/**
        * Clears the internal {@link Cairo.Surface}, making all pixels fully transparent.
        */
void
gala_drawing_buffer_surface_clear (GalaDrawingBufferSurface* self)
{
	cairo_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_drawing_buffer_surface_get_context (self);
	_tmp1_ = _tmp0_;
	cairo_save (_tmp1_);
	_tmp2_ = self->priv->_context;
	cairo_set_source_rgba (_tmp2_, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp3_ = self->priv->_context;
	cairo_set_operator (_tmp3_, CAIRO_OPERATOR_SOURCE);
	_tmp4_ = self->priv->_context;
	cairo_paint (_tmp4_);
	_tmp5_ = self->priv->_context;
	cairo_restore (_tmp5_);
}

/**
        * Creates a {@link Gdk.Pixbuf} from internal {@link Cairo.Surface}.
        *
        * @return the {@link Gdk.Pixbuf}
        */
GdkPixbuf*
gala_drawing_buffer_surface_load_to_pixbuf (GalaDrawingBufferSurface* self)
{
	cairo_surface_t* image_surface = NULL;
	gint _tmp0_;
	gint _tmp1_;
	cairo_surface_t* _tmp2_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_t* _tmp9_;
	gint width = 0;
	cairo_surface_t* _tmp10_;
	gint height = 0;
	cairo_surface_t* _tmp11_;
	GdkPixbuf* pb = NULL;
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	guint8* data = NULL;
	cairo_surface_t* _tmp14_;
	guchar* _tmp15_;
	guint8* pixels = NULL;
	GdkPixbuf* _tmp16_;
	guint8* _tmp17_;
	gint length = 0;
	cairo_surface_t* _tmp18_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_width;
	_tmp1_ = self->priv->_height;
	_tmp2_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp0_, _tmp1_);
	image_surface = _tmp2_;
	_tmp3_ = image_surface;
	_tmp4_ = cairo_create (_tmp3_);
	cr = _tmp4_;
	_tmp5_ = cr;
	cairo_set_operator (_tmp5_, CAIRO_OPERATOR_SOURCE);
	_tmp6_ = cr;
	_tmp7_ = gala_drawing_buffer_surface_get_surface (self);
	_tmp8_ = _tmp7_;
	cairo_set_source_surface (_tmp6_, _tmp8_, (gdouble) 0, (gdouble) 0);
	_tmp9_ = cr;
	cairo_paint (_tmp9_);
	_tmp10_ = image_surface;
	width = cairo_image_surface_get_width (_tmp10_);
	_tmp11_ = image_surface;
	height = cairo_image_surface_get_height (_tmp11_);
	_tmp12_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, width, height);
	pb = _tmp12_;
	_tmp13_ = pb;
	gdk_pixbuf_fill (_tmp13_, (guint32) 0x00000000);
	_tmp14_ = image_surface;
	_tmp15_ = cairo_image_surface_get_data (_tmp14_);
	data = _tmp15_;
	_tmp16_ = pb;
	_tmp17_ = gdk_pixbuf_get_pixels (_tmp16_);
	pixels = _tmp17_;
	length = width * height;
	_tmp18_ = image_surface;
	if (cairo_image_surface_get_format (_tmp18_) == CAIRO_FORMAT_ARGB32) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp19_ = FALSE;
				_tmp19_ = TRUE;
				while (TRUE) {
					guint8* _tmp21_;
					guint8 _tmp22_;
					guint8* _tmp41_;
					guint8* _tmp42_;
					if (!_tmp19_) {
						gint _tmp20_;
						_tmp20_ = i;
						i = _tmp20_ + 1;
					}
					_tmp19_ = FALSE;
					if (!(i < length)) {
						break;
					}
					_tmp21_ = data;
					_tmp22_ = _tmp21_[3];
					if (((gint) _tmp22_) > 0) {
						guint8* _tmp23_;
						guint8* _tmp24_;
						guint8 _tmp25_;
						guint8* _tmp26_;
						guint8 _tmp27_;
						guint8* _tmp28_;
						guint8* _tmp29_;
						guint8 _tmp30_;
						guint8* _tmp31_;
						guint8 _tmp32_;
						guint8* _tmp33_;
						guint8* _tmp34_;
						guint8 _tmp35_;
						guint8* _tmp36_;
						guint8 _tmp37_;
						guint8* _tmp38_;
						guint8* _tmp39_;
						guint8 _tmp40_;
						_tmp23_ = pixels;
						_tmp24_ = data;
						_tmp25_ = _tmp24_[2];
						_tmp26_ = data;
						_tmp27_ = _tmp26_[3];
						_tmp23_[0] = (guint8) ((_tmp25_ * 255) / _tmp27_);
						_tmp28_ = pixels;
						_tmp29_ = data;
						_tmp30_ = _tmp29_[1];
						_tmp31_ = data;
						_tmp32_ = _tmp31_[3];
						_tmp28_[1] = (guint8) ((_tmp30_ * 255) / _tmp32_);
						_tmp33_ = pixels;
						_tmp34_ = data;
						_tmp35_ = _tmp34_[0];
						_tmp36_ = data;
						_tmp37_ = _tmp36_[3];
						_tmp33_[2] = (guint8) ((_tmp35_ * 255) / _tmp37_);
						_tmp38_ = pixels;
						_tmp39_ = data;
						_tmp40_ = _tmp39_[3];
						_tmp38_[3] = _tmp40_;
					}
					_tmp41_ = pixels;
					pixels = _tmp41_ + 4;
					_tmp42_ = data;
					data = _tmp42_ + 4;
				}
			}
		}
	} else {
		cairo_surface_t* _tmp43_;
		_tmp43_ = image_surface;
		if (cairo_image_surface_get_format (_tmp43_) == CAIRO_FORMAT_RGB24) {
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp44_ = FALSE;
					_tmp44_ = TRUE;
					while (TRUE) {
						guint8* _tmp46_;
						guint8* _tmp47_;
						guint8 _tmp48_;
						guint8* _tmp49_;
						guint8* _tmp50_;
						guint8 _tmp51_;
						guint8* _tmp52_;
						guint8* _tmp53_;
						guint8 _tmp54_;
						guint8* _tmp55_;
						guint8* _tmp56_;
						guint8 _tmp57_;
						guint8* _tmp58_;
						guint8* _tmp59_;
						if (!_tmp44_) {
							gint _tmp45_;
							_tmp45_ = i;
							i = _tmp45_ + 1;
						}
						_tmp44_ = FALSE;
						if (!(i < length)) {
							break;
						}
						_tmp46_ = pixels;
						_tmp47_ = data;
						_tmp48_ = _tmp47_[2];
						_tmp46_[0] = _tmp48_;
						_tmp49_ = pixels;
						_tmp50_ = data;
						_tmp51_ = _tmp50_[1];
						_tmp49_[1] = _tmp51_;
						_tmp52_ = pixels;
						_tmp53_ = data;
						_tmp54_ = _tmp53_[0];
						_tmp52_[2] = _tmp54_;
						_tmp55_ = pixels;
						_tmp56_ = data;
						_tmp57_ = _tmp56_[3];
						_tmp55_[3] = _tmp57_;
						_tmp58_ = pixels;
						pixels = _tmp58_ + 4;
						_tmp59_ = data;
						data = _tmp59_ + 4;
					}
				}
			}
		}
	}
	result = pb;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (image_surface);
	return result;
}

/**
        * Averages all the colors in the internal {@link Cairo.Surface}.
        *
        * @return the {@link Gala.Drawing.Color} with the averaged color
        */
GalaDrawingColor*
gala_drawing_buffer_surface_average_color (GalaDrawingBufferSurface* self)
{
	gdouble b_total = 0.0;
	gdouble g_total = 0.0;
	gdouble r_total = 0.0;
	gint w = 0;
	gint _tmp0_;
	gint h = 0;
	gint _tmp1_;
	cairo_surface_t* original = NULL;
	cairo_surface_t* _tmp2_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_t* _tmp9_;
	guint8* data = NULL;
	cairo_surface_t* _tmp10_;
	guchar* _tmp11_;
	gint length = 0;
	GalaDrawingColor* _tmp22_;
	GalaDrawingColor* _tmp23_;
	GalaDrawingColor* _tmp24_;
	GalaDrawingColor* _tmp25_;
	GalaDrawingColor* _tmp26_;
	GalaDrawingColor* _tmp27_;
	GalaDrawingColor* result;
	g_return_val_if_fail (self != NULL, NULL);
	b_total = 0.0;
	g_total = 0.0;
	r_total = 0.0;
	_tmp0_ = self->priv->_width;
	w = _tmp0_;
	_tmp1_ = self->priv->_height;
	h = _tmp1_;
	_tmp2_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, w, h);
	original = _tmp2_;
	_tmp3_ = original;
	_tmp4_ = cairo_create (_tmp3_);
	cr = _tmp4_;
	_tmp5_ = cr;
	cairo_set_operator (_tmp5_, CAIRO_OPERATOR_SOURCE);
	_tmp6_ = cr;
	_tmp7_ = gala_drawing_buffer_surface_get_surface (self);
	_tmp8_ = _tmp7_;
	cairo_set_source_surface (_tmp6_, _tmp8_, (gdouble) 0, (gdouble) 0);
	_tmp9_ = cr;
	cairo_paint (_tmp9_);
	_tmp10_ = original;
	_tmp11_ = cairo_image_surface_get_data (_tmp10_);
	data = _tmp11_;
	length = w * h;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				guint8 b = 0U;
				guint8* _tmp14_;
				guint8 _tmp15_;
				guint8 g = 0U;
				guint8* _tmp16_;
				guint8 _tmp17_;
				guint8 r = 0U;
				guint8* _tmp18_;
				guint8 _tmp19_;
				guint8 max = 0U;
				guint8 min = 0U;
				gdouble delta = 0.0;
				gdouble _tmp20_ = 0.0;
				gdouble sat = 0.0;
				gdouble score = 0.0;
				guint8* _tmp21_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp14_ = data;
				_tmp15_ = _tmp14_[0];
				b = _tmp15_;
				_tmp16_ = data;
				_tmp17_ = _tmp16_[1];
				g = _tmp17_;
				_tmp18_ = data;
				_tmp19_ = _tmp18_[2];
				r = _tmp19_;
				max = (guint8) MAX ((gdouble) r, MAX ((gdouble) g, (gdouble) b));
				min = (guint8) MIN ((gdouble) r, MIN ((gdouble) g, (gdouble) b));
				delta = (gdouble) (max - min);
				if (delta == ((gdouble) 0)) {
					_tmp20_ = 0.0;
				} else {
					_tmp20_ = delta / max;
				}
				sat = _tmp20_;
				score = 0.2 + (0.8 * sat);
				b_total += b * score;
				g_total += g * score;
				r_total += r * score;
				_tmp21_ = data;
				data = _tmp21_ + 4;
			}
		}
	}
	_tmp22_ = gala_drawing_color_new ((r_total / G_MAXUINT8) / length, (g_total / G_MAXUINT8) / length, (b_total / G_MAXUINT8) / length, (gdouble) 1);
	_tmp23_ = _tmp22_;
	_tmp24_ = gala_drawing_color_set_val (_tmp23_, 0.8);
	_tmp25_ = _tmp24_;
	_tmp26_ = gala_drawing_color_multiply_sat (_tmp25_, 1.15);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp25_);
	_g_object_unref0 (_tmp23_);
	result = _tmp27_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (original);
	return result;
}

/**
        * Performs a blur operation on the internal {@link Cairo.Surface}, using the
        * fast-blur algorithm found here [[http://incubator.quasimondo.com/processing/superfastblur.pde]].
        *
        * @param radius the blur radius
        * @param process_count the number of times to perform the operation
        */
void
gala_drawing_buffer_surface_fast_blur (GalaDrawingBufferSurface* self,
                                       gint radius,
                                       gint process_count)
{
	gboolean _tmp0_ = FALSE;
	gint w = 0;
	gint _tmp1_;
	gint h = 0;
	gint _tmp2_;
	gint channels = 0;
	gboolean _tmp3_ = FALSE;
	cairo_surface_t* original = NULL;
	cairo_surface_t* _tmp4_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_surface_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_t* _tmp11_;
	guint8* pixels = NULL;
	cairo_surface_t* _tmp12_;
	guchar* _tmp13_;
	guint8* buffer = NULL;
	guint8* _tmp14_;
	gint buffer_length1;
	gint _buffer_size_;
	gint* v_min = NULL;
	gint* _tmp15_;
	gint v_min_length1;
	gint _v_min_size_;
	gint* v_max = NULL;
	gint* _tmp16_;
	gint v_max_length1;
	gint _v_max_size_;
	gint div = 0;
	guint8* dv = NULL;
	guint8* _tmp17_;
	gint dv_length1;
	gint _dv_size_;
	cairo_surface_t* _tmp139_;
	cairo_t* _tmp140_;
	cairo_t* _tmp141_;
	cairo_t* _tmp142_;
	cairo_t* _tmp143_;
	cairo_surface_t* _tmp144_;
	cairo_t* _tmp145_;
	cairo_t* _tmp146_;
	cairo_t* _tmp147_;
	cairo_t* _tmp148_;
	g_return_if_fail (self != NULL);
	if (radius < 1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = process_count < 1;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_width;
	w = _tmp1_;
	_tmp2_ = self->priv->_height;
	h = _tmp2_;
	channels = 4;
	if (radius > (w - 1)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = radius > (h - 1);
	}
	if (_tmp3_) {
		return;
	}
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, w, h);
	original = _tmp4_;
	_tmp5_ = original;
	_tmp6_ = cairo_create (_tmp5_);
	cr = _tmp6_;
	_tmp7_ = cr;
	cairo_set_operator (_tmp7_, CAIRO_OPERATOR_SOURCE);
	_tmp8_ = cr;
	_tmp9_ = gala_drawing_buffer_surface_get_surface (self);
	_tmp10_ = _tmp9_;
	cairo_set_source_surface (_tmp8_, _tmp10_, (gdouble) 0, (gdouble) 0);
	_tmp11_ = cr;
	cairo_paint (_tmp11_);
	_tmp12_ = original;
	_tmp13_ = cairo_image_surface_get_data (_tmp12_);
	pixels = _tmp13_;
	_tmp14_ = g_new0 (guint8, (w * h) * channels);
	buffer = _tmp14_;
	buffer_length1 = (w * h) * channels;
	_buffer_size_ = buffer_length1;
	_tmp15_ = g_new0 (gint, MAX (w, h));
	v_min = _tmp15_;
	v_min_length1 = MAX (w, h);
	_v_min_size_ = v_min_length1;
	_tmp16_ = g_new0 (gint, MAX (w, h));
	v_max = _tmp16_;
	v_max_length1 = MAX (w, h);
	_v_max_size_ = v_max_length1;
	div = (2 * radius) + 1;
	_tmp17_ = g_new0 (guint8, 256 * div);
	dv = _tmp17_;
	dv_length1 = 256 * div;
	_dv_size_ = dv_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				guint8* _tmp20_;
				gint _tmp20__length1;
				guint8* _tmp21_;
				gint _tmp21__length1;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = dv;
				_tmp20__length1 = dv_length1;
				if (!(i < _tmp20__length1)) {
					break;
				}
				_tmp21_ = dv;
				_tmp21__length1 = dv_length1;
				_tmp21_[i] = (guint8) (i / div);
			}
		}
	}
	while (TRUE) {
		gint _tmp22_;
		_tmp22_ = process_count;
		process_count = _tmp22_ - 1;
		if (!(_tmp22_ > 0)) {
			break;
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp23_ = FALSE;
				_tmp23_ = TRUE;
				while (TRUE) {
					gint* _tmp25_;
					gint _tmp25__length1;
					gint* _tmp26_;
					gint _tmp26__length1;
					if (!_tmp23_) {
						gint _tmp24_;
						_tmp24_ = x;
						x = _tmp24_ + 1;
					}
					_tmp23_ = FALSE;
					if (!(x < w)) {
						break;
					}
					_tmp25_ = v_min;
					_tmp25__length1 = v_min_length1;
					_tmp25_[x] = MIN ((x + radius) + 1, w - 1);
					_tmp26_ = v_max;
					_tmp26__length1 = v_max_length1;
					_tmp26_[x] = MAX (x - radius, 0);
				}
			}
		}
		{
			gint y = 0;
			y = 0;
			{
				gboolean _tmp27_ = FALSE;
				_tmp27_ = TRUE;
				while (TRUE) {
					gint a_sum = 0;
					gint r_sum = 0;
					gint g_sum = 0;
					gint b_sum = 0;
					guint32 cur_pixel = 0U;
					guint8* _tmp29_;
					guint8 _tmp30_;
					guint8* _tmp31_;
					guint8 _tmp32_;
					guint8* _tmp33_;
					guint8 _tmp34_;
					guint8* _tmp35_;
					guint8 _tmp36_;
					if (!_tmp27_) {
						gint _tmp28_;
						_tmp28_ = y;
						y = _tmp28_ + 1;
					}
					_tmp27_ = FALSE;
					if (!(y < h)) {
						break;
					}
					a_sum = 0;
					r_sum = 0;
					g_sum = 0;
					b_sum = 0;
					cur_pixel = (guint32) ((y * w) * channels);
					_tmp29_ = pixels;
					_tmp30_ = _tmp29_[cur_pixel + 0];
					a_sum += radius * _tmp30_;
					_tmp31_ = pixels;
					_tmp32_ = _tmp31_[cur_pixel + 1];
					r_sum += radius * _tmp32_;
					_tmp33_ = pixels;
					_tmp34_ = _tmp33_[cur_pixel + 2];
					g_sum += radius * _tmp34_;
					_tmp35_ = pixels;
					_tmp36_ = _tmp35_[cur_pixel + 3];
					b_sum += radius * _tmp36_;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp37_ = FALSE;
							_tmp37_ = TRUE;
							while (TRUE) {
								guint8* _tmp39_;
								guint8 _tmp40_;
								guint8* _tmp41_;
								guint8 _tmp42_;
								guint8* _tmp43_;
								guint8 _tmp44_;
								guint8* _tmp45_;
								guint8 _tmp46_;
								if (!_tmp37_) {
									gint _tmp38_;
									_tmp38_ = i;
									i = _tmp38_ + 1;
								}
								_tmp37_ = FALSE;
								if (!(i <= radius)) {
									break;
								}
								_tmp39_ = pixels;
								_tmp40_ = _tmp39_[cur_pixel + 0];
								a_sum += (gint) _tmp40_;
								_tmp41_ = pixels;
								_tmp42_ = _tmp41_[cur_pixel + 1];
								r_sum += (gint) _tmp42_;
								_tmp43_ = pixels;
								_tmp44_ = _tmp43_[cur_pixel + 2];
								g_sum += (gint) _tmp44_;
								_tmp45_ = pixels;
								_tmp46_ = _tmp45_[cur_pixel + 3];
								b_sum += (gint) _tmp46_;
								cur_pixel += (guint32) channels;
							}
						}
					}
					cur_pixel = (guint32) ((y * w) * channels);
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp47_ = FALSE;
							_tmp47_ = TRUE;
							while (TRUE) {
								guint32 p1 = 0U;
								gint* _tmp49_;
								gint _tmp49__length1;
								gint _tmp50_;
								guint32 p2 = 0U;
								gint* _tmp51_;
								gint _tmp51__length1;
								gint _tmp52_;
								guint8* _tmp53_;
								gint _tmp53__length1;
								guint8* _tmp54_;
								gint _tmp54__length1;
								guint8 _tmp55_;
								guint8* _tmp56_;
								gint _tmp56__length1;
								guint8* _tmp57_;
								gint _tmp57__length1;
								guint8 _tmp58_;
								guint8* _tmp59_;
								gint _tmp59__length1;
								guint8* _tmp60_;
								gint _tmp60__length1;
								guint8 _tmp61_;
								guint8* _tmp62_;
								gint _tmp62__length1;
								guint8* _tmp63_;
								gint _tmp63__length1;
								guint8 _tmp64_;
								guint8* _tmp65_;
								guint8 _tmp66_;
								guint8* _tmp67_;
								guint8 _tmp68_;
								guint8* _tmp69_;
								guint8 _tmp70_;
								guint8* _tmp71_;
								guint8 _tmp72_;
								guint8* _tmp73_;
								guint8 _tmp74_;
								guint8* _tmp75_;
								guint8 _tmp76_;
								guint8* _tmp77_;
								guint8 _tmp78_;
								guint8* _tmp79_;
								guint8 _tmp80_;
								if (!_tmp47_) {
									gint _tmp48_;
									_tmp48_ = x;
									x = _tmp48_ + 1;
								}
								_tmp47_ = FALSE;
								if (!(x < w)) {
									break;
								}
								_tmp49_ = v_min;
								_tmp49__length1 = v_min_length1;
								_tmp50_ = _tmp49_[x];
								p1 = (guint32) (((y * w) + _tmp50_) * channels);
								_tmp51_ = v_max;
								_tmp51__length1 = v_max_length1;
								_tmp52_ = _tmp51_[x];
								p2 = (guint32) (((y * w) + _tmp52_) * channels);
								_tmp53_ = buffer;
								_tmp53__length1 = buffer_length1;
								_tmp54_ = dv;
								_tmp54__length1 = dv_length1;
								_tmp55_ = _tmp54_[a_sum];
								_tmp53_[cur_pixel + 0] = _tmp55_;
								_tmp56_ = buffer;
								_tmp56__length1 = buffer_length1;
								_tmp57_ = dv;
								_tmp57__length1 = dv_length1;
								_tmp58_ = _tmp57_[r_sum];
								_tmp56_[cur_pixel + 1] = _tmp58_;
								_tmp59_ = buffer;
								_tmp59__length1 = buffer_length1;
								_tmp60_ = dv;
								_tmp60__length1 = dv_length1;
								_tmp61_ = _tmp60_[g_sum];
								_tmp59_[cur_pixel + 2] = _tmp61_;
								_tmp62_ = buffer;
								_tmp62__length1 = buffer_length1;
								_tmp63_ = dv;
								_tmp63__length1 = dv_length1;
								_tmp64_ = _tmp63_[b_sum];
								_tmp62_[cur_pixel + 3] = _tmp64_;
								_tmp65_ = pixels;
								_tmp66_ = _tmp65_[p1 + 0];
								_tmp67_ = pixels;
								_tmp68_ = _tmp67_[p2 + 0];
								a_sum += (gint) (_tmp66_ - _tmp68_);
								_tmp69_ = pixels;
								_tmp70_ = _tmp69_[p1 + 1];
								_tmp71_ = pixels;
								_tmp72_ = _tmp71_[p2 + 1];
								r_sum += (gint) (_tmp70_ - _tmp72_);
								_tmp73_ = pixels;
								_tmp74_ = _tmp73_[p1 + 2];
								_tmp75_ = pixels;
								_tmp76_ = _tmp75_[p2 + 2];
								g_sum += (gint) (_tmp74_ - _tmp76_);
								_tmp77_ = pixels;
								_tmp78_ = _tmp77_[p1 + 3];
								_tmp79_ = pixels;
								_tmp80_ = _tmp79_[p2 + 3];
								b_sum += (gint) (_tmp78_ - _tmp80_);
								cur_pixel += (guint32) channels;
							}
						}
					}
				}
			}
		}
		{
			gint y = 0;
			y = 0;
			{
				gboolean _tmp81_ = FALSE;
				_tmp81_ = TRUE;
				while (TRUE) {
					gint* _tmp83_;
					gint _tmp83__length1;
					gint* _tmp84_;
					gint _tmp84__length1;
					if (!_tmp81_) {
						gint _tmp82_;
						_tmp82_ = y;
						y = _tmp82_ + 1;
					}
					_tmp81_ = FALSE;
					if (!(y < h)) {
						break;
					}
					_tmp83_ = v_min;
					_tmp83__length1 = v_min_length1;
					_tmp83_[y] = MIN ((y + radius) + 1, h - 1) * w;
					_tmp84_ = v_max;
					_tmp84__length1 = v_max_length1;
					_tmp84_[y] = MAX (y - radius, 0) * w;
				}
			}
		}
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp85_ = FALSE;
				_tmp85_ = TRUE;
				while (TRUE) {
					gint a_sum = 0;
					gint r_sum = 0;
					gint g_sum = 0;
					gint b_sum = 0;
					guint32 cur_pixel = 0U;
					guint8* _tmp87_;
					gint _tmp87__length1;
					guint8 _tmp88_;
					guint8* _tmp89_;
					gint _tmp89__length1;
					guint8 _tmp90_;
					guint8* _tmp91_;
					gint _tmp91__length1;
					guint8 _tmp92_;
					guint8* _tmp93_;
					gint _tmp93__length1;
					guint8 _tmp94_;
					if (!_tmp85_) {
						gint _tmp86_;
						_tmp86_ = x;
						x = _tmp86_ + 1;
					}
					_tmp85_ = FALSE;
					if (!(x < w)) {
						break;
					}
					a_sum = 0;
					r_sum = 0;
					g_sum = 0;
					b_sum = 0;
					cur_pixel = (guint32) (x * channels);
					_tmp87_ = buffer;
					_tmp87__length1 = buffer_length1;
					_tmp88_ = _tmp87_[cur_pixel + 0];
					a_sum += radius * _tmp88_;
					_tmp89_ = buffer;
					_tmp89__length1 = buffer_length1;
					_tmp90_ = _tmp89_[cur_pixel + 1];
					r_sum += radius * _tmp90_;
					_tmp91_ = buffer;
					_tmp91__length1 = buffer_length1;
					_tmp92_ = _tmp91_[cur_pixel + 2];
					g_sum += radius * _tmp92_;
					_tmp93_ = buffer;
					_tmp93__length1 = buffer_length1;
					_tmp94_ = _tmp93_[cur_pixel + 3];
					b_sum += radius * _tmp94_;
					{
						gint i = 0;
						i = 0;
						{
							gboolean _tmp95_ = FALSE;
							_tmp95_ = TRUE;
							while (TRUE) {
								guint8* _tmp97_;
								gint _tmp97__length1;
								guint8 _tmp98_;
								guint8* _tmp99_;
								gint _tmp99__length1;
								guint8 _tmp100_;
								guint8* _tmp101_;
								gint _tmp101__length1;
								guint8 _tmp102_;
								guint8* _tmp103_;
								gint _tmp103__length1;
								guint8 _tmp104_;
								if (!_tmp95_) {
									gint _tmp96_;
									_tmp96_ = i;
									i = _tmp96_ + 1;
								}
								_tmp95_ = FALSE;
								if (!(i <= radius)) {
									break;
								}
								_tmp97_ = buffer;
								_tmp97__length1 = buffer_length1;
								_tmp98_ = _tmp97_[cur_pixel + 0];
								a_sum += (gint) _tmp98_;
								_tmp99_ = buffer;
								_tmp99__length1 = buffer_length1;
								_tmp100_ = _tmp99_[cur_pixel + 1];
								r_sum += (gint) _tmp100_;
								_tmp101_ = buffer;
								_tmp101__length1 = buffer_length1;
								_tmp102_ = _tmp101_[cur_pixel + 2];
								g_sum += (gint) _tmp102_;
								_tmp103_ = buffer;
								_tmp103__length1 = buffer_length1;
								_tmp104_ = _tmp103_[cur_pixel + 3];
								b_sum += (gint) _tmp104_;
								cur_pixel += (guint32) (w * channels);
							}
						}
					}
					cur_pixel = (guint32) (x * channels);
					{
						gint y = 0;
						y = 0;
						{
							gboolean _tmp105_ = FALSE;
							_tmp105_ = TRUE;
							while (TRUE) {
								guint32 p1 = 0U;
								gint* _tmp107_;
								gint _tmp107__length1;
								gint _tmp108_;
								guint32 p2 = 0U;
								gint* _tmp109_;
								gint _tmp109__length1;
								gint _tmp110_;
								guint8* _tmp111_;
								guint8* _tmp112_;
								gint _tmp112__length1;
								guint8 _tmp113_;
								guint8* _tmp114_;
								guint8* _tmp115_;
								gint _tmp115__length1;
								guint8 _tmp116_;
								guint8* _tmp117_;
								guint8* _tmp118_;
								gint _tmp118__length1;
								guint8 _tmp119_;
								guint8* _tmp120_;
								guint8* _tmp121_;
								gint _tmp121__length1;
								guint8 _tmp122_;
								guint8* _tmp123_;
								gint _tmp123__length1;
								guint8 _tmp124_;
								guint8* _tmp125_;
								gint _tmp125__length1;
								guint8 _tmp126_;
								guint8* _tmp127_;
								gint _tmp127__length1;
								guint8 _tmp128_;
								guint8* _tmp129_;
								gint _tmp129__length1;
								guint8 _tmp130_;
								guint8* _tmp131_;
								gint _tmp131__length1;
								guint8 _tmp132_;
								guint8* _tmp133_;
								gint _tmp133__length1;
								guint8 _tmp134_;
								guint8* _tmp135_;
								gint _tmp135__length1;
								guint8 _tmp136_;
								guint8* _tmp137_;
								gint _tmp137__length1;
								guint8 _tmp138_;
								if (!_tmp105_) {
									gint _tmp106_;
									_tmp106_ = y;
									y = _tmp106_ + 1;
								}
								_tmp105_ = FALSE;
								if (!(y < h)) {
									break;
								}
								_tmp107_ = v_min;
								_tmp107__length1 = v_min_length1;
								_tmp108_ = _tmp107_[y];
								p1 = (guint32) ((x + _tmp108_) * channels);
								_tmp109_ = v_max;
								_tmp109__length1 = v_max_length1;
								_tmp110_ = _tmp109_[y];
								p2 = (guint32) ((x + _tmp110_) * channels);
								_tmp111_ = pixels;
								_tmp112_ = dv;
								_tmp112__length1 = dv_length1;
								_tmp113_ = _tmp112_[a_sum];
								_tmp111_[cur_pixel + 0] = _tmp113_;
								_tmp114_ = pixels;
								_tmp115_ = dv;
								_tmp115__length1 = dv_length1;
								_tmp116_ = _tmp115_[r_sum];
								_tmp114_[cur_pixel + 1] = _tmp116_;
								_tmp117_ = pixels;
								_tmp118_ = dv;
								_tmp118__length1 = dv_length1;
								_tmp119_ = _tmp118_[g_sum];
								_tmp117_[cur_pixel + 2] = _tmp119_;
								_tmp120_ = pixels;
								_tmp121_ = dv;
								_tmp121__length1 = dv_length1;
								_tmp122_ = _tmp121_[b_sum];
								_tmp120_[cur_pixel + 3] = _tmp122_;
								_tmp123_ = buffer;
								_tmp123__length1 = buffer_length1;
								_tmp124_ = _tmp123_[p1 + 0];
								_tmp125_ = buffer;
								_tmp125__length1 = buffer_length1;
								_tmp126_ = _tmp125_[p2 + 0];
								a_sum += (gint) (_tmp124_ - _tmp126_);
								_tmp127_ = buffer;
								_tmp127__length1 = buffer_length1;
								_tmp128_ = _tmp127_[p1 + 1];
								_tmp129_ = buffer;
								_tmp129__length1 = buffer_length1;
								_tmp130_ = _tmp129_[p2 + 1];
								r_sum += (gint) (_tmp128_ - _tmp130_);
								_tmp131_ = buffer;
								_tmp131__length1 = buffer_length1;
								_tmp132_ = _tmp131_[p1 + 2];
								_tmp133_ = buffer;
								_tmp133__length1 = buffer_length1;
								_tmp134_ = _tmp133_[p2 + 2];
								g_sum += (gint) (_tmp132_ - _tmp134_);
								_tmp135_ = buffer;
								_tmp135__length1 = buffer_length1;
								_tmp136_ = _tmp135_[p1 + 3];
								_tmp137_ = buffer;
								_tmp137__length1 = buffer_length1;
								_tmp138_ = _tmp137_[p2 + 3];
								b_sum += (gint) (_tmp136_ - _tmp138_);
								cur_pixel += (guint32) (w * channels);
							}
						}
					}
				}
			}
		}
	}
	_tmp139_ = original;
	cairo_surface_mark_dirty (_tmp139_);
	_tmp140_ = gala_drawing_buffer_surface_get_context (self);
	_tmp141_ = _tmp140_;
	cairo_set_operator (_tmp141_, CAIRO_OPERATOR_SOURCE);
	_tmp142_ = gala_drawing_buffer_surface_get_context (self);
	_tmp143_ = _tmp142_;
	_tmp144_ = original;
	cairo_set_source_surface (_tmp143_, _tmp144_, (gdouble) 0, (gdouble) 0);
	_tmp145_ = gala_drawing_buffer_surface_get_context (self);
	_tmp146_ = _tmp145_;
	cairo_paint (_tmp146_);
	_tmp147_ = gala_drawing_buffer_surface_get_context (self);
	_tmp148_ = _tmp147_;
	cairo_set_operator (_tmp148_, CAIRO_OPERATOR_OVER);
	dv = (g_free (dv), NULL);
	v_max = (g_free (v_max), NULL);
	v_min = (g_free (v_min), NULL);
	buffer = (g_free (buffer), NULL);
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (original);
}

/**
        * Performs a blur operation on the internal {@link Cairo.Surface}, using an
        * exponential blurring algorithm. This method is usually the fastest
        * and produces good-looking results (though not quite as good as gaussian's).
        *
        * @param radius the blur radius
        */
static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GalaDrawingBufferSurface* self;
		self = _data2_->self;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void*
___lambda11_ (Block2Data* _data2_)
{
	GalaDrawingBufferSurface* self;
	guint8* _tmp0_;
	void* result;
	self = _data2_->self;
	_tmp0_ = _data2_->pixels;
	gala_drawing_buffer_surface_exponential_blur_rows (self, _tmp0_, _data2_->width, _data2_->height, 0, _data2_->height / 2, 0, _data2_->width, _data2_->alpha);
	result = NULL;
	return result;
}

static gpointer
____lambda11__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda11_ (self);
	block2_data_unref (self);
	return result;
}

static void*
___lambda12_ (Block2Data* _data2_)
{
	GalaDrawingBufferSurface* self;
	guint8* _tmp0_;
	void* result;
	self = _data2_->self;
	_tmp0_ = _data2_->pixels;
	gala_drawing_buffer_surface_exponential_blur_columns (self, _tmp0_, _data2_->width, _data2_->height, 0, _data2_->width / 2, 0, _data2_->height, _data2_->alpha);
	result = NULL;
	return result;
}

static gpointer
____lambda12__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda12_ (self);
	block2_data_unref (self);
	return result;
}

void
gala_drawing_buffer_surface_exponential_blur (GalaDrawingBufferSurface* self,
                                              gint radius)
{
	Block2Data* _data2_;
	gint _tmp0_;
	gint _tmp1_;
	cairo_surface_t* original = NULL;
	cairo_surface_t* _tmp2_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	guchar* _tmp11_;
	cairo_surface_t* _tmp20_;
	cairo_t* _tmp21_;
	cairo_t* _tmp22_;
	cairo_t* _tmp23_;
	cairo_t* _tmp24_;
	cairo_surface_t* _tmp25_;
	cairo_t* _tmp26_;
	cairo_t* _tmp27_;
	cairo_t* _tmp28_;
	cairo_t* _tmp29_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	if (radius < 1) {
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return;
	}
	_data2_->alpha = (gint) ((1 << GALA_DRAWING_BUFFER_SURFACE_ALPHA_PRECISION) * (1.0 - exp ((-2.3) / (radius + 1.0))));
	_tmp0_ = self->priv->_height;
	_data2_->height = _tmp0_;
	_tmp1_ = self->priv->_width;
	_data2_->width = _tmp1_;
	_tmp2_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _data2_->width, _data2_->height);
	original = _tmp2_;
	_tmp3_ = original;
	_tmp4_ = cairo_create (_tmp3_);
	cr = _tmp4_;
	_tmp5_ = cr;
	cairo_set_operator (_tmp5_, CAIRO_OPERATOR_SOURCE);
	_tmp6_ = cr;
	_tmp7_ = gala_drawing_buffer_surface_get_surface (self);
	_tmp8_ = _tmp7_;
	cairo_set_source_surface (_tmp6_, _tmp8_, (gdouble) 0, (gdouble) 0);
	_tmp9_ = cr;
	cairo_paint (_tmp9_);
	_tmp10_ = original;
	_tmp11_ = cairo_image_surface_get_data (_tmp10_);
	_data2_->pixels = _tmp11_;
	{
		GThread* th = NULL;
		GThread* _tmp12_;
		guint8* _tmp13_;
		GThread* _tmp14_;
		GThread* th2 = NULL;
		GThread* _tmp15_;
		guint8* _tmp16_;
		GThread* _tmp17_;
		_tmp12_ = g_thread_try_new (NULL, ____lambda11__gthread_func, block2_data_ref (_data2_), &_inner_error0_);
		th = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp13_ = _data2_->pixels;
		gala_drawing_buffer_surface_exponential_blur_rows (self, _tmp13_, _data2_->width, _data2_->height, _data2_->height / 2, _data2_->height, 0, _data2_->width, _data2_->alpha);
		_tmp14_ = th;
		th = NULL;
		g_thread_join (_tmp14_);
		_tmp15_ = g_thread_try_new (NULL, ____lambda12__gthread_func, block2_data_ref (_data2_), &_inner_error0_);
		th2 = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_thread_unref0 (th);
			goto __catch0_g_error;
		}
		_tmp16_ = _data2_->pixels;
		gala_drawing_buffer_surface_exponential_blur_columns (self, _tmp16_, _data2_->width, _data2_->height, _data2_->width / 2, _data2_->width, 0, _data2_->height, _data2_->alpha);
		_tmp17_ = th2;
		th2 = NULL;
		g_thread_join (_tmp17_);
		_g_thread_unref0 (th2);
		_g_thread_unref0 (th);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = err;
		_tmp19_ = _tmp18_->message;
		g_warning ("BufferSurface.vala:393: %s", _tmp19_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (original);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = original;
	cairo_surface_mark_dirty (_tmp20_);
	_tmp21_ = gala_drawing_buffer_surface_get_context (self);
	_tmp22_ = _tmp21_;
	cairo_set_operator (_tmp22_, CAIRO_OPERATOR_SOURCE);
	_tmp23_ = gala_drawing_buffer_surface_get_context (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = original;
	cairo_set_source_surface (_tmp24_, _tmp25_, (gdouble) 0, (gdouble) 0);
	_tmp26_ = gala_drawing_buffer_surface_get_context (self);
	_tmp27_ = _tmp26_;
	cairo_paint (_tmp27_);
	_tmp28_ = gala_drawing_buffer_surface_get_context (self);
	_tmp29_ = _tmp28_;
	cairo_set_operator (_tmp29_, CAIRO_OPERATOR_OVER);
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (original);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
gala_drawing_buffer_surface_exponential_blur_columns (GalaDrawingBufferSurface* self,
                                                      guint8* pixels,
                                                      gint width,
                                                      gint height,
                                                      gint start_col,
                                                      gint end_col,
                                                      gint start_y,
                                                      gint end_y,
                                                      gint alpha)
{
	g_return_if_fail (self != NULL);
	{
		gint column_index = 0;
		column_index = start_col;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint8* column = NULL;
				gint z_alpha = 0;
				guint8* _tmp2_;
				guint8 _tmp3_;
				gint z_red = 0;
				guint8* _tmp4_;
				guint8 _tmp5_;
				gint z_green = 0;
				guint8* _tmp6_;
				guint8 _tmp7_;
				gint z_blue = 0;
				guint8* _tmp8_;
				guint8 _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = column_index;
					column_index = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(column_index < end_col)) {
					break;
				}
				column = pixels + (column_index * 4);
				_tmp2_ = column;
				_tmp3_ = _tmp2_[0];
				z_alpha = _tmp3_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION;
				_tmp4_ = column;
				_tmp5_ = _tmp4_[1];
				z_red = _tmp5_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION;
				_tmp6_ = column;
				_tmp7_ = _tmp6_[2];
				z_green = _tmp7_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION;
				_tmp8_ = column;
				_tmp9_ = _tmp8_[3];
				z_blue = _tmp9_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION;
				{
					gint index = 0;
					index = width * (start_y + 1);
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							guint8* _tmp11_;
							if (!_tmp10_) {
								index += width;
							}
							_tmp10_ = FALSE;
							if (!(index < ((end_y - 1) * width))) {
								break;
							}
							_tmp11_ = column;
							gala_drawing_buffer_surface_exponential_blur_inner (&_tmp11_[index * 4], &z_alpha, &z_red, &z_green, &z_blue, alpha);
						}
					}
				}
				{
					gint index = 0;
					index = (end_y - 2) * width;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							guint8* _tmp13_;
							if (!_tmp12_) {
								index -= width;
							}
							_tmp12_ = FALSE;
							if (!(index >= start_y)) {
								break;
							}
							_tmp13_ = column;
							gala_drawing_buffer_surface_exponential_blur_inner (&_tmp13_[index * 4], &z_alpha, &z_red, &z_green, &z_blue, alpha);
						}
					}
				}
			}
		}
	}
}

static void
gala_drawing_buffer_surface_exponential_blur_rows (GalaDrawingBufferSurface* self,
                                                   guint8* pixels,
                                                   gint width,
                                                   gint height,
                                                   gint start_row,
                                                   gint end_row,
                                                   gint start_x,
                                                   gint end_x,
                                                   gint alpha)
{
	g_return_if_fail (self != NULL);
	{
		gint row_index = 0;
		row_index = start_row;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint8* row = NULL;
				gint z_alpha = 0;
				guint8* _tmp2_;
				guint8 _tmp3_;
				gint z_red = 0;
				guint8* _tmp4_;
				guint8 _tmp5_;
				gint z_green = 0;
				guint8* _tmp6_;
				guint8 _tmp7_;
				gint z_blue = 0;
				guint8* _tmp8_;
				guint8 _tmp9_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = row_index;
					row_index = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(row_index < end_row)) {
					break;
				}
				row = pixels + ((row_index * width) * 4);
				_tmp2_ = row;
				_tmp3_ = _tmp2_[start_x + 0];
				z_alpha = _tmp3_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION;
				_tmp4_ = row;
				_tmp5_ = _tmp4_[start_x + 1];
				z_red = _tmp5_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION;
				_tmp6_ = row;
				_tmp7_ = _tmp6_[start_x + 2];
				z_green = _tmp7_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION;
				_tmp8_ = row;
				_tmp9_ = _tmp8_[start_x + 3];
				z_blue = _tmp9_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION;
				{
					gint index = 0;
					index = start_x + 1;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							guint8* _tmp12_;
							if (!_tmp10_) {
								gint _tmp11_;
								_tmp11_ = index;
								index = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							if (!(index < end_x)) {
								break;
							}
							_tmp12_ = row;
							gala_drawing_buffer_surface_exponential_blur_inner (&_tmp12_[index * 4], &z_alpha, &z_red, &z_green, &z_blue, alpha);
						}
					}
				}
				{
					gint index = 0;
					index = end_x - 2;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							guint8* _tmp15_;
							if (!_tmp13_) {
								gint _tmp14_;
								_tmp14_ = index;
								index = _tmp14_ - 1;
							}
							_tmp13_ = FALSE;
							if (!(index >= start_x)) {
								break;
							}
							_tmp15_ = row;
							gala_drawing_buffer_surface_exponential_blur_inner (&_tmp15_[index * 4], &z_alpha, &z_red, &z_green, &z_blue, alpha);
						}
					}
				}
			}
		}
	}
}

static inline void
gala_drawing_buffer_surface_exponential_blur_inner (guint8* pixel,
                                                    gint* z_alpha,
                                                    gint* z_red,
                                                    gint* z_green,
                                                    gint* z_blue,
                                                    gint alpha)
{
	guint8 _tmp0_;
	guint8 _tmp1_;
	guint8 _tmp2_;
	guint8 _tmp3_;
	_tmp0_ = pixel[0];
	*z_alpha = (*z_alpha) + ((alpha * ((_tmp0_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION) - (*z_alpha))) >> GALA_DRAWING_BUFFER_SURFACE_ALPHA_PRECISION);
	_tmp1_ = pixel[1];
	*z_red = (*z_red) + ((alpha * ((_tmp1_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION) - (*z_red))) >> GALA_DRAWING_BUFFER_SURFACE_ALPHA_PRECISION);
	_tmp2_ = pixel[2];
	*z_green = (*z_green) + ((alpha * ((_tmp2_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION) - (*z_green))) >> GALA_DRAWING_BUFFER_SURFACE_ALPHA_PRECISION);
	_tmp3_ = pixel[3];
	*z_blue = (*z_blue) + ((alpha * ((_tmp3_ << GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION) - (*z_blue))) >> GALA_DRAWING_BUFFER_SURFACE_ALPHA_PRECISION);
	pixel[0] = (guint8) ((*z_alpha) >> GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION);
	pixel[1] = (guint8) ((*z_red) >> GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION);
	pixel[2] = (guint8) ((*z_green) >> GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION);
	pixel[3] = (guint8) ((*z_blue) >> GALA_DRAWING_BUFFER_SURFACE_PARAM_PRECISION);
}

/**
        * Performs a blur operation on the internal {@link Cairo.Surface}, using a
        * gaussian blurring algorithm. This method is very slow, albeit producing
        * debatably the best-looking results, and in most cases developers should
        * use the exponential blurring algorithm instead.
        *
        * @param radius the blur radius
        */
static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		GalaDrawingBufferSurface* self;
		self = _data3_->self;
		_data3_->shiftar = (g_free (_data3_->shiftar), NULL);
		_data3_->buffer_b = (g_free (_data3_->buffer_b), NULL);
		_data3_->buffer_a = (g_free (_data3_->buffer_a), NULL);
		_data3_->kernel = (g_free (_data3_->kernel), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void*
___lambda13_ (Block3Data* _data3_)
{
	GalaDrawingBufferSurface* self;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	void* result;
	self = _data3_->self;
	_tmp0_ = _data3_->buffer_a;
	_tmp0__length1 = _data3_->buffer_a_length1;
	_tmp1_ = _data3_->buffer_b;
	_tmp1__length1 = _data3_->buffer_b_length1;
	_tmp2_ = _data3_->kernel;
	_tmp2__length1 = _data3_->kernel_length1;
	_tmp3_ = _data3_->shiftar;
	_tmp3__length1 = _data3_->shiftar_length1;
	_tmp3__length2 = _data3_->shiftar_length2;
	gala_drawing_buffer_surface_gaussian_blur_horizontal (self, _tmp0_, _tmp1_, _tmp2_, _data3_->gauss_width, _data3_->width, _data3_->height, 0, _data3_->height / 2, _tmp3_, (gint) _tmp3__length1, (gint) _tmp3__length2);
	result = NULL;
	return result;
}

static gpointer
____lambda13__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda13_ (self);
	block3_data_unref (self);
	return result;
}

static void*
___lambda14_ (Block3Data* _data3_)
{
	GalaDrawingBufferSurface* self;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	void* result;
	self = _data3_->self;
	_tmp0_ = _data3_->buffer_b;
	_tmp0__length1 = _data3_->buffer_b_length1;
	_tmp1_ = _data3_->buffer_a;
	_tmp1__length1 = _data3_->buffer_a_length1;
	_tmp2_ = _data3_->kernel;
	_tmp2__length1 = _data3_->kernel_length1;
	_tmp3_ = _data3_->shiftar;
	_tmp3__length1 = _data3_->shiftar_length1;
	_tmp3__length2 = _data3_->shiftar_length2;
	gala_drawing_buffer_surface_gaussian_blur_vertical (self, _tmp0_, _tmp1_, _tmp2_, _data3_->gauss_width, _data3_->width, _data3_->height, 0, _data3_->width / 2, _tmp3_, (gint) _tmp3__length1, (gint) _tmp3__length2);
	result = NULL;
	return result;
}

static gpointer
____lambda14__gthread_func (gpointer self)
{
	gpointer result;
	result = ___lambda14_ (self);
	block3_data_unref (self);
	return result;
}

void
gala_drawing_buffer_surface_gaussian_blur (GalaDrawingBufferSurface* self,
                                           gint radius)
{
	Block3Data* _data3_;
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	cairo_surface_t* original = NULL;
	cairo_surface_t* _tmp4_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	cairo_t* _tmp8_;
	cairo_surface_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_t* _tmp11_;
	guint8* src = NULL;
	cairo_surface_t* _tmp12_;
	guchar* _tmp13_;
	gint size = 0;
	cairo_surface_t* _tmp14_;
	gdouble* _tmp15_;
	gdouble* _tmp16_;
	gint* _tmp22_;
	cairo_surface_t* _tmp58_;
	cairo_t* _tmp59_;
	cairo_t* _tmp60_;
	cairo_t* _tmp61_;
	cairo_t* _tmp62_;
	cairo_surface_t* _tmp63_;
	cairo_t* _tmp64_;
	cairo_t* _tmp65_;
	cairo_t* _tmp66_;
	cairo_t* _tmp67_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->gauss_width = (radius * 2) + 1;
	_tmp1_ = gala_drawing_buffer_surface_build_gaussian_kernel (_data3_->gauss_width, &_tmp0_);
	_data3_->kernel = _tmp1_;
	_data3_->kernel_length1 = _tmp0_;
	_data3_->_kernel_size_ = _data3_->kernel_length1;
	_tmp2_ = self->priv->_width;
	_data3_->width = _tmp2_;
	_tmp3_ = self->priv->_height;
	_data3_->height = _tmp3_;
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _data3_->width, _data3_->height);
	original = _tmp4_;
	_tmp5_ = original;
	_tmp6_ = cairo_create (_tmp5_);
	cr = _tmp6_;
	_tmp7_ = cr;
	cairo_set_operator (_tmp7_, CAIRO_OPERATOR_SOURCE);
	_tmp8_ = cr;
	_tmp9_ = gala_drawing_buffer_surface_get_surface (self);
	_tmp10_ = _tmp9_;
	cairo_set_source_surface (_tmp8_, _tmp10_, (gdouble) 0, (gdouble) 0);
	_tmp11_ = cr;
	cairo_paint (_tmp11_);
	_tmp12_ = original;
	_tmp13_ = cairo_image_surface_get_data (_tmp12_);
	src = _tmp13_;
	_tmp14_ = original;
	size = _data3_->height * cairo_image_surface_get_stride (_tmp14_);
	_tmp15_ = g_new0 (gdouble, size);
	_data3_->buffer_a = _tmp15_;
	_data3_->buffer_a_length1 = size;
	_data3_->_buffer_a_size_ = _data3_->buffer_a_length1;
	_tmp16_ = g_new0 (gdouble, size);
	_data3_->buffer_b = _tmp16_;
	_data3_->buffer_b_length1 = size;
	_data3_->_buffer_b_size_ = _data3_->buffer_b_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gdouble* _tmp19_;
				gint _tmp19__length1;
				guint8* _tmp20_;
				guint8 _tmp21_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp19_ = _data3_->buffer_a;
				_tmp19__length1 = _data3_->buffer_a_length1;
				_tmp20_ = src;
				_tmp21_ = _tmp20_[i];
				_tmp19_[i] = (gdouble) _tmp21_;
			}
		}
	}
	_tmp22_ = g_new0 (gint, MAX (_data3_->width, _data3_->height) * _data3_->gauss_width);
	_data3_->shiftar = _tmp22_;
	_data3_->shiftar_length1 = MAX (_data3_->width, _data3_->height);
	_data3_->shiftar_length2 = _data3_->gauss_width;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				if (!_tmp23_) {
					gint _tmp24_;
					_tmp24_ = x;
					x = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				if (!(x < _data3_->width)) {
					break;
				}
				{
					gint k = 0;
					k = 0;
					{
						gboolean _tmp25_ = FALSE;
						_tmp25_ = TRUE;
						while (TRUE) {
							gint shift = 0;
							gboolean _tmp27_ = FALSE;
							if (!_tmp25_) {
								gint _tmp26_;
								_tmp26_ = k;
								k = _tmp26_ + 1;
							}
							_tmp25_ = FALSE;
							if (!(k < _data3_->gauss_width)) {
								break;
							}
							shift = k - radius;
							if ((x + shift) <= 0) {
								_tmp27_ = TRUE;
							} else {
								_tmp27_ = (x + shift) >= _data3_->width;
							}
							if (_tmp27_) {
								gint* _tmp28_;
								gint _tmp28__length1;
								gint _tmp28__length2;
								_tmp28_ = _data3_->shiftar;
								_tmp28__length1 = _data3_->shiftar_length1;
								_tmp28__length2 = _data3_->shiftar_length2;
								_tmp28_[(x * _tmp28__length2) + k] = 0;
							} else {
								gint* _tmp29_;
								gint _tmp29__length1;
								gint _tmp29__length2;
								_tmp29_ = _data3_->shiftar;
								_tmp29__length1 = _data3_->shiftar_length1;
								_tmp29__length2 = _data3_->shiftar_length2;
								_tmp29_[(x * _tmp29__length2) + k] = shift * 4;
							}
						}
					}
				}
			}
		}
	}
	{
		GThread* th = NULL;
		GThread* _tmp30_;
		gdouble* _tmp31_;
		gint _tmp31__length1;
		gdouble* _tmp32_;
		gint _tmp32__length1;
		gdouble* _tmp33_;
		gint _tmp33__length1;
		gint* _tmp34_;
		gint _tmp34__length1;
		gint _tmp34__length2;
		GThread* _tmp35_;
		gdouble* _tmp36_;
		gint _tmp36__length1;
		gint* _tmp37_;
		GThread* th2 = NULL;
		GThread* _tmp45_;
		gdouble* _tmp46_;
		gint _tmp46__length1;
		gdouble* _tmp47_;
		gint _tmp47__length1;
		gdouble* _tmp48_;
		gint _tmp48__length1;
		gint* _tmp49_;
		gint _tmp49__length1;
		gint _tmp49__length2;
		GThread* _tmp50_;
		_tmp30_ = g_thread_try_new (NULL, ____lambda13__gthread_func, block3_data_ref (_data3_), &_inner_error0_);
		th = _tmp30_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp31_ = _data3_->buffer_a;
		_tmp31__length1 = _data3_->buffer_a_length1;
		_tmp32_ = _data3_->buffer_b;
		_tmp32__length1 = _data3_->buffer_b_length1;
		_tmp33_ = _data3_->kernel;
		_tmp33__length1 = _data3_->kernel_length1;
		_tmp34_ = _data3_->shiftar;
		_tmp34__length1 = _data3_->shiftar_length1;
		_tmp34__length2 = _data3_->shiftar_length2;
		gala_drawing_buffer_surface_gaussian_blur_horizontal (self, _tmp31_, _tmp32_, _tmp33_, _data3_->gauss_width, _data3_->width, _data3_->height, _data3_->height / 2, _data3_->height, _tmp34_, (gint) _tmp34__length1, (gint) _tmp34__length2);
		_tmp35_ = th;
		th = NULL;
		g_thread_join (_tmp35_);
		_tmp36_ = _data3_->buffer_a;
		_tmp36__length1 = _data3_->buffer_a_length1;
		memset (_tmp36_, 0, (gsize) (sizeof (gdouble) * size));
		_tmp37_ = g_new0 (gint, MAX (_data3_->width, _data3_->height) * _data3_->gauss_width);
		_data3_->shiftar = (g_free (_data3_->shiftar), NULL);
		_data3_->shiftar = _tmp37_;
		_data3_->shiftar_length1 = MAX (_data3_->width, _data3_->height);
		_data3_->shiftar_length2 = _data3_->gauss_width;
		{
			gint y = 0;
			y = 0;
			{
				gboolean _tmp38_ = FALSE;
				_tmp38_ = TRUE;
				while (TRUE) {
					if (!_tmp38_) {
						gint _tmp39_;
						_tmp39_ = y;
						y = _tmp39_ + 1;
					}
					_tmp38_ = FALSE;
					if (!(y < _data3_->height)) {
						break;
					}
					{
						gint k = 0;
						k = 0;
						{
							gboolean _tmp40_ = FALSE;
							_tmp40_ = TRUE;
							while (TRUE) {
								gint shift = 0;
								gboolean _tmp42_ = FALSE;
								if (!_tmp40_) {
									gint _tmp41_;
									_tmp41_ = k;
									k = _tmp41_ + 1;
								}
								_tmp40_ = FALSE;
								if (!(k < _data3_->gauss_width)) {
									break;
								}
								shift = k - radius;
								if ((y + shift) <= 0) {
									_tmp42_ = TRUE;
								} else {
									_tmp42_ = (y + shift) >= _data3_->height;
								}
								if (_tmp42_) {
									gint* _tmp43_;
									gint _tmp43__length1;
									gint _tmp43__length2;
									_tmp43_ = _data3_->shiftar;
									_tmp43__length1 = _data3_->shiftar_length1;
									_tmp43__length2 = _data3_->shiftar_length2;
									_tmp43_[(y * _tmp43__length2) + k] = 0;
								} else {
									gint* _tmp44_;
									gint _tmp44__length1;
									gint _tmp44__length2;
									_tmp44_ = _data3_->shiftar;
									_tmp44__length1 = _data3_->shiftar_length1;
									_tmp44__length2 = _data3_->shiftar_length2;
									_tmp44_[(y * _tmp44__length2) + k] = (shift * _data3_->width) * 4;
								}
							}
						}
					}
				}
			}
		}
		_tmp45_ = g_thread_try_new (NULL, ____lambda14__gthread_func, block3_data_ref (_data3_), &_inner_error0_);
		th2 = _tmp45_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_thread_unref0 (th);
			goto __catch0_g_error;
		}
		_tmp46_ = _data3_->buffer_b;
		_tmp46__length1 = _data3_->buffer_b_length1;
		_tmp47_ = _data3_->buffer_a;
		_tmp47__length1 = _data3_->buffer_a_length1;
		_tmp48_ = _data3_->kernel;
		_tmp48__length1 = _data3_->kernel_length1;
		_tmp49_ = _data3_->shiftar;
		_tmp49__length1 = _data3_->shiftar_length1;
		_tmp49__length2 = _data3_->shiftar_length2;
		gala_drawing_buffer_surface_gaussian_blur_vertical (self, _tmp46_, _tmp47_, _tmp48_, _data3_->gauss_width, _data3_->width, _data3_->height, _data3_->width / 2, _data3_->width, _tmp49_, (gint) _tmp49__length1, (gint) _tmp49__length2);
		_tmp50_ = th2;
		th2 = NULL;
		g_thread_join (_tmp50_);
		_g_thread_unref0 (th2);
		_g_thread_unref0 (th);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp51_;
		const gchar* _tmp52_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp51_ = err;
		_tmp52_ = _tmp51_->message;
		g_message ("BufferSurface.vala:601: %s", _tmp52_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (original);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp53_ = FALSE;
			_tmp53_ = TRUE;
			while (TRUE) {
				guint8* _tmp55_;
				gdouble* _tmp56_;
				gint _tmp56__length1;
				gdouble _tmp57_;
				if (!_tmp53_) {
					gint _tmp54_;
					_tmp54_ = i;
					i = _tmp54_ + 1;
				}
				_tmp53_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp55_ = src;
				_tmp56_ = _data3_->buffer_a;
				_tmp56__length1 = _data3_->buffer_a_length1;
				_tmp57_ = _tmp56_[i];
				_tmp55_[i] = (guint8) _tmp57_;
			}
		}
	}
	_tmp58_ = original;
	cairo_surface_mark_dirty (_tmp58_);
	_tmp59_ = gala_drawing_buffer_surface_get_context (self);
	_tmp60_ = _tmp59_;
	cairo_set_operator (_tmp60_, CAIRO_OPERATOR_SOURCE);
	_tmp61_ = gala_drawing_buffer_surface_get_context (self);
	_tmp62_ = _tmp61_;
	_tmp63_ = original;
	cairo_set_source_surface (_tmp62_, _tmp63_, (gdouble) 0, (gdouble) 0);
	_tmp64_ = gala_drawing_buffer_surface_get_context (self);
	_tmp65_ = _tmp64_;
	cairo_paint (_tmp65_);
	_tmp66_ = gala_drawing_buffer_surface_get_context (self);
	_tmp67_ = _tmp66_;
	cairo_set_operator (_tmp67_, CAIRO_OPERATOR_OVER);
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (original);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
gala_drawing_buffer_surface_gaussian_blur_horizontal (GalaDrawingBufferSurface* self,
                                                      gdouble* src,
                                                      gdouble* dest,
                                                      gdouble* kernel,
                                                      gint gauss_width,
                                                      gint width,
                                                      gint height,
                                                      gint start_row,
                                                      gint end_row,
                                                      gint* shift,
                                                      gint shift_length1,
                                                      gint shift_length2)
{
	guint32 cur_pixel = 0U;
	g_return_if_fail (self != NULL);
	cur_pixel = (guint32) ((start_row * width) * 4);
	{
		gint y = 0;
		y = start_row;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(y < end_row)) {
					break;
				}
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = x;
								x = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(x < width)) {
								break;
							}
							{
								gint k = 0;
								k = 0;
								{
									gboolean _tmp4_ = FALSE;
									_tmp4_ = TRUE;
									while (TRUE) {
										guint32 source = 0U;
										gint _tmp6_;
										gdouble _tmp7_;
										gdouble _tmp8_;
										gdouble _tmp9_;
										gdouble _tmp10_;
										gdouble _tmp11_;
										gdouble _tmp12_;
										gdouble _tmp13_;
										gdouble _tmp14_;
										if (!_tmp4_) {
											gint _tmp5_;
											_tmp5_ = k;
											k = _tmp5_ + 1;
										}
										_tmp4_ = FALSE;
										if (!(k < gauss_width)) {
											break;
										}
										_tmp6_ = shift[(x * shift_length2) + k];
										source = cur_pixel + _tmp6_;
										_tmp7_ = src[source + 0];
										_tmp8_ = kernel[k];
										dest[cur_pixel + 0] += _tmp7_ * _tmp8_;
										_tmp9_ = src[source + 1];
										_tmp10_ = kernel[k];
										dest[cur_pixel + 1] += _tmp9_ * _tmp10_;
										_tmp11_ = src[source + 2];
										_tmp12_ = kernel[k];
										dest[cur_pixel + 2] += _tmp11_ * _tmp12_;
										_tmp13_ = src[source + 3];
										_tmp14_ = kernel[k];
										dest[cur_pixel + 3] += _tmp13_ * _tmp14_;
									}
								}
							}
							cur_pixel += (guint32) 4;
						}
					}
				}
			}
		}
	}
}

static void
gala_drawing_buffer_surface_gaussian_blur_vertical (GalaDrawingBufferSurface* self,
                                                    gdouble* src,
                                                    gdouble* dest,
                                                    gdouble* kernel,
                                                    gint gauss_width,
                                                    gint width,
                                                    gint height,
                                                    gint start_col,
                                                    gint end_col,
                                                    gint* shift,
                                                    gint shift_length1,
                                                    gint shift_length2)
{
	guint32 cur_pixel = 0U;
	g_return_if_fail (self != NULL);
	cur_pixel = (guint32) (start_col * 4);
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = y;
					y = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(y < height)) {
					break;
				}
				{
					gint x = 0;
					x = start_col;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = x;
								x = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(x < end_col)) {
								break;
							}
							{
								gint k = 0;
								k = 0;
								{
									gboolean _tmp4_ = FALSE;
									_tmp4_ = TRUE;
									while (TRUE) {
										guint32 source = 0U;
										gint _tmp6_;
										gdouble _tmp7_;
										gdouble _tmp8_;
										gdouble _tmp9_;
										gdouble _tmp10_;
										gdouble _tmp11_;
										gdouble _tmp12_;
										gdouble _tmp13_;
										gdouble _tmp14_;
										if (!_tmp4_) {
											gint _tmp5_;
											_tmp5_ = k;
											k = _tmp5_ + 1;
										}
										_tmp4_ = FALSE;
										if (!(k < gauss_width)) {
											break;
										}
										_tmp6_ = shift[(y * shift_length2) + k];
										source = cur_pixel + _tmp6_;
										_tmp7_ = src[source + 0];
										_tmp8_ = kernel[k];
										dest[cur_pixel + 0] += _tmp7_ * _tmp8_;
										_tmp9_ = src[source + 1];
										_tmp10_ = kernel[k];
										dest[cur_pixel + 1] += _tmp9_ * _tmp10_;
										_tmp11_ = src[source + 2];
										_tmp12_ = kernel[k];
										dest[cur_pixel + 2] += _tmp11_ * _tmp12_;
										_tmp13_ = src[source + 3];
										_tmp14_ = kernel[k];
										dest[cur_pixel + 3] += _tmp13_ * _tmp14_;
									}
								}
							}
							cur_pixel += (guint32) 4;
						}
					}
				}
				cur_pixel += (guint32) (((width - end_col) + start_col) * 4);
			}
		}
	}
}

static gdouble*
gala_drawing_buffer_surface_build_gaussian_kernel (gint gauss_width,
                                                   gint* result_length1)
{
	gdouble* kernel = NULL;
	gdouble* _tmp0_;
	gint kernel_length1;
	gint _kernel_size_;
	gdouble sd = 0.0;
	gint range = 0;
	gdouble mean = 0.0;
	gdouble gauss_sum = 0.0;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble* _tmp12_;
	gint _tmp12__length1;
	gdouble* result;
	_vala_return_val_if_fail ((gauss_width % 2) == 1, "gauss_width % 2 == 1", NULL);
	_tmp0_ = g_new0 (gdouble, gauss_width);
	kernel = _tmp0_;
	kernel_length1 = gauss_width;
	_kernel_size_ = kernel_length1;
	sd = 255.0;
	range = gauss_width;
	mean = range / sd;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gdouble* _tmp3_;
				gint _tmp3__length1;
				gdouble* _tmp4_;
				gint _tmp4__length1;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < ((gauss_width / 2) + 1))) {
					break;
				}
				_tmp3_ = kernel;
				_tmp3__length1 = kernel_length1;
				_tmp4_ = kernel;
				_tmp4__length1 = kernel_length1;
				_tmp4_[i] = pow (sin ((((i + 1) * (G_PI / 2)) - mean) / range), (gdouble) 2) * sd;
				_tmp3_[(gauss_width - i) - 1] = _tmp4_[i];
			}
		}
	}
	gauss_sum = 0.0;
	_tmp5_ = kernel;
	_tmp5__length1 = kernel_length1;
	{
		gdouble* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = _tmp5_;
		d_collection_length1 = _tmp5__length1;
		for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
			gdouble d = 0.0;
			d = d_collection[d_it];
			{
				gauss_sum += d;
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gdouble* _tmp8_;
				gint _tmp8__length1;
				gdouble* _tmp9_;
				gint _tmp9__length1;
				gdouble* _tmp10_;
				gint _tmp10__length1;
				gdouble _tmp11_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = kernel;
				_tmp8__length1 = kernel_length1;
				if (!(i < _tmp8__length1)) {
					break;
				}
				_tmp9_ = kernel;
				_tmp9__length1 = kernel_length1;
				_tmp10_ = kernel;
				_tmp10__length1 = kernel_length1;
				_tmp11_ = _tmp10_[i];
				_tmp9_[i] = _tmp11_ / gauss_sum;
			}
		}
	}
	_tmp12_ = kernel;
	_tmp12__length1 = kernel_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	return result;
}

cairo_surface_t*
gala_drawing_buffer_surface_get_surface (GalaDrawingBufferSurface* self)
{
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_;
	cairo_surface_t* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_surface;
	if (_tmp0_ == NULL) {
		gint _tmp1_;
		gint _tmp2_;
		cairo_surface_t* _tmp3_;
		_tmp1_ = self->priv->_width;
		_tmp2_ = self->priv->_height;
		_tmp3_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp1_, _tmp2_);
		_cairo_surface_destroy0 (self->priv->_surface);
		self->priv->_surface = _tmp3_;
	}
	_tmp4_ = self->priv->_surface;
	result = _tmp4_;
	return result;
}

static gpointer
_cairo_surface_reference0 (gpointer self)
{
	return self ? cairo_surface_reference (self) : NULL;
}

static void
gala_drawing_buffer_surface_set_surface (GalaDrawingBufferSurface* self,
                                         cairo_surface_t* value)
{
	cairo_surface_t* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _cairo_surface_reference0 (value);
	_cairo_surface_destroy0 (self->priv->_surface);
	self->priv->_surface = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, gala_drawing_buffer_surface_properties[GALA_DRAWING_BUFFER_SURFACE_SURFACE_PROPERTY]);
}

gint
gala_drawing_buffer_surface_get_width (GalaDrawingBufferSurface* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
	return result;
}

static void
gala_drawing_buffer_surface_set_width (GalaDrawingBufferSurface* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_drawing_buffer_surface_get_width (self);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, gala_drawing_buffer_surface_properties[GALA_DRAWING_BUFFER_SURFACE_WIDTH_PROPERTY]);
	}
}

gint
gala_drawing_buffer_surface_get_height (GalaDrawingBufferSurface* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_height;
	return result;
}

static void
gala_drawing_buffer_surface_set_height (GalaDrawingBufferSurface* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_drawing_buffer_surface_get_height (self);
	if (old_value != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, gala_drawing_buffer_surface_properties[GALA_DRAWING_BUFFER_SURFACE_HEIGHT_PROPERTY]);
	}
}

cairo_t*
gala_drawing_buffer_surface_get_context (GalaDrawingBufferSurface* self)
{
	cairo_t* result;
	cairo_t* _tmp0_;
	cairo_t* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_context;
	if (_tmp0_ == NULL) {
		cairo_surface_t* _tmp1_;
		cairo_surface_t* _tmp2_;
		cairo_t* _tmp3_;
		_tmp1_ = gala_drawing_buffer_surface_get_surface (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = cairo_create (_tmp2_);
		_cairo_destroy0 (self->priv->_context);
		self->priv->_context = _tmp3_;
	}
	_tmp4_ = self->priv->_context;
	result = _tmp4_;
	return result;
}

static void
gala_drawing_buffer_surface_class_init (GalaDrawingBufferSurfaceClass * klass,
                                        gpointer klass_data)
{
	gala_drawing_buffer_surface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaDrawingBufferSurface_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_drawing_buffer_surface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_drawing_buffer_surface_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_drawing_buffer_surface_finalize;
	/**
	        * The {@link Cairo.Surface} which will store the results of all drawing operations
	        * made with {@link Gala.Drawing.BufferSurface.context}.
	        */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAWING_BUFFER_SURFACE_SURFACE_PROPERTY, gala_drawing_buffer_surface_properties[GALA_DRAWING_BUFFER_SURFACE_SURFACE_PROPERTY] = g_param_spec_boxed ("surface", "surface", "surface", cairo_gobject_surface_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	        * The width of the {@link Gala.Drawing.BufferSurface}, in pixels.
	        */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAWING_BUFFER_SURFACE_WIDTH_PROPERTY, gala_drawing_buffer_surface_properties[GALA_DRAWING_BUFFER_SURFACE_WIDTH_PROPERTY] = g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	        * The height of the BufferSurface, in pixels.
	        */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAWING_BUFFER_SURFACE_HEIGHT_PROPERTY, gala_drawing_buffer_surface_properties[GALA_DRAWING_BUFFER_SURFACE_HEIGHT_PROPERTY] = g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	        * The {@link Cairo.Context} for the internal surface. All drawing operations done on this
	        * {@link Gala.Drawing.BufferSurface} should use this context.
	        */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_DRAWING_BUFFER_SURFACE_CONTEXT_PROPERTY, gala_drawing_buffer_surface_properties[GALA_DRAWING_BUFFER_SURFACE_CONTEXT_PROPERTY] = g_param_spec_boxed ("context", "context", "context", cairo_gobject_context_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gala_drawing_buffer_surface_instance_init (GalaDrawingBufferSurface * self,
                                           gpointer klass)
{
	self->priv = gala_drawing_buffer_surface_get_instance_private (self);
}

static void
gala_drawing_buffer_surface_finalize (GObject * obj)
{
	GalaDrawingBufferSurface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_DRAWING_TYPE_BUFFER_SURFACE, GalaDrawingBufferSurface);
	_cairo_surface_destroy0 (self->priv->_surface);
	_cairo_destroy0 (self->priv->_context);
	G_OBJECT_CLASS (gala_drawing_buffer_surface_parent_class)->finalize (obj);
}

/**
    * A buffer containing an internal Cairo-usable surface and context, designed
    * for usage with large, rarely updated draw operations.
    */
static GType
gala_drawing_buffer_surface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaDrawingBufferSurfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_drawing_buffer_surface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaDrawingBufferSurface), 0, (GInstanceInitFunc) gala_drawing_buffer_surface_instance_init, NULL };
	GType gala_drawing_buffer_surface_type_id;
	gala_drawing_buffer_surface_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaDrawingBufferSurface", &g_define_type_info, 0);
	GalaDrawingBufferSurface_private_offset = g_type_add_instance_private (gala_drawing_buffer_surface_type_id, sizeof (GalaDrawingBufferSurfacePrivate));
	return gala_drawing_buffer_surface_type_id;
}

GType
gala_drawing_buffer_surface_get_type (void)
{
	static volatile gsize gala_drawing_buffer_surface_type_id__once = 0;
	if (g_once_init_enter (&gala_drawing_buffer_surface_type_id__once)) {
		GType gala_drawing_buffer_surface_type_id;
		gala_drawing_buffer_surface_type_id = gala_drawing_buffer_surface_get_type_once ();
		g_once_init_leave (&gala_drawing_buffer_surface_type_id__once, gala_drawing_buffer_surface_type_id);
	}
	return gala_drawing_buffer_surface_type_id__once;
}

static void
_vala_gala_drawing_buffer_surface_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GalaDrawingBufferSurface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_DRAWING_TYPE_BUFFER_SURFACE, GalaDrawingBufferSurface);
	switch (property_id) {
		case GALA_DRAWING_BUFFER_SURFACE_SURFACE_PROPERTY:
		g_value_set_boxed (value, gala_drawing_buffer_surface_get_surface (self));
		break;
		case GALA_DRAWING_BUFFER_SURFACE_WIDTH_PROPERTY:
		g_value_set_int (value, gala_drawing_buffer_surface_get_width (self));
		break;
		case GALA_DRAWING_BUFFER_SURFACE_HEIGHT_PROPERTY:
		g_value_set_int (value, gala_drawing_buffer_surface_get_height (self));
		break;
		case GALA_DRAWING_BUFFER_SURFACE_CONTEXT_PROPERTY:
		g_value_set_boxed (value, gala_drawing_buffer_surface_get_context (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_drawing_buffer_surface_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GalaDrawingBufferSurface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_DRAWING_TYPE_BUFFER_SURFACE, GalaDrawingBufferSurface);
	switch (property_id) {
		case GALA_DRAWING_BUFFER_SURFACE_SURFACE_PROPERTY:
		gala_drawing_buffer_surface_set_surface (self, g_value_get_boxed (value));
		break;
		case GALA_DRAWING_BUFFER_SURFACE_WIDTH_PROPERTY:
		gala_drawing_buffer_surface_set_width (self, g_value_get_int (value));
		break;
		case GALA_DRAWING_BUFFER_SURFACE_HEIGHT_PROPERTY:
		gala_drawing_buffer_surface_set_height (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

