/*
 *  Warning: Do not edit this file.
 *  Auto-generated by 'beam_makeops'.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "sys.h"
#include "erl_vm.h"
#include "export.h"
#include "erl_process.h"
#include "bif.h"
#include "erl_atom_table.h"
#include "beam_load.h"

#include "erl_term.h"
#include "erl_map.h"
#include "big.h"
#include "erl_bits.h"
#include "erl_binary.h"
#include "beam_transform_helpers.h"
#include "erl_global_literals.h"

static int binary_too_big(LoaderState* S, BeamOpArg Size) {
  return Size.type == TAG_o ||
  (Size.type == TAG_u && ((Size.val >> (8*sizeof(Uint)-3)) != 0));;
}

static int consecutive_words(LoaderState* S, BeamOpArg S1, BeamOpArg D1, BeamOpArg S2, BeamOpArg D2) {
  return S1.type == S2.type && S1.val + 1 == S2.val &&
  D1.type == D2.type && D1.val + 1 == D2.val;;
}

static int distinct(LoaderState* S, BeamOpArg Val1, BeamOpArg Val2) {
  if (Val1.type != Val2.type) {
    return 1;
  } else if (Val1.type == TAG_x || Val1.type == TAG_y) {
    /* We must not compare the type indices (if any). */
    return (Val1.val & REG_MASK) != (Val2.val & REG_MASK);
  } else if (Val1.type == TAG_n) {
    /* NIL has no associated value. */
    return 0;
  } else {
    return Val1.val != Val2.val;
  };
}

static int equal(LoaderState* S, BeamOpArg Val1, BeamOpArg Val2) {
  if (Val1.type != Val2.type) {
    return 0;
  } else if (Val1.type == TAG_x || Val1.type == TAG_y) {
    /* We must not compare the type indices (if any). */
    return (Val1.val & REG_MASK) == (Val2.val & REG_MASK);
  } else if (Val1.type == TAG_n) {
    /* NIL has no associated value. */
    return 1;
  } else {
    return Val1.val == Val2.val;
  };
}

static int fixed_size_values(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  int i;

  if (Size.val < 2 || Size.val % 2 != 0) {
    return 0;
  }

  for (i = 0; i < Size.val; i += 2) {
    if (Rest[i+1].type != TAG_f) {
      return 0;
    }
    switch (Rest[i].type) {
      case TAG_a:
      case TAG_i:
      case TAG_v:
      break;
      case TAG_q:
      return is_float(beamfile_get_literal(&S->beam, Rest[i].val));
      default:
      return 0;
    }
  }

  return 1;;
}

static int floats_or_bignums(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  int i;

  if (Size.val < 2 || Size.val % 2 != 0) {
    return 0;
  }

  for (i = 0; i < Size.val; i += 2) {
    if (Rest[i].type != TAG_q) {
      return 0;
    }
    if (Rest[i+1].type != TAG_f) {
      return 0;
    }
  }

  return 1;;
}

static int is_empty_map(LoaderState* S, BeamOpArg Lit) {
  Eterm term;

  if (Lit.type != TAG_q) {
    return 0;
  }

  term = beamfile_get_literal(&S->beam, Lit.val);
  return is_flatmap(term) && flatmap_get_size(flatmap_val(term)) == 0;;
}

static int is_eq_exact_bif(LoaderState* S, BeamOpArg Bif) {
  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];

    return entry->module == am_erlang && entry->function == am_Eq && entry->arity == 2;
  }
  return 0;;
}

static int is_ge_bif(LoaderState* S, BeamOpArg Bif) {
  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];

    return entry->module == am_erlang && entry->function == am_Ge && entry->arity == 2;
  }
  return 0;;
}

static int is_heavy_bif(LoaderState* S, BeamOpArg Bif) {
  BeamFile_ImportEntry *import;
  Export *export;

  if (Bif.type != TAG_u || Bif.val >= S->beam.imports.count) {
    return 0;
  }

  import = &S->beam.imports.entries[Bif.val];
  export = erts_active_export_entry(import->module,
  import->function,
  import->arity);

  if (export->bif_number != -1) {
    return bif_table[export->bif_number].kind == BIF_KIND_HEAVY;
  }

  return 0;;
}

static int is_lt_bif(LoaderState* S, BeamOpArg Bif) {
  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];

    return entry->module == am_erlang && entry->function == am_Lt && entry->arity == 2;
  }
  return 0;;
}

static int is_mfa_bif(LoaderState* S, BeamOpArg M, BeamOpArg F, BeamOpArg A) {
  Export *e;

  ASSERT(M.type == TAG_a && F.type == TAG_a && A.type == TAG_u);
  e = erts_active_export_entry(M.val, F.val, A.val);

  if (e != NULL) {
    return e->bif_number != -1;
  }

  return 0;;
}

static int is_ne_exact_bif(LoaderState* S, BeamOpArg Bif) {
  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];

    return entry->module == am_erlang && entry->function == am_Neq && entry->arity == 2;
  }
  return 0;;
}

static int is_small_map_literal_keys(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  Uint pair_count = Size.val / 2;

  if (pair_count > MAP_SMALL_MAP_LIMIT) {
    return 0;
  }

  /*
  * Operations with non-literals have always only one key.
  */
  if (pair_count != 1) {
    return 1;
  }

  switch (Rest[0].type) {
    case TAG_a:
    case TAG_i:
    case TAG_n:
    case TAG_q:
    return 1;
    default:
    return 0;
  };
}

static int map_key_sort(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  return beam_load_map_key_sort(S, Size, Rest);;
}

static int mixed_types(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  int i;
  Uint type;

  if (Size.val < 2 || Size.val % 2 != 0) {
    return 0;
  }

  type = Rest[0].type;
  for (i = 0; i < Size.val; i += 2) {
    if (Rest[i].type != type) {
      return 1;
    }
  }

  return 0;;
}

static int never(LoaderState* S) {
  return 0;;
}

static int never_fails(LoaderState* S, BeamOpArg Bif) {
  static Eterm nofail_bifs[] =
  {am_Neqeq,
    am_Lt,
    am_Neq,
    am_Eq,
    am_Le,
    am_Eqeq,
    am_Gt,
    am_Ge,
    am_is_atom,
    am_is_boolean,
    am_is_binary,
    am_is_bitstring,
    am_is_float,
    am_is_integer,
    am_is_list,
    am_is_map,
    am_is_number,
    am_is_pid,
    am_is_port,
    am_is_reference,
    am_is_tuple,
  };

  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];
    int i;

    if (entry->module != am_erlang) {
      return 0;
    }

    if (entry->function == am_is_function) {
      /* Note that is_function/2 may fail. */
      return entry->arity == 1;
    }

    for (i = 0; i < sizeof(nofail_bifs) / sizeof(nofail_bifs[0]); i++) {
      if (entry->function == nofail_bifs[i]) {
        return 1;
      }
    }
  }
  return 0;;
}

static int smp_already_locked(LoaderState* S, BeamOpArg L) {
  ASSERT(L.type == TAG_u);
  return S->labels[L.val].looprec_targeted;;
}

static int smp_mark_target_label(LoaderState* S, BeamOpArg L) {
  ASSERT(L.type == TAG_f);
  S->labels[L.val].looprec_targeted = 1;
  return 1;;
}

static int use_jump_tab(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest, Uint MinSize) {
  Sint min, max;
  Sint i;

  if (Size.val < 2 * MinSize || Size.val % 2 != 0) {
    return 0;
  }

  if (Rest[0].type != TAG_i || Rest[1].type != TAG_f) {
    /* Atoms. Can't use a jump table. */
    return 0;
  }

  min = max = Rest[0].val;
  for (i = 2; i < Size.val; i += 2) {
    if (Rest[i].type != TAG_i || Rest[i+1].type != TAG_f) {
      return 0;
    }
    if (Rest[i].val < min) {
      min = Rest[i].val;
    } else if (max < Rest[i].val) {
      max = Rest[i].val;
    }
  }

  return max - min <= Size.val;;
}

int erts_beam_eval_predicate(unsigned int op, LoaderState* st, BeamOpArg var[], BeamOpArg* rest_args) {
  switch (op) {
    case 0: return never(st);
    case 1: return use_jump_tab(st, var[2], rest_args, 6);
    case 2: return equal(st, var[1], var[2]);
    case 3: return equal(st, var[0], var[3]);
    case 4: return use_jump_tab(st, var[4], rest_args, 6);
    case 5: return mixed_types(st, var[4], rest_args);
    case 6: return mixed_types(st, var[2], rest_args);
    case 7: return fixed_size_values(st, var[4], rest_args);
    case 8: return floats_or_bignums(st, var[2], rest_args);
    case 9: return fixed_size_values(st, var[2], rest_args);
    case 10: return equal(st, var[0], var[2]);
    case 11: return equal(st, var[1], var[3]);
    case 12: return equal(st, var[0], var[1]);
    case 13: return equal(st, var[0], var[4]);
    case 14: return consecutive_words(st, var[1], var[2], var[5], var[6]);
    case 15: return consecutive_words(st, var[1], var[6], var[5], var[2]);
    case 16: return equal(st, var[2], var[3]);
    case 17: return equal(st, var[2], var[4]);
    case 18: return consecutive_words(st, var[0], var[1], var[2], var[3]);
    case 19: return consecutive_words(st, var[0], var[3], var[2], var[1]);
    case 20: return consecutive_words(st, var[2], var[1], var[0], var[3]);
    case 21: return consecutive_words(st, var[2], var[3], var[0], var[1]);
    case 22: return smp_mark_target_label(st, var[0]);
    case 23: return smp_already_locked(st, var[0]);
    case 24: return equal(st, var[3], var[7]);
    case 25: return equal(st, var[2], var[5]);
    case 26: return equal(st, var[1], var[6]);
    case 27: return equal(st, var[6], var[4]);
    case 28: return equal(st, var[0], var[5]);
    case 29: return equal(st, var[5], var[2]);
    case 30: return equal(st, var[1], var[5]);
    case 31: return equal(st, var[4], var[2]);
    case 32: return equal(st, var[1], var[4]);
    case 33: return distinct(st, var[1], var[2]);
    case 34: return is_heavy_bif(st, var[0]);
    case 35: return is_heavy_bif(st, var[1]);
    case 36: return never_fails(st, var[1]);
    case 37: return is_eq_exact_bif(st, var[2]);
    case 38: return is_ne_exact_bif(st, var[2]);
    case 39: return is_ge_bif(st, var[2]);
    case 40: return is_lt_bif(st, var[2]);
    case 41: return is_mfa_bif(st, var[2], var[3], var[4]);
    case 42: return binary_too_big(st, var[1]);
    case 43: return map_key_sort(st, var[3], rest_args);
    case 44: return map_key_sort(st, var[4], rest_args);
    case 45: return is_empty_map(st, var[0]);
    case 46: return is_small_map_literal_keys(st, var[2], rest_args);
    case 47: return map_key_sort(st, var[2], rest_args);
    case 48: return equal(st, var[2], var[7]);
    case 49: return equal(st, var[3], var[8]);
    case 50: return distinct(st, var[2], var[4]);
    case 51: return distinct(st, var[3], var[4]);
    case 52: return equal(st, var[2], var[8]);
    case 53: return equal(st, var[3], var[9]);
    default: erts_exit(ERTS_ABORT_EXIT, "erts_beam_eval_predicate: invalid op %d\n", op);  }
}

static BeamOp* allocate_heap_zero(LoaderState* S, BeamOpArg Ns, BeamOpArg Nh, BeamOpArg Live) {
  BeamOp* alloc;
  BeamOp* init;
  int i;

  alloc = beamopallocator_new_op(&(S)->op_allocator);
  alloc->next = NULL;;
  init = beamopallocator_new_op(&(S)->op_allocator);
  init->next = NULL;;

  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    alloc->op = __make_opname__(allocate_heap, 3);
    alloc->arity = 3;
#undef __make_opname__
  } while (0);
  alloc->a[0] = Ns;
  alloc->a[1] = Nh;
  alloc->a[2] = Live;
  alloc->next = init;

  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    init->op = __make_opname__(init_yregs, 1);
    init->arity = 1;
#undef __make_opname__
  } while (0);
  ASSERT(init->a == init->def_args);

  init->arity = Ns.val+1;
  init->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, init->arity * sizeof(BeamOpArg));;
  init->a[0] = Ns;
  for (i = 0; i < Ns.val; i++) {
    init->a[i+1].type = TAG_y;
    init->a[i+1].val = i;
  }

  return alloc;;
}

static BeamOp* bs_match(LoaderState* S, BeamOpArg Fail, BeamOpArg Ctx, BeamOpArg N, BeamOpArg* List) {
  BeamOp* op;
  int fixed_args;
  int i;

  /*
  * If a BEAM file produced by a later version of Erlang/OTP
  * is accidentally loaded into an earlier version, ensure
  * that the loading fails (as opposed to crashing the runtime)
  * if there are any unknown sub commands.
  */
  i = 0;
  while (i < N.val) {
    BeamOpArg current = List[i++];

    if (current.type != TAG_a) {
      goto error;
    }

    switch (current.val) {
      case am_ensure_exactly:
      case am_skip:
      i += 1;
      break;
      case am_ensure_at_least:
      i += 2;
      break;
      case am_get_tail:
      case am_Eq:
      i += 3;
      break;
      case am_binary:
      case am_integer:
      i += 5;
      break;
      default: {
        error:
        op = beamopallocator_new_op(&(S)->op_allocator);
        op->next = NULL;;
        do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
          op->op = __make_opname__(bad_bs_match, 1);
          op->arity = 1;
#undef __make_opname__
        } while (0);
        op->a[0] = current;
        return op;
      }
    }
  }

  /*
  * Make sure that we don't attempt to pass any overflow tags to the JIT.
  */

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_match, 2);
    op->arity = 2;
#undef __make_opname__
  } while (0);
  fixed_args = op->arity;
  ASSERT(op->a == op->def_args);

  op->arity = (N.val + fixed_args);
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;

  op->a[0] = Fail;
  op->a[1] = Ctx;

  for (i = 0; i < N.val; i++) {
    BeamOpArg current;

    current = List[i];
    if (current.type == TAG_o) {
      /* An overflow tag (in ensure_at_least or ensure_exactly)
      * means that the match will always fail. */
      do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
        op->op = __make_opname__(jump, 1);
        op->arity = 1;
#undef __make_opname__
      } while (0);
      op->a[0] = Fail;
      return op;
    }
    op->a[i+fixed_args] = current;
  }

  return op;;
}

static BeamOp* combine_conses(LoaderState* S, BeamOpArg Len, BeamOpArg Dst, BeamOpArg Hd) {
  BeamOp* cons;
  BeamOp* tail;

  cons = beamopallocator_new_op(&(S)->op_allocator);
  cons->next = NULL;;
  tail = beamopallocator_new_op(&(S)->op_allocator);
  tail->next = NULL;;

  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    cons->op = __make_opname__(append_cons, 2);
    cons->arity = 2;
#undef __make_opname__
  } while (0);
  cons->a[0] = Len;
  cons->a[1] = Hd;
  cons->next = tail;

  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    tail->op = __make_opname__(store_cons, 2);
    tail->arity = 2;
#undef __make_opname__
  } while (0);
  tail->a[0].type = TAG_u;
  tail->a[0].val = Len.val + 1;
  tail->a[1] = Dst;

  return cons;;
}

static BeamOp* create_bin(LoaderState* S, BeamOpArg Fail, BeamOpArg Alloc, BeamOpArg Live, BeamOpArg Unit, BeamOpArg Dst, BeamOpArg N, BeamOpArg* Segments) {
  BeamOp* op;
  int fixed_args;
  int i;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_create_bin, 4);
    op->arity = 4;
#undef __make_opname__
  } while (0);
  fixed_args = op->arity;
  ASSERT(op->a == op->def_args);

  op->arity = (N.val + fixed_args);
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;

  op->a[0] = Fail;
  op->a[1] = Alloc;
  op->a[2] = Live;
  op->a[3] = Dst;

  for (i = 0; i < N.val; i += 6) {
    BeamOpArg Flags;
    Uint flags = 0;

    /* Copy all but flags. */
    op->a[i+fixed_args+0] = Segments[i+0];
    op->a[i+fixed_args+1] = Segments[i+1];
    op->a[i+fixed_args+2] = Segments[i+2];
    op->a[i+fixed_args+4] = Segments[i+4];
    op->a[i+fixed_args+5] = Segments[i+5];

    /* Translate flags. */
    Flags = Segments[i+3];              /* Flags */
    if (Flags.type != TAG_n) {
      if (Flags.type == TAG_q) {
        Eterm term = beamfile_get_literal(&S->beam, Flags.val);
        while (is_list(term)) {
          Eterm* consp = list_val(term);
          Eterm elem = CAR(consp);
          switch (elem) {
            case am_little:
            flags |= BSF_LITTLE;
            break;
            case am_native:
            flags |= BSF_NATIVE;
            break;
          }
          term = CDR(consp);
        }
        ASSERT(is_nil(term));
      }
    }
    Flags.type = TAG_u;
    Flags.val = flags;
    do {
#if defined(WORDS_BIGENDIAN)
      if ((Flags).val & BSF_NATIVE) {
        (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
      }
#else
      if ((Flags).val & BSF_NATIVE) {
        (Flags).val &= ~BSF_NATIVE;
        (Flags).val |= BSF_LITTLE;
      }
#endif
    } while (0);
    op->a[i+fixed_args+3] = Flags;

    /*
    * Replace short string segments with integer segments.
    * Integer segments can be combined with adjacent integer
    * segments for better performance.
    */
    if (op->a[i+fixed_args+0].val == am_string) {
      Sint num_chars = op->a[i+fixed_args+5].val;
      if (num_chars <= 4) {
        Sint index = op->a[i+fixed_args+4].val;
        const byte* s = S->beam.strings.data + index;
        Uint num = 0;
        op->a[i+fixed_args+0].val = am_integer;
        op->a[i+fixed_args+2].val = 8;
        op->a[i+fixed_args+5].val = num_chars;
        while (num_chars-- > 0) {
          num = num << 8 | *s++;
        }
        op->a[i+fixed_args+4].type = TAG_i;
        op->a[i+fixed_args+4].val = num;
      }
    }
  }

  if (op->a[4].val == am_private_append && Alloc.val != 0) {
    BeamOp* th;
    th = beamopallocator_new_op(&(S)->op_allocator);
    th->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      th->op = __make_opname__(test_heap, 2);
      th->arity = 2;
#undef __make_opname__
    } while (0);
    th->a[0] = Alloc;
    th->a[1] = Live;
    th->next = op;

    op->a[1].val = 0;

    op = th;
  }

  return op;;
}

static BeamOp* func_end(LoaderState* S, BeamOpArg Func_Label, BeamOpArg Entry_Label) {
  BeamOp *op = NULL;

  if (S->labels[Entry_Label.val].lambda_index != -1) {
    int index = S->labels[Entry_Label.val].lambda_index;
    BeamFile_LambdaEntry *lambda_entry;

    lambda_entry = &S->beam.lambdas.entries[index];

    if (lambda_entry->num_free > 0) {
      BeamOp *lambda;

      lambda = beamopallocator_new_op(&(S)->op_allocator);
      lambda->next = NULL;;
      do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
        lambda->op = __make_opname__(i_lambda_trampoline, 4);
        lambda->arity = 4;
#undef __make_opname__
      } while (0);

      lambda->a[0].type = TAG_u;
      lambda->a[0].val = index;
      lambda->a[1] = Entry_Label;
      lambda->a[2].type = TAG_u;
      lambda->a[2].val = lambda_entry->arity;
      lambda->a[3].type = TAG_u;
      lambda->a[3].val = lambda_entry->num_free;

      lambda->next = op;
      op = lambda;
    }
  }

  if (S->may_load_nif && (S->load_hdr->are_nifs == NULL ||
  S->load_hdr->are_nifs[S->function_number-1])) {
    BeamOp *padding;

    padding = beamopallocator_new_op(&(S)->op_allocator);
    padding->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      padding->op = __make_opname__(i_nif_padding, 0);
      padding->arity = 0;
#undef __make_opname__
    } while (0);

    padding->next = op;
    op = padding;
  }

  if (op == NULL) {
    /* Workaround for the fact that we have to return an instruction from
    * generators. The loader will remove this dummy instruction. */
    op = beamopallocator_new_op(&(S)->op_allocator);
    op->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(delete_me, 0);
      op->arity = 0;
#undef __make_opname__
    } while (0);

    op->next = NULL;
  }

  return op;;
}

static BeamOp* get(LoaderState* S, BeamOpArg Src, BeamOpArg Dst) {
  BeamOp* op;
  Eterm key_term;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  key_term = beam_load_get_term(S, Src);
  if (is_value(key_term)) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_get_hash, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Src;
    op->a[1].type = TAG_u;
    op->a[1].val = (BeamInstr) erts_pd_make_hx(key_term);
    op->a[2] = Dst;
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_get, 2);
      op->arity = 2;
#undef __make_opname__
    } while (0);
    op->a[0] = Src;
    op->a[1] = Dst;
  }
  return op;;
}

static BeamOp* get_binary2(LoaderState* S, BeamOpArg Fail, BeamOpArg Ms, BeamOpArg Live, BeamOpArg Size, BeamOpArg Unit, BeamOpArg Flags, BeamOpArg Dst) {
  BeamOp* op;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);

  if (Size.type == TAG_a && Size.val == am_all) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_bs_get_binary_all2, 5);
      op->arity = 5;
#undef __make_opname__
    } while (0);
    op->a[0] = Ms;
    op->a[1] = Fail;
    op->a[2] = Live;
    op->a[3] = Unit;
    op->a[4] = Dst;
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_bs_get_binary2, 6);
      op->arity = 6;
#undef __make_opname__
    } while (0);
    op->a[0] = Ms;
    op->a[1] = Fail;
    op->a[2] = Live;
    op->a[3] = Size;
    op->a[4].type = TAG_u;
    op->a[4].val = (Unit.val << 3) | Flags.val;
    op->a[5] = Dst;
  }

  op->next = NULL;
  return op;;
}

static BeamOp* get_float2(LoaderState* S, BeamOpArg Fail, BeamOpArg Ms, BeamOpArg Live, BeamOpArg Size, BeamOpArg Unit, BeamOpArg Flags, BeamOpArg Dst) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_get_float2, 6);
    op->arity = 6;
#undef __make_opname__
  } while (0);
  op->a[0] = Ms;
  op->a[1] = Fail;
  op->a[2] = Live;
  op->a[3] = Size;
  op->a[4].type = TAG_u;
  op->a[4].val = (Unit.val << 3) | Flags.val;
  op->a[5] = Dst;
  return op;;
}

static BeamOp* get_map_element(LoaderState* S, BeamOpArg Fail, BeamOpArg Src, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  BeamOpArg Key;
  Eterm key_term;

  ASSERT(Size.type == TAG_u);

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  op->a[0] = Fail;
  op->a[1] = Src;
  op->a[2] = Rest[0];

  Key = Rest[0];
  key_term = beam_load_get_term(S, Key);
  if (is_value(key_term)) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_get_map_element_hash, 5);
      op->arity = 5;
#undef __make_opname__
    } while (0);
    op->a[3].type = TAG_u;
    op->a[3].val = (BeamInstr) hashmap_make_hash(key_term);
    op->a[4] = Rest[1];
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_get_map_element, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    op->a[3] = Rest[1];
  }
  return op;;
}

static BeamOp* get_map_elements(LoaderState* S, BeamOpArg Fail, BeamOpArg Src, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  Uint i;
  BeamOpArg* dst;
  Eterm key_term;

  ASSERT(Size.type == TAG_u);

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_get_map_elements, 3);
    op->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op->a == op->def_args);

  op->arity = 3 + 3*(Size.val/2);
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->a[0] = Fail;
  op->a[1] = Src;
  op->a[2].type = TAG_u;
  op->a[2].val = 3*(Size.val/2);

  dst = op->a+3;
  for (i = 0; i < Size.val / 2; i++) {
    dst[0] = Rest[2*i];
    dst[1] = Rest[2*i+1];
    dst[2].type = TAG_u;
    key_term = beam_load_get_term(S, dst[0]);
    dst[2].val = (BeamInstr) hashmap_make_hash(key_term);
    dst += 3;
  }
  return op;;
}

static BeamOp* get_utf16(LoaderState* S, BeamOpArg Fail, BeamOpArg Ms, BeamOpArg Flags, BeamOpArg Dst) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_get_utf16, 4);
    op->arity = 4;
#undef __make_opname__
  } while (0);
  op->a[0] = Ms;
  op->a[1] = Fail;
  op->a[2] = Flags;
  op->a[3] = Dst;
  return op;;
}

static BeamOp* has_map_fields(LoaderState* S, BeamOpArg Fail, BeamOpArg Src, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  Uint i;
  Uint n;

  ASSERT(Size.type == TAG_u);
  n = Size.val;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(get_map_elements, 3);
    op->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op->a == op->def_args);

  op->arity = 3 + 2*n;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;

  op->a[0] = Fail;
  op->a[1] = Src;
  op->a[2].type = TAG_u;
  op->a[2].val = 2*n;

  for (i = 0; i < n; i++) {
    op->a[3+2*i] = Rest[i];
    op->a[3+2*i+1].type = TAG_x;
    op->a[3+2*i+1].val = SCRATCH_X_REG; /* Ignore result */
  }
  return op;;
}

static BeamOp* jump_tab(LoaderState* S, BeamOpArg Src, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  Sint min, max;
  Sint i;
  Sint size;
  Sint arity;
  int fixed_args;
  BeamOp* op;

  ASSERT(Size.val >= 2 && Size.val % 2 == 0);

  /* Don't generate a jump table if there's only one choice */
  if (Size.val == 2) {
    BeamOp* jump;

    op = beamopallocator_new_op(&(S)->op_allocator);
    op->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(is_ne_exact, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Rest[1];
    op->a[1] = Src;
    op->a[2] = Rest[0];

    jump = beamopallocator_new_op(&(S)->op_allocator);
    jump->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      jump->op = __make_opname__(jump, 1);
      jump->arity = 1;
#undef __make_opname__
    } while (0);
    jump->a[0] = Fail;

    op->next = jump;
    jump->next = NULL;
    return op;
  }

  /* Calculate the minimum and maximum values and size of jump table. */
  ASSERT(Rest[0].type == TAG_i);
  min = max = Rest[0].val;
  for (i = 2; i < Size.val; i += 2) {
    ASSERT(Rest[i].type == TAG_i && Rest[i+1].type == TAG_f);
    if (Rest[i].val < min) {
      min = Rest[i].val;
    } else if (max < Rest[i].val) {
      max = Rest[i].val;
    }
  }
  size = max - min + 1;

  /* Allocate structure and fill in the fixed fields. */
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  op->next = NULL;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_jump_on_val, 4);
    op->arity = 4;
#undef __make_opname__
  } while (0);
  fixed_args = op->arity;
  arity = fixed_args + size;
  ASSERT(op->a == op->def_args);

  op->arity = arity;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->a[0] = Src;
  op->a[1] = Fail;
  op->a[2].type = TAG_u;
  op->a[2].val = min;
  op->a[3].type = TAG_u;
  op->a[3].val = size;

  /* Fill in the jump table. */
  for (i = fixed_args; i < arity; i++) {
    op->a[i] = Fail;
  }

  for (i = 0; i < Size.val; i += 2) {
    Sint index = fixed_args + Rest[i].val - min;
    ASSERT(fixed_args <= index && index < arity);
    op->a[index] = Rest[i+1];
  }

  return op;;
}

static BeamOp* make_fun2(LoaderState* S, BeamOpArg Idx) {
  BeamOp* op;
  BeamOp* th;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  if (Idx.val >= S->beam.lambdas.count) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_lambda_error, 1);
      op->arity = 1;
#undef __make_opname__
    } while (0);
    op->a[0].type = TAG_o;
    op->a[0].val = 0;
    return op;
  } else {
    BeamFile_LambdaEntry *entry = &S->beam.lambdas.entries[Idx.val];
    unsigned num_free = entry->num_free;
    unsigned arity = entry->arity;
    int i;

    /* Literal lambdas are all owned by the init process as a workaround
    * for all local funs needing a creator pid. Skip the optimization if
    * this module is being loaded before said process has started
    * (just preloaded modules, really). */
    if (num_free == 0 && erts_init_process_id != ERTS_INVALID_PID) {
      do {
        BeamFile_LambdaEntry *entry = &S->beam.lambdas.entries[Idx.val];
        SWord literal;

        ASSERT(entry->num_free == 0);

        /* If we haven't already done so, we need to create a placeholder for the
        * lambda. */
        if (S->lambda_literals[Idx.val] == ERTS_SWORD_MAX) {
          Eterm tmp_hp[ERL_FUN_SIZE];
          ErlFunThing *funp;

          /* The placeholder is an external fun with the export field set to
          * NULL, preventing it from colliding with external fun literals
          * created by the user. We also disable deduplication to prevent it
          * from colliding with other placeholder lambdas of the same arity. */
          funp = (ErlFunThing*)tmp_hp;
          funp->thing_word = HEADER_FUN;
          funp->entry.exp = NULL;
          funp->next = NULL;
          funp->arity = entry->arity;
          funp->num_free = 0;
          funp->creator = am_external;

          literal = beamfile_add_literal(&S->beam, make_fun(tmp_hp), 0);
          S->lambda_literals[Idx.val] = literal;
        } else {
          literal = S->lambda_literals[Idx.val];
        }

        do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
          op->op = __make_opname__(move, 2);
          op->arity = 2;
#undef __make_opname__
        } while (0);
        (op)->a[0].type = TAG_q;
        (op)->a[0].val = literal;
        (op)->a[1].type = TAG_x;
        (op)->a[1].val = 0;
      } while (0);
      return op;
    }

    th = beamopallocator_new_op(&(S)->op_allocator);
    th->next = NULL;;

    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      th->op = __make_opname__(test_heap, 2);
      th->arity = 2;
#undef __make_opname__
    } while (0);
    th->a[0].type = TAG_u;
    th->a[0].val = ERL_FUN_SIZE + num_free;
    th->a[1].type = TAG_u;
    th->a[1].val = num_free;
    th->next = op;

    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_make_fun3, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    ASSERT(op->a == op->def_args);

    op->arity = 4 + num_free;
    op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
    op->a[0].type = TAG_u;
    op->a[0].val = Idx.val;
    op->a[1].type = TAG_x;
    op->a[1].val = 0;
    op->a[2].type = TAG_u;
    op->a[2].val = arity - num_free;
    op->a[3].type = TAG_u;
    op->a[3].val = num_free;

    for (i = 0; i < num_free; i++) {
      op->a[i+4].type = TAG_x;
      op->a[i+4].val = i;
    }

    return th;
  };
}

static BeamOp* make_fun3(LoaderState* S, BeamOpArg Idx, BeamOpArg Dst, BeamOpArg NumFree, BeamOpArg* Env) {
  BeamOp* op;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  if (Idx.val < S->beam.lambdas.count) {
    BeamFile_LambdaEntry *entry = &S->beam.lambdas.entries[Idx.val];

    if (NumFree.val == entry->num_free) {
      int i;

      if (NumFree.val == 0 && erts_init_process_id != ERTS_INVALID_PID) {
        do {
          BeamFile_LambdaEntry *entry = &S->beam.lambdas.entries[Idx.val];
          SWord literal;

          ASSERT(entry->num_free == 0);

          /* If we haven't already done so, we need to create a placeholder for the
          * lambda. */
          if (S->lambda_literals[Idx.val] == ERTS_SWORD_MAX) {
            Eterm tmp_hp[ERL_FUN_SIZE];
            ErlFunThing *funp;

            /* The placeholder is an external fun with the export field set to
            * NULL, preventing it from colliding with external fun literals
            * created by the user. We also disable deduplication to prevent it
            * from colliding with other placeholder lambdas of the same arity. */
            funp = (ErlFunThing*)tmp_hp;
            funp->thing_word = HEADER_FUN;
            funp->entry.exp = NULL;
            funp->next = NULL;
            funp->arity = entry->arity;
            funp->num_free = 0;
            funp->creator = am_external;

            literal = beamfile_add_literal(&S->beam, make_fun(tmp_hp), 0);
            S->lambda_literals[Idx.val] = literal;
          } else {
            literal = S->lambda_literals[Idx.val];
          }

          do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
            op->op = __make_opname__(move, 2);
            op->arity = 2;
#undef __make_opname__
          } while (0);
          (op)->a[0].type = TAG_q;
          (op)->a[0].val = literal;
          (op)->a[1].type = Dst.type;
          (op)->a[1].val = Dst.val;
        } while (0);
      } else {
        do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
          op->op = __make_opname__(i_make_fun3, 4);
          op->arity = 4;
#undef __make_opname__
        } while (0);
        ASSERT(op->a == op->def_args);

        op->arity = 4 + NumFree.val;
        op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;

        op->a[0].type = TAG_u;
        op->a[0].val = Idx.val;
        op->a[1] = Dst;
        op->a[2].type = TAG_u;
        op->a[2].val = entry->arity - entry->num_free;
        op->a[3].type = TAG_u;
        op->a[3].val = entry->num_free;

        for (i = 0; i < NumFree.val; i++) {
          op->a[i+4] = Env[i];
        }
      }

      return op;
    }
  }

  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_lambda_error, 1);
    op->arity = 1;
#undef __make_opname__
  } while (0);
  op->a[0].type = TAG_o;
  op->a[0].val = 0;
  return op;;
}

static BeamOp* new_small_map_lit(LoaderState* S, BeamOpArg Dst, BeamOpArg Live, BeamOpArg Size, BeamOpArg* Rest) {
  unsigned size = Size.val;
  Uint lit;
  unsigned i;
  BeamOp* op;
  BeamOpArg* dst;
  Eterm* tmp;
  Eterm* thp;
  Eterm keys;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_new_small_map_lit, 4);
    op->arity = 4;
#undef __make_opname__
  } while (0);
  ASSERT(op->a == op->def_args);

  op->arity = 4 + size/2;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->next = NULL;

  tmp = thp = erts_alloc(ERTS_ALC_T_LOADER_TMP, ((size == 0 ? 0 : 1) + size/2) * sizeof(*tmp));
  if (size == 0) {
    keys = erts_get_global_literal(ERTS_LIT_EMPTY_TUPLE);
  } else {
    keys = make_tuple(thp);
    *thp++ = make_arityval(size/2);
  }

  dst = op->a+4;

  for (i = 0; i < size; i += 2) {
    switch (Rest[i].type) {
      case TAG_a:
      *thp++ = Rest[i].val;
      ASSERT(is_atom(Rest[i].val));
      break;
      case TAG_i:
      *thp++ = make_small(Rest[i].val);
      break;
      case TAG_n:
      *thp++ = NIL;
      break;
      case TAG_q:
      *thp++ = beamfile_get_literal(&S->beam, Rest[i].val);
      break;
    }
    *dst++ = Rest[i + 1];
  }

  lit = beamfile_add_literal(&S->beam, keys, 1);
  erts_free(ERTS_ALC_T_LOADER_TMP, tmp);

  op->a[0] = Dst;
  op->a[1] = Live;
  op->a[2].type = TAG_q;
  op->a[2].val = lit;
  op->a[3].type = TAG_u;
  op->a[3].val = size / 2;

  return op;;
}

static BeamOp* put_binary(LoaderState* S, BeamOpArg Fail, BeamOpArg Size, BeamOpArg Unit, BeamOpArg Flags, BeamOpArg Src) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  if (Size.type == TAG_a && Size.val == am_all) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_new_bs_put_binary_all, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Src;
    op->a[1] = Fail;
    op->a[2] = Unit;
  } else if (Size.type == TAG_i) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_new_bs_put_binary_imm, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Fail;
    op->a[1].type = TAG_u;
    if (beam_load_safe_mul(Size.val, Unit.val, &op->a[1].val)) {
      op->a[2] = Src;
    } else {
      error:
      /*
      * Invalid size. This instruction can't possibly be
      * reached, because bs_add or bs_init* would already
      * have raised a system_limit exception.
      */
      do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
        op->op = __make_opname__(delete_me, 0);
        op->arity = 0;
#undef __make_opname__
      } while (0);
    }
  } else if (Size.type == TAG_q) {
#ifdef ARCH_64
    /*
    * There is no way that this binary would fit in memory.
    */
    goto error;
#else
    Eterm big = beamfile_get_literal(&S->beam, Size.val);
    Uint bigval;
    Uint size;

    if (!term_to_Uint(big, &bigval) ||
    !beam_load_safe_mul(bigval, Unit.val, &size)) {
      goto error;
    }
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_new_bs_put_binary_imm, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Fail;
    op->a[1].type = TAG_u;
    op->a[1].val = size;
    op->a[2] = Src;
#endif
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_new_bs_put_binary, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    op->a[0] = Fail;
    op->a[1] = Size;
    op->a[2].type = TAG_u;
    op->a[2].val = (Unit.val << 3) | (Flags.val & 7);
    op->a[3] = Src;
  }

  return op;;
}

static BeamOp* put_float(LoaderState* S, BeamOpArg Fail, BeamOpArg Size, BeamOpArg Unit, BeamOpArg Flags, BeamOpArg Src) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  if (Size.type == TAG_i) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_new_bs_put_float_imm, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    op->a[0] = Fail;
    op->a[1].type = TAG_u;
    if (!beam_load_safe_mul(Size.val, Unit.val, &op->a[1].val)) {
      /*
      * Size overflow. This instruction can't possibly be reached, because
      * bs_add or bs_init* would already have raised a system_limit
      * exception.
      */
      do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
        op->op = __make_opname__(delete_me, 0);
        op->arity = 0;
#undef __make_opname__
      } while (0);
    } else {
      op->a[2] = Flags;
      op->a[3] = Src;
    }
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_new_bs_put_float, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    op->a[0] = Fail;
    op->a[1] = Size;
    op->a[2].type = TAG_u;
    op->a[2].val = (Unit.val << 3) | (Flags.val & 7);
    op->a[3] = Src;
  }
  return op;;
}

static BeamOp* put_integer(LoaderState* S, BeamOpArg Fail, BeamOpArg Size, BeamOpArg Unit, BeamOpArg Flags, BeamOpArg Src) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  /* Negative size must fail */
  if (Size.type == TAG_i) {
    Uint size;
    if (!beam_load_safe_mul(Size.val, Unit.val, &size)) {
      error:
      /*
      * Invalid size. This instruction can't possibly be
      * reached, because bs_add or bs_init* would already
      * have raised a system_limit exception.
      */
      do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
        op->op = __make_opname__(delete_me, 0);
        op->arity = 0;
#undef __make_opname__
      } while (0);
      return op;
    }
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_new_bs_put_integer_imm, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    op->a[0] = Src;
    op->a[1] = Fail;
    op->a[2].type = TAG_u;
    op->a[2].val = size;
    op->a[3].type = Flags.type;
    op->a[3].val = (Flags.val & 7);
  } else if (Size.type == TAG_q) {
    Eterm big = beamfile_get_literal(&S->beam, Size.val);
    Uint bigval;
    Uint size;

    if (!term_to_Uint(big, &bigval) ||
    !beam_load_safe_mul(bigval, Unit.val, &size)) {
      goto error;
    }
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_new_bs_put_integer_imm, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    op->a[0] = Src;
    op->a[1] = Fail;
    op->a[2].type = TAG_u;
    op->a[2].val = size;
    op->a[3].type = Flags.type;
    op->a[3].val = (Flags.val & 7);
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_new_bs_put_integer, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    op->a[0] = Fail;
    op->a[1] = Size;
    op->a[2].type = TAG_u;
    op->a[2].val = (Unit.val << 3) | (Flags.val & 7);
    op->a[3] = Src;
  }
  return op;;
}

static BeamOp* put_utf16(LoaderState* S, BeamOpArg Fail, BeamOpArg Flags, BeamOpArg Src) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_put_utf16, 3);
    op->arity = 3;
#undef __make_opname__
  } while (0);
  op->a[0] = Fail;
  op->a[1] = Flags;
  op->a[2] = Src;
  return op;;
}

static BeamOp* select_literals(LoaderState* S, BeamOpArg Src, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  BeamOp* jump;
  BeamOp** prev_next = &op;

  int i;

  for (i = 0; i < Size.val; i += 2) {
    BeamOp* op;
    ASSERT(Rest[i].type == TAG_q);

    op = beamopallocator_new_op(&(S)->op_allocator);
    op->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(is_ne_exact, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Rest[i+1];
    op->a[1] = Src;
    op->a[2] = Rest[i];
    *prev_next = op;
    prev_next = &op->next;
  }

  jump = beamopallocator_new_op(&(S)->op_allocator);
  jump->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    jump->op = __make_opname__(jump, 1);
    jump->arity = 1;
#undef __make_opname__
  } while (0);
  jump->next = NULL;
  jump->a[0] = Fail;
  *prev_next = jump;
  return op;;
}

static BeamOp* select_tuple_arity(LoaderState* S, BeamOpArg Src, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  BeamOpArg *tmp;
  int size = Size.val / 2;
  int arity = Size.val + 3;
  int i, j;

  /* Verify the validity of the list. */
  if (Size.val % 2 != 0) {
    return NULL;
  }

  for (i = 0; i < Size.val; i += 2) {
    if (Rest[i].type != TAG_u || Rest[i+1].type != TAG_f) {
      return NULL;
    }
  }

  /*
  * Generate the generic instruction.
  * Assumption:
  *   Few different tuple arities to select on (fewer than 20).
  *   Use linear scan approach.
  */
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_select_tuple_arity, 3);
    op->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op->a == op->def_args);

  op->arity = arity;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->next = NULL;
  op->a[0] = Src;
  op->a[1] = Fail;

  /* Variable argument count */
  op->a[2].type = TAG_u;
  op->a[2].val = Size.val;

  tmp = (BeamOpArg*)erts_alloc(ERTS_ALC_T_LOADER_TMP,
  sizeof(BeamOpArg) * arity);

  for (i = 3; i < arity; i += 2) {
    tmp[i - 2]      = Rest[i - 2];
    tmp[i - 3].type = TAG_v;
    tmp[i - 3].val  = make_arityval_unchecked(Rest[i - 3].val);
  }

  /* Sort the values to make them useful for a binary or sentinel search. */
  beam_load_sort_select_vals(tmp, size);

  j = 3;
  for (i = 3; i < arity; i += 2) {
    op->a[j + size] = tmp[i - 2];
    op->a[j]        = tmp[i - 3];
    j++;
  }

  erts_free(ERTS_ALC_T_LOADER_TMP, (void *) tmp);

  return op;;
}

static BeamOp* select_val(LoaderState* S, BeamOpArg Src, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  BeamOpArg *tmp;
  int arity = Size.val + 3;
  int size = Size.val / 2;
  int i, j;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  op->next = NULL;

  /* Use linear search for small search spaces */
  if (size <= 10) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_select_val_lins, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_select_val_bins, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
  }

  ASSERT(op->a == op->def_args);

  op->arity = arity;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->a[0] = Src;
  op->a[1] = Fail;

  /* Variable argument count */
  op->a[2].type = TAG_u;
  op->a[2].val = Size.val;

  tmp = (BeamOpArg *) erts_alloc(ERTS_ALC_T_LOADER_TMP, sizeof(BeamOpArg)*(arity));

  for (i = 3; i < arity; i++) {
    tmp[i-3] = Rest[i-3];
  }

  /* Sort the values to make them useful for a binary or sentinel search. */
  beam_load_sort_select_vals(tmp, size);

  j = 3;
  for (i = 3; i < arity; i += 2) {
    op->a[j]      = tmp[i-3];
    op->a[j+size] = tmp[i-2];
    j++;
  }

  erts_free(ERTS_ALC_T_LOADER_TMP, (void *) tmp);

#ifdef DEBUG
  for (i = 0; i < size - 1; i++) {
    ASSERT(op->a[i+3].val <= op->a[i+4].val);
  }
#endif

  return op;;
}

static BeamOp* skip_bits2(LoaderState* S, BeamOpArg Fail, BeamOpArg Ms, BeamOpArg Size, BeamOpArg Unit, BeamOpArg Flags) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  if (Size.type == TAG_a && Size.val == am_all) {
    /*
    * This kind of skip instruction will only be found in modules
    * compiled before OTP 19. From OTP 19, the compiler generates
    * a test_unit instruction of a bs_skip at the end of a
    * binary.
    *
    * It is safe to replace the skip instruction with a test_unit
    * instruction, because the position will never be used again.
    * If the match context itself is used again, it will be used by
    * a bs_restore2 instruction which will overwrite the position
    * by one of the stored positions.
    */
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(bs_test_unit, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Fail;
    op->a[1] = Ms;
    op->a[2] = Unit;
  } else if (Size.type == TAG_i) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_bs_skip_bits_imm2, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Fail;
    op->a[1] = Ms;
    op->a[2].type = TAG_u;
    if (!beam_load_safe_mul(Size.val, Unit.val, &op->a[2].val)) {
      goto error;
    }
  } else if (Size.type == TAG_q) {
    Eterm big = beamfile_get_literal(&S->beam, Size.val);
    Uint bigval;

    if (!term_to_Uint(big, &bigval)) {
      error:
      do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
        op->op = __make_opname__(jump, 1);
        op->arity = 1;
#undef __make_opname__
      } while (0);
      op->a[0] = Fail;
    } else {
      do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
        op->op = __make_opname__(i_bs_skip_bits_imm2, 3);
        op->arity = 3;
#undef __make_opname__
      } while (0);
      op->a[0] = Fail;
      op->a[1] = Ms;
      op->a[2].type = TAG_u;
      if (!beam_load_safe_mul(bigval, Unit.val, &op->a[2].val)) {
        goto error;
      }
    }
  } else if (Size.type == TAG_x || Size.type == TAG_y) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_bs_skip_bits2, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    op->a[0] = Ms;
    op->a[1] = Size;
    op->a[2] = Fail;
    op->a[3] = Unit;
  } else {
    /*
    * Invalid literal size. Can only happen if compiler
    * optimizations are selectively disabled.  For example,
    * at the time of writing, [no_copt, no_type_opt] will allow
    * skip instructions with invalid sizes to slip through.
    */
    goto error;
  }
  return op;;
}

static BeamOp* skip_utf16(LoaderState* S, BeamOpArg Fail, BeamOpArg Ms, BeamOpArg Flags) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_skip_utf16, 3);
    op->arity = 3;
#undef __make_opname__
  } while (0);
  op->a[0] = Ms;
  op->a[1] = Fail;
  op->a[2] = Flags;
  return op;;
}

static BeamOp* split_values(LoaderState* S, BeamOpArg Src, BeamOpArg TypeFail, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op1;
  BeamOp* op2;
  BeamOp* is_integer;
  int i;

  ASSERT(Size.val >= 2 && Size.val % 2 == 0);

  is_integer = beamopallocator_new_op(&(S)->op_allocator);
  is_integer->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    is_integer->op = __make_opname__(is_integer, 2);
    is_integer->arity = 2;
#undef __make_opname__
  } while (0);
  is_integer->a[0] = TypeFail;
  is_integer->a[1] = Src;

  do {
    op1 = beamopallocator_new_op(&(S)->op_allocator);
    op1->next = NULL;
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op1->op = __make_opname__(select_val, 3);
    op1->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op1->a == op1->def_args);

  op1->arity = 3 + Size.val;
  op1->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op1->arity * sizeof(BeamOpArg));;
  op1->a[0] = Src;
  /* We use [] instead of a failure label to indicate a fallthrough
  * to next instruction if none of the values match. That way, we
  * don't have to create a new label dynamically, which would be
  * tricky in BeamAsm. */
  op1->a[1].type = TAG_n;
  op1->a[1].val = 0;
  op1->a[2].type = TAG_u;
  op1->a[2].val = 0;

  do {
    op2 = beamopallocator_new_op(&(S)->op_allocator);
    op2->next = NULL;
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op2->op = __make_opname__(select_val, 3);
    op2->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op2->a == op2->def_args);

  op2->arity = 3 + Size.val;
  op2->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op2->arity * sizeof(BeamOpArg));;
  op2->a[0] = Src;
  op2->a[1] = Fail;
  op2->a[2].type = TAG_u;
  op2->a[2].val = 0;

  /*
  * Split the list.
  */

  ASSERT(Size.type == TAG_u);
  for (i = 0; i < Size.val; i += 2) {
    BeamOp* op = (Rest[i].type == TAG_q) ? op2 : op1;
    int dst = 3 + op->a[2].val;

    ASSERT(Rest[i+1].type == TAG_f);
    op->a[dst] = Rest[i];
    op->a[dst+1] = Rest[i+1];
    op->arity += 2;
    op->a[2].val += 2;
  }
  ASSERT(op1->a[2].val > 0);
  ASSERT(op2->a[2].val > 0);

  /*
  * Order the instruction sequence appropriately.
  */

  if (TypeFail.val == Fail.val) {
    /*
    * select_val Src [] S ... (small numbers)
    * is_integer Fail S
    * select_val Src Fail S ... (bignums)
    */
    op1->next = is_integer;
    is_integer->next = op2;
  } else {
    /*
    * is_integer TypeFail S
    * select_val Src [] S ... (small numbers)
    * select_val Src Fail S ... (bignums)
    */
    is_integer->next = op1;
    op1->next = op2;
    op1 = is_integer;
  }
  op2->next = NULL;

  return op1;;
}

BeamOp* erts_beam_execute_transform(unsigned int op, LoaderState* st, BeamOpArg var[], BeamOpArg* rest_args) {
  switch (op) {
    case 0: return allocate_heap_zero(st, var[0], var[1], var[2]);
    case 1: return jump_tab(st, var[0], var[1], var[2], rest_args);
    case 2: return jump_tab(st, var[1], var[0], var[4], rest_args);
    case 3: return split_values(st, var[1], var[0], var[3], var[4], rest_args);
    case 4: return split_values(st, var[0], var[1], var[1], var[2], rest_args);
    case 5: return select_val(st, var[1], var[0], var[4], rest_args);
    case 6: return select_literals(st, var[0], var[1], var[2], rest_args);
    case 7: return select_val(st, var[0], var[1], var[2], rest_args);
    case 8: return select_tuple_arity(st, var[1], var[0], var[4], rest_args);
    case 9: return select_tuple_arity(st, var[0], var[1], var[2], rest_args);
    case 10: return combine_conses(st, var[0], var[1], var[2]);
    case 11: return get(st, var[2], var[3]);
    case 12: return make_fun2(st, var[0]);
    case 13: return make_fun3(st, var[0], var[1], var[2], rest_args);
    case 14: return func_end(st, var[0], var[1]);
    case 15: return bs_match(st, var[0], var[1], var[2], rest_args);
    case 16: return get_binary2(st, var[0], var[1], var[2], var[3], var[4], var[5], var[6]);
    case 17: return get_float2(st, var[0], var[1], var[2], var[3], var[4], var[5], var[6]);
    case 18: return skip_bits2(st, var[0], var[1], var[2], var[3], var[4]);
    case 19: return get_utf16(st, var[0], var[1], var[2], var[3]);
    case 20: return skip_utf16(st, var[0], var[1], var[2]);
    case 21: return create_bin(st, var[0], var[1], var[2], var[3], var[4], var[5], rest_args);
    case 22: return put_integer(st, var[0], var[1], var[2], var[3], var[4]);
    case 23: return put_utf16(st, var[0], var[1], var[2]);
    case 24: return put_float(st, var[0], var[1], var[2], var[3], var[4]);
    case 25: return put_binary(st, var[0], var[1], var[2], var[3], var[4]);
    case 26: return new_small_map_lit(st, var[0], var[1], var[2], rest_args);
    case 27: return has_map_fields(st, var[0], var[1], var[2], rest_args);
    case 28: return get_map_element(st, var[0], var[1], var[2], rest_args);
    case 29: return get_map_elements(st, var[0], var[1], var[2], rest_args);
    default: erts_exit(ERTS_ABORT_EXIT, "erts_beam_execute_transform: invalid op %d\n", op);  }
}

