/* Generated by wayland-scanner 1.22.0 */

#ifndef ZWP_ACTION_ROUTE_SERVER_PROTOCOL_H
#define ZWP_ACTION_ROUTE_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_zwp_action_route The zwp_action_route protocol
 * @section page_ifaces_zwp_action_route Interfaces
 * - @subpage page_iface_action_route - 
 * - @subpage page_iface_action_route_bind - 
 * - @subpage page_iface_action_route_key_grab - 
 */
struct action_route;
struct action_route_bind;
struct action_route_key_grab;
struct wl_surface;

#ifndef ACTION_ROUTE_INTERFACE
#define ACTION_ROUTE_INTERFACE
/**
 * @page page_iface_action_route action_route
 * @section page_iface_action_route_api API
 * See @ref iface_action_route.
 */
/**
 * @defgroup iface_action_route The action_route interface
 */
extern const struct wl_interface action_route_interface;
#endif
#ifndef ACTION_ROUTE_BIND_INTERFACE
#define ACTION_ROUTE_BIND_INTERFACE
/**
 * @page page_iface_action_route_bind action_route_bind
 * @section page_iface_action_route_bind_api API
 * See @ref iface_action_route_bind.
 */
/**
 * @defgroup iface_action_route_bind The action_route_bind interface
 */
extern const struct wl_interface action_route_bind_interface;
#endif
#ifndef ACTION_ROUTE_KEY_GRAB_INTERFACE
#define ACTION_ROUTE_KEY_GRAB_INTERFACE
/**
 * @page page_iface_action_route_key_grab action_route_key_grab
 * @section page_iface_action_route_key_grab_api API
 * See @ref iface_action_route_key_grab.
 */
/**
 * @defgroup iface_action_route_key_grab The action_route_key_grab interface
 */
extern const struct wl_interface action_route_key_grab_interface;
#endif

#ifndef ACTION_ROUTE_MODE_ENUM
#define ACTION_ROUTE_MODE_ENUM
/**
 * @ingroup iface_action_route
 * types of state on the surface
 *
 */
enum action_route_mode {
	/**
	 * Activatable by any surface if its wl_client has focus
	 */
	ACTION_ROUTE_MODE_FOCUS_SHARED = 1,
	/**
	 * Activatable by topmost surface with focus
	 * Restricts activation to only the top-most client
	 *
	 * 
	 */
	ACTION_ROUTE_MODE_FOCUS_TOPMOST = 2,
	/**
	 * Activatable by one surface at any time
	 * Allows activation for exactly one client at all times
	 *
	 * 
	 */
	ACTION_ROUTE_MODE_EXCLUSIVE = 3,
};
#endif /* ACTION_ROUTE_MODE_ENUM */

#ifndef ACTION_ROUTE_MODIFIERS_ENUM
#define ACTION_ROUTE_MODIFIERS_ENUM
enum action_route_modifiers {
	ACTION_ROUTE_MODIFIERS_SHIFT = 1,
	ACTION_ROUTE_MODIFIERS_CONTROL = 2,
	ACTION_ROUTE_MODIFIERS_ALT = 4,
	ACTION_ROUTE_MODIFIERS_WIN = 8,
	ACTION_ROUTE_MODIFIERS_ALTGR = 16,
};
#endif /* ACTION_ROUTE_MODIFIERS_ENUM */

/**
 * @ingroup iface_action_route
 * @struct action_route_interface
 */
struct action_route_interface {
	/**
	 * Request a new grab for a key press
	 *
	 * 
	 */
	void (*bind_action)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t id,
			    const char *action);
	/**
	 * Request a new grab for a key press
	 *
	 * 
	 */
	void (*grab_key)(struct wl_client *client,
			 struct wl_resource *resource,
			 uint32_t id,
			 struct wl_resource *surface,
			 const char *key,
			 uint32_t mode,
			 uint32_t modifiers,
			 const char *action,
			 const char *params);
};


/**
 * @ingroup iface_action_route
 */
#define ACTION_ROUTE_BIND_ACTION_SINCE_VERSION 1
/**
 * @ingroup iface_action_route
 */
#define ACTION_ROUTE_GRAB_KEY_SINCE_VERSION 1

#ifndef ACTION_ROUTE_BIND_STATE_ENUM
#define ACTION_ROUTE_BIND_STATE_ENUM
enum action_route_bind_state {
	ACTION_ROUTE_BIND_STATE_REJECTED = 0,
	ACTION_ROUTE_BIND_STATE_ACTIVE = 1,
	ACTION_ROUTE_BIND_STATE_QUEUED = 2,
};
#endif /* ACTION_ROUTE_BIND_STATE_ENUM */

/**
 * @ingroup iface_action_route_bind
 * @struct action_route_bind_interface
 */
struct action_route_bind_interface {
	/**
	 * Activate a bind
	 *
	 * 
	 */
	void (*activate)(struct wl_client *client,
			 struct wl_resource *resource,
			 const char *params);
	/**
	 * Destroy a requested bind
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ACTION_ROUTE_BIND_STATUS 0
#define ACTION_ROUTE_BIND_END 1

/**
 * @ingroup iface_action_route_bind
 */
#define ACTION_ROUTE_BIND_STATUS_SINCE_VERSION 1
/**
 * @ingroup iface_action_route_bind
 */
#define ACTION_ROUTE_BIND_END_SINCE_VERSION 1

/**
 * @ingroup iface_action_route_bind
 */
#define ACTION_ROUTE_BIND_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_action_route_bind
 */
#define ACTION_ROUTE_BIND_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_action_route_bind
 * Sends an status event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
action_route_bind_send_status(struct wl_resource *resource_, uint32_t state)
{
	wl_resource_post_event(resource_, ACTION_ROUTE_BIND_STATUS, state);
}

/**
 * @ingroup iface_action_route_bind
 * Sends an end event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
action_route_bind_send_end(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ACTION_ROUTE_BIND_END);
}

#ifndef ACTION_ROUTE_KEY_GRAB_STATE_ENUM
#define ACTION_ROUTE_KEY_GRAB_STATE_ENUM
enum action_route_key_grab_state {
	ACTION_ROUTE_KEY_GRAB_STATE_REJECTED = 0,
	ACTION_ROUTE_KEY_GRAB_STATE_ACTIVE = 1,
	ACTION_ROUTE_KEY_GRAB_STATE_QUEUED = 2,
};
#endif /* ACTION_ROUTE_KEY_GRAB_STATE_ENUM */

/**
 * @ingroup iface_action_route_key_grab
 * @struct action_route_key_grab_interface
 */
struct action_route_key_grab_interface {
	/**
	 * Destroy a requested grab
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define ACTION_ROUTE_KEY_GRAB_STATUS 0

/**
 * @ingroup iface_action_route_key_grab
 */
#define ACTION_ROUTE_KEY_GRAB_STATUS_SINCE_VERSION 1

/**
 * @ingroup iface_action_route_key_grab
 */
#define ACTION_ROUTE_KEY_GRAB_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_action_route_key_grab
 * Sends an status event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
action_route_key_grab_send_status(struct wl_resource *resource_, uint32_t state)
{
	wl_resource_post_event(resource_, ACTION_ROUTE_KEY_GRAB_STATUS, state);
}

#ifdef  __cplusplus
}
#endif

#endif
