/* Generated by wayland-scanner 1.22.0 */

#ifndef ZKDE_SCREENCAST_UNSTABLE_V1_SERVER_PROTOCOL_H
#define ZKDE_SCREENCAST_UNSTABLE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_zkde_screencast_unstable_v1 The zkde_screencast_unstable_v1 protocol
 * @section page_ifaces_zkde_screencast_unstable_v1 Interfaces
 * - @subpage page_iface_zkde_screencast_unstable_v1 - Protocol for managing PipeWire feeds of the different displays and windows.
 * - @subpage page_iface_zkde_screencast_stream_unstable_v1 - 
 * @section page_copyright_zkde_screencast_unstable_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2020-2021 Aleix Pol Gonzalez <aleixpol@kde.org>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct wl_output;
struct zkde_screencast_stream_unstable_v1;
struct zkde_screencast_unstable_v1;

#ifndef ZKDE_SCREENCAST_UNSTABLE_V1_INTERFACE
#define ZKDE_SCREENCAST_UNSTABLE_V1_INTERFACE
/**
 * @page page_iface_zkde_screencast_unstable_v1 zkde_screencast_unstable_v1
 * @section page_iface_zkde_screencast_unstable_v1_desc Description
 * @section page_iface_zkde_screencast_unstable_v1_api API
 * See @ref iface_zkde_screencast_unstable_v1.
 */
/**
 * @defgroup iface_zkde_screencast_unstable_v1 The zkde_screencast_unstable_v1 interface
 */
extern const struct wl_interface zkde_screencast_unstable_v1_interface;
#endif
#ifndef ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_INTERFACE
#define ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_INTERFACE
/**
 * @page page_iface_zkde_screencast_stream_unstable_v1 zkde_screencast_stream_unstable_v1
 * @section page_iface_zkde_screencast_stream_unstable_v1_api API
 * See @ref iface_zkde_screencast_stream_unstable_v1.
 */
/**
 * @defgroup iface_zkde_screencast_stream_unstable_v1 The zkde_screencast_stream_unstable_v1 interface
 */
extern const struct wl_interface zkde_screencast_stream_unstable_v1_interface;
#endif

#ifndef ZKDE_SCREENCAST_UNSTABLE_V1_POINTER_ENUM
#define ZKDE_SCREENCAST_UNSTABLE_V1_POINTER_ENUM
/**
 * @ingroup iface_zkde_screencast_unstable_v1
 * Stream consumer attachment attributes
 */
enum zkde_screencast_unstable_v1_pointer {
	/**
	 * No cursor
	 */
	ZKDE_SCREENCAST_UNSTABLE_V1_POINTER_HIDDEN = 1,
	/**
	 * Render the cursor on the stream
	 */
	ZKDE_SCREENCAST_UNSTABLE_V1_POINTER_EMBEDDED = 2,
	/**
	 * Send metadata about where the cursor is through PipeWire
	 */
	ZKDE_SCREENCAST_UNSTABLE_V1_POINTER_METADATA = 4,
};
#endif /* ZKDE_SCREENCAST_UNSTABLE_V1_POINTER_ENUM */

/**
 * @ingroup iface_zkde_screencast_unstable_v1
 * @struct zkde_screencast_unstable_v1_interface
 */
struct zkde_screencast_unstable_v1_interface {
	/**
	 * requests a feed from a given source
	 *
	 * 
	 * @param pointer Requested pointer mode
	 */
	void (*stream_output)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t stream,
			      struct wl_resource *output,
			      uint32_t pointer);
	/**
	 * requests a feed from a given source
	 *
	 * 
	 * @param window_uuid window Identifier
	 * @param pointer Requested pointer mode
	 */
	void (*stream_window)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t stream,
			      const char *window_uuid,
			      uint32_t pointer);
	/**
	 * Destroy the zkde_screencast_unstable_v1
	 *
	 * Destroy the zkde_screencast_unstable_v1 object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * requests a feed from a new virtual output
	 *
	 * 
	 * @param name name of the created output
	 * @param width Logical width resolution
	 * @param height Logical height resolution
	 * @param scale Scaling factor of the display where it's to be displayed
	 * @param pointer Requested pointer mode
	 * @since 2
	 */
	void (*stream_virtual_output)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t stream,
				      const char *name,
				      int32_t width,
				      int32_t height,
				      wl_fixed_t scale,
				      uint32_t pointer);
};


/**
 * @ingroup iface_zkde_screencast_unstable_v1
 */
#define ZKDE_SCREENCAST_UNSTABLE_V1_STREAM_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_zkde_screencast_unstable_v1
 */
#define ZKDE_SCREENCAST_UNSTABLE_V1_STREAM_WINDOW_SINCE_VERSION 1
/**
 * @ingroup iface_zkde_screencast_unstable_v1
 */
#define ZKDE_SCREENCAST_UNSTABLE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zkde_screencast_unstable_v1
 */
#define ZKDE_SCREENCAST_UNSTABLE_V1_STREAM_VIRTUAL_OUTPUT_SINCE_VERSION 2

/**
 * @ingroup iface_zkde_screencast_stream_unstable_v1
 * @struct zkde_screencast_stream_unstable_v1_interface
 */
struct zkde_screencast_stream_unstable_v1_interface {
	/**
	 * Indicates we are done with the stream and the communication is over.
	 *
	 * 
	 */
	void (*close)(struct wl_client *client,
		      struct wl_resource *resource);
};

#define ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_CLOSED 0
#define ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_CREATED 1
#define ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_FAILED 2

/**
 * @ingroup iface_zkde_screencast_stream_unstable_v1
 */
#define ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_CLOSED_SINCE_VERSION 1
/**
 * @ingroup iface_zkde_screencast_stream_unstable_v1
 */
#define ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_CREATED_SINCE_VERSION 1
/**
 * @ingroup iface_zkde_screencast_stream_unstable_v1
 */
#define ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_zkde_screencast_stream_unstable_v1
 */
#define ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_CLOSE_SINCE_VERSION 1

/**
 * @ingroup iface_zkde_screencast_stream_unstable_v1
 * Sends an closed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
zkde_screencast_stream_unstable_v1_send_closed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_CLOSED);
}

/**
 * @ingroup iface_zkde_screencast_stream_unstable_v1
 * Sends an created event to the client owning the resource.
 * @param resource_ The client's resource
 * @param node node of the pipewire buffer
 */
static inline void
zkde_screencast_stream_unstable_v1_send_created(struct wl_resource *resource_, uint32_t node)
{
	wl_resource_post_event(resource_, ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_CREATED, node);
}

/**
 * @ingroup iface_zkde_screencast_stream_unstable_v1
 * Sends an failed event to the client owning the resource.
 * @param resource_ The client's resource
 * @param error A human readable translated error message.
 */
static inline void
zkde_screencast_stream_unstable_v1_send_failed(struct wl_resource *resource_, const char *error)
{
	wl_resource_post_event(resource_, ZKDE_SCREENCAST_STREAM_UNSTABLE_V1_FAILED, error);
}

#ifdef  __cplusplus
}
#endif

#endif
