/* Generated by wayland-scanner 1.22.0 */

#ifndef KDE_PRIMARY_OUTPUT_V1_SERVER_PROTOCOL_H
#define KDE_PRIMARY_OUTPUT_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_kde_primary_output_v1 The kde_primary_output_v1 protocol
 * @section page_ifaces_kde_primary_output_v1 Interfaces
 * - @subpage page_iface_kde_primary_output_v1 - expose which is the primary display
 * @section page_copyright_kde_primary_output_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2021 Aleix Pol Gonzalez <aleixpol@kde.org>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_primary_output_v1;

#ifndef KDE_PRIMARY_OUTPUT_V1_INTERFACE
#define KDE_PRIMARY_OUTPUT_V1_INTERFACE
/**
 * @page page_iface_kde_primary_output_v1 kde_primary_output_v1
 * @section page_iface_kde_primary_output_v1_desc Description
 *
 * Protocol for telling which is the primary display among the selection of enabled outputs.
 * @section page_iface_kde_primary_output_v1_api API
 * See @ref iface_kde_primary_output_v1.
 */
/**
 * @defgroup iface_kde_primary_output_v1 The kde_primary_output_v1 interface
 *
 * Protocol for telling which is the primary display among the selection of enabled outputs.
 */
extern const struct wl_interface kde_primary_output_v1_interface;
#endif

#define KDE_PRIMARY_OUTPUT_V1_PRIMARY_OUTPUT 0

/**
 * @ingroup iface_kde_primary_output_v1
 */
#define KDE_PRIMARY_OUTPUT_V1_PRIMARY_OUTPUT_SINCE_VERSION 1


/**
 * @ingroup iface_kde_primary_output_v1
 * Sends an primary_output event to the client owning the resource.
 * @param resource_ The client's resource
 * @param output_name the name of the output
 */
static inline void
kde_primary_output_v1_send_primary_output(struct wl_resource *resource_, const char *output_name)
{
	wl_resource_post_event(resource_, KDE_PRIMARY_OUTPUT_V1_PRIMARY_OUTPUT, output_name);
}

#ifdef  __cplusplus
}
#endif

#endif
