/* Generated by wayland-scanner 1.22.0 */

#ifndef KDE_OUTPUT_DEVICE_V2_SERVER_PROTOCOL_H
#define KDE_OUTPUT_DEVICE_V2_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_kde_output_device_v2 The kde_output_device_v2 protocol
 * @section page_ifaces_kde_output_device_v2 Interfaces
 * - @subpage page_iface_kde_output_device_v2 - output configuration representation
 * - @subpage page_iface_kde_output_device_mode_v2 - output mode
 * @section page_copyright_kde_output_device_v2 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2008-2011 Kristian Høgsberg
 * SPDX-FileCopyrightText: 2010-2011 Intel Corporation
 * SPDX-FileCopyrightText: 2012-2013 Collabora, Ltd.
 * SPDX-FileCopyrightText: 2015 Sebastian Kügler <sebas@kde.org>
 * SPDX-FileCopyrightText: 2021 Méven Car <meven.car@enioka.com>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_output_device_mode_v2;
struct kde_output_device_v2;

#ifndef KDE_OUTPUT_DEVICE_V2_INTERFACE
#define KDE_OUTPUT_DEVICE_V2_INTERFACE
/**
 * @page page_iface_kde_output_device_v2 kde_output_device_v2
 * @section page_iface_kde_output_device_v2_desc Description
 *
 * An output device describes a display device available to the compositor.
 * output_device is similar to wl_output, but focuses on output
 * configuration management.
 *
 * A client can query all global output_device objects to enlist all
 * available display devices, even those that may currently not be
 * represented by the compositor as a wl_output.
 *
 * The client sends configuration changes to the server through the
 * outputconfiguration interface, and the server applies the configuration
 * changes to the hardware and signals changes to the output devices
 * accordingly.
 *
 * This object is published as global during start up for every available
 * display devices, or when one later becomes available, for example by
 * being hotplugged via a physical connector.
 * @section page_iface_kde_output_device_v2_api API
 * See @ref iface_kde_output_device_v2.
 */
/**
 * @defgroup iface_kde_output_device_v2 The kde_output_device_v2 interface
 *
 * An output device describes a display device available to the compositor.
 * output_device is similar to wl_output, but focuses on output
 * configuration management.
 *
 * A client can query all global output_device objects to enlist all
 * available display devices, even those that may currently not be
 * represented by the compositor as a wl_output.
 *
 * The client sends configuration changes to the server through the
 * outputconfiguration interface, and the server applies the configuration
 * changes to the hardware and signals changes to the output devices
 * accordingly.
 *
 * This object is published as global during start up for every available
 * display devices, or when one later becomes available, for example by
 * being hotplugged via a physical connector.
 */
extern const struct wl_interface kde_output_device_v2_interface;
#endif
#ifndef KDE_OUTPUT_DEVICE_MODE_V2_INTERFACE
#define KDE_OUTPUT_DEVICE_MODE_V2_INTERFACE
/**
 * @page page_iface_kde_output_device_mode_v2 kde_output_device_mode_v2
 * @section page_iface_kde_output_device_mode_v2_desc Description
 *
 * This object describes an output mode.
 *
 * Some heads don't support output modes, in which case modes won't be
 * advertised.
 *
 * Properties sent via this interface are applied atomically via the
 * kde_output_device.done event. No guarantees are made regarding the order
 * in which properties are sent.
 * @section page_iface_kde_output_device_mode_v2_api API
 * See @ref iface_kde_output_device_mode_v2.
 */
/**
 * @defgroup iface_kde_output_device_mode_v2 The kde_output_device_mode_v2 interface
 *
 * This object describes an output mode.
 *
 * Some heads don't support output modes, in which case modes won't be
 * advertised.
 *
 * Properties sent via this interface are applied atomically via the
 * kde_output_device.done event. No guarantees are made regarding the order
 * in which properties are sent.
 */
extern const struct wl_interface kde_output_device_mode_v2_interface;
#endif

#ifndef KDE_OUTPUT_DEVICE_V2_SUBPIXEL_ENUM
#define KDE_OUTPUT_DEVICE_V2_SUBPIXEL_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * subpixel geometry information
 *
 * This enumeration describes how the physical pixels on an output are
 * laid out.
 */
enum kde_output_device_v2_subpixel {
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_UNKNOWN = 0,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_NONE = 1,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_HORIZONTAL_RGB = 2,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_HORIZONTAL_BGR = 3,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_VERTICAL_RGB = 4,
	KDE_OUTPUT_DEVICE_V2_SUBPIXEL_VERTICAL_BGR = 5,
};
#endif /* KDE_OUTPUT_DEVICE_V2_SUBPIXEL_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_TRANSFORM_ENUM
#define KDE_OUTPUT_DEVICE_V2_TRANSFORM_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * transform from framebuffer to output
 *
 * This describes the transform, that a compositor will apply to a
 * surface to compensate for the rotation or mirroring of an
 * output device.
 *
 * The flipped values correspond to an initial flip around a
 * vertical axis followed by rotation.
 *
 * The purpose is mainly to allow clients to render accordingly and
 * tell the compositor, so that for fullscreen surfaces, the
 * compositor is still able to scan out directly client surfaces.
 */
enum kde_output_device_v2_transform {
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_NORMAL = 0,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_90 = 1,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_180 = 2,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_270 = 3,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED = 4,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED_90 = 5,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED_180 = 6,
	KDE_OUTPUT_DEVICE_V2_TRANSFORM_FLIPPED_270 = 7,
};
#endif /* KDE_OUTPUT_DEVICE_V2_TRANSFORM_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_CAPABILITY_ENUM
#define KDE_OUTPUT_DEVICE_V2_CAPABILITY_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * describes capabilities of the outputdevice
 *
 * Describes what capabilities this device has.
 */
enum kde_output_device_v2_capability {
	/**
	 * if this output_device can use overscan
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_OVERSCAN = 1,
	/**
	 * if this outputdevice supports variable refresh rate
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_VRR = 2,
	/**
	 * if setting the rgb range is possible
	 */
	KDE_OUTPUT_DEVICE_V2_CAPABILITY_RGB_RANGE = 4,
};
#endif /* KDE_OUTPUT_DEVICE_V2_CAPABILITY_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ENUM
#define KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * describes vrr policy
 *
 * Describes when the compositor may employ variable refresh rate
 */
enum kde_output_device_v2_vrr_policy {
	KDE_OUTPUT_DEVICE_V2_VRR_POLICY_NEVER = 0,
	KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ALWAYS = 1,
	KDE_OUTPUT_DEVICE_V2_VRR_POLICY_AUTOMATIC = 2,
};
#endif /* KDE_OUTPUT_DEVICE_V2_VRR_POLICY_ENUM */

#ifndef KDE_OUTPUT_DEVICE_V2_RGB_RANGE_ENUM
#define KDE_OUTPUT_DEVICE_V2_RGB_RANGE_ENUM
/**
 * @ingroup iface_kde_output_device_v2
 * describes RGB range policy
 *
 * Whether full or limited color range should be used
 */
enum kde_output_device_v2_rgb_range {
	KDE_OUTPUT_DEVICE_V2_RGB_RANGE_AUTOMATIC = 0,
	KDE_OUTPUT_DEVICE_V2_RGB_RANGE_FULL = 1,
	KDE_OUTPUT_DEVICE_V2_RGB_RANGE_LIMITED = 2,
};
#endif /* KDE_OUTPUT_DEVICE_V2_RGB_RANGE_ENUM */

#define KDE_OUTPUT_DEVICE_V2_GEOMETRY 0
#define KDE_OUTPUT_DEVICE_V2_CURRENT_MODE 1
#define KDE_OUTPUT_DEVICE_V2_MODE 2
#define KDE_OUTPUT_DEVICE_V2_DONE 3
#define KDE_OUTPUT_DEVICE_V2_SCALE 4
#define KDE_OUTPUT_DEVICE_V2_EDID 5
#define KDE_OUTPUT_DEVICE_V2_ENABLED 6
#define KDE_OUTPUT_DEVICE_V2_UUID 7
#define KDE_OUTPUT_DEVICE_V2_SERIAL_NUMBER 8
#define KDE_OUTPUT_DEVICE_V2_EISA_ID 9
#define KDE_OUTPUT_DEVICE_V2_CAPABILITIES 10
#define KDE_OUTPUT_DEVICE_V2_OVERSCAN 11
#define KDE_OUTPUT_DEVICE_V2_VRR_POLICY 12
#define KDE_OUTPUT_DEVICE_V2_RGB_RANGE 13
#define KDE_OUTPUT_DEVICE_V2_NAME 14

/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CURRENT_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_EDID_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_ENABLED_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_UUID_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_SERIAL_NUMBER_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_EISA_ID_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_CAPABILITIES_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_OVERSCAN_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_VRR_POLICY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_RGB_RANGE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_v2
 */
#define KDE_OUTPUT_DEVICE_V2_NAME_SINCE_VERSION 2


/**
 * @ingroup iface_kde_output_device_v2
 * Sends an geometry event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x x position within the global compositor space
 * @param y y position within the global compositor space
 * @param physical_width width in millimeters of the output
 * @param physical_height height in millimeters of the output
 * @param subpixel subpixel orientation of the output
 * @param make textual description of the manufacturer
 * @param model textual description of the model
 * @param transform transform that maps framebuffer to output
 */
static inline void
kde_output_device_v2_send_geometry(struct wl_resource *resource_, int32_t x, int32_t y, int32_t physical_width, int32_t physical_height, int32_t subpixel, const char *make, const char *model, int32_t transform)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_GEOMETRY, x, y, physical_width, physical_height, subpixel, make, model, transform);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an current_mode event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_current_mode(struct wl_resource *resource_, struct wl_resource *mode)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_CURRENT_MODE, mode);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an mode event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_mode(struct wl_resource *resource_, struct wl_resource *mode)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_MODE, mode);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_DONE);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an scale event to the client owning the resource.
 * @param resource_ The client's resource
 * @param factor scaling factor of output
 */
static inline void
kde_output_device_v2_send_scale(struct wl_resource *resource_, wl_fixed_t factor)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_SCALE, factor);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an edid event to the client owning the resource.
 * @param resource_ The client's resource
 * @param raw base64-encoded EDID string
 */
static inline void
kde_output_device_v2_send_edid(struct wl_resource *resource_, const char *raw)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_EDID, raw);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an enabled event to the client owning the resource.
 * @param resource_ The client's resource
 * @param enabled output enabled state
 */
static inline void
kde_output_device_v2_send_enabled(struct wl_resource *resource_, int32_t enabled)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_ENABLED, enabled);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an uuid event to the client owning the resource.
 * @param resource_ The client's resource
 * @param uuid output devices ID
 */
static inline void
kde_output_device_v2_send_uuid(struct wl_resource *resource_, const char *uuid)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_UUID, uuid);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an serial_number event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serialNumber textual representation of serial number
 */
static inline void
kde_output_device_v2_send_serial_number(struct wl_resource *resource_, const char *serialNumber)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_SERIAL_NUMBER, serialNumber);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an eisa_id event to the client owning the resource.
 * @param resource_ The client's resource
 * @param eisaId textual representation of EISA identifier
 */
static inline void
kde_output_device_v2_send_eisa_id(struct wl_resource *resource_, const char *eisaId)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_EISA_ID, eisaId);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an capabilities event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_capabilities(struct wl_resource *resource_, uint32_t flags)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_CAPABILITIES, flags);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an overscan event to the client owning the resource.
 * @param resource_ The client's resource
 * @param overscan amount of overscan of the monitor
 */
static inline void
kde_output_device_v2_send_overscan(struct wl_resource *resource_, uint32_t overscan)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_OVERSCAN, overscan);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an vrr_policy event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_vrr_policy(struct wl_resource *resource_, uint32_t vrr_policy)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_VRR_POLICY, vrr_policy);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an rgb_range event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_rgb_range(struct wl_resource *resource_, uint32_t rgb_range)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_RGB_RANGE, rgb_range);
}

/**
 * @ingroup iface_kde_output_device_v2
 * Sends an name event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_v2_send_name(struct wl_resource *resource_, const char *name)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_V2_NAME, name);
}

#define KDE_OUTPUT_DEVICE_MODE_V2_SIZE 0
#define KDE_OUTPUT_DEVICE_MODE_V2_REFRESH 1
#define KDE_OUTPUT_DEVICE_MODE_V2_PREFERRED 2
#define KDE_OUTPUT_DEVICE_MODE_V2_REMOVED 3

/**
 * @ingroup iface_kde_output_device_mode_v2
 */
#define KDE_OUTPUT_DEVICE_MODE_V2_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_mode_v2
 */
#define KDE_OUTPUT_DEVICE_MODE_V2_REFRESH_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_mode_v2
 */
#define KDE_OUTPUT_DEVICE_MODE_V2_PREFERRED_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_device_mode_v2
 */
#define KDE_OUTPUT_DEVICE_MODE_V2_REMOVED_SINCE_VERSION 1


/**
 * @ingroup iface_kde_output_device_mode_v2
 * Sends an size event to the client owning the resource.
 * @param resource_ The client's resource
 * @param width width of the mode in hardware units
 * @param height height of the mode in hardware units
 */
static inline void
kde_output_device_mode_v2_send_size(struct wl_resource *resource_, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_MODE_V2_SIZE, width, height);
}

/**
 * @ingroup iface_kde_output_device_mode_v2
 * Sends an refresh event to the client owning the resource.
 * @param resource_ The client's resource
 * @param refresh vertical refresh rate in mHz
 */
static inline void
kde_output_device_mode_v2_send_refresh(struct wl_resource *resource_, int32_t refresh)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_MODE_V2_REFRESH, refresh);
}

/**
 * @ingroup iface_kde_output_device_mode_v2
 * Sends an preferred event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_mode_v2_send_preferred(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_MODE_V2_PREFERRED);
}

/**
 * @ingroup iface_kde_output_device_mode_v2
 * Sends an removed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
kde_output_device_mode_v2_send_removed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, KDE_OUTPUT_DEVICE_MODE_V2_REMOVED);
}

#ifdef  __cplusplus
}
#endif

#endif
