/* Generated by wayland-scanner 1.22.0 */

#ifndef COM_DEEPIN_CLIENT_MANAGEMENT_SERVER_PROTOCOL_H
#define COM_DEEPIN_CLIENT_MANAGEMENT_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_com_deepin_client_management The com_deepin_client_management protocol
 * @section page_ifaces_com_deepin_client_management Interfaces
 * - @subpage page_iface_com_deepin_client_management - managemant client
 * @section page_copyright_com_deepin_client_management Copyright
 * <pre>
 *
 * Copyright © 2020  wugang <wugang@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct com_deepin_client_management;
struct wl_buffer;

#ifndef COM_DEEPIN_CLIENT_MANAGEMENT_INTERFACE
#define COM_DEEPIN_CLIENT_MANAGEMENT_INTERFACE
/**
 * @page page_iface_com_deepin_client_management com_deepin_client_management
 * @section page_iface_com_deepin_client_management_desc Description
 *
 * This interface enables clients to get properties of all windows shown on screen via the server.
 * The server registers one clientmanagement object as a global object.
 * @section page_iface_com_deepin_client_management_api API
 * See @ref iface_com_deepin_client_management.
 */
/**
 * @defgroup iface_com_deepin_client_management The com_deepin_client_management interface
 *
 * This interface enables clients to get properties of all windows shown on screen via the server.
 * The server registers one clientmanagement object as a global object.
 */
extern const struct wl_interface com_deepin_client_management_interface;
#endif

/**
 * @ingroup iface_com_deepin_client_management
 * @struct com_deepin_client_management_interface
 */
struct com_deepin_client_management_interface {
	/**
	 * request get the window state of all clients
	 *
	 * request window state of all clients, will notify by
	 * "windows_state" event.
	 */
	void (*get_window_states)(struct wl_client *client,
				  struct wl_resource *resource);
	/**
	 * request get the window state of all clients
	 *
	 * request window state of all clients, will notify by
	 * "windows_state" event.
	 * @param window_id window id
	 * @param buffer buffer of capture contents
	 */
	void (*capture_window_image)(struct wl_client *client,
				     struct wl_resource *resource,
				     int32_t window_id,
				     struct wl_resource *buffer);
	/**
	 * request window split
	 *
	 * request window split.
	 * @param uuid internal window uuid
	 * @param split_type split type
	 */
	void (*split_window)(struct wl_client *client,
			     struct wl_resource *resource,
			     const char *uuid,
			     int32_t split_type);
};

#define COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_STATES 0
#define COM_DEEPIN_CLIENT_MANAGEMENT_CAPTURE_CALLBACK 1
#define COM_DEEPIN_CLIENT_MANAGEMENT_SPLIT_CHANGE 2

/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_STATES_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_CAPTURE_CALLBACK_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_SPLIT_CHANGE_SINCE_VERSION 1

/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_GET_WINDOW_STATES_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_CAPTURE_WINDOW_IMAGE_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_SPLIT_WINDOW_SINCE_VERSION 1

/**
 * @ingroup iface_com_deepin_client_management
 * Sends an window_states event to the client owning the resource.
 * @param resource_ The client's resource
 * @param states windows information
 */
static inline void
com_deepin_client_management_send_window_states(struct wl_resource *resource_, uint32_t count, struct wl_array *states)
{
	wl_resource_post_event(resource_, COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_STATES, count, states);
}

/**
 * @ingroup iface_com_deepin_client_management
 * Sends an capture_callback event to the client owning the resource.
 * @param resource_ The client's resource
 * @param window_id window id
 * @param succeed 1 to succeed or 0 failed
 * @param buffer buffer of capture contents
 */
static inline void
com_deepin_client_management_send_capture_callback(struct wl_resource *resource_, int32_t window_id, int32_t succeed, struct wl_resource *buffer)
{
	wl_resource_post_event(resource_, COM_DEEPIN_CLIENT_MANAGEMENT_CAPTURE_CALLBACK, window_id, succeed, buffer);
}

/**
 * @ingroup iface_com_deepin_client_management
 * Sends an split_change event to the client owning the resource.
 * @param resource_ The client's resource
 * @param uuid internal window uuid
 * @param splitable splitable
 */
static inline void
com_deepin_client_management_send_split_change(struct wl_resource *resource_, const char *uuid, uint32_t splitable)
{
	wl_resource_post_event(resource_, COM_DEEPIN_CLIENT_MANAGEMENT_SPLIT_CHANGE, uuid, splitable);
}

#ifdef  __cplusplus
}
#endif

#endif
