/* Generated by wayland-scanner 1.22.0 */

#ifndef PLASMA_SHELL_CLIENT_PROTOCOL_H
#define PLASMA_SHELL_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_plasma_shell The plasma_shell protocol
 * @section page_ifaces_plasma_shell Interfaces
 * - @subpage page_iface_org_kde_plasma_shell - create shell windows and helpers
 * - @subpage page_iface_org_kde_plasma_surface - metadata interface
 * @section page_copyright_plasma_shell Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2013-2014 Pier Luigi Fiorini
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_plasma_shell;
struct org_kde_plasma_surface;
struct wl_output;
struct wl_surface;

#ifndef ORG_KDE_PLASMA_SHELL_INTERFACE
#define ORG_KDE_PLASMA_SHELL_INTERFACE
/**
 * @page page_iface_org_kde_plasma_shell org_kde_plasma_shell
 * @section page_iface_org_kde_plasma_shell_desc Description
 *
 * This interface is used by KF5 powered Wayland shells to communicate with
 * the compositor and can only be bound one time.
 * @section page_iface_org_kde_plasma_shell_api API
 * See @ref iface_org_kde_plasma_shell.
 */
/**
 * @defgroup iface_org_kde_plasma_shell The org_kde_plasma_shell interface
 *
 * This interface is used by KF5 powered Wayland shells to communicate with
 * the compositor and can only be bound one time.
 */
extern const struct wl_interface org_kde_plasma_shell_interface;
#endif
#ifndef ORG_KDE_PLASMA_SURFACE_INTERFACE
#define ORG_KDE_PLASMA_SURFACE_INTERFACE
/**
 * @page page_iface_org_kde_plasma_surface org_kde_plasma_surface
 * @section page_iface_org_kde_plasma_surface_desc Description
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide the shell user interface.
 *
 * It provides requests to set surface roles, assign an output
 * or set the position in output coordinates.
 *
 * On the server side the object is automatically destroyed when
 * the related wl_surface is destroyed.  On client side,
 * org_kde_plasma_surface.destroy() must be called before
 * destroying the wl_surface object.
 * @section page_iface_org_kde_plasma_surface_api API
 * See @ref iface_org_kde_plasma_surface.
 */
/**
 * @defgroup iface_org_kde_plasma_surface The org_kde_plasma_surface interface
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide the shell user interface.
 *
 * It provides requests to set surface roles, assign an output
 * or set the position in output coordinates.
 *
 * On the server side the object is automatically destroyed when
 * the related wl_surface is destroyed.  On client side,
 * org_kde_plasma_surface.destroy() must be called before
 * destroying the wl_surface object.
 */
extern const struct wl_interface org_kde_plasma_surface_interface;
#endif

#define ORG_KDE_PLASMA_SHELL_GET_SURFACE 0


/**
 * @ingroup iface_org_kde_plasma_shell
 */
#define ORG_KDE_PLASMA_SHELL_GET_SURFACE_SINCE_VERSION 1

/** @ingroup iface_org_kde_plasma_shell */
static inline void
org_kde_plasma_shell_set_user_data(struct org_kde_plasma_shell *org_kde_plasma_shell, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_plasma_shell, user_data);
}

/** @ingroup iface_org_kde_plasma_shell */
static inline void *
org_kde_plasma_shell_get_user_data(struct org_kde_plasma_shell *org_kde_plasma_shell)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_plasma_shell);
}

static inline uint32_t
org_kde_plasma_shell_get_version(struct org_kde_plasma_shell *org_kde_plasma_shell)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_shell);
}

/** @ingroup iface_org_kde_plasma_shell */
static inline void
org_kde_plasma_shell_destroy(struct org_kde_plasma_shell *org_kde_plasma_shell)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_plasma_shell);
}

/**
 * @ingroup iface_org_kde_plasma_shell
 *
 * Create a shell surface for an existing surface.
 *
 * Only one shell surface can be associated with a given
 * surface.
 */
static inline struct org_kde_plasma_surface *
org_kde_plasma_shell_get_surface(struct org_kde_plasma_shell *org_kde_plasma_shell, struct wl_surface *surface)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_shell,
			 ORG_KDE_PLASMA_SHELL_GET_SURFACE, &org_kde_plasma_surface_interface, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_shell), 0, NULL, surface);

	return (struct org_kde_plasma_surface *) id;
}

#ifndef ORG_KDE_PLASMA_SURFACE_ROLE_ENUM
#define ORG_KDE_PLASMA_SURFACE_ROLE_ENUM
enum org_kde_plasma_surface_role {
	ORG_KDE_PLASMA_SURFACE_ROLE_NORMAL = 0,
	ORG_KDE_PLASMA_SURFACE_ROLE_DESKTOP = 1,
	ORG_KDE_PLASMA_SURFACE_ROLE_PANEL = 2,
	ORG_KDE_PLASMA_SURFACE_ROLE_ONSCREENDISPLAY = 3,
	ORG_KDE_PLASMA_SURFACE_ROLE_NOTIFICATION = 4,
	ORG_KDE_PLASMA_SURFACE_ROLE_TOOLTIP = 5,
	/**
	 * @since 6
	 */
	ORG_KDE_PLASMA_SURFACE_ROLE_CRITICALNOTIFICATION = 6,
	ORG_KDE_PLASMA_SURFACE_ROLE_STANDALONE = 7,
	ORG_KDE_PLASMA_SURFACE_ROLE_OVERRIDE = 8,
	ORG_KDE_PLASMA_SURFACE_ROLE_ACTIVEFULLSCREEN = 9,
};
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_ROLE_CRITICALNOTIFICATION_SINCE_VERSION 6
#endif /* ORG_KDE_PLASMA_SURFACE_ROLE_ENUM */

#ifndef ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ENUM
#define ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ENUM
/**
 * @ingroup iface_org_kde_plasma_surface
 * Behavior for panel surface
 *
 */
enum org_kde_plasma_surface_panel_behavior {
	/**
	 * normal panel visibility
	 *
	 * The panel is on top of other surfaces, windows cannot cover
	 * (full screen windows excluded).
	 */
	ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ALWAYS_VISIBLE = 1,
	/**
	 * hide automatically
	 *
	 * The panel is hidden automatically and restored when the mouse
	 * is over.
	 */
	ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_AUTO_HIDE = 2,
	/**
	 * windows can cover
	 *
	 * Windows can cover the panel.
	 */
	ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_WINDOWS_CAN_COVER = 3,
	/**
	 * windows go below
	 *
	 * Maximized windows take the whole screen space but the panel is
	 * above the windows.
	 */
	ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_WINDOWS_GO_BELOW = 4,
};
#endif /* ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ENUM */

#ifndef ORG_KDE_PLASMA_SURFACE_ERROR_ENUM
#define ORG_KDE_PLASMA_SURFACE_ERROR_ENUM
enum org_kde_plasma_surface_error {
	/**
	 * Request panel_auto_hide performed on a surface which does not correspond to an auto-hide panel.
	 */
	ORG_KDE_PLASMA_SURFACE_ERROR_PANEL_NOT_AUTO_HIDE = 0,
};
#endif /* ORG_KDE_PLASMA_SURFACE_ERROR_ENUM */

/**
 * @ingroup iface_org_kde_plasma_surface
 * @struct org_kde_plasma_surface_listener
 */
struct org_kde_plasma_surface_listener {
	/**
	 * Auto-hiding panel is hidden
	 *
	 * An auto-hiding panel got hidden by the compositor.
	 * @since 4
	 */
	void (*auto_hidden_panel_hidden)(void *data,
					 struct org_kde_plasma_surface *org_kde_plasma_surface);
	/**
	 * Auto-hiding panel is shown
	 *
	 * An auto-hiding panel got shown by the compositor.
	 * @since 4
	 */
	void (*auto_hidden_panel_shown)(void *data,
					struct org_kde_plasma_surface *org_kde_plasma_surface);
};

/**
 * @ingroup iface_org_kde_plasma_surface
 */
static inline int
org_kde_plasma_surface_add_listener(struct org_kde_plasma_surface *org_kde_plasma_surface,
				    const struct org_kde_plasma_surface_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_kde_plasma_surface,
				     (void (**)(void)) listener, data);
}

#define ORG_KDE_PLASMA_SURFACE_DESTROY 0
#define ORG_KDE_PLASMA_SURFACE_SET_OUTPUT 1
#define ORG_KDE_PLASMA_SURFACE_SET_POSITION 2
#define ORG_KDE_PLASMA_SURFACE_SET_ROLE 3
#define ORG_KDE_PLASMA_SURFACE_SET_PANEL_BEHAVIOR 4
#define ORG_KDE_PLASMA_SURFACE_SET_SKIP_TASKBAR 5
#define ORG_KDE_PLASMA_SURFACE_PANEL_AUTO_HIDE_HIDE 6
#define ORG_KDE_PLASMA_SURFACE_PANEL_AUTO_HIDE_SHOW 7
#define ORG_KDE_PLASMA_SURFACE_SET_PANEL_TAKES_FOCUS 8
#define ORG_KDE_PLASMA_SURFACE_SET_SKIP_SWITCHER 9

/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_AUTO_HIDDEN_PANEL_HIDDEN_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_AUTO_HIDDEN_PANEL_SHOWN_SINCE_VERSION 4

/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_ROLE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_PANEL_BEHAVIOR_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_SKIP_TASKBAR_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_PANEL_AUTO_HIDE_HIDE_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_PANEL_AUTO_HIDE_SHOW_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_PANEL_TAKES_FOCUS_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_SKIP_SWITCHER_SINCE_VERSION 5

/** @ingroup iface_org_kde_plasma_surface */
static inline void
org_kde_plasma_surface_set_user_data(struct org_kde_plasma_surface *org_kde_plasma_surface, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_plasma_surface, user_data);
}

/** @ingroup iface_org_kde_plasma_surface */
static inline void *
org_kde_plasma_surface_get_user_data(struct org_kde_plasma_surface *org_kde_plasma_surface)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_plasma_surface);
}

static inline uint32_t
org_kde_plasma_surface_get_version(struct org_kde_plasma_surface *org_kde_plasma_surface)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * The org_kde_plasma_surface interface is removed from the
 * wl_surface object that was turned into a shell surface with the
 * org_kde_plasma_shell.get_surface request.
 * The shell surface role is lost and wl_surface is unmapped.
 */
static inline void
org_kde_plasma_surface_destroy(struct org_kde_plasma_surface *org_kde_plasma_surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * Assign an output to this shell surface.
 * The compositor will use this information to set the position
 * when org_kde_plasma_surface.set_position request is
 * called.
 */
static inline void
org_kde_plasma_surface_set_output(struct org_kde_plasma_surface *org_kde_plasma_surface, struct wl_output *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_SET_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), 0, output);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * Move the surface to new coordinates.
 *
 * Coordinates are global, for example 50,50 for a 1920,0+1920x1080 output
 * is 1970,50 in global coordinates space.
 *
 * Use org_kde_plasma_surface.set_output to assign an output
 * to this surface.
 */
static inline void
org_kde_plasma_surface_set_position(struct org_kde_plasma_surface *org_kde_plasma_surface, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_SET_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), 0, x, y);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * Assign a role to a shell surface.
 *
 * The compositor handles surfaces depending on their role.
 * See the explanation below.
 *
 * This request fails if the surface already has a role, this means
 * the surface role may be assigned only once.
 *
 * == Surfaces with splash role ==
 *
 * Splash surfaces are placed above every other surface during the
 * shell startup phase.
 *
 * The surfaces are placed according to the output coordinates.
 * No size is imposed to those surfaces, the shell has to resize
 * them according to output size.
 *
 * These surfaces are meant to hide the desktop during the startup
 * phase so that the user will always see a ready to work desktop.
 *
 * A shell might not create splash surfaces if the compositor reveals
 * the desktop in an alternative fashion, for example with a fade
 * in effect.
 *
 * That depends on how much time the desktop usually need to prepare
 * the workspace or specific design decisions.
 * This specification doesn't impose any particular design.
 *
 * When the startup phase is finished, the shell will send the
 * org_kde_plasma.desktop_ready request to the compositor.
 *
 * == Surfaces with desktop role ==
 *
 * Desktop surfaces are placed below all other surfaces and are used
 * to show the actual desktop view with icons, search results or
 * controls the user will interact with. What to show depends on the
 * shell implementation.
 *
 * The surfaces are placed according to the output coordinates.
 * No size is imposed to those surfaces, the shell has to resize
 * them according to output size.
 *
 * Only one surface per output can have the desktop role.
 *
 * == Surfaces with dashboard role ==
 *
 * Dashboard surfaces are placed above desktop surfaces and are used to
 * show additional widgets and controls.
 *
 * The surfaces are placed according to the output coordinates.
 * No size is imposed to those surfaces, the shell has to resize
 * them according to output size.
 *
 * Only one surface per output can have the dashboard role.
 *
 * == Surfaces with config role ==
 *
 * A configuration surface is shown when the user wants to configure
 * panel or desktop views.
 *
 * Only one surface per output can have the config role.
 *
 * TODO: This should grab the input like popup menus, right?
 *
 * == Surfaces with overlay role ==
 *
 * Overlays are special surfaces that shows for a limited amount
 * of time.  Such surfaces are useful to display things like volume,
 * brightness and status changes.
 *
 * Compositors may decide to show those surfaces in a layer above
 * all surfaces, even full screen ones if so is desired.
 *
 * == Surfaces with notification role ==
 *
 * Notification surfaces display informative content for a limited
 * amount of time.  The compositor may decide to show them in a corner
 * depending on the configuration.
 *
 * These surfaces are shown in a layer above all other surfaces except
 * for full screen ones.
 *
 * == Surfaces with lock role ==
 *
 * The lock surface is shown by the compositor when the session is
 * locked, users interact with it to unlock the session.
 *
 * Compositors should move lock surfaces to 0,0 in output
 * coordinates space and hide all other surfaces for security sake.
 * For the same reason it is recommended that clients make the
 * lock surface as big as the screen.
 *
 * Only one surface per output can have the lock role.
 */
static inline void
org_kde_plasma_surface_set_role(struct org_kde_plasma_surface *org_kde_plasma_surface, uint32_t role)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_SET_ROLE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), 0, role);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * Set flags bitmask as described by the flag enum.
 * Pass 0 to unset any flag, the surface will adjust its behavior to
 * the default.
 */
static inline void
org_kde_plasma_surface_set_panel_behavior(struct org_kde_plasma_surface *org_kde_plasma_surface, uint32_t flag)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_SET_PANEL_BEHAVIOR, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), 0, flag);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * Setting this bit to the window, will make it say it prefers to not be listed in the taskbar. Taskbar implementations may or may not follow this hint.
 */
static inline void
org_kde_plasma_surface_set_skip_taskbar(struct org_kde_plasma_surface *org_kde_plasma_surface, uint32_t skip)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_SET_SKIP_TASKBAR, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), 0, skip);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * A panel surface with panel_behavior auto_hide can perform this request to hide the panel
 * on a screen edge without unmapping it. The compositor informs the client about the panel
 * being hidden with the event auto_hidden_panel_hidden.
 *
 * The compositor will restore the visibility state of the
 * surface when the pointer touches the screen edge the panel borders. Once the compositor restores
 * the visibility the event auto_hidden_panel_shown will be sent. This event will also be sent
 * if the compositor is unable to hide the panel.
 *
 * The client can also request to show the panel again with the request panel_auto_hide_show.
 */
static inline void
org_kde_plasma_surface_panel_auto_hide_hide(struct org_kde_plasma_surface *org_kde_plasma_surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_PANEL_AUTO_HIDE_HIDE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), 0);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * A panel surface with panel_behavior auto_hide can perform this request to show the panel
 * again which got hidden with panel_auto_hide_hide.
 */
static inline void
org_kde_plasma_surface_panel_auto_hide_show(struct org_kde_plasma_surface *org_kde_plasma_surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_PANEL_AUTO_HIDE_SHOW, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), 0);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * By default various org_kde_plasma_surface roles do not take focus and cannot be
 * activated. With this request the compositor can be instructed to pass focus also to this
 * org_kde_plasma_surface.
 */
static inline void
org_kde_plasma_surface_set_panel_takes_focus(struct org_kde_plasma_surface *org_kde_plasma_surface, uint32_t takes_focus)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_SET_PANEL_TAKES_FOCUS, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), 0, takes_focus);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 *
 * Setting this bit will indicate that the window prefers not to be listed in a switcher.
 */
static inline void
org_kde_plasma_surface_set_skip_switcher(struct org_kde_plasma_surface *org_kde_plasma_surface, uint32_t skip)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_plasma_surface,
			 ORG_KDE_PLASMA_SURFACE_SET_SKIP_SWITCHER, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_plasma_surface), 0, skip);
}

#ifdef  __cplusplus
}
#endif

#endif
