/* Generated by wayland-scanner 1.22.0 */

#ifndef OUTPUTMANAGEMENT_CLIENT_PROTOCOL_H
#define OUTPUTMANAGEMENT_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_outputmanagement The outputmanagement protocol
 * @section page_ifaces_outputmanagement Interfaces
 * - @subpage page_iface_org_kde_kwin_outputmanagement - configuration of server outputs through clients
 * - @subpage page_iface_org_kde_kwin_outputconfiguration - configure single output devices
 * @section page_copyright_outputmanagement Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2008-2011 Kristian Høgsberg
 * SPDX-FileCopyrightText: 2010-2011 Intel Corporation
 * SPDX-FileCopyrightText: 2012-2013 Collabora, Ltd.
 * SPDX-FileCopyrightText: 2015 Sebastian Kügler <sebas@kde.org>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct org_kde_kwin_outputconfiguration;
struct org_kde_kwin_outputdevice;
struct org_kde_kwin_outputmanagement;

#ifndef ORG_KDE_KWIN_OUTPUTMANAGEMENT_INTERFACE
#define ORG_KDE_KWIN_OUTPUTMANAGEMENT_INTERFACE
/**
 * @page page_iface_org_kde_kwin_outputmanagement org_kde_kwin_outputmanagement
 * @section page_iface_org_kde_kwin_outputmanagement_desc Description
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global org_kde_kwin_outputdevice objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode_id)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 * @section page_iface_org_kde_kwin_outputmanagement_api API
 * See @ref iface_org_kde_kwin_outputmanagement.
 */
/**
 * @defgroup iface_org_kde_kwin_outputmanagement The org_kde_kwin_outputmanagement interface
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global org_kde_kwin_outputdevice objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode_id)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 */
extern const struct wl_interface org_kde_kwin_outputmanagement_interface;
#endif
#ifndef ORG_KDE_KWIN_OUTPUTCONFIGURATION_INTERFACE
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_INTERFACE
/**
 * @page page_iface_org_kde_kwin_outputconfiguration org_kde_kwin_outputconfiguration
 * @section page_iface_org_kde_kwin_outputconfiguration_desc Description
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 * @section page_iface_org_kde_kwin_outputconfiguration_api API
 * See @ref iface_org_kde_kwin_outputconfiguration.
 */
/**
 * @defgroup iface_org_kde_kwin_outputconfiguration The org_kde_kwin_outputconfiguration interface
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 */
extern const struct wl_interface org_kde_kwin_outputconfiguration_interface;
#endif

#define ORG_KDE_KWIN_OUTPUTMANAGEMENT_CREATE_CONFIGURATION 0


/**
 * @ingroup iface_org_kde_kwin_outputmanagement
 */
#define ORG_KDE_KWIN_OUTPUTMANAGEMENT_CREATE_CONFIGURATION_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_outputmanagement */
static inline void
org_kde_kwin_outputmanagement_set_user_data(struct org_kde_kwin_outputmanagement *org_kde_kwin_outputmanagement, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_outputmanagement, user_data);
}

/** @ingroup iface_org_kde_kwin_outputmanagement */
static inline void *
org_kde_kwin_outputmanagement_get_user_data(struct org_kde_kwin_outputmanagement *org_kde_kwin_outputmanagement)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_outputmanagement);
}

static inline uint32_t
org_kde_kwin_outputmanagement_get_version(struct org_kde_kwin_outputmanagement *org_kde_kwin_outputmanagement)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputmanagement);
}

/** @ingroup iface_org_kde_kwin_outputmanagement */
static inline void
org_kde_kwin_outputmanagement_destroy(struct org_kde_kwin_outputmanagement *org_kde_kwin_outputmanagement)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_outputmanagement);
}

/**
 * @ingroup iface_org_kde_kwin_outputmanagement
 *
 * Request an outputconfiguration object through which the client can configure
 * output devices.
 */
static inline struct org_kde_kwin_outputconfiguration *
org_kde_kwin_outputmanagement_create_configuration(struct org_kde_kwin_outputmanagement *org_kde_kwin_outputmanagement)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputmanagement,
			 ORG_KDE_KWIN_OUTPUTMANAGEMENT_CREATE_CONFIGURATION, &org_kde_kwin_outputconfiguration_interface, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputmanagement), 0, NULL);

	return (struct org_kde_kwin_outputconfiguration *) id;
}

#ifndef ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_ENUM
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_ENUM
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 * describes vrr policy
 *
 * Describes when the compositor may employ variable refresh rate
 */
enum org_kde_kwin_outputconfiguration_vrr_policy {
	ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_NEVER = 0,
	ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_ALWAYS = 1,
	ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_AUTOMATIC = 2,
};
#endif /* ORG_KDE_KWIN_OUTPUTCONFIGURATION_VRR_POLICY_ENUM */

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 * @struct org_kde_kwin_outputconfiguration_listener
 */
struct org_kde_kwin_outputconfiguration_listener {
	/**
	 * configuration changes have been applied
	 *
	 * Sent after the server has successfully applied the changes. .
	 */
	void (*applied)(void *data,
			struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration);
	/**
	 * configuration changes failed to apply
	 *
	 * Sent if the server rejects the changes or failed to apply
	 * them.
	 */
	void (*failed)(void *data,
		       struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration);
};

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
static inline int
org_kde_kwin_outputconfiguration_add_listener(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration,
					      const struct org_kde_kwin_outputconfiguration_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_kde_kwin_outputconfiguration,
				     (void (**)(void)) listener, data);
}

#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_ENABLE 0
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_MODE 1
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_TRANSFORM 2
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_POSITION 3
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_SCALE 4
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_APPLY 5
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_SCALEF 6
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_COLORCURVES 7
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_DESTROY 8
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_OVERSCAN 9
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_SET_VRR_POLICY 10
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_BRIGHTNESS 11

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_APPLIED_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_ENABLE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_APPLY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_SCALEF_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_COLORCURVES_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_DESTROY_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_OVERSCAN_SINCE_VERSION 3
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_SET_VRR_POLICY_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
#define ORG_KDE_KWIN_OUTPUTCONFIGURATION_BRIGHTNESS_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_outputconfiguration */
static inline void
org_kde_kwin_outputconfiguration_set_user_data(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_outputconfiguration, user_data);
}

/** @ingroup iface_org_kde_kwin_outputconfiguration */
static inline void *
org_kde_kwin_outputconfiguration_get_user_data(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_outputconfiguration);
}

static inline uint32_t
org_kde_kwin_outputconfiguration_get_version(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Mark the output as enabled or disabled.
 */
static inline void
org_kde_kwin_outputconfiguration_enable(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, int32_t enable)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_ENABLE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, enable);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Sets the mode for a given output by its mode size (width and height) and refresh rate.
 */
static inline void
org_kde_kwin_outputconfiguration_mode(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, int32_t mode_id)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, mode_id);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Sets the transformation for a given output.
 */
static inline void
org_kde_kwin_outputconfiguration_transform(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, int32_t transform)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_TRANSFORM, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, transform);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Sets the position for this output device. (x,y) describe the top-left corner
 * of the output in global space, whereby the origin (0,0) of the global space
 * has to be aligned with the top-left corner of the most left and in case this
 * does not define a single one the top output.
 *
 * There may be no gaps or overlaps between outputs, i.e. the outputs are
 * stacked horizontally, vertically, or both on each other.
 */
static inline void
org_kde_kwin_outputconfiguration_position(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, x, y);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Sets the scaling factor for this output device.
 */
static inline void
org_kde_kwin_outputconfiguration_scale(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, int32_t scale)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_SCALE, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, scale);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Asks the server to apply property changes requested through this outputconfiguration
 * object to all outputs on the server side.
 */
static inline void
org_kde_kwin_outputconfiguration_apply(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_APPLY, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Sets the scaling factor for this output device.
 * Sending both scale and scalef is undefined.
 */
static inline void
org_kde_kwin_outputconfiguration_scalef(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, wl_fixed_t scale)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_SCALEF, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, scale);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Set color curves of output devices through RGB color ramps. Allows color
 * correction of output device from user space.
 *
 * These are the raw values. A compositor might opt to adjust these values
 * internally, for example to shift color temperature at night.
 */
static inline void
org_kde_kwin_outputconfiguration_colorcurves(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, struct wl_array *red, struct wl_array *green, struct wl_array *blue)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_COLORCURVES, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, red, green, blue);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 */
static inline void
org_kde_kwin_outputconfiguration_destroy(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Set the overscan value of this output device with a value in percent.
 */
static inline void
org_kde_kwin_outputconfiguration_overscan(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, uint32_t overscan)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_OVERSCAN, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, overscan);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Set what policy the compositor should employ regarding its use of
 * variable refresh rate.
 */
static inline void
org_kde_kwin_outputconfiguration_set_vrr_policy(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, uint32_t policy)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_SET_VRR_POLICY, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, policy);
}

/**
 * @ingroup iface_org_kde_kwin_outputconfiguration
 *
 * Sets the just a test.
 */
static inline void
org_kde_kwin_outputconfiguration_brightness(struct org_kde_kwin_outputconfiguration *org_kde_kwin_outputconfiguration, struct org_kde_kwin_outputdevice *outputdevice, int32_t brightness)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_outputconfiguration,
			 ORG_KDE_KWIN_OUTPUTCONFIGURATION_BRIGHTNESS, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_outputconfiguration), 0, outputdevice, brightness);
}

#ifdef  __cplusplus
}
#endif

#endif
