/* Generated by wayland-scanner 1.22.0 */

#ifndef KEYSTATE_CLIENT_PROTOCOL_H
#define KEYSTATE_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_keystate The keystate protocol
 * @section page_ifaces_keystate Interfaces
 * - @subpage page_iface_org_kde_kwin_keystate - Key States
 * @section page_copyright_keystate Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2019 Aleix Pol Gonzalez <aleixpol@kde.org>
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_kwin_keystate;

#ifndef ORG_KDE_KWIN_KEYSTATE_INTERFACE
#define ORG_KDE_KWIN_KEYSTATE_INTERFACE
/**
 * @page page_iface_org_kde_kwin_keystate org_kde_kwin_keystate
 * @section page_iface_org_kde_kwin_keystate_desc Description
 *
 * Keeps track of the states of the different keys that have a state attached to it.
 * @section page_iface_org_kde_kwin_keystate_api API
 * See @ref iface_org_kde_kwin_keystate.
 */
/**
 * @defgroup iface_org_kde_kwin_keystate The org_kde_kwin_keystate interface
 *
 * Keeps track of the states of the different keys that have a state attached to it.
 */
extern const struct wl_interface org_kde_kwin_keystate_interface;
#endif

#ifndef ORG_KDE_KWIN_KEYSTATE_KEY_ENUM
#define ORG_KDE_KWIN_KEYSTATE_KEY_ENUM
enum org_kde_kwin_keystate_key {
	ORG_KDE_KWIN_KEYSTATE_KEY_CAPSLOCK = 0,
	ORG_KDE_KWIN_KEYSTATE_KEY_NUMLOCK = 1,
	ORG_KDE_KWIN_KEYSTATE_KEY_SCROLLLOCK = 2,
};
#endif /* ORG_KDE_KWIN_KEYSTATE_KEY_ENUM */

#ifndef ORG_KDE_KWIN_KEYSTATE_STATE_ENUM
#define ORG_KDE_KWIN_KEYSTATE_STATE_ENUM
enum org_kde_kwin_keystate_state {
	ORG_KDE_KWIN_KEYSTATE_STATE_UNLOCKED = 0,
	ORG_KDE_KWIN_KEYSTATE_STATE_LATCHED = 1,
	ORG_KDE_KWIN_KEYSTATE_STATE_LOCKED = 2,
};
#endif /* ORG_KDE_KWIN_KEYSTATE_STATE_ENUM */

/**
 * @ingroup iface_org_kde_kwin_keystate
 * @struct org_kde_kwin_keystate_listener
 */
struct org_kde_kwin_keystate_listener {
	/**
	 * Updates the state for a said key
	 *
	 * 
	 */
	void (*stateChanged)(void *data,
			     struct org_kde_kwin_keystate *org_kde_kwin_keystate,
			     uint32_t key,
			     uint32_t state);
};

/**
 * @ingroup iface_org_kde_kwin_keystate
 */
static inline int
org_kde_kwin_keystate_add_listener(struct org_kde_kwin_keystate *org_kde_kwin_keystate,
				   const struct org_kde_kwin_keystate_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) org_kde_kwin_keystate,
				     (void (**)(void)) listener, data);
}

#define ORG_KDE_KWIN_KEYSTATE_FETCHSTATES 0

/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_STATECHANGED_SINCE_VERSION 1

/**
 * @ingroup iface_org_kde_kwin_keystate
 */
#define ORG_KDE_KWIN_KEYSTATE_FETCHSTATES_SINCE_VERSION 1

/** @ingroup iface_org_kde_kwin_keystate */
static inline void
org_kde_kwin_keystate_set_user_data(struct org_kde_kwin_keystate *org_kde_kwin_keystate, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) org_kde_kwin_keystate, user_data);
}

/** @ingroup iface_org_kde_kwin_keystate */
static inline void *
org_kde_kwin_keystate_get_user_data(struct org_kde_kwin_keystate *org_kde_kwin_keystate)
{
	return wl_proxy_get_user_data((struct wl_proxy *) org_kde_kwin_keystate);
}

static inline uint32_t
org_kde_kwin_keystate_get_version(struct org_kde_kwin_keystate *org_kde_kwin_keystate)
{
	return wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_keystate);
}

/** @ingroup iface_org_kde_kwin_keystate */
static inline void
org_kde_kwin_keystate_destroy(struct org_kde_kwin_keystate *org_kde_kwin_keystate)
{
	wl_proxy_destroy((struct wl_proxy *) org_kde_kwin_keystate);
}

/**
 * @ingroup iface_org_kde_kwin_keystate
 */
static inline void
org_kde_kwin_keystate_fetchStates(struct org_kde_kwin_keystate *org_kde_kwin_keystate)
{
	wl_proxy_marshal_flags((struct wl_proxy *) org_kde_kwin_keystate,
			 ORG_KDE_KWIN_KEYSTATE_FETCHSTATES, NULL, wl_proxy_get_version((struct wl_proxy *) org_kde_kwin_keystate), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
