/* Generated by wayland-scanner 1.22.0 */

#ifndef KDE_PRIMARY_OUTPUT_V1_CLIENT_PROTOCOL_H
#define KDE_PRIMARY_OUTPUT_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_kde_primary_output_v1 The kde_primary_output_v1 protocol
 * @section page_ifaces_kde_primary_output_v1 Interfaces
 * - @subpage page_iface_kde_primary_output_v1 - expose which is the primary display
 * @section page_copyright_kde_primary_output_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2021 Aleix Pol Gonzalez <aleixpol@kde.org>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_primary_output_v1;

#ifndef KDE_PRIMARY_OUTPUT_V1_INTERFACE
#define KDE_PRIMARY_OUTPUT_V1_INTERFACE
/**
 * @page page_iface_kde_primary_output_v1 kde_primary_output_v1
 * @section page_iface_kde_primary_output_v1_desc Description
 *
 * Protocol for telling which is the primary display among the selection of enabled outputs.
 * @section page_iface_kde_primary_output_v1_api API
 * See @ref iface_kde_primary_output_v1.
 */
/**
 * @defgroup iface_kde_primary_output_v1 The kde_primary_output_v1 interface
 *
 * Protocol for telling which is the primary display among the selection of enabled outputs.
 */
extern const struct wl_interface kde_primary_output_v1_interface;
#endif

/**
 * @ingroup iface_kde_primary_output_v1
 * @struct kde_primary_output_v1_listener
 */
struct kde_primary_output_v1_listener {
	/**
	 * Provide the current primary output's name
	 *
	 * Specifies which output is the primary one identified by their
	 * uuid. See kde_output_device_v2 uuid event for more information
	 * about it.
	 * @param output_name the name of the output
	 */
	void (*primary_output)(void *data,
			       struct kde_primary_output_v1 *kde_primary_output_v1,
			       const char *output_name);
};

/**
 * @ingroup iface_kde_primary_output_v1
 */
static inline int
kde_primary_output_v1_add_listener(struct kde_primary_output_v1 *kde_primary_output_v1,
				   const struct kde_primary_output_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) kde_primary_output_v1,
				     (void (**)(void)) listener, data);
}

/**
 * @ingroup iface_kde_primary_output_v1
 */
#define KDE_PRIMARY_OUTPUT_V1_PRIMARY_OUTPUT_SINCE_VERSION 1


/** @ingroup iface_kde_primary_output_v1 */
static inline void
kde_primary_output_v1_set_user_data(struct kde_primary_output_v1 *kde_primary_output_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_primary_output_v1, user_data);
}

/** @ingroup iface_kde_primary_output_v1 */
static inline void *
kde_primary_output_v1_get_user_data(struct kde_primary_output_v1 *kde_primary_output_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_primary_output_v1);
}

static inline uint32_t
kde_primary_output_v1_get_version(struct kde_primary_output_v1 *kde_primary_output_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_primary_output_v1);
}

/** @ingroup iface_kde_primary_output_v1 */
static inline void
kde_primary_output_v1_destroy(struct kde_primary_output_v1 *kde_primary_output_v1)
{
	wl_proxy_destroy((struct wl_proxy *) kde_primary_output_v1);
}

#ifdef  __cplusplus
}
#endif

#endif
