/* Generated by wayland-scanner 1.22.0 */

#ifndef KDE_OUTPUT_MANAGEMENT_V2_CLIENT_PROTOCOL_H
#define KDE_OUTPUT_MANAGEMENT_V2_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_kde_output_management_v2 The kde_output_management_v2 protocol
 * @section page_ifaces_kde_output_management_v2 Interfaces
 * - @subpage page_iface_kde_output_management_v2 - configuration of server outputs through clients
 * - @subpage page_iface_kde_output_configuration_v2 - configure single output devices
 * @section page_copyright_kde_output_management_v2 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2008-2011 Kristian Høgsberg
 * SPDX-FileCopyrightText: 2010-2011 Intel Corporation
 * SPDX-FileCopyrightText: 2012-2013 Collabora, Ltd.
 * SPDX-FileCopyrightText: 2015 Sebastian Kügler <sebas@kde.org>
 * SPDX-FileCopyrightText: 2021 Méven Car <meven.car@enioka.com>
 *
 * SPDX-License-Identifier: MIT-CMU
 * </pre>
 */
struct kde_output_configuration_v2;
struct kde_output_device_mode_v2;
struct kde_output_device_v2;
struct kde_output_management_v2;

#ifndef KDE_OUTPUT_MANAGEMENT_V2_INTERFACE
#define KDE_OUTPUT_MANAGEMENT_V2_INTERFACE
/**
 * @page page_iface_kde_output_management_v2 kde_output_management_v2
 * @section page_iface_kde_output_management_v2_desc Description
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global kde_output_device_v2 objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 * @section page_iface_kde_output_management_v2_api API
 * See @ref iface_kde_output_management_v2.
 */
/**
 * @defgroup iface_kde_output_management_v2 The kde_output_management_v2 interface
 *
 * This interface enables clients to set properties of output devices for screen
 * configuration purposes via the server. To this end output devices are referenced
 * by global kde_output_device_v2 objects.
 *
 * outputmanagement (wl_global)
 * --------------------------
 * request:
 * * create_configuration -> outputconfiguration (wl_resource)
 *
 * outputconfiguration (wl_resource)
 * --------------------------
 * requests:
 * * enable(outputdevice, bool)
 * * mode(outputdevice, mode)
 * * transformation(outputdevice, flag)
 * * position(outputdevice, x, y)
 * * apply
 *
 * events:
 * * applied
 * * failed
 *
 * The server registers one outputmanagement object as a global object. In order
 * to configure outputs a client requests create_configuration, which provides a
 * resource referencing an outputconfiguration for one-time configuration. That
 * way the server knows which requests belong together and can group them by that.
 *
 * On the outputconfiguration object the client calls for each output whether the
 * output should be enabled, which mode should be set (by referencing the mode from
 * the list of announced modes) and the output's global position. Once all outputs
 * are configured that way, the client calls apply.
 * At that point and not earlier the server should try to apply the configuration.
 * If this succeeds the server emits the applied signal, otherwise the failed
 * signal, such that the configuring client is noticed about the success of its
 * configuration request.
 *
 * Through this design the interface enables atomic output configuration changes if
 * internally supported by the server.
 *
 */
extern const struct wl_interface kde_output_management_v2_interface;
#endif
#ifndef KDE_OUTPUT_CONFIGURATION_V2_INTERFACE
#define KDE_OUTPUT_CONFIGURATION_V2_INTERFACE
/**
 * @page page_iface_kde_output_configuration_v2 kde_output_configuration_v2
 * @section page_iface_kde_output_configuration_v2_desc Description
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 * @section page_iface_kde_output_configuration_v2_api API
 * See @ref iface_kde_output_configuration_v2.
 */
/**
 * @defgroup iface_kde_output_configuration_v2 The kde_output_configuration_v2 interface
 *
 * outputconfiguration is a client-specific resource that can be used to ask
 * the server to apply changes to available output devices.
 *
 * The client receives a list of output devices from the registry. When it wants
 * to apply new settings, it creates a configuration object from the
 * outputmanagement global, writes changes through this object's enable, scale,
 * transform and mode calls. It then asks the server to apply these settings in
 * an atomic fashion, for example through Linux' DRM interface.
 *
 * The server signals back whether the new settings have applied successfully
 * or failed to apply. outputdevice objects are updated after the changes have been
 * applied to the hardware and before the server side sends the applied event.
 */
extern const struct wl_interface kde_output_configuration_v2_interface;
#endif

#define KDE_OUTPUT_MANAGEMENT_V2_CREATE_CONFIGURATION 0


/**
 * @ingroup iface_kde_output_management_v2
 */
#define KDE_OUTPUT_MANAGEMENT_V2_CREATE_CONFIGURATION_SINCE_VERSION 1

/** @ingroup iface_kde_output_management_v2 */
static inline void
kde_output_management_v2_set_user_data(struct kde_output_management_v2 *kde_output_management_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_output_management_v2, user_data);
}

/** @ingroup iface_kde_output_management_v2 */
static inline void *
kde_output_management_v2_get_user_data(struct kde_output_management_v2 *kde_output_management_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_output_management_v2);
}

static inline uint32_t
kde_output_management_v2_get_version(struct kde_output_management_v2 *kde_output_management_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_output_management_v2);
}

/** @ingroup iface_kde_output_management_v2 */
static inline void
kde_output_management_v2_destroy(struct kde_output_management_v2 *kde_output_management_v2)
{
	wl_proxy_destroy((struct wl_proxy *) kde_output_management_v2);
}

/**
 * @ingroup iface_kde_output_management_v2
 *
 * Request an outputconfiguration object through which the client can configure
 * output devices.
 */
static inline struct kde_output_configuration_v2 *
kde_output_management_v2_create_configuration(struct kde_output_management_v2 *kde_output_management_v2)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) kde_output_management_v2,
			 KDE_OUTPUT_MANAGEMENT_V2_CREATE_CONFIGURATION, &kde_output_configuration_v2_interface, wl_proxy_get_version((struct wl_proxy *) kde_output_management_v2), 0, NULL);

	return (struct kde_output_configuration_v2 *) id;
}

#ifndef KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * describes vrr policy
 *
 * Describes when the compositor may employ variable refresh rate
 */
enum kde_output_configuration_v2_vrr_policy {
	KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_NEVER = 0,
	KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ALWAYS = 1,
	KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_AUTOMATIC = 2,
};
#endif /* KDE_OUTPUT_CONFIGURATION_V2_VRR_POLICY_ENUM */

#ifndef KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_ENUM
#define KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_ENUM
/**
 * @ingroup iface_kde_output_configuration_v2
 * describes RGB range policy
 *
 * Whether this output should use full or limited rgb.
 */
enum kde_output_configuration_v2_rgb_range {
	KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_AUTOMATIC = 0,
	KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_FULL = 1,
	KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_LIMITED = 2,
};
#endif /* KDE_OUTPUT_CONFIGURATION_V2_RGB_RANGE_ENUM */

/**
 * @ingroup iface_kde_output_configuration_v2
 * @struct kde_output_configuration_v2_listener
 */
struct kde_output_configuration_v2_listener {
	/**
	 * configuration changes have been applied
	 *
	 * Sent after the server has successfully applied the changes. .
	 */
	void (*applied)(void *data,
			struct kde_output_configuration_v2 *kde_output_configuration_v2);
	/**
	 * configuration changes failed to apply
	 *
	 * Sent if the server rejects the changes or failed to apply
	 * them.
	 */
	void (*failed)(void *data,
		       struct kde_output_configuration_v2 *kde_output_configuration_v2);
};

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline int
kde_output_configuration_v2_add_listener(struct kde_output_configuration_v2 *kde_output_configuration_v2,
					 const struct kde_output_configuration_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) kde_output_configuration_v2,
				     (void (**)(void)) listener, data);
}

#define KDE_OUTPUT_CONFIGURATION_V2_ENABLE 0
#define KDE_OUTPUT_CONFIGURATION_V2_MODE 1
#define KDE_OUTPUT_CONFIGURATION_V2_TRANSFORM 2
#define KDE_OUTPUT_CONFIGURATION_V2_POSITION 3
#define KDE_OUTPUT_CONFIGURATION_V2_SCALE 4
#define KDE_OUTPUT_CONFIGURATION_V2_APPLY 5
#define KDE_OUTPUT_CONFIGURATION_V2_DESTROY 6
#define KDE_OUTPUT_CONFIGURATION_V2_OVERSCAN 7
#define KDE_OUTPUT_CONFIGURATION_V2_SET_VRR_POLICY 8
#define KDE_OUTPUT_CONFIGURATION_V2_SET_RGB_RANGE 9
#define KDE_OUTPUT_CONFIGURATION_V2_SET_PRIMARY_OUTPUT 10
#define KDE_OUTPUT_CONFIGURATION_V2_BRIGHTNESS 11

/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_APPLIED_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_ENABLE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_MODE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SCALE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_APPLY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_OVERSCAN_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_VRR_POLICY_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_RGB_RANGE_SINCE_VERSION 1
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_SET_PRIMARY_OUTPUT_SINCE_VERSION 2
/**
 * @ingroup iface_kde_output_configuration_v2
 */
#define KDE_OUTPUT_CONFIGURATION_V2_BRIGHTNESS_SINCE_VERSION 1

/** @ingroup iface_kde_output_configuration_v2 */
static inline void
kde_output_configuration_v2_set_user_data(struct kde_output_configuration_v2 *kde_output_configuration_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) kde_output_configuration_v2, user_data);
}

/** @ingroup iface_kde_output_configuration_v2 */
static inline void *
kde_output_configuration_v2_get_user_data(struct kde_output_configuration_v2 *kde_output_configuration_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) kde_output_configuration_v2);
}

static inline uint32_t
kde_output_configuration_v2_get_version(struct kde_output_configuration_v2 *kde_output_configuration_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Mark the output as enabled or disabled.
 */
static inline void
kde_output_configuration_v2_enable(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, int32_t enable)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_ENABLE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, enable);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the mode for a given output.
 */
static inline void
kde_output_configuration_v2_mode(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, struct kde_output_device_mode_v2 *mode)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_MODE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, mode);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the transformation for a given output.
 */
static inline void
kde_output_configuration_v2_transform(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, int32_t transform)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_TRANSFORM, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, transform);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the position for this output device. (x,y) describe the top-left corner
 * of the output in global space, whereby the origin (0,0) of the global space
 * has to be aligned with the top-left corner of the most left and in case this
 * does not define a single one the top output.
 *
 * There may be no gaps or overlaps between outputs, i.e. the outputs are
 * stacked horizontally, vertically, or both on each other.
 */
static inline void
kde_output_configuration_v2_position(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, int32_t x, int32_t y)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_POSITION, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, x, y);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the scaling factor for this output device.
 */
static inline void
kde_output_configuration_v2_scale(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, wl_fixed_t scale)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SCALE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, scale);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Asks the server to apply property changes requested through this outputconfiguration
 * object to all outputs on the server side.
 */
static inline void
kde_output_configuration_v2_apply(struct kde_output_configuration_v2 *kde_output_configuration_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_APPLY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_destroy(struct kde_output_configuration_v2 *kde_output_configuration_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Set the overscan value of this output device with a value in percent.
 */
static inline void
kde_output_configuration_v2_overscan(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t overscan)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_OVERSCAN, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, overscan);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Set what policy the compositor should employ regarding its use of
 * variable refresh rate.
 */
static inline void
kde_output_configuration_v2_set_vrr_policy(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t policy)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_VRR_POLICY, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, policy);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Whether full or limited color range should be used
 */
static inline void
kde_output_configuration_v2_set_rgb_range(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, uint32_t rgb_range)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_RGB_RANGE, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, rgb_range);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 */
static inline void
kde_output_configuration_v2_set_primary_output(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_SET_PRIMARY_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, output);
}

/**
 * @ingroup iface_kde_output_configuration_v2
 *
 * Sets the just a test.
 */
static inline void
kde_output_configuration_v2_brightness(struct kde_output_configuration_v2 *kde_output_configuration_v2, struct kde_output_device_v2 *outputdevice, int32_t brightness)
{
	wl_proxy_marshal_flags((struct wl_proxy *) kde_output_configuration_v2,
			 KDE_OUTPUT_CONFIGURATION_V2_BRIGHTNESS, NULL, wl_proxy_get_version((struct wl_proxy *) kde_output_configuration_v2), 0, outputdevice, brightness);
}

#ifdef  __cplusplus
}
#endif

#endif
