/* Generated by wayland-scanner 1.22.0 */

#ifndef DDE_SEAT_CLIENT_PROTOCOL_H
#define DDE_SEAT_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_dde_seat The dde_seat protocol
 * protocol to get global input events
 *
 * @section page_desc_dde_seat Description
 *
 *
 * @section page_ifaces_dde_seat Interfaces
 * - @subpage page_iface_dde_seat - get pointer objects
 * - @subpage page_iface_dde_pointer - relative pointer object
 * - @subpage page_iface_dde_keyboard - keyboard input device
 * - @subpage page_iface_dde_touch - touch input device
 * @section page_copyright_dde_seat Copyright
 * <pre>
 *
 * Copyright © 2020  wugang <wugang@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct dde_keyboard;
struct dde_pointer;
struct dde_seat;
struct dde_touch;
struct wl_surface;

#ifndef DDE_SEAT_INTERFACE
#define DDE_SEAT_INTERFACE
/**
 * @page page_iface_dde_seat dde_seat
 * @section page_iface_dde_seat_desc Description
 *
 * A global interface used for getting the global seat object for a
 * given input device.
 * @section page_iface_dde_seat_api API
 * See @ref iface_dde_seat.
 */
/**
 * @defgroup iface_dde_seat The dde_seat interface
 *
 * A global interface used for getting the global seat object for a
 * given input device.
 */
extern const struct wl_interface dde_seat_interface;
#endif
#ifndef DDE_POINTER_INTERFACE
#define DDE_POINTER_INTERFACE
/**
 * @page page_iface_dde_pointer dde_pointer
 * @section page_iface_dde_pointer_desc Description
 *
 * A dde_pointer object is an extension to the wl_pointer interface
 * used for emitting global pointer events.
 * @section page_iface_dde_pointer_api API
 * See @ref iface_dde_pointer.
 */
/**
 * @defgroup iface_dde_pointer The dde_pointer interface
 *
 * A dde_pointer object is an extension to the wl_pointer interface
 * used for emitting global pointer events.
 */
extern const struct wl_interface dde_pointer_interface;
#endif
#ifndef DDE_KEYBOARD_INTERFACE
#define DDE_KEYBOARD_INTERFACE
/**
 * @page page_iface_dde_keyboard dde_keyboard
 * @section page_iface_dde_keyboard_desc Description
 *
 * The wl_keyboard interface represents one or more keyboards
 * associated with a seat.
 * @section page_iface_dde_keyboard_api API
 * See @ref iface_dde_keyboard.
 */
/**
 * @defgroup iface_dde_keyboard The dde_keyboard interface
 *
 * The wl_keyboard interface represents one or more keyboards
 * associated with a seat.
 */
extern const struct wl_interface dde_keyboard_interface;
#endif
#ifndef DDE_TOUCH_INTERFACE
#define DDE_TOUCH_INTERFACE
/**
 * @page page_iface_dde_touch dde_touch
 * @section page_iface_dde_touch_desc Description
 *
 * The wl_touch interface represents one or more touchs
 * associated with a seat.
 * @section page_iface_dde_touch_api API
 * See @ref iface_dde_touch.
 */
/**
 * @defgroup iface_dde_touch The dde_touch interface
 *
 * The wl_touch interface represents one or more touchs
 * associated with a seat.
 */
extern const struct wl_interface dde_touch_interface;
#endif

#define DDE_SEAT_GET_DDE_POINTER 0
#define DDE_SEAT_GET_DDE_KEYBOARD 1
#define DDE_SEAT_GET_DDE_TOUCH 2


/**
 * @ingroup iface_dde_seat
 */
#define DDE_SEAT_GET_DDE_POINTER_SINCE_VERSION 1
/**
 * @ingroup iface_dde_seat
 */
#define DDE_SEAT_GET_DDE_KEYBOARD_SINCE_VERSION 1
/**
 * @ingroup iface_dde_seat
 */
#define DDE_SEAT_GET_DDE_TOUCH_SINCE_VERSION 1

/** @ingroup iface_dde_seat */
static inline void
dde_seat_set_user_data(struct dde_seat *dde_seat, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) dde_seat, user_data);
}

/** @ingroup iface_dde_seat */
static inline void *
dde_seat_get_user_data(struct dde_seat *dde_seat)
{
	return wl_proxy_get_user_data((struct wl_proxy *) dde_seat);
}

static inline uint32_t
dde_seat_get_version(struct dde_seat *dde_seat)
{
	return wl_proxy_get_version((struct wl_proxy *) dde_seat);
}

/** @ingroup iface_dde_seat */
static inline void
dde_seat_destroy(struct dde_seat *dde_seat)
{
	wl_proxy_destroy((struct wl_proxy *) dde_seat);
}

/**
 * @ingroup iface_dde_seat
 *
 * get a pointer through a global seat object
 */
static inline struct dde_pointer *
dde_seat_get_dde_pointer(struct dde_seat *dde_seat)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) dde_seat,
			 DDE_SEAT_GET_DDE_POINTER, &dde_pointer_interface, wl_proxy_get_version((struct wl_proxy *) dde_seat), 0, NULL);

	return (struct dde_pointer *) id;
}

/**
 * @ingroup iface_dde_seat
 *
 * The ID provided will be initialized to the dde_keyboard interface
 * for this seat.
 *
 * This request only takes effect if the seat has the keyboard
 * capability, or has had the keyboard capability in the past.
 * It is a protocol violation to issue this request on a seat that has
 * never had the keyboard capability. The missing_capability error will
 * be sent in this case.
 */
static inline struct dde_keyboard *
dde_seat_get_dde_keyboard(struct dde_seat *dde_seat)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) dde_seat,
			 DDE_SEAT_GET_DDE_KEYBOARD, &dde_keyboard_interface, wl_proxy_get_version((struct wl_proxy *) dde_seat), 0, NULL);

	return (struct dde_keyboard *) id;
}

/**
 * @ingroup iface_dde_seat
 *
 * get a touch through a global seat object
 */
static inline struct dde_touch *
dde_seat_get_dde_touch(struct dde_seat *dde_seat)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) dde_seat,
			 DDE_SEAT_GET_DDE_TOUCH, &dde_touch_interface, wl_proxy_get_version((struct wl_proxy *) dde_seat), 0, NULL);

	return (struct dde_touch *) id;
}

#ifndef DDE_POINTER_BUTTON_STATE_ENUM
#define DDE_POINTER_BUTTON_STATE_ENUM
/**
 * @ingroup iface_dde_pointer
 * physical button state
 *
 * Describes the physical state of a button that produced the button
 * event.
 */
enum dde_pointer_button_state {
	/**
	 * the button is not pressed
	 */
	DDE_POINTER_BUTTON_STATE_RELEASED = 0,
	/**
	 * the button is pressed
	 */
	DDE_POINTER_BUTTON_STATE_PRESSED = 1,
};
#endif /* DDE_POINTER_BUTTON_STATE_ENUM */

#ifndef DDE_POINTER_AXIS_ENUM
#define DDE_POINTER_AXIS_ENUM
/**
 * @ingroup iface_dde_pointer
 * axis types
 *
 * Describes the axis types of scroll events.
 */
enum dde_pointer_axis {
	/**
	 * vertical axis
	 */
	DDE_POINTER_AXIS_VERTICAL_SCROLL = 0,
	/**
	 * horizontal axis
	 */
	DDE_POINTER_AXIS_HORIZONTAL_SCROLL = 1,
};
#endif /* DDE_POINTER_AXIS_ENUM */

/**
 * @ingroup iface_dde_pointer
 * @struct dde_pointer_listener
 */
struct dde_pointer_listener {
	/**
	 * pointer motion event
	 *
	 * server send a global cursor position to client
	 * @param x global x coordinate
	 * @param y global y coordinate
	 */
	void (*motion)(void *data,
		       struct dde_pointer *dde_pointer,
		       wl_fixed_t x,
		       wl_fixed_t y);
	/**
	 * pointer button event
	 *
	 * Mouse button click and release notifications.
	 *
	 * The button is a button code as defined in the Linux kernel's
	 * linux/input-event-codes.h header file, e.g. BTN_LEFT.
	 *
	 * Any 16-bit button code value is reserved for future additions to
	 * the kernel's event code list. All other button codes above
	 * 0xFFFF are currently undefined but may be used in future
	 * versions of this protocol.
	 * @param x global x coordinate
	 * @param y global y coordinate
	 * @param button button that produced the event
	 * @param state physical state of the button
	 */
	void (*button)(void *data,
		       struct dde_pointer *dde_pointer,
		       wl_fixed_t x,
		       wl_fixed_t y,
		       uint32_t button,
		       uint32_t state);
	/**
	 * axis event
	 *
	 * Scroll and other axis notifications.
	 *
	 * For scroll events (vertical and horizontal scroll axes), the
	 * value parameter is the length of a vector along the specified
	 * axis in a coordinate space identical to those of motion events,
	 * representing a relative movement along the specified axis.
	 *
	 * For devices that support movements non-parallel to axes multiple
	 * axis events will be emitted.
	 *
	 * When applicable, for example for touch pads, the server can
	 * choose to emit scroll events where the motion vector is
	 * equivalent to a motion event vector.
	 *
	 * When applicable, a client can transform its content relative to
	 * the scroll distance.
	 * @param time timestamp with millisecond granularity
	 * @param axis axis type
	 * @param value length of vector in surface-local coordinate space
	 */
	void (*axis)(void *data,
		     struct dde_pointer *dde_pointer,
		     uint32_t time,
		     uint32_t axis,
		     wl_fixed_t value);
};

/**
 * @ingroup iface_dde_pointer
 */
static inline int
dde_pointer_add_listener(struct dde_pointer *dde_pointer,
			 const struct dde_pointer_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) dde_pointer,
				     (void (**)(void)) listener, data);
}

#define DDE_POINTER_GET_MOTION 0

/**
 * @ingroup iface_dde_pointer
 */
#define DDE_POINTER_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_dde_pointer
 */
#define DDE_POINTER_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_dde_pointer
 */
#define DDE_POINTER_AXIS_SINCE_VERSION 1

/**
 * @ingroup iface_dde_pointer
 */
#define DDE_POINTER_GET_MOTION_SINCE_VERSION 1

/** @ingroup iface_dde_pointer */
static inline void
dde_pointer_set_user_data(struct dde_pointer *dde_pointer, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) dde_pointer, user_data);
}

/** @ingroup iface_dde_pointer */
static inline void *
dde_pointer_get_user_data(struct dde_pointer *dde_pointer)
{
	return wl_proxy_get_user_data((struct wl_proxy *) dde_pointer);
}

static inline uint32_t
dde_pointer_get_version(struct dde_pointer *dde_pointer)
{
	return wl_proxy_get_version((struct wl_proxy *) dde_pointer);
}

/** @ingroup iface_dde_pointer */
static inline void
dde_pointer_destroy(struct dde_pointer *dde_pointer)
{
	wl_proxy_destroy((struct wl_proxy *) dde_pointer);
}

/**
 * @ingroup iface_dde_pointer
 *
 * client request server to send a global cursor position
 */
static inline void
dde_pointer_get_motion(struct dde_pointer *dde_pointer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) dde_pointer,
			 DDE_POINTER_GET_MOTION, NULL, wl_proxy_get_version((struct wl_proxy *) dde_pointer), 0);
}

#ifndef DDE_KEYBOARD_KEYMAP_FORMAT_ENUM
#define DDE_KEYBOARD_KEYMAP_FORMAT_ENUM
/**
 * @ingroup iface_dde_keyboard
 * keyboard mapping format
 *
 * This specifies the format of the keymap provided to the
 * client with the wl_keyboard.keymap event.
 */
enum dde_keyboard_keymap_format {
	/**
	 * no keymap; client must understand how to interpret the raw keycode
	 */
	DDE_KEYBOARD_KEYMAP_FORMAT_NO_KEYMAP = 0,
	/**
	 * libxkbcommon compatible; to determine the xkb keycode, clients must add 8 to the key event keycode
	 */
	DDE_KEYBOARD_KEYMAP_FORMAT_XKB_V1 = 1,
};
#endif /* DDE_KEYBOARD_KEYMAP_FORMAT_ENUM */

#ifndef DDE_KEYBOARD_KEY_STATE_ENUM
#define DDE_KEYBOARD_KEY_STATE_ENUM
/**
 * @ingroup iface_dde_keyboard
 * physical key state
 *
 * Describes the physical state of a key that produced the key event.
 */
enum dde_keyboard_key_state {
	/**
	 * key is not pressed
	 */
	DDE_KEYBOARD_KEY_STATE_RELEASED = 0,
	/**
	 * key is pressed
	 */
	DDE_KEYBOARD_KEY_STATE_PRESSED = 1,
};
#endif /* DDE_KEYBOARD_KEY_STATE_ENUM */

/**
 * @ingroup iface_dde_keyboard
 * @struct dde_keyboard_listener
 */
struct dde_keyboard_listener {
	/**
	 * keyboard mapping
	 *
	 * This event provides a file descriptor to the client which can
	 * be memory-mapped to provide a keyboard mapping description.
	 *
	 * From version 7 onwards, the fd must be mapped with MAP_PRIVATE
	 * by the recipient, as MAP_SHARED may fail.
	 * @param format keymap format
	 * @param fd keymap file descriptor
	 * @param size keymap size, in bytes
	 */
	void (*keymap)(void *data,
		       struct dde_keyboard *dde_keyboard,
		       uint32_t format,
		       int32_t fd,
		       uint32_t size);
	/**
	 * enter event
	 *
	 * Notification that this seat's keyboard focus is on a certain
	 * surface.
	 *
	 * The compositor must send the wl_keyboard.modifiers event after
	 * this event.
	 * @param serial serial number of the enter event
	 * @param surface surface gaining keyboard focus
	 * @param keys the currently pressed keys
	 */
	void (*enter)(void *data,
		      struct dde_keyboard *dde_keyboard,
		      uint32_t serial,
		      struct wl_surface *surface,
		      struct wl_array *keys);
	/**
	 * leave event
	 *
	 * Notification that this seat's keyboard focus is no longer on a
	 * certain surface.
	 *
	 * The leave notification is sent before the enter notification for
	 * the new focus.
	 *
	 * After this event client must assume that all keys, including
	 * modifiers, are lifted and also it must stop key repeating if
	 * there's some going on.
	 * @param serial serial number of the leave event
	 * @param surface surface that lost keyboard focus
	 */
	void (*leave)(void *data,
		      struct dde_keyboard *dde_keyboard,
		      uint32_t serial,
		      struct wl_surface *surface);
	/**
	 * key event
	 *
	 * A key was pressed or released. The time argument is a
	 * timestamp with millisecond granularity, with an undefined base.
	 *
	 * The key is a platform-specific key code that can be interpreted
	 * by feeding it to the keyboard mapping (see the keymap event).
	 *
	 * If this event produces a change in modifiers, then the resulting
	 * wl_keyboard.modifiers event must be sent after this event.
	 * @param serial serial number of the key event
	 * @param time timestamp with millisecond granularity
	 * @param key key that produced the event
	 * @param state physical state of the key
	 */
	void (*key)(void *data,
		    struct dde_keyboard *dde_keyboard,
		    uint32_t serial,
		    uint32_t time,
		    uint32_t key,
		    uint32_t state);
	/**
	 * modifier and group state
	 *
	 * Notifies clients that the modifier and/or group state has
	 * changed, and it should update its local state.
	 * @param serial serial number of the modifiers event
	 * @param mods_depressed depressed modifiers
	 * @param mods_latched latched modifiers
	 * @param mods_locked locked modifiers
	 * @param group keyboard layout
	 */
	void (*modifiers)(void *data,
			  struct dde_keyboard *dde_keyboard,
			  uint32_t serial,
			  uint32_t mods_depressed,
			  uint32_t mods_latched,
			  uint32_t mods_locked,
			  uint32_t group);
	/**
	 * repeat rate and delay
	 *
	 * Informs the client about the keyboard's repeat rate and delay.
	 *
	 * This event is sent as soon as the wl_keyboard object has been
	 * created, and is guaranteed to be received by the client before
	 * any key press event.
	 *
	 * Negative values for either rate or delay are illegal. A rate of
	 * zero will disable any repeating (regardless of the value of
	 * delay).
	 *
	 * This event can be sent later on as well with a new value if
	 * necessary, so clients should continue listening for the event
	 * past the creation of wl_keyboard.
	 * @param rate the rate of repeating keys in characters per second
	 * @param delay delay in milliseconds since key down until repeating starts
	 * @since 4
	 */
	void (*repeat_info)(void *data,
			    struct dde_keyboard *dde_keyboard,
			    int32_t rate,
			    int32_t delay);
};

/**
 * @ingroup iface_dde_keyboard
 */
static inline int
dde_keyboard_add_listener(struct dde_keyboard *dde_keyboard,
			  const struct dde_keyboard_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) dde_keyboard,
				     (void (**)(void)) listener, data);
}

#define DDE_KEYBOARD_RELEASE 0

/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_KEYMAP_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_MODIFIERS_SINCE_VERSION 1
/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_REPEAT_INFO_SINCE_VERSION 4

/**
 * @ingroup iface_dde_keyboard
 */
#define DDE_KEYBOARD_RELEASE_SINCE_VERSION 3

/** @ingroup iface_dde_keyboard */
static inline void
dde_keyboard_set_user_data(struct dde_keyboard *dde_keyboard, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) dde_keyboard, user_data);
}

/** @ingroup iface_dde_keyboard */
static inline void *
dde_keyboard_get_user_data(struct dde_keyboard *dde_keyboard)
{
	return wl_proxy_get_user_data((struct wl_proxy *) dde_keyboard);
}

static inline uint32_t
dde_keyboard_get_version(struct dde_keyboard *dde_keyboard)
{
	return wl_proxy_get_version((struct wl_proxy *) dde_keyboard);
}

/** @ingroup iface_dde_keyboard */
static inline void
dde_keyboard_destroy(struct dde_keyboard *dde_keyboard)
{
	wl_proxy_destroy((struct wl_proxy *) dde_keyboard);
}

/**
 * @ingroup iface_dde_keyboard
 */
static inline void
dde_keyboard_release(struct dde_keyboard *dde_keyboard)
{
	wl_proxy_marshal_flags((struct wl_proxy *) dde_keyboard,
			 DDE_KEYBOARD_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) dde_keyboard), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_dde_touch
 * @struct dde_touch_listener
 */
struct dde_touch_listener {
	/**
	 * down event
	 *
	 * Notification that this seat's touch down. The time argument is
	 * a timestamp with millisecond granularity, with an undefined
	 * base.
	 * @param id id of the touch down event
	 * @param time timestamp with millisecond granularity
	 * @param x global x coordinate
	 * @param y global y coordinate
	 */
	void (*down)(void *data,
		     struct dde_touch *dde_touch,
		     int32_t id,
		     uint32_t time,
		     wl_fixed_t x,
		     wl_fixed_t y);
	/**
	 * up event
	 *
	 * Notification that this seat's touch up. The time argument is a
	 * timestamp with millisecond granularity, with an undefined base.
	 * @param id id of the touch up event
	 * @param time timestamp with millisecond granularity
	 */
	void (*up)(void *data,
		   struct dde_touch *dde_touch,
		   int32_t id,
		   uint32_t time);
	/**
	 * touch motion event
	 *
	 * Notification that this seat's touch motion. The time argument
	 * is a timestamp with millisecond granularity, with an undefined
	 * base.
	 * @param id id of the touch motion event
	 * @param time timestamp with millisecond granularity
	 * @param x global x coordinate
	 * @param y global y coordinate
	 */
	void (*motion)(void *data,
		       struct dde_touch *dde_touch,
		       int32_t id,
		       uint32_t time,
		       wl_fixed_t x,
		       wl_fixed_t y);
};

/**
 * @ingroup iface_dde_touch
 */
static inline int
dde_touch_add_listener(struct dde_touch *dde_touch,
		       const struct dde_touch_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) dde_touch,
				     (void (**)(void)) listener, data);
}

#define DDE_TOUCH_RELEASE 0

/**
 * @ingroup iface_dde_touch
 */
#define DDE_TOUCH_DOWN_SINCE_VERSION 1
/**
 * @ingroup iface_dde_touch
 */
#define DDE_TOUCH_UP_SINCE_VERSION 1
/**
 * @ingroup iface_dde_touch
 */
#define DDE_TOUCH_MOTION_SINCE_VERSION 1

/**
 * @ingroup iface_dde_touch
 */
#define DDE_TOUCH_RELEASE_SINCE_VERSION 3

/** @ingroup iface_dde_touch */
static inline void
dde_touch_set_user_data(struct dde_touch *dde_touch, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) dde_touch, user_data);
}

/** @ingroup iface_dde_touch */
static inline void *
dde_touch_get_user_data(struct dde_touch *dde_touch)
{
	return wl_proxy_get_user_data((struct wl_proxy *) dde_touch);
}

static inline uint32_t
dde_touch_get_version(struct dde_touch *dde_touch)
{
	return wl_proxy_get_version((struct wl_proxy *) dde_touch);
}

/** @ingroup iface_dde_touch */
static inline void
dde_touch_destroy(struct dde_touch *dde_touch)
{
	wl_proxy_destroy((struct wl_proxy *) dde_touch);
}

/**
 * @ingroup iface_dde_touch
 */
static inline void
dde_touch_release(struct dde_touch *dde_touch)
{
	wl_proxy_marshal_flags((struct wl_proxy *) dde_touch,
			 DDE_TOUCH_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) dde_touch), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
