/* Generated by wayland-scanner 1.22.0 */

#ifndef COM_DEEPIN_CLIENT_MANAGEMENT_CLIENT_PROTOCOL_H
#define COM_DEEPIN_CLIENT_MANAGEMENT_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_com_deepin_client_management The com_deepin_client_management protocol
 * @section page_ifaces_com_deepin_client_management Interfaces
 * - @subpage page_iface_com_deepin_client_management - managemant client
 * @section page_copyright_com_deepin_client_management Copyright
 * <pre>
 *
 * Copyright © 2020  wugang <wugang@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct com_deepin_client_management;
struct wl_buffer;

#ifndef COM_DEEPIN_CLIENT_MANAGEMENT_INTERFACE
#define COM_DEEPIN_CLIENT_MANAGEMENT_INTERFACE
/**
 * @page page_iface_com_deepin_client_management com_deepin_client_management
 * @section page_iface_com_deepin_client_management_desc Description
 *
 * This interface enables clients to get properties of all windows shown on screen via the server.
 * The server registers one clientmanagement object as a global object.
 * @section page_iface_com_deepin_client_management_api API
 * See @ref iface_com_deepin_client_management.
 */
/**
 * @defgroup iface_com_deepin_client_management The com_deepin_client_management interface
 *
 * This interface enables clients to get properties of all windows shown on screen via the server.
 * The server registers one clientmanagement object as a global object.
 */
extern const struct wl_interface com_deepin_client_management_interface;
#endif

/**
 * @ingroup iface_com_deepin_client_management
 * @struct com_deepin_client_management_listener
 */
struct com_deepin_client_management_listener {
	/**
	 * get special window information for all clients
	 *
	 * windows information such as pid/window_id/property
	 * @param states windows information
	 */
	void (*window_states)(void *data,
			      struct com_deepin_client_management *com_deepin_client_management,
			      uint32_t count,
			      struct wl_array *states);
	/**
	 * get special window information for all clients
	 *
	 * windows information such as pid/window_id/property
	 * @param window_id window id
	 * @param succeed 1 to succeed or 0 failed
	 * @param buffer buffer of capture contents
	 */
	void (*capture_callback)(void *data,
				 struct com_deepin_client_management *com_deepin_client_management,
				 int32_t window_id,
				 int32_t succeed,
				 struct wl_buffer *buffer);
	/**
	 * send splitable change event
	 *
	 * send splitable change event
	 * @param uuid internal window uuid
	 * @param splitable splitable
	 */
	void (*split_change)(void *data,
			     struct com_deepin_client_management *com_deepin_client_management,
			     const char *uuid,
			     uint32_t splitable);
};

/**
 * @ingroup iface_com_deepin_client_management
 */
static inline int
com_deepin_client_management_add_listener(struct com_deepin_client_management *com_deepin_client_management,
					  const struct com_deepin_client_management_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) com_deepin_client_management,
				     (void (**)(void)) listener, data);
}

#define COM_DEEPIN_CLIENT_MANAGEMENT_GET_WINDOW_STATES 0
#define COM_DEEPIN_CLIENT_MANAGEMENT_CAPTURE_WINDOW_IMAGE 1
#define COM_DEEPIN_CLIENT_MANAGEMENT_SPLIT_WINDOW 2

/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_WINDOW_STATES_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_CAPTURE_CALLBACK_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_SPLIT_CHANGE_SINCE_VERSION 1

/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_GET_WINDOW_STATES_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_CAPTURE_WINDOW_IMAGE_SINCE_VERSION 1
/**
 * @ingroup iface_com_deepin_client_management
 */
#define COM_DEEPIN_CLIENT_MANAGEMENT_SPLIT_WINDOW_SINCE_VERSION 1

/** @ingroup iface_com_deepin_client_management */
static inline void
com_deepin_client_management_set_user_data(struct com_deepin_client_management *com_deepin_client_management, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) com_deepin_client_management, user_data);
}

/** @ingroup iface_com_deepin_client_management */
static inline void *
com_deepin_client_management_get_user_data(struct com_deepin_client_management *com_deepin_client_management)
{
	return wl_proxy_get_user_data((struct wl_proxy *) com_deepin_client_management);
}

static inline uint32_t
com_deepin_client_management_get_version(struct com_deepin_client_management *com_deepin_client_management)
{
	return wl_proxy_get_version((struct wl_proxy *) com_deepin_client_management);
}

/** @ingroup iface_com_deepin_client_management */
static inline void
com_deepin_client_management_destroy(struct com_deepin_client_management *com_deepin_client_management)
{
	wl_proxy_destroy((struct wl_proxy *) com_deepin_client_management);
}

/**
 * @ingroup iface_com_deepin_client_management
 *
 * request window state of all clients, will notify by "windows_state" event.
 */
static inline void
com_deepin_client_management_get_window_states(struct com_deepin_client_management *com_deepin_client_management)
{
	wl_proxy_marshal_flags((struct wl_proxy *) com_deepin_client_management,
			 COM_DEEPIN_CLIENT_MANAGEMENT_GET_WINDOW_STATES, NULL, wl_proxy_get_version((struct wl_proxy *) com_deepin_client_management), 0);
}

/**
 * @ingroup iface_com_deepin_client_management
 *
 * request window state of all clients, will notify by "windows_state" event.
 */
static inline void
com_deepin_client_management_capture_window_image(struct com_deepin_client_management *com_deepin_client_management, int32_t window_id, struct wl_buffer *buffer)
{
	wl_proxy_marshal_flags((struct wl_proxy *) com_deepin_client_management,
			 COM_DEEPIN_CLIENT_MANAGEMENT_CAPTURE_WINDOW_IMAGE, NULL, wl_proxy_get_version((struct wl_proxy *) com_deepin_client_management), 0, window_id, buffer);
}

/**
 * @ingroup iface_com_deepin_client_management
 *
 * request window split.
 */
static inline void
com_deepin_client_management_split_window(struct com_deepin_client_management *com_deepin_client_management, const char *uuid, int32_t split_type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) com_deepin_client_management,
			 COM_DEEPIN_CLIENT_MANAGEMENT_SPLIT_WINDOW, NULL, wl_proxy_get_version((struct wl_proxy *) com_deepin_client_management), 0, uuid, split_type);
}

#ifdef  __cplusplus
}
#endif

#endif
