/* context.c generated by valac 0.56.17, the Vala compiler
 * generated from context.vala, do not modify */

#include "signal-protocol-vala.h"
#include <glib.h>
#include "signal/signal_protocol.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include "signal_helper.h"
#include "signal/ratchet.h"
#include "signal/session_pre_key.h"
#include "signal/key_helper.h"
#include <gee.h>
#include "signal/curve.h"
#include "signal/signal_protocol_types.h"
#include "signal/protocol.h"
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _signal_context_destroy0(var) ((var == NULL) ? NULL : (var = (signal_context_destroy (var), NULL)))
#define _signal_context_unref0(var) ((var == NULL) ? NULL : (var = (signal_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _signal_type_unref_vapi0(var) ((var == NULL) ? NULL : (var = (signal_type_unref_vapi (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _signal_buffer_free0(var) ((var == NULL) ? NULL : (var = (signal_buffer_free (var), NULL)))
typedef struct _SignalParamSpecContext SignalParamSpecContext;

struct _SignalContextPrivate {
	GRecMutex mutex;
};

struct _SignalParamSpecContext {
	GParamSpec parent_instance;
};

static gint SignalContext_private_offset;
static gpointer signal_context_parent_class = NULL;

static void signal_context_locking_function_lock (void* user_data);
static void signal_context_locking_function_unlock (void* user_data);
static void signal_context_stderr_log (int level,
                                const gchar* message,
                                gsize len,
                                void* user_data);
static const char* _signal_log_level_to_string (int value);
static const char* _signal_error_code_to_string (int value);
static void _signal_context_locking_function_lock_signal_locking_func (void* user_data);
static void _signal_context_locking_function_unlock_signal_locking_func (void* user_data);
static void _signal_context_stderr_log_signal_log_func (int level,
                                                 const gchar* message,
                                                 gsize len,
                                                 void* user_data);
VALA_EXTERN SignalStore* signal_store_new (SignalContext* context);
VALA_EXTERN SignalStore* signal_store_construct (GType object_type,
                                     SignalContext* context);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
static void signal_context_finalize (SignalContext * obj);
static GType signal_context_get_type_once (void);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
signal_context_get_instance_private (SignalContext* self)
{
	return G_STRUCT_MEMBER_P (self, SignalContext_private_offset);
}

static gpointer
_signal_context_ref0 (gpointer self)
{
#line 8 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return self ? signal_context_ref (self) : NULL;
#line 87 "context.c"
}

static void
signal_context_locking_function_lock (void* user_data)
{
	SignalContext* ctx = NULL;
	SignalContext* _tmp0_;
#line 8 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = _signal_context_ref0 (G_TYPE_CHECK_INSTANCE_CAST (user_data, SIGNAL_TYPE_CONTEXT, SignalContext));
#line 8 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	ctx = _tmp0_;
#line 9 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_rec_mutex_lock (&ctx->priv->mutex);
#line 7 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_context_unref0 (ctx);
#line 103 "context.c"
}

static void
signal_context_locking_function_unlock (void* user_data)
{
	SignalContext* ctx = NULL;
	SignalContext* _tmp0_;
#line 13 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = _signal_context_ref0 (G_TYPE_CHECK_INSTANCE_CAST (user_data, SIGNAL_TYPE_CONTEXT, SignalContext));
#line 13 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	ctx = _tmp0_;
#line 14 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_rec_mutex_unlock (&ctx->priv->mutex);
#line 12 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_context_unref0 (ctx);
#line 119 "context.c"
}

static const char*
_signal_log_level_to_string (int value)
{
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	switch (value) {
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		case SG_LOG_ERROR:
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return "SG_LOG_ERROR";
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		case SG_LOG_WARNING:
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return "SG_LOG_WARNING";
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		case SG_LOG_NOTICE:
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return "SG_LOG_NOTICE";
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		case SG_LOG_INFO:
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return "SG_LOG_INFO";
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		case SG_LOG_DEBUG:
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return "SG_LOG_DEBUG";
#line 147 "context.c"
	}
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return NULL;
#line 151 "context.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 164 "context.c"
}

static void
signal_context_stderr_log (int level,
                           const gchar* message,
                           gsize len,
                           void* user_data)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 17 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_if_fail (message != NULL);
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = _signal_log_level_to_string (level);
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp1_ = string_to_string (message);
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = g_strconcat (_tmp0_, ": ", _tmp1_, "\n", NULL);
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp3_ = _tmp2_;
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_printerr ("%s", _tmp3_);
#line 18 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_g_free0 (_tmp3_);
#line 191 "context.c"
}

static const char*
_signal_error_code_to_string (int value)
{
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	switch (value) {
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_SUCCESS:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_SUCCESS";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_NOMEM:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_NOMEM";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_INVAL:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_INVAL";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_UNKNOWN:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_UNKNOWN";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_DUPLICATE_MESSAGE:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_DUPLICATE_MESSAGE";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_INVALID_KEY:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_INVALID_KEY";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_INVALID_KEY_ID:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_INVALID_KEY_ID";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_INVALID_MAC:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_INVALID_MAC";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_INVALID_MESSAGE:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_INVALID_MESSAGE";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_INVALID_VERSION:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_INVALID_VERSION";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_LEGACY_MESSAGE:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_LEGACY_MESSAGE";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_NO_SESSION:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_NO_SESSION";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_STALE_KEY_EXCHANGE:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_STALE_KEY_EXCHANGE";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_UNTRUSTED_IDENTITY:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_UNTRUSTED_IDENTITY";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_VRF_SIG_VERIF_FAILED:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_VRF_SIG_VERIF_FAILED";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_INVALID_PROTO_BUF:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_INVALID_PROTO_BUF";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_FP_VERSION_MISMATCH:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_FP_VERSION_MISMATCH";
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		case SG_ERR_FP_IDENT_MISMATCH:
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return "SG_ERR_FP_IDENT_MISMATCH";
#line 271 "context.c"
	}
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	return NULL;
#line 275 "context.c"
}

static gint
signal_throw_gerror_by_code_ (gint code,
                              const gchar* message,
                              GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
#line 40 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	if (code < 0) {
#line 40 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		_tmp0_ = code > SG_ERR_MINIMUM;
#line 290 "context.c"
	} else {
#line 40 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		_tmp0_ = FALSE;
#line 294 "context.c"
	}
#line 40 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	if (_tmp0_) {
#line 298 "context.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		gint _tmp4_ = -1;
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		_tmp1_ = message;
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		if (_tmp1_ == NULL) {
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
			_tmp1_ = "Signal error";
#line 309 "context.c"
		}
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		_tmp2_ = _signal_error_code_to_string ((int) code);
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		_tmp3_ = g_error_new ((GQuark) -1, code, "%s: %s", _tmp1_, _tmp2_);
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		_inner_error0_ = _tmp3_;
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		g_propagate_error (error, _inner_error0_);
#line 41 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		return _tmp4_;
#line 321 "context.c"
	}
#line 43 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	result = code;
#line 43 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	return result;
#line 327 "context.c"
}

static void
_signal_context_locking_function_lock_signal_locking_func (void* user_data)
{
#line 23 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_context_locking_function_lock (user_data);
#line 335 "context.c"
}

static void
_signal_context_locking_function_unlock_signal_locking_func (void* user_data)
{
#line 23 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_context_locking_function_unlock (user_data);
#line 343 "context.c"
}

static void
_signal_context_stderr_log_signal_log_func (int level,
                                            const gchar* message,
                                            gsize len,
                                            void* user_data)
{
#line 24 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_context_stderr_log (level, message, len, user_data);
#line 354 "context.c"
}

SignalContext*
signal_context_construct (GType object_type,
                          gboolean log,
                          GError** error)
{
	SignalContext* self = NULL;
	signal_context* _tmp0_ = NULL;
	gint _tmp1_;
	signal_context* _tmp2_;
	signal_context* _tmp4_;
	GError* _inner_error0_ = NULL;
#line 21 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	self = (SignalContext*) g_type_create_instance (object_type);
#line 22 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp1_ = signal_context_create (&_tmp0_, self);
#line 22 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_context_destroy0 (self->native_context);
#line 22 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	self->native_context = _tmp0_;
#line 22 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp1_, "Error initializing native context", &_inner_error0_);
#line 22 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 22 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 22 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_context_unref0 (self);
#line 22 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 386 "context.c"
	}
#line 23 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = self->native_context;
#line 23 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (signal_context_set_locking_functions (_tmp2_, _signal_context_locking_function_lock_signal_locking_func, _signal_context_locking_function_unlock_signal_locking_func), "Error initializing native locking functions", &_inner_error0_);
#line 23 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 23 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 23 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_context_unref0 (self);
#line 23 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 400 "context.c"
	}
#line 24 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (log) {
#line 404 "context.c"
		signal_context* _tmp3_;
#line 24 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_tmp3_ = self->native_context;
#line 24 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		signal_context_set_log_function (_tmp3_, _signal_context_stderr_log_signal_log_func);
#line 410 "context.c"
	}
#line 25 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp4_ = self->native_context;
#line 25 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	setup_signal_vala_crypto_provider (_tmp4_);
#line 21 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return self;
#line 418 "context.c"
}

SignalContext*
signal_context_new (gboolean log,
                    GError** error)
{
#line 21 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return signal_context_construct (SIGNAL_TYPE_CONTEXT, log, error);
#line 427 "context.c"
}

SignalStore*
signal_context_create_store (SignalContext* self)
{
	SignalStore* _tmp0_;
	SignalStore* result;
#line 28 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = signal_store_new (self);
#line 29 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = _tmp0_;
#line 29 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 443 "context.c"
}

void
signal_context_randomize (SignalContext* self,
                          guint8* data,
                          gint data_length1,
                          GError** error)
{
	GError* _inner_error0_ = NULL;
#line 32 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_if_fail (self != NULL);
#line 33 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (signal_vala_randomize (data, (gint) data_length1), NULL, &_inner_error0_);
#line 33 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 33 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 33 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return;
#line 463 "context.c"
	}
}

session_signed_pre_key*
signal_context_generate_signed_pre_key (SignalContext* self,
                                        ratchet_identity_key_pair* identity_key_pair,
                                        gint32 id,
                                        guint64 timestamp,
                                        GError** error)
{
	session_signed_pre_key* res = NULL;
	signal_context* _tmp2_;
	session_signed_pre_key* _tmp3_ = NULL;
	gint _tmp4_;
	GError* _inner_error0_ = NULL;
	session_signed_pre_key* result;
#line 36 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 36 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (identity_key_pair != NULL, NULL);
#line 37 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (timestamp == ((guint64) 0)) {
#line 486 "context.c"
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
#line 37 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_tmp0_ = g_date_time_new_now_utc ();
#line 37 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_tmp1_ = _tmp0_;
#line 37 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		timestamp = (guint64) g_date_time_to_unix (_tmp1_);
#line 37 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_g_date_time_unref0 (_tmp1_);
#line 497 "context.c"
	}
#line 39 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = self->native_context;
#line 39 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp4_ = signal_protocol_key_helper_generate_signed_pre_key (&_tmp3_, identity_key_pair, (guint32) id, timestamp, _tmp2_);
#line 39 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_type_unref_vapi0 (res);
#line 39 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	res = _tmp3_;
#line 39 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp4_, NULL, &_inner_error0_);
#line 39 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 39 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 39 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_type_unref_vapi0 (res);
#line 39 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 517 "context.c"
	}
#line 40 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = res;
#line 40 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 523 "context.c"
}

GeeSet*
signal_context_generate_pre_keys (SignalContext* self,
                                  guint start,
                                  guint count,
                                  GError** error)
{
	GeeSet* res = NULL;
	GeeHashSet* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeSet* result;
#line 43 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 44 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = gee_hash_set_new (G_TYPE_POINTER, (GBoxedCopyFunc) signal_type_ref_vapi, (GDestroyNotify) signal_type_unref_vapi, NULL, NULL, NULL, NULL, NULL, NULL);
#line 44 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	res = (GeeSet*) _tmp0_;
#line 542 "context.c"
	{
		guint i = 0U;
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		i = start;
#line 547 "context.c"
		{
			gboolean _tmp1_ = FALSE;
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
			_tmp1_ = TRUE;
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
			while (TRUE) {
#line 554 "context.c"
				ec_key_pair* pair = NULL;
				ec_key_pair* _tmp3_;
				session_pre_key* record = NULL;
				ec_key_pair* _tmp4_;
				session_pre_key* _tmp5_ = NULL;
				gint _tmp6_;
				GeeSet* _tmp7_;
				session_pre_key* _tmp8_;
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				if (!_tmp1_) {
#line 565 "context.c"
					guint _tmp2_;
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					_tmp2_ = i;
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					i = _tmp2_ + 1;
#line 571 "context.c"
				}
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				_tmp1_ = FALSE;
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				if (!(i < (start + count))) {
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					break;
#line 579 "context.c"
				}
#line 46 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				_tmp3_ = signal_context_generate_key_pair (self, &_inner_error0_);
#line 46 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				pair = _tmp3_;
#line 46 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 46 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					g_propagate_error (error, _inner_error0_);
#line 46 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					_g_object_unref0 (res);
#line 46 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					return NULL;
#line 593 "context.c"
				}
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				_tmp4_ = pair;
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				_tmp6_ = session_pre_key_create (&_tmp5_, (guint32) i, _tmp4_);
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				_signal_type_unref_vapi0 (record);
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				record = _tmp5_;
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				signal_throw_gerror_by_code_ (_tmp6_, NULL, &_inner_error0_);
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					g_propagate_error (error, _inner_error0_);
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					_signal_type_unref_vapi0 (record);
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					_signal_type_unref_vapi0 (pair);
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					_g_object_unref0 (res);
#line 48 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
					return NULL;
#line 617 "context.c"
				}
#line 49 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				_tmp7_ = res;
#line 49 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				_tmp8_ = record;
#line 49 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				gee_collection_add ((GeeCollection*) _tmp7_, _tmp8_);
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				_signal_type_unref_vapi0 (record);
#line 45 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
				_signal_type_unref_vapi0 (pair);
#line 629 "context.c"
			}
		}
	}
#line 51 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = res;
#line 51 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 637 "context.c"
}

ec_public_key*
signal_context_decode_public_key (SignalContext* self,
                                  guint8* bytes,
                                  gint bytes_length1,
                                  GError** error)
{
	ec_public_key* public_key = NULL;
	signal_context* _tmp0_;
	ec_public_key* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	ec_public_key* result;
#line 54 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = self->native_context;
#line 56 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = curve_decode_point (&_tmp1_, bytes, (gint) bytes_length1, _tmp0_);
#line 56 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_type_unref_vapi0 (public_key);
#line 56 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	public_key = _tmp1_;
#line 56 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp2_, "Error decoding public key", &_inner_error0_);
#line 56 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 56 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 56 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_type_unref_vapi0 (public_key);
#line 56 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 672 "context.c"
	}
#line 57 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = public_key;
#line 57 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 678 "context.c"
}

ec_private_key*
signal_context_decode_private_key (SignalContext* self,
                                   guint8* bytes,
                                   gint bytes_length1,
                                   GError** error)
{
	ec_private_key* private_key = NULL;
	signal_context* _tmp0_;
	ec_private_key* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	ec_private_key* result;
#line 60 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = self->native_context;
#line 62 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = curve_decode_private_point (&_tmp1_, bytes, (gint) bytes_length1, _tmp0_);
#line 62 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_type_unref_vapi0 (private_key);
#line 62 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	private_key = _tmp1_;
#line 62 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp2_, "Error decoding private key", &_inner_error0_);
#line 62 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 62 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 62 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_type_unref_vapi0 (private_key);
#line 62 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 713 "context.c"
	}
#line 63 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = private_key;
#line 63 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 719 "context.c"
}

ec_key_pair*
signal_context_generate_key_pair (SignalContext* self,
                                  GError** error)
{
	ec_key_pair* key_pair = NULL;
	signal_context* _tmp0_;
	ec_key_pair* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	ec_key_pair* result;
#line 66 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 68 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = self->native_context;
#line 68 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = curve_generate_key_pair (_tmp0_, &_tmp1_);
#line 68 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_type_unref_vapi0 (key_pair);
#line 68 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	key_pair = _tmp1_;
#line 68 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp2_, "Error generating key pair", &_inner_error0_);
#line 68 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 68 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 68 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_type_unref_vapi0 (key_pair);
#line 68 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 752 "context.c"
	}
#line 69 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = key_pair;
#line 69 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 758 "context.c"
}

static guint8*
signal_buffer_get_data (signal_buffer* self,
                        gint* result_length1)
{
	guint8* result;
	gint x = 0;
	guint8* res = NULL;
	guint8* _tmp0_;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	x = (gint) signal_buffer_len (self);
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	_tmp0_ = signal_buffer_data (self);
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	res = _tmp0_;
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	res_length1 = -1;
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	_res_size_ = res_length1;
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	res_length1 = x;
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	_tmp1_ = res;
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	_tmp1__length1 = res_length1;
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	if (result_length1) {
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
		*result_length1 = _tmp1__length1;
#line 795 "context.c"
	}
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	result = _tmp1_;
#line 73 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/vapi/signal-protocol-public.vapi"
	return result;
#line 801 "context.c"
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (length > 0) {
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return g_memdup2 (self, length * sizeof (guint8));
#line 812 "context.c"
	}
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return NULL;
#line 816 "context.c"
}

guint8*
signal_context_calculate_signature (SignalContext* self,
                                    ec_private_key* signing_key,
                                    guint8* message,
                                    gint message_length1,
                                    gint* result_length1,
                                    GError** error)
{
	signal_buffer* signature = NULL;
	signal_context* _tmp0_;
	signal_buffer* _tmp1_ = NULL;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
#line 72 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (signing_key != NULL, NULL);
#line 74 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = self->native_context;
#line 74 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = curve_calculate_signature (_tmp0_, &_tmp1_, signing_key, message, (gint) message_length1);
#line 74 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_buffer_free0 (signature);
#line 74 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signature = _tmp1_;
#line 74 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp2_, "Error calculating signature", &_inner_error0_);
#line 74 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 74 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 74 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_buffer_free0 (signature);
#line 74 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 864 "context.c"
	}
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp3_ = signal_buffer_get_data (signature, &_tmp4_);
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp3__length1 = _tmp4_;
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp5_ = _tmp3_;
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp5__length1 = _tmp3__length1;
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup1 (_tmp5_, _tmp5__length1) : _tmp5_;
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp6__length1 = _tmp5__length1;
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp7_ = _tmp6_;
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp7__length1 = _tmp6__length1;
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (result_length1) {
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		*result_length1 = _tmp7__length1;
#line 886 "context.c"
	}
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = _tmp7_;
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_buffer_free0 (signature);
#line 75 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 894 "context.c"
}

signal_message*
signal_context_deserialize_signal_message (SignalContext* self,
                                           guint8* data,
                                           gint data_length1,
                                           GError** error)
{
	signal_message* res = NULL;
	signal_context* _tmp0_;
	signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	signal_message* result;
#line 78 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = self->native_context;
#line 80 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = signal_message_deserialize (&_tmp1_, data, (gint) data_length1, _tmp0_);
#line 80 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_type_unref_vapi0 (res);
#line 80 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	res = _tmp1_;
#line 80 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
#line 80 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 80 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 80 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_type_unref_vapi0 (res);
#line 80 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 929 "context.c"
	}
#line 81 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = res;
#line 81 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 935 "context.c"
}

signal_message*
signal_context_copy_signal_message (SignalContext* self,
                                    ciphertext_message* original,
                                    GError** error)
{
	signal_message* res = NULL;
	signal_context* _tmp0_;
	signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	signal_message* result;
#line 84 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (original != NULL, NULL);
#line 86 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = self->native_context;
#line 86 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = signal_message_copy (&_tmp1_, (signal_message*) original, _tmp0_);
#line 86 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_type_unref_vapi0 (res);
#line 86 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	res = _tmp1_;
#line 86 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
#line 86 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 86 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 86 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_type_unref_vapi0 (res);
#line 86 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 971 "context.c"
	}
#line 87 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = res;
#line 87 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 977 "context.c"
}

pre_key_signal_message*
signal_context_deserialize_pre_key_signal_message (SignalContext* self,
                                                   guint8* data,
                                                   gint data_length1,
                                                   GError** error)
{
	pre_key_signal_message* res = NULL;
	signal_context* _tmp0_;
	pre_key_signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	pre_key_signal_message* result;
#line 90 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 92 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = self->native_context;
#line 92 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = pre_key_signal_message_deserialize (&_tmp1_, data, (gint) data_length1, _tmp0_);
#line 92 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_type_unref_vapi0 (res);
#line 92 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	res = _tmp1_;
#line 92 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
#line 92 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 92 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 92 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_type_unref_vapi0 (res);
#line 92 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 1012 "context.c"
	}
#line 93 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = res;
#line 93 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 1018 "context.c"
}

pre_key_signal_message*
signal_context_copy_pre_key_signal_message (SignalContext* self,
                                            ciphertext_message* original,
                                            GError** error)
{
	pre_key_signal_message* res = NULL;
	signal_context* _tmp0_;
	pre_key_signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	pre_key_signal_message* result;
#line 96 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (original != NULL, NULL);
#line 98 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp0_ = self->native_context;
#line 98 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_tmp2_ = pre_key_signal_message_copy (&_tmp1_, (pre_key_signal_message*) original, _tmp0_);
#line 98 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_type_unref_vapi0 (res);
#line 98 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	res = _tmp1_;
#line 98 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
#line 98 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 98 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_propagate_error (error, _inner_error0_);
#line 98 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		_signal_type_unref_vapi0 (res);
#line 98 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return NULL;
#line 1054 "context.c"
	}
#line 99 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	result = res;
#line 99 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return result;
#line 1060 "context.c"
}

static void
signal_value_context_init (GValue* value)
{
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	value->data[0].v_pointer = NULL;
#line 1068 "context.c"
}

static void
signal_value_context_free_value (GValue* value)
{
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (value->data[0].v_pointer) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		signal_context_unref (value->data[0].v_pointer);
#line 1078 "context.c"
	}
}

static void
signal_value_context_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (src_value->data[0].v_pointer) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		dest_value->data[0].v_pointer = signal_context_ref (src_value->data[0].v_pointer);
#line 1090 "context.c"
	} else {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1094 "context.c"
	}
}

static gpointer
signal_value_context_peek_pointer (const GValue* value)
{
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return value->data[0].v_pointer;
#line 1103 "context.c"
}

static gchar*
signal_value_context_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (collect_values[0].v_pointer) {
#line 1114 "context.c"
		SignalContext * object;
		object = collect_values[0].v_pointer;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		if (object->parent_instance.g_class == NULL) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1121 "context.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1125 "context.c"
		}
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		value->data[0].v_pointer = signal_context_ref (object);
#line 1129 "context.c"
	} else {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		value->data[0].v_pointer = NULL;
#line 1133 "context.c"
	}
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return NULL;
#line 1137 "context.c"
}

static gchar*
signal_value_context_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	SignalContext ** object_p;
	object_p = collect_values[0].v_pointer;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (!object_p) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1152 "context.c"
	}
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (!value->data[0].v_pointer) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		*object_p = NULL;
#line 1158 "context.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		*object_p = value->data[0].v_pointer;
#line 1162 "context.c"
	} else {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		*object_p = signal_context_ref (value->data[0].v_pointer);
#line 1166 "context.c"
	}
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return NULL;
#line 1170 "context.c"
}

GParamSpec*
signal_param_spec_context (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	SignalParamSpecContext* spec;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (g_type_is_a (object_type, SIGNAL_TYPE_CONTEXT), NULL);
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return G_PARAM_SPEC (spec);
#line 1189 "context.c"
}

gpointer
signal_value_get_context (const GValue* value)
{
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SIGNAL_TYPE_CONTEXT), NULL);
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return value->data[0].v_pointer;
#line 1199 "context.c"
}

void
signal_value_set_context (GValue* value,
                          gpointer v_object)
{
	SignalContext * old;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SIGNAL_TYPE_CONTEXT));
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	old = value->data[0].v_pointer;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (v_object) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SIGNAL_TYPE_CONTEXT));
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		value->data[0].v_pointer = v_object;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		signal_context_ref (value->data[0].v_pointer);
#line 1221 "context.c"
	} else {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		value->data[0].v_pointer = NULL;
#line 1225 "context.c"
	}
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (old) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		signal_context_unref (old);
#line 1231 "context.c"
	}
}

void
signal_value_take_context (GValue* value,
                           gpointer v_object)
{
	SignalContext * old;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SIGNAL_TYPE_CONTEXT));
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	old = value->data[0].v_pointer;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (v_object) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SIGNAL_TYPE_CONTEXT));
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		value->data[0].v_pointer = v_object;
#line 1252 "context.c"
	} else {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		value->data[0].v_pointer = NULL;
#line 1256 "context.c"
	}
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (old) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		signal_context_unref (old);
#line 1262 "context.c"
	}
}

static void
signal_context_class_init (SignalContextClass * klass,
                           gpointer klass_data)
{
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	signal_context_parent_class = g_type_class_peek_parent (klass);
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	((SignalContextClass *) klass)->finalize = signal_context_finalize;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_type_class_adjust_private_offset (klass, &SignalContext_private_offset);
#line 1276 "context.c"
}

static void
signal_context_instance_init (SignalContext * self,
                              gpointer klass)
{
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	self->priv = signal_context_get_instance_private (self);
#line 5 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_rec_mutex_init (&self->priv->mutex);
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	self->ref_count = 1;
#line 1289 "context.c"
}

static void
signal_context_finalize (SignalContext * obj)
{
	SignalContext * self;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIGNAL_TYPE_CONTEXT, SignalContext);
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_signal_handlers_destroy (self);
#line 4 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_signal_context_destroy0 (self->native_context);
#line 5 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	_vala_clear_GRecMutex (&self->priv->mutex);
#line 1304 "context.c"
}

 G_GNUC_NO_INLINE static GType
signal_context_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { signal_value_context_init, signal_value_context_free_value, signal_value_context_copy_value, signal_value_context_peek_pointer, "p", signal_value_context_collect_value, "p", signal_value_context_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (SignalContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) signal_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SignalContext), 0, (GInstanceInitFunc) signal_context_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType signal_context_type_id;
	signal_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SignalContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
	SignalContext_private_offset = g_type_add_instance_private (signal_context_type_id, sizeof (SignalContextPrivate));
	return signal_context_type_id;
}

GType
signal_context_get_type (void)
{
	static gsize signal_context_type_id__once = 0;
	if (g_once_init_enter (&signal_context_type_id__once)) {
		GType signal_context_type_id;
		signal_context_type_id = signal_context_get_type_once ();
		g_once_init_leave (&signal_context_type_id__once, signal_context_type_id);
	}
	return signal_context_type_id__once;
}

gpointer
signal_context_ref (gpointer instance)
{
	SignalContext * self;
	self = instance;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	g_atomic_int_inc (&self->ref_count);
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	return instance;
#line 1340 "context.c"
}

void
signal_context_unref (gpointer instance)
{
	SignalContext * self;
	self = instance;
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		SIGNAL_CONTEXT_GET_CLASS (self)->finalize (self);
#line 3 "/build/dino/src/dino-0.4.3/plugins/signal-protocol/src/context.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1354 "context.c"
	}
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

