/* signal-protocol-vala.h generated by valac 0.56.17, the Vala compiler, do not modify */

#ifndef ___BUILD_DINO_SRC_BUILD_EXPORTS_SIGNAL_PROTOCOL_VALA_H__
#define ___BUILD_DINO_SRC_BUILD_EXPORTS_SIGNAL_PROTOCOL_VALA_H__

#include <glib-object.h>
#include "signal/signal_protocol.h"
#include <glib.h>
#include "signal/ratchet.h"
#include "signal_helper.h"
#include "signal/session_pre_key.h"
#include <gee.h>
#include "signal/curve.h"
#include "signal/protocol.h"
#include <stdlib.h>
#include <string.h>
#include "signal/signal_protocol_types.h"
#include "signal/session_builder.h"
#include "signal/session_cipher.h"

G_BEGIN_DECLS

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIGNAL_TYPE_CONTEXT (signal_context_get_type ())
#define SIGNAL_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_CONTEXT, SignalContext))
#define SIGNAL_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_CONTEXT, SignalContextClass))
#define SIGNAL_IS_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_CONTEXT))
#define SIGNAL_IS_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_CONTEXT))
#define SIGNAL_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_CONTEXT, SignalContextClass))

typedef struct _SignalContext SignalContext;
typedef struct _SignalContextClass SignalContextClass;
typedef struct _SignalContextPrivate SignalContextPrivate;

#define SIGNAL_TYPE_STORE (signal_store_get_type ())
#define SIGNAL_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_STORE, SignalStore))
#define SIGNAL_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_STORE, SignalStoreClass))
#define SIGNAL_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_STORE))
#define SIGNAL_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_STORE))
#define SIGNAL_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_STORE, SignalStoreClass))

typedef struct _SignalStore SignalStore;
typedef struct _SignalStoreClass SignalStoreClass;

#define SIGNAL_TYPE_IDENTITY_KEY_STORE (signal_identity_key_store_get_type ())
#define SIGNAL_IDENTITY_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_IDENTITY_KEY_STORE, SignalIdentityKeyStore))
#define SIGNAL_IDENTITY_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_IDENTITY_KEY_STORE, SignalIdentityKeyStoreClass))
#define SIGNAL_IS_IDENTITY_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_IDENTITY_KEY_STORE))
#define SIGNAL_IS_IDENTITY_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_IDENTITY_KEY_STORE))
#define SIGNAL_IDENTITY_KEY_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_IDENTITY_KEY_STORE, SignalIdentityKeyStoreClass))

typedef struct _SignalIdentityKeyStore SignalIdentityKeyStore;
typedef struct _SignalIdentityKeyStoreClass SignalIdentityKeyStoreClass;
typedef struct _SignalIdentityKeyStorePrivate SignalIdentityKeyStorePrivate;

#define SIGNAL_TYPE_SIMPLE_IDENTITY_KEY_STORE (signal_simple_identity_key_store_get_type ())
#define SIGNAL_SIMPLE_IDENTITY_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_SIMPLE_IDENTITY_KEY_STORE, SignalSimpleIdentityKeyStore))
#define SIGNAL_SIMPLE_IDENTITY_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_SIMPLE_IDENTITY_KEY_STORE, SignalSimpleIdentityKeyStoreClass))
#define SIGNAL_IS_SIMPLE_IDENTITY_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_SIMPLE_IDENTITY_KEY_STORE))
#define SIGNAL_IS_SIMPLE_IDENTITY_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_SIMPLE_IDENTITY_KEY_STORE))
#define SIGNAL_SIMPLE_IDENTITY_KEY_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_SIMPLE_IDENTITY_KEY_STORE, SignalSimpleIdentityKeyStoreClass))

typedef struct _SignalSimpleIdentityKeyStore SignalSimpleIdentityKeyStore;
typedef struct _SignalSimpleIdentityKeyStoreClass SignalSimpleIdentityKeyStoreClass;
typedef struct _SignalSimpleIdentityKeyStorePrivate SignalSimpleIdentityKeyStorePrivate;

#define SIGNAL_TYPE_SESSION_STORE (signal_session_store_get_type ())
#define SIGNAL_SESSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_SESSION_STORE, SignalSessionStore))
#define SIGNAL_SESSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_SESSION_STORE, SignalSessionStoreClass))
#define SIGNAL_IS_SESSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_SESSION_STORE))
#define SIGNAL_IS_SESSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_SESSION_STORE))
#define SIGNAL_SESSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_SESSION_STORE, SignalSessionStoreClass))

typedef struct _SignalSessionStore SignalSessionStore;
typedef struct _SignalSessionStoreClass SignalSessionStoreClass;
typedef struct _SignalSessionStorePrivate SignalSessionStorePrivate;

#define SIGNAL_TYPE_SIMPLE_SESSION_STORE (signal_simple_session_store_get_type ())
#define SIGNAL_SIMPLE_SESSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_SIMPLE_SESSION_STORE, SignalSimpleSessionStore))
#define SIGNAL_SIMPLE_SESSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_SIMPLE_SESSION_STORE, SignalSimpleSessionStoreClass))
#define SIGNAL_IS_SIMPLE_SESSION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_SIMPLE_SESSION_STORE))
#define SIGNAL_IS_SIMPLE_SESSION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_SIMPLE_SESSION_STORE))
#define SIGNAL_SIMPLE_SESSION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_SIMPLE_SESSION_STORE, SignalSimpleSessionStoreClass))

typedef struct _SignalSimpleSessionStore SignalSimpleSessionStore;
typedef struct _SignalSimpleSessionStoreClass SignalSimpleSessionStoreClass;
typedef struct _SignalSimpleSessionStorePrivate SignalSimpleSessionStorePrivate;

#define SIGNAL_TYPE_PRE_KEY_STORE (signal_pre_key_store_get_type ())
#define SIGNAL_PRE_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_PRE_KEY_STORE, SignalPreKeyStore))
#define SIGNAL_PRE_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_PRE_KEY_STORE, SignalPreKeyStoreClass))
#define SIGNAL_IS_PRE_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_PRE_KEY_STORE))
#define SIGNAL_IS_PRE_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_PRE_KEY_STORE))
#define SIGNAL_PRE_KEY_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_PRE_KEY_STORE, SignalPreKeyStoreClass))

typedef struct _SignalPreKeyStore SignalPreKeyStore;
typedef struct _SignalPreKeyStoreClass SignalPreKeyStoreClass;
typedef struct _SignalPreKeyStorePrivate SignalPreKeyStorePrivate;

#define SIGNAL_TYPE_SIMPLE_PRE_KEY_STORE (signal_simple_pre_key_store_get_type ())
#define SIGNAL_SIMPLE_PRE_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_SIMPLE_PRE_KEY_STORE, SignalSimplePreKeyStore))
#define SIGNAL_SIMPLE_PRE_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_SIMPLE_PRE_KEY_STORE, SignalSimplePreKeyStoreClass))
#define SIGNAL_IS_SIMPLE_PRE_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_SIMPLE_PRE_KEY_STORE))
#define SIGNAL_IS_SIMPLE_PRE_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_SIMPLE_PRE_KEY_STORE))
#define SIGNAL_SIMPLE_PRE_KEY_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_SIMPLE_PRE_KEY_STORE, SignalSimplePreKeyStoreClass))

typedef struct _SignalSimplePreKeyStore SignalSimplePreKeyStore;
typedef struct _SignalSimplePreKeyStoreClass SignalSimplePreKeyStoreClass;
typedef struct _SignalSimplePreKeyStorePrivate SignalSimplePreKeyStorePrivate;

#define SIGNAL_TYPE_SIGNED_PRE_KEY_STORE (signal_signed_pre_key_store_get_type ())
#define SIGNAL_SIGNED_PRE_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_SIGNED_PRE_KEY_STORE, SignalSignedPreKeyStore))
#define SIGNAL_SIGNED_PRE_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_SIGNED_PRE_KEY_STORE, SignalSignedPreKeyStoreClass))
#define SIGNAL_IS_SIGNED_PRE_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_SIGNED_PRE_KEY_STORE))
#define SIGNAL_IS_SIGNED_PRE_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_SIGNED_PRE_KEY_STORE))
#define SIGNAL_SIGNED_PRE_KEY_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_SIGNED_PRE_KEY_STORE, SignalSignedPreKeyStoreClass))

typedef struct _SignalSignedPreKeyStore SignalSignedPreKeyStore;
typedef struct _SignalSignedPreKeyStoreClass SignalSignedPreKeyStoreClass;
typedef struct _SignalSignedPreKeyStorePrivate SignalSignedPreKeyStorePrivate;

#define SIGNAL_TYPE_SIMPLE_SIGNED_PRE_KEY_STORE (signal_simple_signed_pre_key_store_get_type ())
#define SIGNAL_SIMPLE_SIGNED_PRE_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_TYPE_SIMPLE_SIGNED_PRE_KEY_STORE, SignalSimpleSignedPreKeyStore))
#define SIGNAL_SIMPLE_SIGNED_PRE_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_TYPE_SIMPLE_SIGNED_PRE_KEY_STORE, SignalSimpleSignedPreKeyStoreClass))
#define SIGNAL_IS_SIMPLE_SIGNED_PRE_KEY_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_TYPE_SIMPLE_SIGNED_PRE_KEY_STORE))
#define SIGNAL_IS_SIMPLE_SIGNED_PRE_KEY_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_TYPE_SIMPLE_SIGNED_PRE_KEY_STORE))
#define SIGNAL_SIMPLE_SIGNED_PRE_KEY_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_TYPE_SIMPLE_SIGNED_PRE_KEY_STORE, SignalSimpleSignedPreKeyStoreClass))

typedef struct _SignalSimpleSignedPreKeyStore SignalSimpleSignedPreKeyStore;
typedef struct _SignalSimpleSignedPreKeyStoreClass SignalSimpleSignedPreKeyStoreClass;
typedef struct _SignalSimpleSignedPreKeyStorePrivate SignalSimpleSignedPreKeyStorePrivate;

#define SIGNAL_IDENTITY_KEY_STORE_TYPE_TRUSTED_IDENTITY (signal_identity_key_store_trusted_identity_get_type ())
#define SIGNAL_IDENTITY_KEY_STORE_TRUSTED_IDENTITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_IDENTITY_KEY_STORE_TYPE_TRUSTED_IDENTITY, SignalIdentityKeyStoreTrustedIdentity))
#define SIGNAL_IDENTITY_KEY_STORE_TRUSTED_IDENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_IDENTITY_KEY_STORE_TYPE_TRUSTED_IDENTITY, SignalIdentityKeyStoreTrustedIdentityClass))
#define SIGNAL_IDENTITY_KEY_STORE_IS_TRUSTED_IDENTITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_IDENTITY_KEY_STORE_TYPE_TRUSTED_IDENTITY))
#define SIGNAL_IDENTITY_KEY_STORE_IS_TRUSTED_IDENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_IDENTITY_KEY_STORE_TYPE_TRUSTED_IDENTITY))
#define SIGNAL_IDENTITY_KEY_STORE_TRUSTED_IDENTITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_IDENTITY_KEY_STORE_TYPE_TRUSTED_IDENTITY, SignalIdentityKeyStoreTrustedIdentityClass))

typedef struct _SignalIdentityKeyStoreTrustedIdentity SignalIdentityKeyStoreTrustedIdentity;
typedef struct _SignalIdentityKeyStoreTrustedIdentityClass SignalIdentityKeyStoreTrustedIdentityClass;
typedef struct _SignalIdentityKeyStoreTrustedIdentityPrivate SignalIdentityKeyStoreTrustedIdentityPrivate;

#define SIGNAL_SESSION_STORE_TYPE_SESSION (signal_session_store_session_get_type ())
#define SIGNAL_SESSION_STORE_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_SESSION_STORE_TYPE_SESSION, SignalSessionStoreSession))
#define SIGNAL_SESSION_STORE_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_SESSION_STORE_TYPE_SESSION, SignalSessionStoreSessionClass))
#define SIGNAL_SESSION_STORE_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_SESSION_STORE_TYPE_SESSION))
#define SIGNAL_SESSION_STORE_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_SESSION_STORE_TYPE_SESSION))
#define SIGNAL_SESSION_STORE_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_SESSION_STORE_TYPE_SESSION, SignalSessionStoreSessionClass))

typedef struct _SignalSessionStoreSession SignalSessionStoreSession;
typedef struct _SignalSessionStoreSessionClass SignalSessionStoreSessionClass;
typedef struct _SignalSessionStoreSessionPrivate SignalSessionStoreSessionPrivate;

#define SIGNAL_PRE_KEY_STORE_TYPE_KEY (signal_pre_key_store_key_get_type ())
#define SIGNAL_PRE_KEY_STORE_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_PRE_KEY_STORE_TYPE_KEY, SignalPreKeyStoreKey))
#define SIGNAL_PRE_KEY_STORE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_PRE_KEY_STORE_TYPE_KEY, SignalPreKeyStoreKeyClass))
#define SIGNAL_PRE_KEY_STORE_IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_PRE_KEY_STORE_TYPE_KEY))
#define SIGNAL_PRE_KEY_STORE_IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_PRE_KEY_STORE_TYPE_KEY))
#define SIGNAL_PRE_KEY_STORE_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_PRE_KEY_STORE_TYPE_KEY, SignalPreKeyStoreKeyClass))

typedef struct _SignalPreKeyStoreKey SignalPreKeyStoreKey;
typedef struct _SignalPreKeyStoreKeyClass SignalPreKeyStoreKeyClass;
typedef struct _SignalPreKeyStoreKeyPrivate SignalPreKeyStoreKeyPrivate;

#define SIGNAL_SIGNED_PRE_KEY_STORE_TYPE_KEY (signal_signed_pre_key_store_key_get_type ())
#define SIGNAL_SIGNED_PRE_KEY_STORE_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIGNAL_SIGNED_PRE_KEY_STORE_TYPE_KEY, SignalSignedPreKeyStoreKey))
#define SIGNAL_SIGNED_PRE_KEY_STORE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIGNAL_SIGNED_PRE_KEY_STORE_TYPE_KEY, SignalSignedPreKeyStoreKeyClass))
#define SIGNAL_SIGNED_PRE_KEY_STORE_IS_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIGNAL_SIGNED_PRE_KEY_STORE_TYPE_KEY))
#define SIGNAL_SIGNED_PRE_KEY_STORE_IS_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIGNAL_SIGNED_PRE_KEY_STORE_TYPE_KEY))
#define SIGNAL_SIGNED_PRE_KEY_STORE_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIGNAL_SIGNED_PRE_KEY_STORE_TYPE_KEY, SignalSignedPreKeyStoreKeyClass))

typedef struct _SignalSignedPreKeyStoreKey SignalSignedPreKeyStoreKey;
typedef struct _SignalSignedPreKeyStoreKeyClass SignalSignedPreKeyStoreKeyClass;
typedef struct _SignalSignedPreKeyStoreKeyPrivate SignalSignedPreKeyStoreKeyPrivate;
typedef struct _SignalStorePrivate SignalStorePrivate;

struct _SignalContext {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SignalContextPrivate * priv;
	signal_context* native_context;
};

struct _SignalContextClass {
	GTypeClass parent_class;
	void (*finalize) (SignalContext *self);
};

struct _SignalIdentityKeyStore {
	GObject parent_instance;
	SignalIdentityKeyStorePrivate * priv;
};

struct _SignalIdentityKeyStoreClass {
	GObjectClass parent_class;
	void (*save_identity) (SignalIdentityKeyStore* self, signal_protocol_address* address, guint8* key, gint key_length1, GError** error);
	gboolean (*is_trusted_identity) (SignalIdentityKeyStore* self, signal_protocol_address* address, guint8* key, gint key_length1, GError** error);
	GBytes* (*get_identity_key_private) (SignalIdentityKeyStore* self);
	void (*set_identity_key_private) (SignalIdentityKeyStore* self, GBytes* value);
	GBytes* (*get_identity_key_public) (SignalIdentityKeyStore* self);
	void (*set_identity_key_public) (SignalIdentityKeyStore* self, GBytes* value);
	guint32 (*get_local_registration_id) (SignalIdentityKeyStore* self);
	void (*set_local_registration_id) (SignalIdentityKeyStore* self, guint32 value);
};

struct _SignalSimpleIdentityKeyStore {
	SignalIdentityKeyStore parent_instance;
	SignalSimpleIdentityKeyStorePrivate * priv;
};

struct _SignalSimpleIdentityKeyStoreClass {
	SignalIdentityKeyStoreClass parent_class;
};

struct _SignalSessionStore {
	GObject parent_instance;
	SignalSessionStorePrivate * priv;
};

struct _SignalSessionStoreClass {
	GObjectClass parent_class;
	guint8* (*load_session) (SignalSessionStore* self, signal_protocol_address* address, gint* result_length1, GError** error);
	signal_int_list* (*get_sub_device_sessions) (SignalSessionStore* self, const gchar* name, GError** error);
	void (*store_session) (SignalSessionStore* self, signal_protocol_address* address, guint8* record, gint record_length1, GError** error);
	gboolean (*contains_session) (SignalSessionStore* self, signal_protocol_address* address, GError** error);
	void (*delete_session) (SignalSessionStore* self, signal_protocol_address* address, GError** error);
	void (*delete_all_sessions) (SignalSessionStore* self, const gchar* name, GError** error);
};

struct _SignalSimpleSessionStore {
	SignalSessionStore parent_instance;
	SignalSimpleSessionStorePrivate * priv;
};

struct _SignalSimpleSessionStoreClass {
	SignalSessionStoreClass parent_class;
};

struct _SignalPreKeyStore {
	GObject parent_instance;
	SignalPreKeyStorePrivate * priv;
};

struct _SignalPreKeyStoreClass {
	GObjectClass parent_class;
	guint8* (*load_pre_key) (SignalPreKeyStore* self, guint32 pre_key_id, gint* result_length1, GError** error);
	void (*store_pre_key) (SignalPreKeyStore* self, guint32 pre_key_id, guint8* record, gint record_length1, GError** error);
	gboolean (*contains_pre_key) (SignalPreKeyStore* self, guint32 pre_key_id, GError** error);
	void (*delete_pre_key) (SignalPreKeyStore* self, guint32 pre_key_id, GError** error);
};

struct _SignalSimplePreKeyStore {
	SignalPreKeyStore parent_instance;
	SignalSimplePreKeyStorePrivate * priv;
};

struct _SignalSimplePreKeyStoreClass {
	SignalPreKeyStoreClass parent_class;
};

struct _SignalSignedPreKeyStore {
	GObject parent_instance;
	SignalSignedPreKeyStorePrivate * priv;
};

struct _SignalSignedPreKeyStoreClass {
	GObjectClass parent_class;
	guint8* (*load_signed_pre_key) (SignalSignedPreKeyStore* self, guint32 pre_key_id, gint* result_length1, GError** error);
	void (*store_signed_pre_key) (SignalSignedPreKeyStore* self, guint32 pre_key_id, guint8* record, gint record_length1, GError** error);
	gboolean (*contains_signed_pre_key) (SignalSignedPreKeyStore* self, guint32 pre_key_id, GError** error);
	void (*delete_signed_pre_key) (SignalSignedPreKeyStore* self, guint32 pre_key_id, GError** error);
};

struct _SignalSimpleSignedPreKeyStore {
	SignalSignedPreKeyStore parent_instance;
	SignalSimpleSignedPreKeyStorePrivate * priv;
};

struct _SignalSimpleSignedPreKeyStoreClass {
	SignalSignedPreKeyStoreClass parent_class;
};

struct _SignalIdentityKeyStoreTrustedIdentity {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SignalIdentityKeyStoreTrustedIdentityPrivate * priv;
};

struct _SignalIdentityKeyStoreTrustedIdentityClass {
	GTypeClass parent_class;
	void (*finalize) (SignalIdentityKeyStoreTrustedIdentity *self);
};

struct _SignalSessionStoreSession {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SignalSessionStoreSessionPrivate * priv;
	gchar* name;
	gint device_id;
	guint8* record;
	gint record_length1;
};

struct _SignalSessionStoreSessionClass {
	GTypeClass parent_class;
	void (*finalize) (SignalSessionStoreSession *self);
};

struct _SignalPreKeyStoreKey {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SignalPreKeyStoreKeyPrivate * priv;
};

struct _SignalPreKeyStoreKeyClass {
	GTypeClass parent_class;
	void (*finalize) (SignalPreKeyStoreKey *self);
};

struct _SignalSignedPreKeyStoreKey {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SignalSignedPreKeyStoreKeyPrivate * priv;
};

struct _SignalSignedPreKeyStoreKeyClass {
	GTypeClass parent_class;
	void (*finalize) (SignalSignedPreKeyStoreKey *self);
};

struct _SignalStore {
	GObject parent_instance;
	SignalStorePrivate * priv;
};

struct _SignalStoreClass {
	GObjectClass parent_class;
};

VALA_EXTERN gpointer signal_context_ref (gpointer instance);
VALA_EXTERN void signal_context_unref (gpointer instance);
VALA_EXTERN GParamSpec* signal_param_spec_context (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void signal_value_set_context (GValue* value,
                               gpointer v_object);
VALA_EXTERN void signal_value_take_context (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer signal_value_get_context (const GValue* value);
VALA_EXTERN GType signal_context_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalContext, signal_context_unref)
VALA_EXTERN SignalContext* signal_context_new (gboolean log,
                                   GError** error);
VALA_EXTERN SignalContext* signal_context_construct (GType object_type,
                                         gboolean log,
                                         GError** error);
VALA_EXTERN GType signal_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalStore, g_object_unref)
VALA_EXTERN SignalStore* signal_context_create_store (SignalContext* self);
VALA_EXTERN void signal_context_randomize (SignalContext* self,
                               guint8* data,
                               gint data_length1,
                               GError** error);
VALA_EXTERN session_signed_pre_key* signal_context_generate_signed_pre_key (SignalContext* self,
                                                                ratchet_identity_key_pair* identity_key_pair,
                                                                gint32 id,
                                                                guint64 timestamp,
                                                                GError** error);
VALA_EXTERN GeeSet* signal_context_generate_pre_keys (SignalContext* self,
                                          guint start,
                                          guint count,
                                          GError** error);
VALA_EXTERN ec_public_key* signal_context_decode_public_key (SignalContext* self,
                                                 guint8* bytes,
                                                 gint bytes_length1,
                                                 GError** error);
VALA_EXTERN ec_private_key* signal_context_decode_private_key (SignalContext* self,
                                                   guint8* bytes,
                                                   gint bytes_length1,
                                                   GError** error);
VALA_EXTERN ec_key_pair* signal_context_generate_key_pair (SignalContext* self,
                                               GError** error);
VALA_EXTERN guint8* signal_context_calculate_signature (SignalContext* self,
                                            ec_private_key* signing_key,
                                            guint8* message,
                                            gint message_length1,
                                            gint* result_length1,
                                            GError** error);
VALA_EXTERN signal_message* signal_context_deserialize_signal_message (SignalContext* self,
                                                           guint8* data,
                                                           gint data_length1,
                                                           GError** error);
VALA_EXTERN signal_message* signal_context_copy_signal_message (SignalContext* self,
                                                    ciphertext_message* original,
                                                    GError** error);
VALA_EXTERN pre_key_signal_message* signal_context_deserialize_pre_key_signal_message (SignalContext* self,
                                                                           guint8* data,
                                                                           gint data_length1,
                                                                           GError** error);
VALA_EXTERN pre_key_signal_message* signal_context_copy_pre_key_signal_message (SignalContext* self,
                                                                    ciphertext_message* original,
                                                                    GError** error);
VALA_EXTERN GType signal_identity_key_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalIdentityKeyStore, g_object_unref)
VALA_EXTERN GType signal_simple_identity_key_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalSimpleIdentityKeyStore, g_object_unref)
VALA_EXTERN SignalSimpleIdentityKeyStore* signal_simple_identity_key_store_new (void);
VALA_EXTERN SignalSimpleIdentityKeyStore* signal_simple_identity_key_store_construct (GType object_type);
VALA_EXTERN GType signal_session_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalSessionStore, g_object_unref)
VALA_EXTERN GType signal_simple_session_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalSimpleSessionStore, g_object_unref)
VALA_EXTERN SignalSimpleSessionStore* signal_simple_session_store_new (void);
VALA_EXTERN SignalSimpleSessionStore* signal_simple_session_store_construct (GType object_type);
VALA_EXTERN GType signal_pre_key_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalPreKeyStore, g_object_unref)
VALA_EXTERN GType signal_simple_pre_key_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalSimplePreKeyStore, g_object_unref)
VALA_EXTERN SignalSimplePreKeyStore* signal_simple_pre_key_store_new (void);
VALA_EXTERN SignalSimplePreKeyStore* signal_simple_pre_key_store_construct (GType object_type);
VALA_EXTERN GType signal_signed_pre_key_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalSignedPreKeyStore, g_object_unref)
VALA_EXTERN GType signal_simple_signed_pre_key_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalSimpleSignedPreKeyStore, g_object_unref)
VALA_EXTERN SignalSimpleSignedPreKeyStore* signal_simple_signed_pre_key_store_new (void);
VALA_EXTERN SignalSimpleSignedPreKeyStore* signal_simple_signed_pre_key_store_construct (GType object_type);
VALA_EXTERN void signal_identity_key_store_save_identity (SignalIdentityKeyStore* self,
                                              signal_protocol_address* address,
                                              guint8* key,
                                              gint key_length1,
                                              GError** error);
VALA_EXTERN gboolean signal_identity_key_store_is_trusted_identity (SignalIdentityKeyStore* self,
                                                        signal_protocol_address* address,
                                                        guint8* key,
                                                        gint key_length1,
                                                        GError** error);
VALA_EXTERN SignalIdentityKeyStore* signal_identity_key_store_construct (GType object_type);
VALA_EXTERN GBytes* signal_identity_key_store_get_identity_key_private (SignalIdentityKeyStore* self);
VALA_EXTERN void signal_identity_key_store_set_identity_key_private (SignalIdentityKeyStore* self,
                                                         GBytes* value);
VALA_EXTERN GBytes* signal_identity_key_store_get_identity_key_public (SignalIdentityKeyStore* self);
VALA_EXTERN void signal_identity_key_store_set_identity_key_public (SignalIdentityKeyStore* self,
                                                        GBytes* value);
VALA_EXTERN guint32 signal_identity_key_store_get_local_registration_id (SignalIdentityKeyStore* self);
VALA_EXTERN void signal_identity_key_store_set_local_registration_id (SignalIdentityKeyStore* self,
                                                          guint32 value);
VALA_EXTERN gpointer signal_identity_key_store_trusted_identity_ref (gpointer instance);
VALA_EXTERN void signal_identity_key_store_trusted_identity_unref (gpointer instance);
VALA_EXTERN GParamSpec* signal_identity_key_store_param_spec_trusted_identity (const gchar* name,
                                                                   const gchar* nick,
                                                                   const gchar* blurb,
                                                                   GType object_type,
                                                                   GParamFlags flags);
VALA_EXTERN void signal_identity_key_store_value_set_trusted_identity (GValue* value,
                                                           gpointer v_object);
VALA_EXTERN void signal_identity_key_store_value_take_trusted_identity (GValue* value,
                                                            gpointer v_object);
VALA_EXTERN gpointer signal_identity_key_store_value_get_trusted_identity (const GValue* value);
VALA_EXTERN GType signal_identity_key_store_trusted_identity_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalIdentityKeyStoreTrustedIdentity, signal_identity_key_store_trusted_identity_unref)
VALA_EXTERN SignalIdentityKeyStoreTrustedIdentity* signal_identity_key_store_trusted_identity_new (const gchar* name,
                                                                                       gint device_id,
                                                                                       guint8* key,
                                                                                       gint key_length1);
VALA_EXTERN SignalIdentityKeyStoreTrustedIdentity* signal_identity_key_store_trusted_identity_construct (GType object_type,
                                                                                             const gchar* name,
                                                                                             gint device_id,
                                                                                             guint8* key,
                                                                                             gint key_length1);
VALA_EXTERN SignalIdentityKeyStoreTrustedIdentity* signal_identity_key_store_trusted_identity_new_by_address (signal_protocol_address* address,
                                                                                                  guint8* key,
                                                                                                  gint key_length1);
VALA_EXTERN SignalIdentityKeyStoreTrustedIdentity* signal_identity_key_store_trusted_identity_construct_by_address (GType object_type,
                                                                                                        signal_protocol_address* address,
                                                                                                        guint8* key,
                                                                                                        gint key_length1);
VALA_EXTERN guint8* signal_identity_key_store_trusted_identity_get_key (SignalIdentityKeyStoreTrustedIdentity* self,
                                                            gint* result_length1);
VALA_EXTERN void signal_identity_key_store_trusted_identity_set_key (SignalIdentityKeyStoreTrustedIdentity* self,
                                                         guint8* value,
                                                         gint value_length1);
VALA_EXTERN const gchar* signal_identity_key_store_trusted_identity_get_name (SignalIdentityKeyStoreTrustedIdentity* self);
VALA_EXTERN gint signal_identity_key_store_trusted_identity_get_device_id (SignalIdentityKeyStoreTrustedIdentity* self);
VALA_EXTERN guint8* signal_session_store_load_session (SignalSessionStore* self,
                                           signal_protocol_address* address,
                                           gint* result_length1,
                                           GError** error);
VALA_EXTERN signal_int_list* signal_session_store_get_sub_device_sessions (SignalSessionStore* self,
                                                               const gchar* name,
                                                               GError** error);
VALA_EXTERN void signal_session_store_store_session (SignalSessionStore* self,
                                         signal_protocol_address* address,
                                         guint8* record,
                                         gint record_length1,
                                         GError** error);
VALA_EXTERN gboolean signal_session_store_contains_session (SignalSessionStore* self,
                                                signal_protocol_address* address,
                                                GError** error);
VALA_EXTERN void signal_session_store_delete_session (SignalSessionStore* self,
                                          signal_protocol_address* address,
                                          GError** error);
VALA_EXTERN void signal_session_store_delete_all_sessions (SignalSessionStore* self,
                                               const gchar* name,
                                               GError** error);
VALA_EXTERN SignalSessionStore* signal_session_store_construct (GType object_type);
VALA_EXTERN gpointer signal_session_store_session_ref (gpointer instance);
VALA_EXTERN void signal_session_store_session_unref (gpointer instance);
VALA_EXTERN GParamSpec* signal_session_store_param_spec_session (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void signal_session_store_value_set_session (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void signal_session_store_value_take_session (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer signal_session_store_value_get_session (const GValue* value);
VALA_EXTERN GType signal_session_store_session_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalSessionStoreSession, signal_session_store_session_unref)
VALA_EXTERN SignalSessionStoreSession* signal_session_store_session_new (void);
VALA_EXTERN SignalSessionStoreSession* signal_session_store_session_construct (GType object_type);
VALA_EXTERN guint8* signal_pre_key_store_load_pre_key (SignalPreKeyStore* self,
                                           guint32 pre_key_id,
                                           gint* result_length1,
                                           GError** error);
VALA_EXTERN void signal_pre_key_store_store_pre_key (SignalPreKeyStore* self,
                                         guint32 pre_key_id,
                                         guint8* record,
                                         gint record_length1,
                                         GError** error);
VALA_EXTERN gboolean signal_pre_key_store_contains_pre_key (SignalPreKeyStore* self,
                                                guint32 pre_key_id,
                                                GError** error);
VALA_EXTERN void signal_pre_key_store_delete_pre_key (SignalPreKeyStore* self,
                                          guint32 pre_key_id,
                                          GError** error);
VALA_EXTERN SignalPreKeyStore* signal_pre_key_store_construct (GType object_type);
VALA_EXTERN gpointer signal_pre_key_store_key_ref (gpointer instance);
VALA_EXTERN void signal_pre_key_store_key_unref (gpointer instance);
VALA_EXTERN GParamSpec* signal_pre_key_store_param_spec_key (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void signal_pre_key_store_value_set_key (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void signal_pre_key_store_value_take_key (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer signal_pre_key_store_value_get_key (const GValue* value);
VALA_EXTERN GType signal_pre_key_store_key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalPreKeyStoreKey, signal_pre_key_store_key_unref)
VALA_EXTERN SignalPreKeyStoreKey* signal_pre_key_store_key_new (guint32 key_id,
                                                    guint8* record,
                                                    gint record_length1);
VALA_EXTERN SignalPreKeyStoreKey* signal_pre_key_store_key_construct (GType object_type,
                                                          guint32 key_id,
                                                          guint8* record,
                                                          gint record_length1);
VALA_EXTERN guint32 signal_pre_key_store_key_get_key_id (SignalPreKeyStoreKey* self);
VALA_EXTERN guint8* signal_pre_key_store_key_get_record (SignalPreKeyStoreKey* self,
                                             gint* result_length1);
VALA_EXTERN guint8* signal_signed_pre_key_store_load_signed_pre_key (SignalSignedPreKeyStore* self,
                                                         guint32 pre_key_id,
                                                         gint* result_length1,
                                                         GError** error);
VALA_EXTERN void signal_signed_pre_key_store_store_signed_pre_key (SignalSignedPreKeyStore* self,
                                                       guint32 pre_key_id,
                                                       guint8* record,
                                                       gint record_length1,
                                                       GError** error);
VALA_EXTERN gboolean signal_signed_pre_key_store_contains_signed_pre_key (SignalSignedPreKeyStore* self,
                                                              guint32 pre_key_id,
                                                              GError** error);
VALA_EXTERN void signal_signed_pre_key_store_delete_signed_pre_key (SignalSignedPreKeyStore* self,
                                                        guint32 pre_key_id,
                                                        GError** error);
VALA_EXTERN SignalSignedPreKeyStore* signal_signed_pre_key_store_construct (GType object_type);
VALA_EXTERN gpointer signal_signed_pre_key_store_key_ref (gpointer instance);
VALA_EXTERN void signal_signed_pre_key_store_key_unref (gpointer instance);
VALA_EXTERN GParamSpec* signal_signed_pre_key_store_param_spec_key (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags);
VALA_EXTERN void signal_signed_pre_key_store_value_set_key (GValue* value,
                                                gpointer v_object);
VALA_EXTERN void signal_signed_pre_key_store_value_take_key (GValue* value,
                                                 gpointer v_object);
VALA_EXTERN gpointer signal_signed_pre_key_store_value_get_key (const GValue* value);
VALA_EXTERN GType signal_signed_pre_key_store_key_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SignalSignedPreKeyStoreKey, signal_signed_pre_key_store_key_unref)
VALA_EXTERN SignalSignedPreKeyStoreKey* signal_signed_pre_key_store_key_new (guint32 key_id,
                                                                 guint8* record,
                                                                 gint record_length1);
VALA_EXTERN SignalSignedPreKeyStoreKey* signal_signed_pre_key_store_key_construct (GType object_type,
                                                                       guint32 key_id,
                                                                       guint8* record,
                                                                       gint record_length1);
VALA_EXTERN guint32 signal_signed_pre_key_store_key_get_key_id (SignalSignedPreKeyStoreKey* self);
VALA_EXTERN guint8* signal_signed_pre_key_store_key_get_record (SignalSignedPreKeyStoreKey* self,
                                                    gint* result_length1);
VALA_EXTERN session_builder* signal_store_create_session_builder (SignalStore* self,
                                                      signal_protocol_address* other,
                                                      GError** error);
VALA_EXTERN session_cipher* signal_store_create_session_cipher (SignalStore* self,
                                                    signal_protocol_address* other,
                                                    GError** error);
VALA_EXTERN gboolean signal_store_is_trusted_identity (SignalStore* self,
                                           signal_protocol_address* address,
                                           ec_public_key* key,
                                           GError** error);
VALA_EXTERN void signal_store_save_identity (SignalStore* self,
                                 signal_protocol_address* address,
                                 ec_public_key* key,
                                 GError** error);
VALA_EXTERN gboolean signal_store_contains_session (SignalStore* self,
                                        signal_protocol_address* other,
                                        GError** error);
VALA_EXTERN void signal_store_delete_session (SignalStore* self,
                                  signal_protocol_address* address,
                                  GError** error);
VALA_EXTERN session_record* signal_store_load_session (SignalStore* self,
                                           signal_protocol_address* other,
                                           GError** error);
VALA_EXTERN gboolean signal_store_contains_pre_key (SignalStore* self,
                                        guint32 pre_key_id,
                                        GError** error);
VALA_EXTERN void signal_store_store_pre_key (SignalStore* self,
                                 session_pre_key* record,
                                 GError** error);
VALA_EXTERN session_pre_key* signal_store_load_pre_key (SignalStore* self,
                                            guint32 pre_key_id,
                                            GError** error);
VALA_EXTERN gboolean signal_store_contains_signed_pre_key (SignalStore* self,
                                               guint32 pre_key_id,
                                               GError** error);
VALA_EXTERN void signal_store_store_signed_pre_key (SignalStore* self,
                                        session_signed_pre_key* record,
                                        GError** error);
VALA_EXTERN session_signed_pre_key* signal_store_load_signed_pre_key (SignalStore* self,
                                                          guint32 pre_key_id,
                                                          GError** error);
VALA_EXTERN SignalContext* signal_store_get_context (SignalStore* self);
VALA_EXTERN SignalIdentityKeyStore* signal_store_get_identity_key_store (SignalStore* self);
VALA_EXTERN void signal_store_set_identity_key_store (SignalStore* self,
                                          SignalIdentityKeyStore* value);
VALA_EXTERN SignalSessionStore* signal_store_get_session_store (SignalStore* self);
VALA_EXTERN void signal_store_set_session_store (SignalStore* self,
                                     SignalSessionStore* value);
VALA_EXTERN SignalPreKeyStore* signal_store_get_pre_key_store (SignalStore* self);
VALA_EXTERN void signal_store_set_pre_key_store (SignalStore* self,
                                     SignalPreKeyStore* value);
VALA_EXTERN SignalSignedPreKeyStore* signal_store_get_signed_pre_key_store (SignalStore* self);
VALA_EXTERN void signal_store_set_signed_pre_key_store (SignalStore* self,
                                            SignalSignedPreKeyStore* value);
VALA_EXTERN guint32 signal_store_get_local_registration_id (SignalStore* self);
VALA_EXTERN ratchet_identity_key_pair* signal_store_get_identity_key_pair (SignalStore* self);
VALA_EXTERN ec_public_key* signal_generate_public_key (ec_private_key* private_key,
                                           GError** error);
VALA_EXTERN guint8* signal_calculate_agreement (ec_public_key* public_key,
                                    ec_private_key* private_key,
                                    gint* result_length1,
                                    GError** error);
VALA_EXTERN gboolean signal_verify_signature (ec_public_key* signing_key,
                                  guint8* message,
                                  gint message_length1,
                                  guint8* signature,
                                  gint signature_length1,
                                  GError** error);
VALA_EXTERN session_pre_key_bundle* signal_create_pre_key_bundle (guint32 registration_id,
                                                      gint device_id,
                                                      guint32 pre_key_id,
                                                      ec_public_key* pre_key_public,
                                                      guint32 signed_pre_key_id,
                                                      ec_public_key* signed_pre_key_public,
                                                      guint8* signed_pre_key_signature,
                                                      gint signed_pre_key_signature_length1,
                                                      ec_public_key* identity_key,
                                                      GError** error);

G_END_DECLS

#endif
