/* srtp.c generated by valac 0.56.17, the Vala compiler
 * generated from srtp.vala, do not modify */

#include "crypto-vala.h"
#include <glib.h>
#include "srtp2/srtp.h"
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _srtp_dealloc0(var) ((var == NULL) ? NULL : (var = (srtp_dealloc (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _CryptoSrtpParamSpecSession CryptoSrtpParamSpecSession;

struct _CryptoSrtpSessionPrivate {
	gboolean _has_encrypt;
	gboolean _has_decrypt;
	srtp_ctx_t* encrypt_context;
	srtp_ctx_t* decrypt_context;
};

struct _CryptoSrtpParamSpecSession {
	GParamSpec parent_instance;
};

static gint CryptoSrtpSession_private_offset;
static gpointer crypto_srtp_session_parent_class = NULL;

static void crypto_srtp_session_log (srtp_log_level_t level,
                              const gchar* msg);
static const char* _srtp_log_level_to_string (srtp_log_level_t value);
static const char* _srtp_error_status_to_string (srtp_err_status_t value);
static void crypto_srtp_session_create_policy (CryptoSrtpSession* self,
                                        const gchar* profile,
                                        srtp_policy_t* result);
static void crypto_srtp_session_set_has_encrypt (CryptoSrtpSession* self,
                                          gboolean value);
static void crypto_srtp_session_set_has_decrypt (CryptoSrtpSession* self,
                                          gboolean value);
static void _crypto_srtp_session_log_srtp_log_handler_func_t (srtp_log_level_t level,
                                                       const gchar* msg,
                                                       gpointer self);
static void crypto_srtp_session_finalize (CryptoSrtpSession * obj);
static GType crypto_srtp_session_get_type_once (void);

static inline gpointer
crypto_srtp_session_get_instance_private (CryptoSrtpSession* self)
{
	return G_STRUCT_MEMBER_P (self, CryptoSrtpSession_private_offset);
}

static const char*
_srtp_log_level_to_string (srtp_log_level_t value)
{
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	switch (value) {
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_log_level_error:
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_log_level_error";
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_log_level_warning:
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_log_level_warning";
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_log_level_info:
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_log_level_info";
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_log_level_debug:
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_log_level_debug";
#line 84 "srtp.c"
	}
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return NULL;
#line 88 "srtp.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 101 "srtp.c"
}

static void
crypto_srtp_session_log (srtp_log_level_t level,
                         const gchar* msg)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 20 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (msg != NULL);
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp0_ = _srtp_log_level_to_string (level);
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1_ = string_to_string (msg);
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp2_ = g_strconcat ("SRTP[", _tmp0_, "]: ", _tmp1_, "\n", NULL);
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3_ = _tmp2_;
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_print ("%s", _tmp3_);
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_g_free0 (_tmp3_);
#line 126 "srtp.c"
}

CryptoSrtpSession*
crypto_srtp_session_construct (GType object_type)
{
	CryptoSrtpSession* self = NULL;
	srtp_ctx_t* _tmp0_ = NULL;
	srtp_ctx_t* _tmp1_ = NULL;
#line 24 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self = (CryptoSrtpSession*) g_type_create_instance (object_type);
#line 25 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	srtp_create (&_tmp0_, NULL);
#line 25 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_srtp_dealloc0 (self->priv->encrypt_context);
#line 25 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self->priv->encrypt_context = _tmp0_;
#line 26 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	srtp_create (&_tmp1_, NULL);
#line 26 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_srtp_dealloc0 (self->priv->decrypt_context);
#line 26 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self->priv->decrypt_context = _tmp1_;
#line 24 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return self;
#line 151 "srtp.c"
}

CryptoSrtpSession*
crypto_srtp_session_new (void)
{
#line 24 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return crypto_srtp_session_construct (CRYPTO_SRTP_TYPE_SESSION);
#line 159 "srtp.c"
}

static const char*
_srtp_error_status_to_string (srtp_err_status_t value)
{
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	switch (value) {
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_ok:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_ok";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_bad_param:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_bad_param";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_alloc_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_alloc_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_dealloc_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_dealloc_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_init_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_init_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_terminus:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_terminus";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_auth_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_auth_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_cipher_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_cipher_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_replay_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_replay_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_replay_old:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_replay_old";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_algo_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_algo_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_no_such_op:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_no_such_op";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_no_ctx:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_no_ctx";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_cant_check:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_cant_check";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_key_expired:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_key_expired";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_socket_err:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_socket_err";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_signal_err:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_signal_err";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_nonce_bad:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_nonce_bad";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_read_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_read_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_write_fail:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_write_fail";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_parse_err:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_parse_err";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_encode_err:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_encode_err";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_semaphore_err:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_semaphore_err";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_pfkey_err:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_pfkey_err";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_bad_mki:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_bad_mki";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_pkt_idx_old:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_pkt_idx_old";
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_pkt_idx_adv:
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return "srtp_err_status_pkt_idx_adv";
#line 279 "srtp.c"
	}
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return NULL;
#line 283 "srtp.c"
}

guint8*
crypto_srtp_session_encrypt_rtp (CryptoSrtpSession* self,
                                 guint8* data,
                                 gint data_length1,
                                 gint* result_length1,
                                 GError** error)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint buf_use = 0;
	srtp_err_status_t res = 0;
	srtp_ctx_t* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_err_status_t _tmp4_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
#line 29 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 30 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp0_ = g_new0 (guint8, data_length1 + SRTP_MAX_TRAILER_LEN);
#line 30 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf = _tmp0_;
#line 30 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_length1 = data_length1 + SRTP_MAX_TRAILER_LEN;
#line 30 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_buf_size_ = buf_length1;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1_ = buf;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1__length1 = buf_length1;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (_tmp1_, data, (gsize) data_length1);
#line 32 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_use = data_length1;
#line 33 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp2_ = self->priv->encrypt_context;
#line 33 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3_ = buf;
#line 33 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3__length1 = buf_length1;
#line 33 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp4_ = srtp_protect (_tmp2_, (void*) _tmp3_, &buf_use);
#line 33 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	res = _tmp4_;
#line 34 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (res != srtp_err_status_ok) {
#line 339 "srtp.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp5_ = _srtp_error_status_to_string (res);
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp6_ = g_strconcat ("SRTP encrypt failed: ", _tmp5_, NULL);
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp7_ = _tmp6_;
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp8_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_UNKNOWN, _tmp7_);
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp9_ = _tmp8_;
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_g_free0 (_tmp7_);
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_inner_error0_ = _tmp9_;
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			g_propagate_error (error, _inner_error0_);
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			buf = (g_free (buf), NULL);
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			return NULL;
#line 367 "srtp.c"
		} else {
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			buf = (g_free (buf), NULL);
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			g_clear_error (&_inner_error0_);
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			return NULL;
#line 377 "srtp.c"
		}
	}
#line 37 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_length1 = buf_use;
#line 38 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp10_ = buf;
#line 38 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp10__length1 = buf_length1;
#line 38 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (result_length1) {
#line 38 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		*result_length1 = _tmp10__length1;
#line 390 "srtp.c"
	}
#line 38 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	result = _tmp10_;
#line 38 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return result;
#line 396 "srtp.c"
}

guint8*
crypto_srtp_session_decrypt_rtp (CryptoSrtpSession* self,
                                 guint8* data,
                                 gint data_length1,
                                 gint* result_length1,
                                 GError** error)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint buf_use = 0;
	srtp_err_status_t res = 0;
	srtp_ctx_t* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_err_status_t _tmp4_;
	guint8* ret = NULL;
	guint8* _tmp11_;
	gint ret_length1;
	gint _ret_size_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	guint8* _tmp13_;
	gint _tmp13__length1;
	guint8* _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
#line 41 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 42 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp0_ = g_new0 (guint8, data_length1);
#line 42 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf = _tmp0_;
#line 42 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_length1 = data_length1;
#line 42 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_buf_size_ = buf_length1;
#line 43 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1_ = buf;
#line 43 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1__length1 = buf_length1;
#line 43 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (_tmp1_, data, (gsize) data_length1);
#line 44 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_use = data_length1;
#line 45 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp2_ = self->priv->decrypt_context;
#line 45 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3_ = buf;
#line 45 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3__length1 = buf_length1;
#line 45 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp4_ = srtp_unprotect (_tmp2_, (void*) _tmp3_, &buf_use);
#line 45 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	res = _tmp4_;
#line 46 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	switch (res) {
#line 46 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_auth_fail:
#line 462 "srtp.c"
		{
			GError* _tmp5_;
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp5_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_AUTHENTICATION_FAILED, "SRTP packet failed the message authentication check");
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_inner_error0_ = _tmp5_;
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_propagate_error (error, _inner_error0_);
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				buf = (g_free (buf), NULL);
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				return NULL;
#line 477 "srtp.c"
			} else {
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				buf = (g_free (buf), NULL);
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_clear_error (&_inner_error0_);
#line 48 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				return NULL;
#line 487 "srtp.c"
			}
		}
#line 46 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_ok:
#line 492 "srtp.c"
		{
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			break;
#line 496 "srtp.c"
		}
		default:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GError* _tmp9_;
			GError* _tmp10_;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp6_ = _srtp_error_status_to_string (res);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp7_ = g_strconcat ("SRTP decrypt failed: ", _tmp6_, NULL);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp8_ = _tmp7_;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp9_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_UNKNOWN, _tmp8_);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp10_ = _tmp9_;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_g_free0 (_tmp8_);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_inner_error0_ = _tmp10_;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_propagate_error (error, _inner_error0_);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				buf = (g_free (buf), NULL);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				return NULL;
#line 527 "srtp.c"
			} else {
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				buf = (g_free (buf), NULL);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_clear_error (&_inner_error0_);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				return NULL;
#line 537 "srtp.c"
			}
		}
	}
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp11_ = g_new0 (guint8, buf_use);
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	ret = _tmp11_;
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	ret_length1 = buf_use;
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_ret_size_ = ret_length1;
#line 55 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp12_ = ret;
#line 55 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp12__length1 = ret_length1;
#line 55 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp13_ = buf;
#line 55 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp13__length1 = buf_length1;
#line 55 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (_tmp12_, _tmp13_, (gsize) buf_use);
#line 56 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp14_ = ret;
#line 56 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp14__length1 = ret_length1;
#line 56 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (result_length1) {
#line 56 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		*result_length1 = _tmp14__length1;
#line 567 "srtp.c"
	}
#line 56 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	result = _tmp14_;
#line 56 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf = (g_free (buf), NULL);
#line 56 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return result;
#line 575 "srtp.c"
}

guint8*
crypto_srtp_session_encrypt_rtcp (CryptoSrtpSession* self,
                                  guint8* data,
                                  gint data_length1,
                                  gint* result_length1,
                                  GError** error)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint buf_use = 0;
	srtp_err_status_t res = 0;
	srtp_ctx_t* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_err_status_t _tmp4_;
	guint8* _tmp10_;
	gint _tmp10__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
#line 59 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp0_ = g_new0 (guint8, (data_length1 + SRTP_MAX_TRAILER_LEN) + 4);
#line 60 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf = _tmp0_;
#line 60 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_length1 = (data_length1 + SRTP_MAX_TRAILER_LEN) + 4;
#line 60 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_buf_size_ = buf_length1;
#line 61 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1_ = buf;
#line 61 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1__length1 = buf_length1;
#line 61 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (_tmp1_, data, (gsize) data_length1);
#line 62 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_use = data_length1;
#line 63 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp2_ = self->priv->encrypt_context;
#line 63 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3_ = buf;
#line 63 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3__length1 = buf_length1;
#line 63 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp4_ = srtp_protect_rtcp (_tmp2_, (void*) _tmp3_, &buf_use);
#line 63 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	res = _tmp4_;
#line 64 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (res != srtp_err_status_ok) {
#line 631 "srtp.c"
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		GError* _tmp9_;
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp5_ = _srtp_error_status_to_string (res);
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp6_ = g_strconcat ("SRTCP encrypt failed: ", _tmp5_, NULL);
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp7_ = _tmp6_;
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp8_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_UNKNOWN, _tmp7_);
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_tmp9_ = _tmp8_;
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_g_free0 (_tmp7_);
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		_inner_error0_ = _tmp9_;
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			g_propagate_error (error, _inner_error0_);
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			buf = (g_free (buf), NULL);
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			return NULL;
#line 659 "srtp.c"
		} else {
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			buf = (g_free (buf), NULL);
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			g_clear_error (&_inner_error0_);
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			return NULL;
#line 669 "srtp.c"
		}
	}
#line 67 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_length1 = buf_use;
#line 68 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp10_ = buf;
#line 68 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp10__length1 = buf_length1;
#line 68 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (result_length1) {
#line 68 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		*result_length1 = _tmp10__length1;
#line 682 "srtp.c"
	}
#line 68 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	result = _tmp10_;
#line 68 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return result;
#line 688 "srtp.c"
}

guint8*
crypto_srtp_session_decrypt_rtcp (CryptoSrtpSession* self,
                                  guint8* data,
                                  gint data_length1,
                                  gint* result_length1,
                                  GError** error)
{
	guint8* buf = NULL;
	guint8* _tmp0_;
	gint buf_length1;
	gint _buf_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint buf_use = 0;
	srtp_err_status_t res = 0;
	srtp_ctx_t* _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_err_status_t _tmp4_;
	guint8* ret = NULL;
	guint8* _tmp11_;
	gint ret_length1;
	gint _ret_size_;
	guint8* _tmp12_;
	gint _tmp12__length1;
	guint8* _tmp13_;
	gint _tmp13__length1;
	guint8* _tmp14_;
	gint _tmp14__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
#line 71 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 72 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp0_ = g_new0 (guint8, data_length1);
#line 72 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf = _tmp0_;
#line 72 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_length1 = data_length1;
#line 72 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_buf_size_ = buf_length1;
#line 73 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1_ = buf;
#line 73 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1__length1 = buf_length1;
#line 73 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (_tmp1_, data, (gsize) data_length1);
#line 74 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf_use = data_length1;
#line 75 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp2_ = self->priv->decrypt_context;
#line 75 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3_ = buf;
#line 75 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3__length1 = buf_length1;
#line 75 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp4_ = srtp_unprotect_rtcp (_tmp2_, (void*) _tmp3_, &buf_use);
#line 75 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	res = _tmp4_;
#line 76 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	switch (res) {
#line 76 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_auth_fail:
#line 754 "srtp.c"
		{
			GError* _tmp5_;
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp5_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_AUTHENTICATION_FAILED, "SRTCP packet failed the message authentication check");
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_inner_error0_ = _tmp5_;
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_propagate_error (error, _inner_error0_);
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				buf = (g_free (buf), NULL);
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				return NULL;
#line 769 "srtp.c"
			} else {
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				buf = (g_free (buf), NULL);
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_clear_error (&_inner_error0_);
#line 78 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				return NULL;
#line 779 "srtp.c"
			}
		}
#line 76 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		case srtp_err_status_ok:
#line 784 "srtp.c"
		{
#line 80 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			break;
#line 788 "srtp.c"
		}
		default:
		{
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			GError* _tmp9_;
			GError* _tmp10_;
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp6_ = _srtp_error_status_to_string (res);
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp7_ = g_strconcat ("SRTCP decrypt failed: ", _tmp6_, NULL);
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp8_ = _tmp7_;
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp9_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_UNKNOWN, _tmp8_);
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_tmp10_ = _tmp9_;
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_g_free0 (_tmp8_);
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			_inner_error0_ = _tmp10_;
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_propagate_error (error, _inner_error0_);
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				buf = (g_free (buf), NULL);
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				return NULL;
#line 819 "srtp.c"
			} else {
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				buf = (g_free (buf), NULL);
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				g_clear_error (&_inner_error0_);
#line 82 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				return NULL;
#line 829 "srtp.c"
			}
		}
	}
#line 84 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp11_ = g_new0 (guint8, buf_use);
#line 84 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	ret = _tmp11_;
#line 84 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	ret_length1 = buf_use;
#line 84 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_ret_size_ = ret_length1;
#line 85 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp12_ = ret;
#line 85 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp12__length1 = ret_length1;
#line 85 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp13_ = buf;
#line 85 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp13__length1 = buf_length1;
#line 85 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (_tmp12_, _tmp13_, (gsize) buf_use);
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp14_ = ret;
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp14__length1 = ret_length1;
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (result_length1) {
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		*result_length1 = _tmp14__length1;
#line 859 "srtp.c"
	}
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	result = _tmp14_;
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	buf = (g_free (buf), NULL);
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return result;
#line 867 "srtp.c"
}

static void
crypto_srtp_session_create_policy (CryptoSrtpSession* self,
                                   const gchar* profile,
                                   srtp_policy_t* result)
{
	srtp_policy_t policy = {0};
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	static GQuark _tmp1_label0 = 0;
#line 89 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (self != NULL);
#line 89 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (profile != NULL);
#line 90 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memset (&policy, 0, sizeof (srtp_policy_t));
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp0_ = profile;
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (CRYPTO_SRTP_AES_CM_128_HMAC_SHA1_80)))) {
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		switch (0) {
#line 894 "srtp.c"
			default:
			{
#line 93 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				srtp_crypto_policy_set_aes_cm_128_hmac_sha1_80 (&policy.rtp);
#line 94 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				srtp_crypto_policy_set_aes_cm_128_hmac_sha1_80 (&policy.rtcp);
#line 95 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
				break;
#line 903 "srtp.c"
			}
		}
	}
#line 97 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	*result = policy;
#line 97 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return;
#line 911 "srtp.c"
}

void
crypto_srtp_session_set_encryption_key (CryptoSrtpSession* self,
                                        const gchar* profile,
                                        guint8* key,
                                        gint key_length1,
                                        guint8* salt,
                                        gint salt_length1)
{
	srtp_policy_t policy = {0};
	srtp_policy_t _tmp0_ = {0};
	guint8* _tmp1_;
	srtp_policy_t _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_policy_t _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	srtp_ctx_t* _tmp6_;
#line 100 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (self != NULL);
#line 100 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (profile != NULL);
#line 101 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	crypto_srtp_session_create_policy (self, profile, &_tmp0_);
#line 101 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy = _tmp0_;
#line 102 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy.ssrc.type = ssrc_any_outbound;
#line 103 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1_ = g_new0 (guint8, key_length1 + salt_length1);
#line 103 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy.key = (g_free (policy.key), NULL);
#line 103 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy.key = _tmp1_;
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp2_ = policy;
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3_ = _tmp2_.key;
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3__length1 = -1;
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (_tmp3_, key, (gsize) key_length1);
#line 105 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp4_ = policy;
#line 105 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp5_ = _tmp4_.key;
#line 105 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp5__length1 = -1;
#line 105 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (((guint8*) _tmp5_) + key_length1, salt, (gsize) salt_length1);
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy.next = NULL;
#line 107 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp6_ = self->priv->encrypt_context;
#line 107 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	srtp_add_stream (_tmp6_, &policy);
#line 108 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	crypto_srtp_session_set_has_encrypt (self, TRUE);
#line 100 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	 (&policy);
#line 974 "srtp.c"
}

void
crypto_srtp_session_set_decryption_key (CryptoSrtpSession* self,
                                        const gchar* profile,
                                        guint8* key,
                                        gint key_length1,
                                        guint8* salt,
                                        gint salt_length1)
{
	srtp_policy_t policy = {0};
	srtp_policy_t _tmp0_ = {0};
	guint8* _tmp1_;
	srtp_policy_t _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	srtp_policy_t _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	srtp_ctx_t* _tmp6_;
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (self != NULL);
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (profile != NULL);
#line 112 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	crypto_srtp_session_create_policy (self, profile, &_tmp0_);
#line 112 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy = _tmp0_;
#line 113 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy.ssrc.type = ssrc_any_inbound;
#line 114 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp1_ = g_new0 (guint8, key_length1 + salt_length1);
#line 114 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy.key = (g_free (policy.key), NULL);
#line 114 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy.key = _tmp1_;
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp2_ = policy;
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3_ = _tmp2_.key;
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp3__length1 = -1;
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (_tmp3_, key, (gsize) key_length1);
#line 116 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp4_ = policy;
#line 116 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp5_ = _tmp4_.key;
#line 116 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp5__length1 = -1;
#line 116 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	memcpy (((guint8*) _tmp5_) + key_length1, salt, (gsize) salt_length1);
#line 117 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	policy.next = NULL;
#line 118 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_tmp6_ = self->priv->decrypt_context;
#line 118 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	srtp_add_stream (_tmp6_, &policy);
#line 119 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	crypto_srtp_session_set_has_decrypt (self, TRUE);
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	 (&policy);
#line 1037 "srtp.c"
}

gboolean
crypto_srtp_session_get_has_encrypt (CryptoSrtpSession* self)
{
	gboolean result;
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	result = self->priv->_has_encrypt;
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return result;
#line 1050 "srtp.c"
}

static void
crypto_srtp_session_set_has_encrypt (CryptoSrtpSession* self,
                                     gboolean value)
{
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (self != NULL);
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self->priv->_has_encrypt = value;
#line 1061 "srtp.c"
}

gboolean
crypto_srtp_session_get_has_decrypt (CryptoSrtpSession* self)
{
	gboolean result;
#line 10 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 10 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	result = self->priv->_has_decrypt;
#line 10 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return result;
#line 1074 "srtp.c"
}

static void
crypto_srtp_session_set_has_decrypt (CryptoSrtpSession* self,
                                     gboolean value)
{
#line 10 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (self != NULL);
#line 10 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self->priv->_has_decrypt = value;
#line 1085 "srtp.c"
}

static void
_crypto_srtp_session_log_srtp_log_handler_func_t (srtp_log_level_t level,
                                                  const gchar* msg,
                                                  gpointer self)
{
#line 17 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	crypto_srtp_session_log (level, msg);
#line 1095 "srtp.c"
}

static void
crypto_srtp_value_session_init (GValue* value)
{
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	value->data[0].v_pointer = NULL;
#line 1103 "srtp.c"
}

static void
crypto_srtp_value_session_free_value (GValue* value)
{
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (value->data[0].v_pointer) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		crypto_srtp_session_unref (value->data[0].v_pointer);
#line 1113 "srtp.c"
	}
}

static void
crypto_srtp_value_session_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (src_value->data[0].v_pointer) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		dest_value->data[0].v_pointer = crypto_srtp_session_ref (src_value->data[0].v_pointer);
#line 1125 "srtp.c"
	} else {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1129 "srtp.c"
	}
}

static gpointer
crypto_srtp_value_session_peek_pointer (const GValue* value)
{
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return value->data[0].v_pointer;
#line 1138 "srtp.c"
}

static gchar*
crypto_srtp_value_session_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (collect_values[0].v_pointer) {
#line 1149 "srtp.c"
		CryptoSrtpSession * object;
		object = collect_values[0].v_pointer;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		if (object->parent_instance.g_class == NULL) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1156 "srtp.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1160 "srtp.c"
		}
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		value->data[0].v_pointer = crypto_srtp_session_ref (object);
#line 1164 "srtp.c"
	} else {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		value->data[0].v_pointer = NULL;
#line 1168 "srtp.c"
	}
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return NULL;
#line 1172 "srtp.c"
}

static gchar*
crypto_srtp_value_session_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	CryptoSrtpSession ** object_p;
	object_p = collect_values[0].v_pointer;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (!object_p) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1187 "srtp.c"
	}
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (!value->data[0].v_pointer) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		*object_p = NULL;
#line 1193 "srtp.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		*object_p = value->data[0].v_pointer;
#line 1197 "srtp.c"
	} else {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		*object_p = crypto_srtp_session_ref (value->data[0].v_pointer);
#line 1201 "srtp.c"
	}
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return NULL;
#line 1205 "srtp.c"
}

GParamSpec*
crypto_srtp_param_spec_session (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	CryptoSrtpParamSpecSession* spec;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_val_if_fail (g_type_is_a (object_type, CRYPTO_SRTP_TYPE_SESSION), NULL);
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return G_PARAM_SPEC (spec);
#line 1224 "srtp.c"
}

gpointer
crypto_srtp_value_get_session (const GValue* value)
{
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CRYPTO_SRTP_TYPE_SESSION), NULL);
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return value->data[0].v_pointer;
#line 1234 "srtp.c"
}

void
crypto_srtp_value_set_session (GValue* value,
                               gpointer v_object)
{
	CryptoSrtpSession * old;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CRYPTO_SRTP_TYPE_SESSION));
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	old = value->data[0].v_pointer;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (v_object) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CRYPTO_SRTP_TYPE_SESSION));
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		value->data[0].v_pointer = v_object;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		crypto_srtp_session_ref (value->data[0].v_pointer);
#line 1256 "srtp.c"
	} else {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		value->data[0].v_pointer = NULL;
#line 1260 "srtp.c"
	}
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (old) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		crypto_srtp_session_unref (old);
#line 1266 "srtp.c"
	}
}

void
crypto_srtp_value_take_session (GValue* value,
                                gpointer v_object)
{
	CryptoSrtpSession * old;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CRYPTO_SRTP_TYPE_SESSION));
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	old = value->data[0].v_pointer;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (v_object) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CRYPTO_SRTP_TYPE_SESSION));
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		value->data[0].v_pointer = v_object;
#line 1287 "srtp.c"
	} else {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		value->data[0].v_pointer = NULL;
#line 1291 "srtp.c"
	}
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (old) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		crypto_srtp_session_unref (old);
#line 1297 "srtp.c"
	}
}

static void
crypto_srtp_session_class_init (CryptoSrtpSessionClass * klass,
                                gpointer klass_data)
{
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	crypto_srtp_session_parent_class = g_type_class_peek_parent (klass);
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	((CryptoSrtpSessionClass *) klass)->finalize = crypto_srtp_session_finalize;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_type_class_adjust_private_offset (klass, &CryptoSrtpSession_private_offset);
#line 16 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	srtp_init ();
#line 17 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	srtp_install_log_handler (_crypto_srtp_session_log_srtp_log_handler_func_t, NULL);
#line 1315 "srtp.c"
}

static void
crypto_srtp_session_instance_init (CryptoSrtpSession * self,
                                   gpointer klass)
{
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self->priv = crypto_srtp_session_get_instance_private (self);
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self->priv->_has_encrypt = FALSE;
#line 10 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self->priv->_has_decrypt = FALSE;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self->ref_count = 1;
#line 1330 "srtp.c"
}

static void
crypto_srtp_session_finalize (CryptoSrtpSession * obj)
{
	CryptoSrtpSession * self;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CRYPTO_SRTP_TYPE_SESSION, CryptoSrtpSession);
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_signal_handlers_destroy (self);
#line 12 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_srtp_dealloc0 (self->priv->encrypt_context);
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	_srtp_dealloc0 (self->priv->decrypt_context);
#line 1345 "srtp.c"
}

 G_GNUC_NO_INLINE static GType
crypto_srtp_session_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { crypto_srtp_value_session_init, crypto_srtp_value_session_free_value, crypto_srtp_value_session_copy_value, crypto_srtp_value_session_peek_pointer, "p", crypto_srtp_value_session_collect_value, "p", crypto_srtp_value_session_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CryptoSrtpSessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crypto_srtp_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CryptoSrtpSession), 0, (GInstanceInitFunc) crypto_srtp_session_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType crypto_srtp_session_type_id;
	crypto_srtp_session_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CryptoSrtpSession", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CryptoSrtpSession_private_offset = g_type_add_instance_private (crypto_srtp_session_type_id, sizeof (CryptoSrtpSessionPrivate));
	return crypto_srtp_session_type_id;
}

GType
crypto_srtp_session_get_type (void)
{
	static gsize crypto_srtp_session_type_id__once = 0;
	if (g_once_init_enter (&crypto_srtp_session_type_id__once)) {
		GType crypto_srtp_session_type_id;
		crypto_srtp_session_type_id = crypto_srtp_session_get_type_once ();
		g_once_init_leave (&crypto_srtp_session_type_id__once, crypto_srtp_session_type_id);
	}
	return crypto_srtp_session_type_id__once;
}

gpointer
crypto_srtp_session_ref (gpointer instance)
{
	CryptoSrtpSession * self;
	self = instance;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	g_atomic_int_inc (&self->ref_count);
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	return instance;
#line 1381 "srtp.c"
}

void
crypto_srtp_session_unref (gpointer instance)
{
	CryptoSrtpSession * self;
	self = instance;
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		CRYPTO_SRTP_SESSION_GET_CLASS (self)->finalize (self);
#line 8 "/build/dino/src/dino-0.4.3/crypto-vala/src/srtp.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1395 "srtp.c"
	}
}

