/* cipher.c generated by valac 0.56.17, the Vala compiler
 * generated from cipher.vala, do not modify */

#include "crypto-vala.h"
#include "gcrypt.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _crypto_symmetric_cipher_unref0(var) ((var == NULL) ? NULL : (var = (crypto_symmetric_cipher_unref (var), NULL)))
typedef struct _CryptoParamSpecSymmetricCipher CryptoParamSpecSymmetricCipher;

struct _CryptoSymmetricCipherPrivate {
	gcry_cipher_hd_t cipher;
};

struct _CryptoParamSpecSymmetricCipher {
	GParamSpec parent_instance;
};

static gint CryptoSymmetricCipher_private_offset;
static gpointer crypto_symmetric_cipher_parent_class = NULL;

static gboolean crypto_symmetric_cipher_parse (const gchar* algo_name,
                                        enum gcry_cipher_algos* algo,
                                        enum gcry_cipher_modes* mode,
                                        enum gcry_cipher_flags* flags);
static const gchar* crypto_symmetric_cipher_mode_to_string (enum gcry_cipher_modes mode);
static enum gcry_cipher_modes crypto_symmetric_cipher_mode_from_string (const gchar* name);
static gchar* crypto_symmetric_cipher_flags_to_string (enum gcry_cipher_flags flags);
static enum gcry_cipher_flags crypto_symmetric_cipher_flag_from_string (const gchar* flag_name);
static enum gcry_cipher_flags crypto_symmetric_cipher_flags_from_string (const gchar* flag_names);
static gchar* crypto_symmetric_cipher_to_algo_name (enum gcry_cipher_algos algo,
                                             enum gcry_cipher_modes mode,
                                             enum gcry_cipher_flags flags);
static CryptoSymmetricCipher* crypto_symmetric_cipher_new_gcrypt (enum gcry_cipher_algos algo,
                                                           enum gcry_cipher_modes mode,
                                                           enum gcry_cipher_flags flags,
                                                           GError** error);
static CryptoSymmetricCipher* crypto_symmetric_cipher_construct_gcrypt (GType object_type,
                                                                 enum gcry_cipher_algos algo,
                                                                 enum gcry_cipher_modes mode,
                                                                 enum gcry_cipher_flags flags,
                                                                 GError** error);
VALA_EXTERN void crypto_may_throw_gcrypt_error (gcry_error_t e,
                                    GError** error);
static void crypto_symmetric_cipher_finalize (CryptoSymmetricCipher * obj);
static GType crypto_symmetric_cipher_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
crypto_symmetric_cipher_get_instance_private (CryptoSymmetricCipher* self)
{
	return G_STRUCT_MEMBER_P (self, CryptoSymmetricCipher_private_offset);
}

gboolean
crypto_symmetric_cipher_supports (const gchar* algo_name)
{
	enum gcry_cipher_algos algo = 0;
	enum gcry_cipher_modes mode = 0;
	enum gcry_cipher_flags flags = 0;
	enum gcry_cipher_algos _tmp0_ = 0;
	enum gcry_cipher_modes _tmp1_ = 0;
	enum gcry_cipher_flags _tmp2_ = 0;
	gboolean _tmp3_;
	gboolean result;
#line 5 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_val_if_fail (algo_name != NULL, FALSE);
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp3_ = crypto_symmetric_cipher_parse (algo_name, &_tmp0_, &_tmp1_, &_tmp2_);
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	algo = _tmp0_;
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	mode = _tmp1_;
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	flags = _tmp2_;
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	result = _tmp3_;
#line 9 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return result;
#line 101 "cipher.c"
}

static const gchar*
crypto_symmetric_cipher_mode_to_string (enum gcry_cipher_modes mode)
{
	const gchar* result;
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	switch (mode) {
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_ECB:
#line 112 "cipher.c"
		{
#line 14 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "ECB";
#line 14 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 118 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_CFB:
#line 122 "cipher.c"
		{
#line 15 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "CFB";
#line 15 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 128 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_CBC:
#line 132 "cipher.c"
		{
#line 16 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "CBC";
#line 16 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 138 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_STREAM:
#line 142 "cipher.c"
		{
#line 17 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "STREAM";
#line 17 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 148 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_OFB:
#line 152 "cipher.c"
		{
#line 18 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "OFB";
#line 18 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 158 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_CTR:
#line 162 "cipher.c"
		{
#line 19 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "CTR";
#line 19 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 168 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_AESWRAP:
#line 172 "cipher.c"
		{
#line 20 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "AESWRAP";
#line 20 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 178 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_GCM:
#line 182 "cipher.c"
		{
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "GCM";
#line 21 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 188 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_POLY1305:
#line 192 "cipher.c"
		{
#line 22 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "POLY1305";
#line 22 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 198 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_OCB:
#line 202 "cipher.c"
		{
#line 23 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "OCB";
#line 23 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 208 "cipher.c"
		}
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		case GCRY_CIPHER_MODE_CFB8:
#line 212 "cipher.c"
		{
#line 24 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = "CFB8";
#line 24 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 218 "cipher.c"
		}
		default:
#line 13 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		break;
#line 223 "cipher.c"
	}
#line 27 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	result = "NONE";
#line 27 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return result;
#line 229 "cipher.c"
}

static enum gcry_cipher_modes
crypto_symmetric_cipher_mode_from_string (const gchar* name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label0 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label1 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label2 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label3 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label4 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label5 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label6 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label7 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label8 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label9 = 0;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	static GQuark _tmp1_label10 = 0;
#line 259 "cipher.c"
	enum gcry_cipher_modes result;
#line 30 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_val_if_fail (name != NULL, 0);
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp0_ = name;
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("ECB")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 271 "cipher.c"
			default:
			{
#line 32 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_ECB;
#line 32 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 278 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("CFB")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 284 "cipher.c"
			default:
			{
#line 33 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_CFB;
#line 33 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 291 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("CBC")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 297 "cipher.c"
			default:
			{
#line 34 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_CBC;
#line 34 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 304 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("STREAM")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 310 "cipher.c"
			default:
			{
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_STREAM;
#line 35 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 317 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("OFB")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 323 "cipher.c"
			default:
			{
#line 36 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_OFB;
#line 36 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 330 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("CTR")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 336 "cipher.c"
			default:
			{
#line 37 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_CTR;
#line 37 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 343 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("AESWRAP")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 349 "cipher.c"
			default:
			{
#line 38 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_AESWRAP;
#line 38 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 356 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("GCM")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 362 "cipher.c"
			default:
			{
#line 39 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_GCM;
#line 39 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 369 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("POLY1305")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 375 "cipher.c"
			default:
			{
#line 40 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_POLY1305;
#line 40 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 382 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("OCB")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 388 "cipher.c"
			default:
			{
#line 41 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_OCB;
#line 41 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 395 "cipher.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("CFB8")))) {
#line 31 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		switch (0) {
#line 401 "cipher.c"
			default:
			{
#line 42 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				result = GCRY_CIPHER_MODE_CFB8;
#line 42 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return result;
#line 408 "cipher.c"
			}
		}
	}
#line 45 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	result = GCRY_CIPHER_MODE_NONE;
#line 45 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return result;
#line 416 "cipher.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 429 "cipher.c"
}

static gchar*
crypto_symmetric_cipher_flags_to_string (enum gcry_cipher_flags flags)
{
	gchar* s = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* result;
#line 49 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	s = NULL;
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if ((GCRY_CIPHER_CBC_MAC & flags) != 0) {
#line 444 "cipher.c"
		gchar* _tmp0_ = NULL;
		const gchar* _tmp1_;
		gchar* _tmp6_;
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp1_ = s;
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_tmp1_ == NULL) {
#line 452 "cipher.c"
			gchar* _tmp2_;
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp2_ = g_strdup ("");
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_g_free0 (_tmp0_);
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp0_ = _tmp2_;
#line 460 "cipher.c"
		} else {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp3_ = s;
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp4_ = string_to_string (_tmp3_);
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp5_ = g_strconcat (_tmp4_, "-", NULL);
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_g_free0 (_tmp0_);
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp0_ = _tmp5_;
#line 475 "cipher.c"
		}
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp6_ = g_strconcat (_tmp0_, "MAC", NULL);
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (s);
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		s = _tmp6_;
#line 50 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (_tmp0_);
#line 485 "cipher.c"
	}
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if ((GCRY_CIPHER_CBC_CTS & flags) != 0) {
#line 489 "cipher.c"
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		gchar* _tmp13_;
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp8_ = s;
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_tmp8_ == NULL) {
#line 497 "cipher.c"
			gchar* _tmp9_;
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp9_ = g_strdup ("");
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_g_free0 (_tmp7_);
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp7_ = _tmp9_;
#line 505 "cipher.c"
		} else {
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp10_ = s;
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp11_ = string_to_string (_tmp10_);
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp12_ = g_strconcat (_tmp11_, "-", NULL);
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_g_free0 (_tmp7_);
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp7_ = _tmp12_;
#line 520 "cipher.c"
		}
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp13_ = g_strconcat (_tmp7_, "CTS", NULL);
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (s);
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		s = _tmp13_;
#line 51 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (_tmp7_);
#line 530 "cipher.c"
	}
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if ((GCRY_CIPHER_ENABLE_SYNC & flags) != 0) {
#line 534 "cipher.c"
		gchar* _tmp14_ = NULL;
		const gchar* _tmp15_;
		gchar* _tmp20_;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp15_ = s;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_tmp15_ == NULL) {
#line 542 "cipher.c"
			gchar* _tmp16_;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp16_ = g_strdup ("");
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_g_free0 (_tmp14_);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp14_ = _tmp16_;
#line 550 "cipher.c"
		} else {
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp17_ = s;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp18_ = string_to_string (_tmp17_);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp19_ = g_strconcat (_tmp18_, "-", NULL);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_g_free0 (_tmp14_);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp14_ = _tmp19_;
#line 565 "cipher.c"
		}
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp20_ = g_strconcat (_tmp14_, "SYNC", NULL);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (s);
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		s = _tmp20_;
#line 52 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (_tmp14_);
#line 575 "cipher.c"
	}
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if ((GCRY_CIPHER_SECURE & flags) != 0) {
#line 579 "cipher.c"
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		gchar* _tmp27_;
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp22_ = s;
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_tmp22_ == NULL) {
#line 587 "cipher.c"
			gchar* _tmp23_;
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp23_ = g_strdup ("");
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_g_free0 (_tmp21_);
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp21_ = _tmp23_;
#line 595 "cipher.c"
		} else {
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp24_ = s;
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp25_ = string_to_string (_tmp24_);
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp26_ = g_strconcat (_tmp25_, "-", NULL);
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_g_free0 (_tmp21_);
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp21_ = _tmp26_;
#line 610 "cipher.c"
		}
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp27_ = g_strconcat (_tmp21_, "SECURE", NULL);
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (s);
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		s = _tmp27_;
#line 53 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (_tmp21_);
#line 620 "cipher.c"
	}
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp29_ = s;
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp28_ = _tmp29_;
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (_tmp28_ == NULL) {
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp28_ = "NONE";
#line 630 "cipher.c"
	}
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp30_ = g_strdup (_tmp28_);
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	result = _tmp30_;
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_g_free0 (s);
#line 54 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return result;
#line 640 "cipher.c"
}

static enum gcry_cipher_flags
crypto_symmetric_cipher_flag_from_string (const gchar* flag_name)
{
	enum gcry_cipher_flags result;
#line 57 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_val_if_fail (flag_name != NULL, 0);
#line 58 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (g_strcmp0 (flag_name, "SECURE") == 0) {
#line 58 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		result = GCRY_CIPHER_SECURE;
#line 58 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		return result;
#line 655 "cipher.c"
	}
#line 59 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (g_strcmp0 (flag_name, "SYNC") == 0) {
#line 59 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		result = GCRY_CIPHER_ENABLE_SYNC;
#line 59 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		return result;
#line 663 "cipher.c"
	}
#line 60 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (g_strcmp0 (flag_name, "CTS") == 0) {
#line 60 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		result = GCRY_CIPHER_CBC_CTS;
#line 60 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		return result;
#line 671 "cipher.c"
	}
#line 61 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (g_strcmp0 (flag_name, "MAC") == 0) {
#line 61 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		result = GCRY_CIPHER_CBC_MAC;
#line 61 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		return result;
#line 679 "cipher.c"
	}
#line 62 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	result = 0;
#line 62 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return result;
#line 685 "cipher.c"
}

static enum gcry_cipher_flags
crypto_symmetric_cipher_flags_from_string (const gchar* flag_names)
{
	enum gcry_cipher_flags flags = 0;
	gchar** _tmp0_;
	gchar** _tmp1_;
	enum gcry_cipher_flags result;
#line 65 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_val_if_fail (flag_names != NULL, 0);
#line 66 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	flags = 0;
#line 67 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp1_ = _tmp0_ = g_strsplit (flag_names, "-", 0);
#line 701 "cipher.c"
	{
		gchar** flag_collection = NULL;
		gint flag_collection_length1 = 0;
		gint _flag_collection_size_ = 0;
		gint flag_it = 0;
#line 67 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		flag_collection = _tmp1_;
#line 67 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		flag_collection_length1 = _vala_array_length (_tmp0_);
#line 67 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		for (flag_it = 0; flag_it < flag_collection_length1; flag_it = flag_it + 1) {
#line 713 "cipher.c"
			gchar* _tmp2_;
			gchar* flag = NULL;
#line 67 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp2_ = g_strdup (flag_collection[flag_it]);
#line 67 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			flag = _tmp2_;
#line 720 "cipher.c"
			{
				const gchar* _tmp3_;
#line 68 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				_tmp3_ = flag;
#line 68 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				flags |= crypto_symmetric_cipher_flag_from_string (_tmp3_);
#line 67 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				_g_free0 (flag);
#line 729 "cipher.c"
			}
		}
#line 67 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		flag_collection = (_vala_array_free (flag_collection, flag_collection_length1, (GDestroyNotify) g_free), NULL);
#line 734 "cipher.c"
	}
#line 70 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	result = flags;
#line 70 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return result;
#line 740 "cipher.c"
}

static gboolean
crypto_symmetric_cipher_parse (const gchar* algo_name,
                               enum gcry_cipher_algos* algo,
                               enum gcry_cipher_modes* mode,
                               enum gcry_cipher_flags* flags)
{
	enum gcry_cipher_algos _vala_algo = 0;
	enum gcry_cipher_modes _vala_mode = 0;
	enum gcry_cipher_flags _vala_flags = 0;
	gchar** algo_parts = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint algo_parts_length1;
	gint _algo_parts_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	gboolean result;
#line 73 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_val_if_fail (algo_name != NULL, FALSE);
#line 74 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_vala_algo = GCRY_CIPHER_NONE;
#line 75 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_vala_mode = GCRY_CIPHER_MODE_NONE;
#line 76 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_vala_flags = 0;
#line 77 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp1_ = _tmp0_ = g_strsplit (algo_name, "-", 3);
#line 77 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	algo_parts = _tmp1_;
#line 77 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	algo_parts_length1 = _vala_array_length (_tmp0_);
#line 77 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_algo_parts_size_ = algo_parts_length1;
#line 79 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp2_ = algo_parts;
#line 79 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp2__length1 = algo_parts_length1;
#line 79 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp3_ = _tmp2_[0];
#line 79 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_vala_algo = gcry_cipher_map_name (_tmp3_);
#line 80 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp4_ = algo_parts;
#line 80 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp4__length1 = algo_parts_length1;
#line 80 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (_tmp4__length1 >= 2) {
#line 798 "cipher.c"
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
#line 81 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp5_ = algo_parts;
#line 81 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp5__length1 = algo_parts_length1;
#line 81 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp6_ = _tmp5_[1];
#line 81 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_vala_mode = crypto_symmetric_cipher_mode_from_string (_tmp6_);
#line 810 "cipher.c"
	}
#line 83 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp7_ = algo_parts;
#line 83 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp7__length1 = algo_parts_length1;
#line 83 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (_tmp7__length1 == 3) {
#line 818 "cipher.c"
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
#line 84 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp8_ = algo_parts;
#line 84 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp8__length1 = algo_parts_length1;
#line 84 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp9_ = _tmp8_[2];
#line 84 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_vala_flags = _vala_flags | crypto_symmetric_cipher_flags_from_string (_tmp9_);
#line 830 "cipher.c"
	}
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp10_ = crypto_symmetric_cipher_to_algo_name (_vala_algo, _vala_mode, _vala_flags);
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp11_ = _tmp10_;
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp12_ = g_strcmp0 (_tmp11_, algo_name) == 0;
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_g_free0 (_tmp11_);
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	result = _tmp12_;
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	algo_parts = (_vala_array_free (algo_parts, algo_parts_length1, (GDestroyNotify) g_free), NULL);
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (algo) {
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		*algo = _vala_algo;
#line 848 "cipher.c"
	}
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (mode) {
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		*mode = _vala_mode;
#line 854 "cipher.c"
	}
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (flags) {
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		*flags = _vala_flags;
#line 860 "cipher.c"
	}
#line 86 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return result;
#line 864 "cipher.c"
}

static gchar*
crypto_symmetric_cipher_to_algo_name (enum gcry_cipher_algos algo,
                                      enum gcry_cipher_modes mode,
                                      enum gcry_cipher_flags flags)
{
	gchar* result;
#line 90 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (flags != 0) {
#line 875 "cipher.c"
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp0_ = gcry_cipher_algo_name (algo);
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp1_ = crypto_symmetric_cipher_mode_to_string (mode);
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp2_ = string_to_string (_tmp1_);
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp3_ = crypto_symmetric_cipher_flags_to_string (flags);
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp4_ = _tmp3_;
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp5_ = string_to_string (_tmp4_);
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp6_ = g_strconcat (_tmp0_, "-", _tmp2_, "-", _tmp5_, NULL);
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp7_ = _tmp6_;
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (_tmp4_);
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		result = _tmp7_;
#line 91 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		return result;
#line 906 "cipher.c"
	} else {
#line 92 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (mode != GCRY_CIPHER_MODE_NONE) {
#line 910 "cipher.c"
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
#line 93 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp8_ = gcry_cipher_algo_name (algo);
#line 93 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp9_ = crypto_symmetric_cipher_mode_to_string (mode);
#line 93 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp10_ = string_to_string (_tmp9_);
#line 93 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp11_ = g_strconcat (_tmp8_, "-", _tmp10_, NULL);
#line 93 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = _tmp11_;
#line 93 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 927 "cipher.c"
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
#line 95 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp12_ = gcry_cipher_algo_name (algo);
#line 95 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_tmp13_ = g_strdup (_tmp12_);
#line 95 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			result = _tmp13_;
#line 95 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return result;
#line 939 "cipher.c"
		}
	}
}

CryptoSymmetricCipher*
crypto_symmetric_cipher_construct (GType object_type,
                                   const gchar* algo_name,
                                   GError** error)
{
	CryptoSymmetricCipher* self = NULL;
	enum gcry_cipher_algos algo = 0;
	enum gcry_cipher_modes mode = 0;
	enum gcry_cipher_flags flags = 0;
	enum gcry_cipher_algos _tmp0_ = 0;
	enum gcry_cipher_modes _tmp1_ = 0;
	enum gcry_cipher_flags _tmp2_ = 0;
	gboolean _tmp3_;
	GError* _inner_error0_ = NULL;
#line 99 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_val_if_fail (algo_name != NULL, NULL);
#line 103 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp3_ = crypto_symmetric_cipher_parse (algo_name, &_tmp0_, &_tmp1_, &_tmp2_);
#line 103 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	algo = _tmp0_;
#line 103 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	mode = _tmp1_;
#line 103 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	flags = _tmp2_;
#line 103 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (_tmp3_) {
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		self = (CryptoSymmetricCipher*) crypto_symmetric_cipher_construct_gcrypt (object_type, algo, mode, flags, &_inner_error0_);
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				g_propagate_error (error, _inner_error0_);
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				_crypto_symmetric_cipher_unref0 (self);
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return NULL;
#line 982 "cipher.c"
			} else {
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				g_clear_error (&_inner_error0_);
#line 104 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
				return NULL;
#line 990 "cipher.c"
			}
		}
	} else {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		GError* _tmp8_;
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp4_ = string_to_string (algo_name);
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp5_ = g_strconcat ("The algorithm ", _tmp4_, " is not supported", NULL);
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp6_ = _tmp5_;
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp7_ = g_error_new_literal (CRYPTO_ERROR, CRYPTO_ERROR_ILLEGAL_ARGUMENTS, _tmp6_);
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_tmp8_ = _tmp7_;
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_g_free0 (_tmp6_);
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		_inner_error0_ = _tmp8_;
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_crypto_symmetric_cipher_unref0 (self);
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return NULL;
#line 1021 "cipher.c"
		} else {
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 106 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return NULL;
#line 1029 "cipher.c"
		}
	}
#line 99 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return self;
#line 1034 "cipher.c"
}

CryptoSymmetricCipher*
crypto_symmetric_cipher_new (const gchar* algo_name,
                             GError** error)
{
#line 99 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return crypto_symmetric_cipher_construct (CRYPTO_TYPE_SYMMETRIC_CIPHER, algo_name, error);
#line 1043 "cipher.c"
}

static CryptoSymmetricCipher*
crypto_symmetric_cipher_construct_gcrypt (GType object_type,
                                          enum gcry_cipher_algos algo,
                                          enum gcry_cipher_modes mode,
                                          enum gcry_cipher_flags flags,
                                          GError** error)
{
	CryptoSymmetricCipher* self = NULL;
	gcry_cipher_hd_t _tmp0_ = {0};
	gcry_error_t _tmp1_;
	GError* _inner_error0_ = NULL;
#line 110 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	self = (CryptoSymmetricCipher*) g_type_create_instance (object_type);
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp1_ = gcry_cipher_open (&_tmp0_, algo, mode, flags);
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	self->priv->cipher = _tmp0_;
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (_tmp1_, &_inner_error0_);
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			_crypto_symmetric_cipher_unref0 (self);
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return NULL;
#line 1075 "cipher.c"
		} else {
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 111 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return NULL;
#line 1083 "cipher.c"
		}
	}
#line 110 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return self;
#line 1088 "cipher.c"
}

static CryptoSymmetricCipher*
crypto_symmetric_cipher_new_gcrypt (enum gcry_cipher_algos algo,
                                    enum gcry_cipher_modes mode,
                                    enum gcry_cipher_flags flags,
                                    GError** error)
{
#line 110 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return crypto_symmetric_cipher_construct_gcrypt (CRYPTO_TYPE_SYMMETRIC_CIPHER, algo, mode, flags, error);
#line 1099 "cipher.c"
}

void
crypto_symmetric_cipher_set_key (CryptoSymmetricCipher* self,
                                 guint8* key,
                                 gint key_length1,
                                 GError** error)
{
	GError* _inner_error0_ = NULL;
#line 114 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (self != NULL);
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (gcry_cipher_setkey (self->priv->cipher, key, (gint) key_length1), &_inner_error0_);
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1121 "cipher.c"
		} else {
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 115 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1129 "cipher.c"
		}
	}
}

void
crypto_symmetric_cipher_set_iv (CryptoSymmetricCipher* self,
                                guint8* iv,
                                gint iv_length1,
                                GError** error)
{
	GError* _inner_error0_ = NULL;
#line 118 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (self != NULL);
#line 119 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (gcry_cipher_setiv (self->priv->cipher, iv, (gint) iv_length1), &_inner_error0_);
#line 119 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 119 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 119 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 119 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1153 "cipher.c"
		} else {
#line 119 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 119 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 119 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1161 "cipher.c"
		}
	}
}

void
crypto_symmetric_cipher_set_counter_vector (CryptoSymmetricCipher* self,
                                            guint8* ctr,
                                            gint ctr_length1,
                                            GError** error)
{
	GError* _inner_error0_ = NULL;
#line 122 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (self != NULL);
#line 123 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (gcry_cipher_setctr (self->priv->cipher, ctr, (gint) ctr_length1), &_inner_error0_);
#line 123 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 123 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 123 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 123 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1185 "cipher.c"
		} else {
#line 123 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 123 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 123 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1193 "cipher.c"
		}
	}
}

void
crypto_symmetric_cipher_reset (CryptoSymmetricCipher* self,
                               GError** error)
{
	GError* _inner_error0_ = NULL;
#line 126 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (self != NULL);
#line 127 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (gcry_cipher_reset (self->priv->cipher), &_inner_error0_);
#line 127 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 127 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 127 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 127 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1215 "cipher.c"
		} else {
#line 127 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 127 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 127 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1223 "cipher.c"
		}
	}
}

guint8*
crypto_symmetric_cipher_get_tag (CryptoSymmetricCipher* self,
                                 gsize taglen,
                                 gint* result_length1,
                                 GError** error)
{
	guint8* tag = NULL;
	guint8* _tmp0_;
	gint tag_length1;
	gint _tag_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
#line 130 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp0_ = g_new0 (guint8, taglen);
#line 131 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	tag = _tmp0_;
#line 131 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	tag_length1 = taglen;
#line 131 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tag_size_ = tag_length1;
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (gcry_cipher_gettag (self->priv->cipher, tag, (gint) tag_length1), &_inner_error0_);
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			tag = (g_free (tag), NULL);
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return NULL;
#line 1264 "cipher.c"
		} else {
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			tag = (g_free (tag), NULL);
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 132 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return NULL;
#line 1274 "cipher.c"
		}
	}
#line 133 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp1_ = tag;
#line 133 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	_tmp1__length1 = tag_length1;
#line 133 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (result_length1) {
#line 133 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		*result_length1 = _tmp1__length1;
#line 1285 "cipher.c"
	}
#line 133 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	result = _tmp1_;
#line 133 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return result;
#line 1291 "cipher.c"
}

void
crypto_symmetric_cipher_check_tag (CryptoSymmetricCipher* self,
                                   guint8* tag,
                                   gint tag_length1,
                                   GError** error)
{
	GError* _inner_error0_ = NULL;
#line 136 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (self != NULL);
#line 137 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (gcry_cipher_checktag (self->priv->cipher, tag, (gint) tag_length1), &_inner_error0_);
#line 137 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 137 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 137 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 137 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1313 "cipher.c"
		} else {
#line 137 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 137 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 137 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1321 "cipher.c"
		}
	}
}

void
crypto_symmetric_cipher_encrypt (CryptoSymmetricCipher* self,
                                 guint8* output,
                                 gint output_length1,
                                 guint8* input,
                                 gint input_length1,
                                 GError** error)
{
	GError* _inner_error0_ = NULL;
#line 140 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (self != NULL);
#line 141 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (gcry_cipher_encrypt (self->priv->cipher, output, (gint) output_length1, input, (gint) input_length1), &_inner_error0_);
#line 141 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 141 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 141 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 141 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1347 "cipher.c"
		} else {
#line 141 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 141 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 141 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1355 "cipher.c"
		}
	}
}

void
crypto_symmetric_cipher_decrypt (CryptoSymmetricCipher* self,
                                 guint8* output,
                                 gint output_length1,
                                 guint8* input,
                                 gint input_length1,
                                 GError** error)
{
	GError* _inner_error0_ = NULL;
#line 144 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (self != NULL);
#line 145 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (gcry_cipher_decrypt (self->priv->cipher, output, (gint) output_length1, input, (gint) input_length1), &_inner_error0_);
#line 145 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 145 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 145 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 145 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1381 "cipher.c"
		} else {
#line 145 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 145 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 145 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1389 "cipher.c"
		}
	}
}

void
crypto_symmetric_cipher_sync (CryptoSymmetricCipher* self,
                              GError** error)
{
	GError* _inner_error0_ = NULL;
#line 148 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (self != NULL);
#line 149 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_may_throw_gcrypt_error (gcry_cipher_sync (self->priv->cipher), &_inner_error0_);
#line 149 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 149 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (_inner_error0_->domain == CRYPTO_ERROR) {
#line 149 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_propagate_error (error, _inner_error0_);
#line 149 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1411 "cipher.c"
		} else {
#line 149 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 149 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			g_clear_error (&_inner_error0_);
#line 149 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return;
#line 1419 "cipher.c"
		}
	}
}

static void
crypto_value_symmetric_cipher_init (GValue* value)
{
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	value->data[0].v_pointer = NULL;
#line 1429 "cipher.c"
}

static void
crypto_value_symmetric_cipher_free_value (GValue* value)
{
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (value->data[0].v_pointer) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		crypto_symmetric_cipher_unref (value->data[0].v_pointer);
#line 1439 "cipher.c"
	}
}

static void
crypto_value_symmetric_cipher_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (src_value->data[0].v_pointer) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		dest_value->data[0].v_pointer = crypto_symmetric_cipher_ref (src_value->data[0].v_pointer);
#line 1451 "cipher.c"
	} else {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1455 "cipher.c"
	}
}

static gpointer
crypto_value_symmetric_cipher_peek_pointer (const GValue* value)
{
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return value->data[0].v_pointer;
#line 1464 "cipher.c"
}

static gchar*
crypto_value_symmetric_cipher_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (collect_values[0].v_pointer) {
#line 1475 "cipher.c"
		CryptoSymmetricCipher * object;
		object = collect_values[0].v_pointer;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		if (object->parent_instance.g_class == NULL) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1482 "cipher.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1486 "cipher.c"
		}
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		value->data[0].v_pointer = crypto_symmetric_cipher_ref (object);
#line 1490 "cipher.c"
	} else {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		value->data[0].v_pointer = NULL;
#line 1494 "cipher.c"
	}
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return NULL;
#line 1498 "cipher.c"
}

static gchar*
crypto_value_symmetric_cipher_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	CryptoSymmetricCipher ** object_p;
	object_p = collect_values[0].v_pointer;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (!object_p) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1513 "cipher.c"
	}
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (!value->data[0].v_pointer) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		*object_p = NULL;
#line 1519 "cipher.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		*object_p = value->data[0].v_pointer;
#line 1523 "cipher.c"
	} else {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		*object_p = crypto_symmetric_cipher_ref (value->data[0].v_pointer);
#line 1527 "cipher.c"
	}
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return NULL;
#line 1531 "cipher.c"
}

GParamSpec*
crypto_param_spec_symmetric_cipher (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	CryptoParamSpecSymmetricCipher* spec;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_val_if_fail (g_type_is_a (object_type, CRYPTO_TYPE_SYMMETRIC_CIPHER), NULL);
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return G_PARAM_SPEC (spec);
#line 1550 "cipher.c"
}

gpointer
crypto_value_get_symmetric_cipher (const GValue* value)
{
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CRYPTO_TYPE_SYMMETRIC_CIPHER), NULL);
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return value->data[0].v_pointer;
#line 1560 "cipher.c"
}

void
crypto_value_set_symmetric_cipher (GValue* value,
                                   gpointer v_object)
{
	CryptoSymmetricCipher * old;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CRYPTO_TYPE_SYMMETRIC_CIPHER));
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	old = value->data[0].v_pointer;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (v_object) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CRYPTO_TYPE_SYMMETRIC_CIPHER));
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		value->data[0].v_pointer = v_object;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		crypto_symmetric_cipher_ref (value->data[0].v_pointer);
#line 1582 "cipher.c"
	} else {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		value->data[0].v_pointer = NULL;
#line 1586 "cipher.c"
	}
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (old) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		crypto_symmetric_cipher_unref (old);
#line 1592 "cipher.c"
	}
}

void
crypto_value_take_symmetric_cipher (GValue* value,
                                    gpointer v_object)
{
	CryptoSymmetricCipher * old;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CRYPTO_TYPE_SYMMETRIC_CIPHER));
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	old = value->data[0].v_pointer;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (v_object) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CRYPTO_TYPE_SYMMETRIC_CIPHER));
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		value->data[0].v_pointer = v_object;
#line 1613 "cipher.c"
	} else {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		value->data[0].v_pointer = NULL;
#line 1617 "cipher.c"
	}
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (old) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		crypto_symmetric_cipher_unref (old);
#line 1623 "cipher.c"
	}
}

static void
crypto_symmetric_cipher_class_init (CryptoSymmetricCipherClass * klass,
                                    gpointer klass_data)
{
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	crypto_symmetric_cipher_parent_class = g_type_class_peek_parent (klass);
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	((CryptoSymmetricCipherClass *) klass)->finalize = crypto_symmetric_cipher_finalize;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_type_class_adjust_private_offset (klass, &CryptoSymmetricCipher_private_offset);
#line 1637 "cipher.c"
}

static void
crypto_symmetric_cipher_instance_init (CryptoSymmetricCipher * self,
                                       gpointer klass)
{
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	self->priv = crypto_symmetric_cipher_get_instance_private (self);
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	self->ref_count = 1;
#line 1648 "cipher.c"
}

static void
crypto_symmetric_cipher_finalize (CryptoSymmetricCipher * obj)
{
	CryptoSymmetricCipher * self;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CRYPTO_TYPE_SYMMETRIC_CIPHER, CryptoSymmetricCipher);
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_signal_handlers_destroy (self);
#line 1659 "cipher.c"
}

 G_GNUC_NO_INLINE static GType
crypto_symmetric_cipher_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { crypto_value_symmetric_cipher_init, crypto_value_symmetric_cipher_free_value, crypto_value_symmetric_cipher_copy_value, crypto_value_symmetric_cipher_peek_pointer, "p", crypto_value_symmetric_cipher_collect_value, "p", crypto_value_symmetric_cipher_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CryptoSymmetricCipherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) crypto_symmetric_cipher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CryptoSymmetricCipher), 0, (GInstanceInitFunc) crypto_symmetric_cipher_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType crypto_symmetric_cipher_type_id;
	crypto_symmetric_cipher_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CryptoSymmetricCipher", &g_define_type_info, &g_define_type_fundamental_info, 0);
	CryptoSymmetricCipher_private_offset = g_type_add_instance_private (crypto_symmetric_cipher_type_id, sizeof (CryptoSymmetricCipherPrivate));
	return crypto_symmetric_cipher_type_id;
}

GType
crypto_symmetric_cipher_get_type (void)
{
	static gsize crypto_symmetric_cipher_type_id__once = 0;
	if (g_once_init_enter (&crypto_symmetric_cipher_type_id__once)) {
		GType crypto_symmetric_cipher_type_id;
		crypto_symmetric_cipher_type_id = crypto_symmetric_cipher_get_type_once ();
		g_once_init_leave (&crypto_symmetric_cipher_type_id__once, crypto_symmetric_cipher_type_id);
	}
	return crypto_symmetric_cipher_type_id__once;
}

gpointer
crypto_symmetric_cipher_ref (gpointer instance)
{
	CryptoSymmetricCipher * self;
	self = instance;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	g_atomic_int_inc (&self->ref_count);
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	return instance;
#line 1695 "cipher.c"
}

void
crypto_symmetric_cipher_unref (gpointer instance)
{
	CryptoSymmetricCipher * self;
	self = instance;
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		CRYPTO_SYMMETRIC_CIPHER_GET_CLASS (self)->finalize (self);
#line 2 "/build/dino/src/dino-0.4.3/crypto-vala/src/cipher.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1709 "cipher.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

