/* monitor.c generated by valac 0.56.14, the Vala compiler
 * generated from monitor.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "deja.h"
#include <glib-unix.h>
#include <signal.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCHEDULER (scheduler_get_type ())
#define SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEDULER, Scheduler))
#define SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEDULER, SchedulerClass))
#define IS_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEDULER))
#define IS_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEDULER))
#define SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEDULER, SchedulerClass))

typedef struct _Scheduler Scheduler;
typedef struct _SchedulerClass SchedulerClass;

#define TYPE_READY_WATCHER (ready_watcher_get_type ())
#define READY_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_READY_WATCHER, ReadyWatcher))
#define READY_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_READY_WATCHER, ReadyWatcherClass))
#define IS_READY_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_READY_WATCHER))
#define IS_READY_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_READY_WATCHER))
#define READY_WATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_READY_WATCHER, ReadyWatcherClass))

typedef struct _ReadyWatcher ReadyWatcher;
typedef struct _ReadyWatcherClass ReadyWatcherClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _KickoffData KickoffData;
typedef struct _SingleKickoffData SingleKickoffData;
typedef struct _StopAndQuitData StopAndQuitData;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _KickoffData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* unready_message;
	gboolean ready;
	ReadyWatcher* _tmp0_;
	Scheduler* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
};

struct _SingleKickoffData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
};

struct _StopAndQuitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GMainLoop* _tmp0_;
};

struct _Block1Data {
	int _ref_count_;
	GBusNameOwnerFlags name_flags;
};

VALA_EXTERN GMainLoop* loop;
GMainLoop* loop = NULL;
VALA_EXTERN Scheduler* scheduler;
Scheduler* scheduler = NULL;
VALA_EXTERN ReadyWatcher* ready_watcher;
ReadyWatcher* ready_watcher = NULL;
VALA_EXTERN gboolean no_delay;
gboolean no_delay = FALSE;
VALA_EXTERN gboolean replace;
gboolean replace = FALSE;
VALA_EXTERN gboolean show_version;
gboolean show_version = FALSE;
VALA_EXTERN gboolean kicking_off;
gboolean kicking_off = FALSE;

VALA_EXTERN GType scheduler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Scheduler, g_object_unref)
VALA_EXTERN GType ready_watcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ReadyWatcher, g_object_unref)
VALA_EXTERN gboolean handle_options (gint* status);
static void kickoff_data_free (gpointer _data);
VALA_EXTERN void kickoff (GAsyncReadyCallback _callback_,
              gpointer _user_data_);
VALA_EXTERN void kickoff_finish (GAsyncResult* _res_);
static gboolean kickoff_co (KickoffData* _data_);
VALA_EXTERN void ready_watcher_is_ready (ReadyWatcher* self,
                             gint days_late,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN gboolean ready_watcher_is_ready_finish (ReadyWatcher* self,
                                        GAsyncResult* _res_,
                                        gchar** message);
VALA_EXTERN gint scheduler_get_days_late (Scheduler* self);
static void kickoff_ready (GObject* source_object,
                    GAsyncResult* _res_,
                    gpointer _user_data_);
VALA_EXTERN void backup_interface_notify_not_ready (const gchar* message,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void backup_interface_notify_not_ready_finish (GAsyncResult* _res_);
VALA_EXTERN void backup_interface_start_auto (GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void backup_interface_start_auto_finish (GAsyncResult* _res_);
static void single_kickoff_data_free (gpointer _data);
VALA_EXTERN void single_kickoff (GAsyncReadyCallback _callback_,
                     gpointer _user_data_);
VALA_EXTERN void single_kickoff_finish (GAsyncResult* _res_);
static gboolean single_kickoff_co (SingleKickoffData* _data_);
static void single_kickoff_ready (GObject* source_object,
                           GAsyncResult* _res_,
                           gpointer _user_data_);
static void stop_and_quit_data_free (gpointer _data);
VALA_EXTERN void stop_and_quit (GAsyncReadyCallback _callback_,
                    gpointer _user_data_);
VALA_EXTERN void stop_and_quit_finish (GAsyncResult* _res_);
static gboolean stop_and_quit_co (StopAndQuitData* _data_);
VALA_EXTERN void backup_interface_stop_auto (GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
VALA_EXTERN void backup_interface_stop_auto_finish (GAsyncResult* _res_);
static void stop_and_quit_ready (GObject* source_object,
                          GAsyncResult* _res_,
                          gpointer _user_data_);
VALA_EXTERN void make_first_check (void);
VALA_EXTERN Scheduler* scheduler_new (void);
VALA_EXTERN Scheduler* scheduler_construct (GType object_type);
VALA_EXTERN ReadyWatcher* ready_watcher_new (gboolean no_delay);
VALA_EXTERN ReadyWatcher* ready_watcher_construct (GType object_type,
                                       gboolean no_delay);
static void __lambda7_ (void);
VALA_EXTERN void ready_watcher_reset_reasons (ReadyWatcher* self);
static void ___lambda7__scheduler_backup (Scheduler* _sender,
                                   gpointer self);
static void __lambda8_ (void);
static void ___lambda8__scheduler_quit (Scheduler* _sender,
                                 gpointer self);
static void __lambda9_ (const gchar* why);
VALA_EXTERN gboolean scheduler_get_past_due (Scheduler* self);
static void ___lambda9__ready_watcher_maybe_ready (ReadyWatcher* _sender,
                                            const gchar* why,
                                            gpointer self);
static void __lambda10_ (void);
static void ___lambda10__ready_watcher_stop_auto (ReadyWatcher* _sender,
                                           gpointer self);
VALA_EXTERN gboolean on_sigusr1 (void);
VALA_EXTERN void begin_monitoring (void);
static gboolean _on_sigusr1_gsource_func (gpointer self);
static gboolean __lambda11_ (void);
static gboolean ___lambda11__gsource_func (gpointer self);
static gint _vala_main (gchar** args,
                 gint args_length1);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda12_ (Block1Data* _data1_);
static void __lambda13_ (void);
static void ___lambda13__gbus_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self);
static void __lambda14_ (void);
static void ___lambda14__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
static void __lambda15_ (void);
static void ___lambda15__gbus_name_lost_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
static gboolean ___lambda12__gsource_func (gpointer self);

const GOptionEntry OPTIONS[4] = {{"no-delay", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &no_delay, NULL, NULL}, {"replace", (gchar) 0, (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &replace, NULL, NULL}, {"version", (gchar) 0, (gint) 0, G_OPTION_ARG_NONE, &show_version, N_ ("Show version"), NULL}, {NULL}};

gboolean
handle_options (gint* status)
{
	gint _vala_status = 0;
	gboolean result;
	_vala_status = 0;
	if (show_version) {
		g_print ("%s %s\n", "deja-dup-monitor", VERSION);
		result = FALSE;
		if (status) {
			*status = _vala_status;
		}
		return result;
	}
	result = TRUE;
	if (status) {
		*status = _vala_status;
	}
	return result;
}

static void
kickoff_data_free (gpointer _data)
{
	KickoffData* _data_;
	_data_ = _data;
	g_slice_free (KickoffData, _data_);
}

void
kickoff (GAsyncReadyCallback _callback_,
         gpointer _user_data_)
{
	KickoffData* _data_;
	_data_ = g_slice_new0 (KickoffData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, kickoff_data_free);
	kickoff_co (_data_);
}

void
kickoff_finish (GAsyncResult* _res_)
{
	KickoffData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
kickoff_ready (GObject* source_object,
               GAsyncResult* _res_,
               gpointer _user_data_)
{
	KickoffData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	kickoff_co (_data_);
}

static gboolean
kickoff_co (KickoffData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ready_watcher;
	_data_->_tmp1_ = scheduler;
	_data_->_tmp2_ = scheduler_get_days_late (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_state_ = 1;
	ready_watcher_is_ready (_data_->_tmp0_, _data_->_tmp3_, kickoff_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = ready_watcher_is_ready_finish (_data_->_tmp0_, _data_->_res_, &_data_->_tmp4_);
	_g_free0 (_data_->unready_message);
	_data_->unready_message = _data_->_tmp4_;
	_data_->ready = _data_->_tmp5_;
	if (!_data_->ready) {
		_data_->_tmp6_ = _data_->unready_message;
		if (_data_->_tmp6_ != NULL) {
			_data_->_tmp7_ = _data_->unready_message;
			_data_->_state_ = 2;
			backup_interface_notify_not_ready (_data_->_tmp7_, kickoff_ready, _data_);
			return FALSE;
			_state_2:
			backup_interface_notify_not_ready_finish (_data_->_res_);
		}
		_g_free0 (_data_->unready_message);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_debug ("monitor.vala:46: Running automatic backup.");
	_data_->_state_ = 3;
	backup_interface_start_auto (kickoff_ready, _data_);
	return FALSE;
	_state_3:
	backup_interface_start_auto_finish (_data_->_res_);
	_g_free0 (_data_->unready_message);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
single_kickoff_data_free (gpointer _data)
{
	SingleKickoffData* _data_;
	_data_ = _data;
	g_slice_free (SingleKickoffData, _data_);
}

void
single_kickoff (GAsyncReadyCallback _callback_,
                gpointer _user_data_)
{
	SingleKickoffData* _data_;
	_data_ = g_slice_new0 (SingleKickoffData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, single_kickoff_data_free);
	single_kickoff_co (_data_);
}

void
single_kickoff_finish (GAsyncResult* _res_)
{
	SingleKickoffData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
single_kickoff_ready (GObject* source_object,
                      GAsyncResult* _res_,
                      gpointer _user_data_)
{
	SingleKickoffData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	single_kickoff_co (_data_);
}

static gboolean
single_kickoff_co (SingleKickoffData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (!kicking_off) {
		kicking_off = TRUE;
		_data_->_state_ = 1;
		kickoff (single_kickoff_ready, _data_);
		return FALSE;
		_state_1:
		kickoff_finish (_data_->_res_);
		kicking_off = FALSE;
	} else {
		g_debug ("monitor.vala:64: Tried to kickoff twice.");
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
stop_and_quit_data_free (gpointer _data)
{
	StopAndQuitData* _data_;
	_data_ = _data;
	g_slice_free (StopAndQuitData, _data_);
}

void
stop_and_quit (GAsyncReadyCallback _callback_,
               gpointer _user_data_)
{
	StopAndQuitData* _data_;
	_data_ = g_slice_new0 (StopAndQuitData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, stop_and_quit_data_free);
	stop_and_quit_co (_data_);
}

void
stop_and_quit_finish (GAsyncResult* _res_)
{
	StopAndQuitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
stop_and_quit_ready (GObject* source_object,
                     GAsyncResult* _res_,
                     gpointer _user_data_)
{
	StopAndQuitData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	stop_and_quit_co (_data_);
}

static gboolean
stop_and_quit_co (StopAndQuitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	backup_interface_stop_auto (stop_and_quit_ready, _data_);
	return FALSE;
	_state_1:
	backup_interface_stop_auto_finish (_data_->_res_);
	_data_->_tmp0_ = loop;
	g_main_loop_quit (_data_->_tmp0_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
__lambda7_ (void)
{
	ReadyWatcher* _tmp0_;
	_tmp0_ = ready_watcher;
	ready_watcher_reset_reasons (_tmp0_);
	single_kickoff (NULL, NULL);
}

static void
___lambda7__scheduler_backup (Scheduler* _sender,
                              gpointer self)
{
	__lambda7_ ();
}

static void
__lambda8_ (void)
{
	stop_and_quit (NULL, NULL);
}

static void
___lambda8__scheduler_quit (Scheduler* _sender,
                            gpointer self)
{
	__lambda8_ ();
}

static void
__lambda9_ (const gchar* why)
{
	Scheduler* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (why != NULL);
	_tmp0_ = scheduler;
	_tmp1_ = scheduler_get_past_due (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		g_debug ("monitor.vala:92: Starting kickoff due to '%s' ready event while past d" \
"ue for a backup.", why);
		single_kickoff (NULL, NULL);
	} else {
		g_debug ("monitor.vala:96: Ignored '%s' ready event because we are not past due " \
"for a backup.", why);
	}
}

static void
___lambda9__ready_watcher_maybe_ready (ReadyWatcher* _sender,
                                       const gchar* why,
                                       gpointer self)
{
	__lambda9_ (why);
}

static void
__lambda10_ (void)
{
	backup_interface_stop_auto (NULL, NULL);
}

static void
___lambda10__ready_watcher_stop_auto (ReadyWatcher* _sender,
                                      gpointer self)
{
	__lambda10_ ();
}

void
make_first_check (void)
{
	Scheduler* _tmp0_;
	ReadyWatcher* _tmp1_;
	Scheduler* _tmp2_;
	Scheduler* _tmp3_;
	ReadyWatcher* _tmp4_;
	ReadyWatcher* _tmp5_;
	deja_dup_make_prompt_check ();
	_tmp0_ = scheduler_new ();
	_g_object_unref0 (scheduler);
	scheduler = _tmp0_;
	_tmp1_ = ready_watcher_new (no_delay);
	_g_object_unref0 (ready_watcher);
	ready_watcher = _tmp1_;
	_tmp2_ = scheduler;
	g_signal_connect (_tmp2_, "backup", (GCallback) ___lambda7__scheduler_backup, NULL);
	_tmp3_ = scheduler;
	g_signal_connect (_tmp3_, "quit", (GCallback) ___lambda8__scheduler_quit, NULL);
	_tmp4_ = ready_watcher;
	g_signal_connect (_tmp4_, "maybe-ready", (GCallback) ___lambda9__ready_watcher_maybe_ready, NULL);
	_tmp5_ = ready_watcher;
	g_signal_connect (_tmp5_, "stop-auto", (GCallback) ___lambda10__ready_watcher_stop_auto, NULL);
}

gboolean
on_sigusr1 (void)
{
	gboolean result;
	g_debug ("monitor.vala:108: Starting auto backup per signal request.");
	backup_interface_start_auto (NULL, NULL);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
_on_sigusr1_gsource_func (gpointer self)
{
	gboolean result;
	result = on_sigusr1 ();
	return result;
}

static gboolean
__lambda11_ (void)
{
	gboolean result;
	make_first_check ();
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ ();
	return result;
}

void
begin_monitoring (void)
{
	DejaDupInstallEnv* _tmp0_;
	DejaDupInstallEnv* _tmp1_;
	GMainLoop* _tmp2_;
	gint delay_time = 0;
	_tmp0_ = deja_dup_install_env_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = loop;
	deja_dup_install_env_register_monitor_restart (_tmp1_, _tmp2_);
	_g_object_unref0 (_tmp1_);
	g_unix_signal_add_full (G_PRIORITY_DEFAULT, (gint) SIGUSR1, _on_sigusr1_gsource_func, NULL, NULL);
	delay_time = 120;
	if (no_delay) {
		delay_time = 0;
	}
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) delay_time, ___lambda11__gsource_func, NULL, NULL);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		g_slice_free (Block1Data, _data1_);
	}
}

static void
__lambda13_ (void)
{
}

static void
___lambda13__gbus_acquired_callback (GDBusConnection* connection,
                                     const gchar* name,
                                     gpointer self)
{
	__lambda13_ ();
}

static void
__lambda14_ (void)
{
	begin_monitoring ();
}

static void
___lambda14__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda14_ ();
}

static void
__lambda15_ (void)
{
	GMainLoop* _tmp0_;
	_tmp0_ = loop;
	g_main_loop_quit (_tmp0_);
}

static void
___lambda15__gbus_name_lost_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda15_ ();
}

static gboolean
__lambda12_ (Block1Data* _data1_)
{
	gboolean result;
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, APPLICATION_ID ".Monitor", _data1_->name_flags, (GClosure*) ((___lambda13__gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda13__gbus_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda14__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda14__gbus_name_acquired_callback, NULL, (GClosureNotify) NULL)), (GClosure*) ((___lambda15__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda15__gbus_name_lost_callback, NULL, (GClosureNotify) NULL)));
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda12_ (self);
	return result;
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	Block1Data* _data1_;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	gint status = 0;
	gint _tmp9_ = 0;
	gboolean _tmp10_;
	GMainLoop* _tmp11_;
	GMainLoop* _tmp12_;
	GError* _inner_error0_ = NULL;
	gint result;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	deja_dup_i18n_setup ();
	g_set_application_name (_ ("Backup Monitor"));
	_tmp0_ = g_option_context_new ("");
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_add_main_entries (_tmp1_, OPTIONS, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GOptionContext* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = context;
		_tmp6_ = g_option_context_get_help (_tmp5_, TRUE, NULL);
		_tmp7_ = _tmp6_;
		g_printerr ("%s\n\n%s", _tmp4_, _tmp7_);
		_g_free0 (_tmp7_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp8_ = -1;
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp10_ = handle_options (&_tmp9_);
	status = _tmp9_;
	if (!_tmp10_) {
		result = status;
		_g_option_context_free0 (context);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	deja_dup_initialize ();
	_data1_->name_flags = G_BUS_NAME_OWNER_FLAGS_DO_NOT_QUEUE | G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT;
	if (replace) {
		_data1_->name_flags |= G_BUS_NAME_OWNER_FLAGS_REPLACE;
	}
	_tmp11_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (loop);
	loop = _tmp11_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda12__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	_tmp12_ = loop;
	g_main_loop_run (_tmp12_);
	_g_object_unref0 (scheduler);
	scheduler = NULL;
	_g_object_unref0 (ready_watcher);
	ready_watcher = NULL;
	_g_main_loop_unref0 (loop);
	loop = NULL;
	result = 0;
	_g_option_context_free0 (context);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

