/* Scheduler.c generated by valac 0.56.14, the Vala compiler
 * generated from Scheduler.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */
/* This class handles the details of telling us when we should try to back up.*/
/* It will send a signal when it is time for a scheduled backup.*/
/**/
/* In the happy path, a backup will be started and when it finishes, the*/
/* LAST_BACKUP_KEY will be set, causing this class to recalculate the next*/
/* backup and it will send a signal then. Rince and repeat.*/
/**/
/* In the error case, maybe the storage location wasn't available. Or the*/
/* backup got interrupted. Or the network connection is metered.*/
/**/
/* Whatever the case, this Scheduler class will actually schedule a fresh*/
/* backup signal every day, until LAST_BACKUP_KEY is set. This way, if anything*/
/* goes wrong at all, we at least will try once a day.*/
/**/
/* We may try more often, as the monitor will likely check backup conditions*/
/* frequently as various triggers happen. But this class's signals are the*/
/* minimum promised - even if the monitor process never tries on its own, we*/
/* will prompt it to try once a day.*/

#include <glib-object.h>
#include <glib.h>
#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCHEDULER (scheduler_get_type ())
#define SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCHEDULER, Scheduler))
#define SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCHEDULER, SchedulerClass))
#define IS_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCHEDULER))
#define IS_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCHEDULER))
#define SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCHEDULER, SchedulerClass))

typedef struct _Scheduler Scheduler;
typedef struct _SchedulerClass SchedulerClass;
typedef struct _SchedulerPrivate SchedulerPrivate;
enum  {
	SCHEDULER_0_PROPERTY,
	SCHEDULER_PAST_DUE_PROPERTY,
	SCHEDULER_DAYS_LATE_PROPERTY,
	SCHEDULER_NUM_PROPERTIES
};
static GParamSpec* scheduler_properties[SCHEDULER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
enum  {
	SCHEDULER_BACKUP_SIGNAL,
	SCHEDULER_QUIT_SIGNAL,
	SCHEDULER_NUM_SIGNALS
};
static guint scheduler_signals[SCHEDULER_NUM_SIGNALS] = {0};

struct _Scheduler {
	GObject parent_instance;
	SchedulerPrivate * priv;
};

struct _SchedulerClass {
	GObjectClass parent_class;
};

struct _SchedulerPrivate {
	gboolean _past_due;
	gint _days_late;
	guint timeout_id;
	DejaDupFilteredSettings* settings;
};

static gint Scheduler_private_offset;
static gpointer scheduler_parent_class = NULL;

VALA_EXTERN GType scheduler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Scheduler, g_object_unref)
static GTimeSpan scheduler_time_until (Scheduler* self,
                                GDateTime* date);
static gboolean scheduler_time_until_next_run (Scheduler* self,
                                        GTimeSpan* time);
static void scheduler_settings_changed (Scheduler* self,
                                 const gchar* key);
static void scheduler_prepare_next_run (Scheduler* self);
VALA_EXTERN void scheduler_set_past_due (Scheduler* self,
                             gboolean value);
VALA_EXTERN void scheduler_set_days_late (Scheduler* self,
                              gint value);
static void scheduler_prepare_run (Scheduler* self,
                            GTimeSpan wait_time);
static void scheduler_prepare_tomorrow (Scheduler* self);
static gboolean ___lambda4_ (Scheduler* self);
static void scheduler_initiate_backup (Scheduler* self);
static gboolean ____lambda4__gsource_func (gpointer self);
VALA_EXTERN guint _scheduler_get_timer_id (Scheduler* self);
VALA_EXTERN Scheduler* scheduler_new (void);
VALA_EXTERN Scheduler* scheduler_construct (GType object_type);
VALA_EXTERN gboolean scheduler_get_past_due (Scheduler* self);
VALA_EXTERN gint scheduler_get_days_late (Scheduler* self);
static GObject * scheduler_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void _scheduler_settings_changed_g_settings_changed (GSettings* _sender,
                                                     const gchar* key,
                                                     gpointer self);
static gboolean _scheduler___lambda5_ (Scheduler* self);
static gboolean __scheduler___lambda5__gsource_func (gpointer self);
static void scheduler_finalize (GObject * obj);
static GType scheduler_get_type_once (void);
static void _vala_scheduler_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_scheduler_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
scheduler_get_instance_private (Scheduler* self)
{
	return G_STRUCT_MEMBER_P (self, Scheduler_private_offset);
}

static GTimeSpan
scheduler_time_until (Scheduler* self,
                      GDateTime* date)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GTimeSpan _tmp2_;
	GTimeSpan result;
	g_return_val_if_fail (self != NULL, 0LL);
	g_return_val_if_fail (date != NULL, 0LL);
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_difference (date, _tmp1_);
	_g_date_time_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

static gboolean
scheduler_time_until_next_run (Scheduler* self,
                               GTimeSpan* time)
{
	GTimeSpan _vala_time = 0LL;
	GDateTime* next_date = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_time = (GTimeSpan) 0;
	_tmp0_ = deja_dup_next_run_date ();
	next_date = _tmp0_;
	_tmp1_ = next_date;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_date_time_unref0 (next_date);
		if (time) {
			*time = _vala_time;
		}
		return result;
	}
	_tmp2_ = next_date;
	_vala_time = scheduler_time_until (self, _tmp2_);
	result = TRUE;
	_g_date_time_unref0 (next_date);
	if (time) {
		*time = _vala_time;
	}
	return result;
}

static void
scheduler_settings_changed (Scheduler* self,
                            const gchar* key)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, DEJA_DUP_LAST_BACKUP_KEY) == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (key, DEJA_DUP_PERIODIC_KEY) == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (key, DEJA_DUP_PERIODIC_PERIOD_KEY) == 0;
	}
	if (_tmp0_) {
		scheduler_prepare_next_run (self);
	}
}

static void
scheduler_prepare_next_run (Scheduler* self)
{
	GTimeSpan wait_time = 0LL;
	gboolean enabled = FALSE;
	GTimeSpan _tmp0_ = 0LL;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_tmp1_ = scheduler_time_until_next_run (self, &_tmp0_);
	wait_time = _tmp0_;
	enabled = _tmp1_;
	if (!enabled) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = wait_time > ((GTimeSpan) 0);
	}
	if (_tmp2_) {
		scheduler_set_past_due (self, FALSE);
		scheduler_set_days_late (self, 0);
	}
	if (!enabled) {
		g_debug ("Scheduler.vala:108: Automatic backups disabled. Stopping monitor.");
		g_signal_emit (self, scheduler_signals[SCHEDULER_QUIT_SIGNAL], 0);
		return;
	}
	scheduler_prepare_run (self, wait_time);
}

static void
scheduler_prepare_tomorrow (Scheduler* self)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	GDateTime* tomorrow = NULL;
	GDateTime* _tmp1_;
	GTimeSpan time = 0LL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = g_date_time_add (now, deja_dup_get_day ());
	tomorrow = _tmp1_;
	time = scheduler_time_until (self, tomorrow);
	scheduler_prepare_run (self, time);
	_g_date_time_unref0 (tomorrow);
	_g_date_time_unref0 (now);
}

static gboolean
___lambda4_ (Scheduler* self)
{
	gboolean result;
	self->priv->timeout_id = (guint) 0;
	scheduler_initiate_backup (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda4_ ((Scheduler*) self);
	return result;
}

static void
scheduler_prepare_run (Scheduler* self,
                       GTimeSpan wait_time)
{
	GTimeSpan secs = 0LL;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	secs = (wait_time / G_TIME_SPAN_SECOND) + 1;
	if (wait_time > ((GTimeSpan) 0)) {
		_tmp0_ = secs > ((GTimeSpan) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_debug ("Scheduler.vala:134: Waiting %ld seconds until next backup.", (glong) secs);
		self->priv->timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) secs, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
	} else {
		g_debug ("Scheduler.vala:142: Late by %ld seconds. Backing up now.", (glong) (secs * -1));
		scheduler_initiate_backup (self);
	}
}

static void
scheduler_initiate_backup (Scheduler* self)
{
	GTimeSpan wait_time = 0LL;
	GTimeSpan _tmp0_ = 0LL;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	scheduler_prepare_tomorrow (self);
	scheduler_set_days_late (self, 0);
	_tmp1_ = scheduler_time_until_next_run (self, &_tmp0_);
	wait_time = _tmp0_;
	if (_tmp1_) {
		scheduler_set_days_late (self, (gint) ((-wait_time) / deja_dup_get_day ()));
	}
	scheduler_set_past_due (self, TRUE);
	g_signal_emit (self, scheduler_signals[SCHEDULER_BACKUP_SIGNAL], 0);
}

guint
_scheduler_get_timer_id (Scheduler* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->timeout_id;
	return result;
}

Scheduler*
scheduler_construct (GType object_type)
{
	Scheduler * self = NULL;
	self = (Scheduler*) g_object_new (object_type, NULL);
	return self;
}

Scheduler*
scheduler_new (void)
{
	return scheduler_construct (TYPE_SCHEDULER);
}

gboolean
scheduler_get_past_due (Scheduler* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_past_due;
	return result;
}

void
scheduler_set_past_due (Scheduler* self,
                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = scheduler_get_past_due (self);
	if (old_value != value) {
		self->priv->_past_due = value;
		g_object_notify_by_pspec ((GObject *) self, scheduler_properties[SCHEDULER_PAST_DUE_PROPERTY]);
	}
}

gint
scheduler_get_days_late (Scheduler* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_days_late;
	return result;
}

void
scheduler_set_days_late (Scheduler* self,
                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = scheduler_get_days_late (self);
	if (old_value != value) {
		self->priv->_days_late = value;
		g_object_notify_by_pspec ((GObject *) self, scheduler_properties[SCHEDULER_DAYS_LATE_PROPERTY]);
	}
}

static void
_scheduler_settings_changed_g_settings_changed (GSettings* _sender,
                                                const gchar* key,
                                                gpointer self)
{
	scheduler_settings_changed ((Scheduler*) self, key);
}

static gboolean
_scheduler___lambda5_ (Scheduler* self)
{
	gboolean result;
	self->priv->timeout_id = (guint) 0;
	scheduler_prepare_next_run (self);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
__scheduler___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = _scheduler___lambda5_ ((Scheduler*) self);
	return result;
}

static GObject *
scheduler_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Scheduler * self;
	DejaDupFilteredSettings* _tmp0_;
	DejaDupFilteredSettings* _tmp1_;
	parent_class = G_OBJECT_CLASS (scheduler_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCHEDULER, Scheduler);
	_tmp0_ = deja_dup_get_settings (NULL);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	g_signal_connect_object ((GSettings*) _tmp1_, "changed", (GCallback) _scheduler_settings_changed_g_settings_changed, self, 0);
	self->priv->timeout_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __scheduler___lambda5__gsource_func, g_object_ref (self), g_object_unref);
	_scheduler_get_timer_id (self);
	return obj;
}

static void
scheduler_class_init (SchedulerClass * klass,
                      gpointer klass_data)
{
	scheduler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Scheduler_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scheduler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scheduler_set_property;
	G_OBJECT_CLASS (klass)->constructor = scheduler_constructor;
	G_OBJECT_CLASS (klass)->finalize = scheduler_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCHEDULER_PAST_DUE_PROPERTY, scheduler_properties[SCHEDULER_PAST_DUE_PROPERTY] = g_param_spec_boolean ("past-due", "past-due", "past-due", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCHEDULER_DAYS_LATE_PROPERTY, scheduler_properties[SCHEDULER_DAYS_LATE_PROPERTY] = g_param_spec_int ("days-late", "days-late", "days-late", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	scheduler_signals[SCHEDULER_BACKUP_SIGNAL] = g_signal_new ("backup", TYPE_SCHEDULER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	scheduler_signals[SCHEDULER_QUIT_SIGNAL] = g_signal_new ("quit", TYPE_SCHEDULER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
scheduler_instance_init (Scheduler * self,
                         gpointer klass)
{
	self->priv = scheduler_get_instance_private (self);
	self->priv->timeout_id = (guint) 0;
	self->priv->settings = NULL;
}

static void
scheduler_finalize (GObject * obj)
{
	Scheduler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCHEDULER, Scheduler);
	if (self->priv->timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (scheduler_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scheduler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SchedulerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scheduler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scheduler), 0, (GInstanceInitFunc) scheduler_instance_init, NULL };
	GType scheduler_type_id;
	scheduler_type_id = g_type_register_static (G_TYPE_OBJECT, "Scheduler", &g_define_type_info, 0);
	Scheduler_private_offset = g_type_add_instance_private (scheduler_type_id, sizeof (SchedulerPrivate));
	return scheduler_type_id;
}

GType
scheduler_get_type (void)
{
	static gsize scheduler_type_id__once = 0;
	if (g_once_init_enter (&scheduler_type_id__once)) {
		GType scheduler_type_id;
		scheduler_type_id = scheduler_get_type_once ();
		g_once_init_leave (&scheduler_type_id__once, scheduler_type_id);
	}
	return scheduler_type_id__once;
}

static void
_vala_scheduler_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	Scheduler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SCHEDULER, Scheduler);
	switch (property_id) {
		case SCHEDULER_PAST_DUE_PROPERTY:
		g_value_set_boolean (value, scheduler_get_past_due (self));
		break;
		case SCHEDULER_DAYS_LATE_PROPERTY:
		g_value_set_int (value, scheduler_get_days_late (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scheduler_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	Scheduler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SCHEDULER, Scheduler);
	switch (property_id) {
		case SCHEDULER_PAST_DUE_PROPERTY:
		scheduler_set_past_due (self, g_value_get_boolean (value));
		break;
		case SCHEDULER_DAYS_LATE_PROPERTY:
		scheduler_set_days_late (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

