/* ReadyWatcher.c generated by valac 0.56.14, the Vala compiler
 * generated from ReadyWatcher.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */
/* This class does three main things, all centered around "readiness".*/
/* "Readiness" is whether we could/should start a backup now. For example,*/
/* the network is up and unmetered. We're not in low power mode. The external*/
/* drive is plugged in. That sort of thing.*/
/**/
/* 1) Watching for possible readiness changes*/
/**/
/* This class watches all the various possible tiggers that might change our*/
/* "ready" state and signals that something changed.*/
/**/
/* This class is intentionally a little dumb. It doesn't know what the policy*/
/* is, whether we are even scheduled for a backup right now, what storage*/
/* location is even configured, etc. It just messages if any possible trigger*/
/* for any storage location or possible backup changed. Then the policy*/
/* driver (the main monitor process) will decide what to do.*/
/**/
/* 2) Actually checking readiness*/
/**/
/* This class also holds the `is_ready` method, which the main monitor process*/
/* may use as part of deciding what to do - but we don't call it ourselves*/
/* prematurely, because it has side effects (like mounting) that we only want*/
/* to initiate if it's time for a backup.*/
/**/
/* 3) Keeping track of "not yet ready" reasons*/
/**/
/* In a given "waiting to become ready" cycle (which in practice is a day, as*/
/* that is how long Scheduler will wait on its own to backup again), we keep*/
/* track of the various reasons we weren't ready yet. We do this because we*/
/* don't want to keep nagging the user to plug in their external drive.*/
/**/
/* And we also want to make sure that if a new not-yet-ready reason appears,*/
/* that we do actually bug the user about it. For example, if we say "we need*/
/* to be connected to the internet please" and they do, but it's a metered*/
/* connection - we need to tell the user about _that_ now (while not bothering*/
/* them about connecting to internet for the rest of the day).*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include "deja.h"

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_READY_WATCHER (ready_watcher_get_type ())
#define READY_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_READY_WATCHER, ReadyWatcher))
#define READY_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_READY_WATCHER, ReadyWatcherClass))
#define IS_READY_WATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_READY_WATCHER))
#define IS_READY_WATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_READY_WATCHER))
#define READY_WATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_READY_WATCHER, ReadyWatcherClass))

typedef struct _ReadyWatcher ReadyWatcher;
typedef struct _ReadyWatcherClass ReadyWatcherClass;
typedef struct _ReadyWatcherPrivate ReadyWatcherPrivate;

#define TYPE_GAME_MODE (game_mode_get_type ())
#define GAME_MODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_MODE, GameMode))
#define GAME_MODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_MODE, GameModeClass))
#define IS_GAME_MODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_MODE))
#define IS_GAME_MODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_MODE))
#define GAME_MODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_MODE, GameModeClass))

typedef struct _GameMode GameMode;
typedef struct _GameModeClass GameModeClass;
enum  {
	READY_WATCHER_0_PROPERTY,
	READY_WATCHER_NO_DELAY_PROPERTY,
	READY_WATCHER_NUM_PROPERTIES
};
static GParamSpec* ready_watcher_properties[READY_WATCHER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ReadyWatcherIsReadyData ReadyWatcherIsReadyData;
typedef struct _ReadyWatcherIsReadyWithReasonData ReadyWatcherIsReadyWithReasonData;
enum  {
	READY_WATCHER_MAYBE_READY_SIGNAL,
	READY_WATCHER_STOP_AUTO_SIGNAL,
	READY_WATCHER_NUM_SIGNALS
};
static guint ready_watcher_signals[READY_WATCHER_NUM_SIGNALS] = {0};

struct _ReadyWatcher {
	GObject parent_instance;
	ReadyWatcherPrivate * priv;
};

struct _ReadyWatcherClass {
	GObjectClass parent_class;
};

struct _ReadyWatcherPrivate {
	gboolean _no_delay;
	guint netcheck_id;
	GHashTable* unready_reasons;
	GameMode* gamemode;
	GPowerProfileMonitor* power_monitor;
};

struct _ReadyWatcherIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ReadyWatcher* self;
	gint days_late;
	gchar* message;
	gboolean result;
	gchar* reason;
	gchar* reason_message;
	gboolean ready;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	GHashTable* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** parts;
	const gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	GHashTable* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
};

struct _ReadyWatcherIsReadyWithReasonData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ReadyWatcher* self;
	gint days_late;
	gchar* reason;
	gchar* message;
	gboolean result;
	GameMode* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp3_;
	GPowerProfileMonitor* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	DejaDupBackend* backend;
	DejaDupBackend* _tmp10_;
	DejaDupNetwork* network;
	DejaDupNetwork* _tmp11_;
	gboolean _tmp12_;
	DejaDupBackend* _tmp13_;
	DejaDupNetwork* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_;
	DejaDupBackend* _tmp20_;
	DejaDupNetwork* _tmp21_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	DejaDupBackend* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_;
};

static gint ReadyWatcher_private_offset;
static gpointer ready_watcher_parent_class = NULL;

VALA_EXTERN GType ready_watcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ReadyWatcher, g_object_unref)
VALA_EXTERN GType game_mode_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameMode, g_object_unref)
VALA_EXTERN ReadyWatcher* ready_watcher_new (gboolean no_delay);
VALA_EXTERN ReadyWatcher* ready_watcher_construct (GType object_type,
                                       gboolean no_delay);
static void ready_watcher_is_ready_data_free (gpointer _data);
VALA_EXTERN void ready_watcher_is_ready (ReadyWatcher* self,
                             gint days_late,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN gboolean ready_watcher_is_ready_finish (ReadyWatcher* self,
                                        GAsyncResult* _res_,
                                        gchar** message);
static gboolean ready_watcher_is_ready_co (ReadyWatcherIsReadyData* _data_);
static void ready_watcher_is_ready_with_reason (ReadyWatcher* self,
                                         gint days_late,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static gboolean ready_watcher_is_ready_with_reason_finish (ReadyWatcher* self,
                                                    GAsyncResult* _res_,
                                                    gchar** reason,
                                                    gchar** message);
static void ready_watcher_is_ready_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
VALA_EXTERN void ready_watcher_reset_reasons (ReadyWatcher* self);
static void _g_free0_ (gpointer var);
static void ready_watcher_is_ready_with_reason_data_free (gpointer _data);
static gboolean ready_watcher_is_ready_with_reason_co (ReadyWatcherIsReadyWithReasonData* _data_);
VALA_EXTERN gboolean game_mode_get_enabled (GameMode* self);
static void ready_watcher_is_ready_with_reason_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void ready_watcher_volume_added (ReadyWatcher* self);
static void ready_watcher_gamemode_changed (ReadyWatcher* self);
static void ready_watcher_power_saver_changed (ReadyWatcher* self);
static void ready_watcher_network_changed (ReadyWatcher* self);
VALA_EXTERN gboolean ready_watcher_get_no_delay (ReadyWatcher* self);
static gboolean __lambda6_ (ReadyWatcher* self);
static gboolean ___lambda6__gsource_func (gpointer self);
VALA_EXTERN void ready_watcher_set_no_delay (ReadyWatcher* self,
                                 gboolean value);
static GObject * ready_watcher_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void _ready_watcher_network_changed_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void _ready_watcher_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                                GVolume* volume,
                                                                gpointer self);
VALA_EXTERN GameMode* game_mode_new (void);
VALA_EXTERN GameMode* game_mode_construct (GType object_type);
static void _ready_watcher_gamemode_changed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void _ready_watcher_power_saver_changed_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void ready_watcher_finalize (GObject * obj);
static GType ready_watcher_get_type_once (void);
static void _vala_ready_watcher_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_ready_watcher_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
ready_watcher_get_instance_private (ReadyWatcher* self)
{
	return G_STRUCT_MEMBER_P (self, ReadyWatcher_private_offset);
}

ReadyWatcher*
ready_watcher_construct (GType object_type,
                         gboolean no_delay)
{
	ReadyWatcher * self = NULL;
	self = (ReadyWatcher*) g_object_new (object_type, "no-delay", no_delay, NULL);
	return self;
}

ReadyWatcher*
ready_watcher_new (gboolean no_delay)
{
	return ready_watcher_construct (TYPE_READY_WATCHER, no_delay);
}

static void
ready_watcher_is_ready_data_free (gpointer _data)
{
	ReadyWatcherIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ReadyWatcherIsReadyData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
ready_watcher_is_ready (ReadyWatcher* self,
                        gint days_late,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	ReadyWatcherIsReadyData* _data_;
	ReadyWatcher* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ReadyWatcherIsReadyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, ready_watcher_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->days_late = days_late;
	ready_watcher_is_ready_co (_data_);
}

gboolean
ready_watcher_is_ready_finish (ReadyWatcher* self,
                               GAsyncResult* _res_,
                               gchar** message)
{
	gboolean result;
	ReadyWatcherIsReadyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (message) {
		*message = _data_->message;
	} else {
		_g_free0 (_data_->message);
	}
	_data_->message = NULL;
	result = _data_->result;
	return result;
}

static void
ready_watcher_is_ready_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	ReadyWatcherIsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	ready_watcher_is_ready_co (_data_);
}

static gboolean
ready_watcher_is_ready_co (ReadyWatcherIsReadyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_g_free0 (_data_->message);
	_data_->message = NULL;
	_data_->_tmp0_ = NULL;
	_data_->_tmp1_ = NULL;
	_data_->_state_ = 1;
	ready_watcher_is_ready_with_reason (_data_->self, _data_->days_late, ready_watcher_is_ready_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = ready_watcher_is_ready_with_reason_finish (_data_->self, _data_->_res_, &_data_->_tmp0_, &_data_->_tmp1_);
	_g_free0 (_data_->reason);
	_data_->reason = _data_->_tmp0_;
	_g_free0 (_data_->reason_message);
	_data_->reason_message = _data_->_tmp1_;
	_data_->ready = _data_->_tmp2_;
	if (!_data_->ready) {
		_data_->_tmp5_ = _data_->reason;
		_data_->_tmp4_ = _data_->_tmp5_ != NULL;
	} else {
		_data_->_tmp4_ = FALSE;
	}
	if (_data_->_tmp4_) {
		_data_->_tmp6_ = _data_->self->priv->unready_reasons;
		_data_->_tmp7_ = _data_->reason;
		_data_->_tmp3_ = !g_hash_table_contains (_data_->_tmp6_, _data_->_tmp7_);
	} else {
		_data_->_tmp3_ = FALSE;
	}
	if (_data_->_tmp3_) {
		_data_->_tmp8_ = _data_->self->priv->unready_reasons;
		_data_->_tmp9_ = _data_->reason;
		_data_->_tmp10_ = g_strdup (_data_->_tmp9_);
		g_hash_table_add (_data_->_tmp8_, _data_->_tmp10_);
		_data_->_tmp11_ = _data_->reason;
		_data_->_tmp13_ = _data_->_tmp12_ = g_strsplit (_data_->_tmp11_, ".", 0);
		_data_->parts = _data_->_tmp13_;
		_data_->parts_length1 = _vala_array_length (_data_->_tmp12_);
		_data_->_parts_size_ = _data_->parts_length1;
		_data_->_tmp14_ = _data_->parts;
		_data_->_tmp14__length1 = _data_->parts_length1;
		if (_data_->_tmp14__length1 > 1) {
			_data_->_tmp15_ = _data_->self->priv->unready_reasons;
			_data_->_tmp16_ = _data_->parts;
			_data_->_tmp16__length1 = _data_->parts_length1;
			_data_->_tmp17_ = _data_->_tmp16_[0];
			_data_->_tmp18_ = g_strdup (_data_->_tmp17_);
			g_hash_table_add (_data_->_tmp15_, _data_->_tmp18_);
		}
		_data_->_tmp19_ = _data_->reason_message;
		_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
		_g_free0 (_data_->message);
		_data_->message = _data_->_tmp20_;
		_data_->parts = (_vala_array_free (_data_->parts, _data_->parts_length1, (GDestroyNotify) g_free), NULL);
	}
	if (!_data_->ready) {
		_data_->_tmp22_ = _data_->reason;
		_data_->_tmp21_ = _data_->_tmp22_ != NULL;
	} else {
		_data_->_tmp21_ = FALSE;
	}
	if (_data_->_tmp21_) {
		_data_->_tmp23_ = _data_->reason;
		g_debug ("ReadyWatcher.vala:80: Backup is not ready yet: %s", _data_->_tmp23_);
	}
	_data_->result = _data_->ready;
	_g_free0 (_data_->reason_message);
	_g_free0 (_data_->reason);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

void
ready_watcher_reset_reasons (ReadyWatcher* self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->unready_reasons);
	self->priv->unready_reasons = _tmp2_;
}

static void
ready_watcher_is_ready_with_reason_data_free (gpointer _data)
{
	ReadyWatcherIsReadyWithReasonData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ReadyWatcherIsReadyWithReasonData, _data_);
}

static void
ready_watcher_is_ready_with_reason (ReadyWatcher* self,
                                    gint days_late,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	ReadyWatcherIsReadyWithReasonData* _data_;
	ReadyWatcher* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ReadyWatcherIsReadyWithReasonData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, ready_watcher_is_ready_with_reason_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->days_late = days_late;
	ready_watcher_is_ready_with_reason_co (_data_);
}

static gboolean
ready_watcher_is_ready_with_reason_finish (ReadyWatcher* self,
                                           GAsyncResult* _res_,
                                           gchar** reason,
                                           gchar** message)
{
	gboolean result;
	ReadyWatcherIsReadyWithReasonData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (reason) {
		*reason = _data_->reason;
	} else {
		_g_free0 (_data_->reason);
	}
	_data_->reason = NULL;
	if (message) {
		*message = _data_->message;
	} else {
		_g_free0 (_data_->message);
	}
	_data_->message = NULL;
	result = _data_->result;
	return result;
}

static void
ready_watcher_is_ready_with_reason_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	ReadyWatcherIsReadyWithReasonData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	ready_watcher_is_ready_with_reason_co (_data_);
}

static gboolean
ready_watcher_is_ready_with_reason_co (ReadyWatcherIsReadyWithReasonData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->gamemode;
	_data_->_tmp1_ = game_mode_get_enabled (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = g_strdup ("gamemode");
		_g_free0 (_data_->reason);
		_data_->reason = _data_->_tmp3_;
		_g_free0 (_data_->message);
		_data_->message = NULL;
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->power_monitor;
	_data_->_tmp5_ = g_power_profile_monitor_get_power_saver_enabled (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	if (_data_->_tmp6_) {
		if (_data_->days_late < 1) {
			_data_->_tmp7_ = g_strdup ("power-saver");
			_g_free0 (_data_->reason);
			_data_->reason = _data_->_tmp7_;
			_g_free0 (_data_->message);
			_data_->message = NULL;
		} else {
			_data_->_tmp8_ = g_strdup ("power-saver.overdue");
			_g_free0 (_data_->reason);
			_data_->reason = _data_->_tmp8_;
			_data_->_tmp9_ = g_strdup (_ ("Backup will begin when power saver mode is no longer active."));
			_g_free0 (_data_->message);
			_data_->message = _data_->_tmp9_;
		}
		_data_->result = FALSE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = deja_dup_backend_get_default ();
	_data_->backend = _data_->_tmp10_;
	_data_->_tmp11_ = deja_dup_network_get ();
	_data_->network = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->backend;
	if (!deja_dup_backend_is_native (_data_->_tmp13_)) {
		_data_->_tmp14_ = _data_->network;
		_data_->_tmp15_ = deja_dup_network_get_connected (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_tmp12_ = !_data_->_tmp16_;
	} else {
		_data_->_tmp12_ = FALSE;
	}
	if (_data_->_tmp12_) {
		_data_->_tmp17_ = g_strdup ("network-connection");
		_g_free0 (_data_->reason);
		_data_->reason = _data_->_tmp17_;
		_data_->_tmp18_ = g_strdup (_ ("Backup will begin when a network connection becomes available."));
		_g_free0 (_data_->message);
		_data_->message = _data_->_tmp18_;
		_data_->result = FALSE;
		_g_object_unref0 (_data_->network);
		_g_object_unref0 (_data_->backend);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp20_ = _data_->backend;
		if (!deja_dup_backend_is_native (_data_->_tmp20_)) {
			_data_->_tmp21_ = _data_->network;
			_data_->_tmp22_ = deja_dup_network_get_metered (_data_->_tmp21_);
			_data_->_tmp23_ = _data_->_tmp22_;
			_data_->_tmp19_ = _data_->_tmp23_;
		} else {
			_data_->_tmp19_ = FALSE;
		}
		if (_data_->_tmp19_) {
			_data_->_tmp24_ = g_strdup ("network-connection.metered");
			_g_free0 (_data_->reason);
			_data_->reason = _data_->_tmp24_;
			_data_->_tmp25_ = g_strdup (_ ("Backup will begin when an unmetered network connection becomes availab" \
"le."));
			_g_free0 (_data_->message);
			_data_->message = _data_->_tmp25_;
			_data_->result = FALSE;
			_g_object_unref0 (_data_->network);
			_g_object_unref0 (_data_->backend);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp26_ = _data_->backend;
	_data_->_tmp27_ = NULL;
	_data_->_tmp28_ = NULL;
	_data_->_state_ = 1;
	deja_dup_backend_is_ready (_data_->_tmp26_, ready_watcher_is_ready_with_reason_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp29_ = deja_dup_backend_is_ready_finish (_data_->_tmp26_, _data_->_res_, &_data_->_tmp27_, &_data_->_tmp28_);
	_g_free0 (_data_->reason);
	_data_->reason = _data_->_tmp27_;
	_g_free0 (_data_->message);
	_data_->message = _data_->_tmp28_;
	_data_->result = _data_->_tmp29_;
	_g_object_unref0 (_data_->network);
	_g_object_unref0 (_data_->backend);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
ready_watcher_volume_added (ReadyWatcher* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, ready_watcher_signals[READY_WATCHER_MAYBE_READY_SIGNAL], 0, "volume added");
}

static void
ready_watcher_gamemode_changed (ReadyWatcher* self)
{
	GameMode* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gamemode;
	_tmp1_ = game_mode_get_enabled (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		g_signal_emit (self, ready_watcher_signals[READY_WATCHER_STOP_AUTO_SIGNAL], 0);
	}
	g_signal_emit (self, ready_watcher_signals[READY_WATCHER_MAYBE_READY_SIGNAL], 0, "gamemode changed");
}

static void
ready_watcher_power_saver_changed (ReadyWatcher* self)
{
	GPowerProfileMonitor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->power_monitor;
	_tmp1_ = g_power_profile_monitor_get_power_saver_enabled (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		g_signal_emit (self, ready_watcher_signals[READY_WATCHER_STOP_AUTO_SIGNAL], 0);
	}
	g_signal_emit (self, ready_watcher_signals[READY_WATCHER_MAYBE_READY_SIGNAL], 0, "power saver changed");
}

static gboolean
__lambda6_ (ReadyWatcher* self)
{
	gboolean result;
	self->priv->netcheck_id = (guint) 0;
	g_signal_emit (self, ready_watcher_signals[READY_WATCHER_MAYBE_READY_SIGNAL], 0, "network status changed");
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((ReadyWatcher*) self);
	return result;
}

static void
ready_watcher_network_changed (ReadyWatcher* self)
{
	gint delay_time = 0;
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->netcheck_id > ((guint) 0)) {
		g_source_remove (self->priv->netcheck_id);
	}
	g_debug ("ReadyWatcher.vala:199: Network status changed, starting timeout.");
	delay_time = 120;
	_tmp0_ = self->priv->_no_delay;
	if (_tmp0_) {
		delay_time = 0;
	}
	self->priv->netcheck_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) delay_time, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
}

gboolean
ready_watcher_get_no_delay (ReadyWatcher* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_delay;
	return result;
}

void
ready_watcher_set_no_delay (ReadyWatcher* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = ready_watcher_get_no_delay (self);
	if (old_value != value) {
		self->priv->_no_delay = value;
		g_object_notify_by_pspec ((GObject *) self, ready_watcher_properties[READY_WATCHER_NO_DELAY_PROPERTY]);
	}
}

static void
_ready_watcher_network_changed_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	ready_watcher_network_changed ((ReadyWatcher*) self);
}

static void
_ready_watcher_volume_added_g_volume_monitor_volume_added (GVolumeMonitor* _sender,
                                                           GVolume* volume,
                                                           gpointer self)
{
	ready_watcher_volume_added ((ReadyWatcher*) self);
}

static void
_ready_watcher_gamemode_changed_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	ready_watcher_gamemode_changed ((ReadyWatcher*) self);
}

static void
_ready_watcher_power_saver_changed_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	ready_watcher_power_saver_changed ((ReadyWatcher*) self);
}

static GObject *
ready_watcher_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ReadyWatcher * self;
	DejaDupNetwork* _tmp0_;
	DejaDupNetwork* _tmp1_;
	DejaDupNetwork* _tmp2_;
	DejaDupNetwork* _tmp3_;
	GVolumeMonitor* mon = NULL;
	GVolumeMonitor* _tmp4_;
	GVolumeMonitor* _tmp5_;
	GameMode* _tmp6_;
	GameMode* _tmp7_;
	GPowerProfileMonitor* _tmp8_;
	GPowerProfileMonitor* _tmp9_;
	parent_class = G_OBJECT_CLASS (ready_watcher_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_READY_WATCHER, ReadyWatcher);
	ready_watcher_reset_reasons (self);
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::connected", (GCallback) _ready_watcher_network_changed_g_object_notify, self, 0);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = deja_dup_network_get ();
	_tmp3_ = _tmp2_;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::metered", (GCallback) _ready_watcher_network_changed_g_object_notify, self, 0);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = deja_dup_get_volume_monitor ();
	mon = _tmp4_;
	_tmp5_ = mon;
	g_signal_connect_object (_tmp5_, "volume-added", (GCallback) _ready_watcher_volume_added_g_volume_monitor_volume_added, self, 0);
	_tmp6_ = game_mode_new ();
	_g_object_unref0 (self->priv->gamemode);
	self->priv->gamemode = _tmp6_;
	_tmp7_ = self->priv->gamemode;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::enabled", (GCallback) _ready_watcher_gamemode_changed_g_object_notify, self, 0);
	_tmp8_ = g_power_profile_monitor_dup_default ();
	_g_object_unref0 (self->priv->power_monitor);
	self->priv->power_monitor = _tmp8_;
	_tmp9_ = self->priv->power_monitor;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::power-saver-enabled", (GCallback) _ready_watcher_power_saver_changed_g_object_notify, self, 0);
	_g_object_unref0 (mon);
	return obj;
}

static void
ready_watcher_class_init (ReadyWatcherClass * klass,
                          gpointer klass_data)
{
	ready_watcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ReadyWatcher_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_ready_watcher_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_ready_watcher_set_property;
	G_OBJECT_CLASS (klass)->constructor = ready_watcher_constructor;
	G_OBJECT_CLASS (klass)->finalize = ready_watcher_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), READY_WATCHER_NO_DELAY_PROPERTY, ready_watcher_properties[READY_WATCHER_NO_DELAY_PROPERTY] = g_param_spec_boolean ("no-delay", "no-delay", "no-delay", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	ready_watcher_signals[READY_WATCHER_MAYBE_READY_SIGNAL] = g_signal_new ("maybe-ready", TYPE_READY_WATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	ready_watcher_signals[READY_WATCHER_STOP_AUTO_SIGNAL] = g_signal_new ("stop-auto", TYPE_READY_WATCHER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
ready_watcher_instance_init (ReadyWatcher * self,
                             gpointer klass)
{
	self->priv = ready_watcher_get_instance_private (self);
	self->priv->netcheck_id = (guint) 0;
	self->priv->unready_reasons = NULL;
	self->priv->gamemode = NULL;
	self->priv->power_monitor = NULL;
}

static void
ready_watcher_finalize (GObject * obj)
{
	ReadyWatcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_READY_WATCHER, ReadyWatcher);
	if (self->priv->netcheck_id > ((guint) 0)) {
		g_source_remove (self->priv->netcheck_id);
		self->priv->netcheck_id = (guint) 0;
	}
	_g_hash_table_unref0 (self->priv->unready_reasons);
	_g_object_unref0 (self->priv->gamemode);
	_g_object_unref0 (self->priv->power_monitor);
	G_OBJECT_CLASS (ready_watcher_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
ready_watcher_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ReadyWatcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ready_watcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ReadyWatcher), 0, (GInstanceInitFunc) ready_watcher_instance_init, NULL };
	GType ready_watcher_type_id;
	ready_watcher_type_id = g_type_register_static (G_TYPE_OBJECT, "ReadyWatcher", &g_define_type_info, 0);
	ReadyWatcher_private_offset = g_type_add_instance_private (ready_watcher_type_id, sizeof (ReadyWatcherPrivate));
	return ready_watcher_type_id;
}

GType
ready_watcher_get_type (void)
{
	static gsize ready_watcher_type_id__once = 0;
	if (g_once_init_enter (&ready_watcher_type_id__once)) {
		GType ready_watcher_type_id;
		ready_watcher_type_id = ready_watcher_get_type_once ();
		g_once_init_leave (&ready_watcher_type_id__once, ready_watcher_type_id);
	}
	return ready_watcher_type_id__once;
}

static void
_vala_ready_watcher_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	ReadyWatcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_READY_WATCHER, ReadyWatcher);
	switch (property_id) {
		case READY_WATCHER_NO_DELAY_PROPERTY:
		g_value_set_boolean (value, ready_watcher_get_no_delay (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_ready_watcher_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	ReadyWatcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_READY_WATCHER, ReadyWatcher);
	switch (property_id) {
		case READY_WATCHER_NO_DELAY_PROPERTY:
		ready_watcher_set_no_delay (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

