/* GameMode.c generated by valac 0.56.14, the Vala compiler
 * generated from GameMode.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */
/**
 * There are two ways to detect an active GameMode state:
 * - org.freedesktop.portal.GameMode.Active (since xdg-desktop-portal 1.16)
 * - com.feralinteractive.GameMode.ClientCount
 *
 * We'll check both for now, since the portal is too new to fully rely on.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_MODE (game_mode_get_type ())
#define GAME_MODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_MODE, GameMode))
#define GAME_MODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_MODE, GameModeClass))
#define IS_GAME_MODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_MODE))
#define IS_GAME_MODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_MODE))
#define GAME_MODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_MODE, GameModeClass))

typedef struct _GameMode GameMode;
typedef struct _GameModeClass GameModeClass;
typedef struct _GameModePrivate GameModePrivate;
enum  {
	GAME_MODE_0_PROPERTY,
	GAME_MODE_ENABLED_PROPERTY,
	GAME_MODE_NUM_PROPERTIES
};
static GParamSpec* game_mode_properties[GAME_MODE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GameModeLoadProxyData GameModeLoadProxyData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _GameMode {
	GObject parent_instance;
	GameModePrivate * priv;
};

struct _GameModeClass {
	GObjectClass parent_class;
};

struct _GameModePrivate {
	gboolean _enabled;
	GDBusProxy* portal;
	GDBusProxy* service;
};

struct _GameModeLoadProxyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GameMode* self;
	GDBusProxy* _tmp0_;
	GDBusProxy* _tmp1_;
	GDBusProxy* _tmp2_;
	GDBusProxy* _tmp3_;
	GDBusProxy* _tmp4_;
	GDBusProxy* _tmp5_;
	GError* _error_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GDBusProxy* _tmp8_;
	GDBusProxy* _tmp9_;
	GError* _inner_error0_;
};

static gint GameMode_private_offset;
static gpointer game_mode_parent_class = NULL;

VALA_EXTERN GType game_mode_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameMode, g_object_unref)
static void game_mode_load_proxy_data_free (gpointer _data);
static void game_mode_load_proxy (GameMode* self,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_);
static void game_mode_load_proxy_finish (GameMode* self,
                                  GAsyncResult* _res_);
static gboolean game_mode_load_proxy_co (GameModeLoadProxyData* _data_);
static void game_mode_load_proxy_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_);
static void game_mode_update_from_portal (GameMode* self);
static void _game_mode_update_from_portal_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                      GVariant* changed_properties,
                                                                      gchar** invalidated_properties,
                                                                      gpointer self);
static void game_mode_update_from_service (GameMode* self);
static void _game_mode_update_from_service_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                       GVariant* changed_properties,
                                                                       gchar** invalidated_properties,
                                                                       gpointer self);
static void game_mode_set_enabled (GameMode* self,
                            gboolean value);
VALA_EXTERN GameMode* game_mode_new (void);
VALA_EXTERN GameMode* game_mode_construct (GType object_type);
VALA_EXTERN gboolean game_mode_get_enabled (GameMode* self);
static GObject * game_mode_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void game_mode_finalize (GObject * obj);
static GType game_mode_get_type_once (void);
static void _vala_game_mode_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_game_mode_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
game_mode_get_instance_private (GameMode* self)
{
	return G_STRUCT_MEMBER_P (self, GameMode_private_offset);
}

static void
game_mode_load_proxy_data_free (gpointer _data)
{
	GameModeLoadProxyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GameModeLoadProxyData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
game_mode_load_proxy (GameMode* self,
                      GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	GameModeLoadProxyData* _data_;
	GameMode* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GameModeLoadProxyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, game_mode_load_proxy_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	game_mode_load_proxy_co (_data_);
}

static void
game_mode_load_proxy_finish (GameMode* self,
                             GAsyncResult* _res_)
{
	GameModeLoadProxyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
game_mode_load_proxy_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_)
{
	GameModeLoadProxyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	game_mode_load_proxy_co (_data_);
}

static void
_game_mode_update_from_portal_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                 GVariant* changed_properties,
                                                                 gchar** invalidated_properties,
                                                                 gpointer self)
{
	game_mode_update_from_portal ((GameMode*) self);
}

static void
_game_mode_update_from_service_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                                  GVariant* changed_properties,
                                                                  gchar** invalidated_properties,
                                                                  gpointer self)
{
	game_mode_update_from_service ((GameMode*) self);
}

static gboolean
game_mode_load_proxy_co (GameModeLoadProxyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_dbus_proxy_new_for_bus (G_BUS_TYPE_SESSION, G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START | G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, NULL, "org.freedesktop.portal.Desktop", "/org/freedesktop/portal/desktop", "org.freedesktop.portal.GameMode", NULL, game_mode_load_proxy_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = g_dbus_proxy_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->portal);
		_data_->self->priv->portal = _data_->_tmp2_;
		_data_->_state_ = 2;
		g_dbus_proxy_new_for_bus (G_BUS_TYPE_SESSION, G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START | G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, NULL, "com.feralinteractive.GameMode", "/com/feralinteractive/GameMode", "com.feralinteractive.GameMode", NULL, game_mode_load_proxy_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp4_ = g_dbus_proxy_new_for_bus_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->_tmp0_);
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_g_object_unref0 (_data_->self->priv->service);
		_data_->self->priv->service = _data_->_tmp5_;
		_g_object_unref0 (_data_->_tmp3_);
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->_error_;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("GameMode.vala:63: %s", _data_->_tmp7_);
		_g_error_free0 (_data_->_error_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->self->priv->portal;
	g_signal_connect_object (_data_->_tmp8_, "g-properties-changed", (GCallback) _game_mode_update_from_portal_g_dbus_proxy_g_properties_changed, _data_->self, 0);
	_data_->_tmp9_ = _data_->self->priv->service;
	g_signal_connect_object (_data_->_tmp9_, "g-properties-changed", (GCallback) _game_mode_update_from_service_g_dbus_proxy_g_properties_changed, _data_->self, 0);
	game_mode_update_from_portal (_data_->self);
	game_mode_update_from_service (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
game_mode_update_from_portal (GameMode* self)
{
	GVariant* active = NULL;
	GDBusProxy* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->portal;
	_tmp1_ = g_dbus_proxy_get_cached_property (_tmp0_, "Active");
	active = _tmp1_;
	_tmp2_ = active;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		_tmp3_ = active;
		game_mode_set_enabled (self, g_variant_get_boolean (_tmp3_));
	}
	_g_variant_unref0 (active);
}

static void
game_mode_update_from_service (GameMode* self)
{
	GVariant* count = NULL;
	GDBusProxy* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->service;
	_tmp1_ = g_dbus_proxy_get_cached_property (_tmp0_, "ClientCount");
	count = _tmp1_;
	_tmp2_ = count;
	if (_tmp2_ != NULL) {
		GVariant* _tmp3_;
		_tmp3_ = count;
		game_mode_set_enabled (self, g_variant_get_int32 (_tmp3_) > ((gint32) 0));
	}
	_g_variant_unref0 (count);
}

GameMode*
game_mode_construct (GType object_type)
{
	GameMode * self = NULL;
	self = (GameMode*) g_object_new (object_type, NULL);
	return self;
}

GameMode*
game_mode_new (void)
{
	return game_mode_construct (TYPE_GAME_MODE);
}

gboolean
game_mode_get_enabled (GameMode* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enabled;
	return result;
}

static void
game_mode_set_enabled (GameMode* self,
                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = game_mode_get_enabled (self);
	if (old_value != value) {
		self->priv->_enabled = value;
		g_object_notify_by_pspec ((GObject *) self, game_mode_properties[GAME_MODE_ENABLED_PROPERTY]);
	}
}

static GObject *
game_mode_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameMode * self;
	parent_class = G_OBJECT_CLASS (game_mode_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_MODE, GameMode);
	game_mode_load_proxy (self, NULL, NULL);
	return obj;
}

static void
game_mode_class_init (GameModeClass * klass,
                      gpointer klass_data)
{
	game_mode_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameMode_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_mode_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_mode_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_mode_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_mode_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_MODE_ENABLED_PROPERTY, game_mode_properties[GAME_MODE_ENABLED_PROPERTY] = g_param_spec_boolean ("enabled", "enabled", "enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
game_mode_instance_init (GameMode * self,
                         gpointer klass)
{
	self->priv = game_mode_get_instance_private (self);
	self->priv->_enabled = FALSE;
	self->priv->portal = NULL;
	self->priv->service = NULL;
}

static void
game_mode_finalize (GObject * obj)
{
	GameMode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_MODE, GameMode);
	_g_object_unref0 (self->priv->portal);
	_g_object_unref0 (self->priv->service);
	G_OBJECT_CLASS (game_mode_parent_class)->finalize (obj);
}

/**
 * I don't know how to get convenient property-changed signals from something
 * like the following... Please let me know if you know how.

[DBus (name = "com.feralinteractive.GameMode")]
interface GameModeInterface : Object {
  [DBus (name = "ClientCount")]
  public abstract int client_count {  get; }
}
*/
 G_GNUC_NO_INLINE static GType
game_mode_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameModeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_mode_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameMode), 0, (GInstanceInitFunc) game_mode_instance_init, NULL };
	GType game_mode_type_id;
	game_mode_type_id = g_type_register_static (G_TYPE_OBJECT, "GameMode", &g_define_type_info, 0);
	GameMode_private_offset = g_type_add_instance_private (game_mode_type_id, sizeof (GameModePrivate));
	return game_mode_type_id;
}

GType
game_mode_get_type (void)
{
	static gsize game_mode_type_id__once = 0;
	if (g_once_init_enter (&game_mode_type_id__once)) {
		GType game_mode_type_id;
		game_mode_type_id = game_mode_get_type_once ();
		g_once_init_leave (&game_mode_type_id__once, game_mode_type_id);
	}
	return game_mode_type_id__once;
}

static void
_vala_game_mode_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GameMode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_MODE, GameMode);
	switch (property_id) {
		case GAME_MODE_ENABLED_PROPERTY:
		g_value_set_boolean (value, game_mode_get_enabled (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_mode_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GameMode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_MODE, GameMode);
	switch (property_id) {
		case GAME_MODE_ENABLED_PROPERTY:
		game_mode_set_enabled (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

