/* ResticInstance.c generated by valac 0.56.14, the Vala compiler
 * generated from ResticInstance.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include "deja.h"

#define TYPE_TOOL_INSTANCE (tool_instance_get_type ())
#define TOOL_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOOL_INSTANCE, ToolInstance))
#define TOOL_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOOL_INSTANCE, ToolInstanceClass))
#define IS_TOOL_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOOL_INSTANCE))
#define IS_TOOL_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOOL_INSTANCE))
#define TOOL_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOOL_INSTANCE, ToolInstanceClass))

typedef struct _ToolInstance ToolInstance;
typedef struct _ToolInstanceClass ToolInstanceClass;
typedef struct _ToolInstancePrivate ToolInstancePrivate;

#define TYPE_RESTIC_INSTANCE (restic_instance_get_type ())
#define RESTIC_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTIC_INSTANCE, ResticInstance))
#define RESTIC_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTIC_INSTANCE, ResticInstanceClass))
#define IS_RESTIC_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTIC_INSTANCE))
#define IS_RESTIC_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTIC_INSTANCE))
#define RESTIC_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTIC_INSTANCE, ResticInstanceClass))

typedef struct _ResticInstance ResticInstance;
typedef struct _ResticInstanceClass ResticInstanceClass;
typedef struct _ResticInstancePrivate ResticInstancePrivate;
enum  {
	RESTIC_INSTANCE_0_PROPERTY,
	RESTIC_INSTANCE_NUM_PROPERTIES
};
static GParamSpec* restic_instance_properties[RESTIC_INSTANCE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
enum  {
	RESTIC_INSTANCE_MESSAGE_SIGNAL,
	RESTIC_INSTANCE_NO_REPOSITORY_SIGNAL,
	RESTIC_INSTANCE_BAD_PASSWORD_SIGNAL,
	RESTIC_INSTANCE_FATAL_ERROR_SIGNAL,
	RESTIC_INSTANCE_NUM_SIGNALS
};
static guint restic_instance_signals[RESTIC_INSTANCE_NUM_SIGNALS] = {0};

struct _ToolInstance {
	GObject parent_instance;
	ToolInstancePrivate * priv;
};

struct _ToolInstanceClass {
	GObjectClass parent_class;
	void (*_send_error) (ToolInstance* self, GError* e);
	gboolean (*_process_line) (ToolInstance* self, const gchar* stanza, const gchar* line, GError** error);
};

struct _ResticInstance {
	ToolInstance parent_instance;
	ResticInstancePrivate * priv;
};

struct _ResticInstanceClass {
	ToolInstanceClass parent_class;
};

static gpointer restic_instance_parent_class = NULL;

VALA_EXTERN GType tool_instance_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType restic_instance_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void _tool_instance_send_error (ToolInstance* self,
                                GError* e);
VALA_EXTERN gboolean _tool_instance_process_line (ToolInstance* self,
                                      const gchar* stanza,
                                      const gchar* line,
                                      GError** error);
static void restic_instance_real__send_error (ToolInstance* base,
                                       GError* e);
static gboolean restic_instance_real__process_line (ToolInstance* base,
                                             const gchar* stanza,
                                             const gchar* line,
                                             GError** error);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN ResticInstance* restic_instance_new (void);
VALA_EXTERN ResticInstance* restic_instance_construct (GType object_type);
VALA_EXTERN ToolInstance* tool_instance_construct (GType object_type);
static GType restic_instance_get_type_once (void);

static void
restic_instance_real__send_error (ToolInstance* base,
                                  GError* e)
{
	ResticInstance * self;
	const gchar* _tmp0_;
	self = (ResticInstance*) base;
	g_return_if_fail (e != NULL);
	_tmp0_ = e->message;
	g_signal_emit (self, restic_instance_signals[RESTIC_INSTANCE_FATAL_ERROR_SIGNAL], 0, _tmp0_);
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gboolean
restic_instance_real__process_line (ToolInstance* base,
                                    const gchar* stanza,
                                    const gchar* line,
                                    GError** error)
{
	ResticInstance * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean is_stanza = FALSE;
	JsonParser* parser = NULL;
	JsonParser* _tmp7_;
	JsonParser* _tmp8_;
	JsonNode* root = NULL;
	JsonParser* _tmp10_;
	JsonNode* _tmp11_;
	JsonNode* _tmp12_;
	JsonNode* _tmp13_;
	JsonReader* _tmp14_;
	JsonReader* _tmp15_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (ResticInstance*) base;
	g_return_val_if_fail (stanza != NULL, FALSE);
	g_return_val_if_fail (line != NULL, FALSE);
	if (g_str_has_prefix (line, "Fatal: unable to open config file: ")) {
		g_signal_emit (self, restic_instance_signals[RESTIC_INSTANCE_NO_REPOSITORY_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	if (g_strcmp0 (line, "Fatal: wrong password or no key found") == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = g_strcmp0 (line, "Fatal: an empty password is not a password") == 0;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (line, "Fatal: Fatal: an empty password is not a password") == 0;
	}
	if (_tmp0_) {
		g_signal_emit (self, restic_instance_signals[RESTIC_INSTANCE_BAD_PASSWORD_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	if (g_str_has_prefix (line, "Fatal: ")) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = string_substring (line, (glong) 7, (glong) -1);
		_tmp3_ = _tmp2_;
		g_signal_emit (self, restic_instance_signals[RESTIC_INSTANCE_FATAL_ERROR_SIGNAL], 0, _tmp3_);
		_g_free0 (_tmp3_);
		result = TRUE;
		return result;
	}
	if (g_str_has_prefix (line, "{")) {
		_tmp5_ = g_str_has_suffix (line, "}");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		if (g_str_has_prefix (line, "[")) {
			_tmp6_ = g_str_has_suffix (line, "]");
		} else {
			_tmp6_ = FALSE;
		}
		_tmp4_ = _tmp6_;
	}
	is_stanza = _tmp4_;
	if (!is_stanza) {
		result = TRUE;
		return result;
	}
	_tmp7_ = json_parser_new_immutable ();
	parser = _tmp7_;
	_tmp8_ = parser;
	json_parser_load_from_data (_tmp8_, stanza, (gssize) -1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		return _tmp9_;
	}
	_tmp10_ = parser;
	_tmp11_ = json_parser_get_root (_tmp10_);
	_tmp12_ = __vala_JsonNode_copy0 (_tmp11_);
	root = _tmp12_;
	_tmp13_ = root;
	_tmp14_ = json_reader_new (_tmp13_);
	_tmp15_ = _tmp14_;
	g_signal_emit (self, restic_instance_signals[RESTIC_INSTANCE_MESSAGE_SIGNAL], 0, _tmp15_);
	_g_object_unref0 (_tmp15_);
	result = TRUE;
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (parser);
	return result;
}

ResticInstance*
restic_instance_construct (GType object_type)
{
	ResticInstance * self = NULL;
	self = (ResticInstance*) tool_instance_construct (object_type);
	return self;
}

ResticInstance*
restic_instance_new (void)
{
	return restic_instance_construct (TYPE_RESTIC_INSTANCE);
}

static void
restic_instance_class_init (ResticInstanceClass * klass,
                            gpointer klass_data)
{
	restic_instance_parent_class = g_type_class_peek_parent (klass);
	((ToolInstanceClass *) klass)->_send_error = (void (*) (ToolInstance*, GError*)) restic_instance_real__send_error;
	((ToolInstanceClass *) klass)->_process_line = (gboolean (*) (ToolInstance*, const gchar*, const gchar*, GError**)) restic_instance_real__process_line;
	restic_instance_signals[RESTIC_INSTANCE_MESSAGE_SIGNAL] = g_signal_new ("message", TYPE_RESTIC_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, json_reader_get_type ());
	restic_instance_signals[RESTIC_INSTANCE_NO_REPOSITORY_SIGNAL] = g_signal_new ("no-repository", TYPE_RESTIC_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	restic_instance_signals[RESTIC_INSTANCE_BAD_PASSWORD_SIGNAL] = g_signal_new ("bad-password", TYPE_RESTIC_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	restic_instance_signals[RESTIC_INSTANCE_FATAL_ERROR_SIGNAL] = g_signal_new ("fatal-error", TYPE_RESTIC_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
restic_instance_instance_init (ResticInstance * self,
                               gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
restic_instance_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ResticInstanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) restic_instance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ResticInstance), 0, (GInstanceInitFunc) restic_instance_instance_init, NULL };
	GType restic_instance_type_id;
	restic_instance_type_id = g_type_register_static (TYPE_TOOL_INSTANCE, "ResticInstance", &g_define_type_info, 0);
	return restic_instance_type_id;
}

GType
restic_instance_get_type (void)
{
	static gsize restic_instance_type_id__once = 0;
	if (g_once_init_enter (&restic_instance_type_id__once)) {
		GType restic_instance_type_id;
		restic_instance_type_id = restic_instance_get_type_once ();
		g_once_init_leave (&restic_instance_type_id__once, restic_instance_type_id);
	}
	return restic_instance_type_id__once;
}

