/* DuplicityPlugin.c generated by valac 0.56.14, the Vala compiler
 * generated from DuplicityPlugin.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib-object.h>

#define DUPLICITY_PLUGIN_REQUIRED_MAJOR 0
#define DUPLICITY_PLUGIN_REQUIRED_MINOR 7
#define DUPLICITY_PLUGIN_REQUIRED_MICRO 14

enum  {
	DUPLICITY_PLUGIN_0_PROPERTY,
	DUPLICITY_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* duplicity_plugin_properties[DUPLICITY_PLUGIN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DUPLICITY_JOB (duplicity_job_get_type ())
#define DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICITY_JOB, DuplicityJob))
#define DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICITY_JOB, DuplicityJobClass))
#define IS_DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICITY_JOB))
#define IS_DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICITY_JOB))
#define DUPLICITY_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICITY_JOB, DuplicityJobClass))

typedef struct _DuplicityJob DuplicityJob;
typedef struct _DuplicityJobClass DuplicityJobClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DuplicityPluginPrivate {
	gboolean has_been_setup;
	gchar* version;
	gboolean supports_microsoft;
	gboolean version1_cli;
};

static gint DuplicityPlugin_private_offset;
static gpointer duplicity_plugin_parent_class = NULL;

static gchar** duplicity_plugin_real_get_dependencies (DejaDupToolPlugin* base,
                                                gint* result_length1);
static void duplicity_plugin_do_initial_setup (DuplicityPlugin* self,
                                        GError** error);
static gchar* duplicity_plugin_real_get_version (DejaDupToolPlugin* base,
                                          GError** error);
static DejaDupToolJob* duplicity_plugin_real_create_job (DejaDupToolPlugin* base,
                                                  GError** error);
VALA_EXTERN DuplicityJob* duplicity_job_new (gboolean version1_cli);
VALA_EXTERN DuplicityJob* duplicity_job_construct (GType object_type,
                                       gboolean version1_cli);
VALA_EXTERN GType duplicity_job_get_type (void) G_GNUC_CONST ;
static gboolean duplicity_plugin_real_supports_backend (DejaDupToolPlugin* base,
                                                 DejaDupBackendKind kind,
                                                 gchar** explanation);
static GObject * duplicity_plugin_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void duplicity_plugin_finalize (GObject * obj);
static GType duplicity_plugin_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
duplicity_plugin_get_instance_private (DuplicityPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, DuplicityPlugin_private_offset);
}

static gchar**
duplicity_plugin_real_get_dependencies (DejaDupToolPlugin* base,
                                        gint* result_length1)
{
	DuplicityPlugin * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (DuplicityPlugin*) base;
	_tmp1_ = _tmp0_ = g_strsplit (DUPLICITY_PACKAGES, ",", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
duplicity_plugin_do_initial_setup (DuplicityPlugin* self,
                                   GError** error)
{
	gchar* stderr = NULL;
	gchar* stdout = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** tokens = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean _tmp9_ = FALSE;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gint major = 0;
	gint minor = 0;
	gint micro = 0;
	const gchar* _tmp19_;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gboolean _tmp23_;
	gboolean _tmp35_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->has_been_setup) {
		return;
	}
	_tmp0_ = duplicity_plugin_duplicity_command ();
	_tmp1_ = g_strdup ("--version");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 2;
	g_spawn_sync (NULL, _tmp3_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp4_, &_tmp5_, NULL, &_inner_error0_);
	_g_free0 (stdout);
	stdout = _tmp4_;
	_g_free0 (stderr);
	stderr = _tmp5_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (stdout);
		_g_free0 (stderr);
		return;
	}
	_tmp6_ = stdout;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
	tokens = _tmp8_;
	tokens_length1 = _vala_array_length (_tmp7_);
	_tokens_size_ = tokens_length1;
	_tmp10_ = tokens;
	_tmp10__length1 = tokens_length1;
	if (_tmp10_ == NULL) {
		_tmp9_ = TRUE;
	} else {
		gchar** _tmp11_;
		gint _tmp11__length1;
		_tmp11_ = tokens;
		_tmp11__length1 = tokens_length1;
		_tmp9_ = _tmp11__length1 < 2;
	}
	if (_tmp9_) {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		_tmp12_ = stderr;
		_tmp13_ = stdout;
		g_warning ("DuplicityPlugin.vala:40: %s\n%s", _tmp12_, _tmp13_);
		_tmp14_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _ ("Could not understand duplicity version."));
		_inner_error0_ = _tmp14_;
		g_propagate_error (error, _inner_error0_);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stdout);
		_g_free0 (stderr);
		return;
	}
	_tmp15_ = tokens;
	_tmp15__length1 = tokens_length1;
	_tmp16_ = tokens;
	_tmp16__length1 = tokens_length1;
	_tmp17_ = _tmp15_[_tmp16__length1 - 1];
	_tmp18_ = string_strip (_tmp17_);
	_g_free0 (self->priv->version);
	self->priv->version = _tmp18_;
	_tmp19_ = self->priv->version;
	_tmp23_ = deja_dup_parse_version (_tmp19_, &_tmp20_, &_tmp21_, &_tmp22_);
	major = _tmp20_;
	minor = _tmp21_;
	micro = _tmp22_;
	if (!_tmp23_) {
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		GError* _tmp27_;
		GError* _tmp28_;
		_tmp24_ = self->priv->version;
		_tmp25_ = g_strdup_printf (_ ("Could not understand duplicity version ‘%s’."), _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp26_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		_inner_error0_ = _tmp28_;
		g_propagate_error (error, _inner_error0_);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stdout);
		_g_free0 (stderr);
		return;
	}
	if (!deja_dup_meets_version (major, minor, micro, DUPLICITY_PLUGIN_REQUIRED_MAJOR, DUPLICITY_PLUGIN_REQUIRED_MINOR, DUPLICITY_PLUGIN_REQUIRED_MICRO)) {
		gchar* msg = NULL;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GError* _tmp33_;
		GError* _tmp34_;
		_tmp29_ = g_strdup (_ ("Backups requires at least version %d.%d.%.2d of duplicity, " "but only found version %d.%d.%.2d"));
		msg = _tmp29_;
		_tmp30_ = msg;
		_tmp31_ = g_strdup_printf (_tmp30_, DUPLICITY_PLUGIN_REQUIRED_MAJOR, DUPLICITY_PLUGIN_REQUIRED_MINOR, DUPLICITY_PLUGIN_REQUIRED_MICRO, major, minor, micro);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp32_);
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp32_);
		_inner_error0_ = _tmp34_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stdout);
		_g_free0 (stderr);
		return;
	}
	if (deja_dup_equals_version (major, minor, micro, 0, 8, 18)) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = deja_dup_meets_version (major, minor, micro, 0, 8, 21);
	}
	self->priv->supports_microsoft = _tmp35_;
	self->priv->version1_cli = !deja_dup_meets_version (major, minor, micro, 2, 0, 0);
	self->priv->has_been_setup = TRUE;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (stdout);
	_g_free0 (stderr);
}

static gchar*
duplicity_plugin_real_get_version (DejaDupToolPlugin* base,
                                   GError** error)
{
	DuplicityPlugin * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (DuplicityPlugin*) base;
	duplicity_plugin_do_initial_setup (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = self->priv->version;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static DejaDupToolJob*
duplicity_plugin_real_create_job (DejaDupToolPlugin* base,
                                  GError** error)
{
	DuplicityPlugin * self;
	DuplicityJob* _tmp0_;
	GError* _inner_error0_ = NULL;
	DejaDupToolJob* result;
	self = (DuplicityPlugin*) base;
	duplicity_plugin_do_initial_setup (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = duplicity_job_new (self->priv->version1_cli);
	result = (DejaDupToolJob*) _tmp0_;
	return result;
}

static gboolean
duplicity_plugin_real_supports_backend (DejaDupToolPlugin* base,
                                        DejaDupBackendKind kind,
                                        gchar** explanation)
{
	DuplicityPlugin * self;
	gchar* _vala_explanation = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (DuplicityPlugin*) base;
	_g_free0 (_vala_explanation);
	_vala_explanation = NULL;
	{
		duplicity_plugin_do_initial_setup (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (_vala_explanation);
		_vala_explanation = _tmp2_;
		result = FALSE;
		_g_error_free0 (e);
		if (explanation) {
			*explanation = _vala_explanation;
		} else {
			_g_free0 (_vala_explanation);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		_g_free0 (_vala_explanation);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	switch (kind) {
		case DEJA_DUP_BACKEND_KIND_LOCAL:
		case DEJA_DUP_BACKEND_KIND_GVFS:
		case DEJA_DUP_BACKEND_KIND_GOOGLE:
		{
			result = TRUE;
			if (explanation) {
				*explanation = _vala_explanation;
			} else {
				_g_free0 (_vala_explanation);
			}
			return result;
		}
		case DEJA_DUP_BACKEND_KIND_MICROSOFT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("This storage location is not yet supported."));
			_g_free0 (_vala_explanation);
			_vala_explanation = _tmp4_;
			result = self->priv->supports_microsoft;
			if (explanation) {
				*explanation = _vala_explanation;
			} else {
				_g_free0 (_vala_explanation);
			}
			return result;
		}
		default:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("This storage location is no longer supported. You can still use " "duplicity directly to back up or restore your files."));
			_g_free0 (_vala_explanation);
			_vala_explanation = _tmp5_;
			result = FALSE;
			if (explanation) {
				*explanation = _vala_explanation;
			} else {
				_g_free0 (_vala_explanation);
			}
			return result;
		}
	}
}

gchar*
duplicity_plugin_duplicity_command (void)
{
	gchar* testing_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing_str = _tmp1_;
	_tmp3_ = testing_str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = testing_str;
		_tmp2_ = atoi (_tmp4_) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("duplicity");
		result = _tmp5_;
		_g_free0 (testing_str);
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (DUPLICITY_COMMAND);
		result = _tmp6_;
		_g_free0 (testing_str);
		return result;
	}
}

DuplicityPlugin*
duplicity_plugin_construct (GType object_type)
{
	DuplicityPlugin * self = NULL;
	self = (DuplicityPlugin*) deja_dup_tool_plugin_construct (object_type);
	return self;
}

DuplicityPlugin*
duplicity_plugin_new (void)
{
	return duplicity_plugin_construct (TYPE_DUPLICITY_PLUGIN);
}

static GObject *
duplicity_plugin_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DuplicityPlugin * self;
	parent_class = G_OBJECT_CLASS (duplicity_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_PLUGIN, DuplicityPlugin);
	deja_dup_tool_plugin_set_name ((DejaDupToolPlugin*) self, "duplicity");
	return obj;
}

static void
duplicity_plugin_class_init (DuplicityPluginClass * klass,
                             gpointer klass_data)
{
	duplicity_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DuplicityPlugin_private_offset);
	((DejaDupToolPluginClass *) klass)->get_dependencies = (gchar** (*) (DejaDupToolPlugin*, gint*)) duplicity_plugin_real_get_dependencies;
	((DejaDupToolPluginClass *) klass)->get_version = (gchar* (*) (DejaDupToolPlugin*, GError**)) duplicity_plugin_real_get_version;
	((DejaDupToolPluginClass *) klass)->create_job = (DejaDupToolJob* (*) (DejaDupToolPlugin*, GError**)) duplicity_plugin_real_create_job;
	((DejaDupToolPluginClass *) klass)->supports_backend = (gboolean (*) (DejaDupToolPlugin*, DejaDupBackendKind, gchar**)) duplicity_plugin_real_supports_backend;
	G_OBJECT_CLASS (klass)->constructor = duplicity_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = duplicity_plugin_finalize;
}

static void
duplicity_plugin_instance_init (DuplicityPlugin * self,
                                gpointer klass)
{
	self->priv = duplicity_plugin_get_instance_private (self);
	self->priv->has_been_setup = FALSE;
	self->priv->version = NULL;
	self->priv->supports_microsoft = FALSE;
	self->priv->version1_cli = FALSE;
}

static void
duplicity_plugin_finalize (GObject * obj)
{
	DuplicityPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_PLUGIN, DuplicityPlugin);
	_g_free0 (self->priv->version);
	G_OBJECT_CLASS (duplicity_plugin_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
duplicity_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DuplicityPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) duplicity_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DuplicityPlugin), 0, (GInstanceInitFunc) duplicity_plugin_instance_init, NULL };
	GType duplicity_plugin_type_id;
	duplicity_plugin_type_id = g_type_register_static (DEJA_DUP_TYPE_TOOL_PLUGIN, "DuplicityPlugin", &g_define_type_info, 0);
	DuplicityPlugin_private_offset = g_type_add_instance_private (duplicity_plugin_type_id, sizeof (DuplicityPluginPrivate));
	return duplicity_plugin_type_id;
}

GType
duplicity_plugin_get_type (void)
{
	static gsize duplicity_plugin_type_id__once = 0;
	if (g_once_init_enter (&duplicity_plugin_type_id__once)) {
		GType duplicity_plugin_type_id;
		duplicity_plugin_type_id = duplicity_plugin_get_type_once ();
		g_once_init_leave (&duplicity_plugin_type_id__once, duplicity_plugin_type_id);
	}
	return duplicity_plugin_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

