/* DuplicityJob.c generated by valac 0.56.14, the Vala compiler
 * generated from DuplicityJob.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <gpg-error.h>

#define DUPLICITY_JOB_MINIMUM_FULL 1
#define DUPLICITY_JOB_ERROR_GENERIC 1
#define DUPLICITY_JOB_ERROR_HOSTNAME_CHANGED 3
#define DUPLICITY_JOB_ERROR_RESTORE_DIR_NOT_FOUND 19
#define DUPLICITY_JOB_ERROR_EXCEPTION 30
#define DUPLICITY_JOB_ERROR_GPG 31
#define DUPLICITY_JOB_ERROR_BAD_VOLUME 44
#define DUPLICITY_JOB_ERROR_BACKEND 50
#define DUPLICITY_JOB_ERROR_BACKEND_PERMISSION_DENIED 51
#define DUPLICITY_JOB_ERROR_BACKEND_NOT_FOUND 52
#define DUPLICITY_JOB_ERROR_BACKEND_NO_SPACE 53
#define DUPLICITY_JOB_INFO_PROGRESS 2
#define DUPLICITY_JOB_INFO_COLLECTION_STATUS 3
#define DUPLICITY_JOB_INFO_DIFF_FILE_NEW 4
#define DUPLICITY_JOB_INFO_DIFF_FILE_CHANGED 5
#define DUPLICITY_JOB_INFO_DIFF_FILE_DELETED 6
#define DUPLICITY_JOB_INFO_PATCH_FILE_WRITING 7
#define DUPLICITY_JOB_INFO_PATCH_FILE_PATCHING 8
#define DUPLICITY_JOB_INFO_FILE_STAT 10
#define DUPLICITY_JOB_INFO_SYNCHRONOUS_UPLOAD_BEGIN 11
#define DUPLICITY_JOB_INFO_ASYNCHRONOUS_UPLOAD_BEGIN 12
#define DUPLICITY_JOB_INFO_SYNCHRONOUS_UPLOAD_DONE 13
#define DUPLICITY_JOB_INFO_ASYNCHRONOUS_UPLOAD_DONE 14
#define DUPLICITY_JOB_WARNING_ORPHANED_SIG 2
#define DUPLICITY_JOB_WARNING_UNNECESSARY_SIG 3
#define DUPLICITY_JOB_WARNING_UNMATCHED_SIG 4
#define DUPLICITY_JOB_WARNING_INCOMPLETE_BACKUP 5
#define DUPLICITY_JOB_WARNING_ORPHANED_BACKUP 6
#define DUPLICITY_JOB_WARNING_CANNOT_STAT 9
#define DUPLICITY_JOB_WARNING_CANNOT_READ 10
#define DUPLICITY_JOB_WARNING_CANNOT_PROCESS 12
#define DUPLICITY_JOB_DEBUG_GENERIC 1

#define TYPE_DUPLICITY_JOB (duplicity_job_get_type ())
#define DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICITY_JOB, DuplicityJob))
#define DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICITY_JOB, DuplicityJobClass))
#define IS_DUPLICITY_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICITY_JOB))
#define IS_DUPLICITY_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICITY_JOB))
#define DUPLICITY_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICITY_JOB, DuplicityJobClass))

typedef struct _DuplicityJob DuplicityJob;
typedef struct _DuplicityJobClass DuplicityJobClass;
typedef struct _DuplicityJobPrivate DuplicityJobPrivate;
typedef enum  {
	DUPLICITY_JOB_STATE_NOT_STARTED,
	DUPLICITY_JOB_STATE_NORMAL,
	DUPLICITY_JOB_STATE_DRY_RUN,
	DUPLICITY_JOB_STATE_STATUS,
	DUPLICITY_JOB_STATE_CLEANUP,
	DUPLICITY_JOB_STATE_DELETE
} DuplicityJobState;

#define DUPLICITY_JOB_TYPE_STATE (duplicity_job_state_get_type ())

#define TYPE_DUPLICITY_INSTANCE (duplicity_instance_get_type ())
#define DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUPLICITY_INSTANCE, DuplicityInstance))
#define DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUPLICITY_INSTANCE, DuplicityInstanceClass))
#define IS_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUPLICITY_INSTANCE))
#define IS_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUPLICITY_INSTANCE))
#define DUPLICITY_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUPLICITY_INSTANCE, DuplicityInstanceClass))

typedef struct _DuplicityInstance DuplicityInstance;
typedef struct _DuplicityInstanceClass DuplicityInstanceClass;

#define DUPLICITY_JOB_TYPE_DATE_INFO (duplicity_job_date_info_get_type ())
typedef struct _DuplicityJobDateInfo DuplicityJobDateInfo;
enum  {
	DUPLICITY_JOB_0_PROPERTY,
	DUPLICITY_JOB_VERSION1_CLI_PROPERTY,
	DUPLICITY_JOB_STATE_PROPERTY,
	DUPLICITY_JOB_NUM_PROPERTIES
};
static GParamSpec* duplicity_job_properties[DUPLICITY_JOB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DuplicityJobStartData DuplicityJobStartData;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _DuplicityJobReportFullBackupsData DuplicityJobReportFullBackupsData;
typedef struct _DuplicityJobCheckBackupSpaceData DuplicityJobCheckBackupSpaceData;
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_tree_unref0(var) ((var == NULL) ? NULL : (var = (g_tree_unref (var), NULL)))

struct _DuplicityJob {
	DejaDupToolJob parent_instance;
	DuplicityJobPrivate * priv;
};

struct _DuplicityJobClass {
	DejaDupToolJobClass parent_class;
	void (*process_error) (DuplicityJob* self, gchar** firstline, gint firstline_length1, GList* data, const gchar* text_in);
	void (*process_info) (DuplicityJob* self, gchar** firstline, gint firstline_length1, GList* data, const gchar* text);
	void (*process_warning) (DuplicityJob* self, gchar** firstline, gint firstline_length1, GList* data, const gchar* text);
};

struct _DuplicityJobDateInfo {
	gboolean full;
	GDateTime* time;
};

struct _DuplicityJobPrivate {
	gboolean _version1_cli;
	DejaDupToolJobMode _original_mode;
	gboolean _error_issued;
	gboolean _was_stopped;
	DuplicityJobState _state;
	DuplicityInstance* inst;
	GList* includes_argv;
	GList* saved_argv;
	GList* saved_envp;
	gboolean is_full_backup;
	gboolean cleaned_up_once;
	gboolean detected_encryption;
	gboolean existing_encrypted;
	gchar* last_bad_volume;
	guint bad_volume_count;
	gboolean has_progress_total;
	guint64 progress_total;
	guint64 progress_count;
	gboolean checked_collection_info;
	gboolean got_collection_info;
	GList* collection_info;
	gboolean reported_full_backups;
	gboolean checked_backup_space;
	gboolean deleted_files;
	gint delete_age;
	GFile* last_touched_file;
	gchar* forced_cache_dir;
	gchar* credentials_dir;
	gchar* saved_status;
	GFile* saved_status_file;
	gboolean saved_status_file_action;
	gboolean restarted_without_cache;
};

struct _DuplicityJobStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DuplicityJob* self;
	DejaDupToolJobMode _tmp0_;
	DejaDupToolJobMode _tmp1_;
	DejaDupToolJobMode _tmp2_;
	DejaDupToolJobMode _tmp3_;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp4_;
	DejaDupFilteredSettings* _tmp5_;
	DejaDupToolJobFlags _tmp6_;
	DejaDupToolJobFlags _tmp7_;
	gchar* template;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	DejaDupBackend* _tmp15_;
	DejaDupBackend* _tmp16_;
	GError* e;
	GError* _tmp17_;
	const gchar* _tmp18_;
	DejaDupToolJobMode _tmp19_;
	DejaDupToolJobMode _tmp20_;
	DejaDupToolJobMode _tmp21_;
	DejaDupToolJobMode _tmp22_;
	DejaDupBackend* _tmp23_;
	DejaDupBackend* _tmp24_;
	DejaDupBackend* _tmp25_;
	DejaDupBackend* _tmp26_;
	DejaDupNetwork* _tmp27_;
	DejaDupNetwork* _tmp28_;
	DejaDupNetwork* _tmp29_;
	DejaDupNetwork* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	GError* _inner_error0_;
};

struct _DuplicityJobReportFullBackupsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DuplicityJob* self;
	GDateTime* full_backup;
	GList* _tmp0_;
	GList* info_collection;
	GList* info_it;
	DuplicityJobDateInfo _tmp1_;
	DuplicityJobDateInfo _tmp2_;
	DuplicityJobDateInfo info;
	DuplicityJobDateInfo _tmp3_;
	DuplicityJobDateInfo _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	gboolean first_backup;
	GDateTime* _tmp7_;
	GDateTime* threshold;
	GDateTime* _tmp8_;
	gboolean _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GDateTime* _tmp12_;
	gboolean _tmp13_;
	DejaDupToolJobMode _tmp14_;
	DejaDupToolJobMode _tmp15_;
};

struct _DuplicityJobCheckBackupSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DuplicityJob* self;
	gint full_dates;
	GList* _tmp0_;
	GList* info_collection;
	GList* info_it;
	DuplicityJobDateInfo _tmp1_;
	DuplicityJobDateInfo _tmp2_;
	DuplicityJobDateInfo info;
	DuplicityJobDateInfo _tmp3_;
	gint _tmp4_;
	gboolean first_backup;
	guint64 initial_required_space;
	guint64 free;
	DejaDupBackend* _tmp5_;
	DejaDupBackend* _tmp6_;
	guint64 total;
	DejaDupBackend* _tmp7_;
	DejaDupBackend* _tmp8_;
	gboolean _tmp9_;
	gchar* msg;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	guint64 _tmp17_;
	guint64 required_free_space;
	gchar* _vala1_msg;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
};

static gint DuplicityJob_private_offset;
static gpointer duplicity_job_parent_class = NULL;
static GFile* duplicity_job_slash;
static GFile* duplicity_job_slash = NULL;

VALA_EXTERN GType duplicity_job_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType duplicity_job_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType duplicity_instance_get_type (void) G_GNUC_CONST ;
static GType duplicity_job_date_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static DuplicityJobDateInfo* duplicity_job_date_info_dup (const DuplicityJobDateInfo* self);
static void duplicity_job_date_info_free (DuplicityJobDateInfo* self);
static void duplicity_job_date_info_copy (const DuplicityJobDateInfo* self,
                                   DuplicityJobDateInfo* dest);
static void duplicity_job_date_info_destroy (DuplicityJobDateInfo* self);
VALA_EXTERN void duplicity_job_process_error (DuplicityJob* self,
                                  gchar** firstline,
                                  gint firstline_length1,
                                  GList* data,
                                  const gchar* text_in);
VALA_EXTERN void duplicity_job_process_info (DuplicityJob* self,
                                 gchar** firstline,
                                 gint firstline_length1,
                                 GList* data,
                                 const gchar* text);
VALA_EXTERN void duplicity_job_process_warning (DuplicityJob* self,
                                    gchar** firstline,
                                    gint firstline_length1,
                                    GList* data,
                                    const gchar* text);
static void duplicity_job_network_changed (DuplicityJob* self);
static void _duplicity_job_network_changed_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self);
static void duplicity_job_clean_credentials_dir (DuplicityJob* self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void _duplicity_job_date_info_free0_ (gpointer var);
static inline void _g_list_free__duplicity_job_date_info_free0_ (GList* self);
VALA_EXTERN DuplicityJob* duplicity_job_new (gboolean version1_cli);
VALA_EXTERN DuplicityJob* duplicity_job_construct (GType object_type,
                                       gboolean version1_cli);
static void duplicity_job_real_start_data_free (gpointer _data);
static void duplicity_job_real_start (DejaDupToolJob* base,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static gboolean duplicity_job_real_start_co (DuplicityJobStartData* _data_);
static DejaDupToolJobMode duplicity_job_get_original_mode (DuplicityJob* self);
static void duplicity_job_set_original_mode (DuplicityJob* self,
                                      DejaDupToolJobMode value);
static void duplicity_job_start_ready (GObject* source_object,
                                GAsyncResult* _res_,
                                gpointer _user_data_);
static void duplicity_job_fill_envp_from_backend (DuplicityJob* self,
                                           GError** error);
static void duplicity_job_process_include_excludes (DuplicityJob* self);
static gboolean duplicity_job_restart (DuplicityJob* self);
static gint duplicity_job_cmp_prefix (DuplicityJob* self,
                               GFile* a,
                               GFile* b);
static void duplicity_job_fill_envp_from_google (DuplicityJob* self,
                                          DejaDupBackendGoogle* google_backend,
                                          GError** error);
static void duplicity_job_fill_envp_from_microsoft (DuplicityJob* self,
                                             DejaDupBackendMicrosoft* microsoft_backend);
static gchar* duplicity_job_get_remote (DuplicityJob* self);
VALA_EXTERN GFile* deja_dup_backend_file_get_file_from_settings (DejaDupBackendFile* self);
VALA_EXTERN gchar* deja_dup_backend_microsoft_get_folder (DejaDupBackendMicrosoft* self);
static gchar* duplicity_job_escape_duplicity_path (DuplicityJob* self,
                                            const gchar* path);
static gchar* duplicity_job_prefix_local (DuplicityJob* self,
                                   const gchar* path);
VALA_EXTERN void deja_dup_expand_links_in_list (GList** all,
                                    gboolean keep_internal);
static void duplicity_job_real_cancel (DejaDupToolJob* base);
VALA_EXTERN DuplicityJobState duplicity_job_get_state (DuplicityJob* self);
static gboolean duplicity_job_cleanup (DuplicityJob* self);
static void duplicity_job_cancel_inst (DuplicityJob* self);
static void duplicity_job_real_stop (DejaDupToolJob* base);
static void duplicity_job_set_was_stopped (DuplicityJob* self,
                                    gboolean value);
static void duplicity_job_real_pause (DejaDupToolJob* base,
                               const gchar* reason);
VALA_EXTERN void duplicity_instance_pause (DuplicityInstance* self);
static void duplicity_job_set_status (DuplicityJob* self,
                               const gchar* msg,
                               gboolean save);
static void duplicity_job_real_resume (DejaDupToolJob* base);
VALA_EXTERN void duplicity_instance_resume (DuplicityInstance* self);
static void duplicity_job_set_saved_status (DuplicityJob* self);
static void duplicity_job_disconnect_inst (DuplicityJob* self);
static void duplicity_job_handle_done (DuplicityJob* self,
                                DuplicityInstance* inst,
                                gboolean success,
                                gboolean cancelled);
VALA_EXTERN void duplicity_job_set_state (DuplicityJob* self,
                              DuplicityJobState value);
static void duplicity_job_report_full_backups (DuplicityJob* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void duplicity_job_report_full_backups_finish (DuplicityJob* self,
                                               GAsyncResult* _res_);
static void duplicity_job_check_backup_space (DuplicityJob* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
static void duplicity_job_check_backup_space_finish (DuplicityJob* self,
                                              GAsyncResult* _res_);
static void duplicity_job_delete_cache (DuplicityJob* self,
                                 GRegex* only);
static GFile* duplicity_job_make_local_rel_path (DuplicityJob* self,
                                          GFile* file);
static void duplicity_job_show_error (DuplicityJob* self,
                               const gchar* errorstr,
                               const gchar* detail);
VALA_EXTERN gboolean duplicity_job_get_version1_cli (DuplicityJob* self);
static void duplicity_job_connect_and_start (DuplicityJob* self,
                                      GList* argv_extra,
                                      GList* envp_extra,
                                      GList* argv_entire,
                                      GFile* custom_local);
static void duplicity_job_report_full_backups_data_free (gpointer _data);
static gboolean duplicity_job_report_full_backups_co (DuplicityJobReportFullBackupsData* _data_);
static void duplicity_job_check_backup_space_data_free (gpointer _data);
static gboolean duplicity_job_check_backup_space_co (DuplicityJobCheckBackupSpaceData* _data_);
static void duplicity_job_check_backup_space_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
static void duplicity_job_delete_excess (DuplicityJob* self,
                                  gint cutoff);
static gboolean duplicity_job_can_ignore_error (DuplicityJob* self);
static gboolean duplicity_job_delete_files_if_needed (DuplicityJob* self);
static gboolean duplicity_job_get_was_stopped (DuplicityJob* self);
static gboolean duplicity_job_get_error_issued (DuplicityJob* self);
static void duplicity_job_set_status_file (DuplicityJob* self,
                                    GFile* file,
                                    gboolean action,
                                    gboolean save);
static gboolean duplicity_job_restart_without_cache (DuplicityJob* self);
static void duplicity_job_handle_exit (DuplicityJob* self,
                                gint code);
static void duplicity_job_handle_message (DuplicityJob* self,
                                   DuplicityInstance* inst,
                                   gchar** control_line,
                                   gint control_line_length1,
                                   GList* data_lines,
                                   const gchar* user_text);
static gboolean duplicity_job_ask_question (DuplicityJob* self,
                                     const gchar* t,
                                     const gchar* m);
static gchar* duplicity_job_parse_duplicity_file (DuplicityJob* self,
                                           const gchar* file,
                                           gint skip_bits);
static void duplicity_job_report_encryption_error (DuplicityJob* self);
static gboolean duplicity_job_check_encryption_error (DuplicityJob* self,
                                               const gchar* text);
static void duplicity_job_real_process_error (DuplicityJob* self,
                                       gchar** firstline,
                                       gint firstline_length1,
                                       GList* data,
                                       const gchar* text_in);
static void duplicity_job_process_exception (DuplicityJob* self,
                                      const gchar* exception,
                                      const gchar* text);
static GFile* duplicity_job_make_file_obj (DuplicityJob* self,
                                    const gchar* file);
static void duplicity_job_real_process_info (DuplicityJob* self,
                                      gchar** firstline,
                                      gint firstline_length1,
                                      GList* data,
                                      const gchar* text);
static void duplicity_job_process_diff_file (DuplicityJob* self,
                                      const gchar* file);
static void duplicity_job_process_patch_file (DuplicityJob* self,
                                       const gchar* file);
static void duplicity_job_process_progress (DuplicityJob* self,
                                     gchar** firstline,
                                     gint firstline_length1);
static void duplicity_job_process_collection_status (DuplicityJob* self,
                                              GList* lines);
static void duplicity_job_process_file_stat (DuplicityJob* self,
                                      const gchar* date,
                                      const gchar* file,
                                      const gchar* dup_type,
                                      GList* data,
                                      const gchar* text);
static gint __lambda18_ (DuplicityJob* self,
                  GDateTime* a,
                  GDateTime* b);
static gint ___lambda18__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static void _g_date_time_unref0_ (gpointer var);
static gboolean duplicity_job_is_file_in_list (DuplicityJob* self,
                                        GFile* file,
                                        GList* list);
static gboolean duplicity_job_is_file_in_or_under_list (DuplicityJob* self,
                                                 GFile* file,
                                                 GList* list);
static void duplicity_job_real_process_warning (DuplicityJob* self,
                                         gchar** firstline,
                                         gint firstline_length1,
                                         GList* data,
                                         const gchar* text);
static void duplicity_job_set_error_issued (DuplicityJob* self,
                                     gboolean value);
static gint duplicity_job_get_volsize (DuplicityJob* self);
static void _duplicity_job_handle_done_duplicity_instance_done (DuplicityInstance* _sender,
                                                         gboolean success,
                                                         gboolean cancelled,
                                                         gpointer self);
static void _duplicity_job_handle_message_duplicity_instance_message (DuplicityInstance* _sender,
                                                               gchar** control_line,
                                                               gint control_line_length1,
                                                               GList* data_lines,
                                                               const gchar* user_text,
                                                               gpointer self);
static void _duplicity_job_handle_exit_duplicity_instance_exited (DuplicityInstance* _sender,
                                                           gint code,
                                                           gpointer self);
VALA_EXTERN void duplicity_instance_cancel (DuplicityInstance* self);
VALA_EXTERN DuplicityInstance* duplicity_instance_new (void);
VALA_EXTERN DuplicityInstance* duplicity_instance_construct (GType object_type);
VALA_EXTERN void duplicity_instance_set_forced_cache_dir (DuplicityInstance* self,
                                              const gchar* value);
VALA_EXTERN void duplicity_instance_start (DuplicityInstance* self,
                               GList* argv_in,
                               GList* envp_in,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN void duplicity_instance_start_finish (DuplicityInstance* self,
                                      GAsyncResult* _res_);
static void duplicity_job_set_version1_cli (DuplicityJob* self,
                                     gboolean value);
static GObject * duplicity_job_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void duplicity_job_finalize (GObject * obj);
static GType duplicity_job_get_type_once (void);
static void _vala_duplicity_job_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_duplicity_job_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
duplicity_job_get_instance_private (DuplicityJob* self)
{
	return G_STRUCT_MEMBER_P (self, DuplicityJob_private_offset);
}

static void
_duplicity_job_network_changed_g_object_notify (GObject* _sender,
                                                GParamSpec* pspec,
                                                gpointer self)
{
	duplicity_job_network_changed ((DuplicityJob*) self);
}

 G_GNUC_NO_INLINE static GType
duplicity_job_state_get_type_once (void)
{
	static const GEnumValue values[] = {{DUPLICITY_JOB_STATE_NOT_STARTED, "DUPLICITY_JOB_STATE_NOT_STARTED", "not-started"}, {DUPLICITY_JOB_STATE_NORMAL, "DUPLICITY_JOB_STATE_NORMAL", "normal"}, {DUPLICITY_JOB_STATE_DRY_RUN, "DUPLICITY_JOB_STATE_DRY_RUN", "dry-run"}, {DUPLICITY_JOB_STATE_STATUS, "DUPLICITY_JOB_STATE_STATUS", "status"}, {DUPLICITY_JOB_STATE_CLEANUP, "DUPLICITY_JOB_STATE_CLEANUP", "cleanup"}, {DUPLICITY_JOB_STATE_DELETE, "DUPLICITY_JOB_STATE_DELETE", "delete"}, {0, NULL, NULL}};
	GType duplicity_job_state_type_id;
	duplicity_job_state_type_id = g_enum_register_static ("DuplicityJobState", values);
	return duplicity_job_state_type_id;
}

GType
duplicity_job_state_get_type (void)
{
	static gsize duplicity_job_state_type_id__once = 0;
	if (g_once_init_enter (&duplicity_job_state_type_id__once)) {
		GType duplicity_job_state_type_id;
		duplicity_job_state_type_id = duplicity_job_state_get_type_once ();
		g_once_init_leave (&duplicity_job_state_type_id__once, duplicity_job_state_type_id);
	}
	return duplicity_job_state_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
_duplicity_job_date_info_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (duplicity_job_date_info_free (var), NULL));
}

static inline void
_g_list_free__duplicity_job_date_info_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _duplicity_job_date_info_free0_);
}

static void
duplicity_job_network_changed (DuplicityJob* self)
{
	DejaDupNetwork* _tmp0_;
	DejaDupNetwork* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_network_get_connected (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	if (_tmp4_) {
		deja_dup_tool_job_resume ((DejaDupToolJob*) self);
	} else {
		deja_dup_tool_job_pause ((DejaDupToolJob*) self, _ ("Paused (no network)"));
	}
}

DuplicityJob*
duplicity_job_construct (GType object_type,
                         gboolean version1_cli)
{
	DuplicityJob * self = NULL;
	self = (DuplicityJob*) g_object_new (object_type, "version1-cli", version1_cli, NULL);
	return self;
}

DuplicityJob*
duplicity_job_new (gboolean version1_cli)
{
	return duplicity_job_construct (TYPE_DUPLICITY_JOB, version1_cli);
}

static void
duplicity_job_clean_credentials_dir (DuplicityJob* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->credentials_dir;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp1_ = self->priv->credentials_dir;
		_tmp2_ = g_strdup_printf ("%s/settings.yaml", _tmp1_);
		_tmp3_ = _tmp2_;
		g_remove (_tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = self->priv->credentials_dir;
		_tmp5_ = g_strdup_printf ("%s/credentials.json", _tmp4_);
		_tmp6_ = _tmp5_;
		g_remove (_tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = self->priv->credentials_dir;
		g_remove (_tmp7_);
		_g_free0 (self->priv->credentials_dir);
		self->priv->credentials_dir = NULL;
	}
}

static void
duplicity_job_real_start_data_free (gpointer _data)
{
	DuplicityJobStartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DuplicityJobStartData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
duplicity_job_real_start (DejaDupToolJob* base,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	DuplicityJob * self;
	DuplicityJobStartData* _data_;
	DuplicityJob* _tmp0_;
	self = (DuplicityJob*) base;
	_data_ = g_slice_new0 (DuplicityJobStartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, duplicity_job_real_start_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	duplicity_job_real_start_co (_data_);
}

static void
duplicity_job_start_finish (DejaDupToolJob* base,
                            GAsyncResult* _res_)
{
	DuplicityJobStartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
duplicity_job_start_ready (GObject* source_object,
                           GAsyncResult* _res_,
                           gpointer _user_data_)
{
	DuplicityJobStartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	duplicity_job_real_start_co (_data_);
}

static gboolean
duplicity_job_real_start_co (DuplicityJobStartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_original_mode;
	if (_data_->_tmp0_ == DEJA_DUP_TOOL_JOB_MODE_INVALID) {
		_data_->_tmp1_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) _data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		duplicity_job_set_original_mode (_data_->self, _data_->_tmp2_);
	}
	_data_->_tmp3_ = _data_->self->priv->_original_mode;
	deja_dup_tool_job_set_mode ((DejaDupToolJob*) _data_->self, _data_->_tmp3_);
	(_data_->self->priv->includes_argv == NULL) ? NULL : (_data_->self->priv->includes_argv = (_g_list_free__g_free0_ (_data_->self->priv->includes_argv), NULL));
	_data_->self->priv->includes_argv = NULL;
	(_data_->self->priv->saved_argv == NULL) ? NULL : (_data_->self->priv->saved_argv = (_g_list_free__g_free0_ (_data_->self->priv->saved_argv), NULL));
	_data_->self->priv->saved_argv = NULL;
	(_data_->self->priv->saved_envp == NULL) ? NULL : (_data_->self->priv->saved_envp = (_g_list_free__g_free0_ (_data_->self->priv->saved_envp), NULL));
	_data_->self->priv->saved_envp = NULL;
	_data_->_tmp4_ = deja_dup_get_settings (NULL);
	_data_->settings = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->settings;
	_data_->self->priv->delete_age = g_settings_get_int ((GSettings*) _data_->_tmp5_, DEJA_DUP_DELETE_AFTER_KEY);
	_data_->_tmp6_ = deja_dup_tool_job_get_flags ((DejaDupToolJob*) _data_->self);
	_data_->_tmp7_ = _data_->_tmp6_;
	if ((_data_->_tmp7_ & DEJA_DUP_TOOL_JOB_FLAGS_NO_CACHE) != 0) {
		_data_->_state_ = 1;
		deja_dup_get_tempdir (duplicity_job_start_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp8_ = deja_dup_get_tempdir_finish (_data_->_res_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp10_ = g_build_filename (_data_->_tmp9_, "duplicity-XXXXXX", NULL);
		_data_->_tmp11_ = _data_->_tmp10_;
		_g_free0 (_data_->_tmp9_);
		_data_->template = _data_->_tmp11_;
		_data_->_tmp12_ = _data_->template;
		_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
		_data_->_tmp14_ = mkdtemp (_data_->_tmp13_);
		_g_free0 (_data_->self->priv->forced_cache_dir);
		_data_->self->priv->forced_cache_dir = _data_->_tmp14_;
		_g_free0 (_data_->template);
	}
	{
		_data_->_tmp15_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) _data_->self);
		_data_->_tmp16_ = _data_->_tmp15_;
		_data_->_state_ = 2;
		deja_dup_backend_prepare (_data_->_tmp16_, duplicity_job_start_ready, _data_);
		return FALSE;
		_state_2:
		deja_dup_backend_prepare_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		duplicity_job_fill_envp_from_backend (_data_->self, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp17_ = _data_->e;
		_data_->_tmp18_ = _data_->_tmp17_->message;
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "raise-error", _data_->_tmp18_, NULL);
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE);
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->settings);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp19_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	if (_data_->_tmp20_ == DEJA_DUP_TOOL_JOB_MODE_INVALID) {
		_g_object_unref0 (_data_->settings);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp21_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) _data_->self);
	_data_->_tmp22_ = _data_->_tmp21_;
	if (_data_->_tmp22_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		_data_->_tmp23_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) _data_->self);
		_data_->_tmp24_ = _data_->_tmp23_;
		deja_dup_backend_add_excludes (_data_->_tmp24_, &((DejaDupToolJob*) _data_->self)->excludes);
		duplicity_job_process_include_excludes (_data_->self);
	}
	if (!duplicity_job_restart (_data_->self)) {
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE);
	}
	_data_->_tmp25_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) _data_->self);
	_data_->_tmp26_ = _data_->_tmp25_;
	if (!deja_dup_backend_is_native (_data_->_tmp26_)) {
		_data_->_tmp27_ = deja_dup_network_get ();
		_data_->_tmp28_ = _data_->_tmp27_;
		g_signal_connect_object ((GObject*) _data_->_tmp28_, "notify::connected", (GCallback) _duplicity_job_network_changed_g_object_notify, _data_->self, 0);
		_g_object_unref0 (_data_->_tmp28_);
		_data_->_tmp29_ = deja_dup_network_get ();
		_data_->_tmp30_ = _data_->_tmp29_;
		_data_->_tmp31_ = deja_dup_network_get_connected (_data_->_tmp30_);
		_data_->_tmp32_ = _data_->_tmp31_;
		_data_->_tmp33_ = !_data_->_tmp32_;
		_g_object_unref0 (_data_->_tmp30_);
		if (_data_->_tmp33_) {
			g_debug ("DuplicityJob.vala:145: No connection found. Postponing the backup.");
			deja_dup_tool_job_pause ((DejaDupToolJob*) _data_->self, _ ("Paused (no network)"));
		}
	}
	_g_object_unref0 (_data_->settings);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gint
duplicity_job_cmp_prefix (DuplicityJob* self,
                          GFile* a,
                          GFile* b)
{
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (a == NULL) {
		_tmp0_ = b == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	} else {
		gboolean _tmp1_ = FALSE;
		if (b == NULL) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = g_file_has_prefix (a, b);
		}
		if (_tmp1_) {
			result = -1;
			return result;
		} else {
			gboolean _tmp2_ = FALSE;
			if (a == NULL) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = g_file_has_prefix (b, a);
			}
			if (_tmp2_) {
				result = 1;
				return result;
			} else {
				result = 0;
				return result;
			}
		}
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
duplicity_job_fill_envp_from_google (DuplicityJob* self,
                                     DejaDupBackendGoogle* google_backend,
                                     GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* yaml_path = NULL;
	gchar* _tmp3_;
	GBytes* yaml_bytes = NULL;
	const gchar* _tmp4_;
	GBytes* _tmp5_;
	gchar* yaml = NULL;
	GBytes* _tmp6_;
	gsize _tmp7_ = 0;
	guint8* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* json_path = NULL;
	gchar* _tmp19_;
	GBytes* json_bytes = NULL;
	const gchar* _tmp20_;
	GBytes* _tmp21_;
	gchar* json = NULL;
	GBytes* _tmp22_;
	gsize _tmp23_ = 0;
	guint8* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (google_backend != NULL);
	duplicity_job_clean_credentials_dir (self);
	_tmp1_ = g_dir_make_tmp ("deja-dup-XXXXXX", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_free0 (self->priv->credentials_dir);
	self->priv->credentials_dir = _tmp2_;
	_tmp3_ = g_strdup ("/org/gnome/DejaDup/pydrive-settings.yaml");
	yaml_path = _tmp3_;
	_tmp4_ = yaml_path;
	_tmp5_ = g_resources_lookup_data (_tmp4_, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
	yaml_bytes = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (yaml_path);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp6_ = yaml_bytes;
	_tmp8_ = g_bytes_get_data (_tmp6_, &_tmp7_);
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	yaml = _tmp9_;
	_tmp10_ = yaml;
	_tmp11_ = string_replace (_tmp10_, "$CLIENT_ID", GOOGLE_CLIENT_ID);
	_g_free0 (yaml);
	yaml = _tmp11_;
	_tmp12_ = yaml;
	_tmp13_ = self->priv->credentials_dir;
	_tmp14_ = string_replace (_tmp12_, "$PATH", _tmp13_);
	_g_free0 (yaml);
	yaml = _tmp14_;
	_tmp15_ = self->priv->credentials_dir;
	_tmp16_ = g_strdup_printf ("%s/settings.yaml", _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = yaml;
	g_file_set_contents (_tmp17_, _tmp18_, (gssize) -1, &_inner_error0_);
	_g_free0 (_tmp17_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (yaml);
		_g_bytes_unref0 (yaml_bytes);
		_g_free0 (yaml_path);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp19_ = g_strdup ("/org/gnome/DejaDup/pydrive-credentials.json");
	json_path = _tmp19_;
	_tmp20_ = json_path;
	_tmp21_ = g_resources_lookup_data (_tmp20_, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
	json_bytes = _tmp21_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (json_path);
		_g_free0 (yaml);
		_g_bytes_unref0 (yaml_bytes);
		_g_free0 (yaml_path);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp22_ = json_bytes;
	_tmp24_ = g_bytes_get_data (_tmp22_, &_tmp23_);
	_tmp25_ = g_strdup ((const gchar*) _tmp24_);
	json = _tmp25_;
	_tmp26_ = json;
	_tmp27_ = string_replace (_tmp26_, "$CLIENT_ID", GOOGLE_CLIENT_ID);
	_g_free0 (json);
	json = _tmp27_;
	_tmp28_ = json;
	_tmp29_ = deja_dup_backend_oauth_get_access_token ((DejaDupBackendOAuth*) google_backend);
	_tmp30_ = _tmp29_;
	_tmp31_ = string_replace (_tmp28_, "$ACCESS_TOKEN", _tmp30_);
	_g_free0 (json);
	json = _tmp31_;
	_tmp32_ = json;
	_tmp33_ = deja_dup_backend_oauth_get_refresh_token ((DejaDupBackendOAuth*) google_backend);
	_tmp34_ = _tmp33_;
	_tmp35_ = string_replace (_tmp32_, "$REFRESH_TOKEN", _tmp34_);
	_g_free0 (json);
	json = _tmp35_;
	_tmp36_ = self->priv->credentials_dir;
	_tmp37_ = g_strdup_printf ("%s/credentials.json", _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = json;
	g_file_set_contents (_tmp38_, _tmp39_, (gssize) -1, &_inner_error0_);
	_g_free0 (_tmp38_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (json);
		_g_bytes_unref0 (json_bytes);
		_g_free0 (json_path);
		_g_free0 (yaml);
		_g_bytes_unref0 (yaml_bytes);
		_g_free0 (yaml_path);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp40_ = self->priv->credentials_dir;
	_tmp41_ = g_strdup_printf ("GOOGLE_DRIVE_SETTINGS=%s/settings.yaml", _tmp40_);
	self->priv->saved_envp = g_list_append (self->priv->saved_envp, _tmp41_);
	_g_free0 (json);
	_g_bytes_unref0 (json_bytes);
	_g_free0 (json_path);
	_g_free0 (yaml);
	_g_bytes_unref0 (yaml_bytes);
	_g_free0 (yaml_path);
	_g_free0 (_tmp0_);
}

static void
duplicity_job_fill_envp_from_microsoft (DuplicityJob* self,
                                        DejaDupBackendMicrosoft* microsoft_backend)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (microsoft_backend != NULL);
	_tmp0_ = g_strdup_printf ("DUPLICITY_ONEDRIVE_CLIENT_ID=%s", MICROSOFT_CLIENT_ID);
	self->priv->saved_envp = g_list_append (self->priv->saved_envp, _tmp0_);
	_tmp1_ = g_strdup_printf ("OAUTH2_CLIENT_ID=%s", MICROSOFT_CLIENT_ID);
	self->priv->saved_envp = g_list_append (self->priv->saved_envp, _tmp1_);
	_tmp2_ = deja_dup_backend_oauth_get_refresh_token ((DejaDupBackendOAuth*) microsoft_backend);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("OAUTH2_REFRESH_TOKEN=%s", _tmp3_);
	self->priv->saved_envp = g_list_append (self->priv->saved_envp, _tmp4_);
}

static void
duplicity_job_fill_envp_from_backend (DuplicityJob* self,
                                      GError** error)
{
	DejaDupBackendGoogle* google_backend = NULL;
	DejaDupBackend* _tmp0_;
	DejaDupBackend* _tmp1_;
	DejaDupBackendGoogle* _tmp2_;
	DejaDupBackendGoogle* _tmp3_;
	DejaDupBackendMicrosoft* microsoft_backend = NULL;
	DejaDupBackend* _tmp5_;
	DejaDupBackend* _tmp6_;
	DejaDupBackendMicrosoft* _tmp7_;
	DejaDupBackendMicrosoft* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_GOOGLE (_tmp1_) ? ((DejaDupBackendGoogle*) _tmp1_) : NULL);
	google_backend = _tmp2_;
	_tmp3_ = google_backend;
	if (_tmp3_ != NULL) {
		DejaDupBackendGoogle* _tmp4_;
		_tmp4_ = google_backend;
		duplicity_job_fill_envp_from_google (self, _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (google_backend);
			return;
		}
	}
	_tmp5_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_MICROSOFT (_tmp6_) ? ((DejaDupBackendMicrosoft*) _tmp6_) : NULL);
	microsoft_backend = _tmp7_;
	_tmp8_ = microsoft_backend;
	if (_tmp8_ != NULL) {
		DejaDupBackendMicrosoft* _tmp9_;
		_tmp9_ = microsoft_backend;
		duplicity_job_fill_envp_from_microsoft (self, _tmp9_);
	}
	_g_object_unref0 (microsoft_backend);
	_g_object_unref0 (google_backend);
}

static gchar*
duplicity_job_get_remote (DuplicityJob* self)
{
	DejaDupBackendFile* file_backend = NULL;
	DejaDupBackend* _tmp0_;
	DejaDupBackend* _tmp1_;
	DejaDupBackendFile* _tmp2_;
	DejaDupBackendFile* _tmp3_;
	DejaDupBackendGoogle* google_backend = NULL;
	DejaDupBackend* _tmp12_;
	DejaDupBackend* _tmp13_;
	DejaDupBackendGoogle* _tmp14_;
	DejaDupBackendGoogle* _tmp15_;
	DejaDupBackendMicrosoft* microsoft_backend = NULL;
	DejaDupBackend* _tmp21_;
	DejaDupBackend* _tmp22_;
	DejaDupBackendMicrosoft* _tmp23_;
	DejaDupBackendMicrosoft* _tmp24_;
	gchar* _tmp30_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_FILE (_tmp1_) ? ((DejaDupBackendFile*) _tmp1_) : NULL);
	file_backend = _tmp2_;
	_tmp3_ = file_backend;
	if (_tmp3_ != NULL) {
		GFile* file = NULL;
		DejaDupBackendFile* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp4_ = file_backend;
		_tmp5_ = deja_dup_backend_file_get_file_from_settings (_tmp4_);
		file = _tmp5_;
		_tmp6_ = file;
		if (_tmp6_ != NULL) {
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp7_ = file;
			_tmp8_ = g_file_get_uri (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat ("gio+", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			result = _tmp11_;
			_g_object_unref0 (file);
			_g_object_unref0 (file_backend);
			return result;
		}
		_g_object_unref0 (file);
	}
	_tmp12_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_GOOGLE (_tmp13_) ? ((DejaDupBackendGoogle*) _tmp13_) : NULL);
	google_backend = _tmp14_;
	_tmp15_ = google_backend;
	if (_tmp15_ != NULL) {
		DejaDupBackendGoogle* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = google_backend;
		_tmp17_ = deja_dup_backend_google_get_folder (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strdup_printf ("pydrive://google/%s", _tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		result = _tmp20_;
		_g_object_unref0 (google_backend);
		_g_object_unref0 (file_backend);
		return result;
	}
	_tmp21_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
	_tmp22_ = _tmp21_;
	_tmp23_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_MICROSOFT (_tmp22_) ? ((DejaDupBackendMicrosoft*) _tmp22_) : NULL);
	microsoft_backend = _tmp23_;
	_tmp24_ = microsoft_backend;
	if (_tmp24_ != NULL) {
		DejaDupBackendMicrosoft* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp25_ = microsoft_backend;
		_tmp26_ = deja_dup_backend_microsoft_get_folder (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf ("onedrive://%s", _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		result = _tmp29_;
		_g_object_unref0 (microsoft_backend);
		_g_object_unref0 (google_backend);
		_g_object_unref0 (file_backend);
		return result;
	}
	_tmp30_ = g_strdup ("invalid://");
	result = _tmp30_;
	_g_object_unref0 (microsoft_backend);
	_g_object_unref0 (google_backend);
	_g_object_unref0 (file_backend);
	return result;
}

static gchar*
duplicity_job_escape_duplicity_path (DuplicityJob* self,
                                     const gchar* path)
{
	gchar* rv = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = string_replace (path, "[", "[[]");
	_g_free0 (rv);
	rv = _tmp0_;
	_tmp1_ = rv;
	_tmp2_ = string_replace (_tmp1_, "?", "[?]");
	_g_free0 (rv);
	rv = _tmp2_;
	_tmp3_ = rv;
	_tmp4_ = string_replace (_tmp3_, "*", "[*]");
	_g_free0 (rv);
	rv = _tmp4_;
	result = rv;
	return result;
}

static gchar*
duplicity_job_prefix_local (DuplicityJob* self,
                            const gchar* path)
{
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	if (g_strcmp0 (path, "/") == 0) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_file_get_path (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_get_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (_tmp6_, path, NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	result = _tmp8_;
	return result;
}

static void
duplicity_job_process_include_excludes (DuplicityJob* self)
{
	GList* _tmp0_;
	GList* _tmp10_;
	GList* excludes2 = NULL;
	GList* _tmp16_;
	GList* _tmp17_;
	GList* _tmp18_;
	GList* _tmp42_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	GList* _tmp55_;
	GList* _tmp56_;
	g_return_if_fail (self != NULL);
	deja_dup_expand_links_in_list (&((DejaDupToolJob*) self)->includes, TRUE);
	deja_dup_expand_links_in_list (&((DejaDupToolJob*) self)->includes_priority, TRUE);
	deja_dup_expand_links_in_list (&((DejaDupToolJob*) self)->excludes, FALSE);
	((DejaDupToolJob*) self)->includes = g_list_sort (((DejaDupToolJob*) self)->includes, (GCompareFunc) duplicity_job_cmp_prefix);
	((DejaDupToolJob*) self)->excludes = g_list_sort (((DejaDupToolJob*) self)->excludes, (GCompareFunc) duplicity_job_cmp_prefix);
	_tmp0_ = ((DejaDupToolJob*) self)->includes_priority;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp0_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			GFile* _tmp1_;
			GFile* i = NULL;
			_tmp1_ = _g_object_ref0 ((GFile*) i_it->data);
			i = _tmp1_;
			{
				GFile* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp2_ = i;
				_tmp3_ = g_file_get_path (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = duplicity_job_prefix_local (self, _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = duplicity_job_escape_duplicity_path (self, _tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strconcat ("--include=", _tmp8_, NULL);
				self->priv->includes_argv = g_list_append (self->priv->includes_argv, _tmp9_);
				_g_free0 (_tmp8_);
				_g_free0 (_tmp6_);
				_g_free0 (_tmp4_);
				_g_object_unref0 (i);
			}
		}
	}
	_tmp10_ = ((DejaDupToolJob*) self)->exclude_regexps;
	{
		GList* r_collection = NULL;
		GList* r_it = NULL;
		r_collection = _tmp10_;
		for (r_it = r_collection; r_it != NULL; r_it = r_it->next) {
			gchar* _tmp11_;
			gchar* r = NULL;
			_tmp11_ = g_strdup ((const gchar*) r_it->data);
			r = _tmp11_;
			{
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = r;
				_tmp13_ = duplicity_job_prefix_local (self, _tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strconcat ("--exclude=", _tmp14_, NULL);
				self->priv->includes_argv = g_list_append (self->priv->includes_argv, _tmp15_);
				_g_free0 (_tmp14_);
				_g_free0 (r);
			}
		}
	}
	_tmp16_ = ((DejaDupToolJob*) self)->excludes;
	_tmp17_ = g_list_copy (_tmp16_);
	excludes2 = _tmp17_;
	_tmp18_ = ((DejaDupToolJob*) self)->includes;
	{
		GList* i_collection = NULL;
		GList* i_it = NULL;
		i_collection = _tmp18_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			GFile* _tmp19_;
			GFile* i = NULL;
			_tmp19_ = _g_object_ref0 ((GFile*) i_it->data);
			i = _tmp19_;
			{
				GList* _tmp20_;
				GList* _tmp21_;
				GFile* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp20_ = excludes2;
				_tmp21_ = g_list_copy (_tmp20_);
				{
					GList* e_collection = NULL;
					GList* e_it = NULL;
					e_collection = _tmp21_;
					for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
						GFile* _tmp22_;
						GFile* e = NULL;
						_tmp22_ = _g_object_ref0 ((GFile*) e_it->data);
						e = _tmp22_;
						{
							GFile* _tmp23_;
							GFile* _tmp24_;
							_tmp23_ = e;
							_tmp24_ = i;
							if (g_file_has_prefix (_tmp23_, _tmp24_)) {
								GFile* _tmp25_;
								gchar* _tmp26_;
								gchar* _tmp27_;
								gchar* _tmp28_;
								gchar* _tmp29_;
								gchar* _tmp30_;
								gchar* _tmp31_;
								gchar* _tmp32_;
								GFile* _tmp33_;
								_tmp25_ = e;
								_tmp26_ = g_file_get_path (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = duplicity_job_prefix_local (self, _tmp27_);
								_tmp29_ = _tmp28_;
								_tmp30_ = duplicity_job_escape_duplicity_path (self, _tmp29_);
								_tmp31_ = _tmp30_;
								_tmp32_ = g_strconcat ("--exclude=", _tmp31_, NULL);
								self->priv->includes_argv = g_list_append (self->priv->includes_argv, _tmp32_);
								_g_free0 (_tmp31_);
								_g_free0 (_tmp29_);
								_g_free0 (_tmp27_);
								_tmp33_ = e;
								excludes2 = g_list_remove (excludes2, _tmp33_);
							}
							_g_object_unref0 (e);
						}
					}
					(e_collection == NULL) ? NULL : (e_collection = (g_list_free (e_collection), NULL));
				}
				_tmp34_ = i;
				_tmp35_ = g_file_get_path (_tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = duplicity_job_prefix_local (self, _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = duplicity_job_escape_duplicity_path (self, _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = g_strconcat ("--include=", _tmp40_, NULL);
				self->priv->includes_argv = g_list_append (self->priv->includes_argv, _tmp41_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp36_);
				_g_object_unref0 (i);
			}
		}
	}
	_tmp42_ = excludes2;
	{
		GList* e_collection = NULL;
		GList* e_it = NULL;
		e_collection = _tmp42_;
		for (e_it = e_collection; e_it != NULL; e_it = e_it->next) {
			GFile* _tmp43_;
			GFile* e = NULL;
			_tmp43_ = _g_object_ref0 ((GFile*) e_it->data);
			e = _tmp43_;
			{
				GFile* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				_tmp44_ = e;
				_tmp45_ = g_file_get_path (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = duplicity_job_prefix_local (self, _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = duplicity_job_escape_duplicity_path (self, _tmp48_);
				_tmp50_ = _tmp49_;
				_tmp51_ = g_strconcat ("--exclude=", _tmp50_, NULL);
				self->priv->includes_argv = g_list_append (self->priv->includes_argv, _tmp51_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				_g_object_unref0 (e);
			}
		}
	}
	_tmp52_ = g_strdup ("--exclude=**");
	self->priv->includes_argv = g_list_append (self->priv->includes_argv, _tmp52_);
	_tmp53_ = g_strdup ("--exclude-if-present=CACHEDIR.TAG");
	self->priv->includes_argv = g_list_append (self->priv->includes_argv, _tmp53_);
	_tmp54_ = g_strdup ("--exclude-if-present=.deja-dup-ignore");
	self->priv->includes_argv = g_list_append (self->priv->includes_argv, _tmp54_);
	_tmp55_ = ((DejaDupToolJob*) self)->includes_priority;
	_tmp56_ = g_list_copy_deep (_tmp55_, (GCopyFunc) g_object_ref, NULL);
	((DejaDupToolJob*) self)->includes = g_list_concat (((DejaDupToolJob*) self)->includes, _tmp56_);
	(excludes2 == NULL) ? NULL : (excludes2 = (g_list_free (excludes2), NULL));
}

static void
duplicity_job_real_cancel (DejaDupToolJob* base)
{
	DuplicityJob * self;
	DejaDupToolJobMode prev_mode = 0;
	DejaDupToolJobMode _tmp0_;
	DejaDupToolJobMode _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (DuplicityJob*) base;
	_tmp0_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	prev_mode = _tmp1_;
	deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_INVALID);
	if (prev_mode == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
		DuplicityJobState _tmp3_;
		_tmp3_ = self->priv->_state;
		_tmp2_ = _tmp3_ == DUPLICITY_JOB_STATE_NORMAL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		if (duplicity_job_cleanup (self)) {
			return;
		}
	}
	duplicity_job_cancel_inst (self);
}

static void
duplicity_job_real_stop (DejaDupToolJob* base)
{
	DuplicityJob * self;
	self = (DuplicityJob*) base;
	duplicity_job_set_was_stopped (self, TRUE);
	deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_INVALID);
	duplicity_job_cancel_inst (self);
}

static void
duplicity_job_real_pause (DejaDupToolJob* base,
                          const gchar* reason)
{
	DuplicityJob * self;
	DuplicityInstance* _tmp0_;
	self = (DuplicityJob*) base;
	_tmp0_ = self->priv->inst;
	if (_tmp0_ != NULL) {
		DuplicityInstance* _tmp1_;
		_tmp1_ = self->priv->inst;
		duplicity_instance_pause (_tmp1_);
		if (reason != NULL) {
			duplicity_job_set_status (self, reason, FALSE);
		}
	}
}

static void
duplicity_job_real_resume (DejaDupToolJob* base)
{
	DuplicityJob * self;
	DuplicityInstance* _tmp0_;
	self = (DuplicityJob*) base;
	_tmp0_ = self->priv->inst;
	if (_tmp0_ != NULL) {
		DuplicityInstance* _tmp1_;
		_tmp1_ = self->priv->inst;
		duplicity_instance_resume (_tmp1_);
		duplicity_job_set_saved_status (self);
	}
}

static void
duplicity_job_cancel_inst (DuplicityJob* self)
{
	g_return_if_fail (self != NULL);
	duplicity_job_disconnect_inst (self);
	duplicity_job_handle_done (self, NULL, FALSE, TRUE);
}

static gboolean
duplicity_job_restart (DuplicityJob* self)
{
	DejaDupToolJobMode _tmp0_;
	DejaDupToolJobMode _tmp1_;
	GList* extra_argv = NULL;
	gchar* action_desc = NULL;
	GFile* custom_local = NULL;
	DejaDupToolJobMode _tmp2_;
	const gchar* _tmp74_;
	const gchar* _tmp78_;
	GList* _tmp79_;
	GFile* _tmp80_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	duplicity_job_set_state (self, DUPLICITY_JOB_STATE_NORMAL);
	_tmp0_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == DEJA_DUP_TOOL_JOB_MODE_INVALID) {
		result = FALSE;
		return result;
	}
	extra_argv = NULL;
	action_desc = NULL;
	custom_local = NULL;
	_tmp2_ = self->priv->_original_mode;
	switch (_tmp2_) {
		case DEJA_DUP_TOOL_JOB_MODE_BACKUP:
		{
			deja_dup_tool_job_set_tag ((DejaDupToolJob*) self, "now");
			if (!self->priv->checked_collection_info) {
				gchar* _tmp3_;
				deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_STATUS);
				duplicity_job_set_state (self, DUPLICITY_JOB_STATE_STATUS);
				_tmp3_ = g_strdup (_ ("Preparing…"));
				_g_free0 (action_desc);
				action_desc = _tmp3_;
			} else {
				gboolean _tmp4_ = FALSE;
				if (!self->priv->reported_full_backups) {
					_tmp4_ = self->priv->got_collection_info;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					duplicity_job_report_full_backups (self, NULL, NULL);
					result = TRUE;
					_g_object_unref0 (custom_local);
					_g_free0 (action_desc);
					(extra_argv == NULL) ? NULL : (extra_argv = (_g_list_free__g_free0_ (extra_argv), NULL));
					return result;
				} else {
					gboolean _tmp5_ = FALSE;
					DejaDupToolJobFlags _tmp6_;
					DejaDupToolJobFlags _tmp7_;
					_tmp6_ = deja_dup_tool_job_get_flags ((DejaDupToolJob*) self);
					_tmp7_ = _tmp6_;
					if ((_tmp7_ & DEJA_DUP_TOOL_JOB_FLAGS_NO_PROGRESS) == 0) {
						_tmp5_ = !self->priv->has_progress_total;
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						gchar* _tmp8_;
						gchar* _tmp9_;
						duplicity_job_set_state (self, DUPLICITY_JOB_STATE_DRY_RUN);
						_tmp8_ = g_strdup (_ ("Preparing…"));
						_g_free0 (action_desc);
						action_desc = _tmp8_;
						_tmp9_ = g_strdup ("--dry-run");
						extra_argv = g_list_append (extra_argv, _tmp9_);
					} else {
						if (!self->priv->checked_backup_space) {
							duplicity_job_check_backup_space (self, NULL, NULL);
							result = TRUE;
							_g_object_unref0 (custom_local);
							_g_free0 (action_desc);
							(extra_argv == NULL) ? NULL : (extra_argv = (_g_list_free__g_free0_ (extra_argv), NULL));
							return result;
						} else {
							if (self->priv->has_progress_total) {
								g_signal_emit_by_name ((DejaDupToolJob*) self, "progress", (gdouble) 0.f);
							}
							if (self->priv->is_full_backup) {
								{
									GRegex* _tmp10_ = NULL;
									GRegex* _tmp11_;
									_tmp11_ = g_regex_new ("^duplicity-full\\..*\\.manifest$", 0, 0, &_inner_error0_);
									_tmp10_ = _tmp11_;
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										goto __catch0_g_error;
									}
									duplicity_job_delete_cache (self, _tmp10_);
									_g_regex_unref0 (_tmp10_);
								}
								goto __finally0;
								__catch0_g_error:
								{
									GError* e = NULL;
									GError* _tmp12_;
									const gchar* _tmp13_;
									e = _inner_error0_;
									_inner_error0_ = NULL;
									_tmp12_ = e;
									_tmp13_ = _tmp12_->message;
									g_warning ("DuplicityJob.vala:411: %s\n", _tmp13_);
									_g_error_free0 (e);
								}
								__finally0:
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									gboolean _tmp14_ = FALSE;
									_g_object_unref0 (custom_local);
									_g_free0 (action_desc);
									(extra_argv == NULL) ? NULL : (extra_argv = (_g_list_free__g_free0_ (extra_argv), NULL));
									g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
									g_clear_error (&_inner_error0_);
									return _tmp14_;
								}
							}
						}
					}
				}
			}
			break;
		}
		case DEJA_DUP_TOOL_JOB_MODE_RESTORE:
		{
			if (!self->priv->checked_collection_info) {
				gchar* _tmp15_;
				deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_STATUS);
				duplicity_job_set_state (self, DUPLICITY_JOB_STATE_STATUS);
				_tmp15_ = g_strdup (_ ("Preparing…"));
				_g_free0 (action_desc);
				action_desc = _tmp15_;
			} else {
				gboolean _tmp16_ = FALSE;
				DejaDupFileTree* _tmp17_;
				DejaDupFileTree* _tmp18_;
				GList* _tmp37_;
				GList* _tmp38_;
				_tmp17_ = deja_dup_tool_job_get_tree ((DejaDupToolJob*) self);
				_tmp18_ = _tmp17_;
				if (_tmp18_ != NULL) {
					DejaDupFileTree* _tmp19_;
					DejaDupFileTree* _tmp20_;
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					_tmp19_ = deja_dup_tool_job_get_tree ((DejaDupToolJob*) self);
					_tmp20_ = _tmp19_;
					_tmp21_ = deja_dup_file_tree_get_old_home (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp16_ = _tmp22_ != NULL;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					GFile* old_home = NULL;
					DejaDupFileTree* _tmp23_;
					DejaDupFileTree* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					GFile* _tmp27_;
					GFile* new_home = NULL;
					const gchar* _tmp28_;
					GFile* _tmp29_;
					gchar* _tmp30_;
					GFile* _tmp31_;
					GFile* _tmp32_;
					gchar* _tmp33_;
					GFile* _tmp34_;
					GFile* _tmp35_;
					gchar* _tmp36_;
					_tmp23_ = deja_dup_tool_job_get_tree ((DejaDupToolJob*) self);
					_tmp24_ = _tmp23_;
					_tmp25_ = deja_dup_file_tree_get_old_home (_tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_file_new_for_path (_tmp26_);
					old_home = _tmp27_;
					_tmp28_ = g_get_home_dir ();
					_tmp29_ = g_file_new_for_path (_tmp28_);
					new_home = _tmp29_;
					_tmp30_ = g_strdup ("--rename");
					extra_argv = g_list_append (extra_argv, _tmp30_);
					_tmp31_ = duplicity_job_slash;
					_tmp32_ = old_home;
					_tmp33_ = g_file_get_relative_path (_tmp31_, _tmp32_);
					extra_argv = g_list_append (extra_argv, _tmp33_);
					_tmp34_ = duplicity_job_slash;
					_tmp35_ = new_home;
					_tmp36_ = g_file_get_relative_path (_tmp34_, _tmp35_);
					extra_argv = g_list_append (extra_argv, _tmp36_);
					_g_object_unref0 (new_home);
					_g_object_unref0 (old_home);
				}
				_tmp37_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
				_tmp38_ = _tmp37_;
				if (_tmp38_ != NULL) {
					GFile* local_file = NULL;
					GList* _tmp39_;
					GList* _tmp40_;
					gconstpointer _tmp41_;
					GFile* _tmp42_;
					GFile* _tmp49_;
					GFile* _tmp50_;
					GFile* target_file = NULL;
					GList* _tmp51_;
					GList* _tmp52_;
					gconstpointer _tmp53_;
					GFile* _tmp54_;
					DejaDupFileTree* _tmp55_;
					DejaDupFileTree* _tmp56_;
					gchar* rel_file_path = NULL;
					GFile* _tmp66_;
					GFile* _tmp67_;
					gchar* _tmp68_;
					gboolean _tmp69_;
					_tmp39_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
					_tmp40_ = _tmp39_;
					_tmp41_ = _tmp40_->data;
					_tmp42_ = duplicity_job_make_local_rel_path (self, (GFile*) _tmp41_);
					local_file = _tmp42_;
					{
						GFile* _tmp43_;
						GFile* _tmp44_;
						GFile* _tmp45_;
						_tmp43_ = local_file;
						_tmp44_ = g_file_get_parent (_tmp43_);
						_tmp45_ = _tmp44_;
						g_file_make_directory_with_parents (_tmp45_, NULL, &_inner_error0_);
						_g_object_unref0 (_tmp45_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
								goto __catch1_g_io_error_exists;
							}
							goto __catch1_g_error;
						}
					}
					goto __finally1;
					__catch1_g_io_error_exists:
					{
						g_clear_error (&_inner_error0_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* e = NULL;
						GError* _tmp46_;
						const gchar* _tmp47_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp46_ = e;
						_tmp47_ = _tmp46_->message;
						duplicity_job_show_error (self, _tmp47_, NULL);
						result = FALSE;
						_g_error_free0 (e);
						_g_object_unref0 (local_file);
						_g_object_unref0 (custom_local);
						_g_free0 (action_desc);
						(extra_argv == NULL) ? NULL : (extra_argv = (_g_list_free__g_free0_ (extra_argv), NULL));
						return result;
					}
					__finally1:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp48_ = FALSE;
						_g_object_unref0 (local_file);
						_g_object_unref0 (custom_local);
						_g_free0 (action_desc);
						(extra_argv == NULL) ? NULL : (extra_argv = (_g_list_free__g_free0_ (extra_argv), NULL));
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp48_;
					}
					_tmp49_ = local_file;
					_tmp50_ = _g_object_ref0 (_tmp49_);
					_g_object_unref0 (custom_local);
					custom_local = _tmp50_;
					_tmp51_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
					_tmp52_ = _tmp51_;
					_tmp53_ = _tmp52_->data;
					_tmp54_ = _g_object_ref0 ((GFile*) _tmp53_);
					target_file = _tmp54_;
					_tmp55_ = deja_dup_tool_job_get_tree ((DejaDupToolJob*) self);
					_tmp56_ = _tmp55_;
					if (_tmp56_ != NULL) {
						gchar* translated_path = NULL;
						DejaDupFileTree* _tmp57_;
						DejaDupFileTree* _tmp58_;
						GFile* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						const gchar* _tmp64_;
						GFile* _tmp65_;
						_tmp57_ = deja_dup_tool_job_get_tree ((DejaDupToolJob*) self);
						_tmp58_ = _tmp57_;
						_tmp59_ = target_file;
						_tmp60_ = g_file_get_path (_tmp59_);
						_tmp61_ = _tmp60_;
						_tmp62_ = deja_dup_file_tree_original_path (_tmp58_, _tmp61_);
						_tmp63_ = _tmp62_;
						_g_free0 (_tmp61_);
						translated_path = _tmp63_;
						_tmp64_ = translated_path;
						_tmp65_ = g_file_new_for_path (_tmp64_);
						_g_object_unref0 (target_file);
						target_file = _tmp65_;
						_g_free0 (translated_path);
					}
					_tmp66_ = duplicity_job_slash;
					_tmp67_ = target_file;
					_tmp68_ = g_file_get_relative_path (_tmp66_, _tmp67_);
					rel_file_path = _tmp68_;
					_tmp69_ = self->priv->_version1_cli;
					if (_tmp69_) {
						const gchar* _tmp70_;
						gchar* _tmp71_;
						_tmp70_ = rel_file_path;
						_tmp71_ = g_strdup_printf ("--file-to-restore=%s", _tmp70_);
						extra_argv = g_list_append (extra_argv, _tmp71_);
					} else {
						const gchar* _tmp72_;
						gchar* _tmp73_;
						_tmp72_ = rel_file_path;
						_tmp73_ = g_strdup_printf ("--path-to-restore=%s", _tmp72_);
						extra_argv = g_list_append (extra_argv, _tmp73_);
					}
					_g_free0 (rel_file_path);
					_g_object_unref0 (target_file);
					_g_object_unref0 (local_file);
				}
				g_signal_emit_by_name ((DejaDupToolJob*) self, "progress", (gdouble) 0.f);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp74_ = action_desc;
	if (_tmp74_ == NULL) {
		DejaDupToolJobMode _tmp75_;
		DejaDupToolJobMode _tmp76_;
		gchar* _tmp77_;
		_tmp75_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
		_tmp76_ = _tmp75_;
		_tmp77_ = deja_dup_operation_mode_to_string (_tmp76_);
		_g_free0 (action_desc);
		action_desc = _tmp77_;
	}
	_tmp78_ = action_desc;
	duplicity_job_set_status (self, _tmp78_, TRUE);
	_tmp79_ = extra_argv;
	_tmp80_ = custom_local;
	duplicity_job_connect_and_start (self, _tmp79_, NULL, NULL, _tmp80_);
	result = TRUE;
	_g_object_unref0 (custom_local);
	_g_free0 (action_desc);
	(extra_argv == NULL) ? NULL : (extra_argv = (_g_list_free__g_free0_ (extra_argv), NULL));
	return result;
}

static GFile*
duplicity_job_make_local_rel_path (DuplicityJob* self,
                                   GFile* file)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_parent (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ == NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		GFile* _tmp5_;
		_tmp5_ = _g_object_ref0 (file);
		result = _tmp5_;
		return result;
	} else {
		GFile* _tmp6_;
		GFile* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp6_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_file_get_basename (file);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_get_child (_tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		result = _tmp11_;
		return result;
	}
}

static void
duplicity_job_report_full_backups_data_free (gpointer _data)
{
	DuplicityJobReportFullBackupsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DuplicityJobReportFullBackupsData, _data_);
}

static void
duplicity_job_report_full_backups (DuplicityJob* self,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	DuplicityJobReportFullBackupsData* _data_;
	DuplicityJob* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DuplicityJobReportFullBackupsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, duplicity_job_report_full_backups_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	duplicity_job_report_full_backups_co (_data_);
}

static void
duplicity_job_report_full_backups_finish (DuplicityJob* self,
                                          GAsyncResult* _res_)
{
	DuplicityJobReportFullBackupsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gboolean
duplicity_job_report_full_backups_co (DuplicityJobReportFullBackupsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->full_backup = NULL;
	_data_->_tmp0_ = _data_->self->priv->collection_info;
	{
		_data_->info_collection = _data_->_tmp0_;
		for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
			_data_->_tmp1_ = *((DuplicityJobDateInfo*) _data_->info_it->data);
			memset (&_data_->_tmp2_, 0, sizeof (DuplicityJobDateInfo));
			duplicity_job_date_info_copy (&_data_->_tmp1_, &_data_->_tmp2_);
			_data_->info = _data_->_tmp2_;
			{
				_data_->_tmp3_ = _data_->info;
				if (_data_->_tmp3_.full) {
					_data_->_tmp4_ = _data_->info;
					_data_->_tmp5_ = _data_->_tmp4_.time;
					_data_->_tmp6_ = _g_date_time_ref0 (_data_->_tmp5_);
					_g_date_time_unref0 (_data_->full_backup);
					_data_->full_backup = _data_->_tmp6_;
				}
				duplicity_job_date_info_destroy (&_data_->info);
			}
		}
	}
	_data_->_tmp7_ = _data_->full_backup;
	_data_->first_backup = _data_->_tmp7_ == NULL;
	_data_->self->priv->reported_full_backups = TRUE;
	_data_->_tmp8_ = deja_dup_get_full_backup_threshold_date ();
	_data_->threshold = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->full_backup;
	if (_data_->_tmp10_ == NULL) {
		_data_->_tmp9_ = TRUE;
	} else {
		_data_->_tmp11_ = _data_->threshold;
		_data_->_tmp12_ = _data_->full_backup;
		_data_->_tmp9_ = g_date_time_compare (_data_->_tmp11_, _data_->_tmp12_) > 0;
	}
	if (_data_->_tmp9_) {
		_data_->self->priv->is_full_backup = TRUE;
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "is-full", _data_->first_backup);
	}
	_data_->_tmp14_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) _data_->self);
	_data_->_tmp15_ = _data_->_tmp14_;
	if (_data_->_tmp15_ != DEJA_DUP_TOOL_JOB_MODE_INVALID) {
		_data_->_tmp13_ = !duplicity_job_restart (_data_->self);
	} else {
		_data_->_tmp13_ = FALSE;
	}
	if (_data_->_tmp13_) {
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE);
	}
	_g_date_time_unref0 (_data_->threshold);
	_g_date_time_unref0 (_data_->full_backup);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
duplicity_job_check_backup_space_data_free (gpointer _data)
{
	DuplicityJobCheckBackupSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DuplicityJobCheckBackupSpaceData, _data_);
}

static void
duplicity_job_check_backup_space (DuplicityJob* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	DuplicityJobCheckBackupSpaceData* _data_;
	DuplicityJob* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DuplicityJobCheckBackupSpaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, duplicity_job_check_backup_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	duplicity_job_check_backup_space_co (_data_);
}

static void
duplicity_job_check_backup_space_finish (DuplicityJob* self,
                                         GAsyncResult* _res_)
{
	DuplicityJobCheckBackupSpaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
duplicity_job_check_backup_space_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	DuplicityJobCheckBackupSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	duplicity_job_check_backup_space_co (_data_);
}

static gboolean
duplicity_job_check_backup_space_co (DuplicityJobCheckBackupSpaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->self->priv->checked_backup_space = TRUE;
	if (!_data_->self->priv->has_progress_total) {
		if (!duplicity_job_restart (_data_->self)) {
			g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE);
		}
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->full_dates = 0;
	_data_->_tmp0_ = _data_->self->priv->collection_info;
	{
		_data_->info_collection = _data_->_tmp0_;
		for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
			_data_->_tmp1_ = *((DuplicityJobDateInfo*) _data_->info_it->data);
			memset (&_data_->_tmp2_, 0, sizeof (DuplicityJobDateInfo));
			duplicity_job_date_info_copy (&_data_->_tmp1_, &_data_->_tmp2_);
			_data_->info = _data_->_tmp2_;
			{
				_data_->_tmp3_ = _data_->info;
				if (_data_->_tmp3_.full) {
					_data_->full_dates = _data_->full_dates + 1;
					_data_->_tmp4_ = _data_->full_dates;
				}
				duplicity_job_date_info_destroy (&_data_->info);
			}
		}
	}
	_data_->first_backup = _data_->full_dates == 0;
	_data_->initial_required_space = _data_->self->priv->progress_total * 2;
	_data_->_tmp5_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) _data_->self);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->_state_ = 1;
	deja_dup_backend_get_space (_data_->_tmp6_, TRUE, duplicity_job_check_backup_space_ready, _data_);
	return FALSE;
	_state_1:
	_data_->free = deja_dup_backend_get_space_finish (_data_->_tmp6_, _data_->_res_);
	_data_->_tmp7_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_state_ = 2;
	deja_dup_backend_get_space (_data_->_tmp8_, FALSE, duplicity_job_check_backup_space_ready, _data_);
	return FALSE;
	_state_2:
	_data_->total = deja_dup_backend_get_space_finish (_data_->_tmp8_, _data_->_res_);
	if (_data_->free != DEJA_DUP_BACKEND_INFINITE_SPACE) {
		_data_->_tmp9_ = _data_->free > _data_->total;
	} else {
		_data_->_tmp9_ = FALSE;
	}
	if (_data_->_tmp9_) {
		_data_->total = _data_->free;
	}
	if (_data_->total < _data_->initial_required_space) {
		_data_->_tmp10_ = g_format_size_full (_data_->initial_required_space, G_FORMAT_SIZE_DEFAULT);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = g_strdup_printf (_ ("Try using a location with at least %s."), _data_->_tmp11_);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = g_strdup_printf ("%s %s\n\n%s", _ ("Backup location is too small."), _data_->_tmp13_, _ ("(Space for two full backups is required.)"));
		_data_->_tmp15_ = _data_->_tmp14_;
		_g_free0 (_data_->_tmp13_);
		_g_free0 (_data_->_tmp11_);
		_data_->msg = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->msg;
		duplicity_job_show_error (_data_->self, _data_->_tmp16_, NULL);
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE);
		_g_free0 (_data_->msg);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->first_backup) {
		_data_->_tmp17_ = _data_->initial_required_space;
	} else {
		_data_->_tmp17_ = _data_->self->priv->progress_total;
	}
	_data_->required_free_space = _data_->_tmp17_;
	if (_data_->free < _data_->required_free_space) {
		if (_data_->full_dates > 1) {
			duplicity_job_delete_excess (_data_->self, _data_->full_dates - 1);
			_data_->self->priv->checked_backup_space = FALSE;
			_data_->self->priv->checked_collection_info = FALSE;
			_data_->self->priv->got_collection_info = FALSE;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp18_ = g_strdup (_ ("Backup location does not have enough free space. Please free up at lea" \
"st %s."));
		_data_->_vala1_msg = _data_->_tmp18_;
		if (_data_->first_backup) {
			_data_->_tmp19_ = g_strdup (_ ("Backup location does not have enough free space. Try using a location " \
"with at least %s free."));
			_g_free0 (_data_->_vala1_msg);
			_data_->_vala1_msg = _data_->_tmp19_;
		}
		_data_->_tmp20_ = _data_->_vala1_msg;
		_data_->_tmp21_ = g_format_size_full (_data_->required_free_space, G_FORMAT_SIZE_DEFAULT);
		_data_->_tmp22_ = _data_->_tmp21_;
		_data_->_tmp23_ = g_strdup_printf (_data_->_tmp20_, _data_->_tmp22_);
		_data_->_tmp24_ = _data_->_tmp23_;
		duplicity_job_show_error (_data_->self, _data_->_tmp24_, NULL);
		_g_free0 (_data_->_tmp24_);
		_g_free0 (_data_->_tmp22_);
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE);
		_g_free0 (_data_->_vala1_msg);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (!duplicity_job_restart (_data_->self)) {
		g_signal_emit_by_name ((DejaDupToolJob*) _data_->self, "done", FALSE, FALSE);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
duplicity_job_cleanup (DuplicityJob* self)
{
	DuplicityJobState _tmp0_;
	GList* cleanup_argv = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GList* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	if (_tmp0_ == DUPLICITY_JOB_STATE_CLEANUP) {
		result = FALSE;
		return result;
	}
	duplicity_job_set_state (self, DUPLICITY_JOB_STATE_CLEANUP);
	cleanup_argv = NULL;
	_tmp1_ = g_strdup ("cleanup");
	cleanup_argv = g_list_append (cleanup_argv, _tmp1_);
	_tmp2_ = g_strdup ("--force");
	cleanup_argv = g_list_append (cleanup_argv, _tmp2_);
	_tmp3_ = duplicity_job_get_remote (self);
	cleanup_argv = g_list_append (cleanup_argv, _tmp3_);
	duplicity_job_set_status (self, _ ("Cleaning up…"), TRUE);
	_tmp4_ = cleanup_argv;
	duplicity_job_connect_and_start (self, NULL, NULL, _tmp4_, NULL);
	result = TRUE;
	(cleanup_argv == NULL) ? NULL : (cleanup_argv = (_g_list_free__g_free0_ (cleanup_argv), NULL));
	return result;
}

static void
duplicity_job_delete_excess (DuplicityJob* self,
                             gint cutoff)
{
	GList* argv = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	duplicity_job_set_state (self, DUPLICITY_JOB_STATE_DELETE);
	argv = NULL;
	_tmp0_ = g_strdup ("remove-all-but-n-full");
	argv = g_list_append (argv, _tmp0_);
	_tmp1_ = g_strdup_printf ("%d", cutoff);
	argv = g_list_append (argv, _tmp1_);
	_tmp2_ = g_strdup ("--force");
	argv = g_list_append (argv, _tmp2_);
	_tmp3_ = duplicity_job_get_remote (self);
	argv = g_list_append (argv, _tmp3_);
	duplicity_job_set_status (self, _ ("Cleaning up…"), TRUE);
	duplicity_job_connect_and_start (self, NULL, NULL, argv, NULL);
	(argv == NULL) ? NULL : (argv = (_g_list_free__g_free0_ (argv), NULL));
	return;
}

static gboolean
duplicity_job_can_ignore_error (DuplicityJob* self)
{
	DuplicityJobState _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_state;
	result = _tmp0_ == DUPLICITY_JOB_STATE_CLEANUP;
	return result;
}

static void
duplicity_job_handle_done (DuplicityJob* self,
                           DuplicityInstance* inst,
                           gboolean success,
                           gboolean cancelled)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp17_;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	if (duplicity_job_can_ignore_error (self)) {
		success = TRUE;
	}
	if (!cancelled) {
		_tmp0_ = success;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		DuplicityJobState _tmp1_;
		_tmp1_ = self->priv->_state;
		switch (_tmp1_) {
			case DUPLICITY_JOB_STATE_DRY_RUN:
			{
				self->priv->has_progress_total = TRUE;
				self->priv->progress_total = self->priv->progress_count;
				if (duplicity_job_restart (self)) {
					return;
				}
				break;
			}
			case DUPLICITY_JOB_STATE_DELETE:
			{
				if (duplicity_job_restart (self)) {
					return;
				}
				break;
			}
			case DUPLICITY_JOB_STATE_CLEANUP:
			{
				self->priv->cleaned_up_once = TRUE;
				if (duplicity_job_restart (self)) {
					return;
				}
				success = FALSE;
				cancelled = TRUE;
				break;
			}
			case DUPLICITY_JOB_STATE_STATUS:
			{
				gboolean should_restart = FALSE;
				DejaDupToolJobMode _tmp2_;
				DejaDupToolJobMode _tmp3_;
				DejaDupToolJobMode _tmp4_;
				DejaDupToolJobMode _tmp5_;
				self->priv->checked_collection_info = TRUE;
				_tmp2_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp3_ = _tmp2_;
				_tmp4_ = self->priv->_original_mode;
				should_restart = _tmp3_ != _tmp4_;
				_tmp5_ = self->priv->_original_mode;
				deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, _tmp5_);
				if (should_restart) {
					if (duplicity_job_restart (self)) {
						return;
					}
				}
				break;
			}
			case DUPLICITY_JOB_STATE_NORMAL:
			{
				gboolean _tmp6_ = FALSE;
				DejaDupToolJobMode _tmp7_;
				DejaDupToolJobMode _tmp8_;
				DejaDupToolJobMode _tmp14_;
				DejaDupToolJobMode _tmp15_;
				_tmp7_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp8_ = _tmp7_;
				if (_tmp8_ == DEJA_DUP_TOOL_JOB_MODE_RESTORE) {
					GList* _tmp9_;
					GList* _tmp10_;
					_tmp9_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
					_tmp10_ = _tmp9_;
					_tmp6_ = _tmp10_ != NULL;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					GList* _tmp11_;
					GList* _tmp12_;
					GList* _tmp13_;
					_tmp11_ = ((DejaDupToolJob*) self)->_restore_files;
					((DejaDupToolJob*) self)->_restore_files = g_list_delete_link (((DejaDupToolJob*) self)->_restore_files, _tmp11_);
					_tmp12_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
					_tmp13_ = _tmp12_;
					if (_tmp13_ != NULL) {
						if (duplicity_job_restart (self)) {
							return;
						}
					}
				}
				_tmp14_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp15_ = _tmp14_;
				if (_tmp15_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
					deja_dup_tool_job_set_mode ((DejaDupToolJob*) self, DEJA_DUP_TOOL_JOB_MODE_INVALID);
					if (duplicity_job_delete_files_if_needed (self)) {
						return;
					}
				}
				break;
			}
			case DUPLICITY_JOB_STATE_NOT_STARTED:
			{
				break;
			}
			default:
			break;
		}
	} else {
		gboolean _tmp16_;
		_tmp16_ = self->priv->_was_stopped;
		if (_tmp16_) {
			success = TRUE;
		}
	}
	_tmp17_ = self->priv->_error_issued;
	if (_tmp17_) {
		success = FALSE;
	}
	if (!success) {
		_tmp19_ = !cancelled;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		gboolean _tmp20_;
		_tmp20_ = self->priv->_error_issued;
		_tmp18_ = !_tmp20_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		duplicity_job_show_error (self, _ ("Failed with an unknown error."), NULL);
	}
	inst = NULL;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "done", success, cancelled);
}

static void
duplicity_job_set_status (DuplicityJob* self,
                          const gchar* msg,
                          gboolean save)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (msg != NULL);
	if (save) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (msg);
		_g_free0 (self->priv->saved_status);
		self->priv->saved_status = _tmp0_;
		_g_object_unref0 (self->priv->saved_status_file);
		self->priv->saved_status_file = NULL;
	}
	g_signal_emit_by_name ((DejaDupToolJob*) self, "action-desc-changed", msg);
}

static void
duplicity_job_set_status_file (DuplicityJob* self,
                               GFile* file,
                               gboolean action,
                               gboolean save)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	if (save) {
		GFile* _tmp0_;
		_g_free0 (self->priv->saved_status);
		self->priv->saved_status = NULL;
		_tmp0_ = _g_object_ref0 (file);
		_g_object_unref0 (self->priv->saved_status_file);
		self->priv->saved_status_file = _tmp0_;
		self->priv->saved_status_file_action = action;
	}
	g_signal_emit_by_name ((DejaDupToolJob*) self, "action-file-changed", file, action);
}

static void
duplicity_job_set_saved_status (DuplicityJob* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->saved_status;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = self->priv->saved_status;
		duplicity_job_set_status (self, _tmp1_, FALSE);
	} else {
		GFile* _tmp2_;
		_tmp2_ = self->priv->saved_status_file;
		duplicity_job_set_status_file (self, _tmp2_, self->priv->saved_status_file_action, FALSE);
	}
}

static gboolean
duplicity_job_delete_files_if_needed (DuplicityJob* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->delete_age == 0) {
		self->priv->deleted_files = TRUE;
		result = FALSE;
		return result;
	}
	if (self->priv->got_collection_info) {
		_tmp0_ = !self->priv->deleted_files;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint full_dates = 0;
		gint too_old = 0;
		GDateTime* today = NULL;
		GDateTime* _tmp1_;
		GDateTime* prev_time = NULL;
		GList* _tmp2_;
		gboolean _tmp15_ = FALSE;
		GDateTime* _tmp16_;
		gboolean _tmp21_ = FALSE;
		full_dates = 0;
		too_old = 0;
		_tmp1_ = g_date_time_new_now_local ();
		today = _tmp1_;
		prev_time = NULL;
		_tmp2_ = self->priv->collection_info;
		{
			GList* info_collection = NULL;
			GList* info_it = NULL;
			info_collection = _tmp2_;
			for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
				DuplicityJobDateInfo _tmp3_;
				DuplicityJobDateInfo _tmp4_ = {0};
				DuplicityJobDateInfo info = {0};
				_tmp3_ = *((DuplicityJobDateInfo*) info_it->data);
				duplicity_job_date_info_copy (&_tmp3_, &_tmp4_);
				info = _tmp4_;
				{
					DuplicityJobDateInfo _tmp5_;
					DuplicityJobDateInfo _tmp12_;
					GDateTime* _tmp13_;
					GDateTime* _tmp14_;
					_tmp5_ = info;
					if (_tmp5_.full) {
						gboolean _tmp6_ = FALSE;
						GDateTime* _tmp7_;
						gint _tmp11_;
						_tmp7_ = prev_time;
						if (_tmp7_ != NULL) {
							GDateTime* _tmp8_;
							GDateTime* _tmp9_;
							_tmp8_ = today;
							_tmp9_ = prev_time;
							_tmp6_ = (g_date_time_difference (_tmp8_, _tmp9_) / G_TIME_SPAN_DAY) > ((GTimeSpan) self->priv->delete_age);
						} else {
							_tmp6_ = FALSE;
						}
						if (_tmp6_) {
							gint _tmp10_;
							too_old = too_old + 1;
							_tmp10_ = too_old;
						}
						full_dates = full_dates + 1;
						_tmp11_ = full_dates;
					}
					_tmp12_ = info;
					_tmp13_ = _tmp12_.time;
					_tmp14_ = _g_date_time_ref0 (_tmp13_);
					_g_date_time_unref0 (prev_time);
					prev_time = _tmp14_;
					duplicity_job_date_info_destroy (&info);
				}
			}
		}
		_tmp16_ = prev_time;
		if (_tmp16_ != NULL) {
			GDateTime* _tmp17_;
			GDateTime* _tmp18_;
			_tmp17_ = today;
			_tmp18_ = prev_time;
			_tmp15_ = (g_date_time_difference (_tmp17_, _tmp18_) / G_TIME_SPAN_DAY) > ((GTimeSpan) self->priv->delete_age);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			gint _tmp19_;
			too_old = too_old + 1;
			_tmp19_ = too_old;
		}
		if (self->priv->is_full_backup) {
			gint _tmp20_;
			full_dates = full_dates + 1;
			_tmp20_ = full_dates;
		}
		if (too_old > 0) {
			_tmp21_ = full_dates > DUPLICITY_JOB_MINIMUM_FULL;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			gint cutoff = 0;
			cutoff = MAX (DUPLICITY_JOB_MINIMUM_FULL, full_dates - too_old);
			duplicity_job_delete_excess (self, cutoff);
			result = TRUE;
			_g_date_time_unref0 (prev_time);
			_g_date_time_unref0 (today);
			return result;
		}
		self->priv->deleted_files = TRUE;
		result = FALSE;
		_g_date_time_unref0 (prev_time);
		_g_date_time_unref0 (today);
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
duplicity_job_delete_cache (DuplicityJob* self,
                            GRegex* only)
{
	gchar* dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* cachedir = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	DejaDupRecursiveDelete* del = NULL;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	DejaDupRecursiveDelete* _tmp8_;
	DejaDupRecursiveDelete* _tmp9_;
	DejaDupRecursiveDelete* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	dir = _tmp1_;
	_tmp2_ = dir;
	if (_tmp2_ == NULL) {
		_g_free0 (dir);
		return;
	}
	_tmp3_ = dir;
	_tmp4_ = g_build_filename (_tmp3_, PACKAGE, NULL);
	cachedir = _tmp4_;
	_tmp5_ = cachedir;
	_tmp6_ = g_file_new_for_path (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = deja_dup_recursive_delete_new (_tmp7_, "metadata", only);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	del = _tmp9_;
	_tmp10_ = del;
	deja_dup_recursive_op_start ((DejaDupRecursiveOp*) _tmp10_);
	_g_object_unref0 (del);
	_g_free0 (cachedir);
	_g_free0 (dir);
}

static gboolean
duplicity_job_restart_without_cache (DuplicityJob* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->restarted_without_cache) {
		result = FALSE;
		return result;
	}
	self->priv->restarted_without_cache = TRUE;
	duplicity_job_delete_cache (self, NULL);
	result = duplicity_job_restart (self);
	return result;
}

static void
duplicity_job_handle_exit (DuplicityJob* self,
                           gint code)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (code == DUPLICITY_JOB_ERROR_GENERIC) {
		gboolean _tmp1_;
		_tmp1_ = self->priv->_error_issued;
		_tmp0_ = !_tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		duplicity_job_restart_without_cache (self);
	}
}

static void
duplicity_job_handle_message (DuplicityJob* self,
                              DuplicityInstance* inst,
                              gchar** control_line,
                              gint control_line_length1,
                              GList* data_lines,
                              const gchar* user_text)
{
	gchar* keyword = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	static GQuark _tmp4_label1 = 0;
	static GQuark _tmp4_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inst != NULL);
	g_return_if_fail (user_text != NULL);
	if (control_line_length1 == 0) {
		return;
	}
	_tmp0_ = control_line[0];
	_tmp1_ = g_strdup (_tmp0_);
	keyword = _tmp1_;
	_tmp2_ = keyword;
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("ERROR")))) {
		switch (0) {
			default:
			{
				duplicity_job_process_error (self, control_line, (gint) control_line_length1, data_lines, user_text);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("INFO")))) {
		switch (0) {
			default:
			{
				duplicity_job_process_info (self, control_line, (gint) control_line_length1, data_lines, user_text);
				break;
			}
		}
	} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("WARNING")))) {
		switch (0) {
			default:
			{
				duplicity_job_process_warning (self, control_line, (gint) control_line_length1, data_lines, user_text);
				break;
			}
		}
	}
	_g_free0 (keyword);
}

static gboolean
duplicity_job_ask_question (DuplicityJob* self,
                            const gchar* t,
                            const gchar* m)
{
	gboolean rv = FALSE;
	DejaDupToolJobMode _tmp0_;
	DejaDupToolJobMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	duplicity_job_disconnect_inst (self);
	g_signal_emit_by_name ((DejaDupToolJob*) self, "question", t, m);
	_tmp0_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	rv = _tmp1_ != DEJA_DUP_TOOL_JOB_MODE_INVALID;
	if (!rv) {
		duplicity_job_handle_done (self, NULL, FALSE, TRUE);
	}
	result = rv;
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
duplicity_job_parse_duplicity_file (DuplicityJob* self,
                                    const gchar* file,
                                    gint skip_bits)
{
	gint next = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	next = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gint _tmp1_;
		_tmp1_ = skip_bits;
		skip_bits = _tmp1_ - 1;
		if (_tmp1_ > 0) {
			_tmp0_ = next >= 0;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		next = string_index_of_char (file, (gunichar) '.', next) + 1;
	}
	if (next < 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		result = _tmp2_;
		return result;
	} else {
		gchar* _tmp3_;
		_tmp3_ = string_substring (file, (glong) next, (glong) -1);
		result = _tmp3_;
		return result;
	}
}

static void
duplicity_job_report_encryption_error (DuplicityJob* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((DejaDupToolJob*) self, "bad-encryption-password");
	duplicity_job_show_error (self, _ ("Bad encryption password."), NULL);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
duplicity_job_check_encryption_error (DuplicityJob* self,
                                      const gchar* text)
{
	gchar* no_seckey_msg = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* bad_key_msg = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (text != NULL, FALSE);
	_tmp0_ = gpg_strerror (GPG_ERR_NO_SECKEY);
	_tmp1_ = g_strdup (_tmp0_);
	no_seckey_msg = _tmp1_;
	_tmp2_ = gpg_strerror (GPG_ERR_BAD_KEY);
	_tmp3_ = g_strdup (_tmp2_);
	bad_key_msg = _tmp3_;
	_tmp7_ = no_seckey_msg;
	if (string_contains (text, _tmp7_)) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = string_contains (text, "No secret key");
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = bad_key_msg;
		_tmp5_ = string_contains (text, _tmp8_);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = string_contains (text, "Bad session key");
	}
	if (_tmp4_) {
		duplicity_job_report_encryption_error (self);
		result = TRUE;
		_g_free0 (bad_key_msg);
		_g_free0 (no_seckey_msg);
		return result;
	}
	result = FALSE;
	_g_free0 (bad_key_msg);
	_g_free0 (no_seckey_msg);
	return result;
}

static void
duplicity_job_real_process_error (DuplicityJob* self,
                                  gchar** firstline,
                                  gint firstline_length1,
                                  GList* data,
                                  const gchar* text_in)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	const gchar* _tmp74_;
	g_return_if_fail (text_in != NULL);
	_tmp0_ = g_strdup (text_in);
	text = _tmp0_;
	if (duplicity_job_can_ignore_error (self)) {
		_g_free0 (text);
		return;
	}
	if (firstline_length1 > 1) {
		const gchar* _tmp1_;
		_tmp1_ = firstline[1];
		switch (atoi (_tmp1_)) {
			case DUPLICITY_JOB_ERROR_GENERIC:
			{
				gboolean _tmp2_ = FALSE;
				const gchar* _tmp3_;
				_tmp3_ = text;
				if (string_contains (_tmp3_, "GnuPG")) {
					const gchar* _tmp4_;
					_tmp4_ = text;
					_tmp2_ = duplicity_job_check_encryption_error (self, _tmp4_);
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					_g_free0 (text);
					return;
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_EXCEPTION:
			{
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp7_;
				if (firstline_length1 > 2) {
					const gchar* _tmp6_;
					_tmp6_ = firstline[2];
					_tmp5_ = _tmp6_;
				} else {
					_tmp5_ = "";
				}
				_tmp7_ = text;
				duplicity_job_process_exception (self, _tmp5_, _tmp7_);
				_g_free0 (text);
				return;
			}
			case DUPLICITY_JOB_ERROR_RESTORE_DIR_NOT_FOUND:
			{
				GList* _tmp8_;
				GList* _tmp9_;
				_tmp8_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
				_tmp9_ = _tmp8_;
				if (_tmp9_ != NULL) {
					GList* _tmp10_;
					GList* _tmp11_;
					gconstpointer _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					_tmp10_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
					_tmp11_ = _tmp10_;
					_tmp12_ = _tmp11_->data;
					_tmp13_ = g_file_get_parse_name ((GFile*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strdup_printf (_ ("Could not restore ‘%s’: File not found in backup"), _tmp14_);
					_g_free0 (text);
					text = _tmp15_;
					_g_free0 (_tmp14_);
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_GPG:
			{
				if (duplicity_job_check_encryption_error (self, text_in)) {
					_g_free0 (text);
					return;
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_HOSTNAME_CHANGED:
			{
				gchar* _tmp23_;
				if (firstline_length1 >= 4) {
					gchar* msg = NULL;
					gchar* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gboolean _tmp22_;
					_tmp16_ = g_strdup (_ ("The existing backup is of a computer named %s, but the " "current computer’s name is %s.  If this is unexpected, " "you should back up to a different location."));
					msg = _tmp16_;
					_tmp17_ = msg;
					_tmp18_ = firstline[3];
					_tmp19_ = firstline[2];
					_tmp20_ = g_strdup_printf (_tmp17_, _tmp18_, _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = !duplicity_job_ask_question (self, _ ("Computer name changed"), _tmp21_);
					_g_free0 (_tmp21_);
					if (_tmp22_) {
						_g_free0 (msg);
						_g_free0 (text);
						return;
					}
					_g_free0 (msg);
				}
				_tmp23_ = g_strdup ("--allow-source-mismatch");
				self->priv->saved_argv = g_list_append (self->priv->saved_argv, _tmp23_);
				if (duplicity_job_restart (self)) {
					_g_free0 (text);
					return;
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_BAD_VOLUME:
			{
				DejaDupToolJobMode _tmp24_;
				DejaDupToolJobMode _tmp25_;
				_tmp24_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
					gchar* this_volume = NULL;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					const gchar* _tmp29_;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					_tmp26_ = firstline[2];
					_tmp27_ = duplicity_job_parse_duplicity_file (self, _tmp26_, 2);
					this_volume = _tmp27_;
					_tmp28_ = self->priv->last_bad_volume;
					_tmp29_ = this_volume;
					if (g_strcmp0 (_tmp28_, _tmp29_) != 0) {
						const gchar* _tmp30_;
						gchar* _tmp31_;
						self->priv->bad_volume_count = (guint) 0;
						_tmp30_ = this_volume;
						_tmp31_ = g_strdup (_tmp30_);
						_g_free0 (self->priv->last_bad_volume);
						self->priv->last_bad_volume = _tmp31_;
					}
					if (self->priv->bad_volume_count == ((guint) 0)) {
						_tmp33_ = duplicity_job_restart (self);
					} else {
						_tmp33_ = FALSE;
					}
					if (_tmp33_) {
						_tmp32_ = TRUE;
					} else {
						gboolean _tmp34_ = FALSE;
						if (self->priv->bad_volume_count == ((guint) 1)) {
							_tmp34_ = duplicity_job_cleanup (self);
						} else {
							_tmp34_ = FALSE;
						}
						_tmp32_ = _tmp34_;
					}
					if (_tmp32_) {
						self->priv->bad_volume_count = self->priv->bad_volume_count + 1;
						_g_free0 (this_volume);
						_g_free0 (text);
						return;
					}
					_g_free0 (this_volume);
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_BACKEND_PERMISSION_DENIED:
			{
				gboolean _tmp35_ = FALSE;
				gboolean _tmp43_ = FALSE;
				if (firstline_length1 >= 5) {
					const gchar* _tmp36_;
					_tmp36_ = firstline[2];
					_tmp35_ = g_strcmp0 (_tmp36_, "put") == 0;
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					GFile* file = NULL;
					const gchar* _tmp37_;
					GFile* _tmp38_;
					GFile* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp37_ = firstline[4];
					_tmp38_ = duplicity_job_make_file_obj (self, _tmp37_);
					file = _tmp38_;
					_tmp39_ = file;
					_tmp40_ = g_file_get_parse_name (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = g_strdup_printf (_ ("Permission denied when trying to create ‘%s’."), _tmp41_);
					_g_free0 (text);
					text = _tmp42_;
					_g_free0 (_tmp41_);
					_g_object_unref0 (file);
				}
				if (firstline_length1 >= 5) {
					const gchar* _tmp44_;
					_tmp44_ = firstline[2];
					_tmp43_ = g_strcmp0 (_tmp44_, "get") == 0;
				} else {
					_tmp43_ = FALSE;
				}
				if (_tmp43_) {
					GFile* file = NULL;
					const gchar* _tmp45_;
					GFile* _tmp46_;
					GFile* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					_tmp45_ = firstline[3];
					_tmp46_ = duplicity_job_make_file_obj (self, _tmp45_);
					file = _tmp46_;
					_tmp47_ = file;
					_tmp48_ = g_file_get_parse_name (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = g_strdup_printf (_ ("Permission denied when trying to read ‘%s’."), _tmp49_);
					_g_free0 (text);
					text = _tmp50_;
					_g_free0 (_tmp49_);
					_g_object_unref0 (file);
				} else {
					gboolean _tmp51_ = FALSE;
					if (firstline_length1 >= 4) {
						const gchar* _tmp52_;
						_tmp52_ = firstline[2];
						_tmp51_ = g_strcmp0 (_tmp52_, "list") == 0;
					} else {
						_tmp51_ = FALSE;
					}
					if (_tmp51_) {
						GFile* file = NULL;
						const gchar* _tmp53_;
						GFile* _tmp54_;
						GFile* _tmp55_;
						gchar* _tmp56_;
						gchar* _tmp57_;
						gchar* _tmp58_;
						_tmp53_ = firstline[3];
						_tmp54_ = duplicity_job_make_file_obj (self, _tmp53_);
						file = _tmp54_;
						_tmp55_ = file;
						_tmp56_ = g_file_get_parse_name (_tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = g_strdup_printf (_ ("Permission denied when trying to read ‘%s’."), _tmp57_);
						_g_free0 (text);
						text = _tmp58_;
						_g_free0 (_tmp57_);
						_g_object_unref0 (file);
					} else {
						gboolean _tmp59_ = FALSE;
						if (firstline_length1 >= 4) {
							const gchar* _tmp60_;
							_tmp60_ = firstline[2];
							_tmp59_ = g_strcmp0 (_tmp60_, "delete") == 0;
						} else {
							_tmp59_ = FALSE;
						}
						if (_tmp59_) {
							GFile* file = NULL;
							const gchar* _tmp61_;
							GFile* _tmp62_;
							GFile* _tmp63_;
							gchar* _tmp64_;
							gchar* _tmp65_;
							gchar* _tmp66_;
							_tmp61_ = firstline[3];
							_tmp62_ = duplicity_job_make_file_obj (self, _tmp61_);
							file = _tmp62_;
							_tmp63_ = file;
							_tmp64_ = g_file_get_parse_name (_tmp63_);
							_tmp65_ = _tmp64_;
							_tmp66_ = g_strdup_printf (_ ("Permission denied when trying to delete ‘%s’."), _tmp65_);
							_g_free0 (text);
							text = _tmp66_;
							_g_free0 (_tmp65_);
							_g_object_unref0 (file);
						}
					}
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_BACKEND_NOT_FOUND:
			{
				if (firstline_length1 >= 4) {
					GFile* file = NULL;
					const gchar* _tmp67_;
					GFile* _tmp68_;
					GFile* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					_tmp67_ = firstline[3];
					_tmp68_ = duplicity_job_make_file_obj (self, _tmp67_);
					file = _tmp68_;
					_tmp69_ = file;
					_tmp70_ = g_file_get_parse_name (_tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = g_strdup_printf (_ ("Backup location ‘%s’ does not exist."), _tmp71_);
					_g_free0 (text);
					text = _tmp72_;
					_g_free0 (_tmp71_);
					_g_object_unref0 (file);
				}
				break;
			}
			case DUPLICITY_JOB_ERROR_BACKEND_NO_SPACE:
			{
				if (firstline_length1 >= 5) {
					gchar* _tmp73_;
					_tmp73_ = g_strdup (_ ("No space left."));
					_g_free0 (text);
					text = _tmp73_;
				}
				break;
			}
			default:
			break;
		}
	}
	_tmp74_ = text;
	duplicity_job_show_error (self, _tmp74_, NULL);
	_g_free0 (text);
}

void
duplicity_job_process_error (DuplicityJob* self,
                             gchar** firstline,
                             gint firstline_length1,
                             GList* data,
                             const gchar* text_in)
{
	DuplicityJobClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DUPLICITY_JOB_GET_CLASS (self);
	if (_klass_->process_error) {
		_klass_->process_error (self, firstline, firstline_length1, data, text_in);
	}
}

static void
duplicity_job_process_exception (DuplicityJob* self,
                                 const gchar* exception,
                                 const gchar* text)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (exception != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = exception;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("EOFError")))) {
		switch (0) {
			default:
			{
				duplicity_job_report_encryption_error (self);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("IOError")))) {
		switch (0) {
			default:
			{
				if (string_contains (text, "GnuPG")) {
					duplicity_job_report_encryption_error (self);
				} else {
					gboolean _tmp3_ = FALSE;
					if (string_contains (text, "[Errno 5]")) {
						GFile* _tmp4_;
						_tmp4_ = self->priv->last_touched_file;
						_tmp3_ = _tmp4_ != NULL;
					} else {
						_tmp3_ = FALSE;
					}
					if (_tmp3_) {
						DejaDupToolJobMode _tmp5_;
						DejaDupToolJobMode _tmp6_;
						_tmp5_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
						_tmp6_ = _tmp5_;
						if (_tmp6_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
							GFile* _tmp7_;
							gchar* _tmp8_;
							gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							_tmp7_ = self->priv->last_touched_file;
							_tmp8_ = g_file_get_parse_name (_tmp7_);
							_tmp9_ = _tmp8_;
							_tmp10_ = g_strdup_printf (_ ("Error reading file ‘%s’."), _tmp9_);
							_tmp11_ = _tmp10_;
							duplicity_job_show_error (self, _tmp11_, NULL);
							_g_free0 (_tmp11_);
							_g_free0 (_tmp9_);
						} else {
							GFile* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							gchar* _tmp16_;
							_tmp12_ = self->priv->last_touched_file;
							_tmp13_ = g_file_get_parse_name (_tmp12_);
							_tmp14_ = _tmp13_;
							_tmp15_ = g_strdup_printf (_ ("Error writing file ‘%s’."), _tmp14_);
							_tmp16_ = _tmp15_;
							duplicity_job_show_error (self, _tmp16_, NULL);
							_g_free0 (_tmp16_);
							_g_free0 (_tmp14_);
						}
					} else {
						if (string_contains (text, "[Errno 28]")) {
							gchar* where = NULL;
							DejaDupToolJobMode _tmp17_;
							DejaDupToolJobMode _tmp18_;
							const gchar* _tmp25_;
							where = NULL;
							_tmp17_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
							_tmp18_ = _tmp17_;
							if (_tmp18_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
								DejaDupBackend* _tmp19_;
								DejaDupBackend* _tmp20_;
								gchar* _tmp21_;
								_tmp19_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
								_tmp20_ = _tmp19_;
								_tmp21_ = deja_dup_backend_get_location_pretty (_tmp20_);
								_g_free0 (where);
								where = _tmp21_;
							} else {
								GFile* _tmp22_;
								GFile* _tmp23_;
								gchar* _tmp24_;
								_tmp22_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
								_tmp23_ = _tmp22_;
								_tmp24_ = g_file_get_path (_tmp23_);
								_g_free0 (where);
								where = _tmp24_;
							}
							_tmp25_ = where;
							if (_tmp25_ == NULL) {
								duplicity_job_show_error (self, _ ("No space left."), NULL);
							} else {
								const gchar* _tmp26_;
								gchar* _tmp27_;
								gchar* _tmp28_;
								_tmp26_ = where;
								_tmp27_ = g_strdup_printf (_ ("No space left in ‘%s’."), _tmp26_);
								_tmp28_ = _tmp27_;
								duplicity_job_show_error (self, _tmp28_, NULL);
								_g_free0 (_tmp28_);
							}
							_g_free0 (where);
						} else {
							if (string_contains (text, "CRC check failed")) {
								if (duplicity_job_restart_without_cache (self)) {
									return;
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("CollectionsError")))) {
		switch (0) {
			default:
			{
				duplicity_job_show_error (self, _ ("No backup files found"), NULL);
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("AssertionError")))) {
		switch (0) {
			default:
			{
				if (duplicity_job_restart_without_cache (self)) {
					return;
				}
				break;
			}
		}
	}
	_tmp30_ = self->priv->_error_issued;
	if (!_tmp30_) {
		_tmp29_ = !duplicity_job_restart_without_cache (self);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		duplicity_job_show_error (self, _ ("Failed with an unknown error."), text);
	}
}

static void
duplicity_job_real_process_info (DuplicityJob* self,
                                 gchar** firstline,
                                 gint firstline_length1,
                                 GList* data,
                                 const gchar* text)
{
	g_return_if_fail (text != NULL);
	if (firstline_length1 > 1) {
		const gchar* _tmp0_;
		_tmp0_ = firstline[1];
		switch (atoi (_tmp0_)) {
			case DUPLICITY_JOB_INFO_DIFF_FILE_NEW:
			case DUPLICITY_JOB_INFO_DIFF_FILE_CHANGED:
			case DUPLICITY_JOB_INFO_DIFF_FILE_DELETED:
			{
				if (firstline_length1 > 2) {
					const gchar* _tmp1_;
					_tmp1_ = firstline[2];
					duplicity_job_process_diff_file (self, _tmp1_);
				}
				break;
			}
			case DUPLICITY_JOB_INFO_PATCH_FILE_WRITING:
			case DUPLICITY_JOB_INFO_PATCH_FILE_PATCHING:
			{
				if (firstline_length1 > 2) {
					const gchar* _tmp2_;
					_tmp2_ = firstline[2];
					duplicity_job_process_patch_file (self, _tmp2_);
				}
				break;
			}
			case DUPLICITY_JOB_INFO_PROGRESS:
			{
				duplicity_job_process_progress (self, firstline, (gint) firstline_length1);
				break;
			}
			case DUPLICITY_JOB_INFO_COLLECTION_STATUS:
			{
				duplicity_job_process_collection_status (self, data);
				break;
			}
			case DUPLICITY_JOB_INFO_SYNCHRONOUS_UPLOAD_BEGIN:
			case DUPLICITY_JOB_INFO_ASYNCHRONOUS_UPLOAD_BEGIN:
			{
				DejaDupBackend* _tmp3_;
				DejaDupBackend* _tmp4_;
				_tmp3_ = deja_dup_tool_job_get_backend ((DejaDupToolJob*) self);
				_tmp4_ = _tmp3_;
				if (!deja_dup_backend_is_native (_tmp4_)) {
					duplicity_job_set_status (self, _ ("Uploading…"), TRUE);
				}
				break;
			}
			case DUPLICITY_JOB_INFO_FILE_STAT:
			{
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp5_ = firstline[2];
				_tmp6_ = firstline[3];
				_tmp7_ = firstline[4];
				duplicity_job_process_file_stat (self, _tmp5_, _tmp6_, _tmp7_, data, text);
				break;
			}
			default:
			break;
		}
	}
}

void
duplicity_job_process_info (DuplicityJob* self,
                            gchar** firstline,
                            gint firstline_length1,
                            GList* data,
                            const gchar* text)
{
	DuplicityJobClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DUPLICITY_JOB_GET_CLASS (self);
	if (_klass_->process_info) {
		_klass_->process_info (self, firstline, firstline_length1, data, text);
	}
}

static void
duplicity_job_process_file_stat (DuplicityJob* self,
                                 const gchar* date,
                                 const gchar* file,
                                 const gchar* dup_type,
                                 GList* data,
                                 const gchar* text)
{
	DejaDupToolJobMode _tmp0_;
	DejaDupToolJobMode _tmp1_;
	GFileType file_type = 0;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (date != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (dup_type != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != DEJA_DUP_TOOL_JOB_MODE_LIST) {
		return;
	}
	if (g_strcmp0 (file, ".") == 0) {
		return;
	}
	file_type = G_FILE_TYPE_UNKNOWN;
	if (g_strcmp0 (dup_type, "reg") == 0) {
		file_type = G_FILE_TYPE_REGULAR;
	} else {
		if (g_strcmp0 (dup_type, "dir") == 0) {
			file_type = G_FILE_TYPE_DIRECTORY;
		} else {
			if (g_strcmp0 (dup_type, "sym") == 0) {
				file_type = G_FILE_TYPE_SYMBOLIC_LINK;
			}
		}
	}
	_tmp2_ = g_strconcat ("/", file, NULL);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "listed-current-files", _tmp3_, file_type);
	_g_free0 (_tmp3_);
}

static void
duplicity_job_process_diff_file (DuplicityJob* self,
                                 const gchar* file)
{
	GFile* gfile = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = duplicity_job_make_file_obj (self, file);
	gfile = _tmp0_;
	_tmp1_ = gfile;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->last_touched_file);
	self->priv->last_touched_file = _tmp2_;
	_tmp3_ = gfile;
	if (g_file_query_file_type (_tmp3_, G_FILE_QUERY_INFO_NONE, NULL) != G_FILE_TYPE_DIRECTORY) {
		GFile* _tmp4_;
		DuplicityJobState _tmp5_;
		_tmp4_ = gfile;
		_tmp5_ = self->priv->_state;
		duplicity_job_set_status_file (self, _tmp4_, _tmp5_ != DUPLICITY_JOB_STATE_DRY_RUN, TRUE);
	}
	_g_object_unref0 (gfile);
}

static void
duplicity_job_process_patch_file (DuplicityJob* self,
                                  const gchar* file)
{
	GFile* gfile = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp0_ = duplicity_job_make_file_obj (self, file);
	gfile = _tmp0_;
	_tmp1_ = gfile;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->last_touched_file);
	self->priv->last_touched_file = _tmp2_;
	_tmp3_ = gfile;
	if (g_file_query_file_type (_tmp3_, G_FILE_QUERY_INFO_NONE, NULL) != G_FILE_TYPE_DIRECTORY) {
		GFile* _tmp4_;
		DuplicityJobState _tmp5_;
		_tmp4_ = gfile;
		_tmp5_ = self->priv->_state;
		duplicity_job_set_status_file (self, _tmp4_, _tmp5_ != DUPLICITY_JOB_STATE_DRY_RUN, TRUE);
	}
	_g_object_unref0 (gfile);
}

static guint64
uint64_parse (const gchar* str,
              guint _base)
{
	guint64 result;
	g_return_val_if_fail (str != NULL, 0ULL);
	result = g_ascii_strtoull (str, NULL, _base);
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static void
duplicity_job_process_progress (DuplicityJob* self,
                                gchar** firstline,
                                gint firstline_length1)
{
	gdouble total = 0.0;
	gdouble percent = 0.0;
	g_return_if_fail (self != NULL);
	if (firstline_length1 > 2) {
		const gchar* _tmp0_;
		_tmp0_ = firstline[2];
		self->priv->progress_count = uint64_parse (_tmp0_, (guint) 0);
	} else {
		return;
	}
	if (firstline_length1 > 3) {
		const gchar* _tmp1_;
		_tmp1_ = firstline[3];
		total = double_parse (_tmp1_);
	} else {
		if (self->priv->progress_total > ((guint64) 0)) {
			total = (gdouble) self->priv->progress_total;
		} else {
			return;
		}
	}
	percent = ((gdouble) self->priv->progress_count) / total;
	if (percent > ((gdouble) 1)) {
		percent = (gdouble) 1;
	}
	if (percent < ((gdouble) 0)) {
		percent = (gdouble) 0;
	}
	g_signal_emit_by_name ((DejaDupToolJob*) self, "progress", percent);
}

static GFile*
duplicity_job_make_file_obj (DuplicityJob* self,
                             const gchar* file)
{
	GList* _tmp0_;
	GList* _tmp1_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GFile* local_file = NULL;
		GList* _tmp2_;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp2_ = deja_dup_tool_job_get_restore_files ((DejaDupToolJob*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = duplicity_job_make_local_rel_path (self, (GFile*) _tmp4_);
		local_file = _tmp5_;
		_tmp6_ = local_file;
		_tmp7_ = g_file_resolve_relative_path (_tmp6_, file);
		result = _tmp7_;
		_g_object_unref0 (local_file);
		return result;
	}
	_tmp8_ = duplicity_job_slash;
	_tmp9_ = g_file_resolve_relative_path (_tmp8_, file);
	result = _tmp9_;
	return result;
}

static gint
__lambda18_ (DuplicityJob* self,
             GDateTime* a,
             GDateTime* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = g_date_time_compare (a, b);
	return result;
}

static gint
___lambda18__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda18_ ((DuplicityJob*) self, (GDateTime*) a, (GDateTime*) b);
	return result;
}

static void
_g_date_time_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL));
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gpointer
_duplicity_job_date_info_dup0 (gpointer self)
{
	return self ? duplicity_job_date_info_dup (self) : NULL;
}

static void
duplicity_job_process_collection_status (DuplicityJob* self,
                                         GList* lines)
{
	gboolean _tmp0_ = FALSE;
	DejaDupToolJobMode _tmp1_;
	DejaDupToolJobMode _tmp2_;
	GTree* dates = NULL;
	GTree* _tmp3_;
	GList* infos = NULL;
	gboolean in_chain = FALSE;
	GList* _tmp42_;
	GTree* _tmp48_;
	g_return_if_fail (self != NULL);
	_tmp1_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != DEJA_DUP_TOOL_JOB_MODE_STATUS) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->got_collection_info;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = g_tree_new_full (___lambda18__gcompare_data_func, self, _g_date_time_unref0_, _g_free0_);
	dates = _tmp3_;
	infos = NULL;
	in_chain = FALSE;
	{
		GList* line_collection = NULL;
		GList* line_it = NULL;
		line_collection = lines;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			gchar* _tmp4_;
			gchar* line = NULL;
			_tmp4_ = g_strdup ((const gchar*) line_it->data);
			line = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				const gchar* _tmp6_;
				_tmp6_ = line;
				if (g_strcmp0 (_tmp6_, "chain-complete") == 0) {
					_tmp5_ = TRUE;
				} else {
					const gchar* _tmp7_;
					_tmp7_ = line;
					_tmp5_ = string_index_of (_tmp7_, "chain-no-sig", 0) == 0;
				}
				if (_tmp5_) {
					in_chain = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					gboolean _tmp9_ = FALSE;
					if (in_chain) {
						const gchar* _tmp10_;
						gint _tmp11_;
						gint _tmp12_;
						_tmp10_ = line;
						_tmp11_ = strlen (_tmp10_);
						_tmp12_ = _tmp11_;
						_tmp9_ = _tmp12_ > 0;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						const gchar* _tmp13_;
						_tmp13_ = line;
						_tmp8_ = string_get (_tmp13_, (glong) 0) == ' ';
					} else {
						_tmp8_ = FALSE;
					}
					if (_tmp8_) {
						gchar** tokens = NULL;
						const gchar* _tmp14_;
						gchar** _tmp15_;
						gchar** _tmp16_;
						gint tokens_length1;
						gint _tokens_size_;
						gchar** _tmp17_;
						gint _tmp17__length1;
						GDateTime* datetime = NULL;
						gchar** _tmp18_;
						gint _tmp18__length1;
						const gchar* _tmp19_;
						GTimeZone* _tmp20_;
						GTimeZone* _tmp21_;
						GDateTime* _tmp22_;
						GDateTime* _tmp23_;
						GDateTime* _tmp24_;
						GTree* _tmp25_;
						GDateTime* _tmp26_;
						GDateTime* _tmp27_;
						gchar** _tmp28_;
						gint _tmp28__length1;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						DuplicityJobDateInfo info = {0};
						GDateTime* _tmp31_;
						GDateTime* _tmp32_;
						gchar** _tmp33_;
						gint _tmp33__length1;
						const gchar* _tmp34_;
						DuplicityJobDateInfo _tmp35_;
						DuplicityJobDateInfo _tmp36_;
						DuplicityJobDateInfo* _tmp37_;
						gboolean _tmp38_ = FALSE;
						_tmp14_ = line;
						_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, " ", 0);
						tokens = _tmp16_;
						tokens_length1 = _vala_array_length (_tmp15_);
						_tokens_size_ = tokens_length1;
						_tmp17_ = tokens;
						_tmp17__length1 = tokens_length1;
						if (_tmp17__length1 <= 2) {
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (line);
							continue;
						}
						_tmp18_ = tokens;
						_tmp18__length1 = tokens_length1;
						_tmp19_ = _tmp18_[2];
						_tmp20_ = g_time_zone_new_utc ();
						_tmp21_ = _tmp20_;
						_tmp22_ = g_date_time_new_from_iso8601 (_tmp19_, _tmp21_);
						_tmp23_ = _tmp22_;
						_g_time_zone_unref0 (_tmp21_);
						datetime = _tmp23_;
						_tmp24_ = datetime;
						if (_tmp24_ == NULL) {
							_g_date_time_unref0 (datetime);
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (line);
							continue;
						}
						_tmp25_ = dates;
						_tmp26_ = datetime;
						_tmp27_ = _g_date_time_ref0 (_tmp26_);
						_tmp28_ = tokens;
						_tmp28__length1 = tokens_length1;
						_tmp29_ = _tmp28_[2];
						_tmp30_ = g_strdup (_tmp29_);
						g_tree_insert (_tmp25_, _tmp27_, _tmp30_);
						memset (&info, 0, sizeof (DuplicityJobDateInfo));
						_tmp31_ = datetime;
						_tmp32_ = _g_date_time_ref0 (_tmp31_);
						_g_date_time_unref0 (info.time);
						info.time = _tmp32_;
						_tmp33_ = tokens;
						_tmp33__length1 = tokens_length1;
						_tmp34_ = _tmp33_[1];
						info.full = g_strcmp0 (_tmp34_, "full") == 0;
						_tmp35_ = info;
						_tmp36_ = _tmp35_;
						_tmp37_ = _duplicity_job_date_info_dup0 (&_tmp36_);
						infos = g_list_append (infos, _tmp37_);
						if (!self->priv->detected_encryption) {
							gchar** _tmp39_;
							gint _tmp39__length1;
							_tmp39_ = tokens;
							_tmp39__length1 = tokens_length1;
							_tmp38_ = _tmp39__length1 > 4;
						} else {
							_tmp38_ = FALSE;
						}
						if (_tmp38_) {
							gchar** _tmp40_;
							gint _tmp40__length1;
							const gchar* _tmp41_;
							self->priv->detected_encryption = TRUE;
							_tmp40_ = tokens;
							_tmp40__length1 = tokens_length1;
							_tmp41_ = _tmp40_[4];
							self->priv->existing_encrypted = g_strcmp0 (_tmp41_, "enc") == 0;
						}
						duplicity_job_date_info_destroy (&info);
						_g_date_time_unref0 (datetime);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					} else {
						if (in_chain) {
							in_chain = FALSE;
						}
					}
				}
				_g_free0 (line);
			}
		}
	}
	self->priv->got_collection_info = TRUE;
	(self->priv->collection_info == NULL) ? NULL : (self->priv->collection_info = (_g_list_free__duplicity_job_date_info_free0_ (self->priv->collection_info), NULL));
	self->priv->collection_info = NULL;
	_tmp42_ = infos;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp42_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			DuplicityJobDateInfo _tmp43_;
			DuplicityJobDateInfo _tmp44_ = {0};
			DuplicityJobDateInfo s = {0};
			_tmp43_ = *((DuplicityJobDateInfo*) s_it->data);
			duplicity_job_date_info_copy (&_tmp43_, &_tmp44_);
			s = _tmp44_;
			{
				DuplicityJobDateInfo _tmp45_;
				DuplicityJobDateInfo _tmp46_;
				DuplicityJobDateInfo* _tmp47_;
				_tmp45_ = s;
				_tmp46_ = _tmp45_;
				_tmp47_ = _duplicity_job_date_info_dup0 (&_tmp46_);
				self->priv->collection_info = g_list_append (self->priv->collection_info, _tmp47_);
				duplicity_job_date_info_destroy (&s);
			}
		}
	}
	_tmp48_ = dates;
	g_signal_emit_by_name ((DejaDupToolJob*) self, "collection-dates", _tmp48_);
	(infos == NULL) ? NULL : (infos = (_g_list_free__duplicity_job_date_info_free0_ (infos), NULL));
	_g_tree_unref0 (dates);
}

static gboolean
duplicity_job_is_file_in_list (DuplicityJob* self,
                               GFile* file,
                               GList* list)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	{
		GList* f_collection = NULL;
		GList* f_it = NULL;
		f_collection = list;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp0_;
			GFile* f = NULL;
			_tmp0_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp0_;
			{
				GFile* _tmp1_;
				_tmp1_ = f;
				if (g_file_equal (file, _tmp1_)) {
					result = TRUE;
					_g_object_unref0 (f);
					return result;
				}
				_g_object_unref0 (f);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
duplicity_job_is_file_in_or_under_list (DuplicityJob* self,
                                        GFile* file,
                                        GList* list)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	{
		GList* f_collection = NULL;
		GList* f_it = NULL;
		f_collection = list;
		for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
			GFile* _tmp0_;
			GFile* f = NULL;
			_tmp0_ = _g_object_ref0 ((GFile*) f_it->data);
			f = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				GFile* _tmp2_;
				_tmp2_ = f;
				if (g_file_equal (file, _tmp2_)) {
					_tmp1_ = TRUE;
				} else {
					GFile* _tmp3_;
					_tmp3_ = f;
					_tmp1_ = g_file_has_prefix (file, _tmp3_);
				}
				if (_tmp1_) {
					result = TRUE;
					_g_object_unref0 (f);
					return result;
				}
				_g_object_unref0 (f);
			}
		}
	}
	result = FALSE;
	return result;
}

static void
duplicity_job_real_process_warning (DuplicityJob* self,
                                    gchar** firstline,
                                    gint firstline_length1,
                                    GList* data,
                                    const gchar* text)
{
	g_return_if_fail (text != NULL);
	if (firstline_length1 > 1) {
		const gchar* _tmp0_;
		_tmp0_ = firstline[1];
		switch (atoi (_tmp0_)) {
			case DUPLICITY_JOB_WARNING_ORPHANED_SIG:
			case DUPLICITY_JOB_WARNING_UNNECESSARY_SIG:
			case DUPLICITY_JOB_WARNING_UNMATCHED_SIG:
			case DUPLICITY_JOB_WARNING_INCOMPLETE_BACKUP:
			case DUPLICITY_JOB_WARNING_ORPHANED_BACKUP:
			{
				gboolean _tmp1_ = FALSE;
				DejaDupToolJobMode _tmp2_;
				DejaDupToolJobMode _tmp3_;
				_tmp2_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
				_tmp3_ = _tmp2_;
				if (_tmp3_ == DEJA_DUP_TOOL_JOB_MODE_BACKUP) {
					_tmp1_ = !self->priv->cleaned_up_once;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					duplicity_job_cleanup (self);
				}
				break;
			}
			case DUPLICITY_JOB_WARNING_CANNOT_STAT:
			case DUPLICITY_JOB_WARNING_CANNOT_READ:
			{
				if (firstline_length1 > 2) {
					GFile* error_file = NULL;
					const gchar* _tmp4_;
					GFile* _tmp5_;
					gboolean _tmp6_ = FALSE;
					GFile* _tmp7_;
					GList* _tmp8_;
					_tmp4_ = firstline[2];
					_tmp5_ = duplicity_job_make_file_obj (self, _tmp4_);
					error_file = _tmp5_;
					_tmp7_ = error_file;
					_tmp8_ = ((DejaDupToolJob*) self)->includes;
					if (duplicity_job_is_file_in_or_under_list (self, _tmp7_, _tmp8_)) {
						GFile* _tmp9_;
						GList* _tmp10_;
						_tmp9_ = error_file;
						_tmp10_ = ((DejaDupToolJob*) self)->excludes;
						_tmp6_ = !duplicity_job_is_file_in_list (self, _tmp9_, _tmp10_);
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						GFile* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp11_ = error_file;
						_tmp12_ = g_file_get_parse_name (_tmp11_);
						_tmp13_ = _tmp12_;
						g_signal_emit_by_name ((DejaDupToolJob*) self, "local-file-error", _tmp13_);
						_g_free0 (_tmp13_);
					}
					_g_object_unref0 (error_file);
				}
				break;
			}
			case DUPLICITY_JOB_WARNING_CANNOT_PROCESS:
			{
				if (firstline_length1 > 2) {
					GFile* error_file = NULL;
					const gchar* _tmp14_;
					GFile* _tmp15_;
					gboolean _tmp16_ = FALSE;
					GFile* _tmp17_;
					GFile* _tmp18_;
					_tmp14_ = firstline[2];
					_tmp15_ = duplicity_job_make_file_obj (self, _tmp14_);
					error_file = _tmp15_;
					_tmp17_ = error_file;
					_tmp18_ = duplicity_job_slash;
					if (!g_file_equal (_tmp17_, _tmp18_)) {
						_tmp16_ = !string_contains (text, "[Errno 1]");
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						GFile* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						_tmp19_ = error_file;
						_tmp20_ = g_file_get_parse_name (_tmp19_);
						_tmp21_ = _tmp20_;
						g_signal_emit_by_name ((DejaDupToolJob*) self, "local-file-error", _tmp21_);
						_g_free0 (_tmp21_);
					}
					_g_object_unref0 (error_file);
				}
				break;
			}
			default:
			break;
		}
	}
}

void
duplicity_job_process_warning (DuplicityJob* self,
                               gchar** firstline,
                               gint firstline_length1,
                               GList* data,
                               const gchar* text)
{
	DuplicityJobClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = DUPLICITY_JOB_GET_CLASS (self);
	if (_klass_->process_warning) {
		_klass_->process_warning (self, firstline, firstline_length1, data, text);
	}
}

static void
duplicity_job_show_error (DuplicityJob* self,
                          const gchar* errorstr,
                          const gchar* detail)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (errorstr != NULL);
	_tmp0_ = self->priv->_error_issued;
	if (_tmp0_ == FALSE) {
		duplicity_job_set_error_issued (self, TRUE);
		g_signal_emit_by_name ((DejaDupToolJob*) self, "raise-error", errorstr, detail);
	}
}

static gint
duplicity_job_get_volsize (DuplicityJob* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (deja_dup_in_testing_mode ()) {
		result = 1;
		return result;
	} else {
		result = 200;
		return result;
	}
}

static void
_duplicity_job_handle_done_duplicity_instance_done (DuplicityInstance* _sender,
                                                    gboolean success,
                                                    gboolean cancelled,
                                                    gpointer self)
{
	duplicity_job_handle_done ((DuplicityJob*) self, _sender, success, cancelled);
}

static void
_duplicity_job_handle_message_duplicity_instance_message (DuplicityInstance* _sender,
                                                          gchar** control_line,
                                                          gint control_line_length1,
                                                          GList* data_lines,
                                                          const gchar* user_text,
                                                          gpointer self)
{
	duplicity_job_handle_message ((DuplicityJob*) self, _sender, control_line, control_line_length1, data_lines, user_text);
}

static void
_duplicity_job_handle_exit_duplicity_instance_exited (DuplicityInstance* _sender,
                                                      gint code,
                                                      gpointer self)
{
	duplicity_job_handle_exit ((DuplicityJob*) self, code);
}

static void
duplicity_job_disconnect_inst (DuplicityJob* self)
{
	DuplicityInstance* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->inst;
	if (_tmp0_ != NULL) {
		DuplicityInstance* _tmp1_;
		guint _tmp2_;
		DuplicityInstance* _tmp3_;
		guint _tmp4_;
		DuplicityInstance* _tmp5_;
		guint _tmp6_;
		DuplicityInstance* _tmp7_;
		_tmp1_ = self->priv->inst;
		g_signal_parse_name ("done", TYPE_DUPLICITY_INSTANCE, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _duplicity_job_handle_done_duplicity_instance_done, self);
		_tmp3_ = self->priv->inst;
		g_signal_parse_name ("message", TYPE_DUPLICITY_INSTANCE, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _duplicity_job_handle_message_duplicity_instance_message, self);
		_tmp5_ = self->priv->inst;
		g_signal_parse_name ("exited", TYPE_DUPLICITY_INSTANCE, &_tmp6_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _duplicity_job_handle_exit_duplicity_instance_exited, self);
		_tmp7_ = self->priv->inst;
		duplicity_instance_cancel (_tmp7_);
		_g_object_unref0 (self->priv->inst);
		self->priv->inst = NULL;
	}
}

static void
duplicity_job_connect_and_start (DuplicityJob* self,
                                 GList* argv_extra,
                                 GList* envp_extra,
                                 GList* argv_entire,
                                 GFile* custom_local)
{
	DuplicityInstance* _tmp0_;
	DuplicityInstance* _tmp1_;
	const gchar* _tmp2_;
	DuplicityInstance* _tmp5_;
	DuplicityInstance* _tmp6_;
	GList* _tmp7_ = NULL;
	GList* base_argv = NULL;
	GFile* _tmp9_ = NULL;
	GFile* local_arg = NULL;
	GList* argv = NULL;
	GList* _tmp12_;
	GList* envp = NULL;
	GList* _tmp59_;
	gboolean use_encryption = FALSE;
	DuplicityInstance* _tmp80_;
	GList* _tmp81_;
	GList* _tmp82_;
	g_return_if_fail (self != NULL);
	duplicity_job_disconnect_inst (self);
	_tmp0_ = duplicity_instance_new ();
	_g_object_unref0 (self->priv->inst);
	self->priv->inst = _tmp0_;
	_tmp1_ = self->priv->inst;
	g_signal_connect_object (_tmp1_, "done", (GCallback) _duplicity_job_handle_done_duplicity_instance_done, self, 0);
	_tmp2_ = self->priv->forced_cache_dir;
	if (_tmp2_ != NULL) {
		DuplicityInstance* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = self->priv->inst;
		_tmp4_ = self->priv->forced_cache_dir;
		duplicity_instance_set_forced_cache_dir (_tmp3_, _tmp4_);
	}
	_tmp5_ = self->priv->inst;
	g_signal_connect_object (_tmp5_, "message", (GCallback) _duplicity_job_handle_message_duplicity_instance_message, self, 0);
	_tmp6_ = self->priv->inst;
	g_signal_connect_object (_tmp6_, "exited", (GCallback) _duplicity_job_handle_exit_duplicity_instance_exited, self, 0);
	if (argv_entire == NULL) {
		GList* _tmp8_;
		_tmp8_ = self->priv->saved_argv;
		_tmp7_ = _tmp8_;
	} else {
		_tmp7_ = argv_entire;
	}
	base_argv = _tmp7_;
	if (custom_local == NULL) {
		GFile* _tmp10_;
		GFile* _tmp11_;
		_tmp10_ = deja_dup_tool_job_get_local ((DejaDupToolJob*) self);
		_tmp11_ = _tmp10_;
		_tmp9_ = _tmp11_;
	} else {
		_tmp9_ = custom_local;
	}
	local_arg = _tmp9_;
	argv = NULL;
	_tmp12_ = base_argv;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp12_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp13_;
			gchar* s = NULL;
			_tmp13_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp13_;
			{
				const gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp14_ = s;
				_tmp15_ = g_strdup (_tmp14_);
				argv = g_list_append (argv, _tmp15_);
				_g_free0 (s);
			}
		}
	}
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = argv_extra;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp16_;
			gchar* s = NULL;
			_tmp16_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp16_;
			{
				const gchar* _tmp17_;
				gchar* _tmp18_;
				_tmp17_ = s;
				_tmp18_ = g_strdup (_tmp17_);
				argv = g_list_append (argv, _tmp18_);
				_g_free0 (s);
			}
		}
	}
	if (argv_entire == NULL) {
		DejaDupToolJobMode _tmp19_;
		DejaDupToolJobMode _tmp20_;
		_tmp19_ = deja_dup_tool_job_get_mode ((DejaDupToolJob*) self);
		_tmp20_ = _tmp19_;
		switch (_tmp20_) {
			case DEJA_DUP_TOOL_JOB_MODE_BACKUP:
			{
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				GList* _tmp23_;
				gchar* _tmp27_;
				GFile* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				if (self->priv->is_full_backup) {
					_tmp21_ = "full";
				} else {
					_tmp21_ = "incremental";
				}
				_tmp22_ = g_strdup (_tmp21_);
				argv = g_list_prepend (argv, _tmp22_);
				_tmp23_ = self->priv->includes_argv;
				{
					GList* s_collection = NULL;
					GList* s_it = NULL;
					s_collection = _tmp23_;
					for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
						gchar* _tmp24_;
						gchar* s = NULL;
						_tmp24_ = g_strdup ((const gchar*) s_it->data);
						s = _tmp24_;
						{
							const gchar* _tmp25_;
							gchar* _tmp26_;
							_tmp25_ = s;
							_tmp26_ = g_strdup (_tmp25_);
							argv = g_list_append (argv, _tmp26_);
							_g_free0 (s);
						}
					}
				}
				_tmp27_ = g_strdup_printf ("--volsize=%d", duplicity_job_get_volsize (self));
				argv = g_list_append (argv, _tmp27_);
				_tmp28_ = local_arg;
				_tmp29_ = g_file_get_path (_tmp28_);
				argv = g_list_append (argv, _tmp29_);
				_tmp30_ = duplicity_job_get_remote (self);
				argv = g_list_append (argv, _tmp30_);
				break;
			}
			case DEJA_DUP_TOOL_JOB_MODE_RESTORE:
			{
				gchar* _tmp31_;
				gboolean _tmp32_ = FALSE;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp40_ = NULL;
				gboolean _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				GFile* _tmp45_;
				gchar* _tmp46_;
				_tmp31_ = g_strdup ("restore");
				argv = g_list_prepend (argv, _tmp31_);
				_tmp33_ = deja_dup_tool_job_get_tag ((DejaDupToolJob*) self);
				_tmp34_ = _tmp33_;
				if (_tmp34_ != NULL) {
					const gchar* _tmp35_;
					const gchar* _tmp36_;
					_tmp35_ = deja_dup_tool_job_get_tag ((DejaDupToolJob*) self);
					_tmp36_ = _tmp35_;
					_tmp32_ = g_strcmp0 (_tmp36_, "now") != 0;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					const gchar* _tmp37_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp37_ = deja_dup_tool_job_get_tag ((DejaDupToolJob*) self);
					_tmp38_ = _tmp37_;
					_tmp39_ = g_strdup_printf ("--time=%s", _tmp38_);
					argv = g_list_append (argv, _tmp39_);
				}
				_tmp41_ = self->priv->_version1_cli;
				if (_tmp41_) {
					_tmp40_ = "--do-not-restore-ownership";
				} else {
					_tmp40_ = "--no-restore-ownership";
				}
				_tmp42_ = g_strdup (_tmp40_);
				argv = g_list_append (argv, _tmp42_);
				_tmp43_ = g_strdup ("--force");
				argv = g_list_append (argv, _tmp43_);
				_tmp44_ = duplicity_job_get_remote (self);
				argv = g_list_append (argv, _tmp44_);
				_tmp45_ = local_arg;
				_tmp46_ = g_file_get_path (_tmp45_);
				argv = g_list_append (argv, _tmp46_);
				break;
			}
			case DEJA_DUP_TOOL_JOB_MODE_STATUS:
			{
				gchar* _tmp47_;
				gchar* _tmp48_;
				_tmp47_ = g_strdup ("collection-status");
				argv = g_list_prepend (argv, _tmp47_);
				_tmp48_ = duplicity_job_get_remote (self);
				argv = g_list_append (argv, _tmp48_);
				break;
			}
			case DEJA_DUP_TOOL_JOB_MODE_LIST:
			{
				gchar* _tmp49_;
				gboolean _tmp50_ = FALSE;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp58_;
				_tmp49_ = g_strdup ("list-current-files");
				argv = g_list_prepend (argv, _tmp49_);
				_tmp51_ = deja_dup_tool_job_get_tag ((DejaDupToolJob*) self);
				_tmp52_ = _tmp51_;
				if (_tmp52_ != NULL) {
					const gchar* _tmp53_;
					const gchar* _tmp54_;
					_tmp53_ = deja_dup_tool_job_get_tag ((DejaDupToolJob*) self);
					_tmp54_ = _tmp53_;
					_tmp50_ = g_strcmp0 (_tmp54_, "now") != 0;
				} else {
					_tmp50_ = FALSE;
				}
				if (_tmp50_) {
					const gchar* _tmp55_;
					const gchar* _tmp56_;
					gchar* _tmp57_;
					_tmp55_ = deja_dup_tool_job_get_tag ((DejaDupToolJob*) self);
					_tmp56_ = _tmp55_;
					_tmp57_ = g_strdup_printf ("--time=%s", _tmp56_);
					argv = g_list_append (argv, _tmp57_);
				}
				_tmp58_ = duplicity_job_get_remote (self);
				argv = g_list_append (argv, _tmp58_);
				break;
			}
			default:
			{
				break;
			}
		}
	}
	envp = NULL;
	_tmp59_ = self->priv->saved_envp;
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = _tmp59_;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp60_;
			gchar* s = NULL;
			_tmp60_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp60_;
			{
				const gchar* _tmp61_;
				gchar* _tmp62_;
				_tmp61_ = s;
				_tmp62_ = g_strdup (_tmp61_);
				envp = g_list_append (envp, _tmp62_);
				_g_free0 (s);
			}
		}
	}
	{
		GList* s_collection = NULL;
		GList* s_it = NULL;
		s_collection = envp_extra;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			gchar* _tmp63_;
			gchar* s = NULL;
			_tmp63_ = g_strdup ((const gchar*) s_it->data);
			s = _tmp63_;
			{
				const gchar* _tmp64_;
				gchar* _tmp65_;
				_tmp64_ = s;
				_tmp65_ = g_strdup (_tmp64_);
				envp = g_list_append (envp, _tmp65_);
				_g_free0 (s);
			}
		}
	}
	use_encryption = FALSE;
	if (self->priv->detected_encryption) {
		use_encryption = self->priv->existing_encrypted;
	} else {
		const gchar* _tmp66_;
		const gchar* _tmp67_;
		_tmp66_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
		_tmp67_ = _tmp66_;
		if (_tmp67_ != NULL) {
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			_tmp68_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
			_tmp69_ = _tmp68_;
			use_encryption = g_strcmp0 (_tmp69_, "") != 0;
		}
	}
	if (use_encryption) {
		gboolean _tmp70_ = FALSE;
		const gchar* _tmp71_;
		const gchar* _tmp72_;
		_tmp71_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
		_tmp72_ = _tmp71_;
		if (_tmp72_ != NULL) {
			const gchar* _tmp73_;
			const gchar* _tmp74_;
			_tmp73_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
			_tmp74_ = _tmp73_;
			_tmp70_ = g_strcmp0 (_tmp74_, "") != 0;
		} else {
			_tmp70_ = FALSE;
		}
		if (_tmp70_) {
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			gchar* _tmp77_;
			_tmp75_ = deja_dup_tool_job_get_encrypt_password ((DejaDupToolJob*) self);
			_tmp76_ = _tmp75_;
			_tmp77_ = g_strdup_printf ("PASSPHRASE=%s", _tmp76_);
			envp = g_list_append (envp, _tmp77_);
		}
	} else {
		gchar* _tmp78_;
		gchar* _tmp79_;
		_tmp78_ = g_strdup ("--no-encryption");
		argv = g_list_append (argv, _tmp78_);
		_tmp79_ = g_strdup ("PASSPHRASE=");
		envp = g_list_append (envp, _tmp79_);
	}
	_tmp80_ = self->priv->inst;
	_tmp81_ = argv;
	_tmp82_ = envp;
	duplicity_instance_start (_tmp80_, _tmp81_, _tmp82_, NULL, NULL);
	(envp == NULL) ? NULL : (envp = (_g_list_free__g_free0_ (envp), NULL));
	(argv == NULL) ? NULL : (argv = (_g_list_free__g_free0_ (argv), NULL));
}

gboolean
duplicity_job_get_version1_cli (DuplicityJob* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_version1_cli;
	return result;
}

static void
duplicity_job_set_version1_cli (DuplicityJob* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = duplicity_job_get_version1_cli (self);
	if (old_value != value) {
		self->priv->_version1_cli = value;
		g_object_notify_by_pspec ((GObject *) self, duplicity_job_properties[DUPLICITY_JOB_VERSION1_CLI_PROPERTY]);
	}
}

static DejaDupToolJobMode
duplicity_job_get_original_mode (DuplicityJob* self)
{
	DejaDupToolJobMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_original_mode;
	return result;
}

static void
duplicity_job_set_original_mode (DuplicityJob* self,
                                 DejaDupToolJobMode value)
{
	g_return_if_fail (self != NULL);
	self->priv->_original_mode = value;
}

static gboolean
duplicity_job_get_error_issued (DuplicityJob* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error_issued;
	return result;
}

static void
duplicity_job_set_error_issued (DuplicityJob* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_error_issued = value;
}

static gboolean
duplicity_job_get_was_stopped (DuplicityJob* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_was_stopped;
	return result;
}

static void
duplicity_job_set_was_stopped (DuplicityJob* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_was_stopped = value;
}

DuplicityJobState
duplicity_job_get_state (DuplicityJob* self)
{
	DuplicityJobState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}

void
duplicity_job_set_state (DuplicityJob* self,
                         DuplicityJobState value)
{
	DuplicityJobState old_value;
	g_return_if_fail (self != NULL);
	old_value = duplicity_job_get_state (self);
	if (old_value != value) {
		self->priv->_state = value;
		g_object_notify_by_pspec ((GObject *) self, duplicity_job_properties[DUPLICITY_JOB_STATE_PROPERTY]);
	}
}

static void
duplicity_job_date_info_copy (const DuplicityJobDateInfo* self,
                              DuplicityJobDateInfo* dest)
{
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	(*dest).full = (*self).full;
	_tmp0_ = (*self).time;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	_g_date_time_unref0 ((*dest).time);
	(*dest).time = _tmp1_;
}

static void
duplicity_job_date_info_destroy (DuplicityJobDateInfo* self)
{
	_g_date_time_unref0 ((*self).time);
}

static DuplicityJobDateInfo*
duplicity_job_date_info_dup (const DuplicityJobDateInfo* self)
{
	DuplicityJobDateInfo* dup;
	dup = g_new0 (DuplicityJobDateInfo, 1);
	duplicity_job_date_info_copy (self, dup);
	return dup;
}

static void
duplicity_job_date_info_free (DuplicityJobDateInfo* self)
{
	duplicity_job_date_info_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
duplicity_job_date_info_get_type_once (void)
{
	GType duplicity_job_date_info_type_id;
	duplicity_job_date_info_type_id = g_boxed_type_register_static ("DuplicityJobDateInfo", (GBoxedCopyFunc) duplicity_job_date_info_dup, (GBoxedFreeFunc) duplicity_job_date_info_free);
	return duplicity_job_date_info_type_id;
}

static GType
duplicity_job_date_info_get_type (void)
{
	static gsize duplicity_job_date_info_type_id__once = 0;
	if (g_once_init_enter (&duplicity_job_date_info_type_id__once)) {
		GType duplicity_job_date_info_type_id;
		duplicity_job_date_info_type_id = duplicity_job_date_info_get_type_once ();
		g_once_init_leave (&duplicity_job_date_info_type_id__once, duplicity_job_date_info_type_id);
	}
	return duplicity_job_date_info_type_id__once;
}

static GObject *
duplicity_job_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DuplicityJob * self;
	GFile* _tmp0_;
	parent_class = G_OBJECT_CLASS (duplicity_job_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_JOB, DuplicityJob);
	_tmp0_ = duplicity_job_slash;
	if (_tmp0_ == NULL) {
		GFile* _tmp1_;
		_tmp1_ = g_file_new_for_path ("/");
		_g_object_unref0 (duplicity_job_slash);
		duplicity_job_slash = _tmp1_;
	}
	return obj;
}

static void
duplicity_job_class_init (DuplicityJobClass * klass,
                          gpointer klass_data)
{
	duplicity_job_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DuplicityJob_private_offset);
	((DejaDupToolJobClass *) klass)->start = (void (*) (DejaDupToolJob*, GAsyncReadyCallback, gpointer)) duplicity_job_real_start;
	((DejaDupToolJobClass *) klass)->start_finish = (void (*) (DejaDupToolJob*, GAsyncResult*)) duplicity_job_start_finish;
	((DejaDupToolJobClass *) klass)->cancel = (void (*) (DejaDupToolJob*)) duplicity_job_real_cancel;
	((DejaDupToolJobClass *) klass)->stop = (void (*) (DejaDupToolJob*)) duplicity_job_real_stop;
	((DejaDupToolJobClass *) klass)->pause = (void (*) (DejaDupToolJob*, const gchar*)) duplicity_job_real_pause;
	((DejaDupToolJobClass *) klass)->resume = (void (*) (DejaDupToolJob*)) duplicity_job_real_resume;
	((DuplicityJobClass *) klass)->process_error = (void (*) (DuplicityJob*, gchar**, gint, GList*, const gchar*)) duplicity_job_real_process_error;
	((DuplicityJobClass *) klass)->process_info = (void (*) (DuplicityJob*, gchar**, gint, GList*, const gchar*)) duplicity_job_real_process_info;
	((DuplicityJobClass *) klass)->process_warning = (void (*) (DuplicityJob*, gchar**, gint, GList*, const gchar*)) duplicity_job_real_process_warning;
	G_OBJECT_CLASS (klass)->get_property = _vala_duplicity_job_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_duplicity_job_set_property;
	G_OBJECT_CLASS (klass)->constructor = duplicity_job_constructor;
	G_OBJECT_CLASS (klass)->finalize = duplicity_job_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DUPLICITY_JOB_VERSION1_CLI_PROPERTY, duplicity_job_properties[DUPLICITY_JOB_VERSION1_CLI_PROPERTY] = g_param_spec_boolean ("version1-cli", "version1-cli", "version1-cli", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DUPLICITY_JOB_STATE_PROPERTY, duplicity_job_properties[DUPLICITY_JOB_STATE_PROPERTY] = g_param_spec_enum ("state", "state", "state", DUPLICITY_JOB_TYPE_STATE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
duplicity_job_instance_init (DuplicityJob * self,
                             gpointer klass)
{
	self->priv = duplicity_job_get_instance_private (self);
	self->priv->_version1_cli = FALSE;
	self->priv->_error_issued = FALSE;
	self->priv->_was_stopped = FALSE;
	self->priv->is_full_backup = FALSE;
	self->priv->cleaned_up_once = FALSE;
	self->priv->detected_encryption = FALSE;
	self->priv->existing_encrypted = FALSE;
	self->priv->has_progress_total = FALSE;
	self->priv->checked_collection_info = FALSE;
	self->priv->got_collection_info = FALSE;
	self->priv->collection_info = NULL;
	self->priv->reported_full_backups = FALSE;
	self->priv->checked_backup_space = FALSE;
	self->priv->deleted_files = FALSE;
	self->priv->delete_age = 0;
	self->priv->last_touched_file = NULL;
	self->priv->forced_cache_dir = NULL;
	self->priv->credentials_dir = NULL;
	self->priv->restarted_without_cache = FALSE;
}

static void
duplicity_job_finalize (GObject * obj)
{
	DuplicityJob * self;
	DejaDupNetwork* _tmp0_;
	DejaDupNetwork* _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICITY_JOB, DuplicityJob);
	_tmp0_ = deja_dup_network_get ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("notify::connected", G_TYPE_OBJECT, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _duplicity_job_network_changed_g_object_notify, self);
	_g_object_unref0 (_tmp1_);
	duplicity_job_clean_credentials_dir (self);
	_g_object_unref0 (self->priv->inst);
	(self->priv->includes_argv == NULL) ? NULL : (self->priv->includes_argv = (_g_list_free__g_free0_ (self->priv->includes_argv), NULL));
	(self->priv->saved_argv == NULL) ? NULL : (self->priv->saved_argv = (_g_list_free__g_free0_ (self->priv->saved_argv), NULL));
	(self->priv->saved_envp == NULL) ? NULL : (self->priv->saved_envp = (_g_list_free__g_free0_ (self->priv->saved_envp), NULL));
	_g_free0 (self->priv->last_bad_volume);
	(self->priv->collection_info == NULL) ? NULL : (self->priv->collection_info = (_g_list_free__duplicity_job_date_info_free0_ (self->priv->collection_info), NULL));
	_g_object_unref0 (self->priv->last_touched_file);
	_g_free0 (self->priv->forced_cache_dir);
	_g_free0 (self->priv->credentials_dir);
	_g_free0 (self->priv->saved_status);
	_g_object_unref0 (self->priv->saved_status_file);
	G_OBJECT_CLASS (duplicity_job_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
duplicity_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DuplicityJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) duplicity_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DuplicityJob), 0, (GInstanceInitFunc) duplicity_job_instance_init, NULL };
	GType duplicity_job_type_id;
	duplicity_job_type_id = g_type_register_static (DEJA_DUP_TYPE_TOOL_JOB, "DuplicityJob", &g_define_type_info, 0);
	DuplicityJob_private_offset = g_type_add_instance_private (duplicity_job_type_id, sizeof (DuplicityJobPrivate));
	return duplicity_job_type_id;
}

GType
duplicity_job_get_type (void)
{
	static gsize duplicity_job_type_id__once = 0;
	if (g_once_init_enter (&duplicity_job_type_id__once)) {
		GType duplicity_job_type_id;
		duplicity_job_type_id = duplicity_job_get_type_once ();
		g_once_init_leave (&duplicity_job_type_id__once, duplicity_job_type_id);
	}
	return duplicity_job_type_id__once;
}

static void
_vala_duplicity_job_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	DuplicityJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DUPLICITY_JOB, DuplicityJob);
	switch (property_id) {
		case DUPLICITY_JOB_VERSION1_CLI_PROPERTY:
		g_value_set_boolean (value, duplicity_job_get_version1_cli (self));
		break;
		case DUPLICITY_JOB_STATE_PROPERTY:
		g_value_set_enum (value, duplicity_job_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_duplicity_job_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	DuplicityJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DUPLICITY_JOB, DuplicityJob);
	switch (property_id) {
		case DUPLICITY_JOB_VERSION1_CLI_PROPERTY:
		duplicity_job_set_version1_cli (self, g_value_get_boolean (value));
		break;
		case DUPLICITY_JOB_STATE_PROPERTY:
		duplicity_job_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

