/* Rclone.c generated by valac 0.56.14, the Vala compiler
 * generated from Rclone.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <glib-object.h>
#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define TYPE_RCLONE (rclone_get_type ())
#define RCLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RCLONE, Rclone))
#define RCLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RCLONE, RcloneClass))
#define IS_RCLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RCLONE))
#define IS_RCLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RCLONE))
#define RCLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RCLONE, RcloneClass))

typedef struct _Rclone Rclone;
typedef struct _RcloneClass RcloneClass;
typedef struct _RclonePrivate RclonePrivate;
enum  {
	RCLONE_0_PROPERTY,
	RCLONE_NUM_PROPERTIES
};
static GParamSpec* rclone_properties[RCLONE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _Rclone {
	GObject parent_instance;
	RclonePrivate * priv;
};

struct _RcloneClass {
	GObjectClass parent_class;
};

static gpointer rclone_parent_class = NULL;

VALA_EXTERN GType rclone_get_type (void) G_GNUC_CONST ;
static gchar* rclone_fill_envp_from_google (DejaDupBackendGoogle* google_backend,
                                     GList** envp);
static gchar* rclone_fill_envp_from_microsoft (DejaDupBackendMicrosoft* microsoft_backend,
                                        GList** envp);
VALA_EXTERN gchar* deja_dup_backend_microsoft_get_folder (DejaDupBackendMicrosoft* self);
VALA_EXTERN gchar* rclone_fill_envp_from_backend (DejaDupBackend* backend,
                                      GList** envp);
VALA_EXTERN gchar* rclone_rclone_command (void);
VALA_EXTERN Rclone* rclone_new (void);
VALA_EXTERN Rclone* rclone_construct (GType object_type);
static GType rclone_get_type_once (void);

static gchar*
rclone_fill_envp_from_google (DejaDupBackendGoogle* google_backend,
                              GList** envp)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* result;
	g_return_val_if_fail (google_backend != NULL, NULL);
	_tmp0_ = g_strdup ("RCLONE_CONFIG_DEJADUPDRIVE_TYPE=drive");
	*envp = g_list_append (*envp, _tmp0_);
	_tmp1_ = g_strdup ("RCLONE_CONFIG_DEJADUPDRIVE_CLIENT_ID=" GOOGLE_CLIENT_ID);
	*envp = g_list_append (*envp, _tmp1_);
	_tmp2_ = deja_dup_backend_oauth_get_full_token ((DejaDupBackendOAuth*) google_backend);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("RCLONE_CONFIG_DEJADUPDRIVE_TOKEN=", _tmp3_, NULL);
	*envp = g_list_append (*envp, _tmp4_);
	_tmp5_ = g_strdup ("RCLONE_CONFIG_DEJADUPDRIVE_SCOPE=drive.file");
	*envp = g_list_append (*envp, _tmp5_);
	_tmp6_ = g_strdup ("RCLONE_CONFIG_DEJADUPDRIVE_USE_TRASH=false");
	*envp = g_list_append (*envp, _tmp6_);
	_tmp7_ = deja_dup_backend_google_get_folder (google_backend);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat ("dejadupdrive:", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	result = _tmp10_;
	return result;
}

static gchar*
rclone_fill_envp_from_microsoft (DejaDupBackendMicrosoft* microsoft_backend,
                                 GList** envp)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (microsoft_backend != NULL, NULL);
	_tmp0_ = g_strdup ("RCLONE_CONFIG_DEJADUPONEDRIVE_TYPE=onedrive");
	*envp = g_list_append (*envp, _tmp0_);
	_tmp1_ = g_strdup ("RCLONE_CONFIG_DEJADUPONEDRIVE_CLIENT_ID=" MICROSOFT_CLIENT_ID);
	*envp = g_list_append (*envp, _tmp1_);
	_tmp2_ = deja_dup_backend_oauth_get_full_token ((DejaDupBackendOAuth*) microsoft_backend);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("RCLONE_CONFIG_DEJADUPONEDRIVE_TOKEN=", _tmp3_, NULL);
	*envp = g_list_append (*envp, _tmp4_);
	_tmp5_ = deja_dup_backend_microsoft_get_drive_id (microsoft_backend);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat ("RCLONE_CONFIG_DEJADUPONEDRIVE_DRIVE_ID=", _tmp6_, NULL);
	*envp = g_list_append (*envp, _tmp7_);
	_tmp8_ = g_strdup ("RCLONE_CONFIG_DEJADUPONEDRIVE_DRIVE_TYPE=personal");
	*envp = g_list_append (*envp, _tmp8_);
	_tmp9_ = deja_dup_backend_microsoft_get_folder (microsoft_backend);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("dejaduponedrive:", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	result = _tmp12_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gchar*
rclone_fill_envp_from_backend (DejaDupBackend* backend,
                               GList** envp)
{
	DejaDupBackendGoogle* google_backend = NULL;
	DejaDupBackendGoogle* _tmp0_;
	DejaDupBackendGoogle* _tmp1_;
	DejaDupBackendMicrosoft* microsoft_backend = NULL;
	DejaDupBackendMicrosoft* _tmp4_;
	DejaDupBackendMicrosoft* _tmp5_;
	gchar* result;
	g_return_val_if_fail (backend != NULL, NULL);
	_tmp0_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_GOOGLE (backend) ? ((DejaDupBackendGoogle*) backend) : NULL);
	google_backend = _tmp0_;
	_tmp1_ = google_backend;
	if (_tmp1_ != NULL) {
		DejaDupBackendGoogle* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = google_backend;
		_tmp3_ = rclone_fill_envp_from_google (_tmp2_, envp);
		result = _tmp3_;
		_g_object_unref0 (google_backend);
		return result;
	}
	_tmp4_ = _g_object_ref0 (DEJA_DUP_IS_BACKEND_MICROSOFT (backend) ? ((DejaDupBackendMicrosoft*) backend) : NULL);
	microsoft_backend = _tmp4_;
	_tmp5_ = microsoft_backend;
	if (_tmp5_ != NULL) {
		DejaDupBackendMicrosoft* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = microsoft_backend;
		_tmp7_ = rclone_fill_envp_from_microsoft (_tmp6_, envp);
		result = _tmp7_;
		_g_object_unref0 (microsoft_backend);
		_g_object_unref0 (google_backend);
		return result;
	}
	result = NULL;
	_g_object_unref0 (microsoft_backend);
	_g_object_unref0 (google_backend);
	return result;
}

gchar*
rclone_rclone_command (void)
{
	gchar* testing_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing_str = _tmp1_;
	_tmp3_ = testing_str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = testing_str;
		_tmp2_ = atoi (_tmp4_) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("rclone");
		result = _tmp5_;
		_g_free0 (testing_str);
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (RCLONE_COMMAND);
		result = _tmp6_;
		_g_free0 (testing_str);
		return result;
	}
}

Rclone*
rclone_construct (GType object_type)
{
	Rclone * self = NULL;
	self = (Rclone*) g_object_new (object_type, NULL);
	return self;
}

Rclone*
rclone_new (void)
{
	return rclone_construct (TYPE_RCLONE);
}

static void
rclone_class_init (RcloneClass * klass,
                   gpointer klass_data)
{
	rclone_parent_class = g_type_class_peek_parent (klass);
}

static void
rclone_instance_init (Rclone * self,
                      gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
rclone_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RcloneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rclone_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Rclone), 0, (GInstanceInitFunc) rclone_instance_init, NULL };
	GType rclone_type_id;
	rclone_type_id = g_type_register_static (G_TYPE_OBJECT, "Rclone", &g_define_type_info, 0);
	return rclone_type_id;
}

GType
rclone_get_type (void)
{
	static gsize rclone_type_id__once = 0;
	if (g_once_init_enter (&rclone_type_id__once)) {
		GType rclone_type_id;
		rclone_type_id = rclone_get_type_once ();
		g_once_init_leave (&rclone_type_id__once, rclone_type_id);
	}
	return rclone_type_id__once;
}

