/* OperationBackup.c generated by valac 0.56.14, the Vala compiler
 * generated from OperationBackup.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>

enum  {
	DEJA_DUP_OPERATION_BACKUP_0_PROPERTY,
	DEJA_DUP_OPERATION_BACKUP_NUM_PROPERTIES
};
static GParamSpec* deja_dup_operation_backup_properties[DEJA_DUP_OPERATION_BACKUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DejaDupOperationBackupStartData DejaDupOperationBackupStartData;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DejaDupOperationBackupOperationFinishedData DejaDupOperationBackupOperationFinishedData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _DejaDupOperationBackupPrivate {
	GFile* metadir;
};

struct _DejaDupOperationBackupStartData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupOperationBackup* self;
};

struct _DejaDupOperationBackupOperationFinishedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupOperationBackup* self;
	gboolean success;
	gboolean cancelled;
	gboolean _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	DejaDupRecursiveDelete* _tmp3_;
	DejaDupRecursiveDelete* _tmp4_;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp5_;
	gchar* tool_name;
	DejaDupFilteredSettings* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	DejaDupOperationVerify* verify;
	DejaDupBackend* _tmp11_;
	DejaDupBackend* _tmp12_;
	DejaDupToolJob* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	DejaDupOperationVerify* _tmp16_;
	DejaDupOperationVerify* _tmp17_;
};

static gint DejaDupOperationBackup_private_offset;
static gpointer deja_dup_operation_backup_parent_class = NULL;

VALA_EXTERN void deja_dup_operation_operation_finished (DejaDupOperation* self,
                                            gboolean success,
                                            gboolean cancelled,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN void deja_dup_operation_operation_finished_finish (DejaDupOperation* self,
                                                   GAsyncResult* _res_);
static void deja_dup_operation_backup_real_start_data_free (gpointer _data);
static void deja_dup_operation_backup_real_start (DejaDupOperation* base,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gboolean deja_dup_operation_backup_real_start_co (DejaDupOperationBackupStartData* _data_);
static void deja_dup_operation_backup_start_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static gchar* deja_dup_operation_backup_real_get_success_detail (DejaDupOperation* base);
static void deja_dup_operation_backup_real_operation_finished_data_free (gpointer _data);
static void deja_dup_operation_backup_real_operation_finished (DejaDupOperation* base,
                                                        gboolean success,
                                                        gboolean cancelled,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static gboolean deja_dup_operation_backup_real_operation_finished_co (DejaDupOperationBackupOperationFinishedData* _data_);
static void deja_dup_operation_backup_operation_finished_ready (GObject* source_object,
                                                         GAsyncResult* _res_,
                                                         gpointer _user_data_);
static void deja_dup_operation_backup_real_send_action_file_changed (DejaDupOperation* base,
                                                              GFile* file,
                                                              gboolean actual);
static GList* deja_dup_operation_backup_real_make_argv (DejaDupOperation* base);
static void deja_dup_operation_backup_add_always_excluded_dirs (DejaDupOperationBackup* self,
                                                         GList** files,
                                                         GList** regexps);
static void deja_dup_operation_backup_fill_metadir (DejaDupOperationBackup* self,
                                             GError** error);
static void deja_dup_operation_backup_finalize (GObject * obj);
static GType deja_dup_operation_backup_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
deja_dup_operation_backup_get_instance_private (DejaDupOperationBackup* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupOperationBackup_private_offset);
}

DejaDupOperationBackup*
deja_dup_operation_backup_construct (GType object_type,
                                     DejaDupBackend* backend)
{
	DejaDupOperationBackup * self = NULL;
	g_return_val_if_fail (backend != NULL, NULL);
	self = (DejaDupOperationBackup*) g_object_new (object_type, "mode", DEJA_DUP_TOOL_JOB_MODE_BACKUP, "backend", backend, NULL);
	return self;
}

DejaDupOperationBackup*
deja_dup_operation_backup_new (DejaDupBackend* backend)
{
	return deja_dup_operation_backup_construct (DEJA_DUP_TYPE_OPERATION_BACKUP, backend);
}

static void
deja_dup_operation_backup_real_start_data_free (gpointer _data)
{
	DejaDupOperationBackupStartData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupOperationBackupStartData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
deja_dup_operation_backup_real_start (DejaDupOperation* base,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	DejaDupOperationBackup * self;
	DejaDupOperationBackupStartData* _data_;
	DejaDupOperationBackup* _tmp0_;
	self = (DejaDupOperationBackup*) base;
	_data_ = g_slice_new0 (DejaDupOperationBackupStartData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_operation_backup_real_start_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_operation_backup_real_start_co (_data_);
}

static void
deja_dup_operation_backup_start_finish (DejaDupOperation* base,
                                        GAsyncResult* _res_)
{
	DejaDupOperationBackupStartData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
deja_dup_operation_backup_start_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	DejaDupOperationBackupStartData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_operation_backup_real_start_co (_data_);
}

static gboolean
deja_dup_operation_backup_real_start_co (DejaDupOperationBackupStartData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	deja_dup_update_last_run_timestamp (DEJA_DUP_LAST_RUN_KEY);
	_data_->_state_ = 1;
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_backup_parent_class)->start (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, DEJA_DUP_TYPE_OPERATION, DejaDupOperation), deja_dup_operation_backup_start_ready, _data_);
	return FALSE;
	_state_1:
	DEJA_DUP_OPERATION_CLASS (deja_dup_operation_backup_parent_class)->start_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, DEJA_DUP_TYPE_OPERATION, DejaDupOperation), _data_->_res_);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
deja_dup_operation_backup_real_get_success_detail (DejaDupOperation* base)
{
	DejaDupOperationBackup * self;
	gchar* detail = NULL;
	GList* error_files = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gchar* result;
	self = (DejaDupOperationBackup*) base;
	detail = NULL;
	_tmp0_ = deja_dup_operation_get_local_error_files ((DejaDupOperation*) self);
	error_files = _tmp0_;
	_tmp1_ = error_files;
	if (g_list_length (_tmp1_) > ((guint) 0)) {
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		GList* _tmp5_;
		_tmp2_ = g_strdup (_ ("Could not back up the following files.  Please make sure you are able " \
"to open them."));
		_g_free0 (detail);
		detail = _tmp2_;
		_tmp3_ = detail;
		_tmp4_ = g_strconcat (_tmp3_, "\n", NULL);
		_g_free0 (detail);
		detail = _tmp4_;
		_tmp5_ = error_files;
		{
			GList* f_collection = NULL;
			GList* f_it = NULL;
			f_collection = _tmp5_;
			for (f_it = f_collection; f_it != NULL; f_it = f_it->next) {
				const gchar* f = NULL;
				f = (const gchar*) f_it->data;
				{
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp6_ = detail;
					_tmp7_ = f;
					_tmp8_ = g_strdup_printf ("\n%s", _tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
					_g_free0 (detail);
					detail = _tmp10_;
					_g_free0 (_tmp9_);
				}
			}
		}
	}
	result = detail;
	(error_files == NULL) ? NULL : (error_files = (g_list_free (error_files), NULL));
	return result;
}

static void
deja_dup_operation_backup_real_operation_finished_data_free (gpointer _data)
{
	DejaDupOperationBackupOperationFinishedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupOperationBackupOperationFinishedData, _data_);
}

static void
deja_dup_operation_backup_real_operation_finished (DejaDupOperation* base,
                                                   gboolean success,
                                                   gboolean cancelled,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	DejaDupOperationBackup * self;
	DejaDupOperationBackupOperationFinishedData* _data_;
	DejaDupOperationBackup* _tmp0_;
	self = (DejaDupOperationBackup*) base;
	_data_ = g_slice_new0 (DejaDupOperationBackupOperationFinishedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_operation_backup_real_operation_finished_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->success = success;
	_data_->cancelled = cancelled;
	deja_dup_operation_backup_real_operation_finished_co (_data_);
}

static void
deja_dup_operation_backup_operation_finished_finish (DejaDupOperation* base,
                                                     GAsyncResult* _res_)
{
	DejaDupOperationBackupOperationFinishedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
deja_dup_operation_backup_operation_finished_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_)
{
	DejaDupOperationBackupOperationFinishedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_operation_backup_real_operation_finished_co (_data_);
}

static gboolean
deja_dup_operation_backup_real_operation_finished_co (DejaDupOperationBackupOperationFinishedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->success) {
		_data_->_tmp0_ = !_data_->cancelled;
	} else {
		_data_->_tmp0_ = FALSE;
	}
	if (_data_->_tmp0_) {
		deja_dup_update_last_run_timestamp (DEJA_DUP_LAST_BACKUP_KEY);
	}
	_data_->_tmp1_ = _data_->self->priv->metadir;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->metadir;
		_data_->_tmp3_ = deja_dup_recursive_delete_new (_data_->_tmp2_, NULL, NULL);
		_data_->_tmp4_ = _data_->_tmp3_;
		deja_dup_recursive_op_start ((DejaDupRecursiveOp*) _data_->_tmp4_);
		_g_object_unref0 (_data_->_tmp4_);
	}
	_data_->_tmp5_ = deja_dup_get_settings (NULL);
	_data_->settings = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->settings;
	_data_->_tmp7_ = g_settings_get_string ((GSettings*) _data_->_tmp6_, DEJA_DUP_TOOL_KEY);
	_data_->tool_name = _data_->_tmp7_;
	if (_data_->success) {
		_data_->_tmp9_ = !_data_->cancelled;
	} else {
		_data_->_tmp9_ = FALSE;
	}
	if (_data_->_tmp9_) {
		_data_->_tmp10_ = _data_->tool_name;
		_data_->_tmp8_ = g_strcmp0 (_data_->_tmp10_, "restic") != 0;
	} else {
		_data_->_tmp8_ = FALSE;
	}
	if (_data_->_tmp8_) {
		_data_->_tmp11_ = deja_dup_operation_get_backend ((DejaDupOperation*) _data_->self);
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp13_ = ((DejaDupOperation*) _data_->self)->job;
		_data_->_tmp14_ = deja_dup_tool_job_get_tag (_data_->_tmp13_);
		_data_->_tmp15_ = _data_->_tmp14_;
		_data_->_tmp16_ = deja_dup_operation_verify_new (_data_->_tmp12_, _data_->_tmp15_);
		_data_->verify = _data_->_tmp16_;
		_data_->_tmp17_ = _data_->verify;
		_data_->_state_ = 1;
		deja_dup_operation_chain_op ((DejaDupOperation*) _data_->self, (DejaDupOperation*) _data_->_tmp17_, _ ("Verifying backup…"), deja_dup_operation_backup_operation_finished_ready, _data_);
		return FALSE;
		_state_1:
		deja_dup_operation_chain_op_finish ((DejaDupOperation*) _data_->self, _data_->_res_);
		_g_object_unref0 (_data_->verify);
	} else {
		_data_->_state_ = 2;
		DEJA_DUP_OPERATION_CLASS (deja_dup_operation_backup_parent_class)->operation_finished (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, DEJA_DUP_TYPE_OPERATION, DejaDupOperation), _data_->success, _data_->cancelled, deja_dup_operation_backup_operation_finished_ready, _data_);
		return FALSE;
		_state_2:
		DEJA_DUP_OPERATION_CLASS (deja_dup_operation_backup_parent_class)->operation_finished_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->self, DEJA_DUP_TYPE_OPERATION, DejaDupOperation), _data_->_res_);
	}
	_g_free0 (_data_->tool_name);
	_g_object_unref0 (_data_->settings);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_operation_backup_real_send_action_file_changed (DejaDupOperation* base,
                                                         GFile* file,
                                                         gboolean actual)
{
	DejaDupOperationBackup * self;
	GFile* _tmp0_;
	self = (DejaDupOperationBackup*) base;
	g_return_if_fail (file != NULL);
	_tmp0_ = self->priv->metadir;
	if (!g_file_has_prefix (file, _tmp0_)) {
		DEJA_DUP_OPERATION_CLASS (deja_dup_operation_backup_parent_class)->send_action_file_changed (G_TYPE_CHECK_INSTANCE_CAST (self, DEJA_DUP_TYPE_OPERATION, DejaDupOperation), file, actual);
	}
}

static GList*
deja_dup_operation_backup_real_make_argv (DejaDupOperation* base)
{
	DejaDupOperationBackup * self;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	GFile** include_list = NULL;
	DejaDupFilteredSettings* _tmp1_;
	gint _tmp2_ = 0;
	GFile** _tmp3_;
	gint include_list_length1;
	gint _include_list_size_;
	GFile** exclude_list = NULL;
	DejaDupFilteredSettings* _tmp4_;
	gint _tmp5_ = 0;
	GFile** _tmp6_;
	gint exclude_list_length1;
	gint _exclude_list_size_;
	DejaDupToolJob* _tmp7_;
	DejaDupToolJob* _tmp8_;
	GFile** _tmp9_;
	gint _tmp9__length1;
	GFile** _tmp14_;
	gint _tmp14__length1;
	DejaDupToolJob* _tmp25_;
	DejaDupInstallEnv* _tmp26_;
	DejaDupInstallEnv* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	GError* _inner_error0_ = NULL;
	GList* result;
	self = (DejaDupOperationBackup*) base;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp3_ = deja_dup_filtered_settings_get_file_list (_tmp1_, DEJA_DUP_INCLUDE_LIST_KEY, &_tmp2_);
	include_list = _tmp3_;
	include_list_length1 = _tmp2_;
	_include_list_size_ = include_list_length1;
	_tmp4_ = settings;
	_tmp6_ = deja_dup_filtered_settings_get_file_list (_tmp4_, DEJA_DUP_EXCLUDE_LIST_KEY, &_tmp5_);
	exclude_list = _tmp6_;
	exclude_list_length1 = _tmp5_;
	_exclude_list_size_ = exclude_list_length1;
	_tmp7_ = ((DejaDupOperation*) self)->job;
	_tmp8_ = ((DejaDupOperation*) self)->job;
	deja_dup_operation_backup_add_always_excluded_dirs (self, &_tmp7_->excludes, &_tmp8_->exclude_regexps);
	_tmp9_ = exclude_list;
	_tmp9__length1 = exclude_list_length1;
	{
		GFile** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp9_;
		s_collection_length1 = _tmp9__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			GFile* _tmp10_;
			GFile* s = NULL;
			_tmp10_ = _g_object_ref0 (s_collection[s_it]);
			s = _tmp10_;
			{
				DejaDupToolJob* _tmp11_;
				GFile* _tmp12_;
				GFile* _tmp13_;
				_tmp11_ = ((DejaDupOperation*) self)->job;
				_tmp12_ = s;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_tmp11_->excludes = g_list_prepend (_tmp11_->excludes, _tmp13_);
				_g_object_unref0 (s);
			}
		}
	}
	_tmp14_ = include_list;
	_tmp14__length1 = include_list_length1;
	{
		GFile** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp14_;
		s_collection_length1 = _tmp14__length1;
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			GFile* _tmp15_;
			GFile* s = NULL;
			_tmp15_ = _g_object_ref0 (s_collection[s_it]);
			s = _tmp15_;
			{
				DejaDupToolJob* _tmp16_;
				GFile* _tmp17_;
				GFile* _tmp18_;
				_tmp16_ = ((DejaDupOperation*) self)->job;
				_tmp17_ = s;
				_tmp18_ = _g_object_ref0 (_tmp17_);
				_tmp16_->includes = g_list_prepend (_tmp16_->includes, _tmp18_);
				_g_object_unref0 (s);
			}
		}
	}
	{
		GFile* _tmp19_;
		DejaDupToolJob* _tmp20_;
		GFile* _tmp21_;
		GFile* _tmp22_;
		_tmp19_ = deja_dup_get_metadir ();
		_g_object_unref0 (self->priv->metadir);
		self->priv->metadir = _tmp19_;
		deja_dup_operation_backup_fill_metadir (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp20_ = ((DejaDupOperation*) self)->job;
		_tmp21_ = self->priv->metadir;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		_tmp20_->includes_priority = g_list_prepend (_tmp20_->includes_priority, _tmp22_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("OperationBackup.vala:90: %s\n", _tmp24_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		exclude_list = (_vala_array_free (exclude_list, exclude_list_length1, (GDestroyNotify) g_object_unref), NULL);
		include_list = (_vala_array_free (include_list, include_list_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (settings);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp25_ = ((DejaDupOperation*) self)->job;
	_tmp26_ = deja_dup_install_env_instance ();
	_tmp27_ = _tmp26_;
	_tmp28_ = deja_dup_install_env_get_read_root (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_file_new_for_path (_tmp29_);
	_tmp31_ = _tmp30_;
	deja_dup_tool_job_set_local (_tmp25_, _tmp31_);
	_g_object_unref0 (_tmp31_);
	_g_free0 (_tmp29_);
	_g_object_unref0 (_tmp27_);
	result = NULL;
	exclude_list = (_vala_array_free (exclude_list, exclude_list_length1, (GDestroyNotify) g_object_unref), NULL);
	include_list = (_vala_array_free (include_list, include_list_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (settings);
	return result;
}

static void
deja_dup_operation_backup_add_always_excluded_dirs (DejaDupOperationBackup* self,
                                                    GList** files,
                                                    GList** regexps)
{
	gchar* cache_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* home_dir = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp20_;
	gint _tmp37_ = 0;
	gchar** _tmp38_;
	GFile* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	GFile* _tmp45_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	cache_dir = _tmp1_;
	_tmp2_ = g_get_home_dir ();
	_tmp3_ = g_strdup (_tmp2_);
	home_dir = _tmp3_;
	_tmp4_ = cache_dir;
	if (_tmp4_ != NULL) {
		GFile* cache = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		const gchar* _tmp9_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		_tmp5_ = cache_dir;
		_tmp6_ = g_file_new_for_path (_tmp5_);
		cache = _tmp6_;
		_tmp7_ = cache;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		*files = g_list_prepend (*files, _tmp8_);
		_tmp9_ = home_dir;
		if (_tmp9_ != NULL) {
			GFile* home = NULL;
			const gchar* _tmp10_;
			GFile* _tmp11_;
			GFile* home_cache = NULL;
			GFile* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			_tmp10_ = home_dir;
			_tmp11_ = g_file_new_for_path (_tmp10_);
			home = _tmp11_;
			_tmp12_ = home;
			_tmp13_ = g_file_get_child (_tmp12_, ".cache");
			home_cache = _tmp13_;
			_tmp14_ = cache;
			_tmp15_ = home_cache;
			if (!g_file_equal (_tmp14_, _tmp15_)) {
				GFile* _tmp16_;
				GFile* _tmp17_;
				_tmp16_ = home_cache;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				*files = g_list_prepend (*files, _tmp17_);
			}
			_g_object_unref0 (home_cache);
			_g_object_unref0 (home);
		}
		_tmp18_ = cache;
		_tmp19_ = g_file_get_child (_tmp18_, PACKAGE);
		*files = g_list_prepend (*files, _tmp19_);
		_g_object_unref0 (cache);
	}
	_tmp20_ = home_dir;
	if (_tmp20_ != NULL) {
		GFile* home = NULL;
		const gchar* _tmp21_;
		GFile* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		GFile* _tmp25_;
		GFile* _tmp26_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		GFile* _tmp29_;
		GFile* _tmp30_;
		GFile* _tmp31_;
		GFile* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp21_ = home_dir;
		_tmp22_ = g_file_new_for_path (_tmp21_);
		home = _tmp22_;
		_tmp23_ = home;
		_tmp24_ = g_file_resolve_relative_path (_tmp23_, ".ccache");
		*files = g_list_prepend (*files, _tmp24_);
		_tmp25_ = home;
		_tmp26_ = g_file_resolve_relative_path (_tmp25_, ".gvfs");
		*files = g_list_prepend (*files, _tmp26_);
		_tmp27_ = home;
		_tmp28_ = g_file_resolve_relative_path (_tmp27_, ".Private");
		*files = g_list_prepend (*files, _tmp28_);
		_tmp29_ = home;
		_tmp30_ = g_file_resolve_relative_path (_tmp29_, ".steam/root");
		*files = g_list_prepend (*files, _tmp30_);
		_tmp31_ = home;
		_tmp32_ = g_file_resolve_relative_path (_tmp31_, ".xsession-errors");
		*files = g_list_prepend (*files, _tmp32_);
		_tmp33_ = home_dir;
		_tmp34_ = g_build_filename (_tmp33_, ".var/app/*/cache", NULL);
		*regexps = g_list_prepend (*regexps, _tmp34_);
		_tmp35_ = home_dir;
		_tmp36_ = g_build_filename (_tmp35_, "snap/*/*/.cache", NULL);
		*regexps = g_list_prepend (*regexps, _tmp36_);
		_g_object_unref0 (home);
	}
	_tmp38_ = deja_dup_get_tempdirs (&_tmp37_);
	{
		gchar** tempdir_collection = NULL;
		gint tempdir_collection_length1 = 0;
		gint _tempdir_collection_size_ = 0;
		gint tempdir_it = 0;
		tempdir_collection = _tmp38_;
		tempdir_collection_length1 = _tmp37_;
		for (tempdir_it = 0; tempdir_it < tempdir_collection_length1; tempdir_it = tempdir_it + 1) {
			gchar* _tmp39_;
			gchar* tempdir = NULL;
			_tmp39_ = g_strdup (tempdir_collection[tempdir_it]);
			tempdir = _tmp39_;
			{
				const gchar* _tmp40_;
				GFile* _tmp41_;
				_tmp40_ = tempdir;
				_tmp41_ = g_file_new_for_path (_tmp40_);
				*files = g_list_prepend (*files, _tmp41_);
				_g_free0 (tempdir);
			}
		}
		tempdir_collection = (_vala_array_free (tempdir_collection, tempdir_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp42_ = g_file_new_for_path ("/dev");
	*files = g_list_prepend (*files, _tmp42_);
	_tmp43_ = g_file_new_for_path ("/proc");
	*files = g_list_prepend (*files, _tmp43_);
	_tmp44_ = g_file_new_for_path ("/run");
	*files = g_list_prepend (*files, _tmp44_);
	_tmp45_ = g_file_new_for_path ("/sys");
	*files = g_list_prepend (*files, _tmp45_);
	_g_free0 (home_dir);
	_g_free0 (cache_dir);
}

static void
deja_dup_operation_backup_fill_metadir (DejaDupOperationBackup* self,
                                        GError** error)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	DejaDupRecursiveDelete* _tmp2_;
	DejaDupRecursiveDelete* _tmp3_;
	GFile* _tmp4_;
	GDateTime* now = NULL;
	GDateTime* _tmp5_;
	gchar* msg = NULL;
	GDateTime* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->metadir;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->metadir;
	_tmp2_ = deja_dup_recursive_delete_new (_tmp1_, NULL, NULL);
	_tmp3_ = _tmp2_;
	deja_dup_recursive_op_start ((DejaDupRecursiveOp*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->metadir;
	g_file_make_directory_with_parents (_tmp4_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp5_ = g_date_time_new_now_utc ();
	now = _tmp5_;
	_tmp6_ = now;
	_tmp7_ = g_date_time_format (_tmp6_, "%s");
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup_printf ("This folder can be safely deleted.\n%s", _tmp8_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	msg = _tmp10_;
	_tmp11_ = self->priv->metadir;
	_tmp12_ = g_file_get_path (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_build_filename (_tmp13_, "README", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = msg;
	g_file_set_contents (_tmp15_, _tmp16_, (gssize) -1, &_inner_error0_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		_g_date_time_unref0 (now);
		return;
	}
	_g_free0 (msg);
	_g_date_time_unref0 (now);
}

static void
deja_dup_operation_backup_class_init (DejaDupOperationBackupClass * klass,
                                      gpointer klass_data)
{
	deja_dup_operation_backup_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupOperationBackup_private_offset);
	((DejaDupOperationClass *) klass)->start = (void (*) (DejaDupOperation*, GAsyncReadyCallback, gpointer)) deja_dup_operation_backup_real_start;
	((DejaDupOperationClass *) klass)->start_finish = (void (*) (DejaDupOperation*, GAsyncResult*)) deja_dup_operation_backup_start_finish;
	((DejaDupOperationClass *) klass)->get_success_detail = (gchar* (*) (DejaDupOperation*)) deja_dup_operation_backup_real_get_success_detail;
	((DejaDupOperationClass *) klass)->operation_finished = (void (*) (DejaDupOperation*, gboolean, gboolean, GAsyncReadyCallback, gpointer)) deja_dup_operation_backup_real_operation_finished;
	((DejaDupOperationClass *) klass)->operation_finished_finish = (void (*) (DejaDupOperation*, GAsyncResult*)) deja_dup_operation_backup_operation_finished_finish;
	((DejaDupOperationClass *) klass)->send_action_file_changed = (void (*) (DejaDupOperation*, GFile*, gboolean)) deja_dup_operation_backup_real_send_action_file_changed;
	((DejaDupOperationClass *) klass)->make_argv = (GList* (*) (DejaDupOperation*)) deja_dup_operation_backup_real_make_argv;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_operation_backup_finalize;
}

static void
deja_dup_operation_backup_instance_init (DejaDupOperationBackup * self,
                                         gpointer klass)
{
	self->priv = deja_dup_operation_backup_get_instance_private (self);
}

static void
deja_dup_operation_backup_finalize (GObject * obj)
{
	DejaDupOperationBackup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_OPERATION_BACKUP, DejaDupOperationBackup);
	_g_object_unref0 (self->priv->metadir);
	G_OBJECT_CLASS (deja_dup_operation_backup_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
deja_dup_operation_backup_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupOperationBackupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_operation_backup_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupOperationBackup), 0, (GInstanceInitFunc) deja_dup_operation_backup_instance_init, NULL };
	GType deja_dup_operation_backup_type_id;
	deja_dup_operation_backup_type_id = g_type_register_static (DEJA_DUP_TYPE_OPERATION, "DejaDupOperationBackup", &g_define_type_info, 0);
	DejaDupOperationBackup_private_offset = g_type_add_instance_private (deja_dup_operation_backup_type_id, sizeof (DejaDupOperationBackupPrivate));
	return deja_dup_operation_backup_type_id;
}

GType
deja_dup_operation_backup_get_type (void)
{
	static gsize deja_dup_operation_backup_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_operation_backup_type_id__once)) {
		GType deja_dup_operation_backup_type_id;
		deja_dup_operation_backup_type_id = deja_dup_operation_backup_get_type_once ();
		g_once_init_leave (&deja_dup_operation_backup_type_id__once, deja_dup_operation_backup_type_id);
	}
	return deja_dup_operation_backup_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

