/* CommonUtils.c generated by valac 0.56.14, the Vala compiler
 * generated from CommonUtils.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <unistd.h>
#include <glib.h>
#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <libsecret/secret.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_rand_free0(var) ((var == NULL) ? NULL : (var = (g_rand_free (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
typedef struct _DejaDupGetNicknameData DejaDupGetNicknameData;
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _DejaDupStorePassphraseData DejaDupStorePassphraseData;
typedef struct _DejaDupGetTempdirData DejaDupGetTempdirData;
typedef struct _DejaDupCleanTempdirsData DejaDupCleanTempdirsData;
typedef struct _Block3Data Block3Data;
typedef struct _DejaDupWaitData DejaDupWaitData;

struct _DejaDupGetNicknameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GFile* f;
	gchar* result;
	gchar* s;
	GFile* _tmp0_;
	GFileInfo* info;
	GFileInfo* _tmp1_;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GError* e;
	GError* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_;
};

struct _DejaDupStorePassphraseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* passphrase;
	gboolean remember;
	SecretSchema* _tmp0_;
	SecretSchema* _tmp1_;
	SecretSchema* _tmp2_;
	SecretSchema* _tmp3_;
	GError* e;
	GError* _tmp4_;
	const gchar* _tmp5_;
	GError* _inner_error0_;
};

struct _DejaDupGetTempdirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* result;
	gchar** tempdirs;
	gint _tmp0_;
	gchar** _tmp1_;
	gint tempdirs_length1;
	gint _tempdirs_size_;
	DejaDupFilteredSettings* settings;
	DejaDupFilteredSettings* _tmp2_;
	GFile** include_list;
	DejaDupFilteredSettings* _tmp3_;
	gint _tmp4_;
	GFile** _tmp5_;
	gint include_list_length1;
	gint _include_list_size_;
	GFile* main_include;
	GFile* home;
	const gchar* _tmp6_;
	GFile* _tmp7_;
	GFile** _tmp8_;
	gint _tmp8__length1;
	GFile** include_collection;
	gint include_collection_length1;
	gint _include_collection_size_;
	gint include_it;
	GFile* _tmp9_;
	GFile* include;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* filesystem_id;
	GFileInfo* info;
	GFile* _tmp21_;
	GFileInfo* _tmp22_;
	GFileInfo* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gchar** tempdir_collection;
	gint tempdir_collection_length1;
	gint _tempdir_collection_size_;
	gint tempdir_it;
	gchar* _tmp30_;
	gchar* tempdir;
	gchar* temp_id;
	const gchar* _tmp31_;
	GFile* gfile;
	const gchar* _tmp32_;
	GFile* _tmp33_;
	GFileInfo* _vala1_info;
	GFile* _tmp34_;
	GFileInfo* _tmp35_;
	GFileInfo* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	GError* _inner_error0_;
};

struct _DejaDupCleanTempdirsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean all;
	gchar** tempdirs;
	gint _tmp0_;
	gchar** _tmp1_;
	gint tempdirs_length1;
	gint _tempdirs_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** tempdir_collection;
	gint tempdir_collection_length1;
	gint _tempdir_collection_size_;
	gint tempdir_it;
	gchar* _tmp3_;
	gchar* tempdir;
	GFile* gfile;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFileEnumerator* enumerator;
	GFile* _tmp6_;
	GFileEnumerator* _tmp7_;
	GList* infos;
	GFileEnumerator* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp11_;
	GFileInfo* info;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GFileInfo* _tmp14_;
	const gchar* _tmp15_;
	GFileInfo* _tmp16_;
	const gchar* _tmp17_;
	gboolean _tmp18_;
	GFileInfo* _tmp19_;
	const gchar* _tmp20_;
	GFile* child;
	GFile* _tmp21_;
	GFileInfo* _tmp22_;
	const gchar* _tmp23_;
	GFile* _tmp24_;
	GFile* _tmp25_;
	DejaDupRecursiveDelete* _tmp26_;
	DejaDupRecursiveDelete* _tmp27_;
	GList* _tmp28_;
	GError* _inner_error0_;
};

struct _Block3Data {
	int _ref_count_;
	gpointer _async_data_;
};

struct _DejaDupWaitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	guint secs;
	Block3Data* _data3_;
};

VALA_EXTERN guint32 deja_dup_machine_id;
guint32 deja_dup_machine_id = (guint32) 0;
VALA_EXTERN DejaDupToolPlugin* deja_dup_tool;
DejaDupToolPlugin* deja_dup_tool = NULL;
VALA_EXTERN GFile* deja_dup_home;
GFile* deja_dup_home = NULL;
VALA_EXTERN GFile* deja_dup_trash;
GFile* deja_dup_trash = NULL;
VALA_EXTERN GVolumeMonitor* deja_dup__monitor;
GVolumeMonitor* deja_dup__monitor = NULL;

VALA_EXTERN gchar* deja_dup_current_time_as_iso8601 (void);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN guint32 deja_dup_get_machine_id (void);
VALA_EXTERN void deja_dup_update_time_key (const gchar* key,
                               gboolean cancel);
VALA_EXTERN void deja_dup_ensure_special_paths (void);
static void deja_dup_get_nickname_data_free (gpointer _data);
static gboolean deja_dup_get_nickname_co (DejaDupGetNicknameData* _data_);
static void deja_dup_get_nickname_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_);
static void deja_dup_store_passphrase_data_free (gpointer _data);
static gboolean deja_dup_store_passphrase_co (DejaDupStorePassphraseData* _data_);
static void deja_dup_get_tempdir_data_free (gpointer _data);
static gboolean deja_dup_get_tempdir_co (DejaDupGetTempdirData* _data_);
static void deja_dup_get_tempdir_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void deja_dup_clean_tempdirs_data_free (gpointer _data);
static gboolean deja_dup_clean_tempdirs_co (DejaDupCleanTempdirsData* _data_);
static void deja_dup_clean_tempdirs_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void deja_dup_wait_data_free (gpointer _data);
VALA_EXTERN void deja_dup_wait (guint secs,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_);
VALA_EXTERN void deja_dup_wait_finish (GAsyncResult* _res_);
static gboolean deja_dup_wait_co (DejaDupWaitData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda7_ (Block3Data* _data3_);
static gboolean ___lambda7__gsource_func (gpointer self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

GQuark
deja_dup_backup_error_quark (void)
{
	return g_quark_from_static_string ("deja-dup-backup-error-quark");
}

 G_GNUC_NO_INLINE static GType
deja_dup_backup_error_get_type_once (void)
{
	static const GEnumValue values[] = {{DEJA_DUP_BACKUP_ERROR_BAD_CONFIG, "DEJA_DUP_BACKUP_ERROR_BAD_CONFIG", "bad-config"}, {DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING, "DEJA_DUP_BACKUP_ERROR_ALREADY_RUNNING", "already-running"}, {0, NULL, NULL}};
	GType deja_dup_backup_error_type_id;
	deja_dup_backup_error_type_id = g_enum_register_static ("DejaDupBackupError", values);
	return deja_dup_backup_error_type_id;
}

GType
deja_dup_backup_error_get_type (void)
{
	static gsize deja_dup_backup_error_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_backup_error_type_id__once)) {
		GType deja_dup_backup_error_type_id;
		deja_dup_backup_error_type_id = deja_dup_backup_error_get_type_once ();
		g_once_init_leave (&deja_dup_backup_error_type_id__once, deja_dup_backup_error_type_id);
	}
	return deja_dup_backup_error_type_id__once;
}

gboolean
deja_dup_in_testing_mode (void)
{
	gchar* testing_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing_str = _tmp1_;
	_tmp3_ = testing_str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = testing_str;
		_tmp2_ = atoi (_tmp4_) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (testing_str);
	return result;
}

gboolean
deja_dup_in_demo_mode (void)
{
	gchar* demo_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean result;
	_tmp0_ = g_getenv ("DEJA_DUP_DEMO");
	_tmp1_ = g_strdup (_tmp0_);
	demo_str = _tmp1_;
	_tmp3_ = demo_str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = demo_str;
		_tmp2_ = atoi (_tmp4_) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	result = _tmp2_;
	_g_free0 (demo_str);
	return result;
}

gchar*
deja_dup_current_time_as_iso8601 (void)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_date_time_new_now_utc ();
	now = _tmp0_;
	_tmp1_ = g_date_time_format_iso8601 (now);
	result = _tmp1_;
	_g_date_time_unref0 (now);
	return result;
}

void
deja_dup_update_last_run_timestamp (const gchar* key)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (key != NULL);
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = deja_dup_current_time_as_iso8601 ();
	_tmp2_ = _tmp1_;
	deja_dup_filtered_settings_set_string (settings, key, _tmp2_);
	_g_free0 (_tmp2_);
	_g_object_unref0 (settings);
}

gboolean
deja_dup_parse_version (const gchar* version_string,
                        gint* major,
                        gint* minor,
                        gint* micro)
{
	gint _vala_major = 0;
	gint _vala_minor = 0;
	gint _vala_micro = 0;
	gchar** ver_tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint ver_tokens_length1;
	gint _ver_tokens_size_;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gboolean result;
	g_return_val_if_fail (version_string != NULL, FALSE);
	_vala_major = 0;
	_vala_minor = 0;
	_vala_micro = 0;
	_tmp1_ = _tmp0_ = g_strsplit (version_string, ".", 0);
	ver_tokens = _tmp1_;
	ver_tokens_length1 = _vala_array_length (_tmp0_);
	_ver_tokens_size_ = ver_tokens_length1;
	_tmp3_ = ver_tokens;
	_tmp3__length1 = ver_tokens_length1;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_;
		gint _tmp4__length1;
		const gchar* _tmp5_;
		_tmp4_ = ver_tokens;
		_tmp4__length1 = ver_tokens_length1;
		_tmp5_ = _tmp4_[0];
		_tmp2_ = _tmp5_ == NULL;
	}
	if (_tmp2_) {
		result = FALSE;
		ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
		if (major) {
			*major = _vala_major;
		}
		if (minor) {
			*minor = _vala_minor;
		}
		if (micro) {
			*micro = _vala_micro;
		}
		return result;
	}
	_tmp6_ = ver_tokens;
	_tmp6__length1 = ver_tokens_length1;
	_tmp7_ = _tmp6_[0];
	_vala_major = atoi (_tmp7_);
	_tmp8_ = ver_tokens;
	_tmp8__length1 = ver_tokens_length1;
	_tmp9_ = _tmp8_[1];
	if (_tmp9_ != NULL) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		const gchar* _tmp13_;
		_tmp10_ = ver_tokens;
		_tmp10__length1 = ver_tokens_length1;
		_tmp11_ = _tmp10_[1];
		_vala_minor = atoi (_tmp11_);
		_tmp12_ = ver_tokens;
		_tmp12__length1 = ver_tokens_length1;
		_tmp13_ = _tmp12_[2];
		if (_tmp13_ != NULL) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			_tmp14_ = ver_tokens;
			_tmp14__length1 = ver_tokens_length1;
			_tmp15_ = _tmp14_[2];
			_vala_micro = atoi (_tmp15_);
		}
	}
	result = TRUE;
	ver_tokens = (_vala_array_free (ver_tokens, ver_tokens_length1, (GDestroyNotify) g_free), NULL);
	if (major) {
		*major = _vala_major;
	}
	if (minor) {
		*minor = _vala_minor;
	}
	if (micro) {
		*micro = _vala_micro;
	}
	return result;
}

gboolean
deja_dup_equals_version (gint major,
                         gint minor,
                         gint micro,
                         gint req_major,
                         gint req_minor,
                         gint req_micro)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (major == req_major) {
		_tmp1_ = minor == req_minor;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = micro == req_micro;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
deja_dup_meets_version (gint major,
                        gint minor,
                        gint micro,
                        gint req_major,
                        gint req_minor,
                        gint req_micro)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	if (major > req_major) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (major == req_major) {
			_tmp2_ = minor > req_minor;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp1_ = _tmp2_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (major == req_major) {
			_tmp4_ = minor == req_minor;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = micro >= req_micro;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

gchar*
deja_dup_nice_prefix (const gchar* command)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	gint major = 0;
	gint minor = 0;
	gint micro = 0;
	struct utsname utsname = {0};
	struct utsname _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	struct utsname _tmp18_;
	const gchar* _tmp19_;
	gchar* result;
	g_return_val_if_fail (command != NULL, NULL);
	_tmp0_ = g_strdup (command);
	cmd = _tmp0_;
	uname (&utsname);
	_tmp1_ = utsname;
	_tmp2_ = _tmp1_.release;
	deja_dup_parse_version (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
	major = _tmp3_;
	minor = _tmp4_;
	micro = _tmp5_;
	_tmp6_ = g_find_program_in_path ("ionice");
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_ != NULL;
	_g_free0 (_tmp7_);
	if (_tmp8_) {
		gboolean _tmp9_ = FALSE;
		struct utsname _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = utsname;
		_tmp11_ = _tmp10_.sysname;
		if (g_strcmp0 (_tmp11_, "Linux") == 0) {
			_tmp9_ = deja_dup_meets_version (major, minor, micro, 2, 6, 25);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = cmd;
			_tmp13_ = g_strconcat ("ionice -c3 ", _tmp12_, NULL);
			_g_free0 (cmd);
			cmd = _tmp13_;
		} else {
			const gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = cmd;
			_tmp15_ = g_strconcat ("ionice -c2 -n7 ", _tmp14_, NULL);
			_g_free0 (cmd);
			cmd = _tmp15_;
		}
	}
	_tmp18_ = utsname;
	_tmp19_ = _tmp18_.sysname;
	if (g_strcmp0 (_tmp19_, "Linux") == 0) {
		_tmp17_ = deja_dup_meets_version (major, minor, micro, 2, 6, 23);
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = g_find_program_in_path ("chrt");
		_tmp21_ = _tmp20_;
		_tmp16_ = _tmp21_ != NULL;
		_g_free0 (_tmp21_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp22_ = cmd;
		_tmp23_ = g_strconcat ("chrt --idle 0 ", _tmp22_, NULL);
		_g_free0 (cmd);
		cmd = _tmp23_;
	} else {
		gchar* _tmp24_;
		gchar* _tmp25_;
		gboolean _tmp26_;
		_tmp24_ = g_find_program_in_path ("nice");
		_tmp25_ = _tmp24_;
		_tmp26_ = _tmp25_ != NULL;
		_g_free0 (_tmp25_);
		if (_tmp26_) {
			const gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp27_ = cmd;
			_tmp28_ = g_strconcat ("nice -n19 ", _tmp27_, NULL);
			_g_free0 (cmd);
			cmd = _tmp28_;
		}
	}
	result = cmd;
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
deja_dup_run_deja_dup (gchar** args,
                       gint args_length1,
                       const gchar* exec)
{
	gchar* command = NULL;
	gchar* _tmp0_;
	gchar** argv = NULL;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint argv_length1;
	gint _argv_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (exec != NULL);
	_tmp0_ = deja_dup_nice_prefix (exec);
	command = _tmp0_;
	_tmp1_ = command;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 0);
	argv = _tmp3_;
	argv_length1 = _vala_array_length (_tmp2_);
	_argv_size_ = argv_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = args;
		arg_collection_length1 = args_length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			gchar* _tmp4_;
			gchar* arg = NULL;
			_tmp4_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = arg;
				_tmp6_ = g_strdup (_tmp5_);
				_vala_array_add2 (&argv, &argv_length1, &_argv_size_, _tmp6_);
				_g_free0 (arg);
			}
		}
	}
	{
		gchar** _tmp7_;
		gint _tmp7__length1;
		_tmp7_ = argv;
		_tmp7__length1 = argv_length1;
		g_spawn_async (NULL, _tmp7_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("CommonUtils.vala:149: %s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (command);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (command);
}

gchar*
deja_dup_get_monitor_exec (void)
{
	gchar* monitor_exec = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* _tmp7_;
	gchar* result;
	_tmp0_ = g_getenv ("DEJA_DUP_MONITOR_EXEC");
	_tmp1_ = g_strdup (_tmp0_);
	monitor_exec = _tmp1_;
	_tmp3_ = monitor_exec;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = monitor_exec;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = monitor_exec;
		return result;
	}
	_tmp7_ = g_build_filename (PKG_LIBEXEC_DIR, "deja-dup-monitor", NULL);
	result = _tmp7_;
	_g_free0 (monitor_exec);
	return result;
}

gchar*
deja_dup_get_application_path (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup ("/org/gnome/DejaDup" PROFILE);
	result = _tmp0_;
	return result;
}

guint32
deja_dup_get_machine_id (void)
{
	gchar* machine_string = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	GError* _inner_error0_ = NULL;
	guint32 result;
	if (deja_dup_machine_id > ((guint32) 0)) {
		result = deja_dup_machine_id;
		return result;
	}
	{
		gchar* _tmp0_ = NULL;
		g_file_get_contents ("/etc/machine-id", &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (machine_string);
		machine_string = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint32 _tmp1_ = 0U;
		_g_free0 (machine_string);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp1_;
	}
	_tmp2_ = machine_string;
	if (_tmp2_ == NULL) {
		{
			gchar* _tmp3_ = NULL;
			g_file_get_contents ("/var/lib/dbus/machine-id", &_tmp3_, NULL, &_inner_error0_);
			_g_free0 (machine_string);
			machine_string = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint32 _tmp4_ = 0U;
			_g_free0 (machine_string);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	_tmp5_ = machine_string;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		_tmp6_ = machine_string;
		deja_dup_machine_id = (guint32) g_ascii_strtoull (_tmp6_, NULL, (guint) 16);
	}
	if (deja_dup_machine_id == ((guint32) 0)) {
		deja_dup_machine_id = (guint32) gethostid ();
	}
	result = deja_dup_machine_id;
	_g_free0 (machine_string);
	return result;
}

GDateTime*
deja_dup_most_recent_scheduled_date (GTimeSpan period)
{
	GDateTime* epoch = NULL;
	GDateTime* _tmp0_;
	GRand* rand = NULL;
	GRand* _tmp1_;
	GTimeSpan early_hour = 0LL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	GDateTime* cur_date = NULL;
	GDateTime* _tmp5_;
	GTimeSpan between = 0LL;
	GDateTime* _tmp6_;
	GTimeSpan mod = 0LL;
	GDateTime* _tmp7_;
	GDateTime* result;
	_tmp0_ = g_date_time_new_from_unix_local ((gint64) 0);
	epoch = _tmp0_;
	_tmp1_ = g_rand_new_with_seed (deja_dup_get_machine_id ());
	rand = _tmp1_;
	early_hour = (GTimeSpan) (g_rand_double_range (rand, (gdouble) 2, (gdouble) 4) * G_TIME_SPAN_HOUR);
	_tmp2_ = epoch;
	_tmp3_ = epoch;
	_tmp4_ = g_date_time_add (_tmp2_, early_hour - g_date_time_get_utc_offset (_tmp3_));
	_g_date_time_unref0 (epoch);
	epoch = _tmp4_;
	_tmp5_ = g_date_time_new_now_local ();
	cur_date = _tmp5_;
	_tmp6_ = epoch;
	between = g_date_time_difference (cur_date, _tmp6_);
	mod = between % period;
	_tmp7_ = g_date_time_add (cur_date, -1 * mod);
	result = _tmp7_;
	_g_date_time_unref0 (cur_date);
	_g_rand_free0 (rand);
	_g_date_time_unref0 (epoch);
	return result;
}

GTimeSpan
deja_dup_get_day (void)
{
	GTimeSpan result;
	if (deja_dup_in_testing_mode ()) {
		result = G_TIME_SPAN_SECOND * ((GTimeSpan) 10);
		return result;
	} else {
		result = G_TIME_SPAN_DAY;
		return result;
	}
}

GDateTime*
deja_dup_next_possible_run_date (void)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gint period_days = 0;
	DejaDupFilteredSettings* _tmp1_;
	gchar* last_run_string = NULL;
	DejaDupFilteredSettings* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GDateTime* last_run = NULL;
	const gchar* _tmp6_;
	GTimeZone* _tmp7_;
	GTimeZone* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	GTimeSpan period = 0LL;
	GDateTime* last_scheduled = NULL;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* result;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	period_days = g_settings_get_int ((GSettings*) _tmp1_, DEJA_DUP_PERIODIC_PERIOD_KEY);
	_tmp2_ = settings;
	_tmp3_ = g_settings_get_string ((GSettings*) _tmp2_, DEJA_DUP_LAST_BACKUP_KEY);
	last_run_string = _tmp3_;
	_tmp4_ = last_run_string;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		GDateTime* _tmp5_;
		_tmp5_ = g_date_time_new_now_local ();
		result = _tmp5_;
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return result;
	}
	if (period_days <= 0) {
		period_days = 1;
	}
	_tmp6_ = last_run_string;
	_tmp7_ = g_time_zone_new_utc ();
	_tmp8_ = _tmp7_;
	_tmp9_ = g_date_time_new_from_iso8601 (_tmp6_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_time_zone_unref0 (_tmp8_);
	last_run = _tmp10_;
	_tmp11_ = last_run;
	if (_tmp11_ == NULL) {
		GDateTime* _tmp12_;
		_tmp12_ = g_date_time_new_now_local ();
		result = _tmp12_;
		_g_date_time_unref0 (last_run);
		_g_free0 (last_run_string);
		_g_object_unref0 (settings);
		return result;
	}
	period = ((GTimeSpan) period_days) * deja_dup_get_day ();
	_tmp13_ = deja_dup_most_recent_scheduled_date (period);
	last_scheduled = _tmp13_;
	_tmp14_ = last_scheduled;
	_tmp15_ = last_run;
	if (g_date_time_compare (_tmp14_, _tmp15_) <= 0) {
		GDateTime* _tmp16_;
		GDateTime* _tmp17_;
		_tmp16_ = last_scheduled;
		_tmp17_ = g_date_time_add (_tmp16_, period);
		_g_date_time_unref0 (last_scheduled);
		last_scheduled = _tmp17_;
	}
	result = last_scheduled;
	_g_date_time_unref0 (last_run);
	_g_free0 (last_run_string);
	_g_object_unref0 (settings);
	return result;
}

GDateTime*
deja_dup_next_run_date (void)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gboolean periodic = FALSE;
	DejaDupFilteredSettings* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* result;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	periodic = g_settings_get_boolean ((GSettings*) _tmp1_, DEJA_DUP_PERIODIC_KEY);
	if (!periodic) {
		result = NULL;
		_g_object_unref0 (settings);
		return result;
	}
	_tmp2_ = deja_dup_next_possible_run_date ();
	result = _tmp2_;
	_g_object_unref0 (settings);
	return result;
}

gint
deja_dup_get_prompt_delay (void)
{
	GTimeSpan span = 0LL;
	gint result;
	span = (GTimeSpan) 0;
	if (deja_dup_in_testing_mode ()) {
		span = G_TIME_SPAN_MINUTE * 2;
	} else {
		span = G_TIME_SPAN_DAY * 30;
	}
	result = (gint) (span / G_TIME_SPAN_SECOND);
	return result;
}

gboolean
deja_dup_make_prompt_check (void)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* prompt = NULL;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GDateTime* last_run = NULL;
	const gchar* _tmp9_;
	GTimeZone* _tmp10_;
	GTimeZone* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* now = NULL;
	GDateTime* _tmp17_;
	GDateTime* _tmp18_;
	GDateTime* _tmp19_;
	gboolean result;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_PROMPT_CHECK_KEY);
	prompt = _tmp2_;
	_tmp3_ = prompt;
	if (g_strcmp0 (_tmp3_, "disabled") == 0) {
		result = FALSE;
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return result;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = prompt;
		if (g_strcmp0 (_tmp4_, "") == 0) {
			deja_dup_update_prompt_time (FALSE);
			result = FALSE;
			_g_free0 (prompt);
			_g_object_unref0 (settings);
			return result;
		} else {
			DejaDupFilteredSettings* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			_tmp5_ = settings;
			_tmp6_ = g_settings_get_string ((GSettings*) _tmp5_, DEJA_DUP_LAST_RUN_KEY);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp7_, "") != 0;
			_g_free0 (_tmp7_);
			if (_tmp8_) {
				result = FALSE;
				_g_free0 (prompt);
				_g_object_unref0 (settings);
				return result;
			}
		}
	}
	_tmp9_ = prompt;
	_tmp10_ = g_time_zone_new_utc ();
	_tmp11_ = _tmp10_;
	_tmp12_ = g_date_time_new_from_iso8601 (_tmp9_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_time_zone_unref0 (_tmp11_);
	last_run = _tmp13_;
	_tmp14_ = last_run;
	if (_tmp14_ == NULL) {
		result = FALSE;
		_g_date_time_unref0 (last_run);
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp15_ = last_run;
	_tmp16_ = g_date_time_add_seconds (_tmp15_, (gdouble) deja_dup_get_prompt_delay ());
	_g_date_time_unref0 (last_run);
	last_run = _tmp16_;
	_tmp17_ = g_date_time_new_now_local ();
	now = _tmp17_;
	_tmp18_ = last_run;
	_tmp19_ = now;
	if (g_date_time_compare (_tmp18_, _tmp19_) <= 0) {
		gchar* _tmp20_;
		gchar** _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		_tmp20_ = g_strdup ("--prompt");
		_tmp21_ = g_new0 (gchar*, 1 + 1);
		_tmp21_[0] = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp22__length1 = 1;
		deja_dup_run_deja_dup (_tmp22_, (gint) 1, "deja-dup");
		_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
		result = TRUE;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (last_run);
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return result;
	} else {
		result = FALSE;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (last_run);
		_g_free0 (prompt);
		_g_object_unref0 (settings);
		return result;
	}
}

void
deja_dup_update_time_key (const gchar* key,
                          gboolean cancel)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* cur_time_str = NULL;
	DejaDupFilteredSettings* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (key != NULL);
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, key);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "disabled") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		_g_object_unref0 (settings);
		return;
	}
	if (cancel) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("disabled");
		_g_free0 (cur_time_str);
		cur_time_str = _tmp5_;
	} else {
		gchar* _tmp6_;
		_tmp6_ = deja_dup_current_time_as_iso8601 ();
		_g_free0 (cur_time_str);
		cur_time_str = _tmp6_;
	}
	_tmp7_ = settings;
	_tmp8_ = cur_time_str;
	deja_dup_filtered_settings_set_string (_tmp7_, key, _tmp8_);
	_g_free0 (cur_time_str);
	_g_object_unref0 (settings);
}

void
deja_dup_update_prompt_time (gboolean cancel)
{
	deja_dup_update_time_key (DEJA_DUP_PROMPT_CHECK_KEY, cancel);
}

void
deja_dup_update_nag_time (gboolean cancel)
{
	deja_dup_update_time_key (DEJA_DUP_NAG_CHECK_KEY, cancel);
}

gint
deja_dup_get_nag_delay (void)
{
	GTimeSpan span = 0LL;
	gint result;
	span = (GTimeSpan) 0;
	if (deja_dup_in_testing_mode ()) {
		span = G_TIME_SPAN_MINUTE * 2;
	} else {
		span = (G_TIME_SPAN_DAY * 30) * 2;
	}
	result = (gint) (span / G_TIME_SPAN_SECOND);
	return result;
}

gboolean
deja_dup_is_nag_time (void)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* nag = NULL;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* last_run_string = NULL;
	DejaDupFilteredSettings* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	GDateTime* last_check = NULL;
	const gchar* _tmp9_;
	GTimeZone* _tmp10_;
	GTimeZone* _tmp11_;
	GDateTime* _tmp12_;
	GDateTime* _tmp13_;
	GDateTime* _tmp14_;
	GDateTime* _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* now = NULL;
	GDateTime* _tmp17_;
	GDateTime* _tmp18_;
	GDateTime* _tmp19_;
	gboolean result;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_NAG_CHECK_KEY);
	nag = _tmp2_;
	_tmp3_ = settings;
	_tmp4_ = g_settings_get_string ((GSettings*) _tmp3_, DEJA_DUP_LAST_BACKUP_KEY);
	last_run_string = _tmp4_;
	_tmp6_ = nag;
	if (g_strcmp0 (_tmp6_, "disabled") == 0) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp7_;
		_tmp7_ = last_run_string;
		_tmp5_ = g_strcmp0 (_tmp7_, "") == 0;
	}
	if (_tmp5_) {
		result = FALSE;
		_g_free0 (last_run_string);
		_g_free0 (nag);
		_g_object_unref0 (settings);
		return result;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = nag;
		if (g_strcmp0 (_tmp8_, "") == 0) {
			deja_dup_update_nag_time (FALSE);
			result = FALSE;
			_g_free0 (last_run_string);
			_g_free0 (nag);
			_g_object_unref0 (settings);
			return result;
		}
	}
	_tmp9_ = nag;
	_tmp10_ = g_time_zone_new_utc ();
	_tmp11_ = _tmp10_;
	_tmp12_ = g_date_time_new_from_iso8601 (_tmp9_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_time_zone_unref0 (_tmp11_);
	last_check = _tmp13_;
	_tmp14_ = last_check;
	if (_tmp14_ == NULL) {
		result = FALSE;
		_g_date_time_unref0 (last_check);
		_g_free0 (last_run_string);
		_g_free0 (nag);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp15_ = last_check;
	_tmp16_ = g_date_time_add_seconds (_tmp15_, (gdouble) deja_dup_get_nag_delay ());
	_g_date_time_unref0 (last_check);
	last_check = _tmp16_;
	_tmp17_ = g_date_time_new_now_local ();
	now = _tmp17_;
	_tmp18_ = last_check;
	_tmp19_ = now;
	result = g_date_time_compare (_tmp18_, _tmp19_) <= 0;
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (last_check);
	_g_free0 (last_run_string);
	_g_free0 (nag);
	_g_object_unref0 (settings);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
deja_dup_process_folder_key (const gchar* folder,
                             gboolean abs_allowed,
                             gboolean* replaced)
{
	gboolean _vala_replaced = FALSE;
	gchar* processed = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp5_ = FALSE;
	gchar* result;
	g_return_val_if_fail (folder != NULL, NULL);
	_vala_replaced = FALSE;
	_tmp0_ = g_strdup (folder);
	processed = _tmp0_;
	_tmp1_ = processed;
	if (string_contains (_tmp1_, "$HOSTNAME")) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = processed;
		_tmp3_ = g_get_host_name ();
		_tmp4_ = string_replace (_tmp2_, "$HOSTNAME", _tmp3_);
		_g_free0 (processed);
		processed = _tmp4_;
		_vala_replaced = TRUE;
	}
	if (!abs_allowed) {
		const gchar* _tmp6_;
		_tmp6_ = processed;
		_tmp5_ = g_str_has_prefix (_tmp6_, "/");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = processed;
		_tmp8_ = string_substring (_tmp7_, (glong) 1, (glong) -1);
		_g_free0 (processed);
		processed = _tmp8_;
	}
	result = processed;
	if (replaced) {
		*replaced = _vala_replaced;
	}
	return result;
}

gchar*
deja_dup_get_folder_key (GSettings* settings,
                         const gchar* key,
                         gboolean abs_allowed)
{
	gboolean replaced = FALSE;
	gchar* folder = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = g_settings_get_string (settings, key);
	folder = _tmp0_;
	_tmp1_ = folder;
	_tmp3_ = deja_dup_process_folder_key (_tmp1_, abs_allowed, &_tmp2_);
	replaced = _tmp2_;
	_g_free0 (folder);
	folder = _tmp3_;
	if (replaced) {
		const gchar* _tmp4_;
		_tmp4_ = folder;
		g_settings_set_string (settings, key, _tmp4_);
	}
	result = folder;
	return result;
}

DejaDupFilteredSettings*
deja_dup_get_settings (const gchar* subdir)
{
	DejaDupFilteredSettings* _tmp0_;
	DejaDupFilteredSettings* result;
	_tmp0_ = deja_dup_filtered_settings_new (subdir, FALSE);
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupToolPlugin*
deja_dup_get_tool (void)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gchar* tool_name = NULL;
	DejaDupFilteredSettings* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	DejaDupToolPlugin* _tmp4_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GQuark _tmp14_ = 0U;
	DejaDupToolPlugin* _tmp16_;
	DejaDupToolPlugin* _tmp17_;
	DejaDupToolPlugin* result;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_TOOL_KEY);
	tool_name = _tmp2_;
	_tmp4_ = deja_dup_tool;
	if (_tmp4_ != NULL) {
		DejaDupToolPlugin* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = deja_dup_tool;
		_tmp6_ = deja_dup_tool_plugin_get_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = tool_name;
		_tmp3_ = g_strcmp0 (_tmp7_, _tmp8_) == 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		DejaDupToolPlugin* _tmp9_;
		DejaDupToolPlugin* _tmp10_;
		_tmp9_ = deja_dup_tool;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		result = _tmp10_;
		_g_free0 (tool_name);
		_g_object_unref0 (settings);
		return result;
	}
	_tmp11_ = tool_name;
	_tmp12_ = _tmp11_;
	_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
	switch (0) {
		default:
		{
			DuplicityPlugin* _tmp15_;
			_tmp15_ = duplicity_plugin_new ();
			_g_object_unref0 (deja_dup_tool);
			deja_dup_tool = (DejaDupToolPlugin*) _tmp15_;
			break;
		}
	}
	_tmp16_ = deja_dup_tool;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	result = _tmp17_;
	_g_free0 (tool_name);
	_g_object_unref0 (settings);
	return result;
}

void
deja_dup_initialize (void)
{
	DejaDupBackend* _tmp0_;
	DejaDupBackend* _tmp1_;
	DejaDupNetwork* _tmp2_;
	DejaDupNetwork* _tmp3_;
	_tmp0_ = deja_dup_backend_get_default ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = deja_dup_network_get ();
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	deja_dup_clean_tempdirs (TRUE, NULL, NULL);
}

void
deja_dup_i18n_setup (void)
{
	gchar* localedir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* language = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp12_;
	_tmp0_ = g_getenv ("DEJA_DUP_LOCALEDIR");
	_tmp1_ = g_strdup (_tmp0_);
	localedir = _tmp1_;
	_tmp3_ = localedir;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = localedir;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (LOCALE_DIR);
		_g_free0 (localedir);
		localedir = _tmp5_;
	}
	_tmp6_ = g_getenv ("DEJA_DUP_LANGUAGE");
	_tmp7_ = g_strdup (_tmp6_);
	language = _tmp7_;
	_tmp9_ = language;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		_tmp10_ = language;
		_tmp8_ = g_strcmp0 (_tmp10_, "") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp11_;
		_tmp11_ = language;
		g_setenv ("LANGUAGE", _tmp11_, TRUE);
	}
	setlocale (LC_ALL, "");
	textdomain (GETTEXT_PACKAGE);
	_tmp12_ = localedir;
	bindtextdomain (GETTEXT_PACKAGE, _tmp12_);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_g_free0 (language);
	_g_free0 (localedir);
}

gchar*
deja_dup_get_file_desc (GFile* file)
{
	gchar* desc = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	if (g_file_is_native (file)) {
		gchar* _tmp0_;
		_tmp0_ = deja_dup_get_display_name (file);
		result = _tmp0_;
		return result;
	}
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp1_;
		GFileInfo* _tmp2_;
		_tmp1_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = info;
		if (g_file_info_has_attribute (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION)) {
			GFileInfo* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = info;
			_tmp4_ = g_file_info_get_attribute_string (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_DESCRIPTION);
			_tmp5_ = g_strdup (_tmp4_);
			result = _tmp5_;
			_g_object_unref0 (info);
			return result;
		} else {
			GFileInfo* _tmp6_;
			_tmp6_ = info;
			if (g_file_info_has_attribute (_tmp6_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME)) {
				GFileInfo* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp7_ = info;
				_tmp8_ = g_file_info_get_attribute_string (_tmp7_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME);
				_tmp9_ = g_strdup (_tmp8_);
				result = _tmp9_;
				_g_object_unref0 (info);
				return result;
			}
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp10_ = g_file_get_parse_name (file);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_path_get_basename (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	desc = _tmp13_;
	{
		GUri* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GUri* _tmp17_;
		GUri* _tmp18_;
		gchar* host = NULL;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gboolean _tmp21_ = FALSE;
		const gchar* _tmp22_;
		_tmp15_ = g_file_get_uri (file);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_uri_parse (_tmp16_, G_URI_FLAGS_NON_DNS, &_inner_error0_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_tmp14_ = _tmp18_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_URI_ERROR) {
				goto __catch1_g_uri_error;
			}
			_g_free0 (desc);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp19_ = g_uri_get_host (_tmp14_);
		_tmp20_ = g_strdup (_tmp19_);
		host = _tmp20_;
		_tmp22_ = host;
		if (_tmp22_ != NULL) {
			const gchar* _tmp23_;
			_tmp23_ = host;
			_tmp21_ = g_strcmp0 (_tmp23_, "") != 0;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp24_ = desc;
			_tmp25_ = host;
			_tmp26_ = g_strdup_printf (_ ("%1$s on %2$s"), _tmp24_, _tmp25_);
			_g_free0 (desc);
			desc = _tmp26_;
		}
		_g_free0 (host);
		_g_uri_unref0 (_tmp14_);
	}
	goto __finally1;
	__catch1_g_uri_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (desc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = desc;
	return result;
}

void
deja_dup_ensure_special_paths (void)
{
	GFile* _tmp0_;
	_tmp0_ = deja_dup_home;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		GFile* _tmp2_;
		DejaDupInstallEnv* _tmp3_;
		DejaDupInstallEnv* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GFile* _tmp7_;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_file_new_for_path (_tmp1_);
		_g_object_unref0 (deja_dup_home);
		deja_dup_home = _tmp2_;
		_tmp3_ = deja_dup_install_env_instance ();
		_tmp4_ = _tmp3_;
		_tmp5_ = deja_dup_install_env_get_trash_dir (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_new_for_path (_tmp6_);
		_g_object_unref0 (deja_dup_trash);
		deja_dup_trash = _tmp7_;
		_g_free0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
	}
}

gchar*
deja_dup_get_display_name (GFile* f)
{
	GFile* _tmp0_;
	gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (f != NULL, NULL);
	deja_dup_ensure_special_paths ();
	_tmp0_ = deja_dup_home;
	if (g_file_has_prefix (f, _tmp0_)) {
		gchar* s = NULL;
		GFile* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = deja_dup_home;
		_tmp2_ = g_file_get_relative_path (_tmp1_, f);
		s = _tmp2_;
		{
			gchar* _tmp3_ = NULL;
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp4_ = s;
			_tmp5_ = s;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_filename_to_utf8 (_tmp4_, (gssize) _tmp7_, NULL, NULL, &_inner_error0_);
			_tmp3_ = _tmp8_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
					goto __catch0_g_convert_error;
				}
				_g_free0 (s);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp9_ = g_strconcat ("~/", _tmp3_, NULL);
			result = _tmp9_;
			_g_free0 (_tmp3_);
			_g_free0 (s);
			return result;
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
			GError* e = NULL;
			GError* _tmp10_;
			const gchar* _tmp11_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp10_ = e;
			_tmp11_ = _tmp10_->message;
			g_warning ("CommonUtils.vala:519: %s\n", _tmp11_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_g_free0 (s);
	}
	_tmp12_ = g_file_get_parse_name (f);
	result = _tmp12_;
	return result;
}

static void
deja_dup_get_nickname_data_free (gpointer _data)
{
	DejaDupGetNicknameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->f);
	_g_free0 (_data_->result);
	g_slice_free (DejaDupGetNicknameData, _data_);
}

void
deja_dup_get_nickname (GFile* f,
                       GAsyncReadyCallback _callback_,
                       gpointer _user_data_)
{
	DejaDupGetNicknameData* _data_;
	GFile* _tmp0_;
	g_return_if_fail (f != NULL);
	_data_ = g_slice_new0 (DejaDupGetNicknameData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_get_nickname_data_free);
	_tmp0_ = _g_object_ref0 (f);
	_g_object_unref0 (_data_->f);
	_data_->f = _tmp0_;
	deja_dup_get_nickname_co (_data_);
}

gchar*
deja_dup_get_nickname_finish (GAsyncResult* _res_)
{
	gchar* result;
	DejaDupGetNicknameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
deja_dup_get_nickname_ready (GObject* source_object,
                             GAsyncResult* _res_,
                             gpointer _user_data_)
{
	DejaDupGetNicknameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_get_nickname_co (_data_);
}

static gboolean
deja_dup_get_nickname_co (DejaDupGetNicknameData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	deja_dup_ensure_special_paths ();
	_data_->_tmp0_ = deja_dup_home;
	if (g_file_equal (_data_->f, _data_->_tmp0_)) {
		{
			_data_->_state_ = 1;
			g_file_query_info_async (_data_->f, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, G_PRIORITY_DEFAULT, NULL, deja_dup_get_nickname_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp1_ = g_file_query_info_finish (_data_->f, _data_->_res_, &_data_->_inner_error0_);
			_data_->info = _data_->_tmp1_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_data_->_tmp2_ = _data_->info;
			_data_->_tmp3_ = g_file_info_get_display_name (_data_->_tmp2_);
			_data_->_tmp4_ = g_strdup_printf (_ ("Home (%s)"), _data_->_tmp3_);
			_g_free0 (_data_->s);
			_data_->s = _data_->_tmp4_;
			_g_object_unref0 (_data_->info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp5_ = _data_->e;
			_data_->_tmp6_ = _data_->_tmp5_->message;
			g_warning ("CommonUtils.vala:543: %s\n", _data_->_tmp6_);
			_data_->_tmp7_ = g_strdup (_ ("Home"));
			_g_free0 (_data_->s);
			_data_->s = _data_->_tmp7_;
			_g_error_free0 (_data_->e);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->s);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_tmp8_ = deja_dup_trash;
		if (g_file_equal (_data_->f, _data_->_tmp8_)) {
			_data_->_tmp9_ = g_strdup (_ ("Trash"));
			_g_free0 (_data_->s);
			_data_->s = _data_->_tmp9_;
		} else {
			_data_->_tmp10_ = deja_dup_get_display_name (_data_->f);
			_g_free0 (_data_->s);
			_data_->s = _data_->_tmp10_;
		}
	}
	_data_->result = _data_->s;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gint
deja_dup_get_full_backup_threshold (void)
{
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_;
	gint threshold = 0;
	DejaDupFilteredSettings* _tmp1_;
	gint result;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	threshold = g_settings_get_int ((GSettings*) _tmp1_, DEJA_DUP_FULL_BACKUP_PERIOD_KEY);
	if (threshold < 0) {
		threshold = 90;
	}
	result = threshold;
	_g_object_unref0 (settings);
	return result;
}

GDateTime*
deja_dup_get_full_backup_threshold_date (void)
{
	GDateTime* date = NULL;
	GDateTime* _tmp0_;
	gint days = 0;
	GDateTime* _tmp1_;
	GDateTime* result;
	_tmp0_ = g_date_time_new_now_utc ();
	date = _tmp0_;
	days = deja_dup_get_full_backup_threshold ();
	_tmp1_ = g_date_time_add_days (date, -days);
	result = _tmp1_;
	_g_date_time_unref0 (date);
	return result;
}

SecretSchema*
deja_dup_get_passphrase_schema (void)
{
	SecretSchema* _tmp0_;
	SecretSchema* result;
	_tmp0_ = secret_schema_new ("org.freedesktop.Secret.Generic", SECRET_SCHEMA_NONE, "owner", SECRET_SCHEMA_ATTRIBUTE_STRING, "type", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	result = _tmp0_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
deja_dup_process_passphrase (const gchar* input)
{
	gchar* processed = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = string_strip (input);
	processed = _tmp0_;
	_tmp1_ = processed;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (input);
		result = _tmp2_;
		_g_free0 (processed);
		return result;
	}
	result = processed;
	return result;
}

static void
deja_dup_store_passphrase_data_free (gpointer _data)
{
	DejaDupStorePassphraseData* _data_;
	_data_ = _data;
	_g_free0 (_data_->passphrase);
	g_slice_free (DejaDupStorePassphraseData, _data_);
}

void
deja_dup_store_passphrase (const gchar* passphrase,
                           gboolean remember,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	DejaDupStorePassphraseData* _data_;
	gchar* _tmp0_;
	g_return_if_fail (passphrase != NULL);
	_data_ = g_slice_new0 (DejaDupStorePassphraseData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_store_passphrase_data_free);
	_tmp0_ = g_strdup (passphrase);
	_g_free0 (_data_->passphrase);
	_data_->passphrase = _tmp0_;
	_data_->remember = remember;
	deja_dup_store_passphrase_co (_data_);
}

void
deja_dup_store_passphrase_finish (GAsyncResult* _res_)
{
	DejaDupStorePassphraseData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
deja_dup_store_passphrase_co (DejaDupStorePassphraseData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		if (_data_->remember) {
			_data_->_tmp0_ = deja_dup_get_passphrase_schema ();
			_data_->_tmp1_ = _data_->_tmp0_;
			secret_password_store_sync (_data_->_tmp1_, SECRET_COLLECTION_DEFAULT, _ ("Backup encryption password"), _data_->passphrase, NULL, &_data_->_inner_error0_, "owner", PACKAGE, "type", "passphrase", NULL);
			_secret_schema_unref0 (_data_->_tmp1_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			_data_->_tmp2_ = deja_dup_get_passphrase_schema ();
			_data_->_tmp3_ = _data_->_tmp2_;
			secret_password_clear_sync (_data_->_tmp3_, NULL, &_data_->_inner_error0_, "owner", PACKAGE, "type", "passphrase", NULL);
			_secret_schema_unref0 (_data_->_tmp3_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp4_ = _data_->e;
		_data_->_tmp5_ = _data_->_tmp4_->message;
		g_warning ("CommonUtils.vala:628: %s\n", _data_->_tmp5_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
deja_dup_ensure_directory_exists (const gchar* path)
{
	GFile* gfile = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (path);
	gfile = _tmp0_;
	{
		gboolean _tmp1_ = FALSE;
		GFile* _tmp2_;
		_tmp2_ = gfile;
		_tmp1_ = g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch0_g_io_error_exists;
			}
			goto __catch0_g_error;
		}
		if (_tmp1_) {
			result = TRUE;
			_g_object_unref0 (gfile);
			return result;
		}
	}
	goto __finally0;
	__catch0_g_io_error_exists:
	{
		g_clear_error (&_inner_error0_);
		result = TRUE;
		_g_object_unref0 (gfile);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("CommonUtils.vala:643: %s\n", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		_g_object_unref0 (gfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	result = FALSE;
	_g_object_unref0 (gfile);
	return result;
}

static void
deja_dup_get_tempdir_data_free (gpointer _data)
{
	DejaDupGetTempdirData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	g_slice_free (DejaDupGetTempdirData, _data_);
}

void
deja_dup_get_tempdir (GAsyncReadyCallback _callback_,
                      gpointer _user_data_)
{
	DejaDupGetTempdirData* _data_;
	_data_ = g_slice_new0 (DejaDupGetTempdirData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_get_tempdir_data_free);
	deja_dup_get_tempdir_co (_data_);
}

gchar*
deja_dup_get_tempdir_finish (GAsyncResult* _res_)
{
	gchar* result;
	DejaDupGetTempdirData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
deja_dup_get_tempdir_ready (GObject* source_object,
                            GAsyncResult* _res_,
                            gpointer _user_data_)
{
	DejaDupGetTempdirData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_get_tempdir_co (_data_);
}

static gboolean
deja_dup_get_tempdir_co (DejaDupGetTempdirData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp1_ = deja_dup_get_tempdirs (&_data_->_tmp0_);
	_data_->tempdirs = _data_->_tmp1_;
	_data_->tempdirs_length1 = _data_->_tmp0_;
	_data_->_tempdirs_size_ = _data_->tempdirs_length1;
	_data_->_tmp2_ = deja_dup_get_settings (NULL);
	_data_->settings = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->settings;
	_data_->_tmp4_ = 0;
	_data_->_tmp5_ = deja_dup_filtered_settings_get_file_list (_data_->_tmp3_, DEJA_DUP_INCLUDE_LIST_KEY, &_data_->_tmp4_);
	_data_->include_list = _data_->_tmp5_;
	_data_->include_list_length1 = _data_->_tmp4_;
	_data_->_include_list_size_ = _data_->include_list_length1;
	_data_->main_include = NULL;
	_data_->_tmp6_ = g_get_home_dir ();
	_data_->_tmp7_ = g_file_new_for_path (_data_->_tmp6_);
	_data_->home = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->include_list;
	_data_->_tmp8__length1 = _data_->include_list_length1;
	{
		_data_->include_collection_length1 = 0;
		_data_->_include_collection_size_ = 0;
		_data_->include_collection = _data_->_tmp8_;
		_data_->include_collection_length1 = _data_->_tmp8__length1;
		for (_data_->include_it = 0; _data_->include_it < _data_->include_collection_length1; _data_->include_it = _data_->include_it + 1) {
			_data_->_tmp9_ = _g_object_ref0 (_data_->include_collection[_data_->include_it]);
			_data_->include = _data_->_tmp9_;
			{
				_data_->_tmp10_ = _data_->include;
				_data_->_tmp11_ = _data_->home;
				if (g_file_equal (_data_->_tmp10_, _data_->_tmp11_)) {
					_data_->_tmp12_ = _data_->include;
					_data_->_tmp13_ = _g_object_ref0 (_data_->_tmp12_);
					_g_object_unref0 (_data_->main_include);
					_data_->main_include = _data_->_tmp13_;
					_g_object_unref0 (_data_->include);
					break;
				} else {
					_data_->_tmp14_ = _data_->main_include;
					if (_data_->_tmp14_ == NULL) {
						_data_->_tmp15_ = _data_->include;
						_data_->_tmp16_ = _g_object_ref0 (_data_->_tmp15_);
						_g_object_unref0 (_data_->main_include);
						_data_->main_include = _data_->_tmp16_;
					}
				}
				_g_object_unref0 (_data_->include);
			}
		}
	}
	_data_->_tmp17_ = _data_->main_include;
	if (_data_->_tmp17_ == NULL) {
		_data_->_tmp18_ = _data_->tempdirs;
		_data_->_tmp18__length1 = _data_->tempdirs_length1;
		_data_->_tmp19_ = _data_->_tmp18_[0];
		_data_->_tmp20_ = g_strdup (_data_->_tmp19_);
		_data_->result = _data_->_tmp20_;
		_g_object_unref0 (_data_->home);
		_g_object_unref0 (_data_->main_include);
		_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data_->settings);
		_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp21_ = _data_->main_include;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->_tmp21_, G_FILE_ATTRIBUTE_ID_FILESYSTEM, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, deja_dup_get_tempdir_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp22_ = g_file_query_info_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
		_data_->info = _data_->_tmp22_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp23_ = _data_->info;
		_data_->_tmp24_ = g_file_info_get_attribute_string (_data_->_tmp23_, G_FILE_ATTRIBUTE_ID_FILESYSTEM);
		_data_->_tmp25_ = g_strdup (_data_->_tmp24_);
		_g_free0 (_data_->filesystem_id);
		_data_->filesystem_id = _data_->_tmp25_;
		_g_object_unref0 (_data_->info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp26_ = _data_->tempdirs;
		_data_->_tmp26__length1 = _data_->tempdirs_length1;
		_data_->_tmp27_ = _data_->_tmp26_[0];
		_data_->_tmp28_ = g_strdup (_data_->_tmp27_);
		_data_->result = _data_->_tmp28_;
		_g_free0 (_data_->filesystem_id);
		_g_object_unref0 (_data_->home);
		_g_object_unref0 (_data_->main_include);
		_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data_->settings);
		_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->filesystem_id);
		_g_object_unref0 (_data_->home);
		_g_object_unref0 (_data_->main_include);
		_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data_->settings);
		_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp29_ = _data_->tempdirs;
	_data_->_tmp29__length1 = _data_->tempdirs_length1;
	{
		_data_->tempdir_collection_length1 = 0;
		_data_->_tempdir_collection_size_ = 0;
		_data_->tempdir_collection = _data_->_tmp29_;
		_data_->tempdir_collection_length1 = _data_->_tmp29__length1;
		for (_data_->tempdir_it = 0; _data_->tempdir_it < _data_->tempdir_collection_length1; _data_->tempdir_it = _data_->tempdir_it + 1) {
			_data_->_tmp30_ = g_strdup (_data_->tempdir_collection[_data_->tempdir_it]);
			_data_->tempdir = _data_->_tmp30_;
			{
				_data_->_tmp31_ = _data_->tempdir;
				deja_dup_ensure_directory_exists (_data_->_tmp31_);
				{
					_data_->_tmp32_ = _data_->tempdir;
					_data_->_tmp33_ = g_file_new_for_path (_data_->_tmp32_);
					_data_->gfile = _data_->_tmp33_;
					_data_->_tmp34_ = _data_->gfile;
					_data_->_state_ = 2;
					g_file_query_info_async (_data_->_tmp34_, G_FILE_ATTRIBUTE_ID_FILESYSTEM, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, deja_dup_get_tempdir_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp35_ = g_file_query_info_finish (_data_->_tmp34_, _data_->_res_, &_data_->_inner_error0_);
					_data_->_vala1_info = _data_->_tmp35_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->gfile);
						goto __catch1_g_error;
					}
					_data_->_tmp36_ = _data_->_vala1_info;
					_data_->_tmp37_ = g_file_info_get_attribute_string (_data_->_tmp36_, G_FILE_ATTRIBUTE_ID_FILESYSTEM);
					_data_->_tmp38_ = g_strdup (_data_->_tmp37_);
					_g_free0 (_data_->temp_id);
					_data_->temp_id = _data_->_tmp38_;
					_g_object_unref0 (_data_->_vala1_info);
					_g_object_unref0 (_data_->gfile);
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_data_->_inner_error0_);
					_g_free0 (_data_->temp_id);
					_g_free0 (_data_->tempdir);
					continue;
				}
				__finally1:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_free0 (_data_->temp_id);
					_g_free0 (_data_->tempdir);
					_g_free0 (_data_->filesystem_id);
					_g_object_unref0 (_data_->home);
					_g_object_unref0 (_data_->main_include);
					_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
					_g_object_unref0 (_data_->settings);
					_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp39_ = _data_->temp_id;
				_data_->_tmp40_ = _data_->filesystem_id;
				if (g_strcmp0 (_data_->_tmp39_, _data_->_tmp40_) == 0) {
					_data_->result = _data_->tempdir;
					_g_free0 (_data_->temp_id);
					_g_free0 (_data_->filesystem_id);
					_g_object_unref0 (_data_->home);
					_g_object_unref0 (_data_->main_include);
					_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
					_g_object_unref0 (_data_->settings);
					_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_free0 (_data_->temp_id);
				_g_free0 (_data_->tempdir);
			}
		}
	}
	_data_->_tmp41_ = _data_->tempdirs;
	_data_->_tmp41__length1 = _data_->tempdirs_length1;
	_data_->_tmp42_ = _data_->_tmp41_[0];
	_data_->_tmp43_ = g_strdup (_data_->_tmp42_);
	_data_->result = _data_->_tmp43_;
	_g_free0 (_data_->filesystem_id);
	_g_object_unref0 (_data_->home);
	_g_object_unref0 (_data_->main_include);
	_data_->include_list = (_vala_array_free (_data_->include_list, _data_->include_list_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (_data_->settings);
	_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
deja_dup_get_tempdirs (gint* result_length1)
{
	gchar* tempdir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar** tempdirs = NULL;
	DejaDupInstallEnv* _tmp9_;
	DejaDupInstallEnv* _tmp10_;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint tempdirs_length1;
	gint _tempdirs_size_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** result;
	_tmp0_ = g_getenv ("DEJA_DUP_TEMPDIR");
	_tmp1_ = g_strdup (_tmp0_);
	tempdir = _tmp1_;
	_tmp3_ = tempdir;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = tempdir;
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp5_ = tempdir;
		_tmp6_ = g_strdup (_tmp5_);
		_tmp7_ = g_new0 (gchar*, 1 + 1);
		_tmp7_[0] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp8__length1;
		}
		result = _tmp8_;
		_g_free0 (tempdir);
		return result;
	}
	_tmp9_ = deja_dup_install_env_instance ();
	_tmp10_ = _tmp9_;
	_tmp12_ = deja_dup_install_env_get_system_tempdirs (_tmp10_, &_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp11_;
	_g_object_unref0 (_tmp10_);
	tempdirs = _tmp13_;
	tempdirs_length1 = _tmp13__length1;
	_tempdirs_size_ = tempdirs_length1;
	_tmp14_ = g_get_user_cache_dir ();
	_tmp15_ = g_build_filename (_tmp14_, PACKAGE, "tmp", NULL);
	_vala_array_add3 (&tempdirs, &tempdirs_length1, &_tempdirs_size_, _tmp15_);
	_tmp16_ = tempdirs;
	_tmp16__length1 = tempdirs_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	_g_free0 (tempdir);
	return result;
}

static void
deja_dup_clean_tempdirs_data_free (gpointer _data)
{
	DejaDupCleanTempdirsData* _data_;
	_data_ = _data;
	g_slice_free (DejaDupCleanTempdirsData, _data_);
}

void
deja_dup_clean_tempdirs (gboolean all,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_)
{
	DejaDupCleanTempdirsData* _data_;
	_data_ = g_slice_new0 (DejaDupCleanTempdirsData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_clean_tempdirs_data_free);
	_data_->all = all;
	deja_dup_clean_tempdirs_co (_data_);
}

void
deja_dup_clean_tempdirs_finish (GAsyncResult* _res_)
{
	DejaDupCleanTempdirsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
deja_dup_clean_tempdirs_ready (GObject* source_object,
                               GAsyncResult* _res_,
                               gpointer _user_data_)
{
	DejaDupCleanTempdirsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_clean_tempdirs_co (_data_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
deja_dup_clean_tempdirs_co (DejaDupCleanTempdirsData* _data_)
{
	static const gint NUM_ENUMERATED = 16;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0;
	_data_->_tmp1_ = deja_dup_get_tempdirs (&_data_->_tmp0_);
	_data_->tempdirs = _data_->_tmp1_;
	_data_->tempdirs_length1 = _data_->_tmp0_;
	_data_->_tempdirs_size_ = _data_->tempdirs_length1;
	_data_->_tmp2_ = _data_->tempdirs;
	_data_->_tmp2__length1 = _data_->tempdirs_length1;
	{
		_data_->tempdir_collection_length1 = 0;
		_data_->_tempdir_collection_size_ = 0;
		_data_->tempdir_collection = _data_->_tmp2_;
		_data_->tempdir_collection_length1 = _data_->_tmp2__length1;
		for (_data_->tempdir_it = 0; _data_->tempdir_it < _data_->tempdir_collection_length1; _data_->tempdir_it = _data_->tempdir_it + 1) {
			_data_->_tmp3_ = g_strdup (_data_->tempdir_collection[_data_->tempdir_it]);
			_data_->tempdir = _data_->_tmp3_;
			{
				_data_->_tmp4_ = _data_->tempdir;
				_data_->_tmp5_ = g_file_new_for_path (_data_->_tmp4_);
				_data_->gfile = _data_->_tmp5_;
				{
					_data_->_tmp6_ = _data_->gfile;
					_data_->_state_ = 1;
					g_file_enumerate_children_async (_data_->_tmp6_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, G_PRIORITY_DEFAULT, NULL, deja_dup_clean_tempdirs_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp7_ = g_file_enumerate_children_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
					_data_->enumerator = _data_->_tmp7_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					while (TRUE) {
						_data_->_tmp8_ = _data_->enumerator;
						_data_->_state_ = 2;
						g_file_enumerator_next_files_async (_data_->_tmp8_, NUM_ENUMERATED, G_PRIORITY_DEFAULT, NULL, deja_dup_clean_tempdirs_ready, _data_);
						return FALSE;
						_state_2:
						_data_->_tmp9_ = g_file_enumerator_next_files_finish (_data_->_tmp8_, _data_->_res_, &_data_->_inner_error0_);
						_data_->infos = _data_->_tmp9_;
						if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
							_g_object_unref0 (_data_->enumerator);
							goto __catch0_g_error;
						}
						_data_->_tmp10_ = _data_->infos;
						{
							_data_->info_collection = _data_->_tmp10_;
							for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
								_data_->_tmp11_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
								_data_->info = _data_->_tmp11_;
								{
									_data_->_tmp14_ = _data_->info;
									_data_->_tmp15_ = g_file_info_get_name (_data_->_tmp14_);
									if (g_str_has_prefix (_data_->_tmp15_, "duplicity-")) {
										_data_->_tmp13_ = TRUE;
									} else {
										_data_->_tmp16_ = _data_->info;
										_data_->_tmp17_ = g_file_info_get_name (_data_->_tmp16_);
										_data_->_tmp13_ = g_str_has_prefix (_data_->_tmp17_, "restic-");
									}
									if (_data_->_tmp13_) {
										_data_->_tmp12_ = TRUE;
									} else {
										if (_data_->all) {
											_data_->_tmp19_ = _data_->info;
											_data_->_tmp20_ = g_file_info_get_name (_data_->_tmp19_);
											_data_->_tmp18_ = g_str_has_prefix (_data_->_tmp20_, "deja-dup-");
										} else {
											_data_->_tmp18_ = FALSE;
										}
										_data_->_tmp12_ = _data_->_tmp18_;
									}
									if (_data_->_tmp12_) {
										_data_->_tmp21_ = _data_->gfile;
										_data_->_tmp22_ = _data_->info;
										_data_->_tmp23_ = g_file_info_get_name (_data_->_tmp22_);
										_data_->_tmp24_ = g_file_get_child (_data_->_tmp21_, _data_->_tmp23_);
										_data_->child = _data_->_tmp24_;
										_data_->_tmp25_ = _data_->child;
										_data_->_tmp26_ = deja_dup_recursive_delete_new (_data_->_tmp25_, NULL, NULL);
										_data_->_tmp27_ = _data_->_tmp26_;
										_data_->_state_ = 3;
										deja_dup_recursive_op_start_async ((DejaDupRecursiveOp*) _data_->_tmp27_, deja_dup_clean_tempdirs_ready, _data_);
										return FALSE;
										_state_3:
										deja_dup_recursive_op_start_finish ((DejaDupRecursiveOp*) _data_->_tmp27_, _data_->_res_);
										_g_object_unref0 (_data_->_tmp27_);
										_g_object_unref0 (_data_->child);
									}
									_g_object_unref0 (_data_->info);
								}
							}
						}
						_data_->_tmp28_ = _data_->infos;
						if (g_list_length (_data_->_tmp28_) != ((guint) NUM_ENUMERATED)) {
							(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
							break;
						}
						(_data_->infos == NULL) ? NULL : (_data_->infos = (_g_list_free__g_object_unref0_ (_data_->infos), NULL));
					}
					_g_object_unref0 (_data_->enumerator);
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_data_->_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->gfile);
					_g_free0 (_data_->tempdir);
					_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->gfile);
				_g_free0 (_data_->tempdir);
			}
		}
	}
	_data_->tempdirs = (_vala_array_free (_data_->tempdirs, _data_->tempdirs_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
deja_dup_try_realpath (const gchar* input)
{
	gchar* resolved = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = realpath (input, NULL);
	resolved = _tmp0_;
	_tmp2_ = resolved;
	if (_tmp2_ == NULL) {
		_tmp1_ = input;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = resolved;
		_tmp1_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp1_);
	result = _tmp4_;
	_g_free0 (resolved);
	return result;
}

GVolumeMonitor*
deja_dup_get_volume_monitor (void)
{
	GVolumeMonitor* _tmp0_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	GVolumeMonitor* result;
	_tmp0_ = deja_dup__monitor;
	if (_tmp0_ == NULL) {
		GVolumeMonitor* _tmp1_;
		_tmp1_ = g_volume_monitor_get ();
		_g_object_unref0 (deja_dup__monitor);
		deja_dup__monitor = _tmp1_;
	}
	_tmp2_ = deja_dup__monitor;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
deja_dup_wait_data_free (gpointer _data)
{
	DejaDupWaitData* _data_;
	_data_ = _data;
	g_slice_free (DejaDupWaitData, _data_);
}

void
deja_dup_wait (guint secs,
               GAsyncReadyCallback _callback_,
               gpointer _user_data_)
{
	DejaDupWaitData* _data_;
	_data_ = g_slice_new0 (DejaDupWaitData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_wait_data_free);
	_data_->secs = secs;
	deja_dup_wait_co (_data_);
}

void
deja_dup_wait_finish (GAsyncResult* _res_)
{
	DejaDupWaitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda7_ (Block3Data* _data3_)
{
	gboolean result;
	deja_dup_wait_co (_data3_->_async_data_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ (self);
	return result;
}

static gboolean
deja_dup_wait_co (DejaDupWaitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->_async_data_ = _data_;
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, _data_->secs, ___lambda7__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

