/* BackendOAuth.c generated by valac 0.56.14, the Vala compiler
 * generated from BackendOAuth.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libsoup/soup.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <libsecret/secret.h>
#include <glib/gi18n-lib.h>
#include <json-glib/json-glib.h>

enum  {
	DEJA_DUP_BACKEND_OAUTH_0_PROPERTY,
	DEJA_DUP_BACKEND_OAUTH_FULL_TOKEN_PROPERTY,
	DEJA_DUP_BACKEND_OAUTH_ACCESS_TOKEN_PROPERTY,
	DEJA_DUP_BACKEND_OAUTH_REFRESH_TOKEN_PROPERTY,
	DEJA_DUP_BACKEND_OAUTH_NUM_PROPERTIES
};
static GParamSpec* deja_dup_backend_oauth_properties[DEJA_DUP_BACKEND_OAUTH_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _DejaDupBackendOauthLookupRefreshTokenData DejaDupBackendOauthLookupRefreshTokenData;
typedef struct _DejaDupBackendOauthClearRefreshTokenData DejaDupBackendOauthClearRefreshTokenData;
typedef struct _DejaDupBackendOauthGotCredentialsData DejaDupBackendOauthGotCredentialsData;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _DejaDupBackendOauthSendMessageRawData DejaDupBackendOauthSendMessageRawData;
typedef struct _DejaDupBackendOauthSendMessageData DejaDupBackendOauthSendMessageData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DejaDupBackendOauthGetTokensData DejaDupBackendOauthGetTokensData;
typedef struct _DejaDupBackendOauthStoreCredentialsData DejaDupBackendOauthStoreCredentialsData;
typedef struct _DejaDupBackendOauthGetCredentialsData DejaDupBackendOauthGetCredentialsData;
typedef struct _DejaDupBackendOauthRefreshCredentialsData DejaDupBackendOauthRefreshCredentialsData;
typedef struct _DejaDupBackendOauthStartAuthorizationData DejaDupBackendOauthStartAuthorizationData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
typedef struct _DejaDupBackendOauthPrepareData DejaDupBackendOauthPrepareData;

struct _DejaDupBackendOAuthPrivate {
	gchar* _full_token;
	gchar* _access_token;
	gchar* _refresh_token;
	GSourceFunc authorization_callback;
	gpointer authorization_callback_target;
	GDestroyNotify authorization_callback_target_destroy_notify;
	SoupSession* session;
	gchar* pkce;
	gchar* error_msg;
	gchar* code;
};

struct _DejaDupBackendOauthLookupRefreshTokenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	gchar* result;
	SecretSchema* schema;
	SecretSchema* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _inner_error0_;
};

struct _DejaDupBackendOauthClearRefreshTokenData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	SecretSchema* schema;
	SecretSchema* _tmp0_;
	const gchar* _tmp1_;
	DejaDupBackendWatcher* _tmp2_;
	DejaDupBackendWatcher* _tmp3_;
	GError* _inner_error0_;
};

struct _DejaDupBackendOauthGotCredentialsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
};

struct _DejaDupBackendOauthSendMessageRawData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	SoupMessage* message;
	JsonReader* result;
	GInputStream* response;
	SoupSession* _tmp0_;
	GInputStream* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint8* data;
	guint8* _tmp4_;
	gint data_length1;
	gint _data_size_;
	GInputStream* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	JsonNode* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	JsonNode* _tmp9_;
	JsonReader* _tmp10_;
	GError* _inner_error0_;
};

struct _DejaDupBackendOauthSendMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	SoupMessage* message;
	JsonReader* result;
	SoupMessageHeaders* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	JsonReader* reader;
	JsonReader* _tmp5_;
	JsonReader* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	GError* _inner_error0_;
};

struct _DejaDupBackendOauthGetTokensData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	SoupMessage* message;
	JsonReader* reader;
	JsonReader* _tmp0_;
	JsonReader* _tmp1_;
	JsonReader* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	JsonReader* _tmp5_;
	JsonReader* _tmp6_;
	JsonNode* _tmp7_;
	JsonNode* _tmp8_;
	JsonNode* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	JsonReader* _tmp12_;
	JsonReader* _tmp13_;
	const gchar* _tmp14_;
	JsonReader* _tmp15_;
	JsonReader* _tmp16_;
	JsonReader* _tmp17_;
	const gchar* _tmp18_;
	JsonReader* _tmp19_;
	GError* _inner_error0_;
};

struct _DejaDupBackendOauthStoreCredentialsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	SecretSchema* schema;
	SecretSchema* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* e;
	GError* _tmp6_;
	const gchar* _tmp7_;
	GError* _inner_error0_;
};

struct _DejaDupBackendOauthGetCredentialsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	gchar* code;
	gchar* form;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	SoupMessage* message;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	SoupMessage* _tmp8_;
	GError* _inner_error0_;
};

struct _DejaDupBackendOauthRefreshCredentialsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	gchar* form;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	SoupMessage* message;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	SoupMessage* _tmp5_;
	GError* _inner_error0_;
};

struct _DejaDupBackendOauthStartAuthorizationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_;
};

struct _DejaDupBackendOauthPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendOAuth* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GError* _inner_error0_;
};

static gint DejaDupBackendOAuth_private_offset;
static gpointer deja_dup_backend_oauth_parent_class = NULL;
static GWeakRef deja_dup_backend_oauth_authorization_instance;
static GWeakRef deja_dup_backend_oauth_authorization_instance = {0};

static gchar* deja_dup_backend_oauth_real_get_redirect_uri (DejaDupBackendOAuth* self);
static void deja_dup_backend_oauth_continue_authorization_helper (DejaDupBackendOAuth* self,
                                                           const gchar* command_line_redirect_uri);
static void deja_dup_backend_oauth_lookup_refresh_token_data_free (gpointer _data);
static gboolean deja_dup_backend_oauth_lookup_refresh_token_co (DejaDupBackendOauthLookupRefreshTokenData* _data_);
static SecretSchema* deja_dup_backend_oauth_get_secret_schema (DejaDupBackendOAuth* self);
static void deja_dup_backend_oauth_clear_refresh_token_data_free (gpointer _data);
static gboolean deja_dup_backend_oauth_clear_refresh_token_co (DejaDupBackendOauthClearRefreshTokenData* _data_);
static gboolean deja_dup_backend_oauth_real_is_native (DejaDupBackend* base);
static void deja_dup_backend_oauth_real_got_credentials_data_free (gpointer _data);
static void deja_dup_backend_oauth_real_got_credentials (DejaDupBackendOAuth* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gboolean deja_dup_backend_oauth_real_got_credentials_co (DejaDupBackendOauthGotCredentialsData* _data_);
static void deja_dup_backend_oauth_send_message_raw_data_free (gpointer _data);
static void deja_dup_backend_oauth_send_message_raw (DejaDupBackendOAuth* self,
                                              SoupMessage* message,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static JsonReader* deja_dup_backend_oauth_send_message_raw_finish (DejaDupBackendOAuth* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
static gboolean deja_dup_backend_oauth_send_message_raw_co (DejaDupBackendOauthSendMessageRawData* _data_);
static void deja_dup_backend_oauth_send_message_raw_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void _vala_JsonNode_free (JsonNode* self);
static void deja_dup_backend_oauth_send_message_data_free (gpointer _data);
VALA_EXTERN void deja_dup_backend_oauth_send_message (DejaDupBackendOAuth* self,
                                          SoupMessage* message,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN JsonReader* deja_dup_backend_oauth_send_message_finish (DejaDupBackendOAuth* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static gboolean deja_dup_backend_oauth_send_message_co (DejaDupBackendOauthSendMessageData* _data_);
static void deja_dup_backend_oauth_send_message_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void deja_dup_backend_oauth_get_tokens_data_free (gpointer _data);
static void deja_dup_backend_oauth_get_tokens (DejaDupBackendOAuth* self,
                                        SoupMessage* message,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void deja_dup_backend_oauth_get_tokens_finish (DejaDupBackendOAuth* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static gboolean deja_dup_backend_oauth_get_tokens_co (DejaDupBackendOauthGetTokensData* _data_);
static void deja_dup_backend_oauth_get_tokens_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void deja_dup_backend_oauth_start_authorization (DejaDupBackendOAuth* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void deja_dup_backend_oauth_start_authorization_finish (DejaDupBackendOAuth* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void deja_dup_backend_oauth_set_full_token (DejaDupBackendOAuth* self,
                                            const gchar* value);
static void deja_dup_backend_oauth_set_access_token (DejaDupBackendOAuth* self,
                                              const gchar* value);
static void deja_dup_backend_oauth_set_refresh_token (DejaDupBackendOAuth* self,
                                               const gchar* value);
static void deja_dup_backend_oauth_store_credentials (DejaDupBackendOAuth* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static void deja_dup_backend_oauth_store_credentials_finish (DejaDupBackendOAuth* self,
                                                      GAsyncResult* _res_);
static void deja_dup_backend_oauth_store_credentials_data_free (gpointer _data);
static gboolean deja_dup_backend_oauth_store_credentials_co (DejaDupBackendOauthStoreCredentialsData* _data_);
static gchar* deja_dup_backend_oauth_get_consent_location (DejaDupBackendOAuth* self);
static void deja_dup_backend_oauth_get_credentials_data_free (gpointer _data);
static void deja_dup_backend_oauth_get_credentials (DejaDupBackendOAuth* self,
                                             const gchar* code,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
static void deja_dup_backend_oauth_get_credentials_finish (DejaDupBackendOAuth* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static gboolean deja_dup_backend_oauth_get_credentials_co (DejaDupBackendOauthGetCredentialsData* _data_);
static void deja_dup_backend_oauth_get_credentials_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_);
static void deja_dup_backend_oauth_refresh_credentials_data_free (gpointer _data);
static void deja_dup_backend_oauth_refresh_credentials (DejaDupBackendOAuth* self,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void deja_dup_backend_oauth_refresh_credentials_finish (DejaDupBackendOAuth* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static gboolean deja_dup_backend_oauth_refresh_credentials_co (DejaDupBackendOauthRefreshCredentialsData* _data_);
static void deja_dup_backend_oauth_refresh_credentials_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void deja_dup_backend_oauth_start_authorization_data_free (gpointer _data);
static gboolean deja_dup_backend_oauth_start_authorization_co (DejaDupBackendOauthStartAuthorizationData* _data_);
static gboolean _deja_dup_backend_oauth_start_authorization_co_gsource_func (gpointer self);
static void deja_dup_backend_oauth_start_authorization_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void deja_dup_backend_oauth_real_prepare_data_free (gpointer _data);
static void deja_dup_backend_oauth_real_prepare (DejaDupBackend* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean deja_dup_backend_oauth_real_prepare_co (DejaDupBackendOauthPrepareData* _data_);
static void deja_dup_backend_oauth_prepare_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static GObject * deja_dup_backend_oauth_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void deja_dup_backend_oauth_finalize (GObject * obj);
static GType deja_dup_backend_oauth_get_type_once (void);
static void _vala_deja_dup_backend_oauth_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_deja_dup_backend_oauth_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
deja_dup_backend_oauth_get_instance_private (DejaDupBackendOAuth* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupBackendOAuth_private_offset);
}

static gchar*
deja_dup_backend_oauth_real_get_redirect_uri (DejaDupBackendOAuth* self)
{
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_oauth_get_redirect_uri'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
deja_dup_backend_oauth_get_redirect_uri (DejaDupBackendOAuth* self)
{
	DejaDupBackendOAuthClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = DEJA_DUP_BACKEND_OAUTH_GET_CLASS (self);
	if (_klass_->get_redirect_uri) {
		return _klass_->get_redirect_uri (self);
	}
	return NULL;
}

gboolean
deja_dup_backend_oauth_continue_authorization (DejaDupBackendOAuth* self,
                                               const gchar* command_line_redirect_uri)
{
	GObject* _tmp0_;
	GObject* _tmp1_;
	gboolean _tmp2_;
	DejaDupBackendOAuth* active_backend = NULL;
	GObject* _tmp3_;
	DejaDupBackendOAuth* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (command_line_redirect_uri != NULL, FALSE);
	_tmp0_ = g_weak_ref_get (&deja_dup_backend_oauth_authorization_instance);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = g_weak_ref_get (&deja_dup_backend_oauth_authorization_instance);
	active_backend = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, DEJA_DUP_TYPE_BACKEND_OAUTH, DejaDupBackendOAuth);
	_tmp4_ = active_backend;
	deja_dup_backend_oauth_continue_authorization_helper (_tmp4_, command_line_redirect_uri);
	result = TRUE;
	_g_object_unref0 (active_backend);
	return result;
}

static void
deja_dup_backend_oauth_lookup_refresh_token_data_free (gpointer _data)
{
	DejaDupBackendOauthLookupRefreshTokenData* _data_;
	_data_ = _data;
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthLookupRefreshTokenData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
deja_dup_backend_oauth_lookup_refresh_token (DejaDupBackendOAuth* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	DejaDupBackendOauthLookupRefreshTokenData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendOauthLookupRefreshTokenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_lookup_refresh_token_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_oauth_lookup_refresh_token_co (_data_);
}

gchar*
deja_dup_backend_oauth_lookup_refresh_token_finish (DejaDupBackendOAuth* self,
                                                    GAsyncResult* _res_)
{
	gchar* result;
	DejaDupBackendOauthLookupRefreshTokenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
deja_dup_backend_oauth_lookup_refresh_token_co (DejaDupBackendOauthLookupRefreshTokenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_oauth_get_secret_schema (_data_->self);
	_data_->schema = _data_->_tmp0_;
	{
		_data_->_tmp2_ = _data_->self->client_id;
		_data_->_tmp3_ = secret_password_lookup_sync (_data_->schema, NULL, &_data_->_inner_error0_, "client_id", _data_->_tmp2_, NULL);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_data_->result = _data_->_tmp4_;
		_g_free0 (_data_->_tmp1_);
		_secret_schema_unref0 (_data_->schema);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = NULL;
		_secret_schema_unref0 (_data_->schema);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	_secret_schema_unref0 (_data_->schema);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
	g_clear_error (&_data_->_inner_error0_);
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_oauth_clear_refresh_token_data_free (gpointer _data)
{
	DejaDupBackendOauthClearRefreshTokenData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthClearRefreshTokenData, _data_);
}

void
deja_dup_backend_oauth_clear_refresh_token (DejaDupBackendOAuth* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	DejaDupBackendOauthClearRefreshTokenData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendOauthClearRefreshTokenData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_clear_refresh_token_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_oauth_clear_refresh_token_co (_data_);
}

void
deja_dup_backend_oauth_clear_refresh_token_finish (DejaDupBackendOAuth* self,
                                                   GAsyncResult* _res_)
{
	DejaDupBackendOauthClearRefreshTokenData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
deja_dup_backend_oauth_clear_refresh_token_co (DejaDupBackendOauthClearRefreshTokenData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_oauth_get_secret_schema (_data_->self);
	_data_->schema = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->client_id;
		secret_password_clear_sync (_data_->schema, NULL, &_data_->_inner_error0_, "client_id", _data_->_tmp1_, NULL);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = deja_dup_backend_watcher_get_instance ();
		_data_->_tmp3_ = _data_->_tmp2_;
		g_signal_emit_by_name (_data_->_tmp3_, "changed");
		_g_object_unref0 (_data_->_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_secret_schema_unref0 (_data_->schema);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_secret_schema_unref0 (_data_->schema);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
deja_dup_backend_oauth_real_is_native (DejaDupBackend* base)
{
	DejaDupBackendOAuth * self;
	gboolean result;
	self = (DejaDupBackendOAuth*) base;
	result = FALSE;
	return result;
}

static void
deja_dup_backend_oauth_real_got_credentials_data_free (gpointer _data)
{
	DejaDupBackendOauthGotCredentialsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthGotCredentialsData, _data_);
}

static void
deja_dup_backend_oauth_real_got_credentials (DejaDupBackendOAuth* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	DejaDupBackendOauthGotCredentialsData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	_data_ = g_slice_new0 (DejaDupBackendOauthGotCredentialsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_real_got_credentials_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_oauth_real_got_credentials_co (_data_);
}

static void
deja_dup_backend_oauth_real_got_credentials_finish (DejaDupBackendOAuth* self,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	DejaDupBackendOauthGotCredentialsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
deja_dup_backend_oauth_real_got_credentials_co (DejaDupBackendOauthGotCredentialsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
deja_dup_backend_oauth_got_credentials (DejaDupBackendOAuth* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	DejaDupBackendOAuthClass* _klass_;
	_klass_ = DEJA_DUP_BACKEND_OAUTH_GET_CLASS (self);
	if (_klass_->got_credentials) {
		_klass_->got_credentials (self, _callback_, _user_data_);
	}
}

void
deja_dup_backend_oauth_got_credentials_finish (DejaDupBackendOAuth* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	DejaDupBackendOAuthClass* _klass_;
	_klass_ = DEJA_DUP_BACKEND_OAUTH_GET_CLASS (self);
	if (_klass_->got_credentials_finish) {
		_klass_->got_credentials_finish (self, _res_, error);
	}
}

void
deja_dup_backend_oauth_stop_login (DejaDupBackendOAuth* self,
                                   const gchar* reason,
                                   GError** error)
{
	gchar* full_reason = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp5_;
	GError* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->brand_name;
	_tmp1_ = g_strdup_printf (_ ("Could not log into %s servers."), _tmp0_);
	full_reason = _tmp1_;
	if (reason != NULL) {
		_tmp2_ = g_strcmp0 (reason, "") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = full_reason;
		_tmp4_ = g_strdup_printf ("%s %s", _tmp3_, reason);
		_g_free0 (full_reason);
		full_reason = _tmp4_;
	}
	_tmp5_ = full_reason;
	_tmp6_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp5_);
	_inner_error0_ = _tmp6_;
	g_propagate_error (error, _inner_error0_);
	_g_free0 (full_reason);
	return;
}

static void
deja_dup_backend_oauth_send_message_raw_data_free (gpointer _data)
{
	DejaDupBackendOauthSendMessageRawData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthSendMessageRawData, _data_);
}

static void
deja_dup_backend_oauth_send_message_raw (DejaDupBackendOAuth* self,
                                         SoupMessage* message,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	DejaDupBackendOauthSendMessageRawData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	SoupMessage* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (DejaDupBackendOauthSendMessageRawData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_send_message_raw_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	deja_dup_backend_oauth_send_message_raw_co (_data_);
}

static JsonReader*
deja_dup_backend_oauth_send_message_raw_finish (DejaDupBackendOAuth* self,
                                                GAsyncResult* _res_,
                                                GError** error)
{
	JsonReader* result;
	DejaDupBackendOauthSendMessageRawData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
deja_dup_backend_oauth_send_message_raw_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	DejaDupBackendOauthSendMessageRawData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_oauth_send_message_raw_co (_data_);
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gboolean
deja_dup_backend_oauth_send_message_raw_co (DejaDupBackendOauthSendMessageRawData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->session;
	_data_->_state_ = 1;
	soup_session_send_async (_data_->_tmp0_, _data_->message, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_oauth_send_message_raw_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = soup_session_send_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
	_data_->response = _data_->_tmp1_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_object_get (_data_->message, "status-code", &_data_->_tmp2_, NULL);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_ != ((guint) SOUP_STATUS_OK)) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->response);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = g_new0 (guint8, 5000);
	_data_->data = _data_->_tmp4_;
	_data_->data_length1 = 5000;
	_data_->_data_size_ = _data_->data_length1;
	_data_->_tmp5_ = _data_->response;
	_data_->_tmp6_ = _data_->data;
	_data_->_tmp6__length1 = _data_->data_length1;
	_data_->_state_ = 2;
	g_input_stream_read_all_async (_data_->_tmp5_, _data_->_tmp6_, (gsize) _data_->_tmp6__length1, G_PRIORITY_DEFAULT, NULL, deja_dup_backend_oauth_send_message_raw_ready, _data_);
	return FALSE;
	_state_2:
	g_input_stream_read_all_finish (_data_->_tmp5_, _data_->_res_, NULL, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->data = (g_free (_data_->data), NULL);
		_g_object_unref0 (_data_->response);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->data;
	_data_->_tmp8__length1 = _data_->data_length1;
	_data_->_tmp9_ = json_from_string ((const gchar*) _data_->_tmp8_, &_data_->_inner_error0_);
	_data_->_tmp7_ = _data_->_tmp9_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->data = (g_free (_data_->data), NULL);
		_g_object_unref0 (_data_->response);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = json_reader_new (_data_->_tmp7_);
	_data_->result = _data_->_tmp10_;
	__vala_JsonNode_free0 (_data_->_tmp7_);
	_data_->data = (g_free (_data_->data), NULL);
	_g_object_unref0 (_data_->response);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_oauth_send_message_data_free (gpointer _data)
{
	DejaDupBackendOauthSendMessageData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthSendMessageData, _data_);
}

void
deja_dup_backend_oauth_send_message (DejaDupBackendOAuth* self,
                                     SoupMessage* message,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	DejaDupBackendOauthSendMessageData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	SoupMessage* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (DejaDupBackendOauthSendMessageData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_send_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	deja_dup_backend_oauth_send_message_co (_data_);
}

JsonReader*
deja_dup_backend_oauth_send_message_finish (DejaDupBackendOAuth* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	JsonReader* result;
	DejaDupBackendOauthSendMessageData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
deja_dup_backend_oauth_send_message_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	DejaDupBackendOauthSendMessageData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_oauth_send_message_co (_data_);
}

static gboolean
deja_dup_backend_oauth_send_message_co (DejaDupBackendOauthSendMessageData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = soup_message_get_request_headers (_data_->message);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = _data_->self->priv->_access_token;
	_data_->_tmp3_ = g_strconcat ("Bearer ", _data_->_tmp2_, NULL);
	_data_->_tmp4_ = _data_->_tmp3_;
	soup_message_headers_replace (_data_->_tmp1_, "Authorization", _data_->_tmp4_);
	_g_free0 (_data_->_tmp4_);
	_data_->_state_ = 1;
	deja_dup_backend_oauth_send_message_raw (_data_->self, _data_->message, deja_dup_backend_oauth_send_message_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = deja_dup_backend_oauth_send_message_raw_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->reader = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->reader;
	if (_data_->_tmp6_ == NULL) {
		_data_->_tmp7_ = soup_message_get_reason_phrase (_data_->message);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _data_->_tmp8_);
		_data_->_inner_error0_ = _data_->_tmp9_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->reader);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->reader;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_oauth_get_tokens_data_free (gpointer _data)
{
	DejaDupBackendOauthGetTokensData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthGetTokensData, _data_);
}

static void
deja_dup_backend_oauth_get_tokens (DejaDupBackendOAuth* self,
                                   SoupMessage* message,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	DejaDupBackendOauthGetTokensData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	SoupMessage* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_data_ = g_slice_new0 (DejaDupBackendOauthGetTokensData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_get_tokens_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (message);
	_g_object_unref0 (_data_->message);
	_data_->message = _tmp1_;
	deja_dup_backend_oauth_get_tokens_co (_data_);
}

static void
deja_dup_backend_oauth_get_tokens_finish (DejaDupBackendOAuth* self,
                                          GAsyncResult* _res_,
                                          GError** error)
{
	DejaDupBackendOauthGetTokensData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
deja_dup_backend_oauth_get_tokens_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	DejaDupBackendOauthGetTokensData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_oauth_get_tokens_co (_data_);
}

static gboolean
deja_dup_backend_oauth_get_tokens_co (DejaDupBackendOauthGetTokensData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		deja_dup_backend_oauth_send_message_raw (_data_->self, _data_->message, deja_dup_backend_oauth_get_tokens_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = deja_dup_backend_oauth_send_message_raw_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->reader);
		_data_->reader = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		deja_dup_backend_oauth_stop_login (_data_->self, _data_->_tmp4_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->reader);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->reader);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->reader;
	if (_data_->_tmp5_ == NULL) {
		_data_->_state_ = 2;
		deja_dup_backend_oauth_start_authorization (_data_->self, deja_dup_backend_oauth_get_tokens_ready, _data_);
		return FALSE;
		_state_2:
		deja_dup_backend_oauth_start_authorization_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->reader);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_object_unref0 (_data_->reader);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->reader;
	g_object_get (_data_->_tmp6_, "root", &_data_->_tmp7_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = json_to_string (_data_->_tmp9_, FALSE);
	_data_->_tmp11_ = _data_->_tmp10_;
	deja_dup_backend_oauth_set_full_token (_data_->self, _data_->_tmp11_);
	_g_free0 (_data_->_tmp11_);
	__vala_JsonNode_free0 (_data_->_tmp9_);
	_data_->_tmp12_ = _data_->reader;
	json_reader_read_member (_data_->_tmp12_, "access_token");
	_data_->_tmp13_ = _data_->reader;
	_data_->_tmp14_ = json_reader_get_string_value (_data_->_tmp13_);
	deja_dup_backend_oauth_set_access_token (_data_->self, _data_->_tmp14_);
	_data_->_tmp15_ = _data_->reader;
	json_reader_end_member (_data_->_tmp15_);
	_data_->_tmp16_ = _data_->reader;
	if (json_reader_read_member (_data_->_tmp16_, "refresh_token")) {
		_data_->_tmp17_ = _data_->reader;
		_data_->_tmp18_ = json_reader_get_string_value (_data_->_tmp17_);
		deja_dup_backend_oauth_set_refresh_token (_data_->self, _data_->_tmp18_);
		_data_->_state_ = 3;
		deja_dup_backend_oauth_store_credentials (_data_->self, deja_dup_backend_oauth_get_tokens_ready, _data_);
		return FALSE;
		_state_3:
		deja_dup_backend_oauth_store_credentials_finish (_data_->self, _data_->_res_);
	}
	_data_->_tmp19_ = _data_->reader;
	json_reader_end_member (_data_->_tmp19_);
	_data_->_state_ = 4;
	deja_dup_backend_oauth_got_credentials (_data_->self, deja_dup_backend_oauth_get_tokens_ready, _data_);
	return FALSE;
	_state_4:
	deja_dup_backend_oauth_got_credentials_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->reader);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->reader);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static SecretSchema*
deja_dup_backend_oauth_get_secret_schema (DejaDupBackendOAuth* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SecretSchema* _tmp3_;
	SecretSchema* _tmp4_;
	SecretSchema* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->brand_name;
	_tmp1_ = g_strconcat (APPLICATION_ID ".", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = secret_schema_new (_tmp2_, SECRET_SCHEMA_NONE, "client_id", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
deja_dup_backend_oauth_store_credentials_data_free (gpointer _data)
{
	DejaDupBackendOauthStoreCredentialsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthStoreCredentialsData, _data_);
}

static void
deja_dup_backend_oauth_store_credentials (DejaDupBackendOAuth* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	DejaDupBackendOauthStoreCredentialsData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendOauthStoreCredentialsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_store_credentials_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_oauth_store_credentials_co (_data_);
}

static void
deja_dup_backend_oauth_store_credentials_finish (DejaDupBackendOAuth* self,
                                                 GAsyncResult* _res_)
{
	DejaDupBackendOauthStoreCredentialsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
deja_dup_backend_oauth_store_credentials_co (DejaDupBackendOauthStoreCredentialsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_oauth_get_secret_schema (_data_->self);
	_data_->schema = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->brand_name;
		_data_->_tmp2_ = g_strdup_printf (_ ("%s credentials for Déjà Dup"), _data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = _data_->self->priv->_refresh_token;
		_data_->_tmp5_ = _data_->self->client_id;
		secret_password_store_sync (_data_->schema, SECRET_COLLECTION_DEFAULT, _data_->_tmp3_, _data_->_tmp4_, NULL, &_data_->_inner_error0_, "client_id", _data_->_tmp5_, NULL);
		_g_free0 (_data_->_tmp3_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp6_ = _data_->e;
		_data_->_tmp7_ = _data_->_tmp6_->message;
		g_warning ("BackendOAuth.vala:174: %s\n", _data_->_tmp7_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_secret_schema_unref0 (_data_->schema);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_secret_schema_unref0 (_data_->schema);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
deja_dup_backend_oauth_get_consent_location (DejaDupBackendOAuth* self)
{
	gchar* form = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	SoupMessage* message = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	SoupMessage* _tmp9_;
	GUri* _tmp10_;
	GUri* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->client_id;
	_tmp1_ = deja_dup_backend_oauth_get_redirect_uri (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->pkce;
	_tmp4_ = self->scope;
	_tmp5_ = soup_form_encode ("client_id", _tmp0_, "redirect_uri", _tmp2_, "response_type", "code", "code_challenge", _tmp3_, "scope", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp2_);
	form = _tmp6_;
	_tmp7_ = self->auth_url;
	_tmp8_ = g_strdup (form);
	_tmp9_ = soup_message_new_from_encoded_form ("GET", _tmp7_, _tmp8_);
	message = _tmp9_;
	_tmp10_ = soup_message_get_uri (message);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_uri_to_string (_tmp11_);
	result = _tmp12_;
	_g_object_unref0 (message);
	_g_free0 (form);
	return result;
}

static void
deja_dup_backend_oauth_get_credentials_data_free (gpointer _data)
{
	DejaDupBackendOauthGetCredentialsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->code);
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthGetCredentialsData, _data_);
}

static void
deja_dup_backend_oauth_get_credentials (DejaDupBackendOAuth* self,
                                        const gchar* code,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	DejaDupBackendOauthGetCredentialsData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (code != NULL);
	_data_ = g_slice_new0 (DejaDupBackendOauthGetCredentialsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_get_credentials_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (code);
	_g_free0 (_data_->code);
	_data_->code = _tmp1_;
	deja_dup_backend_oauth_get_credentials_co (_data_);
}

static void
deja_dup_backend_oauth_get_credentials_finish (DejaDupBackendOAuth* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	DejaDupBackendOauthGetCredentialsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
deja_dup_backend_oauth_get_credentials_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_)
{
	DejaDupBackendOauthGetCredentialsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_oauth_get_credentials_co (_data_);
}

static gboolean
deja_dup_backend_oauth_get_credentials_co (DejaDupBackendOauthGetCredentialsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->client_id;
	_data_->_tmp1_ = deja_dup_backend_oauth_get_redirect_uri (_data_->self);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->self->priv->pkce;
	_data_->_tmp4_ = soup_form_encode ("client_id", _data_->_tmp0_, "redirect_uri", _data_->_tmp2_, "grant_type", "authorization_code", "code_verifier", _data_->_tmp3_, "code", _data_->code, NULL);
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_free0 (_data_->_tmp2_);
	_data_->form = _data_->_tmp5_;
	_data_->_tmp6_ = _data_->self->token_url;
	_data_->_tmp7_ = g_strdup (_data_->form);
	_data_->_tmp8_ = soup_message_new_from_encoded_form ("POST", _data_->_tmp6_, _data_->_tmp7_);
	_data_->message = _data_->_tmp8_;
	_data_->_state_ = 1;
	deja_dup_backend_oauth_get_tokens (_data_->self, _data_->message, deja_dup_backend_oauth_get_credentials_ready, _data_);
	return FALSE;
	_state_1:
	deja_dup_backend_oauth_get_tokens_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->message);
		_g_free0 (_data_->form);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->message);
	_g_free0 (_data_->form);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_oauth_refresh_credentials_data_free (gpointer _data)
{
	DejaDupBackendOauthRefreshCredentialsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthRefreshCredentialsData, _data_);
}

static void
deja_dup_backend_oauth_refresh_credentials (DejaDupBackendOAuth* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	DejaDupBackendOauthRefreshCredentialsData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendOauthRefreshCredentialsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_refresh_credentials_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_oauth_refresh_credentials_co (_data_);
}

static void
deja_dup_backend_oauth_refresh_credentials_finish (DejaDupBackendOAuth* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	DejaDupBackendOauthRefreshCredentialsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
deja_dup_backend_oauth_refresh_credentials_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	DejaDupBackendOauthRefreshCredentialsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_oauth_refresh_credentials_co (_data_);
}

static gboolean
deja_dup_backend_oauth_refresh_credentials_co (DejaDupBackendOauthRefreshCredentialsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->client_id;
	_data_->_tmp1_ = _data_->self->priv->_refresh_token;
	_data_->_tmp2_ = soup_form_encode ("client_id", _data_->_tmp0_, "refresh_token", _data_->_tmp1_, "grant_type", "refresh_token", NULL);
	_data_->form = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->self->token_url;
	_data_->_tmp4_ = g_strdup (_data_->form);
	_data_->_tmp5_ = soup_message_new_from_encoded_form ("POST", _data_->_tmp3_, _data_->_tmp4_);
	_data_->message = _data_->_tmp5_;
	_data_->_state_ = 1;
	deja_dup_backend_oauth_get_tokens (_data_->self, _data_->message, deja_dup_backend_oauth_refresh_credentials_ready, _data_);
	return FALSE;
	_state_1:
	deja_dup_backend_oauth_get_tokens_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->message);
		_g_free0 (_data_->form);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->message);
	_g_free0 (_data_->form);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_oauth_start_authorization_data_free (gpointer _data)
{
	DejaDupBackendOauthStartAuthorizationData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthStartAuthorizationData, _data_);
}

static void
deja_dup_backend_oauth_start_authorization (DejaDupBackendOAuth* self,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	DejaDupBackendOauthStartAuthorizationData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (DejaDupBackendOauthStartAuthorizationData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_start_authorization_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_oauth_start_authorization_co (_data_);
}

static void
deja_dup_backend_oauth_start_authorization_finish (DejaDupBackendOAuth* self,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	DejaDupBackendOauthStartAuthorizationData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
_deja_dup_backend_oauth_start_authorization_co_gsource_func (gpointer self)
{
	gboolean result;
	result = deja_dup_backend_oauth_start_authorization_co (self);
	return result;
}

static void
deja_dup_backend_oauth_start_authorization_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	DejaDupBackendOauthStartAuthorizationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_oauth_start_authorization_co (_data_);
}

static gboolean
deja_dup_backend_oauth_start_authorization_co (DejaDupBackendOauthStartAuthorizationData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_g_free0 (_data_->self->priv->error_msg);
	_data_->self->priv->error_msg = NULL;
	_g_free0 (_data_->self->priv->code);
	_data_->self->priv->code = NULL;
	_data_->_tmp0_ = g_uuid_string_random ();
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_uuid_string_random ();
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = g_strconcat (_data_->_tmp1_, _data_->_tmp3_, NULL);
	_g_free0 (_data_->self->priv->pkce);
	_data_->self->priv->pkce = _data_->_tmp4_;
	_g_free0 (_data_->_tmp3_);
	_g_free0 (_data_->_tmp1_);
	_data_->_tmp5_ = _data_->self->brand_name;
	_data_->_tmp6_ = g_strdup_printf (_ ("You first need to allow Backups to access your %s account."), _data_->_tmp5_);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = deja_dup_backend_oauth_get_consent_location (_data_->self);
	_data_->_tmp9_ = _data_->_tmp8_;
	g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "show-oauth-consent-page", _data_->_tmp7_, _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	_g_free0 (_data_->_tmp7_);
	g_weak_ref_set (&deja_dup_backend_oauth_authorization_instance, (GObject*) _data_->self);
	(_data_->self->priv->authorization_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->authorization_callback_target_destroy_notify (_data_->self->priv->authorization_callback_target), NULL);
	_data_->self->priv->authorization_callback = NULL;
	_data_->self->priv->authorization_callback_target = NULL;
	_data_->self->priv->authorization_callback_target_destroy_notify = NULL;
	_data_->self->priv->authorization_callback = _deja_dup_backend_oauth_start_authorization_co_gsource_func;
	_data_->self->priv->authorization_callback_target = _data_;
	_data_->self->priv->authorization_callback_target_destroy_notify = NULL;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	g_weak_ref_set (&deja_dup_backend_oauth_authorization_instance, NULL);
	(_data_->self->priv->authorization_callback_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->authorization_callback_target_destroy_notify (_data_->self->priv->authorization_callback_target), NULL);
	_data_->self->priv->authorization_callback = NULL;
	_data_->self->priv->authorization_callback_target = NULL;
	_data_->self->priv->authorization_callback_target_destroy_notify = NULL;
	_data_->self->priv->authorization_callback = NULL;
	_data_->self->priv->authorization_callback_target = NULL;
	_data_->self->priv->authorization_callback_target_destroy_notify = NULL;
	_data_->_tmp10_ = _data_->self->priv->error_msg;
	if (_data_->_tmp10_ != NULL) {
		_data_->_tmp11_ = _data_->self->priv->error_msg;
		deja_dup_backend_oauth_stop_login (_data_->self, _data_->_tmp11_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_signal_emit_by_name ((DejaDupBackend*) _data_->self, "show-oauth-consent-page", NULL, NULL);
	_data_->_tmp12_ = _data_->self->priv->code;
	_data_->_state_ = 2;
	deja_dup_backend_oauth_get_credentials (_data_->self, _data_->_tmp12_, deja_dup_backend_oauth_start_authorization_ready, _data_);
	return FALSE;
	_state_2:
	deja_dup_backend_oauth_get_credentials_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_oauth_continue_authorization_helper (DejaDupBackendOAuth* self,
                                                      const gchar* command_line_redirect_uri)
{
	GHashTable* query = NULL;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp22_;
	GSourceFunc _tmp25_;
	gpointer _tmp25__target;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command_line_redirect_uri != NULL);
	query = NULL;
	{
		GUri* uri = NULL;
		GUri* _tmp0_;
		GHashTable* _tmp1_ = NULL;
		GUri* _tmp2_;
		const gchar* _tmp3_;
		GHashTable* _tmp4_;
		GHashTable* _tmp5_;
		_tmp0_ = g_uri_parse (command_line_redirect_uri, G_URI_FLAGS_NONE, &_inner_error0_);
		uri = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_URI_ERROR) {
				goto __catch0_g_uri_error;
			}
			_g_hash_table_unref0 (query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = uri;
		_tmp3_ = g_uri_get_query (_tmp2_);
		_tmp4_ = g_uri_parse_params (_tmp3_, (gsize) -1, "&;", 0, &_inner_error0_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_uri_unref0 (uri);
			if (_inner_error0_->domain == G_URI_ERROR) {
				goto __catch0_g_uri_error;
			}
			_g_hash_table_unref0 (query);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp5_ = _tmp1_;
		_tmp1_ = NULL;
		_g_hash_table_unref0 (query);
		query = _tmp5_;
		_g_hash_table_unref0 (_tmp1_);
		_g_uri_unref0 (uri);
	}
	goto __finally0;
	__catch0_g_uri_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->error_msg);
		self->priv->error_msg = _tmp8_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_hash_table_unref0 (query);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp10_ = self->priv->error_msg;
	if (_tmp10_ == NULL) {
		GHashTable* _tmp11_;
		_tmp11_ = query;
		_tmp9_ = _tmp11_ != NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GHashTable* _tmp12_;
		gconstpointer _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = query;
		_tmp13_ = g_hash_table_lookup (_tmp12_, "error");
		_tmp14_ = g_strdup ((const gchar*) _tmp13_);
		_g_free0 (self->priv->error_msg);
		self->priv->error_msg = _tmp14_;
	}
	_tmp16_ = self->priv->error_msg;
	if (_tmp16_ == NULL) {
		GHashTable* _tmp17_;
		_tmp17_ = query;
		_tmp15_ = _tmp17_ != NULL;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GHashTable* _tmp18_;
		gconstpointer _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = query;
		_tmp19_ = g_hash_table_lookup (_tmp18_, "code");
		_tmp20_ = g_strdup ((const gchar*) _tmp19_);
		_g_free0 (self->priv->code);
		self->priv->code = _tmp20_;
	}
	_tmp22_ = self->priv->error_msg;
	if (_tmp22_ == NULL) {
		const gchar* _tmp23_;
		_tmp23_ = self->priv->code;
		_tmp21_ = _tmp23_ == NULL;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gchar* _tmp24_;
		_tmp24_ = g_strdup ("");
		_g_free0 (self->priv->error_msg);
		self->priv->error_msg = _tmp24_;
	}
	_tmp25_ = self->priv->authorization_callback;
	_tmp25__target = self->priv->authorization_callback_target;
	_tmp25_ (_tmp25__target);
	_g_hash_table_unref0 (query);
}

static void
deja_dup_backend_oauth_real_prepare_data_free (gpointer _data)
{
	DejaDupBackendOauthPrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendOauthPrepareData, _data_);
}

static void
deja_dup_backend_oauth_real_prepare (DejaDupBackend* base,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	DejaDupBackendOAuth * self;
	DejaDupBackendOauthPrepareData* _data_;
	DejaDupBackendOAuth* _tmp0_;
	self = (DejaDupBackendOAuth*) base;
	_data_ = g_slice_new0 (DejaDupBackendOauthPrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_oauth_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_oauth_real_prepare_co (_data_);
}

static void
deja_dup_backend_oauth_prepare_finish (DejaDupBackend* base,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	DejaDupBackendOauthPrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
deja_dup_backend_oauth_prepare_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	DejaDupBackendOauthPrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_oauth_real_prepare_co (_data_);
}

static gboolean
deja_dup_backend_oauth_real_prepare_co (DejaDupBackendOauthPrepareData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_state_ = 1;
	deja_dup_backend_oauth_lookup_refresh_token (_data_->self, deja_dup_backend_oauth_prepare_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp0_ = deja_dup_backend_oauth_lookup_refresh_token_finish (_data_->self, _data_->_res_);
	_data_->_tmp1_ = _data_->_tmp0_;
	deja_dup_backend_oauth_set_refresh_token (_data_->self, _data_->_tmp1_);
	_g_free0 (_data_->_tmp1_);
	_data_->_tmp2_ = _data_->self->priv->_refresh_token;
	if (_data_->_tmp2_ == NULL) {
		_data_->_state_ = 2;
		deja_dup_backend_oauth_start_authorization (_data_->self, deja_dup_backend_oauth_prepare_ready, _data_);
		return FALSE;
		_state_2:
		deja_dup_backend_oauth_start_authorization_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->_state_ = 3;
		deja_dup_backend_oauth_refresh_credentials (_data_->self, deja_dup_backend_oauth_prepare_ready, _data_);
		return FALSE;
		_state_3:
		deja_dup_backend_oauth_refresh_credentials_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

DejaDupBackendOAuth*
deja_dup_backend_oauth_construct (GType object_type)
{
	DejaDupBackendOAuth * self = NULL;
	self = (DejaDupBackendOAuth*) deja_dup_backend_construct (object_type);
	return self;
}

const gchar*
deja_dup_backend_oauth_get_full_token (DejaDupBackendOAuth* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_full_token;
	result = _tmp0_;
	return result;
}

static void
deja_dup_backend_oauth_set_full_token (DejaDupBackendOAuth* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_backend_oauth_get_full_token (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_full_token);
		self->priv->_full_token = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_backend_oauth_properties[DEJA_DUP_BACKEND_OAUTH_FULL_TOKEN_PROPERTY]);
	}
}

const gchar*
deja_dup_backend_oauth_get_access_token (DejaDupBackendOAuth* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_access_token;
	result = _tmp0_;
	return result;
}

static void
deja_dup_backend_oauth_set_access_token (DejaDupBackendOAuth* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_backend_oauth_get_access_token (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_access_token);
		self->priv->_access_token = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_backend_oauth_properties[DEJA_DUP_BACKEND_OAUTH_ACCESS_TOKEN_PROPERTY]);
	}
}

const gchar*
deja_dup_backend_oauth_get_refresh_token (DejaDupBackendOAuth* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_refresh_token;
	result = _tmp0_;
	return result;
}

static void
deja_dup_backend_oauth_set_refresh_token (DejaDupBackendOAuth* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_backend_oauth_get_refresh_token (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_refresh_token);
		self->priv->_refresh_token = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_backend_oauth_properties[DEJA_DUP_BACKEND_OAUTH_REFRESH_TOKEN_PROPERTY]);
	}
}

static GObject *
deja_dup_backend_oauth_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupBackendOAuth * self;
	SoupSession* _tmp0_;
	SoupSession* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	parent_class = G_OBJECT_CLASS (deja_dup_backend_oauth_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_OAUTH, DejaDupBackendOAuth);
	_tmp0_ = soup_session_new ();
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp0_;
	_tmp1_ = self->priv->session;
	_tmp2_ = g_strdup_printf ("%s/%s ", PACKAGE, VERSION);
	_tmp3_ = _tmp2_;
	soup_session_set_user_agent (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
	return obj;
}

static void
deja_dup_backend_oauth_class_init (DejaDupBackendOAuthClass * klass,
                                   gpointer klass_data)
{
	deja_dup_backend_oauth_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupBackendOAuth_private_offset);
	((DejaDupBackendOAuthClass *) klass)->get_redirect_uri = (gchar* (*) (DejaDupBackendOAuth*)) deja_dup_backend_oauth_real_get_redirect_uri;
	((DejaDupBackendClass *) klass)->is_native = (gboolean (*) (DejaDupBackend*)) deja_dup_backend_oauth_real_is_native;
	((DejaDupBackendOAuthClass *) klass)->got_credentials = (void (*) (DejaDupBackendOAuth*, GAsyncReadyCallback, gpointer)) deja_dup_backend_oauth_real_got_credentials;
	((DejaDupBackendOAuthClass *) klass)->got_credentials_finish = (void (*) (DejaDupBackendOAuth*, GAsyncResult*, GError**)) deja_dup_backend_oauth_real_got_credentials_finish;
	((DejaDupBackendClass *) klass)->prepare = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_oauth_real_prepare;
	((DejaDupBackendClass *) klass)->prepare_finish = (void (*) (DejaDupBackend*, GAsyncResult*, GError**)) deja_dup_backend_oauth_prepare_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_backend_oauth_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_backend_oauth_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_backend_oauth_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_oauth_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_BACKEND_OAUTH_FULL_TOKEN_PROPERTY, deja_dup_backend_oauth_properties[DEJA_DUP_BACKEND_OAUTH_FULL_TOKEN_PROPERTY] = g_param_spec_string ("full-token", "full-token", "full-token", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_BACKEND_OAUTH_ACCESS_TOKEN_PROPERTY, deja_dup_backend_oauth_properties[DEJA_DUP_BACKEND_OAUTH_ACCESS_TOKEN_PROPERTY] = g_param_spec_string ("access-token", "access-token", "access-token", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_BACKEND_OAUTH_REFRESH_TOKEN_PROPERTY, deja_dup_backend_oauth_properties[DEJA_DUP_BACKEND_OAUTH_REFRESH_TOKEN_PROPERTY] = g_param_spec_string ("refresh-token", "refresh-token", "refresh-token", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
deja_dup_backend_oauth_instance_init (DejaDupBackendOAuth * self,
                                      gpointer klass)
{
	self->priv = deja_dup_backend_oauth_get_instance_private (self);
}

static void
deja_dup_backend_oauth_finalize (GObject * obj)
{
	DejaDupBackendOAuth * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_OAUTH, DejaDupBackendOAuth);
	_g_free0 (self->priv->_full_token);
	_g_free0 (self->priv->_access_token);
	_g_free0 (self->priv->_refresh_token);
	_g_free0 (self->brand_name);
	_g_free0 (self->client_id);
	_g_free0 (self->auth_url);
	_g_free0 (self->token_url);
	_g_free0 (self->scope);
	(self->priv->authorization_callback_target_destroy_notify == NULL) ? NULL : (self->priv->authorization_callback_target_destroy_notify (self->priv->authorization_callback_target), NULL);
	self->priv->authorization_callback = NULL;
	self->priv->authorization_callback_target = NULL;
	self->priv->authorization_callback_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->session);
	_g_free0 (self->priv->pkce);
	_g_free0 (self->priv->error_msg);
	_g_free0 (self->priv->code);
	G_OBJECT_CLASS (deja_dup_backend_oauth_parent_class)->finalize (obj);
}

/**
 * This abstract backend is for cloud services that use OAuth authentication.
 */
 G_GNUC_NO_INLINE static GType
deja_dup_backend_oauth_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendOAuthClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_oauth_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendOAuth), 0, (GInstanceInitFunc) deja_dup_backend_oauth_instance_init, NULL };
	GType deja_dup_backend_oauth_type_id;
	deja_dup_backend_oauth_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND, "DejaDupBackendOAuth", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	DejaDupBackendOAuth_private_offset = g_type_add_instance_private (deja_dup_backend_oauth_type_id, sizeof (DejaDupBackendOAuthPrivate));
	return deja_dup_backend_oauth_type_id;
}

GType
deja_dup_backend_oauth_get_type (void)
{
	static gsize deja_dup_backend_oauth_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_backend_oauth_type_id__once)) {
		GType deja_dup_backend_oauth_type_id;
		deja_dup_backend_oauth_type_id = deja_dup_backend_oauth_get_type_once ();
		g_once_init_leave (&deja_dup_backend_oauth_type_id__once, deja_dup_backend_oauth_type_id);
	}
	return deja_dup_backend_oauth_type_id__once;
}

static void
_vala_deja_dup_backend_oauth_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	DejaDupBackendOAuth * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_BACKEND_OAUTH, DejaDupBackendOAuth);
	switch (property_id) {
		case DEJA_DUP_BACKEND_OAUTH_FULL_TOKEN_PROPERTY:
		g_value_set_string (value, deja_dup_backend_oauth_get_full_token (self));
		break;
		case DEJA_DUP_BACKEND_OAUTH_ACCESS_TOKEN_PROPERTY:
		g_value_set_string (value, deja_dup_backend_oauth_get_access_token (self));
		break;
		case DEJA_DUP_BACKEND_OAUTH_REFRESH_TOKEN_PROPERTY:
		g_value_set_string (value, deja_dup_backend_oauth_get_refresh_token (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_deja_dup_backend_oauth_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	DejaDupBackendOAuth * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_BACKEND_OAUTH, DejaDupBackendOAuth);
	switch (property_id) {
		case DEJA_DUP_BACKEND_OAUTH_FULL_TOKEN_PROPERTY:
		deja_dup_backend_oauth_set_full_token (self, g_value_get_string (value));
		break;
		case DEJA_DUP_BACKEND_OAUTH_ACCESS_TOKEN_PROPERTY:
		deja_dup_backend_oauth_set_access_token (self, g_value_get_string (value));
		break;
		case DEJA_DUP_BACKEND_OAUTH_REFRESH_TOKEN_PROPERTY:
		deja_dup_backend_oauth_set_refresh_token (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

