/* BackendMicrosoft.c generated by valac 0.56.14, the Vala compiler
 * generated from BackendMicrosoft.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libsoup/soup.h>
#include <json-glib/json-glib.h>

#define TYPE_RCLONE (rclone_get_type ())
#define RCLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RCLONE, Rclone))
#define RCLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RCLONE, RcloneClass))
#define IS_RCLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RCLONE))
#define IS_RCLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RCLONE))
#define RCLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RCLONE, RcloneClass))

typedef struct _Rclone Rclone;
typedef struct _RcloneClass RcloneClass;
enum  {
	DEJA_DUP_BACKEND_MICROSOFT_0_PROPERTY,
	DEJA_DUP_BACKEND_MICROSOFT_DRIVE_ID_PROPERTY,
	DEJA_DUP_BACKEND_MICROSOFT_NUM_PROPERTIES
};
static GParamSpec* deja_dup_backend_microsoft_properties[DEJA_DUP_BACKEND_MICROSOFT_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DejaDupBackendMicrosoftIsReadyData DejaDupBackendMicrosoftIsReadyData;
typedef struct _DejaDupBackendMicrosoftCleanupData DejaDupBackendMicrosoftCleanupData;
typedef struct _DejaDupBackendMicrosoftGetSpaceData DejaDupBackendMicrosoftGetSpaceData;
typedef struct _DejaDupBackendMicrosoftGotCredentialsData DejaDupBackendMicrosoftGotCredentialsData;

struct _DejaDupBackendMicrosoftPrivate {
	gchar* _drive_id;
	Rclone* rclone;
};

struct _DejaDupBackendMicrosoftIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendMicrosoft* self;
	gchar* reason;
	gchar* message;
	gboolean result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	DejaDupNetwork* _tmp2_;
	DejaDupNetwork* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
};

struct _DejaDupBackendMicrosoftCleanupData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendMicrosoft* self;
};

struct _DejaDupBackendMicrosoftGetSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendMicrosoft* self;
	gboolean free;
	guint64 result;
	SoupMessage* message;
	SoupMessage* _tmp0_;
	JsonReader* reader;
	JsonReader* _tmp1_;
	SoupMessage* _tmp2_;
	JsonReader* _tmp3_;
	JsonReader* _tmp4_;
	JsonReader* _tmp5_;
	JsonReader* _tmp6_;
	gint64 total;
	JsonReader* _tmp7_;
	JsonReader* _tmp8_;
	JsonReader* _tmp9_;
	gint64 remaining;
	JsonReader* _tmp10_;
	JsonReader* _tmp11_;
	gint64 _tmp12_;
	GError* _inner_error0_;
};

struct _DejaDupBackendMicrosoftGotCredentialsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendMicrosoft* self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	GError* _tmp3_;
	SoupMessage* message;
	SoupMessage* _tmp4_;
	JsonReader* reader;
	JsonReader* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_;
};

static gint DejaDupBackendMicrosoft_private_offset;
static gpointer deja_dup_backend_microsoft_parent_class = NULL;

VALA_EXTERN GType rclone_get_type (void) G_GNUC_CONST ;
static gchar* deja_dup_backend_microsoft_real_get_redirect_uri (DejaDupBackendOAuth* base);
static gchar** deja_dup_backend_microsoft_real_get_dependencies (DejaDupBackend* base,
                                                          gint* result_length1);
static GIcon* deja_dup_backend_microsoft_real_get_icon (DejaDupBackend* base);
static void deja_dup_backend_microsoft_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_microsoft_real_is_ready (DejaDupBackend* base,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static gboolean deja_dup_backend_microsoft_real_is_ready_co (DejaDupBackendMicrosoftIsReadyData* _data_);
static void deja_dup_backend_microsoft_is_ready_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
VALA_EXTERN gchar* deja_dup_backend_microsoft_get_folder (DejaDupBackendMicrosoft* self);
static gchar* deja_dup_backend_microsoft_real_get_location_pretty (DejaDupBackend* base);
static void deja_dup_backend_microsoft_real_cleanup_data_free (gpointer _data);
static void deja_dup_backend_microsoft_real_cleanup (DejaDupBackend* base,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static gboolean deja_dup_backend_microsoft_real_cleanup_co (DejaDupBackendMicrosoftCleanupData* _data_);
static void deja_dup_backend_microsoft_real_get_space_data_free (gpointer _data);
static void deja_dup_backend_microsoft_real_get_space (DejaDupBackend* base,
                                                gboolean free,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static gboolean deja_dup_backend_microsoft_real_get_space_co (DejaDupBackendMicrosoftGetSpaceData* _data_);
VALA_EXTERN void deja_dup_backend_oauth_send_message (DejaDupBackendOAuth* self,
                                          SoupMessage* message,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN JsonReader* deja_dup_backend_oauth_send_message_finish (DejaDupBackendOAuth* self,
                                                        GAsyncResult* _res_,
                                                        GError** error);
static void deja_dup_backend_microsoft_get_space_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void deja_dup_backend_microsoft_real_got_credentials_data_free (gpointer _data);
static void deja_dup_backend_microsoft_real_got_credentials (DejaDupBackendOAuth* base,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_);
static gboolean deja_dup_backend_microsoft_real_got_credentials_co (DejaDupBackendMicrosoftGotCredentialsData* _data_);
static void deja_dup_backend_microsoft_got_credentials_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_);
static void deja_dup_backend_microsoft_set_drive_id (DejaDupBackendMicrosoft* self,
                                              const gchar* value);
static GObject * deja_dup_backend_microsoft_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void deja_dup_backend_microsoft_finalize (GObject * obj);
static GType deja_dup_backend_microsoft_get_type_once (void);
static void _vala_deja_dup_backend_microsoft_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_deja_dup_backend_microsoft_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static gssize _vala_array_length (gpointer array);

static inline gpointer
deja_dup_backend_microsoft_get_instance_private (DejaDupBackendMicrosoft* self)
{
	return G_STRUCT_MEMBER_P (self, DejaDupBackendMicrosoft_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupBackendMicrosoft*
deja_dup_backend_microsoft_construct (GType object_type,
                                      GSettings* settings)
{
	DejaDupBackendMicrosoft * self = NULL;
	GSettings* _tmp0_ = NULL;
	if (settings != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = _g_object_ref0 (settings);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		DejaDupFilteredSettings* _tmp2_;
		_tmp2_ = deja_dup_get_settings (DEJA_DUP_MICROSOFT_ROOT);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GSettings*) _tmp2_;
	}
	self = (DejaDupBackendMicrosoft*) g_object_new (object_type, "kind", DEJA_DUP_BACKEND_KIND_MICROSOFT, "settings", _tmp0_, NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}

DejaDupBackendMicrosoft*
deja_dup_backend_microsoft_new (GSettings* settings)
{
	return deja_dup_backend_microsoft_construct (DEJA_DUP_TYPE_BACKEND_MICROSOFT, settings);
}

static gchar*
deja_dup_backend_microsoft_real_get_redirect_uri (DejaDupBackendOAuth* base)
{
	DejaDupBackendMicrosoft * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (DejaDupBackendMicrosoft*) base;
	_tmp0_ = ((DejaDupBackendOAuth*) self)->client_id;
	_tmp1_ = g_strdup_printf ("msal%s://auth", _tmp0_);
	result = _tmp1_;
	return result;
}

static gchar**
deja_dup_backend_microsoft_real_get_dependencies (DejaDupBackend* base,
                                                  gint* result_length1)
{
	DejaDupBackendMicrosoft * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (DejaDupBackendMicrosoft*) base;
	_tmp1_ = _tmp0_ = g_strsplit (REQUESTS_OAUTHLIB_PACKAGES, ",", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GIcon*
deja_dup_backend_microsoft_real_get_icon (DejaDupBackend* base)
{
	DejaDupBackendMicrosoft * self;
	GThemedIcon* _tmp0_;
	GIcon* result;
	self = (DejaDupBackendMicrosoft*) base;
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("deja-dup-microsoft-onedrive");
	result = (GIcon*) _tmp0_;
	return result;
}

static void
deja_dup_backend_microsoft_real_is_ready_data_free (gpointer _data)
{
	DejaDupBackendMicrosoftIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendMicrosoftIsReadyData, _data_);
}

static void
deja_dup_backend_microsoft_real_is_ready (DejaDupBackend* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	DejaDupBackendMicrosoft * self;
	DejaDupBackendMicrosoftIsReadyData* _data_;
	DejaDupBackendMicrosoft* _tmp0_;
	self = (DejaDupBackendMicrosoft*) base;
	_data_ = g_slice_new0 (DejaDupBackendMicrosoftIsReadyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_microsoft_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_microsoft_real_is_ready_co (_data_);
}

static gboolean
deja_dup_backend_microsoft_is_ready_finish (DejaDupBackend* base,
                                            GAsyncResult* _res_,
                                            gchar** reason,
                                            gchar** message)
{
	gboolean result;
	DejaDupBackendMicrosoftIsReadyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (reason) {
		*reason = _data_->reason;
	} else {
		_g_free0 (_data_->reason);
	}
	_data_->reason = NULL;
	if (message) {
		*message = _data_->message;
	} else {
		_g_free0 (_data_->message);
	}
	_data_->message = NULL;
	result = _data_->result;
	return result;
}

static void
deja_dup_backend_microsoft_is_ready_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	DejaDupBackendMicrosoftIsReadyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_microsoft_real_is_ready_co (_data_);
}

static gboolean
deja_dup_backend_microsoft_real_is_ready_co (DejaDupBackendMicrosoftIsReadyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup ("microsoft-reachable");
	_g_free0 (_data_->reason);
	_data_->reason = _data_->_tmp0_;
	_data_->_tmp1_ = g_strdup (_ ("Backup will begin when a network connection becomes available."));
	_g_free0 (_data_->message);
	_data_->message = _data_->_tmp1_;
	_data_->_tmp2_ = deja_dup_network_get ();
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = g_strdup_printf ("https://%s/", DEJA_DUP_MICROSOFT_SERVER);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_state_ = 1;
	deja_dup_network_can_reach (_data_->_tmp3_, _data_->_tmp5_, deja_dup_backend_microsoft_is_ready_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = deja_dup_network_can_reach_finish (_data_->_tmp3_, _data_->_res_);
	_g_free0 (_data_->_tmp5_);
	_g_object_unref0 (_data_->_tmp3_);
	_data_->result = _data_->_tmp6_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gchar*
deja_dup_backend_microsoft_get_folder (DejaDupBackendMicrosoft* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_get_folder_key (_tmp1_, DEJA_DUP_MICROSOFT_FOLDER_KEY, FALSE);
	result = _tmp2_;
	return result;
}

static gchar*
deja_dup_backend_microsoft_real_get_location_pretty (DejaDupBackend* base)
{
	DejaDupBackendMicrosoft * self;
	gchar* folder = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result;
	self = (DejaDupBackendMicrosoft*) base;
	_tmp0_ = deja_dup_backend_microsoft_get_folder (self);
	folder = _tmp0_;
	_tmp1_ = folder;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (_ ("Microsoft OneDrive"));
		result = _tmp2_;
		_g_free0 (folder);
		return result;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = folder;
		_tmp4_ = g_strdup_printf (_ ("%s on Microsoft OneDrive"), _tmp3_);
		result = _tmp4_;
		_g_free0 (folder);
		return result;
	}
}

static void
deja_dup_backend_microsoft_real_cleanup_data_free (gpointer _data)
{
	DejaDupBackendMicrosoftCleanupData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendMicrosoftCleanupData, _data_);
}

static void
deja_dup_backend_microsoft_real_cleanup (DejaDupBackend* base,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	DejaDupBackendMicrosoft * self;
	DejaDupBackendMicrosoftCleanupData* _data_;
	DejaDupBackendMicrosoft* _tmp0_;
	self = (DejaDupBackendMicrosoft*) base;
	_data_ = g_slice_new0 (DejaDupBackendMicrosoftCleanupData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_microsoft_real_cleanup_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_microsoft_real_cleanup_co (_data_);
}

static void
deja_dup_backend_microsoft_cleanup_finish (DejaDupBackend* base,
                                           GAsyncResult* _res_)
{
	DejaDupBackendMicrosoftCleanupData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
deja_dup_backend_microsoft_real_cleanup_co (DejaDupBackendMicrosoftCleanupData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_g_object_unref0 (_data_->self->priv->rclone);
	_data_->self->priv->rclone = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_microsoft_real_get_space_data_free (gpointer _data)
{
	DejaDupBackendMicrosoftGetSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendMicrosoftGetSpaceData, _data_);
}

static void
deja_dup_backend_microsoft_real_get_space (DejaDupBackend* base,
                                           gboolean free,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	DejaDupBackendMicrosoft * self;
	DejaDupBackendMicrosoftGetSpaceData* _data_;
	DejaDupBackendMicrosoft* _tmp0_;
	self = (DejaDupBackendMicrosoft*) base;
	_data_ = g_slice_new0 (DejaDupBackendMicrosoftGetSpaceData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_microsoft_real_get_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->free = free;
	deja_dup_backend_microsoft_real_get_space_co (_data_);
}

static guint64
deja_dup_backend_microsoft_get_space_finish (DejaDupBackend* base,
                                             GAsyncResult* _res_)
{
	guint64 result;
	DejaDupBackendMicrosoftGetSpaceData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	return result;
}

static void
deja_dup_backend_microsoft_get_space_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	DejaDupBackendMicrosoftGetSpaceData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_microsoft_real_get_space_co (_data_);
}

static gboolean
deja_dup_backend_microsoft_real_get_space_co (DejaDupBackendMicrosoftGetSpaceData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = soup_message_new ("GET", "https://graph.microsoft.com/v1.0/me/drive?select=quota");
	_data_->message = _data_->_tmp0_;
	{
		_data_->_tmp2_ = _data_->message;
		_data_->_state_ = 1;
		deja_dup_backend_oauth_send_message ((DejaDupBackendOAuth*) _data_->self, _data_->_tmp2_, deja_dup_backend_microsoft_get_space_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = deja_dup_backend_oauth_send_message_finish ((DejaDupBackendOAuth*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_object_unref0 (_data_->reader);
		_data_->reader = _data_->_tmp4_;
		_g_object_unref0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = DEJA_DUP_BACKEND_INFINITE_SPACE;
		_g_object_unref0 (_data_->reader);
		_g_object_unref0 (_data_->message);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->reader);
		_g_object_unref0 (_data_->message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->reader;
	json_reader_read_member (_data_->_tmp5_, "quota");
	_data_->_tmp6_ = _data_->reader;
	json_reader_read_member (_data_->_tmp6_, "total");
	_data_->_tmp7_ = _data_->reader;
	_data_->total = json_reader_get_int_value (_data_->_tmp7_);
	_data_->_tmp8_ = _data_->reader;
	json_reader_end_member (_data_->_tmp8_);
	_data_->_tmp9_ = _data_->reader;
	json_reader_read_member (_data_->_tmp9_, "remaining");
	_data_->_tmp10_ = _data_->reader;
	_data_->remaining = json_reader_get_int_value (_data_->_tmp10_);
	_data_->_tmp11_ = _data_->reader;
	json_reader_end_member (_data_->_tmp11_);
	if (_data_->free) {
		_data_->_tmp12_ = _data_->remaining;
	} else {
		_data_->_tmp12_ = _data_->total;
	}
	_data_->result = (guint64) _data_->_tmp12_;
	_g_object_unref0 (_data_->reader);
	_g_object_unref0 (_data_->message);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_microsoft_real_got_credentials_data_free (gpointer _data)
{
	DejaDupBackendMicrosoftGotCredentialsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendMicrosoftGotCredentialsData, _data_);
}

static void
deja_dup_backend_microsoft_real_got_credentials (DejaDupBackendOAuth* base,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_)
{
	DejaDupBackendMicrosoft * self;
	DejaDupBackendMicrosoftGotCredentialsData* _data_;
	DejaDupBackendMicrosoft* _tmp0_;
	self = (DejaDupBackendMicrosoft*) base;
	_data_ = g_slice_new0 (DejaDupBackendMicrosoftGotCredentialsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_microsoft_real_got_credentials_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_microsoft_real_got_credentials_co (_data_);
}

static void
deja_dup_backend_microsoft_got_credentials_finish (DejaDupBackendOAuth* base,
                                                   GAsyncResult* _res_,
                                                   GError** error)
{
	DejaDupBackendMicrosoftGotCredentialsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
deja_dup_backend_microsoft_got_credentials_ready (GObject* source_object,
                                                  GAsyncResult* _res_,
                                                  gpointer _user_data_)
{
	DejaDupBackendMicrosoftGotCredentialsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_microsoft_real_got_credentials_co (_data_);
}

static gboolean
deja_dup_backend_microsoft_real_got_credentials_co (DejaDupBackendMicrosoftGotCredentialsData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_microsoft_get_folder (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_strcmp0 (_data_->_tmp1_, "") == 0;
	_g_free0 (_data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "%s", _ ("You must provide a Microsoft OneDrive folder."));
		_data_->_inner_error0_ = _data_->_tmp3_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = soup_message_new ("GET", "https://graph.microsoft.com/v1.0/me/drive?select=id");
	_data_->message = _data_->_tmp4_;
	_data_->_state_ = 1;
	deja_dup_backend_oauth_send_message ((DejaDupBackendOAuth*) _data_->self, _data_->message, deja_dup_backend_microsoft_got_credentials_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp5_ = deja_dup_backend_oauth_send_message_finish ((DejaDupBackendOAuth*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	_data_->reader = _data_->_tmp5_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->message);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	json_reader_read_member (_data_->reader, "id");
	_data_->_tmp6_ = json_reader_get_string_value (_data_->reader);
	deja_dup_backend_microsoft_set_drive_id (_data_->self, _data_->_tmp6_);
	json_reader_end_member (_data_->reader);
	_g_object_unref0 (_data_->reader);
	_g_object_unref0 (_data_->message);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

const gchar*
deja_dup_backend_microsoft_get_drive_id (DejaDupBackendMicrosoft* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_drive_id;
	result = _tmp0_;
	return result;
}

static void
deja_dup_backend_microsoft_set_drive_id (DejaDupBackendMicrosoft* self,
                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = deja_dup_backend_microsoft_get_drive_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_drive_id);
		self->priv->_drive_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, deja_dup_backend_microsoft_properties[DEJA_DUP_BACKEND_MICROSOFT_DRIVE_ID_PROPERTY]);
	}
}

static GObject *
deja_dup_backend_microsoft_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupBackendMicrosoft * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	parent_class = G_OBJECT_CLASS (deja_dup_backend_microsoft_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_MICROSOFT, DejaDupBackendMicrosoft);
	_tmp0_ = g_strdup ("Microsoft");
	_g_free0 (((DejaDupBackendOAuth*) self)->brand_name);
	((DejaDupBackendOAuth*) self)->brand_name = _tmp0_;
	_tmp1_ = g_strdup (MICROSOFT_CLIENT_ID);
	_g_free0 (((DejaDupBackendOAuth*) self)->client_id);
	((DejaDupBackendOAuth*) self)->client_id = _tmp1_;
	_tmp2_ = g_strdup ("https://login.microsoftonline.com/common/oauth2/v2.0/authorize");
	_g_free0 (((DejaDupBackendOAuth*) self)->auth_url);
	((DejaDupBackendOAuth*) self)->auth_url = _tmp2_;
	_tmp3_ = g_strdup ("https://login.microsoftonline.com/common/oauth2/v2.0/token");
	_g_free0 (((DejaDupBackendOAuth*) self)->token_url);
	((DejaDupBackendOAuth*) self)->token_url = _tmp3_;
	_tmp4_ = g_strdup ("offline_access Files.ReadWrite");
	_g_free0 (((DejaDupBackendOAuth*) self)->scope);
	((DejaDupBackendOAuth*) self)->scope = _tmp4_;
	return obj;
}

static void
deja_dup_backend_microsoft_class_init (DejaDupBackendMicrosoftClass * klass,
                                       gpointer klass_data)
{
	deja_dup_backend_microsoft_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DejaDupBackendMicrosoft_private_offset);
	((DejaDupBackendOAuthClass *) klass)->get_redirect_uri = (gchar* (*) (DejaDupBackendOAuth*)) deja_dup_backend_microsoft_real_get_redirect_uri;
	((DejaDupBackendClass *) klass)->get_dependencies = (gchar** (*) (DejaDupBackend*, gint*)) deja_dup_backend_microsoft_real_get_dependencies;
	((DejaDupBackendClass *) klass)->get_icon = (GIcon* (*) (DejaDupBackend*)) deja_dup_backend_microsoft_real_get_icon;
	((DejaDupBackendClass *) klass)->is_ready = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_microsoft_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = (gboolean (*) (DejaDupBackend*, GAsyncResult*, gchar**, gchar**)) deja_dup_backend_microsoft_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_location_pretty = (gchar* (*) (DejaDupBackend*)) deja_dup_backend_microsoft_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->cleanup = (void (*) (DejaDupBackend*, GAsyncReadyCallback, gpointer)) deja_dup_backend_microsoft_real_cleanup;
	((DejaDupBackendClass *) klass)->cleanup_finish = (void (*) (DejaDupBackend*, GAsyncResult*)) deja_dup_backend_microsoft_cleanup_finish;
	((DejaDupBackendClass *) klass)->get_space = (void (*) (DejaDupBackend*, gboolean, GAsyncReadyCallback, gpointer)) deja_dup_backend_microsoft_real_get_space;
	((DejaDupBackendClass *) klass)->get_space_finish = (guint64 (*) (DejaDupBackend*, GAsyncResult*)) deja_dup_backend_microsoft_get_space_finish;
	((DejaDupBackendOAuthClass *) klass)->got_credentials = (void (*) (DejaDupBackendOAuth*, GAsyncReadyCallback, gpointer)) deja_dup_backend_microsoft_real_got_credentials;
	((DejaDupBackendOAuthClass *) klass)->got_credentials_finish = (void (*) (DejaDupBackendOAuth*, GAsyncResult*, GError**)) deja_dup_backend_microsoft_got_credentials_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_backend_microsoft_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_backend_microsoft_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_backend_microsoft_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_microsoft_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_BACKEND_MICROSOFT_DRIVE_ID_PROPERTY, deja_dup_backend_microsoft_properties[DEJA_DUP_BACKEND_MICROSOFT_DRIVE_ID_PROPERTY] = g_param_spec_string ("drive-id", "drive-id", "drive-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
deja_dup_backend_microsoft_instance_init (DejaDupBackendMicrosoft * self,
                                          gpointer klass)
{
	self->priv = deja_dup_backend_microsoft_get_instance_private (self);
}

static void
deja_dup_backend_microsoft_finalize (GObject * obj)
{
	DejaDupBackendMicrosoft * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND_MICROSOFT, DejaDupBackendMicrosoft);
	_g_free0 (self->priv->_drive_id);
	_g_object_unref0 (self->priv->rclone);
	G_OBJECT_CLASS (deja_dup_backend_microsoft_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
deja_dup_backend_microsoft_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendMicrosoftClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_microsoft_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendMicrosoft), 0, (GInstanceInitFunc) deja_dup_backend_microsoft_instance_init, NULL };
	GType deja_dup_backend_microsoft_type_id;
	deja_dup_backend_microsoft_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND_OAUTH, "DejaDupBackendMicrosoft", &g_define_type_info, 0);
	DejaDupBackendMicrosoft_private_offset = g_type_add_instance_private (deja_dup_backend_microsoft_type_id, sizeof (DejaDupBackendMicrosoftPrivate));
	return deja_dup_backend_microsoft_type_id;
}

GType
deja_dup_backend_microsoft_get_type (void)
{
	static gsize deja_dup_backend_microsoft_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_backend_microsoft_type_id__once)) {
		GType deja_dup_backend_microsoft_type_id;
		deja_dup_backend_microsoft_type_id = deja_dup_backend_microsoft_get_type_once ();
		g_once_init_leave (&deja_dup_backend_microsoft_type_id__once, deja_dup_backend_microsoft_type_id);
	}
	return deja_dup_backend_microsoft_type_id__once;
}

static void
_vala_deja_dup_backend_microsoft_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	DejaDupBackendMicrosoft * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_BACKEND_MICROSOFT, DejaDupBackendMicrosoft);
	switch (property_id) {
		case DEJA_DUP_BACKEND_MICROSOFT_DRIVE_ID_PROPERTY:
		g_value_set_string (value, deja_dup_backend_microsoft_get_drive_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_deja_dup_backend_microsoft_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	DejaDupBackendMicrosoft * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_BACKEND_MICROSOFT, DejaDupBackendMicrosoft);
	switch (property_id) {
		case DEJA_DUP_BACKEND_MICROSOFT_DRIVE_ID_PROPERTY:
		deja_dup_backend_microsoft_set_drive_id (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

