/* BackendLocal.c generated by valac 0.56.14, the Vala compiler
 * generated from BackendLocal.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <glib.h>
#include <gio/gunixmounts.h>
#include "deja.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

enum  {
	DEJA_DUP_BACKEND_LOCAL_0_PROPERTY,
	DEJA_DUP_BACKEND_LOCAL_NUM_PROPERTIES
};
static GParamSpec* deja_dup_backend_local_properties[DEJA_DUP_BACKEND_LOCAL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DejaDupBackendLocalMountData DejaDupBackendLocalMountData;
typedef struct _DejaDupBackendLocalUnmountData DejaDupBackendLocalUnmountData;

struct _DejaDupBackendLocalMountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendLocal* self;
	gboolean result;
	gchar* mount_path;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GSubprocess* process;
	const gchar* _tmp2_;
	GSubprocess* _tmp3_;
	GSubprocess* _tmp4_;
	GError* _inner_error0_;
};

struct _DejaDupBackendLocalUnmountData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	DejaDupBackendLocal* self;
	gchar* mount_path;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GSubprocess* process;
	const gchar* _tmp2_;
	GSubprocess* _tmp3_;
	GSubprocess* _tmp4_;
	GError* _inner_error0_;
};

static gpointer deja_dup_backend_local_parent_class = NULL;

GList* g_unix_mount_points_get (guint64* time_read);
VALA_EXTERN GFile* deja_dup_backend_file_get_file_from_settings (DejaDupBackendFile* self);
static GFile* deja_dup_backend_local_real_get_root_from_settings (DejaDupBackendFile* base);
static GFile* deja_dup_backend_local_real_get_file_from_settings (DejaDupBackendFile* base);
static GIcon* deja_dup_backend_local_real_get_icon (DejaDupBackend* base);
static gchar* deja_dup_backend_local_get_mount_point (DejaDupBackendLocal* self);
static void _g_unix_mount_point_free0_ (gpointer var);
static inline void _g_list_free__g_unix_mount_point_free0_ (GList* self);
static void deja_dup_backend_local_real_mount_data_free (gpointer _data);
static void deja_dup_backend_local_real_mount (DejaDupBackendFile* base,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean deja_dup_backend_local_real_mount_co (DejaDupBackendLocalMountData* _data_);
static void deja_dup_backend_local_mount_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void deja_dup_backend_local_real_unmount_data_free (gpointer _data);
static void deja_dup_backend_local_real_unmount (DejaDupBackendFile* base,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean deja_dup_backend_local_real_unmount_co (DejaDupBackendLocalUnmountData* _data_);
static void deja_dup_backend_local_unmount_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static GType deja_dup_backend_local_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DejaDupBackendLocal*
deja_dup_backend_local_construct (GType object_type,
                                  GSettings* settings)
{
	DejaDupBackendLocal * self = NULL;
	GSettings* _tmp0_ = NULL;
	if (settings != NULL) {
		GSettings* _tmp1_;
		_tmp1_ = _g_object_ref0 (settings);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = _tmp1_;
	} else {
		DejaDupFilteredSettings* _tmp2_;
		_tmp2_ = deja_dup_get_settings (DEJA_DUP_LOCAL_ROOT);
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (GSettings*) _tmp2_;
	}
	self = (DejaDupBackendLocal*) g_object_new (object_type, "kind", DEJA_DUP_BACKEND_KIND_LOCAL, "settings", _tmp0_, NULL);
	_g_object_unref0 (_tmp0_);
	return self;
}

DejaDupBackendLocal*
deja_dup_backend_local_new (GSettings* settings)
{
	return deja_dup_backend_local_construct (DEJA_DUP_TYPE_BACKEND_LOCAL, settings);
}

GFile*
deja_dup_backend_local_get_file_for_path (const gchar* path)
{
	gchar* resolved = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = deja_dup_resolve_user_dir (path);
	resolved = _tmp0_;
	_tmp1_ = resolved;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_free0 (resolved);
		return result;
	}
	_tmp2_ = resolved;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	result = _tmp3_;
	_g_free0 (resolved);
	return result;
}

gchar*
deja_dup_backend_local_get_path_from_file (GFile* file)
{
	GFile* root = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	root = _tmp1_;
	_tmp2_ = root;
	_tmp3_ = g_file_get_relative_path (_tmp2_, file);
	path = _tmp3_;
	_tmp4_ = path;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_file_get_path (file);
		result = _tmp5_;
		_g_free0 (path);
		_g_object_unref0 (root);
		return result;
	}
	result = path;
	_g_object_unref0 (root);
	return result;
}

static GFile*
deja_dup_backend_local_real_get_root_from_settings (DejaDupBackendFile* base)
{
	DejaDupBackendLocal * self;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	self = (DejaDupBackendLocal*) base;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	result = _tmp1_;
	return result;
}

static GFile*
deja_dup_backend_local_real_get_file_from_settings (DejaDupBackendFile* base)
{
	DejaDupBackendLocal * self;
	gchar* folder = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	self = (DejaDupBackendLocal*) base;
	_tmp0_ = deja_dup_backend_get_settings ((DejaDupBackend*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = deja_dup_get_folder_key (_tmp1_, DEJA_DUP_LOCAL_FOLDER_KEY, TRUE);
	folder = _tmp2_;
	_tmp3_ = deja_dup_backend_local_get_file_for_path (folder);
	result = _tmp3_;
	_g_free0 (folder);
	return result;
}

static GIcon*
deja_dup_backend_local_real_get_icon (DejaDupBackend* base)
{
	DejaDupBackendLocal * self;
	GError* _inner_error0_ = NULL;
	GIcon* result;
	self = (DejaDupBackendLocal*) base;
	{
		GIcon* _tmp0_ = NULL;
		GIcon* _tmp1_;
		GIcon* _tmp2_;
		_tmp1_ = g_icon_new_for_string ("folder", &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp2_;
		_g_object_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static void
_g_unix_mount_point_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_unix_mount_point_free (var), NULL));
}

static inline void
_g_list_free__g_unix_mount_point_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_unix_mount_point_free0_);
}

static gchar*
deja_dup_backend_local_get_mount_point (DejaDupBackendLocal* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GList* points = NULL;
	GList* _tmp1_;
	GList* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = deja_dup_backend_file_get_file_from_settings ((DejaDupBackendFile*) self);
	file = _tmp0_;
	_tmp1_ = g_unix_mount_points_get (NULL);
	points = _tmp1_;
	_tmp2_ = points;
	{
		GList* point_collection = NULL;
		GList* point_it = NULL;
		point_collection = _tmp2_;
		for (point_it = point_collection; point_it != NULL; point_it = point_it->next) {
			GUnixMountPoint* point = NULL;
			point = (GUnixMountPoint*) point_it->data;
			{
				gboolean _tmp3_ = FALSE;
				GUnixMountPoint* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = point;
				_tmp5_ = g_unix_mount_point_get_mount_path (_tmp4_);
				if (g_strcmp0 (_tmp5_, "/") != 0) {
					GFile* _tmp6_;
					GUnixMountPoint* _tmp7_;
					const gchar* _tmp8_;
					GFile* _tmp9_;
					GFile* _tmp10_;
					_tmp6_ = file;
					_tmp7_ = point;
					_tmp8_ = g_unix_mount_point_get_mount_path (_tmp7_);
					_tmp9_ = g_file_new_for_path (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp3_ = g_file_has_prefix (_tmp6_, _tmp10_);
					_g_object_unref0 (_tmp10_);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					GUnixMountPoint* _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp11_ = point;
					_tmp12_ = g_unix_mount_point_get_mount_path (_tmp11_);
					_tmp13_ = g_strdup (_tmp12_);
					result = _tmp13_;
					(points == NULL) ? NULL : (points = (_g_list_free__g_unix_mount_point_free0_ (points), NULL));
					_g_object_unref0 (file);
					return result;
				}
			}
		}
	}
	result = NULL;
	(points == NULL) ? NULL : (points = (_g_list_free__g_unix_mount_point_free0_ (points), NULL));
	_g_object_unref0 (file);
	return result;
}

static void
deja_dup_backend_local_real_mount_data_free (gpointer _data)
{
	DejaDupBackendLocalMountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendLocalMountData, _data_);
}

static void
deja_dup_backend_local_real_mount (DejaDupBackendFile* base,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	DejaDupBackendLocal * self;
	DejaDupBackendLocalMountData* _data_;
	DejaDupBackendLocal* _tmp0_;
	self = (DejaDupBackendLocal*) base;
	_data_ = g_slice_new0 (DejaDupBackendLocalMountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_local_real_mount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_local_real_mount_co (_data_);
}

static gboolean
deja_dup_backend_local_mount_finish (DejaDupBackendFile* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	gboolean result;
	DejaDupBackendLocalMountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
deja_dup_backend_local_mount_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	DejaDupBackendLocalMountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_local_real_mount_co (_data_);
}

static gboolean
deja_dup_backend_local_real_mount_co (DejaDupBackendLocalMountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_local_get_mount_point (_data_->self);
	_data_->mount_path = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->mount_path;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = FALSE;
		_g_free0 (_data_->mount_path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp2_ = _data_->mount_path;
		_data_->_tmp3_ = g_subprocess_new (G_SUBPROCESS_FLAGS_NONE, &_data_->_inner_error0_, "mount", _data_->_tmp2_, NULL);
		_data_->process = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->process;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp4_, NULL, deja_dup_backend_local_mount_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->process);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->process);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = FALSE;
		_g_free0 (_data_->mount_path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->mount_path);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = TRUE;
	_g_free0 (_data_->mount_path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_local_real_unmount_data_free (gpointer _data)
{
	DejaDupBackendLocalUnmountData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendLocalUnmountData, _data_);
}

static void
deja_dup_backend_local_real_unmount (DejaDupBackendFile* base,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	DejaDupBackendLocal * self;
	DejaDupBackendLocalUnmountData* _data_;
	DejaDupBackendLocal* _tmp0_;
	self = (DejaDupBackendLocal*) base;
	_data_ = g_slice_new0 (DejaDupBackendLocalUnmountData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, deja_dup_backend_local_real_unmount_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_local_real_unmount_co (_data_);
}

static void
deja_dup_backend_local_unmount_finish (DejaDupBackendFile* base,
                                       GAsyncResult* _res_)
{
	DejaDupBackendLocalUnmountData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
deja_dup_backend_local_unmount_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	DejaDupBackendLocalUnmountData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	deja_dup_backend_local_real_unmount_co (_data_);
}

static gboolean
deja_dup_backend_local_real_unmount_co (DejaDupBackendLocalUnmountData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = deja_dup_backend_local_get_mount_point (_data_->self);
	_data_->mount_path = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->mount_path;
	if (_data_->_tmp1_ == NULL) {
		_g_free0 (_data_->mount_path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp2_ = _data_->mount_path;
		_data_->_tmp3_ = g_subprocess_new (G_SUBPROCESS_FLAGS_NONE, &_data_->_inner_error0_, "umount", _data_->_tmp2_, NULL);
		_data_->process = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp4_ = _data_->process;
		_data_->_state_ = 1;
		g_subprocess_wait_async (_data_->_tmp4_, NULL, deja_dup_backend_local_unmount_ready, _data_);
		return FALSE;
		_state_1:
		g_subprocess_wait_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->process);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_data_->process);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->mount_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->mount_path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
deja_dup_backend_local_class_init (DejaDupBackendLocalClass * klass,
                                   gpointer klass_data)
{
	deja_dup_backend_local_parent_class = g_type_class_peek_parent (klass);
	((DejaDupBackendFileClass *) klass)->get_root_from_settings = (GFile* (*) (DejaDupBackendFile*)) deja_dup_backend_local_real_get_root_from_settings;
	((DejaDupBackendFileClass *) klass)->get_file_from_settings = (GFile* (*) (DejaDupBackendFile*)) deja_dup_backend_local_real_get_file_from_settings;
	((DejaDupBackendClass *) klass)->get_icon = (GIcon* (*) (DejaDupBackend*)) deja_dup_backend_local_real_get_icon;
	((DejaDupBackendFileClass *) klass)->mount = (void (*) (DejaDupBackendFile*, GAsyncReadyCallback, gpointer)) deja_dup_backend_local_real_mount;
	((DejaDupBackendFileClass *) klass)->mount_finish = (gboolean (*) (DejaDupBackendFile*, GAsyncResult*, GError**)) deja_dup_backend_local_mount_finish;
	((DejaDupBackendFileClass *) klass)->unmount = (void (*) (DejaDupBackendFile*, GAsyncReadyCallback, gpointer)) deja_dup_backend_local_real_unmount;
	((DejaDupBackendFileClass *) klass)->unmount_finish = (void (*) (DejaDupBackendFile*, GAsyncResult*)) deja_dup_backend_local_unmount_finish;
}

static void
deja_dup_backend_local_instance_init (DejaDupBackendLocal * self,
                                      gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
deja_dup_backend_local_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendLocalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_local_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackendLocal), 0, (GInstanceInitFunc) deja_dup_backend_local_instance_init, NULL };
	GType deja_dup_backend_local_type_id;
	deja_dup_backend_local_type_id = g_type_register_static (DEJA_DUP_TYPE_BACKEND_FILE, "DejaDupBackendLocal", &g_define_type_info, 0);
	return deja_dup_backend_local_type_id;
}

GType
deja_dup_backend_local_get_type (void)
{
	static gsize deja_dup_backend_local_type_id__once = 0;
	if (g_once_init_enter (&deja_dup_backend_local_type_id__once)) {
		GType deja_dup_backend_local_type_id;
		deja_dup_backend_local_type_id = deja_dup_backend_local_get_type_once ();
		g_once_init_leave (&deja_dup_backend_local_type_id__once, deja_dup_backend_local_type_id);
	}
	return deja_dup_backend_local_type_id__once;
}

