/* RecentBackupRow.c generated by valac 0.56.14, the Vala compiler
 * generated from RecentBackupRow.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "deja.h"

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_RECENT_BACKUP_ROW (recent_backup_row_get_type ())
#define RECENT_BACKUP_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RECENT_BACKUP_ROW, RecentBackupRow))
#define RECENT_BACKUP_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RECENT_BACKUP_ROW, RecentBackupRowClass))
#define IS_RECENT_BACKUP_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RECENT_BACKUP_ROW))
#define IS_RECENT_BACKUP_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RECENT_BACKUP_ROW))
#define RECENT_BACKUP_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RECENT_BACKUP_ROW, RecentBackupRowClass))

typedef struct _RecentBackupRow RecentBackupRow;
typedef struct _RecentBackupRowClass RecentBackupRowClass;
typedef struct _RecentBackupRowPrivate RecentBackupRowPrivate;
enum  {
	RECENT_BACKUP_ROW_0_PROPERTY,
	RECENT_BACKUP_ROW_NUM_PROPERTIES
};
static GParamSpec* recent_backup_row_properties[RECENT_BACKUP_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _RecentBackupRow {
	AdwActionRow parent_instance;
	RecentBackupRowPrivate * priv;
};

struct _RecentBackupRowClass {
	AdwActionRowClass parent_class;
};

struct _RecentBackupRowPrivate {
	GtkLabel* when;
	GSettings* settings;
};

static gint RecentBackupRow_private_offset;
static gpointer recent_backup_row_parent_class = NULL;

VALA_EXTERN GType recent_backup_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RecentBackupRow, g_object_unref)
static gboolean recent_backup_row_is_same_day (RecentBackupRow* self,
                                        GDateTime* one,
                                        GDateTime* two);
static gchar* recent_backup_row_pretty_last_name (RecentBackupRow* self,
                                           GDateTime* date);
static void recent_backup_row_update_label (RecentBackupRow* self);
VALA_EXTERN RecentBackupRow* recent_backup_row_new (void);
VALA_EXTERN RecentBackupRow* recent_backup_row_construct (GType object_type);
static GObject * recent_backup_row_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _recent_backup_row_update_label_g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self);
static void recent_backup_row_finalize (GObject * obj);
static GType recent_backup_row_get_type_once (void);

static inline gpointer
recent_backup_row_get_instance_private (RecentBackupRow* self)
{
	return G_STRUCT_MEMBER_P (self, RecentBackupRow_private_offset);
}

static gboolean
recent_backup_row_is_same_day (RecentBackupRow* self,
                               GDateTime* one,
                               GDateTime* two)
{
	gint ny = 0;
	gint nm = 0;
	gint nd = 0;
	gint dy = 0;
	gint dm = 0;
	gint dd = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (one != NULL, FALSE);
	g_return_val_if_fail (two != NULL, FALSE);
	g_date_time_get_ymd (one, &_tmp0_, &_tmp1_, &_tmp2_);
	ny = _tmp0_;
	nm = _tmp1_;
	nd = _tmp2_;
	g_date_time_get_ymd (two, &_tmp3_, &_tmp4_, &_tmp5_);
	dy = _tmp3_;
	dm = _tmp4_;
	dd = _tmp5_;
	if (ny == dy) {
		_tmp7_ = nm == dm;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = nd == dd;
	} else {
		_tmp6_ = FALSE;
	}
	result = _tmp6_;
	return result;
}

static gchar*
recent_backup_row_pretty_last_name (RecentBackupRow* self,
                                    GDateTime* date)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date != NULL, NULL);
	_tmp0_ = g_date_time_new_now_utc ();
	now = _tmp0_;
	_tmp1_ = now;
	if (g_date_time_compare (_tmp1_, date) < 0) {
		GDateTime* _tmp2_;
		_tmp2_ = now;
		date = _tmp2_;
	}
	_tmp3_ = now;
	if (recent_backup_row_is_same_day (self, date, _tmp3_)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (_ ("Today"));
		result = _tmp4_;
		_g_date_time_unref0 (now);
		return result;
	} else {
		GDateTime* _tmp5_;
		GDateTime* _tmp6_;
		GDateTime* _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = now;
		_tmp6_ = g_date_time_add_days (_tmp5_, -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = recent_backup_row_is_same_day (self, date, _tmp7_);
		_g_date_time_unref0 (_tmp7_);
		if (_tmp8_) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Yesterday"));
			result = _tmp9_;
			_g_date_time_unref0 (now);
			return result;
		} else {
			GDateTime* _tmp10_;
			GDateTime* _tmp11_;
			GDateTime* _tmp12_;
			GDateTime* _tmp13_;
			gint diff = 0;
			GDateTime* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = now;
			_tmp11_ = now;
			_tmp12_ = now;
			_tmp13_ = g_date_time_new_utc (g_date_time_get_year (_tmp10_), g_date_time_get_month (_tmp11_), g_date_time_get_day_of_month (_tmp12_), 0, 0, 0.0);
			_g_date_time_unref0 (now);
			now = _tmp13_;
			_tmp14_ = now;
			diff = (gint) ((g_date_time_difference (_tmp14_, date) / G_TIME_SPAN_DAY) + 1);
			_tmp15_ = g_strdup_printf (g_dngettext (GETTEXT_PACKAGE, "%d day ago", "%d days ago", (gulong) diff), diff);
			result = _tmp15_;
			_g_date_time_unref0 (now);
			return result;
		}
	}
}

static void
recent_backup_row_update_label (RecentBackupRow* self)
{
	gchar* last = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	GDateTime* last_time = NULL;
	const gchar* _tmp2_;
	GTimeZone* _tmp3_;
	GTimeZone* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, DEJA_DUP_LAST_BACKUP_KEY);
	last = _tmp1_;
	_tmp2_ = last;
	_tmp3_ = g_time_zone_new_utc ();
	_tmp4_ = _tmp3_;
	_tmp5_ = g_date_time_new_from_iso8601 (_tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_time_zone_unref0 (_tmp4_);
	last_time = _tmp6_;
	_tmp7_ = last_time;
	if (_tmp7_ == NULL) {
		GtkLabel* _tmp8_;
		_tmp8_ = self->priv->when;
		gtk_label_set_label (_tmp8_, C_ ("backups", "None"));
	} else {
		GtkLabel* _tmp9_;
		GDateTime* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp9_ = self->priv->when;
		_tmp10_ = last_time;
		_tmp11_ = recent_backup_row_pretty_last_name (self, _tmp10_);
		_tmp12_ = _tmp11_;
		gtk_label_set_label (_tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_g_date_time_unref0 (last_time);
	_g_free0 (last);
}

RecentBackupRow*
recent_backup_row_construct (GType object_type)
{
	RecentBackupRow * self = NULL;
	self = (RecentBackupRow*) g_object_new (object_type, NULL);
	return self;
}

RecentBackupRow*
recent_backup_row_new (void)
{
	return recent_backup_row_construct (TYPE_RECENT_BACKUP_ROW);
}

static void
_recent_backup_row_update_label_g_settings_changed (GSettings* _sender,
                                                    const gchar* key,
                                                    gpointer self)
{
	recent_backup_row_update_label ((RecentBackupRow*) self);
}

static GObject *
recent_backup_row_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	RecentBackupRow * self;
	DejaDupFilteredSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	parent_class = G_OBJECT_CLASS (recent_backup_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_BACKUP_ROW, RecentBackupRow);
	_tmp0_ = deja_dup_get_settings (NULL);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = (GSettings*) _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_strconcat ("changed::", DEJA_DUP_LAST_BACKUP_KEY, NULL);
	g_signal_connect_object (_tmp1_, _tmp2_, (GCallback) _recent_backup_row_update_label_g_settings_changed, self, 0);
	_g_free0 (_tmp2_);
	recent_backup_row_update_label (self);
	return obj;
}

static void
recent_backup_row_class_init (RecentBackupRowClass * klass,
                              gpointer klass_data)
{
	recent_backup_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RecentBackupRow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = recent_backup_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = recent_backup_row_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/DejaDup/RecentBackupRow.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "when", FALSE, RecentBackupRow_private_offset + G_STRUCT_OFFSET (RecentBackupRowPrivate, when));
}

static void
recent_backup_row_instance_init (RecentBackupRow * self,
                                 gpointer klass)
{
	self->priv = recent_backup_row_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
recent_backup_row_finalize (GObject * obj)
{
	RecentBackupRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RECENT_BACKUP_ROW, RecentBackupRow);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (recent_backup_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
recent_backup_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RecentBackupRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) recent_backup_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RecentBackupRow), 0, (GInstanceInitFunc) recent_backup_row_instance_init, NULL };
	GType recent_backup_row_type_id;
	recent_backup_row_type_id = g_type_register_static (adw_action_row_get_type (), "RecentBackupRow", &g_define_type_info, 0);
	RecentBackupRow_private_offset = g_type_add_instance_private (recent_backup_row_type_id, sizeof (RecentBackupRowPrivate));
	return recent_backup_row_type_id;
}

GType
recent_backup_row_get_type (void)
{
	static gsize recent_backup_row_type_id__once = 0;
	if (g_once_init_enter (&recent_backup_row_type_id__once)) {
		GType recent_backup_row_type_id;
		recent_backup_row_type_id = recent_backup_row_get_type_once ();
		g_once_init_leave (&recent_backup_row_type_id__once, recent_backup_row_type_id);
	}
	return recent_backup_row_type_id__once;
}

